
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	0110106f          	j	8000181c <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	6900106f          	j	8000172c <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00008297          	auipc	t0,0x8
800000b0:	22828293          	addi	t0,t0,552 # 800082d4 <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00009397          	auipc	t2,0x9
800000c8:	87838393          	addi	t2,t2,-1928 # 8000893c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	6c80106f          	j	800017b8 <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00007297          	auipc	t0,0x7
8000010c:	8d028293          	addi	t0,t0,-1840 # 800069d8 <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00009317          	auipc	t1,0x9
80000128:	81830313          	addi	t1,t1,-2024 # 8000893c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00008297          	auipc	t0,0x8
80000150:	7f028293          	addi	t0,t0,2032 # 8000893c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00008397          	auipc	t2,0x8
80000190:	0e838393          	addi	t2,t2,232 # 80008274 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00008297          	auipc	t0,0x8
80000240:	70028293          	addi	t0,t0,1792 # 8000893c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	00058793          	mv	a5,a1
800002c4:	00060813          	mv	a6,a2
800002c8:	00068713          	mv	a4,a3
800002cc:	00050313          	mv	t1,a0
800002d0:	28069663          	bnez	a3,8000055c <__udivdi3+0x29c>
800002d4:	00007897          	auipc	a7,0x7
800002d8:	89488893          	addi	a7,a7,-1900 # 80006b68 <__clz_tab>
800002dc:	0ec5f663          	bgeu	a1,a2,800003c8 <__udivdi3+0x108>
800002e0:	00010737          	lui	a4,0x10
800002e4:	0ce67863          	bgeu	a2,a4,800003b4 <__udivdi3+0xf4>
800002e8:	0ff00713          	li	a4,255
800002ec:	00c73733          	sltu	a4,a4,a2
800002f0:	00371713          	slli	a4,a4,0x3
800002f4:	00e656b3          	srl	a3,a2,a4
800002f8:	00d888b3          	add	a7,a7,a3
800002fc:	0008c683          	lbu	a3,0(a7)
80000300:	00e68733          	add	a4,a3,a4
80000304:	02000693          	li	a3,32
80000308:	40e686b3          	sub	a3,a3,a4
8000030c:	00068c63          	beqz	a3,80000324 <__udivdi3+0x64>
80000310:	00d797b3          	sll	a5,a5,a3
80000314:	00e55733          	srl	a4,a0,a4
80000318:	00d61833          	sll	a6,a2,a3
8000031c:	00f765b3          	or	a1,a4,a5
80000320:	00d51333          	sll	t1,a0,a3
80000324:	01085513          	srli	a0,a6,0x10
80000328:	02a5f733          	remu	a4,a1,a0
8000032c:	01081613          	slli	a2,a6,0x10
80000330:	01065613          	srli	a2,a2,0x10
80000334:	01035693          	srli	a3,t1,0x10
80000338:	02a5d5b3          	divu	a1,a1,a0
8000033c:	01071713          	slli	a4,a4,0x10
80000340:	00d766b3          	or	a3,a4,a3
80000344:	02b607b3          	mul	a5,a2,a1
80000348:	00058713          	mv	a4,a1
8000034c:	00f6fe63          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000350:	010686b3          	add	a3,a3,a6
80000354:	fff58713          	addi	a4,a1,-1
80000358:	0106e863          	bltu	a3,a6,80000368 <__udivdi3+0xa8>
8000035c:	00f6f663          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000360:	ffe58713          	addi	a4,a1,-2
80000364:	010686b3          	add	a3,a3,a6
80000368:	40f686b3          	sub	a3,a3,a5
8000036c:	02a6f7b3          	remu	a5,a3,a0
80000370:	01031313          	slli	t1,t1,0x10
80000374:	01035313          	srli	t1,t1,0x10
80000378:	02a6d6b3          	divu	a3,a3,a0
8000037c:	01079793          	slli	a5,a5,0x10
80000380:	0067e333          	or	t1,a5,t1
80000384:	02d605b3          	mul	a1,a2,a3
80000388:	00068513          	mv	a0,a3
8000038c:	00b37c63          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
80000390:	00680333          	add	t1,a6,t1
80000394:	fff68513          	addi	a0,a3,-1
80000398:	01036663          	bltu	t1,a6,800003a4 <__udivdi3+0xe4>
8000039c:	00b37463          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
800003a0:	ffe68513          	addi	a0,a3,-2
800003a4:	01071713          	slli	a4,a4,0x10
800003a8:	00a76733          	or	a4,a4,a0
800003ac:	00000593          	li	a1,0
800003b0:	0e40006f          	j	80000494 <__udivdi3+0x1d4>
800003b4:	010006b7          	lui	a3,0x1000
800003b8:	01000713          	li	a4,16
800003bc:	f2d66ce3          	bltu	a2,a3,800002f4 <__udivdi3+0x34>
800003c0:	01800713          	li	a4,24
800003c4:	f31ff06f          	j	800002f4 <__udivdi3+0x34>
800003c8:	00061663          	bnez	a2,800003d4 <__udivdi3+0x114>
800003cc:	00100693          	li	a3,1
800003d0:	02c6d833          	divu	a6,a3,a2
800003d4:	000106b7          	lui	a3,0x10
800003d8:	0cd87263          	bgeu	a6,a3,8000049c <__udivdi3+0x1dc>
800003dc:	0ff00693          	li	a3,255
800003e0:	0106f463          	bgeu	a3,a6,800003e8 <__udivdi3+0x128>
800003e4:	00800713          	li	a4,8
800003e8:	00e856b3          	srl	a3,a6,a4
800003ec:	00d888b3          	add	a7,a7,a3
800003f0:	0008c683          	lbu	a3,0(a7)
800003f4:	00e686b3          	add	a3,a3,a4
800003f8:	02000713          	li	a4,32
800003fc:	40d70733          	sub	a4,a4,a3
80000400:	0a071863          	bnez	a4,800004b0 <__udivdi3+0x1f0>
80000404:	410787b3          	sub	a5,a5,a6
80000408:	00100593          	li	a1,1
8000040c:	01085613          	srli	a2,a6,0x10
80000410:	01081893          	slli	a7,a6,0x10
80000414:	0108d893          	srli	a7,a7,0x10
80000418:	01035693          	srli	a3,t1,0x10
8000041c:	02c7f733          	remu	a4,a5,a2
80000420:	02c7d7b3          	divu	a5,a5,a2
80000424:	01071713          	slli	a4,a4,0x10
80000428:	00d766b3          	or	a3,a4,a3
8000042c:	02f88533          	mul	a0,a7,a5
80000430:	00078713          	mv	a4,a5
80000434:	00a6fe63          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000438:	010686b3          	add	a3,a3,a6
8000043c:	fff78713          	addi	a4,a5,-1
80000440:	0106e863          	bltu	a3,a6,80000450 <__udivdi3+0x190>
80000444:	00a6f663          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000448:	ffe78713          	addi	a4,a5,-2
8000044c:	010686b3          	add	a3,a3,a6
80000450:	40a686b3          	sub	a3,a3,a0
80000454:	02c6f7b3          	remu	a5,a3,a2
80000458:	01031313          	slli	t1,t1,0x10
8000045c:	01035313          	srli	t1,t1,0x10
80000460:	02c6d6b3          	divu	a3,a3,a2
80000464:	01079793          	slli	a5,a5,0x10
80000468:	0067e333          	or	t1,a5,t1
8000046c:	02d888b3          	mul	a7,a7,a3
80000470:	00068513          	mv	a0,a3
80000474:	01137c63          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000478:	00680333          	add	t1,a6,t1
8000047c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000480:	01036663          	bltu	t1,a6,8000048c <__udivdi3+0x1cc>
80000484:	01137463          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000488:	ffe68513          	addi	a0,a3,-2
8000048c:	01071713          	slli	a4,a4,0x10
80000490:	00a76733          	or	a4,a4,a0
80000494:	00070513          	mv	a0,a4
80000498:	00008067          	ret
8000049c:	010006b7          	lui	a3,0x1000
800004a0:	01000713          	li	a4,16
800004a4:	f4d862e3          	bltu	a6,a3,800003e8 <__udivdi3+0x128>
800004a8:	01800713          	li	a4,24
800004ac:	f3dff06f          	j	800003e8 <__udivdi3+0x128>
800004b0:	00e81833          	sll	a6,a6,a4
800004b4:	00d7d5b3          	srl	a1,a5,a3
800004b8:	00e51333          	sll	t1,a0,a4
800004bc:	00d556b3          	srl	a3,a0,a3
800004c0:	01085513          	srli	a0,a6,0x10
800004c4:	00e797b3          	sll	a5,a5,a4
800004c8:	02a5f733          	remu	a4,a1,a0
800004cc:	00f6e8b3          	or	a7,a3,a5
800004d0:	01081793          	slli	a5,a6,0x10
800004d4:	0107d793          	srli	a5,a5,0x10
800004d8:	0108d613          	srli	a2,a7,0x10
800004dc:	02a5d5b3          	divu	a1,a1,a0
800004e0:	01071713          	slli	a4,a4,0x10
800004e4:	00c76733          	or	a4,a4,a2
800004e8:	02b786b3          	mul	a3,a5,a1
800004ec:	00058613          	mv	a2,a1
800004f0:	00d77e63          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
800004f4:	01070733          	add	a4,a4,a6
800004f8:	fff58613          	addi	a2,a1,-1
800004fc:	01076863          	bltu	a4,a6,8000050c <__udivdi3+0x24c>
80000500:	00d77663          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
80000504:	ffe58613          	addi	a2,a1,-2
80000508:	01070733          	add	a4,a4,a6
8000050c:	40d706b3          	sub	a3,a4,a3
80000510:	02a6f733          	remu	a4,a3,a0
80000514:	01089893          	slli	a7,a7,0x10
80000518:	0108d893          	srli	a7,a7,0x10
8000051c:	02a6d6b3          	divu	a3,a3,a0
80000520:	01071713          	slli	a4,a4,0x10
80000524:	02d785b3          	mul	a1,a5,a3
80000528:	011767b3          	or	a5,a4,a7
8000052c:	00068713          	mv	a4,a3
80000530:	00b7fe63          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000534:	010787b3          	add	a5,a5,a6
80000538:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000053c:	0107e863          	bltu	a5,a6,8000054c <__udivdi3+0x28c>
80000540:	00b7f663          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000544:	ffe68713          	addi	a4,a3,-2
80000548:	010787b3          	add	a5,a5,a6
8000054c:	40b787b3          	sub	a5,a5,a1
80000550:	01061593          	slli	a1,a2,0x10
80000554:	00e5e5b3          	or	a1,a1,a4
80000558:	eb5ff06f          	j	8000040c <__udivdi3+0x14c>
8000055c:	18d5e663          	bltu	a1,a3,800006e8 <__udivdi3+0x428>
80000560:	00010737          	lui	a4,0x10
80000564:	04e6f463          	bgeu	a3,a4,800005ac <__udivdi3+0x2ec>
80000568:	0ff00813          	li	a6,255
8000056c:	00d83733          	sltu	a4,a6,a3
80000570:	00371713          	slli	a4,a4,0x3
80000574:	00e6d833          	srl	a6,a3,a4
80000578:	00006597          	auipc	a1,0x6
8000057c:	5f058593          	addi	a1,a1,1520 # 80006b68 <__clz_tab>
80000580:	010585b3          	add	a1,a1,a6
80000584:	0005c803          	lbu	a6,0(a1)
80000588:	02000593          	li	a1,32
8000058c:	00e80833          	add	a6,a6,a4
80000590:	410585b3          	sub	a1,a1,a6
80000594:	02059663          	bnez	a1,800005c0 <__udivdi3+0x300>
80000598:	00100713          	li	a4,1
8000059c:	eef6ece3          	bltu	a3,a5,80000494 <__udivdi3+0x1d4>
800005a0:	00c53533          	sltu	a0,a0,a2
800005a4:	00154713          	xori	a4,a0,1
800005a8:	eedff06f          	j	80000494 <__udivdi3+0x1d4>
800005ac:	010005b7          	lui	a1,0x1000
800005b0:	01000713          	li	a4,16
800005b4:	fcb6e0e3          	bltu	a3,a1,80000574 <__udivdi3+0x2b4>
800005b8:	01800713          	li	a4,24
800005bc:	fb9ff06f          	j	80000574 <__udivdi3+0x2b4>
800005c0:	01065733          	srl	a4,a2,a6
800005c4:	00b696b3          	sll	a3,a3,a1
800005c8:	00d766b3          	or	a3,a4,a3
800005cc:	0106de93          	srli	t4,a3,0x10
800005d0:	0107d733          	srl	a4,a5,a6
800005d4:	03d778b3          	remu	a7,a4,t4
800005d8:	00b797b3          	sll	a5,a5,a1
800005dc:	01055833          	srl	a6,a0,a6
800005e0:	00f86333          	or	t1,a6,a5
800005e4:	01069793          	slli	a5,a3,0x10
800005e8:	0107d793          	srli	a5,a5,0x10
800005ec:	01035813          	srli	a6,t1,0x10
800005f0:	00b61633          	sll	a2,a2,a1
800005f4:	03d75733          	divu	a4,a4,t4
800005f8:	01089893          	slli	a7,a7,0x10
800005fc:	0108e833          	or	a6,a7,a6
80000600:	02e78f33          	mul	t5,a5,a4
80000604:	00070e13          	mv	t3,a4
80000608:	01e87e63          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000060c:	00d80833          	add	a6,a6,a3
80000610:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000614:	00d86863          	bltu	a6,a3,80000624 <__udivdi3+0x364>
80000618:	01e87663          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000061c:	ffe70e13          	addi	t3,a4,-2
80000620:	00d80833          	add	a6,a6,a3
80000624:	41e80833          	sub	a6,a6,t5
80000628:	03d878b3          	remu	a7,a6,t4
8000062c:	03d85833          	divu	a6,a6,t4
80000630:	01089893          	slli	a7,a7,0x10
80000634:	03078eb3          	mul	t4,a5,a6
80000638:	01031793          	slli	a5,t1,0x10
8000063c:	0107d793          	srli	a5,a5,0x10
80000640:	00f8e7b3          	or	a5,a7,a5
80000644:	00080713          	mv	a4,a6
80000648:	01d7fe63          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000064c:	00d787b3          	add	a5,a5,a3
80000650:	fff80713          	addi	a4,a6,-1
80000654:	00d7e863          	bltu	a5,a3,80000664 <__udivdi3+0x3a4>
80000658:	01d7f663          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000065c:	ffe80713          	addi	a4,a6,-2
80000660:	00d787b3          	add	a5,a5,a3
80000664:	010e1e13          	slli	t3,t3,0x10
80000668:	41d787b3          	sub	a5,a5,t4
8000066c:	00010eb7          	lui	t4,0x10
80000670:	00ee6733          	or	a4,t3,a4
80000674:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000678:	01077333          	and	t1,a4,a6
8000067c:	01075893          	srli	a7,a4,0x10
80000680:	01067833          	and	a6,a2,a6
80000684:	01065613          	srli	a2,a2,0x10
80000688:	03030e33          	mul	t3,t1,a6
8000068c:	03088833          	mul	a6,a7,a6
80000690:	010e5693          	srli	a3,t3,0x10
80000694:	02c30333          	mul	t1,t1,a2
80000698:	01030333          	add	t1,t1,a6
8000069c:	006686b3          	add	a3,a3,t1
800006a0:	02c888b3          	mul	a7,a7,a2
800006a4:	0106f463          	bgeu	a3,a6,800006ac <__udivdi3+0x3ec>
800006a8:	01d888b3          	add	a7,a7,t4
800006ac:	0106d613          	srli	a2,a3,0x10
800006b0:	011608b3          	add	a7,a2,a7
800006b4:	0317e663          	bltu	a5,a7,800006e0 <__udivdi3+0x420>
800006b8:	cf179ae3          	bne	a5,a7,800003ac <__udivdi3+0xec>
800006bc:	000107b7          	lui	a5,0x10
800006c0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006c4:	00f6f6b3          	and	a3,a3,a5
800006c8:	01069693          	slli	a3,a3,0x10
800006cc:	00fe7e33          	and	t3,t3,a5
800006d0:	00b51533          	sll	a0,a0,a1
800006d4:	01c686b3          	add	a3,a3,t3
800006d8:	00000593          	li	a1,0
800006dc:	dad57ce3          	bgeu	a0,a3,80000494 <__udivdi3+0x1d4>
800006e0:	fff70713          	addi	a4,a4,-1
800006e4:	cc9ff06f          	j	800003ac <__udivdi3+0xec>
800006e8:	00000593          	li	a1,0
800006ec:	00000713          	li	a4,0
800006f0:	da5ff06f          	j	80000494 <__udivdi3+0x1d4>

800006f4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006f4:	00008067          	ret

800006f8 <thread_helper>:
 *
 * @return N/A
 */

static void thread_helper(void *arg1, void *arg2, void *arg3)
{
800006f8:	ff010113          	addi	sp,sp,-16
800006fc:	00812423          	sw	s0,8(sp)

	/*
	 * This thread starts off at a higher priority than thread_entry().
	 * Thus, it should execute immediately.
	 */
	thread_evidence++;
80000700:	80008437          	lui	s0,0x80008
80000704:	2d040413          	addi	s0,s0,720 # 800082d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d1>
80000708:	00042783          	lw	a5,0(s0)
{
8000070c:	00112623          	sw	ra,12(sp)
	thread_evidence++;
80000710:	00178793          	addi	a5,a5,1
80000714:	00f42023          	sw	a5,0(s0)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000718:	3d9040ef          	jal	ra,800052f0 <z_impl_k_current_get>

	/* Test that helper will yield to a thread of equal priority */
	self_thread_id = k_current_get();

	/* Lower priority to that of thread_entry() */
	k_thread_priority_set(self_thread_id, self_thread_id->base.prio + 1);
8000071c:	00e50583          	lb	a1,14(a0)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)

K_SYSCALL_DECLARE1(K_SYSCALL_K_THREAD_PRIORITY_GET, k_thread_priority_get, int, k_tid_t, thread)

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000720:	00158593          	addi	a1,a1,1 # 1000001 <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e501>
80000724:	6c8040ef          	jal	ra,80004dec <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80000728:	794040ef          	jal	ra,80004ebc <z_impl_k_yield>

	k_yield();      /* Yield to thread of equal priority */

	thread_evidence++;
8000072c:	00042783          	lw	a5,0(s0)
	/* thread_evidence should now be 2 */

}
80000730:	00c12083          	lw	ra,12(sp)
	thread_evidence++;
80000734:	00178793          	addi	a5,a5,1
80000738:	00f42023          	sw	a5,0(s0)
}
8000073c:	00812403          	lw	s0,8(sp)
80000740:	01010113          	addi	sp,sp,16
80000744:	00008067          	ret

80000748 <isr_handler_trigger>:
	irq_offload(isr_handler, NULL);
80000748:	80001537          	lui	a0,0x80001
8000074c:	00000593          	li	a1,0
80000750:	8ec50513          	addi	a0,a0,-1812 # 800008ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800008ed>
80000754:	08c0106f          	j	800017e0 <irq_offload>

80000758 <test_kernel_cpu_idle>:
	ztest_test_skip();
80000758:	7780206f          	j	80002ed0 <ztest_test_skip>

8000075c <delayed_thread>:
	k_sem_give(&reply_timeout);
}

/* a thread is started with a delay, then it reports that it ran via a fifo */
static void delayed_thread(void *num, void *arg2, void *arg3)
{
8000075c:	ff010113          	addi	sp,sp,-16
80000760:	00812423          	sw	s0,8(sp)
	struct timeout_order *timeout = &timeouts[(int)num];

	ARG_UNUSED(arg2);
	ARG_UNUSED(arg3);

	TC_PRINT(" thread (q order: %d, t/o: %d) is running\n",
80000764:	80008437          	lui	s0,0x80008
80000768:	00451513          	slli	a0,a0,0x4
8000076c:	1f040413          	addi	s0,s0,496 # 800081f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081f1>
80000770:	00a40433          	add	s0,s0,a0
80000774:	00c42583          	lw	a1,12(s0)
80000778:	00442603          	lw	a2,4(s0)
8000077c:	80007537          	lui	a0,0x80007
80000780:	d4050513          	addi	a0,a0,-704 # 80006d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d41>
{
80000784:	00112623          	sw	ra,12(sp)
	TC_PRINT(" thread (q order: %d, t/o: %d) is running\n",
80000788:	789010ef          	jal	ra,80002710 <printk>
		 timeout->q_order, timeout->timeout);

	k_fifo_put(&timeout_order_fifo, timeout);
8000078c:	00040593          	mv	a1,s0
}
80000790:	00812403          	lw	s0,8(sp)
80000794:	00c12083          	lw	ra,12(sp)
	k_fifo_put(&timeout_order_fifo, timeout);
80000798:	80008537          	lui	a0,0x80008
8000079c:	48c50513          	addi	a0,a0,1164 # 8000848c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000848d>
}
800007a0:	01010113          	addi	sp,sp,16
	k_fifo_put(&timeout_order_fifo, timeout);
800007a4:	7490206f          	j	800036ec <k_queue_append>

800007a8 <thread_sleep>:
{
800007a8:	fe010113          	addi	sp,sp,-32
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
800007ac:	00050593          	mv	a1,a0
{
800007b0:	00812c23          	sw	s0,24(sp)
800007b4:	00050413          	mv	s0,a0
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
800007b8:	80007537          	lui	a0,0x80007
800007bc:	65050513          	addi	a0,a0,1616 # 80007650 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007651>
{
800007c0:	00112e23          	sw	ra,28(sp)
800007c4:	00912a23          	sw	s1,20(sp)
800007c8:	01212823          	sw	s2,16(sp)
800007cc:	01312623          	sw	s3,12(sp)
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
800007d0:	741010ef          	jal	ra,80002710 <printk>

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_TIMER_USER_DATA_SET, k_timer_user_data_set, struct k_timer *, timer, void *, user_data)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800007d4:	5ad050ef          	jal	ra,80006580 <z_impl_k_uptime_get>
800007d8:	00050993          	mv	s3,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
800007dc:	00040513          	mv	a0,s0
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800007e0:	00058913          	mv	s2,a1
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
800007e4:	0d1040ef          	jal	ra,800050b4 <z_impl_k_sleep>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800007e8:	599050ef          	jal	ra,80006580 <z_impl_k_uptime_get>
	timestamp = k_uptime_get() - timestamp;
800007ec:	413509b3          	sub	s3,a0,s3
800007f0:	01353533          	sltu	a0,a0,s3
800007f4:	412585b3          	sub	a1,a1,s2
800007f8:	40a584b3          	sub	s1,a1,a0
	TC_PRINT(" thread back from sleep\n");
800007fc:	80007537          	lui	a0,0x80007
80000800:	67850513          	addi	a0,a0,1656 # 80007678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007679>
80000804:	70d010ef          	jal	ra,80002710 <printk>
	if (timestamp < timeout || timestamp > timeout + __ticks_to_ms(2)) {
80000808:	41f45793          	srai	a5,s0,0x1f
8000080c:	02f4c263          	blt	s1,a5,80000830 <thread_sleep+0x88>
80000810:	00979463          	bne	a5,s1,80000818 <thread_sleep+0x70>
80000814:	0089ee63          	bltu	s3,s0,80000830 <thread_sleep+0x88>
80000818:	01440713          	addi	a4,s0,20
8000081c:	00873433          	sltu	s0,a4,s0
80000820:	00f40433          	add	s0,s0,a5
80000824:	00946663          	bltu	s0,s1,80000830 <thread_sleep+0x88>
80000828:	04849863          	bne	s1,s0,80000878 <thread_sleep+0xd0>
8000082c:	05377663          	bgeu	a4,s3,80000878 <thread_sleep+0xd0>
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000830:	80007637          	lui	a2,0x80007
80000834:	800075b7          	lui	a1,0x80007
80000838:	80007537          	lui	a0,0x80007
8000083c:	69458593          	addi	a1,a1,1684 # 80007694 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007695>
80000840:	69c50513          	addi	a0,a0,1692 # 8000769c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000769d>
80000844:	2be00693          	li	a3,702
80000848:	cbc60613          	addi	a2,a2,-836 # 80006cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cbd>
8000084c:	6c5010ef          	jal	ra,80002710 <printk>
}
80000850:	01812403          	lw	s0,24(sp)
80000854:	01c12083          	lw	ra,28(sp)
80000858:	01412483          	lw	s1,20(sp)
8000085c:	01012903          	lw	s2,16(sp)
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000860:	00098593          	mv	a1,s3
}
80000864:	00c12983          	lw	s3,12(sp)
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000868:	80007537          	lui	a0,0x80007
8000086c:	6ac50513          	addi	a0,a0,1708 # 800076ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ad>
}
80000870:	02010113          	addi	sp,sp,32
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000874:	69d0106f          	j	80002710 <printk>
}
80000878:	01812403          	lw	s0,24(sp)
8000087c:	01c12083          	lw	ra,28(sp)
80000880:	01412483          	lw	s1,20(sp)
80000884:	01012903          	lw	s2,16(sp)
80000888:	00c12983          	lw	s3,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
8000088c:	80008537          	lui	a0,0x80008
80000890:	31c50513          	addi	a0,a0,796 # 8000831c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000831d>
80000894:	02010113          	addi	sp,sp,32
80000898:	32d0406f          	j	800053c4 <z_impl_k_sem_give>

8000089c <busy_wait_thread>:
{
8000089c:	ff010113          	addi	sp,sp,-16
800008a0:	00812423          	sw	s0,8(sp)
	usecs = (int)mseconds * 1000;
800008a4:	3e800413          	li	s0,1000
800008a8:	02850433          	mul	s0,a0,s0
	TC_PRINT("Thread busy waiting for %d usecs\n", usecs);
800008ac:	80007537          	lui	a0,0x80007
800008b0:	cfc50513          	addi	a0,a0,-772 # 80006cfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cfd>
{
800008b4:	00112623          	sw	ra,12(sp)
	TC_PRINT("Thread busy waiting for %d usecs\n", usecs);
800008b8:	00040593          	mv	a1,s0
800008bc:	655010ef          	jal	ra,80002710 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800008c0:	00040513          	mv	a0,s0
800008c4:	5f1040ef          	jal	ra,800056b4 <z_impl_k_busy_wait>
	TC_PRINT("Thread busy waiting completed\n");
800008c8:	80007537          	lui	a0,0x80007
800008cc:	d2050513          	addi	a0,a0,-736 # 80006d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d21>
800008d0:	641010ef          	jal	ra,80002710 <printk>
}
800008d4:	00812403          	lw	s0,8(sp)
800008d8:	00c12083          	lw	ra,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800008dc:	80008537          	lui	a0,0x80008
800008e0:	31c50513          	addi	a0,a0,796 # 8000831c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000831d>
800008e4:	01010113          	addi	sp,sp,16
800008e8:	2dd0406f          	j	800053c4 <z_impl_k_sem_give>

800008ec <isr_handler>:
{
800008ec:	ff010113          	addi	sp,sp,-16
800008f0:	00812423          	sw	s0,8(sp)
	switch (isr_info.command) {
800008f4:	80008437          	lui	s0,0x80008
800008f8:	31040413          	addi	s0,s0,784 # 80008310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008311>
{
800008fc:	00912223          	sw	s1,4(sp)
	switch (isr_info.command) {
80000900:	00042483          	lw	s1,0(s0)
{
80000904:	00112623          	sw	ra,12(sp)
80000908:	00048c63          	beqz	s1,80000920 <isr_handler+0x34>
8000090c:	00100793          	li	a5,1
80000910:	02f48663          	beq	s1,a5,8000093c <isr_handler+0x50>
		isr_info.error = UNKNOWN_COMMAND;
80000914:	fff00793          	li	a5,-1
80000918:	00f42223          	sw	a5,4(s0)
}
8000091c:	00c0006f          	j	80000928 <isr_handler+0x3c>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000920:	1d1040ef          	jal	ra,800052f0 <z_impl_k_current_get>
		isr_info.data = (void *)k_current_get();
80000924:	00a42423          	sw	a0,8(s0)
}
80000928:	00c12083          	lw	ra,12(sp)
8000092c:	00812403          	lw	s0,8(sp)
80000930:	00412483          	lw	s1,4(sp)
80000934:	01010113          	addi	sp,sp,16
80000938:	00008067          	ret
		if (k_is_in_isr()) {
8000093c:	555040ef          	jal	ra,80005690 <k_is_in_isr>
80000940:	00050663          	beqz	a0,8000094c <isr_handler+0x60>
			isr_info.value = K_ISR;
80000944:	00042423          	sw	zero,8(s0)
			break;
80000948:	fe1ff06f          	j	80000928 <isr_handler+0x3c>
		if (_current->base.prio < 0) {
8000094c:	800097b7          	lui	a5,0x80009
80000950:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
80000954:	00e78783          	lb	a5,14(a5)
80000958:	0007d663          	bgez	a5,80000964 <isr_handler+0x78>
			isr_info.value = K_COOP_THREAD;
8000095c:	00942423          	sw	s1,8(s0)
			break;
80000960:	fc9ff06f          	j	80000928 <isr_handler+0x3c>
		isr_info.value = K_PREEMPT_THREAD;
80000964:	00200793          	li	a5,2
80000968:	00f42423          	sw	a5,8(s0)
		break;
8000096c:	fbdff06f          	j	80000928 <isr_handler+0x3c>

80000970 <z_zassert.constprop.2>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000970:	fd010113          	addi	sp,sp,-48
80000974:	00112e23          	sw	ra,28(sp)
80000978:	00812c23          	sw	s0,24(sp)
8000097c:	03012423          	sw	a6,40(sp)
80000980:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000984:	04051663          	bnez	a0,800009d0 <z_zassert.constprop.2+0x60>
80000988:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000098c:	80007537          	lui	a0,0x80007
80000990:	00070693          	mv	a3,a4
80000994:	00058713          	mv	a4,a1
80000998:	800075b7          	lui	a1,0x80007
8000099c:	00078413          	mv	s0,a5
800009a0:	6cc58593          	addi	a1,a1,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
		va_start(vargs, msg);
800009a4:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009a8:	6f050513          	addi	a0,a0,1776 # 800076f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076f1>
		va_start(vargs, msg);
800009ac:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009b0:	561010ef          	jal	ra,80002710 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
800009b4:	00c12583          	lw	a1,12(sp)
800009b8:	00040513          	mv	a0,s0
800009bc:	525010ef          	jal	ra,800026e0 <vprintk>
		printk("\n");
800009c0:	80008537          	lui	a0,0x80008
800009c4:	86c50513          	addi	a0,a0,-1940 # 8000786c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000786d>
800009c8:	549010ef          	jal	ra,80002710 <printk>
		va_end(vargs);
		ztest_test_fail();
800009cc:	4d4020ef          	jal	ra,80002ea0 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
800009d0:	01c12083          	lw	ra,28(sp)
800009d4:	01812403          	lw	s0,24(sp)
800009d8:	03010113          	addi	sp,sp,48
800009dc:	00008067          	ret

800009e0 <test_kernel_ctx_thread>:
{
800009e0:	fe010113          	addi	sp,sp,-32
800009e4:	00112e23          	sw	ra,28(sp)
800009e8:	00812c23          	sw	s0,24(sp)
800009ec:	00912a23          	sw	s1,20(sp)
800009f0:	01212823          	sw	s2,16(sp)
800009f4:	01312623          	sw	s3,12(sp)
800009f8:	01412423          	sw	s4,8(sp)
800009fc:	01512223          	sw	s5,4(sp)
80000a00:	0f1040ef          	jal	ra,800052f0 <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000a04:	00000593          	li	a1,0
80000a08:	3e4040ef          	jal	ra,80004dec <z_impl_k_thread_priority_set>
	TC_PRINT("Testing k_current_get() from an ISR and thread\n");
80000a0c:	80007537          	lui	a0,0x80007
80000a10:	43450513          	addi	a0,a0,1076 # 80007434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007435>
80000a14:	4fd010ef          	jal	ra,80002710 <printk>
	isr_info.command = THREAD_SELF_CMD;
80000a18:	80008437          	lui	s0,0x80008
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000a1c:	0d5040ef          	jal	ra,800052f0 <z_impl_k_current_get>
80000a20:	31040413          	addi	s0,s0,784 # 80008310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008311>
80000a24:	00050a93          	mv	s5,a0
80000a28:	00042023          	sw	zero,0(s0)
	isr_info.error = 0;
80000a2c:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000a30:	d19ff0ef          	jal	ra,80000748 <isr_handler_trigger>
	zassert_false(isr_info.error, "ISR detected an error");
80000a34:	00442503          	lw	a0,4(s0)
80000a38:	80007937          	lui	s2,0x80007
80000a3c:	800074b7          	lui	s1,0x80007
80000a40:	80007a37          	lui	s4,0x80007
80000a44:	800079b7          	lui	s3,0x80007
80000a48:	464a0793          	addi	a5,s4,1124 # 80007464 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007465>
80000a4c:	c8090713          	addi	a4,s2,-896 # 80006c80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c81>
80000a50:	6cc48613          	addi	a2,s1,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
80000a54:	47c98593          	addi	a1,s3,1148 # 8000747c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000747d>
80000a58:	1c400693          	li	a3,452
80000a5c:	00153513          	seqz	a0,a0
80000a60:	f11ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	zassert_equal(isr_info.data, (void *)self_thread_id,
80000a64:	00842503          	lw	a0,8(s0)
80000a68:	800077b7          	lui	a5,0x80007
80000a6c:	800075b7          	lui	a1,0x80007
80000a70:	41550533          	sub	a0,a0,s5
80000a74:	c8090713          	addi	a4,s2,-896
80000a78:	6cc48613          	addi	a2,s1,1740
80000a7c:	1c700693          	li	a3,455
80000a80:	4b058593          	addi	a1,a1,1200 # 800074b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074b1>
80000a84:	49878793          	addi	a5,a5,1176 # 80007498 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007499>
80000a88:	00153513          	seqz	a0,a0
80000a8c:	ee5ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	TC_PRINT("Testing k_is_in_isr() from an ISR\n");
80000a90:	80007537          	lui	a0,0x80007
80000a94:	4e450513          	addi	a0,a0,1252 # 800074e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074e5>
80000a98:	479010ef          	jal	ra,80002710 <printk>
	isr_info.command = EXEC_CTX_TYPE_CMD;
80000a9c:	00100793          	li	a5,1
80000aa0:	00f42023          	sw	a5,0(s0)
	isr_info.error = 0;
80000aa4:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000aa8:	ca1ff0ef          	jal	ra,80000748 <isr_handler_trigger>
	zassert_false(isr_info.error, "ISR detected an error");
80000aac:	00442503          	lw	a0,4(s0)
80000ab0:	464a0793          	addi	a5,s4,1124
80000ab4:	c8090713          	addi	a4,s2,-896
80000ab8:	6cc48613          	addi	a2,s1,1740
80000abc:	47c98593          	addi	a1,s3,1148
80000ac0:	1ce00693          	li	a3,462
80000ac4:	00153513          	seqz	a0,a0
80000ac8:	ea9ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	zassert_equal(isr_info.value, K_ISR,
80000acc:	00842503          	lw	a0,8(s0)
80000ad0:	800077b7          	lui	a5,0x80007
80000ad4:	800075b7          	lui	a1,0x80007
80000ad8:	c8090713          	addi	a4,s2,-896
80000adc:	6cc48613          	addi	a2,s1,1740
80000ae0:	50878793          	addi	a5,a5,1288 # 80007508 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007509>
80000ae4:	1d100693          	li	a3,465
80000ae8:	52858593          	addi	a1,a1,1320 # 80007528 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007529>
80000aec:	00153513          	seqz	a0,a0
80000af0:	e81ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	TC_PRINT("Testing k_is_in_isr() from a preemptible thread\n");
80000af4:	80007537          	lui	a0,0x80007
80000af8:	54c50513          	addi	a0,a0,1356 # 8000754c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000754d>
80000afc:	415010ef          	jal	ra,80002710 <printk>
	zassert_false(k_is_in_isr(), "Should not be in ISR context");
80000b00:	391040ef          	jal	ra,80005690 <k_is_in_isr>
80000b04:	00154513          	xori	a0,a0,1
80000b08:	800077b7          	lui	a5,0x80007
80000b0c:	800075b7          	lui	a1,0x80007
80000b10:	c8090713          	addi	a4,s2,-896
80000b14:	6cc48613          	addi	a2,s1,1740
80000b18:	58078793          	addi	a5,a5,1408 # 80007580 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007581>
80000b1c:	1d400693          	li	a3,468
80000b20:	5a058593          	addi	a1,a1,1440 # 800075a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075a1>
80000b24:	0ff57513          	andi	a0,a0,255
80000b28:	e49ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	zassert_false(_current->base.prio < 0,
80000b2c:	800097b7          	lui	a5,0x80009
80000b30:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
}
80000b34:	01812403          	lw	s0,24(sp)
80000b38:	01c12083          	lw	ra,28(sp)
	zassert_false(_current->base.prio < 0,
80000b3c:	00e78803          	lb	a6,14(a5)
}
80000b40:	00c12983          	lw	s3,12(sp)
80000b44:	00812a03          	lw	s4,8(sp)
80000b48:	00412a83          	lw	s5,4(sp)
	zassert_false(_current->base.prio < 0,
80000b4c:	c8090713          	addi	a4,s2,-896
80000b50:	6cc48613          	addi	a2,s1,1740
}
80000b54:	01012903          	lw	s2,16(sp)
80000b58:	01412483          	lw	s1,20(sp)
	zassert_false(_current->base.prio < 0,
80000b5c:	fff84513          	not	a0,a6
80000b60:	800077b7          	lui	a5,0x80007
80000b64:	800075b7          	lui	a1,0x80007
80000b68:	5b878793          	addi	a5,a5,1464 # 800075b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075b9>
80000b6c:	1d800693          	li	a3,472
80000b70:	5ec58593          	addi	a1,a1,1516 # 800075ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075ed>
80000b74:	01f55513          	srli	a0,a0,0x1f
}
80000b78:	02010113          	addi	sp,sp,32
	zassert_false(_current->base.prio < 0,
80000b7c:	df5ff06f          	j	80000970 <z_zassert.constprop.2>

80000b80 <test_kernel_interrupts>:
80000b80:	00008067          	ret

80000b84 <test_kernel_timer_interrupts>:
{
80000b84:	fe010113          	addi	sp,sp,-32
80000b88:	01212823          	sw	s2,16(sp)
80000b8c:	00112e23          	sw	ra,28(sp)
80000b90:	00812c23          	sw	s0,24(sp)
80000b94:	00912a23          	sw	s1,20(sp)
80000b98:	01312623          	sw	s3,12(sp)
80000b9c:	01412423          	sw	s4,8(sp)
	tick = z_tick_get_32();
80000ba0:	1c9050ef          	jal	ra,80006568 <z_tick_get_32>
80000ba4:	00050913          	mv	s2,a0
	while (z_tick_get_32() == tick) {
80000ba8:	1c1050ef          	jal	ra,80006568 <z_tick_get_32>
80000bac:	fea90ee3          	beq	s2,a0,80000ba8 <test_kernel_timer_interrupts+0x24>
	tick++;
80000bb0:	00190913          	addi	s2,s2,1
	unsigned long long count = 0;
80000bb4:	00000493          	li	s1,0
80000bb8:	00000413          	li	s0,0
	while (z_tick_get_32() == tick) {
80000bbc:	1ad050ef          	jal	ra,80006568 <z_tick_get_32>
80000bc0:	0b250063          	beq	a0,s2,80000c60 <test_kernel_timer_interrupts+0xdc>
	count <<= 4;
80000bc4:	01c4d793          	srli	a5,s1,0x1c
	irq_disable(irq);
80000bc8:	00700513          	li	a0,7
	count <<= 4;
80000bcc:	00441413          	slli	s0,s0,0x4
80000bd0:	0087e433          	or	s0,a5,s0
	irq_disable(irq);
80000bd4:	3cd010ef          	jal	ra,800027a0 <z_arch_irq_disable>
	tick = z_tick_get_32();
80000bd8:	191050ef          	jal	ra,80006568 <z_tick_get_32>
	count <<= 4;
80000bdc:	00449493          	slli	s1,s1,0x4
	tick = z_tick_get_32();
80000be0:	00050a13          	mv	s4,a0
	for (i = 0; i < count; i++) {
80000be4:	00000913          	li	s2,0
80000be8:	00000993          	li	s3,0
80000bec:	09249463          	bne	s1,s2,80000c74 <test_kernel_timer_interrupts+0xf0>
80000bf0:	09341263          	bne	s0,s3,80000c74 <test_kernel_timer_interrupts+0xf0>
	tick2 = z_tick_get_32();
80000bf4:	175050ef          	jal	ra,80006568 <z_tick_get_32>
	irq_enable(irq);
80000bf8:	00700513          	li	a0,7
80000bfc:	395010ef          	jal	ra,80002790 <z_arch_irq_enable>
	for (i = 0; i < count; i++) {
80000c00:	00000413          	li	s0,0
80000c04:	00000493          	li	s1,0
80000c08:	08891263          	bne	s2,s0,80000c8c <test_kernel_timer_interrupts+0x108>
80000c0c:	08999063          	bne	s3,s1,80000c8c <test_kernel_timer_interrupts+0x108>
	tick2 = z_tick_get_32();
80000c10:	159050ef          	jal	ra,80006568 <z_tick_get_32>
}
80000c14:	01812403          	lw	s0,24(sp)
	zassert_not_equal(tick, tick2,
80000c18:	40aa0533          	sub	a0,s4,a0
}
80000c1c:	01c12083          	lw	ra,28(sp)
80000c20:	01412483          	lw	s1,20(sp)
80000c24:	01012903          	lw	s2,16(sp)
80000c28:	00c12983          	lw	s3,12(sp)
80000c2c:	00812a03          	lw	s4,8(sp)
	zassert_not_equal(tick, tick2,
80000c30:	800077b7          	lui	a5,0x80007
80000c34:	80007737          	lui	a4,0x80007
80000c38:	80007637          	lui	a2,0x80007
80000c3c:	800075b7          	lui	a1,0x80007
80000c40:	61078793          	addi	a5,a5,1552 # 80007610 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007611>
80000c44:	c6870713          	addi	a4,a4,-920 # 80006c68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c69>
80000c48:	17c00693          	li	a3,380
80000c4c:	6cc60613          	addi	a2,a2,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
80000c50:	63058593          	addi	a1,a1,1584 # 80007630 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007631>
80000c54:	00a03533          	snez	a0,a0
}
80000c58:	02010113          	addi	sp,sp,32
	zassert_not_equal(tick, tick2,
80000c5c:	d15ff06f          	j	80000970 <z_zassert.constprop.2>
		count++;
80000c60:	00148793          	addi	a5,s1,1
80000c64:	0097b733          	sltu	a4,a5,s1
80000c68:	00870433          	add	s0,a4,s0
80000c6c:	00078493          	mv	s1,a5
80000c70:	f4dff06f          	j	80000bbc <test_kernel_timer_interrupts+0x38>
		z_tick_get_32();
80000c74:	0f5050ef          	jal	ra,80006568 <z_tick_get_32>
	for (i = 0; i < count; i++) {
80000c78:	00190793          	addi	a5,s2,1
80000c7c:	0127b733          	sltu	a4,a5,s2
80000c80:	013709b3          	add	s3,a4,s3
80000c84:	00078913          	mv	s2,a5
80000c88:	f65ff06f          	j	80000bec <test_kernel_timer_interrupts+0x68>
		z_tick_get_32();
80000c8c:	0dd050ef          	jal	ra,80006568 <z_tick_get_32>
	for (i = 0; i < count; i++) {
80000c90:	00140793          	addi	a5,s0,1
80000c94:	0087b733          	sltu	a4,a5,s0
80000c98:	009704b3          	add	s1,a4,s1
80000c9c:	00078413          	mv	s0,a5
80000ca0:	f69ff06f          	j	80000c08 <test_kernel_timer_interrupts+0x84>

80000ca4 <test_kernel_cpu_idle_atomic>:
80000ca4:	22c0206f          	j	80002ed0 <ztest_test_skip>

80000ca8 <test_kernel_thread>:
 * @ingroup kernel_context_tests
 *
 * @see k_thread_create
 */
void test_kernel_thread(void)
{
80000ca8:	fe010113          	addi	sp,sp,-32
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000cac:	800016b7          	lui	a3,0x80001
80000cb0:	800095b7          	lui	a1,0x80009
80000cb4:	80008537          	lui	a0,0x80008
80000cb8:	00012223          	sw	zero,4(sp)
80000cbc:	00012023          	sw	zero,0(sp)
80000cc0:	ff400893          	li	a7,-12
80000cc4:	00000813          	li	a6,0
80000cc8:	00000793          	li	a5,0
80000ccc:	00000713          	li	a4,0
80000cd0:	cf468693          	addi	a3,a3,-780 # 80000cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000cf5>
80000cd4:	20000613          	li	a2,512
80000cd8:	d7058593          	addi	a1,a1,-656 # 80008d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d71>
80000cdc:	41c50513          	addi	a0,a0,1052 # 8000841c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000841d>
80000ce0:	00112e23          	sw	ra,28(sp)
80000ce4:	4bd040ef          	jal	ra,800059a0 <z_impl_k_thread_create>

	k_thread_create(&thread_data3, thread_stack3, THREAD_STACKSIZE,
			kernel_thread_entry, NULL, NULL,
			NULL, K_PRIO_COOP(THREAD_PRIORITY), 0, 0);

}
80000ce8:	01c12083          	lw	ra,28(sp)
80000cec:	02010113          	addi	sp,sp,32
80000cf0:	00008067          	ret

80000cf4 <kernel_thread_entry>:
	thread_evidence++;      /* Prove that the thread has run */
80000cf4:	800087b7          	lui	a5,0x80008
80000cf8:	2d078793          	addi	a5,a5,720 # 800082d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d1>
80000cfc:	0007a703          	lw	a4,0(a5)
{
80000d00:	fe010113          	addi	sp,sp,-32
80000d04:	00812c23          	sw	s0,24(sp)
80000d08:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000d0c:	80008537          	lui	a0,0x80008
80000d10:	00112e23          	sw	ra,28(sp)
	thread_evidence++;      /* Prove that the thread has run */
80000d14:	00170713          	addi	a4,a4,1
{
80000d18:	00912a23          	sw	s1,20(sp)
80000d1c:	01212823          	sw	s2,16(sp)
80000d20:	01312623          	sw	s3,12(sp)
80000d24:	01412423          	sw	s4,8(sp)
80000d28:	fff00593          	li	a1,-1
80000d2c:	32c50513          	addi	a0,a0,812 # 8000832c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000832d>
	thread_evidence++;      /* Prove that the thread has run */
80000d30:	00e7a023          	sw	a4,0(a5)
80000d34:	774040ef          	jal	ra,800054a8 <z_impl_k_sem_take>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000d38:	5b8040ef          	jal	ra,800052f0 <z_impl_k_current_get>
80000d3c:	00050993          	mv	s3,a0
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80000d40:	80007a37          	lui	s4,0x80007
80000d44:	40a40533          	sub	a0,s0,a0
80000d48:	800077b7          	lui	a5,0x80007
	isr_info.command = THREAD_SELF_CMD;
80000d4c:	80008437          	lui	s0,0x80008
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80000d50:	800074b7          	lui	s1,0x80007
80000d54:	800075b7          	lui	a1,0x80007
	isr_info.command = THREAD_SELF_CMD;
80000d58:	31040913          	addi	s2,s0,784 # 80008310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008311>
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80000d5c:	ea478793          	addi	a5,a5,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80000d60:	00a03533          	snez	a0,a0
80000d64:	c98a0713          	addi	a4,s4,-872 # 80006c98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c99>
80000d68:	1ea00693          	li	a3,490
80000d6c:	6cc48613          	addi	a2,s1,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
80000d70:	ec458593          	addi	a1,a1,-316 # 80006ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec5>
80000d74:	bfdff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	isr_info.command = THREAD_SELF_CMD;
80000d78:	00092023          	sw	zero,0(s2)
	isr_info.error = 0;
80000d7c:	00092223          	sw	zero,4(s2)
	isr_handler_trigger();
80000d80:	9c9ff0ef          	jal	ra,80000748 <isr_handler_trigger>
	zassert_false((isr_info.error || (isr_info.data != (void *)self_thread_id)),
80000d84:	00492783          	lw	a5,4(s2)
80000d88:	31040413          	addi	s0,s0,784
80000d8c:	00000513          	li	a0,0
80000d90:	00079863          	bnez	a5,80000da0 <kernel_thread_entry+0xac>
80000d94:	00842503          	lw	a0,8(s0)
80000d98:	41350533          	sub	a0,a0,s3
80000d9c:	00153513          	seqz	a0,a0
80000da0:	800077b7          	lui	a5,0x80007
80000da4:	800075b7          	lui	a1,0x80007
80000da8:	c98a0713          	addi	a4,s4,-872
80000dac:	6cc48613          	addi	a2,s1,1740
80000db0:	1f400693          	li	a3,500
80000db4:	f2058593          	addi	a1,a1,-224 # 80006f20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f21>
80000db8:	ef078793          	addi	a5,a5,-272 # 80006ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ef1>
80000dbc:	bb5ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	isr_info.command = EXEC_CTX_TYPE_CMD;
80000dc0:	00100793          	li	a5,1
80000dc4:	00f42023          	sw	a5,0(s0)
	isr_info.error = 0;
80000dc8:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000dcc:	97dff0ef          	jal	ra,80000748 <isr_handler_trigger>
	zassert_false((isr_info.error || (isr_info.value != K_ISR)),
80000dd0:	00842783          	lw	a5,8(s0)
80000dd4:	00442503          	lw	a0,4(s0)
80000dd8:	800075b7          	lui	a1,0x80007
80000ddc:	c98a0713          	addi	a4,s4,-872
80000de0:	00f56533          	or	a0,a0,a5
80000de4:	800077b7          	lui	a5,0x80007
80000de8:	6cc48613          	addi	a2,s1,1740
80000dec:	f6878793          	addi	a5,a5,-152 # 80006f68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f69>
80000df0:	1fa00693          	li	a3,506
80000df4:	f9858593          	addi	a1,a1,-104 # 80006f98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f99>
80000df8:	00153513          	seqz	a0,a0
80000dfc:	b75ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	zassert_false(k_is_in_isr(), "k_is_in_isr() when called from a thread is true");
80000e00:	091040ef          	jal	ra,80005690 <k_is_in_isr>
80000e04:	00154513          	xori	a0,a0,1
80000e08:	800077b7          	lui	a5,0x80007
80000e0c:	800075b7          	lui	a1,0x80007
80000e10:	c98a0713          	addi	a4,s4,-872
80000e14:	6cc48613          	addi	a2,s1,1740
80000e18:	fd078793          	addi	a5,a5,-48 # 80006fd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fd1>
80000e1c:	1fc00693          	li	a3,508
80000e20:	5a058593          	addi	a1,a1,1440 # 800075a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075a1>
80000e24:	0ff57513          	andi	a0,a0,255
80000e28:	b49ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	zassert_false((_current->base.prio >= 0),
80000e2c:	800097b7          	lui	a5,0x80009
80000e30:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
}
80000e34:	01812403          	lw	s0,24(sp)
80000e38:	01c12083          	lw	ra,28(sp)
	zassert_false((_current->base.prio >= 0),
80000e3c:	00e78503          	lb	a0,14(a5)
}
80000e40:	01012903          	lw	s2,16(sp)
80000e44:	00c12983          	lw	s3,12(sp)
	zassert_false((_current->base.prio >= 0),
80000e48:	c98a0713          	addi	a4,s4,-872
80000e4c:	6cc48613          	addi	a2,s1,1740
}
80000e50:	00812a03          	lw	s4,8(sp)
80000e54:	01412483          	lw	s1,20(sp)
	zassert_false((_current->base.prio >= 0),
80000e58:	800077b7          	lui	a5,0x80007
80000e5c:	800075b7          	lui	a1,0x80007
80000e60:	00078793          	mv	a5,a5
80000e64:	1ff00693          	li	a3,511
80000e68:	02458593          	addi	a1,a1,36 # 80007024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007025>
80000e6c:	01f55513          	srli	a0,a0,0x1f
}
80000e70:	02010113          	addi	sp,sp,32
	zassert_false((_current->base.prio >= 0),
80000e74:	afdff06f          	j	80000970 <z_zassert.constprop.2>

80000e78 <test_busy_wait>:
{
80000e78:	fe010113          	addi	sp,sp,-32
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000e7c:	800016b7          	lui	a3,0x80001
80000e80:	800095b7          	lui	a1,0x80009
80000e84:	80008537          	lui	a0,0x80008
80000e88:	00000793          	li	a5,0
80000e8c:	01400713          	li	a4,20
80000e90:	89c68693          	addi	a3,a3,-1892 # 8000089c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000089d>
80000e94:	18000613          	li	a2,384
80000e98:	00012223          	sw	zero,4(sp)
80000e9c:	00012023          	sw	zero,0(sp)
80000ea0:	ff400893          	li	a7,-12
80000ea4:	00000813          	li	a6,0
80000ea8:	f7058593          	addi	a1,a1,-144 # 80008f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008f71>
80000eac:	4a050513          	addi	a0,a0,1184 # 800084a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084a1>
80000eb0:	00112e23          	sw	ra,28(sp)
80000eb4:	2ed040ef          	jal	ra,800059a0 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000eb8:	80008537          	lui	a0,0x80008
80000ebc:	02800593          	li	a1,40
80000ec0:	31c50513          	addi	a0,a0,796 # 8000831c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000831d>
80000ec4:	5e4040ef          	jal	ra,800054a8 <z_impl_k_sem_take>
}
80000ec8:	01c12083          	lw	ra,28(sp)
	zassert_false(rv, " *** thread timed out waiting for " "k_busy_wait()");
80000ecc:	800077b7          	lui	a5,0x80007
80000ed0:	80007737          	lui	a4,0x80007
80000ed4:	80007637          	lui	a2,0x80007
80000ed8:	800075b7          	lui	a1,0x80007
80000edc:	11478793          	addi	a5,a5,276 # 80007114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007115>
80000ee0:	ccc70713          	addi	a4,a4,-820 # 80006ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ccd>
80000ee4:	2e800693          	li	a3,744
80000ee8:	6cc60613          	addi	a2,a2,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
80000eec:	14458593          	addi	a1,a1,324 # 80007144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007145>
80000ef0:	00153513          	seqz	a0,a0
}
80000ef4:	02010113          	addi	sp,sp,32
	zassert_false(rv, " *** thread timed out waiting for " "k_busy_wait()");
80000ef8:	a79ff06f          	j	80000970 <z_zassert.constprop.2>

80000efc <test_k_yield>:
{
80000efc:	fe010113          	addi	sp,sp,-32
80000f00:	00912a23          	sw	s1,20(sp)
	thread_evidence = 0;
80000f04:	800084b7          	lui	s1,0x80008
80000f08:	2d048493          	addi	s1,s1,720 # 800082d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d1>
{
80000f0c:	00112e23          	sw	ra,28(sp)
80000f10:	00812c23          	sw	s0,24(sp)
	thread_evidence = 0;
80000f14:	0004a023          	sw	zero,0(s1)
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000f18:	3d8040ef          	jal	ra,800052f0 <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000f1c:	00000593          	li	a1,0
80000f20:	6cd030ef          	jal	ra,80004dec <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000f24:	80008437          	lui	s0,0x80008
80000f28:	32c40513          	addi	a0,s0,812 # 8000832c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000832d>
80000f2c:	fff00613          	li	a2,-1
80000f30:	00000593          	li	a1,0
80000f34:	3c8040ef          	jal	ra,800052fc <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000f38:	800016b7          	lui	a3,0x80001
80000f3c:	800095b7          	lui	a1,0x80009
80000f40:	80008537          	lui	a0,0x80008
80000f44:	ff400893          	li	a7,-12
80000f48:	00012223          	sw	zero,4(sp)
80000f4c:	00012023          	sw	zero,0(sp)
80000f50:	00000813          	li	a6,0
80000f54:	00000793          	li	a5,0
80000f58:	00000713          	li	a4,0
80000f5c:	3dc68693          	addi	a3,a3,988 # 800013dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800013dd>
80000f60:	20000613          	li	a2,512
80000f64:	97058593          	addi	a1,a1,-1680 # 80008970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008971>
80000f68:	33c50513          	addi	a0,a0,828 # 8000833c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000833d>
80000f6c:	235040ef          	jal	ra,800059a0 <z_impl_k_thread_create>
	zassert_equal(thread_evidence, 1,
80000f70:	0004a803          	lw	a6,0(s1)
80000f74:	800077b7          	lui	a5,0x80007
80000f78:	80007737          	lui	a4,0x80007
80000f7c:	fff80513          	addi	a0,a6,-1
80000f80:	80007637          	lui	a2,0x80007
80000f84:	800075b7          	lui	a1,0x80007
80000f88:	3e878793          	addi	a5,a5,1000 # 800073e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073e9>
80000f8c:	cec70713          	addi	a4,a4,-788 # 80006cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ced>
80000f90:	37c00693          	li	a3,892
80000f94:	6cc60613          	addi	a2,a2,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
80000f98:	41058593          	addi	a1,a1,1040 # 80007410 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007411>
80000f9c:	00153513          	seqz	a0,a0
80000fa0:	9d1ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000fa4:	32c40513          	addi	a0,s0,812
80000fa8:	41c040ef          	jal	ra,800053c4 <z_impl_k_sem_give>
80000fac:	32c40513          	addi	a0,s0,812
80000fb0:	414040ef          	jal	ra,800053c4 <z_impl_k_sem_give>
80000fb4:	32c40513          	addi	a0,s0,812
}
80000fb8:	01812403          	lw	s0,24(sp)
80000fbc:	01c12083          	lw	ra,28(sp)
80000fc0:	01412483          	lw	s1,20(sp)
80000fc4:	02010113          	addi	sp,sp,32
80000fc8:	3fc0406f          	j	800053c4 <z_impl_k_sem_give>

80000fcc <test_k_sleep>:
{
80000fcc:	f7010113          	addi	sp,sp,-144
80000fd0:	07312e23          	sw	s3,124(sp)
80000fd4:	07412c23          	sw	s4,120(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000fd8:	800099b7          	lui	s3,0x80009
80000fdc:	80008a37          	lui	s4,0x80008
80000fe0:	800006b7          	lui	a3,0x80000
80000fe4:	ff400893          	li	a7,-12
80000fe8:	00000813          	li	a6,0
80000fec:	00000793          	li	a5,0
80000ff0:	03200713          	li	a4,50
80000ff4:	7a868693          	addi	a3,a3,1960 # 800007a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800007a9>
80000ff8:	18000613          	li	a2,384
80000ffc:	f7098593          	addi	a1,s3,-144 # 80008f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008f71>
80001000:	4a0a0513          	addi	a0,s4,1184 # 800084a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084a1>
80001004:	00012223          	sw	zero,4(sp)
80001008:	00012023          	sw	zero,0(sp)
8000100c:	08112623          	sw	ra,140(sp)
80001010:	08812423          	sw	s0,136(sp)
80001014:	08912223          	sw	s1,132(sp)
80001018:	09212023          	sw	s2,128(sp)
8000101c:	07512a23          	sw	s5,116(sp)
80001020:	07612823          	sw	s6,112(sp)
80001024:	07712623          	sw	s7,108(sp)
80001028:	07812423          	sw	s8,104(sp)
8000102c:	07912223          	sw	s9,100(sp)
80001030:	07a12023          	sw	s10,96(sp)
80001034:	05b12e23          	sw	s11,92(sp)
80001038:	169040ef          	jal	ra,800059a0 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
8000103c:	80008537          	lui	a0,0x80008
80001040:	06400593          	li	a1,100
80001044:	31c50513          	addi	a0,a0,796 # 8000831c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000831d>
80001048:	460040ef          	jal	ra,800054a8 <z_impl_k_sem_take>
	zassert_equal(rv, 0, " *** thread timed out waiting for thread on "
8000104c:	80007437          	lui	s0,0x80007
80001050:	800077b7          	lui	a5,0x80007
80001054:	800074b7          	lui	s1,0x80007
80001058:	800075b7          	lui	a1,0x80007
8000105c:	15478793          	addi	a5,a5,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
80001060:	cdc40713          	addi	a4,s0,-804 # 80006cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cdd>
80001064:	30300693          	li	a3,771
80001068:	6cc48613          	addi	a2,s1,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
8000106c:	18c58593          	addi	a1,a1,396 # 8000718c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000718d>
80001070:	00153513          	seqz	a0,a0
80001074:	8fdff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	TC_PRINT("Testing k_thread_create() without cancellation\n");
80001078:	80007537          	lui	a0,0x80007
8000107c:	80008ab7          	lui	s5,0x80008
80001080:	1a050513          	addi	a0,a0,416 # 800071a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a1>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001084:	80000d37          	lui	s10,0x80000
80001088:	1f0a8b13          	addi	s6,s5,496 # 800081f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081f1>
8000108c:	4a0a0b93          	addi	s7,s4,1184
80001090:	f7098913          	addi	s2,s3,-144
80001094:	67c010ef          	jal	ra,80002710 <printk>
80001098:	f7098993          	addi	s3,s3,-144
8000109c:	4a0a0a13          	addi	s4,s4,1184
800010a0:	1f0a8a93          	addi	s5,s5,496
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800010a4:	00000c13          	li	s8,0
800010a8:	00700d93          	li	s11,7
800010ac:	000d0c93          	mv	s9,s10
800010b0:	004aa783          	lw	a5,4(s5)
800010b4:	000c0713          	mv	a4,s8
800010b8:	00098593          	mv	a1,s3
800010bc:	00f12223          	sw	a5,4(sp)
800010c0:	000a0513          	mv	a0,s4
800010c4:	00012023          	sw	zero,0(sp)
800010c8:	ff500893          	li	a7,-11
800010cc:	00000813          	li	a6,0
800010d0:	00000793          	li	a5,0
800010d4:	75cd0693          	addi	a3,s10,1884 # 8000075c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000075d>
800010d8:	18000613          	li	a2,384
800010dc:	001c0c13          	addi	s8,s8,1
800010e0:	0c1040ef          	jal	ra,800059a0 <z_impl_k_thread_create>
800010e4:	010a8a93          	addi	s5,s5,16
800010e8:	070a0a13          	addi	s4,s4,112
800010ec:	18098993          	addi	s3,s3,384
800010f0:	fdbc10e3          	bne	s8,s11,800010b0 <test_k_sleep+0xe4>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
800010f4:	80008337          	lui	t1,0x80008
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800010f8:	00000d93          	li	s11,0
		zassert_not_null(data, " *** timeout while waiting for"
800010fc:	80007d37          	lui	s10,0x80007
80001100:	80007ab7          	lui	s5,0x80007
		zassert_equal(data->timeout_order, i,
80001104:	80007a37          	lui	s4,0x80007
80001108:	00030c13          	mv	s8,t1
8000110c:	48c30513          	addi	a0,t1,1164 # 8000848c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000848d>
80001110:	2ee00593          	li	a1,750
80001114:	5e8020ef          	jal	ra,800036fc <z_impl_k_queue_get>
80001118:	00050993          	mv	s3,a0
		zassert_not_null(data, " *** timeout while waiting for"
8000111c:	1d0d0793          	addi	a5,s10,464 # 800071d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071d1>
80001120:	cdc40713          	addi	a4,s0,-804
80001124:	31300693          	li	a3,787
80001128:	6cc48613          	addi	a2,s1,1740
8000112c:	200a8593          	addi	a1,s5,512 # 80007200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007201>
80001130:	00a03533          	snez	a0,a0
80001134:	83dff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
		zassert_equal(data->timeout_order, i,
80001138:	0089a803          	lw	a6,8(s3)
8000113c:	80007e37          	lui	t3,0x80007
80001140:	248e0593          	addi	a1,t3,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80001144:	41b80533          	sub	a0,a6,s11
80001148:	000d8893          	mv	a7,s11
8000114c:	210a0793          	addi	a5,s4,528 # 80007210 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007211>
80001150:	cdc40713          	addi	a4,s0,-804
80001154:	31700693          	li	a3,791
80001158:	6cc48613          	addi	a2,s1,1740
8000115c:	00153513          	seqz	a0,a0
80001160:	811ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
		TC_PRINT(" got thread (q order: %d, t/o: %d) as expected\n",
80001164:	0049a603          	lw	a2,4(s3)
80001168:	00c9a583          	lw	a1,12(s3)
8000116c:	80007537          	lui	a0,0x80007
80001170:	27050513          	addi	a0,a0,624 # 80007270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007271>
80001174:	59c010ef          	jal	ra,80002710 <printk>
80001178:	80007e37          	lui	t3,0x80007
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
8000117c:	001d8d93          	addi	s11,s11,1
80001180:	00700793          	li	a5,7
80001184:	01c12c23          	sw	t3,24(sp)
80001188:	80008337          	lui	t1,0x80008
8000118c:	f8fd90e3          	bne	s11,a5,8000110c <test_k_sleep+0x140>
80001190:	48c30513          	addi	a0,t1,1164 # 8000848c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000848d>
80001194:	2ee00593          	li	a1,750
80001198:	564020ef          	jal	ra,800036fc <z_impl_k_queue_get>
	zassert_false(data, " *** got something unexpected in the fifo");
8000119c:	80007a37          	lui	s4,0x80007
800011a0:	80007ab7          	lui	s5,0x80007
800011a4:	2a0a0793          	addi	a5,s4,672 # 800072a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a1>
800011a8:	cdc40713          	addi	a4,s0,-804
800011ac:	32000693          	li	a3,800
800011b0:	6cc48613          	addi	a2,s1,1740
800011b4:	2cca8593          	addi	a1,s5,716 # 800072cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072cd>
800011b8:	00153513          	seqz	a0,a0
800011bc:	fb4ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	TC_PRINT("Testing k_thread_create() with cancellations\n");
800011c0:	80007537          	lui	a0,0x80007
800011c4:	2dc50513          	addi	a0,a0,732 # 800072dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072dd>
800011c8:	548010ef          	jal	ra,80002710 <printk>
	int cancellations[] = { 0, 3, 4, 6 };
800011cc:	800075b7          	lui	a1,0x80007
800011d0:	01000613          	li	a2,16
800011d4:	b5858593          	addi	a1,a1,-1192 # 80006b58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b59>
800011d8:	02410513          	addi	a0,sp,36
800011dc:	2fd010ef          	jal	ra,80002cd8 <memcpy>
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800011e0:	03410d93          	addi	s11,sp,52
	int cancellations[] = { 0, 3, 4, 6 };
800011e4:	000b0313          	mv	t1,s6
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800011e8:	00000d13          	li	s10,0
800011ec:	00700993          	li	s3,7
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800011f0:	00432783          	lw	a5,4(t1)
800011f4:	000d0713          	mv	a4,s10
800011f8:	00090593          	mv	a1,s2
800011fc:	00f12223          	sw	a5,4(sp)
80001200:	000b8513          	mv	a0,s7
80001204:	00012023          	sw	zero,0(sp)
80001208:	ff500893          	li	a7,-11
8000120c:	00000813          	li	a6,0
80001210:	00000793          	li	a5,0
80001214:	75cc8693          	addi	a3,s9,1884
80001218:	18000613          	li	a2,384
8000121c:	00612e23          	sw	t1,28(sp)
80001220:	780040ef          	jal	ra,800059a0 <z_impl_k_thread_create>
		delayed_threads[i] = id;
80001224:	01c12303          	lw	t1,28(sp)
80001228:	00ada023          	sw	a0,0(s11)
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
8000122c:	001d0d13          	addi	s10,s10,1
80001230:	01030313          	addi	t1,t1,16
80001234:	070b8b93          	addi	s7,s7,112
80001238:	18090913          	addi	s2,s2,384
8000123c:	004d8d93          	addi	s11,s11,4
80001240:	fb3d18e3          	bne	s10,s3,800011f0 <test_k_sleep+0x224>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80001244:	00001bb7          	lui	s7,0x1
80001248:	000b0913          	mv	s2,s6
	int next_cancellation = 0;
8000124c:	00000993          	li	s3,0
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001250:	00000d13          	li	s10,0
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
80001254:	00700c93          	li	s9,7
80001258:	abeb8b93          	addi	s7,s7,-1346 # abe <CONFIG_ISR_STACK_SIZE+0x2be>
		if (i == cancellations[next_cancellation]) {
8000125c:	00299793          	slli	a5,s3,0x2
80001260:	05010713          	addi	a4,sp,80
80001264:	00f707b3          	add	a5,a4,a5
80001268:	fd47a783          	lw	a5,-44(a5)
8000126c:	11a78e63          	beq	a5,s10,80001388 <test_k_sleep+0x3bc>
80001270:	000b8593          	mv	a1,s7
80001274:	48cc0513          	addi	a0,s8,1164
80001278:	484020ef          	jal	ra,800036fc <z_impl_k_queue_get>
		zassert_not_null(data, " *** timeout while waiting for"
8000127c:	800077b7          	lui	a5,0x80007
80001280:	800075b7          	lui	a1,0x80007
80001284:	00050d93          	mv	s11,a0
80001288:	1d078793          	addi	a5,a5,464 # 800071d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071d1>
8000128c:	cdc40713          	addi	a4,s0,-804
80001290:	34e00693          	li	a3,846
80001294:	6cc48613          	addi	a2,s1,1740
80001298:	20058593          	addi	a1,a1,512 # 80007200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007201>
8000129c:	00a03533          	snez	a0,a0
800012a0:	ed0ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
		zassert_equal(data->timeout_order, i,
800012a4:	008da803          	lw	a6,8(s11)
800012a8:	01812583          	lw	a1,24(sp)
800012ac:	800077b7          	lui	a5,0x80007
800012b0:	410d0533          	sub	a0,s10,a6
800012b4:	21078793          	addi	a5,a5,528 # 80007210 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007211>
800012b8:	35200693          	li	a3,850
800012bc:	6cc48613          	addi	a2,s1,1740
800012c0:	24858593          	addi	a1,a1,584
800012c4:	00153513          	seqz	a0,a0
800012c8:	000d0893          	mv	a7,s10
800012cc:	cdc40713          	addi	a4,s0,-804
800012d0:	ea0ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
		TC_PRINT(" got (q order: %d, t/o: %d, t/o order %d) "
800012d4:	008da683          	lw	a3,8(s11)
800012d8:	004da603          	lw	a2,4(s11)
800012dc:	00cda583          	lw	a1,12(s11)
800012e0:	800077b7          	lui	a5,0x80007
800012e4:	30c78513          	addi	a0,a5,780 # 8000730c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000730d>
800012e8:	428010ef          	jal	ra,80002710 <printk>
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800012ec:	001d0d13          	addi	s10,s10,1
800012f0:	01090913          	addi	s2,s2,16
800012f4:	f79d14e3          	bne	s10,s9,8000125c <test_k_sleep+0x290>
	zassert_equal(num_cancellations, next_cancellation,
800012f8:	ffc98513          	addi	a0,s3,-4
800012fc:	800077b7          	lui	a5,0x80007
80001300:	800075b7          	lui	a1,0x80007
80001304:	cdc40713          	addi	a4,s0,-804
80001308:	6cc48613          	addi	a2,s1,1740
8000130c:	00098893          	mv	a7,s3
80001310:	37878793          	addi	a5,a5,888 # 80007378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007379>
80001314:	35b00693          	li	a3,859
80001318:	00400813          	li	a6,4
8000131c:	3b458593          	addi	a1,a1,948 # 800073b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073b5>
80001320:	00153513          	seqz	a0,a0
80001324:	e4cff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
80001328:	2ee00593          	li	a1,750
8000132c:	48cc0513          	addi	a0,s8,1164
80001330:	3cc020ef          	jal	ra,800036fc <z_impl_k_queue_get>
	zassert_false(data, " *** got something unexpected in the fifo");
80001334:	cdc40713          	addi	a4,s0,-804
}
80001338:	08812403          	lw	s0,136(sp)
8000133c:	08c12083          	lw	ra,140(sp)
80001340:	08012903          	lw	s2,128(sp)
80001344:	07c12983          	lw	s3,124(sp)
80001348:	07012b03          	lw	s6,112(sp)
8000134c:	06c12b83          	lw	s7,108(sp)
80001350:	06812c03          	lw	s8,104(sp)
80001354:	06412c83          	lw	s9,100(sp)
80001358:	06012d03          	lw	s10,96(sp)
8000135c:	05c12d83          	lw	s11,92(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
80001360:	2a0a0793          	addi	a5,s4,672
80001364:	6cc48613          	addi	a2,s1,1740
}
80001368:	07812a03          	lw	s4,120(sp)
8000136c:	08412483          	lw	s1,132(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
80001370:	2cca8593          	addi	a1,s5,716
}
80001374:	07412a83          	lw	s5,116(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
80001378:	35f00693          	li	a3,863
8000137c:	00153513          	seqz	a0,a0
}
80001380:	09010113          	addi	sp,sp,144
	zassert_false(data, " *** got something unexpected in the fifo");
80001384:	decff06f          	j	80000970 <z_zassert.constprop.2>
			TC_PRINT(" cancelling "
80001388:	00492603          	lw	a2,4(s2)
8000138c:	00c92583          	lw	a1,12(s2)
80001390:	800077b7          	lui	a5,0x80007
80001394:	34478513          	addi	a0,a5,836 # 80007344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007345>
80001398:	000d0693          	mv	a3,s10
8000139c:	374010ef          	jal	ra,80002710 <printk>
800013a0:	000b0713          	mv	a4,s6
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
800013a4:	00000793          	li	a5,0
				if (timeouts[j].timeout_order == i) {
800013a8:	00872683          	lw	a3,8(a4)
800013ac:	01a68a63          	beq	a3,s10,800013c0 <test_k_sleep+0x3f4>
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
800013b0:	00178793          	addi	a5,a5,1
800013b4:	01070713          	addi	a4,a4,16
800013b8:	ff9798e3          	bne	a5,s9,800013a8 <test_k_sleep+0x3dc>
800013bc:	eb5ff06f          	j	80001270 <test_k_sleep+0x2a4>
				k_thread_abort(delayed_threads[j]);
800013c0:	05010713          	addi	a4,sp,80
800013c4:	00279793          	slli	a5,a5,0x2
800013c8:	00f707b3          	add	a5,a4,a5
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800013cc:	fe47a503          	lw	a0,-28(a5)
				++next_cancellation;
800013d0:	00198993          	addi	s3,s3,1
800013d4:	770040ef          	jal	ra,80005b44 <z_impl_k_thread_abort>
				continue;
800013d8:	f15ff06f          	j	800012ec <test_k_sleep+0x320>

800013dc <k_yield_entry>:
{
800013dc:	fd010113          	addi	sp,sp,-48
800013e0:	02812423          	sw	s0,40(sp)
	thread_evidence++;      /* Prove that the thread has run */
800013e4:	80008437          	lui	s0,0x80008
800013e8:	2d040413          	addi	s0,s0,720 # 800082d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d1>
800013ec:	00042783          	lw	a5,0(s0)
{
800013f0:	01312e23          	sw	s3,28(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800013f4:	800089b7          	lui	s3,0x80008
	thread_evidence++;      /* Prove that the thread has run */
800013f8:	00178793          	addi	a5,a5,1
800013fc:	fff00593          	li	a1,-1
80001400:	32c98513          	addi	a0,s3,812 # 8000832c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000832d>
{
80001404:	02112623          	sw	ra,44(sp)
80001408:	02912223          	sw	s1,36(sp)
8000140c:	03212023          	sw	s2,32(sp)
80001410:	01412c23          	sw	s4,24(sp)
	thread_evidence++;      /* Prove that the thread has run */
80001414:	00f42023          	sw	a5,0(s0)
80001418:	090040ef          	jal	ra,800054a8 <z_impl_k_sem_take>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000141c:	6d5030ef          	jal	ra,800052f0 <z_impl_k_current_get>
80001420:	00050a13          	mv	s4,a0
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001424:	800006b7          	lui	a3,0x80000
80001428:	800095b7          	lui	a1,0x80009
8000142c:	80008537          	lui	a0,0x80008
80001430:	ff300893          	li	a7,-13
80001434:	00000813          	li	a6,0
80001438:	00012223          	sw	zero,4(sp)
8000143c:	00012023          	sw	zero,0(sp)
80001440:	00000793          	li	a5,0
80001444:	00000713          	li	a4,0
80001448:	6f868693          	addi	a3,a3,1784 # 800006f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800006f9>
8000144c:	20000613          	li	a2,512
80001450:	b7058593          	addi	a1,a1,-1168 # 80008b70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008b71>
80001454:	3ac50513          	addi	a0,a0,940 # 800083ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800083ad>
	thread_evidence = 0;
80001458:	00042023          	sw	zero,0(s0)
8000145c:	544040ef          	jal	ra,800059a0 <z_impl_k_thread_create>
	zassert_equal(thread_evidence, 0,
80001460:	00042503          	lw	a0,0(s0)
80001464:	80007937          	lui	s2,0x80007
80001468:	800074b7          	lui	s1,0x80007
8000146c:	800077b7          	lui	a5,0x80007
80001470:	800075b7          	lui	a1,0x80007
80001474:	cac90713          	addi	a4,s2,-852 # 80006cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cad>
80001478:	6cc48613          	addi	a2,s1,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
8000147c:	d6c78793          	addi	a5,a5,-660 # 80006d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d6d>
80001480:	24800693          	li	a3,584
80001484:	da058593          	addi	a1,a1,-608 # 80006da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006da1>
80001488:	00153513          	seqz	a0,a0
8000148c:	ce4ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80001490:	22d030ef          	jal	ra,80004ebc <z_impl_k_yield>
	zassert_not_equal(thread_evidence, 0,
80001494:	00042803          	lw	a6,0(s0)
80001498:	800077b7          	lui	a5,0x80007
8000149c:	800075b7          	lui	a1,0x80007
800014a0:	cac90713          	addi	a4,s2,-852
800014a4:	6cc48613          	addi	a2,s1,1740
800014a8:	01003533          	snez	a0,a6
800014ac:	dc478793          	addi	a5,a5,-572 # 80006dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dc5>
800014b0:	25200693          	li	a3,594
800014b4:	dfc58593          	addi	a1,a1,-516 # 80006dfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dfd>
800014b8:	cb8ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	zassert_false((thread_evidence > 1),
800014bc:	00042803          	lw	a6,0(s0)
800014c0:	800077b7          	lui	a5,0x80007
800014c4:	800075b7          	lui	a1,0x80007
800014c8:	cac90713          	addi	a4,s2,-852
800014cc:	6cc48613          	addi	a2,s1,1740
800014d0:	00282513          	slti	a0,a6,2
800014d4:	e1c78793          	addi	a5,a5,-484 # 80006e1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e1d>
800014d8:	25600693          	li	a3,598
800014dc:	e5458593          	addi	a1,a1,-428 # 80006e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e55>
800014e0:	c90ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
	k_thread_priority_set(self_thread_id, self_thread_id->base.prio - 1);
800014e4:	00ea0583          	lb	a1,14(s4)
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
800014e8:	000a0513          	mv	a0,s4
800014ec:	fff58593          	addi	a1,a1,-1
800014f0:	0fd030ef          	jal	ra,80004dec <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800014f4:	1c9030ef          	jal	ra,80004ebc <z_impl_k_yield>
	zassert_equal(thread_evidence, 1,
800014f8:	00042503          	lw	a0,0(s0)
800014fc:	800077b7          	lui	a5,0x80007
80001500:	800075b7          	lui	a1,0x80007
80001504:	fff50513          	addi	a0,a0,-1
80001508:	cac90713          	addi	a4,s2,-852
8000150c:	6cc48613          	addi	a2,s1,1740
80001510:	41058593          	addi	a1,a1,1040 # 80007410 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007411>
80001514:	00153513          	seqz	a0,a0
80001518:	e7478793          	addi	a5,a5,-396 # 80006e74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e75>
8000151c:	26000693          	li	a3,608
80001520:	c50ff0ef          	jal	ra,80000970 <z_zassert.constprop.2>
}
80001524:	02812403          	lw	s0,40(sp)
80001528:	02c12083          	lw	ra,44(sp)
8000152c:	02412483          	lw	s1,36(sp)
80001530:	02012903          	lw	s2,32(sp)
80001534:	01812a03          	lw	s4,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001538:	32c98513          	addi	a0,s3,812
8000153c:	01c12983          	lw	s3,28(sp)
80001540:	fff00593          	li	a1,-1
80001544:	03010113          	addi	sp,sp,48
80001548:	7610306f          	j	800054a8 <z_impl_k_sem_take>

8000154c <test_main>:
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
8000154c:	80008537          	lui	a0,0x80008

/*test case main entry*/
void test_main(void)
{
80001550:	ff010113          	addi	sp,sp,-16
80001554:	fff00613          	li	a2,-1
80001558:	00000593          	li	a1,0
8000155c:	31c50513          	addi	a0,a0,796 # 8000831c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000831d>
80001560:	00112623          	sw	ra,12(sp)
80001564:	599030ef          	jal	ra,800052fc <z_impl_k_sem_init>
	k_timer_init(&timer, NULL, NULL);
80001568:	80008537          	lui	a0,0x80008
8000156c:	00000593          	li	a1,0
80001570:	00000613          	li	a2,0
80001574:	7b050513          	addi	a0,a0,1968 # 800087b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800087b1>
80001578:	040050ef          	jal	ra,800065b8 <k_timer_init>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
8000157c:	80008537          	lui	a0,0x80008
80001580:	48c50513          	addi	a0,a0,1164 # 8000848c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000848d>
80001584:	14c020ef          	jal	ra,800036d0 <z_impl_k_queue_init>
			 ztest_unit_test(test_kernel_cpu_idle),
			 ztest_unit_test(test_k_yield),
			 ztest_unit_test(test_kernel_thread)
			 );
	ztest_run_test_suite(context);
}
80001588:	00c12083          	lw	ra,12(sp)
	ztest_run_test_suite(context);
8000158c:	800085b7          	lui	a1,0x80008
80001590:	80007537          	lui	a0,0x80007
80001594:	12858593          	addi	a1,a1,296 # 80008128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008129>
80001598:	64850513          	addi	a0,a0,1608 # 80007648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007649>
}
8000159c:	01010113          	addi	sp,sp,16
	ztest_run_test_suite(context);
800015a0:	1610106f          	j	80002f00 <z_ztest_run_test_suite>

800015a4 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
800015a4:	ff010113          	addi	sp,sp,-16
800015a8:	00112623          	sw	ra,12(sp)
800015ac:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
800015b0:	00600793          	li	a5,6
800015b4:	02f50463          	beq	a0,a5,800015dc <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
800015b8:	0d8040ef          	jal	ra,80005690 <k_is_in_isr>
800015bc:	02050463          	beqz	a0,800015e4 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
800015c0:	0d0040ef          	jal	ra,80005690 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
800015c4:	04051663          	bnez	a0,80001610 <z_SysFatalErrorHandler+0x6c>
800015c8:	800085b7          	lui	a1,0x80008
800015cc:	9c858593          	addi	a1,a1,-1592 # 800079c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079c9>
800015d0:	80008537          	lui	a0,0x80008
800015d4:	9dc50513          	addi	a0,a0,-1572 # 800079dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079dd>
800015d8:	138010ef          	jal	ra,80002710 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
800015dc:	1a4010ef          	jal	ra,80002780 <k_cpu_idle>
800015e0:	ffdff06f          	j	800015dc <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
800015e4:	0bc040ef          	jal	ra,800056a0 <z_is_thread_essential>
800015e8:	fc051ce3          	bnez	a0,800015c0 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
800015ec:	80009437          	lui	s0,0x80009
800015f0:	93c40413          	addi	s0,s0,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
800015f4:	00842583          	lw	a1,8(s0)
800015f8:	80008537          	lui	a0,0x80008
800015fc:	9fc50513          	addi	a0,a0,-1540 # 800079fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079fd>
80001600:	110010ef          	jal	ra,80002710 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001604:	00842503          	lw	a0,8(s0)
80001608:	53c040ef          	jal	ra,80005b44 <z_impl_k_thread_abort>
8000160c:	fd1ff06f          	j	800015dc <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80001610:	800085b7          	lui	a1,0x80008
80001614:	9c458593          	addi	a1,a1,-1596 # 800079c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079c5>
80001618:	fb9ff06f          	j	800015d0 <z_SysFatalErrorHandler+0x2c>

8000161c <z_NanoFatalErrorHandler>:
{
8000161c:	fb010113          	addi	sp,sp,-80
80001620:	04812423          	sw	s0,72(sp)
80001624:	04912223          	sw	s1,68(sp)
80001628:	04112623          	sw	ra,76(sp)
	switch (reason) {
8000162c:	00600793          	li	a5,6
{
80001630:	00050493          	mv	s1,a0
80001634:	00058413          	mv	s0,a1
	switch (reason) {
80001638:	0ea7e063          	bltu	a5,a0,80001718 <z_NanoFatalErrorHandler+0xfc>
8000163c:	80007737          	lui	a4,0x80007
80001640:	00251793          	slli	a5,a0,0x2
80001644:	71870713          	addi	a4,a4,1816 # 80007718 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007719>
80001648:	00e787b3          	add	a5,a5,a4
8000164c:	0007a783          	lw	a5,0(a5)
80001650:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80001654:	80008537          	lui	a0,0x80008
80001658:	84850513          	addi	a0,a0,-1976 # 80007848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007849>
		printk("***** Kernel OOPS! *****\n");
8000165c:	0b4010ef          	jal	ra,80002710 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001660:	491030ef          	jal	ra,800052f0 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80001664:	04442783          	lw	a5,68(s0)
80001668:	01042883          	lw	a7,16(s0)
8000166c:	00c42803          	lw	a6,12(s0)
80001670:	02f12823          	sw	a5,48(sp)
80001674:	04042783          	lw	a5,64(s0)
80001678:	00442703          	lw	a4,4(s0)
8000167c:	00042683          	lw	a3,0(s0)
80001680:	02f12623          	sw	a5,44(sp)
80001684:	03c42783          	lw	a5,60(s0)
80001688:	04842603          	lw	a2,72(s0)
8000168c:	00050593          	mv	a1,a0
80001690:	02f12423          	sw	a5,40(sp)
80001694:	03842783          	lw	a5,56(s0)
80001698:	80008537          	lui	a0,0x80008
8000169c:	8cc50513          	addi	a0,a0,-1844 # 800078cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078cd>
800016a0:	02f12223          	sw	a5,36(sp)
800016a4:	03442783          	lw	a5,52(s0)
800016a8:	02f12023          	sw	a5,32(sp)
800016ac:	03042783          	lw	a5,48(s0)
800016b0:	00f12e23          	sw	a5,28(sp)
800016b4:	02c42783          	lw	a5,44(s0)
800016b8:	00f12c23          	sw	a5,24(sp)
800016bc:	02842783          	lw	a5,40(s0)
800016c0:	00f12a23          	sw	a5,20(sp)
800016c4:	02442783          	lw	a5,36(s0)
800016c8:	00f12823          	sw	a5,16(sp)
800016cc:	02042783          	lw	a5,32(s0)
800016d0:	00f12623          	sw	a5,12(sp)
800016d4:	01c42783          	lw	a5,28(s0)
800016d8:	00f12423          	sw	a5,8(sp)
800016dc:	01842783          	lw	a5,24(s0)
800016e0:	00f12223          	sw	a5,4(sp)
800016e4:	01442783          	lw	a5,20(s0)
800016e8:	00f12023          	sw	a5,0(sp)
800016ec:	00842783          	lw	a5,8(s0)
800016f0:	020010ef          	jal	ra,80002710 <printk>
	z_SysFatalErrorHandler(reason, esf);
800016f4:	00040593          	mv	a1,s0
800016f8:	00048513          	mv	a0,s1
800016fc:	ea9ff0ef          	jal	ra,800015a4 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80001700:	80008537          	lui	a0,0x80008
80001704:	87050513          	addi	a0,a0,-1936 # 80007870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007871>
80001708:	f55ff06f          	j	8000165c <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
8000170c:	80008537          	lui	a0,0x80008
80001710:	88c50513          	addi	a0,a0,-1908 # 8000788c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000788d>
80001714:	f49ff06f          	j	8000165c <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80001718:	80008537          	lui	a0,0x80008
8000171c:	00048593          	mv	a1,s1
80001720:	8a850513          	addi	a0,a0,-1880 # 800078a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078a9>
80001724:	7ed000ef          	jal	ra,80002710 <printk>
		break;
80001728:	f39ff06f          	j	80001660 <z_NanoFatalErrorHandler+0x44>

8000172c <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
8000172c:	ff010113          	addi	sp,sp,-16
80001730:	00812423          	sw	s0,8(sp)
80001734:	00112623          	sw	ra,12(sp)
80001738:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
8000173c:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80001740:	00161613          	slli	a2,a2,0x1
80001744:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80001748:	00500793          	li	a5,5
8000174c:	02c7e863          	bltu	a5,a2,8000177c <_Fault+0x50>
80001750:	80007737          	lui	a4,0x80007
80001754:	00261793          	slli	a5,a2,0x2
80001758:	73470713          	addi	a4,a4,1844 # 80007734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007735>
8000175c:	00f707b3          	add	a5,a4,a5
80001760:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001764:	80007537          	lui	a0,0x80007
80001768:	75450513          	addi	a0,a0,1876 # 80007754 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007755>
8000176c:	7a5000ef          	jal	ra,80002710 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80001770:	00040593          	mv	a1,s0
80001774:	00000513          	li	a0,0
80001778:	ea5ff0ef          	jal	ra,8000161c <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
8000177c:	800075b7          	lui	a1,0x80007
80001780:	74c58593          	addi	a1,a1,1868 # 8000774c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000774d>
80001784:	fe1ff06f          	j	80001764 <_Fault+0x38>

80001788 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80001788:	ff010113          	addi	sp,sp,-16
8000178c:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001790:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001794:	80008537          	lui	a0,0x80008
	mcause &= SOC_MCAUSE_EXP_MASK;
80001798:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
8000179c:	0015d593          	srli	a1,a1,0x1
800017a0:	a2450513          	addi	a0,a0,-1500 # 80007a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a25>
800017a4:	76d000ef          	jal	ra,80002710 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
800017a8:	800075b7          	lui	a1,0x80007
800017ac:	77058593          	addi	a1,a1,1904 # 80007770 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007771>
800017b0:	00400513          	li	a0,4
800017b4:	e69ff0ef          	jal	ra,8000161c <z_NanoFatalErrorHandler>

800017b8 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
800017b8:	800087b7          	lui	a5,0x80008
800017bc:	2d478793          	addi	a5,a5,724 # 800082d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d5>
800017c0:	0007a703          	lw	a4,0(a5)
800017c4:	00070c63          	beqz	a4,800017dc <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
800017c8:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
800017cc:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
800017d0:	800087b7          	lui	a5,0x80008
800017d4:	2d87a503          	lw	a0,728(a5) # 800082d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d9>
800017d8:	00030067          	jr	t1
}
800017dc:	00008067          	ret

800017e0 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
800017e0:	00800793          	li	a5,8
800017e4:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
800017e8:	80008737          	lui	a4,0x80008
800017ec:	2ca72a23          	sw	a0,724(a4) # 800082d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d5>
	offload_param = parameter;
800017f0:	80008737          	lui	a4,0x80008
800017f4:	2cb72c23          	sw	a1,728(a4) # 800082d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082d9>

	__asm__ volatile ("ecall");
800017f8:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
800017fc:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80001800:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80001804:	00008067          	ret

80001808 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80001808:	ff010113          	addi	sp,sp,-16
8000180c:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80001810:	2a5010ef          	jal	ra,800032b4 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001814:	79d000ef          	jal	ra,800027b0 <soc_interrupt_init>
#endif
	z_cstart();
80001818:	309010ef          	jal	ra,80003320 <z_cstart>

8000181c <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
8000181c:	00009117          	auipc	sp,0x9
80001820:	9d410113          	addi	sp,sp,-1580 # 8000a1f0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80001824:	000012b7          	lui	t0,0x1
80001828:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
8000182c:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80001830:	fd9ff0ef          	jal	ra,80001808 <_PrepC>

80001834 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80001834:	0890006f          	j	800020bc <z_thread_entry>

80001838 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001838:	fd010113          	addi	sp,sp,-48
8000183c:	02812423          	sw	s0,40(sp)
80001840:	02912223          	sw	s1,36(sp)
80001844:	03212023          	sw	s2,32(sp)
80001848:	01312e23          	sw	s3,28(sp)
8000184c:	01412c23          	sw	s4,24(sp)
80001850:	01512a23          	sw	s5,20(sp)
80001854:	01612823          	sw	s6,16(sp)
80001858:	01712623          	sw	s7,12(sp)
8000185c:	00078b13          	mv	s6,a5
80001860:	02112623          	sw	ra,44(sp)
80001864:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001868:	00f00793          	li	a5,15
{
8000186c:	00050493          	mv	s1,a0
80001870:	00058413          	mv	s0,a1
80001874:	00060993          	mv	s3,a2
80001878:	00068a13          	mv	s4,a3
8000187c:	00070b93          	mv	s7,a4
80001880:	00080a93          	mv	s5,a6
80001884:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001888:	08f89a63          	bne	a7,a5,8000191c <z_new_thread+0xe4>
8000188c:	800037b7          	lui	a5,0x80003
80001890:	27c78793          	addi	a5,a5,636 # 8000327c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000327d>
80001894:	08f69a63          	bne	a3,a5,80001928 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001898:	03012683          	lw	a3,48(sp)
8000189c:	00090593          	mv	a1,s2
800018a0:	00048513          	mv	a0,s1
800018a4:	00400613          	li	a2,4
800018a8:	719030ef          	jal	ra,800057c0 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
800018ac:	fb098593          	addi	a1,s3,-80
800018b0:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800018b4:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
800018b8:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
800018bc:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
800018c0:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800018c4:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
800018c8:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800018cc:	800027b7          	lui	a5,0x80002

	thread->callee_saved.sp = (u32_t)stack_init;
}
800018d0:	02c12083          	lw	ra,44(sp)
800018d4:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800018d8:	83478793          	addi	a5,a5,-1996 # 80001834 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001835>
	stack_init->a0 = (u32_t)thread_func;
800018dc:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
800018e0:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
800018e4:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
800018e8:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800018ec:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
800018f0:	02b4a423          	sw	a1,40(s1)
}
800018f4:	02012903          	lw	s2,32(sp)
800018f8:	02412483          	lw	s1,36(sp)
800018fc:	01c12983          	lw	s3,28(sp)
80001900:	01812a03          	lw	s4,24(sp)
80001904:	01412a83          	lw	s5,20(sp)
80001908:	01012b03          	lw	s6,16(sp)
8000190c:	00c12b83          	lw	s7,12(sp)
80001910:	00812c03          	lw	s8,8(sp)
80001914:	03010113          	addi	sp,sp,48
80001918:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
8000191c:	01088693          	addi	a3,a7,16
80001920:	01e00793          	li	a5,30
80001924:	f6d7fae3          	bgeu	a5,a3,80001898 <z_new_thread+0x60>
80001928:	80008c37          	lui	s8,0x80008
8000192c:	800085b7          	lui	a1,0x80008
80001930:	80008537          	lui	a0,0x80008
80001934:	a4cc0613          	addi	a2,s8,-1460 # 80007a4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a4d>
80001938:	01800693          	li	a3,24
8000193c:	a6c58593          	addi	a1,a1,-1428 # 80007a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a6d>
80001940:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80001944:	5cd000ef          	jal	ra,80002710 <printk>
80001948:	80008537          	lui	a0,0x80008
8000194c:	00090593          	mv	a1,s2
80001950:	ff000693          	li	a3,-16
80001954:	00e00613          	li	a2,14
80001958:	b1850513          	addi	a0,a0,-1256 # 80007b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b19>
8000195c:	5b5000ef          	jal	ra,80002710 <printk>
80001960:	01800593          	li	a1,24
80001964:	a4cc0513          	addi	a0,s8,-1460
80001968:	5e5000ef          	jal	ra,8000274c <assert_post_action>
8000196c:	f2dff06f          	j	80001898 <z_new_thread+0x60>

80001970 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001970:	00c00793          	li	a5,12
80001974:	02f58733          	mul	a4,a1,a5
80001978:	00c52783          	lw	a5,12(a0)
8000197c:	00e787b3          	add	a5,a5,a4
80001980:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001984:	00b75463          	bge	a4,a1,8000198c <get_bit_ptr+0x1c>
80001988:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
8000198c:	02000713          	li	a4,32
80001990:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
80001994:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
80001998:	00271713          	slli	a4,a4,0x2
8000199c:	00e787b3          	add	a5,a5,a4
800019a0:	00f6a023          	sw	a5,0(a3)
}
800019a4:	00008067          	ret

800019a8 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800019a8:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800019ac:	00c10693          	addi	a3,sp,12
{
800019b0:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800019b4:	fbdff0ef          	jal	ra,80001970 <get_bit_ptr>

	*word |= (1<<bit);
800019b8:	00c12703          	lw	a4,12(sp)
800019bc:	00100793          	li	a5,1
800019c0:	00a79533          	sll	a0,a5,a0
800019c4:	00072783          	lw	a5,0(a4)
}
800019c8:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
800019cc:	00a7e7b3          	or	a5,a5,a0
800019d0:	00f72023          	sw	a5,0(a4)
}
800019d4:	02010113          	addi	sp,sp,32
800019d8:	00008067          	ret

800019dc <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800019dc:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800019e0:	00c10693          	addi	a3,sp,12
{
800019e4:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800019e8:	f89ff0ef          	jal	ra,80001970 <get_bit_ptr>

	*word &= ~(1<<bit);
800019ec:	00c12703          	lw	a4,12(sp)
800019f0:	00100793          	li	a5,1
800019f4:	00a79533          	sll	a0,a5,a0
800019f8:	00072783          	lw	a5,0(a4)
}
800019fc:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80001a00:	fff54513          	not	a0,a0
80001a04:	00a7f533          	and	a0,a5,a0
80001a08:	00a72023          	sw	a0,0(a4)
}
80001a0c:	02010113          	addi	sp,sp,32
80001a10:	00008067          	ret

80001a14 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001a14:	00452783          	lw	a5,4(a0)
80001a18:	00855803          	lhu	a6,8(a0)
{
80001a1c:	ff010113          	addi	sp,sp,-16
80001a20:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001a24:	02f80833          	mul	a6,a6,a5
{
80001a28:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001a2c:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001a30:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80001a34:	fff00713          	li	a4,-1
{
80001a38:	00112623          	sw	ra,12(sp)
80001a3c:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
80001a40:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001a44:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
80001a48:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001a4c:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
80001a50:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80001a54:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
80001a58:	0315c263          	blt	a1,a7,80001a7c <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001a5c:	00000493          	li	s1,0
80001a60:	00845783          	lhu	a5,8(s0)
80001a64:	06f4c463          	blt	s1,a5,80001acc <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001a68:	00c12083          	lw	ra,12(sp)
80001a6c:	00812403          	lw	s0,8(sp)
80001a70:	00412483          	lw	s1,4(sp)
80001a74:	01010113          	addi	sp,sp,16
80001a78:	00008067          	ret
		int nblocks = buflen / sz;
80001a7c:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
80001a80:	00c42603          	lw	a2,12(s0)
80001a84:	026586b3          	mul	a3,a1,t1
80001a88:	00d606b3          	add	a3,a2,a3
80001a8c:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001a90:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
80001a94:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
80001a98:	00ee4e63          	blt	t3,a4,80001ab4 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
80001a9c:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
80001aa0:	0027d793          	srli	a5,a5,0x2
80001aa4:	00378793          	addi	a5,a5,3
80001aa8:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
80001aac:	00158593          	addi	a1,a1,1
80001ab0:	fa9ff06f          	j	80001a58 <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
80001ab4:	01f70713          	addi	a4,a4,31
80001ab8:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80001abc:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
80001ac0:	00271713          	slli	a4,a4,0x2
80001ac4:	00e50533          	add	a0,a0,a4
80001ac8:	fd9ff06f          	j	80001aa0 <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80001acc:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
80001ad0:	00048613          	mv	a2,s1
80001ad4:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001ad8:	02f48733          	mul	a4,s1,a5
80001adc:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001ae0:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
80001ae4:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
80001ae8:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
80001aec:	00c42703          	lw	a4,12(s0)
80001af0:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001af4:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
80001af8:	00872683          	lw	a3,8(a4)
80001afc:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
80001b00:	00872683          	lw	a3,8(a4)
80001b04:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
80001b08:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
80001b0c:	e9dff0ef          	jal	ra,800019a8 <set_free_bit>
80001b10:	f51ff06f          	j	80001a60 <z_sys_mem_pool_base_init+0x4c>

80001b14 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001b14:	fb010113          	addi	sp,sp,-80
80001b18:	04812423          	sw	s0,72(sp)
80001b1c:	03712623          	sw	s7,44(sp)
80001b20:	04112623          	sw	ra,76(sp)
80001b24:	04912223          	sw	s1,68(sp)
80001b28:	05212023          	sw	s2,64(sp)
80001b2c:	03312e23          	sw	s3,60(sp)
80001b30:	03412c23          	sw	s4,56(sp)
80001b34:	03512a23          	sw	s5,52(sp)
80001b38:	03612823          	sw	s6,48(sp)
80001b3c:	03812423          	sw	s8,40(sp)
80001b40:	03912223          	sw	s9,36(sp)
80001b44:	03a12023          	sw	s10,32(sp)
80001b48:	01b12e23          	sw	s11,28(sp)
80001b4c:	05010413          	addi	s0,sp,80
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001b50:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001b54:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001b58:	002e1793          	slli	a5,t3,0x2
80001b5c:	00f78793          	addi	a5,a5,15
80001b60:	7f07f793          	andi	a5,a5,2032
80001b64:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001b68:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001b6c:	00010b93          	mv	s7,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001b70:	000b8313          	mv	t1,s7
80001b74:	00378793          	addi	a5,a5,3
80001b78:	ffc7f793          	andi	a5,a5,-4
80001b7c:	00fba023          	sw	a5,0(s7)
	for (i = 0; i < p->n_levels; i++) {
80001b80:	fff88c13          	addi	s8,a7,-1
80001b84:	03c8d463          	bge	a7,t3,80001bac <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
80001b88:	00088c63          	beqz	a7,80001ba0 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001b8c:	ffc32783          	lw	a5,-4(t1)
80001b90:	0027d793          	srli	a5,a5,0x2
80001b94:	00378793          	addi	a5,a5,3
80001b98:	ffc7f793          	andi	a5,a5,-4
80001b9c:	00f32023          	sw	a5,0(t1)
		}

		if (lsizes[i] < size) {
80001ba0:	00430313          	addi	t1,t1,4
80001ba4:	ffc32783          	lw	a5,-4(t1)
80001ba8:	04b7fa63          	bgeu	a5,a1,80001bfc <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80001bac:	fff00793          	li	a5,-1
80001bb0:	04fc1a63          	bne	s8,a5,80001c04 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
80001bb4:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
80001bb8:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80001bbc:	fb040113          	addi	sp,s0,-80
80001bc0:	04c12083          	lw	ra,76(sp)
80001bc4:	04812403          	lw	s0,72(sp)
80001bc8:	04412483          	lw	s1,68(sp)
80001bcc:	04012903          	lw	s2,64(sp)
80001bd0:	03c12983          	lw	s3,60(sp)
80001bd4:	03812a03          	lw	s4,56(sp)
80001bd8:	03412a83          	lw	s5,52(sp)
80001bdc:	03012b03          	lw	s6,48(sp)
80001be0:	02c12b83          	lw	s7,44(sp)
80001be4:	02812c03          	lw	s8,40(sp)
80001be8:	02412c83          	lw	s9,36(sp)
80001bec:	02012d03          	lw	s10,32(sp)
80001bf0:	01c12d83          	lw	s11,28(sp)
80001bf4:	05010113          	addi	sp,sp,80
80001bf8:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
80001bfc:	00188893          	addi	a7,a7,1
80001c00:	f81ff06f          	j	80001b80 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001c04:	01054783          	lbu	a5,16(a0)
		return 0;
80001c08:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001c0c:	0017f793          	andi	a5,a5,1
80001c10:	00078863          	beqz	a5,80001c20 <z_sys_mem_pool_block_alloc+0x10c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001c14:	00800913          	li	s2,8
80001c18:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80001c1c:	00897913          	andi	s2,s2,8
80001c20:	00c00793          	li	a5,12
80001c24:	02fc07b3          	mul	a5,s8,a5
80001c28:	fae42e23          	sw	a4,-68(s0)
80001c2c:	00068d13          	mv	s10,a3
80001c30:	00060c93          	mv	s9,a2
80001c34:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80001c38:	000c0a13          	mv	s4,s8
80001c3c:	00478713          	addi	a4,a5,4
80001c40:	00c52783          	lw	a5,12(a0)
80001c44:	00e787b3          	add	a5,a5,a4
	for (i = alloc_l; i >= 0; i--) {
80001c48:	fff00713          	li	a4,-1
	return list->head == list;
80001c4c:	0007a983          	lw	s3,0(a5)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001c50:	17378c63          	beq	a5,s3,80001dc8 <z_sys_mem_pool_block_alloc+0x2b4>
	node->prev->next = node->next;
80001c54:	0009a783          	lw	a5,0(s3)
80001c58:	0049a703          	lw	a4,4(s3)
		data = block_alloc(p, i, lsizes[i]);
80001c5c:	002a1a93          	slli	s5,s4,0x2
80001c60:	015b8ab3          	add	s5,s7,s5
80001c64:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80001c68:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80001c6c:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001c70:	0009a223          	sw	zero,4(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001c74:	0004a783          	lw	a5,0(s1)
		data = block_alloc(p, i, lsizes[i]);
80001c78:	000aa603          	lw	a2,0(s5)
		clear_free_bit(p, l, block_num(p, block, lsz));
80001c7c:	000a0593          	mv	a1,s4
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001c80:	40f987b3          	sub	a5,s3,a5
		clear_free_bit(p, l, block_num(p, block, lsz));
80001c84:	02c7c633          	div	a2,a5,a2
80001c88:	00048513          	mv	a0,s1
80001c8c:	001a0a13          	addi	s4,s4,1
80001c90:	d4dff0ef          	jal	ra,800019dc <clear_free_bit>
		if (data != NULL) {
80001c94:	00c00693          	li	a3,12
			for (from_l = i; from_l < alloc_l; from_l++) {
80001c98:	fffa0793          	addi	a5,s4,-1
80001c9c:	0587c663          	blt	a5,s8,80001ce8 <z_sys_mem_pool_block_alloc+0x1d4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001ca0:	0104c783          	lbu	a5,16(s1)
80001ca4:	0017f793          	andi	a5,a5,1
80001ca8:	00078463          	beqz	a5,80001cb0 <z_sys_mem_pool_block_alloc+0x19c>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001cac:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80001cb0:	fbc42783          	lw	a5,-68(s0)
		return -ENOMEM;
80001cb4:	ff400513          	li	a0,-12
	*data_p = data;
80001cb8:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80001cbc:	f00980e3          	beqz	s3,80001bbc <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001cc0:	0004a783          	lw	a5,0(s1)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001cc4:	002c1813          	slli	a6,s8,0x2
80001cc8:	010b8bb3          	add	s7,s7,a6
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001ccc:	40f989b3          	sub	s3,s3,a5
80001cd0:	000ba783          	lw	a5,0(s7)
	*level_p = alloc_l;
80001cd4:	018ca023          	sw	s8,0(s9)
	return 0;
80001cd8:	00000513          	li	a0,0
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001cdc:	02f9c9b3          	div	s3,s3,a5
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001ce0:	013d2023          	sw	s3,0(s10)
	return 0;
80001ce4:	ed9ff06f          	j	80001bbc <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001ce8:	0004ad83          	lw	s11,0(s1)
80001cec:	000aa783          	lw	a5,0(s5)
80001cf0:	02da0eb3          	mul	t4,s4,a3
80001cf4:	41b98db3          	sub	s11,s3,s11
	for (i = 1; i < 4; i++) {
80001cf8:	00100713          	li	a4,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001cfc:	02fdcdb3          	div	s11,s11,a5
		int lbn = 4*bn + i;
80001d00:	002d9d93          	slli	s11,s11,0x2
		int lsz = lsizes[l + 1];
80001d04:	004aab03          	lw	s6,4(s5)
		set_free_bit(p, l + 1, lbn);
80001d08:	01b70633          	add	a2,a4,s11
80001d0c:	000a0593          	mv	a1,s4
		void *block2 = (lsz * i) + (char *)block;
80001d10:	02eb0e33          	mul	t3,s6,a4
		set_free_bit(p, l + 1, lbn);
80001d14:	00048513          	mv	a0,s1
80001d18:	fbd42823          	sw	t4,-80(s0)
80001d1c:	fae42c23          	sw	a4,-72(s0)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001d20:	fffb0b13          	addi	s6,s6,-1
		void *block2 = (lsz * i) + (char *)block;
80001d24:	01c98e33          	add	t3,s3,t3
80001d28:	fbc42a23          	sw	t3,-76(s0)
		set_free_bit(p, l + 1, lbn);
80001d2c:	c7dff0ef          	jal	ra,800019a8 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001d30:	fb442e03          	lw	t3,-76(s0)
80001d34:	0004a783          	lw	a5,0(s1)
	return p->n_max * p->max_sz;
80001d38:	0044a603          	lw	a2,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001d3c:	016e0b33          	add	s6,t3,s6
80001d40:	40fb0b33          	sub	s6,s6,a5
	return p->n_max * p->max_sz;
80001d44:	0084d783          	lhu	a5,8(s1)
		if (block_fits(p, block2, lsz)) {
80001d48:	fb842703          	lw	a4,-72(s0)
80001d4c:	fb042e83          	lw	t4,-80(s0)
	return p->n_max * p->max_sz;
80001d50:	02c787b3          	mul	a5,a5,a2
		if (block_fits(p, block2, lsz)) {
80001d54:	00c00693          	li	a3,12
80001d58:	00400893          	li	a7,4
80001d5c:	00800313          	li	t1,8
80001d60:	02fb7463          	bgeu	s6,a5,80001d88 <z_sys_mem_pool_block_alloc+0x274>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001d64:	00c4a783          	lw	a5,12(s1)
80001d68:	01d787b3          	add	a5,a5,t4
80001d6c:	00478613          	addi	a2,a5,4
	node->next = list;
80001d70:	00ce2023          	sw	a2,0(t3) # 80007000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007001>
	node->prev = list->tail;
80001d74:	0087a603          	lw	a2,8(a5)
80001d78:	00ce2223          	sw	a2,4(t3)
	list->tail->next = node;
80001d7c:	0087a603          	lw	a2,8(a5)
80001d80:	01c62023          	sw	t3,0(a2)
	list->tail = node;
80001d84:	01c7a423          	sw	t3,8(a5)
	for (i = 1; i < 4; i++) {
80001d88:	00170713          	addi	a4,a4,1
80001d8c:	f7171ce3          	bne	a4,a7,80001d04 <z_sys_mem_pool_block_alloc+0x1f0>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001d90:	0104c783          	lbu	a5,16(s1)
80001d94:	0017f793          	andi	a5,a5,1
80001d98:	00079a63          	bnez	a5,80001dac <z_sys_mem_pool_block_alloc+0x298>
		return 0;
80001d9c:	00000913          	li	s2,0
80001da0:	001a0a13          	addi	s4,s4,1
80001da4:	004a8a93          	addi	s5,s5,4
80001da8:	ef1ff06f          	j	80001c98 <z_sys_mem_pool_block_alloc+0x184>
80001dac:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001db0:	0104c783          	lbu	a5,16(s1)
80001db4:	0017f793          	andi	a5,a5,1
80001db8:	fe0782e3          	beqz	a5,80001d9c <z_sys_mem_pool_block_alloc+0x288>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001dbc:	30033973          	csrrc	s2,mstatus,t1
	key = (mstatus & SOC_MSTATUS_IEN);
80001dc0:	00897913          	andi	s2,s2,8
80001dc4:	fddff06f          	j	80001da0 <z_sys_mem_pool_block_alloc+0x28c>
	for (i = alloc_l; i >= 0; i--) {
80001dc8:	fffa0a13          	addi	s4,s4,-1
80001dcc:	ff498793          	addi	a5,s3,-12
80001dd0:	e6ea1ee3          	bne	s4,a4,80001c4c <z_sys_mem_pool_block_alloc+0x138>
80001dd4:	00000993          	li	s3,0
80001dd8:	ec9ff06f          	j	80001ca0 <z_sys_mem_pool_block_alloc+0x18c>

80001ddc <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001ddc:	fa010113          	addi	sp,sp,-96
80001de0:	04812c23          	sw	s0,88(sp)
80001de4:	05312623          	sw	s3,76(sp)
80001de8:	03712e23          	sw	s7,60(sp)
80001dec:	04112e23          	sw	ra,92(sp)
80001df0:	04912a23          	sw	s1,84(sp)
80001df4:	05212823          	sw	s2,80(sp)
80001df8:	05412423          	sw	s4,72(sp)
80001dfc:	05512223          	sw	s5,68(sp)
80001e00:	05612023          	sw	s6,64(sp)
80001e04:	03812c23          	sw	s8,56(sp)
80001e08:	03912a23          	sw	s9,52(sp)
80001e0c:	03a12823          	sw	s10,48(sp)
80001e10:	03b12623          	sw	s11,44(sp)
80001e14:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001e18:	00a54683          	lbu	a3,10(a0)
{
80001e1c:	00050b93          	mv	s7,a0
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 1; i <= level; i++) {
80001e20:	00100813          	li	a6,1
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001e24:	00269693          	slli	a3,a3,0x2
80001e28:	00f68693          	addi	a3,a3,15
80001e2c:	7f06f693          	andi	a3,a3,2032
80001e30:	40d10133          	sub	sp,sp,a3
	lsizes[0] = _ALIGN4(p->max_sz);
80001e34:	00452683          	lw	a3,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001e38:	00010993          	mv	s3,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001e3c:	00098513          	mv	a0,s3
80001e40:	00368693          	addi	a3,a3,3
80001e44:	ffc6f693          	andi	a3,a3,-4
80001e48:	00d9a023          	sw	a3,0(s3)
	for (i = 1; i <= level; i++) {
80001e4c:	00450513          	addi	a0,a0,4
80001e50:	0d05f463          	bgeu	a1,a6,80001f18 <z_sys_mem_pool_block_free+0x13c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001e54:	010bc683          	lbu	a3,16(s7)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001e58:	00058c13          	mv	s8,a1
80001e5c:	00060913          	mv	s2,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001e60:	0016f693          	andi	a3,a3,1
		return 0;
80001e64:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001e68:	00068863          	beqz	a3,80001e78 <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001e6c:	00800493          	li	s1,8
80001e70:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80001e74:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80001e78:	80008ab7          	lui	s5,0x80008
		sys_dlist_append(&p->levels[level].free_list, block);
80001e7c:	00c00d13          	li	s10,12
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001e80:	00800d93          	li	s11,8
	while (level >= 0) {
80001e84:	0a0c5863          	bgez	s8,80001f34 <z_sys_mem_pool_block_free+0x158>
	__ASSERT(0, "out of levels");
80001e88:	800084b7          	lui	s1,0x80008
80001e8c:	800085b7          	lui	a1,0x80008
80001e90:	80008537          	lui	a0,0x80008
80001e94:	b4c48613          	addi	a2,s1,-1204 # 80007b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b4d>
80001e98:	0c000693          	li	a3,192
80001e9c:	bb458593          	addi	a1,a1,-1100 # 80007bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bb5>
80001ea0:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80001ea4:	06d000ef          	jal	ra,80002710 <printk>
80001ea8:	80008537          	lui	a0,0x80008
80001eac:	b8050513          	addi	a0,a0,-1152 # 80007b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b81>
80001eb0:	061000ef          	jal	ra,80002710 <printk>
80001eb4:	b4c48513          	addi	a0,s1,-1204
80001eb8:	0c000593          	li	a1,192
80001ebc:	091000ef          	jal	ra,8000274c <assert_post_action>
	return -1;
80001ec0:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001ec4:	010bc783          	lbu	a5,16(s7)
80001ec8:	0017f793          	andi	a5,a5,1
80001ecc:	00078663          	beqz	a5,80001ed8 <z_sys_mem_pool_block_free+0xfc>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001ed0:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ed4:	3004a4f3          	csrrs	s1,mstatus,s1
}
80001ed8:	fa040113          	addi	sp,s0,-96
80001edc:	05c12083          	lw	ra,92(sp)
80001ee0:	05812403          	lw	s0,88(sp)
80001ee4:	05412483          	lw	s1,84(sp)
80001ee8:	05012903          	lw	s2,80(sp)
80001eec:	04c12983          	lw	s3,76(sp)
80001ef0:	04812a03          	lw	s4,72(sp)
80001ef4:	04412a83          	lw	s5,68(sp)
80001ef8:	04012b03          	lw	s6,64(sp)
80001efc:	03c12b83          	lw	s7,60(sp)
80001f00:	03812c03          	lw	s8,56(sp)
80001f04:	03412c83          	lw	s9,52(sp)
80001f08:	03012d03          	lw	s10,48(sp)
80001f0c:	02c12d83          	lw	s11,44(sp)
80001f10:	06010113          	addi	sp,sp,96
80001f14:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001f18:	ffc52683          	lw	a3,-4(a0)
	for (i = 1; i <= level; i++) {
80001f1c:	00180813          	addi	a6,a6,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001f20:	0026d693          	srli	a3,a3,0x2
80001f24:	00368693          	addi	a3,a3,3
80001f28:	ffc6f693          	andi	a3,a3,-4
80001f2c:	00d52023          	sw	a3,0(a0)
80001f30:	f1dff06f          	j	80001e4c <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001f34:	002c1693          	slli	a3,s8,0x2
80001f38:	00d986b3          	add	a3,s3,a3
80001f3c:	0006aa03          	lw	s4,0(a3)
	return p->n_max * p->max_sz;
80001f40:	008bd603          	lhu	a2,8(s7)
80001f44:	004ba583          	lw	a1,4(s7)
	return (u8_t *)p->buf + lsz * block;
80001f48:	034906b3          	mul	a3,s2,s4
		void *block = block_ptr(p, lsz, bn);
80001f4c:	000ba803          	lw	a6,0(s7)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001f50:	fffa0b13          	addi	s6,s4,-1
	return p->n_max * p->max_sz;
80001f54:	02b60633          	mul	a2,a2,a1
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001f58:	00d80cb3          	add	s9,a6,a3
80001f5c:	00db06b3          	add	a3,s6,a3
		__ASSERT(block_fits(p, block, lsz), "");
80001f60:	02c6ec63          	bltu	a3,a2,80001f98 <z_sys_mem_pool_block_free+0x1bc>
80001f64:	800087b7          	lui	a5,0x80008
80001f68:	b6078593          	addi	a1,a5,-1184 # 80007b60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b61>
80001f6c:	800087b7          	lui	a5,0x80008
80001f70:	af878513          	addi	a0,a5,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80001f74:	0a400693          	li	a3,164
80001f78:	b4ca8613          	addi	a2,s5,-1204 # 80007b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b4d>
80001f7c:	794000ef          	jal	ra,80002710 <printk>
80001f80:	800087b7          	lui	a5,0x80008
80001f84:	b7c78513          	addi	a0,a5,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80001f88:	788000ef          	jal	ra,80002710 <printk>
80001f8c:	0a400593          	li	a1,164
80001f90:	b4ca8513          	addi	a0,s5,-1204
80001f94:	7b8000ef          	jal	ra,8000274c <assert_post_action>
		set_free_bit(p, level, bn);
80001f98:	00090613          	mv	a2,s2
80001f9c:	000c0593          	mv	a1,s8
80001fa0:	000b8513          	mv	a0,s7
80001fa4:	a05ff0ef          	jal	ra,800019a8 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80001fa8:	03ac06b3          	mul	a3,s8,s10
80001fac:	00cba603          	lw	a2,12(s7)
80001fb0:	00d606b3          	add	a3,a2,a3
80001fb4:	00468613          	addi	a2,a3,4
	node->next = list;
80001fb8:	00cca023          	sw	a2,0(s9)
	node->prev = list->tail;
80001fbc:	0086a603          	lw	a2,8(a3)
80001fc0:	00cca223          	sw	a2,4(s9)
	list->tail->next = node;
80001fc4:	0086a603          	lw	a2,8(a3)
80001fc8:	01962023          	sw	s9,0(a2)
	list->tail = node;
80001fcc:	0196a423          	sw	s9,8(a3)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001fd0:	010bc683          	lbu	a3,16(s7)
80001fd4:	0016f693          	andi	a3,a3,1
80001fd8:	0c069463          	bnez	a3,800020a0 <z_sys_mem_pool_block_free+0x2c4>
		return 0;
80001fdc:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001fe0:	ee0c02e3          	beqz	s8,80001ec4 <z_sys_mem_pool_block_free+0xe8>
	int bit = get_bit_ptr(p, level, bn, &word);
80001fe4:	fbc40693          	addi	a3,s0,-68
80001fe8:	00090613          	mv	a2,s2
80001fec:	000c0593          	mv	a1,s8
80001ff0:	000b8513          	mv	a0,s7
80001ff4:	97dff0ef          	jal	ra,80001970 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80001ff8:	00400693          	li	a3,4
80001ffc:	02d546b3          	div	a3,a0,a3
80002000:	fbc42603          	lw	a2,-68(s0)
80002004:	00062503          	lw	a0,0(a2)
80002008:	00269693          	slli	a3,a3,0x2
8000200c:	00d55533          	srl	a0,a0,a3
80002010:	00f57513          	andi	a0,a0,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80002014:	00f00693          	li	a3,15
80002018:	ead516e3          	bne	a0,a3,80001ec4 <z_sys_mem_pool_block_free+0xe8>
		for (i = 0; i < 4; i++) {
8000201c:	00000813          	li	a6,0
			int b = (bn & ~3) + i;
80002020:	ffc97e13          	andi	t3,s2,-4
		for (i = 0; i < 4; i++) {
80002024:	00400313          	li	t1,4
	return p->n_max * p->max_sz;
80002028:	008bd583          	lhu	a1,8(s7)
8000202c:	004ba503          	lw	a0,4(s7)
			int b = (bn & ~3) + i;
80002030:	010e0633          	add	a2,t3,a6
	return (u8_t *)p->buf + lsz * block;
80002034:	034608b3          	mul	a7,a2,s4
	return p->n_max * p->max_sz;
80002038:	02a585b3          	mul	a1,a1,a0
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
8000203c:	016886b3          	add	a3,a7,s6
80002040:	04b6f663          	bgeu	a3,a1,8000208c <z_sys_mem_pool_block_free+0x2b0>
				clear_free_bit(p, level, b);
80002044:	000c0593          	mv	a1,s8
80002048:	000b8513          	mv	a0,s7
8000204c:	fbc42223          	sw	t3,-92(s0)
80002050:	fb042423          	sw	a6,-88(s0)
80002054:	fb142623          	sw	a7,-84(s0)
80002058:	985ff0ef          	jal	ra,800019dc <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
8000205c:	000ba683          	lw	a3,0(s7)
80002060:	fac42883          	lw	a7,-84(s0)
	node->prev = NULL;
80002064:	fa442e03          	lw	t3,-92(s0)
80002068:	fa842803          	lw	a6,-88(s0)
8000206c:	011686b3          	add	a3,a3,a7
	node->prev->next = node->next;
80002070:	0046a583          	lw	a1,4(a3)
80002074:	0006a603          	lw	a2,0(a3)
	node->prev = NULL;
80002078:	00400313          	li	t1,4
	node->prev->next = node->next;
8000207c:	00c5a023          	sw	a2,0(a1)
	node->next->prev = node->prev;
80002080:	00b62223          	sw	a1,4(a2)
	node->next = NULL;
80002084:	0006a023          	sw	zero,0(a3)
	node->prev = NULL;
80002088:	0006a223          	sw	zero,4(a3)
		for (i = 0; i < 4; i++) {
8000208c:	00180813          	addi	a6,a6,1
80002090:	f8681ce3          	bne	a6,t1,80002028 <z_sys_mem_pool_block_free+0x24c>
		level = level - 1;
80002094:	fffc0c13          	addi	s8,s8,-1
		bn = bn / 4;
80002098:	03094933          	div	s2,s2,a6
8000209c:	de9ff06f          	j	80001e84 <z_sys_mem_pool_block_free+0xa8>
800020a0:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800020a4:	010bc683          	lbu	a3,16(s7)
800020a8:	0016f693          	andi	a3,a3,1
800020ac:	f20688e3          	beqz	a3,80001fdc <z_sys_mem_pool_block_free+0x200>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800020b0:	300db4f3          	csrrc	s1,mstatus,s11
	key = (mstatus & SOC_MSTATUS_IEN);
800020b4:	0084f493          	andi	s1,s1,8
800020b8:	f29ff06f          	j	80001fe0 <z_sys_mem_pool_block_free+0x204>

800020bc <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
800020bc:	ff010113          	addi	sp,sp,-16
800020c0:	00050793          	mv	a5,a0
800020c4:	00058513          	mv	a0,a1
800020c8:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
800020cc:	00068613          	mv	a2,a3
{
800020d0:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
800020d4:	000780e7          	jalr	a5
800020d8:	218030ef          	jal	ra,800052f0 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800020dc:	269030ef          	jal	ra,80005b44 <z_impl_k_thread_abort>

800020e0 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
800020e0:	00000513          	li	a0,0
800020e4:	00008067          	ret

800020e8 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
800020e8:	ff010113          	addi	sp,sp,-16
800020ec:	00812423          	sw	s0,8(sp)
800020f0:	00050413          	mv	s0,a0
	out('E', ctx);
800020f4:	04500513          	li	a0,69
{
800020f8:	00112623          	sw	ra,12(sp)
800020fc:	00912223          	sw	s1,4(sp)
80002100:	00058493          	mv	s1,a1
	out('E', ctx);
80002104:	000400e7          	jalr	s0
	out('R', ctx);
80002108:	00048593          	mv	a1,s1
8000210c:	05200513          	li	a0,82
80002110:	000400e7          	jalr	s0
	out('R', ctx);
80002114:	00040313          	mv	t1,s0
}
80002118:	00812403          	lw	s0,8(sp)
8000211c:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80002120:	00048593          	mv	a1,s1
}
80002124:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80002128:	05200513          	li	a0,82
}
8000212c:	01010113          	addi	sp,sp,16
	out('R', ctx);
80002130:	00030067          	jr	t1

80002134 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80002134:	0005a783          	lw	a5,0(a1)
80002138:	00178793          	addi	a5,a5,1
8000213c:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80002140:	800087b7          	lui	a5,0x80008
80002144:	2607a303          	lw	t1,608(a5) # 80008260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008261>
80002148:	00030067          	jr	t1

8000214c <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
8000214c:	fb010113          	addi	sp,sp,-80
80002150:	04812423          	sw	s0,72(sp)
80002154:	03312e23          	sw	s3,60(sp)
80002158:	03412c23          	sw	s4,56(sp)
8000215c:	03512a23          	sw	s5,52(sp)
80002160:	03612823          	sw	s6,48(sp)
80002164:	04112623          	sw	ra,76(sp)
80002168:	04912223          	sw	s1,68(sp)
8000216c:	05212023          	sw	s2,64(sp)
80002170:	03712623          	sw	s7,44(sp)
80002174:	03812423          	sw	s8,40(sp)
80002178:	03912223          	sw	s9,36(sp)
8000217c:	03a12023          	sw	s10,32(sp)
80002180:	01b12e23          	sw	s11,28(sp)
80002184:	00050a13          	mv	s4,a0
80002188:	00058a93          	mv	s5,a1
8000218c:	00060993          	mv	s3,a2
80002190:	00068b13          	mv	s6,a3
80002194:	00100413          	li	s0,1
80002198:	00e05463          	blez	a4,800021a0 <_printk_dec_ulong+0x54>
8000219c:	00070413          	mv	s0,a4
800021a0:	00100793          	li	a5,1
800021a4:	02000c13          	li	s8,32
800021a8:	00fb1463          	bne	s6,a5,800021b0 <_printk_dec_ulong+0x64>
800021ac:	03000c13          	li	s8,48
800021b0:	3b9ad4b7          	lui	s1,0x3b9ad
800021b4:	00100913          	li	s2,1
800021b8:	00a00c93          	li	s9,10
800021bc:	00000713          	li	a4,0
800021c0:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
800021c4:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
800021c8:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
800021cc:	00148b93          	addi	s7,s1,1
800021d0:	00071463          	bnez	a4,800021d8 <_printk_dec_ulong+0x8c>
800021d4:	0934f263          	bgeu	s1,s3,80002258 <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
800021d8:	0379d533          	divu	a0,s3,s7
800021dc:	000a8593          	mv	a1,s5
			digits++;
800021e0:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
800021e4:	03050513          	addi	a0,a0,48
800021e8:	000a00e7          	jalr	s4
			found_largest_digit = 1;
800021ec:	00100713          	li	a4,1
		remaining--;
800021f0:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
800021f4:	00100793          	li	a5,1
		remainder %= (pos + 1);
800021f8:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
800021fc:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
80002200:	fcfc96e3          	bne	s9,a5,800021cc <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
80002204:	000a8593          	mv	a1,s5
80002208:	03098513          	addi	a0,s3,48
8000220c:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
80002210:	00300793          	li	a5,3
		remaining = min_width - digits;
80002214:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80002218:	06fb0a63          	beq	s6,a5,8000228c <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
8000221c:	04c12083          	lw	ra,76(sp)
80002220:	04812403          	lw	s0,72(sp)
80002224:	04412483          	lw	s1,68(sp)
80002228:	04012903          	lw	s2,64(sp)
8000222c:	03c12983          	lw	s3,60(sp)
80002230:	03812a03          	lw	s4,56(sp)
80002234:	03412a83          	lw	s5,52(sp)
80002238:	03012b03          	lw	s6,48(sp)
8000223c:	02c12b83          	lw	s7,44(sp)
80002240:	02812c03          	lw	s8,40(sp)
80002244:	02412c83          	lw	s9,36(sp)
80002248:	02012d03          	lw	s10,32(sp)
8000224c:	01c12d83          	lw	s11,28(sp)
80002250:	05010113          	addi	sp,sp,80
80002254:	00008067          	ret
		} else if (remaining <= min_width
80002258:	f9944ce3          	blt	s0,s9,800021f0 <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
8000225c:	f96deae3          	bltu	s11,s6,800021f0 <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80002260:	000a8593          	mv	a1,s5
80002264:	000c0513          	mv	a0,s8
80002268:	00e12623          	sw	a4,12(sp)
8000226c:	000a00e7          	jalr	s4
			digits++;
80002270:	00190913          	addi	s2,s2,1
80002274:	00c12703          	lw	a4,12(sp)
80002278:	f79ff06f          	j	800021f0 <_printk_dec_ulong+0xa4>
			out(' ', ctx);
8000227c:	000a8593          	mv	a1,s5
80002280:	02000513          	li	a0,32
80002284:	000a00e7          	jalr	s4
80002288:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
8000228c:	fe8048e3          	bgtz	s0,8000227c <_printk_dec_ulong+0x130>
80002290:	f8dff06f          	j	8000221c <_printk_dec_ulong+0xd0>

80002294 <__printk_hook_install>:
	_char_out = fn;
80002294:	800087b7          	lui	a5,0x80008
80002298:	26a7a023          	sw	a0,608(a5) # 80008260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008261>
}
8000229c:	00008067          	ret

800022a0 <z_vprintk>:
{
800022a0:	fb010113          	addi	sp,sp,-80
800022a4:	04812423          	sw	s0,72(sp)
800022a8:	04912223          	sw	s1,68(sp)
800022ac:	05212023          	sw	s2,64(sp)
800022b0:	03312e23          	sw	s3,60(sp)
800022b4:	03412c23          	sw	s4,56(sp)
800022b8:	03512a23          	sw	s5,52(sp)
800022bc:	03912223          	sw	s9,36(sp)
800022c0:	03a12023          	sw	s10,32(sp)
800022c4:	01b12e23          	sw	s11,28(sp)
800022c8:	04112623          	sw	ra,76(sp)
800022cc:	03612823          	sw	s6,48(sp)
800022d0:	03712623          	sw	s7,44(sp)
800022d4:	03812423          	sw	s8,40(sp)
800022d8:	00050413          	mv	s0,a0
800022dc:	00058493          	mv	s1,a1
800022e0:	00060a93          	mv	s5,a2
800022e4:	00068d13          	mv	s10,a3
	int long_ctr = 0;
800022e8:	00000a13          	li	s4,0
	int min_width = -1;
800022ec:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
800022f0:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800022f4:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
800022f8:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800022fc:	000ac503          	lbu	a0,0(s5)
80002300:	04051063          	bnez	a0,80002340 <z_vprintk+0xa0>
}
80002304:	04c12083          	lw	ra,76(sp)
80002308:	04812403          	lw	s0,72(sp)
8000230c:	04412483          	lw	s1,68(sp)
80002310:	04012903          	lw	s2,64(sp)
80002314:	03c12983          	lw	s3,60(sp)
80002318:	03812a03          	lw	s4,56(sp)
8000231c:	03412a83          	lw	s5,52(sp)
80002320:	03012b03          	lw	s6,48(sp)
80002324:	02c12b83          	lw	s7,44(sp)
80002328:	02812c03          	lw	s8,40(sp)
8000232c:	02412c83          	lw	s9,36(sp)
80002330:	02012d03          	lw	s10,32(sp)
80002334:	01c12d83          	lw	s11,28(sp)
80002338:	05010113          	addi	sp,sp,80
8000233c:	00008067          	ret
		if (!might_format) {
80002340:	000c9e63          	bnez	s9,8000235c <z_vprintk+0xbc>
			if (*fmt != '%') {
80002344:	02500693          	li	a3,37
80002348:	36d50a63          	beq	a0,a3,800026bc <z_vprintk+0x41c>
				out((int)*fmt, ctx);
8000234c:	00048593          	mv	a1,s1
80002350:	000400e7          	jalr	s0
		++fmt;
80002354:	001a8a93          	addi	s5,s5,1
80002358:	fa5ff06f          	j	800022fc <z_vprintk+0x5c>
			switch (*fmt) {
8000235c:	06400693          	li	a3,100
80002360:	10d50e63          	beq	a0,a3,8000247c <z_vprintk+0x1dc>
80002364:	06a6e263          	bltu	a3,a0,800023c8 <z_vprintk+0x128>
80002368:	03900693          	li	a3,57
8000236c:	02a6ea63          	bltu	a3,a0,800023a0 <z_vprintk+0x100>
80002370:	03100693          	li	a3,49
80002374:	0ed57463          	bgeu	a0,a3,8000245c <z_vprintk+0x1bc>
80002378:	02d00693          	li	a3,45
8000237c:	34d50a63          	beq	a0,a3,800026d0 <z_vprintk+0x430>
80002380:	03000793          	li	a5,48
80002384:	0cf50063          	beq	a0,a5,80002444 <z_vprintk+0x1a4>
80002388:	02500713          	li	a4,37
8000238c:	02e51263          	bne	a0,a4,800023b0 <z_vprintk+0x110>
				out((int)'%', ctx);
80002390:	00048593          	mv	a1,s1
80002394:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80002398:	000400e7          	jalr	s0
				break;
8000239c:	15c0006f          	j	800024f8 <z_vprintk+0x258>
800023a0:	05800693          	li	a3,88
800023a4:	1ad50e63          	beq	a0,a3,80002560 <z_vprintk+0x2c0>
800023a8:	06300713          	li	a4,99
800023ac:	2ee50e63          	beq	a0,a4,800026a8 <z_vprintk+0x408>
				out((int)'%', ctx);
800023b0:	00048593          	mv	a1,s1
800023b4:	02500513          	li	a0,37
800023b8:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
800023bc:	00048593          	mv	a1,s1
800023c0:	000ac503          	lbu	a0,0(s5)
800023c4:	fd5ff06f          	j	80002398 <z_vprintk+0xf8>
800023c8:	07000693          	li	a3,112
800023cc:	16d50a63          	beq	a0,a3,80002540 <z_vprintk+0x2a0>
800023d0:	02a6e063          	bltu	a3,a0,800023f0 <z_vprintk+0x150>
800023d4:	06900693          	li	a3,105
800023d8:	0ad50263          	beq	a0,a3,8000247c <z_vprintk+0x1dc>
800023dc:	06c00693          	li	a3,108
800023e0:	08d50a63          	beq	a0,a3,80002474 <z_vprintk+0x1d4>
800023e4:	06800693          	li	a3,104
800023e8:	f6d506e3          	beq	a0,a3,80002354 <z_vprintk+0xb4>
800023ec:	fc5ff06f          	j	800023b0 <z_vprintk+0x110>
800023f0:	07500693          	li	a3,117
800023f4:	10d50663          	beq	a0,a3,80002500 <z_vprintk+0x260>
800023f8:	02a6ee63          	bltu	a3,a0,80002434 <z_vprintk+0x194>
800023fc:	07300713          	li	a4,115
80002400:	fae518e3          	bne	a0,a4,800023b0 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80002404:	000d2c03          	lw	s8,0(s10)
80002408:	004d0b13          	addi	s6,s10,4
8000240c:	000c0b93          	mv	s7,s8
				while (*s)
80002410:	000bc503          	lbu	a0,0(s7)
80002414:	26051863          	bnez	a0,80002684 <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
80002418:	00300793          	li	a5,3
8000241c:	00f99863          	bne	s3,a5,8000242c <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80002420:	418b8bb3          	sub	s7,s7,s8
80002424:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80002428:	27704663          	bgtz	s7,80002694 <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
8000242c:	000b0d13          	mv	s10,s6
80002430:	0c80006f          	j	800024f8 <z_vprintk+0x258>
80002434:	07800693          	li	a3,120
80002438:	12d50463          	beq	a0,a3,80002560 <z_vprintk+0x2c0>
8000243c:	07a00693          	li	a3,122
80002440:	fa9ff06f          	j	800023e8 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80002444:	00095e63          	bgez	s2,80002460 <z_vprintk+0x1c0>
80002448:	28098863          	beqz	s3,800026d8 <z_vprintk+0x438>
					min_width = *fmt - '0';
8000244c:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80002450:	f00992e3          	bnez	s3,80002354 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80002454:	00200993          	li	s3,2
80002458:	efdff06f          	j	80002354 <z_vprintk+0xb4>
				if (min_width < 0) {
8000245c:	fe0948e3          	bltz	s2,8000244c <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80002460:	00a00693          	li	a3,10
80002464:	02d90933          	mul	s2,s2,a3
80002468:	fd090913          	addi	s2,s2,-48
8000246c:	01250933          	add	s2,a0,s2
80002470:	fe1ff06f          	j	80002450 <z_vprintk+0x1b0>
				long_ctr++;
80002474:	001a0a13          	addi	s4,s4,1
80002478:	eddff06f          	j	80002354 <z_vprintk+0xb4>
				if (long_ctr == 0) {
8000247c:	040a1263          	bnez	s4,800024c0 <z_vprintk+0x220>
					long ld = va_arg(ap, long);
80002480:	000d2603          	lw	a2,0(s10)
80002484:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80002488:	02065063          	bgez	a2,800024a8 <z_vprintk+0x208>
					out((int)'-', ctx);
8000248c:	00048593          	mv	a1,s1
80002490:	02d00513          	li	a0,45
80002494:	00c12023          	sw	a2,0(sp)
80002498:	000400e7          	jalr	s0
					d = -d;
8000249c:	00012603          	lw	a2,0(sp)
					min_width--;
800024a0:	fff90913          	addi	s2,s2,-1
					d = -d;
800024a4:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
800024a8:	00090713          	mv	a4,s2
800024ac:	00098693          	mv	a3,s3
800024b0:	00048593          	mv	a1,s1
800024b4:	00040513          	mv	a0,s0
800024b8:	c95ff0ef          	jal	ra,8000214c <_printk_dec_ulong>
				break;
800024bc:	03c0006f          	j	800024f8 <z_vprintk+0x258>
				} else if (long_ctr == 1) {
800024c0:	00100713          	li	a4,1
800024c4:	faea0ee3          	beq	s4,a4,80002480 <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
800024c8:	007d0793          	addi	a5,s10,7
800024cc:	ff87f713          	andi	a4,a5,-8
800024d0:	00072603          	lw	a2,0(a4)
800024d4:	00472683          	lw	a3,4(a4)
800024d8:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
800024dc:	01b60733          	add	a4,a2,s11
800024e0:	00c73733          	sltu	a4,a4,a2
800024e4:	00d70733          	add	a4,a4,a3
800024e8:	fa0700e3          	beqz	a4,80002488 <z_vprintk+0x1e8>
						print_err(out, ctx);
800024ec:	00048593          	mv	a1,s1
800024f0:	00040513          	mv	a0,s0
800024f4:	bf5ff0ef          	jal	ra,800020e8 <print_err>
			might_format = 0;
800024f8:	00000c93          	li	s9,0
800024fc:	e59ff06f          	j	80002354 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80002500:	000a1863          	bnez	s4,80002510 <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
80002504:	000d2603          	lw	a2,0(s10)
80002508:	004d0d13          	addi	s10,s10,4
8000250c:	f9dff06f          	j	800024a8 <z_vprintk+0x208>
				} else if (long_ctr == 1) {
80002510:	00100713          	li	a4,1
80002514:	feea08e3          	beq	s4,a4,80002504 <z_vprintk+0x264>
					unsigned long long llu =
80002518:	007d0793          	addi	a5,s10,7
8000251c:	ff87f713          	andi	a4,a5,-8
80002520:	00870d13          	addi	s10,a4,8
80002524:	00072603          	lw	a2,0(a4)
80002528:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
8000252c:	fc0710e3          	bnez	a4,800024ec <z_vprintk+0x24c>
80002530:	800007b7          	lui	a5,0x80000
80002534:	fff7c793          	not	a5,a5
80002538:	f6c7f8e3          	bgeu	a5,a2,800024a8 <z_vprintk+0x208>
8000253c:	fb1ff06f          	j	800024ec <z_vprintk+0x24c>
				  out('0', ctx);
80002540:	00048593          	mv	a1,s1
80002544:	03000513          	li	a0,48
80002548:	000400e7          	jalr	s0
				  out('x', ctx);
8000254c:	00048593          	mv	a1,s1
80002550:	07800513          	li	a0,120
80002554:	000400e7          	jalr	s0
				  min_width = 8;
80002558:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
8000255c:	00100993          	li	s3,1
				if (long_ctr < 2) {
80002560:	00100693          	li	a3,1
80002564:	0b46c263          	blt	a3,s4,80002608 <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
80002568:	000d2783          	lw	a5,0(s10)
8000256c:	00012423          	sw	zero,8(sp)
80002570:	004d0d13          	addi	s10,s10,4
80002574:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80002578:	01000c13          	li	s8,16
	int digits = 0;
8000257c:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80002580:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80002584:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80002588:	00412503          	lw	a0,4(sp)
8000258c:	00812583          	lw	a1,8(sp)
80002590:	fff88b13          	addi	s6,a7,-1
80002594:	002b1613          	slli	a2,s6,0x2
80002598:	01112623          	sw	a7,12(sp)
8000259c:	cedfd0ef          	jal	ra,80000288 <__lshrdi3>
800025a0:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800025a4:	08051863          	bnez	a0,80002634 <z_vprintk+0x394>
800025a8:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
800025ac:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800025b0:	00079863          	bnez	a5,800025c0 <z_vprintk+0x320>
800025b4:	00c12883          	lw	a7,12(sp)
800025b8:	00100793          	li	a5,1
800025bc:	08f89663          	bne	a7,a5,80002648 <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
800025c0:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
800025c4:	01851513          	slli	a0,a0,0x18
800025c8:	00048593          	mv	a1,s1
800025cc:	41855513          	srai	a0,a0,0x18
800025d0:	000400e7          	jalr	s0
			digits++;
800025d4:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
800025d8:	040b1863          	bnez	s6,80002628 <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
800025dc:	00300693          	li	a3,3
			might_format = 0;
800025e0:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800025e4:	d6d998e3          	bne	s3,a3,80002354 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
800025e8:	00191713          	slli	a4,s2,0x1
800025ec:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800025f0:	f17054e3          	blez	s7,800024f8 <z_vprintk+0x258>
			out(' ', ctx);
800025f4:	00048593          	mv	a1,s1
800025f8:	02000513          	li	a0,32
800025fc:	000400e7          	jalr	s0
80002600:	fffb8b93          	addi	s7,s7,-1
80002604:	fedff06f          	j	800025f0 <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
80002608:	007d0793          	addi	a5,s10,7
8000260c:	ff87f693          	andi	a3,a5,-8
80002610:	0006a783          	lw	a5,0(a3)
80002614:	00868d13          	addi	s10,a3,8
80002618:	00f12223          	sw	a5,4(sp)
8000261c:	0046a783          	lw	a5,4(a3)
80002620:	00f12423          	sw	a5,8(sp)
80002624:	f55ff06f          	j	80002578 <z_vprintk+0x2d8>
			found_largest_digit = 1;
80002628:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
8000262c:	000b0893          	mv	a7,s6
80002630:	f59ff06f          	j	80002588 <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
80002634:	00900793          	li	a5,9
80002638:	05700693          	li	a3,87
8000263c:	f8a7e2e3          	bltu	a5,a0,800025c0 <z_vprintk+0x320>
80002640:	03000693          	li	a3,48
80002644:	f7dff06f          	j	800025c0 <z_vprintk+0x320>
		if (remaining-- <= min_width) {
80002648:	fffc0793          	addi	a5,s8,-1
8000264c:	00f12623          	sw	a5,12(sp)
80002650:	01894c63          	blt	s2,s8,80002668 <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
80002654:	00100793          	li	a5,1
80002658:	00f99c63          	bne	s3,a5,80002670 <z_vprintk+0x3d0>
				out('0', ctx);
8000265c:	00048593          	mv	a1,s1
80002660:	03000513          	li	a0,48
				out(' ', ctx);
80002664:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80002668:	00c12c03          	lw	s8,12(sp)
8000266c:	fc1ff06f          	j	8000262c <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
80002670:	00200793          	li	a5,2
80002674:	fef99ae3          	bne	s3,a5,80002668 <z_vprintk+0x3c8>
				out(' ', ctx);
80002678:	00048593          	mv	a1,s1
8000267c:	02000513          	li	a0,32
80002680:	fe5ff06f          	j	80002664 <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
80002684:	00048593          	mv	a1,s1
80002688:	001b8b93          	addi	s7,s7,1
8000268c:	000400e7          	jalr	s0
80002690:	d81ff06f          	j	80002410 <z_vprintk+0x170>
						out(' ', ctx);
80002694:	00048593          	mv	a1,s1
80002698:	02000513          	li	a0,32
8000269c:	000400e7          	jalr	s0
800026a0:	fffb8b93          	addi	s7,s7,-1
800026a4:	d85ff06f          	j	80002428 <z_vprintk+0x188>
				out(c, ctx);
800026a8:	000d2503          	lw	a0,0(s10)
800026ac:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
800026b0:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
800026b4:	000400e7          	jalr	s0
				break;
800026b8:	d75ff06f          	j	8000242c <z_vprintk+0x18c>
				long_ctr = 0;
800026bc:	00000a13          	li	s4,0
				min_width = -1;
800026c0:	fff00913          	li	s2,-1
				padding = PAD_NONE;
800026c4:	00000993          	li	s3,0
				might_format = 1;
800026c8:	00100c93          	li	s9,1
800026cc:	c89ff06f          	j	80002354 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
800026d0:	00300993          	li	s3,3
800026d4:	c81ff06f          	j	80002354 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
800026d8:	00100993          	li	s3,1
800026dc:	c79ff06f          	j	80002354 <z_vprintk+0xb4>

800026e0 <vprintk>:
{
800026e0:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
800026e4:	00050613          	mv	a2,a0
800026e8:	80002537          	lui	a0,0x80002
800026ec:	00058693          	mv	a3,a1
800026f0:	13450513          	addi	a0,a0,308 # 80002134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002135>
800026f4:	00c10593          	addi	a1,sp,12
{
800026f8:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800026fc:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80002700:	ba1ff0ef          	jal	ra,800022a0 <z_vprintk>
}
80002704:	01c12083          	lw	ra,28(sp)
80002708:	02010113          	addi	sp,sp,32
8000270c:	00008067          	ret

80002710 <printk>:
{
80002710:	fc010113          	addi	sp,sp,-64
80002714:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80002718:	02410593          	addi	a1,sp,36
{
8000271c:	00112e23          	sw	ra,28(sp)
80002720:	02c12423          	sw	a2,40(sp)
80002724:	02d12623          	sw	a3,44(sp)
80002728:	02e12823          	sw	a4,48(sp)
8000272c:	02f12a23          	sw	a5,52(sp)
80002730:	03012c23          	sw	a6,56(sp)
80002734:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80002738:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
8000273c:	fa5ff0ef          	jal	ra,800026e0 <vprintk>
}
80002740:	01c12083          	lw	ra,28(sp)
80002744:	04010113          	addi	sp,sp,64
80002748:	00008067          	ret

8000274c <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
8000274c:	800085b7          	lui	a1,0x80008
80002750:	80008537          	lui	a0,0x80008
{
80002754:	ff010113          	addi	sp,sp,-16
  k_panic();
80002758:	b9058593          	addi	a1,a1,-1136 # 80007b90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b91>
8000275c:	ba450513          	addi	a0,a0,-1116 # 80007ba4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ba5>
80002760:	01e00613          	li	a2,30
{
80002764:	00112623          	sw	ra,12(sp)
  k_panic();
80002768:	fa9ff0ef          	jal	ra,80002710 <printk>
8000276c:	800075b7          	lui	a1,0x80007
80002770:	77058593          	addi	a1,a1,1904 # 80007770 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007771>
80002774:	00600513          	li	a0,6
80002778:	ea5fe0ef          	jal	ra,8000161c <z_NanoFatalErrorHandler>

8000277c <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
8000277c:	00008067          	ret

80002780 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002780:	00800793          	li	a5,8
80002784:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80002788:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
8000278c:	00008067          	ret

80002790 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80002790:	00100793          	li	a5,1
80002794:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80002798:	30452573          	csrrs	a0,mie,a0
}
8000279c:	00008067          	ret

800027a0 <z_arch_irq_disable>:
	 * Use atomic instruction csrrc to disable device interrupt in mie CSR.
	 * (atomic read and clear bits in CSR register)
	 */
	__asm__ volatile ("csrrc %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
800027a0:	00100793          	li	a5,1
800027a4:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrc %0, mie, %1\n"
800027a8:	30453573          	csrrc	a0,mie,a0
};
800027ac:	00008067          	ret

800027b0 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800027b0:	00800793          	li	a5,8
800027b4:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
800027b8:	30405073          	csrwi	mie,0
800027bc:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
800027c0:	00008067          	ret

800027c4 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
800027c4:	ff010113          	addi	sp,sp,-16
800027c8:	00812423          	sw	s0,8(sp)
800027cc:	00912223          	sw	s1,4(sp)
800027d0:	80008437          	lui	s0,0x80008
800027d4:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
800027d8:	00a00793          	li	a5,10
{
800027dc:	00050493          	mv	s1,a0
800027e0:	2dc40413          	addi	s0,s0,732 # 800082dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082dd>
	if ('\n' == c) {
800027e4:	00f51c63          	bne	a0,a5,800027fc <console_out+0x38>
800027e8:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
800027ec:	00d00593          	li	a1,13
800027f0:	00452783          	lw	a5,4(a0)
800027f4:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
800027f8:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
800027fc:	00042503          	lw	a0,0(s0)
80002800:	0ff4f593          	andi	a1,s1,255
80002804:	00452783          	lw	a5,4(a0)
80002808:	0047a783          	lw	a5,4(a5)
8000280c:	000780e7          	jalr	a5

	return c;
}
80002810:	00c12083          	lw	ra,12(sp)
80002814:	00812403          	lw	s0,8(sp)
80002818:	00048513          	mv	a0,s1
8000281c:	00412483          	lw	s1,4(sp)
80002820:	01010113          	addi	sp,sp,16
80002824:	00008067          	ret

80002828 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80002828:	ff010113          	addi	sp,sp,-16
8000282c:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80002830:	80002437          	lui	s0,0x80002
80002834:	7c440513          	addi	a0,s0,1988 # 800027c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800027c5>
{
80002838:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
8000283c:	5cc000ef          	jal	ra,80002e08 <__stdout_hook_install>
	__printk_hook_install(console_out);
80002840:	7c440513          	addi	a0,s0,1988
}
80002844:	00812403          	lw	s0,8(sp)
80002848:	00c12083          	lw	ra,12(sp)
8000284c:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80002850:	a45ff06f          	j	80002294 <__printk_hook_install>

80002854 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80002854:	80008537          	lui	a0,0x80008
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80002858:	ff010113          	addi	sp,sp,-16
8000285c:	bb050513          	addi	a0,a0,-1104 # 80007bb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bb1>
80002860:	00112623          	sw	ra,12(sp)
80002864:	17d000ef          	jal	ra,800031e0 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80002868:	800087b7          	lui	a5,0x80008
8000286c:	2ca7ae23          	sw	a0,732(a5) # 800082dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082dd>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80002870:	fb9ff0ef          	jal	ra,80002828 <uart_console_hook_install>

	return 0;
}
80002874:	00c12083          	lw	ra,12(sp)
80002878:	00000513          	li	a0,0
8000287c:	01010113          	addi	sp,sp,16
80002880:	00008067          	ret

80002884 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80002884:	f01007b7          	lui	a5,0xf0100
80002888:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
8000288c:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80002890:	f447a583          	lw	a1,-188(a5)
80002894:	fee59ae3          	bne	a1,a4,80002888 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80002898:	00008067          	ret

8000289c <timer_isr>:

static void timer_isr(void *arg)
{
8000289c:	fe010113          	addi	sp,sp,-32
800028a0:	00812c23          	sw	s0,24(sp)
800028a4:	00112e23          	sw	ra,28(sp)
800028a8:	00912a23          	sw	s1,20(sp)
800028ac:	01212823          	sw	s2,16(sp)
800028b0:	01312623          	sw	s3,12(sp)
800028b4:	01412423          	sw	s4,8(sp)
800028b8:	01512223          	sw	s5,4(sp)
800028bc:	00800413          	li	s0,8
800028c0:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800028c4:	80008937          	lui	s2,0x80008
800028c8:	2e090513          	addi	a0,s2,736 # 800082e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e1>
	key = (mstatus & SOC_MSTATUS_IEN);
800028cc:	00847413          	andi	s0,s0,8
800028d0:	70d020ef          	jal	ra,800057dc <z_spin_lock_valid>
800028d4:	02051e63          	bnez	a0,80002910 <timer_isr+0x74>
800028d8:	800084b7          	lui	s1,0x80008
800028dc:	800085b7          	lui	a1,0x80008
800028e0:	80008537          	lui	a0,0x80008
800028e4:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800028e8:	04e00693          	li	a3,78
800028ec:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800028f0:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800028f4:	e1dff0ef          	jal	ra,80002710 <printk>
800028f8:	80008537          	lui	a0,0x80008
800028fc:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80002900:	e11ff0ef          	jal	ra,80002710 <printk>
80002904:	04e00593          	li	a1,78
80002908:	bc448513          	addi	a0,s1,-1084
8000290c:	e41ff0ef          	jal	ra,8000274c <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80002910:	2e090513          	addi	a0,s2,736
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002914:	800084b7          	lui	s1,0x80008
80002918:	71d020ef          	jal	ra,80005834 <z_spin_lock_set_owner>
8000291c:	2c048493          	addi	s1,s1,704 # 800082c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082c1>
	u64_t now = mtime();
80002920:	f65ff0ef          	jal	ra,80002884 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002924:	0004a983          	lw	s3,0(s1)
80002928:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
8000292c:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002930:	41350533          	sub	a0,a0,s3
80002934:	00a73733          	sltu	a4,a4,a0
80002938:	415585b3          	sub	a1,a1,s5
8000293c:	0001d637          	lui	a2,0x1d
80002940:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002944:	00000693          	li	a3,0
80002948:	40e585b3          	sub	a1,a1,a4
8000294c:	975fd0ef          	jal	ra,800002c0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
80002950:	0001d7b7          	lui	a5,0x1d
80002954:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002958:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
8000295c:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002960:	2e090513          	addi	a0,s2,736
	last_count += dticks * CYC_PER_TICK;
80002964:	013789b3          	add	s3,a5,s3
80002968:	00f9b7b3          	sltu	a5,s3,a5
8000296c:	015787b3          	add	a5,a5,s5
80002970:	0134a023          	sw	s3,0(s1)
80002974:	00f4a223          	sw	a5,4(s1)
80002978:	68d020ef          	jal	ra,80005804 <z_spin_unlock_valid>
8000297c:	02051e63          	bnez	a0,800029b8 <timer_isr+0x11c>
80002980:	800084b7          	lui	s1,0x80008
80002984:	800085b7          	lui	a1,0x80008
80002988:	80008537          	lui	a0,0x80008
8000298c:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80002990:	06100693          	li	a3,97
80002994:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80002998:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000299c:	d75ff0ef          	jal	ra,80002710 <printk>
800029a0:	80008537          	lui	a0,0x80008
800029a4:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800029a8:	d69ff0ef          	jal	ra,80002710 <printk>
800029ac:	06100593          	li	a1,97
800029b0:	bc448513          	addi	a0,s1,-1084
800029b4:	d99ff0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800029b8:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
800029bc:	01812403          	lw	s0,24(sp)
800029c0:	01c12083          	lw	ra,28(sp)
800029c4:	01412483          	lw	s1,20(sp)
800029c8:	01012903          	lw	s2,16(sp)
800029cc:	00c12983          	lw	s3,12(sp)
800029d0:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800029d4:	000a0513          	mv	a0,s4
}
800029d8:	00812a03          	lw	s4,8(sp)
800029dc:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800029e0:	0290306f          	j	80006208 <z_clock_announce>

800029e4 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
800029e4:	ff010113          	addi	sp,sp,-16
800029e8:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
800029ec:	e99ff0ef          	jal	ra,80002884 <mtime>
800029f0:	0001d7b7          	lui	a5,0x1d
800029f4:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
800029f8:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
800029fc:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80002a00:	fff00693          	li	a3,-1
80002a04:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002a08:	00a7b533          	sltu	a0,a5,a0
80002a0c:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80002a10:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002a14:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80002a18:	00700513          	li	a0,7
80002a1c:	d75ff0ef          	jal	ra,80002790 <z_arch_irq_enable>
	return 0;
}
80002a20:	00c12083          	lw	ra,12(sp)
80002a24:	00000513          	li	a0,0
80002a28:	01010113          	addi	sp,sp,16
80002a2c:	00008067          	ret

80002a30 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002a30:	16059c63          	bnez	a1,80002ba8 <z_clock_set_timeout+0x178>
{
80002a34:	fe010113          	addi	sp,sp,-32
80002a38:	00112e23          	sw	ra,28(sp)
80002a3c:	00812c23          	sw	s0,24(sp)
80002a40:	00912a23          	sw	s1,20(sp)
80002a44:	01212823          	sw	s2,16(sp)
80002a48:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80002a4c:	fff00793          	li	a5,-1
80002a50:	00f51663          	bne	a0,a5,80002a5c <z_clock_set_timeout+0x2c>
80002a54:	00009537          	lui	a0,0x9
80002a58:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80002a5c:	000097b7          	lui	a5,0x9
80002a60:	fff50413          	addi	s0,a0,-1
80002a64:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80002a68:	1287da63          	bge	a5,s0,80002b9c <z_clock_set_timeout+0x16c>
80002a6c:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002a70:	00800493          	li	s1,8
80002a74:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002a78:	80008937          	lui	s2,0x80008
80002a7c:	2e090513          	addi	a0,s2,736 # 800082e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002a80:	0084f493          	andi	s1,s1,8
80002a84:	559020ef          	jal	ra,800057dc <z_spin_lock_valid>
80002a88:	02051e63          	bnez	a0,80002ac4 <z_clock_set_timeout+0x94>
80002a8c:	800089b7          	lui	s3,0x80008
80002a90:	800085b7          	lui	a1,0x80008
80002a94:	80008537          	lui	a0,0x80008
80002a98:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80002a9c:	04e00693          	li	a3,78
80002aa0:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80002aa4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80002aa8:	c69ff0ef          	jal	ra,80002710 <printk>
80002aac:	80008537          	lui	a0,0x80008
80002ab0:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80002ab4:	c5dff0ef          	jal	ra,80002710 <printk>
80002ab8:	04e00593          	li	a1,78
80002abc:	bc498513          	addi	a0,s3,-1084
80002ac0:	c8dff0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80002ac4:	2e090513          	addi	a0,s2,736
80002ac8:	56d020ef          	jal	ra,80005834 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002acc:	db9ff0ef          	jal	ra,80002884 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
80002ad0:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002ad4:	800087b7          	lui	a5,0x80008
	u32_t cyc = ticks * CYC_PER_TICK;
80002ad8:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002adc:	2c078793          	addi	a5,a5,704 # 800082c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082c1>
80002ae0:	0007a703          	lw	a4,0(a5)
80002ae4:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002ae8:	02c407b3          	mul	a5,s0,a2
80002aec:	4bf68693          	addi	a3,a3,1215
80002af0:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002af4:	3e700693          	li	a3,999
80002af8:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002afc:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002b00:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002b04:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002b08:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002b0c:	00f50533          	add	a0,a0,a5
80002b10:	00a6c463          	blt	a3,a0,80002b18 <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
80002b14:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
80002b18:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002b1c:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
80002b20:	fff00613          	li	a2,-1
80002b24:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002b28:	00f737b3          	sltu	a5,a4,a5
80002b2c:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
80002b30:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
80002b34:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b38:	2e090513          	addi	a0,s2,736
80002b3c:	4c9020ef          	jal	ra,80005804 <z_spin_unlock_valid>
80002b40:	02051e63          	bnez	a0,80002b7c <z_clock_set_timeout+0x14c>
80002b44:	80008437          	lui	s0,0x80008
80002b48:	800085b7          	lui	a1,0x80008
80002b4c:	80008537          	lui	a0,0x80008
80002b50:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80002b54:	06100693          	li	a3,97
80002b58:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80002b5c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80002b60:	bb1ff0ef          	jal	ra,80002710 <printk>
80002b64:	80008537          	lui	a0,0x80008
80002b68:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80002b6c:	ba5ff0ef          	jal	ra,80002710 <printk>
80002b70:	06100593          	li	a1,97
80002b74:	bc440513          	addi	a0,s0,-1084
80002b78:	bd5ff0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b7c:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
80002b80:	01c12083          	lw	ra,28(sp)
80002b84:	01812403          	lw	s0,24(sp)
80002b88:	01412483          	lw	s1,20(sp)
80002b8c:	01012903          	lw	s2,16(sp)
80002b90:	00c12983          	lw	s3,12(sp)
80002b94:	02010113          	addi	sp,sp,32
80002b98:	00008067          	ret
80002b9c:	ec045ae3          	bgez	s0,80002a70 <z_clock_set_timeout+0x40>
80002ba0:	00000413          	li	s0,0
80002ba4:	ecdff06f          	j	80002a70 <z_clock_set_timeout+0x40>
80002ba8:	00008067          	ret

80002bac <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002bac:	ff010113          	addi	sp,sp,-16
80002bb0:	00812423          	sw	s0,8(sp)
80002bb4:	00112623          	sw	ra,12(sp)
80002bb8:	00912223          	sw	s1,4(sp)
80002bbc:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002bc0:	00800413          	li	s0,8
80002bc4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002bc8:	80008937          	lui	s2,0x80008
80002bcc:	2e090513          	addi	a0,s2,736 # 800082e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002bd0:	00847413          	andi	s0,s0,8
80002bd4:	409020ef          	jal	ra,800057dc <z_spin_lock_valid>
80002bd8:	02051e63          	bnez	a0,80002c14 <z_clock_elapsed+0x68>
80002bdc:	800084b7          	lui	s1,0x80008
80002be0:	800085b7          	lui	a1,0x80008
80002be4:	80008537          	lui	a0,0x80008
80002be8:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80002bec:	04e00693          	li	a3,78
80002bf0:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80002bf4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80002bf8:	b19ff0ef          	jal	ra,80002710 <printk>
80002bfc:	80008537          	lui	a0,0x80008
80002c00:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80002c04:	b0dff0ef          	jal	ra,80002710 <printk>
80002c08:	04e00593          	li	a1,78
80002c0c:	bc448513          	addi	a0,s1,-1084
80002c10:	b3dff0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80002c14:	2e090513          	addi	a0,s2,736
80002c18:	41d020ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002c1c:	c69ff0ef          	jal	ra,80002884 <mtime>
80002c20:	800087b7          	lui	a5,0x80008
80002c24:	2c07a483          	lw	s1,704(a5) # 800082c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082c1>
80002c28:	409504b3          	sub	s1,a0,s1
80002c2c:	0001d537          	lui	a0,0x1d
80002c30:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002c34:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002c38:	2e090513          	addi	a0,s2,736
80002c3c:	3c9020ef          	jal	ra,80005804 <z_spin_unlock_valid>
80002c40:	02051e63          	bnez	a0,80002c7c <z_clock_elapsed+0xd0>
80002c44:	80008937          	lui	s2,0x80008
80002c48:	800085b7          	lui	a1,0x80008
80002c4c:	80008537          	lui	a0,0x80008
80002c50:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80002c54:	06100693          	li	a3,97
80002c58:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80002c5c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80002c60:	ab1ff0ef          	jal	ra,80002710 <printk>
80002c64:	80008537          	lui	a0,0x80008
80002c68:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80002c6c:	aa5ff0ef          	jal	ra,80002710 <printk>
80002c70:	06100593          	li	a1,97
80002c74:	bc490513          	addi	a0,s2,-1084
80002c78:	ad5ff0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002c7c:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002c80:	00c12083          	lw	ra,12(sp)
80002c84:	00812403          	lw	s0,8(sp)
80002c88:	00048513          	mv	a0,s1
80002c8c:	00012903          	lw	s2,0(sp)
80002c90:	00412483          	lw	s1,4(sp)
80002c94:	01010113          	addi	sp,sp,16
80002c98:	00008067          	ret

80002c9c <z_timer_cycle_get_32>:

u32_t z_timer_cycle_get_32(void)
{
80002c9c:	ff010113          	addi	sp,sp,-16
80002ca0:	00112623          	sw	ra,12(sp)
	return (u32_t)mtime();
80002ca4:	be1ff0ef          	jal	ra,80002884 <mtime>
}
80002ca8:	00c12083          	lw	ra,12(sp)
80002cac:	01010113          	addi	sp,sp,16
80002cb0:	00008067          	ret

80002cb4 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002cb4:	00054783          	lbu	a5,0(a0)
80002cb8:	0005c703          	lbu	a4,0(a1)
80002cbc:	00e79463          	bne	a5,a4,80002cc4 <strcmp+0x10>
80002cc0:	00079663          	bnez	a5,80002ccc <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002cc4:	40e78533          	sub	a0,a5,a4
80002cc8:	00008067          	ret
		s1++;
80002ccc:	00150513          	addi	a0,a0,1
		s2++;
80002cd0:	00158593          	addi	a1,a1,1
80002cd4:	fe1ff06f          	j	80002cb4 <strcmp>

80002cd8 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80002cd8:	00b547b3          	xor	a5,a0,a1
80002cdc:	0037f793          	andi	a5,a5,3
80002ce0:	06078063          	beqz	a5,80002d40 <memcpy+0x68>
	unsigned char *d_byte = (unsigned char *)d;
80002ce4:	00050793          	mv	a5,a0
80002ce8:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80002cec:	06e61a63          	bne	a2,a4,80002d60 <memcpy+0x88>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80002cf0:	00008067          	ret
			if (n == 0) {
80002cf4:	fe060ee3          	beqz	a2,80002cf0 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80002cf8:	00158593          	addi	a1,a1,1
80002cfc:	fff5c703          	lbu	a4,-1(a1)
80002d00:	00178793          	addi	a5,a5,1
			n--;
80002d04:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80002d08:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80002d0c:	0037f713          	andi	a4,a5,3
80002d10:	fe0712e3          	bnez	a4,80002cf4 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
80002d14:	00300693          	li	a3,3
80002d18:	40e60833          	sub	a6,a2,a4
80002d1c:	0306e663          	bltu	a3,a6,80002d48 <memcpy+0x70>
80002d20:	00265713          	srli	a4,a2,0x2
80002d24:	ffc00693          	li	a3,-4
80002d28:	02d706b3          	mul	a3,a4,a3
80002d2c:	00271713          	slli	a4,a4,0x2
80002d30:	00e787b3          	add	a5,a5,a4
80002d34:	00e585b3          	add	a1,a1,a4
80002d38:	00d60633          	add	a2,a2,a3
80002d3c:	fadff06f          	j	80002ce8 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
80002d40:	00050793          	mv	a5,a0
80002d44:	fc9ff06f          	j	80002d0c <memcpy+0x34>
			*(d_word++) = *(s_word++);
80002d48:	00e588b3          	add	a7,a1,a4
80002d4c:	0008a883          	lw	a7,0(a7)
80002d50:	00e78833          	add	a6,a5,a4
80002d54:	00470713          	addi	a4,a4,4
80002d58:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80002d5c:	fbdff06f          	j	80002d18 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
80002d60:	00e58833          	add	a6,a1,a4
80002d64:	00084803          	lbu	a6,0(a6)
80002d68:	00e786b3          	add	a3,a5,a4
80002d6c:	00170713          	addi	a4,a4,1
80002d70:	01068023          	sb	a6,0(a3)
		n--;
80002d74:	f79ff06f          	j	80002cec <memcpy+0x14>

80002d78 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002d78:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002d7c:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80002d80:	0037f713          	andi	a4,a5,3
80002d84:	04071863          	bnez	a4,80002dd4 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002d88:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002d8c:	00859713          	slli	a4,a1,0x8
80002d90:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002d94:	01059713          	slli	a4,a1,0x10
80002d98:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002d9c:	00c78333          	add	t1,a5,a2
80002da0:	00078713          	mv	a4,a5
80002da4:	00300813          	li	a6,3
80002da8:	40e308b3          	sub	a7,t1,a4
80002dac:	03186e63          	bltu	a6,a7,80002de8 <memset+0x70>
80002db0:	00265713          	srli	a4,a2,0x2
80002db4:	00271593          	slli	a1,a4,0x2
80002db8:	00b787b3          	add	a5,a5,a1
80002dbc:	ffc00593          	li	a1,-4
80002dc0:	02b70733          	mul	a4,a4,a1
80002dc4:	00c70733          	add	a4,a4,a2
80002dc8:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002dcc:	02e79463          	bne	a5,a4,80002df4 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002dd0:	00008067          	ret
		if (n == 0) {
80002dd4:	fe060ee3          	beqz	a2,80002dd0 <memset+0x58>
		*(d_byte++) = c_byte;
80002dd8:	00178793          	addi	a5,a5,1
80002ddc:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002de0:	fff60613          	addi	a2,a2,-1
80002de4:	f9dff06f          	j	80002d80 <memset+0x8>
		*(d_word++) = c_word;
80002de8:	00470713          	addi	a4,a4,4
80002dec:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80002df0:	fb9ff06f          	j	80002da8 <memset+0x30>
		*(d_byte++) = c_byte;
80002df4:	00178793          	addi	a5,a5,1
80002df8:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002dfc:	fd1ff06f          	j	80002dcc <memset+0x54>

80002e00 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80002e00:	fff00513          	li	a0,-1
80002e04:	00008067          	ret

80002e08 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002e08:	800087b7          	lui	a5,0x80008
80002e0c:	26a7a223          	sw	a0,612(a5) # 80008264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008265>
}
80002e10:	00008067          	ret

80002e14 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002e14:	fe010113          	addi	sp,sp,-32
80002e18:	00812c23          	sw	s0,24(sp)
	test->setup();
80002e1c:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80002e20:	80008437          	lui	s0,0x80008
{
80002e24:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002e28:	26840413          	addi	s0,s0,616 # 80008268 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008269>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002e2c:	800084b7          	lui	s1,0x80008
{
80002e30:	00112e23          	sw	ra,28(sp)
80002e34:	01212823          	sw	s2,16(sp)
80002e38:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002e3c:	2e448493          	addi	s1,s1,740 # 800082e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e5>
80002e40:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002e44:	00042023          	sw	zero,0(s0)
{
80002e48:	00050913          	mv	s2,a0
	test_result = 1;
80002e4c:	0134a023          	sw	s3,0(s1)
	test->setup();
80002e50:	000780e7          	jalr	a5
	test->test();
80002e54:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002e58:	01342023          	sw	s3,0(s0)
	test->test();
80002e5c:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002e60:	00200793          	li	a5,2
80002e64:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002e68:	00c92783          	lw	a5,12(s2)
80002e6c:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002e70:	00300793          	li	a5,3
80002e74:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002e78:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002e7c:	0004a023          	sw	zero,0(s1)
}
80002e80:	01c12083          	lw	ra,28(sp)
80002e84:	01412483          	lw	s1,20(sp)
80002e88:	01012903          	lw	s2,16(sp)
80002e8c:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002e90:	80008537          	lui	a0,0x80008
80002e94:	7dc50513          	addi	a0,a0,2012 # 800087dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800087dd>
80002e98:	02010113          	addi	sp,sp,32
80002e9c:	5280206f          	j	800053c4 <z_impl_k_sem_give>

80002ea0 <ztest_test_fail>:
80002ea0:	80008537          	lui	a0,0x80008
{
80002ea4:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002ea8:	800087b7          	lui	a5,0x80008
80002eac:	fff00713          	li	a4,-1
80002eb0:	7dc50513          	addi	a0,a0,2012 # 800087dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800087dd>
{
80002eb4:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002eb8:	2ee7a223          	sw	a4,740(a5) # 800082e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e5>
80002ebc:	508020ef          	jal	ra,800053c4 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002ec0:	430020ef          	jal	ra,800052f0 <z_impl_k_current_get>
}
80002ec4:	00c12083          	lw	ra,12(sp)
80002ec8:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002ecc:	4790206f          	j	80005b44 <z_impl_k_thread_abort>

80002ed0 <ztest_test_skip>:
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002ed0:	80008537          	lui	a0,0x80008
{
80002ed4:	ff010113          	addi	sp,sp,-16
	test_result = -2;
80002ed8:	800087b7          	lui	a5,0x80008
80002edc:	ffe00713          	li	a4,-2
80002ee0:	7dc50513          	addi	a0,a0,2012 # 800087dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800087dd>
{
80002ee4:	00112623          	sw	ra,12(sp)
	test_result = -2;
80002ee8:	2ee7a223          	sw	a4,740(a5) # 800082e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e5>
80002eec:	4d8020ef          	jal	ra,800053c4 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002ef0:	400020ef          	jal	ra,800052f0 <z_impl_k_current_get>
}
80002ef4:	00c12083          	lw	ra,12(sp)
80002ef8:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002efc:	4490206f          	j	80005b44 <z_impl_k_thread_abort>

80002f00 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002f00:	fa010113          	addi	sp,sp,-96
80002f04:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002f08:	800084b7          	lui	s1,0x80008
80002f0c:	2e84a783          	lw	a5,744(s1) # 800082e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e9>
{
80002f10:	04112e23          	sw	ra,92(sp)
80002f14:	04812c23          	sw	s0,88(sp)
80002f18:	05212823          	sw	s2,80(sp)
80002f1c:	05312623          	sw	s3,76(sp)
80002f20:	05412423          	sw	s4,72(sp)
80002f24:	05512223          	sw	s5,68(sp)
80002f28:	05612023          	sw	s6,64(sp)
80002f2c:	03712e23          	sw	s7,60(sp)
80002f30:	03812c23          	sw	s8,56(sp)
80002f34:	03912a23          	sw	s9,52(sp)
80002f38:	03a12823          	sw	s10,48(sp)
80002f3c:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
80002f40:	0807c463          	bltz	a5,80002fc8 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002f44:	80008437          	lui	s0,0x80008
80002f48:	00100613          	li	a2,1
80002f4c:	00050993          	mv	s3,a0
80002f50:	00058c13          	mv	s8,a1
80002f54:	7dc40513          	addi	a0,s0,2012 # 800087dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800087dd>
80002f58:	00000593          	li	a1,0
80002f5c:	3a0020ef          	jal	ra,800052fc <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80002f60:	80008537          	lui	a0,0x80008
80002f64:	00098593          	mv	a1,s3
80002f68:	c7850513          	addi	a0,a0,-904 # 80007c78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c79>
80002f6c:	fa4ff0ef          	jal	ra,80002710 <printk>
	PRINT_LINE;
80002f70:	80008937          	lui	s2,0x80008
80002f74:	c9090513          	addi	a0,s2,-880 # 80007c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c91>
		Z_TC_END_RESULT(ret, test->name);
80002f78:	80008ab7          	lui	s5,0x80008
	PRINT_LINE;
80002f7c:	f94ff0ef          	jal	ra,80002710 <printk>
80002f80:	2e848493          	addi	s1,s1,744
	int fail = 0;
80002f84:	00000a13          	li	s4,0
80002f88:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002f8c:	8000acb7          	lui	s9,0x8000a
80002f90:	80008b37          	lui	s6,0x80008
80002f94:	80003d37          	lui	s10,0x80003
	if (test_result == -1) {
80002f98:	80008db7          	lui	s11,0x80008
80002f9c:	80008bb7          	lui	s7,0x80008
		Z_TC_END_RESULT(ret, test->name);
80002fa0:	c38a8a93          	addi	s5,s5,-968 # 80007c38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c39>
	while (suite->test) {
80002fa4:	004c2783          	lw	a5,4(s8)
80002fa8:	04079e63          	bnez	a5,80003004 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002fac:	00098593          	mv	a1,s3
	if (fail) {
80002fb0:	100a0663          	beqz	s4,800030bc <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002fb4:	80008537          	lui	a0,0x80008
80002fb8:	d0050513          	addi	a0,a0,-768 # 80007d00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d01>
80002fbc:	f54ff0ef          	jal	ra,80002710 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002fc0:	00100793          	li	a5,1
80002fc4:	00f4a023          	sw	a5,0(s1)
}
80002fc8:	05c12083          	lw	ra,92(sp)
80002fcc:	05812403          	lw	s0,88(sp)
80002fd0:	05412483          	lw	s1,84(sp)
80002fd4:	05012903          	lw	s2,80(sp)
80002fd8:	04c12983          	lw	s3,76(sp)
80002fdc:	04812a03          	lw	s4,72(sp)
80002fe0:	04412a83          	lw	s5,68(sp)
80002fe4:	04012b03          	lw	s6,64(sp)
80002fe8:	03c12b83          	lw	s7,60(sp)
80002fec:	03812c03          	lw	s8,56(sp)
80002ff0:	03412c83          	lw	s9,52(sp)
80002ff4:	03012d03          	lw	s10,48(sp)
80002ff8:	02c12d83          	lw	s11,44(sp)
80002ffc:	06010113          	addi	sp,sp,96
80003000:	00008067          	ret
	TC_START(test->name);
80003004:	000c2583          	lw	a1,0(s8)
80003008:	800087b7          	lui	a5,0x80008
8000300c:	cd878513          	addi	a0,a5,-808 # 80007cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cd9>
80003010:	f00ff0ef          	jal	ra,80002710 <printk>
80003014:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80003018:	010c2783          	lw	a5,16(s8)
8000301c:	000c0713          	mv	a4,s8
80003020:	40000613          	li	a2,1024
80003024:	0087e793          	ori	a5,a5,8
80003028:	fff00893          	li	a7,-1
8000302c:	00000813          	li	a6,0
80003030:	e14d0693          	addi	a3,s10,-492 # 80002e14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002e15>
80003034:	00f12023          	sw	a5,0(sp)
80003038:	9f0c8593          	addi	a1,s9,-1552 # 800099f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800099f1>
8000303c:	00000793          	li	a5,0
80003040:	7ecb0513          	addi	a0,s6,2028 # 800087ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800087ed>
80003044:	15d020ef          	jal	ra,800059a0 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80003048:	01c12783          	lw	a5,28(sp)
8000304c:	fff00593          	li	a1,-1
80003050:	7dc78513          	addi	a0,a5,2012
80003054:	454020ef          	jal	ra,800054a8 <z_impl_k_sem_take>
	if (test_result == -1) {
80003058:	2e4d8793          	addi	a5,s11,740 # 800082e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e5>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000305c:	7ecb0513          	addi	a0,s6,2028
80003060:	0007a403          	lw	s0,0(a5)
80003064:	2e1020ef          	jal	ra,80005b44 <z_impl_k_thread_abort>
	if (test_result == -2) {
80003068:	800087b7          	lui	a5,0x80008
8000306c:	2e478793          	addi	a5,a5,740 # 800082e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e5>
80003070:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80003074:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80003078:	ffe00793          	li	a5,-2
	if (test_result == -1) {
8000307c:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80003080:	000c2603          	lw	a2,0(s8)
80003084:	02f71463          	bne	a4,a5,800030ac <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80003088:	800085b7          	lui	a1,0x80008
8000308c:	cec58593          	addi	a1,a1,-788 # 80007cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ced>
		Z_TC_END_RESULT(ret, test->name);
80003090:	cf4b8513          	addi	a0,s7,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
80003094:	e7cff0ef          	jal	ra,80002710 <printk>
80003098:	c9090513          	addi	a0,s2,-880
8000309c:	e74ff0ef          	jal	ra,80002710 <printk>
		fail += run_test(suite);
800030a0:	008a0a33          	add	s4,s4,s0
		suite++;
800030a4:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
800030a8:	efdff06f          	j	80002fa4 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
800030ac:	00241793          	slli	a5,s0,0x2
800030b0:	00fa87b3          	add	a5,s5,a5
800030b4:	0007a583          	lw	a1,0(a5)
800030b8:	fd9ff06f          	j	80003090 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
800030bc:	80008537          	lui	a0,0x80008
800030c0:	d1850513          	addi	a0,a0,-744 # 80007d18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d19>
800030c4:	e4cff0ef          	jal	ra,80002710 <printk>
	test_status = (test_status || fail) ? 1 : 0;
800030c8:	0004a783          	lw	a5,0(s1)
800030cc:	00f037b3          	snez	a5,a5
800030d0:	ef5ff06f          	j	80002fc4 <z_ztest_run_test_suite+0xc4>

800030d4 <end_report>:

void end_report(void)
{
	if (test_status) {
800030d4:	800087b7          	lui	a5,0x80008
800030d8:	2e87a783          	lw	a5,744(a5) # 800082e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082e9>
{
800030dc:	ff010113          	addi	sp,sp,-16
800030e0:	00812423          	sw	s0,8(sp)
800030e4:	80008537          	lui	a0,0x80008
800030e8:	00112623          	sw	ra,12(sp)
800030ec:	80008437          	lui	s0,0x80008
		TC_END_REPORT(TC_FAIL);
800030f0:	c9050513          	addi	a0,a0,-880 # 80007c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c91>
	if (test_status) {
800030f4:	02078263          	beqz	a5,80003118 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
800030f8:	e18ff0ef          	jal	ra,80002710 <printk>
800030fc:	800085b7          	lui	a1,0x80008
80003100:	c4458593          	addi	a1,a1,-956 # 80007c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c45>
	} else {
		TC_END_REPORT(TC_PASS);
80003104:	c4c40513          	addi	a0,s0,-948 # 80007c4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c4d>
	}
}
80003108:	00812403          	lw	s0,8(sp)
8000310c:	00c12083          	lw	ra,12(sp)
80003110:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80003114:	dfcff06f          	j	80002710 <printk>
80003118:	df8ff0ef          	jal	ra,80002710 <printk>
8000311c:	800085b7          	lui	a1,0x80008
80003120:	c6458593          	addi	a1,a1,-924 # 80007c64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c65>
80003124:	fe1ff06f          	j	80003104 <end_report+0x30>

80003128 <main>:

	return test_status;
}
#else
void main(void)
{
80003128:	ff010113          	addi	sp,sp,-16
8000312c:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80003130:	c1cfe0ef          	jal	ra,8000154c <test_main>
	end_report();
}
80003134:	00c12083          	lw	ra,12(sp)
80003138:	01010113          	addi	sp,sp,16
	end_report();
8000313c:	f99ff06f          	j	800030d4 <end_report>

80003140 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80003140:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80003144:	00012623          	sw	zero,12(sp)
    i++;
80003148:	00c12783          	lw	a5,12(sp)
8000314c:	00178793          	addi	a5,a5,1
80003150:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80003154:	f00107b7          	lui	a5,0xf0010
80003158:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
8000315c:	01010113          	addi	sp,sp,16
80003160:	00008067          	ret

80003164 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80003164:	fff00513          	li	a0,-1
80003168:	00008067          	ret

8000316c <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
8000316c:	00000513          	li	a0,0
80003170:	00008067          	ret

80003174 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80003174:	00251713          	slli	a4,a0,0x2
80003178:	800087b7          	lui	a5,0x80008
8000317c:	00150513          	addi	a0,a0,1
80003180:	d4878793          	addi	a5,a5,-696 # 80007d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d49>
80003184:	00251513          	slli	a0,a0,0x2
{
80003188:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
8000318c:	00e78733          	add	a4,a5,a4
80003190:	00a787b3          	add	a5,a5,a0
{
80003194:	00812423          	sw	s0,8(sp)
80003198:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
8000319c:	00072403          	lw	s0,0(a4)
800031a0:	0007a483          	lw	s1,0(a5)
{
800031a4:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800031a8:	00946c63          	bltu	s0,s1,800031c0 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800031ac:	00c12083          	lw	ra,12(sp)
800031b0:	00812403          	lw	s0,8(sp)
800031b4:	00412483          	lw	s1,4(sp)
800031b8:	01010113          	addi	sp,sp,16
800031bc:	00008067          	ret
		retval = device_conf->init(info);
800031c0:	00042783          	lw	a5,0(s0)
800031c4:	00040513          	mv	a0,s0
800031c8:	0047a783          	lw	a5,4(a5)
800031cc:	000780e7          	jalr	a5
		if (retval != 0) {
800031d0:	00050463          	beqz	a0,800031d8 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
800031d4:	00042223          	sw	zero,4(s0)
								info++) {
800031d8:	00c40413          	addi	s0,s0,12
800031dc:	fcdff06f          	j	800031a8 <z_sys_device_do_config_level+0x34>

800031e0 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800031e0:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800031e4:	800087b7          	lui	a5,0x80008
{
800031e8:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800031ec:	800084b7          	lui	s1,0x80008
{
800031f0:	00812423          	sw	s0,8(sp)
800031f4:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800031f8:	27c78413          	addi	s0,a5,636 # 8000827c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000827d>
{
800031fc:	01212023          	sw	s2,0(sp)
80003200:	27c78793          	addi	a5,a5,636
80003204:	2ac48493          	addi	s1,s1,684 # 800082ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ad>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003208:	00941c63          	bne	s0,s1,80003220 <z_impl_device_get_binding+0x40>
8000320c:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80003210:	00078413          	mv	s0,a5
80003214:	02941463          	bne	s0,s1,8000323c <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80003218:	00000413          	li	s0,0
8000321c:	0440006f          	j	80003260 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80003220:	00442703          	lw	a4,4(s0)
80003224:	00070863          	beqz	a4,80003234 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80003228:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
8000322c:	00072703          	lw	a4,0(a4)
80003230:	02a70863          	beq	a4,a0,80003260 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003234:	00c40413          	addi	s0,s0,12
80003238:	fd1ff06f          	j	80003208 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
8000323c:	00442783          	lw	a5,4(s0)
80003240:	00079663          	bnez	a5,8000324c <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003244:	00c40413          	addi	s0,s0,12
80003248:	fcdff06f          	j	80003214 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
8000324c:	00042783          	lw	a5,0(s0)
80003250:	00090513          	mv	a0,s2
80003254:	0007a583          	lw	a1,0(a5)
80003258:	a5dff0ef          	jal	ra,80002cb4 <strcmp>
8000325c:	fe0514e3          	bnez	a0,80003244 <z_impl_device_get_binding+0x64>
}
80003260:	00040513          	mv	a0,s0
80003264:	00c12083          	lw	ra,12(sp)
80003268:	00812403          	lw	s0,8(sp)
8000326c:	00412483          	lw	s1,4(sp)
80003270:	00012903          	lw	s2,0(sp)
80003274:	01010113          	addi	sp,sp,16
80003278:	00008067          	ret

8000327c <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
8000327c:	ff010113          	addi	sp,sp,-16
80003280:	00812423          	sw	s0,8(sp)
80003284:	00912223          	sw	s1,4(sp)
80003288:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000328c:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80003290:	00200493          	li	s1,2
80003294:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80003298:	591020ef          	jal	ra,80006028 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
8000329c:	00a4c463          	blt	s1,a0,800032a4 <idle+0x28>
800032a0:	00100513          	li	a0,1
800032a4:	00100593          	li	a1,1
800032a8:	65d020ef          	jal	ra,80006104 <z_set_timeout_expiry>
	k_cpu_idle();
800032ac:	cd4ff0ef          	jal	ra,80002780 <k_cpu_idle>
800032b0:	fe5ff06f          	j	80003294 <idle+0x18>

800032b4 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
800032b4:	80008537          	lui	a0,0x80008
800032b8:	800097b7          	lui	a5,0x80009
800032bc:	2c050613          	addi	a2,a0,704 # 800082c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082c1>
800032c0:	96878793          	addi	a5,a5,-1688 # 80008968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008969>
800032c4:	40c78633          	sub	a2,a5,a2
800032c8:	00000593          	li	a1,0
800032cc:	2c050513          	addi	a0,a0,704
800032d0:	aa9ff06f          	j	80002d78 <memset>

800032d4 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
800032d4:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800032d8:	00200513          	li	a0,2
{
800032dc:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800032e0:	e95ff0ef          	jal	ra,80003174 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
800032e4:	80008537          	lui	a0,0x80008
800032e8:	d5c50513          	addi	a0,a0,-676 # 80007d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d5d>
800032ec:	c24ff0ef          	jal	ra,80002710 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
800032f0:	00300513          	li	a0,3
800032f4:	e81ff0ef          	jal	ra,80003174 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
800032f8:	79c020ef          	jal	ra,80005a94 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
800032fc:	e2dff0ef          	jal	ra,80003128 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80003300:	800097b7          	lui	a5,0x80009
80003304:	8cc78793          	addi	a5,a5,-1844 # 800088cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800088cd>
80003308:	00c7c703          	lbu	a4,12(a5)
8000330c:	ffe77713          	andi	a4,a4,-2
80003310:	00e78623          	sb	a4,12(a5)
}
80003314:	00c12083          	lw	ra,12(sp)
80003318:	01010113          	addi	sp,sp,16
8000331c:	00008067          	ret

80003320 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80003320:	f6010113          	addi	sp,sp,-160
80003324:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80003328:	8000b7b7          	lui	a5,0x8000b
8000332c:	80009437          	lui	s0,0x80009
80003330:	09312623          	sw	s3,140(sp)
80003334:	9f078793          	addi	a5,a5,-1552 # 8000a9f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000a9f1>
80003338:	93c40993          	addi	s3,s0,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
8000333c:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80003340:	01010793          	addi	a5,sp,16
80003344:	07000613          	li	a2,112
80003348:	00000593          	li	a1,0
8000334c:	00078513          	mv	a0,a5
{
80003350:	08112e23          	sw	ra,156(sp)
80003354:	08912a23          	sw	s1,148(sp)
80003358:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
8000335c:	a1dff0ef          	jal	ra,80002d78 <memset>
80003360:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80003364:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80003368:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
8000336c:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80003370:	e05ff0ef          	jal	ra,80003174 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80003374:	00100513          	li	a0,1
80003378:	dfdff0ef          	jal	ra,80003174 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
8000337c:	10100793          	li	a5,257
80003380:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80003384:	249010ef          	jal	ra,80004dcc <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80003388:	800087b7          	lui	a5,0x80008
8000338c:	da078793          	addi	a5,a5,-608 # 80007da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007da1>
	_kernel.ready_q.cache = _main_thread;
80003390:	80009937          	lui	s2,0x80009
	z_setup_new_thread(_main_thread, _main_stack,
80003394:	00f12223          	sw	a5,4(sp)
80003398:	800036b7          	lui	a3,0x80003
8000339c:	00100793          	li	a5,1
800033a0:	8000a5b7          	lui	a1,0x8000a
	_kernel.ready_q.cache = _main_thread;
800033a4:	8cc90493          	addi	s1,s2,-1844 # 800088cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800088cd>
	z_setup_new_thread(_main_thread, _main_stack,
800033a8:	00f12023          	sw	a5,0(sp)
800033ac:	00000713          	li	a4,0
800033b0:	00000793          	li	a5,0
800033b4:	00000893          	li	a7,0
800033b8:	00000813          	li	a6,0
800033bc:	2d468693          	addi	a3,a3,724 # 800032d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800032d5>
800033c0:	20000613          	li	a2,512
800033c4:	df058593          	addi	a1,a1,-528 # 80009df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009df1>
800033c8:	8cc90513          	addi	a0,s2,-1844
	_kernel.ready_q.cache = _main_thread;
800033cc:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
800033d0:	340020ef          	jal	ra,80005710 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
800033d4:	00d4c783          	lbu	a5,13(s1)
800033d8:	93c40413          	addi	s0,s0,-1732
800033dc:	ffb7f713          	andi	a4,a5,-5
800033e0:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800033e4:	01b7f793          	andi	a5,a5,27
800033e8:	00079a63          	bnez	a5,800033fc <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
800033ec:	0184a783          	lw	a5,24(s1)
800033f0:	00079663          	bnez	a5,800033fc <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
800033f4:	8cc90513          	addi	a0,s2,-1844
800033f8:	5a9000ef          	jal	ra,800041a0 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
800033fc:	800077b7          	lui	a5,0x80007
80003400:	0e878793          	addi	a5,a5,232 # 800070e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070e9>
80003404:	00f12223          	sw	a5,4(sp)
80003408:	80009537          	lui	a0,0x80009
8000340c:	00100793          	li	a5,1
80003410:	800036b7          	lui	a3,0x80003
80003414:	8000a5b7          	lui	a1,0x8000a
80003418:	85c50493          	addi	s1,a0,-1956 # 8000885c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000885d>
8000341c:	00f12023          	sw	a5,0(sp)
80003420:	00f00893          	li	a7,15
80003424:	00000813          	li	a6,0
80003428:	00000793          	li	a5,0
8000342c:	00000713          	li	a4,0
80003430:	27c68693          	addi	a3,a3,636 # 8000327c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000327d>
80003434:	20000613          	li	a2,512
80003438:	ff058593          	addi	a1,a1,-16 # 80009ff0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009ff1>
8000343c:	85c50513          	addi	a0,a0,-1956
80003440:	2d0020ef          	jal	ra,80005710 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003444:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80003448:	00942623          	sw	s1,12(s0)
8000344c:	00800513          	li	a0,8
80003450:	ffb7f793          	andi	a5,a5,-5
80003454:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80003458:	800097b7          	lui	a5,0x80009
8000345c:	95478793          	addi	a5,a5,-1708 # 80008954 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008955>
80003460:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80003464:	00f42e23          	sw	a5,28(s0)
80003468:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
8000346c:	00857513          	andi	a0,a0,8
80003470:	dc9fc0ef          	jal	ra,80000238 <__swap>

80003474 <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003474:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
80003478:	fe010113          	addi	sp,sp,-32
8000347c:	00812c23          	sw	s0,24(sp)
80003480:	00112e23          	sw	ra,28(sp)
80003484:	01f7f793          	andi	a5,a5,31
80003488:	00050413          	mv	s0,a0
8000348c:	00079c63          	bnez	a5,800034a4 <prepare_thread_to_run+0x30>
	if (z_is_thread_ready(thread)) {
80003490:	01852783          	lw	a5,24(a0)
80003494:	00079863          	bnez	a5,800034a4 <prepare_thread_to_run+0x30>
80003498:	00b12623          	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
8000349c:	505000ef          	jal	ra,800041a0 <z_add_thread_to_ready_q>
800034a0:	00c12583          	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
800034a4:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
800034a8:	00b42a23          	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
800034ac:	01c12083          	lw	ra,28(sp)
800034b0:	01812403          	lw	s0,24(sp)
800034b4:	02010113          	addi	sp,sp,32
800034b8:	00008067          	ret

800034bc <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
800034bc:	fe010113          	addi	sp,sp,-32
800034c0:	00812c23          	sw	s0,24(sp)
800034c4:	00912a23          	sw	s1,20(sp)
800034c8:	01212823          	sw	s2,16(sp)
800034cc:	01312623          	sw	s3,12(sp)
800034d0:	01412423          	sw	s4,8(sp)
800034d4:	01612023          	sw	s6,0(sp)
800034d8:	00112e23          	sw	ra,28(sp)
800034dc:	01512223          	sw	s5,4(sp)
800034e0:	00050413          	mv	s0,a0
800034e4:	00058993          	mv	s3,a1
800034e8:	00060a13          	mv	s4,a2
800034ec:	00068b13          	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
800034f0:	00850913          	addi	s2,a0,8
800034f4:	00800493          	li	s1,8
800034f8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800034fc:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80003500:	0084f493          	andi	s1,s1,8
80003504:	2d8020ef          	jal	ra,800057dc <z_spin_lock_valid>
80003508:	02051e63          	bnez	a0,80003544 <queue_insert+0x88>
8000350c:	80008ab7          	lui	s5,0x80008
80003510:	800085b7          	lui	a1,0x80008
80003514:	80008537          	lui	a0,0x80008
80003518:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
8000351c:	04e00693          	li	a3,78
80003520:	bc4a8613          	addi	a2,s5,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003524:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003528:	9e8ff0ef          	jal	ra,80002710 <printk>
8000352c:	80008537          	lui	a0,0x80008
80003530:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80003534:	9dcff0ef          	jal	ra,80002710 <printk>
80003538:	04e00593          	li	a1,78
8000353c:	bc4a8513          	addi	a0,s5,-1084
80003540:	a0cff0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80003544:	00090513          	mv	a0,s2
80003548:	2ec020ef          	jal	ra,80005834 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
8000354c:	00c40513          	addi	a0,s0,12
80003550:	65c010ef          	jal	ra,80004bac <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
80003554:	02050063          	beqz	a0,80003574 <queue_insert+0xb8>
		prepare_thread_to_run(first_pending_thread, data);
80003558:	000a0593          	mv	a1,s4
8000355c:	f19ff0ef          	jal	ra,80003474 <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
80003560:	00090513          	mv	a0,s2
80003564:	00048593          	mv	a1,s1
80003568:	5ec000ef          	jal	ra,80003b54 <z_reschedule>
	return 0;
8000356c:	00000513          	li	a0,0
80003570:	0600006f          	j	800035d0 <queue_insert+0x114>
	if (alloc) {
80003574:	0a0b0e63          	beqz	s6,80003630 <queue_insert+0x174>
		anode = z_thread_malloc(sizeof(*anode));
80003578:	00800513          	li	a0,8
8000357c:	438030ef          	jal	ra,800069b4 <z_thread_malloc>
		if (anode == NULL) {
80003580:	06051c63          	bnez	a0,800035f8 <queue_insert+0x13c>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003584:	00090513          	mv	a0,s2
80003588:	27c020ef          	jal	ra,80005804 <z_spin_unlock_valid>
8000358c:	02051e63          	bnez	a0,800035c8 <queue_insert+0x10c>
80003590:	80008437          	lui	s0,0x80008
80003594:	800085b7          	lui	a1,0x80008
80003598:	80008537          	lui	a0,0x80008
8000359c:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800035a0:	06100693          	li	a3,97
800035a4:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800035a8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800035ac:	964ff0ef          	jal	ra,80002710 <printk>
800035b0:	80008537          	lui	a0,0x80008
800035b4:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800035b8:	958ff0ef          	jal	ra,80002710 <printk>
800035bc:	06100593          	li	a1,97
800035c0:	bc440513          	addi	a0,s0,-1084
800035c4:	988ff0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800035c8:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
800035cc:	ff400513          	li	a0,-12
}
800035d0:	01c12083          	lw	ra,28(sp)
800035d4:	01812403          	lw	s0,24(sp)
800035d8:	01412483          	lw	s1,20(sp)
800035dc:	01012903          	lw	s2,16(sp)
800035e0:	00c12983          	lw	s3,12(sp)
800035e4:	00812a03          	lw	s4,8(sp)
800035e8:	00412a83          	lw	s5,4(sp)
800035ec:	00012b03          	lw	s6,0(sp)
800035f0:	02010113          	addi	sp,sp,32
800035f4:	00008067          	ret
 * @param flags A value between 0 and 3 to set the flags value
 */
static inline void sys_sfnode_init(sys_sfnode_t *node, u8_t flags)
{
	__ASSERT((flags & ~SYS_SFLIST_FLAGS_MASK) == 0U, "flags too large");
	node->next_and_flags = flags;
800035f8:	00100793          	li	a5,1
		anode->data = data;
800035fc:	01452223          	sw	s4,4(a0)
80003600:	00f52023          	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
80003604:	00052783          	lw	a5,0(a0)
80003608:	0037f793          	andi	a5,a5,3
8000360c:	02099863          	bnez	s3,8000363c <queue_insert+0x180>
	parent->next_and_flags = cur_flags | (unative_t)child;
80003610:	00042703          	lw	a4,0(s0)
80003614:	00f767b3          	or	a5,a4,a5
80003618:	00f52023          	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
8000361c:	00442783          	lw	a5,4(s0)
	list->head = node;
80003620:	00a42023          	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
80003624:	f2079ee3          	bnez	a5,80003560 <queue_insert+0xa4>
	list->tail = node;
80003628:	00a42223          	sw	a0,4(s0)
8000362c:	f35ff06f          	j	80003560 <queue_insert+0xa4>
	node->next_and_flags = flags;
80003630:	000a2023          	sw	zero,0(s4)
80003634:	000a0513          	mv	a0,s4
80003638:	fcdff06f          	j	80003604 <queue_insert+0x148>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
8000363c:	0009a703          	lw	a4,0(s3)
80003640:	ffc77713          	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
80003644:	02071863          	bnez	a4,80003674 <queue_insert+0x1b8>
Z_GENLIST_APPEND(sflist, sfnode)
80003648:	00442703          	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
8000364c:	00f52023          	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80003650:	00071863          	bnez	a4,80003660 <queue_insert+0x1a4>
	list->tail = node;
80003654:	00a42223          	sw	a0,4(s0)
	list->head = node;
80003658:	00a42023          	sw	a0,0(s0)
8000365c:	f05ff06f          	j	80003560 <queue_insert+0xa4>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80003660:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80003664:	0037f793          	andi	a5,a5,3
80003668:	00f567b3          	or	a5,a0,a5
8000366c:	00f72023          	sw	a5,0(a4)
80003670:	fb9ff06f          	j	80003628 <queue_insert+0x16c>
80003674:	00e7e7b3          	or	a5,a5,a4
80003678:	00f52023          	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
8000367c:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
80003680:	0037f793          	andi	a5,a5,3
80003684:	00f56533          	or	a0,a0,a5
80003688:	00a9a023          	sw	a0,0(s3)
8000368c:	ed5ff06f          	j	80003560 <queue_insert+0xa4>

80003690 <z_queue_node_peek>:
{
80003690:	ff010113          	addi	sp,sp,-16
80003694:	00812423          	sw	s0,8(sp)
80003698:	00112623          	sw	ra,12(sp)
8000369c:	00050413          	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
800036a0:	00050e63          	beqz	a0,800036bc <z_queue_node_peek+0x2c>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
800036a4:	00052783          	lw	a5,0(a0)
800036a8:	0037f793          	andi	a5,a5,3
800036ac:	00078863          	beqz	a5,800036bc <z_queue_node_peek+0x2c>
		ret = anode->data;
800036b0:	00452403          	lw	s0,4(a0)
		if (needs_free) {
800036b4:	00058463          	beqz	a1,800036bc <z_queue_node_peek+0x2c>
			k_free(anode);
800036b8:	2ec030ef          	jal	ra,800069a4 <k_free>
}
800036bc:	00040513          	mv	a0,s0
800036c0:	00c12083          	lw	ra,12(sp)
800036c4:	00812403          	lw	s0,8(sp)
800036c8:	01010113          	addi	sp,sp,16
800036cc:	00008067          	ret

800036d0 <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
800036d0:	00c50793          	addi	a5,a0,12
	list->head = NULL;
800036d4:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
800036d8:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
800036dc:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
800036e0:	00f52623          	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
800036e4:	00f52823          	sw	a5,16(a0)
}
800036e8:	00008067          	ret

800036ec <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
800036ec:	00058613          	mv	a2,a1
800036f0:	00452583          	lw	a1,4(a0)
800036f4:	00000693          	li	a3,0
800036f8:	dc5ff06f          	j	800034bc <queue_insert>

800036fc <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
800036fc:	fe010113          	addi	sp,sp,-32
80003700:	00812c23          	sw	s0,24(sp)
80003704:	00912a23          	sw	s1,20(sp)
80003708:	01212823          	sw	s2,16(sp)
8000370c:	01312623          	sw	s3,12(sp)
80003710:	00112e23          	sw	ra,28(sp)
80003714:	01412423          	sw	s4,8(sp)
80003718:	00050493          	mv	s1,a0
8000371c:	00058993          	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003720:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003724:	00800413          	li	s0,8
80003728:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000372c:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80003730:	00847413          	andi	s0,s0,8
80003734:	0a8020ef          	jal	ra,800057dc <z_spin_lock_valid>
80003738:	02051e63          	bnez	a0,80003774 <z_impl_k_queue_get+0x78>
8000373c:	80008a37          	lui	s4,0x80008
80003740:	800085b7          	lui	a1,0x80008
80003744:	80008537          	lui	a0,0x80008
80003748:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
8000374c:	04e00693          	li	a3,78
80003750:	bc4a0613          	addi	a2,s4,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003754:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003758:	fb9fe0ef          	jal	ra,80002710 <printk>
8000375c:	80008537          	lui	a0,0x80008
80003760:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80003764:	fadfe0ef          	jal	ra,80002710 <printk>
80003768:	04e00593          	li	a1,78
8000376c:	bc4a0513          	addi	a0,s4,-1084
80003770:	fddfe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80003774:	00090513          	mv	a0,s2
80003778:	0bc020ef          	jal	ra,80005834 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
8000377c:	0004a503          	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
80003780:	08050a63          	beqz	a0,80003814 <z_impl_k_queue_get+0x118>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80003784:	00052783          	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80003788:	0044a703          	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
8000378c:	ffc7f793          	andi	a5,a5,-4
	list->head = node;
80003790:	00f4a023          	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80003794:	00e51463          	bne	a0,a4,8000379c <z_impl_k_queue_get+0xa0>
	list->tail = node;
80003798:	00f4a223          	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
8000379c:	00100593          	li	a1,1
800037a0:	ef1ff0ef          	jal	ra,80003690 <z_queue_node_peek>
800037a4:	00050493          	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800037a8:	00090513          	mv	a0,s2
800037ac:	058020ef          	jal	ra,80005804 <z_spin_unlock_valid>
800037b0:	02051e63          	bnez	a0,800037ec <z_impl_k_queue_get+0xf0>
800037b4:	80008937          	lui	s2,0x80008
800037b8:	800085b7          	lui	a1,0x80008
800037bc:	80008537          	lui	a0,0x80008
800037c0:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800037c4:	06100693          	li	a3,97
800037c8:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800037cc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800037d0:	f41fe0ef          	jal	ra,80002710 <printk>
800037d4:	80008537          	lui	a0,0x80008
800037d8:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800037dc:	f35fe0ef          	jal	ra,80002710 <printk>
800037e0:	06100593          	li	a1,97
800037e4:	bc490513          	addi	a0,s2,-1084
800037e8:	f65fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037ec:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
800037f0:	01c12083          	lw	ra,28(sp)
800037f4:	01812403          	lw	s0,24(sp)
800037f8:	00048513          	mv	a0,s1
800037fc:	01012903          	lw	s2,16(sp)
80003800:	01412483          	lw	s1,20(sp)
80003804:	00c12983          	lw	s3,12(sp)
80003808:	00812a03          	lw	s4,8(sp)
8000380c:	02010113          	addi	sp,sp,32
80003810:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80003814:	04099a63          	bnez	s3,80003868 <z_impl_k_queue_get+0x16c>
80003818:	00090513          	mv	a0,s2
8000381c:	7e9010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80003820:	02051e63          	bnez	a0,8000385c <z_impl_k_queue_get+0x160>
80003824:	800084b7          	lui	s1,0x80008
80003828:	800085b7          	lui	a1,0x80008
8000382c:	80008537          	lui	a0,0x80008
80003830:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80003834:	06100693          	li	a3,97
80003838:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
8000383c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003840:	ed1fe0ef          	jal	ra,80002710 <printk>
80003844:	80008537          	lui	a0,0x80008
80003848:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
8000384c:	ec5fe0ef          	jal	ra,80002710 <printk>
80003850:	06100593          	li	a1,97
80003854:	bc448513          	addi	a0,s1,-1084
80003858:	ef5fe0ef          	jal	ra,8000274c <assert_post_action>
8000385c:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80003860:	00000493          	li	s1,0
80003864:	f8dff06f          	j	800037f0 <z_impl_k_queue_get+0xf4>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80003868:	00c48613          	addi	a2,s1,12
8000386c:	00098693          	mv	a3,s3
80003870:	00040593          	mv	a1,s0
80003874:	00090513          	mv	a0,s2
80003878:	0a0010ef          	jal	ra,80004918 <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
8000387c:	00000493          	li	s1,0
80003880:	f60518e3          	bnez	a0,800037f0 <z_impl_k_queue_get+0xf4>
80003884:	800097b7          	lui	a5,0x80009
80003888:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
8000388c:	0147a483          	lw	s1,20(a5)
80003890:	f61ff06f          	j	800037f0 <z_impl_k_queue_get+0xf4>

80003894 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003894:	00d54783          	lbu	a5,13(a0)
80003898:	01f7f793          	andi	a5,a5,31
8000389c:	00079863          	bnez	a5,800038ac <z_is_thread_ready+0x18>
800038a0:	01852503          	lw	a0,24(a0)
800038a4:	00153513          	seqz	a0,a0
800038a8:	00008067          	ret
800038ac:	00000513          	li	a0,0
}
800038b0:	00008067          	ret

800038b4 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
800038b4:	ff010113          	addi	sp,sp,-16
800038b8:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800038bc:	af0ff0ef          	jal	ra,80002bac <z_clock_elapsed>
800038c0:	800087b7          	lui	a5,0x80008
800038c4:	2f47a783          	lw	a5,756(a5) # 800082f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082f5>

	z_set_timeout_expiry(slice_time, false);
}
800038c8:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800038cc:	80009737          	lui	a4,0x80009
800038d0:	00a78533          	add	a0,a5,a0
800038d4:	94a72623          	sw	a0,-1716(a4) # 8000894c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000894d>
	z_set_timeout_expiry(slice_time, false);
800038d8:	00000593          	li	a1,0
800038dc:	00078513          	mv	a0,a5
}
800038e0:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
800038e4:	0210206f          	j	80006104 <z_set_timeout_expiry>

800038e8 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
800038e8:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
800038ec:	ff010113          	addi	sp,sp,-16
800038f0:	00812423          	sw	s0,8(sp)
800038f4:	00112623          	sw	ra,12(sp)
800038f8:	00912223          	sw	s1,4(sp)
800038fc:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80003900:	02079863          	bnez	a5,80003930 <pended_on.isra.15+0x48>
80003904:	800084b7          	lui	s1,0x80008
80003908:	800085b7          	lui	a1,0x80008
8000390c:	80008537          	lui	a0,0x80008
80003910:	e4058593          	addi	a1,a1,-448 # 80007e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e41>
80003914:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003918:	18300693          	li	a3,387
8000391c:	e2c48613          	addi	a2,s1,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80003920:	df1fe0ef          	jal	ra,80002710 <printk>
80003924:	18300593          	li	a1,387
80003928:	e2c48513          	addi	a0,s1,-468
8000392c:	e21fe0ef          	jal	ra,8000274c <assert_post_action>

	return thread->base.pended_on;
}
80003930:	00042503          	lw	a0,0(s0)
80003934:	00c12083          	lw	ra,12(sp)
80003938:	00812403          	lw	s0,8(sp)
8000393c:	00412483          	lw	s1,4(sp)
80003940:	01010113          	addi	sp,sp,16
80003944:	00008067          	ret

80003948 <k_sched_time_slice_set>:
{
80003948:	fe010113          	addi	sp,sp,-32
8000394c:	00812c23          	sw	s0,24(sp)
80003950:	01212823          	sw	s2,16(sp)
80003954:	01412423          	sw	s4,8(sp)
80003958:	00112e23          	sw	ra,28(sp)
8000395c:	00912a23          	sw	s1,20(sp)
80003960:	01312623          	sw	s3,12(sp)
80003964:	00050913          	mv	s2,a0
80003968:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000396c:	00800413          	li	s0,8
80003970:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003974:	800084b7          	lui	s1,0x80008
80003978:	2ec48513          	addi	a0,s1,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
8000397c:	00847413          	andi	s0,s0,8
80003980:	65d010ef          	jal	ra,800057dc <z_spin_lock_valid>
80003984:	02051e63          	bnez	a0,800039c0 <k_sched_time_slice_set+0x78>
80003988:	800089b7          	lui	s3,0x80008
8000398c:	800085b7          	lui	a1,0x80008
80003990:	80008537          	lui	a0,0x80008
80003994:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80003998:	04e00693          	li	a3,78
8000399c:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800039a0:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800039a4:	d6dfe0ef          	jal	ra,80002710 <printk>
800039a8:	80008537          	lui	a0,0x80008
800039ac:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
800039b0:	d61fe0ef          	jal	ra,80002710 <printk>
800039b4:	04e00593          	li	a1,78
800039b8:	bc498513          	addi	a0,s3,-1084
800039bc:	d91fe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
800039c0:	2ec48513          	addi	a0,s1,748
800039c4:	671010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
800039c8:	800097b7          	lui	a5,0x80009
800039cc:	9407a623          	sw	zero,-1716(a5) # 8000894c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000894d>
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800039d0:	00990913          	addi	s2,s2,9
800039d4:	00a00793          	li	a5,10
800039d8:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
800039dc:	800087b7          	lui	a5,0x80008
800039e0:	2f27aa23          	sw	s2,756(a5) # 800082f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082f5>
		slice_max_prio = prio;
800039e4:	800087b7          	lui	a5,0x80008
800039e8:	2f47a823          	sw	s4,752(a5) # 800082f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082f1>
		reset_time_slice();
800039ec:	ec9ff0ef          	jal	ra,800038b4 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800039f0:	2ec48513          	addi	a0,s1,748
800039f4:	611010ef          	jal	ra,80005804 <z_spin_unlock_valid>
800039f8:	02051e63          	bnez	a0,80003a34 <k_sched_time_slice_set+0xec>
800039fc:	800084b7          	lui	s1,0x80008
80003a00:	800085b7          	lui	a1,0x80008
80003a04:	80008537          	lui	a0,0x80008
80003a08:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80003a0c:	06100693          	li	a3,97
80003a10:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003a14:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003a18:	cf9fe0ef          	jal	ra,80002710 <printk>
80003a1c:	80008537          	lui	a0,0x80008
80003a20:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80003a24:	cedfe0ef          	jal	ra,80002710 <printk>
80003a28:	06100593          	li	a1,97
80003a2c:	bc448513          	addi	a0,s1,-1084
80003a30:	d1dfe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003a34:	30042473          	csrrs	s0,mstatus,s0
}
80003a38:	01c12083          	lw	ra,28(sp)
80003a3c:	01812403          	lw	s0,24(sp)
80003a40:	01412483          	lw	s1,20(sp)
80003a44:	01012903          	lw	s2,16(sp)
80003a48:	00c12983          	lw	s3,12(sp)
80003a4c:	00812a03          	lw	s4,8(sp)
80003a50:	02010113          	addi	sp,sp,32
80003a54:	00008067          	ret

80003a58 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80003a58:	fe010113          	addi	sp,sp,-32
80003a5c:	00812c23          	sw	s0,24(sp)
80003a60:	01212823          	sw	s2,16(sp)
80003a64:	00112e23          	sw	ra,28(sp)
80003a68:	00912a23          	sw	s1,20(sp)
80003a6c:	01312623          	sw	s3,12(sp)
80003a70:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a74:	00800413          	li	s0,8
80003a78:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a7c:	800084b7          	lui	s1,0x80008
80003a80:	2ec48513          	addi	a0,s1,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a84:	00847413          	andi	s0,s0,8
80003a88:	555010ef          	jal	ra,800057dc <z_spin_lock_valid>
80003a8c:	02051e63          	bnez	a0,80003ac8 <z_unpend_thread_no_timeout+0x70>
80003a90:	800089b7          	lui	s3,0x80008
80003a94:	800085b7          	lui	a1,0x80008
80003a98:	80008537          	lui	a0,0x80008
80003a9c:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80003aa0:	04e00693          	li	a3,78
80003aa4:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003aa8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003aac:	c65fe0ef          	jal	ra,80002710 <printk>
80003ab0:	80008537          	lui	a0,0x80008
80003ab4:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80003ab8:	c59fe0ef          	jal	ra,80002710 <printk>
80003abc:	04e00593          	li	a1,78
80003ac0:	bc498513          	addi	a0,s3,-1084
80003ac4:	c89fe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80003ac8:	2ec48513          	addi	a0,s1,748
80003acc:	569010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003ad0:	00890513          	addi	a0,s2,8
80003ad4:	e15ff0ef          	jal	ra,800038e8 <pended_on.isra.15>
80003ad8:	00090593          	mv	a1,s2
80003adc:	2f0000ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003ae0:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ae4:	2ec48513          	addi	a0,s1,748
80003ae8:	ffd7f793          	andi	a5,a5,-3
80003aec:	00f906a3          	sb	a5,13(s2)
80003af0:	515010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80003af4:	02051e63          	bnez	a0,80003b30 <z_unpend_thread_no_timeout+0xd8>
80003af8:	800084b7          	lui	s1,0x80008
80003afc:	800085b7          	lui	a1,0x80008
80003b00:	80008537          	lui	a0,0x80008
80003b04:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80003b08:	06100693          	li	a3,97
80003b0c:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003b10:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003b14:	bfdfe0ef          	jal	ra,80002710 <printk>
80003b18:	80008537          	lui	a0,0x80008
80003b1c:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80003b20:	bf1fe0ef          	jal	ra,80002710 <printk>
80003b24:	06100593          	li	a1,97
80003b28:	bc448513          	addi	a0,s1,-1084
80003b2c:	c21fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003b30:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003b34:	01c12083          	lw	ra,28(sp)
80003b38:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003b3c:	00092423          	sw	zero,8(s2)
}
80003b40:	01412483          	lw	s1,20(sp)
80003b44:	01012903          	lw	s2,16(sp)
80003b48:	00c12983          	lw	s3,12(sp)
80003b4c:	02010113          	addi	sp,sp,32
80003b50:	00008067          	ret

80003b54 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80003b54:	800097b7          	lui	a5,0x80009
80003b58:	93c7a783          	lw	a5,-1732(a5) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
{
80003b5c:	ff010113          	addi	sp,sp,-16
80003b60:	00812423          	sw	s0,8(sp)
80003b64:	00112623          	sw	ra,12(sp)
80003b68:	00912223          	sw	s1,4(sp)
80003b6c:	00058413          	mv	s0,a1
	if (resched()) {
80003b70:	04079e63          	bnez	a5,80003bcc <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b74:	491010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80003b78:	02051e63          	bnez	a0,80003bb4 <z_reschedule+0x60>
80003b7c:	800084b7          	lui	s1,0x80008
80003b80:	800085b7          	lui	a1,0x80008
80003b84:	80008537          	lui	a0,0x80008
80003b88:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80003b8c:	07800693          	li	a3,120
80003b90:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003b94:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003b98:	b79fe0ef          	jal	ra,80002710 <printk>
80003b9c:	80008537          	lui	a0,0x80008
80003ba0:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80003ba4:	b6dfe0ef          	jal	ra,80002710 <printk>
80003ba8:	07800593          	li	a1,120
80003bac:	bc448513          	addi	a0,s1,-1084
80003bb0:	b9dfe0ef          	jal	ra,8000274c <assert_post_action>
80003bb4:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80003bb8:	00812403          	lw	s0,8(sp)
80003bbc:	00c12083          	lw	ra,12(sp)
80003bc0:	00412483          	lw	s1,4(sp)
80003bc4:	01010113          	addi	sp,sp,16
80003bc8:	e70fc06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003bcc:	439010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80003bd0:	02051e63          	bnez	a0,80003c0c <z_reschedule+0xb8>
80003bd4:	800084b7          	lui	s1,0x80008
80003bd8:	800085b7          	lui	a1,0x80008
80003bdc:	80008537          	lui	a0,0x80008
80003be0:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80003be4:	06100693          	li	a3,97
80003be8:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003bec:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003bf0:	b21fe0ef          	jal	ra,80002710 <printk>
80003bf4:	80008537          	lui	a0,0x80008
80003bf8:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80003bfc:	b15fe0ef          	jal	ra,80002710 <printk>
80003c00:	06100593          	li	a1,97
80003c04:	bc448513          	addi	a0,s1,-1084
80003c08:	b45fe0ef          	jal	ra,8000274c <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003c0c:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c10:	30042473          	csrrs	s0,mstatus,s0
80003c14:	00c12083          	lw	ra,12(sp)
80003c18:	00812403          	lw	s0,8(sp)
80003c1c:	00412483          	lw	s1,4(sp)
80003c20:	01010113          	addi	sp,sp,16
80003c24:	00008067          	ret

80003c28 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003c28:	80009737          	lui	a4,0x80009
80003c2c:	93c72703          	lw	a4,-1732(a4) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80003c30:	00071463          	bnez	a4,80003c38 <z_reschedule_irqlock+0x10>
80003c34:	e04fc06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003c38:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c3c:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80003c40:	00008067          	ret

80003c44 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c44:	00800513          	li	a0,8
80003c48:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003c4c:	00857513          	andi	a0,a0,8
80003c50:	fd9ff06f          	j	80003c28 <z_reschedule_irqlock>

80003c54 <k_sched_lock>:

void k_sched_lock(void)
{
80003c54:	fe010113          	addi	sp,sp,-32
80003c58:	00812c23          	sw	s0,24(sp)
80003c5c:	00112e23          	sw	ra,28(sp)
80003c60:	00912a23          	sw	s1,20(sp)
80003c64:	01212823          	sw	s2,16(sp)
80003c68:	01312623          	sw	s3,12(sp)
80003c6c:	00800413          	li	s0,8
80003c70:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c74:	800084b7          	lui	s1,0x80008
80003c78:	2ec48513          	addi	a0,s1,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c7c:	00847413          	andi	s0,s0,8
80003c80:	35d010ef          	jal	ra,800057dc <z_spin_lock_valid>
80003c84:	02051e63          	bnez	a0,80003cc0 <k_sched_lock+0x6c>
80003c88:	80008937          	lui	s2,0x80008
80003c8c:	800085b7          	lui	a1,0x80008
80003c90:	80008537          	lui	a0,0x80008
80003c94:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80003c98:	04e00693          	li	a3,78
80003c9c:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003ca0:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003ca4:	a6dfe0ef          	jal	ra,80002710 <printk>
80003ca8:	80008537          	lui	a0,0x80008
80003cac:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80003cb0:	a61fe0ef          	jal	ra,80002710 <printk>
80003cb4:	04e00593          	li	a1,78
80003cb8:	bc490513          	addi	a0,s2,-1084
80003cbc:	a91fe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80003cc0:	2ec48513          	addi	a0,s1,748
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80003cc4:	80009937          	lui	s2,0x80009
80003cc8:	36d010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
80003ccc:	93c92783          	lw	a5,-1732(s2) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80003cd0:	93c90913          	addi	s2,s2,-1732
80003cd4:	02078e63          	beqz	a5,80003d10 <k_sched_lock+0xbc>
80003cd8:	800089b7          	lui	s3,0x80008
80003cdc:	800085b7          	lui	a1,0x80008
80003ce0:	80008537          	lui	a0,0x80008
80003ce4:	dc458593          	addi	a1,a1,-572 # 80007dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc5>
80003ce8:	10000693          	li	a3,256
80003cec:	da898613          	addi	a2,s3,-600 # 80007da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007da9>
80003cf0:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003cf4:	a1dfe0ef          	jal	ra,80002710 <printk>
80003cf8:	80008537          	lui	a0,0x80008
80003cfc:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80003d00:	a11fe0ef          	jal	ra,80002710 <printk>
80003d04:	10000593          	li	a1,256
80003d08:	da898513          	addi	a0,s3,-600
80003d0c:	a41fe0ef          	jal	ra,8000274c <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80003d10:	00892783          	lw	a5,8(s2)
80003d14:	00f7c703          	lbu	a4,15(a5)
80003d18:	00100793          	li	a5,1
80003d1c:	02f71e63          	bne	a4,a5,80003d58 <k_sched_lock+0x104>
80003d20:	800089b7          	lui	s3,0x80008
80003d24:	800085b7          	lui	a1,0x80008
80003d28:	80008537          	lui	a0,0x80008
80003d2c:	ddc58593          	addi	a1,a1,-548 # 80007ddc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ddd>
80003d30:	10100693          	li	a3,257
80003d34:	da898613          	addi	a2,s3,-600 # 80007da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007da9>
80003d38:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003d3c:	9d5fe0ef          	jal	ra,80002710 <printk>
80003d40:	80008537          	lui	a0,0x80008
80003d44:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80003d48:	9c9fe0ef          	jal	ra,80002710 <printk>
80003d4c:	10100593          	li	a1,257
80003d50:	da898513          	addi	a0,s3,-600
80003d54:	9f9fe0ef          	jal	ra,8000274c <assert_post_action>

	--_current->base.sched_locked;
80003d58:	00892703          	lw	a4,8(s2)
80003d5c:	00f74783          	lbu	a5,15(a4)
80003d60:	fff78793          	addi	a5,a5,-1
80003d64:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003d68:	2ec48513          	addi	a0,s1,748
80003d6c:	299010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80003d70:	02051e63          	bnez	a0,80003dac <k_sched_lock+0x158>
80003d74:	800084b7          	lui	s1,0x80008
80003d78:	800085b7          	lui	a1,0x80008
80003d7c:	80008537          	lui	a0,0x80008
80003d80:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80003d84:	06100693          	li	a3,97
80003d88:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003d8c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003d90:	981fe0ef          	jal	ra,80002710 <printk>
80003d94:	80008537          	lui	a0,0x80008
80003d98:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80003d9c:	975fe0ef          	jal	ra,80002710 <printk>
80003da0:	06100593          	li	a1,97
80003da4:	bc448513          	addi	a0,s1,-1084
80003da8:	9a5fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003dac:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80003db0:	01c12083          	lw	ra,28(sp)
80003db4:	01812403          	lw	s0,24(sp)
80003db8:	01412483          	lw	s1,20(sp)
80003dbc:	01012903          	lw	s2,16(sp)
80003dc0:	00c12983          	lw	s3,12(sp)
80003dc4:	02010113          	addi	sp,sp,32
80003dc8:	00008067          	ret

80003dcc <z_priq_dumb_remove>:
	return thread == _idle_thread;
80003dcc:	800087b7          	lui	a5,0x80008
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80003dd0:	2787a783          	lw	a5,632(a5) # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
{
80003dd4:	ff010113          	addi	sp,sp,-16
80003dd8:	00812423          	sw	s0,8(sp)
80003ddc:	00112623          	sw	ra,12(sp)
80003de0:	00912223          	sw	s1,4(sp)
80003de4:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80003de8:	02f59863          	bne	a1,a5,80003e18 <z_priq_dumb_remove+0x4c>
80003dec:	800084b7          	lui	s1,0x80008
80003df0:	800085b7          	lui	a1,0x80008
80003df4:	80008537          	lui	a0,0x80008
80003df8:	f4458593          	addi	a1,a1,-188 # 80007f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f45>
80003dfc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003e00:	28c00693          	li	a3,652
80003e04:	e2c48613          	addi	a2,s1,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80003e08:	909fe0ef          	jal	ra,80002710 <printk>
80003e0c:	28c00593          	li	a1,652
80003e10:	e2c48513          	addi	a0,s1,-468
80003e14:	939fe0ef          	jal	ra,8000274c <assert_post_action>
	node->prev->next = node->next;
80003e18:	00442703          	lw	a4,4(s0)
80003e1c:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80003e20:	00c12083          	lw	ra,12(sp)
80003e24:	00412483          	lw	s1,4(sp)
80003e28:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003e2c:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80003e30:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80003e34:	00042223          	sw	zero,4(s0)
80003e38:	00812403          	lw	s0,8(sp)
80003e3c:	01010113          	addi	sp,sp,16
80003e40:	00008067          	ret

80003e44 <z_unpend_thread>:
{
80003e44:	fe010113          	addi	sp,sp,-32
80003e48:	00812c23          	sw	s0,24(sp)
80003e4c:	00912a23          	sw	s1,20(sp)
80003e50:	00112e23          	sw	ra,28(sp)
80003e54:	01212823          	sw	s2,16(sp)
80003e58:	01312623          	sw	s3,12(sp)
80003e5c:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e60:	00800493          	li	s1,8
80003e64:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e68:	80008937          	lui	s2,0x80008
80003e6c:	2ec90513          	addi	a0,s2,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e70:	0084f493          	andi	s1,s1,8
80003e74:	169010ef          	jal	ra,800057dc <z_spin_lock_valid>
80003e78:	02051e63          	bnez	a0,80003eb4 <z_unpend_thread+0x70>
80003e7c:	800089b7          	lui	s3,0x80008
80003e80:	800085b7          	lui	a1,0x80008
80003e84:	80008537          	lui	a0,0x80008
80003e88:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80003e8c:	04e00693          	li	a3,78
80003e90:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003e94:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003e98:	879fe0ef          	jal	ra,80002710 <printk>
80003e9c:	80008537          	lui	a0,0x80008
80003ea0:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80003ea4:	86dfe0ef          	jal	ra,80002710 <printk>
80003ea8:	04e00593          	li	a1,78
80003eac:	bc498513          	addi	a0,s3,-1084
80003eb0:	89dfe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80003eb4:	2ec90513          	addi	a0,s2,748
80003eb8:	17d010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003ebc:	00840513          	addi	a0,s0,8
80003ec0:	a29ff0ef          	jal	ra,800038e8 <pended_on.isra.15>
80003ec4:	00040593          	mv	a1,s0
80003ec8:	f05ff0ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003ecc:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ed0:	2ec90513          	addi	a0,s2,748
80003ed4:	ffd7f793          	andi	a5,a5,-3
80003ed8:	00f406a3          	sb	a5,13(s0)
80003edc:	129010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80003ee0:	02051e63          	bnez	a0,80003f1c <z_unpend_thread+0xd8>
80003ee4:	80008937          	lui	s2,0x80008
80003ee8:	800085b7          	lui	a1,0x80008
80003eec:	80008537          	lui	a0,0x80008
80003ef0:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80003ef4:	06100693          	li	a3,97
80003ef8:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80003efc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003f00:	811fe0ef          	jal	ra,80002710 <printk>
80003f04:	80008537          	lui	a0,0x80008
80003f08:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80003f0c:	805fe0ef          	jal	ra,80002710 <printk>
80003f10:	06100593          	li	a1,97
80003f14:	bc490513          	addi	a0,s2,-1084
80003f18:	835fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f1c:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003f20:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003f24:	01840513          	addi	a0,s0,24
}
80003f28:	01812403          	lw	s0,24(sp)
80003f2c:	01c12083          	lw	ra,28(sp)
80003f30:	01412483          	lw	s1,20(sp)
80003f34:	01012903          	lw	s2,16(sp)
80003f38:	00c12983          	lw	s3,12(sp)
80003f3c:	02010113          	addi	sp,sp,32
80003f40:	7f10106f          	j	80005f30 <z_abort_timeout>

80003f44 <z_priq_dumb_best>:
	return list->head == list;
80003f44:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003f48:	00f51463          	bne	a0,a5,80003f50 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003f4c:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80003f50:	00078513          	mv	a0,a5
80003f54:	00008067          	ret

80003f58 <update_cache>:
{
80003f58:	ff010113          	addi	sp,sp,-16
80003f5c:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003f60:	80009437          	lui	s0,0x80009
{
80003f64:	01212023          	sw	s2,0(sp)
80003f68:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003f6c:	93c40513          	addi	a0,s0,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80003f70:	02450513          	addi	a0,a0,36
{
80003f74:	00912223          	sw	s1,4(sp)
80003f78:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003f7c:	fc9ff0ef          	jal	ra,80003f44 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80003f80:	93c40413          	addi	s0,s0,-1732
80003f84:	00050493          	mv	s1,a0
80003f88:	00051463          	bnez	a0,80003f90 <update_cache+0x38>
80003f8c:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
80003f90:	06091e63          	bnez	s2,8000400c <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80003f94:	00842783          	lw	a5,8(s0)
80003f98:	02079e63          	bnez	a5,80003fd4 <update_cache+0x7c>
80003f9c:	80008937          	lui	s2,0x80008
80003fa0:	800085b7          	lui	a1,0x80008
80003fa4:	80008537          	lui	a0,0x80008
80003fa8:	e5858593          	addi	a1,a1,-424 # 80007e58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e59>
80003fac:	07f00693          	li	a3,127
80003fb0:	e2c90613          	addi	a2,s2,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80003fb4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80003fb8:	f58fe0ef          	jal	ra,80002710 <printk>
80003fbc:	80008537          	lui	a0,0x80008
80003fc0:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80003fc4:	f4cfe0ef          	jal	ra,80002710 <printk>
80003fc8:	07f00593          	li	a1,127
80003fcc:	e2c90513          	addi	a0,s2,-468
80003fd0:	f7cfe0ef          	jal	ra,8000274c <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003fd4:	00842783          	lw	a5,8(s0)
80003fd8:	00d7c703          	lbu	a4,13(a5)
80003fdc:	01f77713          	andi	a4,a4,31
80003fe0:	02071663          	bnez	a4,8000400c <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80003fe4:	00e7d683          	lhu	a3,14(a5)
80003fe8:	07f00713          	li	a4,127
80003fec:	02d77063          	bgeu	a4,a3,8000400c <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80003ff0:	02f42023          	sw	a5,32(s0)
}
80003ff4:	00c12083          	lw	ra,12(sp)
80003ff8:	00812403          	lw	s0,8(sp)
80003ffc:	00412483          	lw	s1,4(sp)
80004000:	00012903          	lw	s2,0(sp)
80004004:	01010113          	addi	sp,sp,16
80004008:	00008067          	ret
		if (th != _current) {
8000400c:	00842783          	lw	a5,8(s0)
80004010:	00978463          	beq	a5,s1,80004018 <update_cache+0xc0>
			reset_time_slice();
80004014:	8a1ff0ef          	jal	ra,800038b4 <reset_time_slice>
		_kernel.ready_q.cache = th;
80004018:	02942023          	sw	s1,32(s0)
}
8000401c:	fd9ff06f          	j	80003ff4 <update_cache+0x9c>

80004020 <k_sched_unlock>:
{
80004020:	fe010113          	addi	sp,sp,-32
80004024:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80004028:	80009937          	lui	s2,0x80009
8000402c:	93c90793          	addi	a5,s2,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80004030:	0087a783          	lw	a5,8(a5)
{
80004034:	00112e23          	sw	ra,28(sp)
80004038:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
8000403c:	00f7c783          	lbu	a5,15(a5)
{
80004040:	00912a23          	sw	s1,20(sp)
80004044:	01312623          	sw	s3,12(sp)
80004048:	93c90913          	addi	s2,s2,-1732
	__ASSERT(_current->base.sched_locked != 0, "");
8000404c:	02079e63          	bnez	a5,80004088 <k_sched_unlock+0x68>
80004050:	80008437          	lui	s0,0x80008
80004054:	800085b7          	lui	a1,0x80008
80004058:	80008537          	lui	a0,0x80008
8000405c:	e0458593          	addi	a1,a1,-508 # 80007e04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e05>
80004060:	22100693          	li	a3,545
80004064:	e2c40613          	addi	a2,s0,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004068:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000406c:	ea4fe0ef          	jal	ra,80002710 <printk>
80004070:	80008537          	lui	a0,0x80008
80004074:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80004078:	e98fe0ef          	jal	ra,80002710 <printk>
8000407c:	22100593          	li	a1,545
80004080:	e2c40513          	addi	a0,s0,-468
80004084:	ec8fe0ef          	jal	ra,8000274c <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80004088:	00092783          	lw	a5,0(s2)
8000408c:	02078e63          	beqz	a5,800040c8 <k_sched_unlock+0xa8>
80004090:	80008437          	lui	s0,0x80008
80004094:	800085b7          	lui	a1,0x80008
80004098:	80008537          	lui	a0,0x80008
8000409c:	dc458593          	addi	a1,a1,-572 # 80007dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc5>
800040a0:	22200693          	li	a3,546
800040a4:	e2c40613          	addi	a2,s0,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
800040a8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800040ac:	e64fe0ef          	jal	ra,80002710 <printk>
800040b0:	80008537          	lui	a0,0x80008
800040b4:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
800040b8:	e58fe0ef          	jal	ra,80002710 <printk>
800040bc:	22200593          	li	a1,546
800040c0:	e2c40513          	addi	a0,s0,-468
800040c4:	e88fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040c8:	00800413          	li	s0,8
800040cc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040d0:	800084b7          	lui	s1,0x80008
800040d4:	2ec48513          	addi	a0,s1,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800040d8:	00847413          	andi	s0,s0,8
800040dc:	700010ef          	jal	ra,800057dc <z_spin_lock_valid>
800040e0:	02051e63          	bnez	a0,8000411c <k_sched_unlock+0xfc>
800040e4:	800089b7          	lui	s3,0x80008
800040e8:	800085b7          	lui	a1,0x80008
800040ec:	80008537          	lui	a0,0x80008
800040f0:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800040f4:	04e00693          	li	a3,78
800040f8:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800040fc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004100:	e10fe0ef          	jal	ra,80002710 <printk>
80004104:	80008537          	lui	a0,0x80008
80004108:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
8000410c:	e04fe0ef          	jal	ra,80002710 <printk>
80004110:	04e00593          	li	a1,78
80004114:	bc498513          	addi	a0,s3,-1084
80004118:	e34fe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
8000411c:	2ec48513          	addi	a0,s1,748
80004120:	714010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80004124:	00892703          	lw	a4,8(s2)
		update_cache(1);
80004128:	00100513          	li	a0,1
		++_current->base.sched_locked;
8000412c:	00f74783          	lbu	a5,15(a4)
80004130:	00178793          	addi	a5,a5,1
80004134:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80004138:	e21ff0ef          	jal	ra,80003f58 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000413c:	2ec48513          	addi	a0,s1,748
80004140:	6c4010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80004144:	02051e63          	bnez	a0,80004180 <k_sched_unlock+0x160>
80004148:	800084b7          	lui	s1,0x80008
8000414c:	800085b7          	lui	a1,0x80008
80004150:	80008537          	lui	a0,0x80008
80004154:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80004158:	06100693          	li	a3,97
8000415c:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004160:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004164:	dacfe0ef          	jal	ra,80002710 <printk>
80004168:	80008537          	lui	a0,0x80008
8000416c:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80004170:	da0fe0ef          	jal	ra,80002710 <printk>
80004174:	06100593          	li	a1,97
80004178:	bc448513          	addi	a0,s1,-1084
8000417c:	dd0fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004180:	30042473          	csrrs	s0,mstatus,s0
}
80004184:	01812403          	lw	s0,24(sp)
80004188:	01c12083          	lw	ra,28(sp)
8000418c:	01412483          	lw	s1,20(sp)
80004190:	01012903          	lw	s2,16(sp)
80004194:	00c12983          	lw	s3,12(sp)
80004198:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
8000419c:	aa9ff06f          	j	80003c44 <z_reschedule_unlocked>

800041a0 <z_add_thread_to_ready_q>:
{
800041a0:	fe010113          	addi	sp,sp,-32
800041a4:	00812c23          	sw	s0,24(sp)
800041a8:	00912a23          	sw	s1,20(sp)
800041ac:	00112e23          	sw	ra,28(sp)
800041b0:	01212823          	sw	s2,16(sp)
800041b4:	01312623          	sw	s3,12(sp)
800041b8:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041bc:	00800493          	li	s1,8
800041c0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800041c4:	80008937          	lui	s2,0x80008
800041c8:	2ec90513          	addi	a0,s2,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800041cc:	0084f493          	andi	s1,s1,8
800041d0:	60c010ef          	jal	ra,800057dc <z_spin_lock_valid>
800041d4:	02051e63          	bnez	a0,80004210 <z_add_thread_to_ready_q+0x70>
800041d8:	800089b7          	lui	s3,0x80008
800041dc:	800085b7          	lui	a1,0x80008
800041e0:	80008537          	lui	a0,0x80008
800041e4:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800041e8:	04e00693          	li	a3,78
800041ec:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800041f0:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800041f4:	d1cfe0ef          	jal	ra,80002710 <printk>
800041f8:	80008537          	lui	a0,0x80008
800041fc:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80004200:	d10fe0ef          	jal	ra,80002710 <printk>
80004204:	04e00593          	li	a1,78
80004208:	bc498513          	addi	a0,s3,-1084
8000420c:	d40fe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80004210:	2ec90513          	addi	a0,s2,748
80004214:	620010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80004218:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
8000421c:	2787a783          	lw	a5,632(a5) # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
80004220:	02f41863          	bne	s0,a5,80004250 <z_add_thread_to_ready_q+0xb0>
80004224:	800089b7          	lui	s3,0x80008
80004228:	800085b7          	lui	a1,0x80008
8000422c:	80008537          	lui	a0,0x80008
80004230:	f4458593          	addi	a1,a1,-188 # 80007f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f45>
80004234:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004238:	27600693          	li	a3,630
8000423c:	e2c98613          	addi	a2,s3,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004240:	cd0fe0ef          	jal	ra,80002710 <printk>
80004244:	27600593          	li	a1,630
80004248:	e2c98513          	addi	a0,s3,-468
8000424c:	d00fe0ef          	jal	ra,8000274c <assert_post_action>
	return list->head == list;
80004250:	80009737          	lui	a4,0x80009
80004254:	93c70693          	addi	a3,a4,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80004258:	0246a783          	lw	a5,36(a3)
8000425c:	0286a603          	lw	a2,40(a3)
80004260:	800096b7          	lui	a3,0x80009
80004264:	96068693          	addi	a3,a3,-1696 # 80008960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008961>
80004268:	93c70713          	addi	a4,a4,-1732
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000426c:	0ad78663          	beq	a5,a3,80004318 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004270:	0a078463          	beqz	a5,80004318 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80004274:	00e40583          	lb	a1,14(s0)
80004278:	00e78503          	lb	a0,14(a5)
8000427c:	08a5d863          	bge	a1,a0,8000430c <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80004280:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004284:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004288:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
8000428c:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004290:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80004294:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80004298:	00000513          	li	a0,0
8000429c:	0407e793          	ori	a5,a5,64
800042a0:	00f406a3          	sb	a5,13(s0)
800042a4:	cb5ff0ef          	jal	ra,80003f58 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800042a8:	2ec90513          	addi	a0,s2,748
800042ac:	558010ef          	jal	ra,80005804 <z_spin_unlock_valid>
800042b0:	02051e63          	bnez	a0,800042ec <z_add_thread_to_ready_q+0x14c>
800042b4:	80008437          	lui	s0,0x80008
800042b8:	800085b7          	lui	a1,0x80008
800042bc:	80008537          	lui	a0,0x80008
800042c0:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800042c4:	06100693          	li	a3,97
800042c8:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800042cc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800042d0:	c40fe0ef          	jal	ra,80002710 <printk>
800042d4:	80008537          	lui	a0,0x80008
800042d8:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800042dc:	c34fe0ef          	jal	ra,80002710 <printk>
800042e0:	06100593          	li	a1,97
800042e4:	bc440513          	addi	a0,s0,-1084
800042e8:	c64fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042ec:	3004a4f3          	csrrs	s1,mstatus,s1
}
800042f0:	01c12083          	lw	ra,28(sp)
800042f4:	01812403          	lw	s0,24(sp)
800042f8:	01412483          	lw	s1,20(sp)
800042fc:	01012903          	lw	s2,16(sp)
80004300:	00c12983          	lw	s3,12(sp)
80004304:	02010113          	addi	sp,sp,32
80004308:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
8000430c:	00f60663          	beq	a2,a5,80004318 <z_add_thread_to_ready_q+0x178>
80004310:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004314:	f60792e3          	bnez	a5,80004278 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80004318:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
8000431c:	02872783          	lw	a5,40(a4)
	node->next = list;
80004320:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80004324:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004328:	02872423          	sw	s0,40(a4)
8000432c:	f69ff06f          	j	80004294 <z_add_thread_to_ready_q+0xf4>

80004330 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80004330:	ff052783          	lw	a5,-16(a0)
{
80004334:	fe010113          	addi	sp,sp,-32
80004338:	00812c23          	sw	s0,24(sp)
8000433c:	01312623          	sw	s3,12(sp)
80004340:	00112e23          	sw	ra,28(sp)
80004344:	00912a23          	sw	s1,20(sp)
80004348:	01212823          	sw	s2,16(sp)
8000434c:	01412423          	sw	s4,8(sp)
80004350:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80004354:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80004358:	0c078463          	beqz	a5,80004420 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000435c:	00800493          	li	s1,8
80004360:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004364:	80008937          	lui	s2,0x80008
80004368:	2ec90513          	addi	a0,s2,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
8000436c:	0084f493          	andi	s1,s1,8
80004370:	46c010ef          	jal	ra,800057dc <z_spin_lock_valid>
80004374:	02051e63          	bnez	a0,800043b0 <z_thread_timeout+0x80>
80004378:	80008a37          	lui	s4,0x80008
8000437c:	800085b7          	lui	a1,0x80008
80004380:	80008537          	lui	a0,0x80008
80004384:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80004388:	04e00693          	li	a3,78
8000438c:	bc4a0613          	addi	a2,s4,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004390:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004394:	b7cfe0ef          	jal	ra,80002710 <printk>
80004398:	80008537          	lui	a0,0x80008
8000439c:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
800043a0:	b70fe0ef          	jal	ra,80002710 <printk>
800043a4:	04e00593          	li	a1,78
800043a8:	bc4a0513          	addi	a0,s4,-1084
800043ac:	ba0fe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
800043b0:	2ec90513          	addi	a0,s2,748
800043b4:	480010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800043b8:	ff040513          	addi	a0,s0,-16
800043bc:	d2cff0ef          	jal	ra,800038e8 <pended_on.isra.15>
800043c0:	00098593          	mv	a1,s3
800043c4:	a09ff0ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800043c8:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800043cc:	2ec90513          	addi	a0,s2,748
800043d0:	ffd7f793          	andi	a5,a5,-3
800043d4:	fef40aa3          	sb	a5,-11(s0)
800043d8:	42c010ef          	jal	ra,80005804 <z_spin_unlock_valid>
800043dc:	02051e63          	bnez	a0,80004418 <z_thread_timeout+0xe8>
800043e0:	80008937          	lui	s2,0x80008
800043e4:	800085b7          	lui	a1,0x80008
800043e8:	80008537          	lui	a0,0x80008
800043ec:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800043f0:	06100693          	li	a3,97
800043f4:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800043f8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800043fc:	b14fe0ef          	jal	ra,80002710 <printk>
80004400:	80008537          	lui	a0,0x80008
80004404:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80004408:	b08fe0ef          	jal	ra,80002710 <printk>
8000440c:	06100593          	li	a1,97
80004410:	bc490513          	addi	a0,s2,-1084
80004414:	b38fe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004418:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000441c:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80004420:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80004424:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80004428:	feb7f793          	andi	a5,a5,-21
8000442c:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80004430:	c64ff0ef          	jal	ra,80003894 <z_is_thread_ready>
80004434:	02050463          	beqz	a0,8000445c <z_thread_timeout+0x12c>
}
80004438:	01812403          	lw	s0,24(sp)
8000443c:	01c12083          	lw	ra,28(sp)
80004440:	01412483          	lw	s1,20(sp)
80004444:	01012903          	lw	s2,16(sp)
80004448:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
8000444c:	00098513          	mv	a0,s3
80004450:	00c12983          	lw	s3,12(sp)
80004454:	02010113          	addi	sp,sp,32
80004458:	d49ff06f          	j	800041a0 <z_add_thread_to_ready_q>
8000445c:	01c12083          	lw	ra,28(sp)
80004460:	01812403          	lw	s0,24(sp)
80004464:	01412483          	lw	s1,20(sp)
80004468:	01012903          	lw	s2,16(sp)
8000446c:	00c12983          	lw	s3,12(sp)
80004470:	00812a03          	lw	s4,8(sp)
80004474:	02010113          	addi	sp,sp,32
80004478:	00008067          	ret

8000447c <z_move_thread_to_end_of_prio_q>:
{
8000447c:	fe010113          	addi	sp,sp,-32
80004480:	00812c23          	sw	s0,24(sp)
80004484:	01212823          	sw	s2,16(sp)
80004488:	00112e23          	sw	ra,28(sp)
8000448c:	00912a23          	sw	s1,20(sp)
80004490:	01312623          	sw	s3,12(sp)
80004494:	01412423          	sw	s4,8(sp)
80004498:	01512223          	sw	s5,4(sp)
8000449c:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800044a0:	00800913          	li	s2,8
800044a4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044a8:	800089b7          	lui	s3,0x80008
800044ac:	2ec98513          	addi	a0,s3,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800044b0:	00897913          	andi	s2,s2,8
800044b4:	328010ef          	jal	ra,800057dc <z_spin_lock_valid>
800044b8:	02051e63          	bnez	a0,800044f4 <z_move_thread_to_end_of_prio_q+0x78>
800044bc:	800084b7          	lui	s1,0x80008
800044c0:	800085b7          	lui	a1,0x80008
800044c4:	80008537          	lui	a0,0x80008
800044c8:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800044cc:	04e00693          	li	a3,78
800044d0:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800044d4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800044d8:	a38fe0ef          	jal	ra,80002710 <printk>
800044dc:	80008537          	lui	a0,0x80008
800044e0:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
800044e4:	a2cfe0ef          	jal	ra,80002710 <printk>
800044e8:	04e00593          	li	a1,78
800044ec:	bc448513          	addi	a0,s1,-1084
800044f0:	a5cfe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
800044f4:	2ec98513          	addi	a0,s3,748
800044f8:	33c010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800044fc:	800094b7          	lui	s1,0x80009
80004500:	93c48513          	addi	a0,s1,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80004504:	00040593          	mv	a1,s0
80004508:	02450513          	addi	a0,a0,36
8000450c:	8c1ff0ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	return thread == _idle_thread;
80004510:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
80004514:	2787a783          	lw	a5,632(a5) # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
80004518:	80009a37          	lui	s4,0x80009
8000451c:	93c48493          	addi	s1,s1,-1732
80004520:	960a0a13          	addi	s4,s4,-1696 # 80008960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008961>
80004524:	02f41863          	bne	s0,a5,80004554 <z_move_thread_to_end_of_prio_q+0xd8>
80004528:	80008ab7          	lui	s5,0x80008
8000452c:	800085b7          	lui	a1,0x80008
80004530:	80008537          	lui	a0,0x80008
80004534:	f4458593          	addi	a1,a1,-188 # 80007f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f45>
80004538:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000453c:	27600693          	li	a3,630
80004540:	e2ca8613          	addi	a2,s5,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004544:	9ccfe0ef          	jal	ra,80002710 <printk>
80004548:	27600593          	li	a1,630
8000454c:	e2ca8513          	addi	a0,s5,-468
80004550:	9fcfe0ef          	jal	ra,8000274c <assert_post_action>
	return list->head == list;
80004554:	0244a783          	lw	a5,36(s1)
80004558:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000455c:	0b478e63          	beq	a5,s4,80004618 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004560:	0a078c63          	beqz	a5,80004618 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80004564:	00e40683          	lb	a3,14(s0)
80004568:	00e78603          	lb	a2,14(a5)
8000456c:	0ac6d063          	bge	a3,a2,8000460c <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80004570:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004574:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004578:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
8000457c:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004580:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80004584:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80004588:	0084a503          	lw	a0,8(s1)
8000458c:	0407e793          	ori	a5,a5,64
80004590:	40850533          	sub	a0,a0,s0
80004594:	00153513          	seqz	a0,a0
80004598:	00f406a3          	sb	a5,13(s0)
8000459c:	9bdff0ef          	jal	ra,80003f58 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800045a0:	2ec98513          	addi	a0,s3,748
800045a4:	260010ef          	jal	ra,80005804 <z_spin_unlock_valid>
800045a8:	02051e63          	bnez	a0,800045e4 <z_move_thread_to_end_of_prio_q+0x168>
800045ac:	80008437          	lui	s0,0x80008
800045b0:	800085b7          	lui	a1,0x80008
800045b4:	80008537          	lui	a0,0x80008
800045b8:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800045bc:	06100693          	li	a3,97
800045c0:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800045c4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800045c8:	948fe0ef          	jal	ra,80002710 <printk>
800045cc:	80008537          	lui	a0,0x80008
800045d0:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800045d4:	93cfe0ef          	jal	ra,80002710 <printk>
800045d8:	06100593          	li	a1,97
800045dc:	bc440513          	addi	a0,s0,-1084
800045e0:	96cfe0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800045e4:	30092973          	csrrs	s2,mstatus,s2
}
800045e8:	01c12083          	lw	ra,28(sp)
800045ec:	01812403          	lw	s0,24(sp)
800045f0:	01412483          	lw	s1,20(sp)
800045f4:	01012903          	lw	s2,16(sp)
800045f8:	00c12983          	lw	s3,12(sp)
800045fc:	00812a03          	lw	s4,8(sp)
80004600:	00412a83          	lw	s5,4(sp)
80004604:	02010113          	addi	sp,sp,32
80004608:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
8000460c:	00e78663          	beq	a5,a4,80004618 <z_move_thread_to_end_of_prio_q+0x19c>
80004610:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004614:	f4079ae3          	bnez	a5,80004568 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80004618:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
8000461c:	0284a783          	lw	a5,40(s1)
	node->next = list;
80004620:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80004624:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004628:	0284a423          	sw	s0,40(s1)
8000462c:	f59ff06f          	j	80004584 <z_move_thread_to_end_of_prio_q+0x108>

80004630 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80004630:	800087b7          	lui	a5,0x80008
80004634:	2f47a783          	lw	a5,756(a5) # 800082f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082f5>
80004638:	06078663          	beqz	a5,800046a4 <z_time_slice+0x74>
8000463c:	800097b7          	lui	a5,0x80009
80004640:	93c78793          	addi	a5,a5,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80004644:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80004648:	07f00693          	li	a3,127
8000464c:	00e75603          	lhu	a2,14(a4)
80004650:	04c6ea63          	bltu	a3,a2,800046a4 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80004654:	800086b7          	lui	a3,0x80008
80004658:	00e70603          	lb	a2,14(a4)
8000465c:	2f06a683          	lw	a3,752(a3) # 800082f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082f1>
80004660:	04d64263          	blt	a2,a3,800046a4 <z_time_slice+0x74>
	return thread == _idle_thread;
80004664:	800086b7          	lui	a3,0x80008
		&& !is_idle(t)
80004668:	2786a683          	lw	a3,632(a3) # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
8000466c:	02d70c63          	beq	a4,a3,800046a4 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80004670:	01872683          	lw	a3,24(a4)
80004674:	02069863          	bnez	a3,800046a4 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80004678:	0107a683          	lw	a3,16(a5)
8000467c:	02d54063          	blt	a0,a3,8000469c <z_time_slice+0x6c>
{
80004680:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80004684:	00070513          	mv	a0,a4
{
80004688:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
8000468c:	df1ff0ef          	jal	ra,8000447c <z_move_thread_to_end_of_prio_q>
}
80004690:	00c12083          	lw	ra,12(sp)
80004694:	01010113          	addi	sp,sp,16
			reset_time_slice();
80004698:	a1cff06f          	j	800038b4 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
8000469c:	40a686b3          	sub	a3,a3,a0
800046a0:	00d7a823          	sw	a3,16(a5)
800046a4:	00008067          	ret

800046a8 <z_remove_thread_from_ready_q>:
{
800046a8:	fe010113          	addi	sp,sp,-32
800046ac:	00812c23          	sw	s0,24(sp)
800046b0:	01312623          	sw	s3,12(sp)
800046b4:	00112e23          	sw	ra,28(sp)
800046b8:	00912a23          	sw	s1,20(sp)
800046bc:	01212823          	sw	s2,16(sp)
800046c0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800046c4:	00800413          	li	s0,8
800046c8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800046cc:	800084b7          	lui	s1,0x80008
800046d0:	2ec48513          	addi	a0,s1,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800046d4:	00847413          	andi	s0,s0,8
800046d8:	104010ef          	jal	ra,800057dc <z_spin_lock_valid>
800046dc:	02051e63          	bnez	a0,80004718 <z_remove_thread_from_ready_q+0x70>
800046e0:	80008937          	lui	s2,0x80008
800046e4:	800085b7          	lui	a1,0x80008
800046e8:	80008537          	lui	a0,0x80008
800046ec:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800046f0:	04e00693          	li	a3,78
800046f4:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800046f8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800046fc:	814fe0ef          	jal	ra,80002710 <printk>
80004700:	80008537          	lui	a0,0x80008
80004704:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80004708:	808fe0ef          	jal	ra,80002710 <printk>
8000470c:	04e00593          	li	a1,78
80004710:	bc490513          	addi	a0,s2,-1084
80004714:	838fe0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80004718:	2ec48513          	addi	a0,s1,748
8000471c:	118010ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80004720:	00d9c783          	lbu	a5,13(s3)
80004724:	80009937          	lui	s2,0x80009
80004728:	93c90913          	addi	s2,s2,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
8000472c:	0407f793          	andi	a5,a5,64
80004730:	00078e63          	beqz	a5,8000474c <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80004734:	00098593          	mv	a1,s3
80004738:	02490513          	addi	a0,s2,36
8000473c:	e90ff0ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80004740:	00d9c783          	lbu	a5,13(s3)
80004744:	fbf7f793          	andi	a5,a5,-65
80004748:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
8000474c:	00892503          	lw	a0,8(s2)
80004750:	41350533          	sub	a0,a0,s3
80004754:	00153513          	seqz	a0,a0
80004758:	801ff0ef          	jal	ra,80003f58 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000475c:	2ec48513          	addi	a0,s1,748
80004760:	0a4010ef          	jal	ra,80005804 <z_spin_unlock_valid>
80004764:	02051e63          	bnez	a0,800047a0 <z_remove_thread_from_ready_q+0xf8>
80004768:	800084b7          	lui	s1,0x80008
8000476c:	800085b7          	lui	a1,0x80008
80004770:	80008537          	lui	a0,0x80008
80004774:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80004778:	06100693          	li	a3,97
8000477c:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004780:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004784:	f8dfd0ef          	jal	ra,80002710 <printk>
80004788:	80008537          	lui	a0,0x80008
8000478c:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80004790:	f81fd0ef          	jal	ra,80002710 <printk>
80004794:	06100593          	li	a1,97
80004798:	bc448513          	addi	a0,s1,-1084
8000479c:	fb1fd0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800047a0:	30042473          	csrrs	s0,mstatus,s0
}
800047a4:	01c12083          	lw	ra,28(sp)
800047a8:	01812403          	lw	s0,24(sp)
800047ac:	01412483          	lw	s1,20(sp)
800047b0:	01012903          	lw	s2,16(sp)
800047b4:	00c12983          	lw	s3,12(sp)
800047b8:	02010113          	addi	sp,sp,32
800047bc:	00008067          	ret

800047c0 <pend>:
{
800047c0:	fe010113          	addi	sp,sp,-32
800047c4:	00812c23          	sw	s0,24(sp)
800047c8:	00912a23          	sw	s1,20(sp)
800047cc:	00050413          	mv	s0,a0
800047d0:	01212823          	sw	s2,16(sp)
800047d4:	00112e23          	sw	ra,28(sp)
800047d8:	01312623          	sw	s3,12(sp)
800047dc:	00058493          	mv	s1,a1
800047e0:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
800047e4:	ec5ff0ef          	jal	ra,800046a8 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
800047e8:	00d44783          	lbu	a5,13(s0)
800047ec:	0027e793          	ori	a5,a5,2
800047f0:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
800047f4:	06048663          	beqz	s1,80004860 <pend+0xa0>
	return thread == _idle_thread;
800047f8:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
800047fc:	2787a783          	lw	a5,632(a5) # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
		thread->base.pended_on = wait_q;
80004800:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80004804:	02f41863          	bne	s0,a5,80004834 <pend+0x74>
80004808:	800089b7          	lui	s3,0x80008
8000480c:	800085b7          	lui	a1,0x80008
80004810:	80008537          	lui	a0,0x80008
80004814:	f4458593          	addi	a1,a1,-188 # 80007f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f45>
80004818:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000481c:	27600693          	li	a3,630
80004820:	e2c98613          	addi	a2,s3,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004824:	eedfd0ef          	jal	ra,80002710 <printk>
80004828:	27600593          	li	a1,630
8000482c:	e2c98513          	addi	a0,s3,-468
80004830:	f1dfd0ef          	jal	ra,8000274c <assert_post_action>
	return list->head == list;
80004834:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004838:	06f48c63          	beq	s1,a5,800048b0 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000483c:	06078a63          	beqz	a5,800048b0 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80004840:	00e40703          	lb	a4,14(s0)
80004844:	00e78683          	lb	a3,14(a5)
80004848:	04d75c63          	bge	a4,a3,800048a0 <pend+0xe0>
	node->prev = successor->prev;
8000484c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004850:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004854:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004858:	00872023          	sw	s0,0(a4)
	successor->prev = node;
8000485c:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80004860:	fff00793          	li	a5,-1
80004864:	06f90463          	beq	s2,a5,800048cc <pend+0x10c>
80004868:	00990913          	addi	s2,s2,9
8000486c:	00a00613          	li	a2,10
80004870:	02c94633          	div	a2,s2,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004874:	01840513          	addi	a0,s0,24
}
80004878:	01812403          	lw	s0,24(sp)
8000487c:	01c12083          	lw	ra,28(sp)
80004880:	01412483          	lw	s1,20(sp)
80004884:	01012903          	lw	s2,16(sp)
80004888:	00c12983          	lw	s3,12(sp)
8000488c:	800045b7          	lui	a1,0x80004
80004890:	33058593          	addi	a1,a1,816 # 80004330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004331>
80004894:	02010113          	addi	sp,sp,32
80004898:	00160613          	addi	a2,a2,1
8000489c:	4680106f          	j	80005d04 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
800048a0:	0044a683          	lw	a3,4(s1)
800048a4:	00d78663          	beq	a5,a3,800048b0 <pend+0xf0>
800048a8:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800048ac:	f8079ce3          	bnez	a5,80004844 <pend+0x84>
	node->prev = list->tail;
800048b0:	0044a783          	lw	a5,4(s1)
	node->next = list;
800048b4:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800048b8:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800048bc:	0044a783          	lw	a5,4(s1)
800048c0:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800048c4:	0084a223          	sw	s0,4(s1)
800048c8:	f99ff06f          	j	80004860 <pend+0xa0>
}
800048cc:	01c12083          	lw	ra,28(sp)
800048d0:	01812403          	lw	s0,24(sp)
800048d4:	01412483          	lw	s1,20(sp)
800048d8:	01012903          	lw	s2,16(sp)
800048dc:	00c12983          	lw	s3,12(sp)
800048e0:	02010113          	addi	sp,sp,32
800048e4:	00008067          	ret

800048e8 <z_pend_curr_irqlock>:
{
800048e8:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
800048ec:	800097b7          	lui	a5,0x80009
{
800048f0:	00812423          	sw	s0,8(sp)
800048f4:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
800048f8:	9447a503          	lw	a0,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
{
800048fc:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004900:	ec1ff0ef          	jal	ra,800047c0 <pend>
80004904:	00040513          	mv	a0,s0
}
80004908:	00812403          	lw	s0,8(sp)
8000490c:	00c12083          	lw	ra,12(sp)
80004910:	01010113          	addi	sp,sp,16
80004914:	925fb06f          	j	80000238 <__swap>

80004918 <z_pend_curr>:
{
80004918:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
8000491c:	800097b7          	lui	a5,0x80009
{
80004920:	00812423          	sw	s0,8(sp)
80004924:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004928:	9447a503          	lw	a0,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
{
8000492c:	00912223          	sw	s1,4(sp)
80004930:	00058493          	mv	s1,a1
80004934:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80004938:	00068613          	mv	a2,a3
{
8000493c:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004940:	e81ff0ef          	jal	ra,800047c0 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004944:	00040513          	mv	a0,s0
80004948:	6bd000ef          	jal	ra,80005804 <z_spin_unlock_valid>
8000494c:	02051e63          	bnez	a0,80004988 <z_pend_curr+0x70>
80004950:	80008437          	lui	s0,0x80008
80004954:	800085b7          	lui	a1,0x80008
80004958:	80008537          	lui	a0,0x80008
8000495c:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80004960:	07800693          	li	a3,120
80004964:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004968:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000496c:	da5fd0ef          	jal	ra,80002710 <printk>
80004970:	80008537          	lui	a0,0x80008
80004974:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80004978:	d99fd0ef          	jal	ra,80002710 <printk>
8000497c:	07800593          	li	a1,120
80004980:	bc440513          	addi	a0,s0,-1084
80004984:	dc9fd0ef          	jal	ra,8000274c <assert_post_action>
}
80004988:	00812403          	lw	s0,8(sp)
8000498c:	00c12083          	lw	ra,12(sp)
80004990:	00048513          	mv	a0,s1
80004994:	00412483          	lw	s1,4(sp)
80004998:	01010113          	addi	sp,sp,16
8000499c:	89dfb06f          	j	80000238 <__swap>

800049a0 <z_thread_priority_set>:
{
800049a0:	fe010113          	addi	sp,sp,-32
800049a4:	00812c23          	sw	s0,24(sp)
800049a8:	01212823          	sw	s2,16(sp)
800049ac:	01412423          	sw	s4,8(sp)
800049b0:	00112e23          	sw	ra,28(sp)
800049b4:	00912a23          	sw	s1,20(sp)
800049b8:	01312623          	sw	s3,12(sp)
800049bc:	01512223          	sw	s5,4(sp)
800049c0:	01612023          	sw	s6,0(sp)
800049c4:	00050413          	mv	s0,a0
800049c8:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800049cc:	00800913          	li	s2,8
800049d0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800049d4:	800089b7          	lui	s3,0x80008
800049d8:	2ec98513          	addi	a0,s3,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800049dc:	00897913          	andi	s2,s2,8
800049e0:	5fd000ef          	jal	ra,800057dc <z_spin_lock_valid>
800049e4:	02051e63          	bnez	a0,80004a20 <z_thread_priority_set+0x80>
800049e8:	800084b7          	lui	s1,0x80008
800049ec:	800085b7          	lui	a1,0x80008
800049f0:	80008537          	lui	a0,0x80008
800049f4:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800049f8:	04e00693          	li	a3,78
800049fc:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004a00:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004a04:	d0dfd0ef          	jal	ra,80002710 <printk>
80004a08:	80008537          	lui	a0,0x80008
80004a0c:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80004a10:	d01fd0ef          	jal	ra,80002710 <printk>
80004a14:	04e00593          	li	a1,78
80004a18:	bc448513          	addi	a0,s1,-1084
80004a1c:	d31fd0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80004a20:	2ec98513          	addi	a0,s3,748
80004a24:	611000ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		need_sched = z_is_thread_ready(thread);
80004a28:	00040513          	mv	a0,s0
80004a2c:	e69fe0ef          	jal	ra,80003894 <z_is_thread_ready>
80004a30:	018a1a13          	slli	s4,s4,0x18
80004a34:	00050a93          	mv	s5,a0
		if (need_sched) {
80004a38:	418a5a13          	srai	s4,s4,0x18
80004a3c:	14050063          	beqz	a0,80004b7c <z_thread_priority_set+0x1dc>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80004a40:	800094b7          	lui	s1,0x80009
80004a44:	93c48513          	addi	a0,s1,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80004a48:	00040593          	mv	a1,s0
80004a4c:	02450513          	addi	a0,a0,36
80004a50:	b7cff0ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	return thread == _idle_thread;
80004a54:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
80004a58:	2787a783          	lw	a5,632(a5) # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
			thread->base.prio = prio;
80004a5c:	01440723          	sb	s4,14(s0)
	return thread == _idle_thread;
80004a60:	80009a37          	lui	s4,0x80009
80004a64:	93c48493          	addi	s1,s1,-1732
80004a68:	960a0a13          	addi	s4,s4,-1696 # 80008960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008961>
	__ASSERT_NO_MSG(!is_idle(thread));
80004a6c:	02f41863          	bne	s0,a5,80004a9c <z_thread_priority_set+0xfc>
80004a70:	80008b37          	lui	s6,0x80008
80004a74:	800085b7          	lui	a1,0x80008
80004a78:	80008537          	lui	a0,0x80008
80004a7c:	f4458593          	addi	a1,a1,-188 # 80007f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f45>
80004a80:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004a84:	27600693          	li	a3,630
80004a88:	e2cb0613          	addi	a2,s6,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004a8c:	c85fd0ef          	jal	ra,80002710 <printk>
80004a90:	27600593          	li	a1,630
80004a94:	e2cb0513          	addi	a0,s6,-468
80004a98:	cb5fd0ef          	jal	ra,8000274c <assert_post_action>
	return list->head == list;
80004a9c:	0244a783          	lw	a5,36(s1)
80004aa0:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004aa4:	0d478063          	beq	a5,s4,80004b64 <z_thread_priority_set+0x1c4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004aa8:	0a078e63          	beqz	a5,80004b64 <z_thread_priority_set+0x1c4>
	if (t1->base.prio < t2->base.prio) {
80004aac:	00e40683          	lb	a3,14(s0)
80004ab0:	00e78603          	lb	a2,14(a5)
80004ab4:	0ac6d263          	bge	a3,a2,80004b58 <z_thread_priority_set+0x1b8>
	node->prev = successor->prev;
80004ab8:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004abc:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004ac0:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004ac4:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004ac8:	0087a223          	sw	s0,4(a5)
			update_cache(1);
80004acc:	00100513          	li	a0,1
80004ad0:	c88ff0ef          	jal	ra,80003f58 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ad4:	2ec98513          	addi	a0,s3,748
80004ad8:	52d000ef          	jal	ra,80005804 <z_spin_unlock_valid>
80004adc:	02051e63          	bnez	a0,80004b18 <z_thread_priority_set+0x178>
80004ae0:	80008437          	lui	s0,0x80008
80004ae4:	800085b7          	lui	a1,0x80008
80004ae8:	80008537          	lui	a0,0x80008
80004aec:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80004af0:	06100693          	li	a3,97
80004af4:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004af8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004afc:	c15fd0ef          	jal	ra,80002710 <printk>
80004b00:	80008537          	lui	a0,0x80008
80004b04:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80004b08:	c09fd0ef          	jal	ra,80002710 <printk>
80004b0c:	06100593          	li	a1,97
80004b10:	bc440513          	addi	a0,s0,-1084
80004b14:	c39fd0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004b18:	30092973          	csrrs	s2,mstatus,s2
	if (need_sched && _current->base.sched_locked == 0) {
80004b1c:	060a8463          	beqz	s5,80004b84 <z_thread_priority_set+0x1e4>
80004b20:	800097b7          	lui	a5,0x80009
80004b24:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
80004b28:	00f7c783          	lbu	a5,15(a5)
80004b2c:	04079c63          	bnez	a5,80004b84 <z_thread_priority_set+0x1e4>
}
80004b30:	01812403          	lw	s0,24(sp)
80004b34:	01c12083          	lw	ra,28(sp)
80004b38:	01412483          	lw	s1,20(sp)
80004b3c:	01012903          	lw	s2,16(sp)
80004b40:	00c12983          	lw	s3,12(sp)
80004b44:	00812a03          	lw	s4,8(sp)
80004b48:	00412a83          	lw	s5,4(sp)
80004b4c:	00012b03          	lw	s6,0(sp)
80004b50:	02010113          	addi	sp,sp,32
		z_reschedule_unlocked();
80004b54:	8f0ff06f          	j	80003c44 <z_reschedule_unlocked>
	return (node == list->tail) ? NULL : node->next;
80004b58:	00e78663          	beq	a5,a4,80004b64 <z_thread_priority_set+0x1c4>
80004b5c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004b60:	f40798e3          	bnez	a5,80004ab0 <z_thread_priority_set+0x110>
	node->prev = list->tail;
80004b64:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80004b68:	0284a783          	lw	a5,40(s1)
	node->next = list;
80004b6c:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80004b70:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004b74:	0284a423          	sw	s0,40(s1)
80004b78:	f55ff06f          	j	80004acc <z_thread_priority_set+0x12c>
			thread->base.prio = prio;
80004b7c:	01440723          	sb	s4,14(s0)
80004b80:	f55ff06f          	j	80004ad4 <z_thread_priority_set+0x134>
}
80004b84:	01c12083          	lw	ra,28(sp)
80004b88:	01812403          	lw	s0,24(sp)
80004b8c:	01412483          	lw	s1,20(sp)
80004b90:	01012903          	lw	s2,16(sp)
80004b94:	00c12983          	lw	s3,12(sp)
80004b98:	00812a03          	lw	s4,8(sp)
80004b9c:	00412a83          	lw	s5,4(sp)
80004ba0:	00012b03          	lw	s6,0(sp)
80004ba4:	02010113          	addi	sp,sp,32
80004ba8:	00008067          	ret

80004bac <z_unpend_first_thread>:
{
80004bac:	fe010113          	addi	sp,sp,-32
80004bb0:	01212823          	sw	s2,16(sp)
80004bb4:	01312623          	sw	s3,12(sp)
80004bb8:	00112e23          	sw	ra,28(sp)
80004bbc:	00812c23          	sw	s0,24(sp)
80004bc0:	00912a23          	sw	s1,20(sp)
80004bc4:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004bc8:	00800913          	li	s2,8
80004bcc:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004bd0:	800084b7          	lui	s1,0x80008
80004bd4:	2ec48513          	addi	a0,s1,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004bd8:	00897913          	andi	s2,s2,8
80004bdc:	401000ef          	jal	ra,800057dc <z_spin_lock_valid>
80004be0:	02051e63          	bnez	a0,80004c1c <z_unpend_first_thread+0x70>
80004be4:	80008437          	lui	s0,0x80008
80004be8:	800085b7          	lui	a1,0x80008
80004bec:	80008537          	lui	a0,0x80008
80004bf0:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80004bf4:	04e00693          	li	a3,78
80004bf8:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004bfc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004c00:	b11fd0ef          	jal	ra,80002710 <printk>
80004c04:	80008537          	lui	a0,0x80008
80004c08:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80004c0c:	b05fd0ef          	jal	ra,80002710 <printk>
80004c10:	04e00593          	li	a1,78
80004c14:	bc440513          	addi	a0,s0,-1084
80004c18:	b35fd0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80004c1c:	2ec48513          	addi	a0,s1,748
80004c20:	415000ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80004c24:	00098513          	mv	a0,s3
80004c28:	b1cff0ef          	jal	ra,80003f44 <z_priq_dumb_best>
80004c2c:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004c30:	2ec48513          	addi	a0,s1,748
80004c34:	3d1000ef          	jal	ra,80005804 <z_spin_unlock_valid>
80004c38:	02051e63          	bnez	a0,80004c74 <z_unpend_first_thread+0xc8>
80004c3c:	800089b7          	lui	s3,0x80008
80004c40:	800085b7          	lui	a1,0x80008
80004c44:	80008537          	lui	a0,0x80008
80004c48:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80004c4c:	06100693          	li	a3,97
80004c50:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004c54:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004c58:	ab9fd0ef          	jal	ra,80002710 <printk>
80004c5c:	80008537          	lui	a0,0x80008
80004c60:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80004c64:	aadfd0ef          	jal	ra,80002710 <printk>
80004c68:	06100593          	li	a1,97
80004c6c:	bc498513          	addi	a0,s3,-1084
80004c70:	addfd0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c74:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004c78:	0c040663          	beqz	s0,80004d44 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004c7c:	00800913          	li	s2,8
80004c80:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004c84:	2ec48513          	addi	a0,s1,748
	key = (mstatus & SOC_MSTATUS_IEN);
80004c88:	00897913          	andi	s2,s2,8
80004c8c:	351000ef          	jal	ra,800057dc <z_spin_lock_valid>
80004c90:	02051e63          	bnez	a0,80004ccc <z_unpend_first_thread+0x120>
80004c94:	800089b7          	lui	s3,0x80008
80004c98:	800085b7          	lui	a1,0x80008
80004c9c:	80008537          	lui	a0,0x80008
80004ca0:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80004ca4:	04e00693          	li	a3,78
80004ca8:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004cac:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004cb0:	a61fd0ef          	jal	ra,80002710 <printk>
80004cb4:	80008537          	lui	a0,0x80008
80004cb8:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80004cbc:	a55fd0ef          	jal	ra,80002710 <printk>
80004cc0:	04e00593          	li	a1,78
80004cc4:	bc498513          	addi	a0,s3,-1084
80004cc8:	a85fd0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80004ccc:	2ec48513          	addi	a0,s1,748
80004cd0:	365000ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004cd4:	00840513          	addi	a0,s0,8
80004cd8:	c11fe0ef          	jal	ra,800038e8 <pended_on.isra.15>
80004cdc:	00040593          	mv	a1,s0
80004ce0:	8ecff0ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004ce4:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ce8:	2ec48513          	addi	a0,s1,748
80004cec:	ffd7f793          	andi	a5,a5,-3
80004cf0:	00f406a3          	sb	a5,13(s0)
80004cf4:	311000ef          	jal	ra,80005804 <z_spin_unlock_valid>
80004cf8:	02051e63          	bnez	a0,80004d34 <z_unpend_first_thread+0x188>
80004cfc:	800084b7          	lui	s1,0x80008
80004d00:	800085b7          	lui	a1,0x80008
80004d04:	80008537          	lui	a0,0x80008
80004d08:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80004d0c:	06100693          	li	a3,97
80004d10:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004d14:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004d18:	9f9fd0ef          	jal	ra,80002710 <printk>
80004d1c:	80008537          	lui	a0,0x80008
80004d20:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80004d24:	9edfd0ef          	jal	ra,80002710 <printk>
80004d28:	06100593          	li	a1,97
80004d2c:	bc448513          	addi	a0,s1,-1084
80004d30:	a1dfd0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004d34:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80004d38:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80004d3c:	01840513          	addi	a0,s0,24
80004d40:	1f0010ef          	jal	ra,80005f30 <z_abort_timeout>
}
80004d44:	00040513          	mv	a0,s0
80004d48:	01c12083          	lw	ra,28(sp)
80004d4c:	01812403          	lw	s0,24(sp)
80004d50:	01412483          	lw	s1,20(sp)
80004d54:	01012903          	lw	s2,16(sp)
80004d58:	00c12983          	lw	s3,12(sp)
80004d5c:	02010113          	addi	sp,sp,32
80004d60:	00008067          	ret

80004d64 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80004d64:	ff010113          	addi	sp,sp,-16
80004d68:	00912223          	sw	s1,4(sp)
80004d6c:	01212023          	sw	s2,0(sp)
80004d70:	00112623          	sw	ra,12(sp)
80004d74:	00812423          	sw	s0,8(sp)
80004d78:	00050913          	mv	s2,a0
	int need_sched = 0;
80004d7c:	00000493          	li	s1,0
	return list->head == list;
80004d80:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004d84:	00890463          	beq	s2,s0,80004d8c <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80004d88:	02041063          	bnez	s0,80004da8 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80004d8c:	00c12083          	lw	ra,12(sp)
80004d90:	00812403          	lw	s0,8(sp)
80004d94:	00048513          	mv	a0,s1
80004d98:	00012903          	lw	s2,0(sp)
80004d9c:	00412483          	lw	s1,4(sp)
80004da0:	01010113          	addi	sp,sp,16
80004da4:	00008067          	ret
		z_unpend_thread(th);
80004da8:	00040513          	mv	a0,s0
80004dac:	898ff0ef          	jal	ra,80003e44 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80004db0:	00040513          	mv	a0,s0
80004db4:	ae1fe0ef          	jal	ra,80003894 <z_is_thread_ready>
		need_sched = 1;
80004db8:	00100493          	li	s1,1
80004dbc:	fc0502e3          	beqz	a0,80004d80 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80004dc0:	00040513          	mv	a0,s0
80004dc4:	bdcff0ef          	jal	ra,800041a0 <z_add_thread_to_ready_q>
80004dc8:	fb9ff06f          	j	80004d80 <z_unpend_all+0x1c>

80004dcc <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80004dcc:	800097b7          	lui	a5,0x80009
80004dd0:	93c78793          	addi	a5,a5,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80004dd4:	02478713          	addi	a4,a5,36
80004dd8:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004ddc:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004de0:	00000593          	li	a1,0
80004de4:	00000513          	li	a0,0
80004de8:	b61fe06f          	j	80003948 <k_sched_time_slice_set>

80004dec <z_impl_k_thread_priority_set>:
Z_SYSCALL_HANDLER1_SIMPLE(k_thread_priority_get, K_OBJ_THREAD,
			  struct k_thread *);
#endif

void z_impl_k_thread_priority_set(k_tid_t tid, int prio)
{
80004dec:	ff010113          	addi	sp,sp,-16
80004df0:	00812423          	sw	s0,8(sp)
80004df4:	01212023          	sw	s2,0(sp)
80004df8:	00112623          	sw	ra,12(sp)
80004dfc:	00912223          	sw	s1,4(sp)
	/*
	 * Use NULL, since we cannot know what the entry point is (we do not
	 * keep track of it) and idle cannot change its priority.
	 */
	Z_ASSERT_VALID_PRIO(prio, NULL);
80004e00:	01058713          	addi	a4,a1,16
80004e04:	01e00793          	li	a5,30
{
80004e08:	00050913          	mv	s2,a0
80004e0c:	00058413          	mv	s0,a1
	Z_ASSERT_VALID_PRIO(prio, NULL);
80004e10:	04e7f463          	bgeu	a5,a4,80004e58 <z_impl_k_thread_priority_set+0x6c>
80004e14:	800084b7          	lui	s1,0x80008
80004e18:	800085b7          	lui	a1,0x80008
80004e1c:	80008537          	lui	a0,0x80008
80004e20:	34500693          	li	a3,837
80004e24:	e2c48613          	addi	a2,s1,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004e28:	ec458593          	addi	a1,a1,-316 # 80007ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ec5>
80004e2c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004e30:	8e1fd0ef          	jal	ra,80002710 <printk>
80004e34:	80008537          	lui	a0,0x80008
80004e38:	00040593          	mv	a1,s0
80004e3c:	b1850513          	addi	a0,a0,-1256 # 80007b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b19>
80004e40:	ff000693          	li	a3,-16
80004e44:	00e00613          	li	a2,14
80004e48:	8c9fd0ef          	jal	ra,80002710 <printk>
80004e4c:	34500593          	li	a1,837
80004e50:	e2c48513          	addi	a0,s1,-468
80004e54:	8f9fd0ef          	jal	ra,8000274c <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80004e58:	800097b7          	lui	a5,0x80009
80004e5c:	93c7a783          	lw	a5,-1732(a5) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
80004e60:	02078e63          	beqz	a5,80004e9c <z_impl_k_thread_priority_set+0xb0>
80004e64:	800084b7          	lui	s1,0x80008
80004e68:	800085b7          	lui	a1,0x80008
80004e6c:	80008537          	lui	a0,0x80008
80004e70:	dc458593          	addi	a1,a1,-572 # 80007dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc5>
80004e74:	34600693          	li	a3,838
80004e78:	e2c48613          	addi	a2,s1,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004e7c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004e80:	891fd0ef          	jal	ra,80002710 <printk>
80004e84:	80008537          	lui	a0,0x80008
80004e88:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80004e8c:	885fd0ef          	jal	ra,80002710 <printk>
80004e90:	34600593          	li	a1,838
80004e94:	e2c48513          	addi	a0,s1,-468
80004e98:	8b5fd0ef          	jal	ra,8000274c <assert_post_action>

	struct k_thread *thread = (struct k_thread *)tid;

	z_thread_priority_set(thread, prio);
80004e9c:	00040593          	mv	a1,s0
}
80004ea0:	00812403          	lw	s0,8(sp)
80004ea4:	00c12083          	lw	ra,12(sp)
80004ea8:	00412483          	lw	s1,4(sp)
	z_thread_priority_set(thread, prio);
80004eac:	00090513          	mv	a0,s2
}
80004eb0:	00012903          	lw	s2,0(sp)
80004eb4:	01010113          	addi	sp,sp,16
	z_thread_priority_set(thread, prio);
80004eb8:	ae9ff06f          	j	800049a0 <z_thread_priority_set>

80004ebc <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80004ebc:	fe010113          	addi	sp,sp,-32
80004ec0:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80004ec4:	80009437          	lui	s0,0x80009
80004ec8:	93c42783          	lw	a5,-1732(s0) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
{
80004ecc:	00112e23          	sw	ra,28(sp)
80004ed0:	00912a23          	sw	s1,20(sp)
80004ed4:	01212823          	sw	s2,16(sp)
80004ed8:	01312623          	sw	s3,12(sp)
80004edc:	01412423          	sw	s4,8(sp)
80004ee0:	01512223          	sw	s5,4(sp)
80004ee4:	93c40413          	addi	s0,s0,-1732
	__ASSERT(!z_is_in_isr(), "");
80004ee8:	02078e63          	beqz	a5,80004f24 <z_impl_k_yield+0x68>
80004eec:	800084b7          	lui	s1,0x80008
80004ef0:	800085b7          	lui	a1,0x80008
80004ef4:	80008537          	lui	a0,0x80008
80004ef8:	dc458593          	addi	a1,a1,-572 # 80007dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc5>
80004efc:	37e00693          	li	a3,894
80004f00:	e2c48613          	addi	a2,s1,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004f04:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004f08:	809fd0ef          	jal	ra,80002710 <printk>
80004f0c:	80008537          	lui	a0,0x80008
80004f10:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80004f14:	ffcfd0ef          	jal	ra,80002710 <printk>
80004f18:	37e00593          	li	a1,894
80004f1c:	e2c48513          	addi	a0,s1,-468
80004f20:	82dfd0ef          	jal	ra,8000274c <assert_post_action>
	return thread == _idle_thread;
80004f24:	800087b7          	lui	a5,0x80008

	if (!is_idle(_current)) {
80004f28:	00842683          	lw	a3,8(s0)
80004f2c:	2787a703          	lw	a4,632(a5) # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
80004f30:	00078a13          	mv	s4,a5
80004f34:	12e68663          	beq	a3,a4,80005060 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004f38:	00800913          	li	s2,8
80004f3c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004f40:	800089b7          	lui	s3,0x80008
80004f44:	2ec98513          	addi	a0,s3,748 # 800082ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004f48:	00897913          	andi	s2,s2,8
80004f4c:	091000ef          	jal	ra,800057dc <z_spin_lock_valid>
80004f50:	02051e63          	bnez	a0,80004f8c <z_impl_k_yield+0xd0>
80004f54:	800084b7          	lui	s1,0x80008
80004f58:	800085b7          	lui	a1,0x80008
80004f5c:	80008537          	lui	a0,0x80008
80004f60:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80004f64:	04e00693          	li	a3,78
80004f68:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80004f6c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004f70:	fa0fd0ef          	jal	ra,80002710 <printk>
80004f74:	80008537          	lui	a0,0x80008
80004f78:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80004f7c:	f94fd0ef          	jal	ra,80002710 <printk>
80004f80:	04e00593          	li	a1,78
80004f84:	bc448513          	addi	a0,s1,-1084
80004f88:	fc4fd0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80004f8c:	2ec98513          	addi	a0,s3,748
80004f90:	0a5000ef          	jal	ra,80005834 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80004f94:	00842583          	lw	a1,8(s0)
80004f98:	02440513          	addi	a0,s0,36
80004f9c:	e31fe0ef          	jal	ra,80003dcc <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80004fa0:	278a2783          	lw	a5,632(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80004fa4:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
80004fa8:	80009a37          	lui	s4,0x80009
80004fac:	960a0a13          	addi	s4,s4,-1696 # 80008960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008961>
	__ASSERT_NO_MSG(!is_idle(thread));
80004fb0:	02f49863          	bne	s1,a5,80004fe0 <z_impl_k_yield+0x124>
80004fb4:	80008ab7          	lui	s5,0x80008
80004fb8:	800085b7          	lui	a1,0x80008
80004fbc:	80008537          	lui	a0,0x80008
80004fc0:	f4458593          	addi	a1,a1,-188 # 80007f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f45>
80004fc4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80004fc8:	27600693          	li	a3,630
80004fcc:	e2ca8613          	addi	a2,s5,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80004fd0:	f40fd0ef          	jal	ra,80002710 <printk>
80004fd4:	27600593          	li	a1,630
80004fd8:	e2ca8513          	addi	a0,s5,-468
80004fdc:	f70fd0ef          	jal	ra,8000274c <assert_post_action>
	return list->head == list;
80004fe0:	02442783          	lw	a5,36(s0)
80004fe4:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004fe8:	0b478a63          	beq	a5,s4,8000509c <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004fec:	0a078863          	beqz	a5,8000509c <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
80004ff0:	00e48683          	lb	a3,14(s1)
80004ff4:	00e78603          	lb	a2,14(a5)
80004ff8:	08c6dc63          	bge	a3,a2,80005090 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
80004ffc:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80005000:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
80005004:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
80005008:	00972023          	sw	s1,0(a4)
	successor->prev = node;
8000500c:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80005010:	00100513          	li	a0,1
80005014:	f45fe0ef          	jal	ra,80003f58 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005018:	2ec98513          	addi	a0,s3,748
8000501c:	7e8000ef          	jal	ra,80005804 <z_spin_unlock_valid>
80005020:	02051e63          	bnez	a0,8000505c <z_impl_k_yield+0x1a0>
80005024:	80008437          	lui	s0,0x80008
80005028:	800085b7          	lui	a1,0x80008
8000502c:	80008537          	lui	a0,0x80008
80005030:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80005034:	06100693          	li	a3,97
80005038:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
8000503c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005040:	ed0fd0ef          	jal	ra,80002710 <printk>
80005044:	80008537          	lui	a0,0x80008
80005048:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
8000504c:	ec4fd0ef          	jal	ra,80002710 <printk>
80005050:	06100593          	li	a1,97
80005054:	bc440513          	addi	a0,s0,-1084
80005058:	ef4fd0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000505c:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005060:	00800513          	li	a0,8
80005064:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
80005068:	01812403          	lw	s0,24(sp)
8000506c:	01c12083          	lw	ra,28(sp)
80005070:	01412483          	lw	s1,20(sp)
80005074:	01012903          	lw	s2,16(sp)
80005078:	00c12983          	lw	s3,12(sp)
8000507c:	00812a03          	lw	s4,8(sp)
80005080:	00412a83          	lw	s5,4(sp)
80005084:	00857513          	andi	a0,a0,8
80005088:	02010113          	addi	sp,sp,32
8000508c:	9acfb06f          	j	80000238 <__swap>
	return (node == list->tail) ? NULL : node->next;
80005090:	00e78663          	beq	a5,a4,8000509c <z_impl_k_yield+0x1e0>
80005094:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80005098:	f4079ee3          	bnez	a5,80004ff4 <z_impl_k_yield+0x138>
	node->prev = list->tail;
8000509c:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
800050a0:	02842783          	lw	a5,40(s0)
	node->next = list;
800050a4:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
800050a8:	0097a023          	sw	s1,0(a5)
	list->tail = node;
800050ac:	02942423          	sw	s1,40(s0)
800050b0:	f61ff06f          	j	80005010 <z_impl_k_yield+0x154>

800050b4 <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
800050b4:	fd010113          	addi	sp,sp,-48
800050b8:	02912223          	sw	s1,36(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
800050bc:	800094b7          	lui	s1,0x80009
800050c0:	93c4a783          	lw	a5,-1732(s1) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
{
800050c4:	02812423          	sw	s0,40(sp)
800050c8:	02112623          	sw	ra,44(sp)
800050cc:	03212023          	sw	s2,32(sp)
800050d0:	01312e23          	sw	s3,28(sp)
800050d4:	01412c23          	sw	s4,24(sp)
800050d8:	00050413          	mv	s0,a0
800050dc:	93c48493          	addi	s1,s1,-1732
	__ASSERT(!z_is_in_isr(), "");
800050e0:	02078e63          	beqz	a5,8000511c <z_impl_k_sleep+0x68>
800050e4:	80008937          	lui	s2,0x80008
800050e8:	800085b7          	lui	a1,0x80008
800050ec:	80008537          	lui	a0,0x80008
800050f0:	dc458593          	addi	a1,a1,-572 # 80007dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc5>
800050f4:	39900693          	li	a3,921
800050f8:	e2c90613          	addi	a2,s2,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
800050fc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005100:	e10fd0ef          	jal	ra,80002710 <printk>
80005104:	80008537          	lui	a0,0x80008
80005108:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
8000510c:	e04fd0ef          	jal	ra,80002710 <printk>
80005110:	39900593          	li	a1,921
80005114:	e2c90513          	addi	a0,s2,-468
80005118:	e34fd0ef          	jal	ra,8000274c <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
8000511c:	fff00793          	li	a5,-1
80005120:	1af41263          	bne	s0,a5,800052c4 <z_impl_k_sleep+0x210>
80005124:	80008937          	lui	s2,0x80008
80005128:	800085b7          	lui	a1,0x80008
8000512c:	80008537          	lui	a0,0x80008
80005130:	e7858593          	addi	a1,a1,-392 # 80007e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e79>
80005134:	39a00693          	li	a3,922
80005138:	e2c90613          	addi	a2,s2,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
8000513c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005140:	dd0fd0ef          	jal	ra,80002710 <printk>
80005144:	80008537          	lui	a0,0x80008
80005148:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
8000514c:	dc4fd0ef          	jal	ra,80002710 <printk>
80005150:	39a00593          	li	a1,922
80005154:	e2c90513          	addi	a0,s2,-468
80005158:	df4fd0ef          	jal	ra,8000274c <assert_post_action>
8000515c:	00a00793          	li	a5,10
80005160:	00940413          	addi	s0,s0,9
80005164:	02f44433          	div	s0,s0,a5
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
	expected_wakeup_time = ticks + z_tick_get_32();
80005168:	400010ef          	jal	ra,80006568 <z_tick_get_32>
8000516c:	00800993          	li	s3,8

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
80005170:	00012623          	sw	zero,12(sp)
	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80005174:	00140413          	addi	s0,s0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80005178:	00a40933          	add	s2,s0,a0
8000517c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005180:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80005184:	0089f993          	andi	s3,s3,8
80005188:	654000ef          	jal	ra,800057dc <z_spin_lock_valid>
8000518c:	02051e63          	bnez	a0,800051c8 <z_impl_k_sleep+0x114>
80005190:	80008a37          	lui	s4,0x80008
80005194:	800085b7          	lui	a1,0x80008
80005198:	80008537          	lui	a0,0x80008
8000519c:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800051a0:	04e00693          	li	a3,78
800051a4:	bc4a0613          	addi	a2,s4,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800051a8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800051ac:	d64fd0ef          	jal	ra,80002710 <printk>
800051b0:	80008537          	lui	a0,0x80008
800051b4:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
800051b8:	d58fd0ef          	jal	ra,80002710 <printk>
800051bc:	04e00593          	li	a1,78
800051c0:	bc4a0513          	addi	a0,s4,-1084
800051c4:	d88fd0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
800051c8:	00c10513          	addi	a0,sp,12
800051cc:	668000ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
800051d0:	0084a503          	lw	a0,8(s1)
800051d4:	cd4ff0ef          	jal	ra,800046a8 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800051d8:	0084a503          	lw	a0,8(s1)
800051dc:	800045b7          	lui	a1,0x80004
800051e0:	00040613          	mv	a2,s0
800051e4:	01850513          	addi	a0,a0,24
800051e8:	33058593          	addi	a1,a1,816 # 80004330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004331>
800051ec:	319000ef          	jal	ra,80005d04 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
800051f0:	0084a703          	lw	a4,8(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800051f4:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
800051f8:	00d74783          	lbu	a5,13(a4)
800051fc:	0107e793          	ori	a5,a5,16
80005200:	00f706a3          	sb	a5,13(a4)
80005204:	600000ef          	jal	ra,80005804 <z_spin_unlock_valid>
80005208:	02051e63          	bnez	a0,80005244 <z_impl_k_sleep+0x190>
8000520c:	80008437          	lui	s0,0x80008
80005210:	800085b7          	lui	a1,0x80008
80005214:	80008537          	lui	a0,0x80008
80005218:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
8000521c:	07800693          	li	a3,120
80005220:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005224:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005228:	ce8fd0ef          	jal	ra,80002710 <printk>
8000522c:	80008537          	lui	a0,0x80008
80005230:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80005234:	cdcfd0ef          	jal	ra,80002710 <printk>
80005238:	07800593          	li	a1,120
8000523c:	bc440513          	addi	a0,s0,-1084
80005240:	d0cfd0ef          	jal	ra,8000274c <assert_post_action>
80005244:	00098513          	mv	a0,s3
80005248:	ff1fa0ef          	jal	ra,80000238 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
8000524c:	0084a783          	lw	a5,8(s1)
80005250:	00d7c783          	lbu	a5,13(a5)
80005254:	0107f793          	andi	a5,a5,16
80005258:	02078e63          	beqz	a5,80005294 <z_impl_k_sleep+0x1e0>
8000525c:	80008437          	lui	s0,0x80008
80005260:	800085b7          	lui	a1,0x80008
80005264:	80008537          	lui	a0,0x80008
80005268:	e8c58593          	addi	a1,a1,-372 # 80007e8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e8d>
8000526c:	3b700693          	li	a3,951
80005270:	e2c40613          	addi	a2,s0,-468 # 80007e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e2d>
80005274:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005278:	c98fd0ef          	jal	ra,80002710 <printk>
8000527c:	80008537          	lui	a0,0x80008
80005280:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80005284:	c8cfd0ef          	jal	ra,80002710 <printk>
80005288:	3b700593          	li	a1,951
8000528c:	e2c40513          	addi	a0,s0,-468
80005290:	cbcfd0ef          	jal	ra,8000274c <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
80005294:	2d4010ef          	jal	ra,80006568 <z_tick_get_32>
80005298:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
8000529c:	00000413          	li	s0,0
	if (ticks > 0) {
800052a0:	02a05663          	blez	a0,800052cc <z_impl_k_sleep+0x218>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800052a4:	3e800793          	li	a5,1000
800052a8:	02f515b3          	mulh	a1,a0,a5
800052ac:	06400613          	li	a2,100
800052b0:	00000693          	li	a3,0
800052b4:	02f50533          	mul	a0,a0,a5
800052b8:	808fb0ef          	jal	ra,800002c0 <__udivdi3>
800052bc:	00050413          	mv	s0,a0
		return __ticks_to_ms(ticks);
800052c0:	00c0006f          	j	800052cc <z_impl_k_sleep+0x218>
	if (duration == 0) {
800052c4:	e8041ce3          	bnez	s0,8000515c <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800052c8:	bf5ff0ef          	jal	ra,80004ebc <z_impl_k_yield>
}
800052cc:	00040513          	mv	a0,s0
800052d0:	02c12083          	lw	ra,44(sp)
800052d4:	02812403          	lw	s0,40(sp)
800052d8:	02412483          	lw	s1,36(sp)
800052dc:	02012903          	lw	s2,32(sp)
800052e0:	01c12983          	lw	s3,28(sp)
800052e4:	01812a03          	lw	s4,24(sp)
800052e8:	03010113          	addi	sp,sp,48
800052ec:	00008067          	ret

800052f0 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800052f0:	800097b7          	lui	a5,0x80009
800052f4:	9447a503          	lw	a0,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
800052f8:	00008067          	ret

800052fc <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800052fc:	fe010113          	addi	sp,sp,-32
80005300:	00812c23          	sw	s0,24(sp)
80005304:	00912a23          	sw	s1,20(sp)
80005308:	01212823          	sw	s2,16(sp)
8000530c:	00112e23          	sw	ra,28(sp)
80005310:	01312623          	sw	s3,12(sp)
80005314:	00050413          	mv	s0,a0
80005318:	00058913          	mv	s2,a1
8000531c:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80005320:	02061e63          	bnez	a2,8000535c <z_impl_k_sem_init+0x60>
80005324:	800089b7          	lui	s3,0x80008
80005328:	800085b7          	lui	a1,0x80008
8000532c:	80008537          	lui	a0,0x80008
80005330:	f6858593          	addi	a1,a1,-152 # 80007f68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f69>
80005334:	04600693          	li	a3,70
80005338:	f5898613          	addi	a2,s3,-168 # 80007f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f59>
8000533c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005340:	bd0fd0ef          	jal	ra,80002710 <printk>
80005344:	80008537          	lui	a0,0x80008
80005348:	f7450513          	addi	a0,a0,-140 # 80007f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f75>
8000534c:	bc4fd0ef          	jal	ra,80002710 <printk>
80005350:	04600593          	li	a1,70
80005354:	f5898513          	addi	a0,s3,-168
80005358:	bf4fd0ef          	jal	ra,8000274c <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
8000535c:	0324fe63          	bgeu	s1,s2,80005398 <z_impl_k_sem_init+0x9c>
80005360:	800089b7          	lui	s3,0x80008
80005364:	800085b7          	lui	a1,0x80008
80005368:	80008537          	lui	a0,0x80008
8000536c:	f8c58593          	addi	a1,a1,-116 # 80007f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f8d>
80005370:	04700693          	li	a3,71
80005374:	f5898613          	addi	a2,s3,-168 # 80007f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f59>
80005378:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000537c:	b94fd0ef          	jal	ra,80002710 <printk>
80005380:	80008537          	lui	a0,0x80008
80005384:	fa450513          	addi	a0,a0,-92 # 80007fa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fa5>
80005388:	b88fd0ef          	jal	ra,80002710 <printk>
8000538c:	04700593          	li	a1,71
80005390:	f5898513          	addi	a0,s3,-168
80005394:	bb8fd0ef          	jal	ra,8000274c <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80005398:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
8000539c:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800053a0:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800053a4:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800053a8:	01c12083          	lw	ra,28(sp)
800053ac:	01812403          	lw	s0,24(sp)
800053b0:	01412483          	lw	s1,20(sp)
800053b4:	01012903          	lw	s2,16(sp)
800053b8:	00c12983          	lw	s3,12(sp)
800053bc:	02010113          	addi	sp,sp,32
800053c0:	00008067          	ret

800053c4 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800053c4:	fe010113          	addi	sp,sp,-32
800053c8:	00912a23          	sw	s1,20(sp)
800053cc:	01312623          	sw	s3,12(sp)
800053d0:	00112e23          	sw	ra,28(sp)
800053d4:	00812c23          	sw	s0,24(sp)
800053d8:	01212823          	sw	s2,16(sp)
800053dc:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800053e0:	00800493          	li	s1,8
800053e4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800053e8:	80008437          	lui	s0,0x80008
800053ec:	2f840513          	addi	a0,s0,760 # 800082f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082f9>
	key = (mstatus & SOC_MSTATUS_IEN);
800053f0:	0084f493          	andi	s1,s1,8
800053f4:	3e8000ef          	jal	ra,800057dc <z_spin_lock_valid>
800053f8:	02051e63          	bnez	a0,80005434 <z_impl_k_sem_give+0x70>
800053fc:	80008937          	lui	s2,0x80008
80005400:	800085b7          	lui	a1,0x80008
80005404:	80008537          	lui	a0,0x80008
80005408:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
8000540c:	04e00693          	li	a3,78
80005410:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005414:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005418:	af8fd0ef          	jal	ra,80002710 <printk>
8000541c:	80008537          	lui	a0,0x80008
80005420:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80005424:	aecfd0ef          	jal	ra,80002710 <printk>
80005428:	04e00593          	li	a1,78
8000542c:	bc490513          	addi	a0,s2,-1084
80005430:	b1cfd0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80005434:	2f840513          	addi	a0,s0,760
80005438:	3fc000ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
8000543c:	00098513          	mv	a0,s3
80005440:	f6cff0ef          	jal	ra,80004bac <z_unpend_first_thread>
80005444:	00050913          	mv	s2,a0
	if (thread != NULL) {
80005448:	04050263          	beqz	a0,8000548c <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000544c:	00d54783          	lbu	a5,13(a0)
80005450:	01f7f793          	andi	a5,a5,31
80005454:	00079863          	bnez	a5,80005464 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80005458:	01852783          	lw	a5,24(a0)
8000545c:	00079463          	bnez	a5,80005464 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80005460:	d41fe0ef          	jal	ra,800041a0 <z_add_thread_to_ready_q>
80005464:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80005468:	2f840513          	addi	a0,s0,760
}
8000546c:	01812403          	lw	s0,24(sp)
80005470:	01c12083          	lw	ra,28(sp)
80005474:	01012903          	lw	s2,16(sp)
80005478:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
8000547c:	00048593          	mv	a1,s1
}
80005480:	01412483          	lw	s1,20(sp)
80005484:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80005488:	eccfe06f          	j	80003b54 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
8000548c:	0089a703          	lw	a4,8(s3)
80005490:	00c9a783          	lw	a5,12(s3)
80005494:	40e787b3          	sub	a5,a5,a4
80005498:	00f037b3          	snez	a5,a5
8000549c:	00e787b3          	add	a5,a5,a4
800054a0:	00f9a423          	sw	a5,8(s3)
800054a4:	fc5ff06f          	j	80005468 <z_impl_k_sem_give+0xa4>

800054a8 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800054a8:	800097b7          	lui	a5,0x80009
800054ac:	93c7a783          	lw	a5,-1732(a5) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
{
800054b0:	fe010113          	addi	sp,sp,-32
800054b4:	01212823          	sw	s2,16(sp)
800054b8:	01312623          	sw	s3,12(sp)
800054bc:	00112e23          	sw	ra,28(sp)
800054c0:	00812c23          	sw	s0,24(sp)
800054c4:	00912a23          	sw	s1,20(sp)
800054c8:	01412423          	sw	s4,8(sp)
800054cc:	00050913          	mv	s2,a0
800054d0:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800054d4:	04078063          	beqz	a5,80005514 <z_impl_k_sem_take+0x6c>
800054d8:	02058e63          	beqz	a1,80005514 <z_impl_k_sem_take+0x6c>
800054dc:	80008437          	lui	s0,0x80008
800054e0:	800085b7          	lui	a1,0x80008
800054e4:	80008537          	lui	a0,0x80008
800054e8:	fcc58593          	addi	a1,a1,-52 # 80007fcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fcd>
800054ec:	08c00693          	li	a3,140
800054f0:	f5840613          	addi	a2,s0,-168 # 80007f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f59>
800054f4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800054f8:	a18fd0ef          	jal	ra,80002710 <printk>
800054fc:	80008537          	lui	a0,0x80008
80005500:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80005504:	a0cfd0ef          	jal	ra,80002710 <printk>
80005508:	08c00593          	li	a1,140
8000550c:	f5840513          	addi	a0,s0,-168
80005510:	a3cfd0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005514:	00800413          	li	s0,8
80005518:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000551c:	800084b7          	lui	s1,0x80008
80005520:	2f848513          	addi	a0,s1,760 # 800082f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005524:	00847413          	andi	s0,s0,8
80005528:	2b4000ef          	jal	ra,800057dc <z_spin_lock_valid>
8000552c:	02051e63          	bnez	a0,80005568 <z_impl_k_sem_take+0xc0>
80005530:	80008a37          	lui	s4,0x80008
80005534:	800085b7          	lui	a1,0x80008
80005538:	80008537          	lui	a0,0x80008
8000553c:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80005540:	04e00693          	li	a3,78
80005544:	bc4a0613          	addi	a2,s4,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005548:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000554c:	9c4fd0ef          	jal	ra,80002710 <printk>
80005550:	80008537          	lui	a0,0x80008
80005554:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80005558:	9b8fd0ef          	jal	ra,80002710 <printk>
8000555c:	04e00593          	li	a1,78
80005560:	bc4a0513          	addi	a0,s4,-1084
80005564:	9e8fd0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80005568:	2f848513          	addi	a0,s1,760
8000556c:	2c8000ef          	jal	ra,80005834 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80005570:	00892783          	lw	a5,8(s2)
80005574:	06078c63          	beqz	a5,800055ec <z_impl_k_sem_take+0x144>
		sem->count--;
80005578:	fff78793          	addi	a5,a5,-1
8000557c:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005580:	2f848513          	addi	a0,s1,760
80005584:	280000ef          	jal	ra,80005804 <z_spin_unlock_valid>
80005588:	02051e63          	bnez	a0,800055c4 <z_impl_k_sem_take+0x11c>
8000558c:	800084b7          	lui	s1,0x80008
80005590:	800085b7          	lui	a1,0x80008
80005594:	80008537          	lui	a0,0x80008
80005598:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
8000559c:	06100693          	li	a3,97
800055a0:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800055a4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800055a8:	968fd0ef          	jal	ra,80002710 <printk>
800055ac:	80008537          	lui	a0,0x80008
800055b0:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800055b4:	95cfd0ef          	jal	ra,80002710 <printk>
800055b8:	06100593          	li	a1,97
800055bc:	bc448513          	addi	a0,s1,-1084
800055c0:	98cfd0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800055c4:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800055c8:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800055cc:	01c12083          	lw	ra,28(sp)
800055d0:	01812403          	lw	s0,24(sp)
800055d4:	01412483          	lw	s1,20(sp)
800055d8:	01012903          	lw	s2,16(sp)
800055dc:	00c12983          	lw	s3,12(sp)
800055e0:	00812a03          	lw	s4,8(sp)
800055e4:	02010113          	addi	sp,sp,32
800055e8:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800055ec:	04099a63          	bnez	s3,80005640 <z_impl_k_sem_take+0x198>
800055f0:	2f848513          	addi	a0,s1,760
800055f4:	210000ef          	jal	ra,80005804 <z_spin_unlock_valid>
800055f8:	02051e63          	bnez	a0,80005634 <z_impl_k_sem_take+0x18c>
800055fc:	800084b7          	lui	s1,0x80008
80005600:	800085b7          	lui	a1,0x80008
80005604:	80008537          	lui	a0,0x80008
80005608:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
8000560c:	06100693          	li	a3,97
80005610:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005614:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005618:	8f8fd0ef          	jal	ra,80002710 <printk>
8000561c:	80008537          	lui	a0,0x80008
80005620:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80005624:	8ecfd0ef          	jal	ra,80002710 <printk>
80005628:	06100593          	li	a1,97
8000562c:	bc448513          	addi	a0,s1,-1084
80005630:	91cfd0ef          	jal	ra,8000274c <assert_post_action>
80005634:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80005638:	ff000513          	li	a0,-16
8000563c:	f91ff06f          	j	800055cc <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005640:	00040593          	mv	a1,s0
}
80005644:	01812403          	lw	s0,24(sp)
80005648:	01c12083          	lw	ra,28(sp)
8000564c:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005650:	00098693          	mv	a3,s3
80005654:	00090613          	mv	a2,s2
}
80005658:	00c12983          	lw	s3,12(sp)
8000565c:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005660:	2f848513          	addi	a0,s1,760
}
80005664:	01412483          	lw	s1,20(sp)
80005668:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000566c:	aacff06f          	j	80004918 <z_pend_curr>

80005670 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005670:	00d54783          	lbu	a5,13(a0)
80005674:	01f7f793          	andi	a5,a5,31
80005678:	00079863          	bnez	a5,80005688 <z_is_thread_ready+0x18>
8000567c:	01852503          	lw	a0,24(a0)
80005680:	00153513          	seqz	a0,a0
80005684:	00008067          	ret
80005688:	00000513          	li	a0,0
}
8000568c:	00008067          	ret

80005690 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80005690:	800097b7          	lui	a5,0x80009
80005694:	93c7a503          	lw	a0,-1732(a5) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
}
80005698:	00a03533          	snez	a0,a0
8000569c:	00008067          	ret

800056a0 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800056a0:	800097b7          	lui	a5,0x80009
800056a4:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
800056a8:	00c7c503          	lbu	a0,12(a5)
}
800056ac:	00157513          	andi	a0,a0,1
800056b0:	00008067          	ret

800056b4 <z_impl_k_busy_wait>:
void z_impl_k_busy_wait(u32_t usec_to_wait)
{
#if !defined(CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT)
	/* use 64-bit math to prevent overflow when multiplying */
	u32_t cycles_to_wait = (u32_t)(
		(u64_t)usec_to_wait *
800056b4:	00b727b7          	lui	a5,0xb72
800056b8:	b0078793          	addi	a5,a5,-1280 # b71b00 <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC>
800056bc:	02f535b3          	mulhu	a1,a0,a5
		(u64_t)sys_clock_hw_cycles_per_sec() /
800056c0:	000f4637          	lui	a2,0xf4
{
800056c4:	ff010113          	addi	sp,sp,-16
		(u64_t)sys_clock_hw_cycles_per_sec() /
800056c8:	24060613          	addi	a2,a2,576 # f4240 <CONFIG_RISCV_RAM_SIZE+0xb4240>
800056cc:	00000693          	li	a3,0
{
800056d0:	00112623          	sw	ra,12(sp)
800056d4:	00812423          	sw	s0,8(sp)
800056d8:	00912223          	sw	s1,4(sp)
		(u64_t)sys_clock_hw_cycles_per_sec() /
800056dc:	02f50533          	mul	a0,a0,a5
800056e0:	be1fa0ef          	jal	ra,800002c0 <__udivdi3>
800056e4:	00050413          	mv	s0,a0
		(u64_t)USEC_PER_SEC
	);
	u32_t start_cycles = k_cycle_get_32();
800056e8:	db4fd0ef          	jal	ra,80002c9c <z_timer_cycle_get_32>
800056ec:	00050493          	mv	s1,a0

	for (;;) {
		u32_t current_cycles = k_cycle_get_32();
800056f0:	dacfd0ef          	jal	ra,80002c9c <z_timer_cycle_get_32>

		/* this handles the rollover on an unsigned 32-bit value */
		if ((current_cycles - start_cycles) >= cycles_to_wait) {
800056f4:	40950533          	sub	a0,a0,s1
800056f8:	fe856ce3          	bltu	a0,s0,800056f0 <z_impl_k_busy_wait+0x3c>
		}
	}
#else
	z_arch_busy_wait(usec_to_wait);
#endif /* CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT */
}
800056fc:	00c12083          	lw	ra,12(sp)
80005700:	00812403          	lw	s0,8(sp)
80005704:	00412483          	lw	s1,4(sp)
80005708:	01010113          	addi	sp,sp,16
8000570c:	00008067          	ret

80005710 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80005710:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005714:	02012303          	lw	t1,32(sp)
{
80005718:	00812c23          	sw	s0,24(sp)
8000571c:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005720:	00612023          	sw	t1,0(sp)
{
80005724:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005728:	910fc0ef          	jal	ra,80001838 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
8000572c:	800097b7          	lui	a5,0x80009
80005730:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
	sys_trace_thread_create(new_thread);
}
80005734:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80005738:	0687a783          	lw	a5,104(a5)
8000573c:	06f42423          	sw	a5,104(s0)
}
80005740:	01812403          	lw	s0,24(sp)
80005744:	02010113          	addi	sp,sp,32
80005748:	00008067          	ret

8000574c <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
8000574c:	06052783          	lw	a5,96(a0)
{
80005750:	ff010113          	addi	sp,sp,-16
80005754:	00812423          	sw	s0,8(sp)
80005758:	00112623          	sw	ra,12(sp)
8000575c:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80005760:	00078463          	beqz	a5,80005768 <z_thread_single_abort+0x1c>
		thread->fn_abort();
80005764:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80005768:	00040513          	mv	a0,s0
8000576c:	f05ff0ef          	jal	ra,80005670 <z_is_thread_ready>
80005770:	02050463          	beqz	a0,80005798 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80005774:	00040513          	mv	a0,s0
80005778:	f31fe0ef          	jal	ra,800046a8 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
8000577c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80005780:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80005784:	0087e793          	ori	a5,a5,8
80005788:	00f406a3          	sb	a5,13(s0)
}
8000578c:	00812403          	lw	s0,8(sp)
80005790:	01010113          	addi	sp,sp,16
80005794:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80005798:	00d44783          	lbu	a5,13(s0)
8000579c:	0027f793          	andi	a5,a5,2
800057a0:	00078663          	beqz	a5,800057ac <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
800057a4:	00040513          	mv	a0,s0
800057a8:	ab0fe0ef          	jal	ra,80003a58 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
800057ac:	01842783          	lw	a5,24(s0)
800057b0:	fc0786e3          	beqz	a5,8000577c <z_thread_single_abort+0x30>
	return z_abort_timeout(&thread->base.timeout);
800057b4:	01840513          	addi	a0,s0,24
800057b8:	778000ef          	jal	ra,80005f30 <z_abort_timeout>
800057bc:	fc1ff06f          	j	8000577c <z_thread_single_abort+0x30>

800057c0 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800057c0:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800057c4:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800057c8:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
800057cc:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800057d0:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800057d4:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800057d8:	00008067          	ret

800057dc <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800057dc:	00052503          	lw	a0,0(a0)
800057e0:	00050e63          	beqz	a0,800057fc <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800057e4:	800097b7          	lui	a5,0x80009
800057e8:	9507c783          	lbu	a5,-1712(a5) # 80008950 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008951>
800057ec:	00357513          	andi	a0,a0,3
800057f0:	40f50533          	sub	a0,a0,a5
800057f4:	00a03533          	snez	a0,a0
800057f8:	00008067          	ret
			return false;
		}
	}
	return true;
800057fc:	00100513          	li	a0,1
}
80005800:	00008067          	ret

80005804 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80005804:	800097b7          	lui	a5,0x80009
80005808:	93c78793          	addi	a5,a5,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
8000580c:	0147c703          	lbu	a4,20(a5)
80005810:	0087a783          	lw	a5,8(a5)
80005814:	00e7e7b3          	or	a5,a5,a4
80005818:	00052703          	lw	a4,0(a0)
8000581c:	00f71863          	bne	a4,a5,8000582c <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80005820:	00052023          	sw	zero,0(a0)
	return true;
80005824:	00100513          	li	a0,1
80005828:	00008067          	ret
		return false;
8000582c:	00000513          	li	a0,0
}
80005830:	00008067          	ret

80005834 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80005834:	800097b7          	lui	a5,0x80009
80005838:	93c78793          	addi	a5,a5,-1732 # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
8000583c:	0147c703          	lbu	a4,20(a5)
80005840:	0087a783          	lw	a5,8(a5)
80005844:	00e7e7b3          	or	a5,a5,a4
80005848:	00f52023          	sw	a5,0(a0)
}
8000584c:	00008067          	ret

80005850 <z_impl_k_thread_start>:
{
80005850:	fe010113          	addi	sp,sp,-32
80005854:	00812c23          	sw	s0,24(sp)
80005858:	01212823          	sw	s2,16(sp)
8000585c:	00112e23          	sw	ra,28(sp)
80005860:	00912a23          	sw	s1,20(sp)
80005864:	01312623          	sw	s3,12(sp)
80005868:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000586c:	00800413          	li	s0,8
80005870:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005874:	800084b7          	lui	s1,0x80008
80005878:	2fc48513          	addi	a0,s1,764 # 800082fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082fd>
	key = (mstatus & SOC_MSTATUS_IEN);
8000587c:	00847413          	andi	s0,s0,8
80005880:	f5dff0ef          	jal	ra,800057dc <z_spin_lock_valid>
80005884:	02051e63          	bnez	a0,800058c0 <z_impl_k_thread_start+0x70>
80005888:	800089b7          	lui	s3,0x80008
8000588c:	800085b7          	lui	a1,0x80008
80005890:	80008537          	lui	a0,0x80008
80005894:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80005898:	04e00693          	li	a3,78
8000589c:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800058a0:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800058a4:	e6dfc0ef          	jal	ra,80002710 <printk>
800058a8:	80008537          	lui	a0,0x80008
800058ac:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
800058b0:	e61fc0ef          	jal	ra,80002710 <printk>
800058b4:	04e00593          	li	a1,78
800058b8:	bc498513          	addi	a0,s3,-1084
800058bc:	e91fc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
800058c0:	2fc48513          	addi	a0,s1,764
800058c4:	f71ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
800058c8:	00d94783          	lbu	a5,13(s2)
800058cc:	0047f713          	andi	a4,a5,4
800058d0:	06071463          	bnez	a4,80005938 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800058d4:	2fc48513          	addi	a0,s1,764
800058d8:	f2dff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
800058dc:	02051e63          	bnez	a0,80005918 <z_impl_k_thread_start+0xc8>
800058e0:	800084b7          	lui	s1,0x80008
800058e4:	800085b7          	lui	a1,0x80008
800058e8:	80008537          	lui	a0,0x80008
800058ec:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800058f0:	06100693          	li	a3,97
800058f4:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800058f8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800058fc:	e15fc0ef          	jal	ra,80002710 <printk>
80005900:	80008537          	lui	a0,0x80008
80005904:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80005908:	e09fc0ef          	jal	ra,80002710 <printk>
8000590c:	06100593          	li	a1,97
80005910:	bc448513          	addi	a0,s1,-1084
80005914:	e39fc0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005918:	30042473          	csrrs	s0,mstatus,s0
}
8000591c:	01c12083          	lw	ra,28(sp)
80005920:	01812403          	lw	s0,24(sp)
80005924:	01412483          	lw	s1,20(sp)
80005928:	01012903          	lw	s2,16(sp)
8000592c:	00c12983          	lw	s3,12(sp)
80005930:	02010113          	addi	sp,sp,32
80005934:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80005938:	ffb7f793          	andi	a5,a5,-5
8000593c:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80005940:	00090513          	mv	a0,s2
80005944:	d2dff0ef          	jal	ra,80005670 <z_is_thread_ready>
80005948:	00050663          	beqz	a0,80005954 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
8000594c:	00090513          	mv	a0,s2
80005950:	851fe0ef          	jal	ra,800041a0 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80005954:	00040593          	mv	a1,s0
}
80005958:	01812403          	lw	s0,24(sp)
8000595c:	01c12083          	lw	ra,28(sp)
80005960:	01012903          	lw	s2,16(sp)
80005964:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80005968:	2fc48513          	addi	a0,s1,764
}
8000596c:	01412483          	lw	s1,20(sp)
80005970:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80005974:	9e0fe06f          	j	80003b54 <z_reschedule>

80005978 <schedule_new_thread>:
	if (delay == 0) {
80005978:	00059463          	bnez	a1,80005980 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
8000597c:	ed5ff06f          	j	80005850 <z_impl_k_thread_start>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005980:	00958593          	addi	a1,a1,9
80005984:	00a00613          	li	a2,10
80005988:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
8000598c:	800045b7          	lui	a1,0x80004
80005990:	33058593          	addi	a1,a1,816 # 80004330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004331>
80005994:	01850513          	addi	a0,a0,24
80005998:	00160613          	addi	a2,a2,1
8000599c:	3680006f          	j	80005d04 <z_add_timeout>

800059a0 <z_impl_k_thread_create>:
{
800059a0:	fc010113          	addi	sp,sp,-64
800059a4:	03512223          	sw	s5,36(sp)
800059a8:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800059ac:	800096b7          	lui	a3,0x80009
800059b0:	93c6a683          	lw	a3,-1732(a3) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
{
800059b4:	02812c23          	sw	s0,56(sp)
800059b8:	02912a23          	sw	s1,52(sp)
800059bc:	03312623          	sw	s3,44(sp)
800059c0:	03412423          	sw	s4,40(sp)
800059c4:	02112e23          	sw	ra,60(sp)
800059c8:	03212823          	sw	s2,48(sp)
800059cc:	00050413          	mv	s0,a0
800059d0:	00058993          	mv	s3,a1
800059d4:	00060a13          	mv	s4,a2
800059d8:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800059dc:	04068e63          	beqz	a3,80005a38 <z_impl_k_thread_create+0x98>
800059e0:	80008937          	lui	s2,0x80008
800059e4:	800085b7          	lui	a1,0x80008
800059e8:	80008537          	lui	a0,0x80008
800059ec:	1b200693          	li	a3,434
800059f0:	00090613          	mv	a2,s2
800059f4:	dc458593          	addi	a1,a1,-572 # 80007dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc5>
800059f8:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800059fc:	01112e23          	sw	a7,28(sp)
80005a00:	01012c23          	sw	a6,24(sp)
80005a04:	00f12a23          	sw	a5,20(sp)
80005a08:	00e12823          	sw	a4,16(sp)
80005a0c:	d05fc0ef          	jal	ra,80002710 <printk>
80005a10:	80008537          	lui	a0,0x80008
80005a14:	01450513          	addi	a0,a0,20 # 80008014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008015>
80005a18:	cf9fc0ef          	jal	ra,80002710 <printk>
80005a1c:	1b200593          	li	a1,434
80005a20:	00090513          	mv	a0,s2
80005a24:	d29fc0ef          	jal	ra,8000274c <assert_post_action>
80005a28:	01c12883          	lw	a7,28(sp)
80005a2c:	01812803          	lw	a6,24(sp)
80005a30:	01412783          	lw	a5,20(sp)
80005a34:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005a38:	04012683          	lw	a3,64(sp)
80005a3c:	00012223          	sw	zero,4(sp)
80005a40:	000a0613          	mv	a2,s4
80005a44:	00d12023          	sw	a3,0(sp)
80005a48:	00098593          	mv	a1,s3
80005a4c:	000a8693          	mv	a3,s5
80005a50:	00040513          	mv	a0,s0
80005a54:	cbdff0ef          	jal	ra,80005710 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80005a58:	fff00793          	li	a5,-1
80005a5c:	00f48863          	beq	s1,a5,80005a6c <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80005a60:	00048593          	mv	a1,s1
80005a64:	00040513          	mv	a0,s0
80005a68:	f11ff0ef          	jal	ra,80005978 <schedule_new_thread>
}
80005a6c:	00040513          	mv	a0,s0
80005a70:	03c12083          	lw	ra,60(sp)
80005a74:	03812403          	lw	s0,56(sp)
80005a78:	03412483          	lw	s1,52(sp)
80005a7c:	03012903          	lw	s2,48(sp)
80005a80:	02c12983          	lw	s3,44(sp)
80005a84:	02812a03          	lw	s4,40(sp)
80005a88:	02412a83          	lw	s5,36(sp)
80005a8c:	04010113          	addi	sp,sp,64
80005a90:	00008067          	ret

80005a94 <z_init_static_threads>:
{
80005a94:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80005a98:	800087b7          	lui	a5,0x80008
{
80005a9c:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005aa0:	80008937          	lui	s2,0x80008
{
80005aa4:	00812c23          	sw	s0,24(sp)
80005aa8:	00912a23          	sw	s1,20(sp)
80005aac:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005ab0:	2ac78413          	addi	s0,a5,684 # 800082ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ad>
80005ab4:	2ac78493          	addi	s1,a5,684
80005ab8:	2ac90913          	addi	s2,s2,684 # 800082ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ad>
80005abc:	03246663          	bltu	s0,s2,80005ae8 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80005ac0:	00048413          	mv	s0,s1
	k_sched_lock();
80005ac4:	990fe0ef          	jal	ra,80003c54 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80005ac8:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80005acc:	07246063          	bltu	s0,s2,80005b2c <z_init_static_threads+0x98>
}
80005ad0:	01812403          	lw	s0,24(sp)
80005ad4:	01c12083          	lw	ra,28(sp)
80005ad8:	01412483          	lw	s1,20(sp)
80005adc:	01012903          	lw	s2,16(sp)
80005ae0:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80005ae4:	d3cfe06f          	j	80004020 <k_sched_unlock>
		z_setup_new_thread(
80005ae8:	02c42783          	lw	a5,44(s0)
80005aec:	00f12223          	sw	a5,4(sp)
80005af0:	02042783          	lw	a5,32(s0)
80005af4:	00f12023          	sw	a5,0(sp)
80005af8:	01442783          	lw	a5,20(s0)
80005afc:	01c42883          	lw	a7,28(s0)
80005b00:	01842803          	lw	a6,24(s0)
80005b04:	01042703          	lw	a4,16(s0)
80005b08:	00c42683          	lw	a3,12(s0)
80005b0c:	00842603          	lw	a2,8(s0)
80005b10:	00442583          	lw	a1,4(s0)
80005b14:	00042503          	lw	a0,0(s0)
80005b18:	bf9ff0ef          	jal	ra,80005710 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80005b1c:	00042783          	lw	a5,0(s0)
80005b20:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80005b24:	03040413          	addi	s0,s0,48
80005b28:	f95ff06f          	j	80005abc <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80005b2c:	02442583          	lw	a1,36(s0)
80005b30:	00958663          	beq	a1,s1,80005b3c <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80005b34:	00042503          	lw	a0,0(s0)
80005b38:	e41ff0ef          	jal	ra,80005978 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80005b3c:	03040413          	addi	s0,s0,48
80005b40:	f8dff06f          	j	80005acc <z_init_static_threads+0x38>

80005b44 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80005b44:	fe010113          	addi	sp,sp,-32
80005b48:	00812c23          	sw	s0,24(sp)
80005b4c:	00912a23          	sw	s1,20(sp)
80005b50:	00112e23          	sw	ra,28(sp)
80005b54:	01212823          	sw	s2,16(sp)
80005b58:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80005b5c:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005b60:	00800413          	li	s0,8
80005b64:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005b68:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80005b6c:	00847413          	andi	s0,s0,8
80005b70:	c6dff0ef          	jal	ra,800057dc <z_spin_lock_valid>
80005b74:	02051e63          	bnez	a0,80005bb0 <z_impl_k_thread_abort+0x6c>
80005b78:	80008937          	lui	s2,0x80008
80005b7c:	800085b7          	lui	a1,0x80008
80005b80:	80008537          	lui	a0,0x80008
80005b84:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80005b88:	04e00693          	li	a3,78
80005b8c:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005b90:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005b94:	b7dfc0ef          	jal	ra,80002710 <printk>
80005b98:	80008537          	lui	a0,0x80008
80005b9c:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80005ba0:	b71fc0ef          	jal	ra,80002710 <printk>
80005ba4:	04e00593          	li	a1,78
80005ba8:	bc490513          	addi	a0,s2,-1084
80005bac:	ba1fc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80005bb0:	00c10513          	addi	a0,sp,12
80005bb4:	c81ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80005bb8:	00c4c783          	lbu	a5,12(s1)
80005bbc:	0017f793          	andi	a5,a5,1
80005bc0:	02078e63          	beqz	a5,80005bfc <z_impl_k_thread_abort+0xb8>
80005bc4:	80008937          	lui	s2,0x80008
80005bc8:	800085b7          	lui	a1,0x80008
80005bcc:	80008537          	lui	a0,0x80008
80005bd0:	05458593          	addi	a1,a1,84 # 80008054 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008055>
80005bd4:	02900693          	li	a3,41
80005bd8:	03c90613          	addi	a2,s2,60 # 8000803c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000803d>
80005bdc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005be0:	b31fc0ef          	jal	ra,80002710 <printk>
80005be4:	80008537          	lui	a0,0x80008
80005be8:	08850513          	addi	a0,a0,136 # 80008088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008089>
80005bec:	b25fc0ef          	jal	ra,80002710 <printk>
80005bf0:	02900593          	li	a1,41
80005bf4:	03c90513          	addi	a0,s2,60
80005bf8:	b55fc0ef          	jal	ra,8000274c <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80005bfc:	00048513          	mv	a0,s1
80005c00:	b4dff0ef          	jal	ra,8000574c <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80005c04:	00040593          	mv	a1,s0
80005c08:	00c10513          	addi	a0,sp,12
80005c0c:	f49fd0ef          	jal	ra,80003b54 <z_reschedule>
}
80005c10:	01c12083          	lw	ra,28(sp)
80005c14:	01812403          	lw	s0,24(sp)
80005c18:	01412483          	lw	s1,20(sp)
80005c1c:	01012903          	lw	s2,16(sp)
80005c20:	02010113          	addi	sp,sp,32
80005c24:	00008067          	ret

80005c28 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80005c28:	800087b7          	lui	a5,0x80008
80005c2c:	3007a783          	lw	a5,768(a5) # 80008300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008301>
80005c30:	00079463          	bnez	a5,80005c38 <elapsed+0x10>
80005c34:	f79fc06f          	j	80002bac <z_clock_elapsed>
}
80005c38:	00000513          	li	a0,0
80005c3c:	00008067          	ret

80005c40 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80005c40:	00052783          	lw	a5,0(a0)
80005c44:	02050263          	beqz	a0,80005c68 <remove_timeout+0x28>
80005c48:	80008737          	lui	a4,0x80008
	return (node == list->tail) ? NULL : node->next;
80005c4c:	27072703          	lw	a4,624(a4) # 80008270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008271>
80005c50:	00e50c63          	beq	a0,a4,80005c68 <remove_timeout+0x28>
	if (next(t) != NULL) {
80005c54:	00078a63          	beqz	a5,80005c68 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80005c58:	0087a703          	lw	a4,8(a5)
80005c5c:	00852683          	lw	a3,8(a0)
80005c60:	00d70733          	add	a4,a4,a3
80005c64:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80005c68:	00452703          	lw	a4,4(a0)
80005c6c:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80005c70:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80005c74:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80005c78:	00052223          	sw	zero,4(a0)
}
80005c7c:	00008067          	ret

80005c80 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80005c80:	800087b7          	lui	a5,0x80008
80005c84:	30c7c783          	lbu	a5,780(a5) # 8000830c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000830d>
{
80005c88:	ff010113          	addi	sp,sp,-16
80005c8c:	00112623          	sw	ra,12(sp)
80005c90:	00812423          	sw	s0,8(sp)
80005c94:	00912223          	sw	s1,4(sp)
80005c98:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80005c9c:	00079663          	bnez	a5,80005ca8 <next_timeout+0x28>
80005ca0:	80000537          	lui	a0,0x80000
80005ca4:	fff54513          	not	a0,a0
	return list->head == list;
80005ca8:	800087b7          	lui	a5,0x80008
80005cac:	26c78793          	addi	a5,a5,620 # 8000826c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000826d>
80005cb0:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005cb4:	02f40463          	beq	s0,a5,80005cdc <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80005cb8:	02040263          	beqz	s0,80005cdc <next_timeout+0x5c>
80005cbc:	00842483          	lw	s1,8(s0)
80005cc0:	f69ff0ef          	jal	ra,80005c28 <elapsed>
80005cc4:	40a484b3          	sub	s1,s1,a0
80005cc8:	00000513          	li	a0,0
80005ccc:	0004c863          	bltz	s1,80005cdc <next_timeout+0x5c>
80005cd0:	00842403          	lw	s0,8(s0)
80005cd4:	f55ff0ef          	jal	ra,80005c28 <elapsed>
80005cd8:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80005cdc:	800097b7          	lui	a5,0x80009
80005ce0:	94c7a783          	lw	a5,-1716(a5) # 8000894c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000894d>
80005ce4:	00078663          	beqz	a5,80005cf0 <next_timeout+0x70>
80005ce8:	00a7d463          	bge	a5,a0,80005cf0 <next_timeout+0x70>
80005cec:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80005cf0:	00c12083          	lw	ra,12(sp)
80005cf4:	00812403          	lw	s0,8(sp)
80005cf8:	00412483          	lw	s1,4(sp)
80005cfc:	01010113          	addi	sp,sp,16
80005d00:	00008067          	ret

80005d04 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005d04:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80005d08:	fd010113          	addi	sp,sp,-48
80005d0c:	02812423          	sw	s0,40(sp)
80005d10:	02912223          	sw	s1,36(sp)
80005d14:	01312e23          	sw	s3,28(sp)
80005d18:	02112623          	sw	ra,44(sp)
80005d1c:	03212023          	sw	s2,32(sp)
80005d20:	01412c23          	sw	s4,24(sp)
80005d24:	01512a23          	sw	s5,20(sp)
80005d28:	01612823          	sw	s6,16(sp)
80005d2c:	01712623          	sw	s7,12(sp)
80005d30:	01812423          	sw	s8,8(sp)
80005d34:	00050413          	mv	s0,a0
80005d38:	00058993          	mv	s3,a1
80005d3c:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005d40:	02078e63          	beqz	a5,80005d7c <z_add_timeout+0x78>
80005d44:	80008937          	lui	s2,0x80008
80005d48:	800085b7          	lui	a1,0x80008
80005d4c:	80008537          	lui	a0,0x80008
80005d50:	0b858593          	addi	a1,a1,184 # 800080b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080b9>
80005d54:	04d00693          	li	a3,77
80005d58:	0a490613          	addi	a2,s2,164 # 800080a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080a5>
80005d5c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005d60:	9b1fc0ef          	jal	ra,80002710 <printk>
80005d64:	80008537          	lui	a0,0x80008
80005d68:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80005d6c:	9a5fc0ef          	jal	ra,80002710 <printk>
80005d70:	04d00593          	li	a1,77
80005d74:	0a490513          	addi	a0,s2,164
80005d78:	9d5fc0ef          	jal	ra,8000274c <assert_post_action>
	to->fn = fn;
80005d7c:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80005d80:	00904463          	bgtz	s1,80005d88 <z_add_timeout+0x84>
80005d84:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005d88:	00800993          	li	s3,8
80005d8c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005d90:	80008a37          	lui	s4,0x80008
80005d94:	304a0513          	addi	a0,s4,772 # 80008304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008305>
	key = (mstatus & SOC_MSTATUS_IEN);
80005d98:	0089f993          	andi	s3,s3,8
80005d9c:	a41ff0ef          	jal	ra,800057dc <z_spin_lock_valid>
80005da0:	02051e63          	bnez	a0,80005ddc <z_add_timeout+0xd8>
80005da4:	80008937          	lui	s2,0x80008
80005da8:	800085b7          	lui	a1,0x80008
80005dac:	80008537          	lui	a0,0x80008
80005db0:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80005db4:	04e00693          	li	a3,78
80005db8:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005dbc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005dc0:	951fc0ef          	jal	ra,80002710 <printk>
80005dc4:	80008537          	lui	a0,0x80008
80005dc8:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80005dcc:	945fc0ef          	jal	ra,80002710 <printk>
80005dd0:	04e00593          	li	a1,78
80005dd4:	bc490513          	addi	a0,s2,-1084
80005dd8:	975fc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80005ddc:	304a0513          	addi	a0,s4,772
80005de0:	a55ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80005de4:	e45ff0ef          	jal	ra,80005c28 <elapsed>
80005de8:	00950533          	add	a0,a0,s1
	return list->head == list;
80005dec:	800084b7          	lui	s1,0x80008
80005df0:	26c4a903          	lw	s2,620(s1) # 8000826c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000826d>
80005df4:	00a42423          	sw	a0,8(s0)
80005df8:	26c48493          	addi	s1,s1,620
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005dfc:	00990c63          	beq	s2,s1,80005e14 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80005e00:	80008ab7          	lui	s5,0x80008
80005e04:	80008b37          	lui	s6,0x80008
80005e08:	80008bb7          	lui	s7,0x80008
80005e0c:	80008c37          	lui	s8,0x80008
		for (t = first(); t != NULL; t = next(t)) {
80005e10:	02091063          	bnez	s2,80005e30 <z_add_timeout+0x12c>
	node->prev = list->tail;
80005e14:	0044a783          	lw	a5,4(s1)
	node->next = list;
80005e18:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80005e1c:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80005e20:	0044a783          	lw	a5,4(s1)
80005e24:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80005e28:	0084a223          	sw	s0,4(s1)
80005e2c:	05c0006f          	j	80005e88 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80005e30:	00892783          	lw	a5,8(s2)
80005e34:	0207d663          	bgez	a5,80005e60 <z_add_timeout+0x15c>
80005e38:	0d8b0593          	addi	a1,s6,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
80005e3c:	05600693          	li	a3,86
80005e40:	0a4a8613          	addi	a2,s5,164 # 800080a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080a5>
80005e44:	af8b8513          	addi	a0,s7,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005e48:	8c9fc0ef          	jal	ra,80002710 <printk>
80005e4c:	b7cc0513          	addi	a0,s8,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
80005e50:	8c1fc0ef          	jal	ra,80002710 <printk>
80005e54:	05600593          	li	a1,86
80005e58:	0a4a8513          	addi	a0,s5,164
80005e5c:	8f1fc0ef          	jal	ra,8000274c <assert_post_action>

			if (t->dticks > to->dticks) {
80005e60:	00892703          	lw	a4,8(s2)
80005e64:	00842783          	lw	a5,8(s0)
80005e68:	0ae7d863          	bge	a5,a4,80005f18 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80005e6c:	40f707b3          	sub	a5,a4,a5
80005e70:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80005e74:	00492783          	lw	a5,4(s2)
	node->next = successor;
80005e78:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80005e7c:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80005e80:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80005e84:	00892223          	sw	s0,4(s2)
	return list->head == list;
80005e88:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005e8c:	00978a63          	beq	a5,s1,80005ea0 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80005e90:	00f41863          	bne	s0,a5,80005ea0 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80005e94:	dedff0ef          	jal	ra,80005c80 <next_timeout>
80005e98:	00000593          	li	a1,0
80005e9c:	b95fc0ef          	jal	ra,80002a30 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005ea0:	304a0513          	addi	a0,s4,772
80005ea4:	961ff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
80005ea8:	02051e63          	bnez	a0,80005ee4 <z_add_timeout+0x1e0>
80005eac:	80008437          	lui	s0,0x80008
80005eb0:	800085b7          	lui	a1,0x80008
80005eb4:	80008537          	lui	a0,0x80008
80005eb8:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80005ebc:	06100693          	li	a3,97
80005ec0:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005ec4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005ec8:	849fc0ef          	jal	ra,80002710 <printk>
80005ecc:	80008537          	lui	a0,0x80008
80005ed0:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80005ed4:	83dfc0ef          	jal	ra,80002710 <printk>
80005ed8:	06100593          	li	a1,97
80005edc:	bc440513          	addi	a0,s0,-1084
80005ee0:	86dfc0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005ee4:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80005ee8:	02c12083          	lw	ra,44(sp)
80005eec:	02812403          	lw	s0,40(sp)
80005ef0:	02412483          	lw	s1,36(sp)
80005ef4:	02012903          	lw	s2,32(sp)
80005ef8:	01c12983          	lw	s3,28(sp)
80005efc:	01812a03          	lw	s4,24(sp)
80005f00:	01412a83          	lw	s5,20(sp)
80005f04:	01012b03          	lw	s6,16(sp)
80005f08:	00c12b83          	lw	s7,12(sp)
80005f0c:	00812c03          	lw	s8,8(sp)
80005f10:	03010113          	addi	sp,sp,48
80005f14:	00008067          	ret
			to->dticks -= t->dticks;
80005f18:	40e787b3          	sub	a5,a5,a4
80005f1c:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80005f20:	0044a783          	lw	a5,4(s1)
80005f24:	ef2788e3          	beq	a5,s2,80005e14 <z_add_timeout+0x110>
80005f28:	00092903          	lw	s2,0(s2)
80005f2c:	ee5ff06f          	j	80005e10 <z_add_timeout+0x10c>

80005f30 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80005f30:	fe010113          	addi	sp,sp,-32
80005f34:	00812c23          	sw	s0,24(sp)
80005f38:	01312623          	sw	s3,12(sp)
80005f3c:	00112e23          	sw	ra,28(sp)
80005f40:	00912a23          	sw	s1,20(sp)
80005f44:	01212823          	sw	s2,16(sp)
80005f48:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005f4c:	00800413          	li	s0,8
80005f50:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005f54:	800084b7          	lui	s1,0x80008
80005f58:	30448513          	addi	a0,s1,772 # 80008304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008305>
	key = (mstatus & SOC_MSTATUS_IEN);
80005f5c:	00847413          	andi	s0,s0,8
80005f60:	87dff0ef          	jal	ra,800057dc <z_spin_lock_valid>
80005f64:	02051e63          	bnez	a0,80005fa0 <z_abort_timeout+0x70>
80005f68:	80008937          	lui	s2,0x80008
80005f6c:	800085b7          	lui	a1,0x80008
80005f70:	80008537          	lui	a0,0x80008
80005f74:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80005f78:	04e00693          	li	a3,78
80005f7c:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005f80:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005f84:	f8cfc0ef          	jal	ra,80002710 <printk>
80005f88:	80008537          	lui	a0,0x80008
80005f8c:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80005f90:	f80fc0ef          	jal	ra,80002710 <printk>
80005f94:	04e00593          	li	a1,78
80005f98:	bc490513          	addi	a0,s2,-1084
80005f9c:	fb0fc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80005fa0:	30448513          	addi	a0,s1,772
80005fa4:	891ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80005fa8:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80005fac:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80005fb0:	00078863          	beqz	a5,80005fc0 <z_abort_timeout+0x90>
			remove_timeout(to);
80005fb4:	00098513          	mv	a0,s3
80005fb8:	c89ff0ef          	jal	ra,80005c40 <remove_timeout>
			ret = 0;
80005fbc:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005fc0:	30448513          	addi	a0,s1,772
80005fc4:	841ff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
80005fc8:	02051e63          	bnez	a0,80006004 <z_abort_timeout+0xd4>
80005fcc:	800084b7          	lui	s1,0x80008
80005fd0:	800085b7          	lui	a1,0x80008
80005fd4:	80008537          	lui	a0,0x80008
80005fd8:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80005fdc:	06100693          	li	a3,97
80005fe0:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80005fe4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80005fe8:	f28fc0ef          	jal	ra,80002710 <printk>
80005fec:	80008537          	lui	a0,0x80008
80005ff0:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80005ff4:	f1cfc0ef          	jal	ra,80002710 <printk>
80005ff8:	06100593          	li	a1,97
80005ffc:	bc448513          	addi	a0,s1,-1084
80006000:	f4cfc0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006004:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80006008:	01c12083          	lw	ra,28(sp)
8000600c:	01812403          	lw	s0,24(sp)
80006010:	00090513          	mv	a0,s2
80006014:	01412483          	lw	s1,20(sp)
80006018:	01012903          	lw	s2,16(sp)
8000601c:	00c12983          	lw	s3,12(sp)
80006020:	02010113          	addi	sp,sp,32
80006024:	00008067          	ret

80006028 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80006028:	ff010113          	addi	sp,sp,-16
8000602c:	00812423          	sw	s0,8(sp)
80006030:	00112623          	sw	ra,12(sp)
80006034:	00912223          	sw	s1,4(sp)
80006038:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000603c:	00800413          	li	s0,8
80006040:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006044:	800084b7          	lui	s1,0x80008
80006048:	30448513          	addi	a0,s1,772 # 80008304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008305>
	key = (mstatus & SOC_MSTATUS_IEN);
8000604c:	00847413          	andi	s0,s0,8
80006050:	f8cff0ef          	jal	ra,800057dc <z_spin_lock_valid>
80006054:	02051e63          	bnez	a0,80006090 <z_get_next_timeout_expiry+0x68>
80006058:	80008937          	lui	s2,0x80008
8000605c:	800085b7          	lui	a1,0x80008
80006060:	80008537          	lui	a0,0x80008
80006064:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80006068:	04e00693          	li	a3,78
8000606c:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80006070:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80006074:	e9cfc0ef          	jal	ra,80002710 <printk>
80006078:	80008537          	lui	a0,0x80008
8000607c:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80006080:	e90fc0ef          	jal	ra,80002710 <printk>
80006084:	04e00593          	li	a1,78
80006088:	bc490513          	addi	a0,s2,-1084
8000608c:	ec0fc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
80006090:	30448513          	addi	a0,s1,772
80006094:	fa0ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80006098:	be9ff0ef          	jal	ra,80005c80 <next_timeout>
8000609c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800060a0:	30448513          	addi	a0,s1,772
800060a4:	f60ff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
800060a8:	02051e63          	bnez	a0,800060e4 <z_get_next_timeout_expiry+0xbc>
800060ac:	800084b7          	lui	s1,0x80008
800060b0:	800085b7          	lui	a1,0x80008
800060b4:	80008537          	lui	a0,0x80008
800060b8:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800060bc:	06100693          	li	a3,97
800060c0:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800060c4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800060c8:	e48fc0ef          	jal	ra,80002710 <printk>
800060cc:	80008537          	lui	a0,0x80008
800060d0:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800060d4:	e3cfc0ef          	jal	ra,80002710 <printk>
800060d8:	06100593          	li	a1,97
800060dc:	bc448513          	addi	a0,s1,-1084
800060e0:	e6cfc0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800060e4:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800060e8:	00c12083          	lw	ra,12(sp)
800060ec:	00812403          	lw	s0,8(sp)
800060f0:	00090513          	mv	a0,s2
800060f4:	00412483          	lw	s1,4(sp)
800060f8:	00012903          	lw	s2,0(sp)
800060fc:	01010113          	addi	sp,sp,16
80006100:	00008067          	ret

80006104 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80006104:	fe010113          	addi	sp,sp,-32
80006108:	00812c23          	sw	s0,24(sp)
8000610c:	01212823          	sw	s2,16(sp)
80006110:	01412423          	sw	s4,8(sp)
80006114:	00112e23          	sw	ra,28(sp)
80006118:	00912a23          	sw	s1,20(sp)
8000611c:	01312623          	sw	s3,12(sp)
80006120:	00050913          	mv	s2,a0
80006124:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006128:	00800413          	li	s0,8
8000612c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006130:	800084b7          	lui	s1,0x80008
80006134:	30448513          	addi	a0,s1,772 # 80008304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008305>
	key = (mstatus & SOC_MSTATUS_IEN);
80006138:	00847413          	andi	s0,s0,8
8000613c:	ea0ff0ef          	jal	ra,800057dc <z_spin_lock_valid>
80006140:	02051e63          	bnez	a0,8000617c <z_set_timeout_expiry+0x78>
80006144:	800089b7          	lui	s3,0x80008
80006148:	800085b7          	lui	a1,0x80008
8000614c:	80008537          	lui	a0,0x80008
80006150:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80006154:	04e00693          	li	a3,78
80006158:	bc498613          	addi	a2,s3,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
8000615c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80006160:	db0fc0ef          	jal	ra,80002710 <printk>
80006164:	80008537          	lui	a0,0x80008
80006168:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
8000616c:	da4fc0ef          	jal	ra,80002710 <printk>
80006170:	04e00593          	li	a1,78
80006174:	bc498513          	addi	a0,s3,-1084
80006178:	dd4fc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
8000617c:	30448513          	addi	a0,s1,772
80006180:	eb4ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80006184:	afdff0ef          	jal	ra,80005c80 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80006188:	00a95c63          	bge	s2,a0,800061a0 <z_set_timeout_expiry+0x9c>
8000618c:	00100793          	li	a5,1
80006190:	00a7d863          	bge	a5,a0,800061a0 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80006194:	000a0593          	mv	a1,s4
80006198:	00090513          	mv	a0,s2
8000619c:	895fc0ef          	jal	ra,80002a30 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800061a0:	30448513          	addi	a0,s1,772
800061a4:	e60ff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
800061a8:	02051e63          	bnez	a0,800061e4 <z_set_timeout_expiry+0xe0>
800061ac:	800084b7          	lui	s1,0x80008
800061b0:	800085b7          	lui	a1,0x80008
800061b4:	80008537          	lui	a0,0x80008
800061b8:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800061bc:	06100693          	li	a3,97
800061c0:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800061c4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800061c8:	d48fc0ef          	jal	ra,80002710 <printk>
800061cc:	80008537          	lui	a0,0x80008
800061d0:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800061d4:	d3cfc0ef          	jal	ra,80002710 <printk>
800061d8:	06100593          	li	a1,97
800061dc:	bc448513          	addi	a0,s1,-1084
800061e0:	d6cfc0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800061e4:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800061e8:	01c12083          	lw	ra,28(sp)
800061ec:	01812403          	lw	s0,24(sp)
800061f0:	01412483          	lw	s1,20(sp)
800061f4:	01012903          	lw	s2,16(sp)
800061f8:	00c12983          	lw	s3,12(sp)
800061fc:	00812a03          	lw	s4,8(sp)
80006200:	02010113          	addi	sp,sp,32
80006204:	00008067          	ret

80006208 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80006208:	fd010113          	addi	sp,sp,-48
8000620c:	02812423          	sw	s0,40(sp)
80006210:	01412c23          	sw	s4,24(sp)
80006214:	02112623          	sw	ra,44(sp)
80006218:	02912223          	sw	s1,36(sp)
8000621c:	03212023          	sw	s2,32(sp)
80006220:	01312e23          	sw	s3,28(sp)
80006224:	01512a23          	sw	s5,20(sp)
80006228:	01612823          	sw	s6,16(sp)
8000622c:	01712623          	sw	s7,12(sp)
80006230:	01812423          	sw	s8,8(sp)
80006234:	01912223          	sw	s9,4(sp)
80006238:	01a12023          	sw	s10,0(sp)
8000623c:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006240:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80006244:	becfe0ef          	jal	ra,80004630 <z_time_slice>
80006248:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000624c:	80008937          	lui	s2,0x80008
80006250:	30490513          	addi	a0,s2,772 # 80008304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008305>
	key = (mstatus & SOC_MSTATUS_IEN);
80006254:	00847413          	andi	s0,s0,8
80006258:	d84ff0ef          	jal	ra,800057dc <z_spin_lock_valid>
8000625c:	02051e63          	bnez	a0,80006298 <z_clock_announce+0x90>
80006260:	800084b7          	lui	s1,0x80008
80006264:	800085b7          	lui	a1,0x80008
80006268:	80008537          	lui	a0,0x80008
8000626c:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80006270:	04e00693          	li	a3,78
80006274:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80006278:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000627c:	c94fc0ef          	jal	ra,80002710 <printk>
80006280:	80008537          	lui	a0,0x80008
80006284:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80006288:	c88fc0ef          	jal	ra,80002710 <printk>
8000628c:	04e00593          	li	a1,78
80006290:	bc448513          	addi	a0,s1,-1084
80006294:	cb8fc0ef          	jal	ra,8000274c <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80006298:	800089b7          	lui	s3,0x80008
	z_spin_lock_set_owner(l);
8000629c:	30490513          	addi	a0,s2,772
800062a0:	d94ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
800062a4:	800084b7          	lui	s1,0x80008
800062a8:	3149a023          	sw	s4,768(s3) # 80008300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008301>
	return list->head == list;
800062ac:	80008a37          	lui	s4,0x80008
800062b0:	30098993          	addi	s3,s3,768
800062b4:	26ca0a13          	addi	s4,s4,620 # 8000826c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000826d>
800062b8:	2c848493          	addi	s1,s1,712 # 800082c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082c9>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800062bc:	80008ab7          	lui	s5,0x80008
800062c0:	80008bb7          	lui	s7,0x80008
800062c4:	80008b37          	lui	s6,0x80008
800062c8:	80008c37          	lui	s8,0x80008
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800062cc:	80008cb7          	lui	s9,0x80008
800062d0:	000a2d03          	lw	s10,0(s4)
800062d4:	0009a783          	lw	a5,0(s3)
800062d8:	0004a683          	lw	a3,0(s1)
800062dc:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800062e0:	014d0c63          	beq	s10,s4,800062f8 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
800062e4:	000d0a63          	beqz	s10,800062f8 <z_clock_announce+0xf0>
800062e8:	008d2703          	lw	a4,8(s10)
800062ec:	0ae7dc63          	bge	a5,a4,800063a4 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
800062f0:	40f70733          	sub	a4,a4,a5
800062f4:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
800062f8:	00d786b3          	add	a3,a5,a3
800062fc:	41f7d713          	srai	a4,a5,0x1f
80006300:	00a70733          	add	a4,a4,a0
80006304:	00f6b7b3          	sltu	a5,a3,a5
80006308:	00e787b3          	add	a5,a5,a4
8000630c:	00d4a023          	sw	a3,0(s1)
80006310:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80006314:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80006318:	969ff0ef          	jal	ra,80005c80 <next_timeout>
8000631c:	00000593          	li	a1,0
80006320:	f10fc0ef          	jal	ra,80002a30 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006324:	30490513          	addi	a0,s2,772
80006328:	cdcff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
8000632c:	02051e63          	bnez	a0,80006368 <z_clock_announce+0x160>
80006330:	800084b7          	lui	s1,0x80008
80006334:	800085b7          	lui	a1,0x80008
80006338:	80008537          	lui	a0,0x80008
8000633c:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80006340:	06100693          	li	a3,97
80006344:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80006348:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000634c:	bc4fc0ef          	jal	ra,80002710 <printk>
80006350:	80008537          	lui	a0,0x80008
80006354:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80006358:	bb8fc0ef          	jal	ra,80002710 <printk>
8000635c:	06100593          	li	a1,97
80006360:	bc448513          	addi	a0,s1,-1084
80006364:	be8fc0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006368:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
8000636c:	02c12083          	lw	ra,44(sp)
80006370:	02812403          	lw	s0,40(sp)
80006374:	02412483          	lw	s1,36(sp)
80006378:	02012903          	lw	s2,32(sp)
8000637c:	01c12983          	lw	s3,28(sp)
80006380:	01812a03          	lw	s4,24(sp)
80006384:	01412a83          	lw	s5,20(sp)
80006388:	01012b03          	lw	s6,16(sp)
8000638c:	00c12b83          	lw	s7,12(sp)
80006390:	00812c03          	lw	s8,8(sp)
80006394:	00412c83          	lw	s9,4(sp)
80006398:	00012d03          	lw	s10,0(sp)
8000639c:	03010113          	addi	sp,sp,48
800063a0:	00008067          	ret
		curr_tick += dt;
800063a4:	00d706b3          	add	a3,a4,a3
800063a8:	41f75593          	srai	a1,a4,0x1f
800063ac:	00a585b3          	add	a1,a1,a0
800063b0:	00e6b633          	sltu	a2,a3,a4
800063b4:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
800063b8:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
800063bc:	000d0513          	mv	a0,s10
		t->dticks = 0;
800063c0:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
800063c4:	00d4a023          	sw	a3,0(s1)
800063c8:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
800063cc:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
800063d0:	871ff0ef          	jal	ra,80005c40 <remove_timeout>
800063d4:	30490513          	addi	a0,s2,772
800063d8:	c2cff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
800063dc:	02051663          	bnez	a0,80006408 <z_clock_announce+0x200>
800063e0:	c0cb8593          	addi	a1,s7,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
800063e4:	06100693          	li	a3,97
800063e8:	bc4a8613          	addi	a2,s5,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800063ec:	af8b0513          	addi	a0,s6,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800063f0:	b20fc0ef          	jal	ra,80002710 <printk>
800063f4:	c24c0513          	addi	a0,s8,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
800063f8:	b18fc0ef          	jal	ra,80002710 <printk>
800063fc:	06100593          	li	a1,97
80006400:	bc4a8513          	addi	a0,s5,-1084
80006404:	b48fc0ef          	jal	ra,8000274c <assert_post_action>
80006408:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
8000640c:	00cd2783          	lw	a5,12(s10)
80006410:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006414:	00800413          	li	s0,8
80006418:	000780e7          	jalr	a5
8000641c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006420:	30490513          	addi	a0,s2,772
	key = (mstatus & SOC_MSTATUS_IEN);
80006424:	00847413          	andi	s0,s0,8
80006428:	bb4ff0ef          	jal	ra,800057dc <z_spin_lock_valid>
8000642c:	02051863          	bnez	a0,8000645c <z_clock_announce+0x254>
80006430:	bdcc8593          	addi	a1,s9,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80006434:	04e00693          	li	a3,78
80006438:	bc4a8613          	addi	a2,s5,-1084
8000643c:	af8b0513          	addi	a0,s6,-1288
80006440:	ad0fc0ef          	jal	ra,80002710 <printk>
80006444:	80008537          	lui	a0,0x80008
80006448:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
8000644c:	ac4fc0ef          	jal	ra,80002710 <printk>
80006450:	04e00593          	li	a1,78
80006454:	bc4a8513          	addi	a0,s5,-1084
80006458:	af4fc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
8000645c:	30490513          	addi	a0,s2,772
80006460:	bd4ff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	return k;
80006464:	e6dff06f          	j	800062d0 <z_clock_announce+0xc8>

80006468 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80006468:	fe010113          	addi	sp,sp,-32
8000646c:	00912a23          	sw	s1,20(sp)
80006470:	00112e23          	sw	ra,28(sp)
80006474:	00812c23          	sw	s0,24(sp)
80006478:	01212823          	sw	s2,16(sp)
8000647c:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006480:	00800493          	li	s1,8
80006484:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006488:	80008937          	lui	s2,0x80008
8000648c:	30490513          	addi	a0,s2,772 # 80008304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008305>
	key = (mstatus & SOC_MSTATUS_IEN);
80006490:	0084f493          	andi	s1,s1,8
80006494:	b48ff0ef          	jal	ra,800057dc <z_spin_lock_valid>
80006498:	02051e63          	bnez	a0,800064d4 <z_tick_get+0x6c>
8000649c:	80008437          	lui	s0,0x80008
800064a0:	800085b7          	lui	a1,0x80008
800064a4:	80008537          	lui	a0,0x80008
800064a8:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
800064ac:	04e00693          	li	a3,78
800064b0:	bc440613          	addi	a2,s0,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
800064b4:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800064b8:	a58fc0ef          	jal	ra,80002710 <printk>
800064bc:	80008537          	lui	a0,0x80008
800064c0:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
800064c4:	a4cfc0ef          	jal	ra,80002710 <printk>
800064c8:	04e00593          	li	a1,78
800064cc:	bc440513          	addi	a0,s0,-1084
800064d0:	a7cfc0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
800064d4:	30490513          	addi	a0,s2,772
800064d8:	b5cff0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
800064dc:	ed0fc0ef          	jal	ra,80002bac <z_clock_elapsed>
800064e0:	800087b7          	lui	a5,0x80008
800064e4:	2c878793          	addi	a5,a5,712 # 800082c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082c9>
800064e8:	0007a983          	lw	s3,0(a5)
800064ec:	0047a403          	lw	s0,4(a5)
800064f0:	013509b3          	add	s3,a0,s3
800064f4:	00a9b533          	sltu	a0,s3,a0
800064f8:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800064fc:	30490513          	addi	a0,s2,772
80006500:	b04ff0ef          	jal	ra,80005804 <z_spin_unlock_valid>
80006504:	02051e63          	bnez	a0,80006540 <z_tick_get+0xd8>
80006508:	80008937          	lui	s2,0x80008
8000650c:	800085b7          	lui	a1,0x80008
80006510:	80008537          	lui	a0,0x80008
80006514:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80006518:	06100693          	li	a3,97
8000651c:	bc490613          	addi	a2,s2,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80006520:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80006524:	9ecfc0ef          	jal	ra,80002710 <printk>
80006528:	80008537          	lui	a0,0x80008
8000652c:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
80006530:	9e0fc0ef          	jal	ra,80002710 <printk>
80006534:	06100593          	li	a1,97
80006538:	bc490513          	addi	a0,s2,-1084
8000653c:	a10fc0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006540:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80006544:	00040593          	mv	a1,s0
80006548:	01c12083          	lw	ra,28(sp)
8000654c:	01812403          	lw	s0,24(sp)
80006550:	00098513          	mv	a0,s3
80006554:	01412483          	lw	s1,20(sp)
80006558:	01012903          	lw	s2,16(sp)
8000655c:	00c12983          	lw	s3,12(sp)
80006560:	02010113          	addi	sp,sp,32
80006564:	00008067          	ret

80006568 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80006568:	ff010113          	addi	sp,sp,-16
8000656c:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80006570:	ef9ff0ef          	jal	ra,80006468 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80006574:	00c12083          	lw	ra,12(sp)
80006578:	01010113          	addi	sp,sp,16
8000657c:	00008067          	ret

80006580 <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
80006580:	ff010113          	addi	sp,sp,-16
80006584:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
80006588:	ee1ff0ef          	jal	ra,80006468 <z_tick_get>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000658c:	3e800793          	li	a5,1000
80006590:	02a7b733          	mulhu	a4,a5,a0
80006594:	06400613          	li	a2,100
80006598:	00000693          	li	a3,0
8000659c:	02b785b3          	mul	a1,a5,a1
800065a0:	02a78533          	mul	a0,a5,a0
800065a4:	00e585b3          	add	a1,a1,a4
800065a8:	d19f90ef          	jal	ra,800002c0 <__udivdi3>
}
800065ac:	00c12083          	lw	ra,12(sp)
800065b0:	01010113          	addi	sp,sp,16
800065b4:	00008067          	ret

800065b8 <k_timer_init>:
800065b8:	01050793          	addi	a5,a0,16

void k_timer_init(struct k_timer *timer,
			 k_timer_expiry_t expiry_fn,
			 k_timer_stop_t stop_fn)
{
	timer->expiry_fn = expiry_fn;
800065bc:	00b52c23          	sw	a1,24(a0)
	timer->stop_fn = stop_fn;
800065c0:	00c52e23          	sw	a2,28(a0)
	timer->status = 0U;
800065c4:	02052223          	sw	zero,36(a0)
	list->head = (sys_dnode_t *)list;
800065c8:	00f52823          	sw	a5,16(a0)
	list->tail = (sys_dnode_t *)list;
800065cc:	00f52a23          	sw	a5,20(a0)
	node->next = NULL;
800065d0:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800065d4:	00052223          	sw	zero,4(a0)

	z_waitq_init(&timer->wait_q);
	z_init_timeout(&timer->timeout, z_timer_expiration_handler);
	SYS_TRACING_OBJ_INIT(k_timer, timer);

	timer->user_data = NULL;
800065d8:	02052423          	sw	zero,40(a0)

	z_object_init(timer);
}
800065dc:	00008067          	ret

800065e0 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
800065e0:	ff010113          	addi	sp,sp,-16
800065e4:	00812423          	sw	s0,8(sp)
800065e8:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800065ec:	80008437          	lui	s0,0x80008
800065f0:	800084b7          	lui	s1,0x80008
{
800065f4:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800065f8:	2ac40413          	addi	s0,s0,684 # 800082ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ad>
800065fc:	2ac48493          	addi	s1,s1,684 # 800082ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ad>
80006600:	00946e63          	bltu	s0,s1,8000661c <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80006604:	00c12083          	lw	ra,12(sp)
80006608:	00812403          	lw	s0,8(sp)
8000660c:	00412483          	lw	s1,4(sp)
80006610:	00000513          	li	a0,0
80006614:	01010113          	addi	sp,sp,16
80006618:	00008067          	ret
8000661c:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80006620:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80006624:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80006628:	00f42c23          	sw	a5,24(s0)
8000662c:	be8fb0ef          	jal	ra,80001a14 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80006630:	01c40413          	addi	s0,s0,28
80006634:	fcdff06f          	j	80006600 <init_static_pools+0x20>

80006638 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006638:	800097b7          	lui	a5,0x80009
8000663c:	93c7a783          	lw	a5,-1732(a5) # 8000893c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000893d>
{
80006640:	fb010113          	addi	sp,sp,-80
80006644:	04912223          	sw	s1,68(sp)
80006648:	03312e23          	sw	s3,60(sp)
8000664c:	03412c23          	sw	s4,56(sp)
80006650:	03712623          	sw	s7,44(sp)
80006654:	04112623          	sw	ra,76(sp)
80006658:	04812423          	sw	s0,72(sp)
8000665c:	05212023          	sw	s2,64(sp)
80006660:	03512a23          	sw	s5,52(sp)
80006664:	03612823          	sw	s6,48(sp)
80006668:	03812423          	sw	s8,40(sp)
8000666c:	03912223          	sw	s9,36(sp)
80006670:	03a12023          	sw	s10,32(sp)
80006674:	01b12e23          	sw	s11,28(sp)
80006678:	00050a13          	mv	s4,a0
8000667c:	00058993          	mv	s3,a1
80006680:	00060b93          	mv	s7,a2
80006684:	00068493          	mv	s1,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006688:	16078263          	beqz	a5,800067ec <k_mem_pool_alloc+0x1b4>
8000668c:	12069463          	bnez	a3,800067b4 <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
80006690:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80006694:	80008437          	lui	s0,0x80008
80006698:	2ac40413          	addi	s0,s0,684 # 800082ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ad>
8000669c:	408a0433          	sub	s0,s4,s0
800066a0:	b6db77b7          	lui	a5,0xb6db7
800066a4:	40245413          	srai	s0,s0,0x2
800066a8:	db778793          	addi	a5,a5,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
800066ac:	02f40433          	mul	s0,s0,a5
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
800066b0:	fffffab7          	lui	s5,0xfffff
		block->id.block = block_num;
800066b4:	00001b37          	lui	s6,0x1
			if (ret != -EAGAIN) {
800066b8:	ff500c13          	li	s8,-11
			ret = -ENOMEM;
800066bc:	ff400c93          	li	s9,-12
		block->id.level = level_num;
800066c0:	0ffa8a93          	addi	s5,s5,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
800066c4:	fffb0b13          	addi	s6,s6,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800066c8:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
800066cc:	014a0d93          	addi	s11,s4,20
		block->id.pool = pool_id(p);
800066d0:	0ff47413          	andi	s0,s0,255
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
800066d4:	00098713          	mv	a4,s3
800066d8:	00c10693          	addi	a3,sp,12
800066dc:	00810613          	addi	a2,sp,8
800066e0:	000b8593          	mv	a1,s7
800066e4:	000a0513          	mv	a0,s4
800066e8:	c2cfb0ef          	jal	ra,80001b14 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
800066ec:	03851263          	bne	a0,s8,80006710 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
800066f0:	00098713          	mv	a4,s3
800066f4:	00c10693          	addi	a3,sp,12
800066f8:	00810613          	addi	a2,sp,8
800066fc:	000b8593          	mv	a1,s7
80006700:	000a0513          	mv	a0,s4
80006704:	c10fb0ef          	jal	ra,80001b14 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80006708:	01851463          	bne	a0,s8,80006710 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
8000670c:	ff400513          	li	a0,-12
		block->id.level = level_num;
80006710:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80006714:	00898223          	sb	s0,4(s3)
		block->id.level = level_num;
80006718:	00f7f793          	andi	a5,a5,15
8000671c:	00879713          	slli	a4,a5,0x8
80006720:	0049a783          	lw	a5,4(s3)
80006724:	0157f7b3          	and	a5,a5,s5
80006728:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
8000672c:	00c12703          	lw	a4,12(sp)
80006730:	0167f7b3          	and	a5,a5,s6
80006734:	00c71713          	slli	a4,a4,0xc
80006738:	00e7e7b3          	or	a5,a5,a4
8000673c:	00f9a223          	sw	a5,4(s3)
		if (ret == 0 || timeout == K_NO_WAIT ||
80006740:	02050c63          	beqz	a0,80006778 <k_mem_pool_alloc+0x140>
80006744:	02048a63          	beqz	s1,80006778 <k_mem_pool_alloc+0x140>
80006748:	03951863          	bne	a0,s9,80006778 <k_mem_pool_alloc+0x140>
8000674c:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80006750:	00048613          	mv	a2,s1
80006754:	000d8593          	mv	a1,s11
80006758:	00857513          	andi	a0,a0,8
8000675c:	98cfe0ef          	jal	ra,800048e8 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80006760:	fff00793          	li	a5,-1
80006764:	f6f488e3          	beq	s1,a5,800066d4 <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
80006768:	d01ff0ef          	jal	ra,80006468 <z_tick_get>
8000676c:	40a904b3          	sub	s1,s2,a0

			if (timeout < 0) {
80006770:	f604d2e3          	bgez	s1,800066d4 <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80006774:	ff500513          	li	a0,-11
}
80006778:	04c12083          	lw	ra,76(sp)
8000677c:	04812403          	lw	s0,72(sp)
80006780:	04412483          	lw	s1,68(sp)
80006784:	04012903          	lw	s2,64(sp)
80006788:	03c12983          	lw	s3,60(sp)
8000678c:	03812a03          	lw	s4,56(sp)
80006790:	03412a83          	lw	s5,52(sp)
80006794:	03012b03          	lw	s6,48(sp)
80006798:	02c12b83          	lw	s7,44(sp)
8000679c:	02812c03          	lw	s8,40(sp)
800067a0:	02412c83          	lw	s9,36(sp)
800067a4:	02012d03          	lw	s10,32(sp)
800067a8:	01c12d83          	lw	s11,28(sp)
800067ac:	05010113          	addi	sp,sp,80
800067b0:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800067b4:	80008437          	lui	s0,0x80008
800067b8:	800085b7          	lui	a1,0x80008
800067bc:	80008537          	lui	a0,0x80008
800067c0:	0fc58593          	addi	a1,a1,252 # 800080fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080fd>
800067c4:	03900693          	li	a3,57
800067c8:	0e840613          	addi	a2,s0,232 # 800080e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e9>
800067cc:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
800067d0:	f41fb0ef          	jal	ra,80002710 <printk>
800067d4:	80008537          	lui	a0,0x80008
800067d8:	b7c50513          	addi	a0,a0,-1156 # 80007b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b7d>
800067dc:	f35fb0ef          	jal	ra,80002710 <printk>
800067e0:	03900593          	li	a1,57
800067e4:	0e840513          	addi	a0,s0,232
800067e8:	f65fb0ef          	jal	ra,8000274c <assert_post_action>
	if (timeout > 0) {
800067ec:	ea9052e3          	blez	s1,80006690 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
800067f0:	c79ff0ef          	jal	ra,80006468 <z_tick_get>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800067f4:	00948913          	addi	s2,s1,9
800067f8:	00a00793          	li	a5,10
800067fc:	02f94933          	div	s2,s2,a5
80006800:	00a90933          	add	s2,s2,a0
80006804:	e91ff06f          	j	80006694 <k_mem_pool_alloc+0x5c>

80006808 <k_mem_pool_free_id>:

void k_mem_pool_free_id(struct k_mem_block_id *id)
{
80006808:	fe010113          	addi	sp,sp,-32
8000680c:	01212823          	sw	s2,16(sp)
80006810:	00054903          	lbu	s2,0(a0)
80006814:	01c00793          	li	a5,28
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006818:	00052603          	lw	a2,0(a0)
8000681c:	02f90933          	mul	s2,s2,a5
{
80006820:	01312623          	sw	s3,12(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006824:	800089b7          	lui	s3,0x80008
80006828:	00865593          	srli	a1,a2,0x8
8000682c:	2ac98513          	addi	a0,s3,684 # 800082ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082ad>
80006830:	00c65613          	srli	a2,a2,0xc
80006834:	00f5f593          	andi	a1,a1,15
{
80006838:	00812c23          	sw	s0,24(sp)
8000683c:	00112e23          	sw	ra,28(sp)
80006840:	00912a23          	sw	s1,20(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006844:	01250533          	add	a0,a0,s2
{
80006848:	01412423          	sw	s4,8(sp)
8000684c:	00800413          	li	s0,8
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006850:	d8cfb0ef          	jal	ra,80001ddc <z_sys_mem_pool_block_free>
80006854:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006858:	800084b7          	lui	s1,0x80008
8000685c:	30848513          	addi	a0,s1,776 # 80008308 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008309>
80006860:	f7dfe0ef          	jal	ra,800057dc <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
80006864:	00847413          	andi	s0,s0,8
80006868:	2ac98993          	addi	s3,s3,684
8000686c:	02051e63          	bnez	a0,800068a8 <k_mem_pool_free_id+0xa0>
80006870:	80008a37          	lui	s4,0x80008
80006874:	800085b7          	lui	a1,0x80008
80006878:	80008537          	lui	a0,0x80008
8000687c:	bdc58593          	addi	a1,a1,-1060 # 80007bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bdd>
80006880:	04e00693          	li	a3,78
80006884:	bc4a0613          	addi	a2,s4,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
80006888:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
8000688c:	e85fb0ef          	jal	ra,80002710 <printk>
80006890:	80008537          	lui	a0,0x80008
80006894:	bf450513          	addi	a0,a0,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80006898:	e79fb0ef          	jal	ra,80002710 <printk>
8000689c:	04e00593          	li	a1,78
800068a0:	bc4a0513          	addi	a0,s4,-1084
800068a4:	ea9fb0ef          	jal	ra,8000274c <assert_post_action>
	z_spin_lock_set_owner(l);
800068a8:	30848513          	addi	a0,s1,776
800068ac:	f89fe0ef          	jal	ra,80005834 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
800068b0:	01490513          	addi	a0,s2,20
800068b4:	00a98533          	add	a0,s3,a0
800068b8:	cacfe0ef          	jal	ra,80004d64 <z_unpend_all>

	if (need_sched != 0) {
800068bc:	02050663          	beqz	a0,800068e8 <k_mem_pool_free_id+0xe0>
		z_reschedule(&lock, key);
800068c0:	00040593          	mv	a1,s0
	} else {
		k_spin_unlock(&lock, key);
	}
}
800068c4:	01812403          	lw	s0,24(sp)
800068c8:	01c12083          	lw	ra,28(sp)
800068cc:	01012903          	lw	s2,16(sp)
800068d0:	00c12983          	lw	s3,12(sp)
800068d4:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
800068d8:	30848513          	addi	a0,s1,776
}
800068dc:	01412483          	lw	s1,20(sp)
800068e0:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
800068e4:	a70fd06f          	j	80003b54 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800068e8:	30848513          	addi	a0,s1,776
800068ec:	f19fe0ef          	jal	ra,80005804 <z_spin_unlock_valid>
800068f0:	02051e63          	bnez	a0,8000692c <k_mem_pool_free_id+0x124>
800068f4:	800084b7          	lui	s1,0x80008
800068f8:	800085b7          	lui	a1,0x80008
800068fc:	80008537          	lui	a0,0x80008
80006900:	c0c58593          	addi	a1,a1,-1012 # 80007c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c0d>
80006904:	06100693          	li	a3,97
80006908:	bc448613          	addi	a2,s1,-1084 # 80007bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc5>
8000690c:	af850513          	addi	a0,a0,-1288 # 80007af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af9>
80006910:	e01fb0ef          	jal	ra,80002710 <printk>
80006914:	80008537          	lui	a0,0x80008
80006918:	c2450513          	addi	a0,a0,-988 # 80007c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c25>
8000691c:	df5fb0ef          	jal	ra,80002710 <printk>
80006920:	06100593          	li	a1,97
80006924:	bc448513          	addi	a0,s1,-1084
80006928:	e25fb0ef          	jal	ra,8000274c <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000692c:	30042473          	csrrs	s0,mstatus,s0
}
80006930:	01c12083          	lw	ra,28(sp)
80006934:	01812403          	lw	s0,24(sp)
80006938:	01412483          	lw	s1,20(sp)
8000693c:	01012903          	lw	s2,16(sp)
80006940:	00c12983          	lw	s3,12(sp)
80006944:	00812a03          	lw	s4,8(sp)
80006948:	02010113          	addi	sp,sp,32
8000694c:	00008067          	ret

80006950 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
80006950:	00458613          	addi	a2,a1,4
80006954:	00b67e63          	bgeu	a2,a1,80006970 <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
80006958:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
8000695c:	00008067          	ret
		return NULL;
80006960:	00000513          	li	a0,0
}
80006964:	01c12083          	lw	ra,28(sp)
80006968:	02010113          	addi	sp,sp,32
8000696c:	00008067          	ret
{
80006970:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006974:	00000693          	li	a3,0
80006978:	00810593          	addi	a1,sp,8
{
8000697c:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006980:	cb9ff0ef          	jal	ra,80006638 <k_mem_pool_alloc>
80006984:	fc051ee3          	bnez	a0,80006960 <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80006988:	00812503          	lw	a0,8(sp)
8000698c:	00400613          	li	a2,4
80006990:	00c10593          	addi	a1,sp,12
80006994:	b44fc0ef          	jal	ra,80002cd8 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80006998:	00812503          	lw	a0,8(sp)
8000699c:	00450513          	addi	a0,a0,4
800069a0:	fc5ff06f          	j	80006964 <k_mem_pool_malloc+0x14>

800069a4 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
800069a4:	00050663          	beqz	a0,800069b0 <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
800069a8:	ffc50513          	addi	a0,a0,-4
800069ac:	e5dff06f          	j	80006808 <k_mem_pool_free_id>
	}
}
800069b0:	00008067          	ret

800069b4 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
800069b4:	800097b7          	lui	a5,0x80009
800069b8:	9447a783          	lw	a5,-1724(a5) # 80008944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008945>
{
800069bc:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
800069c0:	0687a503          	lw	a0,104(a5)
800069c4:	00050463          	beqz	a0,800069cc <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
800069c8:	f89ff06f          	j	80006950 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
800069cc:	00000513          	li	a0,0
800069d0:	00008067          	ret

800069d4 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
800069d4:	00008067          	ret
