
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	11c0106f          	j	80001128 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	79d0006f          	j	80001038 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00006297          	auipc	t0,0x6
800000b0:	26828293          	addi	t0,t0,616 # 80006314 <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00006397          	auipc	t2,0x6
800000c8:	4f838393          	addi	t2,t2,1272 # 800065bc <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	7d50006f          	j	800010c4 <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00005297          	auipc	t0,0x5
8000010c:	25c28293          	addi	t0,t0,604 # 80005364 <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00006317          	auipc	t1,0x6
80000128:	49830313          	addi	t1,t1,1176 # 800065bc <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00006297          	auipc	t0,0x6
80000150:	47028293          	addi	t0,t0,1136 # 800065bc <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00006397          	auipc	t2,0x6
80000190:	12838393          	addi	t2,t2,296 # 800062b4 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00006297          	auipc	t0,0x6
80000240:	38028293          	addi	t0,t0,896 # 800065bc <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	fd010113          	addi	sp,sp,-48
800002c4:	02912223          	sw	s1,36(sp)
800002c8:	01612823          	sw	s6,16(sp)
800002cc:	02112623          	sw	ra,44(sp)
800002d0:	02812423          	sw	s0,40(sp)
800002d4:	03212023          	sw	s2,32(sp)
800002d8:	01312e23          	sw	s3,28(sp)
800002dc:	01412c23          	sw	s4,24(sp)
800002e0:	01512a23          	sw	s5,20(sp)
800002e4:	01712623          	sw	s7,12(sp)
800002e8:	01812423          	sw	s8,8(sp)
800002ec:	01912223          	sw	s9,4(sp)
800002f0:	00050b13          	mv	s6,a0
800002f4:	00058493          	mv	s1,a1
800002f8:	38069c63          	bnez	a3,80000690 <__udivdi3+0x3d0>
800002fc:	00060413          	mv	s0,a2
80000300:	00050993          	mv	s3,a0
80000304:	00005917          	auipc	s2,0x5
80000308:	1e090913          	addi	s2,s2,480 # 800054e4 <__devconfig_end>
8000030c:	12c5f863          	bgeu	a1,a2,8000043c <__udivdi3+0x17c>
80000310:	000107b7          	lui	a5,0x10
80000314:	00058a93          	mv	s5,a1
80000318:	10f67863          	bgeu	a2,a5,80000428 <__udivdi3+0x168>
8000031c:	0ff00693          	li	a3,255
80000320:	00c6b6b3          	sltu	a3,a3,a2
80000324:	00369693          	slli	a3,a3,0x3
80000328:	00d657b3          	srl	a5,a2,a3
8000032c:	00f90933          	add	s2,s2,a5
80000330:	00094703          	lbu	a4,0(s2)
80000334:	00d706b3          	add	a3,a4,a3
80000338:	02000713          	li	a4,32
8000033c:	40d70733          	sub	a4,a4,a3
80000340:	00070c63          	beqz	a4,80000358 <__udivdi3+0x98>
80000344:	00e494b3          	sll	s1,s1,a4
80000348:	00db56b3          	srl	a3,s6,a3
8000034c:	00e61433          	sll	s0,a2,a4
80000350:	0096eab3          	or	s5,a3,s1
80000354:	00eb19b3          	sll	s3,s6,a4
80000358:	01045b13          	srli	s6,s0,0x10
8000035c:	000b0593          	mv	a1,s6
80000360:	000a8513          	mv	a0,s5
80000364:	634000ef          	jal	ra,80000998 <__umodsi3>
80000368:	00050913          	mv	s2,a0
8000036c:	000b0593          	mv	a1,s6
80000370:	01041b93          	slli	s7,s0,0x10
80000374:	000a8513          	mv	a0,s5
80000378:	5d8000ef          	jal	ra,80000950 <__udivsi3>
8000037c:	010bdb93          	srli	s7,s7,0x10
80000380:	00050493          	mv	s1,a0
80000384:	00050593          	mv	a1,a0
80000388:	000b8513          	mv	a0,s7
8000038c:	508000ef          	jal	ra,80000894 <__mulsi3>
80000390:	01091913          	slli	s2,s2,0x10
80000394:	0109d713          	srli	a4,s3,0x10
80000398:	00e96733          	or	a4,s2,a4
8000039c:	00048a13          	mv	s4,s1
800003a0:	00a77e63          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003a4:	00870733          	add	a4,a4,s0
800003a8:	fff48a13          	addi	s4,s1,-1
800003ac:	00876863          	bltu	a4,s0,800003bc <__udivdi3+0xfc>
800003b0:	00a77663          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003b4:	ffe48a13          	addi	s4,s1,-2
800003b8:	00870733          	add	a4,a4,s0
800003bc:	40a704b3          	sub	s1,a4,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	5d0000ef          	jal	ra,80000998 <__umodsi3>
800003cc:	00050913          	mv	s2,a0
800003d0:	000b0593          	mv	a1,s6
800003d4:	00048513          	mv	a0,s1
800003d8:	578000ef          	jal	ra,80000950 <__udivsi3>
800003dc:	01099993          	slli	s3,s3,0x10
800003e0:	00050493          	mv	s1,a0
800003e4:	00050593          	mv	a1,a0
800003e8:	01091913          	slli	s2,s2,0x10
800003ec:	000b8513          	mv	a0,s7
800003f0:	0109d993          	srli	s3,s3,0x10
800003f4:	4a0000ef          	jal	ra,80000894 <__mulsi3>
800003f8:	013969b3          	or	s3,s2,s3
800003fc:	00048613          	mv	a2,s1
80000400:	00a9fc63          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000404:	013409b3          	add	s3,s0,s3
80000408:	fff48613          	addi	a2,s1,-1
8000040c:	0089e663          	bltu	s3,s0,80000418 <__udivdi3+0x158>
80000410:	00a9f463          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000414:	ffe48613          	addi	a2,s1,-2
80000418:	010a1793          	slli	a5,s4,0x10
8000041c:	00c7e7b3          	or	a5,a5,a2
80000420:	00000a13          	li	s4,0
80000424:	1300006f          	j	80000554 <__udivdi3+0x294>
80000428:	010007b7          	lui	a5,0x1000
8000042c:	01000693          	li	a3,16
80000430:	eef66ce3          	bltu	a2,a5,80000328 <__udivdi3+0x68>
80000434:	01800693          	li	a3,24
80000438:	ef1ff06f          	j	80000328 <__udivdi3+0x68>
8000043c:	00068a13          	mv	s4,a3
80000440:	00061a63          	bnez	a2,80000454 <__udivdi3+0x194>
80000444:	00000593          	li	a1,0
80000448:	00100513          	li	a0,1
8000044c:	504000ef          	jal	ra,80000950 <__udivsi3>
80000450:	00050413          	mv	s0,a0
80000454:	000107b7          	lui	a5,0x10
80000458:	12f47c63          	bgeu	s0,a5,80000590 <__udivdi3+0x2d0>
8000045c:	0ff00793          	li	a5,255
80000460:	0087f463          	bgeu	a5,s0,80000468 <__udivdi3+0x1a8>
80000464:	00800a13          	li	s4,8
80000468:	014457b3          	srl	a5,s0,s4
8000046c:	00f90933          	add	s2,s2,a5
80000470:	00094683          	lbu	a3,0(s2)
80000474:	02000613          	li	a2,32
80000478:	014686b3          	add	a3,a3,s4
8000047c:	40d60633          	sub	a2,a2,a3
80000480:	12061263          	bnez	a2,800005a4 <__udivdi3+0x2e4>
80000484:	408484b3          	sub	s1,s1,s0
80000488:	00100a13          	li	s4,1
8000048c:	01045b13          	srli	s6,s0,0x10
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	500000ef          	jal	ra,80000998 <__umodsi3>
8000049c:	00050913          	mv	s2,a0
800004a0:	000b0593          	mv	a1,s6
800004a4:	00048513          	mv	a0,s1
800004a8:	01041b93          	slli	s7,s0,0x10
800004ac:	4a4000ef          	jal	ra,80000950 <__udivsi3>
800004b0:	010bdb93          	srli	s7,s7,0x10
800004b4:	00050493          	mv	s1,a0
800004b8:	00050593          	mv	a1,a0
800004bc:	000b8513          	mv	a0,s7
800004c0:	3d4000ef          	jal	ra,80000894 <__mulsi3>
800004c4:	01091913          	slli	s2,s2,0x10
800004c8:	0109d713          	srli	a4,s3,0x10
800004cc:	00e96733          	or	a4,s2,a4
800004d0:	00048a93          	mv	s5,s1
800004d4:	00a77e63          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004d8:	00870733          	add	a4,a4,s0
800004dc:	fff48a93          	addi	s5,s1,-1
800004e0:	00876863          	bltu	a4,s0,800004f0 <__udivdi3+0x230>
800004e4:	00a77663          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004e8:	ffe48a93          	addi	s5,s1,-2
800004ec:	00870733          	add	a4,a4,s0
800004f0:	40a704b3          	sub	s1,a4,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	49c000ef          	jal	ra,80000998 <__umodsi3>
80000500:	00050913          	mv	s2,a0
80000504:	000b0593          	mv	a1,s6
80000508:	00048513          	mv	a0,s1
8000050c:	444000ef          	jal	ra,80000950 <__udivsi3>
80000510:	01099993          	slli	s3,s3,0x10
80000514:	00050493          	mv	s1,a0
80000518:	00050593          	mv	a1,a0
8000051c:	01091913          	slli	s2,s2,0x10
80000520:	000b8513          	mv	a0,s7
80000524:	0109d993          	srli	s3,s3,0x10
80000528:	36c000ef          	jal	ra,80000894 <__mulsi3>
8000052c:	013969b3          	or	s3,s2,s3
80000530:	00048613          	mv	a2,s1
80000534:	00a9fc63          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000538:	013409b3          	add	s3,s0,s3
8000053c:	fff48613          	addi	a2,s1,-1
80000540:	0089e663          	bltu	s3,s0,8000054c <__udivdi3+0x28c>
80000544:	00a9f463          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000548:	ffe48613          	addi	a2,s1,-2
8000054c:	010a9793          	slli	a5,s5,0x10
80000550:	00c7e7b3          	or	a5,a5,a2
80000554:	00078513          	mv	a0,a5
80000558:	000a0593          	mv	a1,s4
8000055c:	02c12083          	lw	ra,44(sp)
80000560:	02812403          	lw	s0,40(sp)
80000564:	02412483          	lw	s1,36(sp)
80000568:	02012903          	lw	s2,32(sp)
8000056c:	01c12983          	lw	s3,28(sp)
80000570:	01812a03          	lw	s4,24(sp)
80000574:	01412a83          	lw	s5,20(sp)
80000578:	01012b03          	lw	s6,16(sp)
8000057c:	00c12b83          	lw	s7,12(sp)
80000580:	00812c03          	lw	s8,8(sp)
80000584:	00412c83          	lw	s9,4(sp)
80000588:	03010113          	addi	sp,sp,48
8000058c:	00008067          	ret
80000590:	010007b7          	lui	a5,0x1000
80000594:	01000a13          	li	s4,16
80000598:	ecf468e3          	bltu	s0,a5,80000468 <__udivdi3+0x1a8>
8000059c:	01800a13          	li	s4,24
800005a0:	ec9ff06f          	j	80000468 <__udivdi3+0x1a8>
800005a4:	00c41433          	sll	s0,s0,a2
800005a8:	00d4da33          	srl	s4,s1,a3
800005ac:	00cb19b3          	sll	s3,s6,a2
800005b0:	00db56b3          	srl	a3,s6,a3
800005b4:	01045b13          	srli	s6,s0,0x10
800005b8:	00c494b3          	sll	s1,s1,a2
800005bc:	000b0593          	mv	a1,s6
800005c0:	000a0513          	mv	a0,s4
800005c4:	0096eab3          	or	s5,a3,s1
800005c8:	3d0000ef          	jal	ra,80000998 <__umodsi3>
800005cc:	00050913          	mv	s2,a0
800005d0:	000b0593          	mv	a1,s6
800005d4:	000a0513          	mv	a0,s4
800005d8:	01041b93          	slli	s7,s0,0x10
800005dc:	374000ef          	jal	ra,80000950 <__udivsi3>
800005e0:	010bdb93          	srli	s7,s7,0x10
800005e4:	00050493          	mv	s1,a0
800005e8:	00050593          	mv	a1,a0
800005ec:	000b8513          	mv	a0,s7
800005f0:	2a4000ef          	jal	ra,80000894 <__mulsi3>
800005f4:	01091913          	slli	s2,s2,0x10
800005f8:	010ad713          	srli	a4,s5,0x10
800005fc:	00e96733          	or	a4,s2,a4
80000600:	00048a13          	mv	s4,s1
80000604:	00a77e63          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000608:	00870733          	add	a4,a4,s0
8000060c:	fff48a13          	addi	s4,s1,-1
80000610:	00876863          	bltu	a4,s0,80000620 <__udivdi3+0x360>
80000614:	00a77663          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000618:	ffe48a13          	addi	s4,s1,-2
8000061c:	00870733          	add	a4,a4,s0
80000620:	40a704b3          	sub	s1,a4,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	36c000ef          	jal	ra,80000998 <__umodsi3>
80000630:	00050913          	mv	s2,a0
80000634:	000b0593          	mv	a1,s6
80000638:	00048513          	mv	a0,s1
8000063c:	314000ef          	jal	ra,80000950 <__udivsi3>
80000640:	00050493          	mv	s1,a0
80000644:	00050593          	mv	a1,a0
80000648:	000b8513          	mv	a0,s7
8000064c:	248000ef          	jal	ra,80000894 <__mulsi3>
80000650:	010a9693          	slli	a3,s5,0x10
80000654:	01091913          	slli	s2,s2,0x10
80000658:	0106d693          	srli	a3,a3,0x10
8000065c:	00d967b3          	or	a5,s2,a3
80000660:	00048713          	mv	a4,s1
80000664:	00a7fe63          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000668:	008787b3          	add	a5,a5,s0
8000066c:	fff48713          	addi	a4,s1,-1
80000670:	0087e863          	bltu	a5,s0,80000680 <__udivdi3+0x3c0>
80000674:	00a7f663          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000678:	ffe48713          	addi	a4,s1,-2
8000067c:	008787b3          	add	a5,a5,s0
80000680:	010a1a13          	slli	s4,s4,0x10
80000684:	40a784b3          	sub	s1,a5,a0
80000688:	00ea6a33          	or	s4,s4,a4
8000068c:	e01ff06f          	j	8000048c <__udivdi3+0x1cc>
80000690:	1ed5ec63          	bltu	a1,a3,80000888 <__udivdi3+0x5c8>
80000694:	000107b7          	lui	a5,0x10
80000698:	04f6f463          	bgeu	a3,a5,800006e0 <__udivdi3+0x420>
8000069c:	0ff00593          	li	a1,255
800006a0:	00d5b533          	sltu	a0,a1,a3
800006a4:	00351513          	slli	a0,a0,0x3
800006a8:	00a6d733          	srl	a4,a3,a0
800006ac:	00005797          	auipc	a5,0x5
800006b0:	e3878793          	addi	a5,a5,-456 # 800054e4 <__devconfig_end>
800006b4:	00e787b3          	add	a5,a5,a4
800006b8:	0007c583          	lbu	a1,0(a5)
800006bc:	02000a13          	li	s4,32
800006c0:	00a585b3          	add	a1,a1,a0
800006c4:	40ba0a33          	sub	s4,s4,a1
800006c8:	020a1663          	bnez	s4,800006f4 <__udivdi3+0x434>
800006cc:	00100793          	li	a5,1
800006d0:	e896e2e3          	bltu	a3,s1,80000554 <__udivdi3+0x294>
800006d4:	00cb3633          	sltu	a2,s6,a2
800006d8:	00164793          	xori	a5,a2,1
800006dc:	e79ff06f          	j	80000554 <__udivdi3+0x294>
800006e0:	010007b7          	lui	a5,0x1000
800006e4:	01000513          	li	a0,16
800006e8:	fcf6e0e3          	bltu	a3,a5,800006a8 <__udivdi3+0x3e8>
800006ec:	01800513          	li	a0,24
800006f0:	fb9ff06f          	j	800006a8 <__udivdi3+0x3e8>
800006f4:	00b65ab3          	srl	s5,a2,a1
800006f8:	014696b3          	sll	a3,a3,s4
800006fc:	00daeab3          	or	s5,s5,a3
80000700:	00b4d933          	srl	s2,s1,a1
80000704:	014497b3          	sll	a5,s1,s4
80000708:	00bb55b3          	srl	a1,s6,a1
8000070c:	010adb93          	srli	s7,s5,0x10
80000710:	00f5e4b3          	or	s1,a1,a5
80000714:	00090513          	mv	a0,s2
80000718:	000b8593          	mv	a1,s7
8000071c:	014619b3          	sll	s3,a2,s4
80000720:	278000ef          	jal	ra,80000998 <__umodsi3>
80000724:	00050413          	mv	s0,a0
80000728:	000b8593          	mv	a1,s7
8000072c:	00090513          	mv	a0,s2
80000730:	010a9c13          	slli	s8,s5,0x10
80000734:	21c000ef          	jal	ra,80000950 <__udivsi3>
80000738:	010c5c13          	srli	s8,s8,0x10
8000073c:	00050913          	mv	s2,a0
80000740:	00050593          	mv	a1,a0
80000744:	000c0513          	mv	a0,s8
80000748:	14c000ef          	jal	ra,80000894 <__mulsi3>
8000074c:	01041413          	slli	s0,s0,0x10
80000750:	0104d713          	srli	a4,s1,0x10
80000754:	00e46733          	or	a4,s0,a4
80000758:	00090c93          	mv	s9,s2
8000075c:	00a77e63          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000760:	01570733          	add	a4,a4,s5
80000764:	fff90c93          	addi	s9,s2,-1
80000768:	01576863          	bltu	a4,s5,80000778 <__udivdi3+0x4b8>
8000076c:	00a77663          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000770:	ffe90c93          	addi	s9,s2,-2
80000774:	01570733          	add	a4,a4,s5
80000778:	40a70933          	sub	s2,a4,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	214000ef          	jal	ra,80000998 <__umodsi3>
80000788:	00050413          	mv	s0,a0
8000078c:	000b8593          	mv	a1,s7
80000790:	00090513          	mv	a0,s2
80000794:	1bc000ef          	jal	ra,80000950 <__udivsi3>
80000798:	00050913          	mv	s2,a0
8000079c:	00050593          	mv	a1,a0
800007a0:	000c0513          	mv	a0,s8
800007a4:	0f0000ef          	jal	ra,80000894 <__mulsi3>
800007a8:	01049793          	slli	a5,s1,0x10
800007ac:	01041413          	slli	s0,s0,0x10
800007b0:	0107d793          	srli	a5,a5,0x10
800007b4:	00f46733          	or	a4,s0,a5
800007b8:	00090613          	mv	a2,s2
800007bc:	00a77e63          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007c0:	01570733          	add	a4,a4,s5
800007c4:	fff90613          	addi	a2,s2,-1
800007c8:	01576863          	bltu	a4,s5,800007d8 <__udivdi3+0x518>
800007cc:	00a77663          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007d0:	ffe90613          	addi	a2,s2,-2
800007d4:	01570733          	add	a4,a4,s5
800007d8:	010c9793          	slli	a5,s9,0x10
800007dc:	00010e37          	lui	t3,0x10
800007e0:	00c7e7b3          	or	a5,a5,a2
800007e4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007e8:	0107f333          	and	t1,a5,a6
800007ec:	0109f833          	and	a6,s3,a6
800007f0:	40a70733          	sub	a4,a4,a0
800007f4:	0107de93          	srli	t4,a5,0x10
800007f8:	0109d993          	srli	s3,s3,0x10
800007fc:	00030513          	mv	a0,t1
80000800:	00080593          	mv	a1,a6
80000804:	090000ef          	jal	ra,80000894 <__mulsi3>
80000808:	00050893          	mv	a7,a0
8000080c:	00098593          	mv	a1,s3
80000810:	00030513          	mv	a0,t1
80000814:	080000ef          	jal	ra,80000894 <__mulsi3>
80000818:	00050313          	mv	t1,a0
8000081c:	00080593          	mv	a1,a6
80000820:	000e8513          	mv	a0,t4
80000824:	070000ef          	jal	ra,80000894 <__mulsi3>
80000828:	00050813          	mv	a6,a0
8000082c:	00098593          	mv	a1,s3
80000830:	000e8513          	mv	a0,t4
80000834:	060000ef          	jal	ra,80000894 <__mulsi3>
80000838:	0108d693          	srli	a3,a7,0x10
8000083c:	01030333          	add	t1,t1,a6
80000840:	006686b3          	add	a3,a3,t1
80000844:	0106f463          	bgeu	a3,a6,8000084c <__udivdi3+0x58c>
80000848:	01c50533          	add	a0,a0,t3
8000084c:	0106d613          	srli	a2,a3,0x10
80000850:	00a60533          	add	a0,a2,a0
80000854:	02a76663          	bltu	a4,a0,80000880 <__udivdi3+0x5c0>
80000858:	bca714e3          	bne	a4,a0,80000420 <__udivdi3+0x160>
8000085c:	00010737          	lui	a4,0x10
80000860:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000864:	00e6f6b3          	and	a3,a3,a4
80000868:	01069693          	slli	a3,a3,0x10
8000086c:	00e8f8b3          	and	a7,a7,a4
80000870:	014b1633          	sll	a2,s6,s4
80000874:	011686b3          	add	a3,a3,a7
80000878:	00000a13          	li	s4,0
8000087c:	ccd67ce3          	bgeu	a2,a3,80000554 <__udivdi3+0x294>
80000880:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000884:	b9dff06f          	j	80000420 <__udivdi3+0x160>
80000888:	00000a13          	li	s4,0
8000088c:	00000793          	li	a5,0
80000890:	cc5ff06f          	j	80000554 <__udivdi3+0x294>

80000894 <__mulsi3>:
80000894:	00050613          	mv	a2,a0
80000898:	00000513          	li	a0,0
8000089c:	0015f693          	andi	a3,a1,1
800008a0:	00068463          	beqz	a3,800008a8 <__mulsi3+0x14>
800008a4:	00c50533          	add	a0,a0,a2
800008a8:	0015d593          	srli	a1,a1,0x1
800008ac:	00161613          	slli	a2,a2,0x1
800008b0:	fe0596e3          	bnez	a1,8000089c <__mulsi3+0x8>
800008b4:	00008067          	ret

800008b8 <__muldi3>:
800008b8:	ff010113          	addi	sp,sp,-16
800008bc:	00068313          	mv	t1,a3
800008c0:	00112623          	sw	ra,12(sp)
800008c4:	00050e13          	mv	t3,a0
800008c8:	00050893          	mv	a7,a0
800008cc:	00060693          	mv	a3,a2
800008d0:	00000713          	li	a4,0
800008d4:	00000793          	li	a5,0
800008d8:	00000813          	li	a6,0
800008dc:	0016f513          	andi	a0,a3,1
800008e0:	00171e93          	slli	t4,a4,0x1
800008e4:	00050c63          	beqz	a0,800008fc <__muldi3+0x44>
800008e8:	01088533          	add	a0,a7,a6
800008ec:	01053833          	sltu	a6,a0,a6
800008f0:	00e787b3          	add	a5,a5,a4
800008f4:	00f807b3          	add	a5,a6,a5
800008f8:	00050813          	mv	a6,a0
800008fc:	01f8d713          	srli	a4,a7,0x1f
80000900:	0016d693          	srli	a3,a3,0x1
80000904:	00eee733          	or	a4,t4,a4
80000908:	00189893          	slli	a7,a7,0x1
8000090c:	fc0698e3          	bnez	a3,800008dc <__muldi3+0x24>
80000910:	00058863          	beqz	a1,80000920 <__muldi3+0x68>
80000914:	00060513          	mv	a0,a2
80000918:	f7dff0ef          	jal	ra,80000894 <__mulsi3>
8000091c:	00a787b3          	add	a5,a5,a0
80000920:	00030a63          	beqz	t1,80000934 <__muldi3+0x7c>
80000924:	000e0513          	mv	a0,t3
80000928:	00030593          	mv	a1,t1
8000092c:	f69ff0ef          	jal	ra,80000894 <__mulsi3>
80000930:	00f507b3          	add	a5,a0,a5
80000934:	00c12083          	lw	ra,12(sp)
80000938:	00080513          	mv	a0,a6
8000093c:	00078593          	mv	a1,a5
80000940:	01010113          	addi	sp,sp,16
80000944:	00008067          	ret

80000948 <__divsi3>:
80000948:	06054063          	bltz	a0,800009a8 <__umodsi3+0x10>
8000094c:	0605c663          	bltz	a1,800009b8 <__umodsi3+0x20>

80000950 <__udivsi3>:
80000950:	00058613          	mv	a2,a1
80000954:	00050593          	mv	a1,a0
80000958:	fff00513          	li	a0,-1
8000095c:	02060c63          	beqz	a2,80000994 <__udivsi3+0x44>
80000960:	00100693          	li	a3,1
80000964:	00b67a63          	bgeu	a2,a1,80000978 <__udivsi3+0x28>
80000968:	00c05863          	blez	a2,80000978 <__udivsi3+0x28>
8000096c:	00161613          	slli	a2,a2,0x1
80000970:	00169693          	slli	a3,a3,0x1
80000974:	feb66ae3          	bltu	a2,a1,80000968 <__udivsi3+0x18>
80000978:	00000513          	li	a0,0
8000097c:	00c5e663          	bltu	a1,a2,80000988 <__udivsi3+0x38>
80000980:	40c585b3          	sub	a1,a1,a2
80000984:	00d56533          	or	a0,a0,a3
80000988:	0016d693          	srli	a3,a3,0x1
8000098c:	00165613          	srli	a2,a2,0x1
80000990:	fe0696e3          	bnez	a3,8000097c <__udivsi3+0x2c>
80000994:	00008067          	ret

80000998 <__umodsi3>:
80000998:	00008293          	mv	t0,ra
8000099c:	fb5ff0ef          	jal	ra,80000950 <__udivsi3>
800009a0:	00058513          	mv	a0,a1
800009a4:	00028067          	jr	t0
800009a8:	40a00533          	neg	a0,a0
800009ac:	0005d863          	bgez	a1,800009bc <__umodsi3+0x24>
800009b0:	40b005b3          	neg	a1,a1
800009b4:	f9dff06f          	j	80000950 <__udivsi3>
800009b8:	40b005b3          	neg	a1,a1
800009bc:	00008293          	mv	t0,ra
800009c0:	f91ff0ef          	jal	ra,80000950 <__udivsi3>
800009c4:	40a00533          	neg	a0,a0
800009c8:	00028067          	jr	t0

800009cc <__modsi3>:
800009cc:	00008293          	mv	t0,ra
800009d0:	0005ca63          	bltz	a1,800009e4 <__modsi3+0x18>
800009d4:	00054c63          	bltz	a0,800009ec <__modsi3+0x20>
800009d8:	f79ff0ef          	jal	ra,80000950 <__udivsi3>
800009dc:	00058513          	mv	a0,a1
800009e0:	00028067          	jr	t0
800009e4:	40b005b3          	neg	a1,a1
800009e8:	fe0558e3          	bgez	a0,800009d8 <__modsi3+0xc>
800009ec:	40a00533          	neg	a0,a0
800009f0:	f61ff0ef          	jal	ra,80000950 <__udivsi3>
800009f4:	40b00533          	neg	a0,a1
800009f8:	00028067          	jr	t0

800009fc <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009fc:	00008067          	ret

80000a00 <irq_offload_isr>:

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
80000a00:	6080306f          	j	80004008 <z_impl_k_wakeup>

80000a04 <align_to_tick_boundary>:

	TC_PRINT("Kernel objects initialized\n");
}

static void align_to_tick_boundary(void)
{
80000a04:	ff010113          	addi	sp,sp,-16
80000a08:	00812423          	sw	s0,8(sp)
80000a0c:	00112623          	sw	ra,12(sp)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)

K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000a10:	0c5040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
80000a14:	00050413          	mv	s0,a0
80000a18:	0bd040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
	u32_t tick;

	tick = k_uptime_get_32();
	while (k_uptime_get_32() == tick) {
80000a1c:	fea40ee3          	beq	s0,a0,80000a18 <align_to_tick_boundary+0x14>
#if defined(CONFIG_ARCH_POSIX)
		k_busy_wait(50);
#endif
	}

}
80000a20:	00c12083          	lw	ra,12(sp)
80000a24:	00812403          	lw	s0,8(sp)
80000a28:	01010113          	addi	sp,sp,16
80000a2c:	00008067          	ret

80000a30 <z_zassert.constprop.2>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000a30:	fd010113          	addi	sp,sp,-48
80000a34:	00112e23          	sw	ra,28(sp)
80000a38:	00812c23          	sw	s0,24(sp)
80000a3c:	03012423          	sw	a6,40(sp)
80000a40:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000a44:	04051863          	bnez	a0,80000a94 <z_zassert.constprop.2+0x64>
80000a48:	00068613          	mv	a2,a3
80000a4c:	00058713          	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a50:	800056b7          	lui	a3,0x80005
80000a54:	800065b7          	lui	a1,0x80006
80000a58:	80006537          	lui	a0,0x80006
80000a5c:	5f068693          	addi	a3,a3,1520 # 800055f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055f1>
80000a60:	00078413          	mv	s0,a5
80000a64:	89458593          	addi	a1,a1,-1900 # 80005894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005895>
		va_start(vargs, msg);
80000a68:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a6c:	8b450513          	addi	a0,a0,-1868 # 800058b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058b5>
		va_start(vargs, msg);
80000a70:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a74:	034010ef          	jal	ra,80001aa8 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000a78:	00c12583          	lw	a1,12(sp)
80000a7c:	00040513          	mv	a0,s0
80000a80:	7f9000ef          	jal	ra,80001a78 <vprintk>
		printk("\n");
80000a84:	80005537          	lui	a0,0x80005
80000a88:	6ac50513          	addi	a0,a0,1708 # 800056ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056ad>
80000a8c:	01c010ef          	jal	ra,80001aa8 <printk>
		va_end(vargs);
		ztest_test_fail();
80000a90:	70c010ef          	jal	ra,8000219c <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000a94:	01c12083          	lw	ra,28(sp)
80000a98:	01812403          	lw	s0,24(sp)
80000a9c:	03010113          	addi	sp,sp,48
80000aa0:	00008067          	ret

80000aa4 <helper_thread>:

	k_wakeup((k_tid_t) arg);
}

static void helper_thread(int arg1, int arg2)
{
80000aa4:	ff010113          	addi	sp,sp,-16
80000aa8:	00912223          	sw	s1,4(sp)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000aac:	800064b7          	lui	s1,0x80006
80000ab0:	00812423          	sw	s0,8(sp)
80000ab4:	fff00593          	li	a1,-1
80000ab8:	3bc48513          	addi	a0,s1,956 # 800063bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063bd>

	k_sem_take(&helper_thread_sem, K_FOREVER);
	/* Wake the test thread */
	k_wakeup(test_thread_id);
80000abc:	80006437          	lui	s0,0x80006
{
80000ac0:	00112623          	sw	ra,12(sp)
	k_wakeup(test_thread_id);
80000ac4:	31040413          	addi	s0,s0,784 # 80006310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006311>
80000ac8:	770030ef          	jal	ra,80004238 <z_impl_k_sem_take>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
80000acc:	00042503          	lw	a0,0(s0)
80000ad0:	538030ef          	jal	ra,80004008 <z_impl_k_wakeup>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000ad4:	fff00593          	li	a1,-1
80000ad8:	3bc48513          	addi	a0,s1,956
80000adc:	75c030ef          	jal	ra,80004238 <z_impl_k_sem_take>
	k_sem_take(&helper_thread_sem, K_FOREVER);
	/* Wake the test thread from an ISR */
	irq_offload(irq_offload_isr, (void *)test_thread_id);
80000ae0:	00042583          	lw	a1,0(s0)
}
80000ae4:	00812403          	lw	s0,8(sp)
80000ae8:	00c12083          	lw	ra,12(sp)
80000aec:	00412483          	lw	s1,4(sp)
	irq_offload(irq_offload_isr, (void *)test_thread_id);
80000af0:	80001537          	lui	a0,0x80001
80000af4:	a0050513          	addi	a0,a0,-1536 # 80000a00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a01>
}
80000af8:	01010113          	addi	sp,sp,16
	irq_offload(irq_offload_isr, (void *)test_thread_id);
80000afc:	5f00006f          	j	800010ec <irq_offload>

80000b00 <test_sleep>:
 * @ingroup kernel_sleep_tests
 *
 * @see k_sleep(), k_wakeup(), k_uptime_get_32()
 */
void test_sleep(void)
{
80000b00:	fe010113          	addi	sp,sp,-32
80000b04:	00112e23          	sw	ra,28(sp)
80000b08:	00812c23          	sw	s0,24(sp)
80000b0c:	00912a23          	sw	s1,20(sp)
80000b10:	01212823          	sw	s2,16(sp)
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000b14:	56c030ef          	jal	ra,80004080 <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000b18:	00000593          	li	a1,0
80000b1c:	7e5020ef          	jal	ra,80003b00 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000b20:	80006937          	lui	s2,0x80006
80000b24:	44c90513          	addi	a0,s2,1100 # 8000644c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000644d>
80000b28:	fff00613          	li	a2,-1
80000b2c:	00000593          	li	a1,0
80000b30:	55c030ef          	jal	ra,8000408c <z_impl_k_sem_init>
80000b34:	80006537          	lui	a0,0x80006
80000b38:	fff00613          	li	a2,-1
80000b3c:	00000593          	li	a1,0
80000b40:	3bc50513          	addi	a0,a0,956 # 800063bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063bd>
80000b44:	548030ef          	jal	ra,8000408c <z_impl_k_sem_init>
80000b48:	800064b7          	lui	s1,0x80006
80000b4c:	fff00613          	li	a2,-1
80000b50:	00000593          	li	a1,0
80000b54:	3cc48513          	addi	a0,s1,972 # 800063cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063cd>
80000b58:	534030ef          	jal	ra,8000408c <z_impl_k_sem_init>
	TC_PRINT("Kernel objects initialized\n");
80000b5c:	80005537          	lui	a0,0x80005
80000b60:	61050513          	addi	a0,a0,1552 # 80005610 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005611>
80000b64:	745000ef          	jal	ra,80001aa8 <printk>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000b68:	800016b7          	lui	a3,0x80001
80000b6c:	800065b7          	lui	a1,0x80006
80000b70:	80006537          	lui	a0,0x80006
80000b74:	ffc00893          	li	a7,-4
80000b78:	00000813          	li	a6,0
80000b7c:	00000793          	li	a5,0
80000b80:	00000713          	li	a4,0
80000b84:	cbc68693          	addi	a3,a3,-836 # 80000cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000cbd>
80000b88:	18000613          	li	a2,384
80000b8c:	00012223          	sw	zero,4(sp)
80000b90:	00012023          	sw	zero,0(sp)
80000b94:	5f058593          	addi	a1,a1,1520 # 800065f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f1>
80000b98:	3dc50513          	addi	a0,a0,988 # 800063dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063dd>
	 * threads run at same priority level.
	 */
	k_thread_priority_set(k_current_get(), 0);
	test_objects_init();

	test_thread_id = k_thread_create(&test_thread_data, test_thread_stack,
80000b9c:	80006437          	lui	s0,0x80006
80000ba0:	355030ef          	jal	ra,800046f4 <z_impl_k_thread_create>
80000ba4:	31040413          	addi	s0,s0,784 # 80006310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006311>
80000ba8:	00050593          	mv	a1,a0
80000bac:	00a42023          	sw	a0,0(s0)
					 THREAD_STACK,
					 (k_thread_entry_t) test_thread,
					 0, 0, NULL, TEST_THREAD_PRIORITY,
					 0, 0);

	TC_PRINT("Test thread started: id = %p\n", test_thread_id);
80000bb0:	80005537          	lui	a0,0x80005
80000bb4:	62c50513          	addi	a0,a0,1580 # 8000562c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000562d>
80000bb8:	6f1000ef          	jal	ra,80001aa8 <printk>
80000bbc:	800016b7          	lui	a3,0x80001
80000bc0:	800065b7          	lui	a1,0x80006
80000bc4:	80006537          	lui	a0,0x80006
80000bc8:	ff600893          	li	a7,-10
80000bcc:	00000813          	li	a6,0
80000bd0:	00000793          	li	a5,0
80000bd4:	00000713          	li	a4,0
80000bd8:	aa468693          	addi	a3,a3,-1372 # 80000aa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000aa5>
80000bdc:	18000613          	li	a2,384
80000be0:	00012223          	sw	zero,4(sp)
80000be4:	00012023          	sw	zero,0(sp)
80000be8:	77058593          	addi	a1,a1,1904 # 80006770 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006771>
80000bec:	34c50513          	addi	a0,a0,844 # 8000634c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000634d>
80000bf0:	305030ef          	jal	ra,800046f4 <z_impl_k_thread_create>
					   helper_thread_stack, THREAD_STACK,
					   (k_thread_entry_t) helper_thread,
					   0, 0, NULL, HELPER_THREAD_PRIORITY,
					   0, 0);

	TC_PRINT("Helper thread started: id = %p\n", helper_thread_id);
80000bf4:	00050593          	mv	a1,a0
80000bf8:	80005537          	lui	a0,0x80005
80000bfc:	64c50513          	addi	a0,a0,1612 # 8000564c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000564d>
80000c00:	6a9000ef          	jal	ra,80001aa8 <printk>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000c04:	44c90513          	addi	a0,s2,1100
80000c08:	54c030ef          	jal	ra,80004154 <z_impl_k_sem_give>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000c0c:	fff00593          	li	a1,-1
80000c10:	3cc48513          	addi	a0,s1,972
80000c14:	624030ef          	jal	ra,80004238 <z_impl_k_sem_take>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
80000c18:	00042503          	lw	a0,0(s0)
	k_sem_take(&task_sem, K_FOREVER);

	/* Wake the test thread */
	k_wakeup(test_thread_id);

	zassert_false(test_failure, "test failure");
80000c1c:	80005937          	lui	s2,0x80005
80000c20:	800064b7          	lui	s1,0x80006
80000c24:	3e4030ef          	jal	ra,80004008 <z_impl_k_wakeup>
80000c28:	800067b7          	lui	a5,0x80006
80000c2c:	2b07c503          	lbu	a0,688(a5) # 800062b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b1>
80000c30:	800055b7          	lui	a1,0x80005
80000c34:	800057b7          	lui	a5,0x80005
80000c38:	5f090713          	addi	a4,s2,1520 # 800055f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055f1>
80000c3c:	89448613          	addi	a2,s1,-1900 # 80005894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005895>
80000c40:	66c78793          	addi	a5,a5,1644 # 8000566c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000566d>
80000c44:	0de00693          	li	a3,222
80000c48:	67c58593          	addi	a1,a1,1660 # 8000567c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000567d>
80000c4c:	00154513          	xori	a0,a0,1
80000c50:	de1ff0ef          	jal	ra,80000a30 <z_zassert.constprop.2>

	TC_PRINT("Testing kernel k_sleep()\n");
80000c54:	80005537          	lui	a0,0x80005
80000c58:	69450513          	addi	a0,a0,1684 # 80005694 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005695>
80000c5c:	64d000ef          	jal	ra,80001aa8 <printk>
	align_to_tick_boundary();
80000c60:	da5ff0ef          	jal	ra,80000a04 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000c64:	670040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
80000c68:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000c6c:	3e800513          	li	a0,1000
80000c70:	158030ef          	jal	ra,80003dc8 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000c74:	660040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
	u32_t dt = end - start;
80000c78:	40850833          	sub	a6,a0,s0
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
		     "k_sleep() slept for %d ticks, not %d\n",
		     end_tick - start_tick, ONE_SECOND_ALIGNED);

	status = TC_PASS;
}
80000c7c:	01812403          	lw	s0,24(sp)
80000c80:	01c12083          	lw	ra,28(sp)
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
80000c84:	5f090713          	addi	a4,s2,1520
80000c88:	89448613          	addi	a2,s1,-1900
}
80000c8c:	01012903          	lw	s2,16(sp)
80000c90:	01412483          	lw	s1,20(sp)
	return dt >= dur && dt <= (dur + 1);
80000c94:	c0e80513          	addi	a0,a6,-1010
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
80000c98:	800057b7          	lui	a5,0x80005
80000c9c:	800055b7          	lui	a1,0x80005
80000ca0:	3f200893          	li	a7,1010
80000ca4:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000ca8:	0e700693          	li	a3,231
80000cac:	6d858593          	addi	a1,a1,1752 # 800056d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056d9>
80000cb0:	00253513          	sltiu	a0,a0,2
}
80000cb4:	02010113          	addi	sp,sp,32
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
80000cb8:	d79ff06f          	j	80000a30 <z_zassert.constprop.2>

80000cbc <test_thread>:
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000cbc:	80006537          	lui	a0,0x80006
{
80000cc0:	ff010113          	addi	sp,sp,-16
80000cc4:	fff00593          	li	a1,-1
80000cc8:	44c50513          	addi	a0,a0,1100 # 8000644c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000644d>
80000ccc:	00112623          	sw	ra,12(sp)
80000cd0:	00812423          	sw	s0,8(sp)
80000cd4:	00912223          	sw	s1,4(sp)
80000cd8:	01212023          	sw	s2,0(sp)
80000cdc:	55c030ef          	jal	ra,80004238 <z_impl_k_sem_take>
	TC_PRINT("Testing normal expiration of k_sleep()\n");
80000ce0:	80005537          	lui	a0,0x80005
80000ce4:	72050513          	addi	a0,a0,1824 # 80005720 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005721>
80000ce8:	5c1000ef          	jal	ra,80001aa8 <printk>
	align_to_tick_boundary();
80000cec:	d19ff0ef          	jal	ra,80000a04 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000cf0:	5e4040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
80000cf4:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000cf8:	3e800513          	li	a0,1000
80000cfc:	0cc030ef          	jal	ra,80003dc8 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000d00:	5d4040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
	u32_t dt = end - start;
80000d04:	40850433          	sub	s0,a0,s0
	return dt >= dur && dt <= (dur + 1);
80000d08:	c0e40793          	addi	a5,s0,-1010
80000d0c:	00100493          	li	s1,1
80000d10:	08f4e063          	bltu	s1,a5,80000d90 <test_thread+0xd4>
	TC_PRINT("Testing: test thread sleep + helper thread wakeup test\n");
80000d14:	80005537          	lui	a0,0x80005
80000d18:	74850513          	addi	a0,a0,1864 # 80005748 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005749>
80000d1c:	58d000ef          	jal	ra,80001aa8 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000d20:	80006937          	lui	s2,0x80006
80000d24:	3bc90513          	addi	a0,s2,956 # 800063bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063bd>
80000d28:	42c030ef          	jal	ra,80004154 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000d2c:	cd9ff0ef          	jal	ra,80000a04 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000d30:	5a4040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
80000d34:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000d38:	3e800513          	li	a0,1000
80000d3c:	08c030ef          	jal	ra,80003dc8 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000d40:	594040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000d44:	40850433          	sub	s0,a0,s0
80000d48:	0884f863          	bgeu	s1,s0,80000dd8 <test_thread+0x11c>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000d4c:	07d00693          	li	a3,125
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000d50:	80005637          	lui	a2,0x80005
80000d54:	800055b7          	lui	a1,0x80005
80000d58:	80005537          	lui	a0,0x80005
80000d5c:	78058593          	addi	a1,a1,1920 # 80005780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005781>
80000d60:	78850513          	addi	a0,a0,1928 # 80005788 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005789>
80000d64:	5e460613          	addi	a2,a2,1508 # 800055e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055e5>
80000d68:	541000ef          	jal	ra,80001aa8 <printk>
80000d6c:	80005537          	lui	a0,0x80005
80000d70:	00040593          	mv	a1,s0
80000d74:	7c450513          	addi	a0,a0,1988 # 800057c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c5>
}
80000d78:	00812403          	lw	s0,8(sp)
80000d7c:	00c12083          	lw	ra,12(sp)
80000d80:	00412483          	lw	s1,4(sp)
80000d84:	00012903          	lw	s2,0(sp)
80000d88:	01010113          	addi	sp,sp,16
		TC_ERROR(" *** k_wakeup() took too long (%d ticks) at LAST\n",
80000d8c:	51d0006f          	j	80001aa8 <printk>
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000d90:	80005637          	lui	a2,0x80005
80000d94:	800055b7          	lui	a1,0x80005
80000d98:	80005537          	lui	a0,0x80005
80000d9c:	5e460613          	addi	a2,a2,1508 # 800055e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055e5>
80000da0:	78058593          	addi	a1,a1,1920 # 80005780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005781>
80000da4:	78850513          	addi	a0,a0,1928 # 80005788 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005789>
80000da8:	06e00693          	li	a3,110
80000dac:	4fd000ef          	jal	ra,80001aa8 <printk>
80000db0:	00040593          	mv	a1,s0
}
80000db4:	00812403          	lw	s0,8(sp)
80000db8:	00c12083          	lw	ra,12(sp)
80000dbc:	00412483          	lw	s1,4(sp)
80000dc0:	00012903          	lw	s2,0(sp)
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000dc4:	80005537          	lui	a0,0x80005
80000dc8:	3f200613          	li	a2,1010
80000dcc:	79850513          	addi	a0,a0,1944 # 80005798 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005799>
}
80000dd0:	01010113          	addi	sp,sp,16
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000dd4:	4d50006f          	j	80001aa8 <printk>
	TC_PRINT("Testing: test thread sleep + isr offload wakeup test\n");
80000dd8:	80005537          	lui	a0,0x80005
80000ddc:	7f050513          	addi	a0,a0,2032 # 800057f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057f1>
80000de0:	4c9000ef          	jal	ra,80001aa8 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000de4:	3bc90513          	addi	a0,s2,956
80000de8:	36c030ef          	jal	ra,80004154 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000dec:	c19ff0ef          	jal	ra,80000a04 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000df0:	4e4040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
80000df4:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000df8:	3e800513          	li	a0,1000
80000dfc:	7cd020ef          	jal	ra,80003dc8 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000e00:	4d4040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000e04:	40850433          	sub	s0,a0,s0
80000e08:	0084f663          	bgeu	s1,s0,80000e14 <test_thread+0x158>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000e0c:	08b00693          	li	a3,139
80000e10:	f41ff06f          	j	80000d50 <test_thread+0x94>
	TC_PRINT("Testing: test thread sleep + main wakeup test thread\n");
80000e14:	80006537          	lui	a0,0x80006
80000e18:	82850513          	addi	a0,a0,-2008 # 80005828 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005829>
80000e1c:	48d000ef          	jal	ra,80001aa8 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000e20:	80006537          	lui	a0,0x80006
80000e24:	3cc50513          	addi	a0,a0,972 # 800063cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063cd>
80000e28:	32c030ef          	jal	ra,80004154 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000e2c:	bd9ff0ef          	jal	ra,80000a04 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000e30:	4a4040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
80000e34:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000e38:	3e800513          	li	a0,1000
80000e3c:	78d020ef          	jal	ra,80003dc8 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000e40:	494040ef          	jal	ra,800052d4 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000e44:	40850433          	sub	s0,a0,s0
80000e48:	0284fa63          	bgeu	s1,s0,80000e7c <test_thread+0x1c0>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks) at LAST\n",
80000e4c:	80005637          	lui	a2,0x80005
80000e50:	800055b7          	lui	a1,0x80005
80000e54:	80005537          	lui	a0,0x80005
80000e58:	78058593          	addi	a1,a1,1920 # 80005780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005781>
80000e5c:	78850513          	addi	a0,a0,1928 # 80005788 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005789>
80000e60:	09900693          	li	a3,153
80000e64:	5e460613          	addi	a2,a2,1508 # 800055e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055e5>
80000e68:	441000ef          	jal	ra,80001aa8 <printk>
80000e6c:	80006537          	lui	a0,0x80006
80000e70:	00040593          	mv	a1,s0
80000e74:	86050513          	addi	a0,a0,-1952 # 80005860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005861>
80000e78:	f01ff06f          	j	80000d78 <test_thread+0xbc>
}
80000e7c:	00c12083          	lw	ra,12(sp)
80000e80:	00812403          	lw	s0,8(sp)
	test_failure = false;
80000e84:	800067b7          	lui	a5,0x80006
80000e88:	2a078823          	sb	zero,688(a5) # 800062b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b1>
}
80000e8c:	00412483          	lw	s1,4(sp)
80000e90:	00012903          	lw	s2,0(sp)
80000e94:	01010113          	addi	sp,sp,16
80000e98:	00008067          	ret

80000e9c <test_main>:
/*test case main entry*/
void test_main(void)
{
	ztest_test_suite(sleep,
			 ztest_unit_test(test_sleep));
	ztest_run_test_suite(sleep);
80000e9c:	800065b7          	lui	a1,0x80006
80000ea0:	80005537          	lui	a0,0x80005
80000ea4:	27458593          	addi	a1,a1,628 # 80006274 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006275>
80000ea8:	60850513          	addi	a0,a0,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000eac:	3200106f          	j	800021cc <z_ztest_run_test_suite>

80000eb0 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000eb0:	ff010113          	addi	sp,sp,-16
80000eb4:	00112623          	sw	ra,12(sp)
80000eb8:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000ebc:	00600793          	li	a5,6
80000ec0:	02f50463          	beq	a0,a5,80000ee8 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000ec4:	55c030ef          	jal	ra,80004420 <k_is_in_isr>
80000ec8:	02050463          	beqz	a0,80000ef0 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000ecc:	554030ef          	jal	ra,80004420 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000ed0:	04051663          	bnez	a0,80000f1c <z_SysFatalErrorHandler+0x6c>
80000ed4:	800065b7          	lui	a1,0x80006
80000ed8:	b8c58593          	addi	a1,a1,-1140 # 80005b8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b8d>
80000edc:	80006537          	lui	a0,0x80006
80000ee0:	ba050513          	addi	a0,a0,-1120 # 80005ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ba1>
80000ee4:	3c5000ef          	jal	ra,80001aa8 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000ee8:	431000ef          	jal	ra,80001b18 <k_cpu_idle>
80000eec:	ffdff06f          	j	80000ee8 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000ef0:	540030ef          	jal	ra,80004430 <z_is_thread_essential>
80000ef4:	fc051ce3          	bnez	a0,80000ecc <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000ef8:	80006437          	lui	s0,0x80006
80000efc:	5bc40413          	addi	s0,s0,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80000f00:	00842583          	lw	a1,8(s0)
80000f04:	80006537          	lui	a0,0x80006
80000f08:	bc050513          	addi	a0,a0,-1088 # 80005bc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bc1>
80000f0c:	39d000ef          	jal	ra,80001aa8 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000f10:	00842503          	lw	a0,8(s0)
80000f14:	185030ef          	jal	ra,80004898 <z_impl_k_thread_abort>
80000f18:	fd1ff06f          	j	80000ee8 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000f1c:	800065b7          	lui	a1,0x80006
80000f20:	b8858593          	addi	a1,a1,-1144 # 80005b88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b89>
80000f24:	fb9ff06f          	j	80000edc <z_SysFatalErrorHandler+0x2c>

80000f28 <z_NanoFatalErrorHandler>:
{
80000f28:	fb010113          	addi	sp,sp,-80
80000f2c:	04812423          	sw	s0,72(sp)
80000f30:	04912223          	sw	s1,68(sp)
80000f34:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000f38:	00600793          	li	a5,6
{
80000f3c:	00050493          	mv	s1,a0
80000f40:	00058413          	mv	s0,a1
	switch (reason) {
80000f44:	0ea7e063          	bltu	a5,a0,80001024 <z_NanoFatalErrorHandler+0xfc>
80000f48:	80006737          	lui	a4,0x80006
80000f4c:	00251793          	slli	a5,a0,0x2
80000f50:	8dc70713          	addi	a4,a4,-1828 # 800058dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058dd>
80000f54:	00e787b3          	add	a5,a5,a4
80000f58:	0007a783          	lw	a5,0(a5)
80000f5c:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000f60:	80006537          	lui	a0,0x80006
80000f64:	a0c50513          	addi	a0,a0,-1524 # 80005a0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a0d>
		printk("***** Kernel OOPS! *****\n");
80000f68:	341000ef          	jal	ra,80001aa8 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000f6c:	114030ef          	jal	ra,80004080 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000f70:	04442783          	lw	a5,68(s0)
80000f74:	01042883          	lw	a7,16(s0)
80000f78:	00c42803          	lw	a6,12(s0)
80000f7c:	02f12823          	sw	a5,48(sp)
80000f80:	04042783          	lw	a5,64(s0)
80000f84:	00442703          	lw	a4,4(s0)
80000f88:	00042683          	lw	a3,0(s0)
80000f8c:	02f12623          	sw	a5,44(sp)
80000f90:	03c42783          	lw	a5,60(s0)
80000f94:	04842603          	lw	a2,72(s0)
80000f98:	00050593          	mv	a1,a0
80000f9c:	02f12423          	sw	a5,40(sp)
80000fa0:	03842783          	lw	a5,56(s0)
80000fa4:	80006537          	lui	a0,0x80006
80000fa8:	a9050513          	addi	a0,a0,-1392 # 80005a90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a91>
80000fac:	02f12223          	sw	a5,36(sp)
80000fb0:	03442783          	lw	a5,52(s0)
80000fb4:	02f12023          	sw	a5,32(sp)
80000fb8:	03042783          	lw	a5,48(s0)
80000fbc:	00f12e23          	sw	a5,28(sp)
80000fc0:	02c42783          	lw	a5,44(s0)
80000fc4:	00f12c23          	sw	a5,24(sp)
80000fc8:	02842783          	lw	a5,40(s0)
80000fcc:	00f12a23          	sw	a5,20(sp)
80000fd0:	02442783          	lw	a5,36(s0)
80000fd4:	00f12823          	sw	a5,16(sp)
80000fd8:	02042783          	lw	a5,32(s0)
80000fdc:	00f12623          	sw	a5,12(sp)
80000fe0:	01c42783          	lw	a5,28(s0)
80000fe4:	00f12423          	sw	a5,8(sp)
80000fe8:	01842783          	lw	a5,24(s0)
80000fec:	00f12223          	sw	a5,4(sp)
80000ff0:	01442783          	lw	a5,20(s0)
80000ff4:	00f12023          	sw	a5,0(sp)
80000ff8:	00842783          	lw	a5,8(s0)
80000ffc:	2ad000ef          	jal	ra,80001aa8 <printk>
	z_SysFatalErrorHandler(reason, esf);
80001000:	00040593          	mv	a1,s0
80001004:	00048513          	mv	a0,s1
80001008:	ea9ff0ef          	jal	ra,80000eb0 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
8000100c:	80006537          	lui	a0,0x80006
80001010:	a3450513          	addi	a0,a0,-1484 # 80005a34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a35>
80001014:	f55ff06f          	j	80000f68 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80001018:	80006537          	lui	a0,0x80006
8000101c:	a5050513          	addi	a0,a0,-1456 # 80005a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a51>
80001020:	f49ff06f          	j	80000f68 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80001024:	80006537          	lui	a0,0x80006
80001028:	00048593          	mv	a1,s1
8000102c:	a6c50513          	addi	a0,a0,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
80001030:	279000ef          	jal	ra,80001aa8 <printk>
		break;
80001034:	f39ff06f          	j	80000f6c <z_NanoFatalErrorHandler+0x44>

80001038 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80001038:	ff010113          	addi	sp,sp,-16
8000103c:	00812423          	sw	s0,8(sp)
80001040:	00112623          	sw	ra,12(sp)
80001044:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001048:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
8000104c:	00161613          	slli	a2,a2,0x1
80001050:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80001054:	00500793          	li	a5,5
80001058:	02c7e863          	bltu	a5,a2,80001088 <_Fault+0x50>
8000105c:	80006737          	lui	a4,0x80006
80001060:	00261793          	slli	a5,a2,0x2
80001064:	8f870713          	addi	a4,a4,-1800 # 800058f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f9>
80001068:	00f707b3          	add	a5,a4,a5
8000106c:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001070:	80006537          	lui	a0,0x80006
80001074:	91850513          	addi	a0,a0,-1768 # 80005918 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005919>
80001078:	231000ef          	jal	ra,80001aa8 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
8000107c:	00040593          	mv	a1,s0
80001080:	00000513          	li	a0,0
80001084:	ea5ff0ef          	jal	ra,80000f28 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001088:	800065b7          	lui	a1,0x80006
8000108c:	91058593          	addi	a1,a1,-1776 # 80005910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005911>
80001090:	fe1ff06f          	j	80001070 <_Fault+0x38>

80001094 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80001094:	ff010113          	addi	sp,sp,-16
80001098:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
8000109c:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
800010a0:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
800010a4:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
800010a8:	0015d593          	srli	a1,a1,0x1
800010ac:	be850513          	addi	a0,a0,-1048 # 80005be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005be9>
800010b0:	1f9000ef          	jal	ra,80001aa8 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
800010b4:	800065b7          	lui	a1,0x80006
800010b8:	93458593          	addi	a1,a1,-1740 # 80005934 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005935>
800010bc:	00400513          	li	a0,4
800010c0:	e69ff0ef          	jal	ra,80000f28 <z_NanoFatalErrorHandler>

800010c4 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
800010c4:	800067b7          	lui	a5,0x80006
800010c8:	31478793          	addi	a5,a5,788 # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
800010cc:	0007a703          	lw	a4,0(a5)
800010d0:	00070c63          	beqz	a4,800010e8 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
800010d4:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
800010d8:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
800010dc:	800067b7          	lui	a5,0x80006
800010e0:	3187a503          	lw	a0,792(a5) # 80006318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006319>
800010e4:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
800010e8:	00008067          	ret

800010ec <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
800010ec:	00800793          	li	a5,8
800010f0:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
800010f4:	80006737          	lui	a4,0x80006
800010f8:	30a72a23          	sw	a0,788(a4) # 80006314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006315>
	offload_param = parameter;
800010fc:	80006737          	lui	a4,0x80006
80001100:	30b72c23          	sw	a1,792(a4) # 80006318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006319>

	__asm__ volatile ("ecall");
80001104:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80001108:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
8000110c:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80001110:	00008067          	ret

80001114 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80001114:	ff010113          	addi	sp,sp,-16
80001118:	00112623          	sw	ra,12(sp)
	z_bss_zero();
8000111c:	464010ef          	jal	ra,80002580 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001120:	219000ef          	jal	ra,80001b38 <soc_interrupt_init>
#endif
	z_cstart();
80001124:	4c8010ef          	jal	ra,800025ec <z_cstart>

80001128 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80001128:	00006117          	auipc	sp,0x6
8000112c:	fc810113          	addi	sp,sp,-56 # 800070f0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80001130:	000012b7          	lui	t0,0x1
80001134:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80001138:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
8000113c:	fd9ff0ef          	jal	ra,80001114 <_PrepC>

80001140 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80001140:	2fc0006f          	j	8000143c <z_thread_entry>

80001144 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001144:	fd010113          	addi	sp,sp,-48
80001148:	02812423          	sw	s0,40(sp)
8000114c:	02912223          	sw	s1,36(sp)
80001150:	03212023          	sw	s2,32(sp)
80001154:	01312e23          	sw	s3,28(sp)
80001158:	01412c23          	sw	s4,24(sp)
8000115c:	01512a23          	sw	s5,20(sp)
80001160:	01612823          	sw	s6,16(sp)
80001164:	01712623          	sw	s7,12(sp)
80001168:	00078b13          	mv	s6,a5
8000116c:	02112623          	sw	ra,44(sp)
80001170:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001174:	00f00793          	li	a5,15
{
80001178:	00050493          	mv	s1,a0
8000117c:	00058413          	mv	s0,a1
80001180:	00060993          	mv	s3,a2
80001184:	00068a13          	mv	s4,a3
80001188:	00070b93          	mv	s7,a4
8000118c:	00080a93          	mv	s5,a6
80001190:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001194:	08f89a63          	bne	a7,a5,80001228 <z_new_thread+0xe4>
80001198:	800027b7          	lui	a5,0x80002
8000119c:	54878793          	addi	a5,a5,1352 # 80002548 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002549>
800011a0:	08f69a63          	bne	a3,a5,80001234 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
800011a4:	03012683          	lw	a3,48(sp)
800011a8:	00090593          	mv	a1,s2
800011ac:	00048513          	mv	a0,s1
800011b0:	00400613          	li	a2,4
800011b4:	340030ef          	jal	ra,800044f4 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
800011b8:	fb098593          	addi	a1,s3,-80
800011bc:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800011c0:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
800011c4:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
800011c8:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
800011cc:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800011d0:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
800011d4:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800011d8:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
800011dc:	02c12083          	lw	ra,44(sp)
800011e0:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800011e4:	14078793          	addi	a5,a5,320 # 80001140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001141>
	stack_init->a0 = (u32_t)thread_func;
800011e8:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
800011ec:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
800011f0:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
800011f4:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800011f8:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
800011fc:	02b4a423          	sw	a1,40(s1)
}
80001200:	02012903          	lw	s2,32(sp)
80001204:	02412483          	lw	s1,36(sp)
80001208:	01c12983          	lw	s3,28(sp)
8000120c:	01812a03          	lw	s4,24(sp)
80001210:	01412a83          	lw	s5,20(sp)
80001214:	01012b03          	lw	s6,16(sp)
80001218:	00c12b83          	lw	s7,12(sp)
8000121c:	00812c03          	lw	s8,8(sp)
80001220:	03010113          	addi	sp,sp,48
80001224:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001228:	01088693          	addi	a3,a7,16
8000122c:	01e00793          	li	a5,30
80001230:	f6d7fae3          	bgeu	a5,a3,800011a4 <z_new_thread+0x60>
80001234:	80006c37          	lui	s8,0x80006
80001238:	800065b7          	lui	a1,0x80006
8000123c:	80006537          	lui	a0,0x80006
80001240:	c10c0613          	addi	a2,s8,-1008 # 80005c10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c11>
80001244:	01800693          	li	a3,24
80001248:	c3058593          	addi	a1,a1,-976 # 80005c30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c31>
8000124c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80001250:	059000ef          	jal	ra,80001aa8 <printk>
80001254:	80006537          	lui	a0,0x80006
80001258:	00090593          	mv	a1,s2
8000125c:	ff000693          	li	a3,-16
80001260:	00e00613          	li	a2,14
80001264:	cdc50513          	addi	a0,a0,-804 # 80005cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cdd>
80001268:	041000ef          	jal	ra,80001aa8 <printk>
8000126c:	01800593          	li	a1,24
80001270:	c10c0513          	addi	a0,s8,-1008
80001274:	071000ef          	jal	ra,80001ae4 <assert_post_action>
80001278:	f2dff06f          	j	800011a4 <z_new_thread+0x60>

8000127c <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
8000127c:	00159793          	slli	a5,a1,0x1
80001280:	00b787b3          	add	a5,a5,a1
80001284:	00279713          	slli	a4,a5,0x2
80001288:	00c52783          	lw	a5,12(a0)
8000128c:	00e787b3          	add	a5,a5,a4
80001290:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001294:	00b75463          	bge	a4,a1,8000129c <get_bit_ptr+0x20>
80001298:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
8000129c:	41f65713          	srai	a4,a2,0x1f
800012a0:	01f77713          	andi	a4,a4,31
800012a4:	00c70733          	add	a4,a4,a2
800012a8:	40575713          	srai	a4,a4,0x5
800012ac:	00271713          	slli	a4,a4,0x2
800012b0:	00e787b3          	add	a5,a5,a4
800012b4:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
800012b8:	01f67513          	andi	a0,a2,31
800012bc:	00008067          	ret

800012c0 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800012c0:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800012c4:	00c10693          	addi	a3,sp,12
{
800012c8:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800012cc:	fb1ff0ef          	jal	ra,8000127c <get_bit_ptr>

	*word |= (1<<bit);
800012d0:	00c12703          	lw	a4,12(sp)
800012d4:	00100793          	li	a5,1
800012d8:	00a79533          	sll	a0,a5,a0
800012dc:	00072783          	lw	a5,0(a4)
}
800012e0:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
800012e4:	00a7e7b3          	or	a5,a5,a0
800012e8:	00f72023          	sw	a5,0(a4)
}
800012ec:	02010113          	addi	sp,sp,32
800012f0:	00008067          	ret

800012f4 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
800012f4:	fe010113          	addi	sp,sp,-32
800012f8:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800012fc:	00452483          	lw	s1,4(a0)
{
80001300:	00812c23          	sw	s0,24(sp)
80001304:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001308:	00855503          	lhu	a0,8(a0)
8000130c:	00048593          	mv	a1,s1
{
80001310:	01212823          	sw	s2,16(sp)
80001314:	01312623          	sw	s3,12(sp)
80001318:	01412423          	sw	s4,8(sp)
8000131c:	01512223          	sw	s5,4(sp)
80001320:	01612023          	sw	s6,0(sp)
80001324:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001328:	d6cff0ef          	jal	ra,80000894 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
8000132c:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001330:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80001334:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001338:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
8000133c:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
80001340:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001344:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80001348:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
8000134c:	03594c63          	blt	s2,s5,80001384 <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001350:	00000493          	li	s1,0
80001354:	00845783          	lhu	a5,8(s0)
80001358:	08f4cc63          	blt	s1,a5,800013f0 <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
8000135c:	01c12083          	lw	ra,28(sp)
80001360:	01812403          	lw	s0,24(sp)
80001364:	01412483          	lw	s1,20(sp)
80001368:	01012903          	lw	s2,16(sp)
8000136c:	00c12983          	lw	s3,12(sp)
80001370:	00812a03          	lw	s4,8(sp)
80001374:	00412a83          	lw	s5,4(sp)
80001378:	00012b03          	lw	s6,0(sp)
8000137c:	02010113          	addi	sp,sp,32
80001380:	00008067          	ret
		int nblocks = buflen / sz;
80001384:	00048593          	mv	a1,s1
80001388:	000a0513          	mv	a0,s4
8000138c:	dc4ff0ef          	jal	ra,80000950 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80001390:	00191713          	slli	a4,s2,0x1
80001394:	01270733          	add	a4,a4,s2
80001398:	00271793          	slli	a5,a4,0x2
8000139c:	00c42703          	lw	a4,12(s0)
800013a0:	00f70733          	add	a4,a4,a5
800013a4:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
800013a8:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
800013ac:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
800013b0:	00ab4e63          	blt	s6,a0,800013cc <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
800013b4:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800013b8:	0024d493          	srli	s1,s1,0x2
800013bc:	00348493          	addi	s1,s1,3
800013c0:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800013c4:	00190913          	addi	s2,s2,1
800013c8:	f85ff06f          	j	8000134c <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
800013cc:	01f50513          	addi	a0,a0,31
800013d0:	41f55793          	srai	a5,a0,0x1f
800013d4:	01f7f793          	andi	a5,a5,31
800013d8:	00a787b3          	add	a5,a5,a0
800013dc:	4057d793          	srai	a5,a5,0x5
800013e0:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
800013e4:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
800013e8:	00f989b3          	add	s3,s3,a5
800013ec:	fcdff06f          	j	800013b8 <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
800013f0:	00442583          	lw	a1,4(s0)
800013f4:	00048513          	mv	a0,s1
800013f8:	c9cff0ef          	jal	ra,80000894 <__mulsi3>
800013fc:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001400:	00048613          	mv	a2,s1
80001404:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001408:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
8000140c:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001410:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001414:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001418:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
8000141c:	0087a703          	lw	a4,8(a5)
80001420:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
80001424:	0087a703          	lw	a4,8(a5)
80001428:	00a72023          	sw	a0,0(a4)
	list->tail = node;
8000142c:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001430:	00040513          	mv	a0,s0
80001434:	e8dff0ef          	jal	ra,800012c0 <set_free_bit>
80001438:	f1dff06f          	j	80001354 <z_sys_mem_pool_base_init+0x60>

8000143c <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
8000143c:	ff010113          	addi	sp,sp,-16
80001440:	00050793          	mv	a5,a0
80001444:	00058513          	mv	a0,a1
80001448:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
8000144c:	00068613          	mv	a2,a3
{
80001450:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001454:	000780e7          	jalr	a5
80001458:	429020ef          	jal	ra,80004080 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000145c:	43c030ef          	jal	ra,80004898 <z_impl_k_thread_abort>

80001460 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001460:	00000513          	li	a0,0
80001464:	00008067          	ret

80001468 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001468:	ff010113          	addi	sp,sp,-16
8000146c:	00812423          	sw	s0,8(sp)
80001470:	00050413          	mv	s0,a0
	out('E', ctx);
80001474:	04500513          	li	a0,69
{
80001478:	00112623          	sw	ra,12(sp)
8000147c:	00912223          	sw	s1,4(sp)
80001480:	00058493          	mv	s1,a1
	out('E', ctx);
80001484:	000400e7          	jalr	s0
	out('R', ctx);
80001488:	00048593          	mv	a1,s1
8000148c:	05200513          	li	a0,82
80001490:	000400e7          	jalr	s0
	out('R', ctx);
80001494:	00040313          	mv	t1,s0
}
80001498:	00812403          	lw	s0,8(sp)
8000149c:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
800014a0:	00048593          	mv	a1,s1
}
800014a4:	00412483          	lw	s1,4(sp)
	out('R', ctx);
800014a8:	05200513          	li	a0,82
}
800014ac:	01010113          	addi	sp,sp,16
	out('R', ctx);
800014b0:	00030067          	jr	t1

800014b4 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800014b4:	0005a783          	lw	a5,0(a1)
800014b8:	00178793          	addi	a5,a5,1
800014bc:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
800014c0:	800067b7          	lui	a5,0x80006
800014c4:	29c7a303          	lw	t1,668(a5) # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
800014c8:	00030067          	jr	t1

800014cc <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
800014cc:	fc010113          	addi	sp,sp,-64
800014d0:	02812c23          	sw	s0,56(sp)
800014d4:	03312623          	sw	s3,44(sp)
800014d8:	03412423          	sw	s4,40(sp)
800014dc:	03612023          	sw	s6,32(sp)
800014e0:	01a12823          	sw	s10,16(sp)
800014e4:	02112e23          	sw	ra,60(sp)
800014e8:	02912a23          	sw	s1,52(sp)
800014ec:	03212823          	sw	s2,48(sp)
800014f0:	03512223          	sw	s5,36(sp)
800014f4:	01712e23          	sw	s7,28(sp)
800014f8:	01812c23          	sw	s8,24(sp)
800014fc:	01912a23          	sw	s9,20(sp)
80001500:	01b12623          	sw	s11,12(sp)
80001504:	00050993          	mv	s3,a0
80001508:	00058a13          	mv	s4,a1
8000150c:	00060d13          	mv	s10,a2
80001510:	00068b13          	mv	s6,a3
80001514:	00100413          	li	s0,1
80001518:	00e05463          	blez	a4,80001520 <_printk_dec_ulong+0x54>
8000151c:	00070413          	mv	s0,a4
80001520:	00100793          	li	a5,1
80001524:	02000c93          	li	s9,32
80001528:	00fb1463          	bne	s6,a5,80001530 <_printk_dec_ulong+0x64>
8000152c:	03000c93          	li	s9,48
80001530:	3b9ad4b7          	lui	s1,0x3b9ad
80001534:	00100913          	li	s2,1
80001538:	00a00a93          	li	s5,10
8000153c:	00000c13          	li	s8,0
80001540:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001544:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001548:	00148b93          	addi	s7,s1,1
8000154c:	000c1463          	bnez	s8,80001554 <_printk_dec_ulong+0x88>
80001550:	0ba4f263          	bgeu	s1,s10,800015f4 <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001554:	000b8593          	mv	a1,s7
80001558:	000d0513          	mv	a0,s10
8000155c:	bf4ff0ef          	jal	ra,80000950 <__udivsi3>
80001560:	000a0593          	mv	a1,s4
80001564:	03050513          	addi	a0,a0,48
80001568:	000980e7          	jalr	s3
			digits++;
8000156c:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
80001570:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001574:	000b8593          	mv	a1,s7
80001578:	000d0513          	mv	a0,s10
8000157c:	c1cff0ef          	jal	ra,80000998 <__umodsi3>
80001580:	00050d13          	mv	s10,a0
		pos /= 10;
80001584:	00a00593          	li	a1,10
80001588:	00048513          	mv	a0,s1
8000158c:	bc4ff0ef          	jal	ra,80000950 <__udivsi3>
		remaining--;
80001590:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
80001594:	00100793          	li	a5,1
		pos /= 10;
80001598:	00050493          	mv	s1,a0
	while (pos >= 9) {
8000159c:	fafa96e3          	bne	s5,a5,80001548 <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
800015a0:	000a0593          	mv	a1,s4
800015a4:	030d0513          	addi	a0,s10,48
800015a8:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
800015ac:	00300793          	li	a5,3
		remaining = min_width - digits;
800015b0:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
800015b4:	06fb0663          	beq	s6,a5,80001620 <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
800015b8:	03c12083          	lw	ra,60(sp)
800015bc:	03812403          	lw	s0,56(sp)
800015c0:	03412483          	lw	s1,52(sp)
800015c4:	03012903          	lw	s2,48(sp)
800015c8:	02c12983          	lw	s3,44(sp)
800015cc:	02812a03          	lw	s4,40(sp)
800015d0:	02412a83          	lw	s5,36(sp)
800015d4:	02012b03          	lw	s6,32(sp)
800015d8:	01c12b83          	lw	s7,28(sp)
800015dc:	01812c03          	lw	s8,24(sp)
800015e0:	01412c83          	lw	s9,20(sp)
800015e4:	01012d03          	lw	s10,16(sp)
800015e8:	00c12d83          	lw	s11,12(sp)
800015ec:	04010113          	addi	sp,sp,64
800015f0:	00008067          	ret
		} else if (remaining <= min_width
800015f4:	f95440e3          	blt	s0,s5,80001574 <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
800015f8:	f76deee3          	bltu	s11,s6,80001574 <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
800015fc:	000a0593          	mv	a1,s4
80001600:	000c8513          	mv	a0,s9
80001604:	000980e7          	jalr	s3
			digits++;
80001608:	00190913          	addi	s2,s2,1
8000160c:	f69ff06f          	j	80001574 <_printk_dec_ulong+0xa8>
			out(' ', ctx);
80001610:	000a0593          	mv	a1,s4
80001614:	02000513          	li	a0,32
80001618:	000980e7          	jalr	s3
8000161c:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80001620:	fe8048e3          	bgtz	s0,80001610 <_printk_dec_ulong+0x144>
80001624:	f95ff06f          	j	800015b8 <_printk_dec_ulong+0xec>

80001628 <__printk_hook_install>:
	_char_out = fn;
80001628:	800067b7          	lui	a5,0x80006
8000162c:	28a7ae23          	sw	a0,668(a5) # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
}
80001630:	00008067          	ret

80001634 <z_vprintk>:
{
80001634:	fb010113          	addi	sp,sp,-80
80001638:	04812423          	sw	s0,72(sp)
8000163c:	04912223          	sw	s1,68(sp)
80001640:	05212023          	sw	s2,64(sp)
80001644:	03312e23          	sw	s3,60(sp)
80001648:	03412c23          	sw	s4,56(sp)
8000164c:	03512a23          	sw	s5,52(sp)
80001650:	03912223          	sw	s9,36(sp)
80001654:	03a12023          	sw	s10,32(sp)
80001658:	01b12e23          	sw	s11,28(sp)
8000165c:	04112623          	sw	ra,76(sp)
80001660:	03612823          	sw	s6,48(sp)
80001664:	03712623          	sw	s7,44(sp)
80001668:	03812423          	sw	s8,40(sp)
8000166c:	00050413          	mv	s0,a0
80001670:	00058493          	mv	s1,a1
80001674:	00060a93          	mv	s5,a2
80001678:	00068d13          	mv	s10,a3
	int long_ctr = 0;
8000167c:	00000a13          	li	s4,0
	int min_width = -1;
80001680:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001684:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001688:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
8000168c:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001690:	000ac503          	lbu	a0,0(s5)
80001694:	04051063          	bnez	a0,800016d4 <z_vprintk+0xa0>
}
80001698:	04c12083          	lw	ra,76(sp)
8000169c:	04812403          	lw	s0,72(sp)
800016a0:	04412483          	lw	s1,68(sp)
800016a4:	04012903          	lw	s2,64(sp)
800016a8:	03c12983          	lw	s3,60(sp)
800016ac:	03812a03          	lw	s4,56(sp)
800016b0:	03412a83          	lw	s5,52(sp)
800016b4:	03012b03          	lw	s6,48(sp)
800016b8:	02c12b83          	lw	s7,44(sp)
800016bc:	02812c03          	lw	s8,40(sp)
800016c0:	02412c83          	lw	s9,36(sp)
800016c4:	02012d03          	lw	s10,32(sp)
800016c8:	01c12d83          	lw	s11,28(sp)
800016cc:	05010113          	addi	sp,sp,80
800016d0:	00008067          	ret
		if (!might_format) {
800016d4:	000c9e63          	bnez	s9,800016f0 <z_vprintk+0xbc>
			if (*fmt != '%') {
800016d8:	02500693          	li	a3,37
800016dc:	36d50c63          	beq	a0,a3,80001a54 <z_vprintk+0x420>
				out((int)*fmt, ctx);
800016e0:	00048593          	mv	a1,s1
800016e4:	000400e7          	jalr	s0
		++fmt;
800016e8:	001a8a93          	addi	s5,s5,1
800016ec:	fa5ff06f          	j	80001690 <z_vprintk+0x5c>
			switch (*fmt) {
800016f0:	06400693          	li	a3,100
800016f4:	12d50063          	beq	a0,a3,80001814 <z_vprintk+0x1e0>
800016f8:	06a6e263          	bltu	a3,a0,8000175c <z_vprintk+0x128>
800016fc:	03900693          	li	a3,57
80001700:	02a6ea63          	bltu	a3,a0,80001734 <z_vprintk+0x100>
80001704:	03100693          	li	a3,49
80001708:	0ed57463          	bgeu	a0,a3,800017f0 <z_vprintk+0x1bc>
8000170c:	02d00693          	li	a3,45
80001710:	34d50c63          	beq	a0,a3,80001a68 <z_vprintk+0x434>
80001714:	03000793          	li	a5,48
80001718:	0cf50063          	beq	a0,a5,800017d8 <z_vprintk+0x1a4>
8000171c:	02500713          	li	a4,37
80001720:	02e51263          	bne	a0,a4,80001744 <z_vprintk+0x110>
				out((int)'%', ctx);
80001724:	00048593          	mv	a1,s1
80001728:	02500513          	li	a0,37
				out((int)*fmt, ctx);
8000172c:	000400e7          	jalr	s0
				break;
80001730:	1600006f          	j	80001890 <z_vprintk+0x25c>
80001734:	05800693          	li	a3,88
80001738:	1cd50063          	beq	a0,a3,800018f8 <z_vprintk+0x2c4>
8000173c:	06300713          	li	a4,99
80001740:	30e50063          	beq	a0,a4,80001a40 <z_vprintk+0x40c>
				out((int)'%', ctx);
80001744:	00048593          	mv	a1,s1
80001748:	02500513          	li	a0,37
8000174c:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001750:	00048593          	mv	a1,s1
80001754:	000ac503          	lbu	a0,0(s5)
80001758:	fd5ff06f          	j	8000172c <z_vprintk+0xf8>
8000175c:	07000693          	li	a3,112
80001760:	16d50c63          	beq	a0,a3,800018d8 <z_vprintk+0x2a4>
80001764:	02a6e063          	bltu	a3,a0,80001784 <z_vprintk+0x150>
80001768:	06900693          	li	a3,105
8000176c:	0ad50463          	beq	a0,a3,80001814 <z_vprintk+0x1e0>
80001770:	06c00693          	li	a3,108
80001774:	08d50c63          	beq	a0,a3,8000180c <z_vprintk+0x1d8>
80001778:	06800693          	li	a3,104
8000177c:	f6d506e3          	beq	a0,a3,800016e8 <z_vprintk+0xb4>
80001780:	fc5ff06f          	j	80001744 <z_vprintk+0x110>
80001784:	07500693          	li	a3,117
80001788:	10d50863          	beq	a0,a3,80001898 <z_vprintk+0x264>
8000178c:	02a6ee63          	bltu	a3,a0,800017c8 <z_vprintk+0x194>
80001790:	07300713          	li	a4,115
80001794:	fae518e3          	bne	a0,a4,80001744 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001798:	000d2c03          	lw	s8,0(s10)
8000179c:	004d0b13          	addi	s6,s10,4
800017a0:	000c0b93          	mv	s7,s8
				while (*s)
800017a4:	000bc503          	lbu	a0,0(s7)
800017a8:	26051a63          	bnez	a0,80001a1c <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
800017ac:	00300793          	li	a5,3
800017b0:	00f99863          	bne	s3,a5,800017c0 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
800017b4:	418b8bb3          	sub	s7,s7,s8
800017b8:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800017bc:	27704863          	bgtz	s7,80001a2c <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
800017c0:	000b0d13          	mv	s10,s6
800017c4:	0cc0006f          	j	80001890 <z_vprintk+0x25c>
800017c8:	07800693          	li	a3,120
800017cc:	12d50663          	beq	a0,a3,800018f8 <z_vprintk+0x2c4>
800017d0:	07a00693          	li	a3,122
800017d4:	fa9ff06f          	j	8000177c <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
800017d8:	00095e63          	bgez	s2,800017f4 <z_vprintk+0x1c0>
800017dc:	28098a63          	beqz	s3,80001a70 <z_vprintk+0x43c>
					min_width = *fmt - '0';
800017e0:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
800017e4:	f00992e3          	bnez	s3,800016e8 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
800017e8:	00200993          	li	s3,2
800017ec:	efdff06f          	j	800016e8 <z_vprintk+0xb4>
				if (min_width < 0) {
800017f0:	fe0948e3          	bltz	s2,800017e0 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
800017f4:	00291693          	slli	a3,s2,0x2
800017f8:	01268933          	add	s2,a3,s2
800017fc:	00191913          	slli	s2,s2,0x1
80001800:	fd090913          	addi	s2,s2,-48
80001804:	01250933          	add	s2,a0,s2
80001808:	fddff06f          	j	800017e4 <z_vprintk+0x1b0>
				long_ctr++;
8000180c:	001a0a13          	addi	s4,s4,1
80001810:	ed9ff06f          	j	800016e8 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001814:	040a1263          	bnez	s4,80001858 <z_vprintk+0x224>
					long ld = va_arg(ap, long);
80001818:	000d2603          	lw	a2,0(s10)
8000181c:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001820:	02065063          	bgez	a2,80001840 <z_vprintk+0x20c>
					out((int)'-', ctx);
80001824:	00048593          	mv	a1,s1
80001828:	02d00513          	li	a0,45
8000182c:	00c12023          	sw	a2,0(sp)
80001830:	000400e7          	jalr	s0
					d = -d;
80001834:	00012603          	lw	a2,0(sp)
					min_width--;
80001838:	fff90913          	addi	s2,s2,-1
					d = -d;
8000183c:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001840:	00090713          	mv	a4,s2
80001844:	00098693          	mv	a3,s3
80001848:	00048593          	mv	a1,s1
8000184c:	00040513          	mv	a0,s0
80001850:	c7dff0ef          	jal	ra,800014cc <_printk_dec_ulong>
				break;
80001854:	03c0006f          	j	80001890 <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80001858:	00100713          	li	a4,1
8000185c:	faea0ee3          	beq	s4,a4,80001818 <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
80001860:	007d0793          	addi	a5,s10,7
80001864:	ff87f713          	andi	a4,a5,-8
80001868:	00072603          	lw	a2,0(a4)
8000186c:	00472683          	lw	a3,4(a4)
80001870:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001874:	01b60733          	add	a4,a2,s11
80001878:	00c73733          	sltu	a4,a4,a2
8000187c:	00d70733          	add	a4,a4,a3
80001880:	fa0700e3          	beqz	a4,80001820 <z_vprintk+0x1ec>
						print_err(out, ctx);
80001884:	00048593          	mv	a1,s1
80001888:	00040513          	mv	a0,s0
8000188c:	bddff0ef          	jal	ra,80001468 <print_err>
			might_format = 0;
80001890:	00000c93          	li	s9,0
80001894:	e55ff06f          	j	800016e8 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001898:	000a1863          	bnez	s4,800018a8 <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
8000189c:	000d2603          	lw	a2,0(s10)
800018a0:	004d0d13          	addi	s10,s10,4
800018a4:	f9dff06f          	j	80001840 <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
800018a8:	00100713          	li	a4,1
800018ac:	feea08e3          	beq	s4,a4,8000189c <z_vprintk+0x268>
					unsigned long long llu =
800018b0:	007d0793          	addi	a5,s10,7
800018b4:	ff87f713          	andi	a4,a5,-8
800018b8:	00870d13          	addi	s10,a4,8
800018bc:	00072603          	lw	a2,0(a4)
800018c0:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
800018c4:	fc0710e3          	bnez	a4,80001884 <z_vprintk+0x250>
800018c8:	800007b7          	lui	a5,0x80000
800018cc:	fff7c793          	not	a5,a5
800018d0:	f6c7f8e3          	bgeu	a5,a2,80001840 <z_vprintk+0x20c>
800018d4:	fb1ff06f          	j	80001884 <z_vprintk+0x250>
				  out('0', ctx);
800018d8:	00048593          	mv	a1,s1
800018dc:	03000513          	li	a0,48
800018e0:	000400e7          	jalr	s0
				  out('x', ctx);
800018e4:	00048593          	mv	a1,s1
800018e8:	07800513          	li	a0,120
800018ec:	000400e7          	jalr	s0
				  min_width = 8;
800018f0:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
800018f4:	00100993          	li	s3,1
				if (long_ctr < 2) {
800018f8:	00100693          	li	a3,1
800018fc:	0b46c263          	blt	a3,s4,800019a0 <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
80001900:	000d2783          	lw	a5,0(s10)
80001904:	00012423          	sw	zero,8(sp)
80001908:	004d0d13          	addi	s10,s10,4
8000190c:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001910:	01000c13          	li	s8,16
	int digits = 0;
80001914:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001918:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
8000191c:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001920:	00412503          	lw	a0,4(sp)
80001924:	00812583          	lw	a1,8(sp)
80001928:	fff88b13          	addi	s6,a7,-1
8000192c:	002b1613          	slli	a2,s6,0x2
80001930:	01112623          	sw	a7,12(sp)
80001934:	955fe0ef          	jal	ra,80000288 <__lshrdi3>
80001938:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
8000193c:	08051863          	bnez	a0,800019cc <z_vprintk+0x398>
80001940:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001944:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001948:	00079863          	bnez	a5,80001958 <z_vprintk+0x324>
8000194c:	00c12883          	lw	a7,12(sp)
80001950:	00100793          	li	a5,1
80001954:	08f89663          	bne	a7,a5,800019e0 <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
80001958:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
8000195c:	01851513          	slli	a0,a0,0x18
80001960:	00048593          	mv	a1,s1
80001964:	41855513          	srai	a0,a0,0x18
80001968:	000400e7          	jalr	s0
			digits++;
8000196c:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80001970:	040b1863          	bnez	s6,800019c0 <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
80001974:	00300693          	li	a3,3
			might_format = 0;
80001978:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
8000197c:	d6d996e3          	bne	s3,a3,800016e8 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80001980:	00191713          	slli	a4,s2,0x1
80001984:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001988:	f17054e3          	blez	s7,80001890 <z_vprintk+0x25c>
			out(' ', ctx);
8000198c:	00048593          	mv	a1,s1
80001990:	02000513          	li	a0,32
80001994:	000400e7          	jalr	s0
80001998:	fffb8b93          	addi	s7,s7,-1
8000199c:	fedff06f          	j	80001988 <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
800019a0:	007d0793          	addi	a5,s10,7
800019a4:	ff87f693          	andi	a3,a5,-8
800019a8:	0006a783          	lw	a5,0(a3)
800019ac:	00868d13          	addi	s10,a3,8
800019b0:	00f12223          	sw	a5,4(sp)
800019b4:	0046a783          	lw	a5,4(a3)
800019b8:	00f12423          	sw	a5,8(sp)
800019bc:	f55ff06f          	j	80001910 <z_vprintk+0x2dc>
			found_largest_digit = 1;
800019c0:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800019c4:	000b0893          	mv	a7,s6
800019c8:	f59ff06f          	j	80001920 <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
800019cc:	00900793          	li	a5,9
800019d0:	05700693          	li	a3,87
800019d4:	f8a7e2e3          	bltu	a5,a0,80001958 <z_vprintk+0x324>
800019d8:	03000693          	li	a3,48
800019dc:	f7dff06f          	j	80001958 <z_vprintk+0x324>
		if (remaining-- <= min_width) {
800019e0:	fffc0793          	addi	a5,s8,-1
800019e4:	00f12623          	sw	a5,12(sp)
800019e8:	01894c63          	blt	s2,s8,80001a00 <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
800019ec:	00100793          	li	a5,1
800019f0:	00f99c63          	bne	s3,a5,80001a08 <z_vprintk+0x3d4>
				out('0', ctx);
800019f4:	00048593          	mv	a1,s1
800019f8:	03000513          	li	a0,48
				out(' ', ctx);
800019fc:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80001a00:	00c12c03          	lw	s8,12(sp)
80001a04:	fc1ff06f          	j	800019c4 <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
80001a08:	00200793          	li	a5,2
80001a0c:	fef99ae3          	bne	s3,a5,80001a00 <z_vprintk+0x3cc>
				out(' ', ctx);
80001a10:	00048593          	mv	a1,s1
80001a14:	02000513          	li	a0,32
80001a18:	fe5ff06f          	j	800019fc <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
80001a1c:	00048593          	mv	a1,s1
80001a20:	001b8b93          	addi	s7,s7,1
80001a24:	000400e7          	jalr	s0
80001a28:	d7dff06f          	j	800017a4 <z_vprintk+0x170>
						out(' ', ctx);
80001a2c:	00048593          	mv	a1,s1
80001a30:	02000513          	li	a0,32
80001a34:	000400e7          	jalr	s0
80001a38:	fffb8b93          	addi	s7,s7,-1
80001a3c:	d81ff06f          	j	800017bc <z_vprintk+0x188>
				out(c, ctx);
80001a40:	000d2503          	lw	a0,0(s10)
80001a44:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80001a48:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001a4c:	000400e7          	jalr	s0
				break;
80001a50:	d71ff06f          	j	800017c0 <z_vprintk+0x18c>
				long_ctr = 0;
80001a54:	00000a13          	li	s4,0
				min_width = -1;
80001a58:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80001a5c:	00000993          	li	s3,0
				might_format = 1;
80001a60:	00100c93          	li	s9,1
80001a64:	c85ff06f          	j	800016e8 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80001a68:	00300993          	li	s3,3
80001a6c:	c7dff06f          	j	800016e8 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80001a70:	00100993          	li	s3,1
80001a74:	c75ff06f          	j	800016e8 <z_vprintk+0xb4>

80001a78 <vprintk>:
{
80001a78:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001a7c:	00050613          	mv	a2,a0
80001a80:	80001537          	lui	a0,0x80001
80001a84:	00058693          	mv	a3,a1
80001a88:	4b450513          	addi	a0,a0,1204 # 800014b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800014b5>
80001a8c:	00c10593          	addi	a1,sp,12
{
80001a90:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001a94:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001a98:	b9dff0ef          	jal	ra,80001634 <z_vprintk>
}
80001a9c:	01c12083          	lw	ra,28(sp)
80001aa0:	02010113          	addi	sp,sp,32
80001aa4:	00008067          	ret

80001aa8 <printk>:
{
80001aa8:	fc010113          	addi	sp,sp,-64
80001aac:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80001ab0:	02410593          	addi	a1,sp,36
{
80001ab4:	00112e23          	sw	ra,28(sp)
80001ab8:	02c12423          	sw	a2,40(sp)
80001abc:	02d12623          	sw	a3,44(sp)
80001ac0:	02e12823          	sw	a4,48(sp)
80001ac4:	02f12a23          	sw	a5,52(sp)
80001ac8:	03012c23          	sw	a6,56(sp)
80001acc:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80001ad0:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001ad4:	fa5ff0ef          	jal	ra,80001a78 <vprintk>
}
80001ad8:	01c12083          	lw	ra,28(sp)
80001adc:	04010113          	addi	sp,sp,64
80001ae0:	00008067          	ret

80001ae4 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001ae4:	800065b7          	lui	a1,0x80006
80001ae8:	80006537          	lui	a0,0x80006
{
80001aec:	ff010113          	addi	sp,sp,-16
  k_panic();
80001af0:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80001af4:	d2450513          	addi	a0,a0,-732 # 80005d24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d25>
80001af8:	01e00613          	li	a2,30
{
80001afc:	00112623          	sw	ra,12(sp)
  k_panic();
80001b00:	fa9ff0ef          	jal	ra,80001aa8 <printk>
80001b04:	800065b7          	lui	a1,0x80006
80001b08:	93458593          	addi	a1,a1,-1740 # 80005934 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005935>
80001b0c:	00600513          	li	a0,6
80001b10:	c18ff0ef          	jal	ra,80000f28 <z_NanoFatalErrorHandler>

80001b14 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001b14:	00008067          	ret

80001b18 <k_cpu_idle>:
80001b18:	00800793          	li	a5,8
80001b1c:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001b20:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001b24:	00008067          	ret

80001b28 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001b28:	00100793          	li	a5,1
80001b2c:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001b30:	30452573          	csrrs	a0,mie,a0
}
80001b34:	00008067          	ret

80001b38 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001b38:	00800793          	li	a5,8
80001b3c:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001b40:	30405073          	csrwi	mie,0
80001b44:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001b48:	00008067          	ret

80001b4c <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001b4c:	ff010113          	addi	sp,sp,-16
80001b50:	00812423          	sw	s0,8(sp)
80001b54:	00912223          	sw	s1,4(sp)
80001b58:	80006437          	lui	s0,0x80006
80001b5c:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001b60:	00a00793          	li	a5,10
{
80001b64:	00050493          	mv	s1,a0
80001b68:	31c40413          	addi	s0,s0,796 # 8000631c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000631d>
	if ('\n' == c) {
80001b6c:	00f51c63          	bne	a0,a5,80001b84 <console_out+0x38>
80001b70:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001b74:	00d00593          	li	a1,13
80001b78:	00452783          	lw	a5,4(a0)
80001b7c:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80001b80:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001b84:	00042503          	lw	a0,0(s0)
80001b88:	0ff4f593          	andi	a1,s1,255
80001b8c:	00452783          	lw	a5,4(a0)
80001b90:	0047a783          	lw	a5,4(a5)
80001b94:	000780e7          	jalr	a5

	return c;
}
80001b98:	00c12083          	lw	ra,12(sp)
80001b9c:	00812403          	lw	s0,8(sp)
80001ba0:	00048513          	mv	a0,s1
80001ba4:	00412483          	lw	s1,4(sp)
80001ba8:	01010113          	addi	sp,sp,16
80001bac:	00008067          	ret

80001bb0 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001bb0:	ff010113          	addi	sp,sp,-16
80001bb4:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001bb8:	80002437          	lui	s0,0x80002
80001bbc:	b4c40513          	addi	a0,s0,-1204 # 80001b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001b4d>
{
80001bc0:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001bc4:	540000ef          	jal	ra,80002104 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001bc8:	b4c40513          	addi	a0,s0,-1204
}
80001bcc:	00812403          	lw	s0,8(sp)
80001bd0:	00c12083          	lw	ra,12(sp)
80001bd4:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001bd8:	a51ff06f          	j	80001628 <__printk_hook_install>

80001bdc <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001bdc:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001be0:	ff010113          	addi	sp,sp,-16
80001be4:	d3050513          	addi	a0,a0,-720 # 80005d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d31>
80001be8:	00112623          	sw	ra,12(sp)
80001bec:	0c1000ef          	jal	ra,800024ac <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001bf0:	800067b7          	lui	a5,0x80006
80001bf4:	30a7ae23          	sw	a0,796(a5) # 8000631c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000631d>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001bf8:	fb9ff0ef          	jal	ra,80001bb0 <uart_console_hook_install>

	return 0;
}
80001bfc:	00c12083          	lw	ra,12(sp)
80001c00:	00000513          	li	a0,0
80001c04:	01010113          	addi	sp,sp,16
80001c08:	00008067          	ret

80001c0c <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001c0c:	f01007b7          	lui	a5,0xf0100
80001c10:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001c14:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001c18:	f447a583          	lw	a1,-188(a5)
80001c1c:	fee59ae3          	bne	a1,a4,80001c10 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001c20:	00008067          	ret

80001c24 <timer_isr>:

static void timer_isr(void *arg)
{
80001c24:	fe010113          	addi	sp,sp,-32
80001c28:	00812c23          	sw	s0,24(sp)
80001c2c:	00112e23          	sw	ra,28(sp)
80001c30:	00912a23          	sw	s1,20(sp)
80001c34:	01212823          	sw	s2,16(sp)
80001c38:	01312623          	sw	s3,12(sp)
80001c3c:	01412423          	sw	s4,8(sp)
80001c40:	01512223          	sw	s5,4(sp)
80001c44:	00800413          	li	s0,8
80001c48:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001c4c:	80006937          	lui	s2,0x80006
80001c50:	32090513          	addi	a0,s2,800 # 80006320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006321>
	key = (mstatus & SOC_MSTATUS_IEN);
80001c54:	00847413          	andi	s0,s0,8
80001c58:	0b9020ef          	jal	ra,80004510 <z_spin_lock_valid>
80001c5c:	02051e63          	bnez	a0,80001c98 <timer_isr+0x74>
80001c60:	800064b7          	lui	s1,0x80006
80001c64:	800065b7          	lui	a1,0x80006
80001c68:	80006537          	lui	a0,0x80006
80001c6c:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80001c70:	04e00693          	li	a3,78
80001c74:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80001c78:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80001c7c:	e2dff0ef          	jal	ra,80001aa8 <printk>
80001c80:	80006537          	lui	a0,0x80006
80001c84:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80001c88:	e21ff0ef          	jal	ra,80001aa8 <printk>
80001c8c:	04e00593          	li	a1,78
80001c90:	d4448513          	addi	a0,s1,-700
80001c94:	e51ff0ef          	jal	ra,80001ae4 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001c98:	32090513          	addi	a0,s2,800
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001c9c:	800064b7          	lui	s1,0x80006
80001ca0:	0c9020ef          	jal	ra,80004568 <z_spin_lock_set_owner>
80001ca4:	30048493          	addi	s1,s1,768 # 80006300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006301>
	u64_t now = mtime();
80001ca8:	f65ff0ef          	jal	ra,80001c0c <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001cac:	0004a983          	lw	s3,0(s1)
80001cb0:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001cb4:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001cb8:	41350533          	sub	a0,a0,s3
80001cbc:	00a7b7b3          	sltu	a5,a5,a0
80001cc0:	415585b3          	sub	a1,a1,s5
80001cc4:	0001d637          	lui	a2,0x1d
80001cc8:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001ccc:	00000693          	li	a3,0
80001cd0:	40f585b3          	sub	a1,a1,a5
80001cd4:	decfe0ef          	jal	ra,800002c0 <__udivdi3>
80001cd8:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80001cdc:	0001d5b7          	lui	a1,0x1d
80001ce0:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001ce4:	000a0513          	mv	a0,s4
80001ce8:	badfe0ef          	jal	ra,80000894 <__mulsi3>
80001cec:	013509b3          	add	s3,a0,s3
80001cf0:	00a9b533          	sltu	a0,s3,a0
80001cf4:	01550533          	add	a0,a0,s5
80001cf8:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001cfc:	32090513          	addi	a0,s2,800
80001d00:	0134a023          	sw	s3,0(s1)
80001d04:	035020ef          	jal	ra,80004538 <z_spin_unlock_valid>
80001d08:	02051e63          	bnez	a0,80001d44 <timer_isr+0x120>
80001d0c:	800064b7          	lui	s1,0x80006
80001d10:	800065b7          	lui	a1,0x80006
80001d14:	80006537          	lui	a0,0x80006
80001d18:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80001d1c:	06100693          	li	a3,97
80001d20:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80001d24:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80001d28:	d81ff0ef          	jal	ra,80001aa8 <printk>
80001d2c:	80006537          	lui	a0,0x80006
80001d30:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80001d34:	d75ff0ef          	jal	ra,80001aa8 <printk>
80001d38:	06100593          	li	a1,97
80001d3c:	d4448513          	addi	a0,s1,-700
80001d40:	da5ff0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001d44:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001d48:	01812403          	lw	s0,24(sp)
80001d4c:	01c12083          	lw	ra,28(sp)
80001d50:	01412483          	lw	s1,20(sp)
80001d54:	01012903          	lw	s2,16(sp)
80001d58:	00c12983          	lw	s3,12(sp)
80001d5c:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001d60:	000a0513          	mv	a0,s4
}
80001d64:	00812a03          	lw	s4,8(sp)
80001d68:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001d6c:	1f00306f          	j	80004f5c <z_clock_announce>

80001d70 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001d70:	ff010113          	addi	sp,sp,-16
80001d74:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001d78:	e95ff0ef          	jal	ra,80001c0c <mtime>
80001d7c:	0001d7b7          	lui	a5,0x1d
80001d80:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001d84:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001d88:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80001d8c:	fff00693          	li	a3,-1
80001d90:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001d94:	00a7b533          	sltu	a0,a5,a0
80001d98:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80001d9c:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001da0:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001da4:	00700513          	li	a0,7
80001da8:	d81ff0ef          	jal	ra,80001b28 <z_arch_irq_enable>
	return 0;
}
80001dac:	00c12083          	lw	ra,12(sp)
80001db0:	00000513          	li	a0,0
80001db4:	01010113          	addi	sp,sp,16
80001db8:	00008067          	ret

80001dbc <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001dbc:	1a059263          	bnez	a1,80001f60 <z_clock_set_timeout+0x1a4>
{
80001dc0:	fe010113          	addi	sp,sp,-32
80001dc4:	00112e23          	sw	ra,28(sp)
80001dc8:	00812c23          	sw	s0,24(sp)
80001dcc:	00912a23          	sw	s1,20(sp)
80001dd0:	01212823          	sw	s2,16(sp)
80001dd4:	01312623          	sw	s3,12(sp)
80001dd8:	01412423          	sw	s4,8(sp)
80001ddc:	01512223          	sw	s5,4(sp)
80001de0:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001de4:	fff00793          	li	a5,-1
80001de8:	00f51663          	bne	a0,a5,80001df4 <z_clock_set_timeout+0x38>
80001dec:	00009537          	lui	a0,0x9
80001df0:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001df4:	000097b7          	lui	a5,0x9
80001df8:	fff50413          	addi	s0,a0,-1
80001dfc:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001e00:	1487da63          	bge	a5,s0,80001f54 <z_clock_set_timeout+0x198>
80001e04:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001e08:	00800913          	li	s2,8
80001e0c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001e10:	80006ab7          	lui	s5,0x80006
80001e14:	320a8513          	addi	a0,s5,800 # 80006320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006321>
	key = (mstatus & SOC_MSTATUS_IEN);
80001e18:	00897913          	andi	s2,s2,8
80001e1c:	6f4020ef          	jal	ra,80004510 <z_spin_lock_valid>
80001e20:	02051e63          	bnez	a0,80001e5c <z_clock_set_timeout+0xa0>
80001e24:	800064b7          	lui	s1,0x80006
80001e28:	800065b7          	lui	a1,0x80006
80001e2c:	80006537          	lui	a0,0x80006
80001e30:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80001e34:	04e00693          	li	a3,78
80001e38:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80001e3c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80001e40:	c69ff0ef          	jal	ra,80001aa8 <printk>
80001e44:	80006537          	lui	a0,0x80006
80001e48:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80001e4c:	c5dff0ef          	jal	ra,80001aa8 <printk>
80001e50:	04e00593          	li	a1,78
80001e54:	d4448513          	addi	a0,s1,-700
80001e58:	c8dff0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80001e5c:	320a8513          	addi	a0,s5,800
80001e60:	708020ef          	jal	ra,80004568 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001e64:	da9ff0ef          	jal	ra,80001c0c <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001e68:	800067b7          	lui	a5,0x80006
80001e6c:	30078793          	addi	a5,a5,768 # 80006300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006301>
	u32_t cyc = ticks * CYC_PER_TICK;
80001e70:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001e74:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80001e78:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80001e7c:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001e80:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001e84:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001e88:	a0dfe0ef          	jal	ra,80000894 <__mulsi3>
80001e8c:	4bf48793          	addi	a5,s1,1215
80001e90:	413787b3          	sub	a5,a5,s3
80001e94:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001e98:	4c048593          	addi	a1,s1,1216
80001e9c:	00aa0533          	add	a0,s4,a0
80001ea0:	ab1fe0ef          	jal	ra,80000950 <__udivsi3>
80001ea4:	4c048593          	addi	a1,s1,1216
80001ea8:	9edfe0ef          	jal	ra,80000894 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001eac:	41498a33          	sub	s4,s3,s4
80001eb0:	00aa0a33          	add	s4,s4,a0
80001eb4:	3e700793          	li	a5,999
80001eb8:	0147c663          	blt	a5,s4,80001ec4 <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
80001ebc:	4c048493          	addi	s1,s1,1216
80001ec0:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
80001ec4:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80001ec8:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80001ecc:	fff00713          	li	a4,-1
80001ed0:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80001ed4:	00a9b533          	sltu	a0,s3,a0
80001ed8:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
80001edc:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80001ee0:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001ee4:	320a8513          	addi	a0,s5,800
80001ee8:	650020ef          	jal	ra,80004538 <z_spin_unlock_valid>
80001eec:	02051e63          	bnez	a0,80001f28 <z_clock_set_timeout+0x16c>
80001ef0:	80006437          	lui	s0,0x80006
80001ef4:	800065b7          	lui	a1,0x80006
80001ef8:	80006537          	lui	a0,0x80006
80001efc:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80001f00:	06100693          	li	a3,97
80001f04:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80001f08:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80001f0c:	b9dff0ef          	jal	ra,80001aa8 <printk>
80001f10:	80006537          	lui	a0,0x80006
80001f14:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80001f18:	b91ff0ef          	jal	ra,80001aa8 <printk>
80001f1c:	06100593          	li	a1,97
80001f20:	d4440513          	addi	a0,s0,-700
80001f24:	bc1ff0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001f28:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80001f2c:	01c12083          	lw	ra,28(sp)
80001f30:	01812403          	lw	s0,24(sp)
80001f34:	01412483          	lw	s1,20(sp)
80001f38:	01012903          	lw	s2,16(sp)
80001f3c:	00c12983          	lw	s3,12(sp)
80001f40:	00812a03          	lw	s4,8(sp)
80001f44:	00412a83          	lw	s5,4(sp)
80001f48:	00012b03          	lw	s6,0(sp)
80001f4c:	02010113          	addi	sp,sp,32
80001f50:	00008067          	ret
80001f54:	ea045ae3          	bgez	s0,80001e08 <z_clock_set_timeout+0x4c>
80001f58:	00000413          	li	s0,0
80001f5c:	eadff06f          	j	80001e08 <z_clock_set_timeout+0x4c>
80001f60:	00008067          	ret

80001f64 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001f64:	ff010113          	addi	sp,sp,-16
80001f68:	00812423          	sw	s0,8(sp)
80001f6c:	00112623          	sw	ra,12(sp)
80001f70:	00912223          	sw	s1,4(sp)
80001f74:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001f78:	00800413          	li	s0,8
80001f7c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001f80:	800064b7          	lui	s1,0x80006
80001f84:	32048513          	addi	a0,s1,800 # 80006320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006321>
	key = (mstatus & SOC_MSTATUS_IEN);
80001f88:	00847413          	andi	s0,s0,8
80001f8c:	584020ef          	jal	ra,80004510 <z_spin_lock_valid>
80001f90:	02051e63          	bnez	a0,80001fcc <z_clock_elapsed+0x68>
80001f94:	80006937          	lui	s2,0x80006
80001f98:	800065b7          	lui	a1,0x80006
80001f9c:	80006537          	lui	a0,0x80006
80001fa0:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80001fa4:	04e00693          	li	a3,78
80001fa8:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80001fac:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80001fb0:	af9ff0ef          	jal	ra,80001aa8 <printk>
80001fb4:	80006537          	lui	a0,0x80006
80001fb8:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80001fbc:	aedff0ef          	jal	ra,80001aa8 <printk>
80001fc0:	04e00593          	li	a1,78
80001fc4:	d4490513          	addi	a0,s2,-700
80001fc8:	b1dff0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80001fcc:	32048513          	addi	a0,s1,800
80001fd0:	598020ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80001fd4:	c39ff0ef          	jal	ra,80001c0c <mtime>
80001fd8:	800067b7          	lui	a5,0x80006
80001fdc:	3007a783          	lw	a5,768(a5) # 80006300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006301>
80001fe0:	0001d5b7          	lui	a1,0x1d
80001fe4:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001fe8:	40f50533          	sub	a0,a0,a5
80001fec:	965fe0ef          	jal	ra,80000950 <__udivsi3>
80001ff0:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001ff4:	32048513          	addi	a0,s1,800
80001ff8:	540020ef          	jal	ra,80004538 <z_spin_unlock_valid>
80001ffc:	02051e63          	bnez	a0,80002038 <z_clock_elapsed+0xd4>
80002000:	800064b7          	lui	s1,0x80006
80002004:	800065b7          	lui	a1,0x80006
80002008:	80006537          	lui	a0,0x80006
8000200c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80002010:	06100693          	li	a3,97
80002014:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002018:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
8000201c:	a8dff0ef          	jal	ra,80001aa8 <printk>
80002020:	80006537          	lui	a0,0x80006
80002024:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80002028:	a81ff0ef          	jal	ra,80001aa8 <printk>
8000202c:	06100593          	li	a1,97
80002030:	d4448513          	addi	a0,s1,-700
80002034:	ab1ff0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002038:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
8000203c:	00c12083          	lw	ra,12(sp)
80002040:	00812403          	lw	s0,8(sp)
80002044:	00090513          	mv	a0,s2
80002048:	00412483          	lw	s1,4(sp)
8000204c:	00012903          	lw	s2,0(sp)
80002050:	01010113          	addi	sp,sp,16
80002054:	00008067          	ret

80002058 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002058:	00054783          	lbu	a5,0(a0)
8000205c:	0005c703          	lbu	a4,0(a1)
80002060:	00e79463          	bne	a5,a4,80002068 <strcmp+0x10>
80002064:	00079663          	bnez	a5,80002070 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002068:	40e78533          	sub	a0,a5,a4
8000206c:	00008067          	ret
		s1++;
80002070:	00150513          	addi	a0,a0,1
		s2++;
80002074:	00158593          	addi	a1,a1,1
80002078:	fe1ff06f          	j	80002058 <strcmp>

8000207c <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
8000207c:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002080:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80002084:	0037f713          	andi	a4,a5,3
80002088:	04071463          	bnez	a4,800020d0 <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
8000208c:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002090:	00859713          	slli	a4,a1,0x8
80002094:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002098:	01059713          	slli	a4,a1,0x10
8000209c:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
800020a0:	00c78333          	add	t1,a5,a2
800020a4:	00078713          	mv	a4,a5
800020a8:	00300813          	li	a6,3
800020ac:	40e308b3          	sub	a7,t1,a4
800020b0:	03186a63          	bltu	a6,a7,800020e4 <memset+0x68>
800020b4:	00265713          	srli	a4,a2,0x2
800020b8:	00271593          	slli	a1,a4,0x2
800020bc:	00b787b3          	add	a5,a5,a1
800020c0:	40b60633          	sub	a2,a2,a1
800020c4:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
800020c8:	02c79463          	bne	a5,a2,800020f0 <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
800020cc:	00008067          	ret
		if (n == 0) {
800020d0:	fe060ee3          	beqz	a2,800020cc <memset+0x50>
		*(d_byte++) = c_byte;
800020d4:	00178793          	addi	a5,a5,1
800020d8:	fed78fa3          	sb	a3,-1(a5)
		n--;
800020dc:	fff60613          	addi	a2,a2,-1
800020e0:	fa5ff06f          	j	80002084 <memset+0x8>
		*(d_word++) = c_word;
800020e4:	00470713          	addi	a4,a4,4
800020e8:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
800020ec:	fc1ff06f          	j	800020ac <memset+0x30>
		*(d_byte++) = c_byte;
800020f0:	00178793          	addi	a5,a5,1
800020f4:	fed78fa3          	sb	a3,-1(a5)
		n--;
800020f8:	fd1ff06f          	j	800020c8 <memset+0x4c>

800020fc <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
800020fc:	fff00513          	li	a0,-1
80002100:	00008067          	ret

80002104 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002104:	800067b7          	lui	a5,0x80006
80002108:	2aa7a023          	sw	a0,672(a5) # 800062a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a1>
}
8000210c:	00008067          	ret

80002110 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002110:	fe010113          	addi	sp,sp,-32
80002114:	00812c23          	sw	s0,24(sp)
	test->setup();
80002118:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
8000211c:	80006437          	lui	s0,0x80006
{
80002120:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002124:	2a440413          	addi	s0,s0,676 # 800062a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a5>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002128:	800064b7          	lui	s1,0x80006
{
8000212c:	00112e23          	sw	ra,28(sp)
80002130:	01212823          	sw	s2,16(sp)
80002134:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002138:	32448493          	addi	s1,s1,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
8000213c:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002140:	00042023          	sw	zero,0(s0)
{
80002144:	00050913          	mv	s2,a0
	test_result = 1;
80002148:	0134a023          	sw	s3,0(s1)
	test->setup();
8000214c:	000780e7          	jalr	a5
	test->test();
80002150:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002154:	01342023          	sw	s3,0(s0)
	test->test();
80002158:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
8000215c:	00200793          	li	a5,2
80002160:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002164:	00c92783          	lw	a5,12(s2)
80002168:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
8000216c:	00300793          	li	a5,3
80002170:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002174:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002178:	0004a023          	sw	zero,0(s1)
}
8000217c:	01c12083          	lw	ra,28(sp)
80002180:	01412483          	lw	s1,20(sp)
80002184:	01012903          	lw	s2,16(sp)
80002188:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
8000218c:	80006537          	lui	a0,0x80006
80002190:	45c50513          	addi	a0,a0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80002194:	02010113          	addi	sp,sp,32
80002198:	7bd0106f          	j	80004154 <z_impl_k_sem_give>

8000219c <ztest_test_fail>:
8000219c:	80006537          	lui	a0,0x80006
{
800021a0:	ff010113          	addi	sp,sp,-16
	test_result = -1;
800021a4:	800067b7          	lui	a5,0x80006
800021a8:	fff00713          	li	a4,-1
800021ac:	45c50513          	addi	a0,a0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
{
800021b0:	00112623          	sw	ra,12(sp)
	test_result = -1;
800021b4:	32e7a223          	sw	a4,804(a5) # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
800021b8:	79d010ef          	jal	ra,80004154 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800021bc:	6c5010ef          	jal	ra,80004080 <z_impl_k_current_get>
}
800021c0:	00c12083          	lw	ra,12(sp)
800021c4:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800021c8:	6d00206f          	j	80004898 <z_impl_k_thread_abort>

800021cc <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
800021cc:	fa010113          	addi	sp,sp,-96
800021d0:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
800021d4:	800064b7          	lui	s1,0x80006
800021d8:	3284a783          	lw	a5,808(s1) # 80006328 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006329>
{
800021dc:	04112e23          	sw	ra,92(sp)
800021e0:	04812c23          	sw	s0,88(sp)
800021e4:	05212823          	sw	s2,80(sp)
800021e8:	05312623          	sw	s3,76(sp)
800021ec:	05412423          	sw	s4,72(sp)
800021f0:	05512223          	sw	s5,68(sp)
800021f4:	05612023          	sw	s6,64(sp)
800021f8:	03712e23          	sw	s7,60(sp)
800021fc:	03812c23          	sw	s8,56(sp)
80002200:	03912a23          	sw	s9,52(sp)
80002204:	03a12823          	sw	s10,48(sp)
80002208:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
8000220c:	0807c463          	bltz	a5,80002294 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002210:	80006437          	lui	s0,0x80006
80002214:	00100613          	li	a2,1
80002218:	00050993          	mv	s3,a0
8000221c:	00058c13          	mv	s8,a1
80002220:	45c40513          	addi	a0,s0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80002224:	00000593          	li	a1,0
80002228:	665010ef          	jal	ra,8000408c <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
8000222c:	80006537          	lui	a0,0x80006
80002230:	00098593          	mv	a1,s3
80002234:	df850513          	addi	a0,a0,-520 # 80005df8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005df9>
80002238:	871ff0ef          	jal	ra,80001aa8 <printk>
	PRINT_LINE;
8000223c:	80006937          	lui	s2,0x80006
80002240:	e1090513          	addi	a0,s2,-496 # 80005e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e11>
		Z_TC_END_RESULT(ret, test->name);
80002244:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
80002248:	861ff0ef          	jal	ra,80001aa8 <printk>
8000224c:	32848493          	addi	s1,s1,808
	int fail = 0;
80002250:	00000a13          	li	s4,0
80002254:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002258:	80007cb7          	lui	s9,0x80007
8000225c:	80006b37          	lui	s6,0x80006
80002260:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80002264:	80006db7          	lui	s11,0x80006
80002268:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
8000226c:	db8a8a93          	addi	s5,s5,-584 # 80005db8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005db9>
	while (suite->test) {
80002270:	004c2783          	lw	a5,4(s8)
80002274:	04079e63          	bnez	a5,800022d0 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002278:	00098593          	mv	a1,s3
	if (fail) {
8000227c:	100a0663          	beqz	s4,80002388 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002280:	80006537          	lui	a0,0x80006
80002284:	e8050513          	addi	a0,a0,-384 # 80005e80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e81>
80002288:	821ff0ef          	jal	ra,80001aa8 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
8000228c:	00100793          	li	a5,1
80002290:	00f4a023          	sw	a5,0(s1)
}
80002294:	05c12083          	lw	ra,92(sp)
80002298:	05812403          	lw	s0,88(sp)
8000229c:	05412483          	lw	s1,84(sp)
800022a0:	05012903          	lw	s2,80(sp)
800022a4:	04c12983          	lw	s3,76(sp)
800022a8:	04812a03          	lw	s4,72(sp)
800022ac:	04412a83          	lw	s5,68(sp)
800022b0:	04012b03          	lw	s6,64(sp)
800022b4:	03c12b83          	lw	s7,60(sp)
800022b8:	03812c03          	lw	s8,56(sp)
800022bc:	03412c83          	lw	s9,52(sp)
800022c0:	03012d03          	lw	s10,48(sp)
800022c4:	02c12d83          	lw	s11,44(sp)
800022c8:	06010113          	addi	sp,sp,96
800022cc:	00008067          	ret
	TC_START(test->name);
800022d0:	000c2583          	lw	a1,0(s8)
800022d4:	800067b7          	lui	a5,0x80006
800022d8:	e5878513          	addi	a0,a5,-424 # 80005e58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e59>
800022dc:	fccff0ef          	jal	ra,80001aa8 <printk>
800022e0:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
800022e4:	010c2783          	lw	a5,16(s8)
800022e8:	000c0713          	mv	a4,s8
800022ec:	40000613          	li	a2,1024
800022f0:	0087e793          	ori	a5,a5,8
800022f4:	fff00893          	li	a7,-1
800022f8:	00000813          	li	a6,0
800022fc:	110d0693          	addi	a3,s10,272 # 80002110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002111>
80002300:	00f12023          	sw	a5,0(sp)
80002304:	8f0c8593          	addi	a1,s9,-1808 # 800068f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068f1>
80002308:	00000793          	li	a5,0
8000230c:	46cb0513          	addi	a0,s6,1132 # 8000646c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000646d>
80002310:	3e4020ef          	jal	ra,800046f4 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002314:	01c12783          	lw	a5,28(sp)
80002318:	fff00593          	li	a1,-1
8000231c:	45c78513          	addi	a0,a5,1116
80002320:	719010ef          	jal	ra,80004238 <z_impl_k_sem_take>
	if (test_result == -1) {
80002324:	324d8793          	addi	a5,s11,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002328:	46cb0513          	addi	a0,s6,1132
8000232c:	0007a403          	lw	s0,0(a5)
80002330:	568020ef          	jal	ra,80004898 <z_impl_k_thread_abort>
	if (test_result == -2) {
80002334:	800067b7          	lui	a5,0x80006
80002338:	32478793          	addi	a5,a5,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
8000233c:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002340:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80002344:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002348:	00143413          	seqz	s0,s0
	if (test_result == -2) {
8000234c:	000c2603          	lw	a2,0(s8)
80002350:	02f71463          	bne	a4,a5,80002378 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002354:	800065b7          	lui	a1,0x80006
80002358:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
		Z_TC_END_RESULT(ret, test->name);
8000235c:	e74b8513          	addi	a0,s7,-396 # 80005e74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e75>
80002360:	f48ff0ef          	jal	ra,80001aa8 <printk>
80002364:	e1090513          	addi	a0,s2,-496
80002368:	f40ff0ef          	jal	ra,80001aa8 <printk>
		fail += run_test(suite);
8000236c:	008a0a33          	add	s4,s4,s0
		suite++;
80002370:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002374:	efdff06f          	j	80002270 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80002378:	00241793          	slli	a5,s0,0x2
8000237c:	00fa87b3          	add	a5,s5,a5
80002380:	0007a583          	lw	a1,0(a5)
80002384:	fd9ff06f          	j	8000235c <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80002388:	80006537          	lui	a0,0x80006
8000238c:	e9850513          	addi	a0,a0,-360 # 80005e98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e99>
80002390:	f18ff0ef          	jal	ra,80001aa8 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002394:	0004a783          	lw	a5,0(s1)
80002398:	00f037b3          	snez	a5,a5
8000239c:	ef5ff06f          	j	80002290 <z_ztest_run_test_suite+0xc4>

800023a0 <end_report>:

void end_report(void)
{
	if (test_status) {
800023a0:	800067b7          	lui	a5,0x80006
800023a4:	3287a783          	lw	a5,808(a5) # 80006328 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006329>
{
800023a8:	ff010113          	addi	sp,sp,-16
800023ac:	00812423          	sw	s0,8(sp)
800023b0:	80006537          	lui	a0,0x80006
800023b4:	00112623          	sw	ra,12(sp)
800023b8:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
800023bc:	e1050513          	addi	a0,a0,-496 # 80005e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e11>
	if (test_status) {
800023c0:	02078263          	beqz	a5,800023e4 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
800023c4:	ee4ff0ef          	jal	ra,80001aa8 <printk>
800023c8:	800065b7          	lui	a1,0x80006
800023cc:	dc458593          	addi	a1,a1,-572 # 80005dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dc5>
	} else {
		TC_END_REPORT(TC_PASS);
800023d0:	dcc40513          	addi	a0,s0,-564 # 80005dcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dcd>
	}
}
800023d4:	00812403          	lw	s0,8(sp)
800023d8:	00c12083          	lw	ra,12(sp)
800023dc:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
800023e0:	ec8ff06f          	j	80001aa8 <printk>
800023e4:	ec4ff0ef          	jal	ra,80001aa8 <printk>
800023e8:	800065b7          	lui	a1,0x80006
800023ec:	de458593          	addi	a1,a1,-540 # 80005de4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005de5>
800023f0:	fe1ff06f          	j	800023d0 <end_report+0x30>

800023f4 <main>:

	return test_status;
}
#else
void main(void)
{
800023f4:	ff010113          	addi	sp,sp,-16
800023f8:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
800023fc:	aa1fe0ef          	jal	ra,80000e9c <test_main>
	end_report();
}
80002400:	00c12083          	lw	ra,12(sp)
80002404:	01010113          	addi	sp,sp,16
	end_report();
80002408:	f99ff06f          	j	800023a0 <end_report>

8000240c <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
8000240c:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002410:	00012623          	sw	zero,12(sp)
    i++;
80002414:	00c12783          	lw	a5,12(sp)
80002418:	00178793          	addi	a5,a5,1
8000241c:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002420:	f00107b7          	lui	a5,0xf0010
80002424:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002428:	01010113          	addi	sp,sp,16
8000242c:	00008067          	ret

80002430 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002430:	fff00513          	li	a0,-1
80002434:	00008067          	ret

80002438 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002438:	00000513          	li	a0,0
8000243c:	00008067          	ret

80002440 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002440:	00251713          	slli	a4,a0,0x2
80002444:	800067b7          	lui	a5,0x80006
80002448:	00150513          	addi	a0,a0,1
8000244c:	ec878793          	addi	a5,a5,-312 # 80005ec8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ec9>
80002450:	00251513          	slli	a0,a0,0x2
{
80002454:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002458:	00e78733          	add	a4,a5,a4
8000245c:	00a787b3          	add	a5,a5,a0
{
80002460:	00812423          	sw	s0,8(sp)
80002464:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002468:	00072403          	lw	s0,0(a4)
8000246c:	0007a483          	lw	s1,0(a5)
{
80002470:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002474:	00946c63          	bltu	s0,s1,8000248c <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002478:	00c12083          	lw	ra,12(sp)
8000247c:	00812403          	lw	s0,8(sp)
80002480:	00412483          	lw	s1,4(sp)
80002484:	01010113          	addi	sp,sp,16
80002488:	00008067          	ret
		retval = device_conf->init(info);
8000248c:	00042783          	lw	a5,0(s0)
80002490:	00040513          	mv	a0,s0
80002494:	0047a783          	lw	a5,4(a5)
80002498:	000780e7          	jalr	a5
		if (retval != 0) {
8000249c:	00050463          	beqz	a0,800024a4 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
800024a0:	00042223          	sw	zero,4(s0)
								info++) {
800024a4:	00c40413          	addi	s0,s0,12
800024a8:	fcdff06f          	j	80002474 <z_sys_device_do_config_level+0x34>

800024ac <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800024ac:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800024b0:	800067b7          	lui	a5,0x80006
{
800024b4:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800024b8:	800064b7          	lui	s1,0x80006
{
800024bc:	00812423          	sw	s0,8(sp)
800024c0:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800024c4:	2bc78413          	addi	s0,a5,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
{
800024c8:	01212023          	sw	s2,0(sp)
800024cc:	2bc78793          	addi	a5,a5,700
800024d0:	2ec48493          	addi	s1,s1,748 # 800062ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062ed>
	for (info = __device_init_start; info != __device_init_end; info++) {
800024d4:	00941c63          	bne	s0,s1,800024ec <z_impl_device_get_binding+0x40>
800024d8:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
800024dc:	00078413          	mv	s0,a5
800024e0:	02941463          	bne	s0,s1,80002508 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
800024e4:	00000413          	li	s0,0
800024e8:	0440006f          	j	8000252c <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
800024ec:	00442703          	lw	a4,4(s0)
800024f0:	00070863          	beqz	a4,80002500 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
800024f4:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
800024f8:	00072703          	lw	a4,0(a4)
800024fc:	02a70863          	beq	a4,a0,8000252c <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002500:	00c40413          	addi	s0,s0,12
80002504:	fd1ff06f          	j	800024d4 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002508:	00442783          	lw	a5,4(s0)
8000250c:	00079663          	bnez	a5,80002518 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002510:	00c40413          	addi	s0,s0,12
80002514:	fcdff06f          	j	800024e0 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002518:	00042783          	lw	a5,0(s0)
8000251c:	00090513          	mv	a0,s2
80002520:	0007a583          	lw	a1,0(a5)
80002524:	b35ff0ef          	jal	ra,80002058 <strcmp>
80002528:	fe0514e3          	bnez	a0,80002510 <z_impl_device_get_binding+0x64>
}
8000252c:	00040513          	mv	a0,s0
80002530:	00c12083          	lw	ra,12(sp)
80002534:	00812403          	lw	s0,8(sp)
80002538:	00412483          	lw	s1,4(sp)
8000253c:	00012903          	lw	s2,0(sp)
80002540:	01010113          	addi	sp,sp,16
80002544:	00008067          	ret

80002548 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002548:	ff010113          	addi	sp,sp,-16
8000254c:	00812423          	sw	s0,8(sp)
80002550:	00912223          	sw	s1,4(sp)
80002554:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002558:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
8000255c:	00200493          	li	s1,2
80002560:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80002564:	019020ef          	jal	ra,80004d7c <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002568:	00a4c463          	blt	s1,a0,80002570 <idle+0x28>
8000256c:	00100513          	li	a0,1
80002570:	00100593          	li	a1,1
80002574:	0e5020ef          	jal	ra,80004e58 <z_set_timeout_expiry>
	k_cpu_idle();
80002578:	da0ff0ef          	jal	ra,80001b18 <k_cpu_idle>
8000257c:	fe5ff06f          	j	80002560 <idle+0x18>

80002580 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002580:	80006537          	lui	a0,0x80006
80002584:	800067b7          	lui	a5,0x80006
80002588:	30050613          	addi	a2,a0,768 # 80006300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006301>
8000258c:	5e878793          	addi	a5,a5,1512 # 800065e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e9>
80002590:	40c78633          	sub	a2,a5,a2
80002594:	00000593          	li	a1,0
80002598:	30050513          	addi	a0,a0,768
8000259c:	ae1ff06f          	j	8000207c <memset>

800025a0 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
800025a0:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800025a4:	00200513          	li	a0,2
{
800025a8:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800025ac:	e95ff0ef          	jal	ra,80002440 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
800025b0:	80006537          	lui	a0,0x80006
800025b4:	edc50513          	addi	a0,a0,-292 # 80005edc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005edd>
800025b8:	cf0ff0ef          	jal	ra,80001aa8 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
800025bc:	00300513          	li	a0,3
800025c0:	e81ff0ef          	jal	ra,80002440 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
800025c4:	224020ef          	jal	ra,800047e8 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
800025c8:	e2dff0ef          	jal	ra,800023f4 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
800025cc:	800067b7          	lui	a5,0x80006
800025d0:	54c78793          	addi	a5,a5,1356 # 8000654c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000654d>
800025d4:	00c7c703          	lbu	a4,12(a5)
800025d8:	ffe77713          	andi	a4,a4,-2
800025dc:	00e78623          	sb	a4,12(a5)
}
800025e0:	00c12083          	lw	ra,12(sp)
800025e4:	01010113          	addi	sp,sp,16
800025e8:	00008067          	ret

800025ec <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
800025ec:	f6010113          	addi	sp,sp,-160
800025f0:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
800025f4:	800087b7          	lui	a5,0x80008
800025f8:	80006437          	lui	s0,0x80006
800025fc:	09312623          	sw	s3,140(sp)
80002600:	8f078793          	addi	a5,a5,-1808 # 800078f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f1>
80002604:	5bc40993          	addi	s3,s0,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80002608:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
8000260c:	01010793          	addi	a5,sp,16
80002610:	07000613          	li	a2,112
80002614:	00000593          	li	a1,0
80002618:	00078513          	mv	a0,a5
{
8000261c:	08112e23          	sw	ra,156(sp)
80002620:	08912a23          	sw	s1,148(sp)
80002624:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002628:	a55ff0ef          	jal	ra,8000207c <memset>
8000262c:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002630:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002634:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002638:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
8000263c:	e05ff0ef          	jal	ra,80002440 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002640:	00100513          	li	a0,1
80002644:	dfdff0ef          	jal	ra,80002440 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002648:	10100793          	li	a5,257
8000264c:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002650:	490010ef          	jal	ra,80003ae0 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002654:	800067b7          	lui	a5,0x80006
80002658:	f2078793          	addi	a5,a5,-224 # 80005f20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f21>
	_kernel.ready_q.cache = _main_thread;
8000265c:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
80002660:	00f12223          	sw	a5,4(sp)
80002664:	800026b7          	lui	a3,0x80002
80002668:	00100793          	li	a5,1
8000266c:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002670:	54c90493          	addi	s1,s2,1356 # 8000654c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000654d>
	z_setup_new_thread(_main_thread, _main_stack,
80002674:	00f12023          	sw	a5,0(sp)
80002678:	00000713          	li	a4,0
8000267c:	00000793          	li	a5,0
80002680:	00000893          	li	a7,0
80002684:	00000813          	li	a6,0
80002688:	5a068693          	addi	a3,a3,1440 # 800025a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800025a1>
8000268c:	20000613          	li	a2,512
80002690:	cf058593          	addi	a1,a1,-784 # 80006cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf1>
80002694:	54c90513          	addi	a0,s2,1356
	_kernel.ready_q.cache = _main_thread;
80002698:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
8000269c:	5a9010ef          	jal	ra,80004444 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
800026a0:	00d4c783          	lbu	a5,13(s1)
800026a4:	5bc40413          	addi	s0,s0,1468
800026a8:	ffb7f713          	andi	a4,a5,-5
800026ac:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800026b0:	01b7f793          	andi	a5,a5,27
800026b4:	00079a63          	bnez	a5,800026c8 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
800026b8:	0184a783          	lw	a5,24(s1)
800026bc:	00079663          	bnez	a5,800026c8 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
800026c0:	54c90513          	addi	a0,s2,1356
800026c4:	089000ef          	jal	ra,80002f4c <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
800026c8:	800067b7          	lui	a5,0x80006
800026cc:	f2878793          	addi	a5,a5,-216 # 80005f28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f29>
800026d0:	00f12223          	sw	a5,4(sp)
800026d4:	80006537          	lui	a0,0x80006
800026d8:	00100793          	li	a5,1
800026dc:	800026b7          	lui	a3,0x80002
800026e0:	800075b7          	lui	a1,0x80007
800026e4:	4dc50493          	addi	s1,a0,1244 # 800064dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064dd>
800026e8:	00f12023          	sw	a5,0(sp)
800026ec:	00f00893          	li	a7,15
800026f0:	00000813          	li	a6,0
800026f4:	00000793          	li	a5,0
800026f8:	00000713          	li	a4,0
800026fc:	54868693          	addi	a3,a3,1352 # 80002548 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002549>
80002700:	20000613          	li	a2,512
80002704:	ef058593          	addi	a1,a1,-272 # 80006ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ef1>
80002708:	4dc50513          	addi	a0,a0,1244
8000270c:	539010ef          	jal	ra,80004444 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002710:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002714:	00942623          	sw	s1,12(s0)
80002718:	00800513          	li	a0,8
8000271c:	ffb7f793          	andi	a5,a5,-5
80002720:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002724:	800067b7          	lui	a5,0x80006
80002728:	5d478793          	addi	a5,a5,1492 # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
8000272c:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002730:	00f42e23          	sw	a5,28(s0)
80002734:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002738:	00857513          	andi	a0,a0,8
8000273c:	afdfd0ef          	jal	ra,80000238 <__swap>

80002740 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002740:	00d54783          	lbu	a5,13(a0)
80002744:	01f7f793          	andi	a5,a5,31
80002748:	00079863          	bnez	a5,80002758 <z_is_thread_ready+0x18>
8000274c:	01852503          	lw	a0,24(a0)
80002750:	00153513          	seqz	a0,a0
80002754:	00008067          	ret
80002758:	00000513          	li	a0,0
}
8000275c:	00008067          	ret

80002760 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002760:	ff010113          	addi	sp,sp,-16
80002764:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002768:	ffcff0ef          	jal	ra,80001f64 <z_clock_elapsed>
8000276c:	800067b7          	lui	a5,0x80006
80002770:	3347a783          	lw	a5,820(a5) # 80006334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006335>

	z_set_timeout_expiry(slice_time, false);
}
80002774:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002778:	80006737          	lui	a4,0x80006
8000277c:	00a78533          	add	a0,a5,a0
80002780:	5ca72623          	sw	a0,1484(a4) # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
	z_set_timeout_expiry(slice_time, false);
80002784:	00000593          	li	a1,0
80002788:	00078513          	mv	a0,a5
}
8000278c:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002790:	6c80206f          	j	80004e58 <z_set_timeout_expiry>

80002794 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002794:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002798:	ff010113          	addi	sp,sp,-16
8000279c:	00812423          	sw	s0,8(sp)
800027a0:	00112623          	sw	ra,12(sp)
800027a4:	00912223          	sw	s1,4(sp)
800027a8:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
800027ac:	02079863          	bnez	a5,800027dc <pended_on.isra.15+0x48>
800027b0:	800064b7          	lui	s1,0x80006
800027b4:	800065b7          	lui	a1,0x80006
800027b8:	80006537          	lui	a0,0x80006
800027bc:	fcc58593          	addi	a1,a1,-52 # 80005fcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fcd>
800027c0:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800027c4:	18300693          	li	a3,387
800027c8:	fb848613          	addi	a2,s1,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
800027cc:	adcff0ef          	jal	ra,80001aa8 <printk>
800027d0:	18300593          	li	a1,387
800027d4:	fb848513          	addi	a0,s1,-72
800027d8:	b0cff0ef          	jal	ra,80001ae4 <assert_post_action>

	return thread->base.pended_on;
}
800027dc:	00042503          	lw	a0,0(s0)
800027e0:	00c12083          	lw	ra,12(sp)
800027e4:	00812403          	lw	s0,8(sp)
800027e8:	00412483          	lw	s1,4(sp)
800027ec:	01010113          	addi	sp,sp,16
800027f0:	00008067          	ret

800027f4 <k_sched_time_slice_set>:
{
800027f4:	fe010113          	addi	sp,sp,-32
800027f8:	00812c23          	sw	s0,24(sp)
800027fc:	01312623          	sw	s3,12(sp)
80002800:	01412423          	sw	s4,8(sp)
80002804:	00112e23          	sw	ra,28(sp)
80002808:	00912a23          	sw	s1,20(sp)
8000280c:	01212823          	sw	s2,16(sp)
80002810:	00050a13          	mv	s4,a0
80002814:	00058993          	mv	s3,a1
80002818:	00800413          	li	s0,8
8000281c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002820:	800064b7          	lui	s1,0x80006
80002824:	32c48513          	addi	a0,s1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002828:	00847413          	andi	s0,s0,8
8000282c:	4e5010ef          	jal	ra,80004510 <z_spin_lock_valid>
80002830:	02051e63          	bnez	a0,8000286c <k_sched_time_slice_set+0x78>
80002834:	80006937          	lui	s2,0x80006
80002838:	800065b7          	lui	a1,0x80006
8000283c:	80006537          	lui	a0,0x80006
80002840:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80002844:	04e00693          	li	a3,78
80002848:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
8000284c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002850:	a58ff0ef          	jal	ra,80001aa8 <printk>
80002854:	80006537          	lui	a0,0x80006
80002858:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
8000285c:	a4cff0ef          	jal	ra,80001aa8 <printk>
80002860:	04e00593          	li	a1,78
80002864:	d4490513          	addi	a0,s2,-700
80002868:	a7cff0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
8000286c:	32c48513          	addi	a0,s1,812
80002870:	4f9010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002874:	800067b7          	lui	a5,0x80006
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002878:	00a00593          	li	a1,10
8000287c:	009a0513          	addi	a0,s4,9
80002880:	5c07a623          	sw	zero,1484(a5) # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
80002884:	8c4fe0ef          	jal	ra,80000948 <__divsi3>
		slice_max_prio = prio;
80002888:	800067b7          	lui	a5,0x80006
		slice_time = z_ms_to_ticks(slice);
8000288c:	80006937          	lui	s2,0x80006
80002890:	32a92a23          	sw	a0,820(s2) # 80006334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006335>
		slice_max_prio = prio;
80002894:	3337a823          	sw	s3,816(a5) # 80006330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006331>
		reset_time_slice();
80002898:	ec9ff0ef          	jal	ra,80002760 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000289c:	32c48513          	addi	a0,s1,812
800028a0:	499010ef          	jal	ra,80004538 <z_spin_unlock_valid>
800028a4:	02051e63          	bnez	a0,800028e0 <k_sched_time_slice_set+0xec>
800028a8:	800064b7          	lui	s1,0x80006
800028ac:	800065b7          	lui	a1,0x80006
800028b0:	80006537          	lui	a0,0x80006
800028b4:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
800028b8:	06100693          	li	a3,97
800028bc:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800028c0:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800028c4:	9e4ff0ef          	jal	ra,80001aa8 <printk>
800028c8:	80006537          	lui	a0,0x80006
800028cc:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
800028d0:	9d8ff0ef          	jal	ra,80001aa8 <printk>
800028d4:	06100593          	li	a1,97
800028d8:	d4448513          	addi	a0,s1,-700
800028dc:	a08ff0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800028e0:	30042473          	csrrs	s0,mstatus,s0
}
800028e4:	01c12083          	lw	ra,28(sp)
800028e8:	01812403          	lw	s0,24(sp)
800028ec:	01412483          	lw	s1,20(sp)
800028f0:	01012903          	lw	s2,16(sp)
800028f4:	00c12983          	lw	s3,12(sp)
800028f8:	00812a03          	lw	s4,8(sp)
800028fc:	02010113          	addi	sp,sp,32
80002900:	00008067          	ret

80002904 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002904:	fe010113          	addi	sp,sp,-32
80002908:	00812c23          	sw	s0,24(sp)
8000290c:	01212823          	sw	s2,16(sp)
80002910:	00112e23          	sw	ra,28(sp)
80002914:	00912a23          	sw	s1,20(sp)
80002918:	01312623          	sw	s3,12(sp)
8000291c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002920:	00800413          	li	s0,8
80002924:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002928:	800064b7          	lui	s1,0x80006
8000292c:	32c48513          	addi	a0,s1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002930:	00847413          	andi	s0,s0,8
80002934:	3dd010ef          	jal	ra,80004510 <z_spin_lock_valid>
80002938:	02051e63          	bnez	a0,80002974 <z_unpend_thread_no_timeout+0x70>
8000293c:	800069b7          	lui	s3,0x80006
80002940:	800065b7          	lui	a1,0x80006
80002944:	80006537          	lui	a0,0x80006
80002948:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
8000294c:	04e00693          	li	a3,78
80002950:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002954:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002958:	950ff0ef          	jal	ra,80001aa8 <printk>
8000295c:	80006537          	lui	a0,0x80006
80002960:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80002964:	944ff0ef          	jal	ra,80001aa8 <printk>
80002968:	04e00593          	li	a1,78
8000296c:	d4498513          	addi	a0,s3,-700
80002970:	974ff0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002974:	32c48513          	addi	a0,s1,812
80002978:	3f1010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000297c:	00890513          	addi	a0,s2,8
80002980:	e15ff0ef          	jal	ra,80002794 <pended_on.isra.15>
80002984:	00090593          	mv	a1,s2
80002988:	2f0000ef          	jal	ra,80002c78 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000298c:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002990:	32c48513          	addi	a0,s1,812
80002994:	ffd7f793          	andi	a5,a5,-3
80002998:	00f906a3          	sb	a5,13(s2)
8000299c:	39d010ef          	jal	ra,80004538 <z_spin_unlock_valid>
800029a0:	02051e63          	bnez	a0,800029dc <z_unpend_thread_no_timeout+0xd8>
800029a4:	800064b7          	lui	s1,0x80006
800029a8:	800065b7          	lui	a1,0x80006
800029ac:	80006537          	lui	a0,0x80006
800029b0:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
800029b4:	06100693          	li	a3,97
800029b8:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800029bc:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800029c0:	8e8ff0ef          	jal	ra,80001aa8 <printk>
800029c4:	80006537          	lui	a0,0x80006
800029c8:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
800029cc:	8dcff0ef          	jal	ra,80001aa8 <printk>
800029d0:	06100593          	li	a1,97
800029d4:	d4448513          	addi	a0,s1,-700
800029d8:	90cff0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800029dc:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
800029e0:	01c12083          	lw	ra,28(sp)
800029e4:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
800029e8:	00092423          	sw	zero,8(s2)
}
800029ec:	01412483          	lw	s1,20(sp)
800029f0:	01012903          	lw	s2,16(sp)
800029f4:	00c12983          	lw	s3,12(sp)
800029f8:	02010113          	addi	sp,sp,32
800029fc:	00008067          	ret

80002a00 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80002a00:	800067b7          	lui	a5,0x80006
80002a04:	5bc7a783          	lw	a5,1468(a5) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
{
80002a08:	ff010113          	addi	sp,sp,-16
80002a0c:	00812423          	sw	s0,8(sp)
80002a10:	00112623          	sw	ra,12(sp)
80002a14:	00912223          	sw	s1,4(sp)
80002a18:	00058413          	mv	s0,a1
	if (resched()) {
80002a1c:	04079e63          	bnez	a5,80002a78 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002a20:	319010ef          	jal	ra,80004538 <z_spin_unlock_valid>
80002a24:	02051e63          	bnez	a0,80002a60 <z_reschedule+0x60>
80002a28:	800064b7          	lui	s1,0x80006
80002a2c:	800065b7          	lui	a1,0x80006
80002a30:	80006537          	lui	a0,0x80006
80002a34:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80002a38:	07800693          	li	a3,120
80002a3c:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002a40:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002a44:	864ff0ef          	jal	ra,80001aa8 <printk>
80002a48:	80006537          	lui	a0,0x80006
80002a4c:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80002a50:	858ff0ef          	jal	ra,80001aa8 <printk>
80002a54:	07800593          	li	a1,120
80002a58:	d4448513          	addi	a0,s1,-700
80002a5c:	888ff0ef          	jal	ra,80001ae4 <assert_post_action>
80002a60:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80002a64:	00812403          	lw	s0,8(sp)
80002a68:	00c12083          	lw	ra,12(sp)
80002a6c:	00412483          	lw	s1,4(sp)
80002a70:	01010113          	addi	sp,sp,16
80002a74:	fc4fd06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002a78:	2c1010ef          	jal	ra,80004538 <z_spin_unlock_valid>
80002a7c:	02051e63          	bnez	a0,80002ab8 <z_reschedule+0xb8>
80002a80:	800064b7          	lui	s1,0x80006
80002a84:	800065b7          	lui	a1,0x80006
80002a88:	80006537          	lui	a0,0x80006
80002a8c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80002a90:	06100693          	li	a3,97
80002a94:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002a98:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002a9c:	80cff0ef          	jal	ra,80001aa8 <printk>
80002aa0:	80006537          	lui	a0,0x80006
80002aa4:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80002aa8:	800ff0ef          	jal	ra,80001aa8 <printk>
80002aac:	06100593          	li	a1,97
80002ab0:	d4448513          	addi	a0,s1,-700
80002ab4:	830ff0ef          	jal	ra,80001ae4 <assert_post_action>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80002ab8:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002abc:	30042473          	csrrs	s0,mstatus,s0
80002ac0:	00c12083          	lw	ra,12(sp)
80002ac4:	00812403          	lw	s0,8(sp)
80002ac8:	00412483          	lw	s1,4(sp)
80002acc:	01010113          	addi	sp,sp,16
80002ad0:	00008067          	ret

80002ad4 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80002ad4:	80006737          	lui	a4,0x80006
80002ad8:	5bc72703          	lw	a4,1468(a4) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80002adc:	00071463          	bnez	a4,80002ae4 <z_reschedule_irqlock+0x10>
80002ae0:	f58fd06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80002ae4:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ae8:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002aec:	00008067          	ret

80002af0 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002af0:	00800513          	li	a0,8
80002af4:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80002af8:	00857513          	andi	a0,a0,8
80002afc:	fd9ff06f          	j	80002ad4 <z_reschedule_irqlock>

80002b00 <k_sched_lock>:

void k_sched_lock(void)
{
80002b00:	fe010113          	addi	sp,sp,-32
80002b04:	00812c23          	sw	s0,24(sp)
80002b08:	00112e23          	sw	ra,28(sp)
80002b0c:	00912a23          	sw	s1,20(sp)
80002b10:	01212823          	sw	s2,16(sp)
80002b14:	01312623          	sw	s3,12(sp)
80002b18:	00800413          	li	s0,8
80002b1c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002b20:	800064b7          	lui	s1,0x80006
80002b24:	32c48513          	addi	a0,s1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002b28:	00847413          	andi	s0,s0,8
80002b2c:	1e5010ef          	jal	ra,80004510 <z_spin_lock_valid>
80002b30:	02051e63          	bnez	a0,80002b6c <k_sched_lock+0x6c>
80002b34:	80006937          	lui	s2,0x80006
80002b38:	800065b7          	lui	a1,0x80006
80002b3c:	80006537          	lui	a0,0x80006
80002b40:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80002b44:	04e00693          	li	a3,78
80002b48:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002b4c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002b50:	f59fe0ef          	jal	ra,80001aa8 <printk>
80002b54:	80006537          	lui	a0,0x80006
80002b58:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80002b5c:	f4dfe0ef          	jal	ra,80001aa8 <printk>
80002b60:	04e00593          	li	a1,78
80002b64:	d4490513          	addi	a0,s2,-700
80002b68:	f7dfe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002b6c:	32c48513          	addi	a0,s1,812
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80002b70:	80006937          	lui	s2,0x80006
80002b74:	1f5010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
80002b78:	5bc92783          	lw	a5,1468(s2) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80002b7c:	5bc90913          	addi	s2,s2,1468
80002b80:	02078e63          	beqz	a5,80002bbc <k_sched_lock+0xbc>
80002b84:	800069b7          	lui	s3,0x80006
80002b88:	800065b7          	lui	a1,0x80006
80002b8c:	80006537          	lui	a0,0x80006
80002b90:	f4c58593          	addi	a1,a1,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
80002b94:	10000693          	li	a3,256
80002b98:	f3098613          	addi	a2,s3,-208 # 80005f30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f31>
80002b9c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002ba0:	f09fe0ef          	jal	ra,80001aa8 <printk>
80002ba4:	80006537          	lui	a0,0x80006
80002ba8:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80002bac:	efdfe0ef          	jal	ra,80001aa8 <printk>
80002bb0:	10000593          	li	a1,256
80002bb4:	f3098513          	addi	a0,s3,-208
80002bb8:	f2dfe0ef          	jal	ra,80001ae4 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80002bbc:	00892783          	lw	a5,8(s2)
80002bc0:	00f7c703          	lbu	a4,15(a5)
80002bc4:	00100793          	li	a5,1
80002bc8:	02f71e63          	bne	a4,a5,80002c04 <k_sched_lock+0x104>
80002bcc:	800069b7          	lui	s3,0x80006
80002bd0:	800065b7          	lui	a1,0x80006
80002bd4:	80006537          	lui	a0,0x80006
80002bd8:	f6858593          	addi	a1,a1,-152 # 80005f68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f69>
80002bdc:	10100693          	li	a3,257
80002be0:	f3098613          	addi	a2,s3,-208 # 80005f30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f31>
80002be4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002be8:	ec1fe0ef          	jal	ra,80001aa8 <printk>
80002bec:	80006537          	lui	a0,0x80006
80002bf0:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80002bf4:	eb5fe0ef          	jal	ra,80001aa8 <printk>
80002bf8:	10100593          	li	a1,257
80002bfc:	f3098513          	addi	a0,s3,-208
80002c00:	ee5fe0ef          	jal	ra,80001ae4 <assert_post_action>

	--_current->base.sched_locked;
80002c04:	00892703          	lw	a4,8(s2)
80002c08:	00f74783          	lbu	a5,15(a4)
80002c0c:	fff78793          	addi	a5,a5,-1
80002c10:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002c14:	32c48513          	addi	a0,s1,812
80002c18:	121010ef          	jal	ra,80004538 <z_spin_unlock_valid>
80002c1c:	02051e63          	bnez	a0,80002c58 <k_sched_lock+0x158>
80002c20:	800064b7          	lui	s1,0x80006
80002c24:	800065b7          	lui	a1,0x80006
80002c28:	80006537          	lui	a0,0x80006
80002c2c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80002c30:	06100693          	li	a3,97
80002c34:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002c38:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002c3c:	e6dfe0ef          	jal	ra,80001aa8 <printk>
80002c40:	80006537          	lui	a0,0x80006
80002c44:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80002c48:	e61fe0ef          	jal	ra,80001aa8 <printk>
80002c4c:	06100593          	li	a1,97
80002c50:	d4448513          	addi	a0,s1,-700
80002c54:	e91fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002c58:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80002c5c:	01c12083          	lw	ra,28(sp)
80002c60:	01812403          	lw	s0,24(sp)
80002c64:	01412483          	lw	s1,20(sp)
80002c68:	01012903          	lw	s2,16(sp)
80002c6c:	00c12983          	lw	s3,12(sp)
80002c70:	02010113          	addi	sp,sp,32
80002c74:	00008067          	ret

80002c78 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80002c78:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80002c7c:	2b87a783          	lw	a5,696(a5) # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
{
80002c80:	ff010113          	addi	sp,sp,-16
80002c84:	00812423          	sw	s0,8(sp)
80002c88:	00112623          	sw	ra,12(sp)
80002c8c:	00912223          	sw	s1,4(sp)
80002c90:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80002c94:	02f59863          	bne	a1,a5,80002cc4 <z_priq_dumb_remove+0x4c>
80002c98:	800064b7          	lui	s1,0x80006
80002c9c:	800065b7          	lui	a1,0x80006
80002ca0:	80006537          	lui	a0,0x80006
80002ca4:	0d058593          	addi	a1,a1,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
80002ca8:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002cac:	28c00693          	li	a3,652
80002cb0:	fb848613          	addi	a2,s1,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80002cb4:	df5fe0ef          	jal	ra,80001aa8 <printk>
80002cb8:	28c00593          	li	a1,652
80002cbc:	fb848513          	addi	a0,s1,-72
80002cc0:	e25fe0ef          	jal	ra,80001ae4 <assert_post_action>
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80002cc4:	00442703          	lw	a4,4(s0)
80002cc8:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80002ccc:	00c12083          	lw	ra,12(sp)
80002cd0:	00412483          	lw	s1,4(sp)
80002cd4:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80002cd8:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80002cdc:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80002ce0:	00042223          	sw	zero,4(s0)
80002ce4:	00812403          	lw	s0,8(sp)
80002ce8:	01010113          	addi	sp,sp,16
80002cec:	00008067          	ret

80002cf0 <z_priq_dumb_best>:
	return list->head == list;
80002cf0:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002cf4:	00f51463          	bne	a0,a5,80002cfc <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80002cf8:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80002cfc:	00078513          	mv	a0,a5
80002d00:	00008067          	ret

80002d04 <update_cache>:
{
80002d04:	ff010113          	addi	sp,sp,-16
80002d08:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002d0c:	80006437          	lui	s0,0x80006
{
80002d10:	01212023          	sw	s2,0(sp)
80002d14:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002d18:	5bc40513          	addi	a0,s0,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80002d1c:	02450513          	addi	a0,a0,36
{
80002d20:	00912223          	sw	s1,4(sp)
80002d24:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002d28:	fc9ff0ef          	jal	ra,80002cf0 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80002d2c:	5bc40413          	addi	s0,s0,1468
80002d30:	00050493          	mv	s1,a0
80002d34:	00051463          	bnez	a0,80002d3c <update_cache+0x38>
80002d38:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
80002d3c:	06091e63          	bnez	s2,80002db8 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80002d40:	00842783          	lw	a5,8(s0)
80002d44:	02079e63          	bnez	a5,80002d80 <update_cache+0x7c>
80002d48:	80006937          	lui	s2,0x80006
80002d4c:	800065b7          	lui	a1,0x80006
80002d50:	80006537          	lui	a0,0x80006
80002d54:	fe458593          	addi	a1,a1,-28 # 80005fe4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fe5>
80002d58:	07f00693          	li	a3,127
80002d5c:	fb890613          	addi	a2,s2,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80002d60:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002d64:	d45fe0ef          	jal	ra,80001aa8 <printk>
80002d68:	80006537          	lui	a0,0x80006
80002d6c:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80002d70:	d39fe0ef          	jal	ra,80001aa8 <printk>
80002d74:	07f00593          	li	a1,127
80002d78:	fb890513          	addi	a0,s2,-72
80002d7c:	d69fe0ef          	jal	ra,80001ae4 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80002d80:	00842783          	lw	a5,8(s0)
80002d84:	00d7c703          	lbu	a4,13(a5)
80002d88:	01f77713          	andi	a4,a4,31
80002d8c:	02071663          	bnez	a4,80002db8 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80002d90:	00e7d683          	lhu	a3,14(a5)
80002d94:	07f00713          	li	a4,127
80002d98:	02d77063          	bgeu	a4,a3,80002db8 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80002d9c:	02f42023          	sw	a5,32(s0)
}
80002da0:	00c12083          	lw	ra,12(sp)
80002da4:	00812403          	lw	s0,8(sp)
80002da8:	00412483          	lw	s1,4(sp)
80002dac:	00012903          	lw	s2,0(sp)
80002db0:	01010113          	addi	sp,sp,16
80002db4:	00008067          	ret
		if (th != _current) {
80002db8:	00842783          	lw	a5,8(s0)
80002dbc:	00978463          	beq	a5,s1,80002dc4 <update_cache+0xc0>
			reset_time_slice();
80002dc0:	9a1ff0ef          	jal	ra,80002760 <reset_time_slice>
		_kernel.ready_q.cache = th;
80002dc4:	02942023          	sw	s1,32(s0)
}
80002dc8:	fd9ff06f          	j	80002da0 <update_cache+0x9c>

80002dcc <k_sched_unlock>:
{
80002dcc:	fe010113          	addi	sp,sp,-32
80002dd0:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002dd4:	80006937          	lui	s2,0x80006
80002dd8:	5bc90793          	addi	a5,s2,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80002ddc:	0087a783          	lw	a5,8(a5)
{
80002de0:	00112e23          	sw	ra,28(sp)
80002de4:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002de8:	00f7c783          	lbu	a5,15(a5)
{
80002dec:	00912a23          	sw	s1,20(sp)
80002df0:	01312623          	sw	s3,12(sp)
80002df4:	5bc90913          	addi	s2,s2,1468
	__ASSERT(_current->base.sched_locked != 0, "");
80002df8:	02079e63          	bnez	a5,80002e34 <k_sched_unlock+0x68>
80002dfc:	80006437          	lui	s0,0x80006
80002e00:	800065b7          	lui	a1,0x80006
80002e04:	80006537          	lui	a0,0x80006
80002e08:	f9058593          	addi	a1,a1,-112 # 80005f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f91>
80002e0c:	22100693          	li	a3,545
80002e10:	fb840613          	addi	a2,s0,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80002e14:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002e18:	c91fe0ef          	jal	ra,80001aa8 <printk>
80002e1c:	80006537          	lui	a0,0x80006
80002e20:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80002e24:	c85fe0ef          	jal	ra,80001aa8 <printk>
80002e28:	22100593          	li	a1,545
80002e2c:	fb840513          	addi	a0,s0,-72
80002e30:	cb5fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80002e34:	00092783          	lw	a5,0(s2)
80002e38:	02078e63          	beqz	a5,80002e74 <k_sched_unlock+0xa8>
80002e3c:	80006437          	lui	s0,0x80006
80002e40:	800065b7          	lui	a1,0x80006
80002e44:	80006537          	lui	a0,0x80006
80002e48:	f4c58593          	addi	a1,a1,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
80002e4c:	22200693          	li	a3,546
80002e50:	fb840613          	addi	a2,s0,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80002e54:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002e58:	c51fe0ef          	jal	ra,80001aa8 <printk>
80002e5c:	80006537          	lui	a0,0x80006
80002e60:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80002e64:	c45fe0ef          	jal	ra,80001aa8 <printk>
80002e68:	22200593          	li	a1,546
80002e6c:	fb840513          	addi	a0,s0,-72
80002e70:	c75fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002e74:	00800413          	li	s0,8
80002e78:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e7c:	800064b7          	lui	s1,0x80006
80002e80:	32c48513          	addi	a0,s1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002e84:	00847413          	andi	s0,s0,8
80002e88:	688010ef          	jal	ra,80004510 <z_spin_lock_valid>
80002e8c:	02051e63          	bnez	a0,80002ec8 <k_sched_unlock+0xfc>
80002e90:	800069b7          	lui	s3,0x80006
80002e94:	800065b7          	lui	a1,0x80006
80002e98:	80006537          	lui	a0,0x80006
80002e9c:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80002ea0:	04e00693          	li	a3,78
80002ea4:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002ea8:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002eac:	bfdfe0ef          	jal	ra,80001aa8 <printk>
80002eb0:	80006537          	lui	a0,0x80006
80002eb4:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80002eb8:	bf1fe0ef          	jal	ra,80001aa8 <printk>
80002ebc:	04e00593          	li	a1,78
80002ec0:	d4498513          	addi	a0,s3,-700
80002ec4:	c21fe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002ec8:	32c48513          	addi	a0,s1,812
80002ecc:	69c010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80002ed0:	00892703          	lw	a4,8(s2)
		update_cache(1);
80002ed4:	00100513          	li	a0,1
		++_current->base.sched_locked;
80002ed8:	00f74783          	lbu	a5,15(a4)
80002edc:	00178793          	addi	a5,a5,1
80002ee0:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80002ee4:	e21ff0ef          	jal	ra,80002d04 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ee8:	32c48513          	addi	a0,s1,812
80002eec:	64c010ef          	jal	ra,80004538 <z_spin_unlock_valid>
80002ef0:	02051e63          	bnez	a0,80002f2c <k_sched_unlock+0x160>
80002ef4:	800064b7          	lui	s1,0x80006
80002ef8:	800065b7          	lui	a1,0x80006
80002efc:	80006537          	lui	a0,0x80006
80002f00:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80002f04:	06100693          	li	a3,97
80002f08:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002f0c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002f10:	b99fe0ef          	jal	ra,80001aa8 <printk>
80002f14:	80006537          	lui	a0,0x80006
80002f18:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80002f1c:	b8dfe0ef          	jal	ra,80001aa8 <printk>
80002f20:	06100593          	li	a1,97
80002f24:	d4448513          	addi	a0,s1,-700
80002f28:	bbdfe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f2c:	30042473          	csrrs	s0,mstatus,s0
}
80002f30:	01812403          	lw	s0,24(sp)
80002f34:	01c12083          	lw	ra,28(sp)
80002f38:	01412483          	lw	s1,20(sp)
80002f3c:	01012903          	lw	s2,16(sp)
80002f40:	00c12983          	lw	s3,12(sp)
80002f44:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80002f48:	ba9ff06f          	j	80002af0 <z_reschedule_unlocked>

80002f4c <z_add_thread_to_ready_q>:
{
80002f4c:	fe010113          	addi	sp,sp,-32
80002f50:	00812c23          	sw	s0,24(sp)
80002f54:	00912a23          	sw	s1,20(sp)
80002f58:	00112e23          	sw	ra,28(sp)
80002f5c:	01212823          	sw	s2,16(sp)
80002f60:	01312623          	sw	s3,12(sp)
80002f64:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f68:	00800493          	li	s1,8
80002f6c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f70:	80006937          	lui	s2,0x80006
80002f74:	32c90513          	addi	a0,s2,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f78:	0084f493          	andi	s1,s1,8
80002f7c:	594010ef          	jal	ra,80004510 <z_spin_lock_valid>
80002f80:	02051e63          	bnez	a0,80002fbc <z_add_thread_to_ready_q+0x70>
80002f84:	800069b7          	lui	s3,0x80006
80002f88:	800065b7          	lui	a1,0x80006
80002f8c:	80006537          	lui	a0,0x80006
80002f90:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80002f94:	04e00693          	li	a3,78
80002f98:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80002f9c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002fa0:	b09fe0ef          	jal	ra,80001aa8 <printk>
80002fa4:	80006537          	lui	a0,0x80006
80002fa8:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80002fac:	afdfe0ef          	jal	ra,80001aa8 <printk>
80002fb0:	04e00593          	li	a1,78
80002fb4:	d4498513          	addi	a0,s3,-700
80002fb8:	b2dfe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002fbc:	32c90513          	addi	a0,s2,812
80002fc0:	5a8010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80002fc4:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80002fc8:	2b87a783          	lw	a5,696(a5) # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
80002fcc:	02f41863          	bne	s0,a5,80002ffc <z_add_thread_to_ready_q+0xb0>
80002fd0:	800069b7          	lui	s3,0x80006
80002fd4:	800065b7          	lui	a1,0x80006
80002fd8:	80006537          	lui	a0,0x80006
80002fdc:	0d058593          	addi	a1,a1,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
80002fe0:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80002fe4:	27600693          	li	a3,630
80002fe8:	fb898613          	addi	a2,s3,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80002fec:	abdfe0ef          	jal	ra,80001aa8 <printk>
80002ff0:	27600593          	li	a1,630
80002ff4:	fb898513          	addi	a0,s3,-72
80002ff8:	aedfe0ef          	jal	ra,80001ae4 <assert_post_action>
	return list->head == list;
80002ffc:	80006737          	lui	a4,0x80006
80003000:	5bc70693          	addi	a3,a4,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80003004:	0246a783          	lw	a5,36(a3)
80003008:	0286a603          	lw	a2,40(a3)
8000300c:	800066b7          	lui	a3,0x80006
80003010:	5e068693          	addi	a3,a3,1504 # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
80003014:	5bc70713          	addi	a4,a4,1468
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003018:	0ad78663          	beq	a5,a3,800030c4 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000301c:	0a078463          	beqz	a5,800030c4 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80003020:	00e40583          	lb	a1,14(s0)
80003024:	00e78503          	lb	a0,14(a5)
80003028:	08a5d863          	bge	a1,a0,800030b8 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
8000302c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003030:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003034:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003038:	00872023          	sw	s0,0(a4)
	successor->prev = node;
8000303c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003040:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80003044:	00000513          	li	a0,0
80003048:	0407e793          	ori	a5,a5,64
8000304c:	00f406a3          	sb	a5,13(s0)
80003050:	cb5ff0ef          	jal	ra,80002d04 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003054:	32c90513          	addi	a0,s2,812
80003058:	4e0010ef          	jal	ra,80004538 <z_spin_unlock_valid>
8000305c:	02051e63          	bnez	a0,80003098 <z_add_thread_to_ready_q+0x14c>
80003060:	80006437          	lui	s0,0x80006
80003064:	800065b7          	lui	a1,0x80006
80003068:	80006537          	lui	a0,0x80006
8000306c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80003070:	06100693          	li	a3,97
80003074:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003078:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
8000307c:	a2dfe0ef          	jal	ra,80001aa8 <printk>
80003080:	80006537          	lui	a0,0x80006
80003084:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80003088:	a21fe0ef          	jal	ra,80001aa8 <printk>
8000308c:	06100593          	li	a1,97
80003090:	d4440513          	addi	a0,s0,-700
80003094:	a51fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003098:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000309c:	01c12083          	lw	ra,28(sp)
800030a0:	01812403          	lw	s0,24(sp)
800030a4:	01412483          	lw	s1,20(sp)
800030a8:	01012903          	lw	s2,16(sp)
800030ac:	00c12983          	lw	s3,12(sp)
800030b0:	02010113          	addi	sp,sp,32
800030b4:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
800030b8:	00f60663          	beq	a2,a5,800030c4 <z_add_thread_to_ready_q+0x178>
800030bc:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800030c0:	f60792e3          	bnez	a5,80003024 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
800030c4:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
800030c8:	02872783          	lw	a5,40(a4)
	node->next = list;
800030cc:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
800030d0:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800030d4:	02872423          	sw	s0,40(a4)
800030d8:	f69ff06f          	j	80003040 <z_add_thread_to_ready_q+0xf4>

800030dc <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
800030dc:	ff052783          	lw	a5,-16(a0)
{
800030e0:	fe010113          	addi	sp,sp,-32
800030e4:	00812c23          	sw	s0,24(sp)
800030e8:	01312623          	sw	s3,12(sp)
800030ec:	00112e23          	sw	ra,28(sp)
800030f0:	00912a23          	sw	s1,20(sp)
800030f4:	01212823          	sw	s2,16(sp)
800030f8:	01412423          	sw	s4,8(sp)
800030fc:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003100:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003104:	0c078463          	beqz	a5,800031cc <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003108:	00800493          	li	s1,8
8000310c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003110:	80006937          	lui	s2,0x80006
80003114:	32c90513          	addi	a0,s2,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80003118:	0084f493          	andi	s1,s1,8
8000311c:	3f4010ef          	jal	ra,80004510 <z_spin_lock_valid>
80003120:	02051e63          	bnez	a0,8000315c <z_thread_timeout+0x80>
80003124:	80006a37          	lui	s4,0x80006
80003128:	800065b7          	lui	a1,0x80006
8000312c:	80006537          	lui	a0,0x80006
80003130:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80003134:	04e00693          	li	a3,78
80003138:	d44a0613          	addi	a2,s4,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
8000313c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003140:	969fe0ef          	jal	ra,80001aa8 <printk>
80003144:	80006537          	lui	a0,0x80006
80003148:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
8000314c:	95dfe0ef          	jal	ra,80001aa8 <printk>
80003150:	04e00593          	li	a1,78
80003154:	d44a0513          	addi	a0,s4,-700
80003158:	98dfe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
8000315c:	32c90513          	addi	a0,s2,812
80003160:	408010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003164:	ff040513          	addi	a0,s0,-16
80003168:	e2cff0ef          	jal	ra,80002794 <pended_on.isra.15>
8000316c:	00098593          	mv	a1,s3
80003170:	b09ff0ef          	jal	ra,80002c78 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003174:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003178:	32c90513          	addi	a0,s2,812
8000317c:	ffd7f793          	andi	a5,a5,-3
80003180:	fef40aa3          	sb	a5,-11(s0)
80003184:	3b4010ef          	jal	ra,80004538 <z_spin_unlock_valid>
80003188:	02051e63          	bnez	a0,800031c4 <z_thread_timeout+0xe8>
8000318c:	80006937          	lui	s2,0x80006
80003190:	800065b7          	lui	a1,0x80006
80003194:	80006537          	lui	a0,0x80006
80003198:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
8000319c:	06100693          	li	a3,97
800031a0:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800031a4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800031a8:	901fe0ef          	jal	ra,80001aa8 <printk>
800031ac:	80006537          	lui	a0,0x80006
800031b0:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
800031b4:	8f5fe0ef          	jal	ra,80001aa8 <printk>
800031b8:	06100593          	li	a1,97
800031bc:	d4490513          	addi	a0,s2,-700
800031c0:	925fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800031c4:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800031c8:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800031cc:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
800031d0:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800031d4:	feb7f793          	andi	a5,a5,-21
800031d8:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
800031dc:	d64ff0ef          	jal	ra,80002740 <z_is_thread_ready>
800031e0:	02050463          	beqz	a0,80003208 <z_thread_timeout+0x12c>
}
800031e4:	01812403          	lw	s0,24(sp)
800031e8:	01c12083          	lw	ra,28(sp)
800031ec:	01412483          	lw	s1,20(sp)
800031f0:	01012903          	lw	s2,16(sp)
800031f4:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
800031f8:	00098513          	mv	a0,s3
800031fc:	00c12983          	lw	s3,12(sp)
80003200:	02010113          	addi	sp,sp,32
80003204:	d49ff06f          	j	80002f4c <z_add_thread_to_ready_q>
80003208:	01c12083          	lw	ra,28(sp)
8000320c:	01812403          	lw	s0,24(sp)
80003210:	01412483          	lw	s1,20(sp)
80003214:	01012903          	lw	s2,16(sp)
80003218:	00c12983          	lw	s3,12(sp)
8000321c:	00812a03          	lw	s4,8(sp)
80003220:	02010113          	addi	sp,sp,32
80003224:	00008067          	ret

80003228 <z_move_thread_to_end_of_prio_q>:
{
80003228:	fe010113          	addi	sp,sp,-32
8000322c:	00812c23          	sw	s0,24(sp)
80003230:	01212823          	sw	s2,16(sp)
80003234:	00112e23          	sw	ra,28(sp)
80003238:	00912a23          	sw	s1,20(sp)
8000323c:	01312623          	sw	s3,12(sp)
80003240:	01412423          	sw	s4,8(sp)
80003244:	01512223          	sw	s5,4(sp)
80003248:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000324c:	00800913          	li	s2,8
80003250:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003254:	800069b7          	lui	s3,0x80006
80003258:	32c98513          	addi	a0,s3,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
8000325c:	00897913          	andi	s2,s2,8
80003260:	2b0010ef          	jal	ra,80004510 <z_spin_lock_valid>
80003264:	02051e63          	bnez	a0,800032a0 <z_move_thread_to_end_of_prio_q+0x78>
80003268:	800064b7          	lui	s1,0x80006
8000326c:	800065b7          	lui	a1,0x80006
80003270:	80006537          	lui	a0,0x80006
80003274:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80003278:	04e00693          	li	a3,78
8000327c:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003280:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003284:	825fe0ef          	jal	ra,80001aa8 <printk>
80003288:	80006537          	lui	a0,0x80006
8000328c:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80003290:	819fe0ef          	jal	ra,80001aa8 <printk>
80003294:	04e00593          	li	a1,78
80003298:	d4448513          	addi	a0,s1,-700
8000329c:	849fe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
800032a0:	32c98513          	addi	a0,s3,812
800032a4:	2c4010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800032a8:	800064b7          	lui	s1,0x80006
800032ac:	5bc48513          	addi	a0,s1,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
800032b0:	00040593          	mv	a1,s0
800032b4:	02450513          	addi	a0,a0,36
800032b8:	9c1ff0ef          	jal	ra,80002c78 <z_priq_dumb_remove>
	return thread == _idle_thread;
800032bc:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
800032c0:	2b87a783          	lw	a5,696(a5) # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
800032c4:	80006a37          	lui	s4,0x80006
800032c8:	5bc48493          	addi	s1,s1,1468
800032cc:	5e0a0a13          	addi	s4,s4,1504 # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
800032d0:	02f41863          	bne	s0,a5,80003300 <z_move_thread_to_end_of_prio_q+0xd8>
800032d4:	80006ab7          	lui	s5,0x80006
800032d8:	800065b7          	lui	a1,0x80006
800032dc:	80006537          	lui	a0,0x80006
800032e0:	0d058593          	addi	a1,a1,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
800032e4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800032e8:	27600693          	li	a3,630
800032ec:	fb8a8613          	addi	a2,s5,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
800032f0:	fb8fe0ef          	jal	ra,80001aa8 <printk>
800032f4:	27600593          	li	a1,630
800032f8:	fb8a8513          	addi	a0,s5,-72
800032fc:	fe8fe0ef          	jal	ra,80001ae4 <assert_post_action>
	return list->head == list;
80003300:	0244a783          	lw	a5,36(s1)
80003304:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003308:	0b478e63          	beq	a5,s4,800033c4 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000330c:	0a078c63          	beqz	a5,800033c4 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003310:	00e40683          	lb	a3,14(s0)
80003314:	00e78603          	lb	a2,14(a5)
80003318:	0ac6d063          	bge	a3,a2,800033b8 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
8000331c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003320:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003324:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003328:	00872023          	sw	s0,0(a4)
	successor->prev = node;
8000332c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003330:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003334:	0084a503          	lw	a0,8(s1)
80003338:	0407e793          	ori	a5,a5,64
8000333c:	40850533          	sub	a0,a0,s0
80003340:	00153513          	seqz	a0,a0
80003344:	00f406a3          	sb	a5,13(s0)
80003348:	9bdff0ef          	jal	ra,80002d04 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000334c:	32c98513          	addi	a0,s3,812
80003350:	1e8010ef          	jal	ra,80004538 <z_spin_unlock_valid>
80003354:	02051e63          	bnez	a0,80003390 <z_move_thread_to_end_of_prio_q+0x168>
80003358:	80006437          	lui	s0,0x80006
8000335c:	800065b7          	lui	a1,0x80006
80003360:	80006537          	lui	a0,0x80006
80003364:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80003368:	06100693          	li	a3,97
8000336c:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003370:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003374:	f34fe0ef          	jal	ra,80001aa8 <printk>
80003378:	80006537          	lui	a0,0x80006
8000337c:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80003380:	f28fe0ef          	jal	ra,80001aa8 <printk>
80003384:	06100593          	li	a1,97
80003388:	d4440513          	addi	a0,s0,-700
8000338c:	f58fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003390:	30092973          	csrrs	s2,mstatus,s2
}
80003394:	01c12083          	lw	ra,28(sp)
80003398:	01812403          	lw	s0,24(sp)
8000339c:	01412483          	lw	s1,20(sp)
800033a0:	01012903          	lw	s2,16(sp)
800033a4:	00c12983          	lw	s3,12(sp)
800033a8:	00812a03          	lw	s4,8(sp)
800033ac:	00412a83          	lw	s5,4(sp)
800033b0:	02010113          	addi	sp,sp,32
800033b4:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
800033b8:	00e78663          	beq	a5,a4,800033c4 <z_move_thread_to_end_of_prio_q+0x19c>
800033bc:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800033c0:	f4079ae3          	bnez	a5,80003314 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
800033c4:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
800033c8:	0284a783          	lw	a5,40(s1)
	node->next = list;
800033cc:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800033d0:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800033d4:	0284a423          	sw	s0,40(s1)
800033d8:	f59ff06f          	j	80003330 <z_move_thread_to_end_of_prio_q+0x108>

800033dc <z_time_slice>:
	if (slice_time && sliceable(_current)) {
800033dc:	800067b7          	lui	a5,0x80006
800033e0:	3347a783          	lw	a5,820(a5) # 80006334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006335>
800033e4:	06078663          	beqz	a5,80003450 <z_time_slice+0x74>
800033e8:	800067b7          	lui	a5,0x80006
800033ec:	5bc78793          	addi	a5,a5,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
800033f0:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
800033f4:	07f00693          	li	a3,127
800033f8:	00e75603          	lhu	a2,14(a4)
800033fc:	04c6ea63          	bltu	a3,a2,80003450 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003400:	800066b7          	lui	a3,0x80006
80003404:	00e70603          	lb	a2,14(a4)
80003408:	3306a683          	lw	a3,816(a3) # 80006330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006331>
8000340c:	04d64263          	blt	a2,a3,80003450 <z_time_slice+0x74>
	return thread == _idle_thread;
80003410:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
80003414:	2b86a683          	lw	a3,696(a3) # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
80003418:	02d70c63          	beq	a4,a3,80003450 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
8000341c:	01872683          	lw	a3,24(a4)
80003420:	02069863          	bnez	a3,80003450 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003424:	0107a683          	lw	a3,16(a5)
80003428:	02d54063          	blt	a0,a3,80003448 <z_time_slice+0x6c>
{
8000342c:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003430:	00070513          	mv	a0,a4
{
80003434:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003438:	df1ff0ef          	jal	ra,80003228 <z_move_thread_to_end_of_prio_q>
}
8000343c:	00c12083          	lw	ra,12(sp)
80003440:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003444:	b1cff06f          	j	80002760 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003448:	40a686b3          	sub	a3,a3,a0
8000344c:	00d7a823          	sw	a3,16(a5)
80003450:	00008067          	ret

80003454 <z_remove_thread_from_ready_q>:
{
80003454:	fe010113          	addi	sp,sp,-32
80003458:	00812c23          	sw	s0,24(sp)
8000345c:	01312623          	sw	s3,12(sp)
80003460:	00112e23          	sw	ra,28(sp)
80003464:	00912a23          	sw	s1,20(sp)
80003468:	01212823          	sw	s2,16(sp)
8000346c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003470:	00800413          	li	s0,8
80003474:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003478:	800064b7          	lui	s1,0x80006
8000347c:	32c48513          	addi	a0,s1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80003480:	00847413          	andi	s0,s0,8
80003484:	08c010ef          	jal	ra,80004510 <z_spin_lock_valid>
80003488:	02051e63          	bnez	a0,800034c4 <z_remove_thread_from_ready_q+0x70>
8000348c:	80006937          	lui	s2,0x80006
80003490:	800065b7          	lui	a1,0x80006
80003494:	80006537          	lui	a0,0x80006
80003498:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
8000349c:	04e00693          	li	a3,78
800034a0:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800034a4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800034a8:	e00fe0ef          	jal	ra,80001aa8 <printk>
800034ac:	80006537          	lui	a0,0x80006
800034b0:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
800034b4:	df4fe0ef          	jal	ra,80001aa8 <printk>
800034b8:	04e00593          	li	a1,78
800034bc:	d4490513          	addi	a0,s2,-700
800034c0:	e24fe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
800034c4:	32c48513          	addi	a0,s1,812
800034c8:	0a0010ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
800034cc:	00d9c783          	lbu	a5,13(s3)
800034d0:	80006937          	lui	s2,0x80006
800034d4:	5bc90913          	addi	s2,s2,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
800034d8:	0407f793          	andi	a5,a5,64
800034dc:	00078e63          	beqz	a5,800034f8 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
800034e0:	00098593          	mv	a1,s3
800034e4:	02490513          	addi	a0,s2,36
800034e8:	f90ff0ef          	jal	ra,80002c78 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
800034ec:	00d9c783          	lbu	a5,13(s3)
800034f0:	fbf7f793          	andi	a5,a5,-65
800034f4:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
800034f8:	00892503          	lw	a0,8(s2)
800034fc:	41350533          	sub	a0,a0,s3
80003500:	00153513          	seqz	a0,a0
80003504:	801ff0ef          	jal	ra,80002d04 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003508:	32c48513          	addi	a0,s1,812
8000350c:	02c010ef          	jal	ra,80004538 <z_spin_unlock_valid>
80003510:	02051e63          	bnez	a0,8000354c <z_remove_thread_from_ready_q+0xf8>
80003514:	800064b7          	lui	s1,0x80006
80003518:	800065b7          	lui	a1,0x80006
8000351c:	80006537          	lui	a0,0x80006
80003520:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80003524:	06100693          	li	a3,97
80003528:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
8000352c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003530:	d78fe0ef          	jal	ra,80001aa8 <printk>
80003534:	80006537          	lui	a0,0x80006
80003538:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
8000353c:	d6cfe0ef          	jal	ra,80001aa8 <printk>
80003540:	06100593          	li	a1,97
80003544:	d4448513          	addi	a0,s1,-700
80003548:	d9cfe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000354c:	30042473          	csrrs	s0,mstatus,s0
}
80003550:	01c12083          	lw	ra,28(sp)
80003554:	01812403          	lw	s0,24(sp)
80003558:	01412483          	lw	s1,20(sp)
8000355c:	01012903          	lw	s2,16(sp)
80003560:	00c12983          	lw	s3,12(sp)
80003564:	02010113          	addi	sp,sp,32
80003568:	00008067          	ret

8000356c <pend>:
{
8000356c:	fe010113          	addi	sp,sp,-32
80003570:	00812c23          	sw	s0,24(sp)
80003574:	00912a23          	sw	s1,20(sp)
80003578:	00050413          	mv	s0,a0
8000357c:	01212823          	sw	s2,16(sp)
80003580:	00112e23          	sw	ra,28(sp)
80003584:	01312623          	sw	s3,12(sp)
80003588:	00058493          	mv	s1,a1
8000358c:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003590:	ec5ff0ef          	jal	ra,80003454 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003594:	00d44783          	lbu	a5,13(s0)
80003598:	0027e793          	ori	a5,a5,2
8000359c:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
800035a0:	06048663          	beqz	s1,8000360c <pend+0xa0>
	return thread == _idle_thread;
800035a4:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
800035a8:	2b87a783          	lw	a5,696(a5) # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
		thread->base.pended_on = wait_q;
800035ac:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
800035b0:	02f41863          	bne	s0,a5,800035e0 <pend+0x74>
800035b4:	800069b7          	lui	s3,0x80006
800035b8:	800065b7          	lui	a1,0x80006
800035bc:	80006537          	lui	a0,0x80006
800035c0:	0d058593          	addi	a1,a1,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
800035c4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800035c8:	27600693          	li	a3,630
800035cc:	fb898613          	addi	a2,s3,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
800035d0:	cd8fe0ef          	jal	ra,80001aa8 <printk>
800035d4:	27600593          	li	a1,630
800035d8:	fb898513          	addi	a0,s3,-72
800035dc:	d08fe0ef          	jal	ra,80001ae4 <assert_post_action>
	return list->head == list;
800035e0:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800035e4:	06f48c63          	beq	s1,a5,8000365c <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800035e8:	06078a63          	beqz	a5,8000365c <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
800035ec:	00e40703          	lb	a4,14(s0)
800035f0:	00e78683          	lb	a3,14(a5)
800035f4:	04d75c63          	bge	a4,a3,8000364c <pend+0xe0>
	node->prev = successor->prev;
800035f8:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800035fc:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003600:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003604:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003608:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
8000360c:	fff00793          	li	a5,-1
80003610:	06f90463          	beq	s2,a5,80003678 <pend+0x10c>
80003614:	00a00593          	li	a1,10
80003618:	00990513          	addi	a0,s2,9
8000361c:	b2cfd0ef          	jal	ra,80000948 <__divsi3>

extern void z_thread_timeout(struct _timeout *to);

static inline void z_add_thread_timeout(struct k_thread *th, s32_t ticks)
{
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003620:	00150613          	addi	a2,a0,1
80003624:	01840513          	addi	a0,s0,24
}
80003628:	01812403          	lw	s0,24(sp)
8000362c:	01c12083          	lw	ra,28(sp)
80003630:	01412483          	lw	s1,20(sp)
80003634:	01012903          	lw	s2,16(sp)
80003638:	00c12983          	lw	s3,12(sp)
8000363c:	800035b7          	lui	a1,0x80003
80003640:	0dc58593          	addi	a1,a1,220 # 800030dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800030dd>
80003644:	02010113          	addi	sp,sp,32
80003648:	4100106f          	j	80004a58 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
8000364c:	0044a683          	lw	a3,4(s1)
80003650:	00d78663          	beq	a5,a3,8000365c <pend+0xf0>
80003654:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003658:	f8079ce3          	bnez	a5,800035f0 <pend+0x84>
	node->prev = list->tail;
8000365c:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003660:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003664:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003668:	0044a783          	lw	a5,4(s1)
8000366c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003670:	0084a223          	sw	s0,4(s1)
80003674:	f99ff06f          	j	8000360c <pend+0xa0>
}
80003678:	01c12083          	lw	ra,28(sp)
8000367c:	01812403          	lw	s0,24(sp)
80003680:	01412483          	lw	s1,20(sp)
80003684:	01012903          	lw	s2,16(sp)
80003688:	00c12983          	lw	s3,12(sp)
8000368c:	02010113          	addi	sp,sp,32
80003690:	00008067          	ret

80003694 <z_pend_curr>:
{
80003694:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003698:	800067b7          	lui	a5,0x80006
{
8000369c:	00812423          	sw	s0,8(sp)
800036a0:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
800036a4:	5c47a503          	lw	a0,1476(a5) # 800065c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c5>
{
800036a8:	00912223          	sw	s1,4(sp)
800036ac:	00058493          	mv	s1,a1
800036b0:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
800036b4:	00068613          	mv	a2,a3
{
800036b8:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
800036bc:	eb1ff0ef          	jal	ra,8000356c <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036c0:	00040513          	mv	a0,s0
800036c4:	675000ef          	jal	ra,80004538 <z_spin_unlock_valid>
800036c8:	02051e63          	bnez	a0,80003704 <z_pend_curr+0x70>
800036cc:	80006437          	lui	s0,0x80006
800036d0:	800065b7          	lui	a1,0x80006
800036d4:	80006537          	lui	a0,0x80006
800036d8:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
800036dc:	07800693          	li	a3,120
800036e0:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800036e4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800036e8:	bc0fe0ef          	jal	ra,80001aa8 <printk>
800036ec:	80006537          	lui	a0,0x80006
800036f0:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
800036f4:	bb4fe0ef          	jal	ra,80001aa8 <printk>
800036f8:	07800593          	li	a1,120
800036fc:	d4440513          	addi	a0,s0,-700
80003700:	be4fe0ef          	jal	ra,80001ae4 <assert_post_action>
}
80003704:	00812403          	lw	s0,8(sp)
80003708:	00c12083          	lw	ra,12(sp)
8000370c:	00048513          	mv	a0,s1
80003710:	00412483          	lw	s1,4(sp)
80003714:	01010113          	addi	sp,sp,16
80003718:	b21fc06f          	j	80000238 <__swap>

8000371c <z_thread_priority_set>:
{
8000371c:	fe010113          	addi	sp,sp,-32
80003720:	00812c23          	sw	s0,24(sp)
80003724:	01212823          	sw	s2,16(sp)
80003728:	01412423          	sw	s4,8(sp)
8000372c:	00112e23          	sw	ra,28(sp)
80003730:	00912a23          	sw	s1,20(sp)
80003734:	01312623          	sw	s3,12(sp)
80003738:	01512223          	sw	s5,4(sp)
8000373c:	01612023          	sw	s6,0(sp)
80003740:	00050413          	mv	s0,a0
80003744:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003748:	00800913          	li	s2,8
8000374c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003750:	800069b7          	lui	s3,0x80006
80003754:	32c98513          	addi	a0,s3,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80003758:	00897913          	andi	s2,s2,8
8000375c:	5b5000ef          	jal	ra,80004510 <z_spin_lock_valid>
80003760:	02051e63          	bnez	a0,8000379c <z_thread_priority_set+0x80>
80003764:	800064b7          	lui	s1,0x80006
80003768:	800065b7          	lui	a1,0x80006
8000376c:	80006537          	lui	a0,0x80006
80003770:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80003774:	04e00693          	li	a3,78
80003778:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
8000377c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003780:	b28fe0ef          	jal	ra,80001aa8 <printk>
80003784:	80006537          	lui	a0,0x80006
80003788:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
8000378c:	b1cfe0ef          	jal	ra,80001aa8 <printk>
80003790:	04e00593          	li	a1,78
80003794:	d4448513          	addi	a0,s1,-700
80003798:	b4cfe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
8000379c:	32c98513          	addi	a0,s3,812
800037a0:	5c9000ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		need_sched = z_is_thread_ready(thread);
800037a4:	00040513          	mv	a0,s0
800037a8:	f99fe0ef          	jal	ra,80002740 <z_is_thread_ready>
800037ac:	018a1a13          	slli	s4,s4,0x18
800037b0:	00050a93          	mv	s5,a0
		if (need_sched) {
800037b4:	418a5a13          	srai	s4,s4,0x18
800037b8:	14050063          	beqz	a0,800038f8 <z_thread_priority_set+0x1dc>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
800037bc:	800064b7          	lui	s1,0x80006
800037c0:	5bc48513          	addi	a0,s1,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
800037c4:	00040593          	mv	a1,s0
800037c8:	02450513          	addi	a0,a0,36
800037cc:	cacff0ef          	jal	ra,80002c78 <z_priq_dumb_remove>
	return thread == _idle_thread;
800037d0:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
800037d4:	2b87a783          	lw	a5,696(a5) # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
			thread->base.prio = prio;
800037d8:	01440723          	sb	s4,14(s0)
	return thread == _idle_thread;
800037dc:	80006a37          	lui	s4,0x80006
800037e0:	5bc48493          	addi	s1,s1,1468
800037e4:	5e0a0a13          	addi	s4,s4,1504 # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
	__ASSERT_NO_MSG(!is_idle(thread));
800037e8:	02f41863          	bne	s0,a5,80003818 <z_thread_priority_set+0xfc>
800037ec:	80006b37          	lui	s6,0x80006
800037f0:	800065b7          	lui	a1,0x80006
800037f4:	80006537          	lui	a0,0x80006
800037f8:	0d058593          	addi	a1,a1,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
800037fc:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003800:	27600693          	li	a3,630
80003804:	fb8b0613          	addi	a2,s6,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003808:	aa0fe0ef          	jal	ra,80001aa8 <printk>
8000380c:	27600593          	li	a1,630
80003810:	fb8b0513          	addi	a0,s6,-72
80003814:	ad0fe0ef          	jal	ra,80001ae4 <assert_post_action>
	return list->head == list;
80003818:	0244a783          	lw	a5,36(s1)
8000381c:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003820:	0d478063          	beq	a5,s4,800038e0 <z_thread_priority_set+0x1c4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003824:	0a078e63          	beqz	a5,800038e0 <z_thread_priority_set+0x1c4>
	if (t1->base.prio < t2->base.prio) {
80003828:	00e40683          	lb	a3,14(s0)
8000382c:	00e78603          	lb	a2,14(a5)
80003830:	0ac6d263          	bge	a3,a2,800038d4 <z_thread_priority_set+0x1b8>
	node->prev = successor->prev;
80003834:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003838:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
8000383c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003840:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003844:	0087a223          	sw	s0,4(a5)
			update_cache(1);
80003848:	00100513          	li	a0,1
8000384c:	cb8ff0ef          	jal	ra,80002d04 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003850:	32c98513          	addi	a0,s3,812
80003854:	4e5000ef          	jal	ra,80004538 <z_spin_unlock_valid>
80003858:	02051e63          	bnez	a0,80003894 <z_thread_priority_set+0x178>
8000385c:	80006437          	lui	s0,0x80006
80003860:	800065b7          	lui	a1,0x80006
80003864:	80006537          	lui	a0,0x80006
80003868:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
8000386c:	06100693          	li	a3,97
80003870:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003874:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003878:	a30fe0ef          	jal	ra,80001aa8 <printk>
8000387c:	80006537          	lui	a0,0x80006
80003880:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80003884:	a24fe0ef          	jal	ra,80001aa8 <printk>
80003888:	06100593          	li	a1,97
8000388c:	d4440513          	addi	a0,s0,-700
80003890:	a54fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003894:	30092973          	csrrs	s2,mstatus,s2
	if (need_sched && _current->base.sched_locked == 0) {
80003898:	060a8463          	beqz	s5,80003900 <z_thread_priority_set+0x1e4>
8000389c:	800067b7          	lui	a5,0x80006
800038a0:	5c47a783          	lw	a5,1476(a5) # 800065c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c5>
800038a4:	00f7c783          	lbu	a5,15(a5)
800038a8:	04079c63          	bnez	a5,80003900 <z_thread_priority_set+0x1e4>
}
800038ac:	01812403          	lw	s0,24(sp)
800038b0:	01c12083          	lw	ra,28(sp)
800038b4:	01412483          	lw	s1,20(sp)
800038b8:	01012903          	lw	s2,16(sp)
800038bc:	00c12983          	lw	s3,12(sp)
800038c0:	00812a03          	lw	s4,8(sp)
800038c4:	00412a83          	lw	s5,4(sp)
800038c8:	00012b03          	lw	s6,0(sp)
800038cc:	02010113          	addi	sp,sp,32
		z_reschedule_unlocked();
800038d0:	a20ff06f          	j	80002af0 <z_reschedule_unlocked>
	return (node == list->tail) ? NULL : node->next;
800038d4:	00e78663          	beq	a5,a4,800038e0 <z_thread_priority_set+0x1c4>
800038d8:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800038dc:	f40798e3          	bnez	a5,8000382c <z_thread_priority_set+0x110>
	node->prev = list->tail;
800038e0:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
800038e4:	0284a783          	lw	a5,40(s1)
	node->next = list;
800038e8:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800038ec:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800038f0:	0284a423          	sw	s0,40(s1)
800038f4:	f55ff06f          	j	80003848 <z_thread_priority_set+0x12c>
			thread->base.prio = prio;
800038f8:	01440723          	sb	s4,14(s0)
800038fc:	f55ff06f          	j	80003850 <z_thread_priority_set+0x134>
}
80003900:	01c12083          	lw	ra,28(sp)
80003904:	01812403          	lw	s0,24(sp)
80003908:	01412483          	lw	s1,20(sp)
8000390c:	01012903          	lw	s2,16(sp)
80003910:	00c12983          	lw	s3,12(sp)
80003914:	00812a03          	lw	s4,8(sp)
80003918:	00412a83          	lw	s5,4(sp)
8000391c:	00012b03          	lw	s6,0(sp)
80003920:	02010113          	addi	sp,sp,32
80003924:	00008067          	ret

80003928 <z_unpend_first_thread>:
{
80003928:	fe010113          	addi	sp,sp,-32
8000392c:	01212823          	sw	s2,16(sp)
80003930:	01312623          	sw	s3,12(sp)
80003934:	00112e23          	sw	ra,28(sp)
80003938:	00812c23          	sw	s0,24(sp)
8000393c:	00912a23          	sw	s1,20(sp)
80003940:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003944:	00800913          	li	s2,8
80003948:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000394c:	800064b7          	lui	s1,0x80006
80003950:	32c48513          	addi	a0,s1,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80003954:	00897913          	andi	s2,s2,8
80003958:	3b9000ef          	jal	ra,80004510 <z_spin_lock_valid>
8000395c:	02051e63          	bnez	a0,80003998 <z_unpend_first_thread+0x70>
80003960:	80006437          	lui	s0,0x80006
80003964:	800065b7          	lui	a1,0x80006
80003968:	80006537          	lui	a0,0x80006
8000396c:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80003970:	04e00693          	li	a3,78
80003974:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003978:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
8000397c:	92cfe0ef          	jal	ra,80001aa8 <printk>
80003980:	80006537          	lui	a0,0x80006
80003984:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80003988:	920fe0ef          	jal	ra,80001aa8 <printk>
8000398c:	04e00593          	li	a1,78
80003990:	d4440513          	addi	a0,s0,-700
80003994:	950fe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003998:	32c48513          	addi	a0,s1,812
8000399c:	3cd000ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
800039a0:	00098513          	mv	a0,s3
800039a4:	b4cff0ef          	jal	ra,80002cf0 <z_priq_dumb_best>
800039a8:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800039ac:	32c48513          	addi	a0,s1,812
800039b0:	389000ef          	jal	ra,80004538 <z_spin_unlock_valid>
800039b4:	02051e63          	bnez	a0,800039f0 <z_unpend_first_thread+0xc8>
800039b8:	800069b7          	lui	s3,0x80006
800039bc:	800065b7          	lui	a1,0x80006
800039c0:	80006537          	lui	a0,0x80006
800039c4:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
800039c8:	06100693          	li	a3,97
800039cc:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800039d0:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800039d4:	8d4fe0ef          	jal	ra,80001aa8 <printk>
800039d8:	80006537          	lui	a0,0x80006
800039dc:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
800039e0:	8c8fe0ef          	jal	ra,80001aa8 <printk>
800039e4:	06100593          	li	a1,97
800039e8:	d4498513          	addi	a0,s3,-700
800039ec:	8f8fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800039f0:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
800039f4:	0c040663          	beqz	s0,80003ac0 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800039f8:	00800913          	li	s2,8
800039fc:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a00:	32c48513          	addi	a0,s1,812
	key = (mstatus & SOC_MSTATUS_IEN);
80003a04:	00897913          	andi	s2,s2,8
80003a08:	309000ef          	jal	ra,80004510 <z_spin_lock_valid>
80003a0c:	02051e63          	bnez	a0,80003a48 <z_unpend_first_thread+0x120>
80003a10:	800069b7          	lui	s3,0x80006
80003a14:	800065b7          	lui	a1,0x80006
80003a18:	80006537          	lui	a0,0x80006
80003a1c:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80003a20:	04e00693          	li	a3,78
80003a24:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003a28:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003a2c:	87cfe0ef          	jal	ra,80001aa8 <printk>
80003a30:	80006537          	lui	a0,0x80006
80003a34:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80003a38:	870fe0ef          	jal	ra,80001aa8 <printk>
80003a3c:	04e00593          	li	a1,78
80003a40:	d4498513          	addi	a0,s3,-700
80003a44:	8a0fe0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003a48:	32c48513          	addi	a0,s1,812
80003a4c:	31d000ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003a50:	00840513          	addi	a0,s0,8
80003a54:	d41fe0ef          	jal	ra,80002794 <pended_on.isra.15>
80003a58:	00040593          	mv	a1,s0
80003a5c:	a1cff0ef          	jal	ra,80002c78 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003a60:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a64:	32c48513          	addi	a0,s1,812
80003a68:	ffd7f793          	andi	a5,a5,-3
80003a6c:	00f406a3          	sb	a5,13(s0)
80003a70:	2c9000ef          	jal	ra,80004538 <z_spin_unlock_valid>
80003a74:	02051e63          	bnez	a0,80003ab0 <z_unpend_first_thread+0x188>
80003a78:	800064b7          	lui	s1,0x80006
80003a7c:	800065b7          	lui	a1,0x80006
80003a80:	80006537          	lui	a0,0x80006
80003a84:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80003a88:	06100693          	li	a3,97
80003a8c:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003a90:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003a94:	814fe0ef          	jal	ra,80001aa8 <printk>
80003a98:	80006537          	lui	a0,0x80006
80003a9c:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80003aa0:	808fe0ef          	jal	ra,80001aa8 <printk>
80003aa4:	06100593          	li	a1,97
80003aa8:	d4448513          	addi	a0,s1,-700
80003aac:	838fe0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ab0:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003ab4:	00042423          	sw	zero,8(s0)
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003ab8:	01840513          	addi	a0,s0,24
80003abc:	1c8010ef          	jal	ra,80004c84 <z_abort_timeout>
}
80003ac0:	00040513          	mv	a0,s0
80003ac4:	01c12083          	lw	ra,28(sp)
80003ac8:	01812403          	lw	s0,24(sp)
80003acc:	01412483          	lw	s1,20(sp)
80003ad0:	01012903          	lw	s2,16(sp)
80003ad4:	00c12983          	lw	s3,12(sp)
80003ad8:	02010113          	addi	sp,sp,32
80003adc:	00008067          	ret

80003ae0 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003ae0:	800067b7          	lui	a5,0x80006
80003ae4:	5bc78793          	addi	a5,a5,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80003ae8:	02478713          	addi	a4,a5,36
80003aec:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003af0:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003af4:	00000593          	li	a1,0
80003af8:	00000513          	li	a0,0
80003afc:	cf9fe06f          	j	800027f4 <k_sched_time_slice_set>

80003b00 <z_impl_k_thread_priority_set>:
Z_SYSCALL_HANDLER1_SIMPLE(k_thread_priority_get, K_OBJ_THREAD,
			  struct k_thread *);
#endif

void z_impl_k_thread_priority_set(k_tid_t tid, int prio)
{
80003b00:	ff010113          	addi	sp,sp,-16
80003b04:	00812423          	sw	s0,8(sp)
80003b08:	01212023          	sw	s2,0(sp)
80003b0c:	00112623          	sw	ra,12(sp)
80003b10:	00912223          	sw	s1,4(sp)
	/*
	 * Use NULL, since we cannot know what the entry point is (we do not
	 * keep track of it) and idle cannot change its priority.
	 */
	Z_ASSERT_VALID_PRIO(prio, NULL);
80003b14:	01058713          	addi	a4,a1,16
80003b18:	01e00793          	li	a5,30
{
80003b1c:	00050913          	mv	s2,a0
80003b20:	00058413          	mv	s0,a1
	Z_ASSERT_VALID_PRIO(prio, NULL);
80003b24:	04e7f463          	bgeu	a5,a4,80003b6c <z_impl_k_thread_priority_set+0x6c>
80003b28:	800064b7          	lui	s1,0x80006
80003b2c:	800065b7          	lui	a1,0x80006
80003b30:	80006537          	lui	a0,0x80006
80003b34:	34500693          	li	a3,837
80003b38:	fb848613          	addi	a2,s1,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003b3c:	05058593          	addi	a1,a1,80 # 80006050 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006051>
80003b40:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003b44:	f65fd0ef          	jal	ra,80001aa8 <printk>
80003b48:	80006537          	lui	a0,0x80006
80003b4c:	00040593          	mv	a1,s0
80003b50:	cdc50513          	addi	a0,a0,-804 # 80005cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cdd>
80003b54:	ff000693          	li	a3,-16
80003b58:	00e00613          	li	a2,14
80003b5c:	f4dfd0ef          	jal	ra,80001aa8 <printk>
80003b60:	34500593          	li	a1,837
80003b64:	fb848513          	addi	a0,s1,-72
80003b68:	f7dfd0ef          	jal	ra,80001ae4 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80003b6c:	800067b7          	lui	a5,0x80006
80003b70:	5bc7a783          	lw	a5,1468(a5) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80003b74:	02078e63          	beqz	a5,80003bb0 <z_impl_k_thread_priority_set+0xb0>
80003b78:	800064b7          	lui	s1,0x80006
80003b7c:	800065b7          	lui	a1,0x80006
80003b80:	80006537          	lui	a0,0x80006
80003b84:	f4c58593          	addi	a1,a1,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
80003b88:	34600693          	li	a3,838
80003b8c:	fb848613          	addi	a2,s1,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003b90:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003b94:	f15fd0ef          	jal	ra,80001aa8 <printk>
80003b98:	80006537          	lui	a0,0x80006
80003b9c:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80003ba0:	f09fd0ef          	jal	ra,80001aa8 <printk>
80003ba4:	34600593          	li	a1,838
80003ba8:	fb848513          	addi	a0,s1,-72
80003bac:	f39fd0ef          	jal	ra,80001ae4 <assert_post_action>

	struct k_thread *thread = (struct k_thread *)tid;

	z_thread_priority_set(thread, prio);
80003bb0:	00040593          	mv	a1,s0
}
80003bb4:	00812403          	lw	s0,8(sp)
80003bb8:	00c12083          	lw	ra,12(sp)
80003bbc:	00412483          	lw	s1,4(sp)
	z_thread_priority_set(thread, prio);
80003bc0:	00090513          	mv	a0,s2
}
80003bc4:	00012903          	lw	s2,0(sp)
80003bc8:	01010113          	addi	sp,sp,16
	z_thread_priority_set(thread, prio);
80003bcc:	b51ff06f          	j	8000371c <z_thread_priority_set>

80003bd0 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80003bd0:	fe010113          	addi	sp,sp,-32
80003bd4:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80003bd8:	80006437          	lui	s0,0x80006
80003bdc:	5bc42783          	lw	a5,1468(s0) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
{
80003be0:	00112e23          	sw	ra,28(sp)
80003be4:	00912a23          	sw	s1,20(sp)
80003be8:	01212823          	sw	s2,16(sp)
80003bec:	01312623          	sw	s3,12(sp)
80003bf0:	01412423          	sw	s4,8(sp)
80003bf4:	01512223          	sw	s5,4(sp)
80003bf8:	5bc40413          	addi	s0,s0,1468
	__ASSERT(!z_is_in_isr(), "");
80003bfc:	02078e63          	beqz	a5,80003c38 <z_impl_k_yield+0x68>
80003c00:	800064b7          	lui	s1,0x80006
80003c04:	800065b7          	lui	a1,0x80006
80003c08:	80006537          	lui	a0,0x80006
80003c0c:	f4c58593          	addi	a1,a1,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
80003c10:	37e00693          	li	a3,894
80003c14:	fb848613          	addi	a2,s1,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003c18:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003c1c:	e8dfd0ef          	jal	ra,80001aa8 <printk>
80003c20:	80006537          	lui	a0,0x80006
80003c24:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80003c28:	e81fd0ef          	jal	ra,80001aa8 <printk>
80003c2c:	37e00593          	li	a1,894
80003c30:	fb848513          	addi	a0,s1,-72
80003c34:	eb1fd0ef          	jal	ra,80001ae4 <assert_post_action>
	return thread == _idle_thread;
80003c38:	800067b7          	lui	a5,0x80006

	if (!is_idle(_current)) {
80003c3c:	00842683          	lw	a3,8(s0)
80003c40:	2b87a703          	lw	a4,696(a5) # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
80003c44:	00078a13          	mv	s4,a5
80003c48:	12e68663          	beq	a3,a4,80003d74 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c4c:	00800913          	li	s2,8
80003c50:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c54:	800069b7          	lui	s3,0x80006
80003c58:	32c98513          	addi	a0,s3,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c5c:	00897913          	andi	s2,s2,8
80003c60:	0b1000ef          	jal	ra,80004510 <z_spin_lock_valid>
80003c64:	02051e63          	bnez	a0,80003ca0 <z_impl_k_yield+0xd0>
80003c68:	800064b7          	lui	s1,0x80006
80003c6c:	800065b7          	lui	a1,0x80006
80003c70:	80006537          	lui	a0,0x80006
80003c74:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80003c78:	04e00693          	li	a3,78
80003c7c:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003c80:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003c84:	e25fd0ef          	jal	ra,80001aa8 <printk>
80003c88:	80006537          	lui	a0,0x80006
80003c8c:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80003c90:	e19fd0ef          	jal	ra,80001aa8 <printk>
80003c94:	04e00593          	li	a1,78
80003c98:	d4448513          	addi	a0,s1,-700
80003c9c:	e49fd0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003ca0:	32c98513          	addi	a0,s3,812
80003ca4:	0c5000ef          	jal	ra,80004568 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80003ca8:	00842583          	lw	a1,8(s0)
80003cac:	02440513          	addi	a0,s0,36
80003cb0:	fc9fe0ef          	jal	ra,80002c78 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80003cb4:	2b8a2783          	lw	a5,696(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80003cb8:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
80003cbc:	80006a37          	lui	s4,0x80006
80003cc0:	5e0a0a13          	addi	s4,s4,1504 # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
	__ASSERT_NO_MSG(!is_idle(thread));
80003cc4:	02f49863          	bne	s1,a5,80003cf4 <z_impl_k_yield+0x124>
80003cc8:	80006ab7          	lui	s5,0x80006
80003ccc:	800065b7          	lui	a1,0x80006
80003cd0:	80006537          	lui	a0,0x80006
80003cd4:	0d058593          	addi	a1,a1,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
80003cd8:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003cdc:	27600693          	li	a3,630
80003ce0:	fb8a8613          	addi	a2,s5,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003ce4:	dc5fd0ef          	jal	ra,80001aa8 <printk>
80003ce8:	27600593          	li	a1,630
80003cec:	fb8a8513          	addi	a0,s5,-72
80003cf0:	df5fd0ef          	jal	ra,80001ae4 <assert_post_action>
	return list->head == list;
80003cf4:	02442783          	lw	a5,36(s0)
80003cf8:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003cfc:	0b478a63          	beq	a5,s4,80003db0 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003d00:	0a078863          	beqz	a5,80003db0 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
80003d04:	00e48683          	lb	a3,14(s1)
80003d08:	00e78603          	lb	a2,14(a5)
80003d0c:	08c6dc63          	bge	a3,a2,80003da4 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
80003d10:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003d14:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
80003d18:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
80003d1c:	00972023          	sw	s1,0(a4)
	successor->prev = node;
80003d20:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80003d24:	00100513          	li	a0,1
80003d28:	fddfe0ef          	jal	ra,80002d04 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003d2c:	32c98513          	addi	a0,s3,812
80003d30:	009000ef          	jal	ra,80004538 <z_spin_unlock_valid>
80003d34:	02051e63          	bnez	a0,80003d70 <z_impl_k_yield+0x1a0>
80003d38:	80006437          	lui	s0,0x80006
80003d3c:	800065b7          	lui	a1,0x80006
80003d40:	80006537          	lui	a0,0x80006
80003d44:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80003d48:	06100693          	li	a3,97
80003d4c:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003d50:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003d54:	d55fd0ef          	jal	ra,80001aa8 <printk>
80003d58:	80006537          	lui	a0,0x80006
80003d5c:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80003d60:	d49fd0ef          	jal	ra,80001aa8 <printk>
80003d64:	06100593          	li	a1,97
80003d68:	d4440513          	addi	a0,s0,-700
80003d6c:	d79fd0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003d70:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d74:	00800513          	li	a0,8
80003d78:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
80003d7c:	01812403          	lw	s0,24(sp)
80003d80:	01c12083          	lw	ra,28(sp)
80003d84:	01412483          	lw	s1,20(sp)
80003d88:	01012903          	lw	s2,16(sp)
80003d8c:	00c12983          	lw	s3,12(sp)
80003d90:	00812a03          	lw	s4,8(sp)
80003d94:	00412a83          	lw	s5,4(sp)
80003d98:	00857513          	andi	a0,a0,8
80003d9c:	02010113          	addi	sp,sp,32
80003da0:	c98fc06f          	j	80000238 <__swap>
	return (node == list->tail) ? NULL : node->next;
80003da4:	00e78663          	beq	a5,a4,80003db0 <z_impl_k_yield+0x1e0>
80003da8:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003dac:	f4079ee3          	bnez	a5,80003d08 <z_impl_k_yield+0x138>
	node->prev = list->tail;
80003db0:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80003db4:	02842783          	lw	a5,40(s0)
	node->next = list;
80003db8:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80003dbc:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80003dc0:	02942423          	sw	s1,40(s0)
80003dc4:	f61ff06f          	j	80003d24 <z_impl_k_yield+0x154>

80003dc8 <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
80003dc8:	fd010113          	addi	sp,sp,-48
80003dcc:	02812423          	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80003dd0:	80006437          	lui	s0,0x80006
80003dd4:	5bc42783          	lw	a5,1468(s0) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
{
80003dd8:	02912223          	sw	s1,36(sp)
80003ddc:	02112623          	sw	ra,44(sp)
80003de0:	03212023          	sw	s2,32(sp)
80003de4:	01312e23          	sw	s3,28(sp)
80003de8:	01412c23          	sw	s4,24(sp)
80003dec:	00050493          	mv	s1,a0
80003df0:	5bc40413          	addi	s0,s0,1468
	__ASSERT(!z_is_in_isr(), "");
80003df4:	02078e63          	beqz	a5,80003e30 <z_impl_k_sleep+0x68>
80003df8:	80006937          	lui	s2,0x80006
80003dfc:	800065b7          	lui	a1,0x80006
80003e00:	80006537          	lui	a0,0x80006
80003e04:	f4c58593          	addi	a1,a1,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
80003e08:	39900693          	li	a3,921
80003e0c:	fb890613          	addi	a2,s2,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003e10:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003e14:	c95fd0ef          	jal	ra,80001aa8 <printk>
80003e18:	80006537          	lui	a0,0x80006
80003e1c:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80003e20:	c89fd0ef          	jal	ra,80001aa8 <printk>
80003e24:	39900593          	li	a1,921
80003e28:	fb890513          	addi	a0,s2,-72
80003e2c:	cb9fd0ef          	jal	ra,80001ae4 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80003e30:	fff00793          	li	a5,-1
80003e34:	1af49463          	bne	s1,a5,80003fdc <z_impl_k_sleep+0x214>
80003e38:	80006937          	lui	s2,0x80006
80003e3c:	800065b7          	lui	a1,0x80006
80003e40:	80006537          	lui	a0,0x80006
80003e44:	00458593          	addi	a1,a1,4 # 80006004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006005>
80003e48:	39a00693          	li	a3,922
80003e4c:	fb890613          	addi	a2,s2,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003e50:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003e54:	c55fd0ef          	jal	ra,80001aa8 <printk>
80003e58:	80006537          	lui	a0,0x80006
80003e5c:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80003e60:	c49fd0ef          	jal	ra,80001aa8 <printk>
80003e64:	39a00593          	li	a1,922
80003e68:	fb890513          	addi	a0,s2,-72
80003e6c:	c79fd0ef          	jal	ra,80001ae4 <assert_post_action>
80003e70:	00a00593          	li	a1,10
80003e74:	00948513          	addi	a0,s1,9
80003e78:	ad1fc0ef          	jal	ra,80000948 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80003e7c:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80003e80:	43c010ef          	jal	ra,800052bc <z_tick_get_32>
80003e84:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
80003e88:	00012623          	sw	zero,12(sp)
80003e8c:	00800493          	li	s1,8
80003e90:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e94:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003e98:	0084f493          	andi	s1,s1,8
80003e9c:	674000ef          	jal	ra,80004510 <z_spin_lock_valid>
80003ea0:	02051e63          	bnez	a0,80003edc <z_impl_k_sleep+0x114>
80003ea4:	80006a37          	lui	s4,0x80006
80003ea8:	800065b7          	lui	a1,0x80006
80003eac:	80006537          	lui	a0,0x80006
80003eb0:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80003eb4:	04e00693          	li	a3,78
80003eb8:	d44a0613          	addi	a2,s4,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003ebc:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003ec0:	be9fd0ef          	jal	ra,80001aa8 <printk>
80003ec4:	80006537          	lui	a0,0x80006
80003ec8:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80003ecc:	bddfd0ef          	jal	ra,80001aa8 <printk>
80003ed0:	04e00593          	li	a1,78
80003ed4:	d44a0513          	addi	a0,s4,-700
80003ed8:	c0dfd0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003edc:	00c10513          	addi	a0,sp,12
80003ee0:	688000ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
80003ee4:	00842503          	lw	a0,8(s0)
80003ee8:	d6cff0ef          	jal	ra,80003454 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003eec:	00842503          	lw	a0,8(s0)
80003ef0:	800035b7          	lui	a1,0x80003
80003ef4:	00098613          	mv	a2,s3
80003ef8:	01850513          	addi	a0,a0,24
80003efc:	0dc58593          	addi	a1,a1,220 # 800030dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800030dd>
80003f00:	359000ef          	jal	ra,80004a58 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
80003f04:	00842703          	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f08:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
80003f0c:	00d74783          	lbu	a5,13(a4)
80003f10:	0107e793          	ori	a5,a5,16
80003f14:	00f706a3          	sb	a5,13(a4)
80003f18:	620000ef          	jal	ra,80004538 <z_spin_unlock_valid>
80003f1c:	02051e63          	bnez	a0,80003f58 <z_impl_k_sleep+0x190>
80003f20:	800069b7          	lui	s3,0x80006
80003f24:	800065b7          	lui	a1,0x80006
80003f28:	80006537          	lui	a0,0x80006
80003f2c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80003f30:	07800693          	li	a3,120
80003f34:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80003f38:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003f3c:	b6dfd0ef          	jal	ra,80001aa8 <printk>
80003f40:	80006537          	lui	a0,0x80006
80003f44:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80003f48:	b61fd0ef          	jal	ra,80001aa8 <printk>
80003f4c:	07800593          	li	a1,120
80003f50:	d4498513          	addi	a0,s3,-700
80003f54:	b91fd0ef          	jal	ra,80001ae4 <assert_post_action>
80003f58:	00048513          	mv	a0,s1
80003f5c:	adcfc0ef          	jal	ra,80000238 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80003f60:	00842783          	lw	a5,8(s0)
80003f64:	00d7c783          	lbu	a5,13(a5)
80003f68:	0107f793          	andi	a5,a5,16
80003f6c:	02078e63          	beqz	a5,80003fa8 <z_impl_k_sleep+0x1e0>
80003f70:	80006437          	lui	s0,0x80006
80003f74:	800065b7          	lui	a1,0x80006
80003f78:	80006537          	lui	a0,0x80006
80003f7c:	01858593          	addi	a1,a1,24 # 80006018 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006019>
80003f80:	3b700693          	li	a3,951
80003f84:	fb840613          	addi	a2,s0,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80003f88:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80003f8c:	b1dfd0ef          	jal	ra,80001aa8 <printk>
80003f90:	80006537          	lui	a0,0x80006
80003f94:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80003f98:	b11fd0ef          	jal	ra,80001aa8 <printk>
80003f9c:	3b700593          	li	a1,951
80003fa0:	fb840513          	addi	a0,s0,-72
80003fa4:	b41fd0ef          	jal	ra,80001ae4 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
80003fa8:	314010ef          	jal	ra,800052bc <z_tick_get_32>
80003fac:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80003fb0:	00000493          	li	s1,0
	if (ticks > 0) {
80003fb4:	02a05863          	blez	a0,80003fe4 <z_impl_k_sleep+0x21c>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80003fb8:	3e800613          	li	a2,1000
80003fbc:	00000693          	li	a3,0
80003fc0:	41f55593          	srai	a1,a0,0x1f
80003fc4:	8f5fc0ef          	jal	ra,800008b8 <__muldi3>
80003fc8:	06400613          	li	a2,100
80003fcc:	00000693          	li	a3,0
80003fd0:	af0fc0ef          	jal	ra,800002c0 <__udivdi3>
80003fd4:	00050493          	mv	s1,a0
		return __ticks_to_ms(ticks);
80003fd8:	00c0006f          	j	80003fe4 <z_impl_k_sleep+0x21c>
	if (duration == 0) {
80003fdc:	e8049ae3          	bnez	s1,80003e70 <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80003fe0:	bf1ff0ef          	jal	ra,80003bd0 <z_impl_k_yield>
}
80003fe4:	02c12083          	lw	ra,44(sp)
80003fe8:	02812403          	lw	s0,40(sp)
80003fec:	00048513          	mv	a0,s1
80003ff0:	02012903          	lw	s2,32(sp)
80003ff4:	02412483          	lw	s1,36(sp)
80003ff8:	01c12983          	lw	s3,28(sp)
80003ffc:	01812a03          	lw	s4,24(sp)
80004000:	03010113          	addi	sp,sp,48
80004004:	00008067          	ret

80004008 <z_impl_k_wakeup>:
}
#endif

void z_impl_k_wakeup(k_tid_t thread)
{
	if (z_is_thread_pending(thread)) {
80004008:	00d54783          	lbu	a5,13(a0)
8000400c:	0027f793          	andi	a5,a5,2
80004010:	06079663          	bnez	a5,8000407c <z_impl_k_wakeup+0x74>
{
80004014:	ff010113          	addi	sp,sp,-16
80004018:	00812423          	sw	s0,8(sp)
8000401c:	00050413          	mv	s0,a0
	return z_abort_timeout(&thread->base.timeout);
80004020:	01850513          	addi	a0,a0,24
80004024:	00112623          	sw	ra,12(sp)
80004028:	45d000ef          	jal	ra,80004c84 <z_abort_timeout>
		return;
	}

	if (z_abort_thread_timeout(thread) < 0) {
8000402c:	04054063          	bltz	a0,8000406c <z_impl_k_wakeup+0x64>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80004030:	00d44783          	lbu	a5,13(s0)
	if (z_is_thread_ready(thread)) {
80004034:	00040513          	mv	a0,s0
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80004038:	fef7f793          	andi	a5,a5,-17
8000403c:	00f406a3          	sb	a5,13(s0)
	if (z_is_thread_ready(thread)) {
80004040:	f00fe0ef          	jal	ra,80002740 <z_is_thread_ready>
80004044:	00050663          	beqz	a0,80004050 <z_impl_k_wakeup+0x48>
		z_add_thread_to_ready_q(thread);
80004048:	00040513          	mv	a0,s0
8000404c:	f01fe0ef          	jal	ra,80002f4c <z_add_thread_to_ready_q>
	}

	z_mark_thread_as_not_suspended(thread);
	z_ready_thread(thread);

	if (!z_is_in_isr()) {
80004050:	800067b7          	lui	a5,0x80006
80004054:	5bc7a783          	lw	a5,1468(a5) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80004058:	00079a63          	bnez	a5,8000406c <z_impl_k_wakeup+0x64>

	if (IS_ENABLED(CONFIG_SMP) &&
	    !IS_ENABLED(CONFIG_SCHED_IPI_SUPPORTED)) {
		z_sched_ipi();
	}
}
8000405c:	00812403          	lw	s0,8(sp)
80004060:	00c12083          	lw	ra,12(sp)
80004064:	01010113          	addi	sp,sp,16
		z_reschedule_unlocked();
80004068:	a89fe06f          	j	80002af0 <z_reschedule_unlocked>
}
8000406c:	00c12083          	lw	ra,12(sp)
80004070:	00812403          	lw	s0,8(sp)
80004074:	01010113          	addi	sp,sp,16
80004078:	00008067          	ret
8000407c:	00008067          	ret

80004080 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80004080:	800067b7          	lui	a5,0x80006
80004084:	5c47a503          	lw	a0,1476(a5) # 800065c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c5>
80004088:	00008067          	ret

8000408c <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
8000408c:	fe010113          	addi	sp,sp,-32
80004090:	00812c23          	sw	s0,24(sp)
80004094:	00912a23          	sw	s1,20(sp)
80004098:	01212823          	sw	s2,16(sp)
8000409c:	00112e23          	sw	ra,28(sp)
800040a0:	01312623          	sw	s3,12(sp)
800040a4:	00050413          	mv	s0,a0
800040a8:	00058913          	mv	s2,a1
800040ac:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
800040b0:	02061e63          	bnez	a2,800040ec <z_impl_k_sem_init+0x60>
800040b4:	800069b7          	lui	s3,0x80006
800040b8:	800065b7          	lui	a1,0x80006
800040bc:	80006537          	lui	a0,0x80006
800040c0:	0f458593          	addi	a1,a1,244 # 800060f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f5>
800040c4:	04600693          	li	a3,70
800040c8:	0e498613          	addi	a2,s3,228 # 800060e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e5>
800040cc:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800040d0:	9d9fd0ef          	jal	ra,80001aa8 <printk>
800040d4:	80006537          	lui	a0,0x80006
800040d8:	10050513          	addi	a0,a0,256 # 80006100 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006101>
800040dc:	9cdfd0ef          	jal	ra,80001aa8 <printk>
800040e0:	04600593          	li	a1,70
800040e4:	0e498513          	addi	a0,s3,228
800040e8:	9fdfd0ef          	jal	ra,80001ae4 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
800040ec:	0324fe63          	bgeu	s1,s2,80004128 <z_impl_k_sem_init+0x9c>
800040f0:	800069b7          	lui	s3,0x80006
800040f4:	800065b7          	lui	a1,0x80006
800040f8:	80006537          	lui	a0,0x80006
800040fc:	11858593          	addi	a1,a1,280 # 80006118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006119>
80004100:	04700693          	li	a3,71
80004104:	0e498613          	addi	a2,s3,228 # 800060e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e5>
80004108:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
8000410c:	99dfd0ef          	jal	ra,80001aa8 <printk>
80004110:	80006537          	lui	a0,0x80006
80004114:	13050513          	addi	a0,a0,304 # 80006130 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006131>
80004118:	991fd0ef          	jal	ra,80001aa8 <printk>
8000411c:	04700593          	li	a1,71
80004120:	0e498513          	addi	a0,s3,228
80004124:	9c1fd0ef          	jal	ra,80001ae4 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80004128:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
8000412c:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80004130:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80004134:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80004138:	01c12083          	lw	ra,28(sp)
8000413c:	01812403          	lw	s0,24(sp)
80004140:	01412483          	lw	s1,20(sp)
80004144:	01012903          	lw	s2,16(sp)
80004148:	00c12983          	lw	s3,12(sp)
8000414c:	02010113          	addi	sp,sp,32
80004150:	00008067          	ret

80004154 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80004154:	fe010113          	addi	sp,sp,-32
80004158:	00912a23          	sw	s1,20(sp)
8000415c:	01312623          	sw	s3,12(sp)
80004160:	00112e23          	sw	ra,28(sp)
80004164:	00812c23          	sw	s0,24(sp)
80004168:	01212823          	sw	s2,16(sp)
8000416c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004170:	00800493          	li	s1,8
80004174:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004178:	80006437          	lui	s0,0x80006
8000417c:	33840513          	addi	a0,s0,824 # 80006338 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006339>
	key = (mstatus & SOC_MSTATUS_IEN);
80004180:	0084f493          	andi	s1,s1,8
80004184:	38c000ef          	jal	ra,80004510 <z_spin_lock_valid>
80004188:	02051e63          	bnez	a0,800041c4 <z_impl_k_sem_give+0x70>
8000418c:	80006937          	lui	s2,0x80006
80004190:	800065b7          	lui	a1,0x80006
80004194:	80006537          	lui	a0,0x80006
80004198:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
8000419c:	04e00693          	li	a3,78
800041a0:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800041a4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800041a8:	901fd0ef          	jal	ra,80001aa8 <printk>
800041ac:	80006537          	lui	a0,0x80006
800041b0:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
800041b4:	8f5fd0ef          	jal	ra,80001aa8 <printk>
800041b8:	04e00593          	li	a1,78
800041bc:	d4490513          	addi	a0,s2,-700
800041c0:	925fd0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
800041c4:	33840513          	addi	a0,s0,824
800041c8:	3a0000ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
800041cc:	00098513          	mv	a0,s3
800041d0:	f58ff0ef          	jal	ra,80003928 <z_unpend_first_thread>
800041d4:	00050913          	mv	s2,a0
	if (thread != NULL) {
800041d8:	04050263          	beqz	a0,8000421c <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800041dc:	00d54783          	lbu	a5,13(a0)
800041e0:	01f7f793          	andi	a5,a5,31
800041e4:	00079863          	bnez	a5,800041f4 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
800041e8:	01852783          	lw	a5,24(a0)
800041ec:	00079463          	bnez	a5,800041f4 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
800041f0:	d5dfe0ef          	jal	ra,80002f4c <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
800041f4:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
800041f8:	33840513          	addi	a0,s0,824
}
800041fc:	01812403          	lw	s0,24(sp)
80004200:	01c12083          	lw	ra,28(sp)
80004204:	01012903          	lw	s2,16(sp)
80004208:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
8000420c:	00048593          	mv	a1,s1
}
80004210:	01412483          	lw	s1,20(sp)
80004214:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004218:	fe8fe06f          	j	80002a00 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
8000421c:	0089a703          	lw	a4,8(s3)
80004220:	00c9a783          	lw	a5,12(s3)
80004224:	40e787b3          	sub	a5,a5,a4
80004228:	00f037b3          	snez	a5,a5
8000422c:	00e787b3          	add	a5,a5,a4
80004230:	00f9a423          	sw	a5,8(s3)
80004234:	fc5ff06f          	j	800041f8 <z_impl_k_sem_give+0xa4>

80004238 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004238:	800067b7          	lui	a5,0x80006
8000423c:	5bc7a783          	lw	a5,1468(a5) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
{
80004240:	fe010113          	addi	sp,sp,-32
80004244:	01212823          	sw	s2,16(sp)
80004248:	01312623          	sw	s3,12(sp)
8000424c:	00112e23          	sw	ra,28(sp)
80004250:	00812c23          	sw	s0,24(sp)
80004254:	00912a23          	sw	s1,20(sp)
80004258:	01412423          	sw	s4,8(sp)
8000425c:	00050913          	mv	s2,a0
80004260:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004264:	04078063          	beqz	a5,800042a4 <z_impl_k_sem_take+0x6c>
80004268:	02058e63          	beqz	a1,800042a4 <z_impl_k_sem_take+0x6c>
8000426c:	80006437          	lui	s0,0x80006
80004270:	800065b7          	lui	a1,0x80006
80004274:	80006537          	lui	a0,0x80006
80004278:	15858593          	addi	a1,a1,344 # 80006158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006159>
8000427c:	08c00693          	li	a3,140
80004280:	0e440613          	addi	a2,s0,228 # 800060e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e5>
80004284:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004288:	821fd0ef          	jal	ra,80001aa8 <printk>
8000428c:	80006537          	lui	a0,0x80006
80004290:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80004294:	815fd0ef          	jal	ra,80001aa8 <printk>
80004298:	08c00593          	li	a1,140
8000429c:	0e440513          	addi	a0,s0,228
800042a0:	845fd0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800042a4:	00800413          	li	s0,8
800042a8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800042ac:	800064b7          	lui	s1,0x80006
800042b0:	33848513          	addi	a0,s1,824 # 80006338 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006339>
	key = (mstatus & SOC_MSTATUS_IEN);
800042b4:	00847413          	andi	s0,s0,8
800042b8:	258000ef          	jal	ra,80004510 <z_spin_lock_valid>
800042bc:	02051e63          	bnez	a0,800042f8 <z_impl_k_sem_take+0xc0>
800042c0:	80006a37          	lui	s4,0x80006
800042c4:	800065b7          	lui	a1,0x80006
800042c8:	80006537          	lui	a0,0x80006
800042cc:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
800042d0:	04e00693          	li	a3,78
800042d4:	d44a0613          	addi	a2,s4,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800042d8:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800042dc:	fccfd0ef          	jal	ra,80001aa8 <printk>
800042e0:	80006537          	lui	a0,0x80006
800042e4:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
800042e8:	fc0fd0ef          	jal	ra,80001aa8 <printk>
800042ec:	04e00593          	li	a1,78
800042f0:	d44a0513          	addi	a0,s4,-700
800042f4:	ff0fd0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
800042f8:	33848513          	addi	a0,s1,824
800042fc:	26c000ef          	jal	ra,80004568 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80004300:	00892783          	lw	a5,8(s2)
80004304:	06078c63          	beqz	a5,8000437c <z_impl_k_sem_take+0x144>
		sem->count--;
80004308:	fff78793          	addi	a5,a5,-1
8000430c:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004310:	33848513          	addi	a0,s1,824
80004314:	224000ef          	jal	ra,80004538 <z_spin_unlock_valid>
80004318:	02051e63          	bnez	a0,80004354 <z_impl_k_sem_take+0x11c>
8000431c:	800064b7          	lui	s1,0x80006
80004320:	800065b7          	lui	a1,0x80006
80004324:	80006537          	lui	a0,0x80006
80004328:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
8000432c:	06100693          	li	a3,97
80004330:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004334:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004338:	f70fd0ef          	jal	ra,80001aa8 <printk>
8000433c:	80006537          	lui	a0,0x80006
80004340:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80004344:	f64fd0ef          	jal	ra,80001aa8 <printk>
80004348:	06100593          	li	a1,97
8000434c:	d4448513          	addi	a0,s1,-700
80004350:	f94fd0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004354:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80004358:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
8000435c:	01c12083          	lw	ra,28(sp)
80004360:	01812403          	lw	s0,24(sp)
80004364:	01412483          	lw	s1,20(sp)
80004368:	01012903          	lw	s2,16(sp)
8000436c:	00c12983          	lw	s3,12(sp)
80004370:	00812a03          	lw	s4,8(sp)
80004374:	02010113          	addi	sp,sp,32
80004378:	00008067          	ret
	if (timeout == K_NO_WAIT) {
8000437c:	04099a63          	bnez	s3,800043d0 <z_impl_k_sem_take+0x198>
80004380:	33848513          	addi	a0,s1,824
80004384:	1b4000ef          	jal	ra,80004538 <z_spin_unlock_valid>
80004388:	02051e63          	bnez	a0,800043c4 <z_impl_k_sem_take+0x18c>
8000438c:	800064b7          	lui	s1,0x80006
80004390:	800065b7          	lui	a1,0x80006
80004394:	80006537          	lui	a0,0x80006
80004398:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
8000439c:	06100693          	li	a3,97
800043a0:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800043a4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800043a8:	f00fd0ef          	jal	ra,80001aa8 <printk>
800043ac:	80006537          	lui	a0,0x80006
800043b0:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
800043b4:	ef4fd0ef          	jal	ra,80001aa8 <printk>
800043b8:	06100593          	li	a1,97
800043bc:	d4448513          	addi	a0,s1,-700
800043c0:	f24fd0ef          	jal	ra,80001ae4 <assert_post_action>
800043c4:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800043c8:	ff000513          	li	a0,-16
800043cc:	f91ff06f          	j	8000435c <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800043d0:	00040593          	mv	a1,s0
}
800043d4:	01812403          	lw	s0,24(sp)
800043d8:	01c12083          	lw	ra,28(sp)
800043dc:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800043e0:	00098693          	mv	a3,s3
800043e4:	00090613          	mv	a2,s2
}
800043e8:	00c12983          	lw	s3,12(sp)
800043ec:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800043f0:	33848513          	addi	a0,s1,824
}
800043f4:	01412483          	lw	s1,20(sp)
800043f8:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800043fc:	a98ff06f          	j	80003694 <z_pend_curr>

80004400 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004400:	00d54783          	lbu	a5,13(a0)
80004404:	01f7f793          	andi	a5,a5,31
80004408:	00079863          	bnez	a5,80004418 <z_is_thread_ready+0x18>
8000440c:	01852503          	lw	a0,24(a0)
80004410:	00153513          	seqz	a0,a0
80004414:	00008067          	ret
80004418:	00000513          	li	a0,0
}
8000441c:	00008067          	ret

80004420 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80004420:	800067b7          	lui	a5,0x80006
80004424:	5bc7a503          	lw	a0,1468(a5) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
}
80004428:	00a03533          	snez	a0,a0
8000442c:	00008067          	ret

80004430 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80004430:	800067b7          	lui	a5,0x80006
80004434:	5c47a783          	lw	a5,1476(a5) # 800065c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c5>
80004438:	00c7c503          	lbu	a0,12(a5)
}
8000443c:	00157513          	andi	a0,a0,1
80004440:	00008067          	ret

80004444 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004444:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004448:	02012303          	lw	t1,32(sp)
{
8000444c:	00812c23          	sw	s0,24(sp)
80004450:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004454:	00612023          	sw	t1,0(sp)
{
80004458:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000445c:	ce9fc0ef          	jal	ra,80001144 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004460:	800067b7          	lui	a5,0x80006
80004464:	5c47a783          	lw	a5,1476(a5) # 800065c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c5>
	sys_trace_thread_create(new_thread);
}
80004468:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
8000446c:	0687a783          	lw	a5,104(a5)
80004470:	06f42423          	sw	a5,104(s0)
}
80004474:	01812403          	lw	s0,24(sp)
80004478:	02010113          	addi	sp,sp,32
8000447c:	00008067          	ret

80004480 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004480:	06052783          	lw	a5,96(a0)
{
80004484:	ff010113          	addi	sp,sp,-16
80004488:	00812423          	sw	s0,8(sp)
8000448c:	00112623          	sw	ra,12(sp)
80004490:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004494:	00078463          	beqz	a5,8000449c <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004498:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
8000449c:	00040513          	mv	a0,s0
800044a0:	f61ff0ef          	jal	ra,80004400 <z_is_thread_ready>
800044a4:	02050463          	beqz	a0,800044cc <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
800044a8:	00040513          	mv	a0,s0
800044ac:	fa9fe0ef          	jal	ra,80003454 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
800044b0:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
800044b4:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
800044b8:	0087e793          	ori	a5,a5,8
800044bc:	00f406a3          	sb	a5,13(s0)
}
800044c0:	00812403          	lw	s0,8(sp)
800044c4:	01010113          	addi	sp,sp,16
800044c8:	00008067          	ret
		if (z_is_thread_pending(thread)) {
800044cc:	00d44783          	lbu	a5,13(s0)
800044d0:	0027f793          	andi	a5,a5,2
800044d4:	00078663          	beqz	a5,800044e0 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
800044d8:	00040513          	mv	a0,s0
800044dc:	c28fe0ef          	jal	ra,80002904 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
800044e0:	01842783          	lw	a5,24(s0)
800044e4:	fc0786e3          	beqz	a5,800044b0 <z_thread_single_abort+0x30>
800044e8:	01840513          	addi	a0,s0,24
800044ec:	798000ef          	jal	ra,80004c84 <z_abort_timeout>
800044f0:	fc1ff06f          	j	800044b0 <z_thread_single_abort+0x30>

800044f4 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800044f4:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800044f8:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800044fc:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004500:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004504:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80004508:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
8000450c:	00008067          	ret

80004510 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004510:	00052503          	lw	a0,0(a0)
80004514:	00050e63          	beqz	a0,80004530 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004518:	800067b7          	lui	a5,0x80006
8000451c:	5d07c783          	lbu	a5,1488(a5) # 800065d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d1>
80004520:	00357513          	andi	a0,a0,3
80004524:	40f50533          	sub	a0,a0,a5
80004528:	00a03533          	snez	a0,a0
8000452c:	00008067          	ret
			return false;
		}
	}
	return true;
80004530:	00100513          	li	a0,1
}
80004534:	00008067          	ret

80004538 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80004538:	800067b7          	lui	a5,0x80006
8000453c:	5bc78793          	addi	a5,a5,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80004540:	0147c703          	lbu	a4,20(a5)
80004544:	0087a783          	lw	a5,8(a5)
80004548:	00e7e7b3          	or	a5,a5,a4
8000454c:	00052703          	lw	a4,0(a0)
80004550:	00f71863          	bne	a4,a5,80004560 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004554:	00052023          	sw	zero,0(a0)
	return true;
80004558:	00100513          	li	a0,1
8000455c:	00008067          	ret
		return false;
80004560:	00000513          	li	a0,0
}
80004564:	00008067          	ret

80004568 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004568:	800067b7          	lui	a5,0x80006
8000456c:	5bc78793          	addi	a5,a5,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
80004570:	0147c703          	lbu	a4,20(a5)
80004574:	0087a783          	lw	a5,8(a5)
80004578:	00e7e7b3          	or	a5,a5,a4
8000457c:	00f52023          	sw	a5,0(a0)
}
80004580:	00008067          	ret

80004584 <z_impl_k_thread_start>:
{
80004584:	fe010113          	addi	sp,sp,-32
80004588:	00812c23          	sw	s0,24(sp)
8000458c:	01212823          	sw	s2,16(sp)
80004590:	00112e23          	sw	ra,28(sp)
80004594:	00912a23          	sw	s1,20(sp)
80004598:	01312623          	sw	s3,12(sp)
8000459c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800045a0:	00800413          	li	s0,8
800045a4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045a8:	800064b7          	lui	s1,0x80006
800045ac:	33c48513          	addi	a0,s1,828 # 8000633c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000633d>
	key = (mstatus & SOC_MSTATUS_IEN);
800045b0:	00847413          	andi	s0,s0,8
800045b4:	f5dff0ef          	jal	ra,80004510 <z_spin_lock_valid>
800045b8:	02051e63          	bnez	a0,800045f4 <z_impl_k_thread_start+0x70>
800045bc:	800069b7          	lui	s3,0x80006
800045c0:	800065b7          	lui	a1,0x80006
800045c4:	80006537          	lui	a0,0x80006
800045c8:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
800045cc:	04e00693          	li	a3,78
800045d0:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800045d4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800045d8:	cd0fd0ef          	jal	ra,80001aa8 <printk>
800045dc:	80006537          	lui	a0,0x80006
800045e0:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
800045e4:	cc4fd0ef          	jal	ra,80001aa8 <printk>
800045e8:	04e00593          	li	a1,78
800045ec:	d4498513          	addi	a0,s3,-700
800045f0:	cf4fd0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
800045f4:	33c48513          	addi	a0,s1,828
800045f8:	f71ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
800045fc:	00d94783          	lbu	a5,13(s2)
80004600:	0047f713          	andi	a4,a5,4
80004604:	06071463          	bnez	a4,8000466c <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004608:	33c48513          	addi	a0,s1,828
8000460c:	f2dff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80004610:	02051e63          	bnez	a0,8000464c <z_impl_k_thread_start+0xc8>
80004614:	800064b7          	lui	s1,0x80006
80004618:	800065b7          	lui	a1,0x80006
8000461c:	80006537          	lui	a0,0x80006
80004620:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80004624:	06100693          	li	a3,97
80004628:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
8000462c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004630:	c78fd0ef          	jal	ra,80001aa8 <printk>
80004634:	80006537          	lui	a0,0x80006
80004638:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
8000463c:	c6cfd0ef          	jal	ra,80001aa8 <printk>
80004640:	06100593          	li	a1,97
80004644:	d4448513          	addi	a0,s1,-700
80004648:	c9cfd0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000464c:	30042473          	csrrs	s0,mstatus,s0
}
80004650:	01c12083          	lw	ra,28(sp)
80004654:	01812403          	lw	s0,24(sp)
80004658:	01412483          	lw	s1,20(sp)
8000465c:	01012903          	lw	s2,16(sp)
80004660:	00c12983          	lw	s3,12(sp)
80004664:	02010113          	addi	sp,sp,32
80004668:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
8000466c:	ffb7f793          	andi	a5,a5,-5
80004670:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004674:	00090513          	mv	a0,s2
80004678:	d89ff0ef          	jal	ra,80004400 <z_is_thread_ready>
8000467c:	00050663          	beqz	a0,80004688 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004680:	00090513          	mv	a0,s2
80004684:	8c9fe0ef          	jal	ra,80002f4c <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004688:	00040593          	mv	a1,s0
}
8000468c:	01812403          	lw	s0,24(sp)
80004690:	01c12083          	lw	ra,28(sp)
80004694:	01012903          	lw	s2,16(sp)
80004698:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
8000469c:	33c48513          	addi	a0,s1,828
}
800046a0:	01412483          	lw	s1,20(sp)
800046a4:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
800046a8:	b58fe06f          	j	80002a00 <z_reschedule>

800046ac <schedule_new_thread>:
	if (delay == 0) {
800046ac:	00059463          	bnez	a1,800046b4 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
800046b0:	ed5ff06f          	j	80004584 <z_impl_k_thread_start>
{
800046b4:	ff010113          	addi	sp,sp,-16
800046b8:	00812423          	sw	s0,8(sp)
800046bc:	00050413          	mv	s0,a0
800046c0:	00058513          	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800046c4:	00950513          	addi	a0,a0,9
800046c8:	00a00593          	li	a1,10
800046cc:	00112623          	sw	ra,12(sp)
800046d0:	a78fc0ef          	jal	ra,80000948 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800046d4:	00150613          	addi	a2,a0,1
800046d8:	01840513          	addi	a0,s0,24
}
800046dc:	00812403          	lw	s0,8(sp)
800046e0:	00c12083          	lw	ra,12(sp)
800046e4:	800035b7          	lui	a1,0x80003
800046e8:	0dc58593          	addi	a1,a1,220 # 800030dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800030dd>
800046ec:	01010113          	addi	sp,sp,16
800046f0:	3680006f          	j	80004a58 <z_add_timeout>

800046f4 <z_impl_k_thread_create>:
{
800046f4:	fc010113          	addi	sp,sp,-64
800046f8:	03512223          	sw	s5,36(sp)
800046fc:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004700:	800066b7          	lui	a3,0x80006
80004704:	5bc6a683          	lw	a3,1468(a3) # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
{
80004708:	02812c23          	sw	s0,56(sp)
8000470c:	02912a23          	sw	s1,52(sp)
80004710:	03312623          	sw	s3,44(sp)
80004714:	03412423          	sw	s4,40(sp)
80004718:	02112e23          	sw	ra,60(sp)
8000471c:	03212823          	sw	s2,48(sp)
80004720:	00050413          	mv	s0,a0
80004724:	00058993          	mv	s3,a1
80004728:	00060a13          	mv	s4,a2
8000472c:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004730:	04068e63          	beqz	a3,8000478c <z_impl_k_thread_create+0x98>
80004734:	80006937          	lui	s2,0x80006
80004738:	800065b7          	lui	a1,0x80006
8000473c:	80006537          	lui	a0,0x80006
80004740:	1b200693          	li	a3,434
80004744:	18c90613          	addi	a2,s2,396 # 8000618c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000618d>
80004748:	f4c58593          	addi	a1,a1,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
8000474c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004750:	01112e23          	sw	a7,28(sp)
80004754:	01012c23          	sw	a6,24(sp)
80004758:	00f12a23          	sw	a5,20(sp)
8000475c:	00e12823          	sw	a4,16(sp)
80004760:	b48fd0ef          	jal	ra,80001aa8 <printk>
80004764:	80006537          	lui	a0,0x80006
80004768:	1a050513          	addi	a0,a0,416 # 800061a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061a1>
8000476c:	b3cfd0ef          	jal	ra,80001aa8 <printk>
80004770:	1b200593          	li	a1,434
80004774:	18c90513          	addi	a0,s2,396
80004778:	b6cfd0ef          	jal	ra,80001ae4 <assert_post_action>
8000477c:	01c12883          	lw	a7,28(sp)
80004780:	01812803          	lw	a6,24(sp)
80004784:	01412783          	lw	a5,20(sp)
80004788:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000478c:	04012683          	lw	a3,64(sp)
80004790:	00012223          	sw	zero,4(sp)
80004794:	000a0613          	mv	a2,s4
80004798:	00d12023          	sw	a3,0(sp)
8000479c:	00098593          	mv	a1,s3
800047a0:	000a8693          	mv	a3,s5
800047a4:	00040513          	mv	a0,s0
800047a8:	c9dff0ef          	jal	ra,80004444 <z_setup_new_thread>
	if (delay != K_FOREVER) {
800047ac:	fff00793          	li	a5,-1
800047b0:	00f48863          	beq	s1,a5,800047c0 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
800047b4:	00048593          	mv	a1,s1
800047b8:	00040513          	mv	a0,s0
800047bc:	ef1ff0ef          	jal	ra,800046ac <schedule_new_thread>
}
800047c0:	00040513          	mv	a0,s0
800047c4:	03c12083          	lw	ra,60(sp)
800047c8:	03812403          	lw	s0,56(sp)
800047cc:	03412483          	lw	s1,52(sp)
800047d0:	03012903          	lw	s2,48(sp)
800047d4:	02c12983          	lw	s3,44(sp)
800047d8:	02812a03          	lw	s4,40(sp)
800047dc:	02412a83          	lw	s5,36(sp)
800047e0:	04010113          	addi	sp,sp,64
800047e4:	00008067          	ret

800047e8 <z_init_static_threads>:
{
800047e8:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
800047ec:	800067b7          	lui	a5,0x80006
{
800047f0:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
800047f4:	80006937          	lui	s2,0x80006
{
800047f8:	00812c23          	sw	s0,24(sp)
800047fc:	00912a23          	sw	s1,20(sp)
80004800:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004804:	2ec78413          	addi	s0,a5,748 # 800062ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062ed>
80004808:	2ec78493          	addi	s1,a5,748
8000480c:	2ec90913          	addi	s2,s2,748 # 800062ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062ed>
80004810:	03246663          	bltu	s0,s2,8000483c <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004814:	00048413          	mv	s0,s1
	k_sched_lock();
80004818:	ae8fe0ef          	jal	ra,80002b00 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
8000481c:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004820:	07246063          	bltu	s0,s2,80004880 <z_init_static_threads+0x98>
}
80004824:	01812403          	lw	s0,24(sp)
80004828:	01c12083          	lw	ra,28(sp)
8000482c:	01412483          	lw	s1,20(sp)
80004830:	01012903          	lw	s2,16(sp)
80004834:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004838:	d94fe06f          	j	80002dcc <k_sched_unlock>
		z_setup_new_thread(
8000483c:	02c42783          	lw	a5,44(s0)
80004840:	00f12223          	sw	a5,4(sp)
80004844:	02042783          	lw	a5,32(s0)
80004848:	00f12023          	sw	a5,0(sp)
8000484c:	01442783          	lw	a5,20(s0)
80004850:	01c42883          	lw	a7,28(s0)
80004854:	01842803          	lw	a6,24(s0)
80004858:	01042703          	lw	a4,16(s0)
8000485c:	00c42683          	lw	a3,12(s0)
80004860:	00842603          	lw	a2,8(s0)
80004864:	00442583          	lw	a1,4(s0)
80004868:	00042503          	lw	a0,0(s0)
8000486c:	bd9ff0ef          	jal	ra,80004444 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004870:	00042783          	lw	a5,0(s0)
80004874:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004878:	03040413          	addi	s0,s0,48
8000487c:	f95ff06f          	j	80004810 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004880:	02442583          	lw	a1,36(s0)
80004884:	00958663          	beq	a1,s1,80004890 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004888:	00042503          	lw	a0,0(s0)
8000488c:	e21ff0ef          	jal	ra,800046ac <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004890:	03040413          	addi	s0,s0,48
80004894:	f8dff06f          	j	80004820 <z_init_static_threads+0x38>

80004898 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004898:	fe010113          	addi	sp,sp,-32
8000489c:	00812c23          	sw	s0,24(sp)
800048a0:	00912a23          	sw	s1,20(sp)
800048a4:	00112e23          	sw	ra,28(sp)
800048a8:	01212823          	sw	s2,16(sp)
800048ac:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
800048b0:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800048b4:	00800413          	li	s0,8
800048b8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800048bc:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800048c0:	00847413          	andi	s0,s0,8
800048c4:	c4dff0ef          	jal	ra,80004510 <z_spin_lock_valid>
800048c8:	02051e63          	bnez	a0,80004904 <z_impl_k_thread_abort+0x6c>
800048cc:	80006937          	lui	s2,0x80006
800048d0:	800065b7          	lui	a1,0x80006
800048d4:	80006537          	lui	a0,0x80006
800048d8:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
800048dc:	04e00693          	li	a3,78
800048e0:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
800048e4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800048e8:	9c0fd0ef          	jal	ra,80001aa8 <printk>
800048ec:	80006537          	lui	a0,0x80006
800048f0:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
800048f4:	9b4fd0ef          	jal	ra,80001aa8 <printk>
800048f8:	04e00593          	li	a1,78
800048fc:	d4490513          	addi	a0,s2,-700
80004900:	9e4fd0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004904:	00c10513          	addi	a0,sp,12
80004908:	c61ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
8000490c:	00c4c783          	lbu	a5,12(s1)
80004910:	0017f793          	andi	a5,a5,1
80004914:	02078e63          	beqz	a5,80004950 <z_impl_k_thread_abort+0xb8>
80004918:	80006937          	lui	s2,0x80006
8000491c:	800065b7          	lui	a1,0x80006
80004920:	80006537          	lui	a0,0x80006
80004924:	1e058593          	addi	a1,a1,480 # 800061e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061e1>
80004928:	02900693          	li	a3,41
8000492c:	1c890613          	addi	a2,s2,456 # 800061c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061c9>
80004930:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004934:	974fd0ef          	jal	ra,80001aa8 <printk>
80004938:	80006537          	lui	a0,0x80006
8000493c:	21450513          	addi	a0,a0,532 # 80006214 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006215>
80004940:	968fd0ef          	jal	ra,80001aa8 <printk>
80004944:	02900593          	li	a1,41
80004948:	1c890513          	addi	a0,s2,456
8000494c:	998fd0ef          	jal	ra,80001ae4 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004950:	00048513          	mv	a0,s1
80004954:	b2dff0ef          	jal	ra,80004480 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004958:	00040593          	mv	a1,s0
8000495c:	00c10513          	addi	a0,sp,12
80004960:	8a0fe0ef          	jal	ra,80002a00 <z_reschedule>
}
80004964:	01c12083          	lw	ra,28(sp)
80004968:	01812403          	lw	s0,24(sp)
8000496c:	01412483          	lw	s1,20(sp)
80004970:	01012903          	lw	s2,16(sp)
80004974:	02010113          	addi	sp,sp,32
80004978:	00008067          	ret

8000497c <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
8000497c:	800067b7          	lui	a5,0x80006
80004980:	3407a783          	lw	a5,832(a5) # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
80004984:	00079463          	bnez	a5,8000498c <elapsed+0x10>
80004988:	ddcfd06f          	j	80001f64 <z_clock_elapsed>
}
8000498c:	00000513          	li	a0,0
80004990:	00008067          	ret

80004994 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004994:	00052783          	lw	a5,0(a0)
80004998:	02050263          	beqz	a0,800049bc <remove_timeout+0x28>
8000499c:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
800049a0:	2ac72703          	lw	a4,684(a4) # 800062ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062ad>
800049a4:	00e50c63          	beq	a0,a4,800049bc <remove_timeout+0x28>
	if (next(t) != NULL) {
800049a8:	00078a63          	beqz	a5,800049bc <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
800049ac:	0087a703          	lw	a4,8(a5)
800049b0:	00852683          	lw	a3,8(a0)
800049b4:	00d70733          	add	a4,a4,a3
800049b8:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
800049bc:	00452703          	lw	a4,4(a0)
800049c0:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800049c4:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800049c8:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800049cc:	00052223          	sw	zero,4(a0)
}
800049d0:	00008067          	ret

800049d4 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800049d4:	800067b7          	lui	a5,0x80006
800049d8:	3487c783          	lbu	a5,840(a5) # 80006348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006349>
{
800049dc:	ff010113          	addi	sp,sp,-16
800049e0:	00112623          	sw	ra,12(sp)
800049e4:	00812423          	sw	s0,8(sp)
800049e8:	00912223          	sw	s1,4(sp)
800049ec:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800049f0:	00079663          	bnez	a5,800049fc <next_timeout+0x28>
800049f4:	80000537          	lui	a0,0x80000
800049f8:	fff54513          	not	a0,a0
	return list->head == list;
800049fc:	800067b7          	lui	a5,0x80006
80004a00:	2a878793          	addi	a5,a5,680 # 800062a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a9>
80004a04:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004a08:	02f40463          	beq	s0,a5,80004a30 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004a0c:	02040263          	beqz	s0,80004a30 <next_timeout+0x5c>
80004a10:	00842483          	lw	s1,8(s0)
80004a14:	f69ff0ef          	jal	ra,8000497c <elapsed>
80004a18:	40a484b3          	sub	s1,s1,a0
80004a1c:	00000513          	li	a0,0
80004a20:	0004c863          	bltz	s1,80004a30 <next_timeout+0x5c>
80004a24:	00842403          	lw	s0,8(s0)
80004a28:	f55ff0ef          	jal	ra,8000497c <elapsed>
80004a2c:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004a30:	800067b7          	lui	a5,0x80006
80004a34:	5cc7a783          	lw	a5,1484(a5) # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
80004a38:	00078663          	beqz	a5,80004a44 <next_timeout+0x70>
80004a3c:	00a7d463          	bge	a5,a0,80004a44 <next_timeout+0x70>
80004a40:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004a44:	00c12083          	lw	ra,12(sp)
80004a48:	00812403          	lw	s0,8(sp)
80004a4c:	00412483          	lw	s1,4(sp)
80004a50:	01010113          	addi	sp,sp,16
80004a54:	00008067          	ret

80004a58 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004a58:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004a5c:	fd010113          	addi	sp,sp,-48
80004a60:	02812423          	sw	s0,40(sp)
80004a64:	02912223          	sw	s1,36(sp)
80004a68:	01312e23          	sw	s3,28(sp)
80004a6c:	02112623          	sw	ra,44(sp)
80004a70:	03212023          	sw	s2,32(sp)
80004a74:	01412c23          	sw	s4,24(sp)
80004a78:	01512a23          	sw	s5,20(sp)
80004a7c:	01612823          	sw	s6,16(sp)
80004a80:	01712623          	sw	s7,12(sp)
80004a84:	01812423          	sw	s8,8(sp)
80004a88:	00050413          	mv	s0,a0
80004a8c:	00058993          	mv	s3,a1
80004a90:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004a94:	02078e63          	beqz	a5,80004ad0 <z_add_timeout+0x78>
80004a98:	80006937          	lui	s2,0x80006
80004a9c:	800065b7          	lui	a1,0x80006
80004aa0:	80006537          	lui	a0,0x80006
80004aa4:	24458593          	addi	a1,a1,580 # 80006244 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006245>
80004aa8:	04d00693          	li	a3,77
80004aac:	23090613          	addi	a2,s2,560 # 80006230 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006231>
80004ab0:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004ab4:	ff5fc0ef          	jal	ra,80001aa8 <printk>
80004ab8:	80006537          	lui	a0,0x80006
80004abc:	f6450513          	addi	a0,a0,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80004ac0:	fe9fc0ef          	jal	ra,80001aa8 <printk>
80004ac4:	04d00593          	li	a1,77
80004ac8:	23090513          	addi	a0,s2,560
80004acc:	818fd0ef          	jal	ra,80001ae4 <assert_post_action>
	to->fn = fn;
80004ad0:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004ad4:	00904463          	bgtz	s1,80004adc <z_add_timeout+0x84>
80004ad8:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004adc:	00800993          	li	s3,8
80004ae0:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ae4:	80006a37          	lui	s4,0x80006
80004ae8:	344a0513          	addi	a0,s4,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
	key = (mstatus & SOC_MSTATUS_IEN);
80004aec:	0089f993          	andi	s3,s3,8
80004af0:	a21ff0ef          	jal	ra,80004510 <z_spin_lock_valid>
80004af4:	02051e63          	bnez	a0,80004b30 <z_add_timeout+0xd8>
80004af8:	80006937          	lui	s2,0x80006
80004afc:	800065b7          	lui	a1,0x80006
80004b00:	80006537          	lui	a0,0x80006
80004b04:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80004b08:	04e00693          	li	a3,78
80004b0c:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004b10:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004b14:	f95fc0ef          	jal	ra,80001aa8 <printk>
80004b18:	80006537          	lui	a0,0x80006
80004b1c:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80004b20:	f89fc0ef          	jal	ra,80001aa8 <printk>
80004b24:	04e00593          	li	a1,78
80004b28:	d4490513          	addi	a0,s2,-700
80004b2c:	fb9fc0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004b30:	344a0513          	addi	a0,s4,836
80004b34:	a35ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80004b38:	e45ff0ef          	jal	ra,8000497c <elapsed>
80004b3c:	00950533          	add	a0,a0,s1
	return list->head == list;
80004b40:	800064b7          	lui	s1,0x80006
80004b44:	2a84a903          	lw	s2,680(s1) # 800062a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a9>
80004b48:	00a42423          	sw	a0,8(s0)
80004b4c:	2a848493          	addi	s1,s1,680
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004b50:	00990c63          	beq	s2,s1,80004b68 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80004b54:	80006ab7          	lui	s5,0x80006
80004b58:	80006b37          	lui	s6,0x80006
80004b5c:	80006bb7          	lui	s7,0x80006
80004b60:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
80004b64:	02091063          	bnez	s2,80004b84 <z_add_timeout+0x12c>
	node->prev = list->tail;
80004b68:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004b6c:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004b70:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004b74:	0044a783          	lw	a5,4(s1)
80004b78:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004b7c:	0084a223          	sw	s0,4(s1)
80004b80:	05c0006f          	j	80004bdc <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80004b84:	00892783          	lw	a5,8(s2)
80004b88:	0207d663          	bgez	a5,80004bb4 <z_add_timeout+0x15c>
80004b8c:	264b0593          	addi	a1,s6,612 # 80006264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006265>
80004b90:	05600693          	li	a3,86
80004b94:	230a8613          	addi	a2,s5,560 # 80006230 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006231>
80004b98:	cbcb8513          	addi	a0,s7,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004b9c:	f0dfc0ef          	jal	ra,80001aa8 <printk>
80004ba0:	f64c0513          	addi	a0,s8,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
80004ba4:	f05fc0ef          	jal	ra,80001aa8 <printk>
80004ba8:	05600593          	li	a1,86
80004bac:	230a8513          	addi	a0,s5,560
80004bb0:	f35fc0ef          	jal	ra,80001ae4 <assert_post_action>

			if (t->dticks > to->dticks) {
80004bb4:	00892703          	lw	a4,8(s2)
80004bb8:	00842783          	lw	a5,8(s0)
80004bbc:	0ae7d863          	bge	a5,a4,80004c6c <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80004bc0:	40f707b3          	sub	a5,a4,a5
80004bc4:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004bc8:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004bcc:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004bd0:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80004bd4:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80004bd8:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004bdc:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004be0:	00978a63          	beq	a5,s1,80004bf4 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004be4:	00f41863          	bne	s0,a5,80004bf4 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80004be8:	dedff0ef          	jal	ra,800049d4 <next_timeout>
80004bec:	00000593          	li	a1,0
80004bf0:	9ccfd0ef          	jal	ra,80001dbc <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004bf4:	344a0513          	addi	a0,s4,836
80004bf8:	941ff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80004bfc:	02051e63          	bnez	a0,80004c38 <z_add_timeout+0x1e0>
80004c00:	80006437          	lui	s0,0x80006
80004c04:	800065b7          	lui	a1,0x80006
80004c08:	80006537          	lui	a0,0x80006
80004c0c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80004c10:	06100693          	li	a3,97
80004c14:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004c18:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004c1c:	e8dfc0ef          	jal	ra,80001aa8 <printk>
80004c20:	80006537          	lui	a0,0x80006
80004c24:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80004c28:	e81fc0ef          	jal	ra,80001aa8 <printk>
80004c2c:	06100593          	li	a1,97
80004c30:	d4440513          	addi	a0,s0,-700
80004c34:	eb1fc0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c38:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80004c3c:	02c12083          	lw	ra,44(sp)
80004c40:	02812403          	lw	s0,40(sp)
80004c44:	02412483          	lw	s1,36(sp)
80004c48:	02012903          	lw	s2,32(sp)
80004c4c:	01c12983          	lw	s3,28(sp)
80004c50:	01812a03          	lw	s4,24(sp)
80004c54:	01412a83          	lw	s5,20(sp)
80004c58:	01012b03          	lw	s6,16(sp)
80004c5c:	00c12b83          	lw	s7,12(sp)
80004c60:	00812c03          	lw	s8,8(sp)
80004c64:	03010113          	addi	sp,sp,48
80004c68:	00008067          	ret
			to->dticks -= t->dticks;
80004c6c:	40e787b3          	sub	a5,a5,a4
80004c70:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004c74:	0044a783          	lw	a5,4(s1)
80004c78:	ef2788e3          	beq	a5,s2,80004b68 <z_add_timeout+0x110>
80004c7c:	00092903          	lw	s2,0(s2)
80004c80:	ee5ff06f          	j	80004b64 <z_add_timeout+0x10c>

80004c84 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004c84:	fe010113          	addi	sp,sp,-32
80004c88:	00812c23          	sw	s0,24(sp)
80004c8c:	01312623          	sw	s3,12(sp)
80004c90:	00112e23          	sw	ra,28(sp)
80004c94:	00912a23          	sw	s1,20(sp)
80004c98:	01212823          	sw	s2,16(sp)
80004c9c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004ca0:	00800413          	li	s0,8
80004ca4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ca8:	800064b7          	lui	s1,0x80006
80004cac:	34448513          	addi	a0,s1,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
	key = (mstatus & SOC_MSTATUS_IEN);
80004cb0:	00847413          	andi	s0,s0,8
80004cb4:	85dff0ef          	jal	ra,80004510 <z_spin_lock_valid>
80004cb8:	02051e63          	bnez	a0,80004cf4 <z_abort_timeout+0x70>
80004cbc:	80006937          	lui	s2,0x80006
80004cc0:	800065b7          	lui	a1,0x80006
80004cc4:	80006537          	lui	a0,0x80006
80004cc8:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80004ccc:	04e00693          	li	a3,78
80004cd0:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004cd4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004cd8:	dd1fc0ef          	jal	ra,80001aa8 <printk>
80004cdc:	80006537          	lui	a0,0x80006
80004ce0:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80004ce4:	dc5fc0ef          	jal	ra,80001aa8 <printk>
80004ce8:	04e00593          	li	a1,78
80004cec:	d4490513          	addi	a0,s2,-700
80004cf0:	df5fc0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004cf4:	34448513          	addi	a0,s1,836
80004cf8:	871ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004cfc:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80004d00:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80004d04:	00078863          	beqz	a5,80004d14 <z_abort_timeout+0x90>
			remove_timeout(to);
80004d08:	00098513          	mv	a0,s3
80004d0c:	c89ff0ef          	jal	ra,80004994 <remove_timeout>
			ret = 0;
80004d10:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d14:	34448513          	addi	a0,s1,836
80004d18:	821ff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80004d1c:	02051e63          	bnez	a0,80004d58 <z_abort_timeout+0xd4>
80004d20:	800064b7          	lui	s1,0x80006
80004d24:	800065b7          	lui	a1,0x80006
80004d28:	80006537          	lui	a0,0x80006
80004d2c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80004d30:	06100693          	li	a3,97
80004d34:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004d38:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004d3c:	d6dfc0ef          	jal	ra,80001aa8 <printk>
80004d40:	80006537          	lui	a0,0x80006
80004d44:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80004d48:	d61fc0ef          	jal	ra,80001aa8 <printk>
80004d4c:	06100593          	li	a1,97
80004d50:	d4448513          	addi	a0,s1,-700
80004d54:	d91fc0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004d58:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004d5c:	01c12083          	lw	ra,28(sp)
80004d60:	01812403          	lw	s0,24(sp)
80004d64:	00090513          	mv	a0,s2
80004d68:	01412483          	lw	s1,20(sp)
80004d6c:	01012903          	lw	s2,16(sp)
80004d70:	00c12983          	lw	s3,12(sp)
80004d74:	02010113          	addi	sp,sp,32
80004d78:	00008067          	ret

80004d7c <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004d7c:	ff010113          	addi	sp,sp,-16
80004d80:	00812423          	sw	s0,8(sp)
80004d84:	00112623          	sw	ra,12(sp)
80004d88:	00912223          	sw	s1,4(sp)
80004d8c:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004d90:	00800413          	li	s0,8
80004d94:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004d98:	800064b7          	lui	s1,0x80006
80004d9c:	34448513          	addi	a0,s1,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
	key = (mstatus & SOC_MSTATUS_IEN);
80004da0:	00847413          	andi	s0,s0,8
80004da4:	f6cff0ef          	jal	ra,80004510 <z_spin_lock_valid>
80004da8:	02051e63          	bnez	a0,80004de4 <z_get_next_timeout_expiry+0x68>
80004dac:	80006937          	lui	s2,0x80006
80004db0:	800065b7          	lui	a1,0x80006
80004db4:	80006537          	lui	a0,0x80006
80004db8:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80004dbc:	04e00693          	li	a3,78
80004dc0:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004dc4:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004dc8:	ce1fc0ef          	jal	ra,80001aa8 <printk>
80004dcc:	80006537          	lui	a0,0x80006
80004dd0:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80004dd4:	cd5fc0ef          	jal	ra,80001aa8 <printk>
80004dd8:	04e00593          	li	a1,78
80004ddc:	d4490513          	addi	a0,s2,-700
80004de0:	d05fc0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004de4:	34448513          	addi	a0,s1,836
80004de8:	f80ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004dec:	be9ff0ef          	jal	ra,800049d4 <next_timeout>
80004df0:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004df4:	34448513          	addi	a0,s1,836
80004df8:	f40ff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80004dfc:	02051e63          	bnez	a0,80004e38 <z_get_next_timeout_expiry+0xbc>
80004e00:	800064b7          	lui	s1,0x80006
80004e04:	800065b7          	lui	a1,0x80006
80004e08:	80006537          	lui	a0,0x80006
80004e0c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80004e10:	06100693          	li	a3,97
80004e14:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004e18:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004e1c:	c8dfc0ef          	jal	ra,80001aa8 <printk>
80004e20:	80006537          	lui	a0,0x80006
80004e24:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80004e28:	c81fc0ef          	jal	ra,80001aa8 <printk>
80004e2c:	06100593          	li	a1,97
80004e30:	d4448513          	addi	a0,s1,-700
80004e34:	cb1fc0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004e38:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80004e3c:	00c12083          	lw	ra,12(sp)
80004e40:	00812403          	lw	s0,8(sp)
80004e44:	00090513          	mv	a0,s2
80004e48:	00412483          	lw	s1,4(sp)
80004e4c:	00012903          	lw	s2,0(sp)
80004e50:	01010113          	addi	sp,sp,16
80004e54:	00008067          	ret

80004e58 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80004e58:	fe010113          	addi	sp,sp,-32
80004e5c:	00812c23          	sw	s0,24(sp)
80004e60:	01212823          	sw	s2,16(sp)
80004e64:	01412423          	sw	s4,8(sp)
80004e68:	00112e23          	sw	ra,28(sp)
80004e6c:	00912a23          	sw	s1,20(sp)
80004e70:	01312623          	sw	s3,12(sp)
80004e74:	00050913          	mv	s2,a0
80004e78:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e7c:	00800413          	li	s0,8
80004e80:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e84:	800064b7          	lui	s1,0x80006
80004e88:	34448513          	addi	a0,s1,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
	key = (mstatus & SOC_MSTATUS_IEN);
80004e8c:	00847413          	andi	s0,s0,8
80004e90:	e80ff0ef          	jal	ra,80004510 <z_spin_lock_valid>
80004e94:	02051e63          	bnez	a0,80004ed0 <z_set_timeout_expiry+0x78>
80004e98:	800069b7          	lui	s3,0x80006
80004e9c:	800065b7          	lui	a1,0x80006
80004ea0:	80006537          	lui	a0,0x80006
80004ea4:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80004ea8:	04e00693          	li	a3,78
80004eac:	d4498613          	addi	a2,s3,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004eb0:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004eb4:	bf5fc0ef          	jal	ra,80001aa8 <printk>
80004eb8:	80006537          	lui	a0,0x80006
80004ebc:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80004ec0:	be9fc0ef          	jal	ra,80001aa8 <printk>
80004ec4:	04e00593          	li	a1,78
80004ec8:	d4498513          	addi	a0,s3,-700
80004ecc:	c19fc0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ed0:	34448513          	addi	a0,s1,836
80004ed4:	e94ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004ed8:	afdff0ef          	jal	ra,800049d4 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004edc:	00a95c63          	bge	s2,a0,80004ef4 <z_set_timeout_expiry+0x9c>
80004ee0:	00100793          	li	a5,1
80004ee4:	00a7d863          	bge	a5,a0,80004ef4 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80004ee8:	000a0593          	mv	a1,s4
80004eec:	00090513          	mv	a0,s2
80004ef0:	ecdfc0ef          	jal	ra,80001dbc <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ef4:	34448513          	addi	a0,s1,836
80004ef8:	e40ff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80004efc:	02051e63          	bnez	a0,80004f38 <z_set_timeout_expiry+0xe0>
80004f00:	800064b7          	lui	s1,0x80006
80004f04:	800065b7          	lui	a1,0x80006
80004f08:	80006537          	lui	a0,0x80006
80004f0c:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80004f10:	06100693          	li	a3,97
80004f14:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004f18:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004f1c:	b8dfc0ef          	jal	ra,80001aa8 <printk>
80004f20:	80006537          	lui	a0,0x80006
80004f24:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80004f28:	b81fc0ef          	jal	ra,80001aa8 <printk>
80004f2c:	06100593          	li	a1,97
80004f30:	d4448513          	addi	a0,s1,-700
80004f34:	bb1fc0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004f38:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80004f3c:	01c12083          	lw	ra,28(sp)
80004f40:	01812403          	lw	s0,24(sp)
80004f44:	01412483          	lw	s1,20(sp)
80004f48:	01012903          	lw	s2,16(sp)
80004f4c:	00c12983          	lw	s3,12(sp)
80004f50:	00812a03          	lw	s4,8(sp)
80004f54:	02010113          	addi	sp,sp,32
80004f58:	00008067          	ret

80004f5c <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80004f5c:	fd010113          	addi	sp,sp,-48
80004f60:	02812423          	sw	s0,40(sp)
80004f64:	01412c23          	sw	s4,24(sp)
80004f68:	02112623          	sw	ra,44(sp)
80004f6c:	02912223          	sw	s1,36(sp)
80004f70:	03212023          	sw	s2,32(sp)
80004f74:	01312e23          	sw	s3,28(sp)
80004f78:	01512a23          	sw	s5,20(sp)
80004f7c:	01612823          	sw	s6,16(sp)
80004f80:	01712623          	sw	s7,12(sp)
80004f84:	01812423          	sw	s8,8(sp)
80004f88:	01912223          	sw	s9,4(sp)
80004f8c:	01a12023          	sw	s10,0(sp)
80004f90:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004f94:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80004f98:	c44fe0ef          	jal	ra,800033dc <z_time_slice>
80004f9c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004fa0:	80006937          	lui	s2,0x80006
80004fa4:	34490513          	addi	a0,s2,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
	key = (mstatus & SOC_MSTATUS_IEN);
80004fa8:	00847413          	andi	s0,s0,8
80004fac:	d64ff0ef          	jal	ra,80004510 <z_spin_lock_valid>
80004fb0:	02051e63          	bnez	a0,80004fec <z_clock_announce+0x90>
80004fb4:	800064b7          	lui	s1,0x80006
80004fb8:	800065b7          	lui	a1,0x80006
80004fbc:	80006537          	lui	a0,0x80006
80004fc0:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80004fc4:	04e00693          	li	a3,78
80004fc8:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80004fcc:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80004fd0:	ad9fc0ef          	jal	ra,80001aa8 <printk>
80004fd4:	80006537          	lui	a0,0x80006
80004fd8:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80004fdc:	acdfc0ef          	jal	ra,80001aa8 <printk>
80004fe0:	04e00593          	li	a1,78
80004fe4:	d4448513          	addi	a0,s1,-700
80004fe8:	afdfc0ef          	jal	ra,80001ae4 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80004fec:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
80004ff0:	34490513          	addi	a0,s2,836
80004ff4:	d74ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
80004ff8:	800064b7          	lui	s1,0x80006
80004ffc:	3549a023          	sw	s4,832(s3) # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
	return list->head == list;
80005000:	80006a37          	lui	s4,0x80006
80005004:	34098993          	addi	s3,s3,832
80005008:	2a8a0a13          	addi	s4,s4,680 # 800062a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a9>
8000500c:	30848493          	addi	s1,s1,776 # 80006308 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006309>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005010:	80006ab7          	lui	s5,0x80006
80005014:	80006bb7          	lui	s7,0x80006
80005018:	80006b37          	lui	s6,0x80006
8000501c:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005020:	80006cb7          	lui	s9,0x80006
80005024:	000a2d03          	lw	s10,0(s4)
80005028:	0009a783          	lw	a5,0(s3)
8000502c:	0004a683          	lw	a3,0(s1)
80005030:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005034:	014d0c63          	beq	s10,s4,8000504c <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80005038:	000d0a63          	beqz	s10,8000504c <z_clock_announce+0xf0>
8000503c:	008d2703          	lw	a4,8(s10)
80005040:	0ae7dc63          	bge	a5,a4,800050f8 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80005044:	40f70733          	sub	a4,a4,a5
80005048:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
8000504c:	00d786b3          	add	a3,a5,a3
80005050:	41f7d713          	srai	a4,a5,0x1f
80005054:	00a70733          	add	a4,a4,a0
80005058:	00f6b7b3          	sltu	a5,a3,a5
8000505c:	00e787b3          	add	a5,a5,a4
80005060:	00d4a023          	sw	a3,0(s1)
80005064:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005068:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
8000506c:	969ff0ef          	jal	ra,800049d4 <next_timeout>
80005070:	00000593          	li	a1,0
80005074:	d49fc0ef          	jal	ra,80001dbc <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005078:	34490513          	addi	a0,s2,836
8000507c:	cbcff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80005080:	02051e63          	bnez	a0,800050bc <z_clock_announce+0x160>
80005084:	800064b7          	lui	s1,0x80006
80005088:	800065b7          	lui	a1,0x80006
8000508c:	80006537          	lui	a0,0x80006
80005090:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80005094:	06100693          	li	a3,97
80005098:	d4448613          	addi	a2,s1,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
8000509c:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
800050a0:	a09fc0ef          	jal	ra,80001aa8 <printk>
800050a4:	80006537          	lui	a0,0x80006
800050a8:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
800050ac:	9fdfc0ef          	jal	ra,80001aa8 <printk>
800050b0:	06100593          	li	a1,97
800050b4:	d4448513          	addi	a0,s1,-700
800050b8:	a2dfc0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800050bc:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800050c0:	02c12083          	lw	ra,44(sp)
800050c4:	02812403          	lw	s0,40(sp)
800050c8:	02412483          	lw	s1,36(sp)
800050cc:	02012903          	lw	s2,32(sp)
800050d0:	01c12983          	lw	s3,28(sp)
800050d4:	01812a03          	lw	s4,24(sp)
800050d8:	01412a83          	lw	s5,20(sp)
800050dc:	01012b03          	lw	s6,16(sp)
800050e0:	00c12b83          	lw	s7,12(sp)
800050e4:	00812c03          	lw	s8,8(sp)
800050e8:	00412c83          	lw	s9,4(sp)
800050ec:	00012d03          	lw	s10,0(sp)
800050f0:	03010113          	addi	sp,sp,48
800050f4:	00008067          	ret
		curr_tick += dt;
800050f8:	00d706b3          	add	a3,a4,a3
800050fc:	41f75593          	srai	a1,a4,0x1f
80005100:	00a585b3          	add	a1,a1,a0
80005104:	00e6b633          	sltu	a2,a3,a4
80005108:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
8000510c:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
80005110:	000d0513          	mv	a0,s10
		t->dticks = 0;
80005114:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80005118:	00d4a023          	sw	a3,0(s1)
8000511c:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80005120:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80005124:	871ff0ef          	jal	ra,80004994 <remove_timeout>
80005128:	34490513          	addi	a0,s2,836
8000512c:	c0cff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80005130:	02051663          	bnez	a0,8000515c <z_clock_announce+0x200>
80005134:	d8cb8593          	addi	a1,s7,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
80005138:	06100693          	li	a3,97
8000513c:	d44a8613          	addi	a2,s5,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80005140:	cbcb0513          	addi	a0,s6,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80005144:	965fc0ef          	jal	ra,80001aa8 <printk>
80005148:	da4c0513          	addi	a0,s8,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
8000514c:	95dfc0ef          	jal	ra,80001aa8 <printk>
80005150:	06100593          	li	a1,97
80005154:	d44a8513          	addi	a0,s5,-700
80005158:	98dfc0ef          	jal	ra,80001ae4 <assert_post_action>
8000515c:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80005160:	00cd2783          	lw	a5,12(s10)
80005164:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005168:	00800413          	li	s0,8
8000516c:	000780e7          	jalr	a5
80005170:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005174:	34490513          	addi	a0,s2,836
	key = (mstatus & SOC_MSTATUS_IEN);
80005178:	00847413          	andi	s0,s0,8
8000517c:	b94ff0ef          	jal	ra,80004510 <z_spin_lock_valid>
80005180:	02051863          	bnez	a0,800051b0 <z_clock_announce+0x254>
80005184:	d5cc8593          	addi	a1,s9,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80005188:	04e00693          	li	a3,78
8000518c:	d44a8613          	addi	a2,s5,-700
80005190:	cbcb0513          	addi	a0,s6,-836
80005194:	915fc0ef          	jal	ra,80001aa8 <printk>
80005198:	80006537          	lui	a0,0x80006
8000519c:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
800051a0:	909fc0ef          	jal	ra,80001aa8 <printk>
800051a4:	04e00593          	li	a1,78
800051a8:	d44a8513          	addi	a0,s5,-700
800051ac:	939fc0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
800051b0:	34490513          	addi	a0,s2,836
800051b4:	bb4ff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	return k;
800051b8:	e6dff06f          	j	80005024 <z_clock_announce+0xc8>

800051bc <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
800051bc:	fe010113          	addi	sp,sp,-32
800051c0:	00912a23          	sw	s1,20(sp)
800051c4:	00112e23          	sw	ra,28(sp)
800051c8:	00812c23          	sw	s0,24(sp)
800051cc:	01212823          	sw	s2,16(sp)
800051d0:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800051d4:	00800493          	li	s1,8
800051d8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800051dc:	80006937          	lui	s2,0x80006
800051e0:	34490513          	addi	a0,s2,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
	key = (mstatus & SOC_MSTATUS_IEN);
800051e4:	0084f493          	andi	s1,s1,8
800051e8:	b28ff0ef          	jal	ra,80004510 <z_spin_lock_valid>
800051ec:	02051e63          	bnez	a0,80005228 <z_tick_get+0x6c>
800051f0:	80006437          	lui	s0,0x80006
800051f4:	800065b7          	lui	a1,0x80006
800051f8:	80006537          	lui	a0,0x80006
800051fc:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
80005200:	04e00693          	li	a3,78
80005204:	d4440613          	addi	a2,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80005208:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
8000520c:	89dfc0ef          	jal	ra,80001aa8 <printk>
80005210:	80006537          	lui	a0,0x80006
80005214:	d7450513          	addi	a0,a0,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
80005218:	891fc0ef          	jal	ra,80001aa8 <printk>
8000521c:	04e00593          	li	a1,78
80005220:	d4440513          	addi	a0,s0,-700
80005224:	8c1fc0ef          	jal	ra,80001ae4 <assert_post_action>
	z_spin_lock_set_owner(l);
80005228:	34490513          	addi	a0,s2,836
8000522c:	b3cff0ef          	jal	ra,80004568 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80005230:	d35fc0ef          	jal	ra,80001f64 <z_clock_elapsed>
80005234:	800067b7          	lui	a5,0x80006
80005238:	30878793          	addi	a5,a5,776 # 80006308 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006309>
8000523c:	0007a983          	lw	s3,0(a5)
80005240:	0047a403          	lw	s0,4(a5)
80005244:	013509b3          	add	s3,a0,s3
80005248:	00a9b533          	sltu	a0,s3,a0
8000524c:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005250:	34490513          	addi	a0,s2,836
80005254:	ae4ff0ef          	jal	ra,80004538 <z_spin_unlock_valid>
80005258:	02051e63          	bnez	a0,80005294 <z_tick_get+0xd8>
8000525c:	80006937          	lui	s2,0x80006
80005260:	800065b7          	lui	a1,0x80006
80005264:	80006537          	lui	a0,0x80006
80005268:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
8000526c:	06100693          	li	a3,97
80005270:	d4490613          	addi	a2,s2,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
80005274:	cbc50513          	addi	a0,a0,-836 # 80005cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cbd>
80005278:	831fc0ef          	jal	ra,80001aa8 <printk>
8000527c:	80006537          	lui	a0,0x80006
80005280:	da450513          	addi	a0,a0,-604 # 80005da4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da5>
80005284:	825fc0ef          	jal	ra,80001aa8 <printk>
80005288:	06100593          	li	a1,97
8000528c:	d4490513          	addi	a0,s2,-700
80005290:	855fc0ef          	jal	ra,80001ae4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005294:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80005298:	00040593          	mv	a1,s0
8000529c:	01c12083          	lw	ra,28(sp)
800052a0:	01812403          	lw	s0,24(sp)
800052a4:	00098513          	mv	a0,s3
800052a8:	01412483          	lw	s1,20(sp)
800052ac:	01012903          	lw	s2,16(sp)
800052b0:	00c12983          	lw	s3,12(sp)
800052b4:	02010113          	addi	sp,sp,32
800052b8:	00008067          	ret

800052bc <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
800052bc:	ff010113          	addi	sp,sp,-16
800052c0:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
800052c4:	ef9ff0ef          	jal	ra,800051bc <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
800052c8:	00c12083          	lw	ra,12(sp)
800052cc:	01010113          	addi	sp,sp,16
800052d0:	00008067          	ret

800052d4 <z_impl_k_uptime_get_32>:

u32_t z_impl_k_uptime_get_32(void)
{
800052d4:	ff010113          	addi	sp,sp,-16
800052d8:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get_32());
800052dc:	fe1ff0ef          	jal	ra,800052bc <z_tick_get_32>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800052e0:	3e800613          	li	a2,1000
800052e4:	00000693          	li	a3,0
800052e8:	00000593          	li	a1,0
800052ec:	dccfb0ef          	jal	ra,800008b8 <__muldi3>
800052f0:	06400613          	li	a2,100
800052f4:	00000693          	li	a3,0
800052f8:	fc9fa0ef          	jal	ra,800002c0 <__udivdi3>
}
800052fc:	00c12083          	lw	ra,12(sp)
80005300:	01010113          	addi	sp,sp,16
80005304:	00008067          	ret

80005308 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80005308:	ff010113          	addi	sp,sp,-16
8000530c:	00812423          	sw	s0,8(sp)
80005310:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005314:	80006437          	lui	s0,0x80006
80005318:	800064b7          	lui	s1,0x80006
{
8000531c:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005320:	2ec40413          	addi	s0,s0,748 # 800062ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062ed>
80005324:	2ec48493          	addi	s1,s1,748 # 800062ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062ed>
80005328:	00946e63          	bltu	s0,s1,80005344 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
8000532c:	00c12083          	lw	ra,12(sp)
80005330:	00812403          	lw	s0,8(sp)
80005334:	00412483          	lw	s1,4(sp)
80005338:	00000513          	li	a0,0
8000533c:	01010113          	addi	sp,sp,16
80005340:	00008067          	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80005344:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80005348:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
8000534c:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80005350:	00f42c23          	sw	a5,24(s0)
80005354:	fa1fb0ef          	jal	ra,800012f4 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005358:	01c40413          	addi	s0,s0,28
8000535c:	fcdff06f          	j	80005328 <init_static_pools+0x20>

80005360 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005360:	00008067          	ret
