
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	0f90006f          	j	80000904 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1be000ef          	jal	ra,80000204 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e121                	bnez	a0,8000008e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	12e08093          	addi	ra,ra,302 # 80000198 <no_reschedule>
	tail _Fault
80000072:	60f0006f          	j	80000e80 <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
8000007c:	00005297          	auipc	t0,0x5
80000080:	72c28293          	addi	t0,t0,1836 # 800057a8 <_offload_routine>
	lw t1, 0x00(t0)
80000084:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
80000088:	00031363          	bnez	t1,8000008e <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000008c:	a041                	j	8000010c <reschedule>

8000008e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000008e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000092:	00006397          	auipc	t2,0x6
80000096:	a5a38393          	addi	t2,t2,-1446 # 80005aec <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000009a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000009e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000a0:	c016                	sw	t0,0(sp)

800000a2 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000a2:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000a6:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000a8:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000ac:	00030863          	beqz	t1,800000bc <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000b0:	00000097          	auipc	ra,0x0
800000b4:	03808093          	addi	ra,ra,56 # 800000e8 <on_thread_stack>
	tail z_irq_do_offload
800000b8:	62f0006f          	j	80000ee6 <z_irq_do_offload>

800000bc <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000bc:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000c0:	800002b7          	lui	t0,0x80000
800000c4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000c8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000cc:	128000ef          	jal	ra,800001f4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000d0:	00004297          	auipc	t0,0x4
800000d4:	69028293          	addi	t0,t0,1680 # 80004760 <_image_text_end>
	slli a0, a0, 3
800000d8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000da:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000dc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000e0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000e4:	000300e7          	jalr	t1

800000e8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000e8:	00006317          	auipc	t1,0x6
800000ec:	a0430313          	addi	t1,t1,-1532 # 80005aec <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000f0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000f4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000f6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000fa:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000fc:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000100:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000104:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000108:	087e0863          	beq	t3,t2,80000198 <no_reschedule>

8000010c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000010c:	00006297          	auipc	t0,0x6
80000110:	9e028293          	addi	t0,t0,-1568 # 80005aec <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000114:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000118:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000011c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000120:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000124:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000128:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000012c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000130:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000134:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000138:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000013c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000140:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000144:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000148:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000014c:	00005397          	auipc	t2,0x5
80000150:	5a438393          	addi	t2,t2,1444 # 800056f0 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000154:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000158:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000015c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000160:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000164:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000168:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000016c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000170:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000174:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000178:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000017c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000180:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000184:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000188:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000018c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000190:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000194:	05832d83          	lw	s11,88(t1)

80000198 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000198:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000019a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000019e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001a0:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001a4:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001a6:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001a8:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001aa:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001ac:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ae:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001b0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001b2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001b4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001b6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001b8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001ba:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001bc:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001be:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001c0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001c2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001c4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001c6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001c8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ca:	30200073          	mret
	...

800001d0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001d0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001d4:	00006297          	auipc	t0,0x6
800001d8:	91828293          	addi	t0,t0,-1768 # 80005aec <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001dc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001e0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001e4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001e6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001ea:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001f4:	4305                	li	t1,1
	sll t0, t1, a0
800001f6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001fa:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001fe:	00008067          	ret
	...

80000204 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
80000204:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000208:	80000337          	lui	t1,0x80000
	and t0, t0, t1
8000020c:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000210:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000214:	00028363          	beqz	t0,8000021a <not_interrupt>
	addi a0, a0, 1
80000218:	0505                	addi	a0,a0,1

8000021a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000021a:	00008067          	ret

Disassembly of section text:

80000220 <__lshrdi3>:
80000220:	02060063          	beqz	a2,80000240 <__lshrdi3+0x20>
80000224:	02000793          	li	a5,32
80000228:	40c787b3          	sub	a5,a5,a2
8000022c:	00f04c63          	bgtz	a5,80000244 <__lshrdi3+0x24>
80000230:	fe060513          	addi	a0,a2,-32
80000234:	00000713          	li	a4,0
80000238:	00a5d533          	srl	a0,a1,a0
8000023c:	00070593          	mv	a1,a4
80000240:	00008067          	ret
80000244:	00c5d733          	srl	a4,a1,a2
80000248:	00c55533          	srl	a0,a0,a2
8000024c:	00f595b3          	sll	a1,a1,a5
80000250:	00b56533          	or	a0,a0,a1
80000254:	fe9ff06f          	j	8000023c <__lshrdi3+0x1c>

80000258 <__udivdi3>:
80000258:	fd010113          	addi	sp,sp,-48
8000025c:	02912223          	sw	s1,36(sp)
80000260:	01612823          	sw	s6,16(sp)
80000264:	02112623          	sw	ra,44(sp)
80000268:	02812423          	sw	s0,40(sp)
8000026c:	03212023          	sw	s2,32(sp)
80000270:	01312e23          	sw	s3,28(sp)
80000274:	01412c23          	sw	s4,24(sp)
80000278:	01512a23          	sw	s5,20(sp)
8000027c:	01712623          	sw	s7,12(sp)
80000280:	01812423          	sw	s8,8(sp)
80000284:	01912223          	sw	s9,4(sp)
80000288:	00050b13          	mv	s6,a0
8000028c:	00058493          	mv	s1,a1
80000290:	38069c63          	bnez	a3,80000628 <__udivdi3+0x3d0>
80000294:	00060413          	mv	s0,a2
80000298:	00050993          	mv	s3,a0
8000029c:	00004917          	auipc	s2,0x4
800002a0:	64490913          	addi	s2,s2,1604 # 800048e0 <__devconfig_end>
800002a4:	12c5f863          	bgeu	a1,a2,800003d4 <__udivdi3+0x17c>
800002a8:	000107b7          	lui	a5,0x10
800002ac:	00058a93          	mv	s5,a1
800002b0:	10f67863          	bgeu	a2,a5,800003c0 <__udivdi3+0x168>
800002b4:	0ff00693          	li	a3,255
800002b8:	00c6b6b3          	sltu	a3,a3,a2
800002bc:	00369693          	slli	a3,a3,0x3
800002c0:	00d657b3          	srl	a5,a2,a3
800002c4:	00f90933          	add	s2,s2,a5
800002c8:	00094703          	lbu	a4,0(s2)
800002cc:	00d706b3          	add	a3,a4,a3
800002d0:	02000713          	li	a4,32
800002d4:	40d70733          	sub	a4,a4,a3
800002d8:	00070c63          	beqz	a4,800002f0 <__udivdi3+0x98>
800002dc:	00e494b3          	sll	s1,s1,a4
800002e0:	00db56b3          	srl	a3,s6,a3
800002e4:	00e61433          	sll	s0,a2,a4
800002e8:	0096eab3          	or	s5,a3,s1
800002ec:	00eb19b3          	sll	s3,s6,a4
800002f0:	01045b13          	srli	s6,s0,0x10
800002f4:	000b0593          	mv	a1,s6
800002f8:	000a8513          	mv	a0,s5
800002fc:	5a4000ef          	jal	ra,800008a0 <__umodsi3>
80000300:	00050913          	mv	s2,a0
80000304:	000b0593          	mv	a1,s6
80000308:	01041b93          	slli	s7,s0,0x10
8000030c:	000a8513          	mv	a0,s5
80000310:	548000ef          	jal	ra,80000858 <__udivsi3>
80000314:	010bdb93          	srli	s7,s7,0x10
80000318:	00050493          	mv	s1,a0
8000031c:	00050593          	mv	a1,a0
80000320:	000b8513          	mv	a0,s7
80000324:	508000ef          	jal	ra,8000082c <__mulsi3>
80000328:	01091913          	slli	s2,s2,0x10
8000032c:	0109d713          	srli	a4,s3,0x10
80000330:	00e96733          	or	a4,s2,a4
80000334:	00048a13          	mv	s4,s1
80000338:	00a77e63          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000033c:	00870733          	add	a4,a4,s0
80000340:	fff48a13          	addi	s4,s1,-1
80000344:	00876863          	bltu	a4,s0,80000354 <__udivdi3+0xfc>
80000348:	00a77663          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000034c:	ffe48a13          	addi	s4,s1,-2
80000350:	00870733          	add	a4,a4,s0
80000354:	40a704b3          	sub	s1,a4,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	540000ef          	jal	ra,800008a0 <__umodsi3>
80000364:	00050913          	mv	s2,a0
80000368:	000b0593          	mv	a1,s6
8000036c:	00048513          	mv	a0,s1
80000370:	4e8000ef          	jal	ra,80000858 <__udivsi3>
80000374:	01099993          	slli	s3,s3,0x10
80000378:	00050493          	mv	s1,a0
8000037c:	00050593          	mv	a1,a0
80000380:	01091913          	slli	s2,s2,0x10
80000384:	000b8513          	mv	a0,s7
80000388:	0109d993          	srli	s3,s3,0x10
8000038c:	4a0000ef          	jal	ra,8000082c <__mulsi3>
80000390:	013969b3          	or	s3,s2,s3
80000394:	00048613          	mv	a2,s1
80000398:	00a9fc63          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
8000039c:	013409b3          	add	s3,s0,s3
800003a0:	fff48613          	addi	a2,s1,-1
800003a4:	0089e663          	bltu	s3,s0,800003b0 <__udivdi3+0x158>
800003a8:	00a9f463          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
800003ac:	ffe48613          	addi	a2,s1,-2
800003b0:	010a1793          	slli	a5,s4,0x10
800003b4:	00c7e7b3          	or	a5,a5,a2
800003b8:	00000a13          	li	s4,0
800003bc:	1300006f          	j	800004ec <__udivdi3+0x294>
800003c0:	010007b7          	lui	a5,0x1000
800003c4:	01000693          	li	a3,16
800003c8:	eef66ce3          	bltu	a2,a5,800002c0 <__udivdi3+0x68>
800003cc:	01800693          	li	a3,24
800003d0:	ef1ff06f          	j	800002c0 <__udivdi3+0x68>
800003d4:	00068a13          	mv	s4,a3
800003d8:	00061a63          	bnez	a2,800003ec <__udivdi3+0x194>
800003dc:	00000593          	li	a1,0
800003e0:	00100513          	li	a0,1
800003e4:	474000ef          	jal	ra,80000858 <__udivsi3>
800003e8:	00050413          	mv	s0,a0
800003ec:	000107b7          	lui	a5,0x10
800003f0:	12f47c63          	bgeu	s0,a5,80000528 <__udivdi3+0x2d0>
800003f4:	0ff00793          	li	a5,255
800003f8:	0087f463          	bgeu	a5,s0,80000400 <__udivdi3+0x1a8>
800003fc:	00800a13          	li	s4,8
80000400:	014457b3          	srl	a5,s0,s4
80000404:	00f90933          	add	s2,s2,a5
80000408:	00094683          	lbu	a3,0(s2)
8000040c:	02000613          	li	a2,32
80000410:	014686b3          	add	a3,a3,s4
80000414:	40d60633          	sub	a2,a2,a3
80000418:	12061263          	bnez	a2,8000053c <__udivdi3+0x2e4>
8000041c:	408484b3          	sub	s1,s1,s0
80000420:	00100a13          	li	s4,1
80000424:	01045b13          	srli	s6,s0,0x10
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	470000ef          	jal	ra,800008a0 <__umodsi3>
80000434:	00050913          	mv	s2,a0
80000438:	000b0593          	mv	a1,s6
8000043c:	00048513          	mv	a0,s1
80000440:	01041b93          	slli	s7,s0,0x10
80000444:	414000ef          	jal	ra,80000858 <__udivsi3>
80000448:	010bdb93          	srli	s7,s7,0x10
8000044c:	00050493          	mv	s1,a0
80000450:	00050593          	mv	a1,a0
80000454:	000b8513          	mv	a0,s7
80000458:	3d4000ef          	jal	ra,8000082c <__mulsi3>
8000045c:	01091913          	slli	s2,s2,0x10
80000460:	0109d713          	srli	a4,s3,0x10
80000464:	00e96733          	or	a4,s2,a4
80000468:	00048a93          	mv	s5,s1
8000046c:	00a77e63          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000470:	00870733          	add	a4,a4,s0
80000474:	fff48a93          	addi	s5,s1,-1
80000478:	00876863          	bltu	a4,s0,80000488 <__udivdi3+0x230>
8000047c:	00a77663          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000480:	ffe48a93          	addi	s5,s1,-2
80000484:	00870733          	add	a4,a4,s0
80000488:	40a704b3          	sub	s1,a4,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	40c000ef          	jal	ra,800008a0 <__umodsi3>
80000498:	00050913          	mv	s2,a0
8000049c:	000b0593          	mv	a1,s6
800004a0:	00048513          	mv	a0,s1
800004a4:	3b4000ef          	jal	ra,80000858 <__udivsi3>
800004a8:	01099993          	slli	s3,s3,0x10
800004ac:	00050493          	mv	s1,a0
800004b0:	00050593          	mv	a1,a0
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	000b8513          	mv	a0,s7
800004bc:	0109d993          	srli	s3,s3,0x10
800004c0:	36c000ef          	jal	ra,8000082c <__mulsi3>
800004c4:	013969b3          	or	s3,s2,s3
800004c8:	00048613          	mv	a2,s1
800004cc:	00a9fc63          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004d0:	013409b3          	add	s3,s0,s3
800004d4:	fff48613          	addi	a2,s1,-1
800004d8:	0089e663          	bltu	s3,s0,800004e4 <__udivdi3+0x28c>
800004dc:	00a9f463          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004e0:	ffe48613          	addi	a2,s1,-2
800004e4:	010a9793          	slli	a5,s5,0x10
800004e8:	00c7e7b3          	or	a5,a5,a2
800004ec:	00078513          	mv	a0,a5
800004f0:	000a0593          	mv	a1,s4
800004f4:	02c12083          	lw	ra,44(sp)
800004f8:	02812403          	lw	s0,40(sp)
800004fc:	02412483          	lw	s1,36(sp)
80000500:	02012903          	lw	s2,32(sp)
80000504:	01c12983          	lw	s3,28(sp)
80000508:	01812a03          	lw	s4,24(sp)
8000050c:	01412a83          	lw	s5,20(sp)
80000510:	01012b03          	lw	s6,16(sp)
80000514:	00c12b83          	lw	s7,12(sp)
80000518:	00812c03          	lw	s8,8(sp)
8000051c:	00412c83          	lw	s9,4(sp)
80000520:	03010113          	addi	sp,sp,48
80000524:	00008067          	ret
80000528:	010007b7          	lui	a5,0x1000
8000052c:	01000a13          	li	s4,16
80000530:	ecf468e3          	bltu	s0,a5,80000400 <__udivdi3+0x1a8>
80000534:	01800a13          	li	s4,24
80000538:	ec9ff06f          	j	80000400 <__udivdi3+0x1a8>
8000053c:	00c41433          	sll	s0,s0,a2
80000540:	00d4da33          	srl	s4,s1,a3
80000544:	00cb19b3          	sll	s3,s6,a2
80000548:	00db56b3          	srl	a3,s6,a3
8000054c:	01045b13          	srli	s6,s0,0x10
80000550:	00c494b3          	sll	s1,s1,a2
80000554:	000b0593          	mv	a1,s6
80000558:	000a0513          	mv	a0,s4
8000055c:	0096eab3          	or	s5,a3,s1
80000560:	340000ef          	jal	ra,800008a0 <__umodsi3>
80000564:	00050913          	mv	s2,a0
80000568:	000b0593          	mv	a1,s6
8000056c:	000a0513          	mv	a0,s4
80000570:	01041b93          	slli	s7,s0,0x10
80000574:	2e4000ef          	jal	ra,80000858 <__udivsi3>
80000578:	010bdb93          	srli	s7,s7,0x10
8000057c:	00050493          	mv	s1,a0
80000580:	00050593          	mv	a1,a0
80000584:	000b8513          	mv	a0,s7
80000588:	2a4000ef          	jal	ra,8000082c <__mulsi3>
8000058c:	01091913          	slli	s2,s2,0x10
80000590:	010ad713          	srli	a4,s5,0x10
80000594:	00e96733          	or	a4,s2,a4
80000598:	00048a13          	mv	s4,s1
8000059c:	00a77e63          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005a0:	00870733          	add	a4,a4,s0
800005a4:	fff48a13          	addi	s4,s1,-1
800005a8:	00876863          	bltu	a4,s0,800005b8 <__udivdi3+0x360>
800005ac:	00a77663          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005b0:	ffe48a13          	addi	s4,s1,-2
800005b4:	00870733          	add	a4,a4,s0
800005b8:	40a704b3          	sub	s1,a4,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	2dc000ef          	jal	ra,800008a0 <__umodsi3>
800005c8:	00050913          	mv	s2,a0
800005cc:	000b0593          	mv	a1,s6
800005d0:	00048513          	mv	a0,s1
800005d4:	284000ef          	jal	ra,80000858 <__udivsi3>
800005d8:	00050493          	mv	s1,a0
800005dc:	00050593          	mv	a1,a0
800005e0:	000b8513          	mv	a0,s7
800005e4:	248000ef          	jal	ra,8000082c <__mulsi3>
800005e8:	010a9693          	slli	a3,s5,0x10
800005ec:	01091913          	slli	s2,s2,0x10
800005f0:	0106d693          	srli	a3,a3,0x10
800005f4:	00d967b3          	or	a5,s2,a3
800005f8:	00048713          	mv	a4,s1
800005fc:	00a7fe63          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000600:	008787b3          	add	a5,a5,s0
80000604:	fff48713          	addi	a4,s1,-1
80000608:	0087e863          	bltu	a5,s0,80000618 <__udivdi3+0x3c0>
8000060c:	00a7f663          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000610:	ffe48713          	addi	a4,s1,-2
80000614:	008787b3          	add	a5,a5,s0
80000618:	010a1a13          	slli	s4,s4,0x10
8000061c:	40a784b3          	sub	s1,a5,a0
80000620:	00ea6a33          	or	s4,s4,a4
80000624:	e01ff06f          	j	80000424 <__udivdi3+0x1cc>
80000628:	1ed5ec63          	bltu	a1,a3,80000820 <__udivdi3+0x5c8>
8000062c:	000107b7          	lui	a5,0x10
80000630:	04f6f463          	bgeu	a3,a5,80000678 <__udivdi3+0x420>
80000634:	0ff00593          	li	a1,255
80000638:	00d5b533          	sltu	a0,a1,a3
8000063c:	00351513          	slli	a0,a0,0x3
80000640:	00a6d733          	srl	a4,a3,a0
80000644:	00004797          	auipc	a5,0x4
80000648:	29c78793          	addi	a5,a5,668 # 800048e0 <__devconfig_end>
8000064c:	00e787b3          	add	a5,a5,a4
80000650:	0007c583          	lbu	a1,0(a5)
80000654:	02000a13          	li	s4,32
80000658:	00a585b3          	add	a1,a1,a0
8000065c:	40ba0a33          	sub	s4,s4,a1
80000660:	020a1663          	bnez	s4,8000068c <__udivdi3+0x434>
80000664:	00100793          	li	a5,1
80000668:	e896e2e3          	bltu	a3,s1,800004ec <__udivdi3+0x294>
8000066c:	00cb3633          	sltu	a2,s6,a2
80000670:	00164793          	xori	a5,a2,1
80000674:	e79ff06f          	j	800004ec <__udivdi3+0x294>
80000678:	010007b7          	lui	a5,0x1000
8000067c:	01000513          	li	a0,16
80000680:	fcf6e0e3          	bltu	a3,a5,80000640 <__udivdi3+0x3e8>
80000684:	01800513          	li	a0,24
80000688:	fb9ff06f          	j	80000640 <__udivdi3+0x3e8>
8000068c:	00b65ab3          	srl	s5,a2,a1
80000690:	014696b3          	sll	a3,a3,s4
80000694:	00daeab3          	or	s5,s5,a3
80000698:	00b4d933          	srl	s2,s1,a1
8000069c:	014497b3          	sll	a5,s1,s4
800006a0:	00bb55b3          	srl	a1,s6,a1
800006a4:	010adb93          	srli	s7,s5,0x10
800006a8:	00f5e4b3          	or	s1,a1,a5
800006ac:	00090513          	mv	a0,s2
800006b0:	000b8593          	mv	a1,s7
800006b4:	014619b3          	sll	s3,a2,s4
800006b8:	1e8000ef          	jal	ra,800008a0 <__umodsi3>
800006bc:	00050413          	mv	s0,a0
800006c0:	000b8593          	mv	a1,s7
800006c4:	00090513          	mv	a0,s2
800006c8:	010a9c13          	slli	s8,s5,0x10
800006cc:	18c000ef          	jal	ra,80000858 <__udivsi3>
800006d0:	010c5c13          	srli	s8,s8,0x10
800006d4:	00050913          	mv	s2,a0
800006d8:	00050593          	mv	a1,a0
800006dc:	000c0513          	mv	a0,s8
800006e0:	14c000ef          	jal	ra,8000082c <__mulsi3>
800006e4:	01041413          	slli	s0,s0,0x10
800006e8:	0104d713          	srli	a4,s1,0x10
800006ec:	00e46733          	or	a4,s0,a4
800006f0:	00090c93          	mv	s9,s2
800006f4:	00a77e63          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
800006f8:	01570733          	add	a4,a4,s5
800006fc:	fff90c93          	addi	s9,s2,-1
80000700:	01576863          	bltu	a4,s5,80000710 <__udivdi3+0x4b8>
80000704:	00a77663          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
80000708:	ffe90c93          	addi	s9,s2,-2
8000070c:	01570733          	add	a4,a4,s5
80000710:	40a70933          	sub	s2,a4,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	184000ef          	jal	ra,800008a0 <__umodsi3>
80000720:	00050413          	mv	s0,a0
80000724:	000b8593          	mv	a1,s7
80000728:	00090513          	mv	a0,s2
8000072c:	12c000ef          	jal	ra,80000858 <__udivsi3>
80000730:	00050913          	mv	s2,a0
80000734:	00050593          	mv	a1,a0
80000738:	000c0513          	mv	a0,s8
8000073c:	0f0000ef          	jal	ra,8000082c <__mulsi3>
80000740:	01049793          	slli	a5,s1,0x10
80000744:	01041413          	slli	s0,s0,0x10
80000748:	0107d793          	srli	a5,a5,0x10
8000074c:	00f46733          	or	a4,s0,a5
80000750:	00090613          	mv	a2,s2
80000754:	00a77e63          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000758:	01570733          	add	a4,a4,s5
8000075c:	fff90613          	addi	a2,s2,-1
80000760:	01576863          	bltu	a4,s5,80000770 <__udivdi3+0x518>
80000764:	00a77663          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000768:	ffe90613          	addi	a2,s2,-2
8000076c:	01570733          	add	a4,a4,s5
80000770:	010c9793          	slli	a5,s9,0x10
80000774:	00010e37          	lui	t3,0x10
80000778:	00c7e7b3          	or	a5,a5,a2
8000077c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000780:	0107f333          	and	t1,a5,a6
80000784:	0109f833          	and	a6,s3,a6
80000788:	40a70733          	sub	a4,a4,a0
8000078c:	0107de93          	srli	t4,a5,0x10
80000790:	0109d993          	srli	s3,s3,0x10
80000794:	00030513          	mv	a0,t1
80000798:	00080593          	mv	a1,a6
8000079c:	090000ef          	jal	ra,8000082c <__mulsi3>
800007a0:	00050893          	mv	a7,a0
800007a4:	00098593          	mv	a1,s3
800007a8:	00030513          	mv	a0,t1
800007ac:	080000ef          	jal	ra,8000082c <__mulsi3>
800007b0:	00050313          	mv	t1,a0
800007b4:	00080593          	mv	a1,a6
800007b8:	000e8513          	mv	a0,t4
800007bc:	070000ef          	jal	ra,8000082c <__mulsi3>
800007c0:	00050813          	mv	a6,a0
800007c4:	00098593          	mv	a1,s3
800007c8:	000e8513          	mv	a0,t4
800007cc:	060000ef          	jal	ra,8000082c <__mulsi3>
800007d0:	0108d693          	srli	a3,a7,0x10
800007d4:	01030333          	add	t1,t1,a6
800007d8:	006686b3          	add	a3,a3,t1
800007dc:	0106f463          	bgeu	a3,a6,800007e4 <__udivdi3+0x58c>
800007e0:	01c50533          	add	a0,a0,t3
800007e4:	0106d613          	srli	a2,a3,0x10
800007e8:	00a60533          	add	a0,a2,a0
800007ec:	02a76663          	bltu	a4,a0,80000818 <__udivdi3+0x5c0>
800007f0:	bca714e3          	bne	a4,a0,800003b8 <__udivdi3+0x160>
800007f4:	00010737          	lui	a4,0x10
800007f8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007fc:	00e6f6b3          	and	a3,a3,a4
80000800:	01069693          	slli	a3,a3,0x10
80000804:	00e8f8b3          	and	a7,a7,a4
80000808:	014b1633          	sll	a2,s6,s4
8000080c:	011686b3          	add	a3,a3,a7
80000810:	00000a13          	li	s4,0
80000814:	ccd67ce3          	bgeu	a2,a3,800004ec <__udivdi3+0x294>
80000818:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000081c:	b9dff06f          	j	800003b8 <__udivdi3+0x160>
80000820:	00000a13          	li	s4,0
80000824:	00000793          	li	a5,0
80000828:	cc5ff06f          	j	800004ec <__udivdi3+0x294>

8000082c <__mulsi3>:
8000082c:	00050613          	mv	a2,a0
80000830:	00000513          	li	a0,0
80000834:	0015f693          	andi	a3,a1,1
80000838:	00068463          	beqz	a3,80000840 <__mulsi3+0x14>
8000083c:	00c50533          	add	a0,a0,a2
80000840:	0015d593          	srli	a1,a1,0x1
80000844:	00161613          	slli	a2,a2,0x1
80000848:	fe0596e3          	bnez	a1,80000834 <__mulsi3+0x8>
8000084c:	00008067          	ret

80000850 <__divsi3>:
80000850:	06054063          	bltz	a0,800008b0 <__umodsi3+0x10>
80000854:	0605c663          	bltz	a1,800008c0 <__umodsi3+0x20>

80000858 <__udivsi3>:
80000858:	00058613          	mv	a2,a1
8000085c:	00050593          	mv	a1,a0
80000860:	fff00513          	li	a0,-1
80000864:	02060c63          	beqz	a2,8000089c <__udivsi3+0x44>
80000868:	00100693          	li	a3,1
8000086c:	00b67a63          	bgeu	a2,a1,80000880 <__udivsi3+0x28>
80000870:	00c05863          	blez	a2,80000880 <__udivsi3+0x28>
80000874:	00161613          	slli	a2,a2,0x1
80000878:	00169693          	slli	a3,a3,0x1
8000087c:	feb66ae3          	bltu	a2,a1,80000870 <__udivsi3+0x18>
80000880:	00000513          	li	a0,0
80000884:	00c5e663          	bltu	a1,a2,80000890 <__udivsi3+0x38>
80000888:	40c585b3          	sub	a1,a1,a2
8000088c:	00d56533          	or	a0,a0,a3
80000890:	0016d693          	srli	a3,a3,0x1
80000894:	00165613          	srli	a2,a2,0x1
80000898:	fe0696e3          	bnez	a3,80000884 <__udivsi3+0x2c>
8000089c:	00008067          	ret

800008a0 <__umodsi3>:
800008a0:	00008293          	mv	t0,ra
800008a4:	fb5ff0ef          	jal	ra,80000858 <__udivsi3>
800008a8:	00058513          	mv	a0,a1
800008ac:	00028067          	jr	t0
800008b0:	40a00533          	neg	a0,a0
800008b4:	0005d863          	bgez	a1,800008c4 <__umodsi3+0x24>
800008b8:	40b005b3          	neg	a1,a1
800008bc:	f9dff06f          	j	80000858 <__udivsi3>
800008c0:	40b005b3          	neg	a1,a1
800008c4:	00008293          	mv	t0,ra
800008c8:	f91ff0ef          	jal	ra,80000858 <__udivsi3>
800008cc:	40a00533          	neg	a0,a0
800008d0:	00028067          	jr	t0

800008d4 <__modsi3>:
800008d4:	00008293          	mv	t0,ra
800008d8:	0005ca63          	bltz	a1,800008ec <__modsi3+0x18>
800008dc:	00054c63          	bltz	a0,800008f4 <__modsi3+0x20>
800008e0:	f79ff0ef          	jal	ra,80000858 <__udivsi3>
800008e4:	00058513          	mv	a0,a1
800008e8:	00028067          	jr	t0
800008ec:	40b005b3          	neg	a1,a1
800008f0:	fe0558e3          	bgez	a0,800008e0 <__modsi3+0xc>
800008f4:	40a00533          	neg	a0,a0
800008f8:	f61ff0ef          	jal	ra,80000858 <__udivsi3>
800008fc:	40b00533          	neg	a0,a1
80000900:	00028067          	jr	t0

80000904 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000904:	00006117          	auipc	sp,0x6
80000908:	c1c10113          	addi	sp,sp,-996 # 80006520 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
8000090c:	000012b7          	lui	t0,0x1
80000910:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000914:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000916:	2d09                	jal	80000f28 <_PrepC>

80000918 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000918:	45b0006f          	j	80001572 <z_thread_entry>
	...

8000091e <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
8000091e:	8082                	ret

80000920 <test_stack_user_thread2thread>:
	static void _name(void)	   \
	{			   \
		ztest_test_skip(); \
	}

dummy_test(test_stack_user_thread2thread);
80000920:	6500106f          	j	80001f70 <ztest_test_skip>

80000924 <test_stack_user_pop_fail>:
80000924:	64c0106f          	j	80001f70 <ztest_test_skip>

80000928 <test_main>:
 * @{
 * @}
 */
/*test case main entry*/
void test_main(void)
{
80000928:	1141                	addi	sp,sp,-16
8000092a:	c606                	sw	ra,12(sp)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000092c:	205020ef          	jal	ra,80003330 <z_impl_k_current_get>
80000930:	201020ef          	jal	ra,80003330 <z_impl_k_current_get>
80000934:	1fd020ef          	jal	ra,80003330 <z_impl_k_current_get>
80000938:	1f9020ef          	jal	ra,80003330 <z_impl_k_current_get>
8000093c:	1f5020ef          	jal	ra,80003330 <z_impl_k_current_get>
80000940:	1f1020ef          	jal	ra,80003330 <z_impl_k_current_get>
 * @req K-THREAD-005
 */
static inline void k_thread_resource_pool_assign(struct k_thread *thread,
						 struct k_mem_pool *pool)
{
	thread->resource_pool = pool;
80000944:	800057b7          	lui	a5,0x80005
			 ztest_unit_test(test_stack_thread2isr),
			 ztest_unit_test(test_stack_pop_fail),
			 ztest_user_unit_test(test_stack_user_pop_fail),
			 ztest_unit_test(test_stack_alloc_thread2thread));
	ztest_run_test_suite(stack_api);
}
80000948:	40b2                	lw	ra,12(sp)
8000094a:	72878793          	addi	a5,a5,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
8000094e:	d53c                	sw	a5,104(a0)
	ztest_run_test_suite(stack_api);
80000950:	800055b7          	lui	a1,0x80005
80000954:	80005537          	lui	a0,0x80005
80000958:	64058593          	addi	a1,a1,1600 # 80005640 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005641>
8000095c:	a8450513          	addi	a0,a0,-1404 # 80004a84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a85>
}
80000960:	0141                	addi	sp,sp,16
	ztest_run_test_suite(stack_api);
80000962:	6340106f          	j	80001f96 <z_ztest_run_test_suite>

80000966 <tstack_push>:
struct k_thread thread_data;
static ZTEST_DMEM u32_t data[STACK_LEN] = { 0xABCD, 0x1234 };
struct k_sem end_sema;

static void tstack_push(struct k_stack *pstack)
{
80000966:	1141                	addi	sp,sp,-16
80000968:	c422                	sw	s0,8(sp)
8000096a:	80005437          	lui	s0,0x80005
8000096e:	6cc40413          	addi	s0,s0,1740 # 800056cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056cd>
80000972:	c226                	sw	s1,4(sp)
80000974:	c04a                	sw	s2,0(sp)
80000976:	c606                	sw	ra,12(sp)
80000978:	892a                	mv	s2,a0
8000097a:	01040493          	addi	s1,s0,16

K_SYSCALL_DECLARE1(K_SYSCALL_K_QUEUE_PEEK_TAIL, k_queue_peek_tail, void *, struct k_queue *, queue)

K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_STACK_PUSH, k_stack_push, struct k_stack *, stack, u32_t, data)
8000097e:	400c                	lw	a1,0(s0)
80000980:	854a                	mv	a0,s2
80000982:	0411                	addi	s0,s0,4
80000984:	519020ef          	jal	ra,8000369c <z_impl_k_stack_push>
	for (int i = 0; i < STACK_LEN; i++) {
80000988:	fe941be3          	bne	s0,s1,8000097e <tstack_push+0x18>
		/**TESTPOINT: stack push*/
		k_stack_push(pstack, data[i]);
	}
}
8000098c:	40b2                	lw	ra,12(sp)
8000098e:	4422                	lw	s0,8(sp)
80000990:	4492                	lw	s1,4(sp)
80000992:	4902                	lw	s2,0(sp)
80000994:	0141                	addi	sp,sp,16
80000996:	8082                	ret

80000998 <tIsr_entry_push>:
}

/*entry of contexts*/
static void tIsr_entry_push(void *p)
{
	tstack_push((struct k_stack *)p);
80000998:	b7f9                	j	80000966 <tstack_push>

8000099a <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
8000099a:	7179                	addi	sp,sp,-48
8000099c:	ce06                	sw	ra,28(sp)
8000099e:	cc22                	sw	s0,24(sp)
800009a0:	d442                	sw	a6,40(sp)
800009a2:	d646                	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
800009a4:	ed0d                	bnez	a0,800009de <z_zassert.constprop.0+0x44>
800009a6:	8636                	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009a8:	80005537          	lui	a0,0x80005
800009ac:	86ba                	mv	a3,a4
800009ae:	872e                	mv	a4,a1
800009b0:	800055b7          	lui	a1,0x80005
800009b4:	843e                	mv	s0,a5
800009b6:	b5c58593          	addi	a1,a1,-1188 # 80004b5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b5d>
		va_start(vargs, msg);
800009ba:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009bc:	b9850513          	addi	a0,a0,-1128 # 80004b98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b99>
		va_start(vargs, msg);
800009c0:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009c2:	7fd000ef          	jal	ra,800019be <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
800009c6:	45b2                	lw	a1,12(sp)
800009c8:	8522                	mv	a0,s0
800009ca:	7d9000ef          	jal	ra,800019a2 <vprintk>
		printk("\n");
800009ce:	80005537          	lui	a0,0x80005
800009d2:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
800009d6:	7e9000ef          	jal	ra,800019be <printk>
		va_end(vargs);
		ztest_test_fail();
800009da:	570010ef          	jal	ra,80001f4a <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
800009de:	40f2                	lw	ra,28(sp)
800009e0:	4462                	lw	s0,24(sp)
800009e2:	6145                	addi	sp,sp,48
800009e4:	8082                	ret

800009e6 <tstack_pop>:
{
800009e6:	7139                	addi	sp,sp,-64
800009e8:	dc22                	sw	s0,56(sp)
800009ea:	80005437          	lui	s0,0x80005
800009ee:	6cc40413          	addi	s0,s0,1740 # 800056cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056cd>
800009f2:	da26                	sw	s1,52(sp)
800009f4:	d84a                	sw	s2,48(sp)
800009f6:	d64e                	sw	s3,44(sp)
800009f8:	d452                	sw	s4,40(sp)
800009fa:	d256                	sw	s5,36(sp)
800009fc:	d05a                	sw	s6,32(sp)
800009fe:	ce5e                	sw	s7,28(sp)
80000a00:	de06                	sw	ra,60(sp)
80000a02:	8baa                	mv	s7,a0
80000a04:	ff040a13          	addi	s4,s0,-16
		zassert_false(k_stack_pop(pstack, &rx_data, K_NO_WAIT), NULL);
80000a08:	80005937          	lui	s2,0x80005
80000a0c:	800059b7          	lui	s3,0x80005
80000a10:	800054b7          	lui	s1,0x80005
80000a14:	80005b37          	lui	s6,0x80005
		zassert_equal(rx_data, data[i], NULL);
80000a18:	80005ab7          	lui	s5,0x80005

K_SYSCALL_DECLARE3(K_SYSCALL_K_STACK_POP, k_stack_pop, int, struct k_stack *, stack, u32_t *, data, s32_t, timeout)
80000a1c:	4601                	li	a2,0
80000a1e:	006c                	addi	a1,sp,12
80000a20:	855e                	mv	a0,s7
80000a22:	5af020ef          	jal	ra,800037d0 <z_impl_k_stack_pop>
		zassert_false(k_stack_pop(pstack, &rx_data, K_NO_WAIT), NULL);
80000a26:	cd498793          	addi	a5,s3,-812 # 80004cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cd5>
80000a2a:	a9090713          	addi	a4,s2,-1392 # 80004a90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a91>
80000a2e:	02400693          	li	a3,36
80000a32:	b5c48613          	addi	a2,s1,-1188 # 80004b5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b5d>
80000a36:	b08b0593          	addi	a1,s6,-1272 # 80004b08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b09>
80000a3a:	00153513          	seqz	a0,a0
80000a3e:	3fb1                	jal	8000099a <z_zassert.constprop.0>
		zassert_equal(rx_data, data[i], NULL);
80000a40:	4448                	lw	a0,12(s0)
80000a42:	47b2                	lw	a5,12(sp)
80000a44:	a9090713          	addi	a4,s2,-1392
80000a48:	02500693          	li	a3,37
80000a4c:	8d1d                	sub	a0,a0,a5
80000a4e:	b5c48613          	addi	a2,s1,-1188
80000a52:	cd498793          	addi	a5,s3,-812
80000a56:	b3ca8593          	addi	a1,s5,-1220 # 80004b3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b3d>
80000a5a:	00153513          	seqz	a0,a0
80000a5e:	1471                	addi	s0,s0,-4
80000a60:	3f2d                	jal	8000099a <z_zassert.constprop.0>
	for (int i = STACK_LEN - 1; i >= 0; i--) {
80000a62:	fb441de3          	bne	s0,s4,80000a1c <tstack_pop+0x36>
}
80000a66:	50f2                	lw	ra,60(sp)
80000a68:	5462                	lw	s0,56(sp)
80000a6a:	54d2                	lw	s1,52(sp)
80000a6c:	5942                	lw	s2,48(sp)
80000a6e:	59b2                	lw	s3,44(sp)
80000a70:	5a22                	lw	s4,40(sp)
80000a72:	5a92                	lw	s5,36(sp)
80000a74:	5b02                	lw	s6,32(sp)
80000a76:	4bf2                	lw	s7,28(sp)
80000a78:	6121                	addi	sp,sp,64
80000a7a:	8082                	ret

80000a7c <tThread_entry>:
{
	tstack_pop((struct k_stack *)p);
}

static void tThread_entry(void *p1, void *p2, void *p3)
{
80000a7c:	1141                	addi	sp,sp,-16
80000a7e:	c606                	sw	ra,12(sp)
80000a80:	c422                	sw	s0,8(sp)
80000a82:	c226                	sw	s1,4(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000a84:	80006437          	lui	s0,0x80006
80000a88:	84aa                	mv	s1,a0
	tstack_pop((struct k_stack *)p1);
80000a8a:	3fb1                	jal	800009e6 <tstack_pop>
80000a8c:	8f040513          	addi	a0,s0,-1808 # 800058f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f1>
80000a90:	14b020ef          	jal	ra,800033da <z_impl_k_sem_give>
	k_sem_give(&end_sema);
	tstack_push((struct k_stack *)p1);
80000a94:	8526                	mv	a0,s1
80000a96:	3dc1                	jal	80000966 <tstack_push>
80000a98:	8f040513          	addi	a0,s0,-1808
	k_sem_give(&end_sema);
}
80000a9c:	4422                	lw	s0,8(sp)
80000a9e:	40b2                	lw	ra,12(sp)
80000aa0:	4492                	lw	s1,4(sp)
80000aa2:	0141                	addi	sp,sp,16
80000aa4:	1370206f          	j	800033da <z_impl_k_sem_give>

80000aa8 <tIsr_entry_pop>:
	tstack_pop((struct k_stack *)p);
80000aa8:	bf3d                	j	800009e6 <tstack_pop>

80000aaa <tstack_thread_isr>:
	/* clear the spawn thread to avoid side effect */
	k_thread_abort(tid);
}

static void tstack_thread_isr(struct k_stack *pstack)
{
80000aaa:	1141                	addi	sp,sp,-16
80000aac:	c422                	sw	s0,8(sp)
80000aae:	842a                	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000ab0:	80006537          	lui	a0,0x80006
80000ab4:	4605                	li	a2,1
80000ab6:	4581                	li	a1,0
80000ab8:	8f050513          	addi	a0,a0,-1808 # 800058f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f1>
80000abc:	c606                	sw	ra,12(sp)
80000abe:	07d020ef          	jal	ra,8000333a <z_impl_k_sem_init>
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: thread-isr data passing via stack*/
	irq_offload(tIsr_entry_push, pstack);
80000ac2:	80001537          	lui	a0,0x80001
80000ac6:	85a2                	mv	a1,s0
80000ac8:	99850513          	addi	a0,a0,-1640 # 80000998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000999>
80000acc:	292d                	jal	80000f06 <irq_offload>
	tstack_pop(pstack);
80000ace:	8522                	mv	a0,s0
80000ad0:	3f19                	jal	800009e6 <tstack_pop>

	tstack_push(pstack);
80000ad2:	8522                	mv	a0,s0
80000ad4:	3d49                	jal	80000966 <tstack_push>
	irq_offload(tIsr_entry_pop, pstack);
80000ad6:	85a2                	mv	a1,s0
}
80000ad8:	4422                	lw	s0,8(sp)
80000ada:	40b2                	lw	ra,12(sp)
	irq_offload(tIsr_entry_pop, pstack);
80000adc:	80001537          	lui	a0,0x80001
80000ae0:	aa850513          	addi	a0,a0,-1368 # 80000aa8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000aa9>
}
80000ae4:	0141                	addi	sp,sp,16
	irq_offload(tIsr_entry_pop, pstack);
80000ae6:	a105                	j	80000f06 <irq_offload>

80000ae8 <tstack_thread_thread>:
{
80000ae8:	1101                	addi	sp,sp,-32
80000aea:	ca26                	sw	s1,20(sp)
80000aec:	800064b7          	lui	s1,0x80006
80000af0:	cc22                	sw	s0,24(sp)
80000af2:	4605                	li	a2,1
80000af4:	842a                	mv	s0,a0
80000af6:	4581                	li	a1,0
80000af8:	8f048513          	addi	a0,s1,-1808 # 800058f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f1>
80000afc:	ce06                	sw	ra,28(sp)
80000afe:	c84a                	sw	s2,16(sp)
80000b00:	03b020ef          	jal	ra,8000333a <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000b04:	47b1                	li	a5,12
80000b06:	800016b7          	lui	a3,0x80001
80000b0a:	800065b7          	lui	a1,0x80006
80000b0e:	80006537          	lui	a0,0x80006
80000b12:	8722                	mv	a4,s0
80000b14:	4881                	li	a7,0
80000b16:	4801                	li	a6,0
80000b18:	a7c68693          	addi	a3,a3,-1412 # 80000a7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a7d>
80000b1c:	20000613          	li	a2,512
80000b20:	c03e                	sw	a5,0(sp)
80000b22:	b2058593          	addi	a1,a1,-1248 # 80005b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b21>
80000b26:	4781                	li	a5,0
80000b28:	c202                	sw	zero,4(sp)
80000b2a:	91c50513          	addi	a0,a0,-1764 # 8000591c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000591d>
80000b2e:	00a030ef          	jal	ra,80003b38 <z_impl_k_thread_create>
80000b32:	892a                	mv	s2,a0
	tstack_push(pstack);
80000b34:	8522                	mv	a0,s0
80000b36:	3d05                	jal	80000966 <tstack_push>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000b38:	55fd                	li	a1,-1
80000b3a:	8f048513          	addi	a0,s1,-1808
80000b3e:	147020ef          	jal	ra,80003484 <z_impl_k_sem_take>
80000b42:	55fd                	li	a1,-1
80000b44:	8f048513          	addi	a0,s1,-1808
80000b48:	13d020ef          	jal	ra,80003484 <z_impl_k_sem_take>
	tstack_pop(pstack);
80000b4c:	8522                	mv	a0,s0
80000b4e:	3d61                	jal	800009e6 <tstack_pop>
}
80000b50:	4462                	lw	s0,24(sp)
80000b52:	40f2                	lw	ra,28(sp)
80000b54:	44d2                	lw	s1,20(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000b56:	854a                	mv	a0,s2
80000b58:	4942                	lw	s2,16(sp)
80000b5a:	6105                	addi	sp,sp,32
80000b5c:	0f40306f          	j	80003c50 <z_impl_k_thread_abort>

80000b60 <test_stack_thread2thread>:
/**
 * @brief Test to verify data passing between threads via stack
 * @see k_stack_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop()
 */
void test_stack_thread2thread(void)
{
80000b60:	1141                	addi	sp,sp,-16
80000b62:	c422                	sw	s0,8(sp)
	/**TESTPOINT: test k_stack_init stack*/
	k_stack_init(&stack, data, STACK_LEN);
80000b64:	800055b7          	lui	a1,0x80005
80000b68:	80006437          	lui	s0,0x80006
80000b6c:	90040513          	addi	a0,s0,-1792 # 80005900 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005901>
80000b70:	4611                	li	a2,4
80000b72:	6cc58593          	addi	a1,a1,1740 # 800056cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056cd>
{
80000b76:	c606                	sw	ra,12(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000b78:	27f020ef          	jal	ra,800035f6 <k_stack_init>
	tstack_thread_thread(&stack);
80000b7c:	90040513          	addi	a0,s0,-1792
80000b80:	37a5                	jal	80000ae8 <tstack_thread_thread>

	/**TESTPOINT: test K_STACK_DEFINE stack*/
	tstack_thread_thread(&kstack);
}
80000b82:	4422                	lw	s0,8(sp)
80000b84:	40b2                	lw	ra,12(sp)
	tstack_thread_thread(&kstack);
80000b86:	80005537          	lui	a0,0x80005
80000b8a:	75850513          	addi	a0,a0,1880 # 80005758 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005759>
}
80000b8e:	0141                	addi	sp,sp,16
	tstack_thread_thread(&kstack);
80000b90:	bfa1                	j	80000ae8 <tstack_thread_thread>

80000b92 <test_stack_thread2isr>:
/**
 * @brief Verifies data passing between thread and ISR via stack
 * @see k_stack_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop()
 */
void test_stack_thread2isr(void)
{
80000b92:	1141                	addi	sp,sp,-16
80000b94:	c422                	sw	s0,8(sp)
	/**TESTPOINT: test k_stack_init stack*/
	k_stack_init(&stack, data, STACK_LEN);
80000b96:	800055b7          	lui	a1,0x80005
80000b9a:	80006437          	lui	s0,0x80006
80000b9e:	90040513          	addi	a0,s0,-1792 # 80005900 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005901>
80000ba2:	4611                	li	a2,4
80000ba4:	6cc58593          	addi	a1,a1,1740 # 800056cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056cd>
{
80000ba8:	c606                	sw	ra,12(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000baa:	24d020ef          	jal	ra,800035f6 <k_stack_init>
	tstack_thread_isr(&stack);
80000bae:	90040513          	addi	a0,s0,-1792
80000bb2:	3de5                	jal	80000aaa <tstack_thread_isr>

	/**TESTPOINT: test K_STACK_DEFINE stack*/
	tstack_thread_isr(&kstack);
}
80000bb4:	4422                	lw	s0,8(sp)
80000bb6:	40b2                	lw	ra,12(sp)
	tstack_thread_isr(&kstack);
80000bb8:	80005537          	lui	a0,0x80005
80000bbc:	75850513          	addi	a0,a0,1880 # 80005758 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005759>
}
80000bc0:	0141                	addi	sp,sp,16
	tstack_thread_isr(&kstack);
80000bc2:	b5e5                	j	80000aaa <tstack_thread_isr>

80000bc4 <test_stack_alloc_thread2thread>:
/**
 * @see k_stack_alloc_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop(),
 * k_stack_cleanup()
 */
void test_stack_alloc_thread2thread(void)
{
80000bc4:	1101                	addi	sp,sp,-32
80000bc6:	cc22                	sw	s0,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000bc8:	80005437          	lui	s0,0x80005
80000bcc:	4591                	li	a1,4
80000bce:	77440513          	addi	a0,s0,1908 # 80005774 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005775>
80000bd2:	ce06                	sw	ra,28(sp)
80000bd4:	ca26                	sw	s1,20(sp)
80000bd6:	c84a                	sw	s2,16(sp)
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000bd8:	800064b7          	lui	s1,0x80006
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000bdc:	22f020ef          	jal	ra,8000360a <z_impl_k_stack_alloc_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000be0:	8f048513          	addi	a0,s1,-1808 # 800058f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f1>
80000be4:	4605                	li	a2,1
80000be6:	4581                	li	a1,0
80000be8:	752020ef          	jal	ra,8000333a <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000bec:	800016b7          	lui	a3,0x80001
80000bf0:	800065b7          	lui	a1,0x80006
80000bf4:	80006537          	lui	a0,0x80006
80000bf8:	77440713          	addi	a4,s0,1908
80000bfc:	4781                	li	a5,0
80000bfe:	a7c68693          	addi	a3,a3,-1412 # 80000a7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a7d>
80000c02:	20000613          	li	a2,512
80000c06:	4881                	li	a7,0
80000c08:	4801                	li	a6,0
80000c0a:	b2058593          	addi	a1,a1,-1248 # 80005b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b21>
80000c0e:	c202                	sw	zero,4(sp)
80000c10:	c002                	sw	zero,0(sp)
80000c12:	91c50513          	addi	a0,a0,-1764 # 8000591c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000591d>
80000c16:	723020ef          	jal	ra,80003b38 <z_impl_k_thread_create>
80000c1a:	892a                	mv	s2,a0
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: thread-thread data passing via stack*/
	k_tid_t tid = k_thread_create(&thread_data, threadstack, STACK_SIZE,
					tThread_entry, &kstack_test_alloc,
					NULL, NULL, K_PRIO_PREEMPT(0), 0, 0);
	tstack_push(&kstack_test_alloc);
80000c1c:	77440513          	addi	a0,s0,1908
80000c20:	3399                	jal	80000966 <tstack_push>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000c22:	55fd                	li	a1,-1
80000c24:	8f048513          	addi	a0,s1,-1808
80000c28:	05d020ef          	jal	ra,80003484 <z_impl_k_sem_take>
80000c2c:	55fd                	li	a1,-1
80000c2e:	8f048513          	addi	a0,s1,-1808
80000c32:	053020ef          	jal	ra,80003484 <z_impl_k_sem_take>
	k_sem_take(&end_sema, K_FOREVER);

	k_sem_take(&end_sema, K_FOREVER);
	tstack_pop(&kstack_test_alloc);
80000c36:	77440513          	addi	a0,s0,1908
80000c3a:	3375                	jal	800009e6 <tstack_pop>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000c3c:	854a                	mv	a0,s2
80000c3e:	012030ef          	jal	ra,80003c50 <z_impl_k_thread_abort>

	/* clear the spawn thread to avoid side effect */
	k_thread_abort(tid);
	k_stack_cleanup(&kstack_test_alloc);
80000c42:	77440513          	addi	a0,s0,1908
80000c46:	1f3020ef          	jal	ra,80003638 <k_stack_cleanup>
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000c4a:	10100593          	li	a1,257
80000c4e:	77440513          	addi	a0,s0,1908
80000c52:	1b9020ef          	jal	ra,8000360a <z_impl_k_stack_alloc_init>

	/** Requested buffer allocation from the test pool.*/
	ret = k_stack_alloc_init(&kstack_test_alloc, (STACK_SIZE/2)+1);
	zassert_true(ret == -ENOMEM,
			"resource pool is smaller then requested buffer");
}
80000c56:	4462                	lw	s0,24(sp)
80000c58:	40f2                	lw	ra,28(sp)
80000c5a:	44d2                	lw	s1,20(sp)
80000c5c:	4942                	lw	s2,16(sp)
	zassert_true(ret == -ENOMEM,
80000c5e:	0531                	addi	a0,a0,12
80000c60:	800057b7          	lui	a5,0x80005
80000c64:	80005737          	lui	a4,0x80005
80000c68:	80005637          	lui	a2,0x80005
80000c6c:	800055b7          	lui	a1,0x80005
80000c70:	abc78793          	addi	a5,a5,-1348 # 80004abc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004abd>
80000c74:	a9c70713          	addi	a4,a4,-1380 # 80004a9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a9d>
80000c78:	0a700693          	li	a3,167
80000c7c:	b5c60613          	addi	a2,a2,-1188 # 80004b5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b5d>
80000c80:	aec58593          	addi	a1,a1,-1300 # 80004aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004aed>
80000c84:	00153513          	seqz	a0,a0
}
80000c88:	6105                	addi	sp,sp,32
	zassert_true(ret == -ENOMEM,
80000c8a:	bb01                	j	8000099a <z_zassert.constprop.0>

80000c8c <z_zassert.constprop.1>:
static inline void z_zassert(int cond,
80000c8c:	7179                	addi	sp,sp,-48
80000c8e:	ce06                	sw	ra,28(sp)
80000c90:	d442                	sw	a6,40(sp)
80000c92:	d646                	sw	a7,44(sp)
	if (!(cond)) {
80000c94:	e131                	bnez	a0,80000cd8 <z_zassert.constprop.1+0x4c>
80000c96:	8636                	mv	a2,a3
80000c98:	872e                	mv	a4,a1
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000c9a:	800056b7          	lui	a3,0x80005
80000c9e:	800055b7          	lui	a1,0x80005
80000ca2:	80005537          	lui	a0,0x80005
		va_start(vargs, msg);
80000ca6:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000ca8:	bc068693          	addi	a3,a3,-1088 # 80004bc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bc1>
80000cac:	c4858593          	addi	a1,a1,-952 # 80004c48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c49>
80000cb0:	b9850513          	addi	a0,a0,-1128 # 80004b98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b99>
		va_start(vargs, msg);
80000cb4:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000cb6:	509000ef          	jal	ra,800019be <printk>
		vprintk(msg, vargs);
80000cba:	45b2                	lw	a1,12(sp)
80000cbc:	80005537          	lui	a0,0x80005
80000cc0:	cd450513          	addi	a0,a0,-812 # 80004cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cd5>
80000cc4:	4df000ef          	jal	ra,800019a2 <vprintk>
		printk("\n");
80000cc8:	80005537          	lui	a0,0x80005
80000ccc:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80000cd0:	4ef000ef          	jal	ra,800019be <printk>
		ztest_test_fail();
80000cd4:	276010ef          	jal	ra,80001f4a <ztest_test_fail>
}
80000cd8:	40f2                	lw	ra,28(sp)
80000cda:	6145                	addi	sp,sp,48
80000cdc:	8082                	ret

80000cde <test_stack_pop_fail>:
/**
 * @brief Verifies stack pop functionality
 * @see k_stack_init(), k_stack_pop()
 */
void test_stack_pop_fail(void)
{
80000cde:	7179                	addi	sp,sp,-48
80000ce0:	d422                	sw	s0,40(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000ce2:	800055b7          	lui	a1,0x80005
80000ce6:	80006437          	lui	s0,0x80006
80000cea:	90040513          	addi	a0,s0,-1792 # 80005900 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005901>
80000cee:	4609                	li	a2,2
80000cf0:	7a058593          	addi	a1,a1,1952 # 800057a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057a1>
{
80000cf4:	d606                	sw	ra,44(sp)
80000cf6:	d226                	sw	s1,36(sp)
80000cf8:	d04a                	sw	s2,32(sp)
80000cfa:	ce4e                	sw	s3,28(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000cfc:	0fb020ef          	jal	ra,800035f6 <k_stack_init>
K_SYSCALL_DECLARE3(K_SYSCALL_K_STACK_POP, k_stack_pop, int, struct k_stack *, stack, u32_t *, data, s32_t, timeout)
80000d00:	006c                	addi	a1,sp,12
80000d02:	4601                	li	a2,0
80000d04:	90040513          	addi	a0,s0,-1792
80000d08:	2c9020ef          	jal	ra,800037d0 <z_impl_k_stack_pop>
	zassert_equal(k_stack_pop(stack, &rx_data, K_NO_WAIT), -EBUSY, NULL);
80000d0c:	80005937          	lui	s2,0x80005
80000d10:	800059b7          	lui	s3,0x80005
80000d14:	800054b7          	lui	s1,0x80005
80000d18:	0541                	addi	a0,a0,16
80000d1a:	800055b7          	lui	a1,0x80005
80000d1e:	cd498793          	addi	a5,s3,-812 # 80004cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cd5>
80000d22:	bc090713          	addi	a4,s2,-1088 # 80004bc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bc1>
80000d26:	46d5                	li	a3,21
80000d28:	c4848613          	addi	a2,s1,-952 # 80004c48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c49>
80000d2c:	bd058593          	addi	a1,a1,-1072 # 80004bd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bd1>
80000d30:	00153513          	seqz	a0,a0
80000d34:	3fa1                	jal	80000c8c <z_zassert.constprop.1>
80000d36:	006c                	addi	a1,sp,12
80000d38:	06400613          	li	a2,100
80000d3c:	90040513          	addi	a0,s0,-1792
80000d40:	291020ef          	jal	ra,800037d0 <z_impl_k_stack_pop>
	zassert_equal(k_stack_pop(stack, &rx_data, TIMEOUT), -EAGAIN, NULL);
80000d44:	052d                	addi	a0,a0,11
80000d46:	800055b7          	lui	a1,0x80005
80000d4a:	cd498793          	addi	a5,s3,-812
80000d4e:	bc090713          	addi	a4,s2,-1088
80000d52:	c4848613          	addi	a2,s1,-952
80000d56:	46dd                	li	a3,23
80000d58:	c0c58593          	addi	a1,a1,-1012 # 80004c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c0d>
80000d5c:	00153513          	seqz	a0,a0
80000d60:	3735                	jal	80000c8c <z_zassert.constprop.1>

	stack_pop_fail(&stack);
}
80000d62:	50b2                	lw	ra,44(sp)
80000d64:	5422                	lw	s0,40(sp)
80000d66:	5492                	lw	s1,36(sp)
80000d68:	5902                	lw	s2,32(sp)
80000d6a:	49f2                	lw	s3,28(sp)
80000d6c:	6145                	addi	sp,sp,48
80000d6e:	8082                	ret

80000d70 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000d70:	1141                	addi	sp,sp,-16
80000d72:	c606                	sw	ra,12(sp)
80000d74:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000d76:	4799                	li	a5,6
80000d78:	02f50263          	beq	a0,a5,80000d9c <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000d7c:	3ab020ef          	jal	ra,80003926 <k_is_in_isr>
80000d80:	c10d                	beqz	a0,80000da2 <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000d82:	3a5020ef          	jal	ra,80003926 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000d86:	e121                	bnez	a0,80000dc6 <z_SysFatalErrorHandler+0x56>
80000d88:	800055b7          	lui	a1,0x80005
80000d8c:	f3058593          	addi	a1,a1,-208 # 80004f30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f31>
80000d90:	80005537          	lui	a0,0x80005
80000d94:	f4450513          	addi	a0,a0,-188 # 80004f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f45>
80000d98:	427000ef          	jal	ra,800019be <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000d9c:	469000ef          	jal	ra,80001a04 <k_cpu_idle>
80000da0:	bff5                	j	80000d9c <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000da2:	393020ef          	jal	ra,80003934 <z_is_thread_essential>
80000da6:	fd71                	bnez	a0,80000d82 <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000da8:	80006437          	lui	s0,0x80006
80000dac:	aec40413          	addi	s0,s0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80000db0:	440c                	lw	a1,8(s0)
80000db2:	80005537          	lui	a0,0x80005
80000db6:	f6450513          	addi	a0,a0,-156 # 80004f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f65>
80000dba:	405000ef          	jal	ra,800019be <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000dbe:	4408                	lw	a0,8(s0)
80000dc0:	691020ef          	jal	ra,80003c50 <z_impl_k_thread_abort>
80000dc4:	bfe1                	j	80000d9c <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
80000dc6:	800055b7          	lui	a1,0x80005
80000dca:	f2c58593          	addi	a1,a1,-212 # 80004f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f2d>
80000dce:	b7c9                	j	80000d90 <z_SysFatalErrorHandler+0x20>

80000dd0 <z_NanoFatalErrorHandler>:
{
80000dd0:	715d                	addi	sp,sp,-80
80000dd2:	c4a2                	sw	s0,72(sp)
80000dd4:	c2a6                	sw	s1,68(sp)
80000dd6:	c686                	sw	ra,76(sp)
	switch (reason) {
80000dd8:	4799                	li	a5,6
{
80000dda:	84aa                	mv	s1,a0
80000ddc:	842e                	mv	s0,a1
	switch (reason) {
80000dde:	08a7e963          	bltu	a5,a0,80000e70 <z_NanoFatalErrorHandler+0xa0>
80000de2:	80005737          	lui	a4,0x80005
80000de6:	00251793          	slli	a5,a0,0x2
80000dea:	c8070713          	addi	a4,a4,-896 # 80004c80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c81>
80000dee:	97ba                	add	a5,a5,a4
80000df0:	439c                	lw	a5,0(a5)
80000df2:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000df4:	80005537          	lui	a0,0x80005
80000df8:	db050513          	addi	a0,a0,-592 # 80004db0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004db1>
		printk("***** Kernel OOPS! *****\n");
80000dfc:	3c3000ef          	jal	ra,800019be <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000e00:	530020ef          	jal	ra,80003330 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000e04:	407c                	lw	a5,68(s0)
80000e06:	01042883          	lw	a7,16(s0)
80000e0a:	00c42803          	lw	a6,12(s0)
80000e0e:	d83e                	sw	a5,48(sp)
80000e10:	403c                	lw	a5,64(s0)
80000e12:	4058                	lw	a4,4(s0)
80000e14:	4014                	lw	a3,0(s0)
80000e16:	d63e                	sw	a5,44(sp)
80000e18:	5c5c                	lw	a5,60(s0)
80000e1a:	4430                	lw	a2,72(s0)
80000e1c:	85aa                	mv	a1,a0
80000e1e:	d43e                	sw	a5,40(sp)
80000e20:	5c1c                	lw	a5,56(s0)
80000e22:	80005537          	lui	a0,0x80005
80000e26:	e3450513          	addi	a0,a0,-460 # 80004e34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e35>
80000e2a:	d23e                	sw	a5,36(sp)
80000e2c:	585c                	lw	a5,52(s0)
80000e2e:	d03e                	sw	a5,32(sp)
80000e30:	581c                	lw	a5,48(s0)
80000e32:	ce3e                	sw	a5,28(sp)
80000e34:	545c                	lw	a5,44(s0)
80000e36:	cc3e                	sw	a5,24(sp)
80000e38:	541c                	lw	a5,40(s0)
80000e3a:	ca3e                	sw	a5,20(sp)
80000e3c:	505c                	lw	a5,36(s0)
80000e3e:	c83e                	sw	a5,16(sp)
80000e40:	501c                	lw	a5,32(s0)
80000e42:	c63e                	sw	a5,12(sp)
80000e44:	4c5c                	lw	a5,28(s0)
80000e46:	c43e                	sw	a5,8(sp)
80000e48:	4c1c                	lw	a5,24(s0)
80000e4a:	c23e                	sw	a5,4(sp)
80000e4c:	485c                	lw	a5,20(s0)
80000e4e:	c03e                	sw	a5,0(sp)
80000e50:	441c                	lw	a5,8(s0)
80000e52:	36d000ef          	jal	ra,800019be <printk>
	z_SysFatalErrorHandler(reason, esf);
80000e56:	85a2                	mv	a1,s0
80000e58:	8526                	mv	a0,s1
80000e5a:	3f19                	jal	80000d70 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000e5c:	80005537          	lui	a0,0x80005
80000e60:	dd850513          	addi	a0,a0,-552 # 80004dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd9>
80000e64:	bf61                	j	80000dfc <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
80000e66:	80005537          	lui	a0,0x80005
80000e6a:	df450513          	addi	a0,a0,-524 # 80004df4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004df5>
80000e6e:	b779                	j	80000dfc <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000e70:	80005537          	lui	a0,0x80005
80000e74:	85a6                	mv	a1,s1
80000e76:	e1050513          	addi	a0,a0,-496 # 80004e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e11>
80000e7a:	345000ef          	jal	ra,800019be <printk>
		break;
80000e7e:	b749                	j	80000e00 <z_NanoFatalErrorHandler+0x30>

80000e80 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000e80:	1141                	addi	sp,sp,-16
80000e82:	c422                	sw	s0,8(sp)
80000e84:	c606                	sw	ra,12(sp)
80000e86:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000e88:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000e8c:	0606                	slli	a2,a2,0x1
80000e8e:	8205                	srli	a2,a2,0x1
	switch (cause) {
80000e90:	4795                	li	a5,5
80000e92:	02c7e363          	bltu	a5,a2,80000eb8 <_Fault+0x38>
80000e96:	80005737          	lui	a4,0x80005
80000e9a:	00261793          	slli	a5,a2,0x2
80000e9e:	c9c70713          	addi	a4,a4,-868 # 80004c9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c9d>
80000ea2:	97ba                	add	a5,a5,a4
80000ea4:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000ea6:	80005537          	lui	a0,0x80005
80000eaa:	cbc50513          	addi	a0,a0,-836 # 80004cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cbd>
80000eae:	311000ef          	jal	ra,800019be <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000eb2:	85a2                	mv	a1,s0
80000eb4:	4501                	li	a0,0
80000eb6:	3f29                	jal	80000dd0 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000eb8:	800055b7          	lui	a1,0x80005
80000ebc:	cb458593          	addi	a1,a1,-844 # 80004cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cb5>
80000ec0:	b7dd                	j	80000ea6 <_Fault+0x26>

80000ec2 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000ec2:	1141                	addi	sp,sp,-16
80000ec4:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000ec6:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000eca:	80005537          	lui	a0,0x80005
	mcause &= SOC_MCAUSE_EXP_MASK;
80000ece:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000ed0:	8185                	srli	a1,a1,0x1
80000ed2:	f8c50513          	addi	a0,a0,-116 # 80004f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f8d>
80000ed6:	2e9000ef          	jal	ra,800019be <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000eda:	800055b7          	lui	a1,0x80005
80000ede:	cd858593          	addi	a1,a1,-808 # 80004cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cd9>
80000ee2:	4511                	li	a0,4
80000ee4:	35f5                	jal	80000dd0 <z_NanoFatalErrorHandler>

80000ee6 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000ee6:	800057b7          	lui	a5,0x80005
80000eea:	7a878793          	addi	a5,a5,1960 # 800057a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057a9>
80000eee:	4398                	lw	a4,0(a5)
80000ef0:	cb11                	beqz	a4,80000f04 <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
80000ef2:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000ef6:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000efa:	800057b7          	lui	a5,0x80005
80000efe:	7ac7a503          	lw	a0,1964(a5) # 800057ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057ad>
80000f02:	8302                	jr	t1
}
80000f04:	8082                	ret

80000f06 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80000f06:	47a1                	li	a5,8
80000f08:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
80000f0c:	80005737          	lui	a4,0x80005
80000f10:	7aa72423          	sw	a0,1960(a4) # 800057a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057a9>
	offload_param = parameter;
80000f14:	80005737          	lui	a4,0x80005
80000f18:	7ab72623          	sw	a1,1964(a4) # 800057ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057ad>

	__asm__ volatile ("ecall");
80000f1c:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80000f20:	8ba1                	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80000f22:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80000f26:	8082                	ret

80000f28 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000f28:	1141                	addi	sp,sp,-16
80000f2a:	c606                	sw	ra,12(sp)
	z_bss_zero();
80000f2c:	2f8010ef          	jal	ra,80002224 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000f30:	2ed000ef          	jal	ra,80001a1c <soc_interrupt_init>
#endif
	z_cstart();
80000f34:	342010ef          	jal	ra,80002276 <z_cstart>

80000f38 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000f38:	7179                	addi	sp,sp,-48
80000f3a:	d422                	sw	s0,40(sp)
80000f3c:	d226                	sw	s1,36(sp)
80000f3e:	d04a                	sw	s2,32(sp)
80000f40:	ce4e                	sw	s3,28(sp)
80000f42:	cc52                	sw	s4,24(sp)
80000f44:	ca56                	sw	s5,20(sp)
80000f46:	c85a                	sw	s6,16(sp)
80000f48:	c65e                	sw	s7,12(sp)
80000f4a:	8b3e                	mv	s6,a5
80000f4c:	d606                	sw	ra,44(sp)
80000f4e:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f50:	47bd                	li	a5,15
{
80000f52:	84aa                	mv	s1,a0
80000f54:	842e                	mv	s0,a1
80000f56:	89b2                	mv	s3,a2
80000f58:	8a36                	mv	s4,a3
80000f5a:	8bba                	mv	s7,a4
80000f5c:	8ac2                	mv	s5,a6
80000f5e:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f60:	06f89463          	bne	a7,a5,80000fc8 <z_new_thread+0x90>
80000f64:	800027b7          	lui	a5,0x80002
80000f68:	1fe78793          	addi	a5,a5,510 # 800021fe <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800021ff>
80000f6c:	06f69363          	bne	a3,a5,80000fd2 <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000f70:	56c2                	lw	a3,48(sp)
80000f72:	85ca                	mv	a1,s2
80000f74:	8526                	mv	a0,s1
80000f76:	4611                	li	a2,4
80000f78:	23b020ef          	jal	ra,800039b2 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000f7c:	fb098593          	addi	a1,s3,-80
80000f80:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000f82:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000f84:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000f88:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000f8c:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000f8e:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000f92:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000f94:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000f98:	50b2                	lw	ra,44(sp)
80000f9a:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000f9c:	91878793          	addi	a5,a5,-1768 # 80000918 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000919>
	stack_init->a0 = (u32_t)thread_func;
80000fa0:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000fa4:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000fa8:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000fac:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000fb0:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000fb2:	d48c                	sw	a1,40(s1)
}
80000fb4:	5902                	lw	s2,32(sp)
80000fb6:	5492                	lw	s1,36(sp)
80000fb8:	49f2                	lw	s3,28(sp)
80000fba:	4a62                	lw	s4,24(sp)
80000fbc:	4ad2                	lw	s5,20(sp)
80000fbe:	4b42                	lw	s6,16(sp)
80000fc0:	4bb2                	lw	s7,12(sp)
80000fc2:	4c22                	lw	s8,8(sp)
80000fc4:	6145                	addi	sp,sp,48
80000fc6:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000fc8:	01088693          	addi	a3,a7,16
80000fcc:	47f9                	li	a5,30
80000fce:	fad7f1e3          	bgeu	a5,a3,80000f70 <z_new_thread+0x38>
80000fd2:	80005c37          	lui	s8,0x80005
80000fd6:	800055b7          	lui	a1,0x80005
80000fda:	80005537          	lui	a0,0x80005
80000fde:	fb4c0613          	addi	a2,s8,-76 # 80004fb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fb5>
80000fe2:	46e1                	li	a3,24
80000fe4:	fd458593          	addi	a1,a1,-44 # 80004fd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fd5>
80000fe8:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80000fec:	1d3000ef          	jal	ra,800019be <printk>
80000ff0:	80005537          	lui	a0,0x80005
80000ff4:	85ca                	mv	a1,s2
80000ff6:	56c1                	li	a3,-16
80000ff8:	4639                	li	a2,14
80000ffa:	08050513          	addi	a0,a0,128 # 80005080 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005081>
80000ffe:	1c1000ef          	jal	ra,800019be <printk>
80001002:	45e1                	li	a1,24
80001004:	fb4c0513          	addi	a0,s8,-76
80001008:	1d5000ef          	jal	ra,800019dc <assert_post_action>
8000100c:	b795                	j	80000f70 <z_new_thread+0x38>

8000100e <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
8000100e:	00159793          	slli	a5,a1,0x1
80001012:	97ae                	add	a5,a5,a1
80001014:	00279713          	slli	a4,a5,0x2
80001018:	455c                	lw	a5,12(a0)
8000101a:	97ba                	add	a5,a5,a4
8000101c:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001020:	00b75363          	bge	a4,a1,80001026 <get_bit_ptr+0x18>
80001024:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001026:	41f65713          	srai	a4,a2,0x1f
8000102a:	8b7d                	andi	a4,a4,31
8000102c:	9732                	add	a4,a4,a2
8000102e:	8715                	srai	a4,a4,0x5
80001030:	070a                	slli	a4,a4,0x2
80001032:	97ba                	add	a5,a5,a4
80001034:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
80001036:	01f67513          	andi	a0,a2,31
8000103a:	8082                	ret

8000103c <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
8000103c:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
8000103e:	0074                	addi	a3,sp,12
{
80001040:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001042:	37f1                	jal	8000100e <get_bit_ptr>

	*word |= (1<<bit);
80001044:	4732                	lw	a4,12(sp)
80001046:	4785                	li	a5,1
80001048:	00a79533          	sll	a0,a5,a0
8000104c:	431c                	lw	a5,0(a4)
}
8000104e:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
80001050:	8fc9                	or	a5,a5,a0
80001052:	c31c                	sw	a5,0(a4)
}
80001054:	6105                	addi	sp,sp,32
80001056:	8082                	ret

80001058 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001058:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
8000105a:	0074                	addi	a3,sp,12
{
8000105c:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
8000105e:	3f45                	jal	8000100e <get_bit_ptr>

	*word &= ~(1<<bit);
80001060:	4732                	lw	a4,12(sp)
80001062:	4785                	li	a5,1
80001064:	00a79533          	sll	a0,a5,a0
80001068:	431c                	lw	a5,0(a4)
}
8000106a:	40f2                	lw	ra,28(sp)
	*word &= ~(1<<bit);
8000106c:	fff54513          	not	a0,a0
80001070:	8d7d                	and	a0,a0,a5
80001072:	c308                	sw	a0,0(a4)
}
80001074:	6105                	addi	sp,sp,32
80001076:	8082                	ret

80001078 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001078:	1101                	addi	sp,sp,-32
8000107a:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000107c:	4144                	lw	s1,4(a0)
{
8000107e:	cc22                	sw	s0,24(sp)
80001080:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001082:	00855503          	lhu	a0,8(a0)
80001086:	85a6                	mv	a1,s1
{
80001088:	c84a                	sw	s2,16(sp)
8000108a:	c64e                	sw	s3,12(sp)
8000108c:	c452                	sw	s4,8(sp)
8000108e:	c256                	sw	s5,4(sp)
80001090:	c05a                	sw	s6,0(sp)
80001092:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001094:	f98ff0ef          	jal	ra,8000082c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001098:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
8000109c:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
800010a0:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800010a2:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
800010a4:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
800010a6:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
800010aa:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
800010ac:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
800010ae:	03594163          	blt	s2,s5,800010d0 <z_sys_mem_pool_base_init+0x58>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
800010b2:	4481                	li	s1,0
800010b4:	00845783          	lhu	a5,8(s0)
800010b8:	04f4cf63          	blt	s1,a5,80001116 <z_sys_mem_pool_base_init+0x9e>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
800010bc:	40f2                	lw	ra,28(sp)
800010be:	4462                	lw	s0,24(sp)
800010c0:	44d2                	lw	s1,20(sp)
800010c2:	4942                	lw	s2,16(sp)
800010c4:	49b2                	lw	s3,12(sp)
800010c6:	4a22                	lw	s4,8(sp)
800010c8:	4a92                	lw	s5,4(sp)
800010ca:	4b02                	lw	s6,0(sp)
800010cc:	6105                	addi	sp,sp,32
800010ce:	8082                	ret
		int nblocks = buflen / sz;
800010d0:	85a6                	mv	a1,s1
800010d2:	8552                	mv	a0,s4
800010d4:	f84ff0ef          	jal	ra,80000858 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
800010d8:	00191713          	slli	a4,s2,0x1
800010dc:	974a                	add	a4,a4,s2
800010de:	00271793          	slli	a5,a4,0x2
800010e2:	4458                	lw	a4,12(s0)
800010e4:	973e                	add	a4,a4,a5
800010e6:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
800010ea:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
800010ec:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
800010ee:	00ab4963          	blt	s6,a0,80001100 <z_sys_mem_pool_base_init+0x88>
			p->max_inline_level = i;
800010f2:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800010f6:	8089                	srli	s1,s1,0x2
800010f8:	048d                	addi	s1,s1,3
800010fa:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800010fc:	0905                	addi	s2,s2,1
800010fe:	bf45                	j	800010ae <z_sys_mem_pool_base_init+0x36>
			bits += (nblocks + 31)/32;
80001100:	057d                	addi	a0,a0,31
80001102:	41f55793          	srai	a5,a0,0x1f
80001106:	8bfd                	andi	a5,a5,31
80001108:	97aa                	add	a5,a5,a0
8000110a:	8795                	srai	a5,a5,0x5
8000110c:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
8000110e:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001112:	99be                	add	s3,s3,a5
80001114:	b7cd                	j	800010f6 <z_sys_mem_pool_base_init+0x7e>
	return (u8_t *)p->buf + lsz * block;
80001116:	404c                	lw	a1,4(s0)
80001118:	8526                	mv	a0,s1
8000111a:	f12ff0ef          	jal	ra,8000082c <__mulsi3>
8000111e:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001120:	8626                	mv	a2,s1
80001122:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001124:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
80001126:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001128:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
8000112a:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
8000112e:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
80001130:	4798                	lw	a4,8(a5)
80001132:	c158                	sw	a4,4(a0)

	list->tail->next = node;
80001134:	4798                	lw	a4,8(a5)
80001136:	c308                	sw	a0,0(a4)
	list->tail = node;
80001138:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
8000113a:	8522                	mv	a0,s0
8000113c:	3701                	jal	8000103c <set_free_bit>
8000113e:	bf9d                	j	800010b4 <z_sys_mem_pool_base_init+0x3c>

80001140 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001140:	711d                	addi	sp,sp,-96
80001142:	cca2                	sw	s0,88(sp)
80001144:	c2d6                	sw	s5,68(sp)
80001146:	ce86                	sw	ra,92(sp)
80001148:	caa6                	sw	s1,84(sp)
8000114a:	c8ca                	sw	s2,80(sp)
8000114c:	c6ce                	sw	s3,76(sp)
8000114e:	c4d2                	sw	s4,72(sp)
80001150:	c0da                	sw	s6,64(sp)
80001152:	de5e                	sw	s7,60(sp)
80001154:	dc62                	sw	s8,56(sp)
80001156:	da66                	sw	s9,52(sp)
80001158:	d86a                	sw	s10,48(sp)
8000115a:	d66e                	sw	s11,44(sp)
8000115c:	1080                	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000115e:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001162:	4881                	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001164:	002e1793          	slli	a5,t3,0x2
80001168:	07bd                	addi	a5,a5,15
8000116a:	7f07f793          	andi	a5,a5,2032
8000116e:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001172:	415c                	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001174:	8a8a                	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001176:	8356                	mv	t1,s5
80001178:	078d                	addi	a5,a5,3
8000117a:	9bf1                	andi	a5,a5,-4
8000117c:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80001180:	fff88b13          	addi	s6,a7,-1
80001184:	03c8d263          	bge	a7,t3,800011a8 <z_sys_mem_pool_block_alloc+0x68>
		if (i > 0) {
80001188:	00088b63          	beqz	a7,8000119e <z_sys_mem_pool_block_alloc+0x5e>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000118c:	ffc32803          	lw	a6,-4(t1) # 7ffffffc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x7ffffffd>
80001190:	00285813          	srli	a6,a6,0x2
80001194:	080d                	addi	a6,a6,3
80001196:	ffc87813          	andi	a6,a6,-4
8000119a:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
8000119e:	0311                	addi	t1,t1,4
800011a0:	ffc32803          	lw	a6,-4(t1)
800011a4:	02b87963          	bgeu	a6,a1,800011d6 <z_sys_mem_pool_block_alloc+0x96>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
800011a8:	55fd                	li	a1,-1
800011aa:	02bb1863          	bne	s6,a1,800011da <z_sys_mem_pool_block_alloc+0x9a>
		*data_p = NULL;
800011ae:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
800011b2:	5551                	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
800011b4:	fa040113          	addi	sp,s0,-96
800011b8:	40f6                	lw	ra,92(sp)
800011ba:	4466                	lw	s0,88(sp)
800011bc:	44d6                	lw	s1,84(sp)
800011be:	4946                	lw	s2,80(sp)
800011c0:	49b6                	lw	s3,76(sp)
800011c2:	4a26                	lw	s4,72(sp)
800011c4:	4a96                	lw	s5,68(sp)
800011c6:	4b06                	lw	s6,64(sp)
800011c8:	5bf2                	lw	s7,60(sp)
800011ca:	5c62                	lw	s8,56(sp)
800011cc:	5cd2                	lw	s9,52(sp)
800011ce:	5d42                	lw	s10,48(sp)
800011d0:	5db2                	lw	s11,44(sp)
800011d2:	6125                	addi	sp,sp,96
800011d4:	8082                	ret
	for (i = 0; i < p->n_levels; i++) {
800011d6:	0885                	addi	a7,a7,1
800011d8:	b765                	j	80001180 <z_sys_mem_pool_block_alloc+0x40>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800011da:	01054583          	lbu	a1,16(a0)
		return 0;
800011de:	4901                	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800011e0:	8985                	andi	a1,a1,1
800011e2:	c591                	beqz	a1,800011ee <z_sys_mem_pool_block_alloc+0xae>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800011e4:	4921                	li	s2,8
800011e6:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
800011ea:	00897913          	andi	s2,s2,8
800011ee:	fae42a23          	sw	a4,-76(s0)
800011f2:	001b1713          	slli	a4,s6,0x1
800011f6:	fad42c23          	sw	a3,-72(s0)
800011fa:	975a                	add	a4,a4,s6
800011fc:	4554                	lw	a3,12(a0)
800011fe:	070a                	slli	a4,a4,0x2
80001200:	0711                	addi	a4,a4,4
80001202:	9736                	add	a4,a4,a3
80001204:	fac42e23          	sw	a2,-68(s0)
80001208:	84aa                	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
8000120a:	8a5a                	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
8000120c:	56fd                	li	a3,-1
	return list->head == list;
8000120e:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001212:	13370863          	beq	a4,s3,80001342 <z_sys_mem_pool_block_alloc+0x202>
		data = block_alloc(p, i, lsizes[i]);
80001216:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
8000121a:	0049a683          	lw	a3,4(s3)
8000121e:	00ea8cb3          	add	s9,s5,a4
80001222:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001226:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000122a:	4d21                	li	s10,8
8000122c:	c298                	sw	a4,0(a3)
	node->next->prev = node->prev;
8000122e:	c354                	sw	a3,4(a4)
	node->next = NULL;
80001230:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001234:	0009a223          	sw	zero,4(s3)
80001238:	4088                	lw	a0,0(s1)
8000123a:	40a98533          	sub	a0,s3,a0
8000123e:	e12ff0ef          	jal	ra,80000850 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
80001242:	862a                	mv	a2,a0
80001244:	85d2                	mv	a1,s4
80001246:	8526                	mv	a0,s1
80001248:	3d01                	jal	80001058 <clear_free_bit>
		if (data != NULL) {
8000124a:	0a05                	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
8000124c:	fffa0693          	addi	a3,s4,-1
80001250:	0566c263          	blt	a3,s6,80001294 <z_sys_mem_pool_block_alloc+0x154>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001254:	0104c703          	lbu	a4,16(s1)
80001258:	8b05                	andi	a4,a4,1
8000125a:	c319                	beqz	a4,80001260 <z_sys_mem_pool_block_alloc+0x120>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000125c:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80001260:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
80001264:	5551                	li	a0,-12
	*data_p = data;
80001266:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
8000126a:	f40985e3          	beqz	s3,800011b4 <z_sys_mem_pool_block_alloc+0x74>
	*level_p = alloc_l;
8000126e:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001272:	4088                	lw	a0,0(s1)
	*level_p = alloc_l;
80001274:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001278:	002b1793          	slli	a5,s6,0x2
8000127c:	9abe                	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000127e:	000aa583          	lw	a1,0(s5)
80001282:	40a98533          	sub	a0,s3,a0
80001286:	dcaff0ef          	jal	ra,80000850 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
8000128a:	fb842783          	lw	a5,-72(s0)
8000128e:	c388                	sw	a0,0(a5)
	return 0;
80001290:	4501                	li	a0,0
80001292:	b70d                	j	800011b4 <z_sys_mem_pool_block_alloc+0x74>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001294:	4088                	lw	a0,0(s1)
80001296:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
8000129a:	4b85                	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000129c:	40a98533          	sub	a0,s3,a0
800012a0:	db0ff0ef          	jal	ra,80000850 <__divsi3>
800012a4:	001a1893          	slli	a7,s4,0x1
800012a8:	98d2                	add	a7,a7,s4
		int lbn = 4*bn + i;
800012aa:	00251d93          	slli	s11,a0,0x2
800012ae:	088a                	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
800012b0:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
800012b4:	85de                	mv	a1,s7
800012b6:	fb142623          	sw	a7,-84(s0)
800012ba:	8536                	mv	a0,a3
800012bc:	fad42823          	sw	a3,-80(s0)
800012c0:	d6cff0ef          	jal	ra,8000082c <__mulsi3>
800012c4:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
800012c8:	01bb8633          	add	a2,s7,s11
800012cc:	85d2                	mv	a1,s4
800012ce:	8526                	mv	a0,s1
800012d0:	33b5                	jal	8000103c <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800012d2:	fb042683          	lw	a3,-80(s0)
800012d6:	4090                	lw	a2,0(s1)
	return p->n_max * p->max_sz;
800012d8:	40cc                	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800012da:	16fd                	addi	a3,a3,-1
	return p->n_max * p->max_sz;
800012dc:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800012e0:	96e2                	add	a3,a3,s8
800012e2:	8e91                	sub	a3,a3,a2
800012e4:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
800012e8:	d44ff0ef          	jal	ra,8000082c <__mulsi3>
		if (block_fits(p, block2, lsz)) {
800012ec:	fb042683          	lw	a3,-80(s0)
800012f0:	fac42883          	lw	a7,-84(s0)
800012f4:	02a6f063          	bgeu	a3,a0,80001314 <z_sys_mem_pool_block_alloc+0x1d4>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
800012f8:	44d4                	lw	a3,12(s1)
800012fa:	96c6                	add	a3,a3,a7
800012fc:	00468613          	addi	a2,a3,4
	node->next = list;
80001300:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
80001304:	4690                	lw	a2,8(a3)
80001306:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
8000130a:	4690                	lw	a2,8(a3)
8000130c:	01862023          	sw	s8,0(a2)
	list->tail = node;
80001310:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
80001314:	0b85                	addi	s7,s7,1
80001316:	4791                	li	a5,4
80001318:	f8fb9ce3          	bne	s7,a5,800012b0 <z_sys_mem_pool_block_alloc+0x170>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000131c:	0104c683          	lbu	a3,16(s1)
80001320:	8a85                	andi	a3,a3,1
80001322:	e689                	bnez	a3,8000132c <z_sys_mem_pool_block_alloc+0x1ec>
		return 0;
80001324:	4901                	li	s2,0
80001326:	0a05                	addi	s4,s4,1
80001328:	0c91                	addi	s9,s9,4
8000132a:	b70d                	j	8000124c <z_sys_mem_pool_block_alloc+0x10c>
8000132c:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001330:	0104c683          	lbu	a3,16(s1)
80001334:	8a85                	andi	a3,a3,1
80001336:	d6fd                	beqz	a3,80001324 <z_sys_mem_pool_block_alloc+0x1e4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001338:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
8000133c:	00897913          	andi	s2,s2,8
80001340:	b7dd                	j	80001326 <z_sys_mem_pool_block_alloc+0x1e6>
	for (i = alloc_l; i >= 0; i--) {
80001342:	1a7d                	addi	s4,s4,-1
80001344:	ff498713          	addi	a4,s3,-12
80001348:	ecda13e3          	bne	s4,a3,8000120e <z_sys_mem_pool_block_alloc+0xce>
8000134c:	4981                	li	s3,0
8000134e:	b719                	j	80001254 <z_sys_mem_pool_block_alloc+0x114>

80001350 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001350:	711d                	addi	sp,sp,-96
80001352:	cca2                	sw	s0,88(sp)
80001354:	c4d2                	sw	s4,72(sp)
80001356:	da66                	sw	s9,52(sp)
80001358:	ce86                	sw	ra,92(sp)
8000135a:	caa6                	sw	s1,84(sp)
8000135c:	c8ca                	sw	s2,80(sp)
8000135e:	c6ce                	sw	s3,76(sp)
80001360:	c2d6                	sw	s5,68(sp)
80001362:	c0da                	sw	s6,64(sp)
80001364:	de5e                	sw	s7,60(sp)
80001366:	dc62                	sw	s8,56(sp)
80001368:	d86a                	sw	s10,48(sp)
8000136a:	d66e                	sw	s11,44(sp)
8000136c:	1080                	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000136e:	00a54703          	lbu	a4,10(a0)
{
80001372:	8caa                	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001374:	070a                	slli	a4,a4,0x2
80001376:	073d                	addi	a4,a4,15
80001378:	7f077713          	andi	a4,a4,2032
8000137c:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
80001380:	4158                	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001382:	8a0a                	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001384:	86d2                	mv	a3,s4
80001386:	070d                	addi	a4,a4,3
80001388:	9b71                	andi	a4,a4,-4
8000138a:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
8000138e:	4505                	li	a0,1
80001390:	0691                	addi	a3,a3,4
80001392:	08a5f363          	bgeu	a1,a0,80001418 <z_sys_mem_pool_block_free+0xc8>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001396:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
8000139a:	892e                	mv	s2,a1
8000139c:	89b2                	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000139e:	8b05                	andi	a4,a4,1
		return 0;
800013a0:	4481                	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013a2:	c709                	beqz	a4,800013ac <z_sys_mem_pool_block_free+0x5c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800013a4:	44a1                	li	s1,8
800013a6:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800013aa:	88a1                	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800013ac:	80005b37          	lui	s6,0x80005
	while (level >= 0) {
800013b0:	06095c63          	bgez	s2,80001428 <z_sys_mem_pool_block_free+0xd8>
	__ASSERT(0, "out of levels");
800013b4:	800054b7          	lui	s1,0x80005
800013b8:	800055b7          	lui	a1,0x80005
800013bc:	80005537          	lui	a0,0x80005
800013c0:	0b448613          	addi	a2,s1,180 # 800050b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050b5>
800013c4:	0c000693          	li	a3,192
800013c8:	11c58593          	addi	a1,a1,284 # 8000511c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000511d>
800013cc:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800013d0:	23fd                	jal	800019be <printk>
800013d2:	80005537          	lui	a0,0x80005
800013d6:	0e850513          	addi	a0,a0,232 # 800050e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e9>
800013da:	23d5                	jal	800019be <printk>
800013dc:	0b448513          	addi	a0,s1,180
800013e0:	0c000593          	li	a1,192
800013e4:	2be5                	jal	800019dc <assert_post_action>
	return -1;
800013e6:	54fd                	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013e8:	010cc783          	lbu	a5,16(s9)
800013ec:	8b85                	andi	a5,a5,1
800013ee:	c781                	beqz	a5,800013f6 <z_sys_mem_pool_block_free+0xa6>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
800013f0:	88a1                	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800013f2:	3004a4f3          	csrrs	s1,mstatus,s1
}
800013f6:	fa040113          	addi	sp,s0,-96
800013fa:	40f6                	lw	ra,92(sp)
800013fc:	4466                	lw	s0,88(sp)
800013fe:	44d6                	lw	s1,84(sp)
80001400:	4946                	lw	s2,80(sp)
80001402:	49b6                	lw	s3,76(sp)
80001404:	4a26                	lw	s4,72(sp)
80001406:	4a96                	lw	s5,68(sp)
80001408:	4b06                	lw	s6,64(sp)
8000140a:	5bf2                	lw	s7,60(sp)
8000140c:	5c62                	lw	s8,56(sp)
8000140e:	5cd2                	lw	s9,52(sp)
80001410:	5d42                	lw	s10,48(sp)
80001412:	5db2                	lw	s11,44(sp)
80001414:	6125                	addi	sp,sp,96
80001416:	8082                	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001418:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
8000141c:	0505                	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000141e:	8309                	srli	a4,a4,0x2
80001420:	070d                	addi	a4,a4,3
80001422:	9b71                	andi	a4,a4,-4
80001424:	c298                	sw	a4,0(a3)
80001426:	b7ad                	j	80001390 <z_sys_mem_pool_block_free+0x40>
		int i, lsz = lsizes[level];
80001428:	00291713          	slli	a4,s2,0x2
8000142c:	9752                	add	a4,a4,s4
8000142e:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80001432:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
80001436:	854e                	mv	a0,s3
80001438:	85d6                	mv	a1,s5
8000143a:	bf2ff0ef          	jal	ra,8000082c <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000143e:	fffa8b93          	addi	s7,s5,-1
80001442:	01750d33          	add	s10,a0,s7
80001446:	9c2a                	add	s8,s8,a0
	return p->n_max * p->max_sz;
80001448:	004ca583          	lw	a1,4(s9)
8000144c:	008cd503          	lhu	a0,8(s9)
80001450:	bdcff0ef          	jal	ra,8000082c <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
80001454:	02ad6963          	bltu	s10,a0,80001486 <z_sys_mem_pool_block_free+0x136>
80001458:	800057b7          	lui	a5,0x80005
8000145c:	0c878593          	addi	a1,a5,200 # 800050c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050c9>
80001460:	800057b7          	lui	a5,0x80005
80001464:	06078513          	addi	a0,a5,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80001468:	0a400693          	li	a3,164
8000146c:	0b4b0613          	addi	a2,s6,180 # 800050b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050b5>
80001470:	23b9                	jal	800019be <printk>
80001472:	800057b7          	lui	a5,0x80005
80001476:	0e478513          	addi	a0,a5,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
8000147a:	2391                	jal	800019be <printk>
8000147c:	0a400593          	li	a1,164
80001480:	0b4b0513          	addi	a0,s6,180
80001484:	2ba1                	jal	800019dc <assert_post_action>
		set_free_bit(p, level, bn);
80001486:	864e                	mv	a2,s3
80001488:	85ca                	mv	a1,s2
8000148a:	8566                	mv	a0,s9
8000148c:	3e45                	jal	8000103c <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
8000148e:	00191713          	slli	a4,s2,0x1
80001492:	974a                	add	a4,a4,s2
80001494:	00271693          	slli	a3,a4,0x2
80001498:	00cca703          	lw	a4,12(s9)
8000149c:	9736                	add	a4,a4,a3
8000149e:	00470693          	addi	a3,a4,4
	node->next = list;
800014a2:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
800014a6:	4714                	lw	a3,8(a4)
800014a8:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
800014ac:	4714                	lw	a3,8(a4)
800014ae:	0186a023          	sw	s8,0(a3)
	list->tail = node;
800014b2:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800014b6:	010cc703          	lbu	a4,16(s9)
800014ba:	8b05                	andi	a4,a4,1
800014bc:	e345                	bnez	a4,8000155c <z_sys_mem_pool_block_free+0x20c>
		return 0;
800014be:	4481                	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800014c0:	f20904e3          	beqz	s2,800013e8 <z_sys_mem_pool_block_free+0x98>
	int bit = get_bit_ptr(p, level, bn, &word);
800014c4:	fbc40693          	addi	a3,s0,-68
800014c8:	864e                	mv	a2,s3
800014ca:	85ca                	mv	a1,s2
800014cc:	8566                	mv	a0,s9
800014ce:	3681                	jal	8000100e <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
800014d0:	fbc42683          	lw	a3,-68(s0)
800014d4:	41f55713          	srai	a4,a0,0x1f
800014d8:	8b0d                	andi	a4,a4,3
800014da:	972a                	add	a4,a4,a0
800014dc:	4288                	lw	a0,0(a3)
800014de:	9b71                	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800014e0:	47bd                	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
800014e2:	00e55733          	srl	a4,a0,a4
800014e6:	8b3d                	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800014e8:	f0f710e3          	bne	a4,a5,800013e8 <z_sys_mem_pool_block_free+0x98>
		for (i = 0; i < 4; i++) {
800014ec:	4d01                	li	s10,0
			int b = (bn & ~3) + i;
800014ee:	ffc9fd93          	andi	s11,s3,-4
800014f2:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
800014f6:	8532                	mv	a0,a2
800014f8:	85d6                	mv	a1,s5
800014fa:	fac42423          	sw	a2,-88(s0)
800014fe:	b2eff0ef          	jal	ra,8000082c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001502:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80001506:	8c2a                	mv	s8,a0
	return p->n_max * p->max_sz;
80001508:	004ca583          	lw	a1,4(s9)
8000150c:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001510:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001514:	b18ff0ef          	jal	ra,8000082c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001518:	fac42703          	lw	a4,-84(s0)
8000151c:	fa842603          	lw	a2,-88(s0)
80001520:	02a77263          	bgeu	a4,a0,80001544 <z_sys_mem_pool_block_free+0x1f4>
				clear_free_bit(p, level, b);
80001524:	85ca                	mv	a1,s2
80001526:	8566                	mv	a0,s9
80001528:	3e05                	jal	80001058 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
8000152a:	000ca703          	lw	a4,0(s9)
8000152e:	9c3a                	add	s8,s8,a4
	node->prev->next = node->next;
80001530:	004c2603          	lw	a2,4(s8)
80001534:	000c2703          	lw	a4,0(s8)
80001538:	c218                	sw	a4,0(a2)
	node->next->prev = node->prev;
8000153a:	c350                	sw	a2,4(a4)
	node->next = NULL;
8000153c:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001540:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001544:	0d05                	addi	s10,s10,1
80001546:	4791                	li	a5,4
80001548:	fafd15e3          	bne	s10,a5,800014f2 <z_sys_mem_pool_block_free+0x1a2>
		bn = bn / 4;
8000154c:	41f9d613          	srai	a2,s3,0x1f
80001550:	8a0d                	andi	a2,a2,3
80001552:	99b2                	add	s3,s3,a2
		level = level - 1;
80001554:	197d                	addi	s2,s2,-1
		bn = bn / 4;
80001556:	4029d993          	srai	s3,s3,0x2
8000155a:	bd99                	j	800013b0 <z_sys_mem_pool_block_free+0x60>
8000155c:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001560:	010cc703          	lbu	a4,16(s9)
80001564:	8b05                	andi	a4,a4,1
80001566:	df21                	beqz	a4,800014be <z_sys_mem_pool_block_free+0x16e>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001568:	47a1                	li	a5,8
8000156a:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
8000156e:	88a1                	andi	s1,s1,8
80001570:	bf81                	j	800014c0 <z_sys_mem_pool_block_free+0x170>

80001572 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001572:	1141                	addi	sp,sp,-16
80001574:	87aa                	mv	a5,a0
80001576:	852e                	mv	a0,a1
80001578:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
8000157a:	8636                	mv	a2,a3
{
8000157c:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
8000157e:	9782                	jalr	a5
80001580:	5b1010ef          	jal	ra,80003330 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001584:	6cc020ef          	jal	ra,80003c50 <z_impl_k_thread_abort>

80001588 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001588:	4501                	li	a0,0
8000158a:	8082                	ret

8000158c <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
8000158c:	1141                	addi	sp,sp,-16
8000158e:	c422                	sw	s0,8(sp)
80001590:	842a                	mv	s0,a0
	out('E', ctx);
80001592:	04500513          	li	a0,69
{
80001596:	c606                	sw	ra,12(sp)
80001598:	c226                	sw	s1,4(sp)
8000159a:	84ae                	mv	s1,a1
	out('E', ctx);
8000159c:	9402                	jalr	s0
	out('R', ctx);
8000159e:	85a6                	mv	a1,s1
800015a0:	05200513          	li	a0,82
800015a4:	9402                	jalr	s0
	out('R', ctx);
800015a6:	8322                	mv	t1,s0
}
800015a8:	4422                	lw	s0,8(sp)
800015aa:	40b2                	lw	ra,12(sp)
	out('R', ctx);
800015ac:	85a6                	mv	a1,s1
}
800015ae:	4492                	lw	s1,4(sp)
	out('R', ctx);
800015b0:	05200513          	li	a0,82
}
800015b4:	0141                	addi	sp,sp,16
	out('R', ctx);
800015b6:	8302                	jr	t1

800015b8 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800015b8:	419c                	lw	a5,0(a1)
800015ba:	0785                	addi	a5,a5,1
800015bc:	c19c                	sw	a5,0(a1)
	return _char_out(c);
800015be:	800057b7          	lui	a5,0x80005
800015c2:	6dc7a303          	lw	t1,1756(a5) # 800056dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056dd>
800015c6:	8302                	jr	t1

800015c8 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
800015c8:	7139                	addi	sp,sp,-64
800015ca:	dc22                	sw	s0,56(sp)
800015cc:	d64e                	sw	s3,44(sp)
800015ce:	d452                	sw	s4,40(sp)
800015d0:	d05a                	sw	s6,32(sp)
800015d2:	c86a                	sw	s10,16(sp)
800015d4:	de06                	sw	ra,60(sp)
800015d6:	da26                	sw	s1,52(sp)
800015d8:	d84a                	sw	s2,48(sp)
800015da:	d256                	sw	s5,36(sp)
800015dc:	ce5e                	sw	s7,28(sp)
800015de:	cc62                	sw	s8,24(sp)
800015e0:	ca66                	sw	s9,20(sp)
800015e2:	c66e                	sw	s11,12(sp)
800015e4:	89aa                	mv	s3,a0
800015e6:	8a2e                	mv	s4,a1
800015e8:	8d32                	mv	s10,a2
800015ea:	8b36                	mv	s6,a3
800015ec:	4405                	li	s0,1
800015ee:	00e05363          	blez	a4,800015f4 <_printk_dec_ulong+0x2c>
800015f2:	843a                	mv	s0,a4
800015f4:	4785                	li	a5,1
800015f6:	02000c93          	li	s9,32
800015fa:	00fb1463          	bne	s6,a5,80001602 <_printk_dec_ulong+0x3a>
800015fe:	03000c93          	li	s9,48
80001602:	3b9ad4b7          	lui	s1,0x3b9ad
80001606:	4905                	li	s2,1
80001608:	4aa9                	li	s5,10
8000160a:	4c01                	li	s8,0
8000160c:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001610:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001612:	00148b93          	addi	s7,s1,1
80001616:	000c1463          	bnez	s8,8000161e <_printk_dec_ulong+0x56>
8000161a:	07a4f263          	bgeu	s1,s10,8000167e <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
8000161e:	85de                	mv	a1,s7
80001620:	856a                	mv	a0,s10
80001622:	a36ff0ef          	jal	ra,80000858 <__udivsi3>
80001626:	85d2                	mv	a1,s4
80001628:	03050513          	addi	a0,a0,48
8000162c:	9982                	jalr	s3
			digits++;
8000162e:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
80001630:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001632:	85de                	mv	a1,s7
80001634:	856a                	mv	a0,s10
80001636:	a6aff0ef          	jal	ra,800008a0 <__umodsi3>
8000163a:	8d2a                	mv	s10,a0
		pos /= 10;
8000163c:	45a9                	li	a1,10
8000163e:	8526                	mv	a0,s1
80001640:	a18ff0ef          	jal	ra,80000858 <__udivsi3>
		remaining--;
80001644:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
80001646:	4785                	li	a5,1
		pos /= 10;
80001648:	84aa                	mv	s1,a0
	while (pos >= 9) {
8000164a:	fcfa94e3          	bne	s5,a5,80001612 <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
8000164e:	85d2                	mv	a1,s4
80001650:	030d0513          	addi	a0,s10,48
80001654:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001656:	478d                	li	a5,3
		remaining = min_width - digits;
80001658:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
8000165c:	02fb0f63          	beq	s6,a5,8000169a <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001660:	50f2                	lw	ra,60(sp)
80001662:	5462                	lw	s0,56(sp)
80001664:	54d2                	lw	s1,52(sp)
80001666:	5942                	lw	s2,48(sp)
80001668:	59b2                	lw	s3,44(sp)
8000166a:	5a22                	lw	s4,40(sp)
8000166c:	5a92                	lw	s5,36(sp)
8000166e:	5b02                	lw	s6,32(sp)
80001670:	4bf2                	lw	s7,28(sp)
80001672:	4c62                	lw	s8,24(sp)
80001674:	4cd2                	lw	s9,20(sp)
80001676:	4d42                	lw	s10,16(sp)
80001678:	4db2                	lw	s11,12(sp)
8000167a:	6121                	addi	sp,sp,64
8000167c:	8082                	ret
		} else if (remaining <= min_width
8000167e:	fb544ae3          	blt	s0,s5,80001632 <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
80001682:	fb6de8e3          	bltu	s11,s6,80001632 <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001686:	85d2                	mv	a1,s4
80001688:	8566                	mv	a0,s9
8000168a:	9982                	jalr	s3
			digits++;
8000168c:	0905                	addi	s2,s2,1
8000168e:	b755                	j	80001632 <_printk_dec_ulong+0x6a>
			out(' ', ctx);
80001690:	85d2                	mv	a1,s4
80001692:	02000513          	li	a0,32
80001696:	9982                	jalr	s3
80001698:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
8000169a:	fe804be3          	bgtz	s0,80001690 <_printk_dec_ulong+0xc8>
8000169e:	b7c9                	j	80001660 <_printk_dec_ulong+0x98>

800016a0 <__printk_hook_install>:
	_char_out = fn;
800016a0:	800057b7          	lui	a5,0x80005
800016a4:	6ca7ae23          	sw	a0,1756(a5) # 800056dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056dd>
}
800016a8:	8082                	ret

800016aa <z_vprintk>:
{
800016aa:	715d                	addi	sp,sp,-80
800016ac:	c4a2                	sw	s0,72(sp)
800016ae:	c2a6                	sw	s1,68(sp)
800016b0:	c0ca                	sw	s2,64(sp)
800016b2:	de4e                	sw	s3,60(sp)
800016b4:	dc52                	sw	s4,56(sp)
800016b6:	da56                	sw	s5,52(sp)
800016b8:	d266                	sw	s9,36(sp)
800016ba:	d06a                	sw	s10,32(sp)
800016bc:	ce6e                	sw	s11,28(sp)
800016be:	c686                	sw	ra,76(sp)
800016c0:	d85a                	sw	s6,48(sp)
800016c2:	d65e                	sw	s7,44(sp)
800016c4:	d462                	sw	s8,40(sp)
800016c6:	842a                	mv	s0,a0
800016c8:	84ae                	mv	s1,a1
800016ca:	8ab2                	mv	s5,a2
800016cc:	8d36                	mv	s10,a3
	int long_ctr = 0;
800016ce:	4a01                	li	s4,0
	int min_width = -1;
800016d0:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
800016d2:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800016d4:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
800016d6:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800016da:	000ac503          	lbu	a0,0(s5)
800016de:	e105                	bnez	a0,800016fe <z_vprintk+0x54>
}
800016e0:	40b6                	lw	ra,76(sp)
800016e2:	4426                	lw	s0,72(sp)
800016e4:	4496                	lw	s1,68(sp)
800016e6:	4906                	lw	s2,64(sp)
800016e8:	59f2                	lw	s3,60(sp)
800016ea:	5a62                	lw	s4,56(sp)
800016ec:	5ad2                	lw	s5,52(sp)
800016ee:	5b42                	lw	s6,48(sp)
800016f0:	5bb2                	lw	s7,44(sp)
800016f2:	5c22                	lw	s8,40(sp)
800016f4:	5c92                	lw	s9,36(sp)
800016f6:	5d02                	lw	s10,32(sp)
800016f8:	4df2                	lw	s11,28(sp)
800016fa:	6161                	addi	sp,sp,80
800016fc:	8082                	ret
		if (!might_format) {
800016fe:	000c9a63          	bnez	s9,80001712 <z_vprintk+0x68>
			if (*fmt != '%') {
80001702:	02500693          	li	a3,37
80001706:	28d50563          	beq	a0,a3,80001990 <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
8000170a:	85a6                	mv	a1,s1
8000170c:	9402                	jalr	s0
		++fmt;
8000170e:	0a85                	addi	s5,s5,1
80001710:	b7e9                	j	800016da <z_vprintk+0x30>
			switch (*fmt) {
80001712:	06400693          	li	a3,100
80001716:	0ed50b63          	beq	a0,a3,8000180c <z_vprintk+0x162>
8000171a:	04a6eb63          	bltu	a3,a0,80001770 <z_vprintk+0xc6>
8000171e:	03900693          	li	a3,57
80001722:	02a6e763          	bltu	a3,a0,80001750 <z_vprintk+0xa6>
80001726:	03100693          	li	a3,49
8000172a:	0cd57563          	bgeu	a0,a3,800017f4 <z_vprintk+0x14a>
8000172e:	02d00693          	li	a3,45
80001732:	26d50463          	beq	a0,a3,8000199a <z_vprintk+0x2f0>
80001736:	03000793          	li	a5,48
8000173a:	0af50363          	beq	a0,a5,800017e0 <z_vprintk+0x136>
8000173e:	02500713          	li	a4,37
80001742:	00e51f63          	bne	a0,a4,80001760 <z_vprintk+0xb6>
				out((int)'%', ctx);
80001746:	85a6                	mv	a1,s1
80001748:	02500513          	li	a0,37
				out((int)*fmt, ctx);
8000174c:	9402                	jalr	s0
				break;
8000174e:	aa09                	j	80001860 <z_vprintk+0x1b6>
80001750:	05800693          	li	a3,88
80001754:	14d50b63          	beq	a0,a3,800018aa <z_vprintk+0x200>
80001758:	06300713          	li	a4,99
8000175c:	22e50363          	beq	a0,a4,80001982 <z_vprintk+0x2d8>
				out((int)'%', ctx);
80001760:	85a6                	mv	a1,s1
80001762:	02500513          	li	a0,37
80001766:	9402                	jalr	s0
				out((int)*fmt, ctx);
80001768:	85a6                	mv	a1,s1
8000176a:	000ac503          	lbu	a0,0(s5)
8000176e:	bff9                	j	8000174c <z_vprintk+0xa2>
80001770:	07000693          	li	a3,112
80001774:	12d50163          	beq	a0,a3,80001896 <z_vprintk+0x1ec>
80001778:	00a6ef63          	bltu	a3,a0,80001796 <z_vprintk+0xec>
8000177c:	06900693          	li	a3,105
80001780:	08d50663          	beq	a0,a3,8000180c <z_vprintk+0x162>
80001784:	06c00693          	li	a3,108
80001788:	08d50063          	beq	a0,a3,80001808 <z_vprintk+0x15e>
8000178c:	06800693          	li	a3,104
80001790:	f6d50fe3          	beq	a0,a3,8000170e <z_vprintk+0x64>
80001794:	b7f1                	j	80001760 <z_vprintk+0xb6>
80001796:	07500693          	li	a3,117
8000179a:	0cd50563          	beq	a0,a3,80001864 <z_vprintk+0x1ba>
8000179e:	02a6ea63          	bltu	a3,a0,800017d2 <z_vprintk+0x128>
800017a2:	07300713          	li	a4,115
800017a6:	fae51de3          	bne	a0,a4,80001760 <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
800017aa:	000d2c03          	lw	s8,0(s10)
800017ae:	004d0b13          	addi	s6,s10,4
800017b2:	8be2                	mv	s7,s8
				while (*s)
800017b4:	000bc503          	lbu	a0,0(s7)
800017b8:	1a051b63          	bnez	a0,8000196e <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
800017bc:	478d                	li	a5,3
800017be:	00f99863          	bne	s3,a5,800017ce <z_vprintk+0x124>
					int remaining = min_width - (s - start);
800017c2:	418b8bb3          	sub	s7,s7,s8
800017c6:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800017ca:	1b704663          	bgtz	s7,80001976 <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
800017ce:	8d5a                	mv	s10,s6
800017d0:	a841                	j	80001860 <z_vprintk+0x1b6>
800017d2:	07800693          	li	a3,120
800017d6:	0cd50a63          	beq	a0,a3,800018aa <z_vprintk+0x200>
800017da:	07a00693          	li	a3,122
800017de:	bf4d                	j	80001790 <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
800017e0:	00095c63          	bgez	s2,800017f8 <z_vprintk+0x14e>
800017e4:	1a098d63          	beqz	s3,8000199e <z_vprintk+0x2f4>
					min_width = *fmt - '0';
800017e8:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
800017ec:	f20991e3          	bnez	s3,8000170e <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
800017f0:	4989                	li	s3,2
800017f2:	bf31                	j	8000170e <z_vprintk+0x64>
				if (min_width < 0) {
800017f4:	fe094ae3          	bltz	s2,800017e8 <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
800017f8:	00291693          	slli	a3,s2,0x2
800017fc:	9936                	add	s2,s2,a3
800017fe:	0906                	slli	s2,s2,0x1
80001800:	fd090913          	addi	s2,s2,-48
80001804:	992a                	add	s2,s2,a0
80001806:	b7dd                	j	800017ec <z_vprintk+0x142>
				long_ctr++;
80001808:	0a05                	addi	s4,s4,1
8000180a:	b711                	j	8000170e <z_vprintk+0x64>
				if (long_ctr == 0) {
8000180c:	020a1663          	bnez	s4,80001838 <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
80001810:	000d2603          	lw	a2,0(s10)
80001814:	0d11                	addi	s10,s10,4
				if (d < 0) {
80001816:	00065b63          	bgez	a2,8000182c <z_vprintk+0x182>
					out((int)'-', ctx);
8000181a:	85a6                	mv	a1,s1
8000181c:	02d00513          	li	a0,45
80001820:	c032                	sw	a2,0(sp)
80001822:	9402                	jalr	s0
					d = -d;
80001824:	4602                	lw	a2,0(sp)
					min_width--;
80001826:	197d                	addi	s2,s2,-1
					d = -d;
80001828:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
8000182c:	874a                	mv	a4,s2
8000182e:	86ce                	mv	a3,s3
80001830:	85a6                	mv	a1,s1
80001832:	8522                	mv	a0,s0
80001834:	3b51                	jal	800015c8 <_printk_dec_ulong>
				break;
80001836:	a02d                	j	80001860 <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
80001838:	4705                	li	a4,1
8000183a:	fcea0be3          	beq	s4,a4,80001810 <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
8000183e:	007d0793          	addi	a5,s10,7
80001842:	ff87f713          	andi	a4,a5,-8
80001846:	4310                	lw	a2,0(a4)
80001848:	4354                	lw	a3,4(a4)
8000184a:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
8000184e:	01b60733          	add	a4,a2,s11
80001852:	00c73733          	sltu	a4,a4,a2
80001856:	9736                	add	a4,a4,a3
80001858:	df5d                	beqz	a4,80001816 <z_vprintk+0x16c>
						print_err(out, ctx);
8000185a:	85a6                	mv	a1,s1
8000185c:	8522                	mv	a0,s0
8000185e:	333d                	jal	8000158c <print_err>
			might_format = 0;
80001860:	4c81                	li	s9,0
80001862:	b575                	j	8000170e <z_vprintk+0x64>
				if (long_ctr == 0) {
80001864:	000a1663          	bnez	s4,80001870 <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
80001868:	000d2603          	lw	a2,0(s10)
8000186c:	0d11                	addi	s10,s10,4
8000186e:	bf7d                	j	8000182c <z_vprintk+0x182>
				} else if (long_ctr == 1) {
80001870:	4705                	li	a4,1
80001872:	feea0be3          	beq	s4,a4,80001868 <z_vprintk+0x1be>
					unsigned long long llu =
80001876:	007d0793          	addi	a5,s10,7
8000187a:	ff87f713          	andi	a4,a5,-8
8000187e:	00870d13          	addi	s10,a4,8
80001882:	4310                	lw	a2,0(a4)
80001884:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001886:	fb71                	bnez	a4,8000185a <z_vprintk+0x1b0>
80001888:	800007b7          	lui	a5,0x80000
8000188c:	fff7c793          	not	a5,a5
80001890:	f8c7fee3          	bgeu	a5,a2,8000182c <z_vprintk+0x182>
80001894:	b7d9                	j	8000185a <z_vprintk+0x1b0>
				  out('0', ctx);
80001896:	85a6                	mv	a1,s1
80001898:	03000513          	li	a0,48
8000189c:	9402                	jalr	s0
				  out('x', ctx);
8000189e:	85a6                	mv	a1,s1
800018a0:	07800513          	li	a0,120
800018a4:	9402                	jalr	s0
				  min_width = 8;
800018a6:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
800018a8:	4985                	li	s3,1
				if (long_ctr < 2) {
800018aa:	4685                	li	a3,1
800018ac:	0746c663          	blt	a3,s4,80001918 <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
800018b0:	000d2783          	lw	a5,0(s10)
800018b4:	c402                	sw	zero,8(sp)
800018b6:	0d11                	addi	s10,s10,4
800018b8:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
800018ba:	4c41                	li	s8,16
	int digits = 0;
800018bc:	4b81                	li	s7,0
	int found_largest_digit = 0;
800018be:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800018c0:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800018c2:	4512                	lw	a0,4(sp)
800018c4:	45a2                	lw	a1,8(sp)
800018c6:	fff88b13          	addi	s6,a7,-1
800018ca:	002b1613          	slli	a2,s6,0x2
800018ce:	c646                	sw	a7,12(sp)
800018d0:	951fe0ef          	jal	ra,80000220 <__lshrdi3>
800018d4:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800018d6:	ed39                	bnez	a0,80001934 <z_vprintk+0x28a>
800018d8:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
800018da:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800018de:	e789                	bnez	a5,800018e8 <z_vprintk+0x23e>
800018e0:	48b2                	lw	a7,12(sp)
800018e2:	4785                	li	a5,1
800018e4:	06f89063          	bne	a7,a5,80001944 <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
800018e8:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
800018ea:	0562                	slli	a0,a0,0x18
800018ec:	85a6                	mv	a1,s1
800018ee:	8561                	srai	a0,a0,0x18
800018f0:	9402                	jalr	s0
			digits++;
800018f2:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
800018f4:	020b1d63          	bnez	s6,8000192e <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
800018f8:	468d                	li	a3,3
			might_format = 0;
800018fa:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800018fc:	e0d999e3          	bne	s3,a3,8000170e <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
80001900:	00191713          	slli	a4,s2,0x1
80001904:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001908:	f5705ce3          	blez	s7,80001860 <z_vprintk+0x1b6>
			out(' ', ctx);
8000190c:	85a6                	mv	a1,s1
8000190e:	02000513          	li	a0,32
80001912:	9402                	jalr	s0
80001914:	1bfd                	addi	s7,s7,-1
80001916:	bfcd                	j	80001908 <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
80001918:	007d0793          	addi	a5,s10,7
8000191c:	ff87f693          	andi	a3,a5,-8
80001920:	429c                	lw	a5,0(a3)
80001922:	00868d13          	addi	s10,a3,8
80001926:	c23e                	sw	a5,4(sp)
80001928:	42dc                	lw	a5,4(a3)
8000192a:	c43e                	sw	a5,8(sp)
8000192c:	b779                	j	800018ba <z_vprintk+0x210>
			found_largest_digit = 1;
8000192e:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001930:	88da                	mv	a7,s6
80001932:	bf41                	j	800018c2 <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
80001934:	47a5                	li	a5,9
80001936:	05700693          	li	a3,87
8000193a:	faa7e7e3          	bltu	a5,a0,800018e8 <z_vprintk+0x23e>
8000193e:	03000693          	li	a3,48
80001942:	b75d                	j	800018e8 <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
80001944:	fffc0793          	addi	a5,s8,-1
80001948:	c63e                	sw	a5,12(sp)
8000194a:	01894963          	blt	s2,s8,8000195c <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
8000194e:	4785                	li	a5,1
80001950:	00f99863          	bne	s3,a5,80001960 <z_vprintk+0x2b6>
				out('0', ctx);
80001954:	85a6                	mv	a1,s1
80001956:	03000513          	li	a0,48
				out(' ', ctx);
8000195a:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
8000195c:	4c32                	lw	s8,12(sp)
8000195e:	bfc9                	j	80001930 <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
80001960:	4789                	li	a5,2
80001962:	fef99de3          	bne	s3,a5,8000195c <z_vprintk+0x2b2>
				out(' ', ctx);
80001966:	85a6                	mv	a1,s1
80001968:	02000513          	li	a0,32
8000196c:	b7fd                	j	8000195a <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
8000196e:	85a6                	mv	a1,s1
80001970:	0b85                	addi	s7,s7,1
80001972:	9402                	jalr	s0
80001974:	b581                	j	800017b4 <z_vprintk+0x10a>
						out(' ', ctx);
80001976:	85a6                	mv	a1,s1
80001978:	02000513          	li	a0,32
8000197c:	9402                	jalr	s0
8000197e:	1bfd                	addi	s7,s7,-1
80001980:	b5a9                	j	800017ca <z_vprintk+0x120>
				out(c, ctx);
80001982:	000d2503          	lw	a0,0(s10)
80001986:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
80001988:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
8000198c:	9402                	jalr	s0
				break;
8000198e:	b581                	j	800017ce <z_vprintk+0x124>
				long_ctr = 0;
80001990:	4a01                	li	s4,0
				min_width = -1;
80001992:	597d                	li	s2,-1
				padding = PAD_NONE;
80001994:	4981                	li	s3,0
				might_format = 1;
80001996:	4c85                	li	s9,1
80001998:	bb9d                	j	8000170e <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
8000199a:	498d                	li	s3,3
8000199c:	bb8d                	j	8000170e <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
8000199e:	4985                	li	s3,1
800019a0:	b3bd                	j	8000170e <z_vprintk+0x64>

800019a2 <vprintk>:
{
800019a2:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
800019a4:	862a                	mv	a2,a0
800019a6:	80001537          	lui	a0,0x80001
800019aa:	86ae                	mv	a3,a1
800019ac:	5b850513          	addi	a0,a0,1464 # 800015b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800015b9>
800019b0:	006c                	addi	a1,sp,12
{
800019b2:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800019b4:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
800019b6:	39d5                	jal	800016aa <z_vprintk>
}
800019b8:	40f2                	lw	ra,28(sp)
800019ba:	6105                	addi	sp,sp,32
800019bc:	8082                	ret

800019be <printk>:
{
800019be:	7139                	addi	sp,sp,-64
800019c0:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
800019c2:	104c                	addi	a1,sp,36
{
800019c4:	ce06                	sw	ra,28(sp)
800019c6:	d432                	sw	a2,40(sp)
800019c8:	d636                	sw	a3,44(sp)
800019ca:	d83a                	sw	a4,48(sp)
800019cc:	da3e                	sw	a5,52(sp)
800019ce:	dc42                	sw	a6,56(sp)
800019d0:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
800019d2:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
800019d4:	37f9                	jal	800019a2 <vprintk>
}
800019d6:	40f2                	lw	ra,28(sp)
800019d8:	6121                	addi	sp,sp,64
800019da:	8082                	ret

800019dc <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800019dc:	800055b7          	lui	a1,0x80005
800019e0:	80005537          	lui	a0,0x80005
{
800019e4:	1141                	addi	sp,sp,-16
  k_panic();
800019e6:	0f858593          	addi	a1,a1,248 # 800050f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050f9>
800019ea:	10c50513          	addi	a0,a0,268 # 8000510c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000510d>
800019ee:	4679                	li	a2,30
{
800019f0:	c606                	sw	ra,12(sp)
  k_panic();
800019f2:	37f1                	jal	800019be <printk>
800019f4:	800055b7          	lui	a1,0x80005
800019f8:	cd858593          	addi	a1,a1,-808 # 80004cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cd9>
800019fc:	4519                	li	a0,6
800019fe:	bd2ff0ef          	jal	ra,80000dd0 <z_NanoFatalErrorHandler>

80001a02 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001a02:	8082                	ret

80001a04 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001a04:	47a1                	li	a5,8
80001a06:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001a0a:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001a0e:	8082                	ret

80001a10 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001a10:	4785                	li	a5,1
80001a12:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001a16:	30452573          	csrrs	a0,mie,a0
}
80001a1a:	8082                	ret

80001a1c <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001a1c:	47a1                	li	a5,8
80001a1e:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001a22:	30405073          	csrwi	mie,0
80001a26:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001a2a:	8082                	ret

80001a2c <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001a2c:	1141                	addi	sp,sp,-16
80001a2e:	c422                	sw	s0,8(sp)
80001a30:	c226                	sw	s1,4(sp)
80001a32:	80005437          	lui	s0,0x80005
80001a36:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001a38:	47a9                	li	a5,10
{
80001a3a:	84aa                	mv	s1,a0
80001a3c:	7b040413          	addi	s0,s0,1968 # 800057b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b1>
	if ('\n' == c) {
80001a40:	00f51763          	bne	a0,a5,80001a4e <console_out+0x22>
80001a44:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001a46:	45b5                	li	a1,13
80001a48:	415c                	lw	a5,4(a0)
80001a4a:	43dc                	lw	a5,4(a5)
80001a4c:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001a4e:	4008                	lw	a0,0(s0)
80001a50:	0ff4f593          	andi	a1,s1,255
80001a54:	415c                	lw	a5,4(a0)
80001a56:	43dc                	lw	a5,4(a5)
80001a58:	9782                	jalr	a5

	return c;
}
80001a5a:	40b2                	lw	ra,12(sp)
80001a5c:	4422                	lw	s0,8(sp)
80001a5e:	8526                	mv	a0,s1
80001a60:	4492                	lw	s1,4(sp)
80001a62:	0141                	addi	sp,sp,16
80001a64:	8082                	ret

80001a66 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001a66:	1141                	addi	sp,sp,-16
80001a68:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001a6a:	80002437          	lui	s0,0x80002
80001a6e:	a2c40513          	addi	a0,s0,-1492 # 80001a2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001a2d>
{
80001a72:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001a74:	21b5                	jal	80001ee0 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001a76:	a2c40513          	addi	a0,s0,-1492
}
80001a7a:	4422                	lw	s0,8(sp)
80001a7c:	40b2                	lw	ra,12(sp)
80001a7e:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
80001a80:	b105                	j	800016a0 <__printk_hook_install>

80001a82 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001a82:	80005537          	lui	a0,0x80005
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001a86:	1141                	addi	sp,sp,-16
80001a88:	11850513          	addi	a0,a0,280 # 80005118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005119>
80001a8c:	c606                	sw	ra,12(sp)
80001a8e:	712000ef          	jal	ra,800021a0 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001a92:	800057b7          	lui	a5,0x80005
80001a96:	7aa7a823          	sw	a0,1968(a5) # 800057b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b1>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001a9a:	37f1                	jal	80001a66 <uart_console_hook_install>

	return 0;
}
80001a9c:	40b2                	lw	ra,12(sp)
80001a9e:	4501                	li	a0,0
80001aa0:	0141                	addi	sp,sp,16
80001aa2:	8082                	ret

80001aa4 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001aa4:	f01007b7          	lui	a5,0xf0100
80001aa8:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001aac:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001ab0:	f447a583          	lw	a1,-188(a5)
80001ab4:	fee59ae3          	bne	a1,a4,80001aa8 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001ab8:	8082                	ret

80001aba <timer_isr>:

static void timer_isr(void *arg)
{
80001aba:	1101                	addi	sp,sp,-32
80001abc:	cc22                	sw	s0,24(sp)
80001abe:	ce06                	sw	ra,28(sp)
80001ac0:	ca26                	sw	s1,20(sp)
80001ac2:	c84a                	sw	s2,16(sp)
80001ac4:	c64e                	sw	s3,12(sp)
80001ac6:	c452                	sw	s4,8(sp)
80001ac8:	c256                	sw	s5,4(sp)
80001aca:	4421                	li	s0,8
80001acc:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001ad0:	80005937          	lui	s2,0x80005
80001ad4:	7b490513          	addi	a0,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80001ad8:	8821                	andi	s0,s0,8
80001ada:	6f3010ef          	jal	ra,800039cc <z_spin_lock_valid>
80001ade:	e915                	bnez	a0,80001b12 <timer_isr+0x58>
80001ae0:	800054b7          	lui	s1,0x80005
80001ae4:	800055b7          	lui	a1,0x80005
80001ae8:	80005537          	lui	a0,0x80005
80001aec:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80001af0:	04e00693          	li	a3,78
80001af4:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80001af8:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80001afc:	35c9                	jal	800019be <printk>
80001afe:	80005537          	lui	a0,0x80005
80001b02:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80001b06:	3d65                	jal	800019be <printk>
80001b08:	04e00593          	li	a1,78
80001b0c:	12c48513          	addi	a0,s1,300
80001b10:	35f1                	jal	800019dc <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001b12:	7b490513          	addi	a0,s2,1972
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001b16:	800054b7          	lui	s1,0x80005
80001b1a:	6ef010ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
80001b1e:	79048493          	addi	s1,s1,1936 # 80005790 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005791>
	u64_t now = mtime();
80001b22:	3749                	jal	80001aa4 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001b24:	0004a983          	lw	s3,0(s1)
80001b28:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001b2c:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001b2e:	41350533          	sub	a0,a0,s3
80001b32:	00a7b7b3          	sltu	a5,a5,a0
80001b36:	415585b3          	sub	a1,a1,s5
80001b3a:	6675                	lui	a2,0x1d
80001b3c:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001b40:	4681                	li	a3,0
80001b42:	8d9d                	sub	a1,a1,a5
80001b44:	f14fe0ef          	jal	ra,80000258 <__udivdi3>
80001b48:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80001b4a:	65f5                	lui	a1,0x1d
80001b4c:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001b50:	8552                	mv	a0,s4
80001b52:	cdbfe0ef          	jal	ra,8000082c <__mulsi3>
80001b56:	99aa                	add	s3,s3,a0
80001b58:	00a9b533          	sltu	a0,s3,a0
80001b5c:	9556                	add	a0,a0,s5
80001b5e:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001b60:	7b490513          	addi	a0,s2,1972
80001b64:	0134a023          	sw	s3,0(s1)
80001b68:	67f010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80001b6c:	e915                	bnez	a0,80001ba0 <timer_isr+0xe6>
80001b6e:	800054b7          	lui	s1,0x80005
80001b72:	800055b7          	lui	a1,0x80005
80001b76:	80005537          	lui	a0,0x80005
80001b7a:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80001b7e:	06100693          	li	a3,97
80001b82:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80001b86:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80001b8a:	3d15                	jal	800019be <printk>
80001b8c:	80005537          	lui	a0,0x80005
80001b90:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80001b94:	352d                	jal	800019be <printk>
80001b96:	06100593          	li	a1,97
80001b9a:	12c48513          	addi	a0,s1,300
80001b9e:	3d3d                	jal	800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ba0:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001ba4:	4462                	lw	s0,24(sp)
80001ba6:	40f2                	lw	ra,28(sp)
80001ba8:	44d2                	lw	s1,20(sp)
80001baa:	4942                	lw	s2,16(sp)
80001bac:	49b2                	lw	s3,12(sp)
80001bae:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001bb0:	8552                	mv	a0,s4
}
80001bb2:	4a22                	lw	s4,8(sp)
80001bb4:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001bb6:	60a0206f          	j	800041c0 <z_clock_announce>

80001bba <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001bba:	1141                	addi	sp,sp,-16
80001bbc:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001bbe:	35dd                	jal	80001aa4 <mtime>
80001bc0:	67f5                	lui	a5,0x1d
80001bc2:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001bc6:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001bca:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
80001bcc:	56fd                	li	a3,-1
80001bce:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001bd2:	00a7b533          	sltu	a0,a5,a0
80001bd6:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
80001bd8:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001bdc:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001be0:	451d                	li	a0,7
80001be2:	353d                	jal	80001a10 <z_arch_irq_enable>
	return 0;
}
80001be4:	40b2                	lw	ra,12(sp)
80001be6:	4501                	li	a0,0
80001be8:	0141                	addi	sp,sp,16
80001bea:	8082                	ret

80001bec <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001bec:	14059563          	bnez	a1,80001d36 <z_clock_set_timeout+0x14a>
{
80001bf0:	1101                	addi	sp,sp,-32
80001bf2:	ce06                	sw	ra,28(sp)
80001bf4:	cc22                	sw	s0,24(sp)
80001bf6:	ca26                	sw	s1,20(sp)
80001bf8:	c84a                	sw	s2,16(sp)
80001bfa:	c64e                	sw	s3,12(sp)
80001bfc:	c452                	sw	s4,8(sp)
80001bfe:	c256                	sw	s5,4(sp)
80001c00:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001c02:	57fd                	li	a5,-1
80001c04:	00f51563          	bne	a0,a5,80001c0e <z_clock_set_timeout+0x22>
80001c08:	6525                	lui	a0,0x9
80001c0a:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001c0e:	67a5                	lui	a5,0x9
80001c10:	fff50413          	addi	s0,a0,-1
80001c14:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001c18:	1087db63          	bge	a5,s0,80001d2e <z_clock_set_timeout+0x142>
80001c1c:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001c1e:	4921                	li	s2,8
80001c20:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001c24:	80005ab7          	lui	s5,0x80005
80001c28:	7b4a8513          	addi	a0,s5,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80001c2c:	00897913          	andi	s2,s2,8
80001c30:	59d010ef          	jal	ra,800039cc <z_spin_lock_valid>
80001c34:	e915                	bnez	a0,80001c68 <z_clock_set_timeout+0x7c>
80001c36:	800054b7          	lui	s1,0x80005
80001c3a:	800055b7          	lui	a1,0x80005
80001c3e:	80005537          	lui	a0,0x80005
80001c42:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80001c46:	04e00693          	li	a3,78
80001c4a:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80001c4e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80001c52:	33b5                	jal	800019be <printk>
80001c54:	80005537          	lui	a0,0x80005
80001c58:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80001c5c:	338d                	jal	800019be <printk>
80001c5e:	04e00593          	li	a1,78
80001c62:	12c48513          	addi	a0,s1,300
80001c66:	3b9d                	jal	800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80001c68:	7b4a8513          	addi	a0,s5,1972
80001c6c:	59d010ef          	jal	ra,80003a08 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001c70:	3d15                	jal	80001aa4 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001c72:	800057b7          	lui	a5,0x80005
80001c76:	79078793          	addi	a5,a5,1936 # 80005790 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005791>
	u32_t cyc = ticks * CYC_PER_TICK;
80001c7a:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001c7c:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80001c80:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80001c82:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001c86:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001c88:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001c8c:	ba1fe0ef          	jal	ra,8000082c <__mulsi3>
80001c90:	4bf48793          	addi	a5,s1,1215
80001c94:	413787b3          	sub	a5,a5,s3
80001c98:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001c9a:	4c048593          	addi	a1,s1,1216
80001c9e:	9552                	add	a0,a0,s4
80001ca0:	bb9fe0ef          	jal	ra,80000858 <__udivsi3>
80001ca4:	4c048593          	addi	a1,s1,1216
80001ca8:	b85fe0ef          	jal	ra,8000082c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001cac:	41498a33          	sub	s4,s3,s4
80001cb0:	9a2a                	add	s4,s4,a0
80001cb2:	3e700793          	li	a5,999
80001cb6:	0147c563          	blt	a5,s4,80001cc0 <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
80001cba:	4c048493          	addi	s1,s1,1216
80001cbe:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
80001cc0:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80001cc4:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
80001cc6:	577d                	li	a4,-1
80001cc8:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80001ccc:	00a9b533          	sltu	a0,s3,a0
80001cd0:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
80001cd2:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80001cd6:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001cda:	7b4a8513          	addi	a0,s5,1972
80001cde:	509010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80001ce2:	e915                	bnez	a0,80001d16 <z_clock_set_timeout+0x12a>
80001ce4:	80005437          	lui	s0,0x80005
80001ce8:	800055b7          	lui	a1,0x80005
80001cec:	80005537          	lui	a0,0x80005
80001cf0:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80001cf4:	06100693          	li	a3,97
80001cf8:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80001cfc:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80001d00:	397d                	jal	800019be <printk>
80001d02:	80005537          	lui	a0,0x80005
80001d06:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80001d0a:	3955                	jal	800019be <printk>
80001d0c:	06100593          	li	a1,97
80001d10:	12c40513          	addi	a0,s0,300
80001d14:	31e1                	jal	800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001d16:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80001d1a:	40f2                	lw	ra,28(sp)
80001d1c:	4462                	lw	s0,24(sp)
80001d1e:	44d2                	lw	s1,20(sp)
80001d20:	4942                	lw	s2,16(sp)
80001d22:	49b2                	lw	s3,12(sp)
80001d24:	4a22                	lw	s4,8(sp)
80001d26:	4a92                	lw	s5,4(sp)
80001d28:	4b02                	lw	s6,0(sp)
80001d2a:	6105                	addi	sp,sp,32
80001d2c:	8082                	ret
80001d2e:	ee0458e3          	bgez	s0,80001c1e <z_clock_set_timeout+0x32>
80001d32:	4401                	li	s0,0
80001d34:	b5ed                	j	80001c1e <z_clock_set_timeout+0x32>
80001d36:	8082                	ret

80001d38 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001d38:	1141                	addi	sp,sp,-16
80001d3a:	c422                	sw	s0,8(sp)
80001d3c:	c606                	sw	ra,12(sp)
80001d3e:	c226                	sw	s1,4(sp)
80001d40:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d42:	4421                	li	s0,8
80001d44:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001d48:	800054b7          	lui	s1,0x80005
80001d4c:	7b448513          	addi	a0,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80001d50:	8821                	andi	s0,s0,8
80001d52:	47b010ef          	jal	ra,800039cc <z_spin_lock_valid>
80001d56:	e915                	bnez	a0,80001d8a <z_clock_elapsed+0x52>
80001d58:	80005937          	lui	s2,0x80005
80001d5c:	800055b7          	lui	a1,0x80005
80001d60:	80005537          	lui	a0,0x80005
80001d64:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80001d68:	04e00693          	li	a3,78
80001d6c:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80001d70:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80001d74:	31a9                	jal	800019be <printk>
80001d76:	80005537          	lui	a0,0x80005
80001d7a:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80001d7e:	3181                	jal	800019be <printk>
80001d80:	04e00593          	li	a1,78
80001d84:	12c90513          	addi	a0,s2,300
80001d88:	3991                	jal	800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80001d8a:	7b448513          	addi	a0,s1,1972
80001d8e:	47b010ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80001d92:	3b09                	jal	80001aa4 <mtime>
80001d94:	800057b7          	lui	a5,0x80005
80001d98:	7907a783          	lw	a5,1936(a5) # 80005790 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005791>
80001d9c:	65f5                	lui	a1,0x1d
80001d9e:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001da2:	8d1d                	sub	a0,a0,a5
80001da4:	ab5fe0ef          	jal	ra,80000858 <__udivsi3>
80001da8:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001daa:	7b448513          	addi	a0,s1,1972
80001dae:	439010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80001db2:	e915                	bnez	a0,80001de6 <z_clock_elapsed+0xae>
80001db4:	800054b7          	lui	s1,0x80005
80001db8:	800055b7          	lui	a1,0x80005
80001dbc:	80005537          	lui	a0,0x80005
80001dc0:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80001dc4:	06100693          	li	a3,97
80001dc8:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80001dcc:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80001dd0:	36fd                	jal	800019be <printk>
80001dd2:	80005537          	lui	a0,0x80005
80001dd6:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80001dda:	36d5                	jal	800019be <printk>
80001ddc:	06100593          	li	a1,97
80001de0:	12c48513          	addi	a0,s1,300
80001de4:	3ee5                	jal	800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001de6:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80001dea:	40b2                	lw	ra,12(sp)
80001dec:	4422                	lw	s0,8(sp)
80001dee:	854a                	mv	a0,s2
80001df0:	4492                	lw	s1,4(sp)
80001df2:	4902                	lw	s2,0(sp)
80001df4:	0141                	addi	sp,sp,16
80001df6:	8082                	ret

80001df8 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80001df8:	00054783          	lbu	a5,0(a0)
80001dfc:	0005c703          	lbu	a4,0(a1)
80001e00:	00e79363          	bne	a5,a4,80001e06 <strcmp+0xe>
80001e04:	e781                	bnez	a5,80001e0c <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80001e06:	40e78533          	sub	a0,a5,a4
80001e0a:	8082                	ret
		s1++;
80001e0c:	0505                	addi	a0,a0,1
		s2++;
80001e0e:	0585                	addi	a1,a1,1
80001e10:	b7e5                	j	80001df8 <strcmp>

80001e12 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80001e12:	00b547b3          	xor	a5,a0,a1
80001e16:	8b8d                	andi	a5,a5,3
80001e18:	cf95                	beqz	a5,80001e54 <memcpy+0x42>
	unsigned char *d_byte = (unsigned char *)d;
80001e1a:	87aa                	mv	a5,a0
80001e1c:	4701                	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80001e1e:	04e61763          	bne	a2,a4,80001e6c <memcpy+0x5a>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80001e22:	8082                	ret
			if (n == 0) {
80001e24:	de7d                	beqz	a2,80001e22 <memcpy+0x10>
			*(d_byte++) = *(s_byte++);
80001e26:	0585                	addi	a1,a1,1
80001e28:	fff5c703          	lbu	a4,-1(a1)
80001e2c:	0785                	addi	a5,a5,1
			n--;
80001e2e:	167d                	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80001e30:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80001e34:	0037f713          	andi	a4,a5,3
80001e38:	f775                	bnez	a4,80001e24 <memcpy+0x12>
		while (n >= sizeof(unsigned int)) {
80001e3a:	468d                	li	a3,3
80001e3c:	40e60833          	sub	a6,a2,a4
80001e40:	0106ec63          	bltu	a3,a6,80001e58 <memcpy+0x46>
80001e44:	00265713          	srli	a4,a2,0x2
80001e48:	00271693          	slli	a3,a4,0x2
80001e4c:	8e15                	sub	a2,a2,a3
80001e4e:	97b6                	add	a5,a5,a3
80001e50:	95b6                	add	a1,a1,a3
80001e52:	b7e9                	j	80001e1c <memcpy+0xa>
	unsigned char *d_byte = (unsigned char *)d;
80001e54:	87aa                	mv	a5,a0
80001e56:	bff9                	j	80001e34 <memcpy+0x22>
			*(d_word++) = *(s_word++);
80001e58:	00e588b3          	add	a7,a1,a4
80001e5c:	0008a883          	lw	a7,0(a7)
80001e60:	00e78833          	add	a6,a5,a4
80001e64:	0711                	addi	a4,a4,4
80001e66:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80001e6a:	bfc9                	j	80001e3c <memcpy+0x2a>
		*(d_byte++) = *(s_byte++);
80001e6c:	00e58833          	add	a6,a1,a4
80001e70:	00084803          	lbu	a6,0(a6)
80001e74:	00e786b3          	add	a3,a5,a4
80001e78:	0705                	addi	a4,a4,1
80001e7a:	01068023          	sb	a6,0(a3)
		n--;
80001e7e:	b745                	j	80001e1e <memcpy+0xc>

80001e80 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80001e80:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80001e84:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80001e86:	0037f713          	andi	a4,a5,3
80001e8a:	eb1d                	bnez	a4,80001ec0 <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80001e8c:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80001e90:	00859713          	slli	a4,a1,0x8
80001e94:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
80001e96:	01059713          	slli	a4,a1,0x10
80001e9a:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
80001e9c:	00c78333          	add	t1,a5,a2
80001ea0:	873e                	mv	a4,a5
80001ea2:	480d                	li	a6,3
80001ea4:	40e308b3          	sub	a7,t1,a4
80001ea8:	03186263          	bltu	a6,a7,80001ecc <memset+0x4c>
80001eac:	00265713          	srli	a4,a2,0x2
80001eb0:	00271593          	slli	a1,a4,0x2
80001eb4:	97ae                	add	a5,a5,a1
80001eb6:	8e0d                	sub	a2,a2,a1
80001eb8:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80001eba:	00c79d63          	bne	a5,a2,80001ed4 <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80001ebe:	8082                	ret
		if (n == 0) {
80001ec0:	de7d                	beqz	a2,80001ebe <memset+0x3e>
		*(d_byte++) = c_byte;
80001ec2:	0785                	addi	a5,a5,1
80001ec4:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001ec8:	167d                	addi	a2,a2,-1
80001eca:	bf75                	j	80001e86 <memset+0x6>
		*(d_word++) = c_word;
80001ecc:	0711                	addi	a4,a4,4
80001ece:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80001ed2:	bfc9                	j	80001ea4 <memset+0x24>
		*(d_byte++) = c_byte;
80001ed4:	0785                	addi	a5,a5,1
80001ed6:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001eda:	b7c5                	j	80001eba <memset+0x3a>

80001edc <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80001edc:	557d                	li	a0,-1
80001ede:	8082                	ret

80001ee0 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80001ee0:	800057b7          	lui	a5,0x80005
80001ee4:	6ea7a023          	sw	a0,1760(a5) # 800056e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e1>
}
80001ee8:	8082                	ret

80001eea <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80001eea:	1101                	addi	sp,sp,-32
80001eec:	cc22                	sw	s0,24(sp)
	test->setup();
80001eee:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80001ef0:	80005437          	lui	s0,0x80005
{
80001ef4:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80001ef6:	6e440413          	addi	s0,s0,1764 # 800056e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e5>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80001efa:	800054b7          	lui	s1,0x80005
{
80001efe:	ce06                	sw	ra,28(sp)
80001f00:	c84a                	sw	s2,16(sp)
80001f02:	c64e                	sw	s3,12(sp)
	test_result = 1;
80001f04:	7b848493          	addi	s1,s1,1976 # 800057b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b9>
80001f08:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
80001f0a:	00042023          	sw	zero,0(s0)
{
80001f0e:	892a                	mv	s2,a0
	test_result = 1;
80001f10:	0134a023          	sw	s3,0(s1)
	test->setup();
80001f14:	9782                	jalr	a5
	test->test();
80001f16:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80001f1a:	01342023          	sw	s3,0(s0)
	test->test();
80001f1e:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80001f20:	4789                	li	a5,2
80001f22:	c01c                	sw	a5,0(s0)
	test->teardown();
80001f24:	00c92783          	lw	a5,12(s2)
80001f28:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80001f2a:	478d                	li	a5,3
80001f2c:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80001f2e:	4462                	lw	s0,24(sp)
	test_result = 0;
80001f30:	0004a023          	sw	zero,0(s1)
}
80001f34:	40f2                	lw	ra,28(sp)
80001f36:	44d2                	lw	s1,20(sp)
80001f38:	4942                	lw	s2,16(sp)
80001f3a:	49b2                	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80001f3c:	80006537          	lui	a0,0x80006
80001f40:	98c50513          	addi	a0,a0,-1652 # 8000598c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000598d>
80001f44:	6105                	addi	sp,sp,32
80001f46:	4940106f          	j	800033da <z_impl_k_sem_give>

80001f4a <ztest_test_fail>:
80001f4a:	80006537          	lui	a0,0x80006
{
80001f4e:	1141                	addi	sp,sp,-16
	test_result = -1;
80001f50:	800057b7          	lui	a5,0x80005
80001f54:	577d                	li	a4,-1
80001f56:	98c50513          	addi	a0,a0,-1652 # 8000598c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000598d>
{
80001f5a:	c606                	sw	ra,12(sp)
	test_result = -1;
80001f5c:	7ae7ac23          	sw	a4,1976(a5) # 800057b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b9>
80001f60:	47a010ef          	jal	ra,800033da <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001f64:	3cc010ef          	jal	ra,80003330 <z_impl_k_current_get>
}
80001f68:	40b2                	lw	ra,12(sp)
80001f6a:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001f6c:	4e50106f          	j	80003c50 <z_impl_k_thread_abort>

80001f70 <ztest_test_skip>:
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80001f70:	80006537          	lui	a0,0x80006
{
80001f74:	1141                	addi	sp,sp,-16
	test_result = -2;
80001f76:	800057b7          	lui	a5,0x80005
80001f7a:	5779                	li	a4,-2
80001f7c:	98c50513          	addi	a0,a0,-1652 # 8000598c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000598d>
{
80001f80:	c606                	sw	ra,12(sp)
	test_result = -2;
80001f82:	7ae7ac23          	sw	a4,1976(a5) # 800057b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b9>
80001f86:	454010ef          	jal	ra,800033da <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001f8a:	3a6010ef          	jal	ra,80003330 <z_impl_k_current_get>
}
80001f8e:	40b2                	lw	ra,12(sp)
80001f90:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001f92:	4bf0106f          	j	80003c50 <z_impl_k_thread_abort>

80001f96 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80001f96:	711d                	addi	sp,sp,-96
80001f98:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80001f9a:	800054b7          	lui	s1,0x80005
80001f9e:	7bc4a783          	lw	a5,1980(s1) # 800057bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057bd>
{
80001fa2:	ce86                	sw	ra,92(sp)
80001fa4:	cca2                	sw	s0,88(sp)
80001fa6:	c8ca                	sw	s2,80(sp)
80001fa8:	c6ce                	sw	s3,76(sp)
80001faa:	c4d2                	sw	s4,72(sp)
80001fac:	c2d6                	sw	s5,68(sp)
80001fae:	c0da                	sw	s6,64(sp)
80001fb0:	de5e                	sw	s7,60(sp)
80001fb2:	dc62                	sw	s8,56(sp)
80001fb4:	da66                	sw	s9,52(sp)
80001fb6:	d86a                	sw	s10,48(sp)
80001fb8:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
80001fba:	0607c963          	bltz	a5,8000202c <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001fbe:	80006437          	lui	s0,0x80006
80001fc2:	4605                	li	a2,1
80001fc4:	89aa                	mv	s3,a0
80001fc6:	8c2e                	mv	s8,a1
80001fc8:	98c40513          	addi	a0,s0,-1652 # 8000598c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000598d>
80001fcc:	4581                	li	a1,0
80001fce:	36c010ef          	jal	ra,8000333a <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80001fd2:	80005537          	lui	a0,0x80005
80001fd6:	85ce                	mv	a1,s3
80001fd8:	1e850513          	addi	a0,a0,488 # 800051e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e9>
80001fdc:	9e3ff0ef          	jal	ra,800019be <printk>
	PRINT_LINE;
80001fe0:	80005937          	lui	s2,0x80005
80001fe4:	20090513          	addi	a0,s2,512 # 80005200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005201>
		Z_TC_END_RESULT(ret, test->name);
80001fe8:	80005ab7          	lui	s5,0x80005
	PRINT_LINE;
80001fec:	9d3ff0ef          	jal	ra,800019be <printk>
80001ff0:	7bc48493          	addi	s1,s1,1980
	int fail = 0;
80001ff4:	4a01                	li	s4,0
80001ff6:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001ff8:	80006cb7          	lui	s9,0x80006
80001ffc:	80006b37          	lui	s6,0x80006
80002000:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80002004:	80005db7          	lui	s11,0x80005
80002008:	80005bb7          	lui	s7,0x80005
		Z_TC_END_RESULT(ret, test->name);
8000200c:	1a0a8a93          	addi	s5,s5,416 # 800051a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a1>
	while (suite->test) {
80002010:	004c2783          	lw	a5,4(s8)
80002014:	eb9d                	bnez	a5,8000204a <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002016:	85ce                	mv	a1,s3
	if (fail) {
80002018:	0c0a0363          	beqz	s4,800020de <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
8000201c:	80005537          	lui	a0,0x80005
80002020:	27050513          	addi	a0,a0,624 # 80005270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005271>
80002024:	99bff0ef          	jal	ra,800019be <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002028:	4785                	li	a5,1
8000202a:	c09c                	sw	a5,0(s1)
}
8000202c:	40f6                	lw	ra,92(sp)
8000202e:	4466                	lw	s0,88(sp)
80002030:	44d6                	lw	s1,84(sp)
80002032:	4946                	lw	s2,80(sp)
80002034:	49b6                	lw	s3,76(sp)
80002036:	4a26                	lw	s4,72(sp)
80002038:	4a96                	lw	s5,68(sp)
8000203a:	4b06                	lw	s6,64(sp)
8000203c:	5bf2                	lw	s7,60(sp)
8000203e:	5c62                	lw	s8,56(sp)
80002040:	5cd2                	lw	s9,52(sp)
80002042:	5d42                	lw	s10,48(sp)
80002044:	5db2                	lw	s11,44(sp)
80002046:	6125                	addi	sp,sp,96
80002048:	8082                	ret
	TC_START(test->name);
8000204a:	000c2583          	lw	a1,0(s8)
8000204e:	800057b7          	lui	a5,0x80005
80002052:	24878513          	addi	a0,a5,584 # 80005248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005249>
80002056:	969ff0ef          	jal	ra,800019be <printk>
8000205a:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
8000205c:	010c2783          	lw	a5,16(s8)
80002060:	8762                	mv	a4,s8
80002062:	40000613          	li	a2,1024
80002066:	0087e793          	ori	a5,a5,8
8000206a:	58fd                	li	a7,-1
8000206c:	4801                	li	a6,0
8000206e:	eead0693          	addi	a3,s10,-278 # 80001eea <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001eeb>
80002072:	c03e                	sw	a5,0(sp)
80002074:	d20c8593          	addi	a1,s9,-736 # 80005d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d21>
80002078:	4781                	li	a5,0
8000207a:	99cb0513          	addi	a0,s6,-1636 # 8000599c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000599d>
8000207e:	2bb010ef          	jal	ra,80003b38 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002082:	47f2                	lw	a5,28(sp)
80002084:	55fd                	li	a1,-1
80002086:	98c78513          	addi	a0,a5,-1652
8000208a:	3fa010ef          	jal	ra,80003484 <z_impl_k_sem_take>
	if (test_result == -1) {
8000208e:	7b8d8793          	addi	a5,s11,1976 # 800057b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b9>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002092:	99cb0513          	addi	a0,s6,-1636
80002096:	4380                	lw	s0,0(a5)
80002098:	3b9010ef          	jal	ra,80003c50 <z_impl_k_thread_abort>
	if (test_result == -2) {
8000209c:	800057b7          	lui	a5,0x80005
800020a0:	7b878793          	addi	a5,a5,1976 # 800057b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b9>
800020a4:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
800020a6:	0405                	addi	s0,s0,1
	if (test_result == -2) {
800020a8:	57f9                	li	a5,-2
	if (test_result == -1) {
800020aa:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800020ae:	000c2603          	lw	a2,0(s8)
800020b2:	02f71163          	bne	a4,a5,800020d4 <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800020b6:	800055b7          	lui	a1,0x80005
800020ba:	25c58593          	addi	a1,a1,604 # 8000525c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000525d>
		Z_TC_END_RESULT(ret, test->name);
800020be:	264b8513          	addi	a0,s7,612 # 80005264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005265>
800020c2:	8fdff0ef          	jal	ra,800019be <printk>
800020c6:	20090513          	addi	a0,s2,512
800020ca:	8f5ff0ef          	jal	ra,800019be <printk>
		fail += run_test(suite);
800020ce:	9a22                	add	s4,s4,s0
		suite++;
800020d0:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
800020d2:	bf3d                	j	80002010 <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
800020d4:	00241793          	slli	a5,s0,0x2
800020d8:	97d6                	add	a5,a5,s5
800020da:	438c                	lw	a1,0(a5)
800020dc:	b7cd                	j	800020be <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
800020de:	80005537          	lui	a0,0x80005
800020e2:	28850513          	addi	a0,a0,648 # 80005288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005289>
800020e6:	8d9ff0ef          	jal	ra,800019be <printk>
	test_status = (test_status || fail) ? 1 : 0;
800020ea:	409c                	lw	a5,0(s1)
800020ec:	00f037b3          	snez	a5,a5
800020f0:	bf2d                	j	8000202a <z_ztest_run_test_suite+0x94>

800020f2 <end_report>:

void end_report(void)
{
	if (test_status) {
800020f2:	800057b7          	lui	a5,0x80005
800020f6:	7bc7a783          	lw	a5,1980(a5) # 800057bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057bd>
{
800020fa:	1141                	addi	sp,sp,-16
800020fc:	c422                	sw	s0,8(sp)
800020fe:	80005537          	lui	a0,0x80005
80002102:	c606                	sw	ra,12(sp)
80002104:	80005437          	lui	s0,0x80005
		TC_END_REPORT(TC_FAIL);
80002108:	20050513          	addi	a0,a0,512 # 80005200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005201>
	if (test_status) {
8000210c:	cf91                	beqz	a5,80002128 <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
8000210e:	8b1ff0ef          	jal	ra,800019be <printk>
80002112:	800055b7          	lui	a1,0x80005
80002116:	1ac58593          	addi	a1,a1,428 # 800051ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051ad>
	} else {
		TC_END_REPORT(TC_PASS);
8000211a:	1b440513          	addi	a0,s0,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
	}
}
8000211e:	4422                	lw	s0,8(sp)
80002120:	40b2                	lw	ra,12(sp)
80002122:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002124:	89bff06f          	j	800019be <printk>
80002128:	897ff0ef          	jal	ra,800019be <printk>
8000212c:	800055b7          	lui	a1,0x80005
80002130:	1cc58593          	addi	a1,a1,460 # 800051cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051cd>
80002134:	b7dd                	j	8000211a <end_report+0x28>

80002136 <main>:

	return test_status;
}
#else
void main(void)
{
80002136:	1141                	addi	sp,sp,-16
80002138:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
8000213a:	feefe0ef          	jal	ra,80000928 <test_main>
	end_report();
}
8000213e:	40b2                	lw	ra,12(sp)
80002140:	0141                	addi	sp,sp,16
	end_report();
80002142:	bf45                	j	800020f2 <end_report>

80002144 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002144:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002146:	c602                	sw	zero,12(sp)
    i++;
80002148:	47b2                	lw	a5,12(sp)
8000214a:	0785                	addi	a5,a5,1
8000214c:	c63e                	sw	a5,12(sp)
    uart[0] = c;
8000214e:	f00107b7          	lui	a5,0xf0010
80002152:	c38c                	sw	a1,0(a5)
}
80002154:	0141                	addi	sp,sp,16
80002156:	8082                	ret

80002158 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002158:	557d                	li	a0,-1
8000215a:	8082                	ret

8000215c <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
8000215c:	4501                	li	a0,0
8000215e:	8082                	ret

80002160 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002160:	00251713          	slli	a4,a0,0x2
80002164:	800057b7          	lui	a5,0x80005
80002168:	0505                	addi	a0,a0,1
8000216a:	2b878793          	addi	a5,a5,696 # 800052b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b9>
8000216e:	050a                	slli	a0,a0,0x2
{
80002170:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002172:	973e                	add	a4,a4,a5
80002174:	97aa                	add	a5,a5,a0
{
80002176:	c422                	sw	s0,8(sp)
80002178:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
8000217a:	4300                	lw	s0,0(a4)
8000217c:	4384                	lw	s1,0(a5)
{
8000217e:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002180:	00946763          	bltu	s0,s1,8000218e <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002184:	40b2                	lw	ra,12(sp)
80002186:	4422                	lw	s0,8(sp)
80002188:	4492                	lw	s1,4(sp)
8000218a:	0141                	addi	sp,sp,16
8000218c:	8082                	ret
		retval = device_conf->init(info);
8000218e:	401c                	lw	a5,0(s0)
80002190:	8522                	mv	a0,s0
80002192:	43dc                	lw	a5,4(a5)
80002194:	9782                	jalr	a5
		if (retval != 0) {
80002196:	c119                	beqz	a0,8000219c <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
80002198:	00042223          	sw	zero,4(s0)
								info++) {
8000219c:	0431                	addi	s0,s0,12
8000219e:	b7cd                	j	80002180 <z_sys_device_do_config_level+0x20>

800021a0 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800021a0:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800021a2:	800057b7          	lui	a5,0x80005
{
800021a6:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800021a8:	800054b7          	lui	s1,0x80005
{
800021ac:	c422                	sw	s0,8(sp)
800021ae:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800021b0:	6f878413          	addi	s0,a5,1784 # 800056f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f9>
{
800021b4:	c04a                	sw	s2,0(sp)
800021b6:	6f878793          	addi	a5,a5,1784
800021ba:	72848493          	addi	s1,s1,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
	for (info = __device_init_start; info != __device_init_end; info++) {
800021be:	00941863          	bne	s0,s1,800021ce <z_impl_device_get_binding+0x2e>
800021c2:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
800021c4:	843e                	mv	s0,a5
800021c6:	00941c63          	bne	s0,s1,800021de <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
800021ca:	4401                	li	s0,0
800021cc:	a015                	j	800021f0 <z_impl_device_get_binding+0x50>
		if ((info->driver_api != NULL) &&
800021ce:	4058                	lw	a4,4(s0)
800021d0:	c709                	beqz	a4,800021da <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
800021d2:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
800021d4:	4318                	lw	a4,0(a4)
800021d6:	00a70d63          	beq	a4,a0,800021f0 <z_impl_device_get_binding+0x50>
	for (info = __device_init_start; info != __device_init_end; info++) {
800021da:	0431                	addi	s0,s0,12
800021dc:	b7cd                	j	800021be <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
800021de:	405c                	lw	a5,4(s0)
800021e0:	e399                	bnez	a5,800021e6 <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
800021e2:	0431                	addi	s0,s0,12
800021e4:	b7cd                	j	800021c6 <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
800021e6:	401c                	lw	a5,0(s0)
800021e8:	854a                	mv	a0,s2
800021ea:	438c                	lw	a1,0(a5)
800021ec:	3131                	jal	80001df8 <strcmp>
800021ee:	f975                	bnez	a0,800021e2 <z_impl_device_get_binding+0x42>
}
800021f0:	8522                	mv	a0,s0
800021f2:	40b2                	lw	ra,12(sp)
800021f4:	4422                	lw	s0,8(sp)
800021f6:	4492                	lw	s1,4(sp)
800021f8:	4902                	lw	s2,0(sp)
800021fa:	0141                	addi	sp,sp,16
800021fc:	8082                	ret

800021fe <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
800021fe:	1141                	addi	sp,sp,-16
80002200:	c422                	sw	s0,8(sp)
80002202:	c226                	sw	s1,4(sp)
80002204:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002206:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002208:	4489                	li	s1,2
8000220a:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
8000220e:	625010ef          	jal	ra,80004032 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002212:	00a4c363          	blt	s1,a0,80002218 <idle+0x1a>
80002216:	4505                	li	a0,1
80002218:	4585                	li	a1,1
8000221a:	6d3010ef          	jal	ra,800040ec <z_set_timeout_expiry>
	k_cpu_idle();
8000221e:	fe6ff0ef          	jal	ra,80001a04 <k_cpu_idle>
80002222:	b7e5                	j	8000220a <idle+0xc>

80002224 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002224:	80005537          	lui	a0,0x80005
80002228:	800067b7          	lui	a5,0x80006
8000222c:	79050613          	addi	a2,a0,1936 # 80005790 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005791>
80002230:	b1878793          	addi	a5,a5,-1256 # 80005b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b19>
80002234:	40c78633          	sub	a2,a5,a2
80002238:	4581                	li	a1,0
8000223a:	79050513          	addi	a0,a0,1936
8000223e:	b189                	j	80001e80 <memset>

80002240 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002240:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002242:	4509                	li	a0,2
{
80002244:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002246:	3f29                	jal	80002160 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002248:	80005537          	lui	a0,0x80005
8000224c:	2cc50513          	addi	a0,a0,716 # 800052cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052cd>
80002250:	f6eff0ef          	jal	ra,800019be <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002254:	450d                	li	a0,3
80002256:	3729                	jal	80002160 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002258:	181010ef          	jal	ra,80003bd8 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
8000225c:	3de9                	jal	80002136 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
8000225e:	800067b7          	lui	a5,0x80006
80002262:	a7c78793          	addi	a5,a5,-1412 # 80005a7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a7d>
80002266:	00c7c703          	lbu	a4,12(a5)
8000226a:	9b79                	andi	a4,a4,-2
8000226c:	00e78623          	sb	a4,12(a5)
}
80002270:	40b2                	lw	ra,12(sp)
80002272:	0141                	addi	sp,sp,16
80002274:	8082                	ret

80002276 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002276:	7135                	addi	sp,sp,-160
80002278:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
8000227a:	800077b7          	lui	a5,0x80007
8000227e:	80006437          	lui	s0,0x80006
80002282:	c74e                	sw	s3,140(sp)
80002284:	d2078793          	addi	a5,a5,-736 # 80006d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d21>
80002288:	aec40993          	addi	s3,s0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
8000228c:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80002290:	081c                	addi	a5,sp,16
80002292:	07000613          	li	a2,112
80002296:	4581                	li	a1,0
80002298:	853e                	mv	a0,a5
{
8000229a:	cf06                	sw	ra,156(sp)
8000229c:	cb26                	sw	s1,148(sp)
8000229e:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800022a0:	be1ff0ef          	jal	ra,80001e80 <memset>
800022a4:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800022a6:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800022aa:	4501                	li	a0,0
	struct k_thread dummy_thread = {
800022ac:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800022b0:	3d45                	jal	80002160 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
800022b2:	4505                	li	a0,1
800022b4:	3575                	jal	80002160 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
800022b6:	10100793          	li	a5,257
800022ba:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800022be:	05a010ef          	jal	ra,80003318 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800022c2:	800057b7          	lui	a5,0x80005
800022c6:	31078793          	addi	a5,a5,784 # 80005310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005311>
	_kernel.ready_q.cache = _main_thread;
800022ca:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
800022ce:	c23e                	sw	a5,4(sp)
800022d0:	800026b7          	lui	a3,0x80002
800022d4:	4785                	li	a5,1
800022d6:	800065b7          	lui	a1,0x80006
	_kernel.ready_q.cache = _main_thread;
800022da:	a7c90493          	addi	s1,s2,-1412 # 80005a7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a7d>
	z_setup_new_thread(_main_thread, _main_stack,
800022de:	c03e                	sw	a5,0(sp)
800022e0:	4701                	li	a4,0
800022e2:	4781                	li	a5,0
800022e4:	4881                	li	a7,0
800022e6:	4801                	li	a6,0
800022e8:	24068693          	addi	a3,a3,576 # 80002240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002241>
800022ec:	20000613          	li	a2,512
800022f0:	12058593          	addi	a1,a1,288 # 80006120 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006121>
800022f4:	a7c90513          	addi	a0,s2,-1412
	_kernel.ready_q.cache = _main_thread;
800022f8:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
800022fc:	648010ef          	jal	ra,80003944 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002300:	00d4c783          	lbu	a5,13(s1)
80002304:	aec40413          	addi	s0,s0,-1300
80002308:	ffb7f713          	andi	a4,a5,-5
8000230c:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002310:	8bed                	andi	a5,a5,27
80002312:	e799                	bnez	a5,80002320 <z_cstart+0xaa>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002314:	4c9c                	lw	a5,24(s1)
80002316:	e789                	bnez	a5,80002320 <z_cstart+0xaa>
		z_add_thread_to_ready_q(thread);
80002318:	a7c90513          	addi	a0,s2,-1412
8000231c:	7de000ef          	jal	ra,80002afa <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002320:	800057b7          	lui	a5,0x80005
80002324:	31878793          	addi	a5,a5,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002328:	c23e                	sw	a5,4(sp)
8000232a:	80006537          	lui	a0,0x80006
8000232e:	4785                	li	a5,1
80002330:	800026b7          	lui	a3,0x80002
80002334:	800065b7          	lui	a1,0x80006
80002338:	a0c50493          	addi	s1,a0,-1524 # 80005a0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a0d>
8000233c:	c03e                	sw	a5,0(sp)
8000233e:	48bd                	li	a7,15
80002340:	4801                	li	a6,0
80002342:	4781                	li	a5,0
80002344:	4701                	li	a4,0
80002346:	1fe68693          	addi	a3,a3,510 # 800021fe <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800021ff>
8000234a:	20000613          	li	a2,512
8000234e:	32058593          	addi	a1,a1,800 # 80006320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006321>
80002352:	a0c50513          	addi	a0,a0,-1524
80002356:	5ee010ef          	jal	ra,80003944 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
8000235a:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
8000235e:	c444                	sw	s1,12(s0)
80002360:	4521                	li	a0,8
80002362:	9bed                	andi	a5,a5,-5
80002364:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002368:	800067b7          	lui	a5,0x80006
8000236c:	b0478793          	addi	a5,a5,-1276 # 80005b04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b05>
80002370:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002372:	cc5c                	sw	a5,28(s0)
80002374:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002378:	8921                	andi	a0,a0,8
8000237a:	e57fd0ef          	jal	ra,800001d0 <__swap>

8000237e <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000237e:	00d54783          	lbu	a5,13(a0)
80002382:	8bfd                	andi	a5,a5,31
80002384:	e789                	bnez	a5,8000238e <z_is_thread_ready+0x10>
80002386:	4d08                	lw	a0,24(a0)
80002388:	00153513          	seqz	a0,a0
8000238c:	8082                	ret
8000238e:	4501                	li	a0,0
}
80002390:	8082                	ret

80002392 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002392:	1141                	addi	sp,sp,-16
80002394:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002396:	9a3ff0ef          	jal	ra,80001d38 <z_clock_elapsed>
8000239a:	800057b7          	lui	a5,0x80005
8000239e:	7c87a783          	lw	a5,1992(a5) # 800057c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c9>

	z_set_timeout_expiry(slice_time, false);
}
800023a2:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800023a4:	80006737          	lui	a4,0x80006
800023a8:	953e                	add	a0,a0,a5
800023aa:	aea72e23          	sw	a0,-1284(a4) # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
	z_set_timeout_expiry(slice_time, false);
800023ae:	4581                	li	a1,0
800023b0:	853e                	mv	a0,a5
}
800023b2:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
800023b4:	5390106f          	j	800040ec <z_set_timeout_expiry>

800023b8 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
800023b8:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
800023ba:	1141                	addi	sp,sp,-16
800023bc:	c422                	sw	s0,8(sp)
800023be:	c606                	sw	ra,12(sp)
800023c0:	c226                	sw	s1,4(sp)
800023c2:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
800023c4:	e79d                	bnez	a5,800023f2 <pended_on.isra.15+0x3a>
800023c6:	800054b7          	lui	s1,0x80005
800023ca:	800055b7          	lui	a1,0x80005
800023ce:	80005537          	lui	a0,0x80005
800023d2:	3b858593          	addi	a1,a1,952 # 800053b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053b9>
800023d6:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800023da:	18300693          	li	a3,387
800023de:	3a448613          	addi	a2,s1,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
800023e2:	ddcff0ef          	jal	ra,800019be <printk>
800023e6:	18300593          	li	a1,387
800023ea:	3a448513          	addi	a0,s1,932
800023ee:	deeff0ef          	jal	ra,800019dc <assert_post_action>

	return thread->base.pended_on;
}
800023f2:	4008                	lw	a0,0(s0)
800023f4:	40b2                	lw	ra,12(sp)
800023f6:	4422                	lw	s0,8(sp)
800023f8:	4492                	lw	s1,4(sp)
800023fa:	0141                	addi	sp,sp,16
800023fc:	8082                	ret

800023fe <k_sched_time_slice_set>:
{
800023fe:	1101                	addi	sp,sp,-32
80002400:	cc22                	sw	s0,24(sp)
80002402:	c64e                	sw	s3,12(sp)
80002404:	c452                	sw	s4,8(sp)
80002406:	ce06                	sw	ra,28(sp)
80002408:	ca26                	sw	s1,20(sp)
8000240a:	c84a                	sw	s2,16(sp)
8000240c:	8a2a                	mv	s4,a0
8000240e:	89ae                	mv	s3,a1
80002410:	4421                	li	s0,8
80002412:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002416:	800054b7          	lui	s1,0x80005
8000241a:	7c048513          	addi	a0,s1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000241e:	8821                	andi	s0,s0,8
80002420:	5ac010ef          	jal	ra,800039cc <z_spin_lock_valid>
80002424:	ed0d                	bnez	a0,8000245e <k_sched_time_slice_set+0x60>
80002426:	80005937          	lui	s2,0x80005
8000242a:	800055b7          	lui	a1,0x80005
8000242e:	80005537          	lui	a0,0x80005
80002432:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002436:	04e00693          	li	a3,78
8000243a:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000243e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002442:	d7cff0ef          	jal	ra,800019be <printk>
80002446:	80005537          	lui	a0,0x80005
8000244a:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
8000244e:	d70ff0ef          	jal	ra,800019be <printk>
80002452:	04e00593          	li	a1,78
80002456:	12c90513          	addi	a0,s2,300
8000245a:	d82ff0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
8000245e:	7c048513          	addi	a0,s1,1984
80002462:	5a6010ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002466:	800067b7          	lui	a5,0x80006
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
8000246a:	45a9                	li	a1,10
8000246c:	009a0513          	addi	a0,s4,9
80002470:	ae07ae23          	sw	zero,-1284(a5) # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
80002474:	bdcfe0ef          	jal	ra,80000850 <__divsi3>
		slice_max_prio = prio;
80002478:	800057b7          	lui	a5,0x80005
		slice_time = z_ms_to_ticks(slice);
8000247c:	80005937          	lui	s2,0x80005
80002480:	7ca92423          	sw	a0,1992(s2) # 800057c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c9>
		slice_max_prio = prio;
80002484:	7d37a223          	sw	s3,1988(a5) # 800057c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c5>
		reset_time_slice();
80002488:	3729                	jal	80002392 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000248a:	7c048513          	addi	a0,s1,1984
8000248e:	558010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002492:	ed0d                	bnez	a0,800024cc <k_sched_time_slice_set+0xce>
80002494:	800054b7          	lui	s1,0x80005
80002498:	800055b7          	lui	a1,0x80005
8000249c:	80005537          	lui	a0,0x80005
800024a0:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800024a4:	06100693          	li	a3,97
800024a8:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800024ac:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800024b0:	d0eff0ef          	jal	ra,800019be <printk>
800024b4:	80005537          	lui	a0,0x80005
800024b8:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800024bc:	d02ff0ef          	jal	ra,800019be <printk>
800024c0:	06100593          	li	a1,97
800024c4:	12c48513          	addi	a0,s1,300
800024c8:	d14ff0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800024cc:	30042473          	csrrs	s0,mstatus,s0
}
800024d0:	40f2                	lw	ra,28(sp)
800024d2:	4462                	lw	s0,24(sp)
800024d4:	44d2                	lw	s1,20(sp)
800024d6:	4942                	lw	s2,16(sp)
800024d8:	49b2                	lw	s3,12(sp)
800024da:	4a22                	lw	s4,8(sp)
800024dc:	6105                	addi	sp,sp,32
800024de:	8082                	ret

800024e0 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
800024e0:	1101                	addi	sp,sp,-32
800024e2:	cc22                	sw	s0,24(sp)
800024e4:	c84a                	sw	s2,16(sp)
800024e6:	ce06                	sw	ra,28(sp)
800024e8:	ca26                	sw	s1,20(sp)
800024ea:	c64e                	sw	s3,12(sp)
800024ec:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800024ee:	4421                	li	s0,8
800024f0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800024f4:	800054b7          	lui	s1,0x80005
800024f8:	7c048513          	addi	a0,s1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
800024fc:	8821                	andi	s0,s0,8
800024fe:	4ce010ef          	jal	ra,800039cc <z_spin_lock_valid>
80002502:	ed0d                	bnez	a0,8000253c <z_unpend_thread_no_timeout+0x5c>
80002504:	800059b7          	lui	s3,0x80005
80002508:	800055b7          	lui	a1,0x80005
8000250c:	80005537          	lui	a0,0x80005
80002510:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002514:	04e00693          	li	a3,78
80002518:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000251c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002520:	c9eff0ef          	jal	ra,800019be <printk>
80002524:	80005537          	lui	a0,0x80005
80002528:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
8000252c:	c92ff0ef          	jal	ra,800019be <printk>
80002530:	04e00593          	li	a1,78
80002534:	12c98513          	addi	a0,s3,300
80002538:	ca4ff0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
8000253c:	7c048513          	addi	a0,s1,1984
80002540:	4c8010ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002544:	00890513          	addi	a0,s2,8
80002548:	3d85                	jal	800023b8 <pended_on.isra.15>
8000254a:	85ca                	mv	a1,s2
8000254c:	2451                	jal	800027d0 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000254e:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002552:	7c048513          	addi	a0,s1,1984
80002556:	9bf5                	andi	a5,a5,-3
80002558:	00f906a3          	sb	a5,13(s2)
8000255c:	48a010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002560:	ed0d                	bnez	a0,8000259a <z_unpend_thread_no_timeout+0xba>
80002562:	800054b7          	lui	s1,0x80005
80002566:	800055b7          	lui	a1,0x80005
8000256a:	80005537          	lui	a0,0x80005
8000256e:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002572:	06100693          	li	a3,97
80002576:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000257a:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000257e:	c40ff0ef          	jal	ra,800019be <printk>
80002582:	80005537          	lui	a0,0x80005
80002586:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
8000258a:	c34ff0ef          	jal	ra,800019be <printk>
8000258e:	06100593          	li	a1,97
80002592:	12c48513          	addi	a0,s1,300
80002596:	c46ff0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000259a:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
8000259e:	40f2                	lw	ra,28(sp)
800025a0:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
800025a2:	00092423          	sw	zero,8(s2)
}
800025a6:	44d2                	lw	s1,20(sp)
800025a8:	4942                	lw	s2,16(sp)
800025aa:	49b2                	lw	s3,12(sp)
800025ac:	6105                	addi	sp,sp,32
800025ae:	8082                	ret

800025b0 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
800025b0:	800067b7          	lui	a5,0x80006
800025b4:	aec7a783          	lw	a5,-1300(a5) # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
{
800025b8:	1141                	addi	sp,sp,-16
800025ba:	c422                	sw	s0,8(sp)
800025bc:	c606                	sw	ra,12(sp)
800025be:	c226                	sw	s1,4(sp)
800025c0:	842e                	mv	s0,a1
	if (resched()) {
800025c2:	e7b9                	bnez	a5,80002610 <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800025c4:	422010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
800025c8:	ed0d                	bnez	a0,80002602 <z_reschedule+0x52>
800025ca:	800054b7          	lui	s1,0x80005
800025ce:	800055b7          	lui	a1,0x80005
800025d2:	80005537          	lui	a0,0x80005
800025d6:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800025da:	07800693          	li	a3,120
800025de:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800025e2:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800025e6:	bd8ff0ef          	jal	ra,800019be <printk>
800025ea:	80005537          	lui	a0,0x80005
800025ee:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800025f2:	bccff0ef          	jal	ra,800019be <printk>
800025f6:	07800593          	li	a1,120
800025fa:	12c48513          	addi	a0,s1,300
800025fe:	bdeff0ef          	jal	ra,800019dc <assert_post_action>
80002602:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80002604:	4422                	lw	s0,8(sp)
80002606:	40b2                	lw	ra,12(sp)
80002608:	4492                	lw	s1,4(sp)
8000260a:	0141                	addi	sp,sp,16
8000260c:	bc5fd06f          	j	800001d0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002610:	3d6010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002614:	ed0d                	bnez	a0,8000264e <z_reschedule+0x9e>
80002616:	800054b7          	lui	s1,0x80005
8000261a:	800055b7          	lui	a1,0x80005
8000261e:	80005537          	lui	a0,0x80005
80002622:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002626:	06100693          	li	a3,97
8000262a:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000262e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002632:	b8cff0ef          	jal	ra,800019be <printk>
80002636:	80005537          	lui	a0,0x80005
8000263a:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
8000263e:	b80ff0ef          	jal	ra,800019be <printk>
80002642:	06100593          	li	a1,97
80002646:	12c48513          	addi	a0,s1,300
8000264a:	b92ff0ef          	jal	ra,800019dc <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
8000264e:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002650:	30042473          	csrrs	s0,mstatus,s0
80002654:	40b2                	lw	ra,12(sp)
80002656:	4422                	lw	s0,8(sp)
80002658:	4492                	lw	s1,4(sp)
8000265a:	0141                	addi	sp,sp,16
8000265c:	8082                	ret

8000265e <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
8000265e:	80006737          	lui	a4,0x80006
80002662:	aec72703          	lw	a4,-1300(a4) # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80002666:	e319                	bnez	a4,8000266c <z_reschedule_irqlock+0xe>
80002668:	b69fd06f          	j	800001d0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
8000266c:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002670:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002674:	8082                	ret

80002676 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002676:	4521                	li	a0,8
80002678:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
8000267c:	8921                	andi	a0,a0,8
8000267e:	b7c5                	j	8000265e <z_reschedule_irqlock>

80002680 <k_sched_lock>:

void k_sched_lock(void)
{
80002680:	1101                	addi	sp,sp,-32
80002682:	cc22                	sw	s0,24(sp)
80002684:	ce06                	sw	ra,28(sp)
80002686:	ca26                	sw	s1,20(sp)
80002688:	c84a                	sw	s2,16(sp)
8000268a:	c64e                	sw	s3,12(sp)
8000268c:	4421                	li	s0,8
8000268e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002692:	800054b7          	lui	s1,0x80005
80002696:	7c048513          	addi	a0,s1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000269a:	8821                	andi	s0,s0,8
8000269c:	330010ef          	jal	ra,800039cc <z_spin_lock_valid>
800026a0:	ed0d                	bnez	a0,800026da <k_sched_lock+0x5a>
800026a2:	80005937          	lui	s2,0x80005
800026a6:	800055b7          	lui	a1,0x80005
800026aa:	80005537          	lui	a0,0x80005
800026ae:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
800026b2:	04e00693          	li	a3,78
800026b6:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800026ba:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800026be:	b00ff0ef          	jal	ra,800019be <printk>
800026c2:	80005537          	lui	a0,0x80005
800026c6:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
800026ca:	af4ff0ef          	jal	ra,800019be <printk>
800026ce:	04e00593          	li	a1,78
800026d2:	12c90513          	addi	a0,s2,300
800026d6:	b06ff0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
800026da:	7c048513          	addi	a0,s1,1984
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
800026de:	80006937          	lui	s2,0x80006
800026e2:	326010ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
800026e6:	aec92783          	lw	a5,-1300(s2) # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
800026ea:	aec90913          	addi	s2,s2,-1300
800026ee:	cf8d                	beqz	a5,80002728 <k_sched_lock+0xa8>
800026f0:	800059b7          	lui	s3,0x80005
800026f4:	800055b7          	lui	a1,0x80005
800026f8:	80005537          	lui	a0,0x80005
800026fc:	33c58593          	addi	a1,a1,828 # 8000533c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000533d>
80002700:	10000693          	li	a3,256
80002704:	32098613          	addi	a2,s3,800 # 80005320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005321>
80002708:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000270c:	ab2ff0ef          	jal	ra,800019be <printk>
80002710:	80005537          	lui	a0,0x80005
80002714:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
80002718:	aa6ff0ef          	jal	ra,800019be <printk>
8000271c:	10000593          	li	a1,256
80002720:	32098513          	addi	a0,s3,800
80002724:	ab8ff0ef          	jal	ra,800019dc <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80002728:	00892783          	lw	a5,8(s2)
8000272c:	00f7c703          	lbu	a4,15(a5)
80002730:	4785                	li	a5,1
80002732:	02f71e63          	bne	a4,a5,8000276e <k_sched_lock+0xee>
80002736:	800059b7          	lui	s3,0x80005
8000273a:	800055b7          	lui	a1,0x80005
8000273e:	80005537          	lui	a0,0x80005
80002742:	35458593          	addi	a1,a1,852 # 80005354 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005355>
80002746:	10100693          	li	a3,257
8000274a:	32098613          	addi	a2,s3,800 # 80005320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005321>
8000274e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002752:	a6cff0ef          	jal	ra,800019be <printk>
80002756:	80005537          	lui	a0,0x80005
8000275a:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
8000275e:	a60ff0ef          	jal	ra,800019be <printk>
80002762:	10100593          	li	a1,257
80002766:	32098513          	addi	a0,s3,800
8000276a:	a72ff0ef          	jal	ra,800019dc <assert_post_action>

	--_current->base.sched_locked;
8000276e:	00892703          	lw	a4,8(s2)
80002772:	00f74783          	lbu	a5,15(a4)
80002776:	17fd                	addi	a5,a5,-1
80002778:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000277c:	7c048513          	addi	a0,s1,1984
80002780:	266010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002784:	ed0d                	bnez	a0,800027be <k_sched_lock+0x13e>
80002786:	800054b7          	lui	s1,0x80005
8000278a:	800055b7          	lui	a1,0x80005
8000278e:	80005537          	lui	a0,0x80005
80002792:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002796:	06100693          	li	a3,97
8000279a:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000279e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800027a2:	a1cff0ef          	jal	ra,800019be <printk>
800027a6:	80005537          	lui	a0,0x80005
800027aa:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800027ae:	a10ff0ef          	jal	ra,800019be <printk>
800027b2:	06100593          	li	a1,97
800027b6:	12c48513          	addi	a0,s1,300
800027ba:	a22ff0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800027be:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800027c2:	40f2                	lw	ra,28(sp)
800027c4:	4462                	lw	s0,24(sp)
800027c6:	44d2                	lw	s1,20(sp)
800027c8:	4942                	lw	s2,16(sp)
800027ca:	49b2                	lw	s3,12(sp)
800027cc:	6105                	addi	sp,sp,32
800027ce:	8082                	ret

800027d0 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800027d0:	800057b7          	lui	a5,0x80005
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800027d4:	6f47a783          	lw	a5,1780(a5) # 800056f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f5>
{
800027d8:	1141                	addi	sp,sp,-16
800027da:	c422                	sw	s0,8(sp)
800027dc:	c606                	sw	ra,12(sp)
800027de:	c226                	sw	s1,4(sp)
800027e0:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800027e2:	02f59863          	bne	a1,a5,80002812 <z_priq_dumb_remove+0x42>
800027e6:	800054b7          	lui	s1,0x80005
800027ea:	800055b7          	lui	a1,0x80005
800027ee:	80005537          	lui	a0,0x80005
800027f2:	3f058593          	addi	a1,a1,1008 # 800053f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053f1>
800027f6:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800027fa:	28c00693          	li	a3,652
800027fe:	3a448613          	addi	a2,s1,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
80002802:	9bcff0ef          	jal	ra,800019be <printk>
80002806:	28c00593          	li	a1,652
8000280a:	3a448513          	addi	a0,s1,932
8000280e:	9ceff0ef          	jal	ra,800019dc <assert_post_action>
	node->prev->next = node->next;
80002812:	4058                	lw	a4,4(s0)
80002814:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80002816:	40b2                	lw	ra,12(sp)
80002818:	4492                	lw	s1,4(sp)
8000281a:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
8000281c:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
8000281e:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80002822:	00042223          	sw	zero,4(s0)
80002826:	4422                	lw	s0,8(sp)
80002828:	0141                	addi	sp,sp,16
8000282a:	8082                	ret

8000282c <z_unpend_thread>:
{
8000282c:	1101                	addi	sp,sp,-32
8000282e:	cc22                	sw	s0,24(sp)
80002830:	ca26                	sw	s1,20(sp)
80002832:	ce06                	sw	ra,28(sp)
80002834:	c84a                	sw	s2,16(sp)
80002836:	c64e                	sw	s3,12(sp)
80002838:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000283a:	44a1                	li	s1,8
8000283c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002840:	80005937          	lui	s2,0x80005
80002844:	7c090513          	addi	a0,s2,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002848:	88a1                	andi	s1,s1,8
8000284a:	182010ef          	jal	ra,800039cc <z_spin_lock_valid>
8000284e:	ed0d                	bnez	a0,80002888 <z_unpend_thread+0x5c>
80002850:	800059b7          	lui	s3,0x80005
80002854:	800055b7          	lui	a1,0x80005
80002858:	80005537          	lui	a0,0x80005
8000285c:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002860:	04e00693          	li	a3,78
80002864:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002868:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000286c:	952ff0ef          	jal	ra,800019be <printk>
80002870:	80005537          	lui	a0,0x80005
80002874:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80002878:	946ff0ef          	jal	ra,800019be <printk>
8000287c:	04e00593          	li	a1,78
80002880:	12c98513          	addi	a0,s3,300
80002884:	958ff0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80002888:	7c090513          	addi	a0,s2,1984
8000288c:	17c010ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002890:	00840513          	addi	a0,s0,8
80002894:	b25ff0ef          	jal	ra,800023b8 <pended_on.isra.15>
80002898:	85a2                	mv	a1,s0
8000289a:	3f1d                	jal	800027d0 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000289c:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800028a0:	7c090513          	addi	a0,s2,1984
800028a4:	9bf5                	andi	a5,a5,-3
800028a6:	00f406a3          	sb	a5,13(s0)
800028aa:	13c010ef          	jal	ra,800039e6 <z_spin_unlock_valid>
800028ae:	ed0d                	bnez	a0,800028e8 <z_unpend_thread+0xbc>
800028b0:	80005937          	lui	s2,0x80005
800028b4:	800055b7          	lui	a1,0x80005
800028b8:	80005537          	lui	a0,0x80005
800028bc:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800028c0:	06100693          	li	a3,97
800028c4:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800028c8:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800028cc:	8f2ff0ef          	jal	ra,800019be <printk>
800028d0:	80005537          	lui	a0,0x80005
800028d4:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800028d8:	8e6ff0ef          	jal	ra,800019be <printk>
800028dc:	06100593          	li	a1,97
800028e0:	12c90513          	addi	a0,s2,300
800028e4:	8f8ff0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800028e8:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800028ec:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800028f0:	01840513          	addi	a0,s0,24
}
800028f4:	4462                	lw	s0,24(sp)
800028f6:	40f2                	lw	ra,28(sp)
800028f8:	44d2                	lw	s1,20(sp)
800028fa:	4942                	lw	s2,16(sp)
800028fc:	49b2                	lw	s3,12(sp)
800028fe:	6105                	addi	sp,sp,32
80002900:	6680106f          	j	80003f68 <z_abort_timeout>

80002904 <z_priq_dumb_best>:
	return list->head == list;
80002904:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002906:	00f51363          	bne	a0,a5,8000290c <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
8000290a:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
8000290c:	853e                	mv	a0,a5
8000290e:	8082                	ret

80002910 <update_cache>:
{
80002910:	1141                	addi	sp,sp,-16
80002912:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002914:	80006437          	lui	s0,0x80006
{
80002918:	c04a                	sw	s2,0(sp)
8000291a:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
8000291c:	aec40513          	addi	a0,s0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80002920:	02450513          	addi	a0,a0,36
{
80002924:	c226                	sw	s1,4(sp)
80002926:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002928:	3ff1                	jal	80002904 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
8000292a:	aec40413          	addi	s0,s0,-1300
8000292e:	84aa                	mv	s1,a0
80002930:	e111                	bnez	a0,80002934 <update_cache+0x24>
80002932:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
80002934:	06091263          	bnez	s2,80002998 <update_cache+0x88>
	__ASSERT(_current != NULL, "");
80002938:	441c                	lw	a5,8(s0)
8000293a:	ef8d                	bnez	a5,80002974 <update_cache+0x64>
8000293c:	80005937          	lui	s2,0x80005
80002940:	800055b7          	lui	a1,0x80005
80002944:	80005537          	lui	a0,0x80005
80002948:	3d058593          	addi	a1,a1,976 # 800053d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053d1>
8000294c:	07f00693          	li	a3,127
80002950:	3a490613          	addi	a2,s2,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
80002954:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002958:	866ff0ef          	jal	ra,800019be <printk>
8000295c:	80005537          	lui	a0,0x80005
80002960:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
80002964:	85aff0ef          	jal	ra,800019be <printk>
80002968:	07f00593          	li	a1,127
8000296c:	3a490513          	addi	a0,s2,932
80002970:	86cff0ef          	jal	ra,800019dc <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80002974:	441c                	lw	a5,8(s0)
80002976:	00d7c703          	lbu	a4,13(a5)
8000297a:	8b7d                	andi	a4,a4,31
8000297c:	ef11                	bnez	a4,80002998 <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
8000297e:	00e7d683          	lhu	a3,14(a5)
80002982:	07f00713          	li	a4,127
80002986:	00d77963          	bgeu	a4,a3,80002998 <update_cache+0x88>
		_kernel.ready_q.cache = _current;
8000298a:	d01c                	sw	a5,32(s0)
}
8000298c:	40b2                	lw	ra,12(sp)
8000298e:	4422                	lw	s0,8(sp)
80002990:	4492                	lw	s1,4(sp)
80002992:	4902                	lw	s2,0(sp)
80002994:	0141                	addi	sp,sp,16
80002996:	8082                	ret
		if (th != _current) {
80002998:	441c                	lw	a5,8(s0)
8000299a:	00978463          	beq	a5,s1,800029a2 <update_cache+0x92>
			reset_time_slice();
8000299e:	9f5ff0ef          	jal	ra,80002392 <reset_time_slice>
		_kernel.ready_q.cache = th;
800029a2:	d004                	sw	s1,32(s0)
}
800029a4:	b7e5                	j	8000298c <update_cache+0x7c>

800029a6 <k_sched_unlock>:
{
800029a6:	1101                	addi	sp,sp,-32
800029a8:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800029aa:	80006937          	lui	s2,0x80006
800029ae:	aec90793          	addi	a5,s2,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
800029b2:	479c                	lw	a5,8(a5)
{
800029b4:	ce06                	sw	ra,28(sp)
800029b6:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800029b8:	00f7c783          	lbu	a5,15(a5)
{
800029bc:	ca26                	sw	s1,20(sp)
800029be:	c64e                	sw	s3,12(sp)
800029c0:	aec90913          	addi	s2,s2,-1300
	__ASSERT(_current->base.sched_locked != 0, "");
800029c4:	ef8d                	bnez	a5,800029fe <k_sched_unlock+0x58>
800029c6:	80005437          	lui	s0,0x80005
800029ca:	800055b7          	lui	a1,0x80005
800029ce:	80005537          	lui	a0,0x80005
800029d2:	37c58593          	addi	a1,a1,892 # 8000537c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000537d>
800029d6:	22100693          	li	a3,545
800029da:	3a440613          	addi	a2,s0,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
800029de:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800029e2:	fddfe0ef          	jal	ra,800019be <printk>
800029e6:	80005537          	lui	a0,0x80005
800029ea:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
800029ee:	fd1fe0ef          	jal	ra,800019be <printk>
800029f2:	22100593          	li	a1,545
800029f6:	3a440513          	addi	a0,s0,932
800029fa:	fe3fe0ef          	jal	ra,800019dc <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800029fe:	00092783          	lw	a5,0(s2)
80002a02:	cf8d                	beqz	a5,80002a3c <k_sched_unlock+0x96>
80002a04:	80005437          	lui	s0,0x80005
80002a08:	800055b7          	lui	a1,0x80005
80002a0c:	80005537          	lui	a0,0x80005
80002a10:	33c58593          	addi	a1,a1,828 # 8000533c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000533d>
80002a14:	22200693          	li	a3,546
80002a18:	3a440613          	addi	a2,s0,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
80002a1c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002a20:	f9ffe0ef          	jal	ra,800019be <printk>
80002a24:	80005537          	lui	a0,0x80005
80002a28:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
80002a2c:	f93fe0ef          	jal	ra,800019be <printk>
80002a30:	22200593          	li	a1,546
80002a34:	3a440513          	addi	a0,s0,932
80002a38:	fa5fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002a3c:	4421                	li	s0,8
80002a3e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002a42:	800054b7          	lui	s1,0x80005
80002a46:	7c048513          	addi	a0,s1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002a4a:	8821                	andi	s0,s0,8
80002a4c:	781000ef          	jal	ra,800039cc <z_spin_lock_valid>
80002a50:	ed0d                	bnez	a0,80002a8a <k_sched_unlock+0xe4>
80002a52:	800059b7          	lui	s3,0x80005
80002a56:	800055b7          	lui	a1,0x80005
80002a5a:	80005537          	lui	a0,0x80005
80002a5e:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002a62:	04e00693          	li	a3,78
80002a66:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002a6a:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002a6e:	f51fe0ef          	jal	ra,800019be <printk>
80002a72:	80005537          	lui	a0,0x80005
80002a76:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80002a7a:	f45fe0ef          	jal	ra,800019be <printk>
80002a7e:	04e00593          	li	a1,78
80002a82:	12c98513          	addi	a0,s3,300
80002a86:	f57fe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80002a8a:	7c048513          	addi	a0,s1,1984
80002a8e:	77b000ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80002a92:	00892703          	lw	a4,8(s2)
		update_cache(1);
80002a96:	4505                	li	a0,1
		++_current->base.sched_locked;
80002a98:	00f74783          	lbu	a5,15(a4)
80002a9c:	0785                	addi	a5,a5,1
80002a9e:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80002aa2:	35bd                	jal	80002910 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002aa4:	7c048513          	addi	a0,s1,1984
80002aa8:	73f000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002aac:	ed0d                	bnez	a0,80002ae6 <k_sched_unlock+0x140>
80002aae:	800054b7          	lui	s1,0x80005
80002ab2:	800055b7          	lui	a1,0x80005
80002ab6:	80005537          	lui	a0,0x80005
80002aba:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002abe:	06100693          	li	a3,97
80002ac2:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002ac6:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002aca:	ef5fe0ef          	jal	ra,800019be <printk>
80002ace:	80005537          	lui	a0,0x80005
80002ad2:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80002ad6:	ee9fe0ef          	jal	ra,800019be <printk>
80002ada:	06100593          	li	a1,97
80002ade:	12c48513          	addi	a0,s1,300
80002ae2:	efbfe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ae6:	30042473          	csrrs	s0,mstatus,s0
}
80002aea:	4462                	lw	s0,24(sp)
80002aec:	40f2                	lw	ra,28(sp)
80002aee:	44d2                	lw	s1,20(sp)
80002af0:	4942                	lw	s2,16(sp)
80002af2:	49b2                	lw	s3,12(sp)
80002af4:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
80002af6:	b81ff06f          	j	80002676 <z_reschedule_unlocked>

80002afa <z_add_thread_to_ready_q>:
{
80002afa:	1101                	addi	sp,sp,-32
80002afc:	cc22                	sw	s0,24(sp)
80002afe:	ca26                	sw	s1,20(sp)
80002b00:	ce06                	sw	ra,28(sp)
80002b02:	c84a                	sw	s2,16(sp)
80002b04:	c64e                	sw	s3,12(sp)
80002b06:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002b08:	44a1                	li	s1,8
80002b0a:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002b0e:	80005937          	lui	s2,0x80005
80002b12:	7c090513          	addi	a0,s2,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002b16:	88a1                	andi	s1,s1,8
80002b18:	6b5000ef          	jal	ra,800039cc <z_spin_lock_valid>
80002b1c:	ed0d                	bnez	a0,80002b56 <z_add_thread_to_ready_q+0x5c>
80002b1e:	800059b7          	lui	s3,0x80005
80002b22:	800055b7          	lui	a1,0x80005
80002b26:	80005537          	lui	a0,0x80005
80002b2a:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002b2e:	04e00693          	li	a3,78
80002b32:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002b36:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002b3a:	e85fe0ef          	jal	ra,800019be <printk>
80002b3e:	80005537          	lui	a0,0x80005
80002b42:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80002b46:	e79fe0ef          	jal	ra,800019be <printk>
80002b4a:	04e00593          	li	a1,78
80002b4e:	12c98513          	addi	a0,s3,300
80002b52:	e8bfe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80002b56:	7c090513          	addi	a0,s2,1984
80002b5a:	6af000ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80002b5e:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002b62:	6f47a783          	lw	a5,1780(a5) # 800056f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f5>
80002b66:	02f41863          	bne	s0,a5,80002b96 <z_add_thread_to_ready_q+0x9c>
80002b6a:	800059b7          	lui	s3,0x80005
80002b6e:	800055b7          	lui	a1,0x80005
80002b72:	80005537          	lui	a0,0x80005
80002b76:	3f058593          	addi	a1,a1,1008 # 800053f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053f1>
80002b7a:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002b7e:	27600693          	li	a3,630
80002b82:	3a498613          	addi	a2,s3,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
80002b86:	e39fe0ef          	jal	ra,800019be <printk>
80002b8a:	27600593          	li	a1,630
80002b8e:	3a498513          	addi	a0,s3,932
80002b92:	e4bfe0ef          	jal	ra,800019dc <assert_post_action>
	return list->head == list;
80002b96:	80006737          	lui	a4,0x80006
80002b9a:	aec70693          	addi	a3,a4,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80002b9e:	52dc                	lw	a5,36(a3)
80002ba0:	5690                	lw	a2,40(a3)
80002ba2:	800066b7          	lui	a3,0x80006
80002ba6:	b1068693          	addi	a3,a3,-1264 # 80005b10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b11>
80002baa:	aec70713          	addi	a4,a4,-1300
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002bae:	08d78563          	beq	a5,a3,80002c38 <z_add_thread_to_ready_q+0x13e>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002bb2:	c3d9                	beqz	a5,80002c38 <z_add_thread_to_ready_q+0x13e>
	if (t1->base.prio < t2->base.prio) {
80002bb4:	00e40583          	lb	a1,14(s0)
80002bb8:	00e78503          	lb	a0,14(a5)
80002bbc:	06a5da63          	bge	a1,a0,80002c30 <z_add_thread_to_ready_q+0x136>
	node->prev = successor->prev;
80002bc0:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002bc2:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002bc4:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002bc6:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002bc8:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002bca:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80002bce:	4501                	li	a0,0
80002bd0:	0407e793          	ori	a5,a5,64
80002bd4:	00f406a3          	sb	a5,13(s0)
80002bd8:	d39ff0ef          	jal	ra,80002910 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002bdc:	7c090513          	addi	a0,s2,1984
80002be0:	607000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002be4:	ed0d                	bnez	a0,80002c1e <z_add_thread_to_ready_q+0x124>
80002be6:	80005437          	lui	s0,0x80005
80002bea:	800055b7          	lui	a1,0x80005
80002bee:	80005537          	lui	a0,0x80005
80002bf2:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002bf6:	06100693          	li	a3,97
80002bfa:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002bfe:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002c02:	dbdfe0ef          	jal	ra,800019be <printk>
80002c06:	80005537          	lui	a0,0x80005
80002c0a:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80002c0e:	db1fe0ef          	jal	ra,800019be <printk>
80002c12:	06100593          	li	a1,97
80002c16:	12c40513          	addi	a0,s0,300
80002c1a:	dc3fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002c1e:	3004a4f3          	csrrs	s1,mstatus,s1
}
80002c22:	40f2                	lw	ra,28(sp)
80002c24:	4462                	lw	s0,24(sp)
80002c26:	44d2                	lw	s1,20(sp)
80002c28:	4942                	lw	s2,16(sp)
80002c2a:	49b2                	lw	s3,12(sp)
80002c2c:	6105                	addi	sp,sp,32
80002c2e:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80002c30:	00f60463          	beq	a2,a5,80002c38 <z_add_thread_to_ready_q+0x13e>
80002c34:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002c36:	f3c9                	bnez	a5,80002bb8 <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
80002c38:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80002c3a:	571c                	lw	a5,40(a4)
	node->next = list;
80002c3c:	c014                	sw	a3,0(s0)
	list->tail->next = node;
80002c3e:	c380                	sw	s0,0(a5)
	list->tail = node;
80002c40:	d700                	sw	s0,40(a4)
80002c42:	b761                	j	80002bca <z_add_thread_to_ready_q+0xd0>

80002c44 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80002c44:	ff052783          	lw	a5,-16(a0)
{
80002c48:	1101                	addi	sp,sp,-32
80002c4a:	cc22                	sw	s0,24(sp)
80002c4c:	c64e                	sw	s3,12(sp)
80002c4e:	ce06                	sw	ra,28(sp)
80002c50:	ca26                	sw	s1,20(sp)
80002c52:	c84a                	sw	s2,16(sp)
80002c54:	c452                	sw	s4,8(sp)
80002c56:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80002c58:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80002c5c:	cfcd                	beqz	a5,80002d16 <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002c5e:	44a1                	li	s1,8
80002c60:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c64:	80005937          	lui	s2,0x80005
80002c68:	7c090513          	addi	a0,s2,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002c6c:	88a1                	andi	s1,s1,8
80002c6e:	55f000ef          	jal	ra,800039cc <z_spin_lock_valid>
80002c72:	ed0d                	bnez	a0,80002cac <z_thread_timeout+0x68>
80002c74:	80005a37          	lui	s4,0x80005
80002c78:	800055b7          	lui	a1,0x80005
80002c7c:	80005537          	lui	a0,0x80005
80002c80:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002c84:	04e00693          	li	a3,78
80002c88:	12ca0613          	addi	a2,s4,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002c8c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002c90:	d2ffe0ef          	jal	ra,800019be <printk>
80002c94:	80005537          	lui	a0,0x80005
80002c98:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80002c9c:	d23fe0ef          	jal	ra,800019be <printk>
80002ca0:	04e00593          	li	a1,78
80002ca4:	12ca0513          	addi	a0,s4,300
80002ca8:	d35fe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80002cac:	7c090513          	addi	a0,s2,1984
80002cb0:	559000ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002cb4:	ff040513          	addi	a0,s0,-16
80002cb8:	f00ff0ef          	jal	ra,800023b8 <pended_on.isra.15>
80002cbc:	85ce                	mv	a1,s3
80002cbe:	b13ff0ef          	jal	ra,800027d0 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002cc2:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002cc6:	7c090513          	addi	a0,s2,1984
80002cca:	9bf5                	andi	a5,a5,-3
80002ccc:	fef40aa3          	sb	a5,-11(s0)
80002cd0:	517000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002cd4:	ed0d                	bnez	a0,80002d0e <z_thread_timeout+0xca>
80002cd6:	80005937          	lui	s2,0x80005
80002cda:	800055b7          	lui	a1,0x80005
80002cde:	80005537          	lui	a0,0x80005
80002ce2:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002ce6:	06100693          	li	a3,97
80002cea:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002cee:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002cf2:	ccdfe0ef          	jal	ra,800019be <printk>
80002cf6:	80005537          	lui	a0,0x80005
80002cfa:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80002cfe:	cc1fe0ef          	jal	ra,800019be <printk>
80002d02:	06100593          	li	a1,97
80002d06:	12c90513          	addi	a0,s2,300
80002d0a:	cd3fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d0e:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80002d12:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002d16:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002d1a:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002d1c:	9bad                	andi	a5,a5,-21
80002d1e:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002d22:	e5cff0ef          	jal	ra,8000237e <z_is_thread_ready>
80002d26:	c919                	beqz	a0,80002d3c <z_thread_timeout+0xf8>
}
80002d28:	4462                	lw	s0,24(sp)
80002d2a:	40f2                	lw	ra,28(sp)
80002d2c:	44d2                	lw	s1,20(sp)
80002d2e:	4942                	lw	s2,16(sp)
80002d30:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80002d32:	854e                	mv	a0,s3
80002d34:	49b2                	lw	s3,12(sp)
80002d36:	6105                	addi	sp,sp,32
80002d38:	dc3ff06f          	j	80002afa <z_add_thread_to_ready_q>
80002d3c:	40f2                	lw	ra,28(sp)
80002d3e:	4462                	lw	s0,24(sp)
80002d40:	44d2                	lw	s1,20(sp)
80002d42:	4942                	lw	s2,16(sp)
80002d44:	49b2                	lw	s3,12(sp)
80002d46:	4a22                	lw	s4,8(sp)
80002d48:	6105                	addi	sp,sp,32
80002d4a:	8082                	ret

80002d4c <z_move_thread_to_end_of_prio_q>:
{
80002d4c:	1101                	addi	sp,sp,-32
80002d4e:	cc22                	sw	s0,24(sp)
80002d50:	c84a                	sw	s2,16(sp)
80002d52:	ce06                	sw	ra,28(sp)
80002d54:	ca26                	sw	s1,20(sp)
80002d56:	c64e                	sw	s3,12(sp)
80002d58:	c452                	sw	s4,8(sp)
80002d5a:	c256                	sw	s5,4(sp)
80002d5c:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d5e:	4921                	li	s2,8
80002d60:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d64:	800059b7          	lui	s3,0x80005
80002d68:	7c098513          	addi	a0,s3,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002d6c:	00897913          	andi	s2,s2,8
80002d70:	45d000ef          	jal	ra,800039cc <z_spin_lock_valid>
80002d74:	ed0d                	bnez	a0,80002dae <z_move_thread_to_end_of_prio_q+0x62>
80002d76:	800054b7          	lui	s1,0x80005
80002d7a:	800055b7          	lui	a1,0x80005
80002d7e:	80005537          	lui	a0,0x80005
80002d82:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002d86:	04e00693          	li	a3,78
80002d8a:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002d8e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002d92:	c2dfe0ef          	jal	ra,800019be <printk>
80002d96:	80005537          	lui	a0,0x80005
80002d9a:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80002d9e:	c21fe0ef          	jal	ra,800019be <printk>
80002da2:	04e00593          	li	a1,78
80002da6:	12c48513          	addi	a0,s1,300
80002daa:	c33fe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80002dae:	7c098513          	addi	a0,s3,1984
80002db2:	457000ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80002db6:	800064b7          	lui	s1,0x80006
80002dba:	aec48513          	addi	a0,s1,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80002dbe:	85a2                	mv	a1,s0
80002dc0:	02450513          	addi	a0,a0,36
80002dc4:	a0dff0ef          	jal	ra,800027d0 <z_priq_dumb_remove>
	return thread == _idle_thread;
80002dc8:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002dcc:	6f47a783          	lw	a5,1780(a5) # 800056f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f5>
80002dd0:	80006a37          	lui	s4,0x80006
80002dd4:	aec48493          	addi	s1,s1,-1300
80002dd8:	b10a0a13          	addi	s4,s4,-1264 # 80005b10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b11>
80002ddc:	02f41863          	bne	s0,a5,80002e0c <z_move_thread_to_end_of_prio_q+0xc0>
80002de0:	80005ab7          	lui	s5,0x80005
80002de4:	800055b7          	lui	a1,0x80005
80002de8:	80005537          	lui	a0,0x80005
80002dec:	3f058593          	addi	a1,a1,1008 # 800053f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053f1>
80002df0:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002df4:	27600693          	li	a3,630
80002df8:	3a4a8613          	addi	a2,s5,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
80002dfc:	bc3fe0ef          	jal	ra,800019be <printk>
80002e00:	27600593          	li	a1,630
80002e04:	3a4a8513          	addi	a0,s5,932
80002e08:	bd5fe0ef          	jal	ra,800019dc <assert_post_action>
	return list->head == list;
80002e0c:	50dc                	lw	a5,36(s1)
80002e0e:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002e10:	09478a63          	beq	a5,s4,80002ea4 <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002e14:	cbc1                	beqz	a5,80002ea4 <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
80002e16:	00e40683          	lb	a3,14(s0)
80002e1a:	00e78603          	lb	a2,14(a5)
80002e1e:	06c6df63          	bge	a3,a2,80002e9c <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
80002e22:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002e24:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002e26:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002e28:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002e2a:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002e2c:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80002e30:	4488                	lw	a0,8(s1)
80002e32:	0407e793          	ori	a5,a5,64
80002e36:	8d01                	sub	a0,a0,s0
80002e38:	00153513          	seqz	a0,a0
80002e3c:	00f406a3          	sb	a5,13(s0)
80002e40:	ad1ff0ef          	jal	ra,80002910 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002e44:	7c098513          	addi	a0,s3,1984
80002e48:	39f000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002e4c:	ed0d                	bnez	a0,80002e86 <z_move_thread_to_end_of_prio_q+0x13a>
80002e4e:	80005437          	lui	s0,0x80005
80002e52:	800055b7          	lui	a1,0x80005
80002e56:	80005537          	lui	a0,0x80005
80002e5a:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002e5e:	06100693          	li	a3,97
80002e62:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002e66:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002e6a:	b55fe0ef          	jal	ra,800019be <printk>
80002e6e:	80005537          	lui	a0,0x80005
80002e72:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80002e76:	b49fe0ef          	jal	ra,800019be <printk>
80002e7a:	06100593          	li	a1,97
80002e7e:	12c40513          	addi	a0,s0,300
80002e82:	b5bfe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002e86:	30092973          	csrrs	s2,mstatus,s2
}
80002e8a:	40f2                	lw	ra,28(sp)
80002e8c:	4462                	lw	s0,24(sp)
80002e8e:	44d2                	lw	s1,20(sp)
80002e90:	4942                	lw	s2,16(sp)
80002e92:	49b2                	lw	s3,12(sp)
80002e94:	4a22                	lw	s4,8(sp)
80002e96:	4a92                	lw	s5,4(sp)
80002e98:	6105                	addi	sp,sp,32
80002e9a:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80002e9c:	00e78463          	beq	a5,a4,80002ea4 <z_move_thread_to_end_of_prio_q+0x158>
80002ea0:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002ea2:	ffa5                	bnez	a5,80002e1a <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
80002ea4:	c058                	sw	a4,4(s0)
	list->tail->next = node;
80002ea6:	549c                	lw	a5,40(s1)
	node->next = list;
80002ea8:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80002eac:	c380                	sw	s0,0(a5)
	list->tail = node;
80002eae:	d480                	sw	s0,40(s1)
80002eb0:	bfb5                	j	80002e2c <z_move_thread_to_end_of_prio_q+0xe0>

80002eb2 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80002eb2:	800057b7          	lui	a5,0x80005
80002eb6:	7c87a783          	lw	a5,1992(a5) # 800057c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c9>
80002eba:	cbb1                	beqz	a5,80002f0e <z_time_slice+0x5c>
80002ebc:	800067b7          	lui	a5,0x80006
80002ec0:	aec78793          	addi	a5,a5,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80002ec4:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80002ec6:	07f00693          	li	a3,127
80002eca:	00e75603          	lhu	a2,14(a4)
80002ece:	04c6e063          	bltu	a3,a2,80002f0e <z_time_slice+0x5c>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80002ed2:	800056b7          	lui	a3,0x80005
80002ed6:	00e70603          	lb	a2,14(a4)
80002eda:	7c46a683          	lw	a3,1988(a3) # 800057c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c5>
80002ede:	02d64863          	blt	a2,a3,80002f0e <z_time_slice+0x5c>
	return thread == _idle_thread;
80002ee2:	800056b7          	lui	a3,0x80005
		&& !is_idle(t)
80002ee6:	6f46a683          	lw	a3,1780(a3) # 800056f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f5>
80002eea:	02d70263          	beq	a4,a3,80002f0e <z_time_slice+0x5c>
		&& !z_is_thread_timeout_active(t);
80002eee:	4f14                	lw	a3,24(a4)
80002ef0:	ee99                	bnez	a3,80002f0e <z_time_slice+0x5c>
		if (ticks >= _current_cpu->slice_ticks) {
80002ef2:	4b94                	lw	a3,16(a5)
80002ef4:	00d54b63          	blt	a0,a3,80002f0a <z_time_slice+0x58>
{
80002ef8:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80002efa:	853a                	mv	a0,a4
{
80002efc:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80002efe:	e4fff0ef          	jal	ra,80002d4c <z_move_thread_to_end_of_prio_q>
}
80002f02:	40b2                	lw	ra,12(sp)
80002f04:	0141                	addi	sp,sp,16
			reset_time_slice();
80002f06:	c8cff06f          	j	80002392 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80002f0a:	8e89                	sub	a3,a3,a0
80002f0c:	cb94                	sw	a3,16(a5)
80002f0e:	8082                	ret

80002f10 <z_remove_thread_from_ready_q>:
{
80002f10:	1101                	addi	sp,sp,-32
80002f12:	cc22                	sw	s0,24(sp)
80002f14:	c64e                	sw	s3,12(sp)
80002f16:	ce06                	sw	ra,28(sp)
80002f18:	ca26                	sw	s1,20(sp)
80002f1a:	c84a                	sw	s2,16(sp)
80002f1c:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f1e:	4421                	li	s0,8
80002f20:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f24:	800054b7          	lui	s1,0x80005
80002f28:	7c048513          	addi	a0,s1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f2c:	8821                	andi	s0,s0,8
80002f2e:	29f000ef          	jal	ra,800039cc <z_spin_lock_valid>
80002f32:	ed0d                	bnez	a0,80002f6c <z_remove_thread_from_ready_q+0x5c>
80002f34:	80005937          	lui	s2,0x80005
80002f38:	800055b7          	lui	a1,0x80005
80002f3c:	80005537          	lui	a0,0x80005
80002f40:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80002f44:	04e00693          	li	a3,78
80002f48:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002f4c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002f50:	a6ffe0ef          	jal	ra,800019be <printk>
80002f54:	80005537          	lui	a0,0x80005
80002f58:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80002f5c:	a63fe0ef          	jal	ra,800019be <printk>
80002f60:	04e00593          	li	a1,78
80002f64:	12c90513          	addi	a0,s2,300
80002f68:	a75fe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80002f6c:	7c048513          	addi	a0,s1,1984
80002f70:	299000ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80002f74:	00d9c783          	lbu	a5,13(s3)
80002f78:	80006937          	lui	s2,0x80006
80002f7c:	aec90913          	addi	s2,s2,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80002f80:	0407f793          	andi	a5,a5,64
80002f84:	cf81                	beqz	a5,80002f9c <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80002f86:	85ce                	mv	a1,s3
80002f88:	02490513          	addi	a0,s2,36
80002f8c:	845ff0ef          	jal	ra,800027d0 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80002f90:	00d9c783          	lbu	a5,13(s3)
80002f94:	fbf7f793          	andi	a5,a5,-65
80002f98:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80002f9c:	00892503          	lw	a0,8(s2)
80002fa0:	41350533          	sub	a0,a0,s3
80002fa4:	00153513          	seqz	a0,a0
80002fa8:	969ff0ef          	jal	ra,80002910 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002fac:	7c048513          	addi	a0,s1,1984
80002fb0:	237000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80002fb4:	ed0d                	bnez	a0,80002fee <z_remove_thread_from_ready_q+0xde>
80002fb6:	800054b7          	lui	s1,0x80005
80002fba:	800055b7          	lui	a1,0x80005
80002fbe:	80005537          	lui	a0,0x80005
80002fc2:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80002fc6:	06100693          	li	a3,97
80002fca:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80002fce:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80002fd2:	9edfe0ef          	jal	ra,800019be <printk>
80002fd6:	80005537          	lui	a0,0x80005
80002fda:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80002fde:	9e1fe0ef          	jal	ra,800019be <printk>
80002fe2:	06100593          	li	a1,97
80002fe6:	12c48513          	addi	a0,s1,300
80002fea:	9f3fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002fee:	30042473          	csrrs	s0,mstatus,s0
}
80002ff2:	40f2                	lw	ra,28(sp)
80002ff4:	4462                	lw	s0,24(sp)
80002ff6:	44d2                	lw	s1,20(sp)
80002ff8:	4942                	lw	s2,16(sp)
80002ffa:	49b2                	lw	s3,12(sp)
80002ffc:	6105                	addi	sp,sp,32
80002ffe:	8082                	ret

80003000 <pend>:
{
80003000:	1101                	addi	sp,sp,-32
80003002:	cc22                	sw	s0,24(sp)
80003004:	ca26                	sw	s1,20(sp)
80003006:	842a                	mv	s0,a0
80003008:	c84a                	sw	s2,16(sp)
8000300a:	ce06                	sw	ra,28(sp)
8000300c:	c64e                	sw	s3,12(sp)
8000300e:	84ae                	mv	s1,a1
80003010:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003012:	3dfd                	jal	80002f10 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003014:	00d44783          	lbu	a5,13(s0)
80003018:	0027e793          	ori	a5,a5,2
8000301c:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003020:	cca9                	beqz	s1,8000307a <pend+0x7a>
	return thread == _idle_thread;
80003022:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80003026:	6f47a783          	lw	a5,1780(a5) # 800056f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f5>
		thread->base.pended_on = wait_q;
8000302a:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
8000302c:	02f41863          	bne	s0,a5,8000305c <pend+0x5c>
80003030:	800059b7          	lui	s3,0x80005
80003034:	800055b7          	lui	a1,0x80005
80003038:	80005537          	lui	a0,0x80005
8000303c:	3f058593          	addi	a1,a1,1008 # 800053f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053f1>
80003040:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003044:	27600693          	li	a3,630
80003048:	3a498613          	addi	a2,s3,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
8000304c:	973fe0ef          	jal	ra,800019be <printk>
80003050:	27600593          	li	a1,630
80003054:	3a498513          	addi	a0,s3,932
80003058:	985fe0ef          	jal	ra,800019dc <assert_post_action>
	return list->head == list;
8000305c:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000305e:	04f48b63          	beq	s1,a5,800030b4 <pend+0xb4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003062:	cba9                	beqz	a5,800030b4 <pend+0xb4>
	if (t1->base.prio < t2->base.prio) {
80003064:	00e40703          	lb	a4,14(s0)
80003068:	00e78683          	lb	a3,14(a5)
8000306c:	02d75f63          	bge	a4,a3,800030aa <pend+0xaa>
	node->prev = successor->prev;
80003070:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003072:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80003074:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80003076:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003078:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
8000307a:	57fd                	li	a5,-1
8000307c:	04f90363          	beq	s2,a5,800030c2 <pend+0xc2>
80003080:	45a9                	li	a1,10
80003082:	00990513          	addi	a0,s2,9
80003086:	fcafd0ef          	jal	ra,80000850 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
8000308a:	00150613          	addi	a2,a0,1
8000308e:	01840513          	addi	a0,s0,24
}
80003092:	4462                	lw	s0,24(sp)
80003094:	40f2                	lw	ra,28(sp)
80003096:	44d2                	lw	s1,20(sp)
80003098:	4942                	lw	s2,16(sp)
8000309a:	49b2                	lw	s3,12(sp)
8000309c:	800035b7          	lui	a1,0x80003
800030a0:	c4458593          	addi	a1,a1,-956 # 80002c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002c45>
800030a4:	6105                	addi	sp,sp,32
800030a6:	4fb0006f          	j	80003da0 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
800030aa:	40d4                	lw	a3,4(s1)
800030ac:	00d78463          	beq	a5,a3,800030b4 <pend+0xb4>
800030b0:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800030b2:	fbdd                	bnez	a5,80003068 <pend+0x68>
	node->prev = list->tail;
800030b4:	40dc                	lw	a5,4(s1)
	node->next = list;
800030b6:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
800030b8:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
800030ba:	40dc                	lw	a5,4(s1)
800030bc:	c380                	sw	s0,0(a5)
	list->tail = node;
800030be:	c0c0                	sw	s0,4(s1)
800030c0:	bf6d                	j	8000307a <pend+0x7a>
}
800030c2:	40f2                	lw	ra,28(sp)
800030c4:	4462                	lw	s0,24(sp)
800030c6:	44d2                	lw	s1,20(sp)
800030c8:	4942                	lw	s2,16(sp)
800030ca:	49b2                	lw	s3,12(sp)
800030cc:	6105                	addi	sp,sp,32
800030ce:	8082                	ret

800030d0 <z_pend_curr_irqlock>:
{
800030d0:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
800030d2:	800067b7          	lui	a5,0x80006
{
800030d6:	c422                	sw	s0,8(sp)
800030d8:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
800030da:	af47a503          	lw	a0,-1292(a5) # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
{
800030de:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
800030e0:	3705                	jal	80003000 <pend>
800030e2:	8522                	mv	a0,s0
}
800030e4:	4422                	lw	s0,8(sp)
800030e6:	40b2                	lw	ra,12(sp)
800030e8:	0141                	addi	sp,sp,16
800030ea:	8e6fd06f          	j	800001d0 <__swap>

800030ee <z_pend_curr>:
{
800030ee:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
800030f0:	800067b7          	lui	a5,0x80006
{
800030f4:	c422                	sw	s0,8(sp)
800030f6:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
800030f8:	af47a503          	lw	a0,-1292(a5) # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
{
800030fc:	c226                	sw	s1,4(sp)
800030fe:	84ae                	mv	s1,a1
80003100:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
80003102:	8636                	mv	a2,a3
{
80003104:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003106:	3ded                	jal	80003000 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003108:	8522                	mv	a0,s0
8000310a:	0dd000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
8000310e:	ed0d                	bnez	a0,80003148 <z_pend_curr+0x5a>
80003110:	80005437          	lui	s0,0x80005
80003114:	800055b7          	lui	a1,0x80005
80003118:	80005537          	lui	a0,0x80005
8000311c:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003120:	07800693          	li	a3,120
80003124:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003128:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000312c:	893fe0ef          	jal	ra,800019be <printk>
80003130:	80005537          	lui	a0,0x80005
80003134:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80003138:	887fe0ef          	jal	ra,800019be <printk>
8000313c:	07800593          	li	a1,120
80003140:	12c40513          	addi	a0,s0,300
80003144:	899fe0ef          	jal	ra,800019dc <assert_post_action>
}
80003148:	4422                	lw	s0,8(sp)
8000314a:	40b2                	lw	ra,12(sp)
8000314c:	8526                	mv	a0,s1
8000314e:	4492                	lw	s1,4(sp)
80003150:	0141                	addi	sp,sp,16
80003152:	87efd06f          	j	800001d0 <__swap>

80003156 <z_unpend_first_thread>:
{
80003156:	1101                	addi	sp,sp,-32
80003158:	c84a                	sw	s2,16(sp)
8000315a:	c64e                	sw	s3,12(sp)
8000315c:	ce06                	sw	ra,28(sp)
8000315e:	cc22                	sw	s0,24(sp)
80003160:	ca26                	sw	s1,20(sp)
80003162:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003164:	4921                	li	s2,8
80003166:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000316a:	800054b7          	lui	s1,0x80005
8000316e:	7c048513          	addi	a0,s1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003172:	00897913          	andi	s2,s2,8
80003176:	057000ef          	jal	ra,800039cc <z_spin_lock_valid>
8000317a:	ed0d                	bnez	a0,800031b4 <z_unpend_first_thread+0x5e>
8000317c:	80005437          	lui	s0,0x80005
80003180:	800055b7          	lui	a1,0x80005
80003184:	80005537          	lui	a0,0x80005
80003188:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
8000318c:	04e00693          	li	a3,78
80003190:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003194:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003198:	827fe0ef          	jal	ra,800019be <printk>
8000319c:	80005537          	lui	a0,0x80005
800031a0:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
800031a4:	81bfe0ef          	jal	ra,800019be <printk>
800031a8:	04e00593          	li	a1,78
800031ac:	12c40513          	addi	a0,s0,300
800031b0:	82dfe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
800031b4:	7c048513          	addi	a0,s1,1984
800031b8:	051000ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
800031bc:	854e                	mv	a0,s3
800031be:	f46ff0ef          	jal	ra,80002904 <z_priq_dumb_best>
800031c2:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800031c4:	7c048513          	addi	a0,s1,1984
800031c8:	01f000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
800031cc:	ed0d                	bnez	a0,80003206 <z_unpend_first_thread+0xb0>
800031ce:	800059b7          	lui	s3,0x80005
800031d2:	800055b7          	lui	a1,0x80005
800031d6:	80005537          	lui	a0,0x80005
800031da:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800031de:	06100693          	li	a3,97
800031e2:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800031e6:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800031ea:	fd4fe0ef          	jal	ra,800019be <printk>
800031ee:	80005537          	lui	a0,0x80005
800031f2:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800031f6:	fc8fe0ef          	jal	ra,800019be <printk>
800031fa:	06100593          	li	a1,97
800031fe:	12c98513          	addi	a0,s3,300
80003202:	fdafe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003206:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
8000320a:	c061                	beqz	s0,800032ca <z_unpend_first_thread+0x174>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000320c:	4921                	li	s2,8
8000320e:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003212:	7c048513          	addi	a0,s1,1984
	key = (mstatus & SOC_MSTATUS_IEN);
80003216:	00897913          	andi	s2,s2,8
8000321a:	7b2000ef          	jal	ra,800039cc <z_spin_lock_valid>
8000321e:	ed0d                	bnez	a0,80003258 <z_unpend_first_thread+0x102>
80003220:	800059b7          	lui	s3,0x80005
80003224:	800055b7          	lui	a1,0x80005
80003228:	80005537          	lui	a0,0x80005
8000322c:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80003230:	04e00693          	li	a3,78
80003234:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003238:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000323c:	f82fe0ef          	jal	ra,800019be <printk>
80003240:	80005537          	lui	a0,0x80005
80003244:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003248:	f76fe0ef          	jal	ra,800019be <printk>
8000324c:	04e00593          	li	a1,78
80003250:	12c98513          	addi	a0,s3,300
80003254:	f88fe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003258:	7c048513          	addi	a0,s1,1984
8000325c:	7ac000ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003260:	00840513          	addi	a0,s0,8
80003264:	954ff0ef          	jal	ra,800023b8 <pended_on.isra.15>
80003268:	85a2                	mv	a1,s0
8000326a:	d66ff0ef          	jal	ra,800027d0 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000326e:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003272:	7c048513          	addi	a0,s1,1984
80003276:	9bf5                	andi	a5,a5,-3
80003278:	00f406a3          	sb	a5,13(s0)
8000327c:	76a000ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80003280:	ed0d                	bnez	a0,800032ba <z_unpend_first_thread+0x164>
80003282:	800054b7          	lui	s1,0x80005
80003286:	800055b7          	lui	a1,0x80005
8000328a:	80005537          	lui	a0,0x80005
8000328e:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003292:	06100693          	li	a3,97
80003296:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000329a:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000329e:	f20fe0ef          	jal	ra,800019be <printk>
800032a2:	80005537          	lui	a0,0x80005
800032a6:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800032aa:	f14fe0ef          	jal	ra,800019be <printk>
800032ae:	06100593          	li	a1,97
800032b2:	12c48513          	addi	a0,s1,300
800032b6:	f26fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800032ba:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
800032be:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
800032c2:	01840513          	addi	a0,s0,24
800032c6:	4a3000ef          	jal	ra,80003f68 <z_abort_timeout>
}
800032ca:	8522                	mv	a0,s0
800032cc:	40f2                	lw	ra,28(sp)
800032ce:	4462                	lw	s0,24(sp)
800032d0:	44d2                	lw	s1,20(sp)
800032d2:	4942                	lw	s2,16(sp)
800032d4:	49b2                	lw	s3,12(sp)
800032d6:	6105                	addi	sp,sp,32
800032d8:	8082                	ret

800032da <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
800032da:	1141                	addi	sp,sp,-16
800032dc:	c226                	sw	s1,4(sp)
800032de:	c04a                	sw	s2,0(sp)
800032e0:	c606                	sw	ra,12(sp)
800032e2:	c422                	sw	s0,8(sp)
800032e4:	892a                	mv	s2,a0
	int need_sched = 0;
800032e6:	4481                	li	s1,0
	return list->head == list;
800032e8:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800032ec:	00890363          	beq	s2,s0,800032f2 <z_unpend_all+0x18>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
800032f0:	e801                	bnez	s0,80003300 <z_unpend_all+0x26>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
800032f2:	40b2                	lw	ra,12(sp)
800032f4:	4422                	lw	s0,8(sp)
800032f6:	8526                	mv	a0,s1
800032f8:	4902                	lw	s2,0(sp)
800032fa:	4492                	lw	s1,4(sp)
800032fc:	0141                	addi	sp,sp,16
800032fe:	8082                	ret
		z_unpend_thread(th);
80003300:	8522                	mv	a0,s0
80003302:	d2aff0ef          	jal	ra,8000282c <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80003306:	8522                	mv	a0,s0
80003308:	876ff0ef          	jal	ra,8000237e <z_is_thread_ready>
		need_sched = 1;
8000330c:	4485                	li	s1,1
8000330e:	dd69                	beqz	a0,800032e8 <z_unpend_all+0xe>
		z_add_thread_to_ready_q(thread);
80003310:	8522                	mv	a0,s0
80003312:	fe8ff0ef          	jal	ra,80002afa <z_add_thread_to_ready_q>
80003316:	bfc9                	j	800032e8 <z_unpend_all+0xe>

80003318 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003318:	800067b7          	lui	a5,0x80006
8000331c:	aec78793          	addi	a5,a5,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80003320:	02478713          	addi	a4,a5,36
80003324:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003326:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003328:	4581                	li	a1,0
8000332a:	4501                	li	a0,0
8000332c:	8d2ff06f          	j	800023fe <k_sched_time_slice_set>

80003330 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80003330:	800067b7          	lui	a5,0x80006
80003334:	af47a503          	lw	a0,-1292(a5) # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80003338:	8082                	ret

8000333a <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
8000333a:	1101                	addi	sp,sp,-32
8000333c:	cc22                	sw	s0,24(sp)
8000333e:	ca26                	sw	s1,20(sp)
80003340:	c84a                	sw	s2,16(sp)
80003342:	ce06                	sw	ra,28(sp)
80003344:	c64e                	sw	s3,12(sp)
80003346:	842a                	mv	s0,a0
80003348:	892e                	mv	s2,a1
8000334a:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
8000334c:	ee0d                	bnez	a2,80003386 <z_impl_k_sem_init+0x4c>
8000334e:	800059b7          	lui	s3,0x80005
80003352:	800055b7          	lui	a1,0x80005
80003356:	80005537          	lui	a0,0x80005
8000335a:	41458593          	addi	a1,a1,1044 # 80005414 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005415>
8000335e:	04600693          	li	a3,70
80003362:	40498613          	addi	a2,s3,1028 # 80005404 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005405>
80003366:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000336a:	e54fe0ef          	jal	ra,800019be <printk>
8000336e:	80005537          	lui	a0,0x80005
80003372:	42050513          	addi	a0,a0,1056 # 80005420 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005421>
80003376:	e48fe0ef          	jal	ra,800019be <printk>
8000337a:	04600593          	li	a1,70
8000337e:	40498513          	addi	a0,s3,1028
80003382:	e5afe0ef          	jal	ra,800019dc <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003386:	0324fe63          	bgeu	s1,s2,800033c2 <z_impl_k_sem_init+0x88>
8000338a:	800059b7          	lui	s3,0x80005
8000338e:	800055b7          	lui	a1,0x80005
80003392:	80005537          	lui	a0,0x80005
80003396:	43858593          	addi	a1,a1,1080 # 80005438 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005439>
8000339a:	04700693          	li	a3,71
8000339e:	40498613          	addi	a2,s3,1028 # 80005404 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005405>
800033a2:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800033a6:	e18fe0ef          	jal	ra,800019be <printk>
800033aa:	80005537          	lui	a0,0x80005
800033ae:	45050513          	addi	a0,a0,1104 # 80005450 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005451>
800033b2:	e0cfe0ef          	jal	ra,800019be <printk>
800033b6:	04700593          	li	a1,71
800033ba:	40498513          	addi	a0,s3,1028
800033be:	e1efe0ef          	jal	ra,800019dc <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
800033c2:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
800033c6:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800033c8:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800033ca:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800033cc:	40f2                	lw	ra,28(sp)
800033ce:	4462                	lw	s0,24(sp)
800033d0:	44d2                	lw	s1,20(sp)
800033d2:	4942                	lw	s2,16(sp)
800033d4:	49b2                	lw	s3,12(sp)
800033d6:	6105                	addi	sp,sp,32
800033d8:	8082                	ret

800033da <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800033da:	1101                	addi	sp,sp,-32
800033dc:	ca26                	sw	s1,20(sp)
800033de:	c64e                	sw	s3,12(sp)
800033e0:	ce06                	sw	ra,28(sp)
800033e2:	cc22                	sw	s0,24(sp)
800033e4:	c84a                	sw	s2,16(sp)
800033e6:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033e8:	44a1                	li	s1,8
800033ea:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033ee:	80005437          	lui	s0,0x80005
800033f2:	7cc40513          	addi	a0,s0,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
	key = (mstatus & SOC_MSTATUS_IEN);
800033f6:	88a1                	andi	s1,s1,8
800033f8:	2bd1                	jal	800039cc <z_spin_lock_valid>
800033fa:	ed0d                	bnez	a0,80003434 <z_impl_k_sem_give+0x5a>
800033fc:	80005937          	lui	s2,0x80005
80003400:	800055b7          	lui	a1,0x80005
80003404:	80005537          	lui	a0,0x80005
80003408:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
8000340c:	04e00693          	li	a3,78
80003410:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003414:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003418:	da6fe0ef          	jal	ra,800019be <printk>
8000341c:	80005537          	lui	a0,0x80005
80003420:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003424:	d9afe0ef          	jal	ra,800019be <printk>
80003428:	04e00593          	li	a1,78
8000342c:	12c90513          	addi	a0,s2,300
80003430:	dacfe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003434:	7cc40513          	addi	a0,s0,1996
80003438:	2bc1                	jal	80003a08 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
8000343a:	854e                	mv	a0,s3
8000343c:	d1bff0ef          	jal	ra,80003156 <z_unpend_first_thread>
80003440:	892a                	mv	s2,a0
	if (thread != NULL) {
80003442:	c515                	beqz	a0,8000346e <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003444:	00d54783          	lbu	a5,13(a0)
80003448:	8bfd                	andi	a5,a5,31
8000344a:	e789                	bnez	a5,80003454 <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
8000344c:	4d1c                	lw	a5,24(a0)
8000344e:	e399                	bnez	a5,80003454 <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
80003450:	eaaff0ef          	jal	ra,80002afa <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80003454:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003458:	7cc40513          	addi	a0,s0,1996
}
8000345c:	4462                	lw	s0,24(sp)
8000345e:	40f2                	lw	ra,28(sp)
80003460:	4942                	lw	s2,16(sp)
80003462:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003464:	85a6                	mv	a1,s1
}
80003466:	44d2                	lw	s1,20(sp)
80003468:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
8000346a:	946ff06f          	j	800025b0 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
8000346e:	0089a703          	lw	a4,8(s3)
80003472:	00c9a783          	lw	a5,12(s3)
80003476:	8f99                	sub	a5,a5,a4
80003478:	00f037b3          	snez	a5,a5
8000347c:	97ba                	add	a5,a5,a4
8000347e:	00f9a423          	sw	a5,8(s3)
80003482:	bfd9                	j	80003458 <z_impl_k_sem_give+0x7e>

80003484 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003484:	800067b7          	lui	a5,0x80006
80003488:	aec7a783          	lw	a5,-1300(a5) # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
{
8000348c:	1101                	addi	sp,sp,-32
8000348e:	c84a                	sw	s2,16(sp)
80003490:	c64e                	sw	s3,12(sp)
80003492:	ce06                	sw	ra,28(sp)
80003494:	cc22                	sw	s0,24(sp)
80003496:	ca26                	sw	s1,20(sp)
80003498:	c452                	sw	s4,8(sp)
8000349a:	892a                	mv	s2,a0
8000349c:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000349e:	cf95                	beqz	a5,800034da <z_impl_k_sem_take+0x56>
800034a0:	cd8d                	beqz	a1,800034da <z_impl_k_sem_take+0x56>
800034a2:	80005437          	lui	s0,0x80005
800034a6:	800055b7          	lui	a1,0x80005
800034aa:	80005537          	lui	a0,0x80005
800034ae:	47858593          	addi	a1,a1,1144 # 80005478 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005479>
800034b2:	08c00693          	li	a3,140
800034b6:	40440613          	addi	a2,s0,1028 # 80005404 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005405>
800034ba:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800034be:	d00fe0ef          	jal	ra,800019be <printk>
800034c2:	80005537          	lui	a0,0x80005
800034c6:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
800034ca:	cf4fe0ef          	jal	ra,800019be <printk>
800034ce:	08c00593          	li	a1,140
800034d2:	40440513          	addi	a0,s0,1028
800034d6:	d06fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800034da:	4421                	li	s0,8
800034dc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800034e0:	800054b7          	lui	s1,0x80005
800034e4:	7cc48513          	addi	a0,s1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
	key = (mstatus & SOC_MSTATUS_IEN);
800034e8:	8821                	andi	s0,s0,8
800034ea:	21cd                	jal	800039cc <z_spin_lock_valid>
800034ec:	ed0d                	bnez	a0,80003526 <z_impl_k_sem_take+0xa2>
800034ee:	80005a37          	lui	s4,0x80005
800034f2:	800055b7          	lui	a1,0x80005
800034f6:	80005537          	lui	a0,0x80005
800034fa:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
800034fe:	04e00693          	li	a3,78
80003502:	12ca0613          	addi	a2,s4,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003506:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000350a:	cb4fe0ef          	jal	ra,800019be <printk>
8000350e:	80005537          	lui	a0,0x80005
80003512:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003516:	ca8fe0ef          	jal	ra,800019be <printk>
8000351a:	04e00593          	li	a1,78
8000351e:	12ca0513          	addi	a0,s4,300
80003522:	cbafe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003526:	7cc48513          	addi	a0,s1,1996
8000352a:	29f9                	jal	80003a08 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
8000352c:	00892783          	lw	a5,8(s2)
80003530:	cfb9                	beqz	a5,8000358e <z_impl_k_sem_take+0x10a>
		sem->count--;
80003532:	17fd                	addi	a5,a5,-1
80003534:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003538:	7cc48513          	addi	a0,s1,1996
8000353c:	216d                	jal	800039e6 <z_spin_unlock_valid>
8000353e:	ed0d                	bnez	a0,80003578 <z_impl_k_sem_take+0xf4>
80003540:	800054b7          	lui	s1,0x80005
80003544:	800055b7          	lui	a1,0x80005
80003548:	80005537          	lui	a0,0x80005
8000354c:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003550:	06100693          	li	a3,97
80003554:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003558:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000355c:	c62fe0ef          	jal	ra,800019be <printk>
80003560:	80005537          	lui	a0,0x80005
80003564:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80003568:	c56fe0ef          	jal	ra,800019be <printk>
8000356c:	06100593          	li	a1,97
80003570:	12c48513          	addi	a0,s1,300
80003574:	c68fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003578:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
8000357c:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
8000357e:	40f2                	lw	ra,28(sp)
80003580:	4462                	lw	s0,24(sp)
80003582:	44d2                	lw	s1,20(sp)
80003584:	4942                	lw	s2,16(sp)
80003586:	49b2                	lw	s3,12(sp)
80003588:	4a22                	lw	s4,8(sp)
8000358a:	6105                	addi	sp,sp,32
8000358c:	8082                	ret
	if (timeout == K_NO_WAIT) {
8000358e:	04099663          	bnez	s3,800035da <z_impl_k_sem_take+0x156>
80003592:	7cc48513          	addi	a0,s1,1996
80003596:	2981                	jal	800039e6 <z_spin_unlock_valid>
80003598:	ed0d                	bnez	a0,800035d2 <z_impl_k_sem_take+0x14e>
8000359a:	800054b7          	lui	s1,0x80005
8000359e:	800055b7          	lui	a1,0x80005
800035a2:	80005537          	lui	a0,0x80005
800035a6:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800035aa:	06100693          	li	a3,97
800035ae:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800035b2:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800035b6:	c08fe0ef          	jal	ra,800019be <printk>
800035ba:	80005537          	lui	a0,0x80005
800035be:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800035c2:	bfcfe0ef          	jal	ra,800019be <printk>
800035c6:	06100593          	li	a1,97
800035ca:	12c48513          	addi	a0,s1,300
800035ce:	c0efe0ef          	jal	ra,800019dc <assert_post_action>
800035d2:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800035d6:	5541                	li	a0,-16
800035d8:	b75d                	j	8000357e <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035da:	85a2                	mv	a1,s0
}
800035dc:	4462                	lw	s0,24(sp)
800035de:	40f2                	lw	ra,28(sp)
800035e0:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035e2:	86ce                	mv	a3,s3
800035e4:	864a                	mv	a2,s2
}
800035e6:	49b2                	lw	s3,12(sp)
800035e8:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035ea:	7cc48513          	addi	a0,s1,1996
}
800035ee:	44d2                	lw	s1,20(sp)
800035f0:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035f2:	afdff06f          	j	800030ee <z_pend_curr>

800035f6 <k_stack_init>:
		  u32_t num_entries)
{
	z_waitq_init(&stack->wait_q);
	stack->lock = (struct k_spinlock) {};
	stack->next = stack->base = buffer;
	stack->top = stack->base + num_entries;
800035f6:	060a                	slli	a2,a2,0x2
	stack->next = stack->base = buffer;
800035f8:	c54c                	sw	a1,12(a0)
800035fa:	c90c                	sw	a1,16(a0)
	stack->top = stack->base + num_entries;
800035fc:	95b2                	add	a1,a1,a2
	list->head = (sys_dnode_t *)list;
800035fe:	c108                	sw	a0,0(a0)
	list->tail = (sys_dnode_t *)list;
80003600:	c148                	sw	a0,4(a0)
	stack->lock = (struct k_spinlock) {};
80003602:	00052423          	sw	zero,8(a0)
	stack->top = stack->base + num_entries;
80003606:	c94c                	sw	a1,20(a0)

	SYS_TRACING_OBJ_INIT(k_stack, stack);
	z_object_init(stack);
}
80003608:	8082                	ret

8000360a <z_impl_k_stack_alloc_init>:

s32_t z_impl_k_stack_alloc_init(struct k_stack *stack, u32_t num_entries)
{
8000360a:	1101                	addi	sp,sp,-32
8000360c:	cc22                	sw	s0,24(sp)
8000360e:	842a                	mv	s0,a0
	void *buffer;
	s32_t ret;

	buffer = z_thread_malloc(num_entries);
80003610:	852e                	mv	a0,a1
{
80003612:	ce06                	sw	ra,28(sp)
	buffer = z_thread_malloc(num_entries);
80003614:	c62e                	sw	a1,12(sp)
80003616:	132010ef          	jal	ra,80004748 <z_thread_malloc>
	if (buffer != NULL) {
8000361a:	cd09                	beqz	a0,80003634 <z_impl_k_stack_alloc_init+0x2a>
		k_stack_init(stack, buffer, num_entries);
8000361c:	4632                	lw	a2,12(sp)
8000361e:	85aa                	mv	a1,a0
80003620:	8522                	mv	a0,s0
80003622:	3fd1                	jal	800035f6 <k_stack_init>
		stack->flags = K_STACK_FLAG_ALLOC;
80003624:	4785                	li	a5,1
80003626:	00f40c23          	sb	a5,24(s0)
		ret = (s32_t)0;
8000362a:	4501                	li	a0,0
	} else {
		ret = -ENOMEM;
	}

	return ret;
}
8000362c:	40f2                	lw	ra,28(sp)
8000362e:	4462                	lw	s0,24(sp)
80003630:	6105                	addi	sp,sp,32
80003632:	8082                	ret
		ret = -ENOMEM;
80003634:	5551                	li	a0,-12
	return ret;
80003636:	bfdd                	j	8000362c <z_impl_k_stack_alloc_init+0x22>

80003638 <k_stack_cleanup>:
	return list->head == list;
80003638:	411c                	lw	a5,0(a0)
	return z_impl_k_stack_alloc_init((struct k_stack *)stack, num_entries);
}
#endif

void k_stack_cleanup(struct k_stack *stack)
{
8000363a:	1141                	addi	sp,sp,-16
8000363c:	c422                	sw	s0,8(sp)
8000363e:	c606                	sw	ra,12(sp)
80003640:	c226                	sw	s1,4(sp)
80003642:	842a                	mv	s0,a0
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003644:	02f50963          	beq	a0,a5,80003676 <k_stack_cleanup+0x3e>
	__ASSERT_NO_MSG(z_waitq_head(&stack->wait_q) == NULL);
80003648:	c79d                	beqz	a5,80003676 <k_stack_cleanup+0x3e>
8000364a:	800054b7          	lui	s1,0x80005
8000364e:	800055b7          	lui	a1,0x80005
80003652:	80005537          	lui	a0,0x80005
80003656:	4c058593          	addi	a1,a1,1216 # 800054c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054c1>
8000365a:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000365e:	05a00693          	li	a3,90
80003662:	4ac48613          	addi	a2,s1,1196 # 800054ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054ad>
80003666:	b58fe0ef          	jal	ra,800019be <printk>
8000366a:	05a00593          	li	a1,90
8000366e:	4ac48513          	addi	a0,s1,1196
80003672:	b6afe0ef          	jal	ra,800019dc <assert_post_action>

	if ((stack->flags & K_STACK_FLAG_ALLOC) != (u8_t)0) {
80003676:	01844783          	lbu	a5,24(s0)
8000367a:	8b85                	andi	a5,a5,1
8000367c:	cb99                	beqz	a5,80003692 <k_stack_cleanup+0x5a>
		k_free(stack->base);
8000367e:	4448                	lw	a0,12(s0)
80003680:	0be010ef          	jal	ra,8000473e <k_free>
		stack->base = NULL;
		stack->flags &= ~K_STACK_FLAG_ALLOC;
80003684:	01844783          	lbu	a5,24(s0)
		stack->base = NULL;
80003688:	00042623          	sw	zero,12(s0)
		stack->flags &= ~K_STACK_FLAG_ALLOC;
8000368c:	9bf9                	andi	a5,a5,-2
8000368e:	00f40c23          	sb	a5,24(s0)
	}
}
80003692:	40b2                	lw	ra,12(sp)
80003694:	4422                	lw	s0,8(sp)
80003696:	4492                	lw	s1,4(sp)
80003698:	0141                	addi	sp,sp,16
8000369a:	8082                	ret

8000369c <z_impl_k_stack_push>:
void z_impl_k_stack_push(struct k_stack *stack, u32_t data)
{
	struct k_thread *first_pending_thread;
	k_spinlock_key_t key;

	__ASSERT(stack->next != stack->top, "stack is full");
8000369c:	4918                	lw	a4,16(a0)
8000369e:	495c                	lw	a5,20(a0)
{
800036a0:	1101                	addi	sp,sp,-32
800036a2:	ca26                	sw	s1,20(sp)
800036a4:	c452                	sw	s4,8(sp)
800036a6:	ce06                	sw	ra,28(sp)
800036a8:	cc22                	sw	s0,24(sp)
800036aa:	c84a                	sw	s2,16(sp)
800036ac:	c64e                	sw	s3,12(sp)
800036ae:	84aa                	mv	s1,a0
800036b0:	8a2e                	mv	s4,a1
	__ASSERT(stack->next != stack->top, "stack is full");
800036b2:	02f71e63          	bne	a4,a5,800036ee <z_impl_k_stack_push+0x52>
800036b6:	80005437          	lui	s0,0x80005
800036ba:	800055b7          	lui	a1,0x80005
800036be:	80005537          	lui	a0,0x80005
800036c2:	4ec58593          	addi	a1,a1,1260 # 800054ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054ed>
800036c6:	06800693          	li	a3,104
800036ca:	4ac40613          	addi	a2,s0,1196 # 800054ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054ad>
800036ce:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800036d2:	aecfe0ef          	jal	ra,800019be <printk>
800036d6:	80005537          	lui	a0,0x80005
800036da:	50850513          	addi	a0,a0,1288 # 80005508 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005509>
800036de:	ae0fe0ef          	jal	ra,800019be <printk>
800036e2:	06800593          	li	a1,104
800036e6:	4ac40513          	addi	a0,s0,1196
800036ea:	af2fe0ef          	jal	ra,800019dc <assert_post_action>

	key = k_spin_lock(&stack->lock);
800036ee:	00848993          	addi	s3,s1,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
800036f2:	4421                	li	s0,8
800036f4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800036f8:	854e                	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
800036fa:	8821                	andi	s0,s0,8
800036fc:	2cc1                	jal	800039cc <z_spin_lock_valid>
800036fe:	ed0d                	bnez	a0,80003738 <z_impl_k_stack_push+0x9c>
80003700:	80005937          	lui	s2,0x80005
80003704:	800055b7          	lui	a1,0x80005
80003708:	80005537          	lui	a0,0x80005
8000370c:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80003710:	04e00693          	li	a3,78
80003714:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003718:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000371c:	aa2fe0ef          	jal	ra,800019be <printk>
80003720:	80005537          	lui	a0,0x80005
80003724:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003728:	a96fe0ef          	jal	ra,800019be <printk>
8000372c:	04e00593          	li	a1,78
80003730:	12c90513          	addi	a0,s2,300
80003734:	aa8fe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003738:	854e                	mv	a0,s3
8000373a:	24f9                	jal	80003a08 <z_spin_lock_set_owner>

	first_pending_thread = z_unpend_first_thread(&stack->wait_q);
8000373c:	8526                	mv	a0,s1
8000373e:	a19ff0ef          	jal	ra,80003156 <z_unpend_first_thread>
80003742:	892a                	mv	s2,a0

	if (first_pending_thread != NULL) {
80003744:	c905                	beqz	a0,80003774 <z_impl_k_stack_push+0xd8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003746:	00d54783          	lbu	a5,13(a0)
8000374a:	8bfd                	andi	a5,a5,31
8000374c:	e789                	bnez	a5,80003756 <z_impl_k_stack_push+0xba>
	if (z_is_thread_ready(thread)) {
8000374e:	4d1c                	lw	a5,24(a0)
80003750:	e399                	bnez	a5,80003756 <z_impl_k_stack_push+0xba>
		z_add_thread_to_ready_q(thread);
80003752:	ba8ff0ef          	jal	ra,80002afa <z_add_thread_to_ready_q>
		z_ready_thread(first_pending_thread);

		z_set_thread_return_value_with_data(first_pending_thread,
						   0, (void *)data);
		z_reschedule(&stack->lock, key);
80003756:	85a2                	mv	a1,s0
		*(stack->next) = data;
		stack->next++;
		k_spin_unlock(&stack->lock, key);
	}

}
80003758:	4462                	lw	s0,24(sp)
	thread->base.swap_data = data;
8000375a:	01492a23          	sw	s4,20(s2)
8000375e:	06092623          	sw	zero,108(s2)
80003762:	40f2                	lw	ra,28(sp)
80003764:	44d2                	lw	s1,20(sp)
80003766:	4942                	lw	s2,16(sp)
80003768:	4a22                	lw	s4,8(sp)
		z_reschedule(&stack->lock, key);
8000376a:	854e                	mv	a0,s3
}
8000376c:	49b2                	lw	s3,12(sp)
8000376e:	6105                	addi	sp,sp,32
		z_reschedule(&stack->lock, key);
80003770:	e41fe06f          	j	800025b0 <z_reschedule>
		*(stack->next) = data;
80003774:	489c                	lw	a5,16(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003776:	854e                	mv	a0,s3
80003778:	0147a023          	sw	s4,0(a5)
		stack->next++;
8000377c:	0791                	addi	a5,a5,4
8000377e:	c89c                	sw	a5,16(s1)
80003780:	249d                	jal	800039e6 <z_spin_unlock_valid>
80003782:	ed0d                	bnez	a0,800037bc <z_impl_k_stack_push+0x120>
80003784:	800054b7          	lui	s1,0x80005
80003788:	800055b7          	lui	a1,0x80005
8000378c:	80005537          	lui	a0,0x80005
80003790:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003794:	06100693          	li	a3,97
80003798:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000379c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800037a0:	a1efe0ef          	jal	ra,800019be <printk>
800037a4:	80005537          	lui	a0,0x80005
800037a8:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800037ac:	a12fe0ef          	jal	ra,800019be <printk>
800037b0:	06100593          	li	a1,97
800037b4:	12c48513          	addi	a0,s1,300
800037b8:	a24fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037bc:	30042473          	csrrs	s0,mstatus,s0
}
800037c0:	40f2                	lw	ra,28(sp)
800037c2:	4462                	lw	s0,24(sp)
800037c4:	44d2                	lw	s1,20(sp)
800037c6:	4942                	lw	s2,16(sp)
800037c8:	49b2                	lw	s3,12(sp)
800037ca:	4a22                	lw	s4,8(sp)
800037cc:	6105                	addi	sp,sp,32
800037ce:	8082                	ret

800037d0 <z_impl_k_stack_pop>:
	return 0;
}
#endif

int z_impl_k_stack_pop(struct k_stack *stack, u32_t *data, s32_t timeout)
{
800037d0:	1101                	addi	sp,sp,-32
800037d2:	cc22                	sw	s0,24(sp)
800037d4:	ca26                	sw	s1,20(sp)
800037d6:	c84a                	sw	s2,16(sp)
800037d8:	c64e                	sw	s3,12(sp)
800037da:	c452                	sw	s4,8(sp)
800037dc:	ce06                	sw	ra,28(sp)
800037de:	c256                	sw	s5,4(sp)
800037e0:	892a                	mv	s2,a0
800037e2:	89ae                	mv	s3,a1
800037e4:	8a32                	mv	s4,a2
	k_spinlock_key_t key;
	int result;

	key = k_spin_lock(&stack->lock);
800037e6:	00850493          	addi	s1,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
800037ea:	4421                	li	s0,8
800037ec:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800037f0:	8526                	mv	a0,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800037f2:	8821                	andi	s0,s0,8
800037f4:	2ae1                	jal	800039cc <z_spin_lock_valid>
800037f6:	ed0d                	bnez	a0,80003830 <z_impl_k_stack_pop+0x60>
800037f8:	80005ab7          	lui	s5,0x80005
800037fc:	800055b7          	lui	a1,0x80005
80003800:	80005537          	lui	a0,0x80005
80003804:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80003808:	04e00693          	li	a3,78
8000380c:	12ca8613          	addi	a2,s5,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003810:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003814:	9aafe0ef          	jal	ra,800019be <printk>
80003818:	80005537          	lui	a0,0x80005
8000381c:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003820:	99efe0ef          	jal	ra,800019be <printk>
80003824:	04e00593          	li	a1,78
80003828:	12ca8513          	addi	a0,s5,300
8000382c:	9b0fe0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003830:	8526                	mv	a0,s1
80003832:	2ad9                	jal	80003a08 <z_spin_lock_set_owner>

	if (likely(stack->next > stack->base)) {
80003834:	01092783          	lw	a5,16(s2)
80003838:	00c92703          	lw	a4,12(s2)
8000383c:	04f77d63          	bgeu	a4,a5,80003896 <z_impl_k_stack_pop+0xc6>
		stack->next--;
80003840:	ffc78713          	addi	a4,a5,-4
		*data = *(stack->next);
80003844:	ffc7a783          	lw	a5,-4(a5)
		stack->next--;
80003848:	00e92823          	sw	a4,16(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000384c:	8526                	mv	a0,s1
		*data = *(stack->next);
8000384e:	00f9a023          	sw	a5,0(s3)
80003852:	2a51                	jal	800039e6 <z_spin_unlock_valid>
80003854:	ed0d                	bnez	a0,8000388e <z_impl_k_stack_pop+0xbe>
80003856:	800054b7          	lui	s1,0x80005
8000385a:	800055b7          	lui	a1,0x80005
8000385e:	80005537          	lui	a0,0x80005
80003862:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003866:	06100693          	li	a3,97
8000386a:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000386e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003872:	94cfe0ef          	jal	ra,800019be <printk>
80003876:	80005537          	lui	a0,0x80005
8000387a:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
8000387e:	940fe0ef          	jal	ra,800019be <printk>
80003882:	06100593          	li	a1,97
80003886:	12c48513          	addi	a0,s1,300
8000388a:	952fe0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000388e:	30042473          	csrrs	s0,mstatus,s0
	if (result == -EAGAIN) {
		return -EAGAIN;
	}

	*data = (u32_t)_current->base.swap_data;
	return 0;
80003892:	4501                	li	a0,0
80003894:	a0a9                	j	800038de <z_impl_k_stack_pop+0x10e>
	if (timeout == K_NO_WAIT) {
80003896:	040a1d63          	bnez	s4,800038f0 <z_impl_k_stack_pop+0x120>
8000389a:	8526                	mv	a0,s1
8000389c:	22a9                	jal	800039e6 <z_spin_unlock_valid>
8000389e:	ed0d                	bnez	a0,800038d8 <z_impl_k_stack_pop+0x108>
800038a0:	800054b7          	lui	s1,0x80005
800038a4:	800055b7          	lui	a1,0x80005
800038a8:	80005537          	lui	a0,0x80005
800038ac:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800038b0:	06100693          	li	a3,97
800038b4:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800038b8:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800038bc:	902fe0ef          	jal	ra,800019be <printk>
800038c0:	80005537          	lui	a0,0x80005
800038c4:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800038c8:	8f6fe0ef          	jal	ra,800019be <printk>
800038cc:	06100593          	li	a1,97
800038d0:	12c48513          	addi	a0,s1,300
800038d4:	908fe0ef          	jal	ra,800019dc <assert_post_action>
800038d8:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800038dc:	5541                	li	a0,-16
}
800038de:	40f2                	lw	ra,28(sp)
800038e0:	4462                	lw	s0,24(sp)
800038e2:	44d2                	lw	s1,20(sp)
800038e4:	4942                	lw	s2,16(sp)
800038e6:	49b2                	lw	s3,12(sp)
800038e8:	4a22                	lw	s4,8(sp)
800038ea:	4a92                	lw	s5,4(sp)
800038ec:	6105                	addi	sp,sp,32
800038ee:	8082                	ret
	result = z_pend_curr(&stack->lock, key, &stack->wait_q, timeout);
800038f0:	86d2                	mv	a3,s4
800038f2:	864a                	mv	a2,s2
800038f4:	85a2                	mv	a1,s0
800038f6:	8526                	mv	a0,s1
800038f8:	ff6ff0ef          	jal	ra,800030ee <z_pend_curr>
	if (result == -EAGAIN) {
800038fc:	57d5                	li	a5,-11
800038fe:	fef500e3          	beq	a0,a5,800038de <z_impl_k_stack_pop+0x10e>
	*data = (u32_t)_current->base.swap_data;
80003902:	800067b7          	lui	a5,0x80006
80003906:	af47a783          	lw	a5,-1292(a5) # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
8000390a:	4bdc                	lw	a5,20(a5)
8000390c:	00f9a023          	sw	a5,0(s3)
80003910:	b749                	j	80003892 <z_impl_k_stack_pop+0xc2>

80003912 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003912:	00d54783          	lbu	a5,13(a0)
80003916:	8bfd                	andi	a5,a5,31
80003918:	e789                	bnez	a5,80003922 <z_is_thread_ready+0x10>
8000391a:	4d08                	lw	a0,24(a0)
8000391c:	00153513          	seqz	a0,a0
80003920:	8082                	ret
80003922:	4501                	li	a0,0
}
80003924:	8082                	ret

80003926 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80003926:	800067b7          	lui	a5,0x80006
8000392a:	aec7a503          	lw	a0,-1300(a5) # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
}
8000392e:	00a03533          	snez	a0,a0
80003932:	8082                	ret

80003934 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80003934:	800067b7          	lui	a5,0x80006
80003938:	af47a783          	lw	a5,-1292(a5) # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
8000393c:	00c7c503          	lbu	a0,12(a5)
}
80003940:	8905                	andi	a0,a0,1
80003942:	8082                	ret

80003944 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80003944:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003946:	5302                	lw	t1,32(sp)
{
80003948:	cc22                	sw	s0,24(sp)
8000394a:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000394c:	c01a                	sw	t1,0(sp)
{
8000394e:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003950:	de8fd0ef          	jal	ra,80000f38 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80003954:	800067b7          	lui	a5,0x80006
80003958:	af47a783          	lw	a5,-1292(a5) # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
	sys_trace_thread_create(new_thread);
}
8000395c:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
8000395e:	57bc                	lw	a5,104(a5)
80003960:	d43c                	sw	a5,104(s0)
}
80003962:	4462                	lw	s0,24(sp)
80003964:	6105                	addi	sp,sp,32
80003966:	8082                	ret

80003968 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80003968:	513c                	lw	a5,96(a0)
{
8000396a:	1141                	addi	sp,sp,-16
8000396c:	c422                	sw	s0,8(sp)
8000396e:	c606                	sw	ra,12(sp)
80003970:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
80003972:	c391                	beqz	a5,80003976 <z_thread_single_abort+0xe>
		thread->fn_abort();
80003974:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80003976:	8522                	mv	a0,s0
80003978:	f9bff0ef          	jal	ra,80003912 <z_is_thread_ready>
8000397c:	cd11                	beqz	a0,80003998 <z_thread_single_abort+0x30>
		z_remove_thread_from_ready_q(thread);
8000397e:	8522                	mv	a0,s0
80003980:	d90ff0ef          	jal	ra,80002f10 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80003984:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80003988:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
8000398a:	0087e793          	ori	a5,a5,8
8000398e:	00f406a3          	sb	a5,13(s0)
}
80003992:	4422                	lw	s0,8(sp)
80003994:	0141                	addi	sp,sp,16
80003996:	8082                	ret
		if (z_is_thread_pending(thread)) {
80003998:	00d44783          	lbu	a5,13(s0)
8000399c:	8b89                	andi	a5,a5,2
8000399e:	c781                	beqz	a5,800039a6 <z_thread_single_abort+0x3e>
			z_unpend_thread_no_timeout(thread);
800039a0:	8522                	mv	a0,s0
800039a2:	b3ffe0ef          	jal	ra,800024e0 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
800039a6:	4c1c                	lw	a5,24(s0)
800039a8:	dff1                	beqz	a5,80003984 <z_thread_single_abort+0x1c>
800039aa:	01840513          	addi	a0,s0,24
800039ae:	2b6d                	jal	80003f68 <z_abort_timeout>
800039b0:	bfd1                	j	80003984 <z_thread_single_abort+0x1c>

800039b2 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800039b2:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800039b6:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800039ba:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
800039be:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800039c2:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800039c6:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800039ca:	8082                	ret

800039cc <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800039cc:	4108                	lw	a0,0(a0)
800039ce:	c911                	beqz	a0,800039e2 <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800039d0:	800067b7          	lui	a5,0x80006
800039d4:	b007c783          	lbu	a5,-1280(a5) # 80005b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b01>
800039d8:	890d                	andi	a0,a0,3
800039da:	8d1d                	sub	a0,a0,a5
800039dc:	00a03533          	snez	a0,a0
800039e0:	8082                	ret
			return false;
		}
	}
	return true;
800039e2:	4505                	li	a0,1
}
800039e4:	8082                	ret

800039e6 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800039e6:	800067b7          	lui	a5,0x80006
800039ea:	aec78793          	addi	a5,a5,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
800039ee:	0147c703          	lbu	a4,20(a5)
800039f2:	479c                	lw	a5,8(a5)
800039f4:	8fd9                	or	a5,a5,a4
800039f6:	4118                	lw	a4,0(a0)
800039f8:	00f71663          	bne	a4,a5,80003a04 <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
800039fc:	00052023          	sw	zero,0(a0)
	return true;
80003a00:	4505                	li	a0,1
80003a02:	8082                	ret
		return false;
80003a04:	4501                	li	a0,0
}
80003a06:	8082                	ret

80003a08 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80003a08:	800067b7          	lui	a5,0x80006
80003a0c:	aec78793          	addi	a5,a5,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80003a10:	0147c703          	lbu	a4,20(a5)
80003a14:	479c                	lw	a5,8(a5)
80003a16:	8fd9                	or	a5,a5,a4
80003a18:	c11c                	sw	a5,0(a0)
}
80003a1a:	8082                	ret

80003a1c <z_impl_k_thread_start>:
{
80003a1c:	1101                	addi	sp,sp,-32
80003a1e:	cc22                	sw	s0,24(sp)
80003a20:	c84a                	sw	s2,16(sp)
80003a22:	ce06                	sw	ra,28(sp)
80003a24:	ca26                	sw	s1,20(sp)
80003a26:	c64e                	sw	s3,12(sp)
80003a28:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a2a:	4421                	li	s0,8
80003a2c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a30:	800054b7          	lui	s1,0x80005
80003a34:	7d048513          	addi	a0,s1,2000 # 800057d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a38:	8821                	andi	s0,s0,8
80003a3a:	f93ff0ef          	jal	ra,800039cc <z_spin_lock_valid>
80003a3e:	ed0d                	bnez	a0,80003a78 <z_impl_k_thread_start+0x5c>
80003a40:	800059b7          	lui	s3,0x80005
80003a44:	800055b7          	lui	a1,0x80005
80003a48:	80005537          	lui	a0,0x80005
80003a4c:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80003a50:	04e00693          	li	a3,78
80003a54:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003a58:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003a5c:	f63fd0ef          	jal	ra,800019be <printk>
80003a60:	80005537          	lui	a0,0x80005
80003a64:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003a68:	f57fd0ef          	jal	ra,800019be <printk>
80003a6c:	04e00593          	li	a1,78
80003a70:	12c98513          	addi	a0,s3,300
80003a74:	f69fd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003a78:	7d048513          	addi	a0,s1,2000
80003a7c:	f8dff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80003a80:	00d94783          	lbu	a5,13(s2)
80003a84:	0047f713          	andi	a4,a5,4
80003a88:	eb39                	bnez	a4,80003ade <z_impl_k_thread_start+0xc2>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a8a:	7d048513          	addi	a0,s1,2000
80003a8e:	f59ff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80003a92:	ed0d                	bnez	a0,80003acc <z_impl_k_thread_start+0xb0>
80003a94:	800054b7          	lui	s1,0x80005
80003a98:	800055b7          	lui	a1,0x80005
80003a9c:	80005537          	lui	a0,0x80005
80003aa0:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003aa4:	06100693          	li	a3,97
80003aa8:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003aac:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003ab0:	f0ffd0ef          	jal	ra,800019be <printk>
80003ab4:	80005537          	lui	a0,0x80005
80003ab8:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80003abc:	f03fd0ef          	jal	ra,800019be <printk>
80003ac0:	06100593          	li	a1,97
80003ac4:	12c48513          	addi	a0,s1,300
80003ac8:	f15fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003acc:	30042473          	csrrs	s0,mstatus,s0
}
80003ad0:	40f2                	lw	ra,28(sp)
80003ad2:	4462                	lw	s0,24(sp)
80003ad4:	44d2                	lw	s1,20(sp)
80003ad6:	4942                	lw	s2,16(sp)
80003ad8:	49b2                	lw	s3,12(sp)
80003ada:	6105                	addi	sp,sp,32
80003adc:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003ade:	9bed                	andi	a5,a5,-5
80003ae0:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80003ae4:	854a                	mv	a0,s2
80003ae6:	e2dff0ef          	jal	ra,80003912 <z_is_thread_ready>
80003aea:	c501                	beqz	a0,80003af2 <z_impl_k_thread_start+0xd6>
		z_add_thread_to_ready_q(thread);
80003aec:	854a                	mv	a0,s2
80003aee:	80cff0ef          	jal	ra,80002afa <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80003af2:	85a2                	mv	a1,s0
}
80003af4:	4462                	lw	s0,24(sp)
80003af6:	40f2                	lw	ra,28(sp)
80003af8:	4942                	lw	s2,16(sp)
80003afa:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003afc:	7d048513          	addi	a0,s1,2000
}
80003b00:	44d2                	lw	s1,20(sp)
80003b02:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003b04:	aadfe06f          	j	800025b0 <z_reschedule>

80003b08 <schedule_new_thread>:
	if (delay == 0) {
80003b08:	e199                	bnez	a1,80003b0e <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80003b0a:	f13ff06f          	j	80003a1c <z_impl_k_thread_start>
{
80003b0e:	1141                	addi	sp,sp,-16
80003b10:	c422                	sw	s0,8(sp)
80003b12:	842a                	mv	s0,a0
80003b14:	852e                	mv	a0,a1
80003b16:	0525                	addi	a0,a0,9
80003b18:	45a9                	li	a1,10
80003b1a:	c606                	sw	ra,12(sp)
80003b1c:	d35fc0ef          	jal	ra,80000850 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003b20:	00150613          	addi	a2,a0,1
80003b24:	01840513          	addi	a0,s0,24
}
80003b28:	4422                	lw	s0,8(sp)
80003b2a:	40b2                	lw	ra,12(sp)
80003b2c:	800035b7          	lui	a1,0x80003
80003b30:	c4458593          	addi	a1,a1,-956 # 80002c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002c45>
80003b34:	0141                	addi	sp,sp,16
80003b36:	a4ad                	j	80003da0 <z_add_timeout>

80003b38 <z_impl_k_thread_create>:
{
80003b38:	7139                	addi	sp,sp,-64
80003b3a:	d256                	sw	s5,36(sp)
80003b3c:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003b3e:	800066b7          	lui	a3,0x80006
80003b42:	aec6a683          	lw	a3,-1300(a3) # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
{
80003b46:	dc22                	sw	s0,56(sp)
80003b48:	da26                	sw	s1,52(sp)
80003b4a:	d64e                	sw	s3,44(sp)
80003b4c:	d452                	sw	s4,40(sp)
80003b4e:	de06                	sw	ra,60(sp)
80003b50:	d84a                	sw	s2,48(sp)
80003b52:	842a                	mv	s0,a0
80003b54:	89ae                	mv	s3,a1
80003b56:	8a32                	mv	s4,a2
80003b58:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003b5a:	c6a9                	beqz	a3,80003ba4 <z_impl_k_thread_create+0x6c>
80003b5c:	80005937          	lui	s2,0x80005
80003b60:	800055b7          	lui	a1,0x80005
80003b64:	80005537          	lui	a0,0x80005
80003b68:	1b200693          	li	a3,434
80003b6c:	51890613          	addi	a2,s2,1304 # 80005518 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005519>
80003b70:	33c58593          	addi	a1,a1,828 # 8000533c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000533d>
80003b74:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003b78:	ce46                	sw	a7,28(sp)
80003b7a:	cc42                	sw	a6,24(sp)
80003b7c:	ca3e                	sw	a5,20(sp)
80003b7e:	c83a                	sw	a4,16(sp)
80003b80:	e3ffd0ef          	jal	ra,800019be <printk>
80003b84:	80005537          	lui	a0,0x80005
80003b88:	52c50513          	addi	a0,a0,1324 # 8000552c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000552d>
80003b8c:	e33fd0ef          	jal	ra,800019be <printk>
80003b90:	1b200593          	li	a1,434
80003b94:	51890513          	addi	a0,s2,1304
80003b98:	e45fd0ef          	jal	ra,800019dc <assert_post_action>
80003b9c:	48f2                	lw	a7,28(sp)
80003b9e:	4862                	lw	a6,24(sp)
80003ba0:	47d2                	lw	a5,20(sp)
80003ba2:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003ba4:	4686                	lw	a3,64(sp)
80003ba6:	c202                	sw	zero,4(sp)
80003ba8:	8652                	mv	a2,s4
80003baa:	c036                	sw	a3,0(sp)
80003bac:	85ce                	mv	a1,s3
80003bae:	86d6                	mv	a3,s5
80003bb0:	8522                	mv	a0,s0
80003bb2:	d93ff0ef          	jal	ra,80003944 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80003bb6:	57fd                	li	a5,-1
80003bb8:	00f48663          	beq	s1,a5,80003bc4 <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
80003bbc:	85a6                	mv	a1,s1
80003bbe:	8522                	mv	a0,s0
80003bc0:	f49ff0ef          	jal	ra,80003b08 <schedule_new_thread>
}
80003bc4:	8522                	mv	a0,s0
80003bc6:	50f2                	lw	ra,60(sp)
80003bc8:	5462                	lw	s0,56(sp)
80003bca:	54d2                	lw	s1,52(sp)
80003bcc:	5942                	lw	s2,48(sp)
80003bce:	59b2                	lw	s3,44(sp)
80003bd0:	5a22                	lw	s4,40(sp)
80003bd2:	5a92                	lw	s5,36(sp)
80003bd4:	6121                	addi	sp,sp,64
80003bd6:	8082                	ret

80003bd8 <z_init_static_threads>:
{
80003bd8:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80003bda:	800057b7          	lui	a5,0x80005
{
80003bde:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003be0:	80005937          	lui	s2,0x80005
{
80003be4:	cc22                	sw	s0,24(sp)
80003be6:	ca26                	sw	s1,20(sp)
80003be8:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003bea:	72878413          	addi	s0,a5,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
80003bee:	72878493          	addi	s1,a5,1832
80003bf2:	72890913          	addi	s2,s2,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
80003bf6:	01246f63          	bltu	s0,s2,80003c14 <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
80003bfa:	8426                	mv	s0,s1
	k_sched_lock();
80003bfc:	a85fe0ef          	jal	ra,80002680 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80003c00:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80003c02:	03246e63          	bltu	s0,s2,80003c3e <z_init_static_threads+0x66>
}
80003c06:	4462                	lw	s0,24(sp)
80003c08:	40f2                	lw	ra,28(sp)
80003c0a:	44d2                	lw	s1,20(sp)
80003c0c:	4942                	lw	s2,16(sp)
80003c0e:	6105                	addi	sp,sp,32
	k_sched_unlock();
80003c10:	d97fe06f          	j	800029a6 <k_sched_unlock>
		z_setup_new_thread(
80003c14:	545c                	lw	a5,44(s0)
80003c16:	c23e                	sw	a5,4(sp)
80003c18:	501c                	lw	a5,32(s0)
80003c1a:	c03e                	sw	a5,0(sp)
80003c1c:	485c                	lw	a5,20(s0)
80003c1e:	01c42883          	lw	a7,28(s0)
80003c22:	01842803          	lw	a6,24(s0)
80003c26:	4818                	lw	a4,16(s0)
80003c28:	4454                	lw	a3,12(s0)
80003c2a:	4410                	lw	a2,8(s0)
80003c2c:	404c                	lw	a1,4(s0)
80003c2e:	4008                	lw	a0,0(s0)
80003c30:	d15ff0ef          	jal	ra,80003944 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80003c34:	401c                	lw	a5,0(s0)
80003c36:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80003c38:	03040413          	addi	s0,s0,48
80003c3c:	bf6d                	j	80003bf6 <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
80003c3e:	504c                	lw	a1,36(s0)
80003c40:	00958563          	beq	a1,s1,80003c4a <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
80003c44:	4008                	lw	a0,0(s0)
80003c46:	ec3ff0ef          	jal	ra,80003b08 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80003c4a:	03040413          	addi	s0,s0,48
80003c4e:	bf55                	j	80003c02 <z_init_static_threads+0x2a>

80003c50 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80003c50:	1101                	addi	sp,sp,-32
80003c52:	cc22                	sw	s0,24(sp)
80003c54:	ca26                	sw	s1,20(sp)
80003c56:	ce06                	sw	ra,28(sp)
80003c58:	c84a                	sw	s2,16(sp)
80003c5a:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80003c5c:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c5e:	4421                	li	s0,8
80003c60:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c64:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003c66:	8821                	andi	s0,s0,8
80003c68:	d65ff0ef          	jal	ra,800039cc <z_spin_lock_valid>
80003c6c:	ed0d                	bnez	a0,80003ca6 <z_impl_k_thread_abort+0x56>
80003c6e:	80005937          	lui	s2,0x80005
80003c72:	800055b7          	lui	a1,0x80005
80003c76:	80005537          	lui	a0,0x80005
80003c7a:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80003c7e:	04e00693          	li	a3,78
80003c82:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003c86:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003c8a:	d35fd0ef          	jal	ra,800019be <printk>
80003c8e:	80005537          	lui	a0,0x80005
80003c92:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003c96:	d29fd0ef          	jal	ra,800019be <printk>
80003c9a:	04e00593          	li	a1,78
80003c9e:	12c90513          	addi	a0,s2,300
80003ca2:	d3bfd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003ca6:	0068                	addi	a0,sp,12
80003ca8:	d61ff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80003cac:	00c4c783          	lbu	a5,12(s1)
80003cb0:	8b85                	andi	a5,a5,1
80003cb2:	cf8d                	beqz	a5,80003cec <z_impl_k_thread_abort+0x9c>
80003cb4:	80005937          	lui	s2,0x80005
80003cb8:	800055b7          	lui	a1,0x80005
80003cbc:	80005537          	lui	a0,0x80005
80003cc0:	56c58593          	addi	a1,a1,1388 # 8000556c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000556d>
80003cc4:	02900693          	li	a3,41
80003cc8:	55490613          	addi	a2,s2,1364 # 80005554 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005555>
80003ccc:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003cd0:	ceffd0ef          	jal	ra,800019be <printk>
80003cd4:	80005537          	lui	a0,0x80005
80003cd8:	5a050513          	addi	a0,a0,1440 # 800055a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055a1>
80003cdc:	ce3fd0ef          	jal	ra,800019be <printk>
80003ce0:	02900593          	li	a1,41
80003ce4:	55490513          	addi	a0,s2,1364
80003ce8:	cf5fd0ef          	jal	ra,800019dc <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80003cec:	8526                	mv	a0,s1
80003cee:	c7bff0ef          	jal	ra,80003968 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80003cf2:	85a2                	mv	a1,s0
80003cf4:	0068                	addi	a0,sp,12
80003cf6:	8bbfe0ef          	jal	ra,800025b0 <z_reschedule>
}
80003cfa:	40f2                	lw	ra,28(sp)
80003cfc:	4462                	lw	s0,24(sp)
80003cfe:	44d2                	lw	s1,20(sp)
80003d00:	4942                	lw	s2,16(sp)
80003d02:	6105                	addi	sp,sp,32
80003d04:	8082                	ret

80003d06 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80003d06:	800057b7          	lui	a5,0x80005
80003d0a:	7d47a783          	lw	a5,2004(a5) # 800057d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d5>
80003d0e:	e399                	bnez	a5,80003d14 <elapsed+0xe>
80003d10:	828fe06f          	j	80001d38 <z_clock_elapsed>
}
80003d14:	4501                	li	a0,0
80003d16:	8082                	ret

80003d18 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80003d18:	411c                	lw	a5,0(a0)
80003d1a:	cd01                	beqz	a0,80003d32 <remove_timeout+0x1a>
80003d1c:	80005737          	lui	a4,0x80005
	return (node == list->tail) ? NULL : node->next;
80003d20:	6ec72703          	lw	a4,1772(a4) # 800056ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056ed>
80003d24:	00e50763          	beq	a0,a4,80003d32 <remove_timeout+0x1a>
	if (next(t) != NULL) {
80003d28:	c789                	beqz	a5,80003d32 <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
80003d2a:	4798                	lw	a4,8(a5)
80003d2c:	4514                	lw	a3,8(a0)
80003d2e:	9736                	add	a4,a4,a3
80003d30:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
80003d32:	4158                	lw	a4,4(a0)
80003d34:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80003d36:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80003d38:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80003d3c:	00052223          	sw	zero,4(a0)
}
80003d40:	8082                	ret

80003d42 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003d42:	800057b7          	lui	a5,0x80005
80003d46:	7e07c783          	lbu	a5,2016(a5) # 800057e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e1>
{
80003d4a:	1141                	addi	sp,sp,-16
80003d4c:	c606                	sw	ra,12(sp)
80003d4e:	c422                	sw	s0,8(sp)
80003d50:	c226                	sw	s1,4(sp)
80003d52:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003d54:	e789                	bnez	a5,80003d5e <next_timeout+0x1c>
80003d56:	80000537          	lui	a0,0x80000
80003d5a:	fff54513          	not	a0,a0
	return list->head == list;
80003d5e:	800057b7          	lui	a5,0x80005
80003d62:	6e878793          	addi	a5,a5,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003d66:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003d68:	00f40f63          	beq	s0,a5,80003d86 <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80003d6c:	cc09                	beqz	s0,80003d86 <next_timeout+0x44>
80003d6e:	4404                	lw	s1,8(s0)
80003d70:	f97ff0ef          	jal	ra,80003d06 <elapsed>
80003d74:	8c89                	sub	s1,s1,a0
80003d76:	4501                	li	a0,0
80003d78:	0004c763          	bltz	s1,80003d86 <next_timeout+0x44>
80003d7c:	4400                	lw	s0,8(s0)
80003d7e:	f89ff0ef          	jal	ra,80003d06 <elapsed>
80003d82:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80003d86:	800067b7          	lui	a5,0x80006
80003d8a:	afc7a783          	lw	a5,-1284(a5) # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
80003d8e:	c781                	beqz	a5,80003d96 <next_timeout+0x54>
80003d90:	00a7d363          	bge	a5,a0,80003d96 <next_timeout+0x54>
80003d94:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80003d96:	40b2                	lw	ra,12(sp)
80003d98:	4422                	lw	s0,8(sp)
80003d9a:	4492                	lw	s1,4(sp)
80003d9c:	0141                	addi	sp,sp,16
80003d9e:	8082                	ret

80003da0 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003da0:	411c                	lw	a5,0(a0)
{
80003da2:	7179                	addi	sp,sp,-48
80003da4:	d422                	sw	s0,40(sp)
80003da6:	d226                	sw	s1,36(sp)
80003da8:	ce4e                	sw	s3,28(sp)
80003daa:	d606                	sw	ra,44(sp)
80003dac:	d04a                	sw	s2,32(sp)
80003dae:	cc52                	sw	s4,24(sp)
80003db0:	ca56                	sw	s5,20(sp)
80003db2:	c85a                	sw	s6,16(sp)
80003db4:	c65e                	sw	s7,12(sp)
80003db6:	c462                	sw	s8,8(sp)
80003db8:	842a                	mv	s0,a0
80003dba:	89ae                	mv	s3,a1
80003dbc:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003dbe:	cf8d                	beqz	a5,80003df8 <z_add_timeout+0x58>
80003dc0:	80005937          	lui	s2,0x80005
80003dc4:	800055b7          	lui	a1,0x80005
80003dc8:	80005537          	lui	a0,0x80005
80003dcc:	5d058593          	addi	a1,a1,1488 # 800055d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055d1>
80003dd0:	04d00693          	li	a3,77
80003dd4:	5bc90613          	addi	a2,s2,1468 # 800055bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055bd>
80003dd8:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003ddc:	be3fd0ef          	jal	ra,800019be <printk>
80003de0:	80005537          	lui	a0,0x80005
80003de4:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
80003de8:	bd7fd0ef          	jal	ra,800019be <printk>
80003dec:	04d00593          	li	a1,77
80003df0:	5bc90513          	addi	a0,s2,1468
80003df4:	be9fd0ef          	jal	ra,800019dc <assert_post_action>
	to->fn = fn;
80003df8:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80003dfc:	00904363          	bgtz	s1,80003e02 <z_add_timeout+0x62>
80003e00:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e02:	49a1                	li	s3,8
80003e04:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e08:	80005a37          	lui	s4,0x80005
80003e0c:	7d8a0513          	addi	a0,s4,2008 # 800057d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e10:	0089f993          	andi	s3,s3,8
80003e14:	bb9ff0ef          	jal	ra,800039cc <z_spin_lock_valid>
80003e18:	ed0d                	bnez	a0,80003e52 <z_add_timeout+0xb2>
80003e1a:	80005937          	lui	s2,0x80005
80003e1e:	800055b7          	lui	a1,0x80005
80003e22:	80005537          	lui	a0,0x80005
80003e26:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80003e2a:	04e00693          	li	a3,78
80003e2e:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003e32:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003e36:	b89fd0ef          	jal	ra,800019be <printk>
80003e3a:	80005537          	lui	a0,0x80005
80003e3e:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003e42:	b7dfd0ef          	jal	ra,800019be <printk>
80003e46:	04e00593          	li	a1,78
80003e4a:	12c90513          	addi	a0,s2,300
80003e4e:	b8ffd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003e52:	7d8a0513          	addi	a0,s4,2008
80003e56:	bb3ff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80003e5a:	eadff0ef          	jal	ra,80003d06 <elapsed>
80003e5e:	9526                	add	a0,a0,s1
	return list->head == list;
80003e60:	800054b7          	lui	s1,0x80005
80003e64:	6e84a903          	lw	s2,1768(s1) # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003e68:	c408                	sw	a0,8(s0)
80003e6a:	6e848493          	addi	s1,s1,1768
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e6e:	00990c63          	beq	s2,s1,80003e86 <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80003e72:	80005ab7          	lui	s5,0x80005
80003e76:	80005b37          	lui	s6,0x80005
80003e7a:	80005bb7          	lui	s7,0x80005
80003e7e:	80005c37          	lui	s8,0x80005
		for (t = first(); t != NULL; t = next(t)) {
80003e82:	00091963          	bnez	s2,80003e94 <z_add_timeout+0xf4>
	node->prev = list->tail;
80003e86:	40dc                	lw	a5,4(s1)
	node->next = list;
80003e88:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003e8a:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003e8c:	40dc                	lw	a5,4(s1)
80003e8e:	c380                	sw	s0,0(a5)
	list->tail = node;
80003e90:	c0c0                	sw	s0,4(s1)
80003e92:	a891                	j	80003ee6 <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
80003e94:	00892783          	lw	a5,8(s2)
80003e98:	0207d663          	bgez	a5,80003ec4 <z_add_timeout+0x124>
80003e9c:	5f0b0593          	addi	a1,s6,1520 # 800055f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055f1>
80003ea0:	05600693          	li	a3,86
80003ea4:	5bca8613          	addi	a2,s5,1468 # 800055bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055bd>
80003ea8:	060b8513          	addi	a0,s7,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003eac:	b13fd0ef          	jal	ra,800019be <printk>
80003eb0:	0e4c0513          	addi	a0,s8,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
80003eb4:	b0bfd0ef          	jal	ra,800019be <printk>
80003eb8:	05600593          	li	a1,86
80003ebc:	5bca8513          	addi	a0,s5,1468
80003ec0:	b1dfd0ef          	jal	ra,800019dc <assert_post_action>

			if (t->dticks > to->dticks) {
80003ec4:	00892703          	lw	a4,8(s2)
80003ec8:	441c                	lw	a5,8(s0)
80003eca:	08e7d763          	bge	a5,a4,80003f58 <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
80003ece:	40f707b3          	sub	a5,a4,a5
80003ed2:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80003ed6:	00492783          	lw	a5,4(s2)
	node->next = successor;
80003eda:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80003ede:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
80003ee0:	c380                	sw	s0,0(a5)
	successor->prev = node;
80003ee2:	00892223          	sw	s0,4(s2)
	return list->head == list;
80003ee6:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003ee8:	00978963          	beq	a5,s1,80003efa <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80003eec:	00f41763          	bne	s0,a5,80003efa <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
80003ef0:	e53ff0ef          	jal	ra,80003d42 <next_timeout>
80003ef4:	4581                	li	a1,0
80003ef6:	cf7fd0ef          	jal	ra,80001bec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003efa:	7d8a0513          	addi	a0,s4,2008
80003efe:	ae9ff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80003f02:	ed0d                	bnez	a0,80003f3c <z_add_timeout+0x19c>
80003f04:	80005437          	lui	s0,0x80005
80003f08:	800055b7          	lui	a1,0x80005
80003f0c:	80005537          	lui	a0,0x80005
80003f10:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003f14:	06100693          	li	a3,97
80003f18:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003f1c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003f20:	a9ffd0ef          	jal	ra,800019be <printk>
80003f24:	80005537          	lui	a0,0x80005
80003f28:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80003f2c:	a93fd0ef          	jal	ra,800019be <printk>
80003f30:	06100593          	li	a1,97
80003f34:	12c40513          	addi	a0,s0,300
80003f38:	aa5fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f3c:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80003f40:	50b2                	lw	ra,44(sp)
80003f42:	5422                	lw	s0,40(sp)
80003f44:	5492                	lw	s1,36(sp)
80003f46:	5902                	lw	s2,32(sp)
80003f48:	49f2                	lw	s3,28(sp)
80003f4a:	4a62                	lw	s4,24(sp)
80003f4c:	4ad2                	lw	s5,20(sp)
80003f4e:	4b42                	lw	s6,16(sp)
80003f50:	4bb2                	lw	s7,12(sp)
80003f52:	4c22                	lw	s8,8(sp)
80003f54:	6145                	addi	sp,sp,48
80003f56:	8082                	ret
			to->dticks -= t->dticks;
80003f58:	8f99                	sub	a5,a5,a4
80003f5a:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80003f5c:	40dc                	lw	a5,4(s1)
80003f5e:	f32784e3          	beq	a5,s2,80003e86 <z_add_timeout+0xe6>
80003f62:	00092903          	lw	s2,0(s2)
80003f66:	bf31                	j	80003e82 <z_add_timeout+0xe2>

80003f68 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80003f68:	1101                	addi	sp,sp,-32
80003f6a:	cc22                	sw	s0,24(sp)
80003f6c:	c64e                	sw	s3,12(sp)
80003f6e:	ce06                	sw	ra,28(sp)
80003f70:	ca26                	sw	s1,20(sp)
80003f72:	c84a                	sw	s2,16(sp)
80003f74:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f76:	4421                	li	s0,8
80003f78:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f7c:	800054b7          	lui	s1,0x80005
80003f80:	7d848513          	addi	a0,s1,2008 # 800057d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f84:	8821                	andi	s0,s0,8
80003f86:	a47ff0ef          	jal	ra,800039cc <z_spin_lock_valid>
80003f8a:	ed0d                	bnez	a0,80003fc4 <z_abort_timeout+0x5c>
80003f8c:	80005937          	lui	s2,0x80005
80003f90:	800055b7          	lui	a1,0x80005
80003f94:	80005537          	lui	a0,0x80005
80003f98:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80003f9c:	04e00693          	li	a3,78
80003fa0:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003fa4:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80003fa8:	a17fd0ef          	jal	ra,800019be <printk>
80003fac:	80005537          	lui	a0,0x80005
80003fb0:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003fb4:	a0bfd0ef          	jal	ra,800019be <printk>
80003fb8:	04e00593          	li	a1,78
80003fbc:	12c90513          	addi	a0,s2,300
80003fc0:	a1dfd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
80003fc4:	7d848513          	addi	a0,s1,2008
80003fc8:	a41ff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80003fcc:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80003fd0:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80003fd2:	c789                	beqz	a5,80003fdc <z_abort_timeout+0x74>
			remove_timeout(to);
80003fd4:	854e                	mv	a0,s3
80003fd6:	d43ff0ef          	jal	ra,80003d18 <remove_timeout>
			ret = 0;
80003fda:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003fdc:	7d848513          	addi	a0,s1,2008
80003fe0:	a07ff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80003fe4:	ed0d                	bnez	a0,8000401e <z_abort_timeout+0xb6>
80003fe6:	800054b7          	lui	s1,0x80005
80003fea:	800055b7          	lui	a1,0x80005
80003fee:	80005537          	lui	a0,0x80005
80003ff2:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80003ff6:	06100693          	li	a3,97
80003ffa:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003ffe:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80004002:	9bdfd0ef          	jal	ra,800019be <printk>
80004006:	80005537          	lui	a0,0x80005
8000400a:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
8000400e:	9b1fd0ef          	jal	ra,800019be <printk>
80004012:	06100593          	li	a1,97
80004016:	12c48513          	addi	a0,s1,300
8000401a:	9c3fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000401e:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004022:	40f2                	lw	ra,28(sp)
80004024:	4462                	lw	s0,24(sp)
80004026:	854a                	mv	a0,s2
80004028:	44d2                	lw	s1,20(sp)
8000402a:	4942                	lw	s2,16(sp)
8000402c:	49b2                	lw	s3,12(sp)
8000402e:	6105                	addi	sp,sp,32
80004030:	8082                	ret

80004032 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004032:	1141                	addi	sp,sp,-16
80004034:	c422                	sw	s0,8(sp)
80004036:	c606                	sw	ra,12(sp)
80004038:	c226                	sw	s1,4(sp)
8000403a:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000403c:	4421                	li	s0,8
8000403e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004042:	800054b7          	lui	s1,0x80005
80004046:	7d848513          	addi	a0,s1,2008 # 800057d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d9>
	key = (mstatus & SOC_MSTATUS_IEN);
8000404a:	8821                	andi	s0,s0,8
8000404c:	981ff0ef          	jal	ra,800039cc <z_spin_lock_valid>
80004050:	ed0d                	bnez	a0,8000408a <z_get_next_timeout_expiry+0x58>
80004052:	80005937          	lui	s2,0x80005
80004056:	800055b7          	lui	a1,0x80005
8000405a:	80005537          	lui	a0,0x80005
8000405e:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80004062:	04e00693          	li	a3,78
80004066:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000406a:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000406e:	951fd0ef          	jal	ra,800019be <printk>
80004072:	80005537          	lui	a0,0x80005
80004076:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
8000407a:	945fd0ef          	jal	ra,800019be <printk>
8000407e:	04e00593          	li	a1,78
80004082:	12c90513          	addi	a0,s2,300
80004086:	957fd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
8000408a:	7d848513          	addi	a0,s1,2008
8000408e:	97bff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004092:	cb1ff0ef          	jal	ra,80003d42 <next_timeout>
80004096:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004098:	7d848513          	addi	a0,s1,2008
8000409c:	94bff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
800040a0:	ed0d                	bnez	a0,800040da <z_get_next_timeout_expiry+0xa8>
800040a2:	800054b7          	lui	s1,0x80005
800040a6:	800055b7          	lui	a1,0x80005
800040aa:	80005537          	lui	a0,0x80005
800040ae:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800040b2:	06100693          	li	a3,97
800040b6:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800040ba:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800040be:	901fd0ef          	jal	ra,800019be <printk>
800040c2:	80005537          	lui	a0,0x80005
800040c6:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800040ca:	8f5fd0ef          	jal	ra,800019be <printk>
800040ce:	06100593          	li	a1,97
800040d2:	12c48513          	addi	a0,s1,300
800040d6:	907fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800040da:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800040de:	40b2                	lw	ra,12(sp)
800040e0:	4422                	lw	s0,8(sp)
800040e2:	854a                	mv	a0,s2
800040e4:	4492                	lw	s1,4(sp)
800040e6:	4902                	lw	s2,0(sp)
800040e8:	0141                	addi	sp,sp,16
800040ea:	8082                	ret

800040ec <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
800040ec:	1101                	addi	sp,sp,-32
800040ee:	cc22                	sw	s0,24(sp)
800040f0:	c84a                	sw	s2,16(sp)
800040f2:	c452                	sw	s4,8(sp)
800040f4:	ce06                	sw	ra,28(sp)
800040f6:	ca26                	sw	s1,20(sp)
800040f8:	c64e                	sw	s3,12(sp)
800040fa:	892a                	mv	s2,a0
800040fc:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040fe:	4421                	li	s0,8
80004100:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004104:	800054b7          	lui	s1,0x80005
80004108:	7d848513          	addi	a0,s1,2008 # 800057d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d9>
	key = (mstatus & SOC_MSTATUS_IEN);
8000410c:	8821                	andi	s0,s0,8
8000410e:	8bfff0ef          	jal	ra,800039cc <z_spin_lock_valid>
80004112:	ed0d                	bnez	a0,8000414c <z_set_timeout_expiry+0x60>
80004114:	800059b7          	lui	s3,0x80005
80004118:	800055b7          	lui	a1,0x80005
8000411c:	80005537          	lui	a0,0x80005
80004120:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80004124:	04e00693          	li	a3,78
80004128:	12c98613          	addi	a2,s3,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000412c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80004130:	88ffd0ef          	jal	ra,800019be <printk>
80004134:	80005537          	lui	a0,0x80005
80004138:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
8000413c:	883fd0ef          	jal	ra,800019be <printk>
80004140:	04e00593          	li	a1,78
80004144:	12c98513          	addi	a0,s3,300
80004148:	895fd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
8000414c:	7d848513          	addi	a0,s1,2008
80004150:	8b9ff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004154:	befff0ef          	jal	ra,80003d42 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004158:	00a95963          	bge	s2,a0,8000416a <z_set_timeout_expiry+0x7e>
8000415c:	4785                	li	a5,1
8000415e:	00a7d663          	bge	a5,a0,8000416a <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
80004162:	85d2                	mv	a1,s4
80004164:	854a                	mv	a0,s2
80004166:	a87fd0ef          	jal	ra,80001bec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000416a:	7d848513          	addi	a0,s1,2008
8000416e:	879ff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80004172:	ed0d                	bnez	a0,800041ac <z_set_timeout_expiry+0xc0>
80004174:	800054b7          	lui	s1,0x80005
80004178:	800055b7          	lui	a1,0x80005
8000417c:	80005537          	lui	a0,0x80005
80004180:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80004184:	06100693          	li	a3,97
80004188:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000418c:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80004190:	82ffd0ef          	jal	ra,800019be <printk>
80004194:	80005537          	lui	a0,0x80005
80004198:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
8000419c:	823fd0ef          	jal	ra,800019be <printk>
800041a0:	06100593          	li	a1,97
800041a4:	12c48513          	addi	a0,s1,300
800041a8:	835fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800041ac:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800041b0:	40f2                	lw	ra,28(sp)
800041b2:	4462                	lw	s0,24(sp)
800041b4:	44d2                	lw	s1,20(sp)
800041b6:	4942                	lw	s2,16(sp)
800041b8:	49b2                	lw	s3,12(sp)
800041ba:	4a22                	lw	s4,8(sp)
800041bc:	6105                	addi	sp,sp,32
800041be:	8082                	ret

800041c0 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
800041c0:	7179                	addi	sp,sp,-48
800041c2:	d422                	sw	s0,40(sp)
800041c4:	cc52                	sw	s4,24(sp)
800041c6:	d606                	sw	ra,44(sp)
800041c8:	d226                	sw	s1,36(sp)
800041ca:	d04a                	sw	s2,32(sp)
800041cc:	ce4e                	sw	s3,28(sp)
800041ce:	ca56                	sw	s5,20(sp)
800041d0:	c85a                	sw	s6,16(sp)
800041d2:	c65e                	sw	s7,12(sp)
800041d4:	c462                	sw	s8,8(sp)
800041d6:	c266                	sw	s9,4(sp)
800041d8:	c06a                	sw	s10,0(sp)
800041da:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041dc:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
800041de:	cd5fe0ef          	jal	ra,80002eb2 <z_time_slice>
800041e2:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800041e6:	80005937          	lui	s2,0x80005
800041ea:	7d890513          	addi	a0,s2,2008 # 800057d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d9>
	key = (mstatus & SOC_MSTATUS_IEN);
800041ee:	8821                	andi	s0,s0,8
800041f0:	fdcff0ef          	jal	ra,800039cc <z_spin_lock_valid>
800041f4:	ed0d                	bnez	a0,8000422e <z_clock_announce+0x6e>
800041f6:	800054b7          	lui	s1,0x80005
800041fa:	800055b7          	lui	a1,0x80005
800041fe:	80005537          	lui	a0,0x80005
80004202:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80004206:	04e00693          	li	a3,78
8000420a:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000420e:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80004212:	facfd0ef          	jal	ra,800019be <printk>
80004216:	80005537          	lui	a0,0x80005
8000421a:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
8000421e:	fa0fd0ef          	jal	ra,800019be <printk>
80004222:	04e00593          	li	a1,78
80004226:	12c48513          	addi	a0,s1,300
8000422a:	fb2fd0ef          	jal	ra,800019dc <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
8000422e:	800059b7          	lui	s3,0x80005
	z_spin_lock_set_owner(l);
80004232:	7d890513          	addi	a0,s2,2008
80004236:	fd2ff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
8000423a:	800054b7          	lui	s1,0x80005
8000423e:	7d49aa23          	sw	s4,2004(s3) # 800057d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d5>
	return list->head == list;
80004242:	80005a37          	lui	s4,0x80005
80004246:	7d498993          	addi	s3,s3,2004
8000424a:	6e8a0a13          	addi	s4,s4,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000424e:	79848493          	addi	s1,s1,1944 # 80005798 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005799>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004252:	80005ab7          	lui	s5,0x80005
80004256:	80005bb7          	lui	s7,0x80005
8000425a:	80005b37          	lui	s6,0x80005
8000425e:	80005c37          	lui	s8,0x80005
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004262:	80005cb7          	lui	s9,0x80005
80004266:	000a2d03          	lw	s10,0(s4)
8000426a:	0009a783          	lw	a5,0(s3)
8000426e:	4094                	lw	a3,0(s1)
80004270:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004272:	014d0b63          	beq	s10,s4,80004288 <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80004276:	000d0963          	beqz	s10,80004288 <z_clock_announce+0xc8>
8000427a:	008d2703          	lw	a4,8(s10)
8000427e:	08e7d663          	bge	a5,a4,8000430a <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80004282:	8f1d                	sub	a4,a4,a5
80004284:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80004288:	96be                	add	a3,a3,a5
8000428a:	41f7d713          	srai	a4,a5,0x1f
8000428e:	972a                	add	a4,a4,a0
80004290:	00f6b7b3          	sltu	a5,a3,a5
80004294:	97ba                	add	a5,a5,a4
80004296:	c094                	sw	a3,0(s1)
80004298:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
8000429a:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
8000429e:	aa5ff0ef          	jal	ra,80003d42 <next_timeout>
800042a2:	4581                	li	a1,0
800042a4:	949fd0ef          	jal	ra,80001bec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800042a8:	7d890513          	addi	a0,s2,2008
800042ac:	f3aff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
800042b0:	ed0d                	bnez	a0,800042ea <z_clock_announce+0x12a>
800042b2:	800054b7          	lui	s1,0x80005
800042b6:	800055b7          	lui	a1,0x80005
800042ba:	80005537          	lui	a0,0x80005
800042be:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800042c2:	06100693          	li	a3,97
800042c6:	12c48613          	addi	a2,s1,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800042ca:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800042ce:	ef0fd0ef          	jal	ra,800019be <printk>
800042d2:	80005537          	lui	a0,0x80005
800042d6:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800042da:	ee4fd0ef          	jal	ra,800019be <printk>
800042de:	06100593          	li	a1,97
800042e2:	12c48513          	addi	a0,s1,300
800042e6:	ef6fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042ea:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800042ee:	50b2                	lw	ra,44(sp)
800042f0:	5422                	lw	s0,40(sp)
800042f2:	5492                	lw	s1,36(sp)
800042f4:	5902                	lw	s2,32(sp)
800042f6:	49f2                	lw	s3,28(sp)
800042f8:	4a62                	lw	s4,24(sp)
800042fa:	4ad2                	lw	s5,20(sp)
800042fc:	4b42                	lw	s6,16(sp)
800042fe:	4bb2                	lw	s7,12(sp)
80004300:	4c22                	lw	s8,8(sp)
80004302:	4c92                	lw	s9,4(sp)
80004304:	4d02                	lw	s10,0(sp)
80004306:	6145                	addi	sp,sp,48
80004308:	8082                	ret
		curr_tick += dt;
8000430a:	96ba                	add	a3,a3,a4
8000430c:	41f75593          	srai	a1,a4,0x1f
80004310:	95aa                	add	a1,a1,a0
80004312:	00e6b633          	sltu	a2,a3,a4
80004316:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
80004318:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
8000431a:	856a                	mv	a0,s10
		t->dticks = 0;
8000431c:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80004320:	c094                	sw	a3,0(s1)
80004322:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
80004324:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80004328:	9f1ff0ef          	jal	ra,80003d18 <remove_timeout>
8000432c:	7d890513          	addi	a0,s2,2008
80004330:	eb6ff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80004334:	e50d                	bnez	a0,8000435e <z_clock_announce+0x19e>
80004336:	174b8593          	addi	a1,s7,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
8000433a:	06100693          	li	a3,97
8000433e:	12ca8613          	addi	a2,s5,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80004342:	060b0513          	addi	a0,s6,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80004346:	e78fd0ef          	jal	ra,800019be <printk>
8000434a:	18cc0513          	addi	a0,s8,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
8000434e:	e70fd0ef          	jal	ra,800019be <printk>
80004352:	06100593          	li	a1,97
80004356:	12ca8513          	addi	a0,s5,300
8000435a:	e82fd0ef          	jal	ra,800019dc <assert_post_action>
8000435e:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80004362:	00cd2783          	lw	a5,12(s10)
80004366:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004368:	4421                	li	s0,8
8000436a:	9782                	jalr	a5
8000436c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004370:	7d890513          	addi	a0,s2,2008
	key = (mstatus & SOC_MSTATUS_IEN);
80004374:	8821                	andi	s0,s0,8
80004376:	e56ff0ef          	jal	ra,800039cc <z_spin_lock_valid>
8000437a:	e51d                	bnez	a0,800043a8 <z_clock_announce+0x1e8>
8000437c:	144c8593          	addi	a1,s9,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80004380:	04e00693          	li	a3,78
80004384:	12ca8613          	addi	a2,s5,300
80004388:	060b0513          	addi	a0,s6,96
8000438c:	e32fd0ef          	jal	ra,800019be <printk>
80004390:	80005537          	lui	a0,0x80005
80004394:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80004398:	e26fd0ef          	jal	ra,800019be <printk>
8000439c:	04e00593          	li	a1,78
800043a0:	12ca8513          	addi	a0,s5,300
800043a4:	e38fd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
800043a8:	7d890513          	addi	a0,s2,2008
800043ac:	e5cff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	return k;
800043b0:	bd5d                	j	80004266 <z_clock_announce+0xa6>

800043b2 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
800043b2:	1101                	addi	sp,sp,-32
800043b4:	ca26                	sw	s1,20(sp)
800043b6:	ce06                	sw	ra,28(sp)
800043b8:	cc22                	sw	s0,24(sp)
800043ba:	c84a                	sw	s2,16(sp)
800043bc:	c64e                	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800043be:	44a1                	li	s1,8
800043c0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800043c4:	80005937          	lui	s2,0x80005
800043c8:	7d890513          	addi	a0,s2,2008 # 800057d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d9>
	key = (mstatus & SOC_MSTATUS_IEN);
800043cc:	88a1                	andi	s1,s1,8
800043ce:	dfeff0ef          	jal	ra,800039cc <z_spin_lock_valid>
800043d2:	ed0d                	bnez	a0,8000440c <z_tick_get+0x5a>
800043d4:	80005437          	lui	s0,0x80005
800043d8:	800055b7          	lui	a1,0x80005
800043dc:	80005537          	lui	a0,0x80005
800043e0:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
800043e4:	04e00693          	li	a3,78
800043e8:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800043ec:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800043f0:	dcefd0ef          	jal	ra,800019be <printk>
800043f4:	80005537          	lui	a0,0x80005
800043f8:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
800043fc:	dc2fd0ef          	jal	ra,800019be <printk>
80004400:	04e00593          	li	a1,78
80004404:	12c40513          	addi	a0,s0,300
80004408:	dd4fd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
8000440c:	7d890513          	addi	a0,s2,2008
80004410:	df8ff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80004414:	925fd0ef          	jal	ra,80001d38 <z_clock_elapsed>
80004418:	800057b7          	lui	a5,0x80005
8000441c:	79878793          	addi	a5,a5,1944 # 80005798 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005799>
80004420:	0007a983          	lw	s3,0(a5)
80004424:	43c0                	lw	s0,4(a5)
80004426:	99aa                	add	s3,s3,a0
80004428:	00a9b533          	sltu	a0,s3,a0
8000442c:	942a                	add	s0,s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000442e:	7d890513          	addi	a0,s2,2008
80004432:	db4ff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
80004436:	ed0d                	bnez	a0,80004470 <z_tick_get+0xbe>
80004438:	80005937          	lui	s2,0x80005
8000443c:	800055b7          	lui	a1,0x80005
80004440:	80005537          	lui	a0,0x80005
80004444:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
80004448:	06100693          	li	a3,97
8000444c:	12c90613          	addi	a2,s2,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80004450:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
80004454:	d6afd0ef          	jal	ra,800019be <printk>
80004458:	80005537          	lui	a0,0x80005
8000445c:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80004460:	d5efd0ef          	jal	ra,800019be <printk>
80004464:	06100593          	li	a1,97
80004468:	12c90513          	addi	a0,s2,300
8000446c:	d70fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004470:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80004474:	85a2                	mv	a1,s0
80004476:	40f2                	lw	ra,28(sp)
80004478:	4462                	lw	s0,24(sp)
8000447a:	854e                	mv	a0,s3
8000447c:	44d2                	lw	s1,20(sp)
8000447e:	4942                	lw	s2,16(sp)
80004480:	49b2                	lw	s3,12(sp)
80004482:	6105                	addi	sp,sp,32
80004484:	8082                	ret

80004486 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80004486:	1141                	addi	sp,sp,-16
80004488:	c422                	sw	s0,8(sp)
8000448a:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000448c:	80005437          	lui	s0,0x80005
80004490:	800054b7          	lui	s1,0x80005
{
80004494:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004496:	72840413          	addi	s0,s0,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
8000449a:	74448493          	addi	s1,s1,1860 # 80005744 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005745>
8000449e:	00946863          	bltu	s0,s1,800044ae <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
800044a2:	40b2                	lw	ra,12(sp)
800044a4:	4422                	lw	s0,8(sp)
800044a6:	4492                	lw	s1,4(sp)
800044a8:	4501                	li	a0,0
800044aa:	0141                	addi	sp,sp,16
800044ac:	8082                	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
800044ae:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
800044b2:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
800044b4:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
800044b6:	cc1c                	sw	a5,24(s0)
800044b8:	bc1fc0ef          	jal	ra,80001078 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800044bc:	0471                	addi	s0,s0,28
800044be:	b7c5                	j	8000449e <init_static_pools+0x18>

800044c0 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800044c0:	800067b7          	lui	a5,0x80006
800044c4:	aec7a783          	lw	a5,-1300(a5) # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
{
800044c8:	715d                	addi	sp,sp,-80
800044ca:	c4a2                	sw	s0,72(sp)
800044cc:	c2a6                	sw	s1,68(sp)
800044ce:	de4e                	sw	s3,60(sp)
800044d0:	d85a                	sw	s6,48(sp)
800044d2:	c686                	sw	ra,76(sp)
800044d4:	c0ca                	sw	s2,64(sp)
800044d6:	dc52                	sw	s4,56(sp)
800044d8:	da56                	sw	s5,52(sp)
800044da:	d65e                	sw	s7,44(sp)
800044dc:	d462                	sw	s8,40(sp)
800044de:	d266                	sw	s9,36(sp)
800044e0:	d06a                	sw	s10,32(sp)
800044e2:	ce6e                	sw	s11,28(sp)
800044e4:	89aa                	mv	s3,a0
800044e6:	84ae                	mv	s1,a1
800044e8:	8b32                	mv	s6,a2
800044ea:	8436                	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800044ec:	10078063          	beqz	a5,800045ec <k_mem_pool_alloc+0x12c>
800044f0:	e2f1                	bnez	a3,800045b4 <k_mem_pool_alloc+0xf4>
	s64_t end = 0;
800044f2:	4901                	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
800044f4:	80005537          	lui	a0,0x80005
800044f8:	72850513          	addi	a0,a0,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
800044fc:	40a98533          	sub	a0,s3,a0
80004500:	b6db75b7          	lui	a1,0xb6db7
80004504:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
80004508:	8509                	srai	a0,a0,0x2
8000450a:	b22fc0ef          	jal	ra,8000082c <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
8000450e:	7a7d                	lui	s4,0xfffff
		block->id.block = block_num;
80004510:	6a85                	lui	s5,0x1
		block->id.pool = pool_id(p);
80004512:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80004516:	5bd5                	li	s7,-11
			ret = -ENOMEM;
80004518:	5cd1                	li	s9,-12
		block->id.level = level_num;
8000451a:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
8000451e:	1afd                	addi	s5,s5,-1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004520:	4d21                	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80004522:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80004526:	8726                	mv	a4,s1
80004528:	0074                	addi	a3,sp,12
8000452a:	0030                	addi	a2,sp,8
8000452c:	85da                	mv	a1,s6
8000452e:	854e                	mv	a0,s3
80004530:	c11fc0ef          	jal	ra,80001140 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80004534:	01751c63          	bne	a0,s7,8000454c <k_mem_pool_alloc+0x8c>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80004538:	8726                	mv	a4,s1
8000453a:	0074                	addi	a3,sp,12
8000453c:	0030                	addi	a2,sp,8
8000453e:	85da                	mv	a1,s6
80004540:	854e                	mv	a0,s3
80004542:	bfffc0ef          	jal	ra,80001140 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80004546:	01751363          	bne	a0,s7,8000454c <k_mem_pool_alloc+0x8c>
			ret = -ENOMEM;
8000454a:	5551                	li	a0,-12
		block->id.level = level_num;
8000454c:	47a2                	lw	a5,8(sp)
		block->id.pool = pool_id(p);
8000454e:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
80004552:	8bbd                	andi	a5,a5,15
80004554:	00879713          	slli	a4,a5,0x8
80004558:	40dc                	lw	a5,4(s1)
8000455a:	0147f7b3          	and	a5,a5,s4
8000455e:	8fd9                	or	a5,a5,a4
		block->id.block = block_num;
80004560:	4732                	lw	a4,12(sp)
80004562:	0157f7b3          	and	a5,a5,s5
80004566:	0732                	slli	a4,a4,0xc
80004568:	8fd9                	or	a5,a5,a4
8000456a:	c0dc                	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
8000456c:	c50d                	beqz	a0,80004596 <k_mem_pool_alloc+0xd6>
8000456e:	c405                	beqz	s0,80004596 <k_mem_pool_alloc+0xd6>
80004570:	03951363          	bne	a0,s9,80004596 <k_mem_pool_alloc+0xd6>
80004574:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80004578:	8622                	mv	a2,s0
8000457a:	85ee                	mv	a1,s11
8000457c:	8921                	andi	a0,a0,8
8000457e:	b53fe0ef          	jal	ra,800030d0 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80004582:	57fd                	li	a5,-1
80004584:	faf401e3          	beq	s0,a5,80004526 <k_mem_pool_alloc+0x66>
			timeout = end - z_tick_get();
80004588:	e2bff0ef          	jal	ra,800043b2 <z_tick_get>
8000458c:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
80004590:	f8045be3          	bgez	s0,80004526 <k_mem_pool_alloc+0x66>
				break;
			}
		}
	}

	return -EAGAIN;
80004594:	5555                	li	a0,-11
}
80004596:	40b6                	lw	ra,76(sp)
80004598:	4426                	lw	s0,72(sp)
8000459a:	4496                	lw	s1,68(sp)
8000459c:	4906                	lw	s2,64(sp)
8000459e:	59f2                	lw	s3,60(sp)
800045a0:	5a62                	lw	s4,56(sp)
800045a2:	5ad2                	lw	s5,52(sp)
800045a4:	5b42                	lw	s6,48(sp)
800045a6:	5bb2                	lw	s7,44(sp)
800045a8:	5c22                	lw	s8,40(sp)
800045aa:	5c92                	lw	s9,36(sp)
800045ac:	5d02                	lw	s10,32(sp)
800045ae:	4df2                	lw	s11,28(sp)
800045b0:	6161                	addi	sp,sp,80
800045b2:	8082                	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800045b4:	80005937          	lui	s2,0x80005
800045b8:	800055b7          	lui	a1,0x80005
800045bc:	80005537          	lui	a0,0x80005
800045c0:	61458593          	addi	a1,a1,1556 # 80005614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005615>
800045c4:	03900693          	li	a3,57
800045c8:	60090613          	addi	a2,s2,1536 # 80005600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005601>
800045cc:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800045d0:	beefd0ef          	jal	ra,800019be <printk>
800045d4:	80005537          	lui	a0,0x80005
800045d8:	0e450513          	addi	a0,a0,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
800045dc:	be2fd0ef          	jal	ra,800019be <printk>
800045e0:	03900593          	li	a1,57
800045e4:	60090513          	addi	a0,s2,1536
800045e8:	bf4fd0ef          	jal	ra,800019dc <assert_post_action>
	if (timeout > 0) {
800045ec:	f08053e3          	blez	s0,800044f2 <k_mem_pool_alloc+0x32>
		end = z_tick_get() + z_ms_to_ticks(timeout);
800045f0:	dc3ff0ef          	jal	ra,800043b2 <z_tick_get>
800045f4:	892a                	mv	s2,a0
800045f6:	45a9                	li	a1,10
800045f8:	00940513          	addi	a0,s0,9
800045fc:	a54fc0ef          	jal	ra,80000850 <__divsi3>
80004600:	992a                	add	s2,s2,a0
80004602:	bdcd                	j	800044f4 <k_mem_pool_alloc+0x34>

80004604 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80004604:	00054783          	lbu	a5,0(a0)
{
80004608:	1101                	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
8000460a:	4110                	lw	a2,0(a0)
{
8000460c:	cc22                	sw	s0,24(sp)
8000460e:	00379413          	slli	s0,a5,0x3
80004612:	c84a                	sw	s2,16(sp)
80004614:	8c1d                	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80004616:	80005937          	lui	s2,0x80005
8000461a:	040a                	slli	s0,s0,0x2
8000461c:	00865593          	srli	a1,a2,0x8
80004620:	72890513          	addi	a0,s2,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
80004624:	8231                	srli	a2,a2,0xc
80004626:	89bd                	andi	a1,a1,15
80004628:	9522                	add	a0,a0,s0
{
8000462a:	ce06                	sw	ra,28(sp)
8000462c:	ca26                	sw	s1,20(sp)
8000462e:	c64e                	sw	s3,12(sp)
80004630:	c452                	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80004632:	d1ffc0ef          	jal	ra,80001350 <z_sys_mem_pool_block_free>
80004636:	45a1                	li	a1,8
80004638:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000463c:	800054b7          	lui	s1,0x80005
80004640:	7dc48513          	addi	a0,s1,2012 # 800057dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057dd>
	key = (mstatus & SOC_MSTATUS_IEN);
80004644:	0085f993          	andi	s3,a1,8
80004648:	b84ff0ef          	jal	ra,800039cc <z_spin_lock_valid>
8000464c:	72890913          	addi	s2,s2,1832
80004650:	ed0d                	bnez	a0,8000468a <k_mem_pool_free_id+0x86>
80004652:	80005a37          	lui	s4,0x80005
80004656:	800055b7          	lui	a1,0x80005
8000465a:	80005537          	lui	a0,0x80005
8000465e:	14458593          	addi	a1,a1,324 # 80005144 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005145>
80004662:	04e00693          	li	a3,78
80004666:	12ca0613          	addi	a2,s4,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
8000466a:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
8000466e:	b50fd0ef          	jal	ra,800019be <printk>
80004672:	80005537          	lui	a0,0x80005
80004676:	15c50513          	addi	a0,a0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
8000467a:	b44fd0ef          	jal	ra,800019be <printk>
8000467e:	04e00593          	li	a1,78
80004682:	12ca0513          	addi	a0,s4,300
80004686:	b56fd0ef          	jal	ra,800019dc <assert_post_action>
	z_spin_lock_set_owner(l);
8000468a:	7dc48513          	addi	a0,s1,2012
8000468e:	b7aff0ef          	jal	ra,80003a08 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80004692:	01440513          	addi	a0,s0,20
80004696:	954a                	add	a0,a0,s2
80004698:	c43fe0ef          	jal	ra,800032da <z_unpend_all>

	if (need_sched != 0) {
8000469c:	cd09                	beqz	a0,800046b6 <k_mem_pool_free_id+0xb2>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
8000469e:	4462                	lw	s0,24(sp)
800046a0:	40f2                	lw	ra,28(sp)
800046a2:	4942                	lw	s2,16(sp)
800046a4:	4a22                	lw	s4,8(sp)
		z_reschedule(&lock, key);
800046a6:	85ce                	mv	a1,s3
800046a8:	7dc48513          	addi	a0,s1,2012
}
800046ac:	49b2                	lw	s3,12(sp)
800046ae:	44d2                	lw	s1,20(sp)
800046b0:	6105                	addi	sp,sp,32
		z_reschedule(&lock, key);
800046b2:	efffd06f          	j	800025b0 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800046b6:	7dc48513          	addi	a0,s1,2012
800046ba:	b2cff0ef          	jal	ra,800039e6 <z_spin_unlock_valid>
800046be:	ed0d                	bnez	a0,800046f8 <k_mem_pool_free_id+0xf4>
800046c0:	80005437          	lui	s0,0x80005
800046c4:	800055b7          	lui	a1,0x80005
800046c8:	80005537          	lui	a0,0x80005
800046cc:	17458593          	addi	a1,a1,372 # 80005174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005175>
800046d0:	06100693          	li	a3,97
800046d4:	12c40613          	addi	a2,s0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
800046d8:	06050513          	addi	a0,a0,96 # 80005060 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005061>
800046dc:	ae2fd0ef          	jal	ra,800019be <printk>
800046e0:	80005537          	lui	a0,0x80005
800046e4:	18c50513          	addi	a0,a0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
800046e8:	ad6fd0ef          	jal	ra,800019be <printk>
800046ec:	06100593          	li	a1,97
800046f0:	12c40513          	addi	a0,s0,300
800046f4:	ae8fd0ef          	jal	ra,800019dc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800046f8:	3009a5f3          	csrrs	a1,mstatus,s3
}
800046fc:	40f2                	lw	ra,28(sp)
800046fe:	4462                	lw	s0,24(sp)
80004700:	44d2                	lw	s1,20(sp)
80004702:	4942                	lw	s2,16(sp)
80004704:	49b2                	lw	s3,12(sp)
80004706:	4a22                	lw	s4,8(sp)
80004708:	6105                	addi	sp,sp,32
8000470a:	8082                	ret

8000470c <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
8000470c:	00458613          	addi	a2,a1,4
80004710:	00b67863          	bgeu	a2,a1,80004720 <k_mem_pool_malloc+0x14>
				   &size)) {
		return NULL;
80004714:	4501                	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
80004716:	8082                	ret
		return NULL;
80004718:	4501                	li	a0,0
}
8000471a:	40f2                	lw	ra,28(sp)
8000471c:	6105                	addi	sp,sp,32
8000471e:	8082                	ret
{
80004720:	1101                	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80004722:	4681                	li	a3,0
80004724:	002c                	addi	a1,sp,8
{
80004726:	ce06                	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80004728:	d99ff0ef          	jal	ra,800044c0 <k_mem_pool_alloc>
8000472c:	f575                	bnez	a0,80004718 <k_mem_pool_malloc+0xc>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
8000472e:	4522                	lw	a0,8(sp)
80004730:	4611                	li	a2,4
80004732:	006c                	addi	a1,sp,12
80004734:	edefd0ef          	jal	ra,80001e12 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80004738:	4522                	lw	a0,8(sp)
8000473a:	0511                	addi	a0,a0,4
8000473c:	bff9                	j	8000471a <k_mem_pool_malloc+0xe>

8000473e <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
8000473e:	c501                	beqz	a0,80004746 <k_free+0x8>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80004740:	1571                	addi	a0,a0,-4
80004742:	ec3ff06f          	j	80004604 <k_mem_pool_free_id>
	}
}
80004746:	8082                	ret

80004748 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80004748:	800067b7          	lui	a5,0x80006
8000474c:	af47a783          	lw	a5,-1292(a5) # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
{
80004750:	85aa                	mv	a1,a0
	if (_current->resource_pool != NULL) {
80004752:	57a8                	lw	a0,104(a5)
80004754:	c119                	beqz	a0,8000475a <z_thread_malloc+0x12>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80004756:	fb7ff06f          	j	8000470c <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
8000475a:	4501                	li	a0,0
8000475c:	8082                	ret

8000475e <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
8000475e:	8082                	ret
