
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	1790006f          	j	80000984 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1ae000ef          	jal	ra,800001f4 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e905                	bnez	a0,8000007e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	11e08093          	addi	ra,ra,286 # 80000188 <no_reschedule>
	tail _Fault
80000072:	7560106f          	j	800017c8 <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000007c:	a041                	j	800000fc <reschedule>

8000007e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000007e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000082:	00006397          	auipc	t2,0x6
80000086:	3da38393          	addi	t2,t2,986 # 8000645c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000008a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000008e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
80000090:	c016                	sw	t0,0(sp)

80000092 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
80000092:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
80000096:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
80000098:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
8000009c:	00030863          	beqz	t1,800000ac <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000a0:	00000097          	auipc	ra,0x0
800000a4:	03808093          	addi	ra,ra,56 # 800000d8 <on_thread_stack>
	tail z_irq_do_offload
800000a8:	7820106f          	j	8000182a <z_irq_do_offload>

800000ac <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000ac:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000b0:	800002b7          	lui	t0,0x80000
800000b4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000b8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000bc:	128000ef          	jal	ra,800001e4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000c0:	00005297          	auipc	t0,0x5
800000c4:	d4c28293          	addi	t0,t0,-692 # 80004e0c <_sw_isr_table>
	slli a0, a0, 3
800000c8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000ca:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000cc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000d0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000d4:	000300e7          	jalr	t1

800000d8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000d8:	00006317          	auipc	t1,0x6
800000dc:	38430313          	addi	t1,t1,900 # 8000645c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000e0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000e4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000e6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000ea:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000ec:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
800000f0:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
800000f4:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
800000f8:	087e0863          	beq	t3,t2,80000188 <no_reschedule>

800000fc <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
800000fc:	00006297          	auipc	t0,0x6
80000100:	36028293          	addi	t0,t0,864 # 8000645c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000104:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000108:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000010c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000110:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000114:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000118:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000011c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000120:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000124:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000128:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000012c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000130:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000134:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000138:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000013c:	00006397          	auipc	t2,0x6
80000140:	f9c38393          	addi	t2,t2,-100 # 800060d8 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000144:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000148:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000014c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000150:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000154:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000158:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000015c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000160:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000164:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000168:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000016c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000170:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000174:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000178:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000017c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000180:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000184:	05832d83          	lw	s11,88(t1)

80000188 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000188:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000018a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000018e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
80000190:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
80000194:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
80000196:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
80000198:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
8000019a:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
8000019c:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
8000019e:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001a0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001a2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001a4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001a6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001a8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001aa:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001ac:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001ae:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001b0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001b2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001b4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001b6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001b8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ba:	30200073          	mret
	...

800001c0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001c0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001c4:	00006297          	auipc	t0,0x6
800001c8:	29828293          	addi	t0,t0,664 # 8000645c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001cc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001d0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001d4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001d6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001da:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001de:	00008067          	ret
	...

800001e4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001e4:	4305                	li	t1,1
	sll t0, t1, a0
800001e6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001ea:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
800001f4:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
800001f8:	80000337          	lui	t1,0x80000
	and t0, t0, t1
800001fc:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000200:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000204:	00028363          	beqz	t0,8000020a <not_interrupt>
	addi a0, a0, 1
80000208:	0505                	addi	a0,a0,1

8000020a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000020a:	00008067          	ret

Disassembly of section text:

80000210 <__lshrdi3>:
80000210:	02060063          	beqz	a2,80000230 <__lshrdi3+0x20>
80000214:	02000793          	li	a5,32
80000218:	40c787b3          	sub	a5,a5,a2
8000021c:	00f04c63          	bgtz	a5,80000234 <__lshrdi3+0x24>
80000220:	fe060513          	addi	a0,a2,-32
80000224:	00000713          	li	a4,0
80000228:	00a5d533          	srl	a0,a1,a0
8000022c:	00070593          	mv	a1,a4
80000230:	00008067          	ret
80000234:	00c5d733          	srl	a4,a1,a2
80000238:	00c55533          	srl	a0,a0,a2
8000023c:	00f595b3          	sll	a1,a1,a5
80000240:	00b56533          	or	a0,a0,a1
80000244:	fe9ff06f          	j	8000022c <__lshrdi3+0x1c>

80000248 <__udivdi3>:
80000248:	fd010113          	addi	sp,sp,-48
8000024c:	02912223          	sw	s1,36(sp)
80000250:	01612823          	sw	s6,16(sp)
80000254:	02112623          	sw	ra,44(sp)
80000258:	02812423          	sw	s0,40(sp)
8000025c:	03212023          	sw	s2,32(sp)
80000260:	01312e23          	sw	s3,28(sp)
80000264:	01412c23          	sw	s4,24(sp)
80000268:	01512a23          	sw	s5,20(sp)
8000026c:	01712623          	sw	s7,12(sp)
80000270:	01812423          	sw	s8,8(sp)
80000274:	01912223          	sw	s9,4(sp)
80000278:	00050b13          	mv	s6,a0
8000027c:	00058493          	mv	s1,a1
80000280:	38069c63          	bnez	a3,80000618 <__udivdi3+0x3d0>
80000284:	00060413          	mv	s0,a2
80000288:	00050993          	mv	s3,a0
8000028c:	00005917          	auipc	s2,0x5
80000290:	d0090913          	addi	s2,s2,-768 # 80004f8c <__devconfig_end>
80000294:	12c5f863          	bgeu	a1,a2,800003c4 <__udivdi3+0x17c>
80000298:	000107b7          	lui	a5,0x10
8000029c:	00058a93          	mv	s5,a1
800002a0:	10f67863          	bgeu	a2,a5,800003b0 <__udivdi3+0x168>
800002a4:	0ff00693          	li	a3,255
800002a8:	00c6b6b3          	sltu	a3,a3,a2
800002ac:	00369693          	slli	a3,a3,0x3
800002b0:	00d657b3          	srl	a5,a2,a3
800002b4:	00f90933          	add	s2,s2,a5
800002b8:	00094703          	lbu	a4,0(s2)
800002bc:	00d706b3          	add	a3,a4,a3
800002c0:	02000713          	li	a4,32
800002c4:	40d70733          	sub	a4,a4,a3
800002c8:	00070c63          	beqz	a4,800002e0 <__udivdi3+0x98>
800002cc:	00e494b3          	sll	s1,s1,a4
800002d0:	00db56b3          	srl	a3,s6,a3
800002d4:	00e61433          	sll	s0,a2,a4
800002d8:	0096eab3          	or	s5,a3,s1
800002dc:	00eb19b3          	sll	s3,s6,a4
800002e0:	01045b13          	srli	s6,s0,0x10
800002e4:	000b0593          	mv	a1,s6
800002e8:	000a8513          	mv	a0,s5
800002ec:	634000ef          	jal	ra,80000920 <__umodsi3>
800002f0:	00050913          	mv	s2,a0
800002f4:	000b0593          	mv	a1,s6
800002f8:	01041b93          	slli	s7,s0,0x10
800002fc:	000a8513          	mv	a0,s5
80000300:	5d8000ef          	jal	ra,800008d8 <__udivsi3>
80000304:	010bdb93          	srli	s7,s7,0x10
80000308:	00050493          	mv	s1,a0
8000030c:	00050593          	mv	a1,a0
80000310:	000b8513          	mv	a0,s7
80000314:	508000ef          	jal	ra,8000081c <__mulsi3>
80000318:	01091913          	slli	s2,s2,0x10
8000031c:	0109d713          	srli	a4,s3,0x10
80000320:	00e96733          	or	a4,s2,a4
80000324:	00048a13          	mv	s4,s1
80000328:	00a77e63          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000032c:	00870733          	add	a4,a4,s0
80000330:	fff48a13          	addi	s4,s1,-1
80000334:	00876863          	bltu	a4,s0,80000344 <__udivdi3+0xfc>
80000338:	00a77663          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000033c:	ffe48a13          	addi	s4,s1,-2
80000340:	00870733          	add	a4,a4,s0
80000344:	40a704b3          	sub	s1,a4,a0
80000348:	000b0593          	mv	a1,s6
8000034c:	00048513          	mv	a0,s1
80000350:	5d0000ef          	jal	ra,80000920 <__umodsi3>
80000354:	00050913          	mv	s2,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	578000ef          	jal	ra,800008d8 <__udivsi3>
80000364:	01099993          	slli	s3,s3,0x10
80000368:	00050493          	mv	s1,a0
8000036c:	00050593          	mv	a1,a0
80000370:	01091913          	slli	s2,s2,0x10
80000374:	000b8513          	mv	a0,s7
80000378:	0109d993          	srli	s3,s3,0x10
8000037c:	4a0000ef          	jal	ra,8000081c <__mulsi3>
80000380:	013969b3          	or	s3,s2,s3
80000384:	00048613          	mv	a2,s1
80000388:	00a9fc63          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000038c:	013409b3          	add	s3,s0,s3
80000390:	fff48613          	addi	a2,s1,-1
80000394:	0089e663          	bltu	s3,s0,800003a0 <__udivdi3+0x158>
80000398:	00a9f463          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000039c:	ffe48613          	addi	a2,s1,-2
800003a0:	010a1793          	slli	a5,s4,0x10
800003a4:	00c7e7b3          	or	a5,a5,a2
800003a8:	00000a13          	li	s4,0
800003ac:	1300006f          	j	800004dc <__udivdi3+0x294>
800003b0:	010007b7          	lui	a5,0x1000
800003b4:	01000693          	li	a3,16
800003b8:	eef66ce3          	bltu	a2,a5,800002b0 <__udivdi3+0x68>
800003bc:	01800693          	li	a3,24
800003c0:	ef1ff06f          	j	800002b0 <__udivdi3+0x68>
800003c4:	00068a13          	mv	s4,a3
800003c8:	00061a63          	bnez	a2,800003dc <__udivdi3+0x194>
800003cc:	00000593          	li	a1,0
800003d0:	00100513          	li	a0,1
800003d4:	504000ef          	jal	ra,800008d8 <__udivsi3>
800003d8:	00050413          	mv	s0,a0
800003dc:	000107b7          	lui	a5,0x10
800003e0:	12f47c63          	bgeu	s0,a5,80000518 <__udivdi3+0x2d0>
800003e4:	0ff00793          	li	a5,255
800003e8:	0087f463          	bgeu	a5,s0,800003f0 <__udivdi3+0x1a8>
800003ec:	00800a13          	li	s4,8
800003f0:	014457b3          	srl	a5,s0,s4
800003f4:	00f90933          	add	s2,s2,a5
800003f8:	00094683          	lbu	a3,0(s2)
800003fc:	02000613          	li	a2,32
80000400:	014686b3          	add	a3,a3,s4
80000404:	40d60633          	sub	a2,a2,a3
80000408:	12061263          	bnez	a2,8000052c <__udivdi3+0x2e4>
8000040c:	408484b3          	sub	s1,s1,s0
80000410:	00100a13          	li	s4,1
80000414:	01045b13          	srli	s6,s0,0x10
80000418:	000b0593          	mv	a1,s6
8000041c:	00048513          	mv	a0,s1
80000420:	500000ef          	jal	ra,80000920 <__umodsi3>
80000424:	00050913          	mv	s2,a0
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	01041b93          	slli	s7,s0,0x10
80000434:	4a4000ef          	jal	ra,800008d8 <__udivsi3>
80000438:	010bdb93          	srli	s7,s7,0x10
8000043c:	00050493          	mv	s1,a0
80000440:	00050593          	mv	a1,a0
80000444:	000b8513          	mv	a0,s7
80000448:	3d4000ef          	jal	ra,8000081c <__mulsi3>
8000044c:	01091913          	slli	s2,s2,0x10
80000450:	0109d713          	srli	a4,s3,0x10
80000454:	00e96733          	or	a4,s2,a4
80000458:	00048a93          	mv	s5,s1
8000045c:	00a77e63          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000460:	00870733          	add	a4,a4,s0
80000464:	fff48a93          	addi	s5,s1,-1
80000468:	00876863          	bltu	a4,s0,80000478 <__udivdi3+0x230>
8000046c:	00a77663          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000470:	ffe48a93          	addi	s5,s1,-2
80000474:	00870733          	add	a4,a4,s0
80000478:	40a704b3          	sub	s1,a4,a0
8000047c:	000b0593          	mv	a1,s6
80000480:	00048513          	mv	a0,s1
80000484:	49c000ef          	jal	ra,80000920 <__umodsi3>
80000488:	00050913          	mv	s2,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	444000ef          	jal	ra,800008d8 <__udivsi3>
80000498:	01099993          	slli	s3,s3,0x10
8000049c:	00050493          	mv	s1,a0
800004a0:	00050593          	mv	a1,a0
800004a4:	01091913          	slli	s2,s2,0x10
800004a8:	000b8513          	mv	a0,s7
800004ac:	0109d993          	srli	s3,s3,0x10
800004b0:	36c000ef          	jal	ra,8000081c <__mulsi3>
800004b4:	013969b3          	or	s3,s2,s3
800004b8:	00048613          	mv	a2,s1
800004bc:	00a9fc63          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004c0:	013409b3          	add	s3,s0,s3
800004c4:	fff48613          	addi	a2,s1,-1
800004c8:	0089e663          	bltu	s3,s0,800004d4 <__udivdi3+0x28c>
800004cc:	00a9f463          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004d0:	ffe48613          	addi	a2,s1,-2
800004d4:	010a9793          	slli	a5,s5,0x10
800004d8:	00c7e7b3          	or	a5,a5,a2
800004dc:	00078513          	mv	a0,a5
800004e0:	000a0593          	mv	a1,s4
800004e4:	02c12083          	lw	ra,44(sp)
800004e8:	02812403          	lw	s0,40(sp)
800004ec:	02412483          	lw	s1,36(sp)
800004f0:	02012903          	lw	s2,32(sp)
800004f4:	01c12983          	lw	s3,28(sp)
800004f8:	01812a03          	lw	s4,24(sp)
800004fc:	01412a83          	lw	s5,20(sp)
80000500:	01012b03          	lw	s6,16(sp)
80000504:	00c12b83          	lw	s7,12(sp)
80000508:	00812c03          	lw	s8,8(sp)
8000050c:	00412c83          	lw	s9,4(sp)
80000510:	03010113          	addi	sp,sp,48
80000514:	00008067          	ret
80000518:	010007b7          	lui	a5,0x1000
8000051c:	01000a13          	li	s4,16
80000520:	ecf468e3          	bltu	s0,a5,800003f0 <__udivdi3+0x1a8>
80000524:	01800a13          	li	s4,24
80000528:	ec9ff06f          	j	800003f0 <__udivdi3+0x1a8>
8000052c:	00c41433          	sll	s0,s0,a2
80000530:	00d4da33          	srl	s4,s1,a3
80000534:	00cb19b3          	sll	s3,s6,a2
80000538:	00db56b3          	srl	a3,s6,a3
8000053c:	01045b13          	srli	s6,s0,0x10
80000540:	00c494b3          	sll	s1,s1,a2
80000544:	000b0593          	mv	a1,s6
80000548:	000a0513          	mv	a0,s4
8000054c:	0096eab3          	or	s5,a3,s1
80000550:	3d0000ef          	jal	ra,80000920 <__umodsi3>
80000554:	00050913          	mv	s2,a0
80000558:	000b0593          	mv	a1,s6
8000055c:	000a0513          	mv	a0,s4
80000560:	01041b93          	slli	s7,s0,0x10
80000564:	374000ef          	jal	ra,800008d8 <__udivsi3>
80000568:	010bdb93          	srli	s7,s7,0x10
8000056c:	00050493          	mv	s1,a0
80000570:	00050593          	mv	a1,a0
80000574:	000b8513          	mv	a0,s7
80000578:	2a4000ef          	jal	ra,8000081c <__mulsi3>
8000057c:	01091913          	slli	s2,s2,0x10
80000580:	010ad713          	srli	a4,s5,0x10
80000584:	00e96733          	or	a4,s2,a4
80000588:	00048a13          	mv	s4,s1
8000058c:	00a77e63          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
80000590:	00870733          	add	a4,a4,s0
80000594:	fff48a13          	addi	s4,s1,-1
80000598:	00876863          	bltu	a4,s0,800005a8 <__udivdi3+0x360>
8000059c:	00a77663          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
800005a0:	ffe48a13          	addi	s4,s1,-2
800005a4:	00870733          	add	a4,a4,s0
800005a8:	40a704b3          	sub	s1,a4,a0
800005ac:	000b0593          	mv	a1,s6
800005b0:	00048513          	mv	a0,s1
800005b4:	36c000ef          	jal	ra,80000920 <__umodsi3>
800005b8:	00050913          	mv	s2,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	314000ef          	jal	ra,800008d8 <__udivsi3>
800005c8:	00050493          	mv	s1,a0
800005cc:	00050593          	mv	a1,a0
800005d0:	000b8513          	mv	a0,s7
800005d4:	248000ef          	jal	ra,8000081c <__mulsi3>
800005d8:	010a9693          	slli	a3,s5,0x10
800005dc:	01091913          	slli	s2,s2,0x10
800005e0:	0106d693          	srli	a3,a3,0x10
800005e4:	00d967b3          	or	a5,s2,a3
800005e8:	00048713          	mv	a4,s1
800005ec:	00a7fe63          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
800005f0:	008787b3          	add	a5,a5,s0
800005f4:	fff48713          	addi	a4,s1,-1
800005f8:	0087e863          	bltu	a5,s0,80000608 <__udivdi3+0x3c0>
800005fc:	00a7f663          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
80000600:	ffe48713          	addi	a4,s1,-2
80000604:	008787b3          	add	a5,a5,s0
80000608:	010a1a13          	slli	s4,s4,0x10
8000060c:	40a784b3          	sub	s1,a5,a0
80000610:	00ea6a33          	or	s4,s4,a4
80000614:	e01ff06f          	j	80000414 <__udivdi3+0x1cc>
80000618:	1ed5ec63          	bltu	a1,a3,80000810 <__udivdi3+0x5c8>
8000061c:	000107b7          	lui	a5,0x10
80000620:	04f6f463          	bgeu	a3,a5,80000668 <__udivdi3+0x420>
80000624:	0ff00593          	li	a1,255
80000628:	00d5b533          	sltu	a0,a1,a3
8000062c:	00351513          	slli	a0,a0,0x3
80000630:	00a6d733          	srl	a4,a3,a0
80000634:	00005797          	auipc	a5,0x5
80000638:	95878793          	addi	a5,a5,-1704 # 80004f8c <__devconfig_end>
8000063c:	00e787b3          	add	a5,a5,a4
80000640:	0007c583          	lbu	a1,0(a5)
80000644:	02000a13          	li	s4,32
80000648:	00a585b3          	add	a1,a1,a0
8000064c:	40ba0a33          	sub	s4,s4,a1
80000650:	020a1663          	bnez	s4,8000067c <__udivdi3+0x434>
80000654:	00100793          	li	a5,1
80000658:	e896e2e3          	bltu	a3,s1,800004dc <__udivdi3+0x294>
8000065c:	00cb3633          	sltu	a2,s6,a2
80000660:	00164793          	xori	a5,a2,1
80000664:	e79ff06f          	j	800004dc <__udivdi3+0x294>
80000668:	010007b7          	lui	a5,0x1000
8000066c:	01000513          	li	a0,16
80000670:	fcf6e0e3          	bltu	a3,a5,80000630 <__udivdi3+0x3e8>
80000674:	01800513          	li	a0,24
80000678:	fb9ff06f          	j	80000630 <__udivdi3+0x3e8>
8000067c:	00b65ab3          	srl	s5,a2,a1
80000680:	014696b3          	sll	a3,a3,s4
80000684:	00daeab3          	or	s5,s5,a3
80000688:	00b4d933          	srl	s2,s1,a1
8000068c:	014497b3          	sll	a5,s1,s4
80000690:	00bb55b3          	srl	a1,s6,a1
80000694:	010adb93          	srli	s7,s5,0x10
80000698:	00f5e4b3          	or	s1,a1,a5
8000069c:	00090513          	mv	a0,s2
800006a0:	000b8593          	mv	a1,s7
800006a4:	014619b3          	sll	s3,a2,s4
800006a8:	278000ef          	jal	ra,80000920 <__umodsi3>
800006ac:	00050413          	mv	s0,a0
800006b0:	000b8593          	mv	a1,s7
800006b4:	00090513          	mv	a0,s2
800006b8:	010a9c13          	slli	s8,s5,0x10
800006bc:	21c000ef          	jal	ra,800008d8 <__udivsi3>
800006c0:	010c5c13          	srli	s8,s8,0x10
800006c4:	00050913          	mv	s2,a0
800006c8:	00050593          	mv	a1,a0
800006cc:	000c0513          	mv	a0,s8
800006d0:	14c000ef          	jal	ra,8000081c <__mulsi3>
800006d4:	01041413          	slli	s0,s0,0x10
800006d8:	0104d713          	srli	a4,s1,0x10
800006dc:	00e46733          	or	a4,s0,a4
800006e0:	00090c93          	mv	s9,s2
800006e4:	00a77e63          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006e8:	01570733          	add	a4,a4,s5
800006ec:	fff90c93          	addi	s9,s2,-1
800006f0:	01576863          	bltu	a4,s5,80000700 <__udivdi3+0x4b8>
800006f4:	00a77663          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006f8:	ffe90c93          	addi	s9,s2,-2
800006fc:	01570733          	add	a4,a4,s5
80000700:	40a70933          	sub	s2,a4,a0
80000704:	000b8593          	mv	a1,s7
80000708:	00090513          	mv	a0,s2
8000070c:	214000ef          	jal	ra,80000920 <__umodsi3>
80000710:	00050413          	mv	s0,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	1bc000ef          	jal	ra,800008d8 <__udivsi3>
80000720:	00050913          	mv	s2,a0
80000724:	00050593          	mv	a1,a0
80000728:	000c0513          	mv	a0,s8
8000072c:	0f0000ef          	jal	ra,8000081c <__mulsi3>
80000730:	01049793          	slli	a5,s1,0x10
80000734:	01041413          	slli	s0,s0,0x10
80000738:	0107d793          	srli	a5,a5,0x10
8000073c:	00f46733          	or	a4,s0,a5
80000740:	00090613          	mv	a2,s2
80000744:	00a77e63          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000748:	01570733          	add	a4,a4,s5
8000074c:	fff90613          	addi	a2,s2,-1
80000750:	01576863          	bltu	a4,s5,80000760 <__udivdi3+0x518>
80000754:	00a77663          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000758:	ffe90613          	addi	a2,s2,-2
8000075c:	01570733          	add	a4,a4,s5
80000760:	010c9793          	slli	a5,s9,0x10
80000764:	00010e37          	lui	t3,0x10
80000768:	00c7e7b3          	or	a5,a5,a2
8000076c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000770:	0107f333          	and	t1,a5,a6
80000774:	0109f833          	and	a6,s3,a6
80000778:	40a70733          	sub	a4,a4,a0
8000077c:	0107de93          	srli	t4,a5,0x10
80000780:	0109d993          	srli	s3,s3,0x10
80000784:	00030513          	mv	a0,t1
80000788:	00080593          	mv	a1,a6
8000078c:	090000ef          	jal	ra,8000081c <__mulsi3>
80000790:	00050893          	mv	a7,a0
80000794:	00098593          	mv	a1,s3
80000798:	00030513          	mv	a0,t1
8000079c:	080000ef          	jal	ra,8000081c <__mulsi3>
800007a0:	00050313          	mv	t1,a0
800007a4:	00080593          	mv	a1,a6
800007a8:	000e8513          	mv	a0,t4
800007ac:	070000ef          	jal	ra,8000081c <__mulsi3>
800007b0:	00050813          	mv	a6,a0
800007b4:	00098593          	mv	a1,s3
800007b8:	000e8513          	mv	a0,t4
800007bc:	060000ef          	jal	ra,8000081c <__mulsi3>
800007c0:	0108d693          	srli	a3,a7,0x10
800007c4:	01030333          	add	t1,t1,a6
800007c8:	006686b3          	add	a3,a3,t1
800007cc:	0106f463          	bgeu	a3,a6,800007d4 <__udivdi3+0x58c>
800007d0:	01c50533          	add	a0,a0,t3
800007d4:	0106d613          	srli	a2,a3,0x10
800007d8:	00a60533          	add	a0,a2,a0
800007dc:	02a76663          	bltu	a4,a0,80000808 <__udivdi3+0x5c0>
800007e0:	bca714e3          	bne	a4,a0,800003a8 <__udivdi3+0x160>
800007e4:	00010737          	lui	a4,0x10
800007e8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007ec:	00e6f6b3          	and	a3,a3,a4
800007f0:	01069693          	slli	a3,a3,0x10
800007f4:	00e8f8b3          	and	a7,a7,a4
800007f8:	014b1633          	sll	a2,s6,s4
800007fc:	011686b3          	add	a3,a3,a7
80000800:	00000a13          	li	s4,0
80000804:	ccd67ce3          	bgeu	a2,a3,800004dc <__udivdi3+0x294>
80000808:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000080c:	b9dff06f          	j	800003a8 <__udivdi3+0x160>
80000810:	00000a13          	li	s4,0
80000814:	00000793          	li	a5,0
80000818:	cc5ff06f          	j	800004dc <__udivdi3+0x294>

8000081c <__mulsi3>:
8000081c:	00050613          	mv	a2,a0
80000820:	00000513          	li	a0,0
80000824:	0015f693          	andi	a3,a1,1
80000828:	00068463          	beqz	a3,80000830 <__mulsi3+0x14>
8000082c:	00c50533          	add	a0,a0,a2
80000830:	0015d593          	srli	a1,a1,0x1
80000834:	00161613          	slli	a2,a2,0x1
80000838:	fe0596e3          	bnez	a1,80000824 <__mulsi3+0x8>
8000083c:	00008067          	ret

80000840 <__muldi3>:
80000840:	ff010113          	addi	sp,sp,-16
80000844:	00068313          	mv	t1,a3
80000848:	00112623          	sw	ra,12(sp)
8000084c:	00050e13          	mv	t3,a0
80000850:	00050893          	mv	a7,a0
80000854:	00060693          	mv	a3,a2
80000858:	00000713          	li	a4,0
8000085c:	00000793          	li	a5,0
80000860:	00000813          	li	a6,0
80000864:	0016f513          	andi	a0,a3,1
80000868:	00171e93          	slli	t4,a4,0x1
8000086c:	00050c63          	beqz	a0,80000884 <__muldi3+0x44>
80000870:	01088533          	add	a0,a7,a6
80000874:	01053833          	sltu	a6,a0,a6
80000878:	00e787b3          	add	a5,a5,a4
8000087c:	00f807b3          	add	a5,a6,a5
80000880:	00050813          	mv	a6,a0
80000884:	01f8d713          	srli	a4,a7,0x1f
80000888:	0016d693          	srli	a3,a3,0x1
8000088c:	00eee733          	or	a4,t4,a4
80000890:	00189893          	slli	a7,a7,0x1
80000894:	fc0698e3          	bnez	a3,80000864 <__muldi3+0x24>
80000898:	00058863          	beqz	a1,800008a8 <__muldi3+0x68>
8000089c:	00060513          	mv	a0,a2
800008a0:	f7dff0ef          	jal	ra,8000081c <__mulsi3>
800008a4:	00a787b3          	add	a5,a5,a0
800008a8:	00030a63          	beqz	t1,800008bc <__muldi3+0x7c>
800008ac:	000e0513          	mv	a0,t3
800008b0:	00030593          	mv	a1,t1
800008b4:	f69ff0ef          	jal	ra,8000081c <__mulsi3>
800008b8:	00f507b3          	add	a5,a0,a5
800008bc:	00c12083          	lw	ra,12(sp)
800008c0:	00080513          	mv	a0,a6
800008c4:	00078593          	mv	a1,a5
800008c8:	01010113          	addi	sp,sp,16
800008cc:	00008067          	ret

800008d0 <__divsi3>:
800008d0:	06054063          	bltz	a0,80000930 <__umodsi3+0x10>
800008d4:	0605c663          	bltz	a1,80000940 <__umodsi3+0x20>

800008d8 <__udivsi3>:
800008d8:	00058613          	mv	a2,a1
800008dc:	00050593          	mv	a1,a0
800008e0:	fff00513          	li	a0,-1
800008e4:	02060c63          	beqz	a2,8000091c <__udivsi3+0x44>
800008e8:	00100693          	li	a3,1
800008ec:	00b67a63          	bgeu	a2,a1,80000900 <__udivsi3+0x28>
800008f0:	00c05863          	blez	a2,80000900 <__udivsi3+0x28>
800008f4:	00161613          	slli	a2,a2,0x1
800008f8:	00169693          	slli	a3,a3,0x1
800008fc:	feb66ae3          	bltu	a2,a1,800008f0 <__udivsi3+0x18>
80000900:	00000513          	li	a0,0
80000904:	00c5e663          	bltu	a1,a2,80000910 <__udivsi3+0x38>
80000908:	40c585b3          	sub	a1,a1,a2
8000090c:	00d56533          	or	a0,a0,a3
80000910:	0016d693          	srli	a3,a3,0x1
80000914:	00165613          	srli	a2,a2,0x1
80000918:	fe0696e3          	bnez	a3,80000904 <__udivsi3+0x2c>
8000091c:	00008067          	ret

80000920 <__umodsi3>:
80000920:	00008293          	mv	t0,ra
80000924:	fb5ff0ef          	jal	ra,800008d8 <__udivsi3>
80000928:	00058513          	mv	a0,a1
8000092c:	00028067          	jr	t0
80000930:	40a00533          	neg	a0,a0
80000934:	0005d863          	bgez	a1,80000944 <__umodsi3+0x24>
80000938:	40b005b3          	neg	a1,a1
8000093c:	f9dff06f          	j	800008d8 <__udivsi3>
80000940:	40b005b3          	neg	a1,a1
80000944:	00008293          	mv	t0,ra
80000948:	f91ff0ef          	jal	ra,800008d8 <__udivsi3>
8000094c:	40a00533          	neg	a0,a0
80000950:	00028067          	jr	t0

80000954 <__modsi3>:
80000954:	00008293          	mv	t0,ra
80000958:	0005ca63          	bltz	a1,8000096c <__modsi3+0x18>
8000095c:	00054c63          	bltz	a0,80000974 <__modsi3+0x20>
80000960:	f79ff0ef          	jal	ra,800008d8 <__udivsi3>
80000964:	00058513          	mv	a0,a1
80000968:	00028067          	jr	t0
8000096c:	40b005b3          	neg	a1,a1
80000970:	fe0558e3          	bgez	a0,80000960 <__modsi3+0xc>
80000974:	40a00533          	neg	a0,a0
80000978:	f61ff0ef          	jal	ra,800008d8 <__udivsi3>
8000097c:	40b00533          	neg	a0,a1
80000980:	00028067          	jr	t0

80000984 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000984:	00006117          	auipc	sp,0x6
80000988:	30c10113          	addi	sp,sp,780 # 80006c90 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
8000098c:	000012b7          	lui	t0,0x1
80000990:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000994:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000996:	6b5000ef          	jal	ra,8000184a <_PrepC>
	...

8000099c <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
8000099c:	09e0106f          	j	80001a3a <z_thread_entry>
	...

800009a2 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009a2:	8082                	ret

800009a4 <init_timer_data>:
		}				 \
	} while (0)

static void init_timer_data(void)
{
	tdata.expire_cnt = 0;
800009a4:	800067b7          	lui	a5,0x80006
800009a8:	28078793          	addi	a5,a5,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
800009ac:	0007a023          	sw	zero,0(a5)
	tdata.stop_cnt = 0;
800009b0:	0007a223          	sw	zero,4(a5)
}
800009b4:	8082                	ret

800009b6 <duration_stop>:
	}
}

static void duration_stop(struct k_timer *timer)
{
	tdata.stop_cnt++;
800009b6:	800067b7          	lui	a5,0x80006
800009ba:	28078793          	addi	a5,a5,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
800009be:	43d8                	lw	a4,4(a5)
800009c0:	0705                	addi	a4,a4,1
800009c2:	c3d8                	sw	a4,4(a5)
}
800009c4:	8082                	ret

800009c6 <period0_expire>:

static void period0_expire(struct k_timer *timer)
{
	tdata.expire_cnt++;
800009c6:	800067b7          	lui	a5,0x80006
800009ca:	28078793          	addi	a5,a5,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
800009ce:	4398                	lw	a4,0(a5)
800009d0:	0705                	addi	a4,a4,1
800009d2:	c398                	sw	a4,0(a5)
}
800009d4:	8082                	ret

800009d6 <user_data_timer_handler>:

static int user_data_correct[5] = { 0, 0, 0, 0, 0 };

static void user_data_timer_handler(struct k_timer *timer)
{
	int timer_num = timer == user_data_timer[0] ? 0 :
800009d6:	800067b7          	lui	a5,0x80006
800009da:	13c78793          	addi	a5,a5,316 # 8000613c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000613d>
800009de:	04f50d63          	beq	a0,a5,80000a38 <user_data_timer_handler+0x62>
			timer == user_data_timer[1] ? 1 :
800009e2:	800067b7          	lui	a5,0x80006
800009e6:	16878793          	addi	a5,a5,360 # 80006168 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006169>
800009ea:	04f50963          	beq	a0,a5,80000a3c <user_data_timer_handler+0x66>
			timer == user_data_timer[2] ? 2 :
800009ee:	800067b7          	lui	a5,0x80006
800009f2:	19478793          	addi	a5,a5,404 # 80006194 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006195>
800009f6:	04f50563          	beq	a0,a5,80000a40 <user_data_timer_handler+0x6a>
			timer == user_data_timer[3] ? 3 :
800009fa:	800067b7          	lui	a5,0x80006
800009fe:	1c078793          	addi	a5,a5,448 # 800061c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061c1>
80000a02:	04f50163          	beq	a0,a5,80000a44 <user_data_timer_handler+0x6e>
			timer == user_data_timer[4] ? 4 : -1;
80000a06:	800067b7          	lui	a5,0x80006
80000a0a:	1ec78793          	addi	a5,a5,492 # 800061ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061ed>
80000a0e:	02f51463          	bne	a0,a5,80000a36 <user_data_timer_handler+0x60>
80000a12:	4791                	li	a5,4
	if (timer_num == -1) {
		return;
	}

	intptr_t data_retrieved = (intptr_t)k_timer_user_data_get(timer);
	user_data_correct[timer_num] = user_data[timer_num] == data_retrieved;
80000a14:	800056b7          	lui	a3,0x80005
80000a18:	078a                	slli	a5,a5,0x2
80000a1a:	80006737          	lui	a4,0x80006
80000a1e:	5e068693          	addi	a3,a3,1504 # 800055e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055e1>
80000a22:	96be                	add	a3,a3,a5
80000a24:	2e870713          	addi	a4,a4,744 # 800062e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e9>
80000a28:	973e                	add	a4,a4,a5
80000a2a:	4294                	lw	a3,0(a3)
80000a2c:	551c                	lw	a5,40(a0)
80000a2e:	8f95                	sub	a5,a5,a3
80000a30:	0017b793          	seqz	a5,a5
80000a34:	c31c                	sw	a5,0(a4)
}
80000a36:	8082                	ret
	int timer_num = timer == user_data_timer[0] ? 0 :
80000a38:	4781                	li	a5,0
80000a3a:	bfe9                	j	80000a14 <user_data_timer_handler+0x3e>
			timer == user_data_timer[1] ? 1 :
80000a3c:	4785                	li	a5,1
80000a3e:	bfd9                	j	80000a14 <user_data_timer_handler+0x3e>
			timer == user_data_timer[2] ? 2 :
80000a40:	4789                	li	a5,2
80000a42:	bfc9                	j	80000a14 <user_data_timer_handler+0x3e>
			timer == user_data_timer[3] ? 3 :
80000a44:	478d                	li	a5,3
80000a46:	b7f9                	j	80000a14 <user_data_timer_handler+0x3e>

80000a48 <z_impl_k_timer_remaining_get>:
 * @return Remaining time (in milliseconds).
 */
__syscall u32_t k_timer_remaining_get(struct k_timer *timer);

static inline u32_t z_impl_k_timer_remaining_get(struct k_timer *timer)
{
80000a48:	1141                	addi	sp,sp,-16
80000a4a:	c606                	sw	ra,12(sp)
	const s32_t ticks = z_timeout_remaining(&timer->timeout);
80000a4c:	273030ef          	jal	ra,800044be <z_timeout_remaining>
	return (ticks > 0) ? (u32_t)__ticks_to_ms(ticks) : 0U;
80000a50:	02a05063          	blez	a0,80000a70 <z_impl_k_timer_remaining_get+0x28>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80000a54:	3e800613          	li	a2,1000
80000a58:	4681                	li	a3,0
80000a5a:	41f55593          	srai	a1,a0,0x1f
80000a5e:	33cd                	jal	80000840 <__muldi3>
80000a60:	06400613          	li	a2,100
80000a64:	4681                	li	a3,0
80000a66:	fe2ff0ef          	jal	ra,80000248 <__udivdi3>
}
80000a6a:	40b2                	lw	ra,12(sp)
80000a6c:	0141                	addi	sp,sp,16
80000a6e:	8082                	ret
	return (ticks > 0) ? (u32_t)__ticks_to_ms(ticks) : 0U;
80000a70:	4501                	li	a0,0
80000a72:	bfe5                	j	80000a6a <z_impl_k_timer_remaining_get+0x22>

80000a74 <z_zassert.constprop.6>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000a74:	7179                	addi	sp,sp,-48
80000a76:	ce06                	sw	ra,28(sp)
80000a78:	d442                	sw	a6,40(sp)
80000a7a:	d646                	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000a7c:	ed1d                	bnez	a0,80000aba <z_zassert.constprop.6+0x46>
80000a7e:	8636                	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a80:	80005537          	lui	a0,0x80005
80000a84:	86ba                	mv	a3,a4
80000a86:	872e                	mv	a4,a1
80000a88:	800055b7          	lui	a1,0x80005
		va_start(vargs, msg);
80000a8c:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a8e:	60858593          	addi	a1,a1,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000a92:	63450513          	addi	a0,a0,1588 # 80005634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005635>
		va_start(vargs, msg);
80000a96:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a98:	3ee010ef          	jal	ra,80001e86 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000a9c:	45b2                	lw	a1,12(sp)
80000a9e:	80005537          	lui	a0,0x80005
80000aa2:	6b050513          	addi	a0,a0,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000aa6:	3c4010ef          	jal	ra,80001e6a <vprintk>
		printk("\n");
80000aaa:	80006537          	lui	a0,0x80006
80000aae:	fe450513          	addi	a0,a0,-28 # 80005fe4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fe5>
80000ab2:	3d4010ef          	jal	ra,80001e86 <printk>
		va_end(vargs);
		ztest_test_fail();
80000ab6:	105010ef          	jal	ra,800023ba <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000aba:	40f2                	lw	ra,28(sp)
80000abc:	6145                	addi	sp,sp,48
80000abe:	8082                	ret

80000ac0 <test_timer_user_data>:
 *
 * @see K_TIMER_DEFINE(), k_timer_user_data_set(), k_timer_start(),
 * k_timer_user_data_get(), k_timer_stop()
 */
void test_timer_user_data(void)
{
80000ac0:	7179                	addi	sp,sp,-48
80000ac2:	d422                	sw	s0,40(sp)
80000ac4:	d04a                	sw	s2,32(sp)
80000ac6:	cc52                	sw	s4,24(sp)
80000ac8:	ca56                	sw	s5,20(sp)
	int ii;

	for (ii = 0; ii < 5; ii++) {
		intptr_t check;

		k_timer_user_data_set(user_data_timer[ii],
80000aca:	80005437          	lui	s0,0x80005
				      (void *)user_data[ii]);
80000ace:	80005937          	lui	s2,0x80005
		check = (intptr_t)k_timer_user_data_get(user_data_timer[ii]);

		zassert_true(check == user_data[ii], NULL);
80000ad2:	80005a37          	lui	s4,0x80005
80000ad6:	80005ab7          	lui	s5,0x80005
{
80000ada:	d226                	sw	s1,36(sp)
80000adc:	ce4e                	sw	s3,28(sp)
80000ade:	c85a                	sw	s6,16(sp)
80000ae0:	c65e                	sw	s7,12(sp)
80000ae2:	d606                	sw	ra,44(sp)
80000ae4:	4481                	li	s1,0
		k_timer_user_data_set(user_data_timer[ii],
80000ae6:	5f440413          	addi	s0,s0,1524 # 800055f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055f5>
				      (void *)user_data[ii]);
80000aea:	5e090913          	addi	s2,s2,1504 # 800055e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055e1>
		zassert_true(check == user_data[ii], NULL);
80000aee:	800059b7          	lui	s3,0x80005
80000af2:	8b52                	mv	s6,s4
80000af4:	8bd6                	mv	s7,s5
		k_timer_user_data_set(user_data_timer[ii],
80000af6:	009407b3          	add	a5,s0,s1
				      (void *)user_data[ii]);
80000afa:	00990733          	add	a4,s2,s1
		k_timer_user_data_set(user_data_timer[ii],
80000afe:	439c                	lw	a5,0(a5)
 * @internal
 */
static inline void z_impl_k_timer_user_data_set(struct k_timer *timer,
					       void *user_data)
{
	timer->user_data = user_data;
80000b00:	4318                	lw	a4,0(a4)
		zassert_true(check == user_data[ii], NULL);
80000b02:	800055b7          	lui	a1,0x80005
80000b06:	1d500693          	li	a3,469
80000b0a:	d798                	sw	a4,40(a5)
80000b0c:	60898613          	addi	a2,s3,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000b10:	6b0a8793          	addi	a5,s5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000b14:	180a0713          	addi	a4,s4,384 # 80005180 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005181>
80000b18:	5a058593          	addi	a1,a1,1440 # 800055a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055a1>
80000b1c:	4505                	li	a0,1
80000b1e:	3f99                	jal	80000a74 <z_zassert.constprop.6>
80000b20:	0491                	addi	s1,s1,4
	for (ii = 0; ii < 5; ii++) {
80000b22:	47d1                	li	a5,20
80000b24:	fcf499e3          	bne	s1,a5,80000af6 <test_timer_user_data+0x36>
80000b28:	03200493          	li	s1,50
	}

	for (ii = 0; ii < 5; ii++) {
80000b2c:	12c00913          	li	s2,300

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_NAME_SET, k_thread_name_set, k_tid_t, thread_id, const char *, value)

K_SYSCALL_DECLARE1(K_SYSCALL_K_THREAD_NAME_GET, k_thread_name_get, const char *, k_tid_t, thread_id)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000b30:	4008                	lw	a0,0(s0)
80000b32:	85a6                	mv	a1,s1
80000b34:	4601                	li	a2,0
80000b36:	03248493          	addi	s1,s1,50
80000b3a:	771030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
80000b3e:	0411                	addi	s0,s0,4
80000b40:	ff2498e3          	bne	s1,s2,80000b30 <test_timer_user_data+0x70>
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000b44:	12c00513          	li	a0,300
80000b48:	569020ef          	jal	ra,800038b0 <z_impl_k_sleep>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000b4c:	80006537          	lui	a0,0x80006
80000b50:	13c50513          	addi	a0,a0,316 # 8000613c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000613d>
80000b54:	7f1030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80000b58:	80006537          	lui	a0,0x80006
80000b5c:	16850513          	addi	a0,a0,360 # 80006168 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006169>
80000b60:	7e5030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80000b64:	80006537          	lui	a0,0x80006
80000b68:	19450513          	addi	a0,a0,404 # 80006194 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006195>
80000b6c:	7d9030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80000b70:	80006537          	lui	a0,0x80006
80000b74:	1c050513          	addi	a0,a0,448 # 800061c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061c1>
80000b78:	7cd030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80000b7c:	80006537          	lui	a0,0x80006
80000b80:	80006437          	lui	s0,0x80006
80000b84:	1ec50513          	addi	a0,a0,492 # 800061ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061ed>
80000b88:	2e840413          	addi	s0,s0,744 # 800062e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e9>
80000b8c:	7b9030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80000b90:	01440493          	addi	s1,s0,20
	for (ii = 0; ii < 5; ii++) {
		k_timer_stop(user_data_timer[ii]);
	}

	for (ii = 0; ii < 5; ii++) {
		zassert_true(user_data_correct[ii], NULL);
80000b94:	80005937          	lui	s2,0x80005
80000b98:	4008                	lw	a0,0(s0)
80000b9a:	6b0b8793          	addi	a5,s7,1712
80000b9e:	180b0713          	addi	a4,s6,384
80000ba2:	1e300693          	li	a3,483
80000ba6:	60898613          	addi	a2,s3,1544
80000baa:	5c090593          	addi	a1,s2,1472 # 800055c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055c1>
80000bae:	0411                	addi	s0,s0,4
80000bb0:	35d1                	jal	80000a74 <z_zassert.constprop.6>
	for (ii = 0; ii < 5; ii++) {
80000bb2:	fe8493e3          	bne	s1,s0,80000b98 <test_timer_user_data+0xd8>
	}
}
80000bb6:	50b2                	lw	ra,44(sp)
80000bb8:	5422                	lw	s0,40(sp)
80000bba:	5492                	lw	s1,36(sp)
80000bbc:	5902                	lw	s2,32(sp)
80000bbe:	49f2                	lw	s3,28(sp)
80000bc0:	4a62                	lw	s4,24(sp)
80000bc2:	4ad2                	lw	s5,20(sp)
80000bc4:	4b42                	lw	s6,16(sp)
80000bc6:	4bb2                	lw	s7,12(sp)
80000bc8:	6145                	addi	sp,sp,48
80000bca:	8082                	ret

80000bcc <test_timer_remaining_get>:
 * @see k_timer_init(), k_timer_start(), k_timer_stop(),
 * k_timer_remaining_get()
 */

void test_timer_remaining_get(void)
{
80000bcc:	1141                	addi	sp,sp,-16
80000bce:	c606                	sw	ra,12(sp)
80000bd0:	c422                	sw	s0,8(sp)
80000bd2:	c226                	sw	s1,4(sp)
	u32_t remaining;

	init_timer_data();
	k_timer_init(&timer, NULL, NULL);
80000bd4:	80006437          	lui	s0,0x80006
	init_timer_data();
80000bd8:	33f1                	jal	800009a4 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
80000bda:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80000bde:	4601                	li	a2,0
80000be0:	4581                	li	a1,0
80000be2:	6ab030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000be6:	4601                	li	a2,0
80000be8:	06400593          	li	a1,100
80000bec:	2bc40513          	addi	a0,s0,700
80000bf0:	6bb030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000bf4:	6531                	lui	a0,0xc
80000bf6:	35050513          	addi	a0,a0,848 # c350 <CONFIG_ISR_STACK_SIZE+0xbb50>
80000bfa:	194030ef          	jal	ra,80003d8e <z_impl_k_busy_wait>

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000bfe:	2bc40513          	addi	a0,s0,700
80000c02:	3599                	jal	80000a48 <z_impl_k_timer_remaining_get>
80000c04:	84aa                	mv	s1,a0
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000c06:	2bc40513          	addi	a0,s0,700
80000c0a:	73b030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
	k_timer_start(&timer, DURATION, 0);
	busy_wait_ms(DURATION / 2);
	remaining = k_timer_remaining_get(&timer);
	k_timer_stop(&timer);
	zassert_true(remaining <= (DURATION / 2), NULL);
}
80000c0e:	4422                	lw	s0,8(sp)
80000c10:	40b2                	lw	ra,12(sp)
	zassert_true(remaining <= (DURATION / 2), NULL);
80000c12:	0334b513          	sltiu	a0,s1,51
}
80000c16:	4492                	lw	s1,4(sp)
	zassert_true(remaining <= (DURATION / 2), NULL);
80000c18:	800057b7          	lui	a5,0x80005
80000c1c:	80005737          	lui	a4,0x80005
80000c20:	80005637          	lui	a2,0x80005
80000c24:	800055b7          	lui	a1,0x80005
80000c28:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000c2c:	19870713          	addi	a4,a4,408 # 80005198 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005199>
80000c30:	20000693          	li	a3,512
80000c34:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000c38:	47858593          	addi	a1,a1,1144 # 80005478 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005479>
}
80000c3c:	0141                	addi	sp,sp,16
	zassert_true(remaining <= (DURATION / 2), NULL);
80000c3e:	bd1d                	j	80000a74 <z_zassert.constprop.6>

80000c40 <status_expire>:
{
80000c40:	1141                	addi	sp,sp,-16
80000c42:	c422                	sw	s0,8(sp)
80000c44:	c606                	sw	ra,12(sp)
80000c46:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000c48:	751030ef          	jal	ra,80004b98 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(timer) == 1, timer);
80000c4c:	4785                	li	a5,1
80000c4e:	02f50e63          	beq	a0,a5,80000c8a <status_expire+0x4a>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000c52:	8522                	mv	a0,s0
80000c54:	6f1030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000c58:	8522                	mv	a0,s0
80000c5a:	73f030ef          	jal	ra,80004b98 <z_impl_k_timer_status_get>
80000c5e:	157d                	addi	a0,a0,-1
80000c60:	800057b7          	lui	a5,0x80005
80000c64:	80005737          	lui	a4,0x80005
80000c68:	80005637          	lui	a2,0x80005
80000c6c:	800055b7          	lui	a1,0x80005
80000c70:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000c74:	09c70713          	addi	a4,a4,156 # 8000509c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000509d>
80000c78:	04b00693          	li	a3,75
80000c7c:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000c80:	21858593          	addi	a1,a1,536 # 80005218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005219>
80000c84:	00153513          	seqz	a0,a0
80000c88:	33f5                	jal	80000a74 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000c8a:	8522                	mv	a0,s0
80000c8c:	3b75                	jal	80000a48 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(timer) >= PERIOD, timer);
80000c8e:	03100793          	li	a5,49
80000c92:	02a7ee63          	bltu	a5,a0,80000cce <status_expire+0x8e>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000c96:	8522                	mv	a0,s0
80000c98:	6ad030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000c9c:	8522                	mv	a0,s0
80000c9e:	336d                	jal	80000a48 <z_impl_k_timer_remaining_get>
80000ca0:	03253513          	sltiu	a0,a0,50
80000ca4:	800057b7          	lui	a5,0x80005
80000ca8:	80005737          	lui	a4,0x80005
80000cac:	80005637          	lui	a2,0x80005
80000cb0:	800055b7          	lui	a1,0x80005
80000cb4:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000cb8:	09c70713          	addi	a4,a4,156 # 8000509c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000509d>
80000cbc:	04d00693          	li	a3,77
80000cc0:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000cc4:	24058593          	addi	a1,a1,576 # 80005240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005241>
80000cc8:	00154513          	xori	a0,a0,1
80000ccc:	3365                	jal	80000a74 <z_zassert.constprop.6>
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
80000cce:	800067b7          	lui	a5,0x80006
80000cd2:	2807a703          	lw	a4,640(a5) # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
80000cd6:	478d                	li	a5,3
80000cd8:	00e7d863          	bge	a5,a4,80000ce8 <status_expire+0xa8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000cdc:	8522                	mv	a0,s0
}
80000cde:	4422                	lw	s0,8(sp)
80000ce0:	40b2                	lw	ra,12(sp)
80000ce2:	0141                	addi	sp,sp,16
80000ce4:	6610306f          	j	80004b44 <z_impl_k_timer_stop>
80000ce8:	40b2                	lw	ra,12(sp)
80000cea:	4422                	lw	s0,8(sp)
80000cec:	0141                	addi	sp,sp,16
80000cee:	8082                	ret

80000cf0 <status_stop>:
{
80000cf0:	1141                	addi	sp,sp,-16
80000cf2:	c422                	sw	s0,8(sp)
80000cf4:	c606                	sw	ra,12(sp)
80000cf6:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000cf8:	3b81                	jal	80000a48 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000cfa:	cd15                	beqz	a0,80000d36 <status_stop+0x46>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000cfc:	8522                	mv	a0,s0
80000cfe:	647030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000d02:	8522                	mv	a0,s0
80000d04:	3391                	jal	80000a48 <z_impl_k_timer_remaining_get>
}
80000d06:	4422                	lw	s0,8(sp)
80000d08:	40b2                	lw	ra,12(sp)
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000d0a:	800057b7          	lui	a5,0x80005
80000d0e:	80005737          	lui	a4,0x80005
80000d12:	80005637          	lui	a2,0x80005
80000d16:	800055b7          	lui	a1,0x80005
80000d1a:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000d1e:	0ac70713          	addi	a4,a4,172 # 800050ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050ad>
80000d22:	05c00693          	li	a3,92
80000d26:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000d2a:	26c58593          	addi	a1,a1,620 # 8000526c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000526d>
80000d2e:	00153513          	seqz	a0,a0
}
80000d32:	0141                	addi	sp,sp,16
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000d34:	b381                	j	80000a74 <z_zassert.constprop.6>
}
80000d36:	40b2                	lw	ra,12(sp)
80000d38:	4422                	lw	s0,8(sp)
80000d3a:	0141                	addi	sp,sp,16
80000d3c:	8082                	ret

80000d3e <test_timer_status_get>:
{
80000d3e:	1141                	addi	sp,sp,-16
80000d40:	c606                	sw	ra,12(sp)
80000d42:	c422                	sw	s0,8(sp)
	init_timer_data();
80000d44:	3185                	jal	800009a4 <init_timer_data>
	k_timer_init(&timer, status_expire, status_stop);
80000d46:	80006437          	lui	s0,0x80006
80000d4a:	80001637          	lui	a2,0x80001
80000d4e:	800015b7          	lui	a1,0x80001
80000d52:	cf060613          	addi	a2,a2,-784 # 80000cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000cf1>
80000d56:	c4058593          	addi	a1,a1,-960 # 80000c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000c41>
80000d5a:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80000d5e:	52f030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000d62:	2bc40513          	addi	a0,s0,700
80000d66:	03200613          	li	a2,50
80000d6a:	06400593          	li	a1,100
80000d6e:	53d030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000d72:	2bc40513          	addi	a0,s0,700
80000d76:	623030ef          	jal	ra,80004b98 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(&timer) == 0, &timer);
80000d7a:	cd15                	beqz	a0,80000db6 <test_timer_status_get+0x78>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000d7c:	2bc40513          	addi	a0,s0,700
80000d80:	5c5030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000d84:	2bc40513          	addi	a0,s0,700
80000d88:	611030ef          	jal	ra,80004b98 <z_impl_k_timer_status_get>
80000d8c:	800057b7          	lui	a5,0x80005
80000d90:	80005737          	lui	a4,0x80005
80000d94:	80005637          	lui	a2,0x80005
80000d98:	800055b7          	lui	a1,0x80005
80000d9c:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000da0:	11c70713          	addi	a4,a4,284 # 8000511c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000511d>
80000da4:	11f00693          	li	a3,287
80000da8:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000dac:	4a058593          	addi	a1,a1,1184 # 800054a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054a1>
80000db0:	00153513          	seqz	a0,a0
80000db4:	31c1                	jal	80000a74 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000db6:	2bc40513          	addi	a0,s0,700
80000dba:	3179                	jal	80000a48 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(&timer) >= DURATION / 2, &timer);
80000dbc:	03100793          	li	a5,49
80000dc0:	04a7e063          	bltu	a5,a0,80000e00 <test_timer_status_get+0xc2>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000dc4:	2bc40513          	addi	a0,s0,700
80000dc8:	57d030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000dcc:	2bc40513          	addi	a0,s0,700
80000dd0:	39a5                	jal	80000a48 <z_impl_k_timer_remaining_get>
80000dd2:	03253513          	sltiu	a0,a0,50
80000dd6:	800057b7          	lui	a5,0x80005
80000dda:	80005737          	lui	a4,0x80005
80000dde:	80005637          	lui	a2,0x80005
80000de2:	800055b7          	lui	a1,0x80005
80000de6:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000dea:	11c70713          	addi	a4,a4,284 # 8000511c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000511d>
80000dee:	12100693          	li	a3,289
80000df2:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000df6:	4cc58593          	addi	a1,a1,1228 # 800054cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054cd>
80000dfa:	00154513          	xori	a0,a0,1
80000dfe:	399d                	jal	80000a74 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000e00:	2bc40513          	addi	a0,s0,700
}
80000e04:	4422                	lw	s0,8(sp)
80000e06:	40b2                	lw	ra,12(sp)
80000e08:	0141                	addi	sp,sp,16
80000e0a:	53b0306f          	j	80004b44 <z_impl_k_timer_stop>

80000e0e <test_timer_status_get_anytime>:
{
80000e0e:	1141                	addi	sp,sp,-16
80000e10:	c606                	sw	ra,12(sp)
80000e12:	c422                	sw	s0,8(sp)
	init_timer_data();
80000e14:	3e41                	jal	800009a4 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
80000e16:	80006437          	lui	s0,0x80006
80000e1a:	4601                	li	a2,0
80000e1c:	4581                	li	a1,0
80000e1e:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80000e22:	46b030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000e26:	03200613          	li	a2,50
80000e2a:	06400593          	li	a1,100
80000e2e:	2bc40513          	addi	a0,s0,700
80000e32:	479030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000e36:	00043537          	lui	a0,0x43
80000e3a:	23850513          	addi	a0,a0,568 # 43238 <CONFIG_RISCV_RAM_SIZE+0x3238>
80000e3e:	751020ef          	jal	ra,80003d8e <z_impl_k_busy_wait>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000e42:	2bc40513          	addi	a0,s0,700
80000e46:	553030ef          	jal	ra,80004b98 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(&timer) == EXPIRE_TIMES, &timer);
80000e4a:	4791                	li	a5,4
80000e4c:	04f50063          	beq	a0,a5,80000e8c <test_timer_status_get_anytime+0x7e>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000e50:	2bc40513          	addi	a0,s0,700
80000e54:	4f1030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000e58:	2bc40513          	addi	a0,s0,700
80000e5c:	53d030ef          	jal	ra,80004b98 <z_impl_k_timer_status_get>
80000e60:	1571                	addi	a0,a0,-4
80000e62:	800057b7          	lui	a5,0x80005
80000e66:	80005737          	lui	a4,0x80005
80000e6a:	80005637          	lui	a2,0x80005
80000e6e:	800055b7          	lui	a1,0x80005
80000e72:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000e76:	13470713          	addi	a4,a4,308 # 80005134 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005135>
80000e7a:	13e00693          	li	a3,318
80000e7e:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000e82:	50058593          	addi	a1,a1,1280 # 80005500 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005501>
80000e86:	00153513          	seqz	a0,a0
80000e8a:	36ed                	jal	80000a74 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000e8c:	2bc40513          	addi	a0,s0,700
}
80000e90:	4422                	lw	s0,8(sp)
80000e92:	40b2                	lw	ra,12(sp)
80000e94:	0141                	addi	sp,sp,16
80000e96:	4af0306f          	j	80004b44 <z_impl_k_timer_stop>

80000e9a <test_timer_status_sync>:
{
80000e9a:	7179                	addi	sp,sp,-48
80000e9c:	d606                	sw	ra,44(sp)
80000e9e:	d422                	sw	s0,40(sp)
80000ea0:	d226                	sw	s1,36(sp)
80000ea2:	d04a                	sw	s2,32(sp)
80000ea4:	ce4e                	sw	s3,28(sp)
80000ea6:	cc52                	sw	s4,24(sp)
80000ea8:	ca56                	sw	s5,20(sp)
80000eaa:	c85a                	sw	s6,16(sp)
80000eac:	c65e                	sw	s7,12(sp)
80000eae:	c462                	sw	s8,8(sp)
80000eb0:	c266                	sw	s9,4(sp)
80000eb2:	c06a                	sw	s10,0(sp)
	init_timer_data();
80000eb4:	3cc5                	jal	800009a4 <init_timer_data>
	k_timer_init(&timer, duration_expire, duration_stop);
80000eb6:	80006437          	lui	s0,0x80006
80000eba:	80001637          	lui	a2,0x80001
80000ebe:	800015b7          	lui	a1,0x80001
80000ec2:	9b660613          	addi	a2,a2,-1610 # 800009b6 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009b7>
80000ec6:	55e58593          	addi	a1,a1,1374 # 8000155e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000155f>
80000eca:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80000ece:	3bf030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000ed2:	03200613          	li	a2,50
80000ed6:	06400593          	li	a1,100
80000eda:	2bc40513          	addi	a0,s0,700
80000ede:	3cd030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
	for (int i = 0; i < EXPIRE_TIMES; i++) {
80000ee2:	4481                	li	s1,0
		TIMER_ASSERT(tdata.expire_cnt == i, &timer);
80000ee4:	80006ab7          	lui	s5,0x80006
80000ee8:	80005937          	lui	s2,0x80005
80000eec:	800059b7          	lui	s3,0x80005
80000ef0:	80005a37          	lui	s4,0x80005
80000ef4:	80005bb7          	lui	s7,0x80005
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80000ef8:	4b05                	li	s6,1
80000efa:	80005c37          	lui	s8,0x80005
		TIMER_ASSERT(tdata.expire_cnt == (i + 1), &timer);
80000efe:	80005cb7          	lui	s9,0x80005
		TIMER_ASSERT(tdata.expire_cnt == i, &timer);
80000f02:	280aa783          	lw	a5,640(s5) # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
80000f06:	280a8d13          	addi	s10,s5,640
80000f0a:	02978663          	beq	a5,s1,80000f36 <test_timer_status_sync+0x9c>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000f0e:	2bc40513          	addi	a0,s0,700
80000f12:	433030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80000f16:	000d2503          	lw	a0,0(s10)
80000f1a:	6b098793          	addi	a5,s3,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80000f1e:	15490713          	addi	a4,s2,340 # 80005154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005155>
80000f22:	8d05                	sub	a0,a0,s1
80000f24:	15c00693          	li	a3,348
80000f28:	608a0613          	addi	a2,s4,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80000f2c:	52cb8593          	addi	a1,s7,1324 # 8000552c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000552d>
80000f30:	00153513          	seqz	a0,a0
80000f34:	3681                	jal	80000a74 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80000f36:	2bc40513          	addi	a0,s0,700
80000f3a:	521030ef          	jal	ra,80004c5a <z_impl_k_timer_status_sync>
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80000f3e:	03650863          	beq	a0,s6,80000f6e <test_timer_status_sync+0xd4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000f42:	2bc40513          	addi	a0,s0,700
80000f46:	3ff030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80000f4a:	2bc40513          	addi	a0,s0,700
80000f4e:	50d030ef          	jal	ra,80004c5a <z_impl_k_timer_status_sync>
80000f52:	157d                	addi	a0,a0,-1
80000f54:	6b098793          	addi	a5,s3,1712
80000f58:	15490713          	addi	a4,s2,340
80000f5c:	15e00693          	li	a3,350
80000f60:	608a0613          	addi	a2,s4,1544
80000f64:	54cc0593          	addi	a1,s8,1356 # 8000554c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000554d>
80000f68:	00153513          	seqz	a0,a0
80000f6c:	3621                	jal	80000a74 <z_zassert.constprop.6>
		TIMER_ASSERT(tdata.expire_cnt == (i + 1), &timer);
80000f6e:	000d2783          	lw	a5,0(s10)
80000f72:	0485                	addi	s1,s1,1
80000f74:	02978663          	beq	a5,s1,80000fa0 <test_timer_status_sync+0x106>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000f78:	2bc40513          	addi	a0,s0,700
80000f7c:	3c9030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80000f80:	000d2503          	lw	a0,0(s10)
80000f84:	6b098793          	addi	a5,s3,1712
80000f88:	15490713          	addi	a4,s2,340
80000f8c:	8d05                	sub	a0,a0,s1
80000f8e:	16000693          	li	a3,352
80000f92:	608a0613          	addi	a2,s4,1544
80000f96:	578c8593          	addi	a1,s9,1400 # 80005578 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005579>
80000f9a:	00153513          	seqz	a0,a0
80000f9e:	3cd9                	jal	80000a74 <z_zassert.constprop.6>
	for (int i = 0; i < EXPIRE_TIMES; i++) {
80000fa0:	4791                	li	a5,4
80000fa2:	f6f490e3          	bne	s1,a5,80000f02 <test_timer_status_sync+0x68>
80000fa6:	2bc40513          	addi	a0,s0,700
}
80000faa:	5422                	lw	s0,40(sp)
80000fac:	50b2                	lw	ra,44(sp)
80000fae:	5492                	lw	s1,36(sp)
80000fb0:	5902                	lw	s2,32(sp)
80000fb2:	49f2                	lw	s3,28(sp)
80000fb4:	4a62                	lw	s4,24(sp)
80000fb6:	4ad2                	lw	s5,20(sp)
80000fb8:	4b42                	lw	s6,16(sp)
80000fba:	4bb2                	lw	s7,12(sp)
80000fbc:	4c22                	lw	s8,8(sp)
80000fbe:	4c92                	lw	s9,4(sp)
80000fc0:	4d02                	lw	s10,0(sp)
80000fc2:	6145                	addi	sp,sp,48
80000fc4:	3810306f          	j	80004b44 <z_impl_k_timer_stop>

80000fc8 <test_timer_k_define>:
{
80000fc8:	1141                	addi	sp,sp,-16
80000fca:	c606                	sw	ra,12(sp)
80000fcc:	c422                	sw	s0,8(sp)
80000fce:	c226                	sw	s1,4(sp)
80000fd0:	c04a                	sw	s2,0(sp)
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000fd2:	80006437          	lui	s0,0x80006
	init_timer_data();
80000fd6:	32f9                	jal	800009a4 <init_timer_data>
80000fd8:	03200613          	li	a2,50
80000fdc:	06400593          	li	a1,100
80000fe0:	11040513          	addi	a0,s0,272 # 80006110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006111>
80000fe4:	2c7030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
80000fe8:	800064b7          	lui	s1,0x80006

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_TIMER_USER_DATA_SET, k_timer_user_data_set, struct k_timer *, timer, void *, user_data)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000fec:	225030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
80000ff0:	28048913          	addi	s2,s1,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
80000ff4:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000ff8:	0004f537          	lui	a0,0x4f
80000ffc:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
80001000:	00b92623          	sw	a1,12(s2)
80001004:	58b020ef          	jal	ra,80003d8e <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &ktimer);
80001008:	00092703          	lw	a4,0(s2)
8000100c:	4791                	li	a5,4
8000100e:	28048493          	addi	s1,s1,640
80001012:	02f70d63          	beq	a4,a5,8000104c <test_timer_k_define+0x84>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001016:	11040513          	addi	a0,s0,272
8000101a:	32b030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
8000101e:	4088                	lw	a0,0(s1)
80001020:	800057b7          	lui	a5,0x80005
80001024:	80005737          	lui	a4,0x80005
80001028:	1571                	addi	a0,a0,-4
8000102a:	80005637          	lui	a2,0x80005
8000102e:	800055b7          	lui	a1,0x80005
80001032:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80001036:	16c70713          	addi	a4,a4,364 # 8000516c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000516d>
8000103a:	17f00693          	li	a3,383
8000103e:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80001042:	3c058593          	addi	a1,a1,960 # 800053c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053c1>
80001046:	00153513          	seqz	a0,a0
8000104a:	342d                	jal	80000a74 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &ktimer);
8000104c:	40d8                	lw	a4,4(s1)
8000104e:	4785                	li	a5,1
80001050:	02f70d63          	beq	a4,a5,8000108a <test_timer_k_define+0xc2>
80001054:	11040513          	addi	a0,s0,272
80001058:	2ed030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
8000105c:	40c8                	lw	a0,4(s1)
8000105e:	800057b7          	lui	a5,0x80005
80001062:	80005737          	lui	a4,0x80005
80001066:	157d                	addi	a0,a0,-1
80001068:	80005637          	lui	a2,0x80005
8000106c:	800055b7          	lui	a1,0x80005
80001070:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80001074:	16c70713          	addi	a4,a4,364 # 8000516c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000516d>
80001078:	18000693          	li	a3,384
8000107c:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80001080:	3e058593          	addi	a1,a1,992 # 800053e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053e1>
80001084:	00153513          	seqz	a0,a0
80001088:	32f5                	jal	80000a74 <z_zassert.constprop.6>
8000108a:	11040513          	addi	a0,s0,272
8000108e:	2b7030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
	init_timer_data();
80001092:	913ff0ef          	jal	ra,800009a4 <init_timer_data>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80001096:	03200613          	li	a2,50
8000109a:	06400593          	li	a1,100
8000109e:	11040513          	addi	a0,s0,272
800010a2:	209030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800010a6:	6531                	lui	a0,0xc
800010a8:	35050513          	addi	a0,a0,848 # c350 <CONFIG_ISR_STACK_SIZE+0xbb50>
800010ac:	4e3020ef          	jal	ra,80003d8e <z_impl_k_busy_wait>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800010b0:	03200613          	li	a2,50
800010b4:	06400593          	li	a1,100
800010b8:	11040513          	addi	a0,s0,272
800010bc:	1ef030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800010c0:	151030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
	tdata.timestamp = k_uptime_get();
800010c4:	c488                	sw	a0,8(s1)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800010c6:	0004f537          	lui	a0,0x4f
800010ca:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800010ce:	c4cc                	sw	a1,12(s1)
800010d0:	4bf020ef          	jal	ra,80003d8e <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &ktimer);
800010d4:	4098                	lw	a4,0(s1)
800010d6:	4791                	li	a5,4
800010d8:	02f70e63          	beq	a4,a5,80001114 <test_timer_k_define+0x14c>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800010dc:	11040513          	addi	a0,s0,272
800010e0:	265030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
800010e4:	4088                	lw	a0,0(s1)
800010e6:	800057b7          	lui	a5,0x80005
800010ea:	80005737          	lui	a4,0x80005
800010ee:	1571                	addi	a0,a0,-4
800010f0:	80005637          	lui	a2,0x80005
800010f4:	800055b7          	lui	a1,0x80005
800010f8:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800010fc:	16c70713          	addi	a4,a4,364 # 8000516c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000516d>
80001100:	19300693          	li	a3,403
80001104:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80001108:	3c058593          	addi	a1,a1,960 # 800053c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053c1>
8000110c:	00153513          	seqz	a0,a0
80001110:	965ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &ktimer);
80001114:	40d8                	lw	a4,4(s1)
80001116:	4785                	li	a5,1
80001118:	02f70e63          	beq	a4,a5,80001154 <test_timer_k_define+0x18c>
8000111c:	11040513          	addi	a0,s0,272
80001120:	225030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80001124:	40c8                	lw	a0,4(s1)
80001126:	800057b7          	lui	a5,0x80005
8000112a:	80005737          	lui	a4,0x80005
8000112e:	157d                	addi	a0,a0,-1
80001130:	80005637          	lui	a2,0x80005
80001134:	800055b7          	lui	a1,0x80005
80001138:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
8000113c:	16c70713          	addi	a4,a4,364 # 8000516c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000516d>
80001140:	19400693          	li	a3,404
80001144:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80001148:	3e058593          	addi	a1,a1,992 # 800053e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053e1>
8000114c:	00153513          	seqz	a0,a0
80001150:	925ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
80001154:	11040513          	addi	a0,s0,272
}
80001158:	4422                	lw	s0,8(sp)
8000115a:	40b2                	lw	ra,12(sp)
8000115c:	4492                	lw	s1,4(sp)
8000115e:	4902                	lw	s2,0(sp)
80001160:	0141                	addi	sp,sp,16
80001162:	1e30306f          	j	80004b44 <z_impl_k_timer_stop>

80001166 <test_timer_expirefn_null>:
{
80001166:	1141                	addi	sp,sp,-16
80001168:	c606                	sw	ra,12(sp)
8000116a:	c422                	sw	s0,8(sp)
8000116c:	c226                	sw	s1,4(sp)
	init_timer_data();
8000116e:	837ff0ef          	jal	ra,800009a4 <init_timer_data>
	k_timer_init(&timer, NULL, duration_stop);
80001172:	80006437          	lui	s0,0x80006
80001176:	80001637          	lui	a2,0x80001
8000117a:	9b660613          	addi	a2,a2,-1610 # 800009b6 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009b7>
8000117e:	4581                	li	a1,0
80001180:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80001184:	109030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80001188:	03200613          	li	a2,50
8000118c:	06400593          	li	a1,100
80001190:	2bc40513          	addi	a0,s0,700
80001194:	117030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80001198:	0004f537          	lui	a0,0x4f
8000119c:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800011a0:	3ef020ef          	jal	ra,80003d8e <z_impl_k_busy_wait>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800011a4:	2bc40513          	addi	a0,s0,700
	TIMER_ASSERT(tdata.expire_cnt == 0, &timer);
800011a8:	800064b7          	lui	s1,0x80006
800011ac:	199030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
800011b0:	2804a783          	lw	a5,640(s1) # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
800011b4:	28048493          	addi	s1,s1,640
800011b8:	cf85                	beqz	a5,800011f0 <test_timer_expirefn_null+0x8a>
800011ba:	2bc40513          	addi	a0,s0,700
800011be:	187030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
800011c2:	4088                	lw	a0,0(s1)
800011c4:	800057b7          	lui	a5,0x80005
800011c8:	80005737          	lui	a4,0x80005
800011cc:	80005637          	lui	a2,0x80005
800011d0:	800055b7          	lui	a1,0x80005
800011d4:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800011d8:	0e870713          	addi	a4,a4,232 # 800050e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e9>
800011dc:	0bf00693          	li	a3,191
800011e0:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
800011e4:	3a058593          	addi	a1,a1,928 # 800053a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a1>
800011e8:	00153513          	seqz	a0,a0
800011ec:	889ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &timer);
800011f0:	40d8                	lw	a4,4(s1)
800011f2:	4785                	li	a5,1
800011f4:	02f70e63          	beq	a4,a5,80001230 <test_timer_expirefn_null+0xca>
800011f8:	2bc40513          	addi	a0,s0,700
800011fc:	149030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80001200:	40c8                	lw	a0,4(s1)
80001202:	800057b7          	lui	a5,0x80005
80001206:	80005737          	lui	a4,0x80005
8000120a:	157d                	addi	a0,a0,-1
8000120c:	80005637          	lui	a2,0x80005
80001210:	800055b7          	lui	a1,0x80005
80001214:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
80001218:	0e870713          	addi	a4,a4,232 # 800050e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e9>
8000121c:	0c100693          	li	a3,193
80001220:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80001224:	3e058593          	addi	a1,a1,992 # 800053e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053e1>
80001228:	00153513          	seqz	a0,a0
8000122c:	849ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
80001230:	2bc40513          	addi	a0,s0,700
}
80001234:	4422                	lw	s0,8(sp)
80001236:	40b2                	lw	ra,12(sp)
80001238:	4492                	lw	s1,4(sp)
8000123a:	0141                	addi	sp,sp,16
8000123c:	1090306f          	j	80004b44 <z_impl_k_timer_stop>

80001240 <test_timer_period_0>:
{
80001240:	1141                	addi	sp,sp,-16
80001242:	c606                	sw	ra,12(sp)
80001244:	c422                	sw	s0,8(sp)
80001246:	c226                	sw	s1,4(sp)
80001248:	c04a                	sw	s2,0(sp)
	init_timer_data();
8000124a:	f5aff0ef          	jal	ra,800009a4 <init_timer_data>
	k_timer_init(&timer, period0_expire, NULL);
8000124e:	80006437          	lui	s0,0x80006
80001252:	800015b7          	lui	a1,0x80001
80001256:	4601                	li	a2,0
80001258:	9c658593          	addi	a1,a1,-1594 # 800009c6 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009c7>
8000125c:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80001260:	02d030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80001264:	4601                	li	a2,0
80001266:	06400593          	li	a1,100
8000126a:	2bc40513          	addi	a0,s0,700
8000126e:	03d030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
80001272:	800064b7          	lui	s1,0x80006
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001276:	79a030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
8000127a:	28048913          	addi	s2,s1,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
8000127e:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80001282:	6565                	lui	a0,0x19
80001284:	a8850513          	addi	a0,a0,-1400 # 18a88 <CONFIG_ISR_STACK_SIZE+0x18288>
80001288:	00b92623          	sw	a1,12(s2)
8000128c:	303020ef          	jal	ra,80003d8e <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == 1, &timer);
80001290:	00092703          	lw	a4,0(s2)
80001294:	4785                	li	a5,1
80001296:	28048493          	addi	s1,s1,640
8000129a:	02f70e63          	beq	a4,a5,800012d6 <test_timer_period_0+0x96>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
8000129e:	2bc40513          	addi	a0,s0,700
800012a2:	0a3030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
800012a6:	4088                	lw	a0,0(s1)
800012a8:	800057b7          	lui	a5,0x80005
800012ac:	80005737          	lui	a4,0x80005
800012b0:	157d                	addi	a0,a0,-1
800012b2:	80005637          	lui	a2,0x80005
800012b6:	800055b7          	lui	a1,0x80005
800012ba:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800012be:	0d470713          	addi	a4,a4,212 # 800050d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050d5>
800012c2:	09f00693          	li	a3,159
800012c6:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
800012ca:	40058593          	addi	a1,a1,1024 # 80005400 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005401>
800012ce:	00153513          	seqz	a0,a0
800012d2:	fa2ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 0, &timer);
800012d6:	40dc                	lw	a5,4(s1)
800012d8:	cf85                	beqz	a5,80001310 <test_timer_period_0+0xd0>
800012da:	2bc40513          	addi	a0,s0,700
800012de:	067030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
800012e2:	40c8                	lw	a0,4(s1)
800012e4:	800057b7          	lui	a5,0x80005
800012e8:	80005737          	lui	a4,0x80005
800012ec:	80005637          	lui	a2,0x80005
800012f0:	800055b7          	lui	a1,0x80005
800012f4:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800012f8:	0d470713          	addi	a4,a4,212 # 800050d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050d5>
800012fc:	0a000693          	li	a3,160
80001300:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
80001304:	42058593          	addi	a1,a1,1056 # 80005420 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005421>
80001308:	00153513          	seqz	a0,a0
8000130c:	f68ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
80001310:	2bc40513          	addi	a0,s0,700
}
80001314:	4422                	lw	s0,8(sp)
80001316:	40b2                	lw	ra,12(sp)
80001318:	4492                	lw	s1,4(sp)
8000131a:	4902                	lw	s2,0(sp)
8000131c:	0141                	addi	sp,sp,16
8000131e:	0270306f          	j	80004b44 <z_impl_k_timer_stop>

80001322 <test_timer_duration_period>:
{
80001322:	1141                	addi	sp,sp,-16
80001324:	c606                	sw	ra,12(sp)
80001326:	c422                	sw	s0,8(sp)
80001328:	c226                	sw	s1,4(sp)
8000132a:	c04a                	sw	s2,0(sp)
	init_timer_data();
8000132c:	e78ff0ef          	jal	ra,800009a4 <init_timer_data>
	k_timer_init(&timer, duration_expire, duration_stop);
80001330:	80006437          	lui	s0,0x80006
80001334:	80001637          	lui	a2,0x80001
80001338:	800015b7          	lui	a1,0x80001
8000133c:	9b660613          	addi	a2,a2,-1610 # 800009b6 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009b7>
80001340:	55e58593          	addi	a1,a1,1374 # 8000155e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000155f>
80001344:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80001348:	744030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
8000134c:	03200613          	li	a2,50
80001350:	06400593          	li	a1,100
80001354:	2bc40513          	addi	a0,s0,700
80001358:	752030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
8000135c:	800064b7          	lui	s1,0x80006
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001360:	6b0030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
80001364:	28048913          	addi	s2,s1,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
80001368:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
8000136c:	0004f537          	lui	a0,0x4f
80001370:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
80001374:	00b92623          	sw	a1,12(s2)
80001378:	217020ef          	jal	ra,80003d8e <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &timer);
8000137c:	00092703          	lw	a4,0(s2)
80001380:	4791                	li	a5,4
80001382:	28048493          	addi	s1,s1,640
80001386:	02f70e63          	beq	a4,a5,800013c2 <test_timer_duration_period+0xa0>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
8000138a:	2bc40513          	addi	a0,s0,700
8000138e:	7b6030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
80001392:	4088                	lw	a0,0(s1)
80001394:	800057b7          	lui	a5,0x80005
80001398:	80005737          	lui	a4,0x80005
8000139c:	1571                	addi	a0,a0,-4
8000139e:	80005637          	lui	a2,0x80005
800013a2:	800055b7          	lui	a1,0x80005
800013a6:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800013aa:	0b870713          	addi	a4,a4,184 # 800050b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050b9>
800013ae:	07f00693          	li	a3,127
800013b2:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
800013b6:	3c058593          	addi	a1,a1,960 # 800053c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053c1>
800013ba:	00153513          	seqz	a0,a0
800013be:	eb6ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &timer);
800013c2:	40d8                	lw	a4,4(s1)
800013c4:	4785                	li	a5,1
800013c6:	02f70e63          	beq	a4,a5,80001402 <test_timer_duration_period+0xe0>
800013ca:	2bc40513          	addi	a0,s0,700
800013ce:	776030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
800013d2:	40c8                	lw	a0,4(s1)
800013d4:	800057b7          	lui	a5,0x80005
800013d8:	80005737          	lui	a4,0x80005
800013dc:	157d                	addi	a0,a0,-1
800013de:	80005637          	lui	a2,0x80005
800013e2:	800055b7          	lui	a1,0x80005
800013e6:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800013ea:	0b870713          	addi	a4,a4,184 # 800050b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050b9>
800013ee:	08000693          	li	a3,128
800013f2:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
800013f6:	3e058593          	addi	a1,a1,992 # 800053e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053e1>
800013fa:	00153513          	seqz	a0,a0
800013fe:	e76ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
80001402:	2bc40513          	addi	a0,s0,700
}
80001406:	4422                	lw	s0,8(sp)
80001408:	40b2                	lw	ra,12(sp)
8000140a:	4492                	lw	s1,4(sp)
8000140c:	4902                	lw	s2,0(sp)
8000140e:	0141                	addi	sp,sp,16
80001410:	7340306f          	j	80004b44 <z_impl_k_timer_stop>

80001414 <test_timer_periodicity>:
{
80001414:	7179                	addi	sp,sp,-48
80001416:	d422                	sw	s0,40(sp)
	k_timer_init(&sync_timer, NULL, NULL);
80001418:	80006437          	lui	s0,0x80006
8000141c:	29040513          	addi	a0,s0,656 # 80006290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006291>
80001420:	4601                	li	a2,0
80001422:	4581                	li	a1,0
{
80001424:	d606                	sw	ra,44(sp)
80001426:	d226                	sw	s1,36(sp)
80001428:	d04a                	sw	s2,32(sp)
8000142a:	ce4e                	sw	s3,28(sp)
8000142c:	cc52                	sw	s4,24(sp)
8000142e:	ca56                	sw	s5,20(sp)
80001430:	c85a                	sw	s6,16(sp)
80001432:	c65e                	sw	s7,12(sp)
80001434:	c462                	sw	s8,8(sp)
80001436:	c266                	sw	s9,4(sp)
	k_timer_init(&sync_timer, NULL, NULL);
80001438:	654030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
8000143c:	4605                	li	a2,1
8000143e:	4581                	li	a1,0
80001440:	29040513          	addi	a0,s0,656
80001444:	666030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80001448:	29040513          	addi	a0,s0,656
8000144c:	00f030ef          	jal	ra,80004c5a <z_impl_k_timer_status_sync>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001450:	29040513          	addi	a0,s0,656
80001454:	6f0030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
	k_timer_init(&timer, NULL, NULL);
80001458:	80006437          	lui	s0,0x80006
	init_timer_data();
8000145c:	d48ff0ef          	jal	ra,800009a4 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
80001460:	4601                	li	a2,0
80001462:	4581                	li	a1,0
80001464:	2bc40513          	addi	a0,s0,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80001468:	624030ef          	jal	ra,80004a8c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
8000146c:	03200613          	li	a2,50
80001470:	4581                	li	a1,0
80001472:	2bc40513          	addi	a0,s0,700
80001476:	634030ef          	jal	ra,80004aaa <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
8000147a:	2bc40513          	addi	a0,s0,700
8000147e:	7dc030ef          	jal	ra,80004c5a <z_impl_k_timer_status_sync>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001482:	58e030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
	tdata.timestamp = k_uptime_get();
80001486:	800064b7          	lui	s1,0x80006
8000148a:	28048793          	addi	a5,s1,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
8000148e:	c788                	sw	a0,8(a5)
80001490:	c7cc                	sw	a1,12(a5)
80001492:	4911                	li	s2,4
80001494:	28048493          	addi	s1,s1,640
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80001498:	4985                	li	s3,1
8000149a:	80005ab7          	lui	s5,0x80005
8000149e:	80005b37          	lui	s6,0x80005
800014a2:	80005bb7          	lui	s7,0x80005
800014a6:	80005c37          	lui	s8,0x80005
800014aa:	fce00a13          	li	s4,-50
		TIMER_ASSERT(WITHIN_ERROR(delta, PERIOD, 1), &timer);
800014ae:	80005cb7          	lui	s9,0x80005
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
800014b2:	2bc40513          	addi	a0,s0,700
800014b6:	7a4030ef          	jal	ra,80004c5a <z_impl_k_timer_status_sync>
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
800014ba:	03350963          	beq	a0,s3,800014ec <test_timer_periodicity+0xd8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800014be:	2bc40513          	addi	a0,s0,700
800014c2:	682030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
800014c6:	2bc40513          	addi	a0,s0,700
800014ca:	790030ef          	jal	ra,80004c5a <z_impl_k_timer_status_sync>
800014ce:	157d                	addi	a0,a0,-1
800014d0:	6b0b0793          	addi	a5,s6,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800014d4:	104a8713          	addi	a4,s5,260 # 80005104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005105>
800014d8:	0fc00693          	li	a3,252
800014dc:	608b8613          	addi	a2,s7,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
800014e0:	54cc0593          	addi	a1,s8,1356 # 8000554c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000554d>
800014e4:	00153513          	seqz	a0,a0
800014e8:	d8cff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800014ec:	524030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
static inline s64_t k_uptime_delta(s64_t *reftime)
{
	s64_t uptime, delta;

	uptime = k_uptime_get();
	delta = uptime - *reftime;
800014f0:	449c                	lw	a5,8(s1)
800014f2:	44d8                	lw	a4,12(s1)
	*reftime = uptime;
800014f4:	c488                	sw	a0,8(s1)
800014f6:	40fa07b3          	sub	a5,s4,a5
800014fa:	00fa36b3          	sltu	a3,s4,a5
800014fe:	fff74713          	not	a4,a4
80001502:	8f15                	sub	a4,a4,a3
		TIMER_ASSERT(WITHIN_ERROR(delta, PERIOD, 1), &timer);
80001504:	97aa                	add	a5,a5,a0
80001506:	c4cc                	sw	a1,12(s1)
80001508:	00a7b533          	sltu	a0,a5,a0
8000150c:	95ba                	add	a1,a1,a4
8000150e:	952e                	add	a0,a0,a1
80001510:	e119                	bnez	a0,80001516 <test_timer_periodicity+0x102>
80001512:	02f9f363          	bgeu	s3,a5,80001538 <test_timer_periodicity+0x124>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001516:	2bc40513          	addi	a0,s0,700
8000151a:	62a030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
8000151e:	6b0b0793          	addi	a5,s6,1712
80001522:	104a8713          	addi	a4,s5,260
80001526:	10300693          	li	a3,259
8000152a:	608b8613          	addi	a2,s7,1544
8000152e:	440c8593          	addi	a1,s9,1088 # 80005440 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005441>
80001532:	4501                	li	a0,0
80001534:	d40ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
80001538:	197d                	addi	s2,s2,-1
	for (int i = 0; i < EXPIRE_TIMES; i++) {
8000153a:	f6091ce3          	bnez	s2,800014b2 <test_timer_periodicity+0x9e>
8000153e:	2bc40513          	addi	a0,s0,700
}
80001542:	5422                	lw	s0,40(sp)
80001544:	50b2                	lw	ra,44(sp)
80001546:	5492                	lw	s1,36(sp)
80001548:	5902                	lw	s2,32(sp)
8000154a:	49f2                	lw	s3,28(sp)
8000154c:	4a62                	lw	s4,24(sp)
8000154e:	4ad2                	lw	s5,20(sp)
80001550:	4b42                	lw	s6,16(sp)
80001552:	4bb2                	lw	s7,12(sp)
80001554:	4c22                	lw	s8,8(sp)
80001556:	4c92                	lw	s9,4(sp)
80001558:	6145                	addi	sp,sp,48
8000155a:	5ea0306f          	j	80004b44 <z_impl_k_timer_stop>

8000155e <duration_expire>:
{
8000155e:	1141                	addi	sp,sp,-16
80001560:	c422                	sw	s0,8(sp)
	tdata.expire_cnt++;
80001562:	80006437          	lui	s0,0x80006
80001566:	28040713          	addi	a4,s0,640 # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
8000156a:	431c                	lw	a5,0(a4)
{
8000156c:	c226                	sw	s1,4(sp)
8000156e:	c606                	sw	ra,12(sp)
	tdata.expire_cnt++;
80001570:	0785                	addi	a5,a5,1
80001572:	c31c                	sw	a5,0(a4)
	if (tdata.expire_cnt == 1) {
80001574:	4705                	li	a4,1
{
80001576:	84aa                	mv	s1,a0
80001578:	28040413          	addi	s0,s0,640
	if (tdata.expire_cnt == 1) {
8000157c:	0ae79263          	bne	a5,a4,80001620 <duration_expire+0xc2>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001580:	490030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001584:	4418                	lw	a4,8(s0)
80001586:	445c                	lw	a5,12(s0)
	*reftime = uptime;
80001588:	c408                	sw	a0,8(s0)
	delta = uptime - *reftime;
8000158a:	40e50733          	sub	a4,a0,a4
8000158e:	00e536b3          	sltu	a3,a0,a4
80001592:	40f587b3          	sub	a5,a1,a5
80001596:	8f95                	sub	a5,a5,a3
	*reftime = uptime;
80001598:	c44c                	sw	a1,12(s0)
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= DURATION,
8000159a:	06f04463          	bgtz	a5,80001602 <duration_expire+0xa4>
8000159e:	e789                	bnez	a5,800015a8 <duration_expire+0x4a>
800015a0:	06300793          	li	a5,99
800015a4:	04e7ef63          	bltu	a5,a4,80001602 <duration_expire+0xa4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800015a8:	8526                	mv	a0,s1
800015aa:	59a030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800015ae:	462030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
800015b2:	4414                	lw	a3,8(s0)
800015b4:	445c                	lw	a5,12(s0)
	*reftime = uptime;
800015b6:	c408                	sw	a0,8(s0)
	delta = uptime - *reftime;
800015b8:	40d506b3          	sub	a3,a0,a3
800015bc:	00d53733          	sltu	a4,a0,a3
800015c0:	40f587b3          	sub	a5,a1,a5
800015c4:	8f99                	sub	a5,a5,a4
	*reftime = uptime;
800015c6:	c44c                	sw	a1,12(s0)
800015c8:	80005737          	lui	a4,0x80005
800015cc:	4505                	li	a0,1
800015ce:	00f04863          	bgtz	a5,800015de <duration_expire+0x80>
800015d2:	e789                	bnez	a5,800015dc <duration_expire+0x7e>
800015d4:	06300793          	li	a5,99
800015d8:	00d7e363          	bltu	a5,a3,800015de <duration_expire+0x80>
800015dc:	4501                	li	a0,0
800015de:	800057b7          	lui	a5,0x80005
800015e2:	80005637          	lui	a2,0x80005
800015e6:	800055b7          	lui	a1,0x80005
800015ea:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
800015ee:	08c70713          	addi	a4,a4,140 # 8000508c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000508d>
800015f2:	03300693          	li	a3,51
800015f6:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
800015fa:	1b458593          	addi	a1,a1,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= PERIOD, timer);
800015fe:	c76ff0ef          	jal	ra,80000a74 <z_zassert.constprop.6>
80001602:	40e030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
80001606:	4018                	lw	a4,0(s0)
	tdata.timestamp = k_uptime_get();
80001608:	c408                	sw	a0,8(s0)
8000160a:	c44c                	sw	a1,12(s0)
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
8000160c:	478d                	li	a5,3
8000160e:	08e7d963          	bge	a5,a4,800016a0 <duration_expire+0x142>
}
80001612:	4422                	lw	s0,8(sp)
80001614:	40b2                	lw	ra,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001616:	8526                	mv	a0,s1
80001618:	4492                	lw	s1,4(sp)
8000161a:	0141                	addi	sp,sp,16
8000161c:	5280306f          	j	80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001620:	3f0030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001624:	4418                	lw	a4,8(s0)
80001626:	445c                	lw	a5,12(s0)
	*reftime = uptime;
80001628:	c408                	sw	a0,8(s0)
	delta = uptime - *reftime;
8000162a:	40e50733          	sub	a4,a0,a4
8000162e:	00e536b3          	sltu	a3,a0,a4
80001632:	40f587b3          	sub	a5,a1,a5
80001636:	8f95                	sub	a5,a5,a3
	*reftime = uptime;
80001638:	c44c                	sw	a1,12(s0)
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= PERIOD, timer);
8000163a:	fcf044e3          	bgtz	a5,80001602 <duration_expire+0xa4>
8000163e:	e789                	bnez	a5,80001648 <duration_expire+0xea>
80001640:	03100793          	li	a5,49
80001644:	fae7efe3          	bltu	a5,a4,80001602 <duration_expire+0xa4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001648:	8526                	mv	a0,s1
8000164a:	4fa030ef          	jal	ra,80004b44 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
8000164e:	3c2030ef          	jal	ra,80004a10 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001652:	4414                	lw	a3,8(s0)
80001654:	445c                	lw	a5,12(s0)
	*reftime = uptime;
80001656:	c408                	sw	a0,8(s0)
	delta = uptime - *reftime;
80001658:	40d506b3          	sub	a3,a0,a3
8000165c:	00d53733          	sltu	a4,a0,a3
80001660:	40f587b3          	sub	a5,a1,a5
80001664:	8f99                	sub	a5,a5,a4
	*reftime = uptime;
80001666:	c44c                	sw	a1,12(s0)
80001668:	80005737          	lui	a4,0x80005
8000166c:	4505                	li	a0,1
8000166e:	00f04863          	bgtz	a5,8000167e <duration_expire+0x120>
80001672:	e789                	bnez	a5,8000167c <duration_expire+0x11e>
80001674:	03100793          	li	a5,49
80001678:	00d7e363          	bltu	a5,a3,8000167e <duration_expire+0x120>
8000167c:	4501                	li	a0,0
8000167e:	800057b7          	lui	a5,0x80005
80001682:	80005637          	lui	a2,0x80005
80001686:	800055b7          	lui	a1,0x80005
8000168a:	6b078793          	addi	a5,a5,1712 # 800056b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b1>
8000168e:	08c70713          	addi	a4,a4,140 # 8000508c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000508d>
80001692:	03500693          	li	a3,53
80001696:	60860613          	addi	a2,a2,1544 # 80005608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005609>
8000169a:	1e858593          	addi	a1,a1,488 # 800051e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e9>
8000169e:	b785                	j	800015fe <duration_expire+0xa0>
}
800016a0:	40b2                	lw	ra,12(sp)
800016a2:	4422                	lw	s0,8(sp)
800016a4:	4492                	lw	s1,4(sp)
800016a6:	0141                	addi	sp,sp,16
800016a8:	8082                	ret

800016aa <test_main>:
			 ztest_unit_test(test_timer_status_get_anytime),
			 ztest_unit_test(test_timer_status_sync),
			 ztest_unit_test(test_timer_k_define),
			 ztest_unit_test(test_timer_user_data),
			 ztest_unit_test(test_timer_remaining_get));
	ztest_run_test_suite(timer_api);
800016aa:	800065b7          	lui	a1,0x80006
800016ae:	80005537          	lui	a0,0x80005
800016b2:	fe858593          	addi	a1,a1,-24 # 80005fe8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fe9>
800016b6:	39450513          	addi	a0,a0,916 # 80005394 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005395>
800016ba:	5270006f          	j	800023e0 <z_ztest_run_test_suite>

800016be <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
800016be:	1141                	addi	sp,sp,-16
800016c0:	c606                	sw	ra,12(sp)
800016c2:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
800016c4:	4799                	li	a5,6
800016c6:	02f50263          	beq	a0,a5,800016ea <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
800016ca:	6a6020ef          	jal	ra,80003d70 <k_is_in_isr>
800016ce:	c10d                	beqz	a0,800016f0 <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
800016d0:	6a0020ef          	jal	ra,80003d70 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
800016d4:	e121                	bnez	a0,80001714 <z_SysFatalErrorHandler+0x56>
800016d6:	800065b7          	lui	a1,0x80006
800016da:	90c58593          	addi	a1,a1,-1780 # 8000590c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000590d>
800016de:	80006537          	lui	a0,0x80006
800016e2:	92050513          	addi	a0,a0,-1760 # 80005920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005921>
800016e6:	7a0000ef          	jal	ra,80001e86 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
800016ea:	7e2000ef          	jal	ra,80001ecc <k_cpu_idle>
800016ee:	bff5                	j	800016ea <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
800016f0:	68e020ef          	jal	ra,80003d7e <z_is_thread_essential>
800016f4:	fd71                	bnez	a0,800016d0 <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
800016f6:	80006437          	lui	s0,0x80006
800016fa:	45c40413          	addi	s0,s0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
800016fe:	440c                	lw	a1,8(s0)
80001700:	80006537          	lui	a0,0x80006
80001704:	94050513          	addi	a0,a0,-1728 # 80005940 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005941>
80001708:	77e000ef          	jal	ra,80001e86 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000170c:	4408                	lw	a0,8(s0)
8000170e:	1cf020ef          	jal	ra,800040dc <z_impl_k_thread_abort>
80001712:	bfe1                	j	800016ea <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
80001714:	800065b7          	lui	a1,0x80006
80001718:	90858593          	addi	a1,a1,-1784 # 80005908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005909>
8000171c:	b7c9                	j	800016de <z_SysFatalErrorHandler+0x20>

8000171e <z_NanoFatalErrorHandler>:
{
8000171e:	715d                	addi	sp,sp,-80
80001720:	c4a2                	sw	s0,72(sp)
80001722:	c2a6                	sw	s1,68(sp)
80001724:	c686                	sw	ra,76(sp)
	switch (reason) {
80001726:	4799                	li	a5,6
{
80001728:	84aa                	mv	s1,a0
8000172a:	842e                	mv	s0,a1
	switch (reason) {
8000172c:	08a7e763          	bltu	a5,a0,800017ba <z_NanoFatalErrorHandler+0x9c>
80001730:	80005737          	lui	a4,0x80005
80001734:	00251793          	slli	a5,a0,0x2
80001738:	65c70713          	addi	a4,a4,1628 # 8000565c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000565d>
8000173c:	97ba                	add	a5,a5,a4
8000173e:	439c                	lw	a5,0(a5)
80001740:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80001742:	80005537          	lui	a0,0x80005
80001746:	78c50513          	addi	a0,a0,1932 # 8000578c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000578d>
		printk("***** Kernel OOPS! *****\n");
8000174a:	2f35                	jal	80001e86 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000174c:	34a020ef          	jal	ra,80003a96 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80001750:	407c                	lw	a5,68(s0)
80001752:	01042883          	lw	a7,16(s0)
80001756:	00c42803          	lw	a6,12(s0)
8000175a:	d83e                	sw	a5,48(sp)
8000175c:	403c                	lw	a5,64(s0)
8000175e:	4058                	lw	a4,4(s0)
80001760:	4014                	lw	a3,0(s0)
80001762:	d63e                	sw	a5,44(sp)
80001764:	5c5c                	lw	a5,60(s0)
80001766:	4430                	lw	a2,72(s0)
80001768:	85aa                	mv	a1,a0
8000176a:	d43e                	sw	a5,40(sp)
8000176c:	5c1c                	lw	a5,56(s0)
8000176e:	80006537          	lui	a0,0x80006
80001772:	81050513          	addi	a0,a0,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
80001776:	d23e                	sw	a5,36(sp)
80001778:	585c                	lw	a5,52(s0)
8000177a:	d03e                	sw	a5,32(sp)
8000177c:	581c                	lw	a5,48(s0)
8000177e:	ce3e                	sw	a5,28(sp)
80001780:	545c                	lw	a5,44(s0)
80001782:	cc3e                	sw	a5,24(sp)
80001784:	541c                	lw	a5,40(s0)
80001786:	ca3e                	sw	a5,20(sp)
80001788:	505c                	lw	a5,36(s0)
8000178a:	c83e                	sw	a5,16(sp)
8000178c:	501c                	lw	a5,32(s0)
8000178e:	c63e                	sw	a5,12(sp)
80001790:	4c5c                	lw	a5,28(s0)
80001792:	c43e                	sw	a5,8(sp)
80001794:	4c1c                	lw	a5,24(s0)
80001796:	c23e                	sw	a5,4(sp)
80001798:	485c                	lw	a5,20(s0)
8000179a:	c03e                	sw	a5,0(sp)
8000179c:	441c                	lw	a5,8(s0)
8000179e:	25e5                	jal	80001e86 <printk>
	z_SysFatalErrorHandler(reason, esf);
800017a0:	85a2                	mv	a1,s0
800017a2:	8526                	mv	a0,s1
800017a4:	3f29                	jal	800016be <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
800017a6:	80005537          	lui	a0,0x80005
800017aa:	7b450513          	addi	a0,a0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800017ae:	bf71                	j	8000174a <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
800017b0:	80005537          	lui	a0,0x80005
800017b4:	7d050513          	addi	a0,a0,2000 # 800057d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d1>
800017b8:	bf49                	j	8000174a <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
800017ba:	80005537          	lui	a0,0x80005
800017be:	85a6                	mv	a1,s1
800017c0:	7ec50513          	addi	a0,a0,2028 # 800057ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057ed>
800017c4:	25c9                	jal	80001e86 <printk>
		break;
800017c6:	b759                	j	8000174c <z_NanoFatalErrorHandler+0x2e>

800017c8 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
800017c8:	1141                	addi	sp,sp,-16
800017ca:	c422                	sw	s0,8(sp)
800017cc:	c606                	sw	ra,12(sp)
800017ce:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
800017d0:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
800017d4:	0606                	slli	a2,a2,0x1
800017d6:	8205                	srli	a2,a2,0x1
	switch (cause) {
800017d8:	4795                	li	a5,5
800017da:	02c7e263          	bltu	a5,a2,800017fe <_Fault+0x36>
800017de:	80005737          	lui	a4,0x80005
800017e2:	00261793          	slli	a5,a2,0x2
800017e6:	67870713          	addi	a4,a4,1656 # 80005678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005679>
800017ea:	97ba                	add	a5,a5,a4
800017ec:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
800017ee:	80005537          	lui	a0,0x80005
800017f2:	69850513          	addi	a0,a0,1688 # 80005698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005699>
800017f6:	2d41                	jal	80001e86 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
800017f8:	85a2                	mv	a1,s0
800017fa:	4501                	li	a0,0
800017fc:	370d                	jal	8000171e <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
800017fe:	800055b7          	lui	a1,0x80005
80001802:	69058593          	addi	a1,a1,1680 # 80005690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005691>
80001806:	b7e5                	j	800017ee <_Fault+0x26>

80001808 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80001808:	1141                	addi	sp,sp,-16
8000180a:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
8000180c:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001810:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80001814:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001816:	8185                	srli	a1,a1,0x1
80001818:	96850513          	addi	a0,a0,-1688 # 80005968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005969>
8000181c:	25ad                	jal	80001e86 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
8000181e:	800055b7          	lui	a1,0x80005
80001822:	6b458593          	addi	a1,a1,1716 # 800056b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b5>
80001826:	4511                	li	a0,4
80001828:	3ddd                	jal	8000171e <z_NanoFatalErrorHandler>

8000182a <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
8000182a:	800067b7          	lui	a5,0x80006
8000182e:	24078793          	addi	a5,a5,576 # 80006240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006241>
80001832:	4398                	lw	a4,0(a5)
80001834:	cb11                	beqz	a4,80001848 <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
80001836:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
8000183a:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
8000183e:	800067b7          	lui	a5,0x80006
80001842:	2447a503          	lw	a0,580(a5) # 80006244 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006245>
80001846:	8302                	jr	t1
}
80001848:	8082                	ret

8000184a <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
8000184a:	1141                	addi	sp,sp,-16
8000184c:	c606                	sw	ra,12(sp)
	z_bss_zero();
8000184e:	623000ef          	jal	ra,80002670 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001852:	2d49                	jal	80001ee4 <soc_interrupt_init>
#endif
	z_cstart();
80001854:	671000ef          	jal	ra,800026c4 <z_cstart>

80001858 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001858:	7179                	addi	sp,sp,-48
8000185a:	d422                	sw	s0,40(sp)
8000185c:	d226                	sw	s1,36(sp)
8000185e:	d04a                	sw	s2,32(sp)
80001860:	ce4e                	sw	s3,28(sp)
80001862:	cc52                	sw	s4,24(sp)
80001864:	ca56                	sw	s5,20(sp)
80001866:	c85a                	sw	s6,16(sp)
80001868:	c65e                	sw	s7,12(sp)
8000186a:	8b3e                	mv	s6,a5
8000186c:	d606                	sw	ra,44(sp)
8000186e:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001870:	47bd                	li	a5,15
{
80001872:	84aa                	mv	s1,a0
80001874:	842e                	mv	s0,a1
80001876:	89b2                	mv	s3,a2
80001878:	8a36                	mv	s4,a3
8000187a:	8bba                	mv	s7,a4
8000187c:	8ac2                	mv	s5,a6
8000187e:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001880:	06f89463          	bne	a7,a5,800018e8 <z_new_thread+0x90>
80001884:	800027b7          	lui	a5,0x80002
80001888:	64a78793          	addi	a5,a5,1610 # 8000264a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000264b>
8000188c:	06f69363          	bne	a3,a5,800018f2 <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001890:	56c2                	lw	a3,48(sp)
80001892:	85ca                	mv	a1,s2
80001894:	8526                	mv	a0,s1
80001896:	4611                	li	a2,4
80001898:	5a6020ef          	jal	ra,80003e3e <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
8000189c:	fb098593          	addi	a1,s3,-80
800018a0:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800018a2:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
800018a4:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
800018a8:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
800018ac:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800018ae:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
800018b2:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800018b4:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
800018b8:	50b2                	lw	ra,44(sp)
800018ba:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800018bc:	99c78793          	addi	a5,a5,-1636 # 8000099c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000099d>
	stack_init->a0 = (u32_t)thread_func;
800018c0:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
800018c4:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
800018c8:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
800018cc:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800018d0:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
800018d2:	d48c                	sw	a1,40(s1)
}
800018d4:	5902                	lw	s2,32(sp)
800018d6:	5492                	lw	s1,36(sp)
800018d8:	49f2                	lw	s3,28(sp)
800018da:	4a62                	lw	s4,24(sp)
800018dc:	4ad2                	lw	s5,20(sp)
800018de:	4b42                	lw	s6,16(sp)
800018e0:	4bb2                	lw	s7,12(sp)
800018e2:	4c22                	lw	s8,8(sp)
800018e4:	6145                	addi	sp,sp,48
800018e6:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800018e8:	01088693          	addi	a3,a7,16
800018ec:	47f9                	li	a5,30
800018ee:	fad7f1e3          	bgeu	a5,a3,80001890 <z_new_thread+0x38>
800018f2:	80006c37          	lui	s8,0x80006
800018f6:	800065b7          	lui	a1,0x80006
800018fa:	80006537          	lui	a0,0x80006
800018fe:	990c0613          	addi	a2,s8,-1648 # 80005990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005991>
80001902:	46e1                	li	a3,24
80001904:	9b058593          	addi	a1,a1,-1616 # 800059b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059b1>
80001908:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000190c:	2bad                	jal	80001e86 <printk>
8000190e:	80006537          	lui	a0,0x80006
80001912:	85ca                	mv	a1,s2
80001914:	56c1                	li	a3,-16
80001916:	4639                	li	a2,14
80001918:	a5c50513          	addi	a0,a0,-1444 # 80005a5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a5d>
8000191c:	23ad                	jal	80001e86 <printk>
8000191e:	45e1                	li	a1,24
80001920:	990c0513          	addi	a0,s8,-1648
80001924:	2341                	jal	80001ea4 <assert_post_action>
80001926:	b7ad                	j	80001890 <z_new_thread+0x38>

80001928 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001928:	00159793          	slli	a5,a1,0x1
8000192c:	97ae                	add	a5,a5,a1
8000192e:	00279713          	slli	a4,a5,0x2
80001932:	455c                	lw	a5,12(a0)
80001934:	97ba                	add	a5,a5,a4
80001936:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
8000193a:	00b75363          	bge	a4,a1,80001940 <get_bit_ptr+0x18>
8000193e:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001940:	41f65713          	srai	a4,a2,0x1f
80001944:	8b7d                	andi	a4,a4,31
80001946:	9732                	add	a4,a4,a2
80001948:	8715                	srai	a4,a4,0x5
8000194a:	070a                	slli	a4,a4,0x2
8000194c:	97ba                	add	a5,a5,a4
8000194e:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
80001950:	01f67513          	andi	a0,a2,31
80001954:	8082                	ret

80001956 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001956:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001958:	0074                	addi	a3,sp,12
{
8000195a:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
8000195c:	37f1                	jal	80001928 <get_bit_ptr>

	*word |= (1<<bit);
8000195e:	4732                	lw	a4,12(sp)
80001960:	4785                	li	a5,1
80001962:	00a79533          	sll	a0,a5,a0
80001966:	431c                	lw	a5,0(a4)
}
80001968:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
8000196a:	8fc9                	or	a5,a5,a0
8000196c:	c31c                	sw	a5,0(a4)
}
8000196e:	6105                	addi	sp,sp,32
80001970:	8082                	ret

80001972 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001972:	1101                	addi	sp,sp,-32
80001974:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001976:	4144                	lw	s1,4(a0)
{
80001978:	cc22                	sw	s0,24(sp)
8000197a:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000197c:	00855503          	lhu	a0,8(a0)
80001980:	85a6                	mv	a1,s1
{
80001982:	c84a                	sw	s2,16(sp)
80001984:	c64e                	sw	s3,12(sp)
80001986:	c452                	sw	s4,8(sp)
80001988:	c256                	sw	s5,4(sp)
8000198a:	c05a                	sw	s6,0(sp)
8000198c:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000198e:	e8ffe0ef          	jal	ra,8000081c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001992:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001996:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
8000199a:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000199c:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
8000199e:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
800019a0:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
800019a4:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
800019a6:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
800019a8:	03594163          	blt	s2,s5,800019ca <z_sys_mem_pool_base_init+0x58>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
800019ac:	4481                	li	s1,0
800019ae:	00845783          	lhu	a5,8(s0)
800019b2:	04f4cf63          	blt	s1,a5,80001a10 <z_sys_mem_pool_base_init+0x9e>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
800019b6:	40f2                	lw	ra,28(sp)
800019b8:	4462                	lw	s0,24(sp)
800019ba:	44d2                	lw	s1,20(sp)
800019bc:	4942                	lw	s2,16(sp)
800019be:	49b2                	lw	s3,12(sp)
800019c0:	4a22                	lw	s4,8(sp)
800019c2:	4a92                	lw	s5,4(sp)
800019c4:	4b02                	lw	s6,0(sp)
800019c6:	6105                	addi	sp,sp,32
800019c8:	8082                	ret
		int nblocks = buflen / sz;
800019ca:	85a6                	mv	a1,s1
800019cc:	8552                	mv	a0,s4
800019ce:	f0bfe0ef          	jal	ra,800008d8 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
800019d2:	00191713          	slli	a4,s2,0x1
800019d6:	974a                	add	a4,a4,s2
800019d8:	00271793          	slli	a5,a4,0x2
800019dc:	4458                	lw	a4,12(s0)
800019de:	973e                	add	a4,a4,a5
800019e0:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
800019e4:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
800019e6:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
800019e8:	00ab4963          	blt	s6,a0,800019fa <z_sys_mem_pool_base_init+0x88>
			p->max_inline_level = i;
800019ec:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800019f0:	8089                	srli	s1,s1,0x2
800019f2:	048d                	addi	s1,s1,3
800019f4:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800019f6:	0905                	addi	s2,s2,1
800019f8:	bf45                	j	800019a8 <z_sys_mem_pool_base_init+0x36>
			bits += (nblocks + 31)/32;
800019fa:	057d                	addi	a0,a0,31
800019fc:	41f55793          	srai	a5,a0,0x1f
80001a00:	8bfd                	andi	a5,a5,31
80001a02:	97aa                	add	a5,a5,a0
80001a04:	8795                	srai	a5,a5,0x5
80001a06:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80001a08:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001a0c:	99be                	add	s3,s3,a5
80001a0e:	b7cd                	j	800019f0 <z_sys_mem_pool_base_init+0x7e>
	return (u8_t *)p->buf + lsz * block;
80001a10:	404c                	lw	a1,4(s0)
80001a12:	8526                	mv	a0,s1
80001a14:	e09fe0ef          	jal	ra,8000081c <__mulsi3>
80001a18:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001a1a:	8626                	mv	a2,s1
80001a1c:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001a1e:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
80001a20:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001a22:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001a24:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001a28:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
80001a2a:	4798                	lw	a4,8(a5)
80001a2c:	c158                	sw	a4,4(a0)

	list->tail->next = node;
80001a2e:	4798                	lw	a4,8(a5)
80001a30:	c308                	sw	a0,0(a4)
	list->tail = node;
80001a32:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001a34:	8522                	mv	a0,s0
80001a36:	3705                	jal	80001956 <set_free_bit>
80001a38:	bf9d                	j	800019ae <z_sys_mem_pool_base_init+0x3c>

80001a3a <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001a3a:	1141                	addi	sp,sp,-16
80001a3c:	87aa                	mv	a5,a0
80001a3e:	852e                	mv	a0,a1
80001a40:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
80001a42:	8636                	mv	a2,a3
{
80001a44:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
80001a46:	9782                	jalr	a5
80001a48:	04e020ef          	jal	ra,80003a96 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001a4c:	690020ef          	jal	ra,800040dc <z_impl_k_thread_abort>

80001a50 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001a50:	4501                	li	a0,0
80001a52:	8082                	ret

80001a54 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001a54:	1141                	addi	sp,sp,-16
80001a56:	c422                	sw	s0,8(sp)
80001a58:	842a                	mv	s0,a0
	out('E', ctx);
80001a5a:	04500513          	li	a0,69
{
80001a5e:	c606                	sw	ra,12(sp)
80001a60:	c226                	sw	s1,4(sp)
80001a62:	84ae                	mv	s1,a1
	out('E', ctx);
80001a64:	9402                	jalr	s0
	out('R', ctx);
80001a66:	85a6                	mv	a1,s1
80001a68:	05200513          	li	a0,82
80001a6c:	9402                	jalr	s0
	out('R', ctx);
80001a6e:	8322                	mv	t1,s0
}
80001a70:	4422                	lw	s0,8(sp)
80001a72:	40b2                	lw	ra,12(sp)
	out('R', ctx);
80001a74:	85a6                	mv	a1,s1
}
80001a76:	4492                	lw	s1,4(sp)
	out('R', ctx);
80001a78:	05200513          	li	a0,82
}
80001a7c:	0141                	addi	sp,sp,16
	out('R', ctx);
80001a7e:	8302                	jr	t1

80001a80 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001a80:	419c                	lw	a5,0(a1)
80001a82:	0785                	addi	a5,a5,1
80001a84:	c19c                	sw	a5,0(a1)
	return _char_out(c);
80001a86:	800067b7          	lui	a5,0x80006
80001a8a:	0c47a303          	lw	t1,196(a5) # 800060c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c5>
80001a8e:	8302                	jr	t1

80001a90 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001a90:	7139                	addi	sp,sp,-64
80001a92:	dc22                	sw	s0,56(sp)
80001a94:	d64e                	sw	s3,44(sp)
80001a96:	d452                	sw	s4,40(sp)
80001a98:	d05a                	sw	s6,32(sp)
80001a9a:	c86a                	sw	s10,16(sp)
80001a9c:	de06                	sw	ra,60(sp)
80001a9e:	da26                	sw	s1,52(sp)
80001aa0:	d84a                	sw	s2,48(sp)
80001aa2:	d256                	sw	s5,36(sp)
80001aa4:	ce5e                	sw	s7,28(sp)
80001aa6:	cc62                	sw	s8,24(sp)
80001aa8:	ca66                	sw	s9,20(sp)
80001aaa:	c66e                	sw	s11,12(sp)
80001aac:	89aa                	mv	s3,a0
80001aae:	8a2e                	mv	s4,a1
80001ab0:	8d32                	mv	s10,a2
80001ab2:	8b36                	mv	s6,a3
80001ab4:	4405                	li	s0,1
80001ab6:	00e05363          	blez	a4,80001abc <_printk_dec_ulong+0x2c>
80001aba:	843a                	mv	s0,a4
80001abc:	4785                	li	a5,1
80001abe:	02000c93          	li	s9,32
80001ac2:	00fb1463          	bne	s6,a5,80001aca <_printk_dec_ulong+0x3a>
80001ac6:	03000c93          	li	s9,48
80001aca:	3b9ad4b7          	lui	s1,0x3b9ad
80001ace:	4905                	li	s2,1
80001ad0:	4aa9                	li	s5,10
80001ad2:	4c01                	li	s8,0
80001ad4:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001ad8:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001ada:	00148b93          	addi	s7,s1,1
80001ade:	000c1463          	bnez	s8,80001ae6 <_printk_dec_ulong+0x56>
80001ae2:	07a4f263          	bgeu	s1,s10,80001b46 <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001ae6:	85de                	mv	a1,s7
80001ae8:	856a                	mv	a0,s10
80001aea:	deffe0ef          	jal	ra,800008d8 <__udivsi3>
80001aee:	85d2                	mv	a1,s4
80001af0:	03050513          	addi	a0,a0,48
80001af4:	9982                	jalr	s3
			digits++;
80001af6:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
80001af8:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001afa:	85de                	mv	a1,s7
80001afc:	856a                	mv	a0,s10
80001afe:	e23fe0ef          	jal	ra,80000920 <__umodsi3>
80001b02:	8d2a                	mv	s10,a0
		pos /= 10;
80001b04:	45a9                	li	a1,10
80001b06:	8526                	mv	a0,s1
80001b08:	dd1fe0ef          	jal	ra,800008d8 <__udivsi3>
		remaining--;
80001b0c:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
80001b0e:	4785                	li	a5,1
		pos /= 10;
80001b10:	84aa                	mv	s1,a0
	while (pos >= 9) {
80001b12:	fcfa94e3          	bne	s5,a5,80001ada <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
80001b16:	85d2                	mv	a1,s4
80001b18:	030d0513          	addi	a0,s10,48
80001b1c:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001b1e:	478d                	li	a5,3
		remaining = min_width - digits;
80001b20:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001b24:	02fb0f63          	beq	s6,a5,80001b62 <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001b28:	50f2                	lw	ra,60(sp)
80001b2a:	5462                	lw	s0,56(sp)
80001b2c:	54d2                	lw	s1,52(sp)
80001b2e:	5942                	lw	s2,48(sp)
80001b30:	59b2                	lw	s3,44(sp)
80001b32:	5a22                	lw	s4,40(sp)
80001b34:	5a92                	lw	s5,36(sp)
80001b36:	5b02                	lw	s6,32(sp)
80001b38:	4bf2                	lw	s7,28(sp)
80001b3a:	4c62                	lw	s8,24(sp)
80001b3c:	4cd2                	lw	s9,20(sp)
80001b3e:	4d42                	lw	s10,16(sp)
80001b40:	4db2                	lw	s11,12(sp)
80001b42:	6121                	addi	sp,sp,64
80001b44:	8082                	ret
		} else if (remaining <= min_width
80001b46:	fb544ae3          	blt	s0,s5,80001afa <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
80001b4a:	fb6de8e3          	bltu	s11,s6,80001afa <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001b4e:	85d2                	mv	a1,s4
80001b50:	8566                	mv	a0,s9
80001b52:	9982                	jalr	s3
			digits++;
80001b54:	0905                	addi	s2,s2,1
80001b56:	b755                	j	80001afa <_printk_dec_ulong+0x6a>
			out(' ', ctx);
80001b58:	85d2                	mv	a1,s4
80001b5a:	02000513          	li	a0,32
80001b5e:	9982                	jalr	s3
80001b60:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
80001b62:	fe804be3          	bgtz	s0,80001b58 <_printk_dec_ulong+0xc8>
80001b66:	b7c9                	j	80001b28 <_printk_dec_ulong+0x98>

80001b68 <__printk_hook_install>:
	_char_out = fn;
80001b68:	800067b7          	lui	a5,0x80006
80001b6c:	0ca7a223          	sw	a0,196(a5) # 800060c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c5>
}
80001b70:	8082                	ret

80001b72 <z_vprintk>:
{
80001b72:	715d                	addi	sp,sp,-80
80001b74:	c4a2                	sw	s0,72(sp)
80001b76:	c2a6                	sw	s1,68(sp)
80001b78:	c0ca                	sw	s2,64(sp)
80001b7a:	de4e                	sw	s3,60(sp)
80001b7c:	dc52                	sw	s4,56(sp)
80001b7e:	da56                	sw	s5,52(sp)
80001b80:	d266                	sw	s9,36(sp)
80001b82:	d06a                	sw	s10,32(sp)
80001b84:	ce6e                	sw	s11,28(sp)
80001b86:	c686                	sw	ra,76(sp)
80001b88:	d85a                	sw	s6,48(sp)
80001b8a:	d65e                	sw	s7,44(sp)
80001b8c:	d462                	sw	s8,40(sp)
80001b8e:	842a                	mv	s0,a0
80001b90:	84ae                	mv	s1,a1
80001b92:	8ab2                	mv	s5,a2
80001b94:	8d36                	mv	s10,a3
	int long_ctr = 0;
80001b96:	4a01                	li	s4,0
	int min_width = -1;
80001b98:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001b9a:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001b9c:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
80001b9e:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001ba2:	000ac503          	lbu	a0,0(s5)
80001ba6:	e105                	bnez	a0,80001bc6 <z_vprintk+0x54>
}
80001ba8:	40b6                	lw	ra,76(sp)
80001baa:	4426                	lw	s0,72(sp)
80001bac:	4496                	lw	s1,68(sp)
80001bae:	4906                	lw	s2,64(sp)
80001bb0:	59f2                	lw	s3,60(sp)
80001bb2:	5a62                	lw	s4,56(sp)
80001bb4:	5ad2                	lw	s5,52(sp)
80001bb6:	5b42                	lw	s6,48(sp)
80001bb8:	5bb2                	lw	s7,44(sp)
80001bba:	5c22                	lw	s8,40(sp)
80001bbc:	5c92                	lw	s9,36(sp)
80001bbe:	5d02                	lw	s10,32(sp)
80001bc0:	4df2                	lw	s11,28(sp)
80001bc2:	6161                	addi	sp,sp,80
80001bc4:	8082                	ret
		if (!might_format) {
80001bc6:	000c9a63          	bnez	s9,80001bda <z_vprintk+0x68>
			if (*fmt != '%') {
80001bca:	02500693          	li	a3,37
80001bce:	28d50563          	beq	a0,a3,80001e58 <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
80001bd2:	85a6                	mv	a1,s1
80001bd4:	9402                	jalr	s0
		++fmt;
80001bd6:	0a85                	addi	s5,s5,1
80001bd8:	b7e9                	j	80001ba2 <z_vprintk+0x30>
			switch (*fmt) {
80001bda:	06400693          	li	a3,100
80001bde:	0ed50b63          	beq	a0,a3,80001cd4 <z_vprintk+0x162>
80001be2:	04a6eb63          	bltu	a3,a0,80001c38 <z_vprintk+0xc6>
80001be6:	03900693          	li	a3,57
80001bea:	02a6e763          	bltu	a3,a0,80001c18 <z_vprintk+0xa6>
80001bee:	03100693          	li	a3,49
80001bf2:	0cd57563          	bgeu	a0,a3,80001cbc <z_vprintk+0x14a>
80001bf6:	02d00693          	li	a3,45
80001bfa:	26d50463          	beq	a0,a3,80001e62 <z_vprintk+0x2f0>
80001bfe:	03000793          	li	a5,48
80001c02:	0af50363          	beq	a0,a5,80001ca8 <z_vprintk+0x136>
80001c06:	02500713          	li	a4,37
80001c0a:	00e51f63          	bne	a0,a4,80001c28 <z_vprintk+0xb6>
				out((int)'%', ctx);
80001c0e:	85a6                	mv	a1,s1
80001c10:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001c14:	9402                	jalr	s0
				break;
80001c16:	aa09                	j	80001d28 <z_vprintk+0x1b6>
80001c18:	05800693          	li	a3,88
80001c1c:	14d50b63          	beq	a0,a3,80001d72 <z_vprintk+0x200>
80001c20:	06300713          	li	a4,99
80001c24:	22e50363          	beq	a0,a4,80001e4a <z_vprintk+0x2d8>
				out((int)'%', ctx);
80001c28:	85a6                	mv	a1,s1
80001c2a:	02500513          	li	a0,37
80001c2e:	9402                	jalr	s0
				out((int)*fmt, ctx);
80001c30:	85a6                	mv	a1,s1
80001c32:	000ac503          	lbu	a0,0(s5)
80001c36:	bff9                	j	80001c14 <z_vprintk+0xa2>
80001c38:	07000693          	li	a3,112
80001c3c:	12d50163          	beq	a0,a3,80001d5e <z_vprintk+0x1ec>
80001c40:	00a6ef63          	bltu	a3,a0,80001c5e <z_vprintk+0xec>
80001c44:	06900693          	li	a3,105
80001c48:	08d50663          	beq	a0,a3,80001cd4 <z_vprintk+0x162>
80001c4c:	06c00693          	li	a3,108
80001c50:	08d50063          	beq	a0,a3,80001cd0 <z_vprintk+0x15e>
80001c54:	06800693          	li	a3,104
80001c58:	f6d50fe3          	beq	a0,a3,80001bd6 <z_vprintk+0x64>
80001c5c:	b7f1                	j	80001c28 <z_vprintk+0xb6>
80001c5e:	07500693          	li	a3,117
80001c62:	0cd50563          	beq	a0,a3,80001d2c <z_vprintk+0x1ba>
80001c66:	02a6ea63          	bltu	a3,a0,80001c9a <z_vprintk+0x128>
80001c6a:	07300713          	li	a4,115
80001c6e:	fae51de3          	bne	a0,a4,80001c28 <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
80001c72:	000d2c03          	lw	s8,0(s10)
80001c76:	004d0b13          	addi	s6,s10,4
80001c7a:	8be2                	mv	s7,s8
				while (*s)
80001c7c:	000bc503          	lbu	a0,0(s7)
80001c80:	1a051b63          	bnez	a0,80001e36 <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
80001c84:	478d                	li	a5,3
80001c86:	00f99863          	bne	s3,a5,80001c96 <z_vprintk+0x124>
					int remaining = min_width - (s - start);
80001c8a:	418b8bb3          	sub	s7,s7,s8
80001c8e:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001c92:	1b704663          	bgtz	s7,80001e3e <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
80001c96:	8d5a                	mv	s10,s6
80001c98:	a841                	j	80001d28 <z_vprintk+0x1b6>
80001c9a:	07800693          	li	a3,120
80001c9e:	0cd50a63          	beq	a0,a3,80001d72 <z_vprintk+0x200>
80001ca2:	07a00693          	li	a3,122
80001ca6:	bf4d                	j	80001c58 <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
80001ca8:	00095c63          	bgez	s2,80001cc0 <z_vprintk+0x14e>
80001cac:	1a098d63          	beqz	s3,80001e66 <z_vprintk+0x2f4>
					min_width = *fmt - '0';
80001cb0:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001cb4:	f20991e3          	bnez	s3,80001bd6 <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
80001cb8:	4989                	li	s3,2
80001cba:	bf31                	j	80001bd6 <z_vprintk+0x64>
				if (min_width < 0) {
80001cbc:	fe094ae3          	bltz	s2,80001cb0 <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
80001cc0:	00291693          	slli	a3,s2,0x2
80001cc4:	9936                	add	s2,s2,a3
80001cc6:	0906                	slli	s2,s2,0x1
80001cc8:	fd090913          	addi	s2,s2,-48
80001ccc:	992a                	add	s2,s2,a0
80001cce:	b7dd                	j	80001cb4 <z_vprintk+0x142>
				long_ctr++;
80001cd0:	0a05                	addi	s4,s4,1
80001cd2:	b711                	j	80001bd6 <z_vprintk+0x64>
				if (long_ctr == 0) {
80001cd4:	020a1663          	bnez	s4,80001d00 <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
80001cd8:	000d2603          	lw	a2,0(s10)
80001cdc:	0d11                	addi	s10,s10,4
				if (d < 0) {
80001cde:	00065b63          	bgez	a2,80001cf4 <z_vprintk+0x182>
					out((int)'-', ctx);
80001ce2:	85a6                	mv	a1,s1
80001ce4:	02d00513          	li	a0,45
80001ce8:	c032                	sw	a2,0(sp)
80001cea:	9402                	jalr	s0
					d = -d;
80001cec:	4602                	lw	a2,0(sp)
					min_width--;
80001cee:	197d                	addi	s2,s2,-1
					d = -d;
80001cf0:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001cf4:	874a                	mv	a4,s2
80001cf6:	86ce                	mv	a3,s3
80001cf8:	85a6                	mv	a1,s1
80001cfa:	8522                	mv	a0,s0
80001cfc:	3b51                	jal	80001a90 <_printk_dec_ulong>
				break;
80001cfe:	a02d                	j	80001d28 <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
80001d00:	4705                	li	a4,1
80001d02:	fcea0be3          	beq	s4,a4,80001cd8 <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
80001d06:	007d0793          	addi	a5,s10,7
80001d0a:	ff87f713          	andi	a4,a5,-8
80001d0e:	4310                	lw	a2,0(a4)
80001d10:	4354                	lw	a3,4(a4)
80001d12:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001d16:	01b60733          	add	a4,a2,s11
80001d1a:	00c73733          	sltu	a4,a4,a2
80001d1e:	9736                	add	a4,a4,a3
80001d20:	df5d                	beqz	a4,80001cde <z_vprintk+0x16c>
						print_err(out, ctx);
80001d22:	85a6                	mv	a1,s1
80001d24:	8522                	mv	a0,s0
80001d26:	333d                	jal	80001a54 <print_err>
			might_format = 0;
80001d28:	4c81                	li	s9,0
80001d2a:	b575                	j	80001bd6 <z_vprintk+0x64>
				if (long_ctr == 0) {
80001d2c:	000a1663          	bnez	s4,80001d38 <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
80001d30:	000d2603          	lw	a2,0(s10)
80001d34:	0d11                	addi	s10,s10,4
80001d36:	bf7d                	j	80001cf4 <z_vprintk+0x182>
				} else if (long_ctr == 1) {
80001d38:	4705                	li	a4,1
80001d3a:	feea0be3          	beq	s4,a4,80001d30 <z_vprintk+0x1be>
					unsigned long long llu =
80001d3e:	007d0793          	addi	a5,s10,7
80001d42:	ff87f713          	andi	a4,a5,-8
80001d46:	00870d13          	addi	s10,a4,8
80001d4a:	4310                	lw	a2,0(a4)
80001d4c:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001d4e:	fb71                	bnez	a4,80001d22 <z_vprintk+0x1b0>
80001d50:	800007b7          	lui	a5,0x80000
80001d54:	fff7c793          	not	a5,a5
80001d58:	f8c7fee3          	bgeu	a5,a2,80001cf4 <z_vprintk+0x182>
80001d5c:	b7d9                	j	80001d22 <z_vprintk+0x1b0>
				  out('0', ctx);
80001d5e:	85a6                	mv	a1,s1
80001d60:	03000513          	li	a0,48
80001d64:	9402                	jalr	s0
				  out('x', ctx);
80001d66:	85a6                	mv	a1,s1
80001d68:	07800513          	li	a0,120
80001d6c:	9402                	jalr	s0
				  min_width = 8;
80001d6e:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001d70:	4985                	li	s3,1
				if (long_ctr < 2) {
80001d72:	4685                	li	a3,1
80001d74:	0746c663          	blt	a3,s4,80001de0 <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
80001d78:	000d2783          	lw	a5,0(s10)
80001d7c:	c402                	sw	zero,8(sp)
80001d7e:	0d11                	addi	s10,s10,4
80001d80:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001d82:	4c41                	li	s8,16
	int digits = 0;
80001d84:	4b81                	li	s7,0
	int found_largest_digit = 0;
80001d86:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001d88:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001d8a:	4512                	lw	a0,4(sp)
80001d8c:	45a2                	lw	a1,8(sp)
80001d8e:	fff88b13          	addi	s6,a7,-1
80001d92:	002b1613          	slli	a2,s6,0x2
80001d96:	c646                	sw	a7,12(sp)
80001d98:	c78fe0ef          	jal	ra,80000210 <__lshrdi3>
80001d9c:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001d9e:	ed39                	bnez	a0,80001dfc <z_vprintk+0x28a>
80001da0:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001da2:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001da6:	e789                	bnez	a5,80001db0 <z_vprintk+0x23e>
80001da8:	48b2                	lw	a7,12(sp)
80001daa:	4785                	li	a5,1
80001dac:	06f89063          	bne	a7,a5,80001e0c <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
80001db0:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
80001db2:	0562                	slli	a0,a0,0x18
80001db4:	85a6                	mv	a1,s1
80001db6:	8561                	srai	a0,a0,0x18
80001db8:	9402                	jalr	s0
			digits++;
80001dba:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
80001dbc:	020b1d63          	bnez	s6,80001df6 <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
80001dc0:	468d                	li	a3,3
			might_format = 0;
80001dc2:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001dc4:	e0d999e3          	bne	s3,a3,80001bd6 <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
80001dc8:	00191713          	slli	a4,s2,0x1
80001dcc:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001dd0:	f5705ce3          	blez	s7,80001d28 <z_vprintk+0x1b6>
			out(' ', ctx);
80001dd4:	85a6                	mv	a1,s1
80001dd6:	02000513          	li	a0,32
80001dda:	9402                	jalr	s0
80001ddc:	1bfd                	addi	s7,s7,-1
80001dde:	bfcd                	j	80001dd0 <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
80001de0:	007d0793          	addi	a5,s10,7
80001de4:	ff87f693          	andi	a3,a5,-8
80001de8:	429c                	lw	a5,0(a3)
80001dea:	00868d13          	addi	s10,a3,8
80001dee:	c23e                	sw	a5,4(sp)
80001df0:	42dc                	lw	a5,4(a3)
80001df2:	c43e                	sw	a5,8(sp)
80001df4:	b779                	j	80001d82 <z_vprintk+0x210>
			found_largest_digit = 1;
80001df6:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001df8:	88da                	mv	a7,s6
80001dfa:	bf41                	j	80001d8a <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
80001dfc:	47a5                	li	a5,9
80001dfe:	05700693          	li	a3,87
80001e02:	faa7e7e3          	bltu	a5,a0,80001db0 <z_vprintk+0x23e>
80001e06:	03000693          	li	a3,48
80001e0a:	b75d                	j	80001db0 <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
80001e0c:	fffc0793          	addi	a5,s8,-1
80001e10:	c63e                	sw	a5,12(sp)
80001e12:	01894963          	blt	s2,s8,80001e24 <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
80001e16:	4785                	li	a5,1
80001e18:	00f99863          	bne	s3,a5,80001e28 <z_vprintk+0x2b6>
				out('0', ctx);
80001e1c:	85a6                	mv	a1,s1
80001e1e:	03000513          	li	a0,48
				out(' ', ctx);
80001e22:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
80001e24:	4c32                	lw	s8,12(sp)
80001e26:	bfc9                	j	80001df8 <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
80001e28:	4789                	li	a5,2
80001e2a:	fef99de3          	bne	s3,a5,80001e24 <z_vprintk+0x2b2>
				out(' ', ctx);
80001e2e:	85a6                	mv	a1,s1
80001e30:	02000513          	li	a0,32
80001e34:	b7fd                	j	80001e22 <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
80001e36:	85a6                	mv	a1,s1
80001e38:	0b85                	addi	s7,s7,1
80001e3a:	9402                	jalr	s0
80001e3c:	b581                	j	80001c7c <z_vprintk+0x10a>
						out(' ', ctx);
80001e3e:	85a6                	mv	a1,s1
80001e40:	02000513          	li	a0,32
80001e44:	9402                	jalr	s0
80001e46:	1bfd                	addi	s7,s7,-1
80001e48:	b5a9                	j	80001c92 <z_vprintk+0x120>
				out(c, ctx);
80001e4a:	000d2503          	lw	a0,0(s10)
80001e4e:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
80001e50:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001e54:	9402                	jalr	s0
				break;
80001e56:	b581                	j	80001c96 <z_vprintk+0x124>
				long_ctr = 0;
80001e58:	4a01                	li	s4,0
				min_width = -1;
80001e5a:	597d                	li	s2,-1
				padding = PAD_NONE;
80001e5c:	4981                	li	s3,0
				might_format = 1;
80001e5e:	4c85                	li	s9,1
80001e60:	bb9d                	j	80001bd6 <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
80001e62:	498d                	li	s3,3
80001e64:	bb8d                	j	80001bd6 <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
80001e66:	4985                	li	s3,1
80001e68:	b3bd                	j	80001bd6 <z_vprintk+0x64>

80001e6a <vprintk>:
{
80001e6a:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001e6c:	862a                	mv	a2,a0
80001e6e:	80002537          	lui	a0,0x80002
80001e72:	86ae                	mv	a3,a1
80001e74:	a8050513          	addi	a0,a0,-1408 # 80001a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001a81>
80001e78:	006c                	addi	a1,sp,12
{
80001e7a:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001e7c:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001e7e:	39d5                	jal	80001b72 <z_vprintk>
}
80001e80:	40f2                	lw	ra,28(sp)
80001e82:	6105                	addi	sp,sp,32
80001e84:	8082                	ret

80001e86 <printk>:
{
80001e86:	7139                	addi	sp,sp,-64
80001e88:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
80001e8a:	104c                	addi	a1,sp,36
{
80001e8c:	ce06                	sw	ra,28(sp)
80001e8e:	d432                	sw	a2,40(sp)
80001e90:	d636                	sw	a3,44(sp)
80001e92:	d83a                	sw	a4,48(sp)
80001e94:	da3e                	sw	a5,52(sp)
80001e96:	dc42                	sw	a6,56(sp)
80001e98:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
80001e9a:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
80001e9c:	37f9                	jal	80001e6a <vprintk>
}
80001e9e:	40f2                	lw	ra,28(sp)
80001ea0:	6121                	addi	sp,sp,64
80001ea2:	8082                	ret

80001ea4 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001ea4:	800065b7          	lui	a1,0x80006
80001ea8:	80006537          	lui	a0,0x80006
{
80001eac:	1141                	addi	sp,sp,-16
  k_panic();
80001eae:	a9058593          	addi	a1,a1,-1392 # 80005a90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a91>
80001eb2:	aa450513          	addi	a0,a0,-1372 # 80005aa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aa5>
80001eb6:	4679                	li	a2,30
{
80001eb8:	c606                	sw	ra,12(sp)
  k_panic();
80001eba:	37f1                	jal	80001e86 <printk>
80001ebc:	800055b7          	lui	a1,0x80005
80001ec0:	6b458593          	addi	a1,a1,1716 # 800056b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056b5>
80001ec4:	4519                	li	a0,6
80001ec6:	859ff0ef          	jal	ra,8000171e <z_NanoFatalErrorHandler>

80001eca <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001eca:	8082                	ret

80001ecc <k_cpu_idle>:
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ecc:	47a1                	li	a5,8
80001ece:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001ed2:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001ed6:	8082                	ret

80001ed8 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001ed8:	4785                	li	a5,1
80001eda:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001ede:	30452573          	csrrs	a0,mie,a0
}
80001ee2:	8082                	ret

80001ee4 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001ee4:	47a1                	li	a5,8
80001ee6:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001eea:	30405073          	csrwi	mie,0
80001eee:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001ef2:	8082                	ret

80001ef4 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001ef4:	1141                	addi	sp,sp,-16
80001ef6:	c422                	sw	s0,8(sp)
80001ef8:	c226                	sw	s1,4(sp)
80001efa:	80006437          	lui	s0,0x80006
80001efe:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001f00:	47a9                	li	a5,10
{
80001f02:	84aa                	mv	s1,a0
80001f04:	24840413          	addi	s0,s0,584 # 80006248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006249>
	if ('\n' == c) {
80001f08:	00f51763          	bne	a0,a5,80001f16 <console_out+0x22>
80001f0c:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001f0e:	45b5                	li	a1,13
80001f10:	415c                	lw	a5,4(a0)
80001f12:	43dc                	lw	a5,4(a5)
80001f14:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001f16:	4008                	lw	a0,0(s0)
80001f18:	0ff4f593          	andi	a1,s1,255
80001f1c:	415c                	lw	a5,4(a0)
80001f1e:	43dc                	lw	a5,4(a5)
80001f20:	9782                	jalr	a5

	return c;
}
80001f22:	40b2                	lw	ra,12(sp)
80001f24:	4422                	lw	s0,8(sp)
80001f26:	8526                	mv	a0,s1
80001f28:	4492                	lw	s1,4(sp)
80001f2a:	0141                	addi	sp,sp,16
80001f2c:	8082                	ret

80001f2e <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001f2e:	1141                	addi	sp,sp,-16
80001f30:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001f32:	80002437          	lui	s0,0x80002
80001f36:	ef440513          	addi	a0,s0,-268 # 80001ef4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001ef5>
{
80001f3a:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001f3c:	2911                	jal	80002350 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001f3e:	ef440513          	addi	a0,s0,-268
}
80001f42:	4422                	lw	s0,8(sp)
80001f44:	40b2                	lw	ra,12(sp)
80001f46:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
80001f48:	b105                	j	80001b68 <__printk_hook_install>

80001f4a <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001f4a:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001f4e:	1141                	addi	sp,sp,-16
80001f50:	ab050513          	addi	a0,a0,-1360 # 80005ab0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ab1>
80001f54:	c606                	sw	ra,12(sp)
80001f56:	2d51                	jal	800025ea <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001f58:	800067b7          	lui	a5,0x80006
80001f5c:	24a7a423          	sw	a0,584(a5) # 80006248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006249>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001f60:	37f9                	jal	80001f2e <uart_console_hook_install>

	return 0;
}
80001f62:	40b2                	lw	ra,12(sp)
80001f64:	4501                	li	a0,0
80001f66:	0141                	addi	sp,sp,16
80001f68:	8082                	ret

80001f6a <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001f6a:	f01007b7          	lui	a5,0xf0100
80001f6e:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001f72:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001f76:	f447a583          	lw	a1,-188(a5)
80001f7a:	fee59ae3          	bne	a1,a4,80001f6e <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001f7e:	8082                	ret

80001f80 <timer_isr>:

static void timer_isr(void *arg)
{
80001f80:	1101                	addi	sp,sp,-32
80001f82:	cc22                	sw	s0,24(sp)
80001f84:	ce06                	sw	ra,28(sp)
80001f86:	ca26                	sw	s1,20(sp)
80001f88:	c84a                	sw	s2,16(sp)
80001f8a:	c64e                	sw	s3,12(sp)
80001f8c:	c452                	sw	s4,8(sp)
80001f8e:	c256                	sw	s5,4(sp)
80001f90:	4421                	li	s0,8
80001f92:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001f96:	80006937          	lui	s2,0x80006
80001f9a:	24c90513          	addi	a0,s2,588 # 8000624c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000624d>
	key = (mstatus & SOC_MSTATUS_IEN);
80001f9e:	8821                	andi	s0,s0,8
80001fa0:	6b9010ef          	jal	ra,80003e58 <z_spin_lock_valid>
80001fa4:	e915                	bnez	a0,80001fd8 <timer_isr+0x58>
80001fa6:	800064b7          	lui	s1,0x80006
80001faa:	800065b7          	lui	a1,0x80006
80001fae:	80006537          	lui	a0,0x80006
80001fb2:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80001fb6:	04e00693          	li	a3,78
80001fba:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80001fbe:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80001fc2:	35d1                	jal	80001e86 <printk>
80001fc4:	80006537          	lui	a0,0x80006
80001fc8:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80001fcc:	3d6d                	jal	80001e86 <printk>
80001fce:	04e00593          	li	a1,78
80001fd2:	ac448513          	addi	a0,s1,-1340
80001fd6:	35f9                	jal	80001ea4 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001fd8:	24c90513          	addi	a0,s2,588
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001fdc:	800064b7          	lui	s1,0x80006
80001fe0:	6b5010ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
80001fe4:	23048493          	addi	s1,s1,560 # 80006230 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006231>
	u64_t now = mtime();
80001fe8:	3749                	jal	80001f6a <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001fea:	0004a983          	lw	s3,0(s1)
80001fee:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001ff2:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001ff4:	41350533          	sub	a0,a0,s3
80001ff8:	00a7b7b3          	sltu	a5,a5,a0
80001ffc:	415585b3          	sub	a1,a1,s5
80002000:	6675                	lui	a2,0x1d
80002002:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002006:	4681                	li	a3,0
80002008:	8d9d                	sub	a1,a1,a5
8000200a:	a3efe0ef          	jal	ra,80000248 <__udivdi3>
8000200e:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80002010:	65f5                	lui	a1,0x1d
80002012:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002016:	8552                	mv	a0,s4
80002018:	805fe0ef          	jal	ra,8000081c <__mulsi3>
8000201c:	99aa                	add	s3,s3,a0
8000201e:	00a9b533          	sltu	a0,s3,a0
80002022:	9556                	add	a0,a0,s5
80002024:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002026:	24c90513          	addi	a0,s2,588
8000202a:	0134a023          	sw	s3,0(s1)
8000202e:	645010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80002032:	e915                	bnez	a0,80002066 <timer_isr+0xe6>
80002034:	800064b7          	lui	s1,0x80006
80002038:	800065b7          	lui	a1,0x80006
8000203c:	80006537          	lui	a0,0x80006
80002040:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80002044:	06100693          	li	a3,97
80002048:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000204c:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002050:	3d1d                	jal	80001e86 <printk>
80002052:	80006537          	lui	a0,0x80006
80002056:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
8000205a:	3535                	jal	80001e86 <printk>
8000205c:	06100593          	li	a1,97
80002060:	ac448513          	addi	a0,s1,-1340
80002064:	3581                	jal	80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002066:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
8000206a:	4462                	lw	s0,24(sp)
8000206c:	40f2                	lw	ra,28(sp)
8000206e:	44d2                	lw	s1,20(sp)
80002070:	4942                	lw	s2,16(sp)
80002072:	49b2                	lw	s3,12(sp)
80002074:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002076:	8552                	mv	a0,s4
}
80002078:	4a22                	lw	s4,8(sp)
8000207a:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
8000207c:	6c00206f          	j	8000473c <z_clock_announce>

80002080 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002080:	1141                	addi	sp,sp,-16
80002082:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002084:	35dd                	jal	80001f6a <mtime>
80002086:	67f5                	lui	a5,0x1d
80002088:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
8000208c:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002090:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
80002092:	56fd                	li	a3,-1
80002094:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002098:	00a7b533          	sltu	a0,a5,a0
8000209c:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
8000209e:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
800020a2:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
800020a6:	451d                	li	a0,7
800020a8:	3d05                	jal	80001ed8 <z_arch_irq_enable>
	return 0;
}
800020aa:	40b2                	lw	ra,12(sp)
800020ac:	4501                	li	a0,0
800020ae:	0141                	addi	sp,sp,16
800020b0:	8082                	ret

800020b2 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
800020b2:	14059563          	bnez	a1,800021fc <z_clock_set_timeout+0x14a>
{
800020b6:	1101                	addi	sp,sp,-32
800020b8:	ce06                	sw	ra,28(sp)
800020ba:	cc22                	sw	s0,24(sp)
800020bc:	ca26                	sw	s1,20(sp)
800020be:	c84a                	sw	s2,16(sp)
800020c0:	c64e                	sw	s3,12(sp)
800020c2:	c452                	sw	s4,8(sp)
800020c4:	c256                	sw	s5,4(sp)
800020c6:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800020c8:	57fd                	li	a5,-1
800020ca:	00f51563          	bne	a0,a5,800020d4 <z_clock_set_timeout+0x22>
800020ce:	6525                	lui	a0,0x9
800020d0:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
800020d4:	67a5                	lui	a5,0x9
800020d6:	fff50413          	addi	s0,a0,-1
800020da:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
800020de:	1087db63          	bge	a5,s0,800021f4 <z_clock_set_timeout+0x142>
800020e2:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
800020e4:	4921                	li	s2,8
800020e6:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800020ea:	80006ab7          	lui	s5,0x80006
800020ee:	24ca8513          	addi	a0,s5,588 # 8000624c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000624d>
	key = (mstatus & SOC_MSTATUS_IEN);
800020f2:	00897913          	andi	s2,s2,8
800020f6:	563010ef          	jal	ra,80003e58 <z_spin_lock_valid>
800020fa:	e915                	bnez	a0,8000212e <z_clock_set_timeout+0x7c>
800020fc:	800064b7          	lui	s1,0x80006
80002100:	800065b7          	lui	a1,0x80006
80002104:	80006537          	lui	a0,0x80006
80002108:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
8000210c:	04e00693          	li	a3,78
80002110:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002114:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002118:	33bd                	jal	80001e86 <printk>
8000211a:	80006537          	lui	a0,0x80006
8000211e:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80002122:	3395                	jal	80001e86 <printk>
80002124:	04e00593          	li	a1,78
80002128:	ac448513          	addi	a0,s1,-1340
8000212c:	3ba5                	jal	80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
8000212e:	24ca8513          	addi	a0,s5,588
80002132:	563010ef          	jal	ra,80003e94 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002136:	3d15                	jal	80001f6a <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002138:	800067b7          	lui	a5,0x80006
8000213c:	23078793          	addi	a5,a5,560 # 80006230 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006231>
	u32_t cyc = ticks * CYC_PER_TICK;
80002140:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002142:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80002146:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80002148:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000214c:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000214e:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002152:	ecafe0ef          	jal	ra,8000081c <__mulsi3>
80002156:	4bf48793          	addi	a5,s1,1215
8000215a:	413787b3          	sub	a5,a5,s3
8000215e:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002160:	4c048593          	addi	a1,s1,1216
80002164:	9552                	add	a0,a0,s4
80002166:	f72fe0ef          	jal	ra,800008d8 <__udivsi3>
8000216a:	4c048593          	addi	a1,s1,1216
8000216e:	eaefe0ef          	jal	ra,8000081c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002172:	41498a33          	sub	s4,s3,s4
80002176:	9a2a                	add	s4,s4,a0
80002178:	3e700793          	li	a5,999
8000217c:	0147c563          	blt	a5,s4,80002186 <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
80002180:	4c048493          	addi	s1,s1,1216
80002184:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
80002186:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
8000218a:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
8000218c:	577d                	li	a4,-1
8000218e:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002192:	00a9b533          	sltu	a0,s3,a0
80002196:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
80002198:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
8000219c:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800021a0:	24ca8513          	addi	a0,s5,588
800021a4:	4cf010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800021a8:	e915                	bnez	a0,800021dc <z_clock_set_timeout+0x12a>
800021aa:	80006437          	lui	s0,0x80006
800021ae:	800065b7          	lui	a1,0x80006
800021b2:	80006537          	lui	a0,0x80006
800021b6:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800021ba:	06100693          	li	a3,97
800021be:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800021c2:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800021c6:	31c1                	jal	80001e86 <printk>
800021c8:	80006537          	lui	a0,0x80006
800021cc:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800021d0:	395d                	jal	80001e86 <printk>
800021d2:	06100593          	li	a1,97
800021d6:	ac440513          	addi	a0,s0,-1340
800021da:	31e9                	jal	80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800021dc:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
800021e0:	40f2                	lw	ra,28(sp)
800021e2:	4462                	lw	s0,24(sp)
800021e4:	44d2                	lw	s1,20(sp)
800021e6:	4942                	lw	s2,16(sp)
800021e8:	49b2                	lw	s3,12(sp)
800021ea:	4a22                	lw	s4,8(sp)
800021ec:	4a92                	lw	s5,4(sp)
800021ee:	4b02                	lw	s6,0(sp)
800021f0:	6105                	addi	sp,sp,32
800021f2:	8082                	ret
800021f4:	ee0458e3          	bgez	s0,800020e4 <z_clock_set_timeout+0x32>
800021f8:	4401                	li	s0,0
800021fa:	b5ed                	j	800020e4 <z_clock_set_timeout+0x32>
800021fc:	8082                	ret

800021fe <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
800021fe:	1141                	addi	sp,sp,-16
80002200:	c422                	sw	s0,8(sp)
80002202:	c606                	sw	ra,12(sp)
80002204:	c226                	sw	s1,4(sp)
80002206:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002208:	4421                	li	s0,8
8000220a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000220e:	800064b7          	lui	s1,0x80006
80002212:	24c48513          	addi	a0,s1,588 # 8000624c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000624d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002216:	8821                	andi	s0,s0,8
80002218:	441010ef          	jal	ra,80003e58 <z_spin_lock_valid>
8000221c:	ed0d                	bnez	a0,80002256 <z_clock_elapsed+0x58>
8000221e:	80006937          	lui	s2,0x80006
80002222:	800065b7          	lui	a1,0x80006
80002226:	80006537          	lui	a0,0x80006
8000222a:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
8000222e:	04e00693          	li	a3,78
80002232:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002236:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000223a:	c4dff0ef          	jal	ra,80001e86 <printk>
8000223e:	80006537          	lui	a0,0x80006
80002242:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80002246:	c41ff0ef          	jal	ra,80001e86 <printk>
8000224a:	04e00593          	li	a1,78
8000224e:	ac490513          	addi	a0,s2,-1340
80002252:	c53ff0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002256:	24c48513          	addi	a0,s1,588
8000225a:	43b010ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
8000225e:	3331                	jal	80001f6a <mtime>
80002260:	800067b7          	lui	a5,0x80006
80002264:	2307a783          	lw	a5,560(a5) # 80006230 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006231>
80002268:	65f5                	lui	a1,0x1d
8000226a:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000226e:	8d1d                	sub	a0,a0,a5
80002270:	e68fe0ef          	jal	ra,800008d8 <__udivsi3>
80002274:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002276:	24c48513          	addi	a0,s1,588
8000227a:	3f9010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000227e:	ed0d                	bnez	a0,800022b8 <z_clock_elapsed+0xba>
80002280:	800064b7          	lui	s1,0x80006
80002284:	800065b7          	lui	a1,0x80006
80002288:	80006537          	lui	a0,0x80006
8000228c:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80002290:	06100693          	li	a3,97
80002294:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002298:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000229c:	bebff0ef          	jal	ra,80001e86 <printk>
800022a0:	80006537          	lui	a0,0x80006
800022a4:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800022a8:	bdfff0ef          	jal	ra,80001e86 <printk>
800022ac:	06100593          	li	a1,97
800022b0:	ac448513          	addi	a0,s1,-1340
800022b4:	bf1ff0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800022b8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
800022bc:	40b2                	lw	ra,12(sp)
800022be:	4422                	lw	s0,8(sp)
800022c0:	854a                	mv	a0,s2
800022c2:	4492                	lw	s1,4(sp)
800022c4:	4902                	lw	s2,0(sp)
800022c6:	0141                	addi	sp,sp,16
800022c8:	8082                	ret

800022ca <z_timer_cycle_get_32>:

u32_t z_timer_cycle_get_32(void)
{
800022ca:	1141                	addi	sp,sp,-16
800022cc:	c606                	sw	ra,12(sp)
	return (u32_t)mtime();
800022ce:	3971                	jal	80001f6a <mtime>
}
800022d0:	40b2                	lw	ra,12(sp)
800022d2:	0141                	addi	sp,sp,16
800022d4:	8082                	ret

800022d6 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
800022d6:	00054783          	lbu	a5,0(a0)
800022da:	0005c703          	lbu	a4,0(a1)
800022de:	00e79363          	bne	a5,a4,800022e4 <strcmp+0xe>
800022e2:	e781                	bnez	a5,800022ea <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
800022e4:	40e78533          	sub	a0,a5,a4
800022e8:	8082                	ret
		s1++;
800022ea:	0505                	addi	a0,a0,1
		s2++;
800022ec:	0585                	addi	a1,a1,1
800022ee:	b7e5                	j	800022d6 <strcmp>

800022f0 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
800022f0:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
800022f4:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
800022f6:	0037f713          	andi	a4,a5,3
800022fa:	eb1d                	bnez	a4,80002330 <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
800022fc:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002300:	00859713          	slli	a4,a1,0x8
80002304:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
80002306:	01059713          	slli	a4,a1,0x10
8000230a:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
8000230c:	00c78333          	add	t1,a5,a2
80002310:	873e                	mv	a4,a5
80002312:	480d                	li	a6,3
80002314:	40e308b3          	sub	a7,t1,a4
80002318:	03186263          	bltu	a6,a7,8000233c <memset+0x4c>
8000231c:	00265713          	srli	a4,a2,0x2
80002320:	00271593          	slli	a1,a4,0x2
80002324:	97ae                	add	a5,a5,a1
80002326:	8e0d                	sub	a2,a2,a1
80002328:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
8000232a:	00c79d63          	bne	a5,a2,80002344 <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
8000232e:	8082                	ret
		if (n == 0) {
80002330:	de7d                	beqz	a2,8000232e <memset+0x3e>
		*(d_byte++) = c_byte;
80002332:	0785                	addi	a5,a5,1
80002334:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002338:	167d                	addi	a2,a2,-1
8000233a:	bf75                	j	800022f6 <memset+0x6>
		*(d_word++) = c_word;
8000233c:	0711                	addi	a4,a4,4
8000233e:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80002342:	bfc9                	j	80002314 <memset+0x24>
		*(d_byte++) = c_byte;
80002344:	0785                	addi	a5,a5,1
80002346:	fed78fa3          	sb	a3,-1(a5)
		n--;
8000234a:	b7c5                	j	8000232a <memset+0x3a>

8000234c <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
8000234c:	557d                	li	a0,-1
8000234e:	8082                	ret

80002350 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002350:	800067b7          	lui	a5,0x80006
80002354:	0ca7a423          	sw	a0,200(a5) # 800060c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c9>
}
80002358:	8082                	ret

8000235a <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
8000235a:	1101                	addi	sp,sp,-32
8000235c:	cc22                	sw	s0,24(sp)
	test->setup();
8000235e:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80002360:	80006437          	lui	s0,0x80006
{
80002364:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002366:	0cc40413          	addi	s0,s0,204 # 800060cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060cd>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
8000236a:	800064b7          	lui	s1,0x80006
{
8000236e:	ce06                	sw	ra,28(sp)
80002370:	c84a                	sw	s2,16(sp)
80002372:	c64e                	sw	s3,12(sp)
	test_result = 1;
80002374:	25048493          	addi	s1,s1,592 # 80006250 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006251>
80002378:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
8000237a:	00042023          	sw	zero,0(s0)
{
8000237e:	892a                	mv	s2,a0
	test_result = 1;
80002380:	0134a023          	sw	s3,0(s1)
	test->setup();
80002384:	9782                	jalr	a5
	test->test();
80002386:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
8000238a:	01342023          	sw	s3,0(s0)
	test->test();
8000238e:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002390:	4789                	li	a5,2
80002392:	c01c                	sw	a5,0(s0)
	test->teardown();
80002394:	00c92783          	lw	a5,12(s2)
80002398:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
8000239a:	478d                	li	a5,3
8000239c:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
8000239e:	4462                	lw	s0,24(sp)
	test_result = 0;
800023a0:	0004a023          	sw	zero,0(s1)
}
800023a4:	40f2                	lw	ra,28(sp)
800023a6:	44d2                	lw	s1,20(sp)
800023a8:	4942                	lw	s2,16(sp)
800023aa:	49b2                	lw	s3,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800023ac:	80006537          	lui	a0,0x80006
800023b0:	2fc50513          	addi	a0,a0,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
800023b4:	6105                	addi	sp,sp,32
800023b6:	78a0106f          	j	80003b40 <z_impl_k_sem_give>

800023ba <ztest_test_fail>:
800023ba:	80006537          	lui	a0,0x80006
{
800023be:	1141                	addi	sp,sp,-16
	test_result = -1;
800023c0:	800067b7          	lui	a5,0x80006
800023c4:	577d                	li	a4,-1
800023c6:	2fc50513          	addi	a0,a0,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
{
800023ca:	c606                	sw	ra,12(sp)
	test_result = -1;
800023cc:	24e7a823          	sw	a4,592(a5) # 80006250 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006251>
800023d0:	770010ef          	jal	ra,80003b40 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800023d4:	6c2010ef          	jal	ra,80003a96 <z_impl_k_current_get>
}
800023d8:	40b2                	lw	ra,12(sp)
800023da:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800023dc:	5010106f          	j	800040dc <z_impl_k_thread_abort>

800023e0 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
800023e0:	711d                	addi	sp,sp,-96
800023e2:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
800023e4:	800064b7          	lui	s1,0x80006
800023e8:	2544a783          	lw	a5,596(s1) # 80006254 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006255>
{
800023ec:	ce86                	sw	ra,92(sp)
800023ee:	cca2                	sw	s0,88(sp)
800023f0:	c8ca                	sw	s2,80(sp)
800023f2:	c6ce                	sw	s3,76(sp)
800023f4:	c4d2                	sw	s4,72(sp)
800023f6:	c2d6                	sw	s5,68(sp)
800023f8:	c0da                	sw	s6,64(sp)
800023fa:	de5e                	sw	s7,60(sp)
800023fc:	dc62                	sw	s8,56(sp)
800023fe:	da66                	sw	s9,52(sp)
80002400:	d86a                	sw	s10,48(sp)
80002402:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
80002404:	0607c963          	bltz	a5,80002476 <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002408:	80006437          	lui	s0,0x80006
8000240c:	4605                	li	a2,1
8000240e:	89aa                	mv	s3,a0
80002410:	8c2e                	mv	s8,a1
80002412:	2fc40513          	addi	a0,s0,764 # 800062fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062fd>
80002416:	4581                	li	a1,0
80002418:	688010ef          	jal	ra,80003aa0 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
8000241c:	80006537          	lui	a0,0x80006
80002420:	85ce                	mv	a1,s3
80002422:	b8050513          	addi	a0,a0,-1152 # 80005b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b81>
80002426:	a61ff0ef          	jal	ra,80001e86 <printk>
	PRINT_LINE;
8000242a:	80006937          	lui	s2,0x80006
8000242e:	b9890513          	addi	a0,s2,-1128 # 80005b98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b99>
		Z_TC_END_RESULT(ret, test->name);
80002432:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
80002436:	a51ff0ef          	jal	ra,80001e86 <printk>
8000243a:	25448493          	addi	s1,s1,596
	int fail = 0;
8000243e:	4a01                	li	s4,0
80002440:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002442:	80006cb7          	lui	s9,0x80006
80002446:	80006b37          	lui	s6,0x80006
8000244a:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
8000244e:	80006db7          	lui	s11,0x80006
80002452:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
80002456:	b38a8a93          	addi	s5,s5,-1224 # 80005b38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b39>
	while (suite->test) {
8000245a:	004c2783          	lw	a5,4(s8)
8000245e:	eb9d                	bnez	a5,80002494 <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002460:	85ce                	mv	a1,s3
	if (fail) {
80002462:	0c0a0363          	beqz	s4,80002528 <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
80002466:	80006537          	lui	a0,0x80006
8000246a:	c0850513          	addi	a0,a0,-1016 # 80005c08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c09>
8000246e:	a19ff0ef          	jal	ra,80001e86 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002472:	4785                	li	a5,1
80002474:	c09c                	sw	a5,0(s1)
}
80002476:	40f6                	lw	ra,92(sp)
80002478:	4466                	lw	s0,88(sp)
8000247a:	44d6                	lw	s1,84(sp)
8000247c:	4946                	lw	s2,80(sp)
8000247e:	49b6                	lw	s3,76(sp)
80002480:	4a26                	lw	s4,72(sp)
80002482:	4a96                	lw	s5,68(sp)
80002484:	4b06                	lw	s6,64(sp)
80002486:	5bf2                	lw	s7,60(sp)
80002488:	5c62                	lw	s8,56(sp)
8000248a:	5cd2                	lw	s9,52(sp)
8000248c:	5d42                	lw	s10,48(sp)
8000248e:	5db2                	lw	s11,44(sp)
80002490:	6125                	addi	sp,sp,96
80002492:	8082                	ret
	TC_START(test->name);
80002494:	000c2583          	lw	a1,0(s8)
80002498:	800067b7          	lui	a5,0x80006
8000249c:	be078513          	addi	a0,a5,-1056 # 80005be0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005be1>
800024a0:	9e7ff0ef          	jal	ra,80001e86 <printk>
800024a4:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
800024a6:	010c2783          	lw	a5,16(s8)
800024aa:	8762                	mv	a4,s8
800024ac:	40000613          	li	a2,1024
800024b0:	0087e793          	ori	a5,a5,8
800024b4:	58fd                	li	a7,-1
800024b6:	4801                	li	a6,0
800024b8:	35ad0693          	addi	a3,s10,858 # 8000235a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000235b>
800024bc:	c03e                	sw	a5,0(sp)
800024be:	490c8593          	addi	a1,s9,1168 # 80006490 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006491>
800024c2:	4781                	li	a5,0
800024c4:	30cb0513          	addi	a0,s6,780 # 8000630c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000630d>
800024c8:	2fd010ef          	jal	ra,80003fc4 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800024cc:	47f2                	lw	a5,28(sp)
800024ce:	55fd                	li	a1,-1
800024d0:	2fc78513          	addi	a0,a5,764
800024d4:	716010ef          	jal	ra,80003bea <z_impl_k_sem_take>
	if (test_result == -1) {
800024d8:	250d8793          	addi	a5,s11,592 # 80006250 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006251>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800024dc:	30cb0513          	addi	a0,s6,780
800024e0:	4380                	lw	s0,0(a5)
800024e2:	3fb010ef          	jal	ra,800040dc <z_impl_k_thread_abort>
	if (test_result == -2) {
800024e6:	800067b7          	lui	a5,0x80006
800024ea:	25078793          	addi	a5,a5,592 # 80006250 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006251>
800024ee:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
800024f0:	0405                	addi	s0,s0,1
	if (test_result == -2) {
800024f2:	57f9                	li	a5,-2
	if (test_result == -1) {
800024f4:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800024f8:	000c2603          	lw	a2,0(s8)
800024fc:	02f71163          	bne	a4,a5,8000251e <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002500:	800065b7          	lui	a1,0x80006
80002504:	bf458593          	addi	a1,a1,-1036 # 80005bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf5>
		Z_TC_END_RESULT(ret, test->name);
80002508:	bfcb8513          	addi	a0,s7,-1028 # 80005bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bfd>
8000250c:	97bff0ef          	jal	ra,80001e86 <printk>
80002510:	b9890513          	addi	a0,s2,-1128
80002514:	973ff0ef          	jal	ra,80001e86 <printk>
		fail += run_test(suite);
80002518:	9a22                	add	s4,s4,s0
		suite++;
8000251a:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
8000251c:	bf3d                	j	8000245a <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
8000251e:	00241793          	slli	a5,s0,0x2
80002522:	97d6                	add	a5,a5,s5
80002524:	438c                	lw	a1,0(a5)
80002526:	b7cd                	j	80002508 <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
80002528:	80006537          	lui	a0,0x80006
8000252c:	c2050513          	addi	a0,a0,-992 # 80005c20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c21>
80002530:	957ff0ef          	jal	ra,80001e86 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002534:	409c                	lw	a5,0(s1)
80002536:	00f037b3          	snez	a5,a5
8000253a:	bf2d                	j	80002474 <z_ztest_run_test_suite+0x94>

8000253c <end_report>:

void end_report(void)
{
	if (test_status) {
8000253c:	800067b7          	lui	a5,0x80006
80002540:	2547a783          	lw	a5,596(a5) # 80006254 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006255>
{
80002544:	1141                	addi	sp,sp,-16
80002546:	c422                	sw	s0,8(sp)
80002548:	80006537          	lui	a0,0x80006
8000254c:	c606                	sw	ra,12(sp)
8000254e:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
80002552:	b9850513          	addi	a0,a0,-1128 # 80005b98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b99>
	if (test_status) {
80002556:	cf91                	beqz	a5,80002572 <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
80002558:	92fff0ef          	jal	ra,80001e86 <printk>
8000255c:	800065b7          	lui	a1,0x80006
80002560:	b4458593          	addi	a1,a1,-1212 # 80005b44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b45>
	} else {
		TC_END_REPORT(TC_PASS);
80002564:	b4c40513          	addi	a0,s0,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
	}
}
80002568:	4422                	lw	s0,8(sp)
8000256a:	40b2                	lw	ra,12(sp)
8000256c:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
8000256e:	919ff06f          	j	80001e86 <printk>
80002572:	915ff0ef          	jal	ra,80001e86 <printk>
80002576:	800065b7          	lui	a1,0x80006
8000257a:	b6458593          	addi	a1,a1,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
8000257e:	b7dd                	j	80002564 <end_report+0x28>

80002580 <main>:

	return test_status;
}
#else
void main(void)
{
80002580:	1141                	addi	sp,sp,-16
80002582:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002584:	926ff0ef          	jal	ra,800016aa <test_main>
	end_report();
}
80002588:	40b2                	lw	ra,12(sp)
8000258a:	0141                	addi	sp,sp,16
	end_report();
8000258c:	bf45                	j	8000253c <end_report>

8000258e <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
8000258e:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002590:	c602                	sw	zero,12(sp)
    i++;
80002592:	47b2                	lw	a5,12(sp)
80002594:	0785                	addi	a5,a5,1
80002596:	c63e                	sw	a5,12(sp)
    uart[0] = c;
80002598:	f00107b7          	lui	a5,0xf0010
8000259c:	c38c                	sw	a1,0(a5)
}
8000259e:	0141                	addi	sp,sp,16
800025a0:	8082                	ret

800025a2 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800025a2:	557d                	li	a0,-1
800025a4:	8082                	ret

800025a6 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
800025a6:	4501                	li	a0,0
800025a8:	8082                	ret

800025aa <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800025aa:	00251713          	slli	a4,a0,0x2
800025ae:	800067b7          	lui	a5,0x80006
800025b2:	0505                	addi	a0,a0,1
800025b4:	c5078793          	addi	a5,a5,-944 # 80005c50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c51>
800025b8:	050a                	slli	a0,a0,0x2
{
800025ba:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800025bc:	973e                	add	a4,a4,a5
800025be:	97aa                	add	a5,a5,a0
{
800025c0:	c422                	sw	s0,8(sp)
800025c2:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800025c4:	4300                	lw	s0,0(a4)
800025c6:	4384                	lw	s1,0(a5)
{
800025c8:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800025ca:	00946763          	bltu	s0,s1,800025d8 <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800025ce:	40b2                	lw	ra,12(sp)
800025d0:	4422                	lw	s0,8(sp)
800025d2:	4492                	lw	s1,4(sp)
800025d4:	0141                	addi	sp,sp,16
800025d6:	8082                	ret
		retval = device_conf->init(info);
800025d8:	401c                	lw	a5,0(s0)
800025da:	8522                	mv	a0,s0
800025dc:	43dc                	lw	a5,4(a5)
800025de:	9782                	jalr	a5
		if (retval != 0) {
800025e0:	c119                	beqz	a0,800025e6 <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
800025e2:	00042223          	sw	zero,4(s0)
								info++) {
800025e6:	0431                	addi	s0,s0,12
800025e8:	b7cd                	j	800025ca <z_sys_device_do_config_level+0x20>

800025ea <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800025ea:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800025ec:	800067b7          	lui	a5,0x80006
{
800025f0:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800025f2:	800064b7          	lui	s1,0x80006
{
800025f6:	c422                	sw	s0,8(sp)
800025f8:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800025fa:	0e078413          	addi	s0,a5,224 # 800060e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e1>
{
800025fe:	c04a                	sw	s2,0(sp)
80002600:	0e078793          	addi	a5,a5,224
80002604:	11048493          	addi	s1,s1,272 # 80006110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006111>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002608:	00941863          	bne	s0,s1,80002618 <z_impl_device_get_binding+0x2e>
8000260c:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
8000260e:	843e                	mv	s0,a5
80002610:	00941c63          	bne	s0,s1,80002628 <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002614:	4401                	li	s0,0
80002616:	a01d                	j	8000263c <z_impl_device_get_binding+0x52>
		if ((info->driver_api != NULL) &&
80002618:	4058                	lw	a4,4(s0)
8000261a:	c709                	beqz	a4,80002624 <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
8000261c:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
8000261e:	4318                	lw	a4,0(a4)
80002620:	00a70e63          	beq	a4,a0,8000263c <z_impl_device_get_binding+0x52>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002624:	0431                	addi	s0,s0,12
80002626:	b7cd                	j	80002608 <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
80002628:	405c                	lw	a5,4(s0)
8000262a:	e399                	bnez	a5,80002630 <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000262c:	0431                	addi	s0,s0,12
8000262e:	b7cd                	j	80002610 <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
80002630:	401c                	lw	a5,0(s0)
80002632:	854a                	mv	a0,s2
80002634:	438c                	lw	a1,0(a5)
80002636:	ca1ff0ef          	jal	ra,800022d6 <strcmp>
8000263a:	f96d                	bnez	a0,8000262c <z_impl_device_get_binding+0x42>
}
8000263c:	8522                	mv	a0,s0
8000263e:	40b2                	lw	ra,12(sp)
80002640:	4422                	lw	s0,8(sp)
80002642:	4492                	lw	s1,4(sp)
80002644:	4902                	lw	s2,0(sp)
80002646:	0141                	addi	sp,sp,16
80002648:	8082                	ret

8000264a <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
8000264a:	1141                	addi	sp,sp,-16
8000264c:	c422                	sw	s0,8(sp)
8000264e:	c226                	sw	s1,4(sp)
80002650:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002652:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002654:	4489                	li	s1,2
80002656:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
8000265a:	755010ef          	jal	ra,800045ae <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
8000265e:	00a4c363          	blt	s1,a0,80002664 <idle+0x1a>
80002662:	4505                	li	a0,1
80002664:	4585                	li	a1,1
80002666:	002020ef          	jal	ra,80004668 <z_set_timeout_expiry>
	k_cpu_idle();
8000266a:	863ff0ef          	jal	ra,80001ecc <k_cpu_idle>
8000266e:	b7e5                	j	80002656 <idle+0xc>

80002670 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002670:	80006537          	lui	a0,0x80006
80002674:	800067b7          	lui	a5,0x80006
80002678:	23050613          	addi	a2,a0,560 # 80006230 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006231>
8000267c:	48878793          	addi	a5,a5,1160 # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
80002680:	40c78633          	sub	a2,a5,a2
80002684:	4581                	li	a1,0
80002686:	23050513          	addi	a0,a0,560
8000268a:	c67ff06f          	j	800022f0 <memset>

8000268e <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
8000268e:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002690:	4509                	li	a0,2
{
80002692:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002694:	3f19                	jal	800025aa <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002696:	80006537          	lui	a0,0x80006
8000269a:	c6450513          	addi	a0,a0,-924 # 80005c64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c65>
8000269e:	fe8ff0ef          	jal	ra,80001e86 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
800026a2:	450d                	li	a0,3
800026a4:	3719                	jal	800025aa <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
800026a6:	1bf010ef          	jal	ra,80004064 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
800026aa:	3dd9                	jal	80002580 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
800026ac:	800067b7          	lui	a5,0x80006
800026b0:	3ec78793          	addi	a5,a5,1004 # 800063ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063ed>
800026b4:	00c7c703          	lbu	a4,12(a5)
800026b8:	9b79                	andi	a4,a4,-2
800026ba:	00e78623          	sb	a4,12(a5)
}
800026be:	40b2                	lw	ra,12(sp)
800026c0:	0141                	addi	sp,sp,16
800026c2:	8082                	ret

800026c4 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
800026c4:	7135                	addi	sp,sp,-160
800026c6:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
800026c8:	800077b7          	lui	a5,0x80007
800026cc:	80006437          	lui	s0,0x80006
800026d0:	c74e                	sw	s3,140(sp)
800026d2:	49078793          	addi	a5,a5,1168 # 80007490 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007491>
800026d6:	45c40993          	addi	s3,s0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
800026da:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800026de:	081c                	addi	a5,sp,16
800026e0:	07000613          	li	a2,112
800026e4:	4581                	li	a1,0
800026e6:	853e                	mv	a0,a5
{
800026e8:	cf06                	sw	ra,156(sp)
800026ea:	cb26                	sw	s1,148(sp)
800026ec:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800026ee:	c03ff0ef          	jal	ra,800022f0 <memset>
800026f2:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800026f4:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800026f8:	4501                	li	a0,0
	struct k_thread dummy_thread = {
800026fa:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800026fe:	3575                	jal	800025aa <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002700:	4505                	li	a0,1
80002702:	3565                	jal	800025aa <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002704:	10100793          	li	a5,257
80002708:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
8000270c:	7eb000ef          	jal	ra,800036f6 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002710:	800067b7          	lui	a5,0x80006
80002714:	ca878793          	addi	a5,a5,-856 # 80005ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca9>
	_kernel.ready_q.cache = _main_thread;
80002718:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
8000271c:	c23e                	sw	a5,4(sp)
8000271e:	800026b7          	lui	a3,0x80002
80002722:	4785                	li	a5,1
80002724:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002728:	3ec90493          	addi	s1,s2,1004 # 800063ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063ed>
	z_setup_new_thread(_main_thread, _main_stack,
8000272c:	c03e                	sw	a5,0(sp)
8000272e:	4701                	li	a4,0
80002730:	4781                	li	a5,0
80002732:	4881                	li	a7,0
80002734:	4801                	li	a6,0
80002736:	68e68693          	addi	a3,a3,1678 # 8000268e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000268f>
8000273a:	20000613          	li	a2,512
8000273e:	89058593          	addi	a1,a1,-1904 # 80006890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006891>
80002742:	3ec90513          	addi	a0,s2,1004
	_kernel.ready_q.cache = _main_thread;
80002746:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
8000274a:	686010ef          	jal	ra,80003dd0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
8000274e:	00d4c783          	lbu	a5,13(s1)
80002752:	45c40413          	addi	s0,s0,1116
80002756:	ffb7f713          	andi	a4,a5,-5
8000275a:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000275e:	8bed                	andi	a5,a5,27
80002760:	e799                	bnez	a5,8000276e <z_cstart+0xaa>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002762:	4c9c                	lw	a5,24(s1)
80002764:	e789                	bnez	a5,8000276e <z_cstart+0xaa>
		z_add_thread_to_ready_q(thread);
80002766:	3ec90513          	addi	a0,s2,1004
8000276a:	7c6000ef          	jal	ra,80002f30 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
8000276e:	800067b7          	lui	a5,0x80006
80002772:	cb078793          	addi	a5,a5,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
80002776:	c23e                	sw	a5,4(sp)
80002778:	80006537          	lui	a0,0x80006
8000277c:	4785                	li	a5,1
8000277e:	800026b7          	lui	a3,0x80002
80002782:	800075b7          	lui	a1,0x80007
80002786:	37c50493          	addi	s1,a0,892 # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
8000278a:	c03e                	sw	a5,0(sp)
8000278c:	48bd                	li	a7,15
8000278e:	4801                	li	a6,0
80002790:	4781                	li	a5,0
80002792:	4701                	li	a4,0
80002794:	64a68693          	addi	a3,a3,1610 # 8000264a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000264b>
80002798:	20000613          	li	a2,512
8000279c:	a9058593          	addi	a1,a1,-1392 # 80006a90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a91>
800027a0:	37c50513          	addi	a0,a0,892
800027a4:	62c010ef          	jal	ra,80003dd0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800027a8:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800027ac:	c444                	sw	s1,12(s0)
800027ae:	4521                	li	a0,8
800027b0:	9bed                	andi	a5,a5,-5
800027b2:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800027b6:	800067b7          	lui	a5,0x80006
800027ba:	47478793          	addi	a5,a5,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
800027be:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800027c0:	cc5c                	sw	a5,28(s0)
800027c2:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800027c6:	8921                	andi	a0,a0,8
800027c8:	9f9fd0ef          	jal	ra,800001c0 <__swap>

800027cc <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800027cc:	00d54783          	lbu	a5,13(a0)
800027d0:	8bfd                	andi	a5,a5,31
800027d2:	e789                	bnez	a5,800027dc <z_is_thread_ready+0x10>
800027d4:	4d08                	lw	a0,24(a0)
800027d6:	00153513          	seqz	a0,a0
800027da:	8082                	ret
800027dc:	4501                	li	a0,0
}
800027de:	8082                	ret

800027e0 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
800027e0:	1141                	addi	sp,sp,-16
800027e2:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800027e4:	a1bff0ef          	jal	ra,800021fe <z_clock_elapsed>
800027e8:	800067b7          	lui	a5,0x80006
800027ec:	2607a783          	lw	a5,608(a5) # 80006260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006261>

	z_set_timeout_expiry(slice_time, false);
}
800027f0:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800027f2:	80006737          	lui	a4,0x80006
800027f6:	953e                	add	a0,a0,a5
800027f8:	46a72623          	sw	a0,1132(a4) # 8000646c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000646d>
	z_set_timeout_expiry(slice_time, false);
800027fc:	4581                	li	a1,0
800027fe:	853e                	mv	a0,a5
}
80002800:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002802:	6670106f          	j	80004668 <z_set_timeout_expiry>

80002806 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002806:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002808:	1141                	addi	sp,sp,-16
8000280a:	c422                	sw	s0,8(sp)
8000280c:	c606                	sw	ra,12(sp)
8000280e:	c226                	sw	s1,4(sp)
80002810:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002812:	e79d                	bnez	a5,80002840 <pended_on.isra.15+0x3a>
80002814:	800064b7          	lui	s1,0x80006
80002818:	800065b7          	lui	a1,0x80006
8000281c:	80006537          	lui	a0,0x80006
80002820:	d5458593          	addi	a1,a1,-684 # 80005d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d55>
80002824:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002828:	18300693          	li	a3,387
8000282c:	d4048613          	addi	a2,s1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002830:	e56ff0ef          	jal	ra,80001e86 <printk>
80002834:	18300593          	li	a1,387
80002838:	d4048513          	addi	a0,s1,-704
8000283c:	e68ff0ef          	jal	ra,80001ea4 <assert_post_action>

	return thread->base.pended_on;
}
80002840:	4008                	lw	a0,0(s0)
80002842:	40b2                	lw	ra,12(sp)
80002844:	4422                	lw	s0,8(sp)
80002846:	4492                	lw	s1,4(sp)
80002848:	0141                	addi	sp,sp,16
8000284a:	8082                	ret

8000284c <k_sched_time_slice_set>:
{
8000284c:	1101                	addi	sp,sp,-32
8000284e:	cc22                	sw	s0,24(sp)
80002850:	c64e                	sw	s3,12(sp)
80002852:	c452                	sw	s4,8(sp)
80002854:	ce06                	sw	ra,28(sp)
80002856:	ca26                	sw	s1,20(sp)
80002858:	c84a                	sw	s2,16(sp)
8000285a:	8a2a                	mv	s4,a0
8000285c:	89ae                	mv	s3,a1
8000285e:	4421                	li	s0,8
80002860:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002864:	800064b7          	lui	s1,0x80006
80002868:	25848513          	addi	a0,s1,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
8000286c:	8821                	andi	s0,s0,8
8000286e:	5ea010ef          	jal	ra,80003e58 <z_spin_lock_valid>
80002872:	ed0d                	bnez	a0,800028ac <k_sched_time_slice_set+0x60>
80002874:	80006937          	lui	s2,0x80006
80002878:	800065b7          	lui	a1,0x80006
8000287c:	80006537          	lui	a0,0x80006
80002880:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80002884:	04e00693          	li	a3,78
80002888:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000288c:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002890:	df6ff0ef          	jal	ra,80001e86 <printk>
80002894:	80006537          	lui	a0,0x80006
80002898:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
8000289c:	deaff0ef          	jal	ra,80001e86 <printk>
800028a0:	04e00593          	li	a1,78
800028a4:	ac490513          	addi	a0,s2,-1340
800028a8:	dfcff0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800028ac:	25848513          	addi	a0,s1,600
800028b0:	5e4010ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
800028b4:	800067b7          	lui	a5,0x80006
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800028b8:	45a9                	li	a1,10
800028ba:	009a0513          	addi	a0,s4,9
800028be:	4607a623          	sw	zero,1132(a5) # 8000646c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000646d>
800028c2:	80efe0ef          	jal	ra,800008d0 <__divsi3>
		slice_max_prio = prio;
800028c6:	800067b7          	lui	a5,0x80006
		slice_time = z_ms_to_ticks(slice);
800028ca:	80006937          	lui	s2,0x80006
800028ce:	26a92023          	sw	a0,608(s2) # 80006260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006261>
		slice_max_prio = prio;
800028d2:	2537ae23          	sw	s3,604(a5) # 8000625c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000625d>
		reset_time_slice();
800028d6:	3729                	jal	800027e0 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800028d8:	25848513          	addi	a0,s1,600
800028dc:	596010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800028e0:	ed0d                	bnez	a0,8000291a <k_sched_time_slice_set+0xce>
800028e2:	800064b7          	lui	s1,0x80006
800028e6:	800065b7          	lui	a1,0x80006
800028ea:	80006537          	lui	a0,0x80006
800028ee:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800028f2:	06100693          	li	a3,97
800028f6:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800028fa:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800028fe:	d88ff0ef          	jal	ra,80001e86 <printk>
80002902:	80006537          	lui	a0,0x80006
80002906:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
8000290a:	d7cff0ef          	jal	ra,80001e86 <printk>
8000290e:	06100593          	li	a1,97
80002912:	ac448513          	addi	a0,s1,-1340
80002916:	d8eff0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000291a:	30042473          	csrrs	s0,mstatus,s0
}
8000291e:	40f2                	lw	ra,28(sp)
80002920:	4462                	lw	s0,24(sp)
80002922:	44d2                	lw	s1,20(sp)
80002924:	4942                	lw	s2,16(sp)
80002926:	49b2                	lw	s3,12(sp)
80002928:	4a22                	lw	s4,8(sp)
8000292a:	6105                	addi	sp,sp,32
8000292c:	8082                	ret

8000292e <z_find_first_thread_to_unpend>:

ALWAYS_INLINE struct k_thread *z_find_first_thread_to_unpend(_wait_q_t *wait_q,
						     struct k_thread *from)
{
8000292e:	1101                	addi	sp,sp,-32
80002930:	cc22                	sw	s0,24(sp)
80002932:	c64e                	sw	s3,12(sp)
80002934:	ce06                	sw	ra,28(sp)
80002936:	ca26                	sw	s1,20(sp)
80002938:	c84a                	sw	s2,16(sp)
8000293a:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000293c:	4421                	li	s0,8
8000293e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002942:	800064b7          	lui	s1,0x80006
80002946:	25848513          	addi	a0,s1,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
8000294a:	8821                	andi	s0,s0,8
8000294c:	50c010ef          	jal	ra,80003e58 <z_spin_lock_valid>
80002950:	ed0d                	bnez	a0,8000298a <z_find_first_thread_to_unpend+0x5c>
80002952:	80006937          	lui	s2,0x80006
80002956:	800065b7          	lui	a1,0x80006
8000295a:	80006537          	lui	a0,0x80006
8000295e:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80002962:	04e00693          	li	a3,78
80002966:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000296a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000296e:	d18ff0ef          	jal	ra,80001e86 <printk>
80002972:	80006537          	lui	a0,0x80006
80002976:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
8000297a:	d0cff0ef          	jal	ra,80001e86 <printk>
8000297e:	04e00593          	li	a1,78
80002982:	ac490513          	addi	a0,s2,-1340
80002986:	d1eff0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
8000298a:	25848513          	addi	a0,s1,600
8000298e:	506010ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	ARG_UNUSED(from);

	struct k_thread *ret = NULL;

	LOCKED(&sched_spinlock) {
		ret = _priq_wait_best(&wait_q->waitq);
80002992:	854e                	mv	a0,s3
80002994:	265d                	jal	80002d3a <z_priq_dumb_best>
80002996:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002998:	25848513          	addi	a0,s1,600
8000299c:	4d6010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800029a0:	ed0d                	bnez	a0,800029da <z_find_first_thread_to_unpend+0xac>
800029a2:	800064b7          	lui	s1,0x80006
800029a6:	800065b7          	lui	a1,0x80006
800029aa:	80006537          	lui	a0,0x80006
800029ae:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800029b2:	06100693          	li	a3,97
800029b6:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800029ba:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800029be:	cc8ff0ef          	jal	ra,80001e86 <printk>
800029c2:	80006537          	lui	a0,0x80006
800029c6:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800029ca:	cbcff0ef          	jal	ra,80001e86 <printk>
800029ce:	06100593          	li	a1,97
800029d2:	ac448513          	addi	a0,s1,-1340
800029d6:	cceff0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800029da:	30042473          	csrrs	s0,mstatus,s0
	}

	return ret;
}
800029de:	40f2                	lw	ra,28(sp)
800029e0:	4462                	lw	s0,24(sp)
800029e2:	854a                	mv	a0,s2
800029e4:	44d2                	lw	s1,20(sp)
800029e6:	4942                	lw	s2,16(sp)
800029e8:	49b2                	lw	s3,12(sp)
800029ea:	6105                	addi	sp,sp,32
800029ec:	8082                	ret

800029ee <z_unpend_thread_no_timeout>:

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
800029ee:	1101                	addi	sp,sp,-32
800029f0:	cc22                	sw	s0,24(sp)
800029f2:	c84a                	sw	s2,16(sp)
800029f4:	ce06                	sw	ra,28(sp)
800029f6:	ca26                	sw	s1,20(sp)
800029f8:	c64e                	sw	s3,12(sp)
800029fa:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800029fc:	4421                	li	s0,8
800029fe:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002a02:	800064b7          	lui	s1,0x80006
80002a06:	25848513          	addi	a0,s1,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
80002a0a:	8821                	andi	s0,s0,8
80002a0c:	44c010ef          	jal	ra,80003e58 <z_spin_lock_valid>
80002a10:	ed0d                	bnez	a0,80002a4a <z_unpend_thread_no_timeout+0x5c>
80002a12:	800069b7          	lui	s3,0x80006
80002a16:	800065b7          	lui	a1,0x80006
80002a1a:	80006537          	lui	a0,0x80006
80002a1e:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80002a22:	04e00693          	li	a3,78
80002a26:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002a2a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002a2e:	c58ff0ef          	jal	ra,80001e86 <printk>
80002a32:	80006537          	lui	a0,0x80006
80002a36:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80002a3a:	c4cff0ef          	jal	ra,80001e86 <printk>
80002a3e:	04e00593          	li	a1,78
80002a42:	ac498513          	addi	a0,s3,-1340
80002a46:	c5eff0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002a4a:	25848513          	addi	a0,s1,600
80002a4e:	446010ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002a52:	00890513          	addi	a0,s2,8
80002a56:	3b45                	jal	80002806 <pended_on.isra.15>
80002a58:	85ca                	mv	a1,s2
80002a5a:	2451                	jal	80002cde <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002a5c:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002a60:	25848513          	addi	a0,s1,600
80002a64:	9bf5                	andi	a5,a5,-3
80002a66:	00f906a3          	sb	a5,13(s2)
80002a6a:	408010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80002a6e:	ed0d                	bnez	a0,80002aa8 <z_unpend_thread_no_timeout+0xba>
80002a70:	800064b7          	lui	s1,0x80006
80002a74:	800065b7          	lui	a1,0x80006
80002a78:	80006537          	lui	a0,0x80006
80002a7c:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80002a80:	06100693          	li	a3,97
80002a84:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002a88:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002a8c:	bfaff0ef          	jal	ra,80001e86 <printk>
80002a90:	80006537          	lui	a0,0x80006
80002a94:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80002a98:	beeff0ef          	jal	ra,80001e86 <printk>
80002a9c:	06100593          	li	a1,97
80002aa0:	ac448513          	addi	a0,s1,-1340
80002aa4:	c00ff0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002aa8:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80002aac:	40f2                	lw	ra,28(sp)
80002aae:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80002ab0:	00092423          	sw	zero,8(s2)
}
80002ab4:	44d2                	lw	s1,20(sp)
80002ab6:	4942                	lw	s2,16(sp)
80002ab8:	49b2                	lw	s3,12(sp)
80002aba:	6105                	addi	sp,sp,32
80002abc:	8082                	ret

80002abe <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80002abe:	800067b7          	lui	a5,0x80006
80002ac2:	45c7a783          	lw	a5,1116(a5) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
{
80002ac6:	1141                	addi	sp,sp,-16
80002ac8:	c422                	sw	s0,8(sp)
80002aca:	c606                	sw	ra,12(sp)
80002acc:	c226                	sw	s1,4(sp)
80002ace:	842e                	mv	s0,a1
	if (resched()) {
80002ad0:	e7b9                	bnez	a5,80002b1e <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ad2:	3a0010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80002ad6:	ed0d                	bnez	a0,80002b10 <z_reschedule+0x52>
80002ad8:	800064b7          	lui	s1,0x80006
80002adc:	800065b7          	lui	a1,0x80006
80002ae0:	80006537          	lui	a0,0x80006
80002ae4:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80002ae8:	07800693          	li	a3,120
80002aec:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002af0:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002af4:	b92ff0ef          	jal	ra,80001e86 <printk>
80002af8:	80006537          	lui	a0,0x80006
80002afc:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80002b00:	b86ff0ef          	jal	ra,80001e86 <printk>
80002b04:	07800593          	li	a1,120
80002b08:	ac448513          	addi	a0,s1,-1340
80002b0c:	b98ff0ef          	jal	ra,80001ea4 <assert_post_action>
80002b10:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80002b12:	4422                	lw	s0,8(sp)
80002b14:	40b2                	lw	ra,12(sp)
80002b16:	4492                	lw	s1,4(sp)
80002b18:	0141                	addi	sp,sp,16
80002b1a:	ea6fd06f          	j	800001c0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b1e:	354010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80002b22:	ed0d                	bnez	a0,80002b5c <z_reschedule+0x9e>
80002b24:	800064b7          	lui	s1,0x80006
80002b28:	800065b7          	lui	a1,0x80006
80002b2c:	80006537          	lui	a0,0x80006
80002b30:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80002b34:	06100693          	li	a3,97
80002b38:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002b3c:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002b40:	b46ff0ef          	jal	ra,80001e86 <printk>
80002b44:	80006537          	lui	a0,0x80006
80002b48:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80002b4c:	b3aff0ef          	jal	ra,80001e86 <printk>
80002b50:	06100593          	li	a1,97
80002b54:	ac448513          	addi	a0,s1,-1340
80002b58:	b4cff0ef          	jal	ra,80001ea4 <assert_post_action>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80002b5c:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b5e:	30042473          	csrrs	s0,mstatus,s0
80002b62:	40b2                	lw	ra,12(sp)
80002b64:	4422                	lw	s0,8(sp)
80002b66:	4492                	lw	s1,4(sp)
80002b68:	0141                	addi	sp,sp,16
80002b6a:	8082                	ret

80002b6c <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80002b6c:	80006737          	lui	a4,0x80006
80002b70:	45c72703          	lw	a4,1116(a4) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80002b74:	e319                	bnez	a4,80002b7a <z_reschedule_irqlock+0xe>
80002b76:	e4afd06f          	j	800001c0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80002b7a:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b7e:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002b82:	8082                	ret

80002b84 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002b84:	4521                	li	a0,8
80002b86:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80002b8a:	8921                	andi	a0,a0,8
80002b8c:	b7c5                	j	80002b6c <z_reschedule_irqlock>

80002b8e <k_sched_lock>:

void k_sched_lock(void)
{
80002b8e:	1101                	addi	sp,sp,-32
80002b90:	cc22                	sw	s0,24(sp)
80002b92:	ce06                	sw	ra,28(sp)
80002b94:	ca26                	sw	s1,20(sp)
80002b96:	c84a                	sw	s2,16(sp)
80002b98:	c64e                	sw	s3,12(sp)
80002b9a:	4421                	li	s0,8
80002b9c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002ba0:	800064b7          	lui	s1,0x80006
80002ba4:	25848513          	addi	a0,s1,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ba8:	8821                	andi	s0,s0,8
80002baa:	2ae010ef          	jal	ra,80003e58 <z_spin_lock_valid>
80002bae:	ed0d                	bnez	a0,80002be8 <k_sched_lock+0x5a>
80002bb0:	80006937          	lui	s2,0x80006
80002bb4:	800065b7          	lui	a1,0x80006
80002bb8:	80006537          	lui	a0,0x80006
80002bbc:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80002bc0:	04e00693          	li	a3,78
80002bc4:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002bc8:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002bcc:	abaff0ef          	jal	ra,80001e86 <printk>
80002bd0:	80006537          	lui	a0,0x80006
80002bd4:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80002bd8:	aaeff0ef          	jal	ra,80001e86 <printk>
80002bdc:	04e00593          	li	a1,78
80002be0:	ac490513          	addi	a0,s2,-1340
80002be4:	ac0ff0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002be8:	25848513          	addi	a0,s1,600
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80002bec:	80006937          	lui	s2,0x80006
80002bf0:	2a4010ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
80002bf4:	45c92783          	lw	a5,1116(s2) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80002bf8:	45c90913          	addi	s2,s2,1116
80002bfc:	cf8d                	beqz	a5,80002c36 <k_sched_lock+0xa8>
80002bfe:	800069b7          	lui	s3,0x80006
80002c02:	800065b7          	lui	a1,0x80006
80002c06:	80006537          	lui	a0,0x80006
80002c0a:	cd458593          	addi	a1,a1,-812 # 80005cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd5>
80002c0e:	10000693          	li	a3,256
80002c12:	cb898613          	addi	a2,s3,-840 # 80005cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb9>
80002c16:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002c1a:	a6cff0ef          	jal	ra,80001e86 <printk>
80002c1e:	80006537          	lui	a0,0x80006
80002c22:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80002c26:	a60ff0ef          	jal	ra,80001e86 <printk>
80002c2a:	10000593          	li	a1,256
80002c2e:	cb898513          	addi	a0,s3,-840
80002c32:	a72ff0ef          	jal	ra,80001ea4 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80002c36:	00892783          	lw	a5,8(s2)
80002c3a:	00f7c703          	lbu	a4,15(a5)
80002c3e:	4785                	li	a5,1
80002c40:	02f71e63          	bne	a4,a5,80002c7c <k_sched_lock+0xee>
80002c44:	800069b7          	lui	s3,0x80006
80002c48:	800065b7          	lui	a1,0x80006
80002c4c:	80006537          	lui	a0,0x80006
80002c50:	cf058593          	addi	a1,a1,-784 # 80005cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf1>
80002c54:	10100693          	li	a3,257
80002c58:	cb898613          	addi	a2,s3,-840 # 80005cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb9>
80002c5c:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002c60:	a26ff0ef          	jal	ra,80001e86 <printk>
80002c64:	80006537          	lui	a0,0x80006
80002c68:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80002c6c:	a1aff0ef          	jal	ra,80001e86 <printk>
80002c70:	10100593          	li	a1,257
80002c74:	cb898513          	addi	a0,s3,-840
80002c78:	a2cff0ef          	jal	ra,80001ea4 <assert_post_action>

	--_current->base.sched_locked;
80002c7c:	00892703          	lw	a4,8(s2)
80002c80:	00f74783          	lbu	a5,15(a4)
80002c84:	17fd                	addi	a5,a5,-1
80002c86:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002c8a:	25848513          	addi	a0,s1,600
80002c8e:	1e4010ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80002c92:	ed0d                	bnez	a0,80002ccc <k_sched_lock+0x13e>
80002c94:	800064b7          	lui	s1,0x80006
80002c98:	800065b7          	lui	a1,0x80006
80002c9c:	80006537          	lui	a0,0x80006
80002ca0:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80002ca4:	06100693          	li	a3,97
80002ca8:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002cac:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002cb0:	9d6ff0ef          	jal	ra,80001e86 <printk>
80002cb4:	80006537          	lui	a0,0x80006
80002cb8:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80002cbc:	9caff0ef          	jal	ra,80001e86 <printk>
80002cc0:	06100593          	li	a1,97
80002cc4:	ac448513          	addi	a0,s1,-1340
80002cc8:	9dcff0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ccc:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80002cd0:	40f2                	lw	ra,28(sp)
80002cd2:	4462                	lw	s0,24(sp)
80002cd4:	44d2                	lw	s1,20(sp)
80002cd6:	4942                	lw	s2,16(sp)
80002cd8:	49b2                	lw	s3,12(sp)
80002cda:	6105                	addi	sp,sp,32
80002cdc:	8082                	ret

80002cde <z_priq_dumb_remove>:
	return thread == _idle_thread;
80002cde:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80002ce2:	0dc7a783          	lw	a5,220(a5) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
{
80002ce6:	1141                	addi	sp,sp,-16
80002ce8:	c422                	sw	s0,8(sp)
80002cea:	c606                	sw	ra,12(sp)
80002cec:	c226                	sw	s1,4(sp)
80002cee:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80002cf0:	02f59863          	bne	a1,a5,80002d20 <z_priq_dumb_remove+0x42>
80002cf4:	800064b7          	lui	s1,0x80006
80002cf8:	800065b7          	lui	a1,0x80006
80002cfc:	80006537          	lui	a0,0x80006
80002d00:	dd858593          	addi	a1,a1,-552 # 80005dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd9>
80002d04:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002d08:	28c00693          	li	a3,652
80002d0c:	d4048613          	addi	a2,s1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002d10:	976ff0ef          	jal	ra,80001e86 <printk>
80002d14:	28c00593          	li	a1,652
80002d18:	d4048513          	addi	a0,s1,-704
80002d1c:	988ff0ef          	jal	ra,80001ea4 <assert_post_action>
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80002d20:	4058                	lw	a4,4(s0)
80002d22:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80002d24:	40b2                	lw	ra,12(sp)
80002d26:	4492                	lw	s1,4(sp)
80002d28:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80002d2a:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80002d2c:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80002d30:	00042223          	sw	zero,4(s0)
80002d34:	4422                	lw	s0,8(sp)
80002d36:	0141                	addi	sp,sp,16
80002d38:	8082                	ret

80002d3a <z_priq_dumb_best>:
	return list->head == list;
80002d3a:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002d3c:	00f51363          	bne	a0,a5,80002d42 <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80002d40:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80002d42:	853e                	mv	a0,a5
80002d44:	8082                	ret

80002d46 <update_cache>:
{
80002d46:	1141                	addi	sp,sp,-16
80002d48:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002d4a:	80006437          	lui	s0,0x80006
{
80002d4e:	c04a                	sw	s2,0(sp)
80002d50:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002d52:	45c40513          	addi	a0,s0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80002d56:	02450513          	addi	a0,a0,36
{
80002d5a:	c226                	sw	s1,4(sp)
80002d5c:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002d5e:	3ff1                	jal	80002d3a <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80002d60:	45c40413          	addi	s0,s0,1116
80002d64:	84aa                	mv	s1,a0
80002d66:	e111                	bnez	a0,80002d6a <update_cache+0x24>
80002d68:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
80002d6a:	06091263          	bnez	s2,80002dce <update_cache+0x88>
	__ASSERT(_current != NULL, "");
80002d6e:	441c                	lw	a5,8(s0)
80002d70:	ef8d                	bnez	a5,80002daa <update_cache+0x64>
80002d72:	80006937          	lui	s2,0x80006
80002d76:	800065b7          	lui	a1,0x80006
80002d7a:	80006537          	lui	a0,0x80006
80002d7e:	d6c58593          	addi	a1,a1,-660 # 80005d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d6d>
80002d82:	07f00693          	li	a3,127
80002d86:	d4090613          	addi	a2,s2,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002d8a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002d8e:	8f8ff0ef          	jal	ra,80001e86 <printk>
80002d92:	80006537          	lui	a0,0x80006
80002d96:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80002d9a:	8ecff0ef          	jal	ra,80001e86 <printk>
80002d9e:	07f00593          	li	a1,127
80002da2:	d4090513          	addi	a0,s2,-704
80002da6:	8feff0ef          	jal	ra,80001ea4 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80002daa:	441c                	lw	a5,8(s0)
80002dac:	00d7c703          	lbu	a4,13(a5)
80002db0:	8b7d                	andi	a4,a4,31
80002db2:	ef11                	bnez	a4,80002dce <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
80002db4:	00e7d683          	lhu	a3,14(a5)
80002db8:	07f00713          	li	a4,127
80002dbc:	00d77963          	bgeu	a4,a3,80002dce <update_cache+0x88>
		_kernel.ready_q.cache = _current;
80002dc0:	d01c                	sw	a5,32(s0)
}
80002dc2:	40b2                	lw	ra,12(sp)
80002dc4:	4422                	lw	s0,8(sp)
80002dc6:	4492                	lw	s1,4(sp)
80002dc8:	4902                	lw	s2,0(sp)
80002dca:	0141                	addi	sp,sp,16
80002dcc:	8082                	ret
		if (th != _current) {
80002dce:	441c                	lw	a5,8(s0)
80002dd0:	00978463          	beq	a5,s1,80002dd8 <update_cache+0x92>
			reset_time_slice();
80002dd4:	a0dff0ef          	jal	ra,800027e0 <reset_time_slice>
		_kernel.ready_q.cache = th;
80002dd8:	d004                	sw	s1,32(s0)
}
80002dda:	b7e5                	j	80002dc2 <update_cache+0x7c>

80002ddc <k_sched_unlock>:
{
80002ddc:	1101                	addi	sp,sp,-32
80002dde:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002de0:	80006937          	lui	s2,0x80006
80002de4:	45c90793          	addi	a5,s2,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80002de8:	479c                	lw	a5,8(a5)
{
80002dea:	ce06                	sw	ra,28(sp)
80002dec:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002dee:	00f7c783          	lbu	a5,15(a5)
{
80002df2:	ca26                	sw	s1,20(sp)
80002df4:	c64e                	sw	s3,12(sp)
80002df6:	45c90913          	addi	s2,s2,1116
	__ASSERT(_current->base.sched_locked != 0, "");
80002dfa:	ef8d                	bnez	a5,80002e34 <k_sched_unlock+0x58>
80002dfc:	80006437          	lui	s0,0x80006
80002e00:	800065b7          	lui	a1,0x80006
80002e04:	80006537          	lui	a0,0x80006
80002e08:	d1858593          	addi	a1,a1,-744 # 80005d18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d19>
80002e0c:	22100693          	li	a3,545
80002e10:	d4040613          	addi	a2,s0,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002e14:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002e18:	86eff0ef          	jal	ra,80001e86 <printk>
80002e1c:	80006537          	lui	a0,0x80006
80002e20:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80002e24:	862ff0ef          	jal	ra,80001e86 <printk>
80002e28:	22100593          	li	a1,545
80002e2c:	d4040513          	addi	a0,s0,-704
80002e30:	874ff0ef          	jal	ra,80001ea4 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80002e34:	00092783          	lw	a5,0(s2)
80002e38:	cf8d                	beqz	a5,80002e72 <k_sched_unlock+0x96>
80002e3a:	80006437          	lui	s0,0x80006
80002e3e:	800065b7          	lui	a1,0x80006
80002e42:	80006537          	lui	a0,0x80006
80002e46:	cd458593          	addi	a1,a1,-812 # 80005cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd5>
80002e4a:	22200693          	li	a3,546
80002e4e:	d4040613          	addi	a2,s0,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002e52:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002e56:	830ff0ef          	jal	ra,80001e86 <printk>
80002e5a:	80006537          	lui	a0,0x80006
80002e5e:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80002e62:	824ff0ef          	jal	ra,80001e86 <printk>
80002e66:	22200593          	li	a1,546
80002e6a:	d4040513          	addi	a0,s0,-704
80002e6e:	836ff0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002e72:	4421                	li	s0,8
80002e74:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e78:	800064b7          	lui	s1,0x80006
80002e7c:	25848513          	addi	a0,s1,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
80002e80:	8821                	andi	s0,s0,8
80002e82:	7d7000ef          	jal	ra,80003e58 <z_spin_lock_valid>
80002e86:	ed0d                	bnez	a0,80002ec0 <k_sched_unlock+0xe4>
80002e88:	800069b7          	lui	s3,0x80006
80002e8c:	800065b7          	lui	a1,0x80006
80002e90:	80006537          	lui	a0,0x80006
80002e94:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80002e98:	04e00693          	li	a3,78
80002e9c:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002ea0:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002ea4:	fe3fe0ef          	jal	ra,80001e86 <printk>
80002ea8:	80006537          	lui	a0,0x80006
80002eac:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80002eb0:	fd7fe0ef          	jal	ra,80001e86 <printk>
80002eb4:	04e00593          	li	a1,78
80002eb8:	ac498513          	addi	a0,s3,-1340
80002ebc:	fe9fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002ec0:	25848513          	addi	a0,s1,600
80002ec4:	7d1000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80002ec8:	00892703          	lw	a4,8(s2)
		update_cache(1);
80002ecc:	4505                	li	a0,1
		++_current->base.sched_locked;
80002ece:	00f74783          	lbu	a5,15(a4)
80002ed2:	0785                	addi	a5,a5,1
80002ed4:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80002ed8:	35bd                	jal	80002d46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002eda:	25848513          	addi	a0,s1,600
80002ede:	795000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80002ee2:	ed0d                	bnez	a0,80002f1c <k_sched_unlock+0x140>
80002ee4:	800064b7          	lui	s1,0x80006
80002ee8:	800065b7          	lui	a1,0x80006
80002eec:	80006537          	lui	a0,0x80006
80002ef0:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80002ef4:	06100693          	li	a3,97
80002ef8:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002efc:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002f00:	f87fe0ef          	jal	ra,80001e86 <printk>
80002f04:	80006537          	lui	a0,0x80006
80002f08:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80002f0c:	f7bfe0ef          	jal	ra,80001e86 <printk>
80002f10:	06100593          	li	a1,97
80002f14:	ac448513          	addi	a0,s1,-1340
80002f18:	f8dfe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f1c:	30042473          	csrrs	s0,mstatus,s0
}
80002f20:	4462                	lw	s0,24(sp)
80002f22:	40f2                	lw	ra,28(sp)
80002f24:	44d2                	lw	s1,20(sp)
80002f26:	4942                	lw	s2,16(sp)
80002f28:	49b2                	lw	s3,12(sp)
80002f2a:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
80002f2c:	c59ff06f          	j	80002b84 <z_reschedule_unlocked>

80002f30 <z_add_thread_to_ready_q>:
{
80002f30:	1101                	addi	sp,sp,-32
80002f32:	cc22                	sw	s0,24(sp)
80002f34:	ca26                	sw	s1,20(sp)
80002f36:	ce06                	sw	ra,28(sp)
80002f38:	c84a                	sw	s2,16(sp)
80002f3a:	c64e                	sw	s3,12(sp)
80002f3c:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f3e:	44a1                	li	s1,8
80002f40:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f44:	80006937          	lui	s2,0x80006
80002f48:	25890513          	addi	a0,s2,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f4c:	88a1                	andi	s1,s1,8
80002f4e:	70b000ef          	jal	ra,80003e58 <z_spin_lock_valid>
80002f52:	ed0d                	bnez	a0,80002f8c <z_add_thread_to_ready_q+0x5c>
80002f54:	800069b7          	lui	s3,0x80006
80002f58:	800065b7          	lui	a1,0x80006
80002f5c:	80006537          	lui	a0,0x80006
80002f60:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80002f64:	04e00693          	li	a3,78
80002f68:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80002f6c:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002f70:	f17fe0ef          	jal	ra,80001e86 <printk>
80002f74:	80006537          	lui	a0,0x80006
80002f78:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80002f7c:	f0bfe0ef          	jal	ra,80001e86 <printk>
80002f80:	04e00593          	li	a1,78
80002f84:	ac498513          	addi	a0,s3,-1340
80002f88:	f1dfe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80002f8c:	25890513          	addi	a0,s2,600
80002f90:	705000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80002f94:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80002f98:	0dc7a783          	lw	a5,220(a5) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
80002f9c:	02f41863          	bne	s0,a5,80002fcc <z_add_thread_to_ready_q+0x9c>
80002fa0:	800069b7          	lui	s3,0x80006
80002fa4:	800065b7          	lui	a1,0x80006
80002fa8:	80006537          	lui	a0,0x80006
80002fac:	dd858593          	addi	a1,a1,-552 # 80005dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd9>
80002fb0:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80002fb4:	27600693          	li	a3,630
80002fb8:	d4098613          	addi	a2,s3,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002fbc:	ecbfe0ef          	jal	ra,80001e86 <printk>
80002fc0:	27600593          	li	a1,630
80002fc4:	d4098513          	addi	a0,s3,-704
80002fc8:	eddfe0ef          	jal	ra,80001ea4 <assert_post_action>
	return list->head == list;
80002fcc:	80006737          	lui	a4,0x80006
80002fd0:	45c70693          	addi	a3,a4,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80002fd4:	52dc                	lw	a5,36(a3)
80002fd6:	5690                	lw	a2,40(a3)
80002fd8:	800066b7          	lui	a3,0x80006
80002fdc:	48068693          	addi	a3,a3,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
80002fe0:	45c70713          	addi	a4,a4,1116
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002fe4:	08d78563          	beq	a5,a3,8000306e <z_add_thread_to_ready_q+0x13e>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002fe8:	c3d9                	beqz	a5,8000306e <z_add_thread_to_ready_q+0x13e>
	if (t1->base.prio < t2->base.prio) {
80002fea:	00e40583          	lb	a1,14(s0)
80002fee:	00e78503          	lb	a0,14(a5)
80002ff2:	06a5da63          	bge	a1,a0,80003066 <z_add_thread_to_ready_q+0x136>
	node->prev = successor->prev;
80002ff6:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002ff8:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002ffa:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002ffc:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002ffe:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003000:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80003004:	4501                	li	a0,0
80003006:	0407e793          	ori	a5,a5,64
8000300a:	00f406a3          	sb	a5,13(s0)
8000300e:	d39ff0ef          	jal	ra,80002d46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003012:	25890513          	addi	a0,s2,600
80003016:	65d000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000301a:	ed0d                	bnez	a0,80003054 <z_add_thread_to_ready_q+0x124>
8000301c:	80006437          	lui	s0,0x80006
80003020:	800065b7          	lui	a1,0x80006
80003024:	80006537          	lui	a0,0x80006
80003028:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
8000302c:	06100693          	li	a3,97
80003030:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003034:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003038:	e4ffe0ef          	jal	ra,80001e86 <printk>
8000303c:	80006537          	lui	a0,0x80006
80003040:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003044:	e43fe0ef          	jal	ra,80001e86 <printk>
80003048:	06100593          	li	a1,97
8000304c:	ac440513          	addi	a0,s0,-1340
80003050:	e55fe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003054:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003058:	40f2                	lw	ra,28(sp)
8000305a:	4462                	lw	s0,24(sp)
8000305c:	44d2                	lw	s1,20(sp)
8000305e:	4942                	lw	s2,16(sp)
80003060:	49b2                	lw	s3,12(sp)
80003062:	6105                	addi	sp,sp,32
80003064:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80003066:	00f60463          	beq	a2,a5,8000306e <z_add_thread_to_ready_q+0x13e>
8000306a:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000306c:	f3c9                	bnez	a5,80002fee <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
8000306e:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80003070:	571c                	lw	a5,40(a4)
	node->next = list;
80003072:	c014                	sw	a3,0(s0)
	list->tail->next = node;
80003074:	c380                	sw	s0,0(a5)
	list->tail = node;
80003076:	d700                	sw	s0,40(a4)
80003078:	b761                	j	80003000 <z_add_thread_to_ready_q+0xd0>

8000307a <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
8000307a:	ff052783          	lw	a5,-16(a0)
{
8000307e:	1101                	addi	sp,sp,-32
80003080:	cc22                	sw	s0,24(sp)
80003082:	c64e                	sw	s3,12(sp)
80003084:	ce06                	sw	ra,28(sp)
80003086:	ca26                	sw	s1,20(sp)
80003088:	c84a                	sw	s2,16(sp)
8000308a:	c452                	sw	s4,8(sp)
8000308c:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
8000308e:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003092:	cfcd                	beqz	a5,8000314c <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003094:	44a1                	li	s1,8
80003096:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000309a:	80006937          	lui	s2,0x80006
8000309e:	25890513          	addi	a0,s2,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
800030a2:	88a1                	andi	s1,s1,8
800030a4:	5b5000ef          	jal	ra,80003e58 <z_spin_lock_valid>
800030a8:	ed0d                	bnez	a0,800030e2 <z_thread_timeout+0x68>
800030aa:	80006a37          	lui	s4,0x80006
800030ae:	800065b7          	lui	a1,0x80006
800030b2:	80006537          	lui	a0,0x80006
800030b6:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800030ba:	04e00693          	li	a3,78
800030be:	ac4a0613          	addi	a2,s4,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800030c2:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800030c6:	dc1fe0ef          	jal	ra,80001e86 <printk>
800030ca:	80006537          	lui	a0,0x80006
800030ce:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
800030d2:	db5fe0ef          	jal	ra,80001e86 <printk>
800030d6:	04e00593          	li	a1,78
800030da:	ac4a0513          	addi	a0,s4,-1340
800030de:	dc7fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800030e2:	25890513          	addi	a0,s2,600
800030e6:	5af000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800030ea:	ff040513          	addi	a0,s0,-16
800030ee:	f18ff0ef          	jal	ra,80002806 <pended_on.isra.15>
800030f2:	85ce                	mv	a1,s3
800030f4:	bebff0ef          	jal	ra,80002cde <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800030f8:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800030fc:	25890513          	addi	a0,s2,600
80003100:	9bf5                	andi	a5,a5,-3
80003102:	fef40aa3          	sb	a5,-11(s0)
80003106:	56d000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000310a:	ed0d                	bnez	a0,80003144 <z_thread_timeout+0xca>
8000310c:	80006937          	lui	s2,0x80006
80003110:	800065b7          	lui	a1,0x80006
80003114:	80006537          	lui	a0,0x80006
80003118:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
8000311c:	06100693          	li	a3,97
80003120:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003124:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003128:	d5ffe0ef          	jal	ra,80001e86 <printk>
8000312c:	80006537          	lui	a0,0x80006
80003130:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003134:	d53fe0ef          	jal	ra,80001e86 <printk>
80003138:	06100593          	li	a1,97
8000313c:	ac490513          	addi	a0,s2,-1340
80003140:	d65fe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003144:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003148:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
8000314c:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003150:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003152:	9bad                	andi	a5,a5,-21
80003154:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003158:	e74ff0ef          	jal	ra,800027cc <z_is_thread_ready>
8000315c:	c919                	beqz	a0,80003172 <z_thread_timeout+0xf8>
}
8000315e:	4462                	lw	s0,24(sp)
80003160:	40f2                	lw	ra,28(sp)
80003162:	44d2                	lw	s1,20(sp)
80003164:	4942                	lw	s2,16(sp)
80003166:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003168:	854e                	mv	a0,s3
8000316a:	49b2                	lw	s3,12(sp)
8000316c:	6105                	addi	sp,sp,32
8000316e:	dc3ff06f          	j	80002f30 <z_add_thread_to_ready_q>
80003172:	40f2                	lw	ra,28(sp)
80003174:	4462                	lw	s0,24(sp)
80003176:	44d2                	lw	s1,20(sp)
80003178:	4942                	lw	s2,16(sp)
8000317a:	49b2                	lw	s3,12(sp)
8000317c:	4a22                	lw	s4,8(sp)
8000317e:	6105                	addi	sp,sp,32
80003180:	8082                	ret

80003182 <z_move_thread_to_end_of_prio_q>:
{
80003182:	1101                	addi	sp,sp,-32
80003184:	cc22                	sw	s0,24(sp)
80003186:	c84a                	sw	s2,16(sp)
80003188:	ce06                	sw	ra,28(sp)
8000318a:	ca26                	sw	s1,20(sp)
8000318c:	c64e                	sw	s3,12(sp)
8000318e:	c452                	sw	s4,8(sp)
80003190:	c256                	sw	s5,4(sp)
80003192:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003194:	4921                	li	s2,8
80003196:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000319a:	800069b7          	lui	s3,0x80006
8000319e:	25898513          	addi	a0,s3,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
800031a2:	00897913          	andi	s2,s2,8
800031a6:	4b3000ef          	jal	ra,80003e58 <z_spin_lock_valid>
800031aa:	ed0d                	bnez	a0,800031e4 <z_move_thread_to_end_of_prio_q+0x62>
800031ac:	800064b7          	lui	s1,0x80006
800031b0:	800065b7          	lui	a1,0x80006
800031b4:	80006537          	lui	a0,0x80006
800031b8:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800031bc:	04e00693          	li	a3,78
800031c0:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800031c4:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800031c8:	cbffe0ef          	jal	ra,80001e86 <printk>
800031cc:	80006537          	lui	a0,0x80006
800031d0:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
800031d4:	cb3fe0ef          	jal	ra,80001e86 <printk>
800031d8:	04e00593          	li	a1,78
800031dc:	ac448513          	addi	a0,s1,-1340
800031e0:	cc5fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800031e4:	25898513          	addi	a0,s3,600
800031e8:	4ad000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800031ec:	800064b7          	lui	s1,0x80006
800031f0:	45c48513          	addi	a0,s1,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
800031f4:	85a2                	mv	a1,s0
800031f6:	02450513          	addi	a0,a0,36
800031fa:	ae5ff0ef          	jal	ra,80002cde <z_priq_dumb_remove>
	return thread == _idle_thread;
800031fe:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003202:	0dc7a783          	lw	a5,220(a5) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
80003206:	80006a37          	lui	s4,0x80006
8000320a:	45c48493          	addi	s1,s1,1116
8000320e:	480a0a13          	addi	s4,s4,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
80003212:	02f41863          	bne	s0,a5,80003242 <z_move_thread_to_end_of_prio_q+0xc0>
80003216:	80006ab7          	lui	s5,0x80006
8000321a:	800065b7          	lui	a1,0x80006
8000321e:	80006537          	lui	a0,0x80006
80003222:	dd858593          	addi	a1,a1,-552 # 80005dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd9>
80003226:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000322a:	27600693          	li	a3,630
8000322e:	d40a8613          	addi	a2,s5,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003232:	c55fe0ef          	jal	ra,80001e86 <printk>
80003236:	27600593          	li	a1,630
8000323a:	d40a8513          	addi	a0,s5,-704
8000323e:	c67fe0ef          	jal	ra,80001ea4 <assert_post_action>
	return list->head == list;
80003242:	50dc                	lw	a5,36(s1)
80003244:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003246:	09478a63          	beq	a5,s4,800032da <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000324a:	cbc1                	beqz	a5,800032da <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
8000324c:	00e40683          	lb	a3,14(s0)
80003250:	00e78603          	lb	a2,14(a5)
80003254:	06c6df63          	bge	a3,a2,800032d2 <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
80003258:	43d8                	lw	a4,4(a5)
	node->next = successor;
8000325a:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
8000325c:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
8000325e:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003260:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003262:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003266:	4488                	lw	a0,8(s1)
80003268:	0407e793          	ori	a5,a5,64
8000326c:	8d01                	sub	a0,a0,s0
8000326e:	00153513          	seqz	a0,a0
80003272:	00f406a3          	sb	a5,13(s0)
80003276:	ad1ff0ef          	jal	ra,80002d46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000327a:	25898513          	addi	a0,s3,600
8000327e:	3f5000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80003282:	ed0d                	bnez	a0,800032bc <z_move_thread_to_end_of_prio_q+0x13a>
80003284:	80006437          	lui	s0,0x80006
80003288:	800065b7          	lui	a1,0x80006
8000328c:	80006537          	lui	a0,0x80006
80003290:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80003294:	06100693          	li	a3,97
80003298:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000329c:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800032a0:	be7fe0ef          	jal	ra,80001e86 <printk>
800032a4:	80006537          	lui	a0,0x80006
800032a8:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800032ac:	bdbfe0ef          	jal	ra,80001e86 <printk>
800032b0:	06100593          	li	a1,97
800032b4:	ac440513          	addi	a0,s0,-1340
800032b8:	bedfe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800032bc:	30092973          	csrrs	s2,mstatus,s2
}
800032c0:	40f2                	lw	ra,28(sp)
800032c2:	4462                	lw	s0,24(sp)
800032c4:	44d2                	lw	s1,20(sp)
800032c6:	4942                	lw	s2,16(sp)
800032c8:	49b2                	lw	s3,12(sp)
800032ca:	4a22                	lw	s4,8(sp)
800032cc:	4a92                	lw	s5,4(sp)
800032ce:	6105                	addi	sp,sp,32
800032d0:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
800032d2:	00e78463          	beq	a5,a4,800032da <z_move_thread_to_end_of_prio_q+0x158>
800032d6:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800032d8:	ffa5                	bnez	a5,80003250 <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
800032da:	c058                	sw	a4,4(s0)
	list->tail->next = node;
800032dc:	549c                	lw	a5,40(s1)
	node->next = list;
800032de:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800032e2:	c380                	sw	s0,0(a5)
	list->tail = node;
800032e4:	d480                	sw	s0,40(s1)
800032e6:	bfb5                	j	80003262 <z_move_thread_to_end_of_prio_q+0xe0>

800032e8 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
800032e8:	800067b7          	lui	a5,0x80006
800032ec:	2607a783          	lw	a5,608(a5) # 80006260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006261>
800032f0:	cbb1                	beqz	a5,80003344 <z_time_slice+0x5c>
800032f2:	800067b7          	lui	a5,0x80006
800032f6:	45c78793          	addi	a5,a5,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
800032fa:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
800032fc:	07f00693          	li	a3,127
80003300:	00e75603          	lhu	a2,14(a4)
80003304:	04c6e063          	bltu	a3,a2,80003344 <z_time_slice+0x5c>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003308:	800066b7          	lui	a3,0x80006
8000330c:	00e70603          	lb	a2,14(a4)
80003310:	25c6a683          	lw	a3,604(a3) # 8000625c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000625d>
80003314:	02d64863          	blt	a2,a3,80003344 <z_time_slice+0x5c>
	return thread == _idle_thread;
80003318:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
8000331c:	0dc6a683          	lw	a3,220(a3) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
80003320:	02d70263          	beq	a4,a3,80003344 <z_time_slice+0x5c>
		&& !z_is_thread_timeout_active(t);
80003324:	4f14                	lw	a3,24(a4)
80003326:	ee99                	bnez	a3,80003344 <z_time_slice+0x5c>
		if (ticks >= _current_cpu->slice_ticks) {
80003328:	4b94                	lw	a3,16(a5)
8000332a:	00d54b63          	blt	a0,a3,80003340 <z_time_slice+0x58>
{
8000332e:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003330:	853a                	mv	a0,a4
{
80003332:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003334:	e4fff0ef          	jal	ra,80003182 <z_move_thread_to_end_of_prio_q>
}
80003338:	40b2                	lw	ra,12(sp)
8000333a:	0141                	addi	sp,sp,16
			reset_time_slice();
8000333c:	ca4ff06f          	j	800027e0 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003340:	8e89                	sub	a3,a3,a0
80003342:	cb94                	sw	a3,16(a5)
80003344:	8082                	ret

80003346 <z_remove_thread_from_ready_q>:
{
80003346:	1101                	addi	sp,sp,-32
80003348:	cc22                	sw	s0,24(sp)
8000334a:	c64e                	sw	s3,12(sp)
8000334c:	ce06                	sw	ra,28(sp)
8000334e:	ca26                	sw	s1,20(sp)
80003350:	c84a                	sw	s2,16(sp)
80003352:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003354:	4421                	li	s0,8
80003356:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000335a:	800064b7          	lui	s1,0x80006
8000335e:	25848513          	addi	a0,s1,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
80003362:	8821                	andi	s0,s0,8
80003364:	2f5000ef          	jal	ra,80003e58 <z_spin_lock_valid>
80003368:	ed0d                	bnez	a0,800033a2 <z_remove_thread_from_ready_q+0x5c>
8000336a:	80006937          	lui	s2,0x80006
8000336e:	800065b7          	lui	a1,0x80006
80003372:	80006537          	lui	a0,0x80006
80003376:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
8000337a:	04e00693          	li	a3,78
8000337e:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003382:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003386:	b01fe0ef          	jal	ra,80001e86 <printk>
8000338a:	80006537          	lui	a0,0x80006
8000338e:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80003392:	af5fe0ef          	jal	ra,80001e86 <printk>
80003396:	04e00593          	li	a1,78
8000339a:	ac490513          	addi	a0,s2,-1340
8000339e:	b07fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800033a2:	25848513          	addi	a0,s1,600
800033a6:	2ef000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
800033aa:	00d9c783          	lbu	a5,13(s3)
800033ae:	80006937          	lui	s2,0x80006
800033b2:	45c90913          	addi	s2,s2,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
800033b6:	0407f793          	andi	a5,a5,64
800033ba:	cf81                	beqz	a5,800033d2 <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
800033bc:	85ce                	mv	a1,s3
800033be:	02490513          	addi	a0,s2,36
800033c2:	91dff0ef          	jal	ra,80002cde <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
800033c6:	00d9c783          	lbu	a5,13(s3)
800033ca:	fbf7f793          	andi	a5,a5,-65
800033ce:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
800033d2:	00892503          	lw	a0,8(s2)
800033d6:	41350533          	sub	a0,a0,s3
800033da:	00153513          	seqz	a0,a0
800033de:	969ff0ef          	jal	ra,80002d46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800033e2:	25848513          	addi	a0,s1,600
800033e6:	28d000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800033ea:	ed0d                	bnez	a0,80003424 <z_remove_thread_from_ready_q+0xde>
800033ec:	800064b7          	lui	s1,0x80006
800033f0:	800065b7          	lui	a1,0x80006
800033f4:	80006537          	lui	a0,0x80006
800033f8:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800033fc:	06100693          	li	a3,97
80003400:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003404:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003408:	a7ffe0ef          	jal	ra,80001e86 <printk>
8000340c:	80006537          	lui	a0,0x80006
80003410:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003414:	a73fe0ef          	jal	ra,80001e86 <printk>
80003418:	06100593          	li	a1,97
8000341c:	ac448513          	addi	a0,s1,-1340
80003420:	a85fe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003424:	30042473          	csrrs	s0,mstatus,s0
}
80003428:	40f2                	lw	ra,28(sp)
8000342a:	4462                	lw	s0,24(sp)
8000342c:	44d2                	lw	s1,20(sp)
8000342e:	4942                	lw	s2,16(sp)
80003430:	49b2                	lw	s3,12(sp)
80003432:	6105                	addi	sp,sp,32
80003434:	8082                	ret

80003436 <pend>:
{
80003436:	1101                	addi	sp,sp,-32
80003438:	cc22                	sw	s0,24(sp)
8000343a:	ca26                	sw	s1,20(sp)
8000343c:	842a                	mv	s0,a0
8000343e:	c84a                	sw	s2,16(sp)
80003440:	ce06                	sw	ra,28(sp)
80003442:	c64e                	sw	s3,12(sp)
80003444:	84ae                	mv	s1,a1
80003446:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003448:	effff0ef          	jal	ra,80003346 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
8000344c:	00d44783          	lbu	a5,13(s0)
80003450:	0027e793          	ori	a5,a5,2
80003454:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003458:	cca9                	beqz	s1,800034b2 <pend+0x7c>
	return thread == _idle_thread;
8000345a:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
8000345e:	0dc7a783          	lw	a5,220(a5) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
		thread->base.pended_on = wait_q;
80003462:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003464:	02f41863          	bne	s0,a5,80003494 <pend+0x5e>
80003468:	800069b7          	lui	s3,0x80006
8000346c:	800065b7          	lui	a1,0x80006
80003470:	80006537          	lui	a0,0x80006
80003474:	dd858593          	addi	a1,a1,-552 # 80005dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd9>
80003478:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000347c:	27600693          	li	a3,630
80003480:	d4098613          	addi	a2,s3,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003484:	a03fe0ef          	jal	ra,80001e86 <printk>
80003488:	27600593          	li	a1,630
8000348c:	d4098513          	addi	a0,s3,-704
80003490:	a15fe0ef          	jal	ra,80001ea4 <assert_post_action>
	return list->head == list;
80003494:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003496:	04f48b63          	beq	s1,a5,800034ec <pend+0xb6>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000349a:	cba9                	beqz	a5,800034ec <pend+0xb6>
	if (t1->base.prio < t2->base.prio) {
8000349c:	00e40703          	lb	a4,14(s0)
800034a0:	00e78683          	lb	a3,14(a5)
800034a4:	02d75f63          	bge	a4,a3,800034e2 <pend+0xac>
	node->prev = successor->prev;
800034a8:	43d8                	lw	a4,4(a5)
	node->next = successor;
800034aa:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
800034ac:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
800034ae:	c300                	sw	s0,0(a4)
	successor->prev = node;
800034b0:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
800034b2:	57fd                	li	a5,-1
800034b4:	04f90363          	beq	s2,a5,800034fa <pend+0xc4>
800034b8:	45a9                	li	a1,10
800034ba:	00990513          	addi	a0,s2,9
800034be:	c12fd0ef          	jal	ra,800008d0 <__divsi3>

extern void z_thread_timeout(struct _timeout *to);

static inline void z_add_thread_timeout(struct k_thread *th, s32_t ticks)
{
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800034c2:	00150613          	addi	a2,a0,1
800034c6:	01840513          	addi	a0,s0,24
}
800034ca:	4462                	lw	s0,24(sp)
800034cc:	40f2                	lw	ra,28(sp)
800034ce:	44d2                	lw	s1,20(sp)
800034d0:	4942                	lw	s2,16(sp)
800034d2:	49b2                	lw	s3,12(sp)
800034d4:	800035b7          	lui	a1,0x80003
800034d8:	07a58593          	addi	a1,a1,122 # 8000307a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000307b>
800034dc:	6105                	addi	sp,sp,32
800034de:	54f0006f          	j	8000422c <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
800034e2:	40d4                	lw	a3,4(s1)
800034e4:	00d78463          	beq	a5,a3,800034ec <pend+0xb6>
800034e8:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800034ea:	fbdd                	bnez	a5,800034a0 <pend+0x6a>
	node->prev = list->tail;
800034ec:	40dc                	lw	a5,4(s1)
	node->next = list;
800034ee:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
800034f0:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
800034f2:	40dc                	lw	a5,4(s1)
800034f4:	c380                	sw	s0,0(a5)
	list->tail = node;
800034f6:	c0c0                	sw	s0,4(s1)
800034f8:	bf6d                	j	800034b2 <pend+0x7c>
}
800034fa:	40f2                	lw	ra,28(sp)
800034fc:	4462                	lw	s0,24(sp)
800034fe:	44d2                	lw	s1,20(sp)
80003500:	4942                	lw	s2,16(sp)
80003502:	49b2                	lw	s3,12(sp)
80003504:	6105                	addi	sp,sp,32
80003506:	8082                	ret

80003508 <z_pend_curr>:
{
80003508:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
8000350a:	800067b7          	lui	a5,0x80006
{
8000350e:	c422                	sw	s0,8(sp)
80003510:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80003512:	4647a503          	lw	a0,1124(a5) # 80006464 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006465>
{
80003516:	c226                	sw	s1,4(sp)
80003518:	84ae                	mv	s1,a1
8000351a:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
8000351c:	8636                	mv	a2,a3
{
8000351e:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003520:	f17ff0ef          	jal	ra,80003436 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003524:	8522                	mv	a0,s0
80003526:	14d000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000352a:	ed0d                	bnez	a0,80003564 <z_pend_curr+0x5c>
8000352c:	80006437          	lui	s0,0x80006
80003530:	800065b7          	lui	a1,0x80006
80003534:	80006537          	lui	a0,0x80006
80003538:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
8000353c:	07800693          	li	a3,120
80003540:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003544:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003548:	93ffe0ef          	jal	ra,80001e86 <printk>
8000354c:	80006537          	lui	a0,0x80006
80003550:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003554:	933fe0ef          	jal	ra,80001e86 <printk>
80003558:	07800593          	li	a1,120
8000355c:	ac440513          	addi	a0,s0,-1340
80003560:	945fe0ef          	jal	ra,80001ea4 <assert_post_action>
}
80003564:	4422                	lw	s0,8(sp)
80003566:	40b2                	lw	ra,12(sp)
80003568:	8526                	mv	a0,s1
8000356a:	4492                	lw	s1,4(sp)
8000356c:	0141                	addi	sp,sp,16
8000356e:	c53fc06f          	j	800001c0 <__swap>

80003572 <z_unpend_first_thread>:
{
80003572:	1101                	addi	sp,sp,-32
80003574:	c84a                	sw	s2,16(sp)
80003576:	c64e                	sw	s3,12(sp)
80003578:	ce06                	sw	ra,28(sp)
8000357a:	cc22                	sw	s0,24(sp)
8000357c:	ca26                	sw	s1,20(sp)
8000357e:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003580:	4921                	li	s2,8
80003582:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003586:	800064b7          	lui	s1,0x80006
8000358a:	25848513          	addi	a0,s1,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
8000358e:	00897913          	andi	s2,s2,8
80003592:	0c7000ef          	jal	ra,80003e58 <z_spin_lock_valid>
80003596:	ed0d                	bnez	a0,800035d0 <z_unpend_first_thread+0x5e>
80003598:	80006437          	lui	s0,0x80006
8000359c:	800065b7          	lui	a1,0x80006
800035a0:	80006537          	lui	a0,0x80006
800035a4:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800035a8:	04e00693          	li	a3,78
800035ac:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800035b0:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800035b4:	8d3fe0ef          	jal	ra,80001e86 <printk>
800035b8:	80006537          	lui	a0,0x80006
800035bc:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
800035c0:	8c7fe0ef          	jal	ra,80001e86 <printk>
800035c4:	04e00593          	li	a1,78
800035c8:	ac440513          	addi	a0,s0,-1340
800035cc:	8d9fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800035d0:	25848513          	addi	a0,s1,600
800035d4:	0c1000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
800035d8:	854e                	mv	a0,s3
800035da:	f60ff0ef          	jal	ra,80002d3a <z_priq_dumb_best>
800035de:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800035e0:	25848513          	addi	a0,s1,600
800035e4:	08f000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800035e8:	ed0d                	bnez	a0,80003622 <z_unpend_first_thread+0xb0>
800035ea:	800069b7          	lui	s3,0x80006
800035ee:	800065b7          	lui	a1,0x80006
800035f2:	80006537          	lui	a0,0x80006
800035f6:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800035fa:	06100693          	li	a3,97
800035fe:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003602:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003606:	881fe0ef          	jal	ra,80001e86 <printk>
8000360a:	80006537          	lui	a0,0x80006
8000360e:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003612:	875fe0ef          	jal	ra,80001e86 <printk>
80003616:	06100593          	li	a1,97
8000361a:	ac498513          	addi	a0,s3,-1340
8000361e:	887fe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003622:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003626:	c061                	beqz	s0,800036e6 <z_unpend_first_thread+0x174>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003628:	4921                	li	s2,8
8000362a:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000362e:	25848513          	addi	a0,s1,600
	key = (mstatus & SOC_MSTATUS_IEN);
80003632:	00897913          	andi	s2,s2,8
80003636:	023000ef          	jal	ra,80003e58 <z_spin_lock_valid>
8000363a:	ed0d                	bnez	a0,80003674 <z_unpend_first_thread+0x102>
8000363c:	800069b7          	lui	s3,0x80006
80003640:	800065b7          	lui	a1,0x80006
80003644:	80006537          	lui	a0,0x80006
80003648:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
8000364c:	04e00693          	li	a3,78
80003650:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003654:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003658:	82ffe0ef          	jal	ra,80001e86 <printk>
8000365c:	80006537          	lui	a0,0x80006
80003660:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80003664:	823fe0ef          	jal	ra,80001e86 <printk>
80003668:	04e00593          	li	a1,78
8000366c:	ac498513          	addi	a0,s3,-1340
80003670:	835fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003674:	25848513          	addi	a0,s1,600
80003678:	01d000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000367c:	00840513          	addi	a0,s0,8
80003680:	986ff0ef          	jal	ra,80002806 <pended_on.isra.15>
80003684:	85a2                	mv	a1,s0
80003686:	e58ff0ef          	jal	ra,80002cde <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000368a:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000368e:	25848513          	addi	a0,s1,600
80003692:	9bf5                	andi	a5,a5,-3
80003694:	00f406a3          	sb	a5,13(s0)
80003698:	7da000ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000369c:	ed0d                	bnez	a0,800036d6 <z_unpend_first_thread+0x164>
8000369e:	800064b7          	lui	s1,0x80006
800036a2:	800065b7          	lui	a1,0x80006
800036a6:	80006537          	lui	a0,0x80006
800036aa:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800036ae:	06100693          	li	a3,97
800036b2:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800036b6:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800036ba:	fccfe0ef          	jal	ra,80001e86 <printk>
800036be:	80006537          	lui	a0,0x80006
800036c2:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800036c6:	fc0fe0ef          	jal	ra,80001e86 <printk>
800036ca:	06100593          	li	a1,97
800036ce:	ac448513          	addi	a0,s1,-1340
800036d2:	fd2fe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800036d6:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
800036da:	00042423          	sw	zero,8(s0)
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800036de:	01840513          	addi	a0,s0,24
800036e2:	513000ef          	jal	ra,800043f4 <z_abort_timeout>
}
800036e6:	8522                	mv	a0,s0
800036e8:	40f2                	lw	ra,28(sp)
800036ea:	4462                	lw	s0,24(sp)
800036ec:	44d2                	lw	s1,20(sp)
800036ee:	4942                	lw	s2,16(sp)
800036f0:	49b2                	lw	s3,12(sp)
800036f2:	6105                	addi	sp,sp,32
800036f4:	8082                	ret

800036f6 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
800036f6:	800067b7          	lui	a5,0x80006
800036fa:	45c78793          	addi	a5,a5,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
800036fe:	02478713          	addi	a4,a5,36
80003702:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003704:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003706:	4581                	li	a1,0
80003708:	4501                	li	a0,0
8000370a:	942ff06f          	j	8000284c <k_sched_time_slice_set>

8000370e <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
8000370e:	1101                	addi	sp,sp,-32
80003710:	cc22                	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80003712:	80006437          	lui	s0,0x80006
80003716:	45c42783          	lw	a5,1116(s0) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
{
8000371a:	ce06                	sw	ra,28(sp)
8000371c:	ca26                	sw	s1,20(sp)
8000371e:	c84a                	sw	s2,16(sp)
80003720:	c64e                	sw	s3,12(sp)
80003722:	c452                	sw	s4,8(sp)
80003724:	c256                	sw	s5,4(sp)
80003726:	45c40413          	addi	s0,s0,1116
	__ASSERT(!z_is_in_isr(), "");
8000372a:	cf8d                	beqz	a5,80003764 <z_impl_k_yield+0x56>
8000372c:	800064b7          	lui	s1,0x80006
80003730:	800065b7          	lui	a1,0x80006
80003734:	80006537          	lui	a0,0x80006
80003738:	cd458593          	addi	a1,a1,-812 # 80005cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd5>
8000373c:	37e00693          	li	a3,894
80003740:	d4048613          	addi	a2,s1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003744:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003748:	f3efe0ef          	jal	ra,80001e86 <printk>
8000374c:	80006537          	lui	a0,0x80006
80003750:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80003754:	f32fe0ef          	jal	ra,80001e86 <printk>
80003758:	37e00593          	li	a1,894
8000375c:	d4048513          	addi	a0,s1,-704
80003760:	f44fe0ef          	jal	ra,80001ea4 <assert_post_action>
	return thread == _idle_thread;
80003764:	800067b7          	lui	a5,0x80006

	if (!is_idle(_current)) {
80003768:	4414                	lw	a3,8(s0)
8000376a:	0dc7a703          	lw	a4,220(a5) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
8000376e:	8a3e                	mv	s4,a5
80003770:	10e68763          	beq	a3,a4,8000387e <z_impl_k_yield+0x170>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003774:	4921                	li	s2,8
80003776:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000377a:	800069b7          	lui	s3,0x80006
8000377e:	25898513          	addi	a0,s3,600 # 80006258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006259>
	key = (mstatus & SOC_MSTATUS_IEN);
80003782:	00897913          	andi	s2,s2,8
80003786:	6d2000ef          	jal	ra,80003e58 <z_spin_lock_valid>
8000378a:	ed0d                	bnez	a0,800037c4 <z_impl_k_yield+0xb6>
8000378c:	800064b7          	lui	s1,0x80006
80003790:	800065b7          	lui	a1,0x80006
80003794:	80006537          	lui	a0,0x80006
80003798:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
8000379c:	04e00693          	li	a3,78
800037a0:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800037a4:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800037a8:	edefe0ef          	jal	ra,80001e86 <printk>
800037ac:	80006537          	lui	a0,0x80006
800037b0:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
800037b4:	ed2fe0ef          	jal	ra,80001e86 <printk>
800037b8:	04e00593          	li	a1,78
800037bc:	ac448513          	addi	a0,s1,-1340
800037c0:	ee4fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800037c4:	25898513          	addi	a0,s3,600
800037c8:	6cc000ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
800037cc:	440c                	lw	a1,8(s0)
800037ce:	02440513          	addi	a0,s0,36
800037d2:	d0cff0ef          	jal	ra,80002cde <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
800037d6:	0dca2783          	lw	a5,220(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
800037da:	4404                	lw	s1,8(s0)
	return thread == _idle_thread;
800037dc:	80006a37          	lui	s4,0x80006
800037e0:	480a0a13          	addi	s4,s4,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
	__ASSERT_NO_MSG(!is_idle(thread));
800037e4:	02f49863          	bne	s1,a5,80003814 <z_impl_k_yield+0x106>
800037e8:	80006ab7          	lui	s5,0x80006
800037ec:	800065b7          	lui	a1,0x80006
800037f0:	80006537          	lui	a0,0x80006
800037f4:	dd858593          	addi	a1,a1,-552 # 80005dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd9>
800037f8:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800037fc:	27600693          	li	a3,630
80003800:	d40a8613          	addi	a2,s5,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003804:	e82fe0ef          	jal	ra,80001e86 <printk>
80003808:	27600593          	li	a1,630
8000380c:	d40a8513          	addi	a0,s5,-704
80003810:	e94fe0ef          	jal	ra,80001ea4 <assert_post_action>
	return list->head == list;
80003814:	505c                	lw	a5,36(s0)
80003816:	5418                	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003818:	09478563          	beq	a5,s4,800038a2 <z_impl_k_yield+0x194>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000381c:	c3d9                	beqz	a5,800038a2 <z_impl_k_yield+0x194>
	if (t1->base.prio < t2->base.prio) {
8000381e:	00e48683          	lb	a3,14(s1)
80003822:	00e78603          	lb	a2,14(a5)
80003826:	06c6da63          	bge	a3,a2,8000389a <z_impl_k_yield+0x18c>
	node->prev = successor->prev;
8000382a:	43d8                	lw	a4,4(a5)
	node->next = successor;
8000382c:	c09c                	sw	a5,0(s1)
	node->prev = successor->prev;
8000382e:	c0d8                	sw	a4,4(s1)
	successor->prev->next = node;
80003830:	c304                	sw	s1,0(a4)
	successor->prev = node;
80003832:	c3c4                	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80003834:	4505                	li	a0,1
80003836:	d10ff0ef          	jal	ra,80002d46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000383a:	25898513          	addi	a0,s3,600
8000383e:	2d15                	jal	80003e72 <z_spin_unlock_valid>
80003840:	ed0d                	bnez	a0,8000387a <z_impl_k_yield+0x16c>
80003842:	80006437          	lui	s0,0x80006
80003846:	800065b7          	lui	a1,0x80006
8000384a:	80006537          	lui	a0,0x80006
8000384e:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80003852:	06100693          	li	a3,97
80003856:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000385a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000385e:	e28fe0ef          	jal	ra,80001e86 <printk>
80003862:	80006537          	lui	a0,0x80006
80003866:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
8000386a:	e1cfe0ef          	jal	ra,80001e86 <printk>
8000386e:	06100593          	li	a1,97
80003872:	ac440513          	addi	a0,s0,-1340
80003876:	e2efe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000387a:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000387e:	4521                	li	a0,8
80003880:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
80003884:	4462                	lw	s0,24(sp)
80003886:	40f2                	lw	ra,28(sp)
80003888:	44d2                	lw	s1,20(sp)
8000388a:	4942                	lw	s2,16(sp)
8000388c:	49b2                	lw	s3,12(sp)
8000388e:	4a22                	lw	s4,8(sp)
80003890:	4a92                	lw	s5,4(sp)
80003892:	8921                	andi	a0,a0,8
80003894:	6105                	addi	sp,sp,32
80003896:	92bfc06f          	j	800001c0 <__swap>
	return (node == list->tail) ? NULL : node->next;
8000389a:	00e78463          	beq	a5,a4,800038a2 <z_impl_k_yield+0x194>
8000389e:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800038a0:	f3c9                	bnez	a5,80003822 <z_impl_k_yield+0x114>
	node->prev = list->tail;
800038a2:	c0d8                	sw	a4,4(s1)
	list->tail->next = node;
800038a4:	541c                	lw	a5,40(s0)
	node->next = list;
800038a6:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
800038aa:	c384                	sw	s1,0(a5)
	list->tail = node;
800038ac:	d404                	sw	s1,40(s0)
800038ae:	b759                	j	80003834 <z_impl_k_yield+0x126>

800038b0 <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
800038b0:	7179                	addi	sp,sp,-48
800038b2:	d422                	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
800038b4:	80006437          	lui	s0,0x80006
800038b8:	45c42783          	lw	a5,1116(s0) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
{
800038bc:	d226                	sw	s1,36(sp)
800038be:	d606                	sw	ra,44(sp)
800038c0:	d04a                	sw	s2,32(sp)
800038c2:	ce4e                	sw	s3,28(sp)
800038c4:	cc52                	sw	s4,24(sp)
800038c6:	84aa                	mv	s1,a0
800038c8:	45c40413          	addi	s0,s0,1116
	__ASSERT(!z_is_in_isr(), "");
800038cc:	cf8d                	beqz	a5,80003906 <z_impl_k_sleep+0x56>
800038ce:	80006937          	lui	s2,0x80006
800038d2:	800065b7          	lui	a1,0x80006
800038d6:	80006537          	lui	a0,0x80006
800038da:	cd458593          	addi	a1,a1,-812 # 80005cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd5>
800038de:	39900693          	li	a3,921
800038e2:	d4090613          	addi	a2,s2,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800038e6:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800038ea:	d9cfe0ef          	jal	ra,80001e86 <printk>
800038ee:	80006537          	lui	a0,0x80006
800038f2:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
800038f6:	d90fe0ef          	jal	ra,80001e86 <printk>
800038fa:	39900593          	li	a1,921
800038fe:	d4090513          	addi	a0,s2,-704
80003902:	da2fe0ef          	jal	ra,80001ea4 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80003906:	57fd                	li	a5,-1
80003908:	16f49a63          	bne	s1,a5,80003a7c <z_impl_k_sleep+0x1cc>
8000390c:	80006937          	lui	s2,0x80006
80003910:	800065b7          	lui	a1,0x80006
80003914:	80006537          	lui	a0,0x80006
80003918:	d8c58593          	addi	a1,a1,-628 # 80005d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d8d>
8000391c:	39a00693          	li	a3,922
80003920:	d4090613          	addi	a2,s2,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003924:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003928:	d5efe0ef          	jal	ra,80001e86 <printk>
8000392c:	80006537          	lui	a0,0x80006
80003930:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80003934:	d52fe0ef          	jal	ra,80001e86 <printk>
80003938:	39a00593          	li	a1,922
8000393c:	d4090513          	addi	a0,s2,-704
80003940:	d64fe0ef          	jal	ra,80001ea4 <assert_post_action>
80003944:	45a9                	li	a1,10
80003946:	00948513          	addi	a0,s1,9
8000394a:	f87fc0ef          	jal	ra,800008d0 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
8000394e:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80003952:	0b0010ef          	jal	ra,80004a02 <z_tick_get_32>
80003956:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
8000395a:	c602                	sw	zero,12(sp)
8000395c:	44a1                	li	s1,8
8000395e:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003962:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003964:	88a1                	andi	s1,s1,8
80003966:	29cd                	jal	80003e58 <z_spin_lock_valid>
80003968:	ed0d                	bnez	a0,800039a2 <z_impl_k_sleep+0xf2>
8000396a:	80006a37          	lui	s4,0x80006
8000396e:	800065b7          	lui	a1,0x80006
80003972:	80006537          	lui	a0,0x80006
80003976:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
8000397a:	04e00693          	li	a3,78
8000397e:	ac4a0613          	addi	a2,s4,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003982:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003986:	d00fe0ef          	jal	ra,80001e86 <printk>
8000398a:	80006537          	lui	a0,0x80006
8000398e:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80003992:	cf4fe0ef          	jal	ra,80001e86 <printk>
80003996:	04e00593          	li	a1,78
8000399a:	ac4a0513          	addi	a0,s4,-1340
8000399e:	d06fe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800039a2:	0068                	addi	a0,sp,12
800039a4:	29c5                	jal	80003e94 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
800039a6:	4408                	lw	a0,8(s0)
800039a8:	99fff0ef          	jal	ra,80003346 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800039ac:	4408                	lw	a0,8(s0)
800039ae:	800035b7          	lui	a1,0x80003
800039b2:	864e                	mv	a2,s3
800039b4:	0561                	addi	a0,a0,24
800039b6:	07a58593          	addi	a1,a1,122 # 8000307a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000307b>
800039ba:	073000ef          	jal	ra,8000422c <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
800039be:	4418                	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800039c0:	0068                	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
800039c2:	00d74783          	lbu	a5,13(a4)
800039c6:	0107e793          	ori	a5,a5,16
800039ca:	00f706a3          	sb	a5,13(a4)
800039ce:	2155                	jal	80003e72 <z_spin_unlock_valid>
800039d0:	ed0d                	bnez	a0,80003a0a <z_impl_k_sleep+0x15a>
800039d2:	800069b7          	lui	s3,0x80006
800039d6:	800065b7          	lui	a1,0x80006
800039da:	80006537          	lui	a0,0x80006
800039de:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800039e2:	07800693          	li	a3,120
800039e6:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800039ea:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800039ee:	c98fe0ef          	jal	ra,80001e86 <printk>
800039f2:	80006537          	lui	a0,0x80006
800039f6:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800039fa:	c8cfe0ef          	jal	ra,80001e86 <printk>
800039fe:	07800593          	li	a1,120
80003a02:	ac498513          	addi	a0,s3,-1340
80003a06:	c9efe0ef          	jal	ra,80001ea4 <assert_post_action>
80003a0a:	8526                	mv	a0,s1
80003a0c:	fb4fc0ef          	jal	ra,800001c0 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80003a10:	441c                	lw	a5,8(s0)
80003a12:	00d7c783          	lbu	a5,13(a5)
80003a16:	8bc1                	andi	a5,a5,16
80003a18:	cf8d                	beqz	a5,80003a52 <z_impl_k_sleep+0x1a2>
80003a1a:	80006437          	lui	s0,0x80006
80003a1e:	800065b7          	lui	a1,0x80006
80003a22:	80006537          	lui	a0,0x80006
80003a26:	da058593          	addi	a1,a1,-608 # 80005da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da1>
80003a2a:	3b700693          	li	a3,951
80003a2e:	d4040613          	addi	a2,s0,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003a32:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003a36:	c50fe0ef          	jal	ra,80001e86 <printk>
80003a3a:	80006537          	lui	a0,0x80006
80003a3e:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80003a42:	c44fe0ef          	jal	ra,80001e86 <printk>
80003a46:	3b700593          	li	a1,951
80003a4a:	d4040513          	addi	a0,s0,-704
80003a4e:	c56fe0ef          	jal	ra,80001ea4 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
80003a52:	7b1000ef          	jal	ra,80004a02 <z_tick_get_32>
80003a56:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80003a5a:	4481                	li	s1,0
	if (ticks > 0) {
80003a5c:	02a05463          	blez	a0,80003a84 <z_impl_k_sleep+0x1d4>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80003a60:	3e800613          	li	a2,1000
80003a64:	4681                	li	a3,0
80003a66:	41f55593          	srai	a1,a0,0x1f
80003a6a:	dd7fc0ef          	jal	ra,80000840 <__muldi3>
80003a6e:	06400613          	li	a2,100
80003a72:	4681                	li	a3,0
80003a74:	fd4fc0ef          	jal	ra,80000248 <__udivdi3>
80003a78:	84aa                	mv	s1,a0
		return __ticks_to_ms(ticks);
80003a7a:	a029                	j	80003a84 <z_impl_k_sleep+0x1d4>
	if (duration == 0) {
80003a7c:	ec0494e3          	bnez	s1,80003944 <z_impl_k_sleep+0x94>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80003a80:	c8fff0ef          	jal	ra,8000370e <z_impl_k_yield>
}
80003a84:	50b2                	lw	ra,44(sp)
80003a86:	5422                	lw	s0,40(sp)
80003a88:	8526                	mv	a0,s1
80003a8a:	5902                	lw	s2,32(sp)
80003a8c:	5492                	lw	s1,36(sp)
80003a8e:	49f2                	lw	s3,28(sp)
80003a90:	4a62                	lw	s4,24(sp)
80003a92:	6145                	addi	sp,sp,48
80003a94:	8082                	ret

80003a96 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80003a96:	800067b7          	lui	a5,0x80006
80003a9a:	4647a503          	lw	a0,1124(a5) # 80006464 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006465>
80003a9e:	8082                	ret

80003aa0 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80003aa0:	1101                	addi	sp,sp,-32
80003aa2:	cc22                	sw	s0,24(sp)
80003aa4:	ca26                	sw	s1,20(sp)
80003aa6:	c84a                	sw	s2,16(sp)
80003aa8:	ce06                	sw	ra,28(sp)
80003aaa:	c64e                	sw	s3,12(sp)
80003aac:	842a                	mv	s0,a0
80003aae:	892e                	mv	s2,a1
80003ab0:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80003ab2:	ee0d                	bnez	a2,80003aec <z_impl_k_sem_init+0x4c>
80003ab4:	800069b7          	lui	s3,0x80006
80003ab8:	800065b7          	lui	a1,0x80006
80003abc:	80006537          	lui	a0,0x80006
80003ac0:	dfc58593          	addi	a1,a1,-516 # 80005dfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dfd>
80003ac4:	04600693          	li	a3,70
80003ac8:	dec98613          	addi	a2,s3,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80003acc:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003ad0:	bb6fe0ef          	jal	ra,80001e86 <printk>
80003ad4:	80006537          	lui	a0,0x80006
80003ad8:	e0850513          	addi	a0,a0,-504 # 80005e08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e09>
80003adc:	baafe0ef          	jal	ra,80001e86 <printk>
80003ae0:	04600593          	li	a1,70
80003ae4:	dec98513          	addi	a0,s3,-532
80003ae8:	bbcfe0ef          	jal	ra,80001ea4 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003aec:	0324fe63          	bgeu	s1,s2,80003b28 <z_impl_k_sem_init+0x88>
80003af0:	800069b7          	lui	s3,0x80006
80003af4:	800065b7          	lui	a1,0x80006
80003af8:	80006537          	lui	a0,0x80006
80003afc:	e2058593          	addi	a1,a1,-480 # 80005e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e21>
80003b00:	04700693          	li	a3,71
80003b04:	dec98613          	addi	a2,s3,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80003b08:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003b0c:	b7afe0ef          	jal	ra,80001e86 <printk>
80003b10:	80006537          	lui	a0,0x80006
80003b14:	e3850513          	addi	a0,a0,-456 # 80005e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e39>
80003b18:	b6efe0ef          	jal	ra,80001e86 <printk>
80003b1c:	04700593          	li	a1,71
80003b20:	dec98513          	addi	a0,s3,-532
80003b24:	b80fe0ef          	jal	ra,80001ea4 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80003b28:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80003b2c:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80003b2e:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80003b30:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80003b32:	40f2                	lw	ra,28(sp)
80003b34:	4462                	lw	s0,24(sp)
80003b36:	44d2                	lw	s1,20(sp)
80003b38:	4942                	lw	s2,16(sp)
80003b3a:	49b2                	lw	s3,12(sp)
80003b3c:	6105                	addi	sp,sp,32
80003b3e:	8082                	ret

80003b40 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80003b40:	1101                	addi	sp,sp,-32
80003b42:	ca26                	sw	s1,20(sp)
80003b44:	c64e                	sw	s3,12(sp)
80003b46:	ce06                	sw	ra,28(sp)
80003b48:	cc22                	sw	s0,24(sp)
80003b4a:	c84a                	sw	s2,16(sp)
80003b4c:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003b4e:	44a1                	li	s1,8
80003b50:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003b54:	80006437          	lui	s0,0x80006
80003b58:	26440513          	addi	a0,s0,612 # 80006264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006265>
	key = (mstatus & SOC_MSTATUS_IEN);
80003b5c:	88a1                	andi	s1,s1,8
80003b5e:	2ced                	jal	80003e58 <z_spin_lock_valid>
80003b60:	ed0d                	bnez	a0,80003b9a <z_impl_k_sem_give+0x5a>
80003b62:	80006937          	lui	s2,0x80006
80003b66:	800065b7          	lui	a1,0x80006
80003b6a:	80006537          	lui	a0,0x80006
80003b6e:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80003b72:	04e00693          	li	a3,78
80003b76:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003b7a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003b7e:	b08fe0ef          	jal	ra,80001e86 <printk>
80003b82:	80006537          	lui	a0,0x80006
80003b86:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80003b8a:	afcfe0ef          	jal	ra,80001e86 <printk>
80003b8e:	04e00593          	li	a1,78
80003b92:	ac490513          	addi	a0,s2,-1340
80003b96:	b0efe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b9a:	26440513          	addi	a0,s0,612
80003b9e:	2cdd                	jal	80003e94 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80003ba0:	854e                	mv	a0,s3
80003ba2:	9d1ff0ef          	jal	ra,80003572 <z_unpend_first_thread>
80003ba6:	892a                	mv	s2,a0
	if (thread != NULL) {
80003ba8:	c515                	beqz	a0,80003bd4 <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003baa:	00d54783          	lbu	a5,13(a0)
80003bae:	8bfd                	andi	a5,a5,31
80003bb0:	e789                	bnez	a5,80003bba <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
80003bb2:	4d1c                	lw	a5,24(a0)
80003bb4:	e399                	bnez	a5,80003bba <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
80003bb6:	b7aff0ef          	jal	ra,80002f30 <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80003bba:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003bbe:	26440513          	addi	a0,s0,612
}
80003bc2:	4462                	lw	s0,24(sp)
80003bc4:	40f2                	lw	ra,28(sp)
80003bc6:	4942                	lw	s2,16(sp)
80003bc8:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003bca:	85a6                	mv	a1,s1
}
80003bcc:	44d2                	lw	s1,20(sp)
80003bce:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003bd0:	eeffe06f          	j	80002abe <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80003bd4:	0089a703          	lw	a4,8(s3)
80003bd8:	00c9a783          	lw	a5,12(s3)
80003bdc:	8f99                	sub	a5,a5,a4
80003bde:	00f037b3          	snez	a5,a5
80003be2:	97ba                	add	a5,a5,a4
80003be4:	00f9a423          	sw	a5,8(s3)
80003be8:	bfd9                	j	80003bbe <z_impl_k_sem_give+0x7e>

80003bea <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003bea:	800067b7          	lui	a5,0x80006
80003bee:	45c7a783          	lw	a5,1116(a5) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
{
80003bf2:	1101                	addi	sp,sp,-32
80003bf4:	c84a                	sw	s2,16(sp)
80003bf6:	c64e                	sw	s3,12(sp)
80003bf8:	ce06                	sw	ra,28(sp)
80003bfa:	cc22                	sw	s0,24(sp)
80003bfc:	ca26                	sw	s1,20(sp)
80003bfe:	c452                	sw	s4,8(sp)
80003c00:	892a                	mv	s2,a0
80003c02:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003c04:	cf95                	beqz	a5,80003c40 <z_impl_k_sem_take+0x56>
80003c06:	cd8d                	beqz	a1,80003c40 <z_impl_k_sem_take+0x56>
80003c08:	80006437          	lui	s0,0x80006
80003c0c:	800065b7          	lui	a1,0x80006
80003c10:	80006537          	lui	a0,0x80006
80003c14:	e6058593          	addi	a1,a1,-416 # 80005e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e61>
80003c18:	08c00693          	li	a3,140
80003c1c:	dec40613          	addi	a2,s0,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80003c20:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003c24:	a62fe0ef          	jal	ra,80001e86 <printk>
80003c28:	80006537          	lui	a0,0x80006
80003c2c:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80003c30:	a56fe0ef          	jal	ra,80001e86 <printk>
80003c34:	08c00593          	li	a1,140
80003c38:	dec40513          	addi	a0,s0,-532
80003c3c:	a68fe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c40:	4421                	li	s0,8
80003c42:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c46:	800064b7          	lui	s1,0x80006
80003c4a:	26448513          	addi	a0,s1,612 # 80006264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006265>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c4e:	8821                	andi	s0,s0,8
80003c50:	2421                	jal	80003e58 <z_spin_lock_valid>
80003c52:	ed0d                	bnez	a0,80003c8c <z_impl_k_sem_take+0xa2>
80003c54:	80006a37          	lui	s4,0x80006
80003c58:	800065b7          	lui	a1,0x80006
80003c5c:	80006537          	lui	a0,0x80006
80003c60:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80003c64:	04e00693          	li	a3,78
80003c68:	ac4a0613          	addi	a2,s4,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003c6c:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003c70:	a16fe0ef          	jal	ra,80001e86 <printk>
80003c74:	80006537          	lui	a0,0x80006
80003c78:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80003c7c:	a0afe0ef          	jal	ra,80001e86 <printk>
80003c80:	04e00593          	li	a1,78
80003c84:	ac4a0513          	addi	a0,s4,-1340
80003c88:	a1cfe0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c8c:	26448513          	addi	a0,s1,612
80003c90:	2411                	jal	80003e94 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80003c92:	00892783          	lw	a5,8(s2)
80003c96:	cfb9                	beqz	a5,80003cf4 <z_impl_k_sem_take+0x10a>
		sem->count--;
80003c98:	17fd                	addi	a5,a5,-1
80003c9a:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c9e:	26448513          	addi	a0,s1,612
80003ca2:	2ac1                	jal	80003e72 <z_spin_unlock_valid>
80003ca4:	ed0d                	bnez	a0,80003cde <z_impl_k_sem_take+0xf4>
80003ca6:	800064b7          	lui	s1,0x80006
80003caa:	800065b7          	lui	a1,0x80006
80003cae:	80006537          	lui	a0,0x80006
80003cb2:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80003cb6:	06100693          	li	a3,97
80003cba:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003cbe:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003cc2:	9c4fe0ef          	jal	ra,80001e86 <printk>
80003cc6:	80006537          	lui	a0,0x80006
80003cca:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003cce:	9b8fe0ef          	jal	ra,80001e86 <printk>
80003cd2:	06100593          	li	a1,97
80003cd6:	ac448513          	addi	a0,s1,-1340
80003cda:	9cafe0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003cde:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80003ce2:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80003ce4:	40f2                	lw	ra,28(sp)
80003ce6:	4462                	lw	s0,24(sp)
80003ce8:	44d2                	lw	s1,20(sp)
80003cea:	4942                	lw	s2,16(sp)
80003cec:	49b2                	lw	s3,12(sp)
80003cee:	4a22                	lw	s4,8(sp)
80003cf0:	6105                	addi	sp,sp,32
80003cf2:	8082                	ret
	if (timeout == K_NO_WAIT) {
80003cf4:	04099663          	bnez	s3,80003d40 <z_impl_k_sem_take+0x156>
80003cf8:	26448513          	addi	a0,s1,612
80003cfc:	2a9d                	jal	80003e72 <z_spin_unlock_valid>
80003cfe:	ed0d                	bnez	a0,80003d38 <z_impl_k_sem_take+0x14e>
80003d00:	800064b7          	lui	s1,0x80006
80003d04:	800065b7          	lui	a1,0x80006
80003d08:	80006537          	lui	a0,0x80006
80003d0c:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80003d10:	06100693          	li	a3,97
80003d14:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003d18:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003d1c:	96afe0ef          	jal	ra,80001e86 <printk>
80003d20:	80006537          	lui	a0,0x80006
80003d24:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003d28:	95efe0ef          	jal	ra,80001e86 <printk>
80003d2c:	06100593          	li	a1,97
80003d30:	ac448513          	addi	a0,s1,-1340
80003d34:	970fe0ef          	jal	ra,80001ea4 <assert_post_action>
80003d38:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80003d3c:	5541                	li	a0,-16
80003d3e:	b75d                	j	80003ce4 <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80003d40:	85a2                	mv	a1,s0
}
80003d42:	4462                	lw	s0,24(sp)
80003d44:	40f2                	lw	ra,28(sp)
80003d46:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80003d48:	86ce                	mv	a3,s3
80003d4a:	864a                	mv	a2,s2
}
80003d4c:	49b2                	lw	s3,12(sp)
80003d4e:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80003d50:	26448513          	addi	a0,s1,612
}
80003d54:	44d2                	lw	s1,20(sp)
80003d56:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80003d58:	fb0ff06f          	j	80003508 <z_pend_curr>

80003d5c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003d5c:	00d54783          	lbu	a5,13(a0)
80003d60:	8bfd                	andi	a5,a5,31
80003d62:	e789                	bnez	a5,80003d6c <z_is_thread_ready+0x10>
80003d64:	4d08                	lw	a0,24(a0)
80003d66:	00153513          	seqz	a0,a0
80003d6a:	8082                	ret
80003d6c:	4501                	li	a0,0
}
80003d6e:	8082                	ret

80003d70 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80003d70:	800067b7          	lui	a5,0x80006
80003d74:	45c7a503          	lw	a0,1116(a5) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
}
80003d78:	00a03533          	snez	a0,a0
80003d7c:	8082                	ret

80003d7e <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80003d7e:	800067b7          	lui	a5,0x80006
80003d82:	4647a783          	lw	a5,1124(a5) # 80006464 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006465>
80003d86:	00c7c503          	lbu	a0,12(a5)
}
80003d8a:	8905                	andi	a0,a0,1
80003d8c:	8082                	ret

80003d8e <z_impl_k_busy_wait>:
void z_impl_k_busy_wait(u32_t usec_to_wait)
{
#if !defined(CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT)
	/* use 64-bit math to prevent overflow when multiplying */
	u32_t cycles_to_wait = (u32_t)(
		(u64_t)usec_to_wait *
80003d8e:	00b72637          	lui	a2,0xb72
{
80003d92:	1141                	addi	sp,sp,-16
		(u64_t)usec_to_wait *
80003d94:	b0060613          	addi	a2,a2,-1280 # b71b00 <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC>
80003d98:	4681                	li	a3,0
80003d9a:	4581                	li	a1,0
{
80003d9c:	c606                	sw	ra,12(sp)
80003d9e:	c422                	sw	s0,8(sp)
80003da0:	c226                	sw	s1,4(sp)
		(u64_t)usec_to_wait *
80003da2:	a9ffc0ef          	jal	ra,80000840 <__muldi3>
		(u64_t)sys_clock_hw_cycles_per_sec() /
80003da6:	000f4637          	lui	a2,0xf4
80003daa:	24060613          	addi	a2,a2,576 # f4240 <CONFIG_RISCV_RAM_SIZE+0xb4240>
80003dae:	4681                	li	a3,0
80003db0:	c98fc0ef          	jal	ra,80000248 <__udivdi3>
80003db4:	842a                	mv	s0,a0
		(u64_t)USEC_PER_SEC
	);
	u32_t start_cycles = k_cycle_get_32();
80003db6:	d14fe0ef          	jal	ra,800022ca <z_timer_cycle_get_32>
80003dba:	84aa                	mv	s1,a0

	for (;;) {
		u32_t current_cycles = k_cycle_get_32();
80003dbc:	d0efe0ef          	jal	ra,800022ca <z_timer_cycle_get_32>

		/* this handles the rollover on an unsigned 32-bit value */
		if ((current_cycles - start_cycles) >= cycles_to_wait) {
80003dc0:	8d05                	sub	a0,a0,s1
80003dc2:	fe856de3          	bltu	a0,s0,80003dbc <z_impl_k_busy_wait+0x2e>
		}
	}
#else
	z_arch_busy_wait(usec_to_wait);
#endif /* CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT */
}
80003dc6:	40b2                	lw	ra,12(sp)
80003dc8:	4422                	lw	s0,8(sp)
80003dca:	4492                	lw	s1,4(sp)
80003dcc:	0141                	addi	sp,sp,16
80003dce:	8082                	ret

80003dd0 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80003dd0:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003dd2:	5302                	lw	t1,32(sp)
{
80003dd4:	cc22                	sw	s0,24(sp)
80003dd6:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003dd8:	c01a                	sw	t1,0(sp)
{
80003dda:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003ddc:	a7dfd0ef          	jal	ra,80001858 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80003de0:	800067b7          	lui	a5,0x80006
80003de4:	4647a783          	lw	a5,1124(a5) # 80006464 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006465>
	sys_trace_thread_create(new_thread);
}
80003de8:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80003dea:	57bc                	lw	a5,104(a5)
80003dec:	d43c                	sw	a5,104(s0)
}
80003dee:	4462                	lw	s0,24(sp)
80003df0:	6105                	addi	sp,sp,32
80003df2:	8082                	ret

80003df4 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80003df4:	513c                	lw	a5,96(a0)
{
80003df6:	1141                	addi	sp,sp,-16
80003df8:	c422                	sw	s0,8(sp)
80003dfa:	c606                	sw	ra,12(sp)
80003dfc:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
80003dfe:	c391                	beqz	a5,80003e02 <z_thread_single_abort+0xe>
		thread->fn_abort();
80003e00:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80003e02:	8522                	mv	a0,s0
80003e04:	f59ff0ef          	jal	ra,80003d5c <z_is_thread_ready>
80003e08:	cd11                	beqz	a0,80003e24 <z_thread_single_abort+0x30>
		z_remove_thread_from_ready_q(thread);
80003e0a:	8522                	mv	a0,s0
80003e0c:	d3aff0ef          	jal	ra,80003346 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80003e10:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80003e14:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80003e16:	0087e793          	ori	a5,a5,8
80003e1a:	00f406a3          	sb	a5,13(s0)
}
80003e1e:	4422                	lw	s0,8(sp)
80003e20:	0141                	addi	sp,sp,16
80003e22:	8082                	ret
		if (z_is_thread_pending(thread)) {
80003e24:	00d44783          	lbu	a5,13(s0)
80003e28:	8b89                	andi	a5,a5,2
80003e2a:	c781                	beqz	a5,80003e32 <z_thread_single_abort+0x3e>
			z_unpend_thread_no_timeout(thread);
80003e2c:	8522                	mv	a0,s0
80003e2e:	bc1fe0ef          	jal	ra,800029ee <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80003e32:	4c1c                	lw	a5,24(s0)
80003e34:	dff1                	beqz	a5,80003e10 <z_thread_single_abort+0x1c>
	return z_abort_timeout(&thread->base.timeout);
80003e36:	01840513          	addi	a0,s0,24
80003e3a:	2b6d                	jal	800043f4 <z_abort_timeout>
80003e3c:	bfd1                	j	80003e10 <z_thread_single_abort+0x1c>

80003e3e <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80003e3e:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80003e42:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80003e46:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80003e4a:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80003e4e:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80003e52:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80003e56:	8082                	ret

80003e58 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80003e58:	4108                	lw	a0,0(a0)
80003e5a:	c911                	beqz	a0,80003e6e <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80003e5c:	800067b7          	lui	a5,0x80006
80003e60:	4707c783          	lbu	a5,1136(a5) # 80006470 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006471>
80003e64:	890d                	andi	a0,a0,3
80003e66:	8d1d                	sub	a0,a0,a5
80003e68:	00a03533          	snez	a0,a0
80003e6c:	8082                	ret
			return false;
		}
	}
	return true;
80003e6e:	4505                	li	a0,1
}
80003e70:	8082                	ret

80003e72 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80003e72:	800067b7          	lui	a5,0x80006
80003e76:	45c78793          	addi	a5,a5,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80003e7a:	0147c703          	lbu	a4,20(a5)
80003e7e:	479c                	lw	a5,8(a5)
80003e80:	8fd9                	or	a5,a5,a4
80003e82:	4118                	lw	a4,0(a0)
80003e84:	00f71663          	bne	a4,a5,80003e90 <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
80003e88:	00052023          	sw	zero,0(a0)
	return true;
80003e8c:	4505                	li	a0,1
80003e8e:	8082                	ret
		return false;
80003e90:	4501                	li	a0,0
}
80003e92:	8082                	ret

80003e94 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80003e94:	800067b7          	lui	a5,0x80006
80003e98:	45c78793          	addi	a5,a5,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80003e9c:	0147c703          	lbu	a4,20(a5)
80003ea0:	479c                	lw	a5,8(a5)
80003ea2:	8fd9                	or	a5,a5,a4
80003ea4:	c11c                	sw	a5,0(a0)
}
80003ea6:	8082                	ret

80003ea8 <z_impl_k_thread_start>:
{
80003ea8:	1101                	addi	sp,sp,-32
80003eaa:	cc22                	sw	s0,24(sp)
80003eac:	c84a                	sw	s2,16(sp)
80003eae:	ce06                	sw	ra,28(sp)
80003eb0:	ca26                	sw	s1,20(sp)
80003eb2:	c64e                	sw	s3,12(sp)
80003eb4:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003eb6:	4421                	li	s0,8
80003eb8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ebc:	800064b7          	lui	s1,0x80006
80003ec0:	26848513          	addi	a0,s1,616 # 80006268 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006269>
	key = (mstatus & SOC_MSTATUS_IEN);
80003ec4:	8821                	andi	s0,s0,8
80003ec6:	f93ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
80003eca:	ed0d                	bnez	a0,80003f04 <z_impl_k_thread_start+0x5c>
80003ecc:	800069b7          	lui	s3,0x80006
80003ed0:	800065b7          	lui	a1,0x80006
80003ed4:	80006537          	lui	a0,0x80006
80003ed8:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80003edc:	04e00693          	li	a3,78
80003ee0:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003ee4:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003ee8:	f9ffd0ef          	jal	ra,80001e86 <printk>
80003eec:	80006537          	lui	a0,0x80006
80003ef0:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80003ef4:	f93fd0ef          	jal	ra,80001e86 <printk>
80003ef8:	04e00593          	li	a1,78
80003efc:	ac498513          	addi	a0,s3,-1340
80003f00:	fa5fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80003f04:	26848513          	addi	a0,s1,616
80003f08:	f8dff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80003f0c:	00d94783          	lbu	a5,13(s2)
80003f10:	0047f713          	andi	a4,a5,4
80003f14:	eb39                	bnez	a4,80003f6a <z_impl_k_thread_start+0xc2>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f16:	26848513          	addi	a0,s1,616
80003f1a:	f59ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80003f1e:	ed0d                	bnez	a0,80003f58 <z_impl_k_thread_start+0xb0>
80003f20:	800064b7          	lui	s1,0x80006
80003f24:	800065b7          	lui	a1,0x80006
80003f28:	80006537          	lui	a0,0x80006
80003f2c:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80003f30:	06100693          	li	a3,97
80003f34:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80003f38:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80003f3c:	f4bfd0ef          	jal	ra,80001e86 <printk>
80003f40:	80006537          	lui	a0,0x80006
80003f44:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80003f48:	f3ffd0ef          	jal	ra,80001e86 <printk>
80003f4c:	06100593          	li	a1,97
80003f50:	ac448513          	addi	a0,s1,-1340
80003f54:	f51fd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f58:	30042473          	csrrs	s0,mstatus,s0
}
80003f5c:	40f2                	lw	ra,28(sp)
80003f5e:	4462                	lw	s0,24(sp)
80003f60:	44d2                	lw	s1,20(sp)
80003f62:	4942                	lw	s2,16(sp)
80003f64:	49b2                	lw	s3,12(sp)
80003f66:	6105                	addi	sp,sp,32
80003f68:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003f6a:	9bed                	andi	a5,a5,-5
80003f6c:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80003f70:	854a                	mv	a0,s2
80003f72:	debff0ef          	jal	ra,80003d5c <z_is_thread_ready>
80003f76:	c501                	beqz	a0,80003f7e <z_impl_k_thread_start+0xd6>
		z_add_thread_to_ready_q(thread);
80003f78:	854a                	mv	a0,s2
80003f7a:	fb7fe0ef          	jal	ra,80002f30 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80003f7e:	85a2                	mv	a1,s0
}
80003f80:	4462                	lw	s0,24(sp)
80003f82:	40f2                	lw	ra,28(sp)
80003f84:	4942                	lw	s2,16(sp)
80003f86:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003f88:	26848513          	addi	a0,s1,616
}
80003f8c:	44d2                	lw	s1,20(sp)
80003f8e:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003f90:	b2ffe06f          	j	80002abe <z_reschedule>

80003f94 <schedule_new_thread>:
	if (delay == 0) {
80003f94:	e199                	bnez	a1,80003f9a <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80003f96:	f13ff06f          	j	80003ea8 <z_impl_k_thread_start>
{
80003f9a:	1141                	addi	sp,sp,-16
80003f9c:	c422                	sw	s0,8(sp)
80003f9e:	842a                	mv	s0,a0
80003fa0:	852e                	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80003fa2:	0525                	addi	a0,a0,9
80003fa4:	45a9                	li	a1,10
80003fa6:	c606                	sw	ra,12(sp)
80003fa8:	929fc0ef          	jal	ra,800008d0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003fac:	00150613          	addi	a2,a0,1
80003fb0:	01840513          	addi	a0,s0,24
}
80003fb4:	4422                	lw	s0,8(sp)
80003fb6:	40b2                	lw	ra,12(sp)
80003fb8:	800035b7          	lui	a1,0x80003
80003fbc:	07a58593          	addi	a1,a1,122 # 8000307a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000307b>
80003fc0:	0141                	addi	sp,sp,16
80003fc2:	a4ad                	j	8000422c <z_add_timeout>

80003fc4 <z_impl_k_thread_create>:
{
80003fc4:	7139                	addi	sp,sp,-64
80003fc6:	d256                	sw	s5,36(sp)
80003fc8:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003fca:	800066b7          	lui	a3,0x80006
80003fce:	45c6a683          	lw	a3,1116(a3) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
{
80003fd2:	dc22                	sw	s0,56(sp)
80003fd4:	da26                	sw	s1,52(sp)
80003fd6:	d64e                	sw	s3,44(sp)
80003fd8:	d452                	sw	s4,40(sp)
80003fda:	de06                	sw	ra,60(sp)
80003fdc:	d84a                	sw	s2,48(sp)
80003fde:	842a                	mv	s0,a0
80003fe0:	89ae                	mv	s3,a1
80003fe2:	8a32                	mv	s4,a2
80003fe4:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003fe6:	c6a9                	beqz	a3,80004030 <z_impl_k_thread_create+0x6c>
80003fe8:	80006937          	lui	s2,0x80006
80003fec:	800065b7          	lui	a1,0x80006
80003ff0:	80006537          	lui	a0,0x80006
80003ff4:	1b200693          	li	a3,434
80003ff8:	e9490613          	addi	a2,s2,-364 # 80005e94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e95>
80003ffc:	cd458593          	addi	a1,a1,-812 # 80005cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd5>
80004000:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004004:	ce46                	sw	a7,28(sp)
80004006:	cc42                	sw	a6,24(sp)
80004008:	ca3e                	sw	a5,20(sp)
8000400a:	c83a                	sw	a4,16(sp)
8000400c:	e7bfd0ef          	jal	ra,80001e86 <printk>
80004010:	80006537          	lui	a0,0x80006
80004014:	ea850513          	addi	a0,a0,-344 # 80005ea8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ea9>
80004018:	e6ffd0ef          	jal	ra,80001e86 <printk>
8000401c:	1b200593          	li	a1,434
80004020:	e9490513          	addi	a0,s2,-364
80004024:	e81fd0ef          	jal	ra,80001ea4 <assert_post_action>
80004028:	48f2                	lw	a7,28(sp)
8000402a:	4862                	lw	a6,24(sp)
8000402c:	47d2                	lw	a5,20(sp)
8000402e:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004030:	4686                	lw	a3,64(sp)
80004032:	c202                	sw	zero,4(sp)
80004034:	8652                	mv	a2,s4
80004036:	c036                	sw	a3,0(sp)
80004038:	85ce                	mv	a1,s3
8000403a:	86d6                	mv	a3,s5
8000403c:	8522                	mv	a0,s0
8000403e:	d93ff0ef          	jal	ra,80003dd0 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004042:	57fd                	li	a5,-1
80004044:	00f48663          	beq	s1,a5,80004050 <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
80004048:	85a6                	mv	a1,s1
8000404a:	8522                	mv	a0,s0
8000404c:	f49ff0ef          	jal	ra,80003f94 <schedule_new_thread>
}
80004050:	8522                	mv	a0,s0
80004052:	50f2                	lw	ra,60(sp)
80004054:	5462                	lw	s0,56(sp)
80004056:	54d2                	lw	s1,52(sp)
80004058:	5942                	lw	s2,48(sp)
8000405a:	59b2                	lw	s3,44(sp)
8000405c:	5a22                	lw	s4,40(sp)
8000405e:	5a92                	lw	s5,36(sp)
80004060:	6121                	addi	sp,sp,64
80004062:	8082                	ret

80004064 <z_init_static_threads>:
{
80004064:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004066:	800067b7          	lui	a5,0x80006
{
8000406a:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
8000406c:	80006937          	lui	s2,0x80006
{
80004070:	cc22                	sw	s0,24(sp)
80004072:	ca26                	sw	s1,20(sp)
80004074:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004076:	11078413          	addi	s0,a5,272 # 80006110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006111>
8000407a:	11078493          	addi	s1,a5,272
8000407e:	11090913          	addi	s2,s2,272 # 80006110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006111>
80004082:	01246f63          	bltu	s0,s2,800040a0 <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
80004086:	8426                	mv	s0,s1
	k_sched_lock();
80004088:	b07fe0ef          	jal	ra,80002b8e <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
8000408c:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
8000408e:	03246e63          	bltu	s0,s2,800040ca <z_init_static_threads+0x66>
}
80004092:	4462                	lw	s0,24(sp)
80004094:	40f2                	lw	ra,28(sp)
80004096:	44d2                	lw	s1,20(sp)
80004098:	4942                	lw	s2,16(sp)
8000409a:	6105                	addi	sp,sp,32
	k_sched_unlock();
8000409c:	d41fe06f          	j	80002ddc <k_sched_unlock>
		z_setup_new_thread(
800040a0:	545c                	lw	a5,44(s0)
800040a2:	c23e                	sw	a5,4(sp)
800040a4:	501c                	lw	a5,32(s0)
800040a6:	c03e                	sw	a5,0(sp)
800040a8:	485c                	lw	a5,20(s0)
800040aa:	01c42883          	lw	a7,28(s0)
800040ae:	01842803          	lw	a6,24(s0)
800040b2:	4818                	lw	a4,16(s0)
800040b4:	4454                	lw	a3,12(s0)
800040b6:	4410                	lw	a2,8(s0)
800040b8:	404c                	lw	a1,4(s0)
800040ba:	4008                	lw	a0,0(s0)
800040bc:	d15ff0ef          	jal	ra,80003dd0 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
800040c0:	401c                	lw	a5,0(s0)
800040c2:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
800040c4:	03040413          	addi	s0,s0,48
800040c8:	bf6d                	j	80004082 <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
800040ca:	504c                	lw	a1,36(s0)
800040cc:	00958563          	beq	a1,s1,800040d6 <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
800040d0:	4008                	lw	a0,0(s0)
800040d2:	ec3ff0ef          	jal	ra,80003f94 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
800040d6:	03040413          	addi	s0,s0,48
800040da:	bf55                	j	8000408e <z_init_static_threads+0x2a>

800040dc <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
800040dc:	1101                	addi	sp,sp,-32
800040de:	cc22                	sw	s0,24(sp)
800040e0:	ca26                	sw	s1,20(sp)
800040e2:	ce06                	sw	ra,28(sp)
800040e4:	c84a                	sw	s2,16(sp)
800040e6:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
800040e8:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040ea:	4421                	li	s0,8
800040ec:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040f0:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800040f2:	8821                	andi	s0,s0,8
800040f4:	d65ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
800040f8:	ed0d                	bnez	a0,80004132 <z_impl_k_thread_abort+0x56>
800040fa:	80006937          	lui	s2,0x80006
800040fe:	800065b7          	lui	a1,0x80006
80004102:	80006537          	lui	a0,0x80006
80004106:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
8000410a:	04e00693          	li	a3,78
8000410e:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004112:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004116:	d71fd0ef          	jal	ra,80001e86 <printk>
8000411a:	80006537          	lui	a0,0x80006
8000411e:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004122:	d65fd0ef          	jal	ra,80001e86 <printk>
80004126:	04e00593          	li	a1,78
8000412a:	ac490513          	addi	a0,s2,-1340
8000412e:	d77fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004132:	0068                	addi	a0,sp,12
80004134:	d61ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004138:	00c4c783          	lbu	a5,12(s1)
8000413c:	8b85                	andi	a5,a5,1
8000413e:	cf8d                	beqz	a5,80004178 <z_impl_k_thread_abort+0x9c>
80004140:	80006937          	lui	s2,0x80006
80004144:	800065b7          	lui	a1,0x80006
80004148:	80006537          	lui	a0,0x80006
8000414c:	ee858593          	addi	a1,a1,-280 # 80005ee8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee9>
80004150:	02900693          	li	a3,41
80004154:	ed090613          	addi	a2,s2,-304 # 80005ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ed1>
80004158:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000415c:	d2bfd0ef          	jal	ra,80001e86 <printk>
80004160:	80006537          	lui	a0,0x80006
80004164:	f1c50513          	addi	a0,a0,-228 # 80005f1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f1d>
80004168:	d1ffd0ef          	jal	ra,80001e86 <printk>
8000416c:	02900593          	li	a1,41
80004170:	ed090513          	addi	a0,s2,-304
80004174:	d31fd0ef          	jal	ra,80001ea4 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004178:	8526                	mv	a0,s1
8000417a:	c7bff0ef          	jal	ra,80003df4 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
8000417e:	85a2                	mv	a1,s0
80004180:	0068                	addi	a0,sp,12
80004182:	93dfe0ef          	jal	ra,80002abe <z_reschedule>
}
80004186:	40f2                	lw	ra,28(sp)
80004188:	4462                	lw	s0,24(sp)
8000418a:	44d2                	lw	s1,20(sp)
8000418c:	4942                	lw	s2,16(sp)
8000418e:	6105                	addi	sp,sp,32
80004190:	8082                	ret

80004192 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004192:	800067b7          	lui	a5,0x80006
80004196:	26c7a783          	lw	a5,620(a5) # 8000626c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000626d>
8000419a:	e399                	bnez	a5,800041a0 <elapsed+0xe>
8000419c:	862fe06f          	j	800021fe <z_clock_elapsed>
}
800041a0:	4501                	li	a0,0
800041a2:	8082                	ret

800041a4 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
800041a4:	411c                	lw	a5,0(a0)
800041a6:	cd01                	beqz	a0,800041be <remove_timeout+0x1a>
800041a8:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
800041ac:	0d472703          	lw	a4,212(a4) # 800060d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d5>
800041b0:	00e50763          	beq	a0,a4,800041be <remove_timeout+0x1a>
	if (next(t) != NULL) {
800041b4:	c789                	beqz	a5,800041be <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
800041b6:	4798                	lw	a4,8(a5)
800041b8:	4514                	lw	a3,8(a0)
800041ba:	9736                	add	a4,a4,a3
800041bc:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
800041be:	4158                	lw	a4,4(a0)
800041c0:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
800041c2:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
800041c4:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800041c8:	00052223          	sw	zero,4(a0)
}
800041cc:	8082                	ret

800041ce <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800041ce:	800067b7          	lui	a5,0x80006
800041d2:	2787c783          	lbu	a5,632(a5) # 80006278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006279>
{
800041d6:	1141                	addi	sp,sp,-16
800041d8:	c606                	sw	ra,12(sp)
800041da:	c422                	sw	s0,8(sp)
800041dc:	c226                	sw	s1,4(sp)
800041de:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800041e0:	e789                	bnez	a5,800041ea <next_timeout+0x1c>
800041e2:	80000537          	lui	a0,0x80000
800041e6:	fff54513          	not	a0,a0
	return list->head == list;
800041ea:	800067b7          	lui	a5,0x80006
800041ee:	0d078793          	addi	a5,a5,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
800041f2:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800041f4:	00f40f63          	beq	s0,a5,80004212 <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
800041f8:	cc09                	beqz	s0,80004212 <next_timeout+0x44>
800041fa:	4404                	lw	s1,8(s0)
800041fc:	f97ff0ef          	jal	ra,80004192 <elapsed>
80004200:	8c89                	sub	s1,s1,a0
80004202:	4501                	li	a0,0
80004204:	0004c763          	bltz	s1,80004212 <next_timeout+0x44>
80004208:	4400                	lw	s0,8(s0)
8000420a:	f89ff0ef          	jal	ra,80004192 <elapsed>
8000420e:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004212:	800067b7          	lui	a5,0x80006
80004216:	46c7a783          	lw	a5,1132(a5) # 8000646c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000646d>
8000421a:	c781                	beqz	a5,80004222 <next_timeout+0x54>
8000421c:	00a7d363          	bge	a5,a0,80004222 <next_timeout+0x54>
80004220:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004222:	40b2                	lw	ra,12(sp)
80004224:	4422                	lw	s0,8(sp)
80004226:	4492                	lw	s1,4(sp)
80004228:	0141                	addi	sp,sp,16
8000422a:	8082                	ret

8000422c <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
8000422c:	411c                	lw	a5,0(a0)
{
8000422e:	7179                	addi	sp,sp,-48
80004230:	d422                	sw	s0,40(sp)
80004232:	d226                	sw	s1,36(sp)
80004234:	ce4e                	sw	s3,28(sp)
80004236:	d606                	sw	ra,44(sp)
80004238:	d04a                	sw	s2,32(sp)
8000423a:	cc52                	sw	s4,24(sp)
8000423c:	ca56                	sw	s5,20(sp)
8000423e:	c85a                	sw	s6,16(sp)
80004240:	c65e                	sw	s7,12(sp)
80004242:	c462                	sw	s8,8(sp)
80004244:	842a                	mv	s0,a0
80004246:	89ae                	mv	s3,a1
80004248:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
8000424a:	cf8d                	beqz	a5,80004284 <z_add_timeout+0x58>
8000424c:	80006937          	lui	s2,0x80006
80004250:	800065b7          	lui	a1,0x80006
80004254:	80006537          	lui	a0,0x80006
80004258:	f4c58593          	addi	a1,a1,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
8000425c:	04d00693          	li	a3,77
80004260:	f3890613          	addi	a2,s2,-200 # 80005f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f39>
80004264:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004268:	c1ffd0ef          	jal	ra,80001e86 <printk>
8000426c:	80006537          	lui	a0,0x80006
80004270:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80004274:	c13fd0ef          	jal	ra,80001e86 <printk>
80004278:	04d00593          	li	a1,77
8000427c:	f3890513          	addi	a0,s2,-200
80004280:	c25fd0ef          	jal	ra,80001ea4 <assert_post_action>
	to->fn = fn;
80004284:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004288:	00904363          	bgtz	s1,8000428e <z_add_timeout+0x62>
8000428c:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000428e:	49a1                	li	s3,8
80004290:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004294:	80006a37          	lui	s4,0x80006
80004298:	270a0513          	addi	a0,s4,624 # 80006270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006271>
	key = (mstatus & SOC_MSTATUS_IEN);
8000429c:	0089f993          	andi	s3,s3,8
800042a0:	bb9ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
800042a4:	ed0d                	bnez	a0,800042de <z_add_timeout+0xb2>
800042a6:	80006937          	lui	s2,0x80006
800042aa:	800065b7          	lui	a1,0x80006
800042ae:	80006537          	lui	a0,0x80006
800042b2:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800042b6:	04e00693          	li	a3,78
800042ba:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800042be:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800042c2:	bc5fd0ef          	jal	ra,80001e86 <printk>
800042c6:	80006537          	lui	a0,0x80006
800042ca:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
800042ce:	bb9fd0ef          	jal	ra,80001e86 <printk>
800042d2:	04e00593          	li	a1,78
800042d6:	ac490513          	addi	a0,s2,-1340
800042da:	bcbfd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800042de:	270a0513          	addi	a0,s4,624
800042e2:	bb3ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
800042e6:	eadff0ef          	jal	ra,80004192 <elapsed>
800042ea:	9526                	add	a0,a0,s1
	return list->head == list;
800042ec:	800064b7          	lui	s1,0x80006
800042f0:	0d04a903          	lw	s2,208(s1) # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
800042f4:	c408                	sw	a0,8(s0)
800042f6:	0d048493          	addi	s1,s1,208
	return sys_dlist_is_empty(list) ? NULL : list->head;
800042fa:	00990c63          	beq	s2,s1,80004312 <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
800042fe:	80006ab7          	lui	s5,0x80006
80004302:	80006b37          	lui	s6,0x80006
80004306:	80006bb7          	lui	s7,0x80006
8000430a:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
8000430e:	00091963          	bnez	s2,80004320 <z_add_timeout+0xf4>
	node->prev = list->tail;
80004312:	40dc                	lw	a5,4(s1)
	node->next = list;
80004314:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80004316:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80004318:	40dc                	lw	a5,4(s1)
8000431a:	c380                	sw	s0,0(a5)
	list->tail = node;
8000431c:	c0c0                	sw	s0,4(s1)
8000431e:	a891                	j	80004372 <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
80004320:	00892783          	lw	a5,8(s2)
80004324:	0207d663          	bgez	a5,80004350 <z_add_timeout+0x124>
80004328:	f6cb0593          	addi	a1,s6,-148 # 80005f6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f6d>
8000432c:	05600693          	li	a3,86
80004330:	f38a8613          	addi	a2,s5,-200 # 80005f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f39>
80004334:	a3cb8513          	addi	a0,s7,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004338:	b4ffd0ef          	jal	ra,80001e86 <printk>
8000433c:	cecc0513          	addi	a0,s8,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80004340:	b47fd0ef          	jal	ra,80001e86 <printk>
80004344:	05600593          	li	a1,86
80004348:	f38a8513          	addi	a0,s5,-200
8000434c:	b59fd0ef          	jal	ra,80001ea4 <assert_post_action>

			if (t->dticks > to->dticks) {
80004350:	00892703          	lw	a4,8(s2)
80004354:	441c                	lw	a5,8(s0)
80004356:	08e7d763          	bge	a5,a4,800043e4 <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
8000435a:	40f707b3          	sub	a5,a4,a5
8000435e:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004362:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004366:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
8000436a:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
8000436c:	c380                	sw	s0,0(a5)
	successor->prev = node;
8000436e:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004372:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004374:	00978963          	beq	a5,s1,80004386 <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004378:	00f41763          	bne	s0,a5,80004386 <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
8000437c:	e53ff0ef          	jal	ra,800041ce <next_timeout>
80004380:	4581                	li	a1,0
80004382:	d31fd0ef          	jal	ra,800020b2 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004386:	270a0513          	addi	a0,s4,624
8000438a:	ae9ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000438e:	ed0d                	bnez	a0,800043c8 <z_add_timeout+0x19c>
80004390:	80006437          	lui	s0,0x80006
80004394:	800065b7          	lui	a1,0x80006
80004398:	80006537          	lui	a0,0x80006
8000439c:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800043a0:	06100693          	li	a3,97
800043a4:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800043a8:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800043ac:	adbfd0ef          	jal	ra,80001e86 <printk>
800043b0:	80006537          	lui	a0,0x80006
800043b4:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800043b8:	acffd0ef          	jal	ra,80001e86 <printk>
800043bc:	06100593          	li	a1,97
800043c0:	ac440513          	addi	a0,s0,-1340
800043c4:	ae1fd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800043c8:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
800043cc:	50b2                	lw	ra,44(sp)
800043ce:	5422                	lw	s0,40(sp)
800043d0:	5492                	lw	s1,36(sp)
800043d2:	5902                	lw	s2,32(sp)
800043d4:	49f2                	lw	s3,28(sp)
800043d6:	4a62                	lw	s4,24(sp)
800043d8:	4ad2                	lw	s5,20(sp)
800043da:	4b42                	lw	s6,16(sp)
800043dc:	4bb2                	lw	s7,12(sp)
800043de:	4c22                	lw	s8,8(sp)
800043e0:	6145                	addi	sp,sp,48
800043e2:	8082                	ret
			to->dticks -= t->dticks;
800043e4:	8f99                	sub	a5,a5,a4
800043e6:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
800043e8:	40dc                	lw	a5,4(s1)
800043ea:	f32784e3          	beq	a5,s2,80004312 <z_add_timeout+0xe6>
800043ee:	00092903          	lw	s2,0(s2)
800043f2:	bf31                	j	8000430e <z_add_timeout+0xe2>

800043f4 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
800043f4:	1101                	addi	sp,sp,-32
800043f6:	cc22                	sw	s0,24(sp)
800043f8:	c64e                	sw	s3,12(sp)
800043fa:	ce06                	sw	ra,28(sp)
800043fc:	ca26                	sw	s1,20(sp)
800043fe:	c84a                	sw	s2,16(sp)
80004400:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004402:	4421                	li	s0,8
80004404:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004408:	800064b7          	lui	s1,0x80006
8000440c:	27048513          	addi	a0,s1,624 # 80006270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006271>
	key = (mstatus & SOC_MSTATUS_IEN);
80004410:	8821                	andi	s0,s0,8
80004412:	a47ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
80004416:	ed0d                	bnez	a0,80004450 <z_abort_timeout+0x5c>
80004418:	80006937          	lui	s2,0x80006
8000441c:	800065b7          	lui	a1,0x80006
80004420:	80006537          	lui	a0,0x80006
80004424:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80004428:	04e00693          	li	a3,78
8000442c:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004430:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004434:	a53fd0ef          	jal	ra,80001e86 <printk>
80004438:	80006537          	lui	a0,0x80006
8000443c:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004440:	a47fd0ef          	jal	ra,80001e86 <printk>
80004444:	04e00593          	li	a1,78
80004448:	ac490513          	addi	a0,s2,-1340
8000444c:	a59fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004450:	27048513          	addi	a0,s1,624
80004454:	a41ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004458:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
8000445c:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
8000445e:	c789                	beqz	a5,80004468 <z_abort_timeout+0x74>
			remove_timeout(to);
80004460:	854e                	mv	a0,s3
80004462:	d43ff0ef          	jal	ra,800041a4 <remove_timeout>
			ret = 0;
80004466:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004468:	27048513          	addi	a0,s1,624
8000446c:	a07ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80004470:	ed0d                	bnez	a0,800044aa <z_abort_timeout+0xb6>
80004472:	800064b7          	lui	s1,0x80006
80004476:	800065b7          	lui	a1,0x80006
8000447a:	80006537          	lui	a0,0x80006
8000447e:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80004482:	06100693          	li	a3,97
80004486:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000448a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000448e:	9f9fd0ef          	jal	ra,80001e86 <printk>
80004492:	80006537          	lui	a0,0x80006
80004496:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
8000449a:	9edfd0ef          	jal	ra,80001e86 <printk>
8000449e:	06100593          	li	a1,97
800044a2:	ac448513          	addi	a0,s1,-1340
800044a6:	9fffd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800044aa:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
800044ae:	40f2                	lw	ra,28(sp)
800044b0:	4462                	lw	s0,24(sp)
800044b2:	854a                	mv	a0,s2
800044b4:	44d2                	lw	s1,20(sp)
800044b6:	4942                	lw	s2,16(sp)
800044b8:	49b2                	lw	s3,12(sp)
800044ba:	6105                	addi	sp,sp,32
800044bc:	8082                	ret

800044be <z_timeout_remaining>:

s32_t z_timeout_remaining(struct _timeout *timeout)
{
	s32_t ticks = 0;

	if (z_is_inactive_timeout(timeout)) {
800044be:	411c                	lw	a5,0(a0)
800044c0:	0e078563          	beqz	a5,800045aa <z_timeout_remaining+0xec>
{
800044c4:	1101                	addi	sp,sp,-32
800044c6:	ca26                	sw	s1,20(sp)
800044c8:	c64e                	sw	s3,12(sp)
800044ca:	ce06                	sw	ra,28(sp)
800044cc:	cc22                	sw	s0,24(sp)
800044ce:	c84a                	sw	s2,16(sp)
800044d0:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800044d2:	44a1                	li	s1,8
800044d4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044d8:	80006937          	lui	s2,0x80006
800044dc:	27090513          	addi	a0,s2,624 # 80006270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006271>
	key = (mstatus & SOC_MSTATUS_IEN);
800044e0:	88a1                	andi	s1,s1,8
800044e2:	977ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
800044e6:	ed0d                	bnez	a0,80004520 <z_timeout_remaining+0x62>
800044e8:	80006437          	lui	s0,0x80006
800044ec:	800065b7          	lui	a1,0x80006
800044f0:	80006537          	lui	a0,0x80006
800044f4:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800044f8:	04e00693          	li	a3,78
800044fc:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004500:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004504:	983fd0ef          	jal	ra,80001e86 <printk>
80004508:	80006537          	lui	a0,0x80006
8000450c:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004510:	977fd0ef          	jal	ra,80001e86 <printk>
80004514:	04e00593          	li	a1,78
80004518:	ac440513          	addi	a0,s0,-1340
8000451c:	989fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004520:	27090513          	addi	a0,s2,624
80004524:	971ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	return list->head == list;
80004528:	80006737          	lui	a4,0x80006
8000452c:	0d070713          	addi	a4,a4,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
80004530:	431c                	lw	a5,0(a4)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004532:	4401                	li	s0,0
80004534:	00e78463          	beq	a5,a4,8000453c <z_timeout_remaining+0x7e>
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004538:	4358                	lw	a4,4(a4)
		return 0;
	}

	LOCKED(&timeout_lock) {
		for (struct _timeout *t = first(); t != NULL; t = next(t)) {
8000453a:	efb9                	bnez	a5,80004598 <z_timeout_remaining+0xda>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000453c:	27090513          	addi	a0,s2,624
80004540:	933ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80004544:	ed0d                	bnez	a0,8000457e <z_timeout_remaining+0xc0>
80004546:	80006937          	lui	s2,0x80006
8000454a:	800065b7          	lui	a1,0x80006
8000454e:	80006537          	lui	a0,0x80006
80004552:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80004556:	06100693          	li	a3,97
8000455a:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000455e:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004562:	925fd0ef          	jal	ra,80001e86 <printk>
80004566:	80006537          	lui	a0,0x80006
8000456a:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
8000456e:	919fd0ef          	jal	ra,80001e86 <printk>
80004572:	06100593          	li	a1,97
80004576:	ac490513          	addi	a0,s2,-1340
8000457a:	92bfd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000457e:	3004a4f3          	csrrs	s1,mstatus,s1
				break;
			}
		}
	}

	return ticks - elapsed();
80004582:	c11ff0ef          	jal	ra,80004192 <elapsed>
80004586:	40a40533          	sub	a0,s0,a0
}
8000458a:	40f2                	lw	ra,28(sp)
8000458c:	4462                	lw	s0,24(sp)
8000458e:	44d2                	lw	s1,20(sp)
80004590:	4942                	lw	s2,16(sp)
80004592:	49b2                	lw	s3,12(sp)
80004594:	6105                	addi	sp,sp,32
80004596:	8082                	ret
			ticks += t->dticks;
80004598:	4794                	lw	a3,8(a5)
8000459a:	9436                	add	s0,s0,a3
			if (timeout == t) {
8000459c:	fb3780e3          	beq	a5,s3,8000453c <z_timeout_remaining+0x7e>
800045a0:	dfd1                	beqz	a5,8000453c <z_timeout_remaining+0x7e>
	return (node == list->tail) ? NULL : node->next;
800045a2:	f8e78de3          	beq	a5,a4,8000453c <z_timeout_remaining+0x7e>
800045a6:	439c                	lw	a5,0(a5)
800045a8:	bf49                	j	8000453a <z_timeout_remaining+0x7c>
		return 0;
800045aa:	4501                	li	a0,0
}
800045ac:	8082                	ret

800045ae <z_get_next_timeout_expiry>:

s32_t z_get_next_timeout_expiry(void)
{
800045ae:	1141                	addi	sp,sp,-16
800045b0:	c422                	sw	s0,8(sp)
800045b2:	c606                	sw	ra,12(sp)
800045b4:	c226                	sw	s1,4(sp)
800045b6:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800045b8:	4421                	li	s0,8
800045ba:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045be:	800064b7          	lui	s1,0x80006
800045c2:	27048513          	addi	a0,s1,624 # 80006270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006271>
	key = (mstatus & SOC_MSTATUS_IEN);
800045c6:	8821                	andi	s0,s0,8
800045c8:	891ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
800045cc:	ed0d                	bnez	a0,80004606 <z_get_next_timeout_expiry+0x58>
800045ce:	80006937          	lui	s2,0x80006
800045d2:	800065b7          	lui	a1,0x80006
800045d6:	80006537          	lui	a0,0x80006
800045da:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800045de:	04e00693          	li	a3,78
800045e2:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800045e6:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800045ea:	89dfd0ef          	jal	ra,80001e86 <printk>
800045ee:	80006537          	lui	a0,0x80006
800045f2:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
800045f6:	891fd0ef          	jal	ra,80001e86 <printk>
800045fa:	04e00593          	li	a1,78
800045fe:	ac490513          	addi	a0,s2,-1340
80004602:	8a3fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004606:	27048513          	addi	a0,s1,624
8000460a:	88bff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
8000460e:	bc1ff0ef          	jal	ra,800041ce <next_timeout>
80004612:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004614:	27048513          	addi	a0,s1,624
80004618:	85bff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000461c:	ed0d                	bnez	a0,80004656 <z_get_next_timeout_expiry+0xa8>
8000461e:	800064b7          	lui	s1,0x80006
80004622:	800065b7          	lui	a1,0x80006
80004626:	80006537          	lui	a0,0x80006
8000462a:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
8000462e:	06100693          	li	a3,97
80004632:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004636:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000463a:	84dfd0ef          	jal	ra,80001e86 <printk>
8000463e:	80006537          	lui	a0,0x80006
80004642:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80004646:	841fd0ef          	jal	ra,80001e86 <printk>
8000464a:	06100593          	li	a1,97
8000464e:	ac448513          	addi	a0,s1,-1340
80004652:	853fd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004656:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
8000465a:	40b2                	lw	ra,12(sp)
8000465c:	4422                	lw	s0,8(sp)
8000465e:	854a                	mv	a0,s2
80004660:	4492                	lw	s1,4(sp)
80004662:	4902                	lw	s2,0(sp)
80004664:	0141                	addi	sp,sp,16
80004666:	8082                	ret

80004668 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80004668:	1101                	addi	sp,sp,-32
8000466a:	cc22                	sw	s0,24(sp)
8000466c:	c84a                	sw	s2,16(sp)
8000466e:	c452                	sw	s4,8(sp)
80004670:	ce06                	sw	ra,28(sp)
80004672:	ca26                	sw	s1,20(sp)
80004674:	c64e                	sw	s3,12(sp)
80004676:	892a                	mv	s2,a0
80004678:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000467a:	4421                	li	s0,8
8000467c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004680:	800064b7          	lui	s1,0x80006
80004684:	27048513          	addi	a0,s1,624 # 80006270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006271>
	key = (mstatus & SOC_MSTATUS_IEN);
80004688:	8821                	andi	s0,s0,8
8000468a:	fceff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
8000468e:	ed0d                	bnez	a0,800046c8 <z_set_timeout_expiry+0x60>
80004690:	800069b7          	lui	s3,0x80006
80004694:	800065b7          	lui	a1,0x80006
80004698:	80006537          	lui	a0,0x80006
8000469c:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800046a0:	04e00693          	li	a3,78
800046a4:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800046a8:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800046ac:	fdafd0ef          	jal	ra,80001e86 <printk>
800046b0:	80006537          	lui	a0,0x80006
800046b4:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
800046b8:	fcefd0ef          	jal	ra,80001e86 <printk>
800046bc:	04e00593          	li	a1,78
800046c0:	ac498513          	addi	a0,s3,-1340
800046c4:	fe0fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
800046c8:	27048513          	addi	a0,s1,624
800046cc:	fc8ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
800046d0:	affff0ef          	jal	ra,800041ce <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
800046d4:	00a95963          	bge	s2,a0,800046e6 <z_set_timeout_expiry+0x7e>
800046d8:	4785                	li	a5,1
800046da:	00a7d663          	bge	a5,a0,800046e6 <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
800046de:	85d2                	mv	a1,s4
800046e0:	854a                	mv	a0,s2
800046e2:	9d1fd0ef          	jal	ra,800020b2 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800046e6:	27048513          	addi	a0,s1,624
800046ea:	f88ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800046ee:	ed0d                	bnez	a0,80004728 <z_set_timeout_expiry+0xc0>
800046f0:	800064b7          	lui	s1,0x80006
800046f4:	800065b7          	lui	a1,0x80006
800046f8:	80006537          	lui	a0,0x80006
800046fc:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80004700:	06100693          	li	a3,97
80004704:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004708:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000470c:	f7afd0ef          	jal	ra,80001e86 <printk>
80004710:	80006537          	lui	a0,0x80006
80004714:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80004718:	f6efd0ef          	jal	ra,80001e86 <printk>
8000471c:	06100593          	li	a1,97
80004720:	ac448513          	addi	a0,s1,-1340
80004724:	f80fd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004728:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
8000472c:	40f2                	lw	ra,28(sp)
8000472e:	4462                	lw	s0,24(sp)
80004730:	44d2                	lw	s1,20(sp)
80004732:	4942                	lw	s2,16(sp)
80004734:	49b2                	lw	s3,12(sp)
80004736:	4a22                	lw	s4,8(sp)
80004738:	6105                	addi	sp,sp,32
8000473a:	8082                	ret

8000473c <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
8000473c:	7179                	addi	sp,sp,-48
8000473e:	d422                	sw	s0,40(sp)
80004740:	cc52                	sw	s4,24(sp)
80004742:	d606                	sw	ra,44(sp)
80004744:	d226                	sw	s1,36(sp)
80004746:	d04a                	sw	s2,32(sp)
80004748:	ce4e                	sw	s3,28(sp)
8000474a:	ca56                	sw	s5,20(sp)
8000474c:	c85a                	sw	s6,16(sp)
8000474e:	c65e                	sw	s7,12(sp)
80004750:	c462                	sw	s8,8(sp)
80004752:	c266                	sw	s9,4(sp)
80004754:	c06a                	sw	s10,0(sp)
80004756:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004758:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
8000475a:	b8ffe0ef          	jal	ra,800032e8 <z_time_slice>
8000475e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004762:	80006937          	lui	s2,0x80006
80004766:	27090513          	addi	a0,s2,624 # 80006270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006271>
	key = (mstatus & SOC_MSTATUS_IEN);
8000476a:	8821                	andi	s0,s0,8
8000476c:	eecff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
80004770:	ed0d                	bnez	a0,800047aa <z_clock_announce+0x6e>
80004772:	800064b7          	lui	s1,0x80006
80004776:	800065b7          	lui	a1,0x80006
8000477a:	80006537          	lui	a0,0x80006
8000477e:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80004782:	04e00693          	li	a3,78
80004786:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
8000478a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000478e:	ef8fd0ef          	jal	ra,80001e86 <printk>
80004792:	80006537          	lui	a0,0x80006
80004796:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
8000479a:	eecfd0ef          	jal	ra,80001e86 <printk>
8000479e:	04e00593          	li	a1,78
800047a2:	ac448513          	addi	a0,s1,-1340
800047a6:	efefd0ef          	jal	ra,80001ea4 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
800047aa:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
800047ae:	27090513          	addi	a0,s2,624
800047b2:	ee2ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
800047b6:	800064b7          	lui	s1,0x80006
800047ba:	2749a623          	sw	s4,620(s3) # 8000626c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000626d>
	return list->head == list;
800047be:	80006a37          	lui	s4,0x80006
800047c2:	26c98993          	addi	s3,s3,620
800047c6:	0d0a0a13          	addi	s4,s4,208 # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
800047ca:	23848493          	addi	s1,s1,568 # 80006238 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006239>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800047ce:	80006ab7          	lui	s5,0x80006
800047d2:	80006bb7          	lui	s7,0x80006
800047d6:	80006b37          	lui	s6,0x80006
800047da:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800047de:	80006cb7          	lui	s9,0x80006
800047e2:	000a2d03          	lw	s10,0(s4)
800047e6:	0009a783          	lw	a5,0(s3)
800047ea:	4094                	lw	a3,0(s1)
800047ec:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800047ee:	014d0b63          	beq	s10,s4,80004804 <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
800047f2:	000d0963          	beqz	s10,80004804 <z_clock_announce+0xc8>
800047f6:	008d2703          	lw	a4,8(s10)
800047fa:	08e7d663          	bge	a5,a4,80004886 <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
800047fe:	8f1d                	sub	a4,a4,a5
80004800:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80004804:	96be                	add	a3,a3,a5
80004806:	41f7d713          	srai	a4,a5,0x1f
8000480a:	972a                	add	a4,a4,a0
8000480c:	00f6b7b3          	sltu	a5,a3,a5
80004810:	97ba                	add	a5,a5,a4
80004812:	c094                	sw	a3,0(s1)
80004814:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
80004816:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
8000481a:	9b5ff0ef          	jal	ra,800041ce <next_timeout>
8000481e:	4581                	li	a1,0
80004820:	893fd0ef          	jal	ra,800020b2 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004824:	27090513          	addi	a0,s2,624
80004828:	e4aff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
8000482c:	ed0d                	bnez	a0,80004866 <z_clock_announce+0x12a>
8000482e:	800064b7          	lui	s1,0x80006
80004832:	800065b7          	lui	a1,0x80006
80004836:	80006537          	lui	a0,0x80006
8000483a:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
8000483e:	06100693          	li	a3,97
80004842:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004846:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000484a:	e3cfd0ef          	jal	ra,80001e86 <printk>
8000484e:	80006537          	lui	a0,0x80006
80004852:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80004856:	e30fd0ef          	jal	ra,80001e86 <printk>
8000485a:	06100593          	li	a1,97
8000485e:	ac448513          	addi	a0,s1,-1340
80004862:	e42fd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004866:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
8000486a:	50b2                	lw	ra,44(sp)
8000486c:	5422                	lw	s0,40(sp)
8000486e:	5492                	lw	s1,36(sp)
80004870:	5902                	lw	s2,32(sp)
80004872:	49f2                	lw	s3,28(sp)
80004874:	4a62                	lw	s4,24(sp)
80004876:	4ad2                	lw	s5,20(sp)
80004878:	4b42                	lw	s6,16(sp)
8000487a:	4bb2                	lw	s7,12(sp)
8000487c:	4c22                	lw	s8,8(sp)
8000487e:	4c92                	lw	s9,4(sp)
80004880:	4d02                	lw	s10,0(sp)
80004882:	6145                	addi	sp,sp,48
80004884:	8082                	ret
		curr_tick += dt;
80004886:	96ba                	add	a3,a3,a4
80004888:	41f75593          	srai	a1,a4,0x1f
8000488c:	95aa                	add	a1,a1,a0
8000488e:	00e6b633          	sltu	a2,a3,a4
80004892:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
80004894:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
80004896:	856a                	mv	a0,s10
		t->dticks = 0;
80004898:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
8000489c:	c094                	sw	a3,0(s1)
8000489e:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
800048a0:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
800048a4:	901ff0ef          	jal	ra,800041a4 <remove_timeout>
800048a8:	27090513          	addi	a0,s2,624
800048ac:	dc6ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800048b0:	e50d                	bnez	a0,800048da <z_clock_announce+0x19e>
800048b2:	b0cb8593          	addi	a1,s7,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800048b6:	06100693          	li	a3,97
800048ba:	ac4a8613          	addi	a2,s5,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800048be:	a3cb0513          	addi	a0,s6,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800048c2:	dc4fd0ef          	jal	ra,80001e86 <printk>
800048c6:	b24c0513          	addi	a0,s8,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800048ca:	dbcfd0ef          	jal	ra,80001e86 <printk>
800048ce:	06100593          	li	a1,97
800048d2:	ac4a8513          	addi	a0,s5,-1340
800048d6:	dcefd0ef          	jal	ra,80001ea4 <assert_post_action>
800048da:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
800048de:	00cd2783          	lw	a5,12(s10)
800048e2:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
800048e4:	4421                	li	s0,8
800048e6:	9782                	jalr	a5
800048e8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800048ec:	27090513          	addi	a0,s2,624
	key = (mstatus & SOC_MSTATUS_IEN);
800048f0:	8821                	andi	s0,s0,8
800048f2:	d66ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
800048f6:	e51d                	bnez	a0,80004924 <z_clock_announce+0x1e8>
800048f8:	adcc8593          	addi	a1,s9,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
800048fc:	04e00693          	li	a3,78
80004900:	ac4a8613          	addi	a2,s5,-1340
80004904:	a3cb0513          	addi	a0,s6,-1476
80004908:	d7efd0ef          	jal	ra,80001e86 <printk>
8000490c:	80006537          	lui	a0,0x80006
80004910:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004914:	d72fd0ef          	jal	ra,80001e86 <printk>
80004918:	04e00593          	li	a1,78
8000491c:	ac4a8513          	addi	a0,s5,-1340
80004920:	d84fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004924:	27090513          	addi	a0,s2,624
80004928:	d6cff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	return k;
8000492c:	bd5d                	j	800047e2 <z_clock_announce+0xa6>

8000492e <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
8000492e:	1101                	addi	sp,sp,-32
80004930:	ca26                	sw	s1,20(sp)
80004932:	ce06                	sw	ra,28(sp)
80004934:	cc22                	sw	s0,24(sp)
80004936:	c84a                	sw	s2,16(sp)
80004938:	c64e                	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000493a:	44a1                	li	s1,8
8000493c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004940:	80006937          	lui	s2,0x80006
80004944:	27090513          	addi	a0,s2,624 # 80006270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006271>
	key = (mstatus & SOC_MSTATUS_IEN);
80004948:	88a1                	andi	s1,s1,8
8000494a:	d0eff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
8000494e:	ed0d                	bnez	a0,80004988 <z_tick_get+0x5a>
80004950:	80006437          	lui	s0,0x80006
80004954:	800065b7          	lui	a1,0x80006
80004958:	80006537          	lui	a0,0x80006
8000495c:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80004960:	04e00693          	li	a3,78
80004964:	ac440613          	addi	a2,s0,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004968:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
8000496c:	d1afd0ef          	jal	ra,80001e86 <printk>
80004970:	80006537          	lui	a0,0x80006
80004974:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004978:	d0efd0ef          	jal	ra,80001e86 <printk>
8000497c:	04e00593          	li	a1,78
80004980:	ac440513          	addi	a0,s0,-1340
80004984:	d20fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004988:	27090513          	addi	a0,s2,624
8000498c:	d08ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80004990:	86ffd0ef          	jal	ra,800021fe <z_clock_elapsed>
80004994:	800067b7          	lui	a5,0x80006
80004998:	23878793          	addi	a5,a5,568 # 80006238 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006239>
8000499c:	0007a983          	lw	s3,0(a5)
800049a0:	43c0                	lw	s0,4(a5)
800049a2:	99aa                	add	s3,s3,a0
800049a4:	00a9b533          	sltu	a0,s3,a0
800049a8:	942a                	add	s0,s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800049aa:	27090513          	addi	a0,s2,624
800049ae:	cc4ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
800049b2:	ed0d                	bnez	a0,800049ec <z_tick_get+0xbe>
800049b4:	80006937          	lui	s2,0x80006
800049b8:	800065b7          	lui	a1,0x80006
800049bc:	80006537          	lui	a0,0x80006
800049c0:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
800049c4:	06100693          	li	a3,97
800049c8:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
800049cc:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
800049d0:	cb6fd0ef          	jal	ra,80001e86 <printk>
800049d4:	80006537          	lui	a0,0x80006
800049d8:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800049dc:	caafd0ef          	jal	ra,80001e86 <printk>
800049e0:	06100593          	li	a1,97
800049e4:	ac490513          	addi	a0,s2,-1340
800049e8:	cbcfd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049ec:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
800049f0:	85a2                	mv	a1,s0
800049f2:	40f2                	lw	ra,28(sp)
800049f4:	4462                	lw	s0,24(sp)
800049f6:	854e                	mv	a0,s3
800049f8:	44d2                	lw	s1,20(sp)
800049fa:	4942                	lw	s2,16(sp)
800049fc:	49b2                	lw	s3,12(sp)
800049fe:	6105                	addi	sp,sp,32
80004a00:	8082                	ret

80004a02 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80004a02:	1141                	addi	sp,sp,-16
80004a04:	c606                	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80004a06:	f29ff0ef          	jal	ra,8000492e <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80004a0a:	40b2                	lw	ra,12(sp)
80004a0c:	0141                	addi	sp,sp,16
80004a0e:	8082                	ret

80004a10 <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
80004a10:	1141                	addi	sp,sp,-16
80004a12:	c606                	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
80004a14:	f1bff0ef          	jal	ra,8000492e <z_tick_get>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80004a18:	3e800613          	li	a2,1000
80004a1c:	4681                	li	a3,0
80004a1e:	e23fb0ef          	jal	ra,80000840 <__muldi3>
80004a22:	06400613          	li	a2,100
80004a26:	4681                	li	a3,0
80004a28:	821fb0ef          	jal	ra,80000248 <__udivdi3>
}
80004a2c:	40b2                	lw	ra,12(sp)
80004a2e:	0141                	addi	sp,sp,16
80004a30:	8082                	ret

80004a32 <z_timer_expiration_handler>:

	/*
	 * if the timer is periodic, start it again; don't add _TICK_ALIGN
	 * since we're already aligned to a tick boundary
	 */
	if (timer->period > 0) {
80004a32:	5110                	lw	a2,32(a0)
{
80004a34:	1141                	addi	sp,sp,-16
80004a36:	c422                	sw	s0,8(sp)
80004a38:	c606                	sw	ra,12(sp)
80004a3a:	c226                	sw	s1,4(sp)
80004a3c:	842a                	mv	s0,a0
	if (timer->period > 0) {
80004a3e:	00c05863          	blez	a2,80004a4e <z_timer_expiration_handler+0x1c>
		z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80004a42:	800055b7          	lui	a1,0x80005
80004a46:	a3258593          	addi	a1,a1,-1486 # 80004a32 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a33>
80004a4a:	fe2ff0ef          	jal	ra,8000422c <z_add_timeout>
			     timer->period);
	}

	/* update timer's status */
	timer->status += 1U;
80004a4e:	505c                	lw	a5,36(s0)
80004a50:	0785                	addi	a5,a5,1
80004a52:	d05c                	sw	a5,36(s0)

	/* invoke timer expiry function */
	if (timer->expiry_fn != NULL) {
80004a54:	4c1c                	lw	a5,24(s0)
80004a56:	c399                	beqz	a5,80004a5c <z_timer_expiration_handler+0x2a>
		timer->expiry_fn(timer);
80004a58:	8522                	mv	a0,s0
80004a5a:	9782                	jalr	a5
	return list->head == list;
80004a5c:	4804                	lw	s1,16(s0)
	sys_dlist_init(&w->waitq);
}

static inline struct k_thread *z_waitq_head(_wait_q_t *w)
{
	return (void *)sys_dlist_peek_head(&w->waitq);
80004a5e:	0441                	addi	s0,s0,16
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004a60:	02848163          	beq	s1,s0,80004a82 <z_timer_expiration_handler+0x50>
	}

	thread = z_waitq_head(&timer->wait_q);

	if (thread == NULL) {
80004a64:	cc99                	beqz	s1,80004a82 <z_timer_expiration_handler+0x50>
	 * place a thread can be taken off this pend queue, and b) the
	 * only place a thread can be put on the pend queue is at
	 * thread level, which of course cannot interrupt the current
	 * context.
	 */
	z_unpend_thread_no_timeout(thread);
80004a66:	8526                	mv	a0,s1
80004a68:	f87fd0ef          	jal	ra,800029ee <z_unpend_thread_no_timeout>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004a6c:	00d4c783          	lbu	a5,13(s1)
80004a70:	8bfd                	andi	a5,a5,31
80004a72:	e791                	bnez	a5,80004a7e <z_timer_expiration_handler+0x4c>
	if (z_is_thread_ready(thread)) {
80004a74:	4c9c                	lw	a5,24(s1)
80004a76:	e781                	bnez	a5,80004a7e <z_timer_expiration_handler+0x4c>
		z_add_thread_to_ready_q(thread);
80004a78:	8526                	mv	a0,s1
80004a7a:	cb6fe0ef          	jal	ra,80002f30 <z_add_thread_to_ready_q>
80004a7e:	0604a623          	sw	zero,108(s1)

	z_ready_thread(thread);

	z_set_thread_return_value(thread, 0);
}
80004a82:	40b2                	lw	ra,12(sp)
80004a84:	4422                	lw	s0,8(sp)
80004a86:	4492                	lw	s1,4(sp)
80004a88:	0141                	addi	sp,sp,16
80004a8a:	8082                	ret

80004a8c <k_timer_init>:
	sys_dlist_init(&w->waitq);
80004a8c:	01050793          	addi	a5,a0,16

void k_timer_init(struct k_timer *timer,
			 k_timer_expiry_t expiry_fn,
			 k_timer_stop_t stop_fn)
{
	timer->expiry_fn = expiry_fn;
80004a90:	cd0c                	sw	a1,24(a0)
	timer->stop_fn = stop_fn;
80004a92:	cd50                	sw	a2,28(a0)
	timer->status = 0U;
80004a94:	02052223          	sw	zero,36(a0)
	list->head = (sys_dnode_t *)list;
80004a98:	c91c                	sw	a5,16(a0)
	list->tail = (sys_dnode_t *)list;
80004a9a:	c95c                	sw	a5,20(a0)
	node->next = NULL;
80004a9c:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004aa0:	00052223          	sw	zero,4(a0)

	z_waitq_init(&timer->wait_q);
	z_init_timeout(&timer->timeout, z_timer_expiration_handler);
	SYS_TRACING_OBJ_INIT(k_timer, timer);

	timer->user_data = NULL;
80004aa4:	02052423          	sw	zero,40(a0)

	z_object_init(timer);
}
80004aa8:	8082                	ret

80004aaa <z_impl_k_timer_start>:


void z_impl_k_timer_start(struct k_timer *timer, s32_t duration, s32_t period)
{
80004aaa:	7179                	addi	sp,sp,-48
80004aac:	d422                	sw	s0,40(sp)
80004aae:	d226                	sw	s1,36(sp)
80004ab0:	d04a                	sw	s2,32(sp)
80004ab2:	d606                	sw	ra,44(sp)
80004ab4:	ce4e                	sw	s3,28(sp)
80004ab6:	842a                	mv	s0,a0
80004ab8:	84ae                	mv	s1,a1
80004aba:	8932                	mv	s2,a2
	__ASSERT(duration >= 0 && period >= 0 &&
80004abc:	0005c763          	bltz	a1,80004aca <z_impl_k_timer_start+0x20>
80004ac0:	00064563          	bltz	a2,80004aca <z_impl_k_timer_start+0x20>
80004ac4:	00c5e7b3          	or	a5,a1,a2
80004ac8:	ef8d                	bnez	a5,80004b02 <z_impl_k_timer_start+0x58>
80004aca:	800069b7          	lui	s3,0x80006
80004ace:	800065b7          	lui	a1,0x80006
80004ad2:	80006537          	lui	a0,0x80006
80004ad6:	f9058593          	addi	a1,a1,-112 # 80005f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f91>
80004ada:	07300693          	li	a3,115
80004ade:	f7c98613          	addi	a2,s3,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
80004ae2:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004ae6:	ba0fd0ef          	jal	ra,80001e86 <printk>
80004aea:	80006537          	lui	a0,0x80006
80004aee:	fd050513          	addi	a0,a0,-48 # 80005fd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fd1>
80004af2:	b94fd0ef          	jal	ra,80001e86 <printk>
80004af6:	07300593          	li	a1,115
80004afa:	f7c98513          	addi	a0,s3,-132
80004afe:	ba6fd0ef          	jal	ra,80001ea4 <assert_post_action>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80004b02:	45a9                	li	a1,10
80004b04:	00990513          	addi	a0,s2,9
80004b08:	dc9fb0ef          	jal	ra,800008d0 <__divsi3>
		 (duration != 0 || period != 0), "invalid parameters\n");

	volatile s32_t period_in_ticks, duration_in_ticks;

	period_in_ticks = z_ms_to_ticks(period);
80004b0c:	c42a                	sw	a0,8(sp)
80004b0e:	45a9                	li	a1,10
80004b10:	00948513          	addi	a0,s1,9
80004b14:	dbdfb0ef          	jal	ra,800008d0 <__divsi3>
	duration_in_ticks = z_ms_to_ticks(duration);
80004b18:	c62a                	sw	a0,12(sp)

	(void)z_abort_timeout(&timer->timeout);
80004b1a:	8522                	mv	a0,s0
80004b1c:	8d9ff0ef          	jal	ra,800043f4 <z_abort_timeout>
	timer->period = period_in_ticks;
80004b20:	47a2                	lw	a5,8(sp)
	timer->status = 0U;
80004b22:	02042223          	sw	zero,36(s0)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80004b26:	8522                	mv	a0,s0
	timer->period = period_in_ticks;
80004b28:	d01c                	sw	a5,32(s0)
		     duration_in_ticks);
}
80004b2a:	5422                	lw	s0,40(sp)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80004b2c:	4632                	lw	a2,12(sp)
}
80004b2e:	50b2                	lw	ra,44(sp)
80004b30:	5492                	lw	s1,36(sp)
80004b32:	5902                	lw	s2,32(sp)
80004b34:	49f2                	lw	s3,28(sp)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80004b36:	800055b7          	lui	a1,0x80005
80004b3a:	a3258593          	addi	a1,a1,-1486 # 80004a32 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a33>
}
80004b3e:	6145                	addi	sp,sp,48
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80004b40:	eecff06f          	j	8000422c <z_add_timeout>

80004b44 <z_impl_k_timer_stop>:
	return 0;
}
#endif

void z_impl_k_timer_stop(struct k_timer *timer)
{
80004b44:	1141                	addi	sp,sp,-16
80004b46:	c422                	sw	s0,8(sp)
80004b48:	c606                	sw	ra,12(sp)
80004b4a:	842a                	mv	s0,a0
	int inactive = z_abort_timeout(&timer->timeout) != 0;
80004b4c:	8a9ff0ef          	jal	ra,800043f4 <z_abort_timeout>

	if (inactive) {
80004b50:	e121                	bnez	a0,80004b90 <z_impl_k_timer_stop+0x4c>
		return;
	}

	if (timer->stop_fn != NULL) {
80004b52:	4c5c                	lw	a5,28(s0)
80004b54:	c399                	beqz	a5,80004b5a <z_impl_k_timer_stop+0x16>
		timer->stop_fn(timer);
80004b56:	8522                	mv	a0,s0
80004b58:	9782                	jalr	a5
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);
80004b5a:	01040513          	addi	a0,s0,16
80004b5e:	4581                	li	a1,0
80004b60:	dcffd0ef          	jal	ra,8000292e <z_find_first_thread_to_unpend>
80004b64:	842a                	mv	s0,a0
	if (thread != NULL) {
80004b66:	c50d                	beqz	a0,80004b90 <z_impl_k_timer_stop+0x4c>
		z_unpend_thread_no_timeout(thread);
80004b68:	e87fd0ef          	jal	ra,800029ee <z_unpend_thread_no_timeout>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004b6c:	00d44783          	lbu	a5,13(s0)
80004b70:	8bfd                	andi	a5,a5,31
80004b72:	e791                	bnez	a5,80004b7e <z_impl_k_timer_stop+0x3a>
	if (z_is_thread_ready(thread)) {
80004b74:	4c1c                	lw	a5,24(s0)
80004b76:	e781                	bnez	a5,80004b7e <z_impl_k_timer_stop+0x3a>
		z_add_thread_to_ready_q(thread);
80004b78:	8522                	mv	a0,s0
80004b7a:	bb6fe0ef          	jal	ra,80002f30 <z_add_thread_to_ready_q>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b7e:	4521                	li	a0,8
80004b80:	30053573          	csrrc	a0,mstatus,a0

	if (pending_thread != NULL) {
		z_ready_thread(pending_thread);
		z_reschedule_unlocked();
	}
}
80004b84:	4422                	lw	s0,8(sp)
80004b86:	40b2                	lw	ra,12(sp)
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80004b88:	8921                	andi	a0,a0,8
80004b8a:	0141                	addi	sp,sp,16
80004b8c:	fe1fd06f          	j	80002b6c <z_reschedule_irqlock>
80004b90:	40b2                	lw	ra,12(sp)
80004b92:	4422                	lw	s0,8(sp)
80004b94:	0141                	addi	sp,sp,16
80004b96:	8082                	ret

80004b98 <z_impl_k_timer_status_get>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_timer_stop, K_OBJ_TIMER, struct k_timer *);
#endif

u32_t z_impl_k_timer_status_get(struct k_timer *timer)
{
80004b98:	1101                	addi	sp,sp,-32
80004b9a:	cc22                	sw	s0,24(sp)
80004b9c:	c84a                	sw	s2,16(sp)
80004b9e:	ce06                	sw	ra,28(sp)
80004ba0:	ca26                	sw	s1,20(sp)
80004ba2:	c64e                	sw	s3,12(sp)
80004ba4:	892a                	mv	s2,a0
80004ba6:	4421                	li	s0,8
80004ba8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004bac:	800064b7          	lui	s1,0x80006
80004bb0:	27448513          	addi	a0,s1,628 # 80006274 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006275>
	key = (mstatus & SOC_MSTATUS_IEN);
80004bb4:	8821                	andi	s0,s0,8
80004bb6:	aa2ff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
80004bba:	ed0d                	bnez	a0,80004bf4 <z_impl_k_timer_status_get+0x5c>
80004bbc:	800069b7          	lui	s3,0x80006
80004bc0:	800065b7          	lui	a1,0x80006
80004bc4:	80006537          	lui	a0,0x80006
80004bc8:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80004bcc:	04e00693          	li	a3,78
80004bd0:	ac498613          	addi	a2,s3,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004bd4:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004bd8:	aaefd0ef          	jal	ra,80001e86 <printk>
80004bdc:	80006537          	lui	a0,0x80006
80004be0:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004be4:	aa2fd0ef          	jal	ra,80001e86 <printk>
80004be8:	04e00593          	li	a1,78
80004bec:	ac498513          	addi	a0,s3,-1340
80004bf0:	ab4fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004bf4:	27448513          	addi	a0,s1,628
80004bf8:	a9cff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004bfc:	27448513          	addi	a0,s1,628
	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t result = timer->status;
80004c00:	02492983          	lw	s3,36(s2)

	timer->status = 0U;
80004c04:	02092223          	sw	zero,36(s2)
80004c08:	a6aff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80004c0c:	ed0d                	bnez	a0,80004c46 <z_impl_k_timer_status_get+0xae>
80004c0e:	800064b7          	lui	s1,0x80006
80004c12:	800065b7          	lui	a1,0x80006
80004c16:	80006537          	lui	a0,0x80006
80004c1a:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80004c1e:	06100693          	li	a3,97
80004c22:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004c26:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004c2a:	a5cfd0ef          	jal	ra,80001e86 <printk>
80004c2e:	80006537          	lui	a0,0x80006
80004c32:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80004c36:	a50fd0ef          	jal	ra,80001e86 <printk>
80004c3a:	06100593          	li	a1,97
80004c3e:	ac448513          	addi	a0,s1,-1340
80004c42:	a62fd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c46:	30042473          	csrrs	s0,mstatus,s0
	k_spin_unlock(&lock, key);

	return result;
}
80004c4a:	40f2                	lw	ra,28(sp)
80004c4c:	4462                	lw	s0,24(sp)
80004c4e:	854e                	mv	a0,s3
80004c50:	44d2                	lw	s1,20(sp)
80004c52:	4942                	lw	s2,16(sp)
80004c54:	49b2                	lw	s3,12(sp)
80004c56:	6105                	addi	sp,sp,32
80004c58:	8082                	ret

80004c5a <z_impl_k_timer_status_sync>:
Z_SYSCALL_HANDLER1_SIMPLE(k_timer_status_get, K_OBJ_TIMER, struct k_timer *);
#endif

u32_t z_impl_k_timer_status_sync(struct k_timer *timer)
{
	__ASSERT(!z_is_in_isr(), "");
80004c5a:	800067b7          	lui	a5,0x80006
80004c5e:	45c7a783          	lw	a5,1116(a5) # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
{
80004c62:	1101                	addi	sp,sp,-32
80004c64:	c64e                	sw	s3,12(sp)
80004c66:	ce06                	sw	ra,28(sp)
80004c68:	cc22                	sw	s0,24(sp)
80004c6a:	ca26                	sw	s1,20(sp)
80004c6c:	c84a                	sw	s2,16(sp)
80004c6e:	89aa                	mv	s3,a0
	__ASSERT(!z_is_in_isr(), "");
80004c70:	cf8d                	beqz	a5,80004caa <z_impl_k_timer_status_sync+0x50>
80004c72:	80006437          	lui	s0,0x80006
80004c76:	800065b7          	lui	a1,0x80006
80004c7a:	80006537          	lui	a0,0x80006
80004c7e:	cd458593          	addi	a1,a1,-812 # 80005cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd5>
80004c82:	0ba00693          	li	a3,186
80004c86:	f7c40613          	addi	a2,s0,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
80004c8a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004c8e:	9f8fd0ef          	jal	ra,80001e86 <printk>
80004c92:	80006537          	lui	a0,0x80006
80004c96:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80004c9a:	9ecfd0ef          	jal	ra,80001e86 <printk>
80004c9e:	0ba00593          	li	a1,186
80004ca2:	f7c40513          	addi	a0,s0,-132
80004ca6:	9fefd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004caa:	4421                	li	s0,8
80004cac:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004cb0:	800064b7          	lui	s1,0x80006
80004cb4:	27448513          	addi	a0,s1,628 # 80006274 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006275>
	key = (mstatus & SOC_MSTATUS_IEN);
80004cb8:	8821                	andi	s0,s0,8
80004cba:	99eff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
80004cbe:	ed0d                	bnez	a0,80004cf8 <z_impl_k_timer_status_sync+0x9e>
80004cc0:	80006937          	lui	s2,0x80006
80004cc4:	800065b7          	lui	a1,0x80006
80004cc8:	80006537          	lui	a0,0x80006
80004ccc:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80004cd0:	04e00693          	li	a3,78
80004cd4:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004cd8:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004cdc:	9aafd0ef          	jal	ra,80001e86 <printk>
80004ce0:	80006537          	lui	a0,0x80006
80004ce4:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004ce8:	99efd0ef          	jal	ra,80001e86 <printk>
80004cec:	04e00593          	li	a1,78
80004cf0:	ac490513          	addi	a0,s2,-1340
80004cf4:	9b0fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004cf8:	27448513          	addi	a0,s1,628
80004cfc:	998ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t result = timer->status;
80004d00:	0249a903          	lw	s2,36(s3)

	if (result == 0U) {
80004d04:	06091863          	bnez	s2,80004d74 <z_impl_k_timer_status_sync+0x11a>
		if (!z_is_inactive_timeout(&timer->timeout)) {
80004d08:	0009a783          	lw	a5,0(s3)
80004d0c:	c7a5                	beqz	a5,80004d74 <z_impl_k_timer_status_sync+0x11a>
			/* wait for timer to expire or stop */
			(void)z_pend_curr(&lock, key, &timer->wait_q, K_FOREVER);
80004d0e:	85a2                	mv	a1,s0
80004d10:	56fd                	li	a3,-1
80004d12:	01098613          	addi	a2,s3,16
80004d16:	27448513          	addi	a0,s1,628
80004d1a:	feefe0ef          	jal	ra,80003508 <z_pend_curr>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004d1e:	4421                	li	s0,8
80004d20:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004d24:	27448513          	addi	a0,s1,628
	key = (mstatus & SOC_MSTATUS_IEN);
80004d28:	8821                	andi	s0,s0,8
80004d2a:	92eff0ef          	jal	ra,80003e58 <z_spin_lock_valid>
80004d2e:	ed0d                	bnez	a0,80004d68 <z_impl_k_timer_status_sync+0x10e>
80004d30:	80006937          	lui	s2,0x80006
80004d34:	800065b7          	lui	a1,0x80006
80004d38:	80006537          	lui	a0,0x80006
80004d3c:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80004d40:	04e00693          	li	a3,78
80004d44:	ac490613          	addi	a2,s2,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004d48:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004d4c:	93afd0ef          	jal	ra,80001e86 <printk>
80004d50:	80006537          	lui	a0,0x80006
80004d54:	af450513          	addi	a0,a0,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80004d58:	92efd0ef          	jal	ra,80001e86 <printk>
80004d5c:	04e00593          	li	a1,78
80004d60:	ac490513          	addi	a0,s2,-1340
80004d64:	940fd0ef          	jal	ra,80001ea4 <assert_post_action>
	z_spin_lock_set_owner(l);
80004d68:	27448513          	addi	a0,s1,628
80004d6c:	928ff0ef          	jal	ra,80003e94 <z_spin_lock_set_owner>

			/* get updated timer status */
			key = k_spin_lock(&lock);
			result = timer->status;
80004d70:	0249a903          	lw	s2,36(s3)
		}
	} else {
		/* timer has already expired at least once */
	}

	timer->status = 0U;
80004d74:	0209a223          	sw	zero,36(s3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d78:	27448513          	addi	a0,s1,628
80004d7c:	8f6ff0ef          	jal	ra,80003e72 <z_spin_unlock_valid>
80004d80:	ed0d                	bnez	a0,80004dba <z_impl_k_timer_status_sync+0x160>
80004d82:	800064b7          	lui	s1,0x80006
80004d86:	800065b7          	lui	a1,0x80006
80004d8a:	80006537          	lui	a0,0x80006
80004d8e:	b0c58593          	addi	a1,a1,-1268 # 80005b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b0d>
80004d92:	06100693          	li	a3,97
80004d96:	ac448613          	addi	a2,s1,-1340 # 80005ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac5>
80004d9a:	a3c50513          	addi	a0,a0,-1476 # 80005a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a3d>
80004d9e:	8e8fd0ef          	jal	ra,80001e86 <printk>
80004da2:	80006537          	lui	a0,0x80006
80004da6:	b2450513          	addi	a0,a0,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
80004daa:	8dcfd0ef          	jal	ra,80001e86 <printk>
80004dae:	06100593          	li	a1,97
80004db2:	ac448513          	addi	a0,s1,-1340
80004db6:	8eefd0ef          	jal	ra,80001ea4 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004dba:	30042473          	csrrs	s0,mstatus,s0
	k_spin_unlock(&lock, key);

	return result;
}
80004dbe:	40f2                	lw	ra,28(sp)
80004dc0:	4462                	lw	s0,24(sp)
80004dc2:	854a                	mv	a0,s2
80004dc4:	44d2                	lw	s1,20(sp)
80004dc6:	4942                	lw	s2,16(sp)
80004dc8:	49b2                	lw	s3,12(sp)
80004dca:	6105                	addi	sp,sp,32
80004dcc:	8082                	ret

80004dce <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80004dce:	1141                	addi	sp,sp,-16
80004dd0:	c422                	sw	s0,8(sp)
80004dd2:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004dd4:	80006437          	lui	s0,0x80006
80004dd8:	800064b7          	lui	s1,0x80006
{
80004ddc:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004dde:	21840413          	addi	s0,s0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004de2:	21848493          	addi	s1,s1,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80004de6:	00946863          	bltu	s0,s1,80004df6 <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
80004dea:	40b2                	lw	ra,12(sp)
80004dec:	4422                	lw	s0,8(sp)
80004dee:	4492                	lw	s1,4(sp)
80004df0:	4501                	li	a0,0
80004df2:	0141                	addi	sp,sp,16
80004df4:	8082                	ret
80004df6:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80004dfa:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80004dfc:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80004dfe:	cc1c                	sw	a5,24(s0)
80004e00:	b73fc0ef          	jal	ra,80001972 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004e04:	0471                	addi	s0,s0,28
80004e06:	b7c5                	j	80004de6 <init_static_pools+0x18>

80004e08 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80004e08:	8082                	ret
