# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### TextractGenerateCSV <a name="TextractGenerateCSV" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.Initializer"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-sfn-generate-csv'

new TextractGenerateCSV(scope: Construct, id: string, props: TextractGenerateCSVProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps">TextractGenerateCSVProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps">TextractGenerateCSVProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addPrefix">addPrefix</a></code> | Add a prefix to the stateId of this state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.bindToGraph">bindToGraph</a></code> | Register this state as part of the given graph. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.toStateJson">toStateJson</a></code> | Return the Amazon States Language object for this state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addCatch">addCatch</a></code> | Add a recovery handler for this state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addRetry">addRetry</a></code> | Add retry configuration for this state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metric">metric</a></code> | Return the given named metric for this Task. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricFailed">metricFailed</a></code> | Metric for the number of times this activity fails. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricHeartbeatTimedOut">metricHeartbeatTimedOut</a></code> | Metric for the number of times the heartbeat times out for this activity. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricRunTime">metricRunTime</a></code> | The interval, in milliseconds, between the time the Task starts and the time it closes. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricScheduled">metricScheduled</a></code> | Metric for the number of times this activity is scheduled. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricScheduleTime">metricScheduleTime</a></code> | The interval, in milliseconds, for which the activity stays in the schedule state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricStarted">metricStarted</a></code> | Metric for the number of times this activity is started. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricSucceeded">metricSucceeded</a></code> | Metric for the number of times this activity succeeds. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricTime">metricTime</a></code> | The interval, in milliseconds, between the time the activity is scheduled and the time it closes. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricTimedOut">metricTimedOut</a></code> | Metric for the number of times this activity times out. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.next">next</a></code> | Continue normal execution with the given state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addPrefix` <a name="addPrefix" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addPrefix"></a>

```typescript
public addPrefix(x: string): void
```

Add a prefix to the stateId of this state.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addPrefix.parameter.x"></a>

- *Type:* string

---

##### `bindToGraph` <a name="bindToGraph" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.bindToGraph"></a>

```typescript
public bindToGraph(graph: StateGraph): void
```

Register this state as part of the given graph.

Don't call this. It will be called automatically when you work
with states normally.

###### `graph`<sup>Required</sup> <a name="graph" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.bindToGraph.parameter.graph"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.StateGraph

---

##### `toStateJson` <a name="toStateJson" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.toStateJson"></a>

```typescript
public toStateJson(): object
```

Return the Amazon States Language object for this state.

##### `addCatch` <a name="addCatch" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addCatch"></a>

```typescript
public addCatch(handler: IChainable, props?: CatchProps): TaskStateBase
```

Add a recovery handler for this state.

When a particular error occurs, execution will continue at the error
handler instead of failing the state machine execution.

###### `handler`<sup>Required</sup> <a name="handler" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addCatch.parameter.handler"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addCatch.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.CatchProps

---

##### `addRetry` <a name="addRetry" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addRetry"></a>

```typescript
public addRetry(props?: RetryProps): TaskStateBase
```

Add retry configuration for this state.

This controls if and how the execution will be retried if a particular
error occurs.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.addRetry.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.RetryProps

---

##### `metric` <a name="metric" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metric"></a>

```typescript
public metric(metricName: string, props?: MetricOptions): Metric
```

Return the given named metric for this Task.

###### `metricName`<sup>Required</sup> <a name="metricName" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metric.parameter.metricName"></a>

- *Type:* string

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metric.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricFailed` <a name="metricFailed" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricFailed"></a>

```typescript
public metricFailed(props?: MetricOptions): Metric
```

Metric for the number of times this activity fails.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricFailed.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricHeartbeatTimedOut` <a name="metricHeartbeatTimedOut" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricHeartbeatTimedOut"></a>

```typescript
public metricHeartbeatTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times the heartbeat times out for this activity.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricHeartbeatTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricRunTime` <a name="metricRunTime" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricRunTime"></a>

```typescript
public metricRunTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the Task starts and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricRunTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduled` <a name="metricScheduled" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricScheduled"></a>

```typescript
public metricScheduled(props?: MetricOptions): Metric
```

Metric for the number of times this activity is scheduled.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricScheduled.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduleTime` <a name="metricScheduleTime" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricScheduleTime"></a>

```typescript
public metricScheduleTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, for which the activity stays in the schedule state.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricScheduleTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricStarted` <a name="metricStarted" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricStarted"></a>

```typescript
public metricStarted(props?: MetricOptions): Metric
```

Metric for the number of times this activity is started.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricStarted.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricSucceeded` <a name="metricSucceeded" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricSucceeded"></a>

```typescript
public metricSucceeded(props?: MetricOptions): Metric
```

Metric for the number of times this activity succeeds.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricSucceeded.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTime` <a name="metricTime" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricTime"></a>

```typescript
public metricTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the activity is scheduled and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTimedOut` <a name="metricTimedOut" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricTimedOut"></a>

```typescript
public metricTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times this activity times out.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.metricTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `next` <a name="next" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.filterNextables">filterNextables</a></code> | Return only the states that allow chaining from an array of states. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableEndStates">findReachableEndStates</a></code> | Find the set of end states states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableStates">findReachableStates</a></code> | Find the set of states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.prefixStates">prefixStates</a></code> | Add a prefix to the stateId of all States found in a construct tree. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.isConstruct"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-sfn-generate-csv'

TextractGenerateCSV.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `filterNextables` <a name="filterNextables" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.filterNextables"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-sfn-generate-csv'

TextractGenerateCSV.filterNextables(states: State[])
```

Return only the states that allow chaining from an array of states.

###### `states`<sup>Required</sup> <a name="states" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.filterNextables.parameter.states"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State[]

---

##### `findReachableEndStates` <a name="findReachableEndStates" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableEndStates"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-sfn-generate-csv'

TextractGenerateCSV.findReachableEndStates(start: State, options?: FindStateOptions)
```

Find the set of end states states reachable through transitions from the given start state.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableEndStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableEndStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `findReachableStates` <a name="findReachableStates" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableStates"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-sfn-generate-csv'

TextractGenerateCSV.findReachableStates(start: State, options?: FindStateOptions)
```

Find the set of states reachable through transitions from the given start state.

This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.findReachableStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.prefixStates"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-sfn-generate-csv'

TextractGenerateCSV.prefixStates(root: IConstruct, prefix: string)
```

Add a prefix to the stateId of all States found in a construct tree.

###### `root`<sup>Required</sup> <a name="root" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.prefixStates.parameter.root"></a>

- *Type:* constructs.IConstruct

---

###### `prefix`<sup>Required</sup> <a name="prefix" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.prefixStates.parameter.prefix"></a>

- *Type:* string

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | Continuable states of this Chainable. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | First state of this Chainable. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.stateId">stateId</a></code> | <code>string</code> | Tokenized string that evaluates to the state's ID. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.generateCSVLambda">generateCSVLambda</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.generateCSVLogGroup">generateCSVLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.stateMachine">stateMachine</a></code> | <code>aws-cdk-lib.aws_stepfunctions.StateMachine</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

Continuable states of this Chainable.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

First state of this Chainable.

---

##### `stateId`<sup>Required</sup> <a name="stateId" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.stateId"></a>

```typescript
public readonly stateId: string;
```

- *Type:* string

Tokenized string that evaluates to the state's ID.

---

##### `generateCSVLambda`<sup>Required</sup> <a name="generateCSVLambda" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.generateCSVLambda"></a>

```typescript
public readonly generateCSVLambda: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `generateCSVLogGroup`<sup>Required</sup> <a name="generateCSVLogGroup" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.generateCSVLogGroup"></a>

```typescript
public readonly generateCSVLogGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `stateMachine`<sup>Required</sup> <a name="stateMachine" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSV.property.stateMachine"></a>

```typescript
public readonly stateMachine: StateMachine;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.StateMachine

---


## Structs <a name="Structs" id="Structs"></a>

### TextractGenerateCSVProps <a name="TextractGenerateCSVProps" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.Initializer"></a>

```typescript
import { TextractGenerateCSVProps } from 'schadem-cdk-construct-sfn-generate-csv'

const textractGenerateCSVProps: TextractGenerateCSVProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.comment">comment</a></code> | <code>string</code> | An optional description for this state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.heartbeat">heartbeat</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the heartbeat. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.inputPath">inputPath</a></code> | <code>string</code> | JSONPath expression to select part of the state to be the input to this state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.integrationPattern">integrationPattern</a></code> | <code>aws-cdk-lib.aws_stepfunctions.IntegrationPattern</code> | AWS Step Functions integrates with services directly in the Amazon States Language. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.outputPath">outputPath</a></code> | <code>string</code> | JSONPath expression to select select a portion of the state output to pass to the next state. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.resultPath">resultPath</a></code> | <code>string</code> | JSONPath expression to indicate where to inject the state's output. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.resultSelector">resultSelector</a></code> | <code>{[ key: string ]: any}</code> | The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.timeout">timeout</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the state machine. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.csvS3OutputBucket">csvS3OutputBucket</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.csvS3OutputPrefix">csvS3OutputPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.associateWithParent">associateWithParent</a></code> | <code>boolean</code> | Pass the execution ID from the context object to the execution input. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.input">input</a></code> | <code>aws-cdk-lib.aws_stepfunctions.TaskInput</code> | The JSON input for the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.lambdaLogLevel">lambdaLogLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.lambdaMemoryMB">lambdaMemoryMB</a></code> | <code>number</code> | memory of Lambda function (may need to increase for larger documents). |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.lambdaTimeout">lambdaTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.name">name</a></code> | <code>string</code> | The name of the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.outputType">outputType</a></code> | <code>string</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string
- *Default:* No comment

An optional description for this state.

---

##### `heartbeat`<sup>Optional</sup> <a name="heartbeat" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.heartbeat"></a>

```typescript
public readonly heartbeat: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the heartbeat.

---

##### `inputPath`<sup>Optional</sup> <a name="inputPath" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.inputPath"></a>

```typescript
public readonly inputPath: string;
```

- *Type:* string
- *Default:* The entire task input (JSON path '$')

JSONPath expression to select part of the state to be the input to this state.

May also be the special value JsonPath.DISCARD, which will cause the effective
input to be the empty object {}.

---

##### `integrationPattern`<sup>Optional</sup> <a name="integrationPattern" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.integrationPattern"></a>

```typescript
public readonly integrationPattern: IntegrationPattern;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.IntegrationPattern
- *Default:* `IntegrationPattern.REQUEST_RESPONSE` for most tasks. `IntegrationPattern.RUN_JOB` for the following exceptions: `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.

AWS Step Functions integrates with services directly in the Amazon States Language.

You can control these AWS services using service integration patterns

> [https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token)

---

##### `outputPath`<sup>Optional</sup> <a name="outputPath" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.outputPath"></a>

```typescript
public readonly outputPath: string;
```

- *Type:* string
- *Default:* The entire JSON node determined by the state input, the task result, and resultPath is passed to the next state (JSON path '$')

JSONPath expression to select select a portion of the state output to pass to the next state.

May also be the special value JsonPath.DISCARD, which will cause the effective
output to be the empty object {}.

---

##### `resultPath`<sup>Optional</sup> <a name="resultPath" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.resultPath"></a>

```typescript
public readonly resultPath: string;
```

- *Type:* string
- *Default:* Replaces the entire input with the result (JSON path '$')

JSONPath expression to indicate where to inject the state's output.

May also be the special value JsonPath.DISCARD, which will cause the state's
input to become its output.

---

##### `resultSelector`<sup>Optional</sup> <a name="resultSelector" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.resultSelector"></a>

```typescript
public readonly resultSelector: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* None

The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.

You can use ResultSelector to create a payload with values that are static
or selected from the state's raw result.

> [https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector)

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.timeout"></a>

```typescript
public readonly timeout: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the state machine.

---

##### `csvS3OutputBucket`<sup>Required</sup> <a name="csvS3OutputBucket" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.csvS3OutputBucket"></a>

```typescript
public readonly csvS3OutputBucket: string;
```

- *Type:* string

---

##### `csvS3OutputPrefix`<sup>Required</sup> <a name="csvS3OutputPrefix" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.csvS3OutputPrefix"></a>

```typescript
public readonly csvS3OutputPrefix: string;
```

- *Type:* string

---

##### `associateWithParent`<sup>Optional</sup> <a name="associateWithParent" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.associateWithParent"></a>

```typescript
public readonly associateWithParent: boolean;
```

- *Type:* boolean
- *Default:* false

Pass the execution ID from the context object to the execution input.

This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.

If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.

> [https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid)

---

##### `input`<sup>Optional</sup> <a name="input" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.input"></a>

```typescript
public readonly input: TaskInput;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.TaskInput
- *Default:* The state input (JSON path '$')

The JSON input for the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `lambdaLogLevel`<sup>Optional</sup> <a name="lambdaLogLevel" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.lambdaLogLevel"></a>

```typescript
public readonly lambdaLogLevel: string;
```

- *Type:* string

---

##### `lambdaMemoryMB`<sup>Optional</sup> <a name="lambdaMemoryMB" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.lambdaMemoryMB"></a>

```typescript
public readonly lambdaMemoryMB: number;
```

- *Type:* number

memory of Lambda function (may need to increase for larger documents).

---

##### `lambdaTimeout`<sup>Optional</sup> <a name="lambdaTimeout" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.lambdaTimeout"></a>

```typescript
public readonly lambdaTimeout: number;
```

- *Type:* number

---

##### `name`<sup>Optional</sup> <a name="name" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* None

The name of the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `outputType`<sup>Optional</sup> <a name="outputType" id="schadem-cdk-construct-sfn-generate-csv.TextractGenerateCSVProps.property.outputType"></a>

```typescript
public readonly outputType: string;
```

- *Type:* string

---



