# mypy-boto3-apigateway

[![PyPI - mypy-boto3-apigateway](https://img.shields.io/pypi/v/mypy-boto3-apigateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigateway)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-apigateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-apigateway)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.APIGateway 1.14.4](https://boto3.amazonaws.com/v1/documentation/api/1.14.4/reference/services/apigateway.html#APIGateway) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `APIGateway` service.

```bash
python -m pip install boto3-stubs[apigateway]
```

## How to use

### Client annotations

`APIGatewayClient` provides annotations for `boto3.client("apigateway")`.

```python
import boto3

from mypy_boto3_apigateway import APIGatewayClient
from mypy_boto3_apigateway.paginator import (
    GetApiKeysPaginator,
    GetAuthorizersPaginator,
    GetBasePathMappingsPaginator,
    GetClientCertificatesPaginator,
    GetDeploymentsPaginator,
    GetDocumentationPartsPaginator,
    GetDocumentationVersionsPaginator,
    GetDomainNamesPaginator,
    GetGatewayResponsesPaginator,
    GetModelsPaginator,
    GetRequestValidatorsPaginator,
    GetResourcesPaginator,
    GetRestApisPaginator,
    GetSdkTypesPaginator,
    GetUsagePaginator,
    GetUsagePlanKeysPaginator,
    GetUsagePlansPaginator,
    GetVpcLinksPaginator,
)
from mypy_boto3_apigateway.type_defs import AccessLogSettingsTypeDef, ...

client: APIGatewayClient = boto3.client("apigateway")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: APIGatewayClient = session.client("apigateway")
```

### Paginators annotations

`mypy_boto3_apigateway.paginator` module contains type annotations for all paginators.

```python

client: APIGatewayClient = boto3.client("apigateway")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_api_keys_paginator: GetApiKeysPaginator = client.get_paginator("get_api_keys")
get_authorizers_paginator: GetAuthorizersPaginator = client.get_paginator("get_authorizers")
get_base_path_mappings_paginator: GetBasePathMappingsPaginator = client.get_paginator("get_base_path_mappings")
get_client_certificates_paginator: GetClientCertificatesPaginator = client.get_paginator("get_client_certificates")
get_deployments_paginator: GetDeploymentsPaginator = client.get_paginator("get_deployments")
get_documentation_parts_paginator: GetDocumentationPartsPaginator = client.get_paginator("get_documentation_parts")
get_documentation_versions_paginator: GetDocumentationVersionsPaginator = client.get_paginator("get_documentation_versions")
get_domain_names_paginator: GetDomainNamesPaginator = client.get_paginator("get_domain_names")
get_gateway_responses_paginator: GetGatewayResponsesPaginator = client.get_paginator("get_gateway_responses")
get_models_paginator: GetModelsPaginator = client.get_paginator("get_models")
get_request_validators_paginator: GetRequestValidatorsPaginator = client.get_paginator("get_request_validators")
get_resources_paginator: GetResourcesPaginator = client.get_paginator("get_resources")
get_rest_apis_paginator: GetRestApisPaginator = client.get_paginator("get_rest_apis")
get_sdk_types_paginator: GetSdkTypesPaginator = client.get_paginator("get_sdk_types")
get_usage_paginator: GetUsagePaginator = client.get_paginator("get_usage")
get_usage_plan_keys_paginator: GetUsagePlanKeysPaginator = client.get_paginator("get_usage_plan_keys")
get_usage_plans_paginator: GetUsagePlansPaginator = client.get_paginator("get_usage_plans")
get_vpc_links_paginator: GetVpcLinksPaginator = client.get_paginator("get_vpc_links")
```







### Typed dictionations

`mypy_boto3_apigateway.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AccessLogSettingsTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_apigateway` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("apigateway")

session_client = boto3.Session().client("apigateway")
```
