"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsUiReactTsWebsiteProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const web_1 = require("projen/lib/web");
/**
 * Synthesizes a AWS UI React Typescript Website Project.
 *
 * @pjid awsui-react-ts-website
 */
class AwsUiReactTsWebsiteProject extends web_1.ReactTypeScriptProject {
    constructor(options) {
        super({
            ...options,
            defaultReleaseBranch: options.defaultReleaseBranch,
            name: options.name,
            sampleCode: false,
            readme: {
                contents: fs
                    .readFileSync(path.resolve(__dirname, "../README.md"))
                    .toString(),
            },
            gitignore: ["runtime-config.json"],
        });
        this.addDevDeps("@babel/plugin-proposal-private-property-in-object");
        this.addDeps("@awsui/global-styles", "@awsui/components-react", "@awsui/collection-hooks", "react-router-dom", "aws-amplify", "@aws-amplify/ui-react");
        this.applicationName = options.applicationName ?? "Sample App";
        this.publicDir = options.publicDir ?? "public";
        const srcDir = path.resolve(__dirname, "../sample/src");
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                ...Object.fromEntries(fs
                    .readdirSync(srcDir)
                    .filter((f) => f !== "config.json")
                    .map((name) => [
                    name,
                    fs.readFileSync(`${srcDir}/${name}`).toString(),
                ])),
                "config.json": JSON.stringify({
                    applicationName: this.applicationName,
                }, undefined, 2),
            },
        });
        const publicDir = path.resolve(__dirname, "../sample/public");
        new projen_1.SampleDir(this, this.publicDir, {
            sourceDir: publicDir,
            files: {
                // override index.html to pass through applicationName
                "index.html": fs
                    .readFileSync(`${publicDir}/index.html`)
                    .toString()
                    .replace("<title></title>", `<title>${this.applicationName}</title>`),
            },
        });
    }
}
exports.AwsUiReactTsWebsiteProject = AwsUiReactTsWebsiteProject;
_a = JSII_RTTI_SYMBOL_1;
AwsUiReactTsWebsiteProject[_a] = { fqn: "@aws-prototyping-sdk/awsui-react-ts-website.AwsUiReactTsWebsiteProject", version: "0.2.14" };
//# sourceMappingURL=data:application/json;base64,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