###--- Common Base URL ---###
RDFS_BASE_URL = 'http://www.w3.org/2000/01/rdf-schema#'
RDF_BASE_URL = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#'
XSD_BASE_URL = 'http://www.w3.org/2001/XMLSchema#'
OWL_BASE_URL = 'http://www.w3.org/2002/07/owl#'
UNITS_OF_MEASURE = 'http://www.ontology-of-units-of-measure.org/resource/om-2/'
W3C_TIME = 'http://www.w3.org/2006/time#'
DBPEDIA = 'https://dbpedia.org/ontology/'
SAREF = 'https://saref.etsi.org/core/'
ONTOCAPE_PHASESYSTEM = 'http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#'
ONTOCAPE_SUBSTANCE = 'http://www.theworldavatar.com/ontology/ontocape/material/substance/substance.owl#'
ONTOCAPE_REACTIONMECHANISM = 'http://www.theworldavatar.com/ontology/ontocape/material/substance/reaction_mechanism.owl#'
ONTOCAPE_MATERIAL = 'http://www.theworldavatar.com/ontology/ontocape/material/material.owl#'
ONTOCAPE_SYSTEM = 'http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#'
ONTOCAPE_BEHAVIOR = 'http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#'
ONTOUOM = 'http://theworldavatar.com/resource/ontouom/'
ONTOAGENT = 'http://www.theworldavatar.com/ontology/ontoagent/MSM.owl#'
ONTODERIVATION = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontoderivation/OntoDerivation.owl#'
ONTODOE = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontodoe/OntoDoE.owl#'
ONTORXN = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontorxn/OntoRxn.owl#'
ONTOKIN = 'http://www.theworldavatar.com/ontology/ontokin/OntoKin.owl#'
ONTOSPECIES = 'http://www.theworldavatar.com/ontology/ontospecies/OntoSpecies.owl#'
ONTOLAB = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontolab/OntoLab.owl#'
ONTOVAPOURTEC = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontovapourtec/OntoVapourtec.owl#'
ONTOHPLC = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontohplc/OntoHPLC.owl#'
ONTOBPR = 'https://github.com/cambridge-cares/TheWorldAvatar/blob/develop/JPS_Ontology/ontology/ontobpr/OntoBPR.owl#'

###--- Common PREFIX for SPARQL query ---###
PREFIX_RDFS = 'PREFIX rdfs:   <' + RDFS_BASE_URL + '> '
PREFIX_RDF = 'PREFIX rdf:    <' + RDF_BASE_URL + '> '
PREFIX_XSD = 'PREFIX xsd:    <' + XSD_BASE_URL + '> '
PREFIX_OWL = 'PREFIX owl:    <' + OWL_BASE_URL + '> '
PREFIX_OM = 'PREFIX om:     <' + UNITS_OF_MEASURE + '> '

###--- Common IRI for units of measure ---###
OM_MEASURE = UNITS_OF_MEASURE + 'Measure'
OM_HASPHENOMENON = UNITS_OF_MEASURE + 'hasPhenomenon'
OM_HASVALUE = UNITS_OF_MEASURE + 'hasValue'
OM_HASNUMERICALVALUE = UNITS_OF_MEASURE + 'hasNumericalValue'
OM_HASUNIT = UNITS_OF_MEASURE + 'hasUnit'

###--- Common IRI for Time ---###
TIME_HASTIME = W3C_TIME + 'hasTime'
TIME_NUMERICPOSITION = W3C_TIME + 'numericPosition'
TIME_HASTRS = W3C_TIME + 'hasTRS'
TIME_INTIMEPOSITION = W3C_TIME + 'inTimePosition'

###--- Common IRI for OntoAgent ---###
ONTOAGENT_HASOPERATION = ONTOAGENT + 'hasOperation'
ONTOAGENT_HASINPUT = ONTOAGENT + 'hasInput'
ONTOAGENT_HASMANDATORYPART = ONTOAGENT + 'hasMandatoryPart'
ONTOAGENT_HASTYPE = ONTOAGENT + 'hasType'
ONTOAGENT_HASNAME = ONTOAGENT + 'hasName'

###--- Common IRI for OntoDerivation ---###
ONTODERIVATION_ISDERIVEDFROM = ONTODERIVATION + 'isDerivedFrom'
ONTODERIVATION_DERIVATIONASYN = ONTODERIVATION + 'DerivationAsyn'

###--- IRIs for OntoDoE ---###
ONTODOE_DESIGNOFEXPERIMENT = ONTODOE + 'DesignOfExperiment'
ONTODOE_STRATEGY = ONTODOE + 'Strategy'
ONTODOE_TSEMO = ONTODOE + 'TSEMO'
ONTODOE_LHS = ONTODOE + 'LHS'
ONTODOE_CRITERION = ONTODOE + 'Criterion'
ONTODOE_CENTER = ONTODOE + 'Center'
ONTODOE_MAXIMUM = ONTODOE + 'Maximum'
ONTODOE_CENTERMAXIMUM = ONTODOE + 'CenterMaximum'
ONTODOE_CORRELATION = ONTODOE + 'Correlation'
ONTODOE_DOMAIN = ONTODOE + 'Domain'
ONTODOE_DESIGNVARIABLE = ONTODOE + 'DesignVariable'
ONTODOE_CONTINUOUSVARIABLE = ONTODOE + 'ContinuousVariable'
ONTODOE_CATEGORICALVARIABLE = ONTODOE + 'CategoricalVariable'
ONTODOE_SYSTEMRESPONSE = ONTODOE + 'SystemResponse'
ONTODOE_HISTORICALDATA = ONTODOE + 'HistoricalData'
ONTODOE_NEWEXPERIMENT = ONTODOE + 'NewExperiment'
ONTODOE_USESSTRATEGY = ONTODOE + 'usesStrategy'
ONTODOE_HASDOMAIN = ONTODOE + 'hasDomain'
ONTODOE_HASDESIGNVARIABLE = ONTODOE + 'hasDesignVariable'
ONTODOE_HASSYSTEMRESPONSE = ONTODOE + 'hasSystemResponse'
ONTODOE_UTILISESHISTORICALDATA = ONTODOE + 'utilisesHistoricalData'
ONTODOE_PROPOSESNEWEXPERIMENT = ONTODOE + 'proposesNewExperiment'
ONTODOE_REFERSTO = ONTODOE + 'refersTo'
ONTODOE_UPPERLIMIT = ONTODOE + 'upperLimit'
ONTODOE_LOWERLIMIT = ONTODOE + 'lowerLimit'
ONTODOE_POSITIONALID = ONTODOE + 'positionalID'
ONTODOE_MAXIMISE = ONTODOE + 'maximise'
ONTODOE_NUMOFNEWEXP = ONTODOE + 'numOfNewExp'
ONTODOE_NRETRIES = ONTODOE + 'nRetries'
ONTODOE_NSPECTRALPOINTS = ONTODOE + 'nSpectralPoints'
ONTODOE_NGENERATIONS = ONTODOE + 'nGenerations'
ONTODOE_POPULATIONSIZE = ONTODOE + 'populationSize'
ONTODOE_SEED = ONTODOE + 'seed'

###--- IRIs for OntoRxn ---###
ONTORXN_REACTIONEXPERIMENT = ONTORXN + 'ReactionExperiment'
ONTORXN_REACTIONVARIATION = ONTORXN + 'ReactionVariation'
ONTOCAPE_CHEMICALREACTION = ONTOCAPE_REACTIONMECHANISM + 'ChemicalReaction'
ONTORXN_CATALYST = ONTORXN + 'Catalyst'
ONTORXN_SOLVENT = ONTORXN + 'Solvent'
ONTOKIN_PRODUCT = ONTOKIN + 'Product'
ONTORXN_TARGETPRODUCT = ONTORXN + 'TargetProduct'
ONTORXN_IMPURITY = ONTORXN + 'Impurity'
ONTORXN_PERFORMANCEINDICATOR = ONTORXN + 'PerformanceIndicator'
ONTORXN_ENVIRONMENTALFACTOR = ONTORXN + 'EnvironmentalFactor'
ONTORXN_YIELD = ONTORXN + 'Yield'
ONTORXN_ECOSCORE = ONTORXN + 'EcoScore'
ONTORXN_CONVERSION = ONTORXN + 'Conversion'
ONTORXN_SPACETIMEYIELD = ONTORXN + 'SpaceTimeYield'
ONTORXN_RUNMATERIALCOST = ONTORXN + 'RunMaterialCost'
ONTORXN_REACTIONCONDITION = ONTORXN + 'ReactionCondition'
ONTORXN_RESIDENCETIME = ONTORXN + 'ResidenceTime'
ONTORXN_REACTIONTEMPERATURE = ONTORXN + 'ReactionTemperature'
ONTORXN_REACTIONPRESSURE = ONTORXN + 'ReactionPressure'
ONTORXN_STOICHIOMETRYRATIO = ONTORXN + 'StoichiometryRatio'
ONTORXN_REACTIONSCALE = ONTORXN + 'ReactionScale'
ONTORXN_INPUTCHEMICAL = ONTORXN + 'InputChemical'
ONTORXN_OUTPUTCHEMICAL = ONTORXN + 'OutputChemical'
ONTOCAPE_SINGLEPHASE = ONTOCAPE_PHASESYSTEM + 'SinglePhase'
ONTOCAPE_STATEOFAGGREGATION = ONTOCAPE_PHASESYSTEM + 'StateOfAggregation'
ONTOCAPE_PHASECOMPONENT = ONTOCAPE_PHASESYSTEM + 'PhaseComponent'
ONTOCAPE_COMPOSITION = ONTOCAPE_PHASESYSTEM + 'Composition'
ONTOCAPE_PHASECOMPONENTCONCENTRATION = ONTOCAPE_PHASESYSTEM + 'PhaseComponentConcentration'
ONTOCAPE_PHYSICALCONTEXT = ONTOCAPE_PHASESYSTEM + 'PhysicalContext'
ONTOCAPE_VOLUMEBASEDCONCENTRATION = ONTOCAPE_PHASESYSTEM + 'Volume-BasedConcentration'
ONTOCAPE_MOLARITY = ONTOCAPE_PHASESYSTEM + 'Molarity'
ONTOCAPE_CHEMICALSPECIES = ONTOCAPE_SUBSTANCE + 'ChemicalSpecies'
ONTORXN_HASVARIATION = ONTORXN + 'hasVariation'
ONTORXN_ISVARIATIONOF = ONTORXN + 'isVariationOf'
ONTORXN_CONDUCTEDIN = ONTORXN + 'conductedIn'
ONTORXN_ISOCCURENCEOF = ONTORXN + 'isOccurenceOf'
ONTORXN_ISREALISEDAS = ONTORXN + 'isRealisedAs'
ONTOCAPE_CATALYST = ONTOCAPE_REACTIONMECHANISM + 'hasCatalyst'
ONTORXN_HASSOLVENT = ONTORXN + 'hasSolvent'
ONTORXN_HASRXNTYPE = ONTORXN + 'hasRxnType'
ONTORXN_HASPERFORMANCEINDICATOR = ONTORXN + 'hasPerformanceIndicator'
ONTORXN_HASENVIRONMENTALFACTOR = ONTORXN + 'hasEnvironmentalFactor'
ONTORXN_HASYIELD = ONTORXN + 'hasYield'
ONTORXN_HASECOSCORE = ONTORXN + 'hasEcoScore'
ONTORXN_HASCONVERSION = ONTORXN + 'hasConversion'
ONTORXN_HASSPACETIMEYIELD = ONTORXN + 'hasSpaceTimeYield'
ONTORXN_HASRUNMATERIALCOST = ONTORXN + 'hasRunMaterialCost'
ONTORXN_HASREACTIONCONDITION = ONTORXN + 'hasReactionCondition'
ONTORXN_HASRESTIME = ONTORXN + 'hasResTime'
ONTORXN_HASRXNTEMPERATURE = ONTORXN + 'hasRxnTemperature'
ONTORXN_HASRXNPRESSURE = ONTORXN + 'hasRxnPressure'
ONTORXN_HASSTOICHIOMETRYRATIO = ONTORXN + 'hasStoichiometryRatio'
ONTORXN_HASRXNSCALE = ONTORXN + 'hasRxnScale'
ONTORXN_INDICATESMULTIPLICITYOF = ONTORXN + 'indicatesMultiplicityOf'
ONTORXN_INDICATESUSAGEOF = ONTORXN + 'indicatesUsageOf'
ONTORXN_HASINPUTCHEMICAL = ONTORXN + 'hasInputChemical'
ONTORXN_HASOUTPUTCHEMICAL = ONTORXN + 'hasOutputChemical'
ONTOCAPE_REPRESENTSTHERMODYNAMICBEHAVIOROF = ONTOCAPE_MATERIAL + 'representsThermodynamicBehaviorOf'
ONTOCAPE_THERMODYNAMICBEHAVIOR = ONTOCAPE_MATERIAL + 'thermodynamicBehavior'
ONTORXN_ISREALISATIONOF = ONTORXN + 'isRealisationOf'
ONTOCAPE_HASSTATEOFAGGREGATION = ONTOCAPE_PHASESYSTEM + 'hasStateOfAggregation'
ONTOCAPE_ISCOMPOSEDOFSUBSYSTEM = ONTOCAPE_SYSTEM + 'isComposedOfSubsystem'
ONTOCAPE_HAS_COMPOSITION = ONTOCAPE_PHASESYSTEM + 'has_composition'
ONTOCAPE_COMPRISESDIRECTLY = ONTOCAPE_SYSTEM + 'comprisesDirectly'
ONTOCAPE_HAS_PHYSICAL_CONTEXT = ONTOCAPE_PHASESYSTEM + 'has_physical_context'
ONTOCAPE_HASPROPERTY = ONTOCAPE_SYSTEM + 'hasProperty'
ONTOCAPE_REPRESENTSOCCURENCEOF = ONTOCAPE_PHASESYSTEM + 'representsOccurenceOf'
ONTORXN_HASRINCHI = ONTORXN + 'hasRInChI'
ONTORXN_HASRDFILE = ONTORXN + 'hasRDFILE'
ONTORXN_CDXML = ONTORXN + 'cdXML'
ONTORXN_RXNSMILES = ONTORXN + 'rxnSMILES'
ONTORXN_RXNCXSMILES = ONTORXN + 'rxnCXSMILES'

###--- IRIs for OntoLab ---###
ONTOCAPE_REFERSTOMATERIAL = ONTOCAPE_BEHAVIOR + 'refersToMaterial'
DBPEDIA_MANUFACTURER = DBPEDIA + 'manufacturer'
ONTOLAB_CONTAINS = ONTOLAB + 'contains'
ONTOLAB_HASARGUMENT = ONTOLAB + 'hasArgument'
ONTOLAB_HASHEIGHT = ONTOLAB + 'hasHeight'
ONTOLAB_HASLENGTH = ONTOLAB + 'hasLength'
ONTOLAB_HASPOWERSUPPLY = ONTOLAB + 'hasPowerSupply'
ONTOLAB_HASPRICE = ONTOLAB + 'hasPrice'
ONTOLAB_HASQUANTITY = ONTOLAB + 'hasQuantity'
ONTOLAB_HASSETTING = ONTOLAB + 'hasSetting'
ONTOLAB_HASWEIGHT = ONTOLAB + 'hasWeight'
ONTOLAB_HASWIDTH = ONTOLAB + 'hasWidth'
ONTOLAB_ISCONTAINEDIN = ONTOLAB + 'isContainedIn'
ONTOLAB_ISPREPAREDBY = ONTOLAB + 'isPreparedBy'
ONTOLAB_ISSPECIFIEDBY = ONTOLAB + 'isSpecifiedBy'
ONTOLAB_SPECIFIES = ONTOLAB + 'specifies'
SAREF_CONSISTSOF = SAREF + 'consistsOf'
ONTOLAB_HASARGSTR = ONTOLAB + 'hasArgStr'
ONTOLAB_HASCMDSTR = ONTOLAB + 'hasCmdStr'
OM_AMOUNTOFMONEY = UNITS_OF_MEASURE + 'AmountOfMoney'
OM_BODYMASS = UNITS_OF_MEASURE + 'BodyMass'
OM_HEIGHT = UNITS_OF_MEASURE + 'Height'
OM_LENGTH = UNITS_OF_MEASURE + 'Length'
OM_QUANTITY = UNITS_OF_MEASURE + 'Quantity'
OM_WIDTH = UNITS_OF_MEASURE + 'Width'
ONTOCAPE_MATERIALAMOUNT = ONTOCAPE_BEHAVIOR + 'MaterialAmount'
ONTOCAPE_MATERIAL = ONTOCAPE_MATERIAL + 'Material'
DBPEDIA_ORGANISATION = DBPEDIA + 'Organisation'
ONTOLAB_ARGUMENT = ONTOLAB + 'Argument'
ONTOLAB_CHEMICALSOLUTION = ONTOLAB + 'ChemicalSolution'
ONTOLAB_PREPARATIONMETHOD = ONTOLAB + 'PreparationMethod'
ONTOLAB_DRIED = ONTOLAB + 'Dried'
ONTOLAB_DURATIONSETTING = ONTOLAB + 'DurationSetting'
ONTOLAB_PARAMETERSETTING = ONTOLAB + 'ParameterSetting'
ONTOLAB_EQUIPMENTSETTINGS = ONTOLAB + 'EquipmentSettings'
ONTOLAB_LABEQUIPMENT = ONTOLAB + 'LabEquipment'
ONTOLAB_EXTERNALBATTERY = ONTOLAB + 'ExternalBattery'
ONTOLAB_EXTERNALDC = ONTOLAB + 'ExternalDC'
ONTOLAB_FLOWRATESETTING = ONTOLAB + 'FlowRateSetting'
SAREF_DEVICE = SAREF + 'Device'
ONTOLAB_LABORATORY = ONTOLAB + 'Laboratory'
ONTOLAB_LITHIUMBATTERY = ONTOLAB + 'LithiumBattery'
ONTOLAB_NIMHRECHARGEABLEBATTERY = ONTOLAB + 'NiMHRechargeableBattery'
ONTOLAB_POWERSUPPLY = ONTOLAB + 'PowerSupply'
ONTOLAB_REPURIFIED = ONTOLAB + 'Repurified'
ONTOLAB_SOLARPOWERPACK = ONTOLAB + 'SolarPowerPack'
ONTOLAB_SPARGED = ONTOLAB + 'Sparged'
ONTOLAB_SYNTHESISEDINHOUSE = ONTOLAB + 'SynthesisedInHouse'
ONTOLAB_TEMPERATURESETTING = ONTOLAB + 'TemperatureSetting'
ONTOLAB_USEDASRECEIVED = ONTOLAB + 'UsedAsReceived'
ONTOLAB_VOLUMESETTING = ONTOLAB + 'VolumeSetting'
SAREF_COMMAND = SAREF + 'Command'

###--- IRIs for OntoVapourtec ---###
ONTOVAPOURTEC_FILLS = ONTOVAPOURTEC + 'fills'
ONTOVAPOURTEC_ISFILLEDWITH = ONTOVAPOURTEC + 'isFilledWith'
ONTOVAPOURTEC_HASFILLLEVEL = ONTOVAPOURTEC + 'hasFillLevel'
ONTOVAPOURTEC_HASFLOWRATESETTING = ONTOVAPOURTEC + 'hasFlowRateSetting'
ONTOVAPOURTEC_HASINTERNALDIAMETER = ONTOVAPOURTEC + 'hasInternalDiameter'
ONTOVAPOURTEC_HASMAXLEVEL = ONTOVAPOURTEC + 'hasMaxLevel'
ONTOVAPOURTEC_HASREACTORLENGTH = ONTOVAPOURTEC + 'hasReactorLength'
ONTOVAPOURTEC_HASREACTORMATERIAL = ONTOVAPOURTEC + 'hasReactorMaterial'
ONTOVAPOURTEC_HASREACTORTEMPERATURESETTING = ONTOVAPOURTEC + 'hasReactorTemperatureSetting'
ONTOVAPOURTEC_HASREACTORVOLUME = ONTOVAPOURTEC + 'hasReactorVolume'
ONTOVAPOURTEC_HASRESIDENCETIMESETTING = ONTOVAPOURTEC + 'hasResidenceTimeSetting'
ONTOVAPOURTEC_HASSAMPLELOOPVOLUMESETTING = ONTOVAPOURTEC + 'hasSampleLoopVolumeSetting'
ONTOVAPOURTEC_HASSITE = ONTOVAPOURTEC + 'hasSite'
ONTOVAPOURTEC_HASWARNINGLEVEL = ONTOVAPOURTEC + 'hasWarningLevel'
ONTOVAPOURTEC_HOLDS = ONTOVAPOURTEC + 'holds'
ONTOVAPOURTEC_ISHELDIN = ONTOVAPOURTEC + 'isHeldIn'
ONTOVAPOURTEC_PUMPSLIQUIDFROM = ONTOVAPOURTEC + 'pumpsLiquidFrom'
SAREF_ACCOMPLISHES = SAREF + 'accomplishes'
SAREF_ACTSUPON = SAREF + 'actsUpon'
SAREF_HASCOMMAND = SAREF + 'hasCommand'
SAREF_HASFUNCTION = SAREF + 'hasFunction'
SAREF_HASSTATE = SAREF + 'hasState'
SAREF_ISACCOMPLISHEDBY = SAREF + 'isAccomplishedBy'
SAREF_ISCOMMANDOF = SAREF + 'isCommandOf'
SAREF_ISOFFEREDBY = SAREF + 'isOfferedBy'
SAREF_OFFERS = SAREF + 'offers'
SAREF_REPRESENTS = SAREF + 'represents'
OM_DIAMETER = UNITS_OF_MEASURE + 'Diameter'
OM_VOLUME = UNITS_OF_MEASURE + 'Volume'
OM_VOLUMETRICFLOWRATE = UNITS_OF_MEASURE + 'VolumetricFlowRate'
ONTOVAPOURTEC_VIAL = ONTOVAPOURTEC + 'Vial'
ONTOVAPOURTEC_AUTOSAMPLER = ONTOVAPOURTEC + 'AutoSampler'
ONTOVAPOURTEC_AUTOSAMPLERSITE = ONTOVAPOURTEC + 'AutoSamplerSite'
ONTOVAPOURTEC_AUTOSAMPLERFUNCTION = ONTOVAPOURTEC + 'AutoSamplerFunction'
ONTOVAPOURTEC_AUTOSAMPLERCOMMAND = ONTOVAPOURTEC + 'AutoSamplerCommand'
SAREF_FUNCTION = SAREF + 'Function'
ONTOVAPOURTEC_AUTOSAMPLERTASK = ONTOVAPOURTEC + 'AutoSamplerTask'
SAREF_TASK = SAREF + 'Task'
ONTOVAPOURTEC_CLEANREACTOR = ONTOVAPOURTEC + 'CleanReactor'
ONTOVAPOURTEC_VAPOURTECFUNCTION = ONTOVAPOURTEC + 'VapourtecFunction'
ONTOVAPOURTEC_CLEARREACTIONS = ONTOVAPOURTEC + 'ClearReactions'
ONTOVAPOURTEC_CLEANINGREACTION = ONTOVAPOURTEC + 'CleaningReaction'
ONTOVAPOURTEC_VAPOURTECSTATE = ONTOVAPOURTEC + 'VapourtecState'
ONTOVAPOURTEC_REACTIONCOMPLETED = ONTOVAPOURTEC + 'ReactionCompleted'
ONTOVAPOURTEC_CONNECTTOFLOWCOMMANDER = ONTOVAPOURTEC + 'ConnectToFlowCommander'
ONTOVAPOURTEC_INACTIVE = ONTOVAPOURTEC + 'Inactive'
ONTOVAPOURTEC_CONNECTION = ONTOVAPOURTEC + 'Connection'
ONTOVAPOURTEC_EXPFILEPATH = ONTOVAPOURTEC + 'ExpFilePath'
ONTOVAPOURTEC_FAULTRECOVERY = ONTOVAPOURTEC + 'FaultRecovery'
ONTOVAPOURTEC_FAULTRECOVERYCOMMAND = ONTOVAPOURTEC + 'FaultRecoveryCommand'
ONTOVAPOURTEC_FAULTY = ONTOVAPOURTEC + 'Faulty'
ONTOVAPOURTEC_FLOWCHEMISTRY = ONTOVAPOURTEC + 'FlowChemistry'
ONTOVAPOURTEC_FLOWCOMMANDER = ONTOVAPOURTEC + 'FlowCommander'
SAREF_SERVICE = SAREF + 'Service'
ONTOVAPOURTEC_VAPOURTECRS400 = ONTOVAPOURTEC + 'VapourtecRS400'
ONTOVAPOURTEC_GETCOMMAND = ONTOVAPOURTEC + 'GetCommand'
ONTOVAPOURTEC_GETSTATE = ONTOVAPOURTEC + 'GetState'
ONTOVAPOURTEC_IDLE = ONTOVAPOURTEC + 'Idle'
ONTOVAPOURTEC_LAUNCH = ONTOVAPOURTEC + 'Launch'
ONTOVAPOURTEC_STARTFLOWCOMMANDER = ONTOVAPOURTEC + 'StartFlowCommander'
ONTOVAPOURTEC_LOADEXPERIMENT = ONTOVAPOURTEC + 'LoadExperiment'
ONTOVAPOURTEC_RUNREACTOR = ONTOVAPOURTEC + 'RunReactor'
ONTOVAPOURTEC_NULL = ONTOVAPOURTEC + 'Null'
ONTOVAPOURTEC_PUMPSETTINGS = ONTOVAPOURTEC + 'PumpSettings'
ONTOVAPOURTEC_VAPOURTECR2PUMP = ONTOVAPOURTEC + 'VapourtecR2Pump'
ONTOVAPOURTEC_SAMPLELOOPVOLUMESETTING = ONTOVAPOURTEC + 'SampleLoopVolumeSetting'
ONTOVAPOURTEC_REACTORSETTING = ONTOVAPOURTEC + 'ReactorSettings'
ONTOVAPOURTEC_VAPOURTECR4REACTOR = ONTOVAPOURTEC + 'VapourtecR4Reactor'
ONTOVAPOURTEC_REACTORTEMPERATURESETTING = ONTOVAPOURTEC + 'ReactorTemperatureSetting'
ONTOVAPOURTEC_RESIDENCETIMESETTING = ONTOVAPOURTEC + 'ResidenceTimeSetting'
ONTOVAPOURTEC_RUNNINGREACTOR = ONTOVAPOURTEC + 'RunningReaction'
ONTOVAPOURTEC_VAPOURTECR2PUMPFUNCTION = ONTOVAPOURTEC + 'VapourtecR2PumpFunction'
ONTOVAPOURTEC_VAPOURTECR2PUMPCOMMAND = ONTOVAPOURTEC + 'VapourtecR2PumpCommand'
ONTOVAPOURTEC_VAPOURTECR2PUMPTASK = ONTOVAPOURTEC + 'VapourtecR2PumpTask'
ONTOVAPOURTEC_VAPOURTECR4REACTORFUNCTION = ONTOVAPOURTEC + 'VapourtecR4ReactorFunction'
ONTOVAPOURTEC_VAPOURTECR4REACTORCOMMAND = ONTOVAPOURTEC + 'VapourtecR4ReactorCommand'
ONTOVAPOURTEC_VAPOURTECR4REACTORTASK = ONTOVAPOURTEC + 'VapourtecR4ReactorTask'
SAREF_STATE = SAREF + 'State'

###--- IRIs for OntoHPLC ---###
OM_COMMONLYHASUNIT = UNITS_OF_MEASURE + 'commonlyHasUnit'
ONTOHPLC_PEAKAREA = ONTOHPLC + 'PeakArea'
ONTOUOM_MILLIABSORBANCEUNITMULTIPLIESMINUTE = ONTOUOM + 'milli_absorbance_unit_multiplies_minute'
ONTOHPLC_ATRETENTIONTIME = ONTOHPLC + 'atRetentionTime'
ONTOHPLC_GENERATEDFOR = ONTOHPLC + 'generatedFor'
ONTOHPLC_HASJOB = ONTOHPLC + 'hasJob'
ONTOHPLC_HASPEAKAREA = ONTOHPLC + 'hasPeakArea'
ONTOHPLC_HASREPORT = ONTOHPLC + 'hasReport'
ONTOHPLC_HASRESPONSEFACTOR = ONTOHPLC + 'hasResponseFactor'
ONTOHPLC_HASRETENTIONTIME = ONTOHPLC + 'hasRetentionTime'
ONTOHPLC_INDICATESCOMPONENT = ONTOHPLC + 'indicatesComponent'
ONTOHPLC_RECORDS = ONTOHPLC + 'records'
ONTOHPLC_REFERSTOSPECIES = ONTOHPLC + 'refersToSpecies'
ONTOHPLC_RESPONSEFACTOR = ONTOHPLC + 'ResponseFactor'
ONTOHPLC_RETENTIONTIME = ONTOHPLC + 'RetentionTime'
ONTOHPLC_USESINTERNALSTANDARD = ONTOHPLC + 'usesInternalStandard'
ONTOHPLC_USESMETHOD = ONTOHPLC + 'usesMethod'
ONTOHPLC_HASREPORTPATH = ONTOHPLC + 'hasReportPath'
ONTOHPLC_HPLCREPORT = ONTOHPLC + 'HPLCReport'
OM_DURATION = UNITS_OF_MEASURE + 'Duration'
OM_QUANTITYOFDIMENSIONONE = UNITS_OF_MEASURE + 'QuantityOfDimensionOne'
ONTOSPECIES_SPECIES = ONTOSPECIES + 'Species'
ONTOHPLC_CHROMATOGRAMMEASUREMENT = ONTOHPLC + 'ChromatogramMeasurement'
ONTOHPLC_CHROMATOGRAMMEASUREMENTCOMMAND = ONTOHPLC + 'ChromatogramMeasurementCommand'
ONTOHPLC_CHROMATOGRAMPOINT = ONTOHPLC + 'ChromatogramPoint'
ONTOHPLC_HPLCJOB = ONTOHPLC + 'HPLCJob'
ONTOHPLC_HPLCMETHOD = ONTOHPLC + 'HPLCMethod'
ONTOHPLC_INTERNALSTANDARD = ONTOHPLC + 'InternalStandard'
ONTOHPLC_HIGHPERFORMANCELIQUIDCHROMATOGRAPHY = ONTOHPLC + 'HighPerformanceLiquidChromatography'
ONTOHPLC_LIQUIDCHROMATOGRAPHY = ONTOHPLC + 'LiquidChromatography'

###--- IRIs for OntoBPR ---###
ONTOBPR_BACKPRESSUREREGULATOR = ONTOBPR + 'BackPressureRegulator'
ONTOBPR_REACTORPRESSURECONTROL = ONTOBPR + 'ReactorPressureControl'
ONTOBPR_PRESSUREADJUSTMENT = ONTOBPR + 'PressureAdjustment'
ONTOBPR_PRESSUREADJUSTMENTCOMMAND = ONTOBPR + 'PressureAdjustmentCommand'
