# django-cascading-dropdown-widget

Provide a cascading-dropdown widget for django.

## Install

```shell
pip install django-cascading-dropdown-widget
```

## Usage

**pro/settings.py**

**Note:**

- The application used static file jquery3/jquery.js, so MUST include django_static_jquery3 in INSTALLED_APPS.
- The application used template of django_cascading_dropdown_widget, so MUST include django_cascading_dropdown_widget in INSTALLED_APPS.

```python
INSTALLED_APPS = [
    ...
    'django_static_jquery3',
    'django_cascading_dropdown_widget',
    ...
]
```

**app/admin.py**

**Note:**

- Create a new ModelForm, and setting field widget to DjangoCascadingDropdownWidget.
- Create a choices generator instance.

```python
from django.contrib import admin
from django_cascading_dropdown_widget.widgets import DjangoCascadingDropdownWidget
from django_cascading_dropdown_widget.widgets import CascadingModelchoices
from django import forms
from .models import Category
from .models import Book
from .models import Character

class CharacterForm(forms.ModelForm):
    class Meta:
        model = Category
        exclude = []
        widgets = {
            "book": DjangoCascadingDropdownWidget(choices=CascadingModelchoices({
                "model": Category,
                "related_name": "books",
            },{
                "model": Book,
                "fk_name": "category",
            })),
        }

class CharacterAdmin(admin.ModelAdmin):
    form = CharacterForm
    list_display = ["name", "book"]
```

## Choices generator

### CascadingModelchoices

```python
class CascadingModelchoices(object):

    def __init__(self, *cascadings):
        ...
```
The parameters for CascadingModelchoices generator are the CASCADING-MODEL-SETTINGS(name it cascadings for short). A MODEL-SETTING(name it cascading for short)'s config items are:

- model, required. The Model class.
- related_name, required but except for the last model-setting. Use the related_name to get the queryset of the next level items.
- fk_name, required but except for the first model-setting. Which field name to get parent model.
- empty, optional. Use *empty* string instread of '----- xxx ----' in select for empty value.
- str, optional. Get item title from *str* method or property instread of get title by *str(item)*.

### SimpleChoices
### SimpleChoices2 (alias)

```python
class SimpleChoices(object):

    def __init__(self, *cascadings, empty1="-"*10, empty2="-"*10):
        ...
```

- A cascading is a tuple of (Title1, List).
- The Title1 is the first level option.
- The List is the second level selector. The List item is a tuple of (Value2, Title2).
- The Value2 is the second level option's value.
- The Title2 is the second level option's title.

### MPTTModel Choices

- Use CascadingModelchoices for the generator.
- Create *indented_title* function for the MPTTModel. You use whatever name for the *indented_title*.

    ```
    class MyModel(MPTTModel):
        def indented_title(self):
            return ("-"*4) * self.get_level() + self.name
    ```

- Setting ```"str": "indented_title"``` in cascading.
- The application django-cascading-dropdown-widget is NOT required django-mptt, so install django-mptt by youself. We have did try...except... with django-mptt's missing.

## Releases

### v0.2.0 2020/03/23

- Add SimpleChoices generator.
- Add `white-space: nowrap;` for django-cascading-dropdown-widget.

### v0.1.0 2020/03/16

- Fisrt release.