"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.views = self.__class__.views(path + ["views"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        super().__init__(path, service)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            self.vrx_sound_analysis = self.__class__.vrx_sound_analysis(path + ["vrx_sound_analysis"], service)
            super().__init__(path, service)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)

        class vrx_sound_analysis(TUIMenu):
            """
            Ansys Sound analysis and specification.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_indicators(self, *args, **kwargs):
                """
                Print Ansys Sound indicators.
                """
                return PyMenu(self.service, "/plot/vrx_sound_analysis/print_indicators").execute(*args, **kwargs)
            def write_files(self, *args, **kwargs):
                """
                Write Ansys Sound out files.
                """
                return PyMenu(self.service, "/plot/vrx_sound_analysis/write_files").execute(*args, **kwargs)

    class surface(TUIMenu):
        """
        Enter the data surface manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
            self.query = self.__class__.query(path + ["query"], service)
            super().__init__(path, service)
        def imprint_surface(self, *args, **kwargs):
            """
            Enters the list of surfaces to imprint from and the name of the new imprinted surface.
            """
            return PyMenu(self.service, "/surface/imprint_surface").execute(*args, **kwargs)
        def line_slice(self, *args, **kwargs):
            """
            Extracts a linear slice in 2D, given the normal to the line and a distance from the origin.
            """
            return PyMenu(self.service, "/surface/line_slice").execute(*args, **kwargs)
        def rename_surface(self, *args, **kwargs):
            """
            Renames a defined data surface.
            """
            return PyMenu(self.service, "/surface/rename_surface").execute(*args, **kwargs)
        def iso_surface(self, *args, **kwargs):
            """
            Extracts an iso-surface (surface, curve, or point) from the current data field.
            """
            return PyMenu(self.service, "/surface/iso_surface").execute(*args, **kwargs)
        def point_array(self, *args, **kwargs):
            """
            Extracts a rectangular array of data points.
            """
            return PyMenu(self.service, "/surface/point_array").execute(*args, **kwargs)
        def cone_slice(self, *args, **kwargs):
            """
            Extract a cone slice.
            """
            return PyMenu(self.service, "/surface/cone_slice").execute(*args, **kwargs)
        def plane_slice(self, *args, **kwargs):
            """
            Extracts a planar slice.
            """
            return PyMenu(self.service, "/surface/plane_slice").execute(*args, **kwargs)
        def line_surface(self, *args, **kwargs):
            """
            Defines a “line" surface by specifying the two endpoint coordinates.
            """
            return PyMenu(self.service, "/surface/line_surface").execute(*args, **kwargs)
        def plane_view_plane_align(self, *args, **kwargs):
            """
            Create a plane aligned to a view-plane.
            """
            return PyMenu(self.service, "/surface/plane_view_plane_align").execute(*args, **kwargs)
        def structural_point_surface(self, *args, **kwargs):
            """
            Defines a structural “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/structural_point_surface").execute(*args, **kwargs)
        def plane(self, *args, **kwargs):
            """
            Create a plane given 3 points bounded by the domain.
            """
            return PyMenu(self.service, "/surface/plane").execute(*args, **kwargs)
        def edit_surface(self, *args, **kwargs):
            """
            Allows you to edit any of the listed available surfaces.
            """
            return PyMenu(self.service, "/surface/edit_surface").execute(*args, **kwargs)
        def zone_surface(self, *args, **kwargs):
            """
            Creates a surface of a designated zone and gives it a specified name.
            """
            return PyMenu(self.service, "/surface/zone_surface").execute(*args, **kwargs)
        def mouse_plane(self, *args, **kwargs):
            """
            Extracts a planar surface defined by selecting three points with the mouse.
            """
            return PyMenu(self.service, "/surface/mouse_plane").execute(*args, **kwargs)
        def reset_zone_surfaces(self, *args, **kwargs):
            """
            Recreates missing surface zones by resetting the case surface list.
            """
            return PyMenu(self.service, "/surface/reset_zone_surfaces").execute(*args, **kwargs)
        def ungroup_surface(self, *args, **kwargs):
            """
            Ungroup the surface(if grouped).
            """
            return PyMenu(self.service, "/surface/ungroup_surface").execute(*args, **kwargs)
        def partition_surface(self, *args, **kwargs):
            """
            Defines a data surface consisting of mesh faces on the partition boundary.
            """
            return PyMenu(self.service, "/surface/partition_surface").execute(*args, **kwargs)
        def ellipsoid_slice(self, *args, **kwargs):
            """
            Extract a ellipsoid slice.
            """
            return PyMenu(self.service, "/surface/ellipsoid_slice").execute(*args, **kwargs)
        def mouse_rake(self, *args, **kwargs):
            """
            Extracts a “rake" surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_rake").execute(*args, **kwargs)
        def transform_surface(self, *args, **kwargs):
            """
            Transforms surface.
            """
            return PyMenu(self.service, "/surface/transform_surface").execute(*args, **kwargs)
        def iso_clip(self, *args, **kwargs):
            """
            Clips a data surface (surface, curve, or point) between two isovalues.
            """
            return PyMenu(self.service, "/surface/iso_clip").execute(*args, **kwargs)
        def surface_cells(self, *args, **kwargs):
            """
            Extracts all cells intersected by a data surface.
            """
            return PyMenu(self.service, "/surface/surface_cells").execute(*args, **kwargs)
        def surface_priority(self, *args, **kwargs):
            """
            Define Priority for given surface
            id.
            """
            return PyMenu(self.service, "/surface/surface_priority").execute(*args, **kwargs)
        def quadric_slice(self, *args, **kwargs):
            """
            Extracts a quadric slice.
            """
            return PyMenu(self.service, "/surface/quadric_slice").execute(*args, **kwargs)
        def create_imprint_surface(self, *args, **kwargs):
            """
            Imprint surface.
            """
            return PyMenu(self.service, "/surface/create_imprint_surface").execute(*args, **kwargs)
        def mouse_line(self, *args, **kwargs):
            """
            Extracts a line surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_line").execute(*args, **kwargs)
        def closest_point_search(self, *args, **kwargs):
            """
            Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
            """
            return PyMenu(self.service, "/surface/closest_point_search").execute(*args, **kwargs)
        def multiple_plane_surfaces(self, *args, **kwargs):
            """
            Creates multiple planes at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_plane_surfaces").execute(*args, **kwargs)
        def plane_bounded(self, *args, **kwargs):
            """
            Create a bounded surface.
            """
            return PyMenu(self.service, "/surface/plane_bounded").execute(*args, **kwargs)
        def plane_surf_aligned(self, *args, **kwargs):
            """
            Create a plane aligned to a surface.
            """
            return PyMenu(self.service, "/surface/plane_surf_aligned").execute(*args, **kwargs)
        def multiple_zone_surfaces(self, *args, **kwargs):
            """
            Creates multiple data surfaces at one time. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_zone_surfaces").execute(*args, **kwargs)
        def expression_volume(self, *args, **kwargs):
            """
            Create volume with boolean expression.
            """
            return PyMenu(self.service, "/surface/expression_volume").execute(*args, **kwargs)
        def list_surfaces(self, *args, **kwargs):
            """
            Displays the ID and name, and the number of point, curve, and surface facets of the current surfaces.
            """
            return PyMenu(self.service, "/surface/list_surfaces").execute(*args, **kwargs)
        def rake_surface(self, *args, **kwargs):
            """
            Extracts a “rake" surface, given the coordinates of the endpoints.
            """
            return PyMenu(self.service, "/surface/rake_surface").execute(*args, **kwargs)
        def multiple_iso_surfaces(self, *args, **kwargs):
            """
            Creates multiple iso-surfaces at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_iso_surfaces").execute(*args, **kwargs)
        def point_surface(self, *args, **kwargs):
            """
            Defines a “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/point_surface").execute(*args, **kwargs)
        def delete_surface(self, *args, **kwargs):
            """
            Removes a defined data surface.
            """
            return PyMenu(self.service, "/surface/delete_surface").execute(*args, **kwargs)
        def circle_slice(self, *args, **kwargs):
            """
            Extracts a circular slice.
            """
            return PyMenu(self.service, "/surface/circle_slice").execute(*args, **kwargs)
        def iso_clip_multiple(self, *args, **kwargs):
            """
            Clip a data surface (surface, curve, or point) between two iso-values.
            """
            return PyMenu(self.service, "/surface/iso_clip_multiple").execute(*args, **kwargs)
        def plane_surface(self, *args, **kwargs):
            """
            Create a plane from a coordinate plane, point and normal, or three points.
            """
            return PyMenu(self.service, "/surface/plane_surface").execute(*args, **kwargs)
        def group_surfaces(self, *args, **kwargs):
            """
            Group a set of surfaces.
            """
            return PyMenu(self.service, "/surface/group_surfaces").execute(*args, **kwargs)
        def sphere_slice(self, *args, **kwargs):
            """
            Extracts a spherical slice.
            """
            return PyMenu(self.service, "/surface/sphere_slice").execute(*args, **kwargs)
        def plane_point_n_normal(self, *args, **kwargs):
            """
            Create a plane from a point and normal.
            """
            return PyMenu(self.service, "/surface/plane_point_n_normal").execute(*args, **kwargs)

        class post_processing_volume(TUIMenu):
            """
            Enter post-processing volume menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def create_octree(self, *args, **kwargs):
                """
                Create post-processing octree mesh based on current case.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_octree").execute(*args, **kwargs)
            def create_from_file(self, *args, **kwargs):
                """
                Read post-processing mesh from file.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)

        class query(TUIMenu):
            """
            Enter surface query menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_named_selection(self, *args, **kwargs):
                """
                List named selection of surface type.
                """
                return PyMenu(self.service, "/surface/query/list_named_selection").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List surfaces.
                """
                return PyMenu(self.service, "/surface/query/list_surfaces").execute(*args, **kwargs)
            def list_queries(self, *args, **kwargs):
                """
                List all saved queries.
                """
                return PyMenu(self.service, "/surface/query/list_queries").execute(*args, **kwargs)
            def named_surface_list(self, *args, **kwargs):
                """
                Create named list of surfaces.
                """
                return PyMenu(self.service, "/surface/query/named_surface_list").execute(*args, **kwargs)
            def delete_query(self, *args, **kwargs):
                """
                Delete saved query.
                """
                return PyMenu(self.service, "/surface/query/delete_query").execute(*args, **kwargs)

    class turbo_post(TUIMenu):
        """
        Enter the turbo menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def two_d_contours(self, *args, **kwargs):
            """
            Display 2d contours.
            """
            return PyMenu(self.service, "/turbo_post/two_d_contours").execute(*args, **kwargs)
        def avg_contours(self, *args, **kwargs):
            """
            Displays average contours.
            """
            return PyMenu(self.service, "/turbo_post/avg_contours").execute(*args, **kwargs)
        def compute_report(self, *args, **kwargs):
            """
            Computes turbomachinery quantities.
            """
            return PyMenu(self.service, "/turbo_post/compute_report").execute(*args, **kwargs)
        def current_topology(self, *args, **kwargs):
            """
            Sets the current turbo topology for global use.
            """
            return PyMenu(self.service, "/turbo_post/current_topology").execute(*args, **kwargs)
        def xy_plot_avg(self, *args, **kwargs):
            """
            Displays average XY plots.
            """
            return PyMenu(self.service, "/turbo_post/xy_plot_avg").execute(*args, **kwargs)
        def write_report(self, *args, **kwargs):
            """
            Writes the turbo report to file.
            """
            return PyMenu(self.service, "/turbo_post/write_report").execute(*args, **kwargs)

    class server(TUIMenu):
        """
        Enter the server menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def print_connected_clients(self, *args, **kwargs):
            """
            Prints the name of the connected client and its IP address to the console.
            """
            return PyMenu(self.service, "/server/print_connected_clients").execute(*args, **kwargs)
        def start_web_server(self, *args, **kwargs):
            """
            Start web server.
            """
            return PyMenu(self.service, "/server/start_web_server").execute(*args, **kwargs)
        def stop_web_server(self, *args, **kwargs):
            """
            Stop web server.
            """
            return PyMenu(self.service, "/server/stop_web_server").execute(*args, **kwargs)
        def shutdown_server(self, *args, **kwargs):
            """
            Shuts-down the server and disconnects the connected client.
            """
            return PyMenu(self.service, "/server/shutdown_server").execute(*args, **kwargs)
        def print_server_address(self, *args, **kwargs):
            """
            Prints the host address and port number of the server to the console.
            """
            return PyMenu(self.service, "/server/print_server_address").execute(*args, **kwargs)
        def start_server(self, *args, **kwargs):
            """
            Starts the server for the ANSYS Fluent remote visualization client.
            """
            return PyMenu(self.service, "/server/start_server").execute(*args, **kwargs)
        def print_web_server_info(self, *args, **kwargs):
            """
            Print web server information.
            """
            return PyMenu(self.service, "/server/print_web_server_info").execute(*args, **kwargs)
        def write_or_reset_server_info(self, *args, **kwargs):
            """
            Allows you to create a new server_info.txt file (with any name you specify), which resets the password for connecting to this server session. It does not restart the server.
            """
            return PyMenu(self.service, "/server/write_or_reset_server_info").execute(*args, **kwargs)
        def start_client(self, *args, **kwargs):
            """
            Start the ANSYS Fluent remote visualization client.
            """
            return PyMenu(self.service, "/server/start_client").execute(*args, **kwargs)

    class solution(TUIMenu):
        """
        Enter solution menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.calculation_activities = self.__class__.calculation_activities(path + ["calculation_activities"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.methods = self.__class__.methods(path + ["methods"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.run_calculation = self.__class__.run_calculation(path + ["run_calculation"], service)
            self.controls = self.__class__.controls(path + ["controls"], service)
            super().__init__(path, service)

        class monitors(TUIMenu):
            """
            Enter the monitors menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.surface = self.__class__.surface(path + ["surface"], service)
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.statistic = self.__class__.statistic(path + ["statistic"], service)
                self.convergence = self.__class__.convergence(path + ["convergence"], service)
                self.volume = self.__class__.volume(path + ["volume"], service)
                self.force = self.__class__.force(path + ["force"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                super().__init__(path, service)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solution/monitors/convergence_conditions").execute(*args, **kwargs)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solution/monitors/set_average_over").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/plot").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/add").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/edit").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/curves").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list").execute(*args, **kwargs)
                def get_window_id(self, *args, **kwargs):
                    """
                    Get report-plot object window id.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/get_window_id").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/axes").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete_all").execute(*args, **kwargs)

            class surface(TUIMenu):
                """
                Enter the surface menu to set integrated scalar quantities on surface(s) monitors.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.curves = self.__class__.curves(path + ["curves"], service)
                    super().__init__(path, service)
                def set_monitor(self, *args, **kwargs):
                    """
                    Define or modify a surface monitor.
                    """
                    return PyMenu(self.service, "/solution/monitors/surface/set_monitor").execute(*args, **kwargs)
                def list_monitors(self, *args, **kwargs):
                    """
                    List defined surface monitors.
                    """
                    return PyMenu(self.service, "/solution/monitors/surface/list_monitors").execute(*args, **kwargs)
                def clear_monitors(self, *args, **kwargs):
                    """
                    Remove all defined surface monitors.
                    """
                    return PyMenu(self.service, "/solution/monitors/surface/clear_monitors").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear current surface monitor data.
                    """
                    return PyMenu(self.service, "/solution/monitors/surface/clear_data").execute(*args, **kwargs)

                class curves(TUIMenu):
                    """
                    Enter the curves menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def lines(self, *args, **kwargs):
                        """
                        Set lines parameters for surface monitors.
                        """
                        return PyMenu(self.service, "/solution/monitors/surface/curves/lines").execute(*args, **kwargs)
                    def markers(self, *args, **kwargs):
                        """
                        Set markers parameters for surface monitors.
                        """
                        return PyMenu(self.service, "/solution/monitors/surface/curves/markers").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/edit").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/clear_data").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/add").execute(*args, **kwargs)

            class statistic(TUIMenu):
                """
                Enter the statistic monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def monitors(self, *args, **kwargs):
                    """
                    Choose which statistics to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/statistic/monitors").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Enable/disable plotting of statistics during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/statistic/plot").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Enable/disable printing of statistics during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/statistic/print").execute(*args, **kwargs)
                def x_axis(self, *args, **kwargs):
                    """
                    Choose what quantity to use on the abscissa in the plot and in the data written to files.
                    """
                    return PyMenu(self.service, "/solution/monitors/statistic/x_axis").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Enable/disable writing of statistics during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/statistic/write").execute(*args, **kwargs)
                def file_basename(self, *args, **kwargs):
                    """
                    Specify the file basename and extension. The name of the individual monitor will be insterted automatically.
                    """
                    return PyMenu(self.service, "/solution/monitors/statistic/file_basename").execute(*args, **kwargs)
                def window(self, *args, **kwargs):
                    """
                    Specify first window in which statistics will be plotted during iteration.
                    Multiple statistics are plotted in separate windows, beginning with this one.
                    """
                    return PyMenu(self.service, "/solution/monitors/statistic/window").execute(*args, **kwargs)

            class convergence(TUIMenu):
                """
                Enter the convergence menu to add surface, volume, drag, lift and moment monitors to convergence criteria.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def average_over_last_n_iterations_timesteps(self, *args, **kwargs):
                    """
                    Option to average over previous values for checking convergence.
                    """
                    return PyMenu(self.service, "/solution/monitors/convergence/average_over_last_n_iterations_timesteps").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List defined convergence criteria for monitors.
                    """
                    return PyMenu(self.service, "/solution/monitors/convergence/list").execute(*args, **kwargs)
                def frequency(self, *args, **kwargs):
                    """
                    To set how often convergence checks are done with respect to iterations or time steps.
                    """
                    return PyMenu(self.service, "/solution/monitors/convergence/frequency").execute(*args, **kwargs)
                def condition(self, *args, **kwargs):
                    """
                    Option to stop the calculations. All convergence conditions are met or any convergence condition is met.
                    """
                    return PyMenu(self.service, "/solution/monitors/convergence/condition").execute(*args, **kwargs)
                def add_edit(self, *args, **kwargs):
                    """
                    Add or edit convergence criterion for surface, volume, drag, lift and moment monitors.
                    """
                    return PyMenu(self.service, "/solution/monitors/convergence/add_edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a monitor from convergence criteria.
                    """
                    return PyMenu(self.service, "/solution/monitors/convergence/delete").execute(*args, **kwargs)

            class volume(TUIMenu):
                """
                Enter the volume menu to set integrated scalar quantities on volume(s) monitors.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_monitors(self, *args, **kwargs):
                    """
                    List defined volume monitors.
                    """
                    return PyMenu(self.service, "/solution/monitors/volume/list_monitors").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear current volume monitor data.
                    """
                    return PyMenu(self.service, "/solution/monitors/volume/clear_data").execute(*args, **kwargs)
                def set_monitor(self, *args, **kwargs):
                    """
                    Define or modify a volume monitor.
                    """
                    return PyMenu(self.service, "/solution/monitors/volume/set_monitor").execute(*args, **kwargs)
                def clear_monitors(self, *args, **kwargs):
                    """
                    Remove all defined volume monitors.
                    """
                    return PyMenu(self.service, "/solution/monitors/volume/clear_monitors").execute(*args, **kwargs)

            class force(TUIMenu):
                """
                Enter the force monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def moment_coefficient(self, *args, **kwargs):
                    """
                    Set variables for monitoring the moment coefficient.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/moment_coefficient").execute(*args, **kwargs)
                def set_lift_monitor(self, *args, **kwargs):
                    """
                    Set variables for monitoring the lift coefficient.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/set_lift_monitor").execute(*args, **kwargs)
                def list_monitors(self, *args, **kwargs):
                    """
                    List defined force monitors.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/list_monitors").execute(*args, **kwargs)
                def clear_monitors(self, *args, **kwargs):
                    """
                    Clear all or specified monitor data.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/clear_monitors").execute(*args, **kwargs)
                def clear_all_monitors_data(self, *args, **kwargs):
                    """
                    Clear all monitoring data.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/clear_all_monitors_data").execute(*args, **kwargs)
                def unscaled(self, *args, **kwargs):
                    """
                    Specify whether unscaled values are desired.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/unscaled").execute(*args, **kwargs)
                def clear_moment_monitor_data(self, *args, **kwargs):
                    """
                    Clear the moment monitoring data.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/clear_moment_monitor_data").execute(*args, **kwargs)
                def drag_coefficient(self, *args, **kwargs):
                    """
                    Set variables for monitoring the drag coefficient.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/drag_coefficient").execute(*args, **kwargs)
                def lift_coefficient(self, *args, **kwargs):
                    """
                    Set variables for monitoring the lift coefficient.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/lift_coefficient").execute(*args, **kwargs)
                def clear_drag_monitor_data(self, *args, **kwargs):
                    """
                    Clear the drag monitoring data.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/clear_drag_monitor_data").execute(*args, **kwargs)
                def clear_lift_monitor_data(self, *args, **kwargs):
                    """
                    Clear the lift monitoring data.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/clear_lift_monitor_data").execute(*args, **kwargs)
                def monitor_unsteady_iters(self, *args, **kwargs):
                    """
                    Specify whether monitors are updated every iteration or every time step for transient calculations.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/monitor_unsteady_iters").execute(*args, **kwargs)
                def set_moment_monitor(self, *args, **kwargs):
                    """
                    Set variables for monitoring the moment coefficient.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/set_moment_monitor").execute(*args, **kwargs)
                def set_drag_monitor(self, *args, **kwargs):
                    """
                    Set variables for monitoring the drag coefficient.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/set_drag_monitor").execute(*args, **kwargs)
                def delete_monitors(self, *args, **kwargs):
                    """
                    Delete the specified monitor.
                    """
                    return PyMenu(self.service, "/solution/monitors/force/delete_monitors").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enter the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def n_display(self, *args, **kwargs):
                    """
                    Set the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_display").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Renormalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/re_normalize").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Choose which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/monitor").execute(*args, **kwargs)
                def window(self, *args, **kwargs):
                    """
                    Specify window in which residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/window").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Delete the residual history and reset iteration counter to unity.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/reset").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Choose whether or not to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalize").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Set relative convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Set convergence criterion type.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/criterion_type").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Set convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Enable/disable scaling of residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/plot").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Choose which currently-monitored residuals
                    should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/check_convergence").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Set normalization factors for currently-monitored residuals.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Set the number of iterations through which normalization
                    factors will be maximized.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Scale the continuity residuals locally based on the enhanced formulation.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/print").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Set number of residuals to be saved with data.
                    History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_save").execute(*args, **kwargs)

        class calculation_activities(TUIMenu):
            """
            Enter calculation activities menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
                self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
                self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
                self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
                self.animate = self.__class__.animate(path + ["animate"], service)
                super().__init__(path, service)

            class solution_strategy(TUIMenu):
                """
                Enter the automatic initialization and case modification strategy menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.automatic_case_modification = self.__class__.automatic_case_modification(path + ["automatic_case_modification"], service)
                    super().__init__(path, service)
                def import_modifications(self, *args, **kwargs):
                    """
                    Import a list of case modifications from a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/import_modifications").execute(*args, **kwargs)
                def disable_modification(self, *args, **kwargs):
                    """
                    Disable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/disable_modification").execute(*args, **kwargs)
                def copy_modification(self, *args, **kwargs):
                    """
                    Copy a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/copy_modification").execute(*args, **kwargs)
                def continue_strategy_execution(self, *args, **kwargs):
                    """
                    Continue execution of the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/continue_strategy_execution").execute(*args, **kwargs)
                def export_modifications(self, *args, **kwargs):
                    """
                    Export all case modifications to a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/export_modifications").execute(*args, **kwargs)
                def enable_modification(self, *args, **kwargs):
                    """
                    Enable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_modification").execute(*args, **kwargs)
                def automatic_initialization(self, *args, **kwargs):
                    """
                    Define how the case is to be initialized automatically.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_initialization").execute(*args, **kwargs)
                def add_edit_modification(self, *args, **kwargs):
                    """
                    Define a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/add_edit_modification").execute(*args, **kwargs)
                def execute_strategy(self, *args, **kwargs):
                    """
                    Execute the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/execute_strategy").execute(*args, **kwargs)
                def delete_modification(self, *args, **kwargs):
                    """
                    Delete a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/delete_modification").execute(*args, **kwargs)
                def enable_strategy(self, *args, **kwargs):
                    """
                    Specify whether automatic initialization and case modification should be enabled.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_strategy").execute(*args, **kwargs)

                class automatic_case_modification(TUIMenu):
                    """
                    Define how the case is to be modified as the solution progresses.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def original_settings(self, *args, **kwargs):
                        """
                        Specify modification to be performed after initialization to restore to original settings.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/original_settings").execute(*args, **kwargs)
                    def modifications(self, *args, **kwargs):
                        """
                        Specify modifications to be performed during solution.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/modifications").execute(*args, **kwargs)
                    def before_init_modification(self, *args, **kwargs):
                        """
                        Specify modification to be performed before initialization.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/before_init_modification").execute(*args, **kwargs)

            class cell_register_operations(TUIMenu):
                """
                Manage Cell Register Operations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list_properties").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/add").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/edit").execute(*args, **kwargs)

            class auto_save(TUIMenu):
                """
                Enter the auto save menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def retain_most_recent_files(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/retain_most_recent_files").execute(*args, **kwargs)
                def max_files(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/max_files").execute(*args, **kwargs)
                def case_frequency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/case_frequency").execute(*args, **kwargs)
                def root_name(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/root_name").execute(*args, **kwargs)
                def data_frequency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/data_frequency").execute(*args, **kwargs)
                def append_file_name_with(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/append_file_name_with").execute(*args, **kwargs)
                def save_data_file_every(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/save_data_file_every").execute(*args, **kwargs)

            class execute_commands(TUIMenu):
                """
                Enter the execute-monitor-commands menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/delete").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/enable").execute(*args, **kwargs)
                def add_edit(self, *args, **kwargs):
                    """
                    Add or edit execute-commands.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/add_edit").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/copy").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/disable").execute(*args, **kwargs)
                def import_(self, *args, **kwargs):
                    """
                    Import execute-commands from a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/import").execute(*args, **kwargs)
                def export(self, *args, **kwargs):
                    """
                    Export execute-commands to a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/export").execute(*args, **kwargs)

            class animate(TUIMenu):
                """
                Enter the animation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.define = self.__class__.define(path + ["define"], service)
                    self.objects = self.__class__.objects(path + ["objects"], service)
                    super().__init__(path, service)

                class define(TUIMenu):
                    """
                    Enter the animation definition menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def define_monitor(self, *args, **kwargs):
                        """
                        Define new animation.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/define_monitor").execute(*args, **kwargs)
                    def edit_monitor(self, *args, **kwargs):
                        """
                        Change animation monitor attributes.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/edit_monitor").execute(*args, **kwargs)

                class objects(TUIMenu):
                    """
                    Enter to define, edit, delete solution animation objects.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def create(self, *args, **kwargs):
                        """
                        Create new graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/create").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        Copy graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/copy").execute(*args, **kwargs)
                    def get_window_id(self, *args, **kwargs):
                        """
                        Get animation object window id.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/get_window_id").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/edit").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/delete").execute(*args, **kwargs)
                    def clear_history(self, *args, **kwargs):
                        """
                        Clear object history.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/clear_history").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Manage report definitions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/list_properties").execute(*args, **kwargs)
            def convert_monitors_to_report_defns(self, *args, **kwargs):
                """
                Converts all monitors to Report Definitions and create new Report Sets/Plot Sets if required.
                """
                return PyMenu(self.service, "/solution/report_definitions/convert_monitors_to_report_defns").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all report definition objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete_all").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Makes a copy of selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/copy").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/list").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/rename").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/report_definitions/add").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solution/report_definitions/compute").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Manage Cell Registers.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/coarsen").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/delete").execute(*args, **kwargs)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/adapt").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/refine").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/list").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/cell_registers/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/edit").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Apply poor mesh numerics to cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/display").execute(*args, **kwargs)

        class methods(TUIMenu):
            """
            Enter the methods menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.query = self.__class__.query(path + ["query"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                super().__init__(path, service)
            def residual_smoothing(self, *args, **kwargs):
                """
                Set residual smoothing factor and number of iterations.
                """
                return PyMenu(self.service, "/solution/methods/residual_smoothing").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enable convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solution/methods/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Set phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solution/methods/phase_based_vof_discretization").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Set ggnb options.
                """
                return PyMenu(self.service, "/solution/methods/nb_gradient_boundary_option").execute(*args, **kwargs)
            def pseudo_relaxation_factor(self, *args, **kwargs):
                """
                For backward compatibility, pseudo relaxation factor menu.
                """
                return PyMenu(self.service, "/solution/methods/pseudo_relaxation_factor").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Set VOF numeric options.
                """
                return PyMenu(self.service, "/solution/methods/vof_numerics").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Select the pressure velocity coupling scheme.
                """
                return PyMenu(self.service, "/solution/methods/p_v_coupling").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def pseudo_transient_expert(self, *args, **kwargs):
                """
                For backward compatibility, pseudo transient expert usage control.
                """
                return PyMenu(self.service, "/solution/methods/pseudo_transient_expert").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enter the discretization-scheme menu.
                """
                return PyMenu(self.service, "/solution/methods/discretization_scheme").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Set gradient options.
                """
                return PyMenu(self.service, "/solution/methods/gradient_scheme").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solution/methods/flux_type").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Set solution methods to default values.
                """
                return PyMenu(self.service, "/solution/methods/set_solution_methods_to_default").execute(*args, **kwargs)
            def pseudo_transient(self, *args, **kwargs):
                """
                For backward compatibility, pseudo transient (global time-step) formulation setup.
                """
                return PyMenu(self.service, "/solution/methods/pseudo_transient").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enable/disable accelerated non-iterative time marching.
                """
                return PyMenu(self.service, "/solution/methods/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_global_time").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_1st_order").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/solution/methods/noniterative_time_advance").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/solution/methods/frozen_flux").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable/Disable High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets relaxation factor.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Select Variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter methods query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def discretization_scheme(self, *args, **kwargs):
                    """
                    Enter the discretization-scheme menu.
                    """
                    return PyMenu(self.service, "/solution/methods/query/discretization_scheme").execute(*args, **kwargs)
                def p_v_coupling(self, *args, **kwargs):
                    """
                    Get the pressure velocity coupling scheme.
                    """
                    return PyMenu(self.service, "/solution/methods/query/p_v_coupling").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Enter overset solver options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the interpolation method for overset interface(s).
                    """
                    return PyMenu(self.service, "/solution/methods/overset/interpolation_method").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enable solver to run with orphans present.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/orphan_cell_treatment").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    High order pressure extrapolation at overset interface.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/high_order_pressure").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enter the nita expert controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Select a hybrid NITA settings option for faster performance and better robustness.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Set skewness neighbor coupling for nita.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set nita verbosity option.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/set_verbosity").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def numerics(self, *args, **kwargs):
                    """
                    Set numeric options.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/numerics").execute(*args, **kwargs)
                def reactions(self, *args, **kwargs):
                    """
                    Enable/disable the species reaction sources and set relaxation factor.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/reactions").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enter warped-face-gradient-correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable Warped-Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Enter the multiphase numerics options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    super().__init__(path, service)
                def stable_vof_settings(self, *args, **kwargs):
                    """
                    Execute Stable VOF settings.
                    """
                    return PyMenu(self.service, "/solution/methods/multiphase_numerics/stable_vof_settings").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Stability controls for multiphase flow.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        self.num_ventilation = self.__class__.num_ventilation(path + ["num_ventilation"], service)
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.velocity_limiting = self.__class__.velocity_limiting(path + ["velocity_limiting"], service)
                        self.pseudo_transient = self.__class__.pseudo_transient(path + ["pseudo_transient"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        super().__init__(path, service)

                    class anti_diffusion(TUIMenu):
                        """
                        Anti Diffusion Menu for VOF/Multi-Fluid VOF Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Set cosine exponent in dynamic strength treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enable dynamic strength to reduce compression in the tangential direction to the interface.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Set maximum value of dynamic anti-diffusion strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Pressure velocity coupling controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.pressure_interpolation = self.__class__.pressure_interpolation(path + ["pressure_interpolation"], service)
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            super().__init__(path, service)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Set Rhie-Chow related stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Use low order velocity interpolation in flux calculation.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class pressure_interpolation(TUIMenu):
                            """
                            Set Pressure Interpolation related stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def modified_bfw_scheme(self, *args, **kwargs):
                                """
                                Use modified body force weighted pressure interpolation for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/pressure_interpolation/modified_bfw_scheme").execute(*args, **kwargs)

                        class coupled_vof(TUIMenu):
                            """
                            Set Coupled VOF stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Set buoynacy force linerization options in coupled vof.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                        class skewness_correction(TUIMenu):
                            """
                            Skewness correction related stabiity controls for multiphase flow.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Use limited pressure correction gradient in skewness corrections for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                    class num_ventilation(TUIMenu):
                        """
                        Numerical Ventilation Menu for VOF Model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable(self, *args, **kwargs):
                            """
                            Enable numerical ventilation treatment to remove trapped phase adjacent to wall.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/enable").execute(*args, **kwargs)
                        def tau_estimation_options(self, *args, **kwargs):
                            """
                            Set time step size option for numerical ventilation treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/tau_estimation_options").execute(*args, **kwargs)
                        def trapped_phase_vof_max(self, *args, **kwargs):
                            """
                            Set trapped phase maximum volume fraction to activate numerical ventilation treatment for non-trapped phases.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_max").execute(*args, **kwargs)
                        def near_wall_treatment_options(self, *args, **kwargs):
                            """
                            Set near wall treatment options.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/near_wall_treatment_options").execute(*args, **kwargs)
                        def trapped_phase_vof_min(self, *args, **kwargs):
                            """
                            Set trapped phase minimum volume fraction to activate numerical ventilation treatment for trapped phase.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_min").execute(*args, **kwargs)

                    class hybrid_nita(TUIMenu):
                        """
                        Hybrid NITA stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Set hybrid nita start-up controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Set number of outer iterations in hybrid nita.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Set Hybrid NITA instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Set Courant Number limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enable instability detector for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Set Courant Number type for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Set velocity limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Set number of outer iterations for unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)

                    class velocity_limiting(TUIMenu):
                        """
                        Velocity limiting related stabiity controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/velocity_limiting/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Enter max velocity magnitude.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/velocity_limiting/set_velocity_cutoff").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enable verbosity to print number of velocity limited cells during iterations.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/velocity_limiting/verbosity").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/velocity_limiting/set_damping_strengths").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/velocity_limiting/set_damping_strength").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enable velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/velocity_limiting/enable_velocity_limiting").execute(*args, **kwargs)

                    class pseudo_transient(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/false_time_step_linearization").execute(*args, **kwargs)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/smoothed_density_stabilization_method").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_transient/auto_dt_advanced_controls/enable").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Equation Order Menu for Homogeneous Multiphase Flow Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            Solve flow equation at the end of iteration as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Multiphase compressible numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Multiphase enhanced compressible flow numerics options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Multiphase compressible flow BC alternate method.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Multiphase boiling parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        Multiphase boiling liquid volume fraction effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)
                    def thin_film(self, *args, **kwargs):
                        """
                        Multiphase boiling thin film effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Multiphase viscous flow numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Multiphase options for viscosity averaging.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Multiphase default controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Activate multiphase defaults for loaded case.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Multiphase interphase heat and mass transfer numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Alternative treatment of latent heat source due to mass transfer.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Cavitation numerics options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Maximum limit on vapor pressure after turbulence and thermal correction.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enable/disable turbulent diffusion treatment between phases participating in cavitation.
                            This treatment is generally recommended for better solution stability.
                            However, in case of numerical difficulties, it can be disabled.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Condensation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Minimum vapor pressure limit for cavitation model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Evaporation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Boiling advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes expert options of min/max superheat along with wetting fraction controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Allow generalized two-resistance framework for boiling model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Under-relaxation factor for boiling heat flux.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Interfacial area density menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Minimum vof seeding for non-zero area density in heat and mass transfer.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Interfacial area density gradient-symmetric mechanism.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Multiphase miscellaneous porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Multiphase relative permeability fix option.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    VOF solution stabilization menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        super().__init__(path, service)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        Execute additional stability controls for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        Execute advanced stabilization for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Additional advanced stability controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Blended Compressive discretization scheme for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_transient_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_transient_stabilization").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Velocity limiting related stabiity controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enable verbosity to print number of velocity limited cells during iterations.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enable velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Enter max velocity magnitude.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enter the pseudo time method menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the global time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the local time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enter the advanced options menu to define pseudo time settings for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Select the pseudo time step size formulation for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/formulation").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enter the relaxation factors menu to set the pseudo time explicit relaxation factors for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def explicit_relaxation(self, *args, **kwargs):
                    """
                    Enable the explicit relaxation option for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/explicit_relaxation").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enter the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.set_hyb_initialization = self.__class__.set_hyb_initialization(path + ["set_hyb_initialization"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                super().__init__(path, service)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enter the set full-multigrid for initialization menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initialize statistics.
                """
                return PyMenu(self.service, "/solution/initialize/init_flow_statistics").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Reset discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solution/initialize/dpm_reset").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                List default values.
                """
                return PyMenu(self.service, "/solution/initialize/list_defaults").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Open channel automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/levelset_auto_init").execute(*args, **kwargs)
            def init_instantaneous_vel(self, *args, **kwargs):
                """
                Initialize unsteady velocity.
                """
                return PyMenu(self.service, "/solution/initialize/init_instantaneous_vel").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Set reference frame absolute or relative.
                """
                return PyMenu(self.service, "/solution/initialize/reference_frame").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Enter the set defaults menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_defaults").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Delete wall film particles and initialize wall film variables to zero.
                """
                return PyMenu(self.service, "/solution/initialize/lwf_initialization").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_time_sampled").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initialize the flow field with the current default values.
                """
                return PyMenu(self.service, "/solution/initialize/initialize_flow").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specify number of timesteps for ramping of sources
                and initialize acoustics model variables.
                During ramping the sound sources are multiplied by a factor smoothly growing from 0 to 1.
                """
                return PyMenu(self.service, "/solution/initialize/init_acoustics_options").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solution/initialize/patch").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Correct wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solution/initialize/repair_wall_distance").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initialize turbulent velocity fluctuations.
                """
                return PyMenu(self.service, "/solution/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initialize using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solution/initialize/fmg_initialization").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initialize using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/hyb_initialization").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enter the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_options(self, *args, **kwargs):
                    """
                    Patch and smoothing options for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)

            class set_hyb_initialization(TUIMenu):
                """
                Enter the settings for hybrid initialization method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulent_settings(self, *args, **kwargs):
                    """
                    Enter the turbulent settings menu.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_hyb_initialization/turbulent_settings").execute(*args, **kwargs)
                def general_settings(self, *args, **kwargs):
                    """
                    Enter the general settings menu.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_hyb_initialization/general_settings").execute(*args, **kwargs)
                def species_settings(self, *args, **kwargs):
                    """
                    Enter the species settings menu.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_hyb_initialization/species_settings").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enter the compute defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initialize the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outflow").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Turbulent flow parameters for localized initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert options for solution.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                super().__init__(path, service)
            def equation_ordering(self, *args, **kwargs):
                """
                Set the equation order.
                """
                return PyMenu(self.service, "/solution/expert/equation_ordering").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Setting pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solution/expert/bc_pressure_extrapolations").execute(*args, **kwargs)
            def linearized_mass_transfer_udf(self, *args, **kwargs):
                """
                Use linearized mass transfer UDFs?.
                """
                return PyMenu(self.service, "/solution/expert/linearized_mass_transfer_udf").execute(*args, **kwargs)
            def retain_temporary_solver_mem(self, *args, **kwargs):
                """
                Retain temporary solver memory?.
                """
                return PyMenu(self.service, "/solution/expert/retain_temporary_solver_mem").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Lock the temperature for all solid and shell cell zones in the domain.
                """
                return PyMenu(self.service, "/solution/expert/lock_solid_temperature").execute(*args, **kwargs)
            def show_all_discretization_schemes(self, *args, **kwargs):
                """
                Allow selection of all applicable discretization schemes?.
                """
                return PyMenu(self.service, "/solution/expert/show_all_discretization_schemes").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension_expert").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Set damping function in flow direction.
                """
                return PyMenu(self.service, "/solution/expert/numerical_beach_controls").execute(*args, **kwargs)
            def bcd_boundedness(self, *args, **kwargs):
                """
                BCD scheme boundedness strength, constant or expression (0 to 1).
                """
                return PyMenu(self.service, "/solution/expert/bcd_boundedness").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Set reference density option for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_reference_density").execute(*args, **kwargs)
            def singhal_et_al_cavitation_model(self, *args, **kwargs):
                """
                Use Singhal-et-al cavitation model?.
                """
                return PyMenu(self.service, "/solution/expert/singhal_et_al_cavitation_model").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Set all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solution/expert/set_all_species_together").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Set surface-tension calculation options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                Set additional open channel controls.
                """
                return PyMenu(self.service, "/solution/expert/open_channel_controls").execute(*args, **kwargs)
            def energy_numerical_noise_filter(self, *args, **kwargs):
                """
                The energy equation numerical noise filter can be enabled to eliminate non-physical numerical noise in the energy field.
                The numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present.
                Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive.
                """
                return PyMenu(self.service, "/solution/expert/energy_numerical_noise_filter").execute(*args, **kwargs)
            def explicit_under_relaxation_value(self, *args, **kwargs):
                """
                Explicit under-relaxation value.
                """
                return PyMenu(self.service, "/solution/expert/explicit_under_relaxation_value").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solution/expert/material_property_warnings").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Set Explicit VOF controls.
                """
                return PyMenu(self.service, "/solution/expert/vof_explicit_controls").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Enable/Disable reconstruction. When disabled, accuracy will be first-order.
                """
                return PyMenu(self.service, "/solution/expert/disable_reconstruction").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Control the display of warning diagnostics for boundaries with reversed flow, etc.
                """
                return PyMenu(self.service, "/solution/expert/flow_warnings").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Set anisotropic drag parameters for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Control the display of limiter warning diagnostics.
                """
                return PyMenu(self.service, "/solution/expert/limiter_warnings").execute(*args, **kwargs)
            def correction_form(self, *args, **kwargs):
                """
                Discretize momentum equations in correction form for the pressure-based solver.
                """
                return PyMenu(self.service, "/solution/expert/correction_form").execute(*args, **kwargs)
            def bcd_weights_freeze(self, *args, **kwargs):
                """
                At each timestep, freeze BCD scheme weights after specified iteration
                in order to improve timestep convergence.
                """
                return PyMenu(self.service, "/solution/expert/bcd_weights_freeze").execute(*args, **kwargs)
            def alternate_wall_temp_formulation(self, *args, **kwargs):
                """
                Alternate formulation for wall temperatures?.
                """
                return PyMenu(self.service, "/solution/expert/alternate_wall_temp_formulation").execute(*args, **kwargs)
            def retain_cell_residuals(self, *args, **kwargs):
                """
                Retain cell residuals for postprocessing?.
                """
                return PyMenu(self.service, "/solution/expert/retain_cell_residuals").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Enter the open-channel-wave-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Set stokes wave theory variants.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Set bufer layer height between phases for segregated velocity inputs.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)

            class non_reflecting_boundary_treatment(TUIMenu):
                """
                Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)

            class secondary_gradient_limiting(TUIMenu):
                """
                Enter the Secondary Gradient Limiting Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def uds(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for user-defined scalars.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/uds").execute(*args, **kwargs)
                def energy(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for energy equation.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                def mesh_quality_limits(self, *args, **kwargs):
                    """
                    Specify minimum and maximum mesh quality limits.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enter the divergence prevention menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable divergence prevention.
                    """
                    return PyMenu(self.service, "/solution/expert/divergence_prevention/enable").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enter Poor Mesh Numerics Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics on cells with low quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Include cells in register in poor mesh numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Solution correction on meshes of poor quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on cell gradient quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on solution and cell quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Set quality threshold.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Relocate select cell centroids, to improve orthogonality metrics and solution stability.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def user_defined_on_register_auto(self, *args, **kwargs):
                    """
                    Set up the application of poor mesh numerics to cells in registers during the calculation at a specified frequency.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register_auto").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Reset marking of poor cell elements.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Print poor cells count.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def expert(self, *args, **kwargs):
                    """
                    Expert high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/expert").execute(*args, **kwargs)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Enable/disable pressure-discontinuity-sensor visualization.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/enable").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Enter previous defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R3.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_2023r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2023R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2023r1_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R2.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2022R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)

        class run_calculation(TUIMenu):
            """
            Enter run calculation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                super().__init__(path, service)
            def mesh_motion(self, *args, **kwargs):
                """
                Perform mesh motion.
                """
                return PyMenu(self.service, "/solution/run_calculation/mesh_motion").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enter the residual tolerance menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_tolerance").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Set Solution Steering Parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/set_solution_steering").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enter the max-corrections menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/max_corrections").execute(*args, **kwargs)
            def iterate(self, *args, **kwargs):
                """
                Perform a specified number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/iterate").execute(*args, **kwargs)
            def multistage_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/multistage_time_iterate").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/variable_time_stepping").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Set number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/number_of_iterations").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enable solution steering for density-based solver.
                """
                return PyMenu(self.service, "/solution/run_calculation/solution_steering").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Set iteration options.
                """
                return PyMenu(self.service, "/solution/run_calculation/data_sampling").execute(*args, **kwargs)
            def dual_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/dual_time_iterate").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Set number of solver iterations before returning to scheme.
                """
                return PyMenu(self.service, "/solution/run_calculation/reporting_interval").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/adaptive_time_stepping").execute(*args, **kwargs)
            def update_physical_time(self, *args, **kwargs):
                """
                Update the solution to the next physical time level.
                """
                return PyMenu(self.service, "/solution/run_calculation/update_physical_time").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solution/run_calculation/time_step").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/solution/run_calculation/summary").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Set options for second-order time formulation.
                """
                return PyMenu(self.service, "/solution/run_calculation/second_order_time_options").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Set the residual report verbosity.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_verbosity").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Data sampling options for statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dft_datasets = self.__class__.dft_datasets(path + ["dft_datasets"], service)
                    super().__init__(path, service)
                def list_datasets(self, *args, **kwargs):
                    """
                    List dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/list_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_datasets").execute(*args, **kwargs)

                class dft_datasets(TUIMenu):
                    """
                    Data sampling options for runtime discrete Fourier transform.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def freq_tone_and_sampling(self, *args, **kwargs):
                        """
                        Specify single tone frequency and sampling duration as the number of tone periods.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_tone_and_sampling").execute(*args, **kwargs)
                    def zones(self, *args, **kwargs):
                        """
                        Select zones for a new DFT dataset.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/zones").execute(*args, **kwargs)
                    def band_or_tone(self, *args, **kwargs):
                        """
                        Specify, whether a new dataset is for DFT in a frequency band resolved by many harmonics or for a single tone.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/band_or_tone").execute(*args, **kwargs)
                    def add_datasets(self, *args, **kwargs):
                        """
                        Add DFT datasets.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/add_datasets").execute(*args, **kwargs)
                    def freq_min_max(self, *args, **kwargs):
                        """
                        Specify the minimum and the maximum frequency for a band.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_min_max").execute(*args, **kwargs)
                    def freq_step_and_sampling(self, *args, **kwargs):
                        """
                        Specify either the band resolution or the sampling timesteps number. The other value will be computed consistently.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_step_and_sampling").execute(*args, **kwargs)
                    def quantities(self, *args, **kwargs):
                        """
                        Select quantities for a new DFT dataset. Enter () to complete the quantity selection.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/quantities").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enter into the transient controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Set maximum flow time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_flow_time").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Specify a different time step size for solid zones.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enter the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Set Duration Specification Method: [0] Incremental Time Steps, [1] Total Time Steps, [2] Total Time, [3] Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Set number of time step size for acoustic export.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Set the physical time step size.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Set total number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Improve prediction of flow field at time step n+1 for rotating mesh.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/predict_next_time").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Set inceremtal number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Set Total Simulation Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_time").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    Undo the previous time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/undo_timestep").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Set the time-stepping parameters for user-defined time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Set Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/incremental_time").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Set period- or frequency-based fixed time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Set Max Iterations/Time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Activate the simulation status panel.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solution_status").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Set Error-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Set Multiphase-specific adaptive time stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Enable user-specified fixed time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Use specified time step or courant number.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/specified_time_step").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Set Multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Include physics driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity to print multiphase specific time scales.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Set physics based time scale options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Include gravity based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Include acoustic time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Include surface tension based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Include viscous time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)

        class controls(TUIMenu):
            """
            Enter the controls menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                super().__init__(path, service)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enter the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solution/controls/relaxation_factor").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enter the under-relaxation menu.
                """
                return PyMenu(self.service, "/solution/controls/under_relaxation").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Enter the equations menu.
                """
                return PyMenu(self.service, "/solution/controls/equations").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Set P-V-Controls.
                """
                return PyMenu(self.service, "/solution/controls/p_v_controls").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Set solver limits for the values of various solution variables.
                """
                return PyMenu(self.service, "/solution/controls/limits").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Set controls to default values.
                """
                return PyMenu(self.service, "/solution/controls/set_controls_to_default").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Set the fine mesh Courant number (time step factor).
                """
                return PyMenu(self.service, "/solution/controls/courant_number").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter controls query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advanced = self.__class__.advanced(path + ["advanced"], service)
                    self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                    super().__init__(path, service)
                def equations(self, *args, **kwargs):
                    """
                    Enter the equations menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/equations").execute(*args, **kwargs)
                def p_v_controls(self, *args, **kwargs):
                    """
                    Get P-V-Controls.
                    """
                    return PyMenu(self.service, "/solution/controls/query/p_v_controls").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Enter under relaxation menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/under_relaxation").execute(*args, **kwargs)
                def limits(self, *args, **kwargs):
                    """
                    Get solver limits for the values of various solution variables.
                    """
                    return PyMenu(self.service, "/solution/controls/query/limits").execute(*args, **kwargs)
                def relaxation_factor(self, *args, **kwargs):
                    """
                    Enter the relaxation-factor menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/relaxation_factor").execute(*args, **kwargs)
                def courant_number(self, *args, **kwargs):
                    """
                    Get the fine mesh Courant number (time step factor).
                    """
                    return PyMenu(self.service, "/solution/controls/query/courant_number").execute(*args, **kwargs)

                class advanced(TUIMenu):
                    """
                    Controls advanced options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                        super().__init__(path, service)
                    def multi_stage(self, *args, **kwargs):
                        """
                        Set the multiple-stage time stepping scheme coefficients.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_stage").execute(*args, **kwargs)
                    def correction_tolerance(self, *args, **kwargs):
                        """
                        Enter the correction tolerance menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/correction_tolerance").execute(*args, **kwargs)
                    def multi_grid_fas(self, *args, **kwargs):
                        """
                        Get the coefficients that govern the FAS multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_fas").execute(*args, **kwargs)
                    def multi_grid_controls(self, *args, **kwargs):
                        """
                        Enter the multi-grid-controls menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_controls").execute(*args, **kwargs)
                    def multi_grid_amg(self, *args, **kwargs):
                        """
                        Get the parameters that govern the algebraic multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_amg").execute(*args, **kwargs)
                    def relaxation_method(self, *args, **kwargs):
                        """
                        Set the solver relaxation method.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/relaxation_method").execute(*args, **kwargs)

                    class amg_options(TUIMenu):
                        """
                        Enter AMG options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def conservative_amg_coarsening(self, *args, **kwargs):
                            """
                            Use conservative AMG coarsening?.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                        def amg_gpgpu_options(self, *args, **kwargs):
                            """
                            Amg gpu options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                        def aggressive_amg_coarsening(self, *args, **kwargs):
                            """
                            Use aggressive AMG coarsening.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)
                        def laplace_coarsening(self, *args, **kwargs):
                            """
                            Get AMG laplace coarsening options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)

                class acoustics_wave_equation_controls(TUIMenu):
                    """
                    Enter menu for acoustics wave equation solver controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def max_iterations_per_timestep(self, *args, **kwargs):
                        """
                        Specify maximum number of iterations per timestep.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                    def relative_convergence_criterion(self, *args, **kwargs):
                        """
                        Specify convergence tolerance for the timestep iterations
                        as the target residual reduction factor.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter menu for expert controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def under_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify under-relaxation factor to be used in
                            the diagonal matrix elements of implicit solver.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)
                        def explicit_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify explicit relaxation factor to be applied to
                            the solution correction when updating solution in the timestep iterations.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    super().__init__(path, service)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/verbosity").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Controls advanced options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                    self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                    super().__init__(path, service)
                def multi_grid_fas(self, *args, **kwargs):
                    """
                    Set the coefficients that govern the FAS multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_fas").execute(*args, **kwargs)
                def slope_limiter_set(self, *args, **kwargs):
                    """
                    Enter the slope limiter set menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/slope_limiter_set").execute(*args, **kwargs)
                def multi_grid_controls(self, *args, **kwargs):
                    """
                    Enter the multi-grid-controls menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_controls").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Set the solver relaxation method.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/relaxation_method").execute(*args, **kwargs)
                def multi_stage(self, *args, **kwargs):
                    """
                    Set the multiple-stage time stepping scheme coefficients.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_stage").execute(*args, **kwargs)
                def correction_tolerance(self, *args, **kwargs):
                    """
                    Enter the correction tolerance menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/correction_tolerance").execute(*args, **kwargs)
                def multi_grid_amg(self, *args, **kwargs):
                    """
                    Set the parameters that govern the algebraic multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_amg").execute(*args, **kwargs)

                class fast_transient_settings(TUIMenu):
                    """
                    Enter the fast transient settings menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rk2(self, *args, **kwargs):
                        """
                        Enable the use of a two-stage Runge-Kutta scheme for time integration.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/fast_transient_settings/rk2").execute(*args, **kwargs)

                class amg_options(TUIMenu):
                    """
                    Enter AMG options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def laplace_coarsening(self, *args, **kwargs):
                        """
                        Set AMG laplace coarsening options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                    def amg_gpgpu_options(self, *args, **kwargs):
                        """
                        Set GPGPU AMG solver options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                    def conservative_amg_coarsening(self, *args, **kwargs):
                        """
                        Use conservative AMG coarsening?.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                    def aggressive_amg_coarsening(self, *args, **kwargs):
                        """
                        Use aggressive AMG coarsening.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enter menu for acoustics wave equation solver controls.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter menu for expert controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify explicit relaxation factor to be applied to
                        the solution correction when updating solution in the timestep iterations.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify under-relaxation factor to be used in
                        the diagonal matrix elements of implicit solver.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

    class define(TUIMenu):
        """
        Enter the define menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.curvilinear_coordinate_system = self.__class__.curvilinear_coordinate_system(path + ["curvilinear_coordinate_system"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
            self.profiles = self.__class__.profiles(path + ["profiles"], service)
            self.phases = self.__class__.phases(path + ["phases"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.virtual_boundary = self.__class__.virtual_boundary(path + ["virtual_boundary"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.custom_field_functions = self.__class__.custom_field_functions(path + ["custom_field_functions"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.spectral = self.__class__.spectral(path + ["spectral"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            super().__init__(path, service)
        def boundary_conditions(self, *args, **kwargs):
            """
            Enter the boundary conditions menu.
            """
            return PyMenu(self.service, "/define/boundary_conditions").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            Applies a standard set of units to all quantities. The options include default,si, british, andcgs.
            """
            return PyMenu(self.service, "/define/set_unit_system").execute(*args, **kwargs)
        def beta_feature_access(self, *args, **kwargs):
            """
            Enable access to beta features in the interface.
            """
            return PyMenu(self.service, "/define/beta_feature_access").execute(*args, **kwargs)
        def injections(self, *args, **kwargs):
            """
            Enters the injections menu.  For a description of the items in this menu, see define/models/dpm/injections.
            """
            return PyMenu(self.service, "/define/injections").execute(*args, **kwargs)
        def physics(self, *args, **kwargs):
            """
            Manage Physics-regions.
            """
            return PyMenu(self.service, "/define/physics").execute(*args, **kwargs)
        def enable_expressions(self, *args, **kwargs):
            """
            Enable the expressions feature.
            """
            return PyMenu(self.service, "/define/enable_expressions").execute(*args, **kwargs)
        def enable_mesh_morpher_optimizer(self, *args, **kwargs):
            """
            Enables the mesh morpher/optimizer. When the mesh morpher/optimizer is enabled, the define/mesh-morpher-optimizer text command becomes available.
            """
            return PyMenu(self.service, "/define/enable_mesh_morpher_optimizer").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Sets unit conversion factors.
            """
            return PyMenu(self.service, "/define/units").execute(*args, **kwargs)

        class curvilinear_coordinate_system(TUIMenu):
            """
            Curvilinear Coordinate System.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def calculation_settings(self, *args, **kwargs):
                """
                Define Settings for curvilinear coordinate system.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/calculation_settings").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing curvilinear coordinate system.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete Curvilinear Coordinate System.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/delete").execute(*args, **kwargs)
            def display_settings(self, *args, **kwargs):
                """
                Display settings for Curvilinear Coordinate System.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/display_settings").execute(*args, **kwargs)
            def new(self, *args, **kwargs):
                """
                Define a new curvilinear coordinate system.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/new").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display Curvilinear Coordinate System.
                """
                return PyMenu(self.service, "/define/curvilinear_coordinate_system/display").execute(*args, **kwargs)

        class operating_conditions(TUIMenu):
            """
            Enters the define operating conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def operating_density(self, *args, **kwargs):
                """
                Multiphase flow Operating Density menu.
                """
                return PyMenu(self.service, "/define/operating_conditions/operating_density").execute(*args, **kwargs)
            def set_state(self, *args, **kwargs):
                """
                Selects state for real gas EOS subcritical condition.
                """
                return PyMenu(self.service, "/define/operating_conditions/set_state").execute(*args, **kwargs)
            def gravity_mrf_rotation(self, *args, **kwargs):
                """
                Enables/disables rotation of gravity vector in moving reference frame simulations. If enabled, the gravity vector will rotate with respect to the moving reference frame such that the direction of gravity in global coordinates remains fixed.
                """
                return PyMenu(self.service, "/define/operating_conditions/gravity_mrf_rotation").execute(*args, **kwargs)
            def gravity(self, *args, **kwargs):
                """
                Sets gravitational acceleration.
                """
                return PyMenu(self.service, "/define/operating_conditions/gravity").execute(*args, **kwargs)
            def operating_temperature(self, *args, **kwargs):
                """
                Sets the operating temperature for Boussinesq.
                """
                return PyMenu(self.service, "/define/operating_conditions/operating_temperature").execute(*args, **kwargs)
            def gravity_mrf_behavior(self, *args, **kwargs):
                """
                Enable/disable the fix of gravity vector in a stationary reference frame.
                """
                return PyMenu(self.service, "/define/operating_conditions/gravity_mrf_behavior").execute(*args, **kwargs)
            def reference_pressure_location(self, *args, **kwargs):
                """
                Sets a location that determines the reference pressure cell or cells (depending on the selected reference pressure method). The pressure value in such cells can be used to adjust the gauge pressure field after each iteration to keep it from floating.
                """
                return PyMenu(self.service, "/define/operating_conditions/reference_pressure_location").execute(*args, **kwargs)
            def use_inlet_temperature_for_operating_density(self, *args, **kwargs):
                """
                Uses inlet temperature to calculate operating density.
                """
                return PyMenu(self.service, "/define/operating_conditions/use_inlet_temperature_for_operating_density").execute(*args, **kwargs)
            def reference_pressure_method(self, *args, **kwargs):
                """
                Specifies the method used for adjusting the gauge pressure field after each iteration to keep it from floating: the method can assume that all of the cell zones are connected by internal boundary zones (such as interior zones), or can account for connected and disconnected cell zones. Such adjustment is only allowed for incompressible flows, and will be limited partially or entirely by the presence of a pressure boundary.
                """
                return PyMenu(self.service, "/define/operating_conditions/reference_pressure_method").execute(*args, **kwargs)
            def operating_pressure(self, *args, **kwargs):
                """
                Sets the operating pressure.
                """
                return PyMenu(self.service, "/define/operating_conditions/operating_pressure").execute(*args, **kwargs)
            def used_ref_pressure_location(self, *args, **kwargs):
                """
                Prints the coordinates of the reference pressure cell or cells (depending on the selected reference pressure method). The pressure value in such cells can be used to adjust the gauge pressure field after each iteration to keep it from floating.
                """
                return PyMenu(self.service, "/define/operating_conditions/used_ref_pressure_location").execute(*args, **kwargs)

        class gap_model(TUIMenu):
            """
            Enters the gap model menu, where you can define one or more gap regions where the flow is blocked or decelerated when face zones move within a specified proximity threshold of each other.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.advanced_options = self.__class__.advanced_options(path + ["advanced_options"], service)
                super().__init__(path, service)
            def list_gap_cell_zones(self, *args, **kwargs):
                """
                Lists the names of the cell zones that can be excluded for individual gap regions (so that such cells are not marked for flow blockage / deceleration).
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_cell_zones").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates a single gap region, so that when selected face zones move within a specified proximity threshold of each other, flow blockage / deceleration is applied to the cells that lie within the threshold.
                """
                return PyMenu(self.service, "/define/gap_model/create").execute(*args, **kwargs)
            def list_gap_regions(self, *args, **kwargs):
                """
                Lists the properties of the gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_regions").execute(*args, **kwargs)
            def list_gap_face_zones(self, *args, **kwargs):
                """
                Lists the names of the face zones that can be used for creating gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/list_gap_face_zones").execute(*args, **kwargs)
            def render_gap_regions(self, *args, **kwargs):
                """
                Update gap regions for postprocessing.
                """
                return PyMenu(self.service, "/define/gap_model/render_gap_regions").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the existing gap regions.
                """
                return PyMenu(self.service, "/define/gap_model/delete_all").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables/disables the gap model.
                """
                return PyMenu(self.service, "/define/gap_model/enable").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes an existing gap region.
                """
                return PyMenu(self.service, "/define/gap_model/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing gap region.
                """
                return PyMenu(self.service, "/define/gap_model/edit").execute(*args, **kwargs)

            class advanced_options(TUIMenu):
                """
                Enters the advanced options menu for the gap model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reduce_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables a more restrictive algorithm for marking cells in gap regions. This 	text command is only available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/reduce_gap_regions").execute(*args, **kwargs)
                def enhanced_data_interpolation(self, *args, **kwargs):
                    """
                    Enables/disables the use of enhanced data 	interpolation when updating information in gap regions. 	This text command is only available if you have enabled 	the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/enhanced_data_interpolation").execute(*args, **kwargs)
                def clear_gap_regions(self, *args, **kwargs):
                    """
                    Clear gap model solution information and marks.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/clear_gap_regions").execute(*args, **kwargs)
                def cell_check_distance_factor(self, *args, **kwargs):
                    """
                    Enter value of the cell distance factor.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/cell_check_distance_factor").execute(*args, **kwargs)
                def update_gap_regions(self, *args, **kwargs):
                    """
                    Update gap regions and gap model solution information.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/update_gap_regions").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enables/disables access to expert-level text commands 	for the gap model.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/expert").execute(*args, **kwargs)
                def flow_blocking_stabilization_parameters(self, *args, **kwargs):
                    """
                    Adjust stabilization settings for the sponge layer used for blocked gap regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/flow_blocking_stabilization_parameters").execute(*args, **kwargs)
                def render_gap_interface(self, *args, **kwargs):
                    """
                    Enables/disables the rendering of the mesh surfaces inside the gap regions when 	displaying the mesh with contours. Note that the 	solution is still not rendered inside the flow-blocking 	gap regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/render_gap_interface").execute(*args, **kwargs)
                def include_coupled_walls(self, *args, **kwargs):
                    """
                    Include coupled walls in gap face zones.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/include_coupled_walls").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Sets the global solution stabilization level for the gap 	regions.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/solution_stabilization").execute(*args, **kwargs)
                def check_cfl_condition(self, *args, **kwargs):
                    """
                    Enables/disables the printing of warnings if the time 	step size is too large based on a Courant (CFL) number 	automatically determined for your specified solution 	stability level.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/check_cfl_condition").execute(*args, **kwargs)
                def sponge_layer(self, *args, **kwargs):
                    """
                    Allows you to edit the solution stabilization settings for flow-modeling gap regions 	that have sponge-layer local stabilization 	enabled.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/sponge_layer").execute(*args, **kwargs)
                def render_flow_modeling_gaps(self, *args, **kwargs):
                    """
                    Enables/disables the rendering of the solution in the cells of flow-modeling gap 	regions during postprocessing. This text command is only 	available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/render_flow_modeling_gaps").execute(*args, **kwargs)
                def alternative_marking(self, *args, **kwargs):
                    """
                    Mark gap regions using an alternative marking algorithm.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/alternative_marking").execute(*args, **kwargs)
                def fill_data_in_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables the interpolation of solution data throughout the gap regions. This 	text command is only available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/fill_data_in_gap_regions").execute(*args, **kwargs)
                def revert_controls_to_default(self, *args, **kwargs):
                    """
                    Reverts the global gap stabilization level and any related 	solver settings to the default.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/revert_controls_to_default").execute(*args, **kwargs)
                def extend_gap_regions(self, *args, **kwargs):
                    """
                    Enables/disables the extending of the gap regions by including additional cells in 	the vicinity of the gap interfaces during marking. This 	is useful when the default shape of the marked cells is 	negatively affecting solution stability or convergence 	behavior.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/extend_gap_regions").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity for messages printed in the console 	related to the gap model.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/verbosity").execute(*args, **kwargs)
                def precise_gap_marking(self, *args, **kwargs):
                    """
                    Enables/disables the use of a more accurate search algorithm for marking cells in 	gap regions. Note that it can be costly, particularly 	for 3D cases or those with a large number of cells 	inside the gap regions. This text command is only 	available if you have enabled the 	define/gap-model/advanced-options/expert? 	text command.
                    """
                    return PyMenu(self.service, "/define/gap_model/advanced_options/precise_gap_marking").execute(*args, **kwargs)

        class solution_strategy(TUIMenu):
            """
            Enters the automatic initialization and case modification strategy menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.automatic_case_modification = self.__class__.automatic_case_modification(path + ["automatic_case_modification"], service)
                super().__init__(path, service)
            def add_edit_modification(self, *args, **kwargs):
                """
                Define a single case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/add_edit_modification").execute(*args, **kwargs)
            def copy_modification(self, *args, **kwargs):
                """
                Copy a single case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/copy_modification").execute(*args, **kwargs)
            def enable_strategy(self, *args, **kwargs):
                """
                Enables/disables automatic initialization and case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/enable_strategy").execute(*args, **kwargs)
            def continue_strategy_execution(self, *args, **kwargs):
                """
                Continues execution of the currently defined automatic initialization and case modification strategy.
                """
                return PyMenu(self.service, "/define/solution_strategy/continue_strategy_execution").execute(*args, **kwargs)
            def execute_strategy(self, *args, **kwargs):
                """
                Executes the currently defined automatic initialization and case modification strategy.
                """
                return PyMenu(self.service, "/define/solution_strategy/execute_strategy").execute(*args, **kwargs)
            def import_modifications(self, *args, **kwargs):
                """
                Import a list of case modifications from a tsv file.
                """
                return PyMenu(self.service, "/define/solution_strategy/import_modifications").execute(*args, **kwargs)
            def disable_modification(self, *args, **kwargs):
                """
                Disable a single defined case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/disable_modification").execute(*args, **kwargs)
            def delete_modification(self, *args, **kwargs):
                """
                Delete a single case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/delete_modification").execute(*args, **kwargs)
            def automatic_initialization(self, *args, **kwargs):
                """
                Defines how the case is to be automatically initialized.
                """
                return PyMenu(self.service, "/define/solution_strategy/automatic_initialization").execute(*args, **kwargs)
            def export_modifications(self, *args, **kwargs):
                """
                Export all case modifications to a tsv file.
                """
                return PyMenu(self.service, "/define/solution_strategy/export_modifications").execute(*args, **kwargs)
            def enable_modification(self, *args, **kwargs):
                """
                Enable a single defined case modification.
                """
                return PyMenu(self.service, "/define/solution_strategy/enable_modification").execute(*args, **kwargs)

            class automatic_case_modification(TUIMenu):
                """
                Enters the automatic case modification menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def modifications(self, *args, **kwargs):
                    """
                    Specifies modifications to be performed during solution.
                    """
                    return PyMenu(self.service, "/define/solution_strategy/automatic_case_modification/modifications").execute(*args, **kwargs)
                def original_settings(self, *args, **kwargs):
                    """
                    Specifies modification to be performed after initialization to restore to original 	settings.
                    """
                    return PyMenu(self.service, "/define/solution_strategy/automatic_case_modification/original_settings").execute(*args, **kwargs)
                def before_init_modification(self, *args, **kwargs):
                    """
                    Specifies modification to be performed before initialization.
                    """
                    return PyMenu(self.service, "/define/solution_strategy/automatic_case_modification/before_init_modification").execute(*args, **kwargs)

        class profiles(TUIMenu):
            """
            Enters the boundary profiles menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_profile_parameters(self, *args, **kwargs):
                """
                List the parameters of a particular profile.
                """
                return PyMenu(self.service, "/define/profiles/list_profile_parameters").execute(*args, **kwargs)
            def morphing(self, *args, **kwargs):
                """
                Enables/disables profile morphing options in Orient Profile panel.
                """
                return PyMenu(self.service, "/define/profiles/morphing").execute(*args, **kwargs)
            def set_preference_profile_point_cloud_data(self, *args, **kwargs):
                """
                Set Preference Profile Point Cloud Data e.g., Point marker symbol,size,color.
                """
                return PyMenu(self.service, "/define/profiles/set_preference_profile_point_cloud_data").execute(*args, **kwargs)
            def update_interval(self, *args, **kwargs):
                """
                Sets interval between updates of dynamic profiles.
                """
                return PyMenu(self.service, "/define/profiles/update_interval").execute(*args, **kwargs)
            def display_profile_point_cloud_data(self, *args, **kwargs):
                """
                Display Profile Point Cloud Data.
                """
                return PyMenu(self.service, "/define/profiles/display_profile_point_cloud_data").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a profile.
                """
                return PyMenu(self.service, "/define/profiles/delete").execute(*args, **kwargs)
            def replicate_profile(self, *args, **kwargs):
                """
                Replicate Profile.
                """
                return PyMenu(self.service, "/define/profiles/replicate_profile").execute(*args, **kwargs)
            def interpolation_method(self, *args, **kwargs):
                """
                Chooses the method for interpolation of profiles.
                """
                return PyMenu(self.service, "/define/profiles/interpolation_method").execute(*args, **kwargs)
            def display_profile_surface(self, *args, **kwargs):
                """
                Display the profile as a surface (this option is only available if the specified profile contains node-connectivity data).
                """
                return PyMenu(self.service, "/define/profiles/display_profile_surface").execute(*args, **kwargs)
            def list_profile_fields(self, *args, **kwargs):
                """
                Lists the fields of a particular profile.
                """
                return PyMenu(self.service, "/define/profiles/list_profile_fields").execute(*args, **kwargs)
            def orient_profile(self, *args, **kwargs):
                """
                Re-orient an existing profile.
                """
                return PyMenu(self.service, "/define/profiles/orient_profile").execute(*args, **kwargs)
            def overlay_profile_point_cloud_data(self, *args, **kwargs):
                """
                Overlay Profile Point Cloud Data.
                """
                return PyMenu(self.service, "/define/profiles/overlay_profile_point_cloud_data").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all boundary-profiles.
                """
                return PyMenu(self.service, "/define/profiles/delete_all").execute(*args, **kwargs)
            def link_profile_to_reference_frame(self, *args, **kwargs):
                """
                Attaches a profile to a reference frame so that the profile will rotate according to the reference frame.
                """
                return PyMenu(self.service, "/define/profiles/link_profile_to_reference_frame").execute(*args, **kwargs)
            def list_profiles(self, *args, **kwargs):
                """
                Lists all profiles.
                """
                return PyMenu(self.service, "/define/profiles/list_profiles").execute(*args, **kwargs)
            def overlay_profile_surface(self, *args, **kwargs):
                """
                Overlay Profile Surface.
                """
                return PyMenu(self.service, "/define/profiles/overlay_profile_surface").execute(*args, **kwargs)

        class phases(TUIMenu):
            """
            Enters the phases menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                super().__init__(path, service)
            def phase_domain(self, *args, **kwargs):
                """
                Enter the menu to set phase domain properties.
                """
                return PyMenu(self.service, "/define/phases/phase_domain").execute(*args, **kwargs)
            def interaction_domain(self, *args, **kwargs):
                """
                Enter the menu to set interaction domain properties.
                """
                return PyMenu(self.service, "/define/phases/interaction_domain").execute(*args, **kwargs)

            class set_domain_properties(TUIMenu):
                """
                Enters the menu to set phase domain properties.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                    super().__init__(path, service)
                def phase_domains(self, *args, **kwargs):
                    """
                    Enters the menu to select a specific phase.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                def change_phases_names(self, *args, **kwargs):
                    """
                    Allows you to change the names of all the phases in your simulation.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                class interaction_domain(TUIMenu):
                    """
                    Enters the menu to set the interaction domain 	properties.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                        self.forces = self.__class__.forces(path + ["forces"], service)
                        self.numerics = self.__class__.numerics(path + ["numerics"], service)
                        self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                        self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                        super().__init__(path, service)

                    class heat_mass_reactions(TUIMenu):
                        """
                        Enters the menu to set heat, mass-transfer, and reaction models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            super().__init__(path, service)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Allows you to define multiple heterogeneous reactions and stoichiometry. This option is available only with the species model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Species the heat transfer coefficient function between each pair of phases (constant-htc, nusselt-number, ranz-marshall, hughmark, tomiyama, fixed-to-sat-temp, two-resistance, or user-defined). This command is enable only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enters the menu to set cavitation models. This option is available only for the Mixture multiphase model with the Singhal-et-al cavitation model enabled via solve/set/advanced/singhal-et-al-cavitation-model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def cavitation(self, *args, **kwargs):
                                """
                                Sets the vaporization pressure, surface tension coefficient, and non-condensable gas mass fraction. This command is available only when cavitation? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)

                    class forces(TUIMenu):
                        """
                        Enters the menu to set interfacial forces models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            super().__init__(path, service)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specifies the wall lubrication model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specifies the restitution coefficient for collisions between each pair of granular phases, and for collisions between particles of the same granular phase. This command is available only for multiphase flows with two or more granular phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specifies the slip velocity function for each secondary phase with respect to the primary phase. This command is available only for the Mixture multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specifies the drag function, drag modification, and drag factor for each pair of phases. This command is available only with the Eulerian and Mixture multiphase models.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specifies the turbulent dispersion model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specifies the turbulence interaction model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enters the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specifies the virtual mass coefficient for each pair of phases. This option is available only ifvirtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Specifies what form of the implicit method to use (default, option-2, or option-3). default models the entire virtual mass force while option-2 and option-3 model truncated expressions which may further improve convergence. This option is available only if vmass-implicit? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Allows you to include the virtual mass force effect that occurs when a secondary phase accelerates relative to the primary phase. This command is available only with the Eulerian multiphase model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enables/disables the implicit method for the virtual mass force. This option can improve convergence in some cases. This option is available only if virtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enters the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the treatment of the contact angle specification at the porous jump boundary. This command is available only for the VOF multiphase model with the continuum surface stress model option and when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the specification for a wall adhesion angle. This item is available only whensfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Selects the surface tension model. You can choose between the continuum surface force and continuum surface stress methods. This item is available only when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specifies the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Allows you to include the effects of surface tension along the fluid-fluid interface. This option is only available for the VOF and Eulerian multiphase models.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enters the menu to set the lift force. This item is available only with the Eulerian multiphase model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                Specifies the lift function for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Enables/disables the Shaver-Podowski lift correction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)

                    class numerics(TUIMenu):
                        """
                        Enters the menu to set numerics models. This menu is available for multiphase models with the sharp-dispersed and phase localized discretization interface modeling options (set in define/models/multiphase/interface-modeling-options).
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            super().__init__(path, service)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enters the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enables/disables phase localized compressive scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specifies the slope limiter to set a specific discretization scheme for each phase pair. A value of 0 corresponds to first order upwind, a value of 1 corresponds to second order upwind, a value of 2 applies the compressive scheme, and a value between 0 and 2 corresponds to a blended scheme. This option is available only wheninterphase-discr? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)

                    class model_transition(TUIMenu):
                        """
                        Enters the menu to set model transition mechanisms.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            super().__init__(path, service)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Sets the VOF-to-DPM model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)

                    class interfacial_area(TUIMenu):
                        """
                        Enters the menu to set interfacial area models. This menu is available only for the Mixture and Eulerian multiphase models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            super().__init__(path, service)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Specifies the interfacial area model for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)

            class iac_expert(TUIMenu):
                """
                Enters the IAC expert setting menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def ishii_kim_model(self, *args, **kwargs):
                    """
                    Sets Ishii-Kim model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)
                def yao_morel_model(self, *args, **kwargs):
                    """
                    Sets Yao-Morel model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)
                def hibiki_ishii_model(self, *args, **kwargs):
                    """
                    Sets Hibiki-Ishii model coefficients.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)
                def iac_pseudo_time_step(self, *args, **kwargs):
                    """
                    Set iac pseudo-time.
                    """
                    return PyMenu(self.service, "/define/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)

        class materials(TUIMenu):
            """
            Enters the materials menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_base = self.__class__.data_base(path + ["data_base"], service)
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a material from local storage.
                """
                return PyMenu(self.service, "/define/materials/delete").execute(*args, **kwargs)
            def copy_by_formula(self, *args, **kwargs):
                """
                Copies a material from the database by formula.
                """
                return PyMenu(self.service, "/define/materials/copy_by_formula").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copies a material from the database.
                """
                return PyMenu(self.service, "/define/materials/copy").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a locally-stored material.
                """
                return PyMenu(self.service, "/define/materials/list_properties").execute(*args, **kwargs)
            def change_create(self, *args, **kwargs):
                """
                Changes the properties of a locally-stored material or create a new material.   Generally, the properties you enter at the prompts will be filtered according to your case and model settings. However, some of the listed properties may not match the selection choice in the Graphics User Interface. Typically, those excessive properties in the Text User Interface will not be used in your simulation.
                """
                return PyMenu(self.service, "/define/materials/change_create").execute(*args, **kwargs)
            def list_materials(self, *args, **kwargs):
                """
                Lists all locally-stored materials.
                """
                return PyMenu(self.service, "/define/materials/list_materials").execute(*args, **kwargs)

            class data_base(TUIMenu):
                """
                Enters the material database menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def new(self, *args, **kwargs):
                    """
                    Defines new material.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/new").execute(*args, **kwargs)
                def save(self, *args, **kwargs):
                    """
                    Saves user-defined database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/save").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits material.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/edit").execute(*args, **kwargs)
                def database_type(self, *args, **kwargs):
                    """
                    Sets the database type 	(fluent-database, 	granta-mds, or 	user-defined).
                    """
                    return PyMenu(self.service, "/define/materials/data_base/database_type").execute(*args, **kwargs)
                def list_materials(self, *args, **kwargs):
                    """
                    Lists all materials in the database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/list_materials").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a material in the database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/list_properties").execute(*args, **kwargs)

        class reference_frames(TUIMenu):
            """
            Enters the reference frames menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                Lists all of the reference frames.
                """
                return PyMenu(self.service, "/define/reference_frames/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Allows you to edit a reference frame.
                """
                return PyMenu(self.service, "/define/reference_frames/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/list_properties").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/display").execute(*args, **kwargs)
            def hide(self, *args, **kwargs):
                """
                Removes the specified reference frame from the graphics window.
                """
                return PyMenu(self.service, "/define/reference_frames/hide").execute(*args, **kwargs)
            def display_edit(self, *args, **kwargs):
                """
                Display and edit reference frame from graphics.
                """
                return PyMenu(self.service, "/define/reference_frames/display_edit").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new reference frame.
                """
                return PyMenu(self.service, "/define/reference_frames/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes the reference frame you specify.
                """
                return PyMenu(self.service, "/define/reference_frames/delete").execute(*args, **kwargs)

        class virtual_boundary(TUIMenu):
            """
            Manage Virtual Boundaries.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def hole_geometry(self, *args, **kwargs):
                """
                Create a Hole Geometry template.
                """
                return PyMenu(self.service, "/define/virtual_boundary/hole_geometry").execute(*args, **kwargs)
            def boundary_interface(self, *args, **kwargs):
                """
                Create a Boundary Interface.
                """
                return PyMenu(self.service, "/define/virtual_boundary/boundary_interface").execute(*args, **kwargs)

        class turbo_model(TUIMenu):
            """
            Enters the turbo menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.general_turbo_interface_settings = self.__class__.general_turbo_interface_settings(path + ["general_turbo_interface_settings"], service)
                self.turbo_topology = self.__class__.turbo_topology(path + ["turbo_topology"], service)
                self.blade_flutter_harmonics = self.__class__.blade_flutter_harmonics(path + ["blade_flutter_harmonics"], service)
                super().__init__(path, service)
            def graphics_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/define/turbo_model/graphics_extra_settings").execute(*args, **kwargs)
            def isentropic_efficiency(self, *args, **kwargs):
                """
                Compute isentropic efficiency using general property functions for enthalpy.
                """
                return PyMenu(self.service, "/define/turbo_model/isentropic_efficiency").execute(*args, **kwargs)
            def append_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/append_graphics_spectral_content").execute(*args, **kwargs)
            def turbo_interface_check(self, *args, **kwargs):
                """
                Check General Turbo Interface and Phase-lag.
                """
                return PyMenu(self.service, "/define/turbo_model/turbo_interface_check").execute(*args, **kwargs)
            def append_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/append_phaselag_spectral_content").execute(*args, **kwargs)
            def delete_phaselag_spectral_content(self, *args, **kwargs):
                """
                Delete phaselag related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/delete_phaselag_spectral_content").execute(*args, **kwargs)
            def create_turbomachine_description(self, *args, **kwargs):
                """
                Define turbomachine description.
                """
                return PyMenu(self.service, "/define/turbo_model/create_turbomachine_description").execute(*args, **kwargs)
            def blade_flutter_row(self, *args, **kwargs):
                """
                Define the periodic displacement row.
                """
                return PyMenu(self.service, "/define/turbo_model/blade_flutter_row").execute(*args, **kwargs)
            def list_phaselag_state(self, *args, **kwargs):
                """
                List all phaselag related case settings.
                """
                return PyMenu(self.service, "/define/turbo_model/list_phaselag_state").execute(*args, **kwargs)
            def create_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/create_phaselag_spectral_content").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/define/turbo_model/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def list_graphics_spectral_content(self, *args, **kwargs):
                """
                List post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/list_graphics_spectral_content").execute(*args, **kwargs)
            def delete_turbomachine_description(self, *args, **kwargs):
                """
                Delete turbomachine description.
                """
                return PyMenu(self.service, "/define/turbo_model/delete_turbomachine_description").execute(*args, **kwargs)
            def create_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/create_graphics_spectral_content").execute(*args, **kwargs)
            def separate_nonoverlapping_interface_boundary(self, *args, **kwargs):
                """
                Split a general turbo interface non-overlapping zone.
                """
                return PyMenu(self.service, "/define/turbo_model/separate_nonoverlapping_interface_boundary").execute(*args, **kwargs)
            def phaselag_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/define/turbo_model/phaselag_extra_settings").execute(*args, **kwargs)
            def list_turbomachine_description(self, *args, **kwargs):
                """
                List turbomachine description.
                """
                return PyMenu(self.service, "/define/turbo_model/list_turbomachine_description").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/define/turbo_model/make_phaselag_from_periodic").execute(*args, **kwargs)
            def enable_turbo_model(self, *args, **kwargs):
                """
                Enables/disables turbo model menu.
                """
                return PyMenu(self.service, "/define/turbo_model/enable_turbo_model").execute(*args, **kwargs)
            def delete_graphics_spectral_content(self, *args, **kwargs):
                """
                Delete post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/delete_graphics_spectral_content").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Creates a general turbo interface.
                """
                return PyMenu(self.service, "/define/turbo_model/turbo_create").execute(*args, **kwargs)

            class general_turbo_interface_settings(TUIMenu):
                """
                Enters the General Turbo Interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.mixing_plane_model_settings = self.__class__.mixing_plane_model_settings(path + ["mixing_plane_model_settings"], service)
                    super().__init__(path, service)
                def expert(self, *args, **kwargs):
                    """
                    Set the expert parameters for turbo interfaces.
                    """
                    return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/expert").execute(*args, **kwargs)

                class mixing_plane_model_settings(TUIMenu):
                    """
                    Defines settings for the mixing plane model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def number_of_bands(self, *args, **kwargs):
                        """
                        Sets the number of bands to be used for mixing.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/number_of_bands").execute(*args, **kwargs)
                    def mixing_set_constraint(self, *args, **kwargs):
                        """
                        To set the mixing of primitive or total variable approach.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/mixing_set_constraint").execute(*args, **kwargs)
                    def bands_type(self, *args, **kwargs):
                        """
                        Specifies the averaging bands for mixing as fixed or variable width.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/bands_type").execute(*args, **kwargs)
                    def averaging_method(self, *args, **kwargs):
                        """
                        Set the averaging method for the mixing.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/averaging_method").execute(*args, **kwargs)
                    def list_mixing_planes(self, *args, **kwargs):
                        """
                        List the settings of mixing planes in the case.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/list_mixing_planes").execute(*args, **kwargs)

            class turbo_topology(TUIMenu):
                """
                Enters the turbo topology menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a previously created turbo topology.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/delete").execute(*args, **kwargs)
                def define_topology(self, *args, **kwargs):
                    """
                    Defines a turbo topology.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/define_topology").execute(*args, **kwargs)
                def mesh_method(self, *args, **kwargs):
                    """
                    Sets turbo structured mesh generation method.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/mesh_method").execute(*args, **kwargs)
                def search_method(self, *args, **kwargs):
                    """
                    Sets search method for a topology.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/search_method").execute(*args, **kwargs)
                def projection_method(self, *args, **kwargs):
                    """
                    Sets 2D projection method.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/projection_method").execute(*args, **kwargs)

            class blade_flutter_harmonics(TUIMenu):
                """
                Enters the blade flutter harmonics options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_harmonic_exports(self, *args, **kwargs):
                    """
                    Writes harmonic export data.
                    """
                    return PyMenu(self.service, "/define/turbo_model/blade_flutter_harmonics/write_harmonic_exports").execute(*args, **kwargs)
                def enable_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates/Deletes flutter harmonic export data.
                    """
                    return PyMenu(self.service, "/define/turbo_model/blade_flutter_harmonics/enable_harmonic_exports").execute(*args, **kwargs)
                def write_aerodamping_vs_nodal_diameter(self, *args, **kwargs):
                    """
                    Reads report definition file and Writes influence coefficient aerodynamic damping values vs nodal diameter.
                    """
                    return PyMenu(self.service, "/define/turbo_model/blade_flutter_harmonics/write_aerodamping_vs_nodal_diameter").execute(*args, **kwargs)

        class user_defined(TUIMenu):
            """
            Enters the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def fan_model(self, *args, **kwargs):
                """
                Configures user-defined fan model.
                """
                return PyMenu(self.service, "/define/user_defined/fan_model").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/define/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/define/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hooks up user-defined functions.
                """
                return PyMenu(self.service, "/define/user_defined/function_hooks").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/define/user_defined/one_D_coupling").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/define/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def interpreted_functions(self, *args, **kwargs):
                """
                Loads interpreted user-defined functions.
                """
                return PyMenu(self.service, "/define/user_defined/interpreted_functions").execute(*args, **kwargs)
            def execute_on_demand(self, *args, **kwargs):
                """
                Executes UDFs on demand.
                """
                return PyMenu(self.service, "/define/user_defined/execute_on_demand").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocates user-defined memory.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_memory").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Opens user-defined function library.
                """
                return PyMenu(self.service, "/define/user_defined/compiled_functions").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Defines user-defined scalars.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_scalars").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/define/user_defined/use_contributed_cpp").execute(*args, **kwargs)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enables/disables the use of a built-in compiler (Clang) when the define/user-defined/compiled-functions text command is used. This text command / compiler is available for Windows only, and is provided as part of the ANSYS Fluent installation. It is recommended that you enable this text command when the compiler you installed on your machine is an older version that is no longer supported. Note that the built-in compiler is used automatically if Fluent determines that you have not installed Microsoft Visual Studio or Clang on your computer, whether this text command is enabled or not.
                """
                return PyMenu(self.service, "/define/user_defined/use_built_in_compiler").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enters the real-gas menu to enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nist_settings(self, *args, **kwargs):
                    """
                    Specifies the name and the location for the REFPROP library and fluid files.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the NIST real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the NIST real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the user-defined real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Loads a user-defined multispecies real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Selects the state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/set_state").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enters the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                super().__init__(path, service)
            def crevice_model(self, *args, **kwargs):
                """
                Enables/disables the crevice model.
                """
                return PyMenu(self.service, "/define/models/crevice_model").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/define/models/virtual_blade_model").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enables/disables the steady solution model.
                """
                return PyMenu(self.service, "/define/models/steady").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Selects the first-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_1st_order").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Selects the second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Selects the bounded second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enters the crevice model controls menu.
                """
                return PyMenu(self.service, "/define/models/crevice_model_controls").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Loads addon module.
                """
                return PyMenu(self.service, "/define/models/addon_module").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Selects the backward Euler method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_euler").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enables/disables frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/define/models/frozen_flux").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enables/disables axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/define/models/swirl").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/define/models/vbm").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enables/disables the NOx model.
                """
                return PyMenu(self.service, "/define/models/nox").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enables the dual potential MSMD battery model. For text commands that become available when the battery model is enabled, refer to Battery Model Text Commands.
                """
                return PyMenu(self.service, "/define/models/battery_model").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enables/disables noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/define/models/noniterative_time_advance").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/define/models/energy").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Selects the Newmark method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enables/disables the ablation model.
                """
                return PyMenu(self.service, "/define/models/ablation").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enables/disables the soot model.
                """
                return PyMenu(self.service, "/define/models/soot").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enables/disables the electric-potential model.
                """
                return PyMenu(self.service, "/define/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Selects the explicit transient formulation. This text command is only available for unsteady cases that use the density-based solver with the explicit formulation.
                """
                return PyMenu(self.service, "/define/models/unsteady_global_time").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enables/disables the solidification and melting model.
                """
                return PyMenu(self.service, "/define/models/solidification_melting").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Specifies whether or not the domain is axisymmetric.
                """
                return PyMenu(self.service, "/define/models/axisymmetric").execute(*args, **kwargs)

            class dpm(TUIMenu):
                """
                Enters the dispersed phase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.interaction = self.__class__.interaction(path + ["interaction"], service)
                    self.erosion_dynamic_mesh = self.__class__.erosion_dynamic_mesh(path + ["erosion_dynamic_mesh"], service)
                    self.stripping_options = self.__class__.stripping_options(path + ["stripping_options"], service)
                    self.options = self.__class__.options(path + ["options"], service)
                    self.parallel = self.__class__.parallel(path + ["parallel"], service)
                    self.numerics = self.__class__.numerics(path + ["numerics"], service)
                    self.collisions = self.__class__.collisions(path + ["collisions"], service)
                    self.splash_options = self.__class__.splash_options(path + ["splash_options"], service)
                    super().__init__(path, service)
                def clear_particles_from_domain(self, *args, **kwargs):
                    """
                    Removes/keeps all particles currently in the domain.
                    """
                    return PyMenu(self.service, "/define/models/dpm/clear_particles_from_domain").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Sets DPM user-defined functions.
                    """
                    return PyMenu(self.service, "/define/models/dpm/user_defined").execute(*args, **kwargs)
                def fill_injection_material_sources(self, *args, **kwargs):
                    """
                    Initialize the DPM sources corresponding to each material.
                    """
                    return PyMenu(self.service, "/define/models/dpm/fill_injection_material_sources").execute(*args, **kwargs)
                def spray_model(self, *args, **kwargs):
                    """
                    Enters the spray model menu. This command is available only if the breakup model 	enabled globally.
                    """
                    return PyMenu(self.service, "/define/models/dpm/spray_model").execute(*args, **kwargs)
                def injections(self, *args, **kwargs):
                    """
                    Enters the injections menu.
                    """
                    return PyMenu(self.service, "/define/models/dpm/injections").execute(*args, **kwargs)
                def unsteady_tracking(self, *args, **kwargs):
                    """
                    Enables/disables unsteady particle tracking.
                    """
                    return PyMenu(self.service, "/define/models/dpm/unsteady_tracking").execute(*args, **kwargs)

                class interaction(TUIMenu):
                    """
                    Sets parameters for coupled discrete phase calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_source_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM source terms due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_source_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def linearized_dpm_source_terms_limiter(self, *args, **kwargs):
                        """
                        Relative limit for DPM source linear coefficient with respect to fluid linear Ap coefficient.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_source_terms_limiter").execute(*args, **kwargs)
                    def update_dpm_sources_every_flow_iteration(self, *args, **kwargs):
                        """
                        Enables/disables the update of DPM source terms every flow iteration (if this option is not enabled, the terms will be updated every DPM iteration).
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/update_dpm_sources_every_flow_iteration").execute(*args, **kwargs)
                    def ddpm_energy_coupling_via_source_term(self, *args, **kwargs):
                        """
                        Energy coupling in DDPM established via source term.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_energy_coupling_via_source_term").execute(*args, **kwargs)
                    def keep_linearized_dpm_source_terms_constant(self, *args, **kwargs):
                        """
                        Keep linearized DPM source terms constant until the next DPM Update.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/keep_linearized_dpm_source_terms_constant").execute(*args, **kwargs)
                    def implicit_source_term_coupling(self, *args, **kwargs):
                        """
                        Enables/disables implicit treatment for all DPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/implicit_source_term_coupling").execute(*args, **kwargs)
                    def ddpm_iad_particle(self, *args, **kwargs):
                        """
                        Enable/disable the non-default interfacial area method IA-particle.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_iad_particle").execute(*args, **kwargs)
                    def linearized_dpm_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables linearization of source terms for the discrete phase.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_source_terms").execute(*args, **kwargs)
                    def underrelaxation_factor(self, *args, **kwargs):
                        """
                        Sets the under-relaxation factor for the discrete phase sources.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/underrelaxation_factor").execute(*args, **kwargs)
                    def dpm_iteration_interval(self, *args, **kwargs):
                        """
                        Sets the frequency with which the particle trajectory calculations are introduced.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/dpm_iteration_interval").execute(*args, **kwargs)
                    def replace_dpm_mass_source_by_mixture_fraction(self, *args, **kwargs):
                        """
                        When enabled, recalculates the mixture fraction source terms as a function of the primary mixture fraction. This command is available for non- or partially-premixed combustion cases only.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/replace_dpm_mass_source_by_mixture_fraction").execute(*args, **kwargs)
                    def ddpm_enhanced_inter_phase_exchange(self, *args, **kwargs):
                        """
                        Enhanced Eulerian inter-phase exchange.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_enhanced_inter_phase_exchange").execute(*args, **kwargs)
                    def min_vf_threshold_for_dpm_src_scaling(self, *args, **kwargs):
                        """
                        Minimum DPM volume fraction below which no DPM source scaling is applied.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/min_vf_threshold_for_dpm_src_scaling").execute(*args, **kwargs)
                    def enable_drag_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM drag coefficient due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_drag_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def max_vf_allowed_for_blocking(self, *args, **kwargs):
                        """
                        Maximum DPM volume fraction used in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/max_vf_allowed_for_blocking").execute(*args, **kwargs)
                    def enable_flow_blocking_by_particles(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_flow_blocking_by_particles").execute(*args, **kwargs)
                    def reset_sources_at_timestep(self, *args, **kwargs):
                        """
                        Enables/disables flush of DPM source terms at beginning of every time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/reset_sources_at_timestep").execute(*args, **kwargs)
                    def choice_of_eulerian_phase_for_interaction(self, *args, **kwargs):
                        """
                        Enable/disable the option to choose for every injection the Eulerian phase for the DPM continuous phase interaction.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/choice_of_eulerian_phase_for_interaction").execute(*args, **kwargs)
                    def linear_growth_of_dpm_source_term(self, *args, **kwargs):
                        """
                        Enables/disables the linear ramping up of the DPM source terms at every DPM iteration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linear_growth_of_dpm_source_term").execute(*args, **kwargs)
                    def coupled_calculations(self, *args, **kwargs):
                        """
                        Selects whether or not to couple continuous and discrete phase calculations.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/coupled_calculations").execute(*args, **kwargs)
                    def implicit_momentum_coupling(self, *args, **kwargs):
                        """
                        Enables/disables implicit treatment for the DPM momentum source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/implicit_momentum_coupling").execute(*args, **kwargs)
                    def linearized_dpm_species_source_terms(self, *args, **kwargs):
                        """
                        Perform linearization of species source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_species_source_terms").execute(*args, **kwargs)
                    def linearized_dpm_mixture_fraction_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables linearization of mixture fraction source terms. This command is available only for non- or partially-premixed combustion cases.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_mixture_fraction_source_terms").execute(*args, **kwargs)

                class erosion_dynamic_mesh(TUIMenu):
                    """
                    Enters the menu to enable/configure/run the erosion-dynamic mesh interaction.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.general_parameters = self.__class__.general_parameters(path + ["general_parameters"], service)
                        self.run_parameters = self.__class__.run_parameters(path + ["run_parameters"], service)
                        super().__init__(path, service)
                    def run_simulation(self, *args, **kwargs):
                        """
                        Performs a coupled erosion-dynamic mesh simulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_simulation").execute(*args, **kwargs)
                    def enable_erosion_dynamic_mesh_coupling(self, *args, **kwargs):
                        """
                        Enables mesh deformation due to wall erosion.
                        """
                        return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/enable_erosion_dynamic_mesh_coupling").execute(*args, **kwargs)

                    class general_parameters(TUIMenu):
                        """
                        Enters the menu for setting erosion coupling with dynamic mesh.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def erosion_settings(self, *args, **kwargs):
                            """
                            Sets parameters for erosion calculations.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/erosion_settings").execute(*args, **kwargs)
                        def dynamic_mesh_settings(self, *args, **kwargs):
                            """
                            Sets parameters for dynamic mesh calculations.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/dynamic_mesh_settings").execute(*args, **kwargs)
                        def participating_walls(self, *args, **kwargs):
                            """
                            Specifies all participating walls.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/participating_walls").execute(*args, **kwargs)

                    class run_parameters(TUIMenu):
                        """
                        Manages erosion-dynamic mesh run settings.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def simulation_termination(self, *args, **kwargs):
                            """
                            Sets the total time of erosion.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/simulation_termination").execute(*args, **kwargs)
                        def mesh_motion_time_step(self, *args, **kwargs):
                            """
                            Sets the mesh motion time stepping parameters and method.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/mesh_motion_time_step").execute(*args, **kwargs)
                        def autosave_files(self, *args, **kwargs):
                            """
                            Sets the iteration increment and filename to save data files.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_files").execute(*args, **kwargs)
                        def autosave_graphics(self, *args, **kwargs):
                            """
                            Sets the iteration increment to save graphics files.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_graphics").execute(*args, **kwargs)
                        def flow_simulation_control(self, *args, **kwargs):
                            """
                            Sets the number of iterations per flow simulation step.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/flow_simulation_control").execute(*args, **kwargs)

                class stripping_options(TUIMenu):
                    """
                    Enters the stripping options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def diameter_coefficient(self, *args, **kwargs):
                        """
                        Sets the diameter coefficient (  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/dpm/stripping_options/diameter_coefficient").execute(*args, **kwargs)
                    def mass_coefficient(self, *args, **kwargs):
                        """
                        Sets the mass coefficient (  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/dpm/stripping_options/mass_coefficient").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    Enters the options menu to set optional models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def thermophoretic_force(self, *args, **kwargs):
                        """
                        Enables/disables thermophoretic force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/thermophoretic_force").execute(*args, **kwargs)
                    def saffman_lift_force(self, *args, **kwargs):
                        """
                        Enables/disables Saffman lift force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/saffman_lift_force").execute(*args, **kwargs)
                    def track_in_absolute_frame(self, *args, **kwargs):
                        """
                        Enables/disables tracking in absolute frame.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/track_in_absolute_frame").execute(*args, **kwargs)
                    def vaporization_options(self, *args, **kwargs):
                        """
                        Sets Vaporization options.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/vaporization_options").execute(*args, **kwargs)
                    def erosion_accretion(self, *args, **kwargs):
                        """
                        Enables/disables erosion/accretion.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/erosion_accretion").execute(*args, **kwargs)
                    def stagger_spatially_atomizer_injections(self, *args, **kwargs):
                        """
                        Enables/disables spatial staggering for atomizer and solid-cone injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_spatially_atomizer_injections").execute(*args, **kwargs)
                    def remove_wall_film_temperature_limiter(self, *args, **kwargs):
                        """
                        Answering yes at the prompt removes the wall temperature limiter for Lagrangian wall-film walls. If you enter no (default), two additional prompts will appear in the console allowing you to define the temperature difference above the boiling point and to enable/disable the reporting of the Leidenfrost temperature on the wall faces.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/remove_wall_film_temperature_limiter").execute(*args, **kwargs)
                    def pressure_gradient_force(self, *args, **kwargs):
                        """
                        Enables/disables inclusion of pressure gradient effects in the particle force balance.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/pressure_gradient_force").execute(*args, **kwargs)
                    def enable_contour_plots(self, *args, **kwargs):
                        """
                        Enables computation of mean and/or RMS values of additional discrete phase variables for postprocessing.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/enable_contour_plots").execute(*args, **kwargs)
                    def brownian_motion(self, *args, **kwargs):
                        """
                        Enables/disables Brownian motion of particles.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/brownian_motion").execute(*args, **kwargs)
                    def step_report_sig_figures(self, *args, **kwargs):
                        """
                        Sets significant figures in the step-by-step report.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/step_report_sig_figures").execute(*args, **kwargs)
                    def particle_radiation(self, *args, **kwargs):
                        """
                        Enables/disables particle radiation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/particle_radiation").execute(*args, **kwargs)
                    def two_way_coupling(self, *args, **kwargs):
                        """
                        Enables/disables calculation of DPM sources in TKE equation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/two_way_coupling").execute(*args, **kwargs)
                    def set_minimum_particle_diameter(self, *args, **kwargs):
                        """
                        Set the minimum particle diameter.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/set_minimum_particle_diameter").execute(*args, **kwargs)
                    def init_erosion_accretion_rate(self, *args, **kwargs):
                        """
                        Initializes the erosion/accretion rates with zero.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/init_erosion_accretion_rate").execute(*args, **kwargs)
                    def allow_supercritical_pressure_vaporization(self, *args, **kwargs):
                        """
                        Enforces the switching from vaporization to boiling even if the boiling point is not calculated from the vapor pressure data. If the pressure in your model is above critical you must retain the default setting (yes). This options is available only if whenPressure Dependent Boiling is enabled in the Physical Models tab of the Discrete Phase Models dialog box. For more details, see .
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/allow_supercritical_pressure_vaporization").execute(*args, **kwargs)
                    def maximum_udf_species(self, *args, **kwargs):
                        """
                        Specifies the maximum number of species that will be accessible from discrete phase model UDFs. Only species with indices up to this value are accessible in discrete phase model UDFs.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/maximum_udf_species").execute(*args, **kwargs)
                    def virtual_mass_force(self, *args, **kwargs):
                        """
                        Enables/disables inclusion of the virtual mass force in the particle force balance.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/virtual_mass_force").execute(*args, **kwargs)
                    def uniform_mass_distribution_for_injections(self, *args, **kwargs):
                        """
                        Specifies a uniform distribution of mass over the cross-section of solid cone and atomizer injections. This can become important when the mesh is smaller than the diameter (or another characteristic size) of the injection.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/uniform_mass_distribution_for_injections").execute(*args, **kwargs)
                    def stagger_radius(self, *args, **kwargs):
                        """
                        Specifies the region over which to spatially stagger particles when particle-staggering is enabled for non-atomizer injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_radius").execute(*args, **kwargs)
                    def use_absolute_pressure_for_vaporization(self, *args, **kwargs):
                        """
                        Determines whether the absolute pressure or constant operating pressure (specified in define/operating-conditions/operating-pressure) will be used in vaporization rates calculations.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/use_absolute_pressure_for_vaporization").execute(*args, **kwargs)
                    def lowest_volatiles_mass_fraction(self, *args, **kwargs):
                        """
                        Set the lowest volatiles mass fraction.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/lowest_volatiles_mass_fraction").execute(*args, **kwargs)
                    def treat_multicomponent_saturation_temperature_failure(self, *args, **kwargs):
                        """
                        Enables/disables dumping multicomponent particle mass into the continuous phase if the saturation temperature calculation fails.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/treat_multicomponent_saturation_temperature_failure").execute(*args, **kwargs)
                    def scr_urea_deposition_risk_analysis(self, *args, **kwargs):
                        """
                        Enters the menu for setting up the risk for solids deposit formation for the Selective Catalytic Reduction (SCR) process. For more information, see .
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/scr_urea_deposition_risk_analysis").execute(*args, **kwargs)
                    def current_positions_in_sample_file_format(self, *args, **kwargs):
                        """
                        When enabled, generates a file containing particle current positions (step-by-step history report for unsteady tracking) in the sampling file format.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/current_positions_in_sample_file_format").execute(*args, **kwargs)
                    def stagger_spatially_standard_injections(self, *args, **kwargs):
                        """
                        Enables/disables spatial staggering for standard (non-atomizer and non-solid-cone) injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_spatially_standard_injections").execute(*args, **kwargs)
                    def set_thermolysis_limit(self, *args, **kwargs):
                        """
                        Sets the limit for the thermolysis model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/set_thermolysis_limit").execute(*args, **kwargs)
                    def vaporization_heat_transfer_averaging(self, *args, **kwargs):
                        """
                        Enables averaging of the Spalding heat transfer term for the convection/diffusion-controlled model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/vaporization_heat_transfer_averaging").execute(*args, **kwargs)
                    def stagger_temporally(self, *args, **kwargs):
                        """
                        Enables/disables temporal staggering.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_temporally").execute(*args, **kwargs)
                    def convective_film_heat_transfer(self, *args, **kwargs):
                        """
                        Enable/disable convection/conduction film to wall heat transfer model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/convective_film_heat_transfer").execute(*args, **kwargs)
                    def staggering_factor(self, *args, **kwargs):
                        """
                        S.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/staggering_factor").execute(*args, **kwargs)
                    def include_lwf_particles_in_dpm_concentration(self, *args, **kwargs):
                        """
                        Include LWF particle mass in DPM Concentration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/include_lwf_particles_in_dpm_concentration").execute(*args, **kwargs)
                    def ensemble_average(self, *args, **kwargs):
                        """
                        Ensembles average cloud properties.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/ensemble_average").execute(*args, **kwargs)

                class parallel(TUIMenu):
                    """
                    Enters the parallel menu to set parameters for parallel DPM calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def use_hybrid(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed using multicore cluster computing or shared-memory machines. This option works in conjunction withopenmpi for a dynamic load balancing without migration of cells.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_hybrid").execute(*args, **kwargs)
                    def hybrid_collision_variant(self, *args, **kwargs):
                        """
                        Further reduce the residual risk of dead-locks in the experimental feature that
                        allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_variant").execute(*args, **kwargs)
                    def enable_workpile(self, *args, **kwargs):
                        """
                        Turns on/off particle workpile algorithm. This option is only available when the define/models/dpm/parallel/use-shared-memory option is selected.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/enable_workpile").execute(*args, **kwargs)
                    def hybrid_collision_model(self, *args, **kwargs):
                        """
                        An EXPERIMENTAL feature to allow 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_model").execute(*args, **kwargs)
                    def hybrid_workpile(self, *args, **kwargs):
                        """
                        Optimize multi-thread load balancing within each partition in hybrid-parallel DPM tracking.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_workpile").execute(*args, **kwargs)
                    def hybrid_2domain(self, *args, **kwargs):
                        """
                        Enables/disables the use of a second domain for DPM particle tracking.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_2domain").execute(*args, **kwargs)
                    def fix_source_term_accumulation_order(self, *args, **kwargs):
                        """
                        Enforce deterministic order of source term accumulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/fix_source_term_accumulation_order").execute(*args, **kwargs)
                    def n_threads(self, *args, **kwargs):
                        """
                        Sets the number of processors to use for DPM. This option is only available when the define/models/dpm/parallel/enable-workpile? option is enabled.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/n_threads").execute(*args, **kwargs)
                    def report(self, *args, **kwargs):
                        """
                        Prints particle workpile statistics. This option is only available when the define/models/dpm/parallel/enable-workpile? option is enabled.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/report").execute(*args, **kwargs)
                    def hybrid_collision_unidirectional(self, *args, **kwargs):
                        """
                        A faster, yet potentially somewhat less accurate, modification to the beta feature
                        that allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_unidirectional").execute(*args, **kwargs)
                    def use_shared_memory(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed on shared-memory multiprocessor machines.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_shared_memory").execute(*args, **kwargs)
                    def use_message_passing(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed using cluster computing or shared-memory machines. With this option, the compute node processes themselves perform the particle work on their local partitions and particle migration to other compute nodes is implemented using message passing primitives.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_message_passing").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enters the menu for expert DPM parallel text commands.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def partition_method_hybrid_2domain(self, *args, **kwargs):
                            """
                            Enables/disables a partitioning method that is more granular and can yield faster calculations (especially for cases that are running on a low to moderate number of processors). This partitioning method is only applied when you use the DPM domain for the hybrid parallel DPM tracking mode (that is, when you have enabled the define/models/dpm/parallel/hybrid-2domain? text command).
                            """
                            return PyMenu(self.service, "/define/models/dpm/parallel/expert/partition_method_hybrid_2domain").execute(*args, **kwargs)

                class numerics(TUIMenu):
                    """
                    Enters the numerics menu to set numerical solution parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.high_resolution_tracking = self.__class__.high_resolution_tracking(path + ["high_resolution_tracking"], service)
                        super().__init__(path, service)
                    def re_randomize_every_iteration(self, *args, **kwargs):
                        """
                        Determines whether or not the initial particle positions will vary from iteration to iteration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/re_randomize_every_iteration").execute(*args, **kwargs)
                    def error_control(self, *args, **kwargs):
                        """
                        Adapts integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/error_control").execute(*args, **kwargs)
                    def tracking_parameters(self, *args, **kwargs):
                        """
                        Sets parameters for the (initial) tracking step length.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_parameters").execute(*args, **kwargs)
                    def dynamic_interaction(self, *args, **kwargs):
                        """
                        Enable/disable dynamic interaction range.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/dynamic_interaction").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Adjust the DPM tracker's verbosity level.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/verbosity").execute(*args, **kwargs)
                    def gaussian_factor(self, *args, **kwargs):
                        """
                        Specifies the Gaussian constant when using thegaussian kernel for mesh node averaging.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/gaussian_factor").execute(*args, **kwargs)
                    def mppic_settings(self, *args, **kwargs):
                        """
                        Enable PIC and MPPIC to compute DPM and DDPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/mppic_settings").execute(*args, **kwargs)
                    def tracking_statistics(self, *args, **kwargs):
                        """
                        Controls the format of the one-line tracking statistics to be printed after every DPM tracking pass. A value of 0 (the default) prints only fates with non-zero values. A value of 1 prints all fates, including fates with zero values.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_statistics").execute(*args, **kwargs)
                    def enhanced_packing_limit_numerics(self, *args, **kwargs):
                        """
                        Enable enhanced packing limit numerics to avoid exceeding of packing limit for granular phases.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/enhanced_packing_limit_numerics").execute(*args, **kwargs)
                    def enable_node_based_averaging(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DPM quantities.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/enable_node_based_averaging").execute(*args, **kwargs)
                    def average_kernel(self, *args, **kwargs):
                        """
                        Specifies the averaging kernel to use for mesh node averaging.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_kernel").execute(*args, **kwargs)
                    def tracking_scheme(self, *args, **kwargs):
                        """
                        Specifies a tracking scheme.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_scheme").execute(*args, **kwargs)
                    def re_randomize_every_timestep(self, *args, **kwargs):
                        """
                        Determines whether or not the initial particle positions will vary from time step to time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/re_randomize_every_timestep").execute(*args, **kwargs)
                    def vaporization_limiting_factors(self, *args, **kwargs):
                        """
                        Sets the Vaporization Fractional Change Limits.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/vaporization_limiting_factors").execute(*args, **kwargs)
                    def automated_scheme_selection(self, *args, **kwargs):
                        """
                        Enables/disables the adaptation of integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/automated_scheme_selection").execute(*args, **kwargs)
                    def minimum_liquid_fraction(self, *args, **kwargs):
                        """
                        A droplet evaporates completely when the remaining mass is below this fraction of the initial droplet mass.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/minimum_liquid_fraction").execute(*args, **kwargs)
                    def predictor_corrector(self, *args, **kwargs):
                        """
                        Enable predictor/corrector approach to track particles.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/predictor_corrector").execute(*args, **kwargs)
                    def granular_stress_tensor(self, *args, **kwargs):
                        """
                        Enable granular stress tensor to be considered with solid pressure gradient as collision force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/granular_stress_tensor").execute(*args, **kwargs)
                    def average_DDPM_variables(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DDPM quantities.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_DDPM_variables").execute(*args, **kwargs)
                    def underrelax_film_height(self, *args, **kwargs):
                        """
                        Sets the under-relaxation factor for the film height calculation. The recommended values range between 0.5 (default) and 0.9.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/underrelax_film_height").execute(*args, **kwargs)
                    def drag_law(self, *args, **kwargs):
                        """
                        Sets the drag law.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/drag_law").execute(*args, **kwargs)
                    def average_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_source_terms").execute(*args, **kwargs)
                    def average_each_step(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging during integration time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_each_step").execute(*args, **kwargs)
                    def coupled_heat_mass_update(self, *args, **kwargs):
                        """
                        Enables/disables coupled heat and mass update.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/coupled_heat_mass_update").execute(*args, **kwargs)

                    class high_resolution_tracking(TUIMenu):
                        """
                        Enters the high resolution tracking menu. See  for more information about these options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.particle_relocation = self.__class__.particle_relocation(path + ["particle_relocation"], service)
                            self.barycentric_interpolation = self.__class__.barycentric_interpolation(path + ["barycentric_interpolation"], service)
                            super().__init__(path, service)
                        def project_wall_film_particles_to_film(self, *args, **kwargs):
                            """
                            Enables/disables projecting existing particles to Lagrangian wall film to track using high-resolution tracking.  When reading in a data file that contains wall film particles previously tracked with the existing ANSYS Fluent tracking method, you need to either clear the particles from the domain or project their positions to the wall film surface using the project-wall-film-particles-to-film? text command prior to using the high-resolution tracking method. After tracking the particles for one timestep, this option can be disabled to improve performance.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/project_wall_film_particles_to_film").execute(*args, **kwargs)
                        def use_particle_timestep_for_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enables/disables the use of the particle timestep for the subtet intersection tolerance with axisymmetric grids (default: enabled). If disabled, the tolerance will be calculated in the same manner as non-axisymmetric meshes (a scaled value of the tolerance which is set using the define/models/dpm/numerics/high-resolution-tracking/set-subtet-intersection-tolerance text command).
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_particle_timestep_for_intersection_tolerance").execute(*args, **kwargs)
                        def enhanced_wallfilm_location_method(self, *args, **kwargs):
                            """
                            Enable enhanced method of locating film particles on faces.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enhanced_wallfilm_location_method").execute(*args, **kwargs)
                        def set_subtet_intersection_tolerance(self, *args, **kwargs):
                            """
                            Specifies the tolerance used in intersection calculations. This tolerance will be scaled by the characteristic cell crossing time of the particle if the enable-automatic-intersection-tolerance? text command is enabled. If that option is disabled, the specified tolerance will be used without scaling. The default intersection tolerance is 10-5.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/set_subtet_intersection_tolerance").execute(*args, **kwargs)
                        def check_subtet_validity(self, *args, **kwargs):
                            """
                            When enabled, checks the validity of a subtet when the particle first enters it. If the subtet is found to be degenerate, the tracking algorithm modifies to accommodate it.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/check_subtet_validity").execute(*args, **kwargs)
                        def always_use_face_centroid_with_periodics(self, *args, **kwargs):
                            """
                            When enabled, ANSYS Fluent uses quad face centroids when creating subtets in cases with periodic boundaries.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/always_use_face_centroid_with_periodics").execute(*args, **kwargs)
                        def boundary_layer_tracking(self, *args, **kwargs):
                            """
                            Enables/disables the calculation of the particle time step that considers both the cell aspect ratio and the particle trajectory. This method improves the accuracy of the predictions in boundary layer cells, particularly in layers where flow gradients are large.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/boundary_layer_tracking").execute(*args, **kwargs)
                        def enable_high_resolution_tracking(self, *args, **kwargs):
                            """
                            Enables/disables high resolution tracking.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_high_resolution_tracking").execute(*args, **kwargs)
                        def load_legacy_particles(self, *args, **kwargs):
                            """
                            Load particles that were tracked without high-resolution tracking enabled.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/load_legacy_particles").execute(*args, **kwargs)
                        def use_velocity_based_error_control(self, *args, **kwargs):
                            """
                            Enables/disables an alternative method of timestep adaption. By default, ANSYS Fluent uses the half-step method of timestep adaption with particle integration. This alternative method of controlling the integration timestep based upon velocity changes is faster; however, you need to ensure that the accuracy is comparable for your specific application.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_velocity_based_error_control").execute(*args, **kwargs)
                        def use_barycentric_sampling(self, *args, **kwargs):
                            """
                            When enabled, this option provides improved accuracy and parallel consistency when sampling particles at planes. This item is available only with the 3D solver. Using the double-precision solver and bounded planes is recommended.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_barycentric_sampling").execute(*args, **kwargs)
                        def use_quad_face_centroid(self, *args, **kwargs):
                            """
                            Enables/disables using quad face centroids when creating subtets. This option changes the way hexahedral cells are decomposed to avoid creating degenerate subtets.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_quad_face_centroid").execute(*args, **kwargs)
                        def enable_automatic_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enables/disables the automatic calculation of intersection tolerance. By default, the tolerance used in intersection calculations is scaled by the residence time of the particle in the cell to improve robustness. For most cases, the scaled tolerance is sufficient to identify all intersections of the particle trajectory and the subtet faces. You can set the intersection tolerance manually using the set-subtet-intersection-tolerance text command.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_automatic_intersection_tolerance").execute(*args, **kwargs)
                        def wallfilm_relocation_tolerance(self, *args, **kwargs):
                            """
                            Set the relocation tolerance for wallfilm particles after remeshing.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/wallfilm_relocation_tolerance").execute(*args, **kwargs)
                        def use_legacy_particle_location_method(self, *args, **kwargs):
                            """
                            Enable legacy method of locating particles in cells.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_legacy_particle_location_method").execute(*args, **kwargs)
                        def remove_stuck_particles(self, *args, **kwargs):
                            """
                            Remove particles that are stuck at edges or faces.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/remove_stuck_particles").execute(*args, **kwargs)
                        def enable_barycentric_intersections(self, *args, **kwargs):
                            """
                            Enables/disables an alternative method of calculating intersections with cell boundaries. Barycentric intersections are linear calculations and are faster than the default intersection algorithm. The default intersection algorithm is second-order for stationary meshes; therefore, using the barycentric intersection may sacrifice accuracy. You must verify that the barycentric intersections provide comparable results to the default intersection method. This option is available only for 3D stationary meshes and the double precision solver.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_barycentric_intersections").execute(*args, **kwargs)
                        def sliding_interface_crossover_fraction(self, *args, **kwargs):
                            """
                            Specifies the fraction of the distance to the subtet center to move the particle.  At non-conformal interfaces, the nodes used for the barycentric interpolation are different on either side of the interface. This may result in incomplete particles due to discontinuities in the variable interpolation. The number of incomplete particles may be reduced by moving the particles slightly off of the sliding interface. Recommended values range between 0 and 0.5.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/sliding_interface_crossover_fraction").execute(*args, **kwargs)
                        def set_film_spreading_parameter(self, *args, **kwargs):
                            """
                            Set the spreading parameter for Lagrangian wallfilm particles.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/set_film_spreading_parameter").execute(*args, **kwargs)

                        class particle_relocation(TUIMenu):
                            """
                            Enter the particle relocation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def enhanced_cell_relocation_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_cell_relocation_method").execute(*args, **kwargs)
                            def load_legacy_particles(self, *args, **kwargs):
                                """
                                Load particles that were tracked without high-resolution tracking enabled.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/load_legacy_particles").execute(*args, **kwargs)
                            def wallfilm_relocation_tolerance_scale_factor(self, *args, **kwargs):
                                """
                                Set the relocation tolerance scaling factor for wallfilm particles after remeshing.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/wallfilm_relocation_tolerance_scale_factor").execute(*args, **kwargs)
                            def use_legacy_particle_location_method(self, *args, **kwargs):
                                """
                                Enable legacy method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/use_legacy_particle_location_method").execute(*args, **kwargs)
                            def overset_relocation_robustness_level(self, *args, **kwargs):
                                """
                                Set the robustness level for particle relocation in overset meshes.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/overset_relocation_robustness_level").execute(*args, **kwargs)
                            def enhanced_wallfilm_location_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating film particles on faces.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_wallfilm_location_method").execute(*args, **kwargs)

                        class barycentric_interpolation(TUIMenu):
                            """
                            Enter the barycentric interpolation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interpolate_flow_cp(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of specific heat to the particle position. This option is recommended when the specific heat varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For flows with constant specific heat, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_cp").execute(*args, **kwargs)
                            def precompute_pdf_species(self, *args, **kwargs):
                                """
                                When this option is enabled for premixed or non-premixed combustion simulations, the species composition in each cell is precomputed prior to tracking particles. This approach may improve performance for cases with many particles and relatively few cells. By default, this option is set to no, and ANSYS Fluent calculates the species composition during particle tracking. The solution results will be identical for both methods.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/precompute_pdf_species").execute(*args, **kwargs)
                            def interpolate_flow_solution_gradients(self, *args, **kwargs):
                                """
                                When enabled, flow solution gradients are interpolated to the particle position. This can be useful when using physical models that depend on these gradients (for example, the thermophoretic force, pressure-gradient force, or virtual mass force). Interpolating the gradients also improves the accuracy and robustness of the trapezoidal numerics scheme, which is the default method for pathlines.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_solution_gradients").execute(*args, **kwargs)
                            def interpolate_flow_viscosity(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of flow viscosity to the particle position. This option is recommended when the flow viscosity varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For flows with constant viscosity, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_viscosity").execute(*args, **kwargs)
                            def interpolate_flow_density(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of the flow density. This option is recommended when the density varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For constant density flows, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_density").execute(*args, **kwargs)
                            def nodal_reconstruction_frequency(self, *args, **kwargs):
                                """
                                Update nodal reconstruction every N'th DPM iteration.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/nodal_reconstruction_frequency").execute(*args, **kwargs)
                            def zero_nodal_velocity_on_walls(self, *args, **kwargs):
                                """
                                When enabled, sets the velocity at wall nodes to zero. (By default, the nodal velocities on walls are first reconstructed from cell and face values and then corrected to ensure that there are no velocity components directed towards the walls). This may be useful if you want to consider particle impingement on the walls. Note that enabling this option will more likely produce incomplete particles as some particles may settle on the walls.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/zero_nodal_velocity_on_walls").execute(*args, **kwargs)
                            def interpolate_temperature(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of temperature to the particle position. The cell temperature is used by default in calculations of heat transfer to/from the particle.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_temperature").execute(*args, **kwargs)
                            def enable_transient_variable_interpolation(self, *args, **kwargs):
                                """
                                Enable transient variable interpolation.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/enable_transient_variable_interpolation").execute(*args, **kwargs)
                            def user_interpolation_function(self, *args, **kwargs):
                                """
                                Enter user interpolation function.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/user_interpolation_function").execute(*args, **kwargs)
                            def interpolate_wallfilm_properties(self, *args, **kwargs):
                                """
                                When enabled, the wall film properties (film height, film mass, and wall shear) are interpolated to the particle position.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_wallfilm_properties").execute(*args, **kwargs)

                class collisions(TUIMenu):
                    """
                    Enters the DEM collisions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.collision_partners = self.__class__.collision_partners(path + ["collision_partners"], service)
                        super().__init__(path, service)
                    def dem_collisions(self, *args, **kwargs):
                        """
                        Enables/disables the DEM collision model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/dem_collisions").execute(*args, **kwargs)
                    def collision_pair_settings(self, *args, **kwargs):
                        """
                        Supplies settings for collisions to a pair of collision partners. You will be prompted to specify theImpact collision partner and the Target collision partner.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/collision_pair_settings").execute(*args, **kwargs)
                    def list_all_pair_settings(self, *args, **kwargs):
                        """
                        For each pair of collision partners, lists the collision laws and their parameters.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/list_all_pair_settings").execute(*args, **kwargs)
                    def max_particle_velocity(self, *args, **kwargs):
                        """
                        Sets the maximum particle velocity that may arise from collisions.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/max_particle_velocity").execute(*args, **kwargs)
                    def collision_mesh(self, *args, **kwargs):
                        """
                        Input for the collision mesh.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/collision_mesh").execute(*args, **kwargs)

                    class collision_partners(TUIMenu):
                        """
                        Manages collision partners.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/delete").execute(*args, **kwargs)
                        def copy(self, *args, **kwargs):
                            """
                            Copies a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/copy").execute(*args, **kwargs)
                        def create(self, *args, **kwargs):
                            """
                            Creates a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/create").execute(*args, **kwargs)
                        def rename(self, *args, **kwargs):
                            """
                            Renames a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/rename").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Lists all known collision partners.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/list").execute(*args, **kwargs)

                class splash_options(TUIMenu):
                    """
                    Enters the splash option menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def splash_pdf_limiting(self, *args, **kwargs):
                        """
                        Sets the splash pdf limiting method. Available methods are: the splash pdf tail limiting (default for the LWF model) and the splash pdf peak limiting (default for the EWF model). For the splash pdf peak limiting, you will be prompted to specify the peak limiting value.
                        """
                        return PyMenu(self.service, "/define/models/dpm/splash_options/splash_pdf_limiting").execute(*args, **kwargs)
                    def orourke_splash_fraction(self, *args, **kwargs):
                        """
                        Enables/disables the O’Rourke formulation (default for the Lagrangian Wall Film (LWF) model). If the O’Rourke formulation is disabled, the Stanton formulation (default for the Eulerian Wall Film (EWF) model) is used in a simulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/splash_options/orourke_splash_fraction").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enters the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dual_cell_model = self.__class__.dual_cell_model(path + ["dual_cell_model"], service)
                    self.macro_model = self.__class__.macro_model(path + ["macro_model"], service)
                    super().__init__(path, service)

                class dual_cell_model(TUIMenu):
                    """
                    Enters the dual cell model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete_heat_exchanger(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/delete_heat_exchanger").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/plot_NTU").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/write_NTU").execute(*args, **kwargs)
                    def alternative_formulation(self, *args, **kwargs):
                        """
                        Enables/disables alternative formulation for heat transfer calculations.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/alternative_formulation").execute(*args, **kwargs)
                    def add_heat_exchanger(self, *args, **kwargs):
                        """
                        Adds heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/add_heat_exchanger").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables the dual cell heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/heat_exchanger").execute(*args, **kwargs)
                    def modify_heat_exchanger(self, *args, **kwargs):
                        """
                        Modifies heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/modify_heat_exchanger").execute(*args, **kwargs)

                class macro_model(TUIMenu):
                    """
                    Enters the heat macro-model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger").execute(*args, **kwargs)
                    def heat_exchanger_group(self, *args, **kwargs):
                        """
                        Defines heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_group").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/write_NTU").execute(*args, **kwargs)
                    def heat_exchanger_zone(self, *args, **kwargs):
                        """
                        Specifies the zone that represents the heat exchanger, the dimensions of the heat exchanger, the macro grid, and the coolant direction and properties.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_zone").execute(*args, **kwargs)
                    def heat_exchanger_macro_report(self, *args, **kwargs):
                        """
                        Reports the computed values of heat rejection, outlet temperature, and inlet temperature for the macroscopic cells (macros) in a heat exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_macro_report").execute(*args, **kwargs)
                    def heat_exchanger_report(self, *args, **kwargs):
                        """
                        Reports the computed values of total heat rejection, outlet temperature, and inlet temperature for a specified heat-exchanger core.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_report").execute(*args, **kwargs)
                    def heat_exchanger_model(self, *args, **kwargs):
                        """
                        Defines heat-exchanger core model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_model").execute(*args, **kwargs)
                    def delete_heat_exchanger_group(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/delete_heat_exchanger_group").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/plot_NTU").execute(*args, **kwargs)

            class radiation(TUIMenu):
                """
                Enters the radiation models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dtrm_parameters = self.__class__.dtrm_parameters(path + ["dtrm_parameters"], service)
                    self.s2s_parameters = self.__class__.s2s_parameters(path + ["s2s_parameters"], service)
                    self.solar_parameters = self.__class__.solar_parameters(path + ["solar_parameters"], service)
                    super().__init__(path, service)
                def method_partially_specular_wall(self, *args, **kwargs):
                    """
                    Sets the method for partially specular wall with discrete ordinate model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/method_partially_specular_wall").execute(*args, **kwargs)
                def non_gray_model_parameters(self, *args, **kwargs):
                    """
                    Sets parameters for non-gray model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/non_gray_model_parameters").execute(*args, **kwargs)
                def radiation_iteration_parameters(self, *args, **kwargs):
                    """
                    Sets iteration parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_iteration_parameters").execute(*args, **kwargs)
                def apply_full_solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the application of the complete solar load to the first wavelength 	band only, reverting to the pre-2019 R1 behavior of the 	Solar Load and Discrete Ordinates models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/apply_full_solar_irradiation").execute(*args, **kwargs)
                def montecarlo(self, *args, **kwargs):
                    """
                    Enables/disables the Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/montecarlo").execute(*args, **kwargs)
                def solar_calculator(self, *args, **kwargs):
                    """
                    Calculates sun direction and intensity.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_calculator").execute(*args, **kwargs)
                def p1(self, *args, **kwargs):
                    """
                    Enables/disables P1 radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/p1").execute(*args, **kwargs)
                def radiation_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_model_parameters").execute(*args, **kwargs)
                def rosseland(self, *args, **kwargs):
                    """
                    Enables/disables Rosseland radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/rosseland").execute(*args, **kwargs)
                def solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the solar irradiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_irradiation").execute(*args, **kwargs)
                def do_acceleration(self, *args, **kwargs):
                    """
                    Enables/disables the acceleration of the discrete 	ordinates (DO) radiation model calculations. Note that 	this text command is only available when running on 	Linux in parallel.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_acceleration").execute(*args, **kwargs)
                def wsggm_cell_based(self, *args, **kwargs):
                    """
                    Enables/disables WSGGM cell based method. Note that when enabled, the wsggm-cell-based option will 	become available in theAbsorption Coefficient drop-down list in the Create/Edit Materials dialog 	box.
                    """
                    return PyMenu(self.service, "/define/models/radiation/wsggm_cell_based").execute(*args, **kwargs)
                def do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_coupling").execute(*args, **kwargs)
                def discrete_ordinates(self, *args, **kwargs):
                    """
                    Enables/disables discrete ordinates radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_ordinates").execute(*args, **kwargs)
                def s2s(self, *args, **kwargs):
                    """
                    Enables/disables S2S radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/s2s").execute(*args, **kwargs)
                def blending_factor(self, *args, **kwargs):
                    """
                    Sets numeric option for Discrete Ordinate model. Make sure thatSecond Order Upwind is selected for the Discrete Ordinates spatial 	discretization for the blending-factor option to 	appear in the text command list.
                    """
                    return PyMenu(self.service, "/define/models/radiation/blending_factor").execute(*args, **kwargs)
                def discrete_transfer(self, *args, **kwargs):
                    """
                    Enables/disables discrete transfer radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_transfer").execute(*args, **kwargs)
                def mc_model_parameters(self, *args, **kwargs):
                    """
                    Specifies Monte Carlo model parameters. This text command is available only when the 	Monte Carlo model is enabled.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_model_parameters").execute(*args, **kwargs)
                def target_cells_per_volume_cluster(self, *args, **kwargs):
                    """
                    Sets the amount of coarsening of the radiation mesh 	for the Monte Carlo radiation model. A number greater 	than one implies coarsening, whereas equal to one 	implies no coarsening.
                    """
                    return PyMenu(self.service, "/define/models/radiation/target_cells_per_volume_cluster").execute(*args, **kwargs)
                def fast_second_order_discrete_ordinate(self, *args, **kwargs):
                    """
                    Enables/disables the fast-second-order option for Discrete Ordinate Model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/fast_second_order_discrete_ordinate").execute(*args, **kwargs)
                def beta_radiation_features(self, *args, **kwargs):
                    """
                    Enable Radiation Models with Non-Iterative Time Advancement (NITA) as Beta features in FL12.0.
                    """
                    return PyMenu(self.service, "/define/models/radiation/beta_radiation_features").execute(*args, **kwargs)
                def mc_under_relaxation(self, *args, **kwargs):
                    """
                    Sets the under-relaxation factor for Monte Carlo radiation sources used in the 	energy equation.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_under_relaxation").execute(*args, **kwargs)
                def solution_method_for_do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables the solution method for DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solution_method_for_do_coupling").execute(*args, **kwargs)
                def solar(self, *args, **kwargs):
                    """
                    Enables/disables solar model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar").execute(*args, **kwargs)

                class dtrm_parameters(TUIMenu):
                    """
                    Enters the dtrm parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def controls(self, *args, **kwargs):
                        """
                        Sets dtrm solution controls.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/controls").execute(*args, **kwargs)
                    def make_globs(self, *args, **kwargs):
                        """
                        Makes globs (coarser mesh) for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/make_globs").execute(*args, **kwargs)
                    def check_ray_file(self, *args, **kwargs):
                        """
                        Reads DTRM rays file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/check_ray_file").execute(*args, **kwargs)
                    def ray_trace(self, *args, **kwargs):
                        """
                        Creates DTRM rays for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/ray_trace").execute(*args, **kwargs)

                class s2s_parameters(TUIMenu):
                    """
                    Enters the S2S parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def use_old_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the old surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_old_cluster_algorithm").execute(*args, **kwargs)
                    def compute_write_vf(self, *args, **kwargs):
                        """
                        Computes/writes surface clusters and view factors for S2S radiation model.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_write_vf").execute(*args, **kwargs)
                    def compute_vf_only(self, *args, **kwargs):
                        """
                        Computes/writes view factors only.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_only").execute(*args, **kwargs)
                    def compute_fpsc_values(self, *args, **kwargs):
                        """
                        Computes only fpsc values based on current settings.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_fpsc_values").execute(*args, **kwargs)
                    def non_participating_boundary_zones_temperature(self, *args, **kwargs):
                        """
                        Sets temperature for the non-participating boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/non_participating_boundary_zones_temperature").execute(*args, **kwargs)
                    def set_global_faces_per_surface_cluster(self, *args, **kwargs):
                        """
                        Sets global value of faces per surface cluster for all boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_global_faces_per_surface_cluster").execute(*args, **kwargs)
                    def print_zonewise_radiation(self, *args, **kwargs):
                        """
                        Prints the zonewise incoming radiation, viewfactors, and average temperature.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_zonewise_radiation").execute(*args, **kwargs)
                    def use_new_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the new surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_new_cluster_algorithm").execute(*args, **kwargs)
                    def split_angle(self, *args, **kwargs):
                        """
                        Sets split angle for the clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/split_angle").execute(*args, **kwargs)
                    def compute_clusters_and_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write surface cluster first and then view factors.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_clusters_and_vf_accelerated").execute(*args, **kwargs)
                    def set_vf_parameters(self, *args, **kwargs):
                        """
                        Sets the parameters needed for the viewfactor calculations.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_vf_parameters").execute(*args, **kwargs)
                    def compute_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write view factors from existing surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_accelerated").execute(*args, **kwargs)
                    def enable_mesh_interface_clustering(self, *args, **kwargs):
                        """
                        Enables surface clusters on mesh interfaces.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/enable_mesh_interface_clustering").execute(*args, **kwargs)
                    def print_thread_clusters(self, *args, **kwargs):
                        """
                        Prints the following for all boundary threads: thread-id, number of faces, faces per surface cluster, and the number of surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_thread_clusters").execute(*args, **kwargs)
                    def read_vf_file(self, *args, **kwargs):
                        """
                        Reads S2S file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/read_vf_file").execute(*args, **kwargs)

                class solar_parameters(TUIMenu):
                    """
                    Enters the solar parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def illumination_parameters(self, *args, **kwargs):
                        """
                        Sets illumination parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/illumination_parameters").execute(*args, **kwargs)
                    def sol_adjacent_fluidcells(self, *args, **kwargs):
                        """
                        Sets solar load on for adjacent fluid cells.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_adjacent_fluidcells").execute(*args, **kwargs)
                    def autosave_solar_data(self, *args, **kwargs):
                        """
                        Sets autosave solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autosave_solar_data").execute(*args, **kwargs)
                    def ground_reflectivity(self, *args, **kwargs):
                        """
                        Sets ground reflectivity parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/ground_reflectivity").execute(*args, **kwargs)
                    def quad_tree_parameters(self, *args, **kwargs):
                        """
                        Sets quad-tree refinement parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/quad_tree_parameters").execute(*args, **kwargs)
                    def scattering_fraction(self, *args, **kwargs):
                        """
                        Sets scattering fraction parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/scattering_fraction").execute(*args, **kwargs)
                    def autoread_solar_data(self, *args, **kwargs):
                        """
                        Sets autoread solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autoread_solar_data").execute(*args, **kwargs)
                    def use_direction_from_sol_calc(self, *args, **kwargs):
                        """
                        Sets direction computed from solar calculator.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/use_direction_from_sol_calc").execute(*args, **kwargs)
                    def sol_on_demand(self, *args, **kwargs):
                        """
                        Sets solar load on demand.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_on_demand").execute(*args, **kwargs)
                    def sol_camera_pos(self, *args, **kwargs):
                        """
                        Sets camera position based on sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_camera_pos").execute(*args, **kwargs)
                    def sun_direction_vector(self, *args, **kwargs):
                        """
                        Sets sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sun_direction_vector").execute(*args, **kwargs)
                    def solar_thread_control(self, *args, **kwargs):
                        """
                        Sets the number of threads to run the solar flux calculation. This item appears only when running in parallel with nodes located on a separate machine from the one running the host process andSolar Ray Tracing is enabled.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/solar_thread_control").execute(*args, **kwargs)
                    def iteration_parameters(self, *args, **kwargs):
                        """
                        Sets update parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/iteration_parameters").execute(*args, **kwargs)

            class solver(TUIMenu):
                """
                Enters the menu to select the solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def adjust_solver_defaults_based_on_setup(self, *args, **kwargs):
                    """
                    Enable/disable adjustment of solver defaults based on setup.
                    """
                    return PyMenu(self.service, "/define/models/solver/adjust_solver_defaults_based_on_setup").execute(*args, **kwargs)
                def density_based_implicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-implicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_implicit").execute(*args, **kwargs)
                def pressure_based(self, *args, **kwargs):
                    """
                    Enables/disables the pressure-based solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/pressure_based").execute(*args, **kwargs)
                def density_based_explicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-explicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_explicit").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enters the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Sets up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/define/models/species/coal_calculator").execute(*args, **kwargs)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/premixed_combustion").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enables/disables the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/define/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/species/inlet_diffusion").execute(*args, **kwargs)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enables/disables reaction diffusion balance at reacting surface for surface 	reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/reaction_diffusion_balance").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enables/disables the inert transport model.
                    """
                    return PyMenu(self.service, "/define/models/species/inert_transport_model").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Sets the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/define/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables heat of surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables wall surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Sets flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/flamelet_expert").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enables/disables the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/define/models/species/relax_to_equil").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initializes Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/define/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables particle surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Sets EDC model constants.
                    """
                    return PyMenu(self.service, "/define/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enables/disables building of a full 2-mixture fraction table.
                    """
                    return PyMenu(self.service, "/define/models/species/full_tabulation").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enables/disables diffusion energy source.
                    """
                    return PyMenu(self.service, "/define/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/define/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Sets PDF Transport mixing model.
                    """
                    return PyMenu(self.service, "/define/models/species/mixing_model").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enables/disables the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/define/models/species/reacting_channel_model").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Imports Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/define/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enables/disables stiff chemistry option.
                    """
                    return PyMenu(self.service, "/define/models/species/stiff_chemistry").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Sets chemistry ODE integrator parameters. Enables/disables stiff chemistry 	acceleration methods and set their parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/integration_parameters").execute(*args, **kwargs)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enables/disables volumetric reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/volumetric_reactions").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Sets the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/define/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enables/disables the Reactor Network Model.
                    """
                    return PyMenu(self.service, "/define/models/species/reactor_network_model").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enables/disables the ignition model.
                    """
                    return PyMenu(self.service, "/define/models/species/ignition_model").execute(*args, **kwargs)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Sets/changes partially-premixed mixture properties. 	This command is only available when partially-premixed-combustion? 	is enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enables/disables EPDF energy option.
                    """
                    return PyMenu(self.service, "/define/models/species/epdf_energy").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/define/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enables/disables storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/define/models/species/save_gradients").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Includes species migration in electric field. This command is available only when 	the electrochemical surface reactions are 	enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/species_migration").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/define/models/species/re_calc_par_premix_props").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Sets inert transport model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/inert_transport_controls").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enables/disables solution of species models.
                    """
                    return PyMenu(self.service, "/define/models/species/off").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Applies optimal solver settings automatically to provide a faster solution time. 	This command is available only for transient 	non-premixed and partially premixed combustion 	models.
                    """
                    return PyMenu(self.service, "/define/models/species/combustion_numerics").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Sets the convergence acceleration expert parameters. This command is only available 	when the species transport model is enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/species_transport_expert").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enables/disables the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/define/models/species/thickened_flame_model").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enables/disables PDF Transport expert user.
                    """
                    return PyMenu(self.service, "/define/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enables/disables the species transport model.
                    """
                    return PyMenu(self.service, "/define/models/species/species_transport").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Sets values for the grid distribution for PDF table or 	flamelet parameter. This text command is available only 	for partially premixed combustion cases with FGM.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Sets ignition model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/ignition_model_controls").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Sets PDF expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Sets Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enables/disables mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/mass_deposition_source").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Sets PDF parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Sets premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def water_corrosion_pre(self, *args, **kwargs):
                    """
                    Compute water chemistry and set up corrosion material.
                    """
                    return PyMenu(self.service, "/define/models/species/water_corrosion_pre").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Switches between the R15 and R14.5 spark models and sets spark model 	parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/spark_model").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Enables import of the CHEMKIN mechanism transport 	data. When this option is enabled, you will be prompted 	for importing CHEMKIN transport property database when 	setting your combustion case.
                    """
                    return PyMenu(self.service, "/define/models/species/combustion_expert").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enables/disables the Ansys CHEMKIN-CFD solver.
                    """
                    return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Sets PDF expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Sets premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/premixed_model").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Sets PDF parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables thermal diffusion.
                    """
                    return PyMenu(self.service, "/define/models/species/thermal_diffusion").execute(*args, **kwargs)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enables/disables liquid micro mixing.
                    """
                    return PyMenu(self.service, "/define/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clears ISAT table.
                    """
                    return PyMenu(self.service, "/define/models/species/clear_isat_table").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enables/disables the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/pdf_transport").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enters the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def basic_options(self, *args, **kwargs):
                        """
                        Sets basic parameter options.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Deletes cell monitors.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Sets advanced parameter options.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Monitors cell for debug output.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        Lists cell monitors.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)

            class cht(TUIMenu):
                """
                Enters the cht (conjugate heat transfer) menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_time_averaged_coupling = self.__class__.explicit_time_averaged_coupling(path + ["explicit_time_averaged_coupling"], service)
                    super().__init__(path, service)
                def implicit_coupling(self, *args, **kwargs):
                    """
                    Enables the implicit mapping scheme for any 	fluid-solid pair with a mapped mesh interface (only 	required for cases set up in version 19.2 or 	earlier).
                    """
                    return PyMenu(self.service, "/define/models/cht/implicit_coupling").execute(*args, **kwargs)
                def read_mi_type_wall(self, *args, **kwargs):
                    """
                    Read mapped interface data settings from a csv file.
                    """
                    return PyMenu(self.service, "/define/models/cht/read_mi_type_wall").execute(*args, **kwargs)
                def write_mi_type_wall(self, *args, **kwargs):
                    """
                    Write mapped interface settings to a scv file.
                    """
                    return PyMenu(self.service, "/define/models/cht/write_mi_type_wall").execute(*args, **kwargs)

                class explicit_time_averaged_coupling(TUIMenu):
                    """
                    Enters the explicit time averaged thermal coupling 	menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def fuse_explicit_cht_zones(self, *args, **kwargs):
                        """
                        Fuse slitted conformal coupled walls marked for transient explicit thermal coupling.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/fuse_explicit_cht_zones").execute(*args, **kwargs)
                    def coupling_controls(self, *args, **kwargs):
                        """
                        Specify explcit coupling controls.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/coupling_controls").execute(*args, **kwargs)
                    def mapped_interfaces(self, *args, **kwargs):
                        """
                        Select fluid-solid mapped interfaces for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/mapped_interfaces").execute(*args, **kwargs)
                    def conformal_coupled_walls(self, *args, **kwargs):
                        """
                        Select fluid-solid coupled walls (without shell) for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/conformal_coupled_walls").execute(*args, **kwargs)

            class optics(TUIMenu):
                """
                Enter the optics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.statistics = self.__class__.statistics(path + ["statistics"], service)
                    self.beams = self.__class__.beams(path + ["beams"], service)
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/verbosity").execute(*args, **kwargs)
                def sampling_iterations(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/sampling_iterations").execute(*args, **kwargs)
                def report(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/report").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/enable").execute(*args, **kwargs)
                def index_of_refraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/index_of_refraction").execute(*args, **kwargs)

                class statistics(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_controls(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/statistics_controls").execute(*args, **kwargs)
                    def reset_statistics(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/reset_statistics").execute(*args, **kwargs)

                class beams(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/delete").execute(*args, **kwargs)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/rename").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/edit").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Create a new beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/add").execute(*args, **kwargs)
                    def list_beam_parameters(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/list_beam_parameters").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/copy").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enters the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Sets NOx turbulence interaction model.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)
                def nox_expert(self, *args, **kwargs):
                    """
                    Selects additional NOx equations.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_expert").execute(*args, **kwargs)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Selects NOx chemistry model.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enters the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    super().__init__(path, service)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Sets Eulerian Wall Film Model Solution Options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def enable_film_nci_support(self, *args, **kwargs):
                    """
                    Enable wall film fluid-fluid NCI support.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_film_nci_support").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Sets Film Material and Properties.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enables/disables Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activates Eulerian Wall Film Equations.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initializes Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enters the Coupled-Solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enables/disables the coupled solution method.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enables/disables the film curvature smoothing option and sets the smoothing parameters.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)

            class acoustics(TUIMenu):
                """
                Enters the acoustics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.far_field_parameters = self.__class__.far_field_parameters(path + ["far_field_parameters"], service)
                    self.sponge_layers = self.__class__.sponge_layers(path + ["sponge_layers"], service)
                    self.sources_fft = self.__class__.sources_fft(path + ["sources_fft"], service)
                    self.wave_equation_options = self.__class__.wave_equation_options(path + ["wave_equation_options"], service)
                    super().__init__(path, service)
                def read_compute_write(self, *args, **kwargs):
                    """
                    Reads acoustic source data files and computes sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/read_compute_write").execute(*args, **kwargs)
                def broad_band_noise(self, *args, **kwargs):
                    """
                    Enables/disables the broadband noise model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/broad_band_noise").execute(*args, **kwargs)
                def receivers(self, *args, **kwargs):
                    """
                    Sets acoustic receivers.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/receivers").execute(*args, **kwargs)
                def cylindrical_export(self, *args, **kwargs):
                    """
                    Enables/disables the export of data in cylindrical coordinates.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/cylindrical_export").execute(*args, **kwargs)
                def write_acoustic_signals(self, *args, **kwargs):
                    """
                    Writes on-the-fly sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/write_acoustic_signals").execute(*args, **kwargs)
                def acoustic_modal_analysis(self, *args, **kwargs):
                    """
                    Iterate linear acoustic solver to compute the resonance frequencies and the acoustic modes.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/acoustic_modal_analysis").execute(*args, **kwargs)
                def sources(self, *args, **kwargs):
                    """
                    Sets acoustic sources.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/sources").execute(*args, **kwargs)
                def export_volumetric_sources_cgns(self, *args, **kwargs):
                    """
                    Enables/disables the export of fluid zones.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_volumetric_sources_cgns").execute(*args, **kwargs)
                def ffowcs_williams(self, *args, **kwargs):
                    """
                    Enables/disables the Ffowcs-Williams-and-Hawkings model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/ffowcs_williams").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enables/disables the acoustics model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/off").execute(*args, **kwargs)
                def export_volumetric_sources(self, *args, **kwargs):
                    """
                    Enables/disables the export of fluid zones.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_volumetric_sources").execute(*args, **kwargs)
                def display_frequencies(self, *args, **kwargs):
                    """
                    Display resonance frequencies.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/display_frequencies").execute(*args, **kwargs)
                def moving_receiver(self, *args, **kwargs):
                    """
                    Enables/disables the moving receiver option.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/moving_receiver").execute(*args, **kwargs)
                def wave_equation(self, *args, **kwargs):
                    """
                    Enables/disables the wave equation model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/wave_equation").execute(*args, **kwargs)
                def export_source_data_cgns(self, *args, **kwargs):
                    """
                    Enables/disables the export of acoustic source data in CGNS format.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_source_data_cgns").execute(*args, **kwargs)
                def write_centroid_info(self, *args, **kwargs):
                    """
                    Writes centroid info.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/write_centroid_info").execute(*args, **kwargs)
                def export_source_data(self, *args, **kwargs):
                    """
                    Enables/disables the export of acoustic source data in 	ASD format during the wave equation model run.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_source_data").execute(*args, **kwargs)
                def display_flow_time(self, *args, **kwargs):
                    """
                    Enables/disables the display of flow time during read-and-compute.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/display_flow_time").execute(*args, **kwargs)
                def auto_prune(self, *args, **kwargs):
                    """
                    Enables/disables auto prune of the receiver signal(s) during 	read-and-compute.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/auto_prune").execute(*args, **kwargs)
                def convective_effects(self, *args, **kwargs):
                    """
                    Enables/disables the convective effects option.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/convective_effects").execute(*args, **kwargs)
                def modal_analysis(self, *args, **kwargs):
                    """
                    Enable/disable the modal analysis model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/modal_analysis").execute(*args, **kwargs)
                def compute_write(self, *args, **kwargs):
                    """
                    Computes sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/compute_write").execute(*args, **kwargs)

                class far_field_parameters(TUIMenu):
                    """
                    Enters the menu to specify the far-field density and 	speed of sound. Note that this menu is currently 	available only with the acoustics wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def far_field_sound_speed(self, *args, **kwargs):
                        """
                        Specifies the far-field speed of sound value for the acoustics wave equation model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/far_field_parameters/far_field_sound_speed").execute(*args, **kwargs)
                    def far_field_density(self, *args, **kwargs):
                        """
                        Specifies the far-field density value for the acoustics wave equation model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/far_field_parameters/far_field_density").execute(*args, **kwargs)

                class sponge_layers(TUIMenu):
                    """
                    Manage sponge layers where density is blended to eliminate reflections from boundary zones.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def activate(self, *args, **kwargs):
                        """
                        Activate a sponge object.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/activate").execute(*args, **kwargs)
                    def list_active(self, *args, **kwargs):
                        """
                        List the names of the active sponge layer definitions.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list_active").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        Prints a list of the existing sponge layers in the console.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a new sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/add").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edits an existing sponge layer. You can revise the fields listed previously for the define/models/acoustics/sponge-layers/add text command.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/edit").execute(*args, **kwargs)
                    def deactivate(self, *args, **kwargs):
                        """
                        Deactivate a sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/deactivate").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        Prints the properties of an existing sponge layer of your choice in the console.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list_properties").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Deletes an existing sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/delete").execute(*args, **kwargs)

                class sources_fft(TUIMenu):
                    """
                    Enters the acoustic sources fast Fourier transform (FFT) menu, to compute Fourier 	spectra from acoustic source data (ASD) files, create 	postprocessing variables for the pressure signals, and 	write CGNS files of the spectrum data.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.fft_surface_variables = self.__class__.fft_surface_variables(path + ["fft_surface_variables"], service)
                        super().__init__(path, service)
                    def clean_up_storage_area(self, *args, **kwargs):
                        """
                        De-allocates memory used to store the pressure histories and their Fourier spectra, as well as any created surface variables for the visualization.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/clean_up_storage_area").execute(*args, **kwargs)
                    def compute_fft_fields(self, *args, **kwargs):
                        """
                        Computes FFT of the read pressure histories. The computed spectra replace the pressure histories in memory.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/compute_fft_fields").execute(*args, **kwargs)
                    def read_asd_files(self, *args, **kwargs):
                        """
                        Reads ASD files to perform FFT of the pressure history field.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/read_asd_files").execute(*args, **kwargs)
                    def write_cgns_files(self, *args, **kwargs):
                        """
                        Writes surface pressure spectra in CGNS format, which can be used for one-way coupling with Ansys Mechanical in the frequency domain.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/write_cgns_files").execute(*args, **kwargs)

                    class fft_surface_variables(TUIMenu):
                        """
                        Enters the menu to create surface variables from the computed Fourier spectra for visualization.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create_set_of_modes(self, *args, **kwargs):
                            """
                            Selects up to 20 individual Fourier modes and create variable pairs for them, containing the real and the imaginary parts of the complex Fourier amplitudes.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_set_of_modes").execute(*args, **kwargs)
                        def create_third_bands(self, *args, **kwargs):
                            """
                            Creates either the surface pressure level (SPL) variables or the PSD of dp/dt variables for 54 technical thirds.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_third_bands").execute(*args, **kwargs)
                        def remove_variables(self, *args, **kwargs):
                            """
                            Removes all variables created in this menu.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/remove_variables").execute(*args, **kwargs)
                        def create_octave_bands(self, *args, **kwargs):
                            """
                            Creates either the surface pressure level (SPL) variables or the PSD of dp/dt variables for 17 technical octaves.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_octave_bands").execute(*args, **kwargs)
                        def create_constant_width_bands(self, *args, **kwargs):
                            """
                            Selects up to 20 constant width bands and creates either the surface pressures level (SPL) variables or the PSD of dp/dt variables for them.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_constant_width_bands").execute(*args, **kwargs)

                class wave_equation_options(TUIMenu):
                    """
                    Enters the menu to define the acoustics wave equation 	model options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.basic_shapes = self.__class__.basic_shapes(path + ["basic_shapes"], service)
                        self.remote_receivers_options = self.__class__.remote_receivers_options(path + ["remote_receivers_options"], service)
                        super().__init__(path, service)
                    def sponge_layer_udf(self, *args, **kwargs):
                        """
                        Specifies the name of a user-defined function, which defines geometry of the sponge layer.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_udf").execute(*args, **kwargs)
                    def time_filter_source(self, *args, **kwargs):
                        """
                        Enables/disables a time filter for the sound source.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/time_filter_source").execute(*args, **kwargs)
                    def sponge_layer_factor(self, *args, **kwargs):
                        """
                        Specifies the factor of the artificial viscosity coefficient.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_factor").execute(*args, **kwargs)
                    def remote_receivers(self, *args, **kwargs):
                        """
                        Enables/disables the Kirchhoff integral model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers").execute(*args, **kwargs)
                    def source_mask_udf(self, *args, **kwargs):
                        """
                        Specifies the name of a user-defined function, which defines geometry of the source mask.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/source_mask_udf").execute(*args, **kwargs)
                    def sponge_layer_base_level(self, *args, **kwargs):
                        """
                        Specify artificial viscosity base level applied everywhere.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_base_level").execute(*args, **kwargs)

                    class basic_shapes(TUIMenu):
                        """
                        Enters the menu to define the geometry of the source mask and sponge layer using the basic shapes, represented by the cell registers of the type "Region".
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def remove_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Remove a basic shape from the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/remove_sponge_layer_shape").execute(*args, **kwargs)
                        def add_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Adds a basic shape to the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/add_sponge_layer_shape").execute(*args, **kwargs)
                        def add_source_mask_shape(self, *args, **kwargs):
                            """
                            Adds a basic shape to the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/add_source_mask_shape").execute(*args, **kwargs)
                        def remove_source_mask_shape(self, *args, **kwargs):
                            """
                            Remove a basic shape from the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/remove_source_mask_shape").execute(*args, **kwargs)
                        def list_region_registers(self, *args, **kwargs):
                            """
                            List all available cell registers of the type "Region".
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_region_registers").execute(*args, **kwargs)
                        def list_source_mask_shapes(self, *args, **kwargs):
                            """
                            List basic shapes, which are currently used in the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_source_mask_shapes").execute(*args, **kwargs)
                        def list_sponge_layer_shapes(self, *args, **kwargs):
                            """
                            List basic shapes, which are currently used in the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_sponge_layer_shapes").execute(*args, **kwargs)

                    class remote_receivers_options(TUIMenu):
                        """
                        Enters the menu to define remote receivers for the Kirchhoff integral model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def write_signals(self, *args, **kwargs):
                            """
                            Writes the computed receiver signals to the ASCII files.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers_options/write_signals").execute(*args, **kwargs)
                        def integration_surface(self, *args, **kwargs):
                            """
                            Selects the integration surface for the Kirchhoff model.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers_options/integration_surface").execute(*args, **kwargs)

            class system_coupling_settings(TUIMenu):
                """
                Enters the system coupling menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.htc = self.__class__.htc(path + ["htc"], service)
                    super().__init__(path, service)
                def specify_system_coupling_volumetric_cell_zones(self, *args, **kwargs):
                    """
                    Enable/disable volumetric cell zones.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/specify_system_coupling_volumetric_cell_zones").execute(*args, **kwargs)
                def use_face_or_element_based_data_transfer(self, *args, **kwargs):
                    """
                    Answering yes at the prompt 	enables Fluent to use element data for mapping surface 	conservative quantities such as surface forces and heat 	flows.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/use_face_or_element_based_data_transfer").execute(*args, **kwargs)
                def update_rigid_body_mesh_motion_before_mesh_transfer(self, *args, **kwargs):
                    """
                    SC Enable/disable mesh motion.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/update_rigid_body_mesh_motion_before_mesh_transfer").execute(*args, **kwargs)

                class htc(TUIMenu):
                    """
                    Enter the heat transfer coeficient menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.unsteady_statistics = self.__class__.unsteady_statistics(path + ["unsteady_statistics"], service)
                        self.htc_calculation_method = self.__class__.htc_calculation_method(path + ["htc_calculation_method"], service)
                        super().__init__(path, service)

                    class unsteady_statistics(TUIMenu):
                        """
                        Enter the unsteady statistics menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sc_enable_sub_stepping_option_per_coupling_step(self, *args, **kwargs):
                            """
                            Enable/disable sub stepping option per coupling step.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/unsteady_statistics/sc_enable_sub_stepping_option_per_coupling_step").execute(*args, **kwargs)

                    class htc_calculation_method(TUIMenu):
                        """
                        Enter the htc calculation menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def use_wall_function_based_htc(self, *args, **kwargs):
                            """
                            Enable/disable wall function based htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_wall_function_based_htc").execute(*args, **kwargs)
                        def use_yplus_based_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable yplus in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_yplus_based_htc_calculation").execute(*args, **kwargs)
                        def use_tref_in_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable tref in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_tref_in_htc_calculation").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enters the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enables the linear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/linear_elasticity").execute(*args, **kwargs)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/define/models/structure/thermal_effects").execute(*args, **kwargs)
                def structure_off(self, *args, **kwargs):
                    """
                    Disables the structural model.
                    """
                    return PyMenu(self.service, "/define/models/structure/structure_off").execute(*args, **kwargs)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/nonlinear_elasticity").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enters the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def max_iter(self, *args, **kwargs):
                        """
                        Sets the maximum number of iterations for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/enhanced_strain").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Sets the algebraic multigrid (AMG) stabilization method for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/amg_stabilization").execute(*args, **kwargs)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Sets the damping factor for the structural model (that is, the amplitude decay factor  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables an explicit fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of a viscous fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of operating pressure into the fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enters the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Selects soot process parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enables/disables the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Changes the turbulent Schmidt number for soot/nuclei equations.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Sets soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Selects soot model parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)

            class two_temperature(TUIMenu):
                """
                Enters the Two-Temperature model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the Two-Temperature model.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/enable").execute(*args, **kwargs)
                def robustness_enhancement(self, *args, **kwargs):
                    """
                    Enables/disables the robustness enhancement, which is 	on by default.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/robustness_enhancement").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Specifies the level of detail printed in the console 	about the Two-Temperature model. For a verbosity of one, 	Fluent will print the number of cells that reach the 	temperature limit, have an excessive temperature change, 	or get a negative temperature.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/set_verbosity").execute(*args, **kwargs)
                def nasa9_enhancement(self, *args, **kwargs):
                    """
                    Apply nasa9 robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/nasa9_enhancement").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Enters the multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Enables the Algebraic Interfacial Area Density (AIAD) 	model and sets the AIAD secondary continuous phase and 	the secondary entrained phase. Entering 0 as a phase ID cancels any 	previous phase selection. Note that you must define the 	phases in your simulation using the define/phases/ text command 	prior to using the regime-transition-modeling 	text command. This option is available only with the 	Eulerian multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Enables coupled level set interface tracking method.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specifies the number of phases.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Specifies interface modeling options.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def boiling_model_options(self, *args, **kwargs):
                    """
                    Specifies the boiling model options. You can choose theRPI boiling model,Non-equilibrium boiling, orCritical heat flux.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/boiling_model_options").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Specifies body force formulation.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specifies multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/model").execute(*args, **kwargs)
                def eulerian_parameters(self, *args, **kwargs):
                    """
                    Specifies Eulerian parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/eulerian_parameters").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Specifies mixture parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def expert_options(self, *args, **kwargs):
                    """
                    Expert Options.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/expert_options").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    Enables the Open Channel sub-model and/or the Open Channel Wave Boundary Condition 	sub-model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/vof_sub_models").execute(*args, **kwargs)

                class sub_models(TUIMenu):
                    """
                    Enter the menu to select sub-models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling_options = self.__class__.boiling_options(path + ["boiling_options"], service)
                        super().__init__(path, service)
                    def boiling(self, *args, **kwargs):
                        """
                        Activate boiling model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling").execute(*args, **kwargs)

                    class boiling_options(TUIMenu):
                        """
                        Set boiling options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nlbf_model(self, *args, **kwargs):
                            """
                            Set the non-local boundary field correction.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/nlbf_model").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Choose the type of boiling model.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/options").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enters the population balance models menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Gives you recommendations for appropriate bubble sizes and/or droplet size limits.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)
                    def model(self, *args, **kwargs):
                        """
                        Allows you to select the population balance model and set its parameters.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/model").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enters the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nucleation(self, *args, **kwargs):
                            """
                            Specifies the nucleation rate.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Specifies a cutoff limit for the volume fraction values for the breakage and aggregation kernels.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)
                        def aggregation(self, *args, **kwargs):
                            """
                            Sets the aggregation kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Specifies a factor that controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def growth(self, *args, **kwargs):
                            """
                            Specifies the growth rate.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Specifies a factor that controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        super().__init__(path, service)
                    def phase_domain(self, *args, **kwargs):
                        """
                        Enter the menu to set phase domain properties.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/phases/phase_domain").execute(*args, **kwargs)
                    def interaction_domain(self, *args, **kwargs):
                        """
                        Enter the menu to set interaction domain properties.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/phases/interaction_domain").execute(*args, **kwargs)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                super().__init__(path, service)

                            class interfacial_area(TUIMenu):
                                """
                                Enter the menu to set interfacial area models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    super().__init__(path, service)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    super().__init__(path, service)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)

                            class forces(TUIMenu):
                                """
                                Enter the menu to set interfacial forces related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    super().__init__(path, service)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                               