/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import ida.utils.MatrixUtils;
import ida.utils.VectorUtils;
import ida.utils.collections.IntegerSet;
import ida.utils.tuples.Pair;
import ida.utils.tuples.Quadruple;
import ida.utils.tuples.Triple;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class TupleSet {
    private int hashCode = -1;
    private int[][] values;
    public static final EmptySet emptySet = new EmptySet();

    private TupleSet() {
    }

    private TupleSet(int[][] values) {
        this(values, false);
    }

    private TupleSet(int[][] values, boolean sort) {
        this.values = new int[values.length][];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = VectorUtils.copyArray(values[i]);
        }
        if (sort) {
            Arrays.sort(values, new Comparator<int[]>(){

                @Override
                public int compare(int[] o1, int[] o2) {
                    for (int i = 0; i < o1.length; ++i) {
                        if (o1[i] == o2[i]) continue;
                        return o1[i] - o2[i];
                    }
                    return 0;
                }
            });
        }
    }

    public static TupleSet createTupleSet(int[][] values) {
        Arrays.sort((Object[])values);
        if (values.length == 0) {
            return emptySet;
        }
        return TupleSet.createTupleSetFromSortedArray(values);
    }

    public static TupleSet createTupleSetFromPairs(Collection<Pair<Integer, Integer>> pairs) {
        int[][] values = new int[pairs.size()][2];
        int index = 0;
        for (Pair<Integer, Integer> pair : pairs) {
            values[index][0] = (Integer)pair.r;
            values[index][1] = (Integer)pair.s;
            ++index;
        }
        return TupleSet.createTupleSetFromSortedArray(values);
    }

    public static TupleSet createTupleSetFromTriples(Collection<Triple<Integer, Integer, Integer>> triples) {
        int[][] values = new int[triples.size()][2];
        int index = 0;
        for (Triple<Integer, Integer, Integer> pair : triples) {
            values[index][0] = (Integer)pair.r;
            values[index][1] = (Integer)pair.s;
            values[index][2] = (Integer)pair.t;
            ++index;
        }
        return TupleSet.createTupleSetFromSortedArray(values);
    }

    public static TupleSet createTupleSetFromQuadruples(Collection<Quadruple<Integer, Integer, Integer, Integer>> pairs) {
        int[][] values = new int[pairs.size()][2];
        int index = 0;
        for (Quadruple<Integer, Integer, Integer, Integer> pair : pairs) {
            values[index][0] = (Integer)pair.r;
            values[index][1] = (Integer)pair.s;
            values[index][2] = (Integer)pair.t;
            values[index][3] = (Integer)pair.u;
            ++index;
        }
        return TupleSet.createTupleSetFromSortedArray(values);
    }

    public static TupleSet createTupleSetFromSortedArray(int[][] values) {
        int duplicates = 0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (!Arrays.equals(values[i], values[i + 1])) continue;
            ++duplicates;
        }
        if (duplicates > 0) {
            int[][] newValues = new int[values.length - duplicates][values[0].length];
            int j = 0;
            for (int i = 0; i < newValues.length; ++i) {
                if (i != values.length - 1 && Arrays.equals(values[i], values[i + 1])) continue;
                newValues[j] = values[i];
                ++j;
            }
            values = newValues;
        }
        if (values.length == 0) {
            return emptySet;
        }
        return new TupleSet(values, false);
    }

    public static TupleSet createTupleSet(Set<int[]> set) {
        int[][] values = new int[set.size()][];
        int index = 0;
        for (int[] tuple : set) {
            values[index] = VectorUtils.copyArray(tuple);
            ++index;
        }
        return TupleSet.createTupleSet(values);
    }

    private static boolean gt(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i] > 0;
        }
        return false;
    }

    private static boolean lt(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i] < 0;
        }
        return false;
    }

    private static boolean eq(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static TupleSet intersection(TupleSet a, TupleSet b) {
        if (a.isEmpty() || b.isEmpty() || TupleSet.gt(a.values[0], b.values[b.values.length - 1]) || TupleSet.gt(b.values[0], a.values[a.values.length - 1])) {
            return emptySet;
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        int aLength = a.values.length;
        int bLength = b.values.length;
        while (indexA < aLength && indexB < bLength) {
            if (TupleSet.eq(a.values[indexA], b.values[indexB])) {
                ++count;
                ++indexA;
                ++indexB;
                continue;
            }
            if (TupleSet.lt(a.values[indexA], b.values[indexB])) {
                ++indexA;
                continue;
            }
            if (!TupleSet.gt(a.values[indexA], b.values[indexB])) continue;
            ++indexB;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        int[][] newValues = new int[count][];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength && indexB < bLength) {
            if (TupleSet.eq(a.values[indexA], b.values[indexB])) {
                newValues[index] = a.values[indexA];
                ++indexA;
                ++indexB;
                ++index;
                continue;
            }
            if (TupleSet.lt(a.values[indexA], b.values[indexB])) {
                ++indexA;
                continue;
            }
            if (!TupleSet.gt(a.values[indexA], b.values[indexB])) continue;
            ++indexB;
        }
        if (count == 0) {
            return emptySet;
        }
        TupleSet set = new TupleSet();
        set.values = newValues;
        return set;
    }

    public static TupleSet union(TupleSet a, TupleSet b) {
        if (a instanceof EmptySet) {
            return b;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int aLength = a.values.length;
        int bLength = b.values.length;
        int[][] aValues = a.values;
        int[][] bValues = b.values;
        if (a == b) {
            return a;
        }
        if (TupleSet.lt(aValues[aLength - 1], bValues[0])) {
            int[][] values = new int[aLength + bLength][];
            System.arraycopy(aValues, 0, values, 0, aLength);
            System.arraycopy(bValues, 0, values, aLength, bLength);
            return new TupleSet(values);
        }
        if (TupleSet.gt(aValues[0], bValues[bLength - 1])) {
            int[][] values = new int[aLength + bLength][];
            System.arraycopy(bValues, 0, values, 0, bLength);
            System.arraycopy(aValues, 0, values, bLength, aLength);
            return new TupleSet(values);
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                int[] aValue = aValues[indexA];
                int[] bValue = bValues[indexB];
                if (TupleSet.eq(aValue, bValue)) {
                    ++indexA;
                    ++indexB;
                    ++count;
                    continue;
                }
                if (TupleSet.lt(aValue, bValue)) {
                    ++indexA;
                    ++count;
                    continue;
                }
                if (!TupleSet.gt(aValue, bValue)) continue;
                ++indexB;
                ++count;
                continue;
            }
            if (indexA < aLength) {
                ++indexA;
                ++count;
                continue;
            }
            if (indexB >= bLength) continue;
            ++indexB;
            ++count;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        int[][] newValues = new int[count][];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                int[] aValue = aValues[indexA];
                int[] bValue = bValues[indexB];
                if (TupleSet.eq(aValue, bValue)) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++indexB;
                    ++index;
                    continue;
                }
                if (TupleSet.lt(aValue, bValue)) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++index;
                    continue;
                }
                if (!TupleSet.gt(aValue, bValue)) continue;
                newValues[index] = bValue;
                ++indexB;
                ++index;
                continue;
            }
            if (indexA < aLength) {
                newValues[index] = aValues[indexA];
                ++indexA;
                ++index;
                continue;
            }
            if (indexB >= bLength) continue;
            newValues[index] = bValues[indexB];
            ++indexB;
            ++index;
        }
        TupleSet set = new TupleSet();
        set.values = newValues;
        return set;
    }

    public static TupleSet difference(TupleSet a, TupleSet b) {
        int indexA;
        if (a == b) {
            return emptySet;
        }
        if (a instanceof EmptySet) {
            return emptySet;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int indexB = 0;
        int count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && TupleSet.lt(b.values[indexB], a.values[indexA])) {
                ++indexB;
            }
            if (indexB < b.values.length && TupleSet.gt(b.values[indexB], a.values[indexA])) {
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            ++count;
        }
        int[][] newValues = new int[count][];
        indexB = 0;
        count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && TupleSet.lt(b.values[indexB], a.values[indexA])) {
                ++indexB;
            }
            if (indexB < b.values.length && TupleSet.gt(b.values[indexB], a.values[indexA])) {
                newValues[count] = a.values[indexA];
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            newValues[count] = a.values[indexA];
            ++count;
        }
        if (newValues.length == 0) {
            return emptySet;
        }
        TupleSet set = new TupleSet();
        set.values = newValues;
        return set;
    }

    public TupleSet select(int column, IntegerSet keys) {
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!keys.contains(this.values[i][column])) continue;
            ++count;
        }
        int[][] selectedValues = new int[count][];
        count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (!keys.contains(this.values[i][column])) continue;
            selectedValues[count] = this.values[i];
            ++count;
        }
        return TupleSet.createTupleSetFromSortedArray(selectedValues);
    }

    public IntegerSet column(int column) {
        int[] valuesWithDuplicates = new int[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            valuesWithDuplicates[i] = this.values[i][column];
        }
        return IntegerSet.createIntegerSet(valuesWithDuplicates);
    }

    public static TupleSet intersection(Collection<TupleSet> sets) {
        TupleSet result = null;
        for (TupleSet set : sets) {
            if (result == null) {
                result = set;
                continue;
            }
            result = TupleSet.intersection(result, set);
        }
        return result;
    }

    public static TupleSet intersection(TupleSet ... sets) {
        TupleSet result = null;
        for (TupleSet set : sets) {
            result = result == null ? set : TupleSet.intersection(result, set);
        }
        return result;
    }

    public static TupleSet union(Collection<TupleSet> sets) {
        TupleSet result = null;
        for (TupleSet set : sets) {
            if (result == null) {
                result = set;
                continue;
            }
            result = TupleSet.union(result, set);
        }
        return result;
    }

    public static TupleSet union(TupleSet ... sets) {
        TupleSet result = null;
        for (TupleSet set : sets) {
            result = result == null ? set : TupleSet.union(result, set);
        }
        return result;
    }

    public boolean contains(int[] tuple) {
        if (this.values.length < 16) {
            for (int i = 0; i < this.values.length; ++i) {
                if (TupleSet.eq(this.values[i], tuple)) {
                    return true;
                }
                if (!TupleSet.gt(this.values[i], tuple)) continue;
                return false;
            }
        }
        return Arrays.binarySearch(this.values, tuple, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                for (int i = 0; i < o1.length; ++i) {
                    if (o1[i] == o2[i]) continue;
                    return o1[i] - o2[i];
                }
                return 0;
            }
        }) > -1;
    }

    public boolean isSubsetOf(TupleSet b) {
        if (b.isEmpty() || b.size() < this.size() || TupleSet.lt(this.values[0], b.values[0]) || TupleSet.gt(this.values[this.values.length - 1], b.values[b.values.length - 1])) {
            return false;
        }
        int i2 = 0;
        for (int i = 0; i < this.values.length; ++i) {
            while (i2 < b.values.length && TupleSet.lt(b.values[i2], this.values[i])) {
                ++i2;
            }
            if (i2 != b.values.length && !TupleSet.gt(b.values[i2], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(TupleSet b) {
        return !this.equals(b) && this.isSubsetOf(b);
    }

    public boolean equals(Object o) {
        if (o instanceof TupleSet) {
            TupleSet cis = (TupleSet)o;
            if (this.isEmpty() != cis.isEmpty()) {
                return false;
            }
            if (cis.hashCode != -1 && this.hashCode != -1 && cis.hashCode != this.hashCode || cis.values.length != this.values.length) {
                return false;
            }
            if (!TupleSet.eq(cis.values[cis.values.length - 1], this.values[this.values.length - 1])) {
                return false;
            }
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (TupleSet.eq(this.values[i], cis.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void computeHashCode() {
        int hash = 1;
        for (int i = 0; i < this.values.length; ++i) {
            hash = (hash + 1) * (1 + Arrays.hashCode(this.values[i]) * i * i) % 0xFFFFFF;
        }
        this.hashCode = hash;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public Set<int[]> toSet() {
        LinkedHashSet<int[]> retVal = new LinkedHashSet<int[]>();
        for (int[] i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "TupleSet:\n" + MatrixUtils.intMatrixToString(this.values);
    }

    public int[][] values() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    private static class EmptySet
    extends TupleSet {
        private EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(int[] tuple) {
            return false;
        }

        @Override
        public boolean isSubsetOf(TupleSet b) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptySet;
        }

        @Override
        public String toString() {
            return "EmptySet[]";
        }

        @Override
        public Set<int[]> toSet() {
            return new HashSet<int[]>(1);
        }

        @Override
        public int[][] values() {
            return new int[0][0];
        }

        @Override
        public IntegerSet column(int column) {
            return IntegerSet.emptySet;
        }

        @Override
        public TupleSet select(int column, IntegerSet keys) {
            return emptySet;
        }
    }
}

