/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class ValueToIndex<T> {
    private int lastIndex = 0;
    private LinkedHashMap<T, Integer> valueToIndex = new LinkedHashMap();
    private LinkedHashMap<Integer, T> indexToValue = new LinkedHashMap();

    public int valueToIndex(T t) {
        if (!this.valueToIndex.containsKey(t)) {
            this.valueToIndex.put(t, this.lastIndex);
            this.indexToValue.put(this.lastIndex, t);
            ++this.lastIndex;
        }
        return this.valueToIndex.get(t);
    }

    public T indexToValue(int index) {
        if (!this.indexToValue.containsKey(index)) {
            return null;
        }
        return this.indexToValue.get(index);
    }

    public void put(int key, T value) {
        this.valueToIndex.put(value, key);
        this.indexToValue.put(key, value);
    }

    public Set<Integer> valuesToIndices(Collection<T> coll) {
        HashSet<Integer> retVal = new HashSet<Integer>();
        for (T t : coll) {
            retVal.add(this.valueToIndex(t));
        }
        return retVal;
    }

    public Set<T> indicesToValues(Collection<Integer> coll) {
        HashSet<T> retVal = new HashSet<T>();
        for (Integer i : coll) {
            retVal.add(this.indexToValue(i));
        }
        return retVal;
    }

    public int size() {
        return this.valueToIndex.size();
    }

    public Set<T> values() {
        return this.valueToIndex.keySet();
    }

    public Set<Integer> indices() {
        return this.indexToValue.keySet();
    }

    public String toString() {
        return this.valueToIndex.toString();
    }
}

