/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.DatabaseApplication;
import proper.engine.Cardinalizer;
import proper.engine.Engine;

public class CARDINALIZER
extends DatabaseApplication {
    private int maxDepth;
    private String joinType;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.joinType = "leftouter";
        this.maxDepth = 1;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("table", "the table to use as central table for cardinalization", true, "<name>", false);
        this.addDefinition("field", "the class field in the central table", true, "<name>", false);
        this.addDefinition("result_table", "the table to stores the cardinalized data in", true, "<name>", false);
        this.addDefinition("exclude_tables", "tables you want to exclude from the process", true, "<name[,name...]>", true);
        this.addDefinition("index", "specifies the index to use instead of the primary key (implies 'any_index')", true, "<name>", true);
        this.addDefinition("join", "the type of join to perform, available are 'leftouter', 'rightouter'\n'bestouter' (determines the outer join with the least information loss) or\n'natural'\ndefault is: " + this.joinType, true, "<type>", true);
        this.addDefinition("max_depth", "defines the maximal depth the search for relations does, -1 means unlimited\ndefault is: " + this.maxDepth, true, "<int>", true);
        this.addDefinition("use_foreign_keys", "uses foreign key relations to determine relations between tables rather \nthan matching column names", false, "", true);
        this.addDefinition("instead_null", "defines the values for columns (type is determined automatically) which is\nused instead of NULL values after a Join.", true, "col=value[,col=value[,...]]", true);
        this.addDefinition("tree", "instead of discovering the structure of the DB itself a tree structure can\nbe defined by the user. It starts with the root node, the children are\nseparated by ',' and a substree is surrounded by '[' and ']', e.g.:\na[b,c,d[e,f[g,h]]", true, "<tree-string>", true);
    }

    @Override
    public void printDescription() {
        System.out.println("");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nCardinalize\n==========");
        this.println("*Warning: Cardinalization may take time*");
        Cardinalizer engine = new Cardinalizer();
        this.initEngine(engine);
        engine.setParameter("table", this.cl.getValue("table"));
        engine.setParameter("field", this.cl.getValue("field"));
        engine.setParameter("result_table", this.cl.getValue("result_table"));
        engine.setParameter("join", this.cl.getValue("join", this.joinType));
        engine.setParameter("index", this.cl.getValue("index"));
        engine.setParameter("exclude_tables", this.cl.getValue("exclude_tables"));
        engine.setParameter("exclude_fields", this.cl.getValue("exclude_fields"));
        engine.setParameter("max_depth", this.fixAdditionalArg(this.cl.getValue("max_depth", Integer.toString(this.maxDepth))));
        engine.setParameter("instead_null", this.cl.getValue("instead_null"));
        engine.setParameter("tree", this.cl.getValue("tree"));
        engine.setParameter("properties", this.cl.getValue("properties"));
        engine.setParameter("associated_tables", this.cl.getValue("associated_tables"));
        if (this.cl.exists("any_index")) {
            engine.setParameter("any_index", "yes");
        }
        if (this.cl.exists("discretize")) {
            engine.setParameter("discretize", this.cl.getValue("discretize"));
            System.out.println("VALUE==" + engine.getParameter("discretize"));
            if (this.cl.exists("discretize-parts")) {
                engine.setParameter("discretize-parts", this.cl.getValue("discretize-parts"));
            }
        }
        if (this.cl.exists("nb_thres_eq_freq")) {
            engine.setParameter("nb_thres_eq_freq", this.cl.getValue("nb_thres_eq_freq"));
        }
        if (this.cl.exists("use_foreign_keys")) {
            engine.setParameter("use_foreign_keys", "yes");
        }
        return ((Engine)engine).execute();
    }

    public static void main(String[] args) throws Exception {
        CARDINALIZER app = new CARDINALIZER();
        app.run(args);
    }
}

