/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import milk.classifiers.MIClassifier;
import milk.core.Exemplars;
import proper.engine.Engine;
import proper.util.MilkHelper;
import proper.util.Strings;
import weka.core.Instances;

public class MilkClassifier
extends Engine {
    public MilkClassifier() {
        this.setParameter("classifier", "milk.classifiers.MIWrapper");
        this.setParameter("additional", "=W weka.classifiers.trees.J48");
        this.setParameter("input", "tmp/input.arff");
        this.setParameter("unknown", "tmp/unknown.arff");
        this.setParameter("output", "tmp/output.arff");
    }

    @Override
    public boolean execute() {
        super.execute();
        try {
            MIClassifier classifier = MilkHelper.getClassifierInstance(this.getStringParameter("classifier"));
            String[] adds = Strings.breakUp(this.getStringParameter("additional"));
            MilkHelper.setOptions((Object)classifier, adds);
            Instances inst = new Instances((Reader)new FileReader(this.getStringParameter("input")));
            inst.setClassIndex(inst.numAttributes() - 1);
            Exemplars known = new Exemplars(inst);
            classifier.buildClassifier(known);
            inst = new Instances((Reader)new FileReader(this.getStringParameter("unknown")));
            inst.setClassIndex(inst.numAttributes() - 1);
            Exemplars unknown = new Exemplars(inst);
            inst = new Instances((Reader)new FileReader(this.getStringParameter("unknown")));
            inst.setClassIndex(inst.numAttributes() - 1);
            Exemplars classified = new Exemplars(inst);
            classified.setRelationName(classified.relationName().replaceAll("unclassified", "classified"));
            int i = 0;
            while (i < unknown.numExemplars()) {
                this.print(".");
                Instances instUnknown = unknown.exemplar(i).getInstances();
                Instances instClassified = classified.exemplar(i).getInstances();
                int n = 0;
                while (n < instUnknown.numInstances()) {
                    instUnknown.instance(n).setClassMissing();
                    instClassified.instance(n).setClassMissing();
                    ++n;
                }
                double classification = classifier.classifyExemplar(unknown.exemplar(i));
                n = 0;
                while (n < instClassified.numInstances()) {
                    instClassified.instance(n).setClassValue(classification);
                    ++n;
                }
                ++i;
            }
            this.println();
            PrintWriter writer = new PrintWriter(new FileWriter(this.getStringParameter("output")));
            writer.print(classified.toString());
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
    }
}

