/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import proper.engine.Engine;
import proper.util.Strings;
import proper.util.WekaHelper;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class Weka
extends Engine {
    public Weka() {
        this.setParameter("classifier", "weka.classifiers.trees.J48");
        this.setParameter("additional", "");
        this.setParameter("type", "output");
        this.setParameter("train", "tmp/output.arff");
        this.setParameter("instances", "");
        this.setParameter("folds", "10");
    }

    @Override
    public boolean execute() {
        super.execute();
        try {
            boolean useArff = this.valueEquals("type", "output");
            Classifier c = WekaHelper.getClassifierInstance(this.getStringParameter("classifier"));
            String add = "-x \"" + this.getStringParameter("folds") + "\" ";
            add = useArff ? String.valueOf(add) + "-t \"" + this.getStringParameter("train") + "\" " : "";
            add = String.valueOf(add) + this.getStringParameter("additional");
            String[] args = Strings.breakUp(add.trim(), " ", "\"");
            if (useArff) {
                this.println(Evaluation.evaluateModel((Classifier)c, (String[])args));
            } else {
                Instances instances = (Instances)this.getParameter("instances");
                WekaHelper.setOptions((Object)c, args);
                c.buildClassifier(instances);
                this.println(c);
            }
            return true;
        }
        catch (Exception e) {
            this.println(e);
            return false;
        }
    }
}

