/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Stack;
import java.util.Vector;
import proper.io.TextFile;
import proper.remote.ClientList;
import proper.remote.JobDistributor;
import proper.remote.JobServerProcessor;
import proper.remote.Processor;
import proper.remote.Server;
import proper.remote.messages.FileMessage;
import proper.util.ProperVector;

public class JobServer
extends Server {
    public static final int PORT = 31415;
    public static final String REQUEST_REGISTER = "register";
    public static final String REQUEST_UNREGISTER = "unregister";
    public static final String REQUEST_REREGISTER = "reregister";
    public static final String REQUEST_KILL = "kill";
    public static final String REQUEST_JOB = "job";
    public static final String REQUEST_NEXTJOB = "next_job";
    public static final String REQUEST_DELETEJOB = "delete_job";
    public static final String REQUEST_RESULT = "result";
    public static final String REQUEST_FAILED = "failed";
    public static final String REQUEST_GETFILE = "get_file";
    public static final String REQUEST_FILE = "file";
    public static final String REQUEST_ADDJOBS = "add_jobs";
    public static final String REQUEST_ADDITIONALADD = "add_additional";
    public static final String REQUEST_ADDITIONALREMOVE = "remove_additional";
    public static final String REQUEST_ADDITIONALFAILED = "remove_failed";
    public static final String REQUEST_JOBSTODO = "jobs_todo";
    public static final String REQUEST_JOBSDONE = "jobs_done";
    public static final String REQUEST_JOBSFAILED = "jobs_failed";
    public static final String REQUEST_CLIENTS = "clients";
    public static final String REQUEST_PENDING = "pending";
    public static final String REQUEST_ADDITIONAL = "additional";
    public static final String REQUEST_SHUTDOWN = "shutdown";
    public static final int LIST_AVAILABLE = 1;
    public static final int LIST_PENDING = 2;
    public static final int LIST_ADDITIONAL = 3;
    public static final int JOBLIST = 0;
    public static final int JOBLIST_TODO = 1;
    public static final int JOBLIST_DONE = 2;
    public static final int JOBLIST_FAILED = 3;
    public static final String JOB_SYNCHRONIZE = "synchronize";
    public static final String JOB_DISTRIBUTE = "distribute";
    private ClientList available = new ClientList();
    private Stack jobs;
    private String jobsTodoFilename;
    private String jobsDoneFilename;
    private String jobsFailedFilename;
    private String jobsPendingFilename;
    private Stack jobsTodo;
    private Vector jobsDone;
    private Vector jobsFailed;
    private ClientList pending = new ClientList();
    private ClientList additional = new ClientList();
    private Vector received;
    private JobDistributor distributor;

    public JobServer() {
        this.jobs = new Stack();
        this.jobsTodo = new Stack();
        this.jobsDone = new ProperVector();
        this.jobsFailed = new ProperVector();
        this.received = new ProperVector();
        this.distributor = new JobDistributor(this, null);
    }

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.defaultPort = 31415;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("jobs", "the file where the jobs are stored", true, "<filename>", false);
        this.addDefinition("results", "where to store the results from the clients", true, "<filename>", false);
        this.addDefinition("append_results", "this option appends the results to the file, otherwise it is emptied first", false, "", true);
        this.addDefinition("output", "where to store files received from clients", true, "<directory>", false);
    }

    @Override
    public void printDescription() {
        System.out.println("A Multi-Threaded Server for distributing Jobs to JobClients.");
        System.out.println();
    }

    public void addJobs(Vector lines) {
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            if (!line.trim().startsWith("#") && !line.trim().equals("")) {
                this.jobs.add(0, line);
            }
            ++i;
        }
    }

    private boolean loadJobs() {
        this.addJobs(TextFile.load(this.getJobsFilename()));
        boolean result = this.jobs.size() > 0;
        this.jobsTodo.clear();
        this.jobsTodo.addAll(this.jobs);
        this.jobsDone.clear();
        this.jobsFailed.clear();
        String msg = String.valueOf(this.jobs.size()) + " jobs loaded from " + this.getJobsFilename();
        this.addToAccessLog(msg);
        this.println(msg);
        return result;
    }

    public String getJobsFilename() {
        return this.getJobsFilename(0);
    }

    public String getJobsFilename(int list) {
        String result = "";
        switch (list) {
            case 1: {
                result = this.jobsTodoFilename;
                break;
            }
            case 2: {
                result = this.jobsDoneFilename;
                break;
            }
            case 3: {
                result = this.jobsFailedFilename;
                break;
            }
            default: {
                result = this.cl.getValue("jobs");
            }
        }
        return result;
    }

    public Stack getJobs() {
        return (Stack)this.getJobs(0);
    }

    public Vector getJobs(int type) {
        Vector result = null;
        switch (type) {
            case 1: {
                result = this.jobsTodo;
                break;
            }
            case 2: {
                result = this.jobsDone;
                break;
            }
            case 3: {
                result = this.jobsFailed;
                break;
            }
            default: {
                result = this.jobs;
            }
        }
        return result;
    }

    public boolean isSynchronizing() {
        boolean result = false;
        String job = this.jobs.size() > 0 ? (String)this.jobs.peek() : "";
        if (job.equals(JOB_SYNCHRONIZE)) {
            if (this.pending.size() > 0 || this.additional.size() > 0) {
                result = true;
            } else {
                this.jobs.pop();
            }
        }
        return result;
    }

    protected boolean canSendJob() {
        boolean result = true;
        if (this.available.size() == 0 || this.jobs.size() == 0) {
            result = false;
        }
        if (this.isSynchronizing()) {
            result = false;
        }
        return result;
    }

    public void doDistributing() throws Exception {
        String job = this.jobs.size() > 0 ? (String)this.jobs.peek() : "";
        if (job.equals(JOB_DISTRIBUTE)) {
            if (this.pending.size() > 0 || this.additional.size() > 0) {
                return;
            }
            this.jobs.pop();
            int n = 0;
            while (n < this.received.size()) {
                String filename = (String)this.received.get(n);
                FileMessage message = new FileMessage();
                message.setLines(String.valueOf(this.cl.getValue("output")) + filename);
                message.setFilename(filename);
                int i = 0;
                while (i < this.clients.size()) {
                    String msg;
                    if (this.sender.send(this.clients.get(i), message.toString())) {
                        msg = "File '" + message.getFilename() + "' sent to " + this.clients.get(i);
                        this.addToAccessLog(msg);
                        this.println(msg);
                    } else {
                        msg = "File '" + message.getFilename() + "' could not be sent to " + this.clients.get(i);
                        this.addToErrorLog(msg);
                        this.println(msg);
                    }
                    ++i;
                }
                ++n;
            }
            this.received.clear();
        }
    }

    public Vector getReceived() {
        return this.received;
    }

    @Override
    public ClientList getClientList(int type) {
        ClientList result = super.getClientList(type);
        if (type == 1) {
            result = this.available;
        } else if (type == 2) {
            result = this.pending;
        } else if (type == 3) {
            result = this.additional;
        }
        return result;
    }

    private void checkForZombies(String listName, ClientList list) {
        int i = 0;
        while (i < list.size()) {
            if (!this.clients.contains(list.get(i))) {
                this.beforeRemoveClient(list.get(i), list);
                String msg = list.get(i) + " removed from " + listName;
                this.println(msg);
                this.addToErrorLog(String.valueOf(msg) + ": " + list.getJob(i));
                list.remove(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    protected void beforeRemoveClient(InetSocketAddress client, ClientList list) {
        String job = list.getJob(list.indexOf(client));
        if (!job.equals("")) {
            this.jobsFailed.add(job);
        }
    }

    @Override
    protected void afterCheckClients() {
        super.afterCheckClients();
        this.checkForZombies("Pending", this.pending);
        this.checkForZombies("Available", this.available);
        this.checkForZombies("Additional", this.additional);
        this.saveJobLists();
    }

    protected void saveJobLists() {
        TextFile.save(this.getJobsFilename(1), this.jobs);
        TextFile.save(this.getJobsFilename(2), this.jobsDone);
        TextFile.save(this.getJobsFilename(3), this.jobsFailed);
        ProperVector list = new ProperVector();
        int i = 0;
        while (i < this.pending.size()) {
            list.add(this.pending.getJob(i));
            ++i;
        }
        TextFile.save(this.jobsPendingFilename, list);
    }

    @Override
    protected boolean startup() {
        this.println("Starting Server...");
        boolean result = super.startup();
        if (result) {
            result = this.loadJobs();
        }
        if (result) {
            this.jobsTodoFilename = String.valueOf(this.getJobsFilename()) + ".todo";
            this.jobsDoneFilename = String.valueOf(this.getJobsFilename()) + ".done";
            this.jobsFailedFilename = String.valueOf(this.getJobsFilename()) + ".failed";
            this.jobsPendingFilename = String.valueOf(this.getJobsFilename()) + ".pending";
            if (!this.cl.exists("append_results")) {
                try {
                    File file = new File(this.cl.getValue("results"));
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.distributor.start();
        }
        return result;
    }

    public void sendShutdown() {
        int i = 0;
        while (i < this.clients.size()) {
            InetSocketAddress addr = this.clients.get(i);
            if (this.sender.send(addr, this.createMessage(REQUEST_SHUTDOWN).toString())) {
                String msg = "Sent SHUTDOWN to " + addr;
                this.addToAccessLog(msg);
                this.println("\n" + msg);
            }
            ++i;
        }
    }

    public void sendKill() {
        int i = 0;
        while (i < this.clients.size()) {
            InetSocketAddress addr = this.clients.get(i);
            if (this.sender.send(addr, this.createMessage(REQUEST_KILL).toString())) {
                String msg = "Sent KILL to " + addr;
                this.addToAccessLog(msg);
                this.println("\n" + msg);
            }
            ++i;
        }
    }

    @Override
    public boolean isOperational() {
        return this.pending.size() > 0 || this.additional.size() > 0 || this.jobs.size() > 0;
    }

    @Override
    protected void beforeAccept() {
        this.println("\nJobs/Clients/Pending/Additional: " + this.jobs.size() + "/" + this.clients.size() + "/" + this.pending.size() + "/" + this.additional.size());
    }

    @Override
    protected void shutdown() {
        this.sendShutdown();
    }

    @Override
    protected Processor createProcessor(Socket client) {
        JobServerProcessor proc = new JobServerProcessor(this, client);
        proc.setResults(this.cl.getValue("results"));
        proc.setOutput(this.cl.getValue("output"));
        return proc;
    }

    public static void main(String[] args) throws Exception {
        JobServer app = new JobServer();
        app.run(args);
    }
}

