/*
 * Decompiled with CFR 0.152.
 */
package proper.xml;

import java.io.FileReader;
import java.io.Reader;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import proper.util.ProperVector;
import proper.xml.Attribute;
import proper.xml.Element;

public class Parser
extends DefaultHandler {
    private String pi;
    private Element root;
    private boolean validate;
    private String content;
    private Stack current;
    private Vector errors;
    private Vector warnings;

    public Parser() {
        this.clear();
    }

    private void clear() {
        this.pi = null;
        this.root = null;
        this.content = null;
        this.validate = false;
        this.current = new Stack();
        this.errors = new ProperVector();
        this.warnings = new ProperVector();
    }

    public String getPI() {
        return this.pi;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public Element getRoot() {
        return this.root;
    }

    @Override
    public void startDocument() throws SAXException {
        this.pi = "<?xml version='1.0' encoding='UTF-8'?>";
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        Element node = new Element(qName);
        int i = 0;
        while (i < attrs.getLength()) {
            Attribute attr = new Attribute(attrs.getQName(i), attrs.getValue(i));
            node.addAttribute(attr);
            ++i;
        }
        if (this.current.size() == 0) {
            this.root = node;
        }
        if (this.current.size() > 0) {
            ((Element)this.current.peek()).add(node);
        }
        this.current.push(node);
        this.content = null;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        Element node;
        if (this.current.size() > 0 && (node = (Element)this.current.peek()).getName().equals(qName)) {
            node.setContent(this.content);
            this.current.pop();
        }
        this.content = null;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (len > 0) {
            if (this.content == null) {
                this.content = "";
            }
            this.content = String.valueOf(this.content) + new String(buf, offset, len);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.warnings.add(e);
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errors.add(e);
    }

    public Vector getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void parse(String filename) {
        try {
            this.parse(new FileReader(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parse(Reader reader) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            this.errors.clear();
            this.warnings.clear();
            factory.setValidating(this.getValidate());
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(reader), (DefaultHandler)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: proper.xml.Parser filename");
            System.exit(1);
        }
        Parser parser = new Parser();
        parser.parse(args[0]);
        System.out.println(String.valueOf(parser.getPI()) + "\n\n" + parser.getRoot());
    }
}

