/*
 * Decompiled with CFR 0.152.
 */
package data.catalog;

import data.Type;
import data.aggregate.AggregateFunction;
import data.catalog.Catalog;
import data.catalog.CatalogAttributes;
import data.catalog.CatalogLinks;
import data.feature.BasicFeature;
import data.feature.LinkFeature;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import model.inference.hc.AggregateBase;
import util.Couple;

public class CatalogFile
extends Catalog {
    private HashMap<Type, Couple<ArrayList<LinkFeature>, ArrayList<SimpleFeature>>> featuresByType = new HashMap();
    private HashMap<String, BasicFeature> featuresByName = new HashMap();
    private HashMap<String, Type> types = new HashMap();
    private ArrayList<AggregateFunction<?>> functions;
    private HashMap<LinkFeature, CatalogLinks> catalogLinks = new HashMap();
    private HashMap<SimpleFeature, CatalogAttributes> catalogAttributes = new HashMap();

    public CatalogFile() {
        this.instances = new Instances();
    }

    @Override
    public BasicFeature getFeatureByName(String n) {
        return this.featuresByName.get(n);
    }

    public void fillCatalog(String fileNamePrd, String fileNameFct) throws IOException {
        this.processPrdFile(fileNamePrd);
        this.processFctFile(fileNameFct);
        for (CatalogLinks catLink : this.catalogLinks.values()) {
            catLink.createIndexes(this);
        }
    }

    public void processPrdFile(String place) throws IOException {
        int c;
        FileReader fr = new FileReader(place);
        String prdContent = new String();
        while ((c = fr.read()) != -1) {
            prdContent = String.valueOf(prdContent) + (char)c;
        }
        fr.close();
        String[] lines = prdContent.split("\n");
        ArrayList<String> linesIndiv = new ArrayList<String>(lines.length);
        ArrayList<String> linesStruct = new ArrayList<String>(lines.length);
        ArrayList<String> linesProp = new ArrayList<String>(lines.length);
        ArrayList<String> linesType = new ArrayList<String>(lines.length);
        int type = -1;
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].isEmpty() && lines[i].charAt(0) != '%' && lines[i].charAt(0) != '!') {
                if (lines[i].equals("-INDIVIDUAL")) {
                    type = 0;
                } else if (lines[i].equals("-STRUCTURAL")) {
                    type = 1;
                } else if (lines[i].equals("-PROPERTIES")) {
                    type = 2;
                } else if (lines[i].equals("-TYPES")) {
                    type = 3;
                } else if (type == 0) {
                    linesIndiv.add(lines[i]);
                } else if (type == 1) {
                    linesStruct.add(lines[i]);
                } else if (type == 2) {
                    linesProp.add(lines[i]);
                } else if (type == 3) {
                    linesType.add(lines[i]);
                }
            }
            ++i;
        }
        i = 0;
        while (i < linesType.size()) {
            this.processTypes((String)linesType.get(i));
            ++i;
        }
        i = 0;
        while (i < linesStruct.size()) {
            this.processBasicFeatures((String)linesStruct.get(i), 1);
            ++i;
        }
        i = 0;
        while (i < linesProp.size()) {
            this.processBasicFeatures((String)linesProp.get(i), 2);
            ++i;
        }
    }

    private void processTypes(String line) {
        String[] tokens = line.split(" ");
        String name = tokens[0];
        int kind = Integer.parseInt(tokens[1]);
        Type t = new Type(name);
        t.setKind(kind);
        this.types.put(name, t);
    }

    private void processFctFile(String place) throws IOException {
        File fct = new File(place);
        if (fct.exists()) {
            BufferedReader fr2 = new BufferedReader(new FileReader(fct));
            String line = null;
            while ((line = fr2.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '!' || line.charAt(0) == '%') continue;
                this.processLine(line);
            }
            fr2.close();
        }
    }

    private void processLine(String line) {
        String[] temp1 = line.split("\\(");
        String name = temp1[0];
        BasicFeature bf = this.featuresByName.get(name);
        if (bf != null) {
            String[] temp2 = temp1[1].split("\\)");
            String[] arguments = temp2[0].split(",");
            String arg1 = arguments[0];
            Value rv1 = null;
            if (bf.getTypeIn().getKind() == 0) {
                rv1 = new Value(arg1);
            } else if (bf.getTypeIn().getKind() == 1) {
                rv1 = new Value(new Double(arg1));
            }
            if (!bf.getTypeIn().getValues().contains(rv1)) {
                bf.getTypeIn().getValues().add(rv1);
            }
            String arg2 = arguments[1];
            Value rv2 = null;
            if (bf.getTypeOut().getKind() == 0) {
                rv2 = new Value(arg2);
            } else if (bf.getTypeOut().getKind() == 1) {
                rv2 = new Value(new Double(arg2));
            }
            if (!bf.getTypeOut().getValues().contains(rv2)) {
                bf.getTypeOut().getValues().add(rv2);
            }
            this.insert(bf, rv1, rv2);
        }
    }

    private void processBasicFeatures(String pred, int n) {
        String[] tokens = pred.split(" ");
        String name = tokens[0];
        String firstArg = tokens[2];
        String secondArg = tokens[3];
        if (n == 1) {
            Type t2;
            String typeArg1 = firstArg.split(":")[1];
            String typeArg2 = secondArg.split(":")[1];
            Type t1 = this.types.get(typeArg1);
            if (!this.featuresByName.containsKey(t1)) {
                ArrayList a1 = new ArrayList();
                ArrayList a2 = new ArrayList();
                this.featuresByType.put(t1, new Couple(a1, a2));
            }
            if (!this.featuresByType.containsKey(t2 = this.types.get(typeArg2))) {
                ArrayList a1 = new ArrayList();
                ArrayList a2 = new ArrayList();
                this.featuresByType.put(t2, new Couple(a1, a2));
            }
            LinkFeature featToAdd = new LinkFeature(name, t1, t2);
            this.featuresByType.get(t1).getLeft().add(featToAdd);
            this.featuresByName.put(name, featToAdd);
        } else if (n == 2) {
            String typeArg1 = firstArg;
            String typeArg2 = secondArg.substring(1);
            Type t1 = this.types.get(typeArg1);
            if (!this.featuresByType.containsKey(t1)) {
                ArrayList a1 = new ArrayList();
                ArrayList a2 = new ArrayList();
                this.featuresByType.put(t1, new Couple(a1, a2));
            }
            Type t2 = this.types.get(typeArg2);
            SimpleFeature featToAdd = new SimpleFeature(name, t1, t2);
            this.featuresByType.get(t1).getRight().add(featToAdd);
            this.featuresByName.put(name, featToAdd);
        }
    }

    @Override
    public void setClassInstances(String nameFeature) {
        BasicFeature bf;
        this.classFeature = bf = this.featuresByName.get(nameFeature);
        CatalogAttributes classEntries = this.catalogAttributes.get((SimpleFeature)bf);
        for (Map.Entry<Value, Value> ent : classEntries.getAllEntries().entrySet()) {
            this.instances.add(new Instance(ent.getKey(), ent.getValue()));
        }
        this.featuresByType.get(this.classFeature.getTypeIn()).getRight().remove(this.classFeature);
    }

    public void setNumericTypes(ArrayList<String> numericTypes) {
        int i = 0;
        while (i < numericTypes.size()) {
            int j = 0;
            while (j < this.types.size()) {
                if (numericTypes.get(i).equals(this.types.get(j).getName())) {
                    this.types.get(j).setKind(1);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void insert(BasicFeature featureEntry, Value in, Value out) {
        if (featureEntry.isLink()) {
            LinkFeature lf = (LinkFeature)featureEntry;
            if (!this.catalogLinks.containsKey(lf)) {
                this.catalogLinks.put(lf, new CatalogLinks(lf));
            }
            this.catalogLinks.get(lf).insert(in, out);
        } else {
            SimpleFeature sf = (SimpleFeature)featureEntry;
            if (!this.catalogAttributes.containsKey(sf)) {
                this.catalogAttributes.put(sf, new CatalogAttributes(sf));
            }
            this.catalogAttributes.get(sf).insert(in, out);
        }
    }

    @Override
    public ArrayList<Value> getLinkedElements(LinkFeature lf, Value id) {
        boolean permuteAggBase;
        if (this.coupled) {
            boolean permute;
            boolean bl = permute = this.complAggToPermute != null && this.usingAgg != null && this.complAggToPermute.equals(this.usingAgg) && (this.complAggFeaturesCond.isEmpty() && this.usingFeaturesCond.isEmpty() || !this.complAggFeaturesCond.isEmpty() && !this.usingFeaturesCond.isEmpty() && this.usingFeaturesCond.containsAll(this.complAggFeaturesCond));
            if (permute) {
                return this.catalogLinks.get(lf).getEntriesPermuted(id);
            }
            return this.catalogLinks.get(lf).getEntries(id);
        }
        boolean bl = permuteAggBase = this.complAggToPermute != null && this.usingAgg != null && this.complAggToPermute.equals(this.usingAgg);
        if (permuteAggBase) {
            return this.catalogLinks.get(lf).getEntriesPermuted(id);
        }
        return this.catalogLinks.get(lf).getEntries(id);
    }

    @Override
    public Value getAttributeValue(SimpleFeature sf, Value id) {
        boolean permuteCondition;
        if (this.coupled) {
            boolean permute;
            boolean bl = permute = this.complAggToPermute != null && this.usingAgg != null && this.complAggToPermute.equals(this.usingAgg) && (this.complAggFeaturesCond.isEmpty() && this.usingFeaturesCond.isEmpty() || !this.complAggFeaturesCond.isEmpty() && !this.usingFeaturesCond.isEmpty() && this.usingFeaturesCond.containsAll(this.complAggFeaturesCond)) || this.mainFeatToPermute != null && this.mainFeatToPermute.equals(sf);
            if (permute) {
                return this.catalogAttributes.get(sf).getValuePermuted(id);
            }
            return this.catalogAttributes.get(sf).getValue(id);
        }
        boolean bl = permuteCondition = this.complAggFeaturesCond != null && this.usingFeaturesCond != null && (this.complAggFeaturesCond.isEmpty() && this.usingFeaturesCond.isEmpty() || !this.complAggFeaturesCond.isEmpty() && !this.usingFeaturesCond.isEmpty() && this.usingFeaturesCond.containsAll(this.complAggFeaturesCond)) || this.mainFeatToPermute != null && this.mainFeatToPermute.equals(sf);
        if (permuteCondition) {
            return this.catalogAttributes.get(sf).getValuePermuted(id);
        }
        return this.catalogAttributes.get(sf).getValue(id);
    }

    @Override
    public BasicFeature getClassFeature() {
        return this.classFeature;
    }

    @Override
    public ArrayList<SimpleFeature> getSimpleFeatures(Type t) {
        return this.featuresByType.get(t).getRight();
    }

    @Override
    public ArrayList<SimpleFeature> getSimpleFeatures() {
        return new ArrayList<SimpleFeature>(this.catalogAttributes.keySet());
    }

    @Override
    public ArrayList<LinkFeature> getLinkFeatures(Type t) {
        return this.featuresByType.get(t).getLeft();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return new String(sb);
    }

    public ArrayList<AggregateFunction<?>> getFunctions() {
        return this.functions;
    }

    public void setFunctions(ArrayList<AggregateFunction<?>> functions) {
        this.functions = functions;
    }

    public void insert(String id, String feat, String val) {
        BasicFeature bf = this.featuresByName.get(feat);
        if (bf != null) {
            Value rv1 = null;
            if (bf.getTypeIn().getKind() == 0) {
                rv1 = new Value(id);
            } else if (bf.getTypeIn().getKind() == 1) {
                rv1 = new Value(new Double(id));
            }
            if (!bf.getTypeIn().getValues().contains(rv1)) {
                bf.getTypeIn().getValues().add(rv1);
            }
            Value rv2 = null;
            if (bf.getTypeOut().getKind() == 0) {
                rv2 = new Value(val);
            } else if (bf.getTypeOut().getKind() == 1) {
                rv2 = new Value(new Double(val));
            }
            if (!bf.getTypeOut().getValues().contains(rv2)) {
                bf.getTypeOut().getValues().add(rv2);
            }
            this.insert(bf, rv1, rv2);
        }
    }

    @Override
    public Catalog clone() {
        CatalogFile res = new CatalogFile();
        res.setupSchema(this.types, this.featuresByType, this.featuresByName, this.functions, this.instances);
        res.setupContent(this.catalogLinks, this.catalogAttributes);
        res.setClassInstances(this.classFeature, this.instances);
        return res;
    }

    private void setupContent(HashMap<LinkFeature, CatalogLinks> catalogLinks2, HashMap<SimpleFeature, CatalogAttributes> catalogAttributes2) {
        for (Map.Entry<LinkFeature, CatalogLinks> entry : catalogLinks2.entrySet()) {
            this.catalogLinks.put(entry.getKey(), entry.getValue().clone());
        }
        for (Map.Entry<BasicFeature, Object> entry : catalogAttributes2.entrySet()) {
            this.catalogAttributes.put((SimpleFeature)entry.getKey(), ((CatalogAttributes)entry.getValue()).clone());
        }
    }

    private void setupSchema(HashMap<String, Type> types2, HashMap<Type, Couple<ArrayList<LinkFeature>, ArrayList<SimpleFeature>>> featuresByType2, HashMap<String, BasicFeature> featuresByName2, ArrayList<AggregateFunction<?>> functions2, Instances insts) {
        this.types = new HashMap<String, Type>(types2);
        this.functions = new ArrayList(functions2);
        this.featuresByType = new HashMap<Type, Couple<ArrayList<LinkFeature>, ArrayList<SimpleFeature>>>(featuresByType2);
        this.featuresByName = new HashMap<String, BasicFeature>(featuresByName2);
        this.instances = insts;
    }

    @Override
    public void permute(Instances insts, AggregateBase agg, HashSet<SimpleFeature> set) {
        ArrayList<Value> sidsToPerm = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).flatMap(id -> agg.getLink().getLinkedElements((Value)id, this).stream()).collect(Collectors.toList()));
        for (SimpleFeature sf : set) {
            this.catalogAttributes.get(sf).permute(sidsToPerm);
        }
        ArrayList<Value> idsToPerm = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList()));
        this.catalogLinks.get(agg.getLink()).permute(idsToPerm);
        this.complAggToPermute = agg;
        this.complAggFeaturesCond = set;
    }

    @Override
    public void permuteBlocks(Instances insts, AggregateBase agg) {
        ArrayList<Value> idsToPerm = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList()));
        this.catalogLinks.get(agg.getLink()).permute(idsToPerm);
        this.complAggToPermute = agg;
    }

    @Override
    public void permuteFeaturesInBlock(Instances insts, HashSet<SimpleFeature> sfs) {
        ArrayList idsToPerm = new ArrayList(insts.stream().map(inst -> inst.getId()).map(id -> this.complAggToPermute.getLink().getLinkedElements((Value)id, this)).collect(Collectors.toList()));
        for (SimpleFeature sf : sfs) {
            for (ArrayList vals : idsToPerm) {
                this.catalogAttributes.get(sf).permute(vals);
            }
        }
        this.complAggFeaturesCond = sfs;
    }

    @Override
    public void permuteFeatures(Instances insts, LinkFeature lf, HashSet<SimpleFeature> sfs) {
        if (lf == null) {
            ArrayList<Value> secIds = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList()));
            for (SimpleFeature sf : sfs) {
                this.catalogAttributes.get(sf).permute(secIds);
                this.mainFeatToPermute = sf;
            }
        } else {
            ArrayList<Value> secIds = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).flatMap(id -> lf.getLinkedElements((Value)id, this).stream()).collect(Collectors.toList()));
            for (SimpleFeature sf : sfs) {
                this.catalogAttributes.get(sf).permute(secIds);
            }
        }
        this.complAggFeaturesCond = sfs;
    }

    @Override
    public void clearPermutations() {
        if (this.complAggToPermute != null) {
            this.catalogLinks.get(this.complAggToPermute.getLink()).clearPermutation();
        }
        if (this.complAggFeaturesCond != null) {
            for (SimpleFeature sf : this.complAggFeaturesCond) {
                this.catalogAttributes.get(sf).clearPermutation();
            }
        }
        if (this.mainFeatToPermute != null) {
            this.catalogAttributes.get(this.mainFeatToPermute).clearPermutation();
        }
        this.complAggToPermute = null;
        this.complAggFeaturesCond = null;
        this.mainFeatToPermute = null;
    }

    @Override
    public void permuteBlockwise(Instances insts, AggregateBase agg, HashSet<SimpleFeature> sfs) {
        ArrayList<Value> idsToPerm = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList()));
        this.catalogLinks.get(agg.getLink()).permute(idsToPerm);
        this.complAggToPermute = agg;
        this.complAggFeaturesCond = sfs;
    }

    @Override
    public double[] getAttributeRange(SimpleFeature sf) {
        return new double[]{this.catalogAttributes.get(sf).getMin(), this.catalogAttributes.get(sf).getMax()};
    }

    @Override
    public void initShifts(Instances insts, Catalog cat) {
        Type type = this.classFeature.getTypeIn();
        ArrayList<Value> vals = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList()));
        this.initRec(type, vals, cat);
    }

    public void initRec(Type type, ArrayList<Value> vals, Catalog cat) {
        Couple<ArrayList<LinkFeature>, ArrayList<SimpleFeature>> feats = this.featuresByType.get(type);
        if (feats != null) {
            for (SimpleFeature sf : feats.getRight()) {
                sf.initShifts(vals, cat);
            }
            for (LinkFeature lf : feats.getLeft()) {
                ArrayList<Value> nextVals = new ArrayList<Value>(vals.stream().flatMap(v -> this.getLinkedElements(lf, (Value)v).stream()).collect(Collectors.toList()));
                this.initRec(lf.getTypeOut(), nextVals, cat);
            }
        }
    }

    @Override
    public void deployShifts(Instances insts, Catalog cat) {
        Type type = this.classFeature.getTypeIn();
        ArrayList<Value> vals = new ArrayList<Value>(insts.stream().map(inst -> inst.getId()).collect(Collectors.toList()));
        this.deployRec(type, vals, cat);
    }

    public void deployRec(Type type, ArrayList<Value> vals, Catalog cat) {
        Couple<ArrayList<LinkFeature>, ArrayList<SimpleFeature>> feats = this.featuresByType.get(type);
        if (feats != null) {
            for (SimpleFeature sf : feats.getRight()) {
                sf.deployShifts(vals, cat);
            }
            for (LinkFeature lf : feats.getLeft()) {
                ArrayList<Value> nextVals = new ArrayList<Value>(vals.stream().flatMap(v -> this.getLinkedElements(lf, (Value)v).stream()).collect(Collectors.toList()));
                this.deployRec(lf.getTypeOut(), nextVals, cat);
            }
        }
    }
}

