/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.TeraConnectionPoolDataSource;
import com.teradata.jdbc.TeraPooledConnection;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.PooledConnection;

public class TeraLogicalConnection
implements Connection {
    private TeraPooledConnection myPooledCon = null;
    private Connection realConnection = null;
    private TeraConnectionPoolDataSource dataSource = null;
    private boolean isOpen = true;

    TeraLogicalConnection(TeraConnectionPoolDataSource teraConnectionPoolDataSource, TeraPooledConnection teraPooledConnection, Connection connection) {
        this.dataSource = teraConnectionPoolDataSource;
        if (this.logging()) {
            this.logit("New " + this);
        }
        this.realConnection = connection;
        this.myPooledCon = teraPooledConnection;
    }

    public void clearWarnings() throws SQLException {
        try {
            this.getMyConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        if (this.dataSource.logging()) {
            this.logit("Close " + this);
        }
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ187");
        }
        this.setOpenState(false);
        this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon()));
    }

    public void commit() throws SQLException {
        try {
            this.getMyConnection().commit();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        try {
            return this.getMyConnection().createStatement();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            return this.getMyConnection().createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getMyConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.getMyConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Connection getMyConnection() throws SQLException {
        if (this.isClosed()) {
            if (this.dataSource.logging()) {
                this.logit("Close called but connection is already closed" + this);
            }
            throw ErrorFactory.makeDriverJDBCException("TJ186");
        }
        return this.realConnection;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getMyConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getMyConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getMyConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getMyConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.getMyConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public boolean logging() {
        return this.dataSource.logging();
    }

    public void logit(String string) {
        this.dataSource.logit(string);
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            return this.getMyConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            return this.getMyConnection().prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return this.getMyConnection().prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        try {
            this.getMyConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.getMyConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        try {
            this.getMyConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getMyConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getMyConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.getMyConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PooledConnection getMyPooledCon() {
        return this.myPooledCon;
    }

    public void setOpenState(boolean bl) {
        this.isOpen = bl;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setHoldability(int n) throws SQLException {
        try {
            this.getMyConnection().setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public int getHoldability() throws SQLException {
        try {
            return this.getMyConnection().getHoldability();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.getMyConnection().setSavepoint();
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            return this.getMyConnection().setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.getMyConnection().rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getMyConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            return this.getMyConnection().createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            return this.getMyConnection().prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            return this.getMyConnection().prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.myPooledCon.notifyListeners(new ConnectionEvent(this.getMyPooledCon(), sQLException));
            throw sQLException;
        }
    }
}

