"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsRuleToSns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_eventbridge_sns_1 = require("@aws-solutions-constructs/aws-eventbridge-sns");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
class EventsRuleToSns extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the EventRuleToSns class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventsRuleToSnsProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const convertedProps = { ...props };
        // W (for 'wrapped') is added to the id so that the id's of the constructs with the old and new names don't collide
        // If this character pushes you beyond the 64 character limit, just import the new named construct and instantiate
        // it in place of the older named version. They are functionally identical, aside from the types no other changes
        // will be required.  (eg - new EventbridgeToSns instead of EventsRuleToSns)
        const wrappedConstruct = new aws_eventbridge_sns_1.EventbridgeToSns(this, `${id}W`, convertedProps);
        this.snsTopic = wrappedConstruct.snsTopic;
        this.eventsRule = wrappedConstruct.eventsRule;
        this.encryptionKey = wrappedConstruct.encryptionKey;
        this.eventBus = wrappedConstruct.eventBus;
    }
}
exports.EventsRuleToSns = EventsRuleToSns;
_a = JSII_RTTI_SYMBOL_1;
EventsRuleToSns[_a] = { fqn: "@aws-solutions-constructs/aws-events-rule-sns.EventsRuleToSns", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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