"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', {
            description: 'Proxy to npmjs.com for ConstructHub',
            domainName: (_b = props.codeArtifactDomain) === null || _b === void 0 ? void 0 : _b.name,
            domainExists: props.codeArtifactDomain != null,
            upstreams: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.upstreams,
        });
        const vpc = ((_d = props.isolateLambdas) !== null && _d !== void 0 ? _d : true) ? new ec2.Vpc(this, 'Lambda-VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 0,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                {
                    name: 'Public',
                    subnetType: ec2.SubnetType.PUBLIC,
                    reserved: true,
                },
                {
                    name: 'Private',
                    subnetType: ec2.SubnetType.PRIVATE,
                    reserved: true,
                },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED },
            ],
        })
            : undefined;
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = vpc && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [{ subnetType: ec2.SubnetType.ISOLATED }],
            }),
        };
        // The S3 access is necessary for the CodeArtifact VPC endpoint to be used.
        vpcEndpoints === null || vpcEndpoints === void 0 ? void 0 : vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [`${codeArtifact.s3BucketArn}/*`],
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-Bucket',
        }));
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_e = props.denyList) !== null && _e !== void 0 ? _e : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets: { subnetType: ec2.SubnetType.ISOLATED },
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder);
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            orchestration,
            monitoring,
            packageLinks: props.packageLinks,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_f = props.allowedLicenses) !== null && _f !== void 0 ? _f : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.mit(),
            ],
        });
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', {
            bucket: packageData,
            monitoring,
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_g = props.packageSources) !== null && _g !== void 0 ? _g : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
        });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.1.186" };
//# sourceMappingURL=data:application/json;base64,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