# Generated by uml2django - 
# https://steelkiwi.com/blog/best-practices-working-django-models-python/
# https://learndjango.com/tutorials/django-best-practices-models
from django.db import models
from django.utils.translation import gettext_lazy as _
from django.urls import reverse

class SubjectClass(
    models.Model
):
    subject = models.ForeignKey(
        'Subject',
        verbose_name=_('subject'),
        help_text=_('subject help text'),
        on_delete=models.PROTECT,
    )
    subject_level = models.ForeignKey(
        'SubjectLevel',
        verbose_name=_('subject level'),
        help_text=_('subject level help text'),
        on_delete=models.PROTECT,
    )
    title = models.CharField(
        max_length=255,
        verbose_name=_('title'),
        help_text=_('title help text'),
    )
    capacity = models.IntegerField(
        verbose_name=_('capacity'),
        help_text=_('capacity help text'),
    )
    start_date = models.DateField(
        verbose_name=_('start date'),
        help_text=_('start date help text'),
    )
    end_date = models.DateField(
        verbose_name=_('end date'),
        help_text=_('end date help text'),
    )


    class Meta:
        verbose_name = _("subjectclass")
        verbose_name_plural = _("subjectclasses")

    # def __str__(self): 
    #     return self.

    def get_absolute_url(self):
        return reverse("subjectclass-detail", args=[str(self.id)])
