# Generated by uml2django - 
# https://steelkiwi.com/blog/best-practices-working-django-models-python/
# https://learndjango.com/tutorials/django-best-practices-models
from django.db import models
from django.utils.translation import gettext_lazy as _
from django.urls import reverse

class SubjectClassSchedulePeriod(
    models.Model
):
    subject_class = models.ForeignKey(
        'SubjectClass',
        verbose_name=_('subject class'),
        help_text=_('subject class help text'),
        on_delete=models.PROTECT,
    )
    day_of_week = models.CharField(
        max_length=255,
        verbose_name=_('day of week'),
        help_text=_('day of week help text'),
    )
    from_hour = models.TimeField(
        verbose_name=_('from hour'),
        help_text=_('from hour help text'),
    )
    to_time = models.TimeField(
        verbose_name=_('to time'),
        help_text=_('to time help text'),
    )


    class Meta:
        verbose_name = _("subjectclassscheduleperiod")
        verbose_name_plural = _("subjectclassscheduleperiods")
        unique_together = (
            'subject_class',
            'day_of_week',
            'from_hour',
            'to_time',
        )

    # def __str__(self): 
    #     return self.

    def get_absolute_url(self):
        return reverse("subjectclassscheduleperiod-detail", args=[str(self.id)])
