#Core Django imports
from django.test import TestCase
from django.urls import reverse

#Third-party app imports
from model_bakery import baker

from educational.models import SubjectRequirement


class SubjectRequirementViewsTest(TestCase):

    def setUp(self):
        self.subjectrequirement = baker.make(SubjectRequirement)

    def test_subjectrequirement_create_view_status_code(self):
        url = reverse("subjectrequirement-create")
        resp = self.client.get(url)
        self.assertEqual(resp.status_code, 200)
    def test_subjectrequirement_delete_view_status_code(self):
        url = reverse("subjectrequirement-delete",  args=[1])
        resp = self.client.get(url)
        self.assertEqual(resp.status_code, 200)
    def test_subjectrequirement_detail_view_status_code(self):
        url = reverse("subjectrequirement-detail",  args=[1])
        resp = self.client.get(url)
        self.assertEqual(resp.status_code, 200)
    def test_subjectrequirement_list_view_status_code(self):
        url = reverse("subjectrequirement-list")
        resp = self.client.get(url)
        self.assertEqual(resp.status_code, 200)
    def test_subjectrequirement_update_view_status_code(self):
        url = reverse("subjectrequirement-update",  args=[1])
        resp = self.client.get(url)
        self.assertEqual(resp.status_code, 200)
