# Generated by uml2django - 
# https://steelkiwi.com/blog/best-practices-working-django-models-python/
# https://learndjango.com/tutorials/django-best-practices-models
from django.db import models
from django.utils.translation import gettext_lazy as _
from django.urls import reverse

class ClassRoom(
    models.Model
):
    building = models.ForeignKey(
        'Building',
        verbose_name=_('building'),
        help_text=_('building help text'),
        on_delete=models.PROTECT,
    )
    name = models.CharField(
        max_length=255,
        verbose_name=_('name'),
        help_text=_('name help text'),
    )

    slug = models.SlugField(null=False, unique=True) 

    class Meta:
        verbose_name = _("classroom")
        verbose_name_plural = _("classrooms")
        unique_together = (
            'building',
            'name',
        )

    # def __str__(self): 
    #     return self.

    def get_absolute_url(self):
        return reverse("classroom-detail", args=[str(self.id)])
