# Generated by uml2django - 
# https://steelkiwi.com/blog/best-practices-working-django-models-python/
# https://learndjango.com/tutorials/django-best-practices-models
from django.db import models
from django.utils.translation import gettext_lazy as _
from django.urls import reverse

class WorkingPeriod(
    models.Model
):
    building = models.ForeignKey(
        'Building',
        verbose_name=_('building'),
        help_text=_('building help text'),
        on_delete=models.PROTECT,
    )
    class_room = models.ForeignKey(
        'ClassRoom',
        verbose_name=_('class room'),
        help_text=_('class room help text'),
        on_delete=models.PROTECT,
    )
    day_of_week = models.CharField(
        max_length=255,
        verbose_name=_('day of week'),
        help_text=_('day of week help text'),
    )
    from_hour = models.TimeField(
        verbose_name=_('from hour'),
        help_text=_('from hour help text'),
    )
    to_time = models.TimeField(
        verbose_name=_('to time'),
        help_text=_('to time help text'),
    )


    class Meta:
        verbose_name = _("workingperiod")
        verbose_name_plural = _("workingperiods")

    # def __str__(self): 
    #     return self.

    def get_absolute_url(self):
        return reverse("workingperiod-detail", args=[str(self.id)])
