# Generated by uml2django
# https://github.com/J-hanks/uml2django

from django.utils.text import slugify

from rest_framework import serializers

from infrastructure.models import Building
from infrastructure.models.WorkingPeriod import WorkingPeriod

from infrastructure.rest_api.serializers.WorkingPeriodSerializer import WorkingPeriodSerializer


class BuildingSerializer(serializers.ModelSerializer):
    workingperiod_set = WorkingPeriodSerializer(
        # source='workingperiod_set',
        many=True,
        required=False, 
        allow_null=True
    )
    

    class Meta:
        model = Building
        fields = [
            'name',
            'slug',
            'workingperiod_set',
        ]
        read_only_fields = ['slug']
        lookup_field = 'slug'
        extra_kwargs = {
            'url': {'lookup_field': 'slug'}
        }

    def create(self, validated_data):
        workingperiod_set_data = validated_data.pop('workingperiod_set')
        building = Building(**validated_data)
        for workingperiod_data in workingperiod_set_data:
            WorkingPeriod.objects.create(
                building=building,
                **workingperiod_data
            )

        building.slug = slugify(building.name)
        building.save()
        return building
