# infrastructure/urls.py
# Generated by uml2django

from django.urls import path, include
from infrastructure.rest_api.router import router

from infrastructure.views import (
	BuildingCreateView,
	BuildingDeleteView,
	BuildingDetailView,
	BuildingListView,
	BuildingUpdateView,
	ClassRoomCreateView,
	ClassRoomDeleteView,
	ClassRoomDetailView,
	ClassRoomListView,
	ClassRoomUpdateView,
	WorkingPeriodCreateView,
	WorkingPeriodDeleteView,
	WorkingPeriodDetailView,
	WorkingPeriodListView,
	WorkingPeriodUpdateView
)


urlpatterns = [
    path('', include(router.urls)),
	path("Building/create", BuildingCreateView.as_view(), name="building-create"),
	path("Building/<int:pk>/delete", BuildingDeleteView.as_view(), name="building-delete"),
	path("Building/<int:pk>", BuildingDetailView.as_view(), name="building-detail"),
	path("Building/list", BuildingListView.as_view(), name="building-list"),
	path("Building/<int:pk>/update", BuildingUpdateView.as_view(), name="building-update"),
	path("ClassRoom/create", ClassRoomCreateView.as_view(), name="classroom-create"),
	path("ClassRoom/<int:pk>/delete", ClassRoomDeleteView.as_view(), name="classroom-delete"),
	path("ClassRoom/<int:pk>", ClassRoomDetailView.as_view(), name="classroom-detail"),
	path("ClassRoom/list", ClassRoomListView.as_view(), name="classroom-list"),
	path("ClassRoom/<int:pk>/update", ClassRoomUpdateView.as_view(), name="classroom-update")
,
	path("WorkingPeriod/create", WorkingPeriodCreateView.as_view(), name="workingperiod-create"),
	path("WorkingPeriod/<int:pk>/delete", WorkingPeriodDeleteView.as_view(), name="workingperiod-delete"),
	path("WorkingPeriod/<int:pk>", WorkingPeriodDetailView.as_view(), name="workingperiod-detail"),
	path("WorkingPeriod/list", WorkingPeriodListView.as_view(), name="workingperiod-list"),
	path("WorkingPeriod/<int:pk>/update", WorkingPeriodUpdateView.as_view(), name="workingperiod-update")
]
