# people/urls.py
# Generated by uml2django

from django.urls import path, include
from people.rest_api.router import router

from people.views import (
	StudentCreateView,
	StudentDeleteView,
	StudentDetailView,
	StudentListView,
	StudentUpdateView,
	InstructorCreateView,
	InstructorDeleteView,
	InstructorDetailView,
	InstructorListView,
	InstructorUpdateView
)


urlpatterns = [
    path('', include(router.urls)),
	path("Student/create", StudentCreateView.as_view(), name="student-create"),
	path("Student/<int:pk>/delete", StudentDeleteView.as_view(), name="student-delete"),
	path("Student/<int:pk>", StudentDetailView.as_view(), name="student-detail"),
	path("Student/list", StudentListView.as_view(), name="student-list"),
	path("Student/<int:pk>/update", StudentUpdateView.as_view(), name="student-update"),
	path("Instructor/create", InstructorCreateView.as_view(), name="instructor-create"),
	path("Instructor/<int:pk>/delete", InstructorDeleteView.as_view(), name="instructor-delete"),
	path("Instructor/<int:pk>", InstructorDetailView.as_view(), name="instructor-detail"),
	path("Instructor/list", InstructorListView.as_view(), name="instructor-list"),
	path("Instructor/<int:pk>/update", InstructorUpdateView.as_view(), name="instructor-update")
]
