# Generated by Django 3.2 on 2021-10-27 14:03

import django.contrib.postgres.search
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import urlid_graph.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ObjectRepository',
            fields=[
                ('uuid', models.UUIDField(primary_key=True, serialize=False)),
                ('internal_id', models.TextField()),
                ('search_data', django.contrib.postgres.search.SearchVectorField(null=True)),
            ],
            options={
                'db_table': 'urlid_object_repository',
                'managed': False,
            },
            bases=(urlid_graph.models.ObjectMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Entity',
            fields=[
                ('uuid', models.UUIDField(primary_key=True, serialize=False)),
                ('base_url', models.TextField()),
                ('name', models.TextField()),
                ('version', models.TextField()),
            ],
            managers=[
                ('brasilio', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Property',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField()),
                ('value', models.TextField(blank=True, null=True)),
                ('value_type', models.SmallIntegerField(choices=[(1, 'str'), (2, 'date'), (3, 'datetime'), (4, 'float'), (5, 'int'), (6, 'bool')])),
                ('source', models.TextField()),
                ('value_datetime', models.DateTimeField(null=True)),
                ('updated_at', models.DateTimeField(blank=True, null=True)),
                ('object', models.ForeignKey(db_column='object_uuid', db_constraint=False, db_index=False, on_delete=django.db.models.deletion.DO_NOTHING, to='urlid_graph.objectrepository')),
            ],
        ),
        migrations.CreateModel(
            name='Object',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(db_index=True)),
                ('internal_id', models.TextField()),
                ('entity', models.ForeignKey(db_column='entity_uuid', db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, to='urlid_graph.entity')),
            ],
            bases=(urlid_graph.models.ObjectMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ElementConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('config_type', models.PositiveSmallIntegerField(choices=[(1, 'entity'), (2, 'relationship'), (3, 'property'), (4, 'stats')])),
                ('name', models.TextField()),
                ('parent_type', models.PositiveSmallIntegerField(choices=[(1, 'entity'), (2, 'relationship')], null=True)),
                ('parent_name', models.TextField(null=True)),
                ('label', models.TextField()),
                ('data', models.JSONField()),
            ],
            options={
                'unique_together': {('config_type', 'name', 'parent_type', 'parent_name')},
            },
        ),
        migrations.CreateModel(
            name='EntityConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='EntityPropertyConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='RelationshipConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='RelPropertyConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='StatsConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.AddIndex(
            model_name='property',
            index=models.Index(fields=['object', 'value_type'], name='urlid_graph_object__fbf252_idx'),
        ),
    ]
