# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.2.0  # noqa: E501
    The version of the OpenAPI document: 0.10.4
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from symbol_openapi_client.api_client import ApiClient
from symbol_openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TransactionRoutesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def announce_cosignature_transaction(self, cosignature, **kwargs):  # noqa: E501
        """Announce a cosignature transaction  # noqa: E501

        Announces a cosignature transaction to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.announce_cosignature_transaction(cosignature, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Cosignature cosignature: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AnnounceTransactionInfoDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.announce_cosignature_transaction_with_http_info(cosignature, **kwargs)  # noqa: E501

    def announce_cosignature_transaction_with_http_info(self, cosignature, **kwargs):  # noqa: E501
        """Announce a cosignature transaction  # noqa: E501

        Announces a cosignature transaction to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.announce_cosignature_transaction_with_http_info(cosignature, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Cosignature cosignature: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AnnounceTransactionInfoDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'cosignature'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method announce_cosignature_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cosignature' is set
        if self.api_client.client_side_validation and ('cosignature' not in local_var_params or  # noqa: E501
                                                        local_var_params['cosignature'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `cosignature` when calling `announce_cosignature_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cosignature' in local_var_params:
            body_params = local_var_params['cosignature']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/cosignature', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnnounceTransactionInfoDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def announce_partial_transaction(self, transaction_payload, **kwargs):  # noqa: E501
        """Announce an aggregate bonded transaction  # noqa: E501

        Announces an aggregate bonded transaction to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.announce_partial_transaction(transaction_payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionPayload transaction_payload: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AnnounceTransactionInfoDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.announce_partial_transaction_with_http_info(transaction_payload, **kwargs)  # noqa: E501

    def announce_partial_transaction_with_http_info(self, transaction_payload, **kwargs):  # noqa: E501
        """Announce an aggregate bonded transaction  # noqa: E501

        Announces an aggregate bonded transaction to the network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.announce_partial_transaction_with_http_info(transaction_payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionPayload transaction_payload: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AnnounceTransactionInfoDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_payload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method announce_partial_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_payload' is set
        if self.api_client.client_side_validation and ('transaction_payload' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_payload'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_payload` when calling `announce_partial_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_payload' in local_var_params:
            body_params = local_var_params['transaction_payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/partial', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnnounceTransactionInfoDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def announce_transaction(self, transaction_payload, **kwargs):  # noqa: E501
        """Announce a new transaction  # noqa: E501

        Announces a transaction to the network. The [catbuffer library](https://github.com/nemtech/catbuffer) defines the protocol to serialize and deserialize Symbol entities. Catbuffers are integrated into [Symbol SDKs](https://nemtech.github.io/sdk.html).  It's recommended to use SDKs instead of calling the API endpoint directly to announce transactions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.announce_transaction(transaction_payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionPayload transaction_payload: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AnnounceTransactionInfoDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.announce_transaction_with_http_info(transaction_payload, **kwargs)  # noqa: E501

    def announce_transaction_with_http_info(self, transaction_payload, **kwargs):  # noqa: E501
        """Announce a new transaction  # noqa: E501

        Announces a transaction to the network. The [catbuffer library](https://github.com/nemtech/catbuffer) defines the protocol to serialize and deserialize Symbol entities. Catbuffers are integrated into [Symbol SDKs](https://nemtech.github.io/sdk.html).  It's recommended to use SDKs instead of calling the API endpoint directly to announce transactions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.announce_transaction_with_http_info(transaction_payload, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionPayload transaction_payload: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AnnounceTransactionInfoDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_payload'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method announce_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_payload' is set
        if self.api_client.client_side_validation and ('transaction_payload' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_payload'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_payload` when calling `announce_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_payload' in local_var_params:
            body_params = local_var_params['transaction_payload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AnnounceTransactionInfoDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_confirmed_transaction(self, transaction_id, **kwargs):  # noqa: E501
        """Get confirmed transaction information  # noqa: E501

        Returns confirmed transaction information given a transactionId or hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_confirmed_transaction(transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str transaction_id: Transaction id or hash. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TransactionInfoDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_confirmed_transaction_with_http_info(transaction_id, **kwargs)  # noqa: E501

    def get_confirmed_transaction_with_http_info(self, transaction_id, **kwargs):  # noqa: E501
        """Get confirmed transaction information  # noqa: E501

        Returns confirmed transaction information given a transactionId or hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_confirmed_transaction_with_http_info(transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str transaction_id: Transaction id or hash. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TransactionInfoDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_confirmed_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_id` when calling `get_confirmed_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in local_var_params:
            path_params['transactionId'] = local_var_params['transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/confirmed/{transactionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionInfoDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_confirmed_transactions(self, transaction_ids, **kwargs):  # noqa: E501
        """Get confirmed trasactions information  # noqa: E501

        Returns confirmed transactions information for a given array of transactionIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_confirmed_transactions(transaction_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionIds transaction_ids: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TransactionInfoDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_confirmed_transactions_with_http_info(transaction_ids, **kwargs)  # noqa: E501

    def get_confirmed_transactions_with_http_info(self, transaction_ids, **kwargs):  # noqa: E501
        """Get confirmed trasactions information  # noqa: E501

        Returns confirmed transactions information for a given array of transactionIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_confirmed_transactions_with_http_info(transaction_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionIds transaction_ids: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TransactionInfoDTO], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_confirmed_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_ids' is set
        if self.api_client.client_side_validation and ('transaction_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_ids` when calling `get_confirmed_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_ids' in local_var_params:
            body_params = local_var_params['transaction_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/confirmed', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TransactionInfoDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_partial_transaction(self, transaction_id, **kwargs):  # noqa: E501
        """Get partial transaction information  # noqa: E501

        Returns partial transaction information given a transactionId or hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_partial_transaction(transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str transaction_id: Transaction id or hash. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TransactionInfoDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_partial_transaction_with_http_info(transaction_id, **kwargs)  # noqa: E501

    def get_partial_transaction_with_http_info(self, transaction_id, **kwargs):  # noqa: E501
        """Get partial transaction information  # noqa: E501

        Returns partial transaction information given a transactionId or hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_partial_transaction_with_http_info(transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str transaction_id: Transaction id or hash. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TransactionInfoDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_partial_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_id` when calling `get_partial_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in local_var_params:
            path_params['transactionId'] = local_var_params['transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/partial/{transactionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionInfoDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_partial_transactions(self, transaction_ids, **kwargs):  # noqa: E501
        """Get partial trasactions information  # noqa: E501

        Returns partial transactions information for a given array of transactionIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_partial_transactions(transaction_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionIds transaction_ids: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TransactionInfoDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_partial_transactions_with_http_info(transaction_ids, **kwargs)  # noqa: E501

    def get_partial_transactions_with_http_info(self, transaction_ids, **kwargs):  # noqa: E501
        """Get partial trasactions information  # noqa: E501

        Returns partial transactions information for a given array of transactionIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_partial_transactions_with_http_info(transaction_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionIds transaction_ids: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TransactionInfoDTO], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_partial_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_ids' is set
        if self.api_client.client_side_validation and ('transaction_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_ids` when calling `get_partial_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_ids' in local_var_params:
            body_params = local_var_params['transaction_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/partial', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TransactionInfoDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_unconfirmed_transaction(self, transaction_id, **kwargs):  # noqa: E501
        """Get unconfirmed transaction information  # noqa: E501

        Returns unconfirmed transaction information given a transactionId or hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unconfirmed_transaction(transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str transaction_id: Transaction id or hash. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TransactionInfoDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_unconfirmed_transaction_with_http_info(transaction_id, **kwargs)  # noqa: E501

    def get_unconfirmed_transaction_with_http_info(self, transaction_id, **kwargs):  # noqa: E501
        """Get unconfirmed transaction information  # noqa: E501

        Returns unconfirmed transaction information given a transactionId or hash.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unconfirmed_transaction_with_http_info(transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str transaction_id: Transaction id or hash. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TransactionInfoDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_unconfirmed_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_id` when calling `get_unconfirmed_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in local_var_params:
            path_params['transactionId'] = local_var_params['transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/unconfirmed/{transactionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionInfoDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_unconfirmed_transactions(self, transaction_ids, **kwargs):  # noqa: E501
        """Get unconfirmed trasactions information  # noqa: E501

        Returns unconfirmed transactions information for a given array of transactionIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unconfirmed_transactions(transaction_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionIds transaction_ids: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TransactionInfoDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_unconfirmed_transactions_with_http_info(transaction_ids, **kwargs)  # noqa: E501

    def get_unconfirmed_transactions_with_http_info(self, transaction_ids, **kwargs):  # noqa: E501
        """Get unconfirmed trasactions information  # noqa: E501

        Returns unconfirmed transactions information for a given array of transactionIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unconfirmed_transactions_with_http_info(transaction_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TransactionIds transaction_ids: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TransactionInfoDTO], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'transaction_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_unconfirmed_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transaction_ids' is set
        if self.api_client.client_side_validation and ('transaction_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['transaction_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transaction_ids` when calling `get_unconfirmed_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_ids' in local_var_params:
            body_params = local_var_params['transaction_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/unconfirmed', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TransactionInfoDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_confirmed_transactions(self, **kwargs):  # noqa: E501
        """Search confirmed transactions  # noqa: E501

        Returns an array of confirmed transactions. If a transaction was announced with an alias rather than an address, the address that will be considered when querying is the one that was resolved from the alias at confirmation time.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_confirmed_transactions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str address: Filter by address involved in the transaction.  An account's address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with ``recipientAddress`` and ``signerPublicKey`` query params. 
        :param str recipient_address: Filter by address of the account receiving the transaction.
        :param str signer_public_key: Filter by public key of the account signing the entity.
        :param str height: Filter by block height.
        :param str from_height: Only blocks with height greater or equal than this one are returned.
        :param str to_height: Only blocks with height smaller or equal than this one are returned.
        :param str from_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned. 
        :param str to_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned. 
        :param list[TransactionTypeEnum] type: Filter by transaction type. To filter by multiple transaction types, add more filter query params like: ``type=16974&type=16718``. 
        :param bool embedded: When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned. 
        :param str transfer_mosaic_id: Filters transactions involving a specific ``mosaicId``.
        :param int page_size: Select the number of entries to return.
        :param int page_number: Filter by page number.
        :param str offset: Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned. 
        :param Order order: Sort responses in ascending or descending order based on the collection property set on the param ``orderBy``. If the request does not specify ``orderBy``, REST returns the collection ordered by id. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TransactionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.search_confirmed_transactions_with_http_info(**kwargs)  # noqa: E501

    def search_confirmed_transactions_with_http_info(self, **kwargs):  # noqa: E501
        """Search confirmed transactions  # noqa: E501

        Returns an array of confirmed transactions. If a transaction was announced with an alias rather than an address, the address that will be considered when querying is the one that was resolved from the alias at confirmation time.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_confirmed_transactions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str address: Filter by address involved in the transaction.  An account's address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with ``recipientAddress`` and ``signerPublicKey`` query params. 
        :param str recipient_address: Filter by address of the account receiving the transaction.
        :param str signer_public_key: Filter by public key of the account signing the entity.
        :param str height: Filter by block height.
        :param str from_height: Only blocks with height greater or equal than this one are returned.
        :param str to_height: Only blocks with height smaller or equal than this one are returned.
        :param str from_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned. 
        :param str to_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned. 
        :param list[TransactionTypeEnum] type: Filter by transaction type. To filter by multiple transaction types, add more filter query params like: ``type=16974&type=16718``. 
        :param bool embedded: When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned. 
        :param str transfer_mosaic_id: Filters transactions involving a specific ``mosaicId``.
        :param int page_size: Select the number of entries to return.
        :param int page_number: Filter by page number.
        :param str offset: Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned. 
        :param Order order: Sort responses in ascending or descending order based on the collection property set on the param ``orderBy``. If the request does not specify ``orderBy``, REST returns the collection ordered by id. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TransactionPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'address',
            'recipient_address',
            'signer_public_key',
            'height',
            'from_height',
            'to_height',
            'from_transfer_amount',
            'to_transfer_amount',
            'type',
            'embedded',
            'transfer_mosaic_id',
            'page_size',
            'page_number',
            'offset',
            'order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_confirmed_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'page_size' in local_var_params and local_var_params['page_size'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_size` when calling `search_confirmed_transactions`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_size' in local_var_params and local_var_params['page_size'] < 10:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_size` when calling `search_confirmed_transactions`, must be a value greater than or equal to `10`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_number' in local_var_params and local_var_params['page_number'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_number` when calling `search_confirmed_transactions`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'address' in local_var_params and local_var_params['address'] is not None:  # noqa: E501
            query_params.append(('address', local_var_params['address']))  # noqa: E501
        if 'recipient_address' in local_var_params and local_var_params['recipient_address'] is not None:  # noqa: E501
            query_params.append(('recipientAddress', local_var_params['recipient_address']))  # noqa: E501
        if 'signer_public_key' in local_var_params and local_var_params['signer_public_key'] is not None:  # noqa: E501
            query_params.append(('signerPublicKey', local_var_params['signer_public_key']))  # noqa: E501
        if 'height' in local_var_params and local_var_params['height'] is not None:  # noqa: E501
            query_params.append(('height', local_var_params['height']))  # noqa: E501
        if 'from_height' in local_var_params and local_var_params['from_height'] is not None:  # noqa: E501
            query_params.append(('fromHeight', local_var_params['from_height']))  # noqa: E501
        if 'to_height' in local_var_params and local_var_params['to_height'] is not None:  # noqa: E501
            query_params.append(('toHeight', local_var_params['to_height']))  # noqa: E501
        if 'from_transfer_amount' in local_var_params and local_var_params['from_transfer_amount'] is not None:  # noqa: E501
            query_params.append(('fromTransferAmount', local_var_params['from_transfer_amount']))  # noqa: E501
        if 'to_transfer_amount' in local_var_params and local_var_params['to_transfer_amount'] is not None:  # noqa: E501
            query_params.append(('toTransferAmount', local_var_params['to_transfer_amount']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'embedded' in local_var_params and local_var_params['embedded'] is not None:  # noqa: E501
            query_params.append(('embedded', local_var_params['embedded']))  # noqa: E501
        if 'transfer_mosaic_id' in local_var_params and local_var_params['transfer_mosaic_id'] is not None:  # noqa: E501
            query_params.append(('transferMosaicId', local_var_params['transfer_mosaic_id']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('pageSize', local_var_params['page_size']))  # noqa: E501
        if 'page_number' in local_var_params and local_var_params['page_number'] is not None:  # noqa: E501
            query_params.append(('pageNumber', local_var_params['page_number']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'order' in local_var_params and local_var_params['order'] is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/confirmed', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_partial_transactions(self, **kwargs):  # noqa: E501
        """Search partial transactions  # noqa: E501

        Returns an array of partial transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_partial_transactions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str address: Filter by address involved in the transaction.  An account's address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with ``recipientAddress`` and ``signerPublicKey`` query params. 
        :param str recipient_address: Filter by address of the account receiving the transaction.
        :param str signer_public_key: Filter by public key of the account signing the entity.
        :param str height: Filter by block height.
        :param str from_height: Only blocks with height greater or equal than this one are returned.
        :param str to_height: Only blocks with height smaller or equal than this one are returned.
        :param str from_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned. 
        :param str to_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned. 
        :param list[TransactionTypeEnum] type: Filter by transaction type. To filter by multiple transaction types, add more filter query params like: ``type=16974&type=16718``. 
        :param bool embedded: When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned. 
        :param str transfer_mosaic_id: Filters transactions involving a specific ``mosaicId``.
        :param int page_size: Select the number of entries to return.
        :param int page_number: Filter by page number.
        :param str offset: Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned. 
        :param Order order: Sort responses in ascending or descending order based on the collection property set on the param ``orderBy``. If the request does not specify ``orderBy``, REST returns the collection ordered by id. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TransactionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.search_partial_transactions_with_http_info(**kwargs)  # noqa: E501

    def search_partial_transactions_with_http_info(self, **kwargs):  # noqa: E501
        """Search partial transactions  # noqa: E501

        Returns an array of partial transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_partial_transactions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str address: Filter by address involved in the transaction.  An account's address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with ``recipientAddress`` and ``signerPublicKey`` query params. 
        :param str recipient_address: Filter by address of the account receiving the transaction.
        :param str signer_public_key: Filter by public key of the account signing the entity.
        :param str height: Filter by block height.
        :param str from_height: Only blocks with height greater or equal than this one are returned.
        :param str to_height: Only blocks with height smaller or equal than this one are returned.
        :param str from_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned. 
        :param str to_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned. 
        :param list[TransactionTypeEnum] type: Filter by transaction type. To filter by multiple transaction types, add more filter query params like: ``type=16974&type=16718``. 
        :param bool embedded: When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned. 
        :param str transfer_mosaic_id: Filters transactions involving a specific ``mosaicId``.
        :param int page_size: Select the number of entries to return.
        :param int page_number: Filter by page number.
        :param str offset: Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned. 
        :param Order order: Sort responses in ascending or descending order based on the collection property set on the param ``orderBy``. If the request does not specify ``orderBy``, REST returns the collection ordered by id. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TransactionPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'address',
            'recipient_address',
            'signer_public_key',
            'height',
            'from_height',
            'to_height',
            'from_transfer_amount',
            'to_transfer_amount',
            'type',
            'embedded',
            'transfer_mosaic_id',
            'page_size',
            'page_number',
            'offset',
            'order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_partial_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'page_size' in local_var_params and local_var_params['page_size'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_size` when calling `search_partial_transactions`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_size' in local_var_params and local_var_params['page_size'] < 10:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_size` when calling `search_partial_transactions`, must be a value greater than or equal to `10`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_number' in local_var_params and local_var_params['page_number'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_number` when calling `search_partial_transactions`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'address' in local_var_params and local_var_params['address'] is not None:  # noqa: E501
            query_params.append(('address', local_var_params['address']))  # noqa: E501
        if 'recipient_address' in local_var_params and local_var_params['recipient_address'] is not None:  # noqa: E501
            query_params.append(('recipientAddress', local_var_params['recipient_address']))  # noqa: E501
        if 'signer_public_key' in local_var_params and local_var_params['signer_public_key'] is not None:  # noqa: E501
            query_params.append(('signerPublicKey', local_var_params['signer_public_key']))  # noqa: E501
        if 'height' in local_var_params and local_var_params['height'] is not None:  # noqa: E501
            query_params.append(('height', local_var_params['height']))  # noqa: E501
        if 'from_height' in local_var_params and local_var_params['from_height'] is not None:  # noqa: E501
            query_params.append(('fromHeight', local_var_params['from_height']))  # noqa: E501
        if 'to_height' in local_var_params and local_var_params['to_height'] is not None:  # noqa: E501
            query_params.append(('toHeight', local_var_params['to_height']))  # noqa: E501
        if 'from_transfer_amount' in local_var_params and local_var_params['from_transfer_amount'] is not None:  # noqa: E501
            query_params.append(('fromTransferAmount', local_var_params['from_transfer_amount']))  # noqa: E501
        if 'to_transfer_amount' in local_var_params and local_var_params['to_transfer_amount'] is not None:  # noqa: E501
            query_params.append(('toTransferAmount', local_var_params['to_transfer_amount']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'embedded' in local_var_params and local_var_params['embedded'] is not None:  # noqa: E501
            query_params.append(('embedded', local_var_params['embedded']))  # noqa: E501
        if 'transfer_mosaic_id' in local_var_params and local_var_params['transfer_mosaic_id'] is not None:  # noqa: E501
            query_params.append(('transferMosaicId', local_var_params['transfer_mosaic_id']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('pageSize', local_var_params['page_size']))  # noqa: E501
        if 'page_number' in local_var_params and local_var_params['page_number'] is not None:  # noqa: E501
            query_params.append(('pageNumber', local_var_params['page_number']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'order' in local_var_params and local_var_params['order'] is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/partial', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_unconfirmed_transactions(self, **kwargs):  # noqa: E501
        """Search unconfirmed transactions  # noqa: E501

        Returns an array of unconfirmed transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_unconfirmed_transactions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str address: Filter by address involved in the transaction.  An account's address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with ``recipientAddress`` and ``signerPublicKey`` query params. 
        :param str recipient_address: Filter by address of the account receiving the transaction.
        :param str signer_public_key: Filter by public key of the account signing the entity.
        :param str height: Filter by block height.
        :param str from_height: Only blocks with height greater or equal than this one are returned.
        :param str to_height: Only blocks with height smaller or equal than this one are returned.
        :param str from_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned. 
        :param str to_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned. 
        :param list[TransactionTypeEnum] type: Filter by transaction type. To filter by multiple transaction types, add more filter query params like: ``type=16974&type=16718``. 
        :param bool embedded: When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned. 
        :param str transfer_mosaic_id: Filters transactions involving a specific ``mosaicId``.
        :param int page_size: Select the number of entries to return.
        :param int page_number: Filter by page number.
        :param str offset: Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned. 
        :param Order order: Sort responses in ascending or descending order based on the collection property set on the param ``orderBy``. If the request does not specify ``orderBy``, REST returns the collection ordered by id. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TransactionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.search_unconfirmed_transactions_with_http_info(**kwargs)  # noqa: E501

    def search_unconfirmed_transactions_with_http_info(self, **kwargs):  # noqa: E501
        """Search unconfirmed transactions  # noqa: E501

        Returns an array of unconfirmed transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_unconfirmed_transactions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str address: Filter by address involved in the transaction.  An account's address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with ``recipientAddress`` and ``signerPublicKey`` query params. 
        :param str recipient_address: Filter by address of the account receiving the transaction.
        :param str signer_public_key: Filter by public key of the account signing the entity.
        :param str height: Filter by block height.
        :param str from_height: Only blocks with height greater or equal than this one are returned.
        :param str to_height: Only blocks with height smaller or equal than this one are returned.
        :param str from_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned. 
        :param str to_transfer_amount: Requires providing the `transferMosaicId` filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned. 
        :param list[TransactionTypeEnum] type: Filter by transaction type. To filter by multiple transaction types, add more filter query params like: ``type=16974&type=16718``. 
        :param bool embedded: When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned. 
        :param str transfer_mosaic_id: Filters transactions involving a specific ``mosaicId``.
        :param int page_size: Select the number of entries to return.
        :param int page_number: Filter by page number.
        :param str offset: Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned. 
        :param Order order: Sort responses in ascending or descending order based on the collection property set on the param ``orderBy``. If the request does not specify ``orderBy``, REST returns the collection ordered by id. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TransactionPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'address',
            'recipient_address',
            'signer_public_key',
            'height',
            'from_height',
            'to_height',
            'from_transfer_amount',
            'to_transfer_amount',
            'type',
            'embedded',
            'transfer_mosaic_id',
            'page_size',
            'page_number',
            'offset',
            'order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_unconfirmed_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'page_size' in local_var_params and local_var_params['page_size'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_size` when calling `search_unconfirmed_transactions`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_size' in local_var_params and local_var_params['page_size'] < 10:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_size` when calling `search_unconfirmed_transactions`, must be a value greater than or equal to `10`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_number' in local_var_params and local_var_params['page_number'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_number` when calling `search_unconfirmed_transactions`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'address' in local_var_params and local_var_params['address'] is not None:  # noqa: E501
            query_params.append(('address', local_var_params['address']))  # noqa: E501
        if 'recipient_address' in local_var_params and local_var_params['recipient_address'] is not None:  # noqa: E501
            query_params.append(('recipientAddress', local_var_params['recipient_address']))  # noqa: E501
        if 'signer_public_key' in local_var_params and local_var_params['signer_public_key'] is not None:  # noqa: E501
            query_params.append(('signerPublicKey', local_var_params['signer_public_key']))  # noqa: E501
        if 'height' in local_var_params and local_var_params['height'] is not None:  # noqa: E501
            query_params.append(('height', local_var_params['height']))  # noqa: E501
        if 'from_height' in local_var_params and local_var_params['from_height'] is not None:  # noqa: E501
            query_params.append(('fromHeight', local_var_params['from_height']))  # noqa: E501
        if 'to_height' in local_var_params and local_var_params['to_height'] is not None:  # noqa: E501
            query_params.append(('toHeight', local_var_params['to_height']))  # noqa: E501
        if 'from_transfer_amount' in local_var_params and local_var_params['from_transfer_amount'] is not None:  # noqa: E501
            query_params.append(('fromTransferAmount', local_var_params['from_transfer_amount']))  # noqa: E501
        if 'to_transfer_amount' in local_var_params and local_var_params['to_transfer_amount'] is not None:  # noqa: E501
            query_params.append(('toTransferAmount', local_var_params['to_transfer_amount']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'embedded' in local_var_params and local_var_params['embedded'] is not None:  # noqa: E501
            query_params.append(('embedded', local_var_params['embedded']))  # noqa: E501
        if 'transfer_mosaic_id' in local_var_params and local_var_params['transfer_mosaic_id'] is not None:  # noqa: E501
            query_params.append(('transferMosaicId', local_var_params['transfer_mosaic_id']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('pageSize', local_var_params['page_size']))  # noqa: E501
        if 'page_number' in local_var_params and local_var_params['page_number'] is not None:  # noqa: E501
            query_params.append(('pageNumber', local_var_params['page_number']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'order' in local_var_params and local_var_params['order'] is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/transactions/unconfirmed', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
