# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudmersive_image_api_client.api_client import ApiClient


class EditApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def edit_auto_orient(self, image_file, **kwargs):  # noqa: E501
        """Normalizes image rotation and removes EXIF rotation data  # noqa: E501

        Automatically orients the input image based on EXIF information and then removes the EXIF information.  EXIF is an additional set of information stored in some images taken with cell phone cameras based on the orientation of the camera.  By normalizing rotation and removing EXIF data these images become much easier to process.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_auto_orient(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_auto_orient_with_http_info(image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_auto_orient_with_http_info(image_file, **kwargs)  # noqa: E501
            return data

    def edit_auto_orient_with_http_info(self, image_file, **kwargs):  # noqa: E501
        """Normalizes image rotation and removes EXIF rotation data  # noqa: E501

        Automatically orients the input image based on EXIF information and then removes the EXIF information.  EXIF is an additional set of information stored in some images taken with cell phone cameras based on the orientation of the camera.  By normalizing rotation and removing EXIF data these images become much easier to process.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_auto_orient_with_http_info(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_auto_orient" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_auto_orient`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/auto-orient/remove-exif', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_composite_basic(self, location, base_image, layered_image, **kwargs):  # noqa: E501
        """Composite two images together  # noqa: E501

        Composites two input images together; a layered image onto a base image.  The first image you input is the base image.  The second image (the layered image) will be composited on top of this base image.  Supports PNG transparency.  To control padding you can include transparent pixels at the border(s) of your layered images as appropriate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_composite_basic(location, base_image, layered_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location: Location to composite the layered images; possible values are: \"center\", \"top-left\", \"top-center\", \"top-right\", \"center-left\", \"center-right\", \"bottom-left\", \"bottom-center\", \"bottom-right\" (required)
        :param file base_image: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :param file layered_image: Image to layer on top of the base image. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_composite_basic_with_http_info(location, base_image, layered_image, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_composite_basic_with_http_info(location, base_image, layered_image, **kwargs)  # noqa: E501
            return data

    def edit_composite_basic_with_http_info(self, location, base_image, layered_image, **kwargs):  # noqa: E501
        """Composite two images together  # noqa: E501

        Composites two input images together; a layered image onto a base image.  The first image you input is the base image.  The second image (the layered image) will be composited on top of this base image.  Supports PNG transparency.  To control padding you can include transparent pixels at the border(s) of your layered images as appropriate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_composite_basic_with_http_info(location, base_image, layered_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str location: Location to composite the layered images; possible values are: \"center\", \"top-left\", \"top-center\", \"top-right\", \"center-left\", \"center-right\", \"bottom-left\", \"bottom-center\", \"bottom-right\" (required)
        :param file base_image: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :param file layered_image: Image to layer on top of the base image. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['location', 'base_image', 'layered_image']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_composite_basic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'location' is set
        if ('location' not in params or
                params['location'] is None):
            raise ValueError("Missing the required parameter `location` when calling `edit_composite_basic`")  # noqa: E501
        # verify the required parameter 'base_image' is set
        if ('base_image' not in params or
                params['base_image'] is None):
            raise ValueError("Missing the required parameter `base_image` when calling `edit_composite_basic`")  # noqa: E501
        # verify the required parameter 'layered_image' is set
        if ('layered_image' not in params or
                params['layered_image'] is None):
            raise ValueError("Missing the required parameter `layered_image` when calling `edit_composite_basic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'location' in params:
            path_params['location'] = params['location']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'base_image' in params:
            local_var_files['baseImage'] = params['base_image']  # noqa: E501
        if 'layered_image' in params:
            local_var_files['layeredImage'] = params['layered_image']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/composite/{location}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_contrast_adaptive(self, gamma, image_file, **kwargs):  # noqa: E501
        """Adaptively adjust the contrast of the image to be more appealing and easy to see  # noqa: E501

        Uses Gamma to adjust the contrast adaptively the way the human eye sees the world.  Results significantly improve the viewability and visual appeal of the image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_contrast_adaptive(gamma, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float gamma: Gamma value to adjust the contrast in the image.  Recommended value is 2.0.  Values between 0.0 and 1.0 will reduce contrast, while values above 1.0 will increase contrast. (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_contrast_adaptive_with_http_info(gamma, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_contrast_adaptive_with_http_info(gamma, image_file, **kwargs)  # noqa: E501
            return data

    def edit_contrast_adaptive_with_http_info(self, gamma, image_file, **kwargs):  # noqa: E501
        """Adaptively adjust the contrast of the image to be more appealing and easy to see  # noqa: E501

        Uses Gamma to adjust the contrast adaptively the way the human eye sees the world.  Results significantly improve the viewability and visual appeal of the image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_contrast_adaptive_with_http_info(gamma, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float gamma: Gamma value to adjust the contrast in the image.  Recommended value is 2.0.  Values between 0.0 and 1.0 will reduce contrast, while values above 1.0 will increase contrast. (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gamma', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_contrast_adaptive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gamma' is set
        if ('gamma' not in params or
                params['gamma'] is None):
            raise ValueError("Missing the required parameter `gamma` when calling `edit_contrast_adaptive`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_contrast_adaptive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gamma' in params:
            path_params['gamma'] = params['gamma']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/contrast/{gamma}/adaptive', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_crop_rectangle(self, left, top, width, height, image_file, **kwargs):  # noqa: E501
        """Crop an image to a rectangular area  # noqa: E501

        Crop an image to a target rectangular area  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_crop_rectangle(left, top, width, height, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int left: The left edge of the rectangular crop area in pixels (X). (required)
        :param int top: The top edge of the rectangular crop area in pixels (Y). (required)
        :param int width: The width of the rectangular crop area in pixels. (required)
        :param int height: The height of the rectangular crop area in pixels. (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_crop_rectangle_with_http_info(left, top, width, height, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_crop_rectangle_with_http_info(left, top, width, height, image_file, **kwargs)  # noqa: E501
            return data

    def edit_crop_rectangle_with_http_info(self, left, top, width, height, image_file, **kwargs):  # noqa: E501
        """Crop an image to a rectangular area  # noqa: E501

        Crop an image to a target rectangular area  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_crop_rectangle_with_http_info(left, top, width, height, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int left: The left edge of the rectangular crop area in pixels (X). (required)
        :param int top: The top edge of the rectangular crop area in pixels (Y). (required)
        :param int width: The width of the rectangular crop area in pixels. (required)
        :param int height: The height of the rectangular crop area in pixels. (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['left', 'top', 'width', 'height', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_crop_rectangle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'left' is set
        if ('left' not in params or
                params['left'] is None):
            raise ValueError("Missing the required parameter `left` when calling `edit_crop_rectangle`")  # noqa: E501
        # verify the required parameter 'top' is set
        if ('top' not in params or
                params['top'] is None):
            raise ValueError("Missing the required parameter `top` when calling `edit_crop_rectangle`")  # noqa: E501
        # verify the required parameter 'width' is set
        if ('width' not in params or
                params['width'] is None):
            raise ValueError("Missing the required parameter `width` when calling `edit_crop_rectangle`")  # noqa: E501
        # verify the required parameter 'height' is set
        if ('height' not in params or
                params['height'] is None):
            raise ValueError("Missing the required parameter `height` when calling `edit_crop_rectangle`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_crop_rectangle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'left' in params:
            path_params['left'] = params['left']  # noqa: E501
        if 'top' in params:
            path_params['top'] = params['top']  # noqa: E501
        if 'width' in params:
            path_params['width'] = params['width']  # noqa: E501
        if 'height' in params:
            path_params['height'] = params['height']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/crop/rectangle/{left}/{top}/{width}/{height}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_draw_polygon(self, request, **kwargs):  # noqa: E501
        """Draw a polygon onto an image  # noqa: E501

        Draw one or more polygons, with customized visuals, onto an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_draw_polygon(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrawPolygonRequest request: Polygon drawing request parameters (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_draw_polygon_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_draw_polygon_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def edit_draw_polygon_with_http_info(self, request, **kwargs):  # noqa: E501
        """Draw a polygon onto an image  # noqa: E501

        Draw one or more polygons, with customized visuals, onto an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_draw_polygon_with_http_info(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrawPolygonRequest request: Polygon drawing request parameters (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_draw_polygon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `edit_draw_polygon`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/draw/polygon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_draw_rectangle(self, request, **kwargs):  # noqa: E501
        """Draw a rectangle onto an image  # noqa: E501

        Draw one or more rectangles, with customized visuals, onto an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_draw_rectangle(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrawRectangleRequest request: Draw rectangle parameters (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_draw_rectangle_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_draw_rectangle_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def edit_draw_rectangle_with_http_info(self, request, **kwargs):  # noqa: E501
        """Draw a rectangle onto an image  # noqa: E501

        Draw one or more rectangles, with customized visuals, onto an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_draw_rectangle_with_http_info(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrawRectangleRequest request: Draw rectangle parameters (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_draw_rectangle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `edit_draw_rectangle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/draw/rectangle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_draw_text(self, request, **kwargs):  # noqa: E501
        """Draw text onto an image  # noqa: E501

        Draw one or more pieces of text, with customized visuals, onto an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_draw_text(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrawTextRequest request: Draw text parameters (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_draw_text_with_http_info(request, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_draw_text_with_http_info(request, **kwargs)  # noqa: E501
            return data

    def edit_draw_text_with_http_info(self, request, **kwargs):  # noqa: E501
        """Draw text onto an image  # noqa: E501

        Draw one or more pieces of text, with customized visuals, onto an image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_draw_text_with_http_info(request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrawTextRequest request: Draw text parameters (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_draw_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `edit_draw_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/xml', 'text/xml', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/draw/text', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_drop_shadow(self, x, y, sigma, opacity, image_file, **kwargs):  # noqa: E501
        """Add a customizeable drop shadow to an image  # noqa: E501

        Add a customizeable drop shadow to the image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_drop_shadow(x, y, sigma, opacity, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int x: Horizontal (X) offset of the drop shadow (required)
        :param int y: Vertical (Y) offset of the drop shadow (required)
        :param int sigma: Sigma (blur distance) of the drop shadow (required)
        :param int opacity: Opacity of the drop shadow; 0 is 0% and 100 is 100% (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_drop_shadow_with_http_info(x, y, sigma, opacity, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_drop_shadow_with_http_info(x, y, sigma, opacity, image_file, **kwargs)  # noqa: E501
            return data

    def edit_drop_shadow_with_http_info(self, x, y, sigma, opacity, image_file, **kwargs):  # noqa: E501
        """Add a customizeable drop shadow to an image  # noqa: E501

        Add a customizeable drop shadow to the image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_drop_shadow_with_http_info(x, y, sigma, opacity, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int x: Horizontal (X) offset of the drop shadow (required)
        :param int y: Vertical (Y) offset of the drop shadow (required)
        :param int sigma: Sigma (blur distance) of the drop shadow (required)
        :param int opacity: Opacity of the drop shadow; 0 is 0% and 100 is 100% (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x', 'y', 'sigma', 'opacity', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_drop_shadow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x' is set
        if ('x' not in params or
                params['x'] is None):
            raise ValueError("Missing the required parameter `x` when calling `edit_drop_shadow`")  # noqa: E501
        # verify the required parameter 'y' is set
        if ('y' not in params or
                params['y'] is None):
            raise ValueError("Missing the required parameter `y` when calling `edit_drop_shadow`")  # noqa: E501
        # verify the required parameter 'sigma' is set
        if ('sigma' not in params or
                params['sigma'] is None):
            raise ValueError("Missing the required parameter `sigma` when calling `edit_drop_shadow`")  # noqa: E501
        # verify the required parameter 'opacity' is set
        if ('opacity' not in params or
                params['opacity'] is None):
            raise ValueError("Missing the required parameter `opacity` when calling `edit_drop_shadow`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_drop_shadow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'x' in params:
            path_params['X'] = params['x']  # noqa: E501
        if 'y' in params:
            path_params['Y'] = params['y']  # noqa: E501
        if 'sigma' in params:
            path_params['sigma'] = params['sigma']  # noqa: E501
        if 'opacity' in params:
            path_params['opacity'] = params['opacity']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/drop-shadow/{X}/{Y}/{sigma}/{opacity}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_invert(self, image_file, **kwargs):  # noqa: E501
        """Invert, negate the colors in the image  # noqa: E501

        Inverts (negates) all of the colors in the image.  If the image contains transparency, the transparency will first be removed prior to inverting the image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_invert(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_invert_with_http_info(image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_invert_with_http_info(image_file, **kwargs)  # noqa: E501
            return data

    def edit_invert_with_http_info(self, image_file, **kwargs):  # noqa: E501
        """Invert, negate the colors in the image  # noqa: E501

        Inverts (negates) all of the colors in the image.  If the image contains transparency, the transparency will first be removed prior to inverting the image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_invert_with_http_info(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_invert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_invert`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/invert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_remove_exif_data(self, image_file, **kwargs):  # noqa: E501
        """Remove EXIF data from the image  # noqa: E501

        Removes any EXIF data and profiles .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_remove_exif_data(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_remove_exif_data_with_http_info(image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_remove_exif_data_with_http_info(image_file, **kwargs)  # noqa: E501
            return data

    def edit_remove_exif_data_with_http_info(self, image_file, **kwargs):  # noqa: E501
        """Remove EXIF data from the image  # noqa: E501

        Removes any EXIF data and profiles .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_remove_exif_data_with_http_info(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_remove_exif_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_remove_exif_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/remove-exif', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_remove_transparency(self, image_file, **kwargs):  # noqa: E501
        """Remove transparency from the image  # noqa: E501

        Removes any active transparency in the image.  Effectively renders the image at the same resolution, in the same file format, over a white background, thus removing transparency.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_remove_transparency(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_remove_transparency_with_http_info(image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_remove_transparency_with_http_info(image_file, **kwargs)  # noqa: E501
            return data

    def edit_remove_transparency_with_http_info(self, image_file, **kwargs):  # noqa: E501
        """Remove transparency from the image  # noqa: E501

        Removes any active transparency in the image.  Effectively renders the image at the same resolution, in the same file format, over a white background, thus removing transparency.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_remove_transparency_with_http_info(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_remove_transparency" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_remove_transparency`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/remove-transparency', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_rotate(self, degrees, image_file, **kwargs):  # noqa: E501
        """Rotate an image any number of degrees  # noqa: E501

        Rotates an image by an arbitrary number of degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_rotate(degrees, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float degrees: Degrees to rotate the image; values range from 0.0 to 360.0. (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_rotate_with_http_info(degrees, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_rotate_with_http_info(degrees, image_file, **kwargs)  # noqa: E501
            return data

    def edit_rotate_with_http_info(self, degrees, image_file, **kwargs):  # noqa: E501
        """Rotate an image any number of degrees  # noqa: E501

        Rotates an image by an arbitrary number of degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_rotate_with_http_info(degrees, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float degrees: Degrees to rotate the image; values range from 0.0 to 360.0. (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['degrees', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_rotate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'degrees' is set
        if ('degrees' not in params or
                params['degrees'] is None):
            raise ValueError("Missing the required parameter `degrees` when calling `edit_rotate`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `edit_rotate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'degrees' in params:
            path_params['degrees'] = params['degrees']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/edit/rotate/{degrees}/angle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
