# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudmersive_image_api_client.api_client import ApiClient


class FilterApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def filter_black_and_white(self, image_file, **kwargs):  # noqa: E501
        """Convert image to black-and-white grayscale  # noqa: E501

        Remove color from the image by converting to a grayscale, black-and-white image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_black_and_white(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_black_and_white_with_http_info(image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_black_and_white_with_http_info(image_file, **kwargs)  # noqa: E501
            return data

    def filter_black_and_white_with_http_info(self, image_file, **kwargs):  # noqa: E501
        """Convert image to black-and-white grayscale  # noqa: E501

        Remove color from the image by converting to a grayscale, black-and-white image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_black_and_white_with_http_info(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_black_and_white" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_black_and_white`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/black-and-white', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_despeckle(self, image_file, **kwargs):  # noqa: E501
        """Despeckle to remove point noise from the image  # noqa: E501

        Remove point noise / despeckle the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_despeckle(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_despeckle_with_http_info(image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_despeckle_with_http_info(image_file, **kwargs)  # noqa: E501
            return data

    def filter_despeckle_with_http_info(self, image_file, **kwargs):  # noqa: E501
        """Despeckle to remove point noise from the image  # noqa: E501

        Remove point noise / despeckle the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_despeckle_with_http_info(image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_despeckle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_despeckle`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/despeckle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_edge_detect(self, radius, image_file, **kwargs):  # noqa: E501
        """Detect and highlight edges in an image  # noqa: E501

        Perform an edge detection operation on the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_edge_detect(radius, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the edge detection operation; a larger radius will produce a greater effect (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_edge_detect_with_http_info(radius, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_edge_detect_with_http_info(radius, image_file, **kwargs)  # noqa: E501
            return data

    def filter_edge_detect_with_http_info(self, radius, image_file, **kwargs):  # noqa: E501
        """Detect and highlight edges in an image  # noqa: E501

        Perform an edge detection operation on the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_edge_detect_with_http_info(radius, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the edge detection operation; a larger radius will produce a greater effect (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['radius', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_edge_detect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'radius' is set
        if ('radius' not in params or
                params['radius'] is None):
            raise ValueError("Missing the required parameter `radius` when calling `filter_edge_detect`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_edge_detect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'radius' in params:
            path_params['radius'] = params['radius']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/edge-detect/{radius}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_emboss(self, radius, sigma, image_file, **kwargs):  # noqa: E501
        """Emboss an image  # noqa: E501

        Perform an emboss operation on the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_emboss(radius, sigma, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the emboss operation; a larger radius will produce a greater effect (required)
        :param int sigma: Sigma, or variance, of the emboss operation (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_emboss_with_http_info(radius, sigma, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_emboss_with_http_info(radius, sigma, image_file, **kwargs)  # noqa: E501
            return data

    def filter_emboss_with_http_info(self, radius, sigma, image_file, **kwargs):  # noqa: E501
        """Emboss an image  # noqa: E501

        Perform an emboss operation on the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_emboss_with_http_info(radius, sigma, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the emboss operation; a larger radius will produce a greater effect (required)
        :param int sigma: Sigma, or variance, of the emboss operation (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['radius', 'sigma', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_emboss" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'radius' is set
        if ('radius' not in params or
                params['radius'] is None):
            raise ValueError("Missing the required parameter `radius` when calling `filter_emboss`")  # noqa: E501
        # verify the required parameter 'sigma' is set
        if ('sigma' not in params or
                params['sigma'] is None):
            raise ValueError("Missing the required parameter `sigma` when calling `filter_emboss`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_emboss`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'radius' in params:
            path_params['radius'] = params['radius']  # noqa: E501
        if 'sigma' in params:
            path_params['sigma'] = params['sigma']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/emboss/{radius}/{sigma}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_gaussian_blur(self, radius, sigma, image_file, **kwargs):  # noqa: E501
        """Perform a guassian blur on the input image  # noqa: E501

        Perform a gaussian blur on the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_gaussian_blur(radius, sigma, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the blur operation; a larger radius will produce a greater blur effect (required)
        :param int sigma: Sigma, or variance, of the gaussian blur operation (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_gaussian_blur_with_http_info(radius, sigma, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_gaussian_blur_with_http_info(radius, sigma, image_file, **kwargs)  # noqa: E501
            return data

    def filter_gaussian_blur_with_http_info(self, radius, sigma, image_file, **kwargs):  # noqa: E501
        """Perform a guassian blur on the input image  # noqa: E501

        Perform a gaussian blur on the input image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_gaussian_blur_with_http_info(radius, sigma, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the blur operation; a larger radius will produce a greater blur effect (required)
        :param int sigma: Sigma, or variance, of the gaussian blur operation (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['radius', 'sigma', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_gaussian_blur" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'radius' is set
        if ('radius' not in params or
                params['radius'] is None):
            raise ValueError("Missing the required parameter `radius` when calling `filter_gaussian_blur`")  # noqa: E501
        # verify the required parameter 'sigma' is set
        if ('sigma' not in params or
                params['sigma'] is None):
            raise ValueError("Missing the required parameter `sigma` when calling `filter_gaussian_blur`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_gaussian_blur`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'radius' in params:
            path_params['radius'] = params['radius']  # noqa: E501
        if 'sigma' in params:
            path_params['sigma'] = params['sigma']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/blur/guassian/{radius}/{sigma}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_motion_blur(self, radius, sigma, angle, image_file, **kwargs):  # noqa: E501
        """Perform a motion blur on the input image  # noqa: E501

        Perform a motion blur on the input image at a specific angle  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_motion_blur(radius, sigma, angle, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the blur operation; a larger radius will produce a greater blur effect (required)
        :param int sigma: Sigma, or variance, of the motion blur operation (required)
        :param int angle: Angle of the motion blur in degrees (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_motion_blur_with_http_info(radius, sigma, angle, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_motion_blur_with_http_info(radius, sigma, angle, image_file, **kwargs)  # noqa: E501
            return data

    def filter_motion_blur_with_http_info(self, radius, sigma, angle, image_file, **kwargs):  # noqa: E501
        """Perform a motion blur on the input image  # noqa: E501

        Perform a motion blur on the input image at a specific angle  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_motion_blur_with_http_info(radius, sigma, angle, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int radius: Radius in pixels of the blur operation; a larger radius will produce a greater blur effect (required)
        :param int sigma: Sigma, or variance, of the motion blur operation (required)
        :param int angle: Angle of the motion blur in degrees (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['radius', 'sigma', 'angle', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_motion_blur" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'radius' is set
        if ('radius' not in params or
                params['radius'] is None):
            raise ValueError("Missing the required parameter `radius` when calling `filter_motion_blur`")  # noqa: E501
        # verify the required parameter 'sigma' is set
        if ('sigma' not in params or
                params['sigma'] is None):
            raise ValueError("Missing the required parameter `sigma` when calling `filter_motion_blur`")  # noqa: E501
        # verify the required parameter 'angle' is set
        if ('angle' not in params or
                params['angle'] is None):
            raise ValueError("Missing the required parameter `angle` when calling `filter_motion_blur`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_motion_blur`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'radius' in params:
            path_params['radius'] = params['radius']  # noqa: E501
        if 'sigma' in params:
            path_params['sigma'] = params['sigma']  # noqa: E501
        if 'angle' in params:
            path_params['angle'] = params['angle']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/blur/motion/{radius}/{sigma}/{angle}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_posterize(self, levels, image_file, **kwargs):  # noqa: E501
        """Posterize the image by reducing distinct colors  # noqa: E501

        Reduce the unique number of colors in the image to the specified level  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_posterize(levels, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int levels: Number of unique colors to retain in the output image (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_posterize_with_http_info(levels, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_posterize_with_http_info(levels, image_file, **kwargs)  # noqa: E501
            return data

    def filter_posterize_with_http_info(self, levels, image_file, **kwargs):  # noqa: E501
        """Posterize the image by reducing distinct colors  # noqa: E501

        Reduce the unique number of colors in the image to the specified level  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_posterize_with_http_info(levels, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int levels: Number of unique colors to retain in the output image (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['levels', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_posterize" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'levels' is set
        if ('levels' not in params or
                params['levels'] is None):
            raise ValueError("Missing the required parameter `levels` when calling `filter_posterize`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_posterize`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'levels' in params:
            query_params.append(('levels', params['levels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/posterize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_swirl(self, degrees, image_file, **kwargs):  # noqa: E501
        """Swirl distort the image  # noqa: E501

        Swirl distort the image by the specified number of degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_swirl(degrees, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int degrees: Degrees of swirl (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.filter_swirl_with_http_info(degrees, image_file, **kwargs)  # noqa: E501
        else:
            (data) = self.filter_swirl_with_http_info(degrees, image_file, **kwargs)  # noqa: E501
            return data

    def filter_swirl_with_http_info(self, degrees, image_file, **kwargs):  # noqa: E501
        """Swirl distort the image  # noqa: E501

        Swirl distort the image by the specified number of degrees  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_swirl_with_http_info(degrees, image_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int degrees: Degrees of swirl (required)
        :param file image_file: Image file to perform the operation on.  Common file formats such as PNG, JPEG are supported. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['degrees', 'image_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_swirl" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'degrees' is set
        if ('degrees' not in params or
                params['degrees'] is None):
            raise ValueError("Missing the required parameter `degrees` when calling `filter_swirl`")  # noqa: E501
        # verify the required parameter 'image_file' is set
        if ('image_file' not in params or
                params['image_file'] is None):
            raise ValueError("Missing the required parameter `image_file` when calling `filter_swirl`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'degrees' in params:
            query_params.append(('degrees', params['degrees']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/image/filter/swirl', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
