# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DetectedObject(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'object_class_name': 'str',
        'height': 'int',
        'width': 'int',
        'score': 'float',
        'x': 'int',
        'y': 'int'
    }

    attribute_map = {
        'object_class_name': 'ObjectClassName',
        'height': 'Height',
        'width': 'Width',
        'score': 'Score',
        'x': 'X',
        'y': 'Y'
    }

    def __init__(self, object_class_name=None, height=None, width=None, score=None, x=None, y=None):  # noqa: E501
        """DetectedObject - a model defined in Swagger"""  # noqa: E501

        self._object_class_name = None
        self._height = None
        self._width = None
        self._score = None
        self._x = None
        self._y = None
        self.discriminator = None

        if object_class_name is not None:
            self.object_class_name = object_class_name
        if height is not None:
            self.height = height
        if width is not None:
            self.width = width
        if score is not None:
            self.score = score
        if x is not None:
            self.x = x
        if y is not None:
            self.y = y

    @property
    def object_class_name(self):
        """Gets the object_class_name of this DetectedObject.  # noqa: E501

        Class of the object.  Example values are \"person\", \"car\", \"dining table\", etc.  # noqa: E501

        :return: The object_class_name of this DetectedObject.  # noqa: E501
        :rtype: str
        """
        return self._object_class_name

    @object_class_name.setter
    def object_class_name(self, object_class_name):
        """Sets the object_class_name of this DetectedObject.

        Class of the object.  Example values are \"person\", \"car\", \"dining table\", etc.  # noqa: E501

        :param object_class_name: The object_class_name of this DetectedObject.  # noqa: E501
        :type: str
        """

        self._object_class_name = object_class_name

    @property
    def height(self):
        """Gets the height of this DetectedObject.  # noqa: E501

        Height, in pixels, of the object  # noqa: E501

        :return: The height of this DetectedObject.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this DetectedObject.

        Height, in pixels, of the object  # noqa: E501

        :param height: The height of this DetectedObject.  # noqa: E501
        :type: int
        """

        self._height = height

    @property
    def width(self):
        """Gets the width of this DetectedObject.  # noqa: E501

        Width, in pixels, of the object  # noqa: E501

        :return: The width of this DetectedObject.  # noqa: E501
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this DetectedObject.

        Width, in pixels, of the object  # noqa: E501

        :param width: The width of this DetectedObject.  # noqa: E501
        :type: int
        """

        self._width = width

    @property
    def score(self):
        """Gets the score of this DetectedObject.  # noqa: E501

        Confidence score of detected object; possible values are between 0.0 and 1.0; values closer to 1.0 are higher confidence  # noqa: E501

        :return: The score of this DetectedObject.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this DetectedObject.

        Confidence score of detected object; possible values are between 0.0 and 1.0; values closer to 1.0 are higher confidence  # noqa: E501

        :param score: The score of this DetectedObject.  # noqa: E501
        :type: float
        """

        self._score = score

    @property
    def x(self):
        """Gets the x of this DetectedObject.  # noqa: E501

        X location, in pixels, of the left side location of the object, with the right side being X + Width  # noqa: E501

        :return: The x of this DetectedObject.  # noqa: E501
        :rtype: int
        """
        return self._x

    @x.setter
    def x(self, x):
        """Sets the x of this DetectedObject.

        X location, in pixels, of the left side location of the object, with the right side being X + Width  # noqa: E501

        :param x: The x of this DetectedObject.  # noqa: E501
        :type: int
        """

        self._x = x

    @property
    def y(self):
        """Gets the y of this DetectedObject.  # noqa: E501

        Y location, in pixels, of the top side location of the object, with the bottom side being Y + Height  # noqa: E501

        :return: The y of this DetectedObject.  # noqa: E501
        :rtype: int
        """
        return self._y

    @y.setter
    def y(self, y):
        """Sets the y of this DetectedObject.

        Y location, in pixels, of the top side location of the object, with the bottom side being Y + Height  # noqa: E501

        :param y: The y of this DetectedObject.  # noqa: E501
        :type: int
        """

        self._y = y

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DetectedObject, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DetectedObject):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
