# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DrawPolygonRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'base_image_bytes': 'str',
        'base_image_url': 'str',
        'polygons_to_draw': 'list[DrawPolygonInstance]'
    }

    attribute_map = {
        'base_image_bytes': 'BaseImageBytes',
        'base_image_url': 'BaseImageUrl',
        'polygons_to_draw': 'PolygonsToDraw'
    }

    def __init__(self, base_image_bytes=None, base_image_url=None, polygons_to_draw=None):  # noqa: E501
        """DrawPolygonRequest - a model defined in Swagger"""  # noqa: E501

        self._base_image_bytes = None
        self._base_image_url = None
        self._polygons_to_draw = None
        self.discriminator = None

        if base_image_bytes is not None:
            self.base_image_bytes = base_image_bytes
        if base_image_url is not None:
            self.base_image_url = base_image_url
        if polygons_to_draw is not None:
            self.polygons_to_draw = polygons_to_draw

    @property
    def base_image_bytes(self):
        """Gets the base_image_bytes of this DrawPolygonRequest.  # noqa: E501

        Image to draw polygons on, in bytes.  You can also use the BaseImageUrl instead to supply image input as a URL  # noqa: E501

        :return: The base_image_bytes of this DrawPolygonRequest.  # noqa: E501
        :rtype: str
        """
        return self._base_image_bytes

    @base_image_bytes.setter
    def base_image_bytes(self, base_image_bytes):
        """Sets the base_image_bytes of this DrawPolygonRequest.

        Image to draw polygons on, in bytes.  You can also use the BaseImageUrl instead to supply image input as a URL  # noqa: E501

        :param base_image_bytes: The base_image_bytes of this DrawPolygonRequest.  # noqa: E501
        :type: str
        """
        if base_image_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', base_image_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `base_image_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._base_image_bytes = base_image_bytes

    @property
    def base_image_url(self):
        """Gets the base_image_url of this DrawPolygonRequest.  # noqa: E501

        Image to draw polygons on, as an HTTP or HTTPS fully-qualified URL  # noqa: E501

        :return: The base_image_url of this DrawPolygonRequest.  # noqa: E501
        :rtype: str
        """
        return self._base_image_url

    @base_image_url.setter
    def base_image_url(self, base_image_url):
        """Sets the base_image_url of this DrawPolygonRequest.

        Image to draw polygons on, as an HTTP or HTTPS fully-qualified URL  # noqa: E501

        :param base_image_url: The base_image_url of this DrawPolygonRequest.  # noqa: E501
        :type: str
        """

        self._base_image_url = base_image_url

    @property
    def polygons_to_draw(self):
        """Gets the polygons_to_draw of this DrawPolygonRequest.  # noqa: E501

        Polygons to draw on the image.  Polygons are drawn in index order.  # noqa: E501

        :return: The polygons_to_draw of this DrawPolygonRequest.  # noqa: E501
        :rtype: list[DrawPolygonInstance]
        """
        return self._polygons_to_draw

    @polygons_to_draw.setter
    def polygons_to_draw(self, polygons_to_draw):
        """Sets the polygons_to_draw of this DrawPolygonRequest.

        Polygons to draw on the image.  Polygons are drawn in index order.  # noqa: E501

        :param polygons_to_draw: The polygons_to_draw of this DrawPolygonRequest.  # noqa: E501
        :type: list[DrawPolygonInstance]
        """

        self._polygons_to_draw = polygons_to_draw

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DrawPolygonRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DrawPolygonRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
