# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ImageDescriptionResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'successful': 'bool',
        'highconfidence': 'bool',
        'best_outcome': 'RecognitionOutcome',
        'runner_up_outcome': 'RecognitionOutcome'
    }

    attribute_map = {
        'successful': 'Successful',
        'highconfidence': 'Highconfidence',
        'best_outcome': 'BestOutcome',
        'runner_up_outcome': 'RunnerUpOutcome'
    }

    def __init__(self, successful=None, highconfidence=None, best_outcome=None, runner_up_outcome=None):  # noqa: E501
        """ImageDescriptionResponse - a model defined in Swagger"""  # noqa: E501

        self._successful = None
        self._highconfidence = None
        self._best_outcome = None
        self._runner_up_outcome = None
        self.discriminator = None

        if successful is not None:
            self.successful = successful
        if highconfidence is not None:
            self.highconfidence = highconfidence
        if best_outcome is not None:
            self.best_outcome = best_outcome
        if runner_up_outcome is not None:
            self.runner_up_outcome = runner_up_outcome

    @property
    def successful(self):
        """Gets the successful of this ImageDescriptionResponse.  # noqa: E501

        Was the image processed successfully?  # noqa: E501

        :return: The successful of this ImageDescriptionResponse.  # noqa: E501
        :rtype: bool
        """
        return self._successful

    @successful.setter
    def successful(self, successful):
        """Sets the successful of this ImageDescriptionResponse.

        Was the image processed successfully?  # noqa: E501

        :param successful: The successful of this ImageDescriptionResponse.  # noqa: E501
        :type: bool
        """

        self._successful = successful

    @property
    def highconfidence(self):
        """Gets the highconfidence of this ImageDescriptionResponse.  # noqa: E501

        Is the resulting best outcome recognition a high confidence outcome?  # noqa: E501

        :return: The highconfidence of this ImageDescriptionResponse.  # noqa: E501
        :rtype: bool
        """
        return self._highconfidence

    @highconfidence.setter
    def highconfidence(self, highconfidence):
        """Sets the highconfidence of this ImageDescriptionResponse.

        Is the resulting best outcome recognition a high confidence outcome?  # noqa: E501

        :param highconfidence: The highconfidence of this ImageDescriptionResponse.  # noqa: E501
        :type: bool
        """

        self._highconfidence = highconfidence

    @property
    def best_outcome(self):
        """Gets the best_outcome of this ImageDescriptionResponse.  # noqa: E501

        The best Machine Learning outcome  # noqa: E501

        :return: The best_outcome of this ImageDescriptionResponse.  # noqa: E501
        :rtype: RecognitionOutcome
        """
        return self._best_outcome

    @best_outcome.setter
    def best_outcome(self, best_outcome):
        """Sets the best_outcome of this ImageDescriptionResponse.

        The best Machine Learning outcome  # noqa: E501

        :param best_outcome: The best_outcome of this ImageDescriptionResponse.  # noqa: E501
        :type: RecognitionOutcome
        """

        self._best_outcome = best_outcome

    @property
    def runner_up_outcome(self):
        """Gets the runner_up_outcome of this ImageDescriptionResponse.  # noqa: E501

        Best backup (\"runner up\") Machine Learning outcome  # noqa: E501

        :return: The runner_up_outcome of this ImageDescriptionResponse.  # noqa: E501
        :rtype: RecognitionOutcome
        """
        return self._runner_up_outcome

    @runner_up_outcome.setter
    def runner_up_outcome(self, runner_up_outcome):
        """Sets the runner_up_outcome of this ImageDescriptionResponse.

        Best backup (\"runner up\") Machine Learning outcome  # noqa: E501

        :param runner_up_outcome: The runner_up_outcome of this ImageDescriptionResponse.  # noqa: E501
        :type: RecognitionOutcome
        """

        self._runner_up_outcome = runner_up_outcome

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ImageDescriptionResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImageDescriptionResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
