# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ImageMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'successful': 'bool',
        'is_valid_image': 'bool',
        'file_format': 'str',
        'width': 'int',
        'height': 'int',
        'bit_depth': 'int',
        'has_transparency': 'bool',
        'color_space': 'str',
        'exif_profile_name': 'str',
        'exif_values': 'list[ImageMetadataExifValue]'
    }

    attribute_map = {
        'successful': 'Successful',
        'is_valid_image': 'IsValidImage',
        'file_format': 'FileFormat',
        'width': 'Width',
        'height': 'Height',
        'bit_depth': 'BitDepth',
        'has_transparency': 'HasTransparency',
        'color_space': 'ColorSpace',
        'exif_profile_name': 'ExifProfileName',
        'exif_values': 'ExifValues'
    }

    def __init__(self, successful=None, is_valid_image=None, file_format=None, width=None, height=None, bit_depth=None, has_transparency=None, color_space=None, exif_profile_name=None, exif_values=None):  # noqa: E501
        """ImageMetadata - a model defined in Swagger"""  # noqa: E501

        self._successful = None
        self._is_valid_image = None
        self._file_format = None
        self._width = None
        self._height = None
        self._bit_depth = None
        self._has_transparency = None
        self._color_space = None
        self._exif_profile_name = None
        self._exif_values = None
        self.discriminator = None

        if successful is not None:
            self.successful = successful
        if is_valid_image is not None:
            self.is_valid_image = is_valid_image
        if file_format is not None:
            self.file_format = file_format
        if width is not None:
            self.width = width
        if height is not None:
            self.height = height
        if bit_depth is not None:
            self.bit_depth = bit_depth
        if has_transparency is not None:
            self.has_transparency = has_transparency
        if color_space is not None:
            self.color_space = color_space
        if exif_profile_name is not None:
            self.exif_profile_name = exif_profile_name
        if exif_values is not None:
            self.exif_values = exif_values

    @property
    def successful(self):
        """Gets the successful of this ImageMetadata.  # noqa: E501

        True if the operation was successful, false otherwise  # noqa: E501

        :return: The successful of this ImageMetadata.  # noqa: E501
        :rtype: bool
        """
        return self._successful

    @successful.setter
    def successful(self, successful):
        """Sets the successful of this ImageMetadata.

        True if the operation was successful, false otherwise  # noqa: E501

        :param successful: The successful of this ImageMetadata.  # noqa: E501
        :type: bool
        """

        self._successful = successful

    @property
    def is_valid_image(self):
        """Gets the is_valid_image of this ImageMetadata.  # noqa: E501

        True if the input image is a valid image file, false otherwise  # noqa: E501

        :return: The is_valid_image of this ImageMetadata.  # noqa: E501
        :rtype: bool
        """
        return self._is_valid_image

    @is_valid_image.setter
    def is_valid_image(self, is_valid_image):
        """Sets the is_valid_image of this ImageMetadata.

        True if the input image is a valid image file, false otherwise  # noqa: E501

        :param is_valid_image: The is_valid_image of this ImageMetadata.  # noqa: E501
        :type: bool
        """

        self._is_valid_image = is_valid_image

    @property
    def file_format(self):
        """Gets the file_format of this ImageMetadata.  # noqa: E501

        File format of the image  # noqa: E501

        :return: The file_format of this ImageMetadata.  # noqa: E501
        :rtype: str
        """
        return self._file_format

    @file_format.setter
    def file_format(self, file_format):
        """Sets the file_format of this ImageMetadata.

        File format of the image  # noqa: E501

        :param file_format: The file_format of this ImageMetadata.  # noqa: E501
        :type: str
        """

        self._file_format = file_format

    @property
    def width(self):
        """Gets the width of this ImageMetadata.  # noqa: E501

        Width of the image in pixels  # noqa: E501

        :return: The width of this ImageMetadata.  # noqa: E501
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this ImageMetadata.

        Width of the image in pixels  # noqa: E501

        :param width: The width of this ImageMetadata.  # noqa: E501
        :type: int
        """

        self._width = width

    @property
    def height(self):
        """Gets the height of this ImageMetadata.  # noqa: E501

        Height of the image in pixels  # noqa: E501

        :return: The height of this ImageMetadata.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this ImageMetadata.

        Height of the image in pixels  # noqa: E501

        :param height: The height of this ImageMetadata.  # noqa: E501
        :type: int
        """

        self._height = height

    @property
    def bit_depth(self):
        """Gets the bit_depth of this ImageMetadata.  # noqa: E501

        Bits per pixel  # noqa: E501

        :return: The bit_depth of this ImageMetadata.  # noqa: E501
        :rtype: int
        """
        return self._bit_depth

    @bit_depth.setter
    def bit_depth(self, bit_depth):
        """Sets the bit_depth of this ImageMetadata.

        Bits per pixel  # noqa: E501

        :param bit_depth: The bit_depth of this ImageMetadata.  # noqa: E501
        :type: int
        """

        self._bit_depth = bit_depth

    @property
    def has_transparency(self):
        """Gets the has_transparency of this ImageMetadata.  # noqa: E501

        True if the image has transaprency in the form of an alpha channel, false otherwise  # noqa: E501

        :return: The has_transparency of this ImageMetadata.  # noqa: E501
        :rtype: bool
        """
        return self._has_transparency

    @has_transparency.setter
    def has_transparency(self, has_transparency):
        """Sets the has_transparency of this ImageMetadata.

        True if the image has transaprency in the form of an alpha channel, false otherwise  # noqa: E501

        :param has_transparency: The has_transparency of this ImageMetadata.  # noqa: E501
        :type: bool
        """

        self._has_transparency = has_transparency

    @property
    def color_space(self):
        """Gets the color_space of this ImageMetadata.  # noqa: E501

        Color space of the image  # noqa: E501

        :return: The color_space of this ImageMetadata.  # noqa: E501
        :rtype: str
        """
        return self._color_space

    @color_space.setter
    def color_space(self, color_space):
        """Sets the color_space of this ImageMetadata.

        Color space of the image  # noqa: E501

        :param color_space: The color_space of this ImageMetadata.  # noqa: E501
        :type: str
        """

        self._color_space = color_space

    @property
    def exif_profile_name(self):
        """Gets the exif_profile_name of this ImageMetadata.  # noqa: E501

        Name of the EXIF profile used  # noqa: E501

        :return: The exif_profile_name of this ImageMetadata.  # noqa: E501
        :rtype: str
        """
        return self._exif_profile_name

    @exif_profile_name.setter
    def exif_profile_name(self, exif_profile_name):
        """Sets the exif_profile_name of this ImageMetadata.

        Name of the EXIF profile used  # noqa: E501

        :param exif_profile_name: The exif_profile_name of this ImageMetadata.  # noqa: E501
        :type: str
        """

        self._exif_profile_name = exif_profile_name

    @property
    def exif_values(self):
        """Gets the exif_values of this ImageMetadata.  # noqa: E501

        EXIF tags and values embedded in the image  # noqa: E501

        :return: The exif_values of this ImageMetadata.  # noqa: E501
        :rtype: list[ImageMetadataExifValue]
        """
        return self._exif_values

    @exif_values.setter
    def exif_values(self, exif_values):
        """Sets the exif_values of this ImageMetadata.

        EXIF tags and values embedded in the image  # noqa: E501

        :param exif_values: The exif_values of this ImageMetadata.  # noqa: E501
        :type: list[ImageMetadataExifValue]
        """

        self._exif_values = exif_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ImageMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImageMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
