# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class NsfwResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'successful': 'bool',
        'score': 'float',
        'classification_outcome': 'str'
    }

    attribute_map = {
        'successful': 'Successful',
        'score': 'Score',
        'classification_outcome': 'ClassificationOutcome'
    }

    def __init__(self, successful=None, score=None, classification_outcome=None):  # noqa: E501
        """NsfwResult - a model defined in Swagger"""  # noqa: E501

        self._successful = None
        self._score = None
        self._classification_outcome = None
        self.discriminator = None

        if successful is not None:
            self.successful = successful
        if score is not None:
            self.score = score
        if classification_outcome is not None:
            self.classification_outcome = classification_outcome

    @property
    def successful(self):
        """Gets the successful of this NsfwResult.  # noqa: E501

        True if the classification was successfully run, false otherwise  # noqa: E501

        :return: The successful of this NsfwResult.  # noqa: E501
        :rtype: bool
        """
        return self._successful

    @successful.setter
    def successful(self, successful):
        """Sets the successful of this NsfwResult.

        True if the classification was successfully run, false otherwise  # noqa: E501

        :param successful: The successful of this NsfwResult.  # noqa: E501
        :type: bool
        """

        self._successful = successful

    @property
    def score(self):
        """Gets the score of this NsfwResult.  # noqa: E501

        Score between 0.0 and 1.0.  Scores of 0.0-0.2 represent high probability safe content, while scores 0.8-1.0 represent high probability unsafe content.  Content between 0.2 and 0.8 is of increasing raciness.  # noqa: E501

        :return: The score of this NsfwResult.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this NsfwResult.

        Score between 0.0 and 1.0.  Scores of 0.0-0.2 represent high probability safe content, while scores 0.8-1.0 represent high probability unsafe content.  Content between 0.2 and 0.8 is of increasing raciness.  # noqa: E501

        :param score: The score of this NsfwResult.  # noqa: E501
        :type: float
        """

        self._score = score

    @property
    def classification_outcome(self):
        """Gets the classification_outcome of this NsfwResult.  # noqa: E501

        Classification result into four categories: SafeContent_HighProbability, UnsafeContent_HighProbability, RacyContent, SafeContent_ModerateProbability  # noqa: E501

        :return: The classification_outcome of this NsfwResult.  # noqa: E501
        :rtype: str
        """
        return self._classification_outcome

    @classification_outcome.setter
    def classification_outcome(self, classification_outcome):
        """Sets the classification_outcome of this NsfwResult.

        Classification result into four categories: SafeContent_HighProbability, UnsafeContent_HighProbability, RacyContent, SafeContent_ModerateProbability  # noqa: E501

        :param classification_outcome: The classification_outcome of this NsfwResult.  # noqa: E501
        :type: str
        """

        self._classification_outcome = classification_outcome

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NsfwResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NsfwResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
