# coding: utf-8

"""
    imageapi

    Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ObjectDetectionResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'successful': 'bool',
        'objects': 'list[DetectedObject]',
        'object_count': 'int'
    }

    attribute_map = {
        'successful': 'Successful',
        'objects': 'Objects',
        'object_count': 'ObjectCount'
    }

    def __init__(self, successful=None, objects=None, object_count=None):  # noqa: E501
        """ObjectDetectionResult - a model defined in Swagger"""  # noqa: E501

        self._successful = None
        self._objects = None
        self._object_count = None
        self.discriminator = None

        if successful is not None:
            self.successful = successful
        if objects is not None:
            self.objects = objects
        if object_count is not None:
            self.object_count = object_count

    @property
    def successful(self):
        """Gets the successful of this ObjectDetectionResult.  # noqa: E501

        Was the image processed successfully?  # noqa: E501

        :return: The successful of this ObjectDetectionResult.  # noqa: E501
        :rtype: bool
        """
        return self._successful

    @successful.setter
    def successful(self, successful):
        """Sets the successful of this ObjectDetectionResult.

        Was the image processed successfully?  # noqa: E501

        :param successful: The successful of this ObjectDetectionResult.  # noqa: E501
        :type: bool
        """

        self._successful = successful

    @property
    def objects(self):
        """Gets the objects of this ObjectDetectionResult.  # noqa: E501

        Array of objects detected in the scene  # noqa: E501

        :return: The objects of this ObjectDetectionResult.  # noqa: E501
        :rtype: list[DetectedObject]
        """
        return self._objects

    @objects.setter
    def objects(self, objects):
        """Sets the objects of this ObjectDetectionResult.

        Array of objects detected in the scene  # noqa: E501

        :param objects: The objects of this ObjectDetectionResult.  # noqa: E501
        :type: list[DetectedObject]
        """

        self._objects = objects

    @property
    def object_count(self):
        """Gets the object_count of this ObjectDetectionResult.  # noqa: E501

        Number of objects detected in the scene  # noqa: E501

        :return: The object_count of this ObjectDetectionResult.  # noqa: E501
        :rtype: int
        """
        return self._object_count

    @object_count.setter
    def object_count(self, object_count):
        """Sets the object_count of this ObjectDetectionResult.

        Number of objects detected in the scene  # noqa: E501

        :param object_count: The object_count of this ObjectDetectionResult.  # noqa: E501
        :type: int
        """

        self._object_count = object_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ObjectDetectionResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ObjectDetectionResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
