# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['grafana_pandas_datasource']

package_data = \
{'': ['*']}

install_requires = \
['flask-cors>=3.0.10,<4.0.0', 'flask>=1.1.4,<2.0.0', 'pandas>=1.3,<2.0']

setup_kwargs = {
    'name': 'grafana-pandas-datasource',
    'version': '0.2.0',
    'description': 'Serve NumPy data via pandas data frames to Grafana',
    'long_description': '.. image:: https://github.com/panodata/grafana-pandas-datasource/workflows/Tests/badge.svg\n    :target: https://github.com/panodata/grafana-pandas-datasource/actions?workflow=Tests\n\n.. image:: https://img.shields.io/pypi/pyversions/grafana-pandas-datasource.svg\n    :target: https://pypi.org/project/grafana-pandas-datasource/\n\n.. image:: https://img.shields.io/pypi/status/grafana-pandas-datasource.svg\n    :target: https://pypi.org/project/grafana-pandas-datasource/\n\n.. image:: https://img.shields.io/pypi/v/grafana-pandas-datasource.svg\n    :target: https://pypi.org/project/grafana-pandas-datasource/\n\n.. image:: https://img.shields.io/pypi/dm/grafana-pandas-datasource.svg\n    :target: https://pypi.org/project/grafana-pandas-datasource/\n\n.. image:: https://img.shields.io/pypi/l/grafana-pandas-datasource.svg\n    :target: https://github.com/panodata/grafana-pandas-datasource/blob/main/LICENSE\n\n.. image:: https://img.shields.io/badge/Grafana-6.x%20--%208.x-blue.svg\n    :target: https://github.com/grafana/grafana\n    :alt: Supported Grafana versions\n\n|\n\n#########################\nGrafana pandas datasource\n#########################\n\n\n*****\nAbout\n*****\n\nA HTTP API based on Flask_ for serving pandas_ data frames to Grafana_,\ngenerated by NumPy_. The `Grafana Simple JSON Datasource`_ is used to interface\nGrafana with the HTTP API.\n\nThis way, a native Python application can be used to directly supply data to\nGrafana easily and powerfully.\n\nThe framework supports feeding both timeseries data as well as annotations\nthrough corresponding ``/query`` and ``/annotations`` endpoints and also\nprovides ``/search`` and ``/panels`` endpoints.\n\n\n*******************\nSandbox environment\n*******************\n\nIn order to work efficiently with the resources provided by this repository, we\nrecommend to install some programs upfront. This will optimally work on Linux\nand macOS. Windows users might use the WSL subsystem.\n\nInstall prerequisites::\n\n    # Debian Linux\n    apt install git python3 python3-pip httpie docker.io\n    pip install poetry\n\n    # macOS / Homebrew\n    brew install git python3 poetry httpie docker\n\nAcquire sources and bootstrap sandbox environment::\n\n    git clone https://github.com/panodata/grafana-pandas-datasource\n    cd grafana-pandas-datasource\n    poetry install\n    poetry shell\n\nTest drive::\n\n    # Run Grafana pandas datasource demo.\n    python examples/sinewave-midnights/demo.py\n\n    # Submit a timeseries data request.\n    echo \'{"targets": [{"target": "sine_wave:24"}], "range": {"from": "2022-02-22T15", "to": "2022-02-22T20"}}\' | http http://127.0.0.1:3003/query\n\n    # Submit an annotation data request.\n    echo \'{"annotation": {"query": "midnights:xx"}, "range": {"from": "2022-02-20", "to": "2022-02-22"}}\' | http http://127.0.0.1:3003/annotations\n\nWhen the environment has been properly configured, both requests above will\nyield appropriate responses.\n\n\n********\nExamples\n********\n\nThere are `different demo programs`_ accompanied with Grafana datasource and\ndashboard definition files. \n\nAfter confirming the sandbox environment has been installed successfully,\nplease head over to the `Sinewave/Midnights example`_ page in order to learn\nhow to provision Grafana with corresponding resources.\n\n\n*****\nSetup\n*****\n\nWhen aiming to run a dedicated service, without needing to invoke the examples,\nyou can add the package ``grafana-pandas-datasource`` to the list of your\nproject requirements.\n\n::\n\n    pip install grafana-pandas-datasource\n\n\n*******\nCredits\n*******\n\nKudos to Linar, who conceived the initial version of this software the other\nday at https://gist.github.com/linar-jether/95ff412f9d19fdf5e51293eb0c09b850.\n\n\n.. _different demo programs: https://github.com/panodata/grafana-pandas-datasource/tree/main/examples\n.. _Flask: https://github.com/pallets/flask\n.. _Grafana: https://github.com/grafana/grafana\n.. _Grafana Simple JSON Datasource: https://grafana.com/grafana/plugins/grafana-simple-json-datasource/\n.. _NumPy: https://numpy.org/\n.. _pandas: https://github.com/pandas-dev/pandas\n.. _Sinewave/Midnights example: https://github.com/panodata/grafana-pandas-datasource/tree/main/examples/sinewave-midnights\n',
    'author': 'Andreas Motl',
    'author_email': 'andreas.motl@panodata.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://community.panodata.org/t/grafana-python-datasource-using-pandas-for-timeseries-and-table-data/148',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
