import { ICommandPalette } from '@jupyterlab/apputils';
import { IFileBrowserFactory } from '@jupyterlab/filebrowser';
import { ILauncher } from '@jupyterlab/launcher';
import { IMainMenu } from '@jupyterlab/mainmenu';
import { CommandRegistry } from '@phosphor/commands';
import { IProjectManager, Templates } from './tokens';
/**
 * Activate the file menu entries to generate new CoSApp files.
 *
 * Note: this is actually called at the end of the activation function for the project plugin
 *
 * @param commands Application commands registry
 * @param browserFactory File browser factory
 * @param manager Project manager
 * @param fileSettings File template parameters
 * @param palette Commands palette
 * @param menu Application menu
 * @param launcher Application launcher
 */
export declare function activateFileGenerator(commands: CommandRegistry, browserFactory: IFileBrowserFactory, fileSettings: Templates.IFile[], manager: IProjectManager | null, palette: ICommandPalette, launcher: ILauncher | null, menu: IMainMenu | null): void;
