import { Token } from '@phosphor/coreutils';
/**
 * Plugin ID
 */
export const PLUGIN_ID = 'jupyter-project';
/**
 * Project Manager Plugin Token
 */
export const IProjectManager = new Token(`${PLUGIN_ID}:IProjectManager`);
/**
 * Command IDs
 */
export var CommandIDs;
(function (CommandIDs) {
    /**
     * Close current project command
     */
    CommandIDs.closeProject = 'jupyter-project:project-close';
    /**
     * Delete current project command
     */
    CommandIDs.deleteProject = 'jupyter-project:project-delete';
    /**
     * Create new project command
     */
    CommandIDs.newProject = 'jupyter-project:project-create';
    /**
     * Open project command
     */
    CommandIDs.openProject = 'jupyter-project:project-open';
    /**
     * Create new file from template command
     */
    CommandIDs.newTemplateFile = 'jupyter-project:file-template';
})(CommandIDs || (CommandIDs = {}));
//# sourceMappingURL=tokens.js.map