import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import { IResource } from '@aws-cdk/core';
/**
 * (experimental) Represents a API Gateway HTTP/WebSocket API.
 *
 * @experimental
 */
export interface IApi extends IResource {
    /**
     * (experimental) The identifier of this API Gateway API.
     *
     * @experimental
     * @attribute true
     */
    readonly apiId: string;
    /**
     * (experimental) The default endpoint for an API.
     *
     * @experimental
     * @attribute true
     */
    readonly apiEndpoint: string;
    /**
     * (experimental) Return the given named metric for this Api Gateway.
     *
     * @default - average over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
