import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IBucket } from '@aws-cdk/aws-s3';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 *
 * @experimental
 */
export declare enum SecurityPolicy {
    /**
     * (experimental) Cipher suite TLS 1.0.
     *
     * @experimental
     */
    TLS_1_0 = "TLS_1_0",
    /**
     * (experimental) Cipher suite TLS 1.2.
     *
     * @experimental
     */
    TLS_1_2 = "TLS_1_2"
}
/**
 * (experimental) Endpoint type for a domain name.
 *
 * @experimental
 */
export declare enum EndpointType {
    /**
     * (experimental) For an edge-optimized custom domain name.
     *
     * @experimental
     */
    EDGE = "EDGE",
    /**
     * (experimental) For a regional custom domain name.
     *
     * @experimental
     */
    REGIONAL = "REGIONAL"
}
/**
 * (experimental) Represents an APIGatewayV2 DomainName.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @experimental
 */
export interface IDomainName extends IResource {
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     * @attribute true
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     * @attribute true
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     * @attribute true
     */
    readonly regionalHostedZoneId: string;
}
/**
 * (experimental) custom domain name attributes.
 *
 * @experimental
 */
export interface DomainNameAttributes {
    /**
     * (experimental) domain name string.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     */
    readonly regionalHostedZoneId: string;
}
/**
 * (experimental) properties used for creating the DomainName.
 *
 * @experimental
 */
export interface DomainNameProps extends EndpointOptions {
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The mutual TLS authentication configuration for a custom domain name.
     *
     * @default - mTLS is not configured.
     * @experimental
     */
    readonly mtls?: MTLSConfig;
}
/**
 * (experimental) properties for creating a domain name endpoint.
 *
 * @experimental
 */
export interface EndpointOptions {
    /**
     * (experimental) The ACM certificate for this domain name.
     *
     * Certificate can be both ACM issued or imported.
     *
     * @experimental
     */
    readonly certificate: ICertificate;
    /**
     * (experimental) The user-friendly name of the certificate that will be used by the endpoint for this domain name.
     *
     * @default - No friendly certificate name
     * @experimental
     */
    readonly certificateName?: string;
    /**
     * (experimental) The type of endpoint for this DomainName.
     *
     * @default EndpointType.REGIONAL
     * @experimental
     */
    readonly endpointType?: EndpointType;
    /**
     * (experimental) The Transport Layer Security (TLS) version + cipher suite for this domain name.
     *
     * @default SecurityPolicy.TLS_1_2
     * @experimental
     */
    readonly securityPolicy?: SecurityPolicy;
    /**
     * (experimental) A public certificate issued by ACM to validate that you own a custom domain.
     *
     * This parameter is required
     * only when you configure mutual TLS authentication and you specify an ACM imported or private CA certificate
     * for `certificate`. The ownership certificate validates that you have permissions to use the domain name.
     *
     * @default - only required when configuring mTLS
     * @experimental
     */
    readonly ownershipCertificate?: ICertificate;
}
/**
 * (experimental) The mTLS authentication configuration for a custom domain name.
 *
 * @experimental
 */
export interface MTLSConfig {
    /**
     * (experimental) The bucket that the trust store is hosted in.
     *
     * @experimental
     */
    readonly bucket: IBucket;
    /**
     * (experimental) The key in S3 to look at for the trust store.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) The version of the S3 object that contains your truststore.
     *
     * To specify a version, you must have versioning enabled for the S3 bucket.
     *
     * @default - latest version
     * @experimental
     */
    readonly version?: string;
}
/**
 * (experimental) Custom domain resource for the API.
 *
 * @experimental
 */
export declare class DomainName extends Resource implements IDomainName {
    /**
     * (experimental) Import from attributes.
     *
     * @experimental
     */
    static fromDomainNameAttributes(scope: Construct, id: string, attrs: DomainNameAttributes): IDomainName;
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     */
    readonly regionalHostedZoneId: string;
    private readonly domainNameConfigurations;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DomainNameProps);
    private configureMTLS;
    /**
     * (experimental) Adds an endpoint to a domain name.
     *
     * @param options domain name endpoint properties to be set.
     * @experimental
     */
    addEndpoint(options: EndpointOptions): void;
    private validateEndpointType;
}
