"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainName = exports.EndpointType = exports.SecurityPolicy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 *
 * @experimental
 */
var SecurityPolicy;
(function (SecurityPolicy) {
    SecurityPolicy["TLS_1_0"] = "TLS_1_0";
    SecurityPolicy["TLS_1_2"] = "TLS_1_2";
})(SecurityPolicy = exports.SecurityPolicy || (exports.SecurityPolicy = {}));
/**
 * (experimental) Endpoint type for a domain name.
 *
 * @experimental
 */
var EndpointType;
(function (EndpointType) {
    EndpointType["EDGE"] = "EDGE";
    EndpointType["REGIONAL"] = "REGIONAL";
})(EndpointType = exports.EndpointType || (exports.EndpointType = {}));
/**
 * (experimental) Custom domain resource for the API.
 *
 * @experimental
 */
class DomainName extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.domainNameConfigurations = [];
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_DomainNameProps(props);
        if (props.domainName === '') {
            throw new Error('empty string for domainName not allowed');
        }
        // validation for ownership certificate
        if (props.ownershipCertificate && !props.mtls) {
            throw new Error('ownership certificate can only be used with mtls domains');
        }
        const mtlsConfig = this.configureMTLS(props.mtls);
        const domainNameProps = {
            domainName: props.domainName,
            domainNameConfigurations: core_1.Lazy.any({ produce: () => this.domainNameConfigurations }),
            mutualTlsAuthentication: mtlsConfig,
        };
        const resource = new apigatewayv2_generated_1.CfnDomainName(this, 'Resource', domainNameProps);
        this.name = resource.ref;
        this.regionalDomainName = core_1.Token.asString(resource.getAtt('RegionalDomainName'));
        this.regionalHostedZoneId = core_1.Token.asString(resource.getAtt('RegionalHostedZoneId'));
        if (props.certificate) {
            this.addEndpoint(props);
        }
    }
    /**
     * (experimental) Import from attributes.
     *
     * @experimental
     */
    static fromDomainNameAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_DomainNameAttributes(attrs);
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.regionalDomainName = attrs.regionalDomainName;
                this.regionalHostedZoneId = attrs.regionalHostedZoneId;
                this.name = attrs.name;
            }
        }
        return new Import(scope, id);
    }
    configureMTLS(mtlsConfig) {
        if (!mtlsConfig)
            return undefined;
        return {
            truststoreUri: mtlsConfig.bucket.s3UrlForObject(mtlsConfig.key),
            truststoreVersion: mtlsConfig.version,
        };
    }
    /**
     * (experimental) Adds an endpoint to a domain name.
     *
     * @param options domain name endpoint properties to be set.
     * @experimental
     */
    addEndpoint(options) {
        var _b, _c, _d;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_EndpointOptions(options);
        const domainNameConfig = {
            certificateArn: options.certificate.certificateArn,
            certificateName: options.certificateName,
            endpointType: options.endpointType ? (_b = options.endpointType) === null || _b === void 0 ? void 0 : _b.toString() : 'REGIONAL',
            ownershipVerificationCertificateArn: (_c = options.ownershipCertificate) === null || _c === void 0 ? void 0 : _c.certificateArn,
            securityPolicy: (_d = options.securityPolicy) === null || _d === void 0 ? void 0 : _d.toString(),
        };
        this.validateEndpointType(domainNameConfig.endpointType);
        this.domainNameConfigurations.push(domainNameConfig);
    }
    // validates that the new domain name configuration has a unique endpoint
    validateEndpointType(endpointType) {
        for (let config of this.domainNameConfigurations) {
            if (endpointType && endpointType == config.endpointType) {
                throw new Error(`an endpoint with type ${endpointType} already exists`);
            }
        }
    }
}
exports.DomainName = DomainName;
_a = JSII_RTTI_SYMBOL_1;
DomainName[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.DomainName", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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