"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRouteIntegration = exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpConnectionType = exports.HttpIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Supported integration types.
 *
 * @experimental
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    HttpIntegrationType["LAMBDA_PROXY"] = "AWS_PROXY";
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * (experimental) Supported connection types.
 *
 * @experimental
 */
var HttpConnectionType;
(function (HttpConnectionType) {
    HttpConnectionType["VPC_LINK"] = "VPC_LINK";
    HttpConnectionType["INTERNET"] = "INTERNET";
})(HttpConnectionType = exports.HttpConnectionType || (exports.HttpConnectionType = {}));
/**
 * (experimental) Payload format version for lambda proxy integration.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 * @experimental
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * (experimental) A custom payload version.
     *
     * Typically used if there is a version number that the CDK doesn't support yet
     *
     * @experimental
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
_a = JSII_RTTI_SYMBOL_1;
PayloadFormatVersion[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.PayloadFormatVersion", version: "1.139.0" };
/**
 * (experimental) Version 1.0.
 *
 * @experimental
 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/**
 * (experimental) Version 2.0.
 *
 * @experimental
 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpIntegrationProps(props);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            connectionId: props.connectionId,
            connectionType: props.connectionType,
            payloadFormatVersion: (_d = props.payloadFormatVersion) === null || _d === void 0 ? void 0 : _d.version,
            requestParameters: (_e = props.parameterMapping) === null || _e === void 0 ? void 0 : _e.mappings,
        });
        if (props.secureServerName) {
            integ.tlsConfig = {
                serverNameToVerify: props.secureServerName,
            };
        }
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
_b = JSII_RTTI_SYMBOL_1;
HttpIntegration[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpIntegration", version: "1.139.0" };
/**
 * (experimental) The interface that various route integration classes will inherit.
 *
 * @experimental
 */
class HttpRouteIntegration {
    /**
     * (experimental) Initialize an integration for a route on http api.
     *
     * @param id id of the underlying `HttpIntegration` construct.
     * @experimental
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.httpApi.node.addr !== options.route.httpApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new HttpIntegration(options.scope, this.id, {
                httpApi: options.route.httpApi,
                integrationType: config.type,
                integrationUri: config.uri,
                method: config.method,
                connectionId: config.connectionId,
                connectionType: config.connectionType,
                payloadFormatVersion: config.payloadFormatVersion,
                secureServerName: config.secureServerName,
                parameterMapping: config.parameterMapping,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.HttpRouteIntegration = HttpRouteIntegration;
_c = JSII_RTTI_SYMBOL_1;
HttpRouteIntegration[_c] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRouteIntegration", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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