"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRoute = exports.HttpRouteKey = exports.HttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * (experimental) Supported HTTP methods.
 *
 * @experimental
 */
var HttpMethod;
(function (HttpMethod) {
    HttpMethod["ANY"] = "ANY";
    HttpMethod["DELETE"] = "DELETE";
    HttpMethod["GET"] = "GET";
    HttpMethod["HEAD"] = "HEAD";
    HttpMethod["OPTIONS"] = "OPTIONS";
    HttpMethod["PATCH"] = "PATCH";
    HttpMethod["POST"] = "POST";
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * (experimental) HTTP route in APIGateway is a combination of the HTTP method and the path component.
 *
 * This class models that combination.
 *
 * @experimental
 */
class HttpRouteKey {
    constructor(method, path) {
        this.method = method !== null && method !== void 0 ? method : HttpMethod.ANY;
        this.path = path;
        this.key = path ? `${method} ${path}` : '$default';
    }
    /**
     * (experimental) Create a route key with the combination of the path and the method.
     *
     * @param method default is 'ANY'.
     * @experimental
     */
    static with(path, method) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpMethod(method);
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('A route path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(method, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
_a = JSII_RTTI_SYMBOL_1;
HttpRouteKey[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRouteKey", version: "1.139.0" };
/**
 * (experimental) The catch-all route of the API, i.e., when no other routes match.
 *
 * @experimental
 */
HttpRouteKey.DEFAULT = new HttpRouteKey();
/**
 * Supported Route Authorizer types
 */
var HttpRouteAuthorizationType;
(function (HttpRouteAuthorizationType) {
    /** AWS IAM */
    HttpRouteAuthorizationType["AWS_IAM"] = "AWS_IAM";
    /** JSON Web Tokens */
    HttpRouteAuthorizationType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpRouteAuthorizationType["CUSTOM"] = "CUSTOM";
    /** No authorizer */
    HttpRouteAuthorizationType["NONE"] = "NONE";
})(HttpRouteAuthorizationType || (HttpRouteAuthorizationType = {}));
/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpRouteProps(props);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        this.method = props.routeKey.method;
        this.routeArn = this.produceRouteArn(props.routeKey.method);
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        this.authBindResult = (_c = props.authorizer) === null || _c === void 0 ? void 0 : _c.bind({
            route: this,
            scope: this.httpApi instanceof constructs_1.Construct ? this.httpApi : this,
        });
        if (this.authBindResult && !(this.authBindResult.authorizationType in HttpRouteAuthorizationType)) {
            throw new Error(`authorizationType should either be AWS_IAM, JWT, CUSTOM, or NONE but was '${this.authBindResult.authorizationType}'`);
        }
        let authorizationScopes = (_d = this.authBindResult) === null || _d === void 0 ? void 0 : _d.authorizationScopes;
        if (this.authBindResult && props.authorizationScopes) {
            authorizationScopes = Array.from(new Set([
                ...authorizationScopes !== null && authorizationScopes !== void 0 ? authorizationScopes : [],
                ...props.authorizationScopes,
            ]));
        }
        if ((authorizationScopes === null || authorizationScopes === void 0 ? void 0 : authorizationScopes.length) === 0) {
            authorizationScopes = undefined;
        }
        const routeProps = {
            apiId: props.httpApi.apiId,
            routeKey: props.routeKey.key,
            target: `integrations/${config.integrationId}`,
            authorizerId: (_e = this.authBindResult) === null || _e === void 0 ? void 0 : _e.authorizerId,
            authorizationType: (_g = (_f = this.authBindResult) === null || _f === void 0 ? void 0 : _f.authorizationType) !== null && _g !== void 0 ? _g : 'NONE',
            authorizationScopes,
        };
        const route = new apigatewayv2_generated_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
    produceRouteArn(httpMethod) {
        var _c;
        const stage = '*';
        const iamHttpMethod = httpMethod === HttpMethod.ANY ? '*' : httpMethod;
        const path = (_c = this.path) !== null && _c !== void 0 ? _c : '/';
        // When the user has provided a path with path variables, we replace the
        // path variable and all that follows with a wildcard.
        const iamPath = path.replace(/\{.*?\}.*/, '*');
        return `arn:aws:execute-api:${this.stack.region}:${this.stack.account}:${this.httpApi.apiId}/${stage}/${iamHttpMethod}${iamPath}`;
    }
    /**
     * (experimental) Grant access to invoke the route.
     *
     * This method requires that the authorizer of the route is undefined or is
     * an `HttpIamAuthorizer`.
     *
     * @experimental
     */
    grantInvoke(grantee, options = {}) {
        var _c;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_GrantInvokeOptions(options);
        if (!this.authBindResult || this.authBindResult.authorizationType !== HttpRouteAuthorizationType.AWS_IAM) {
            throw new Error('To use grantInvoke, you must use IAM authorization');
        }
        const httpMethods = Array.from(new Set((_c = options.httpMethods) !== null && _c !== void 0 ? _c : [this.method]));
        if (this.method !== HttpMethod.ANY && httpMethods.some(method => method !== this.method)) {
            throw new Error('This route does not support granting invoke for all requested http methods');
        }
        const resourceArns = httpMethods.map(httpMethod => {
            return this.produceRouteArn(httpMethod);
        });
        return iam.Grant.addToPrincipal({
            grantee,
            actions: ['execute-api:Invoke'],
            resourceArns: resourceArns,
        });
    }
}
exports.HttpRoute = HttpRoute;
_b = JSII_RTTI_SYMBOL_1;
HttpRoute[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRoute", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyb3V0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx3Q0FBd0M7QUFDeEMsd0NBQXlDO0FBQ3pDLDJDQUF1QztBQUN2QyxzRUFBb0U7Ozs7OztBQTRCcEUsSUFBWSxVQWlCWDtBQWpCRCxXQUFZLFVBQVU7SUFFcEIseUJBQVcsQ0FBQTtJQUVYLCtCQUFpQixDQUFBO0lBRWpCLHlCQUFXLENBQUE7SUFFWCwyQkFBYSxDQUFBO0lBRWIsaUNBQW1CLENBQUE7SUFFbkIsNkJBQWUsQ0FBQTtJQUVmLDJCQUFhLENBQUE7SUFFYix5QkFBVyxDQUFBO0FBQ2IsQ0FBQyxFQWpCVyxVQUFVLEdBQVYsa0JBQVUsS0FBVixrQkFBVSxRQWlCckI7Ozs7Ozs7O0FBR0QsTUFBYSxZQUFZO0lBbUJ2QixZQUFvQixNQUFtQixFQUFFLElBQWE7UUFDcEQsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLGFBQU4sTUFBTSxjQUFOLE1BQU0sR0FBSSxVQUFVLENBQUMsR0FBRyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sSUFBSSxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0tBQ3BEOzs7Ozs7O0lBbEJNLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBWSxFQUFFLE1BQW1COztRQUNsRCxJQUFJLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFO1lBQ2pFLE1BQU0sSUFBSSxLQUFLLENBQUMsa0VBQWtFLENBQUMsQ0FBQztTQUNyRjtRQUNELE9BQU8sSUFBSSxZQUFZLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDO0tBQ3ZDOztBQVZILG9DQXdCQzs7Ozs7Ozs7QUF0QndCLG9CQUFPLEdBQUcsSUFBSSxZQUFZLEVBQUUsQ0FBQztBQTZDdEQ7O0dBRUc7QUFDSCxJQUFLLDBCQVlKO0FBWkQsV0FBSywwQkFBMEI7SUFDN0IsY0FBYztJQUNkLGlEQUFtQixDQUFBO0lBRW5CLHNCQUFzQjtJQUN0Qix5Q0FBVyxDQUFBO0lBRVgsd0JBQXdCO0lBQ3hCLCtDQUFpQixDQUFBO0lBRWpCLG9CQUFvQjtJQUNwQiwyQ0FBYSxDQUFBO0FBQ2YsQ0FBQyxFQVpJLDBCQUEwQixLQUExQiwwQkFBMEIsUUFZOUI7Ozs7Ozs7QUFHRCxNQUFhLFNBQVUsU0FBUSxlQUFROzs7O0lBU3JDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBcUI7O1FBQzdELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7O1FBRWpCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDO1FBQ2hDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUM7UUFDcEMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFNUQsTUFBTSxNQUFNLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUM7WUFDNUMsS0FBSyxFQUFFLElBQUk7WUFDWCxLQUFLLEVBQUUsSUFBSTtTQUNaLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxjQUFjLFNBQUcsS0FBSyxDQUFDLFVBQVUsMENBQUUsSUFBSSxDQUFDO1lBQzNDLEtBQUssRUFBRSxJQUFJO1lBQ1gsS0FBSyxFQUFFLElBQUksQ0FBQyxPQUFPLFlBQVksc0JBQVMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSTtTQUMvRCxDQUFDLENBQUM7UUFFSCxJQUFJLElBQUksQ0FBQyxjQUFjLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsaUJBQWlCLElBQUksMEJBQTBCLENBQUMsRUFBRTtZQUNqRyxNQUFNLElBQUksS0FBSyxDQUFDLDZFQUE2RSxJQUFJLENBQUMsY0FBYyxDQUFDLGlCQUFpQixHQUFHLENBQUMsQ0FBQztTQUN4STtRQUVELElBQUksbUJBQW1CLFNBQUcsSUFBSSxDQUFDLGNBQWMsMENBQUUsbUJBQW1CLENBQUM7UUFFbkUsSUFBSSxJQUFJLENBQUMsY0FBYyxJQUFJLEtBQUssQ0FBQyxtQkFBbUIsRUFBRTtZQUNwRCxtQkFBbUIsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDO2dCQUN2QyxHQUFHLG1CQUFtQixhQUFuQixtQkFBbUIsY0FBbkIsbUJBQW1CLEdBQUksRUFBRTtnQkFDNUIsR0FBRyxLQUFLLENBQUMsbUJBQW1CO2FBQzdCLENBQUMsQ0FBQyxDQUFDO1NBQ0w7UUFFRCxJQUFJLENBQUEsbUJBQW1CLGFBQW5CLG1CQUFtQix1QkFBbkIsbUJBQW1CLENBQUUsTUFBTSxNQUFLLENBQUMsRUFBRTtZQUNyQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7U0FDakM7UUFFRCxNQUFNLFVBQVUsR0FBa0I7WUFDaEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSztZQUMxQixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHO1lBQzVCLE1BQU0sRUFBRSxnQkFBZ0IsTUFBTSxDQUFDLGFBQWEsRUFBRTtZQUM5QyxZQUFZLFFBQUUsSUFBSSxDQUFDLGNBQWMsMENBQUUsWUFBWTtZQUMvQyxpQkFBaUIsY0FBRSxJQUFJLENBQUMsY0FBYywwQ0FBRSxpQkFBaUIsbUNBQUksTUFBTTtZQUNuRSxtQkFBbUI7U0FDcEIsQ0FBQztRQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksaUNBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3pELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztLQUMxQjtJQUVPLGVBQWUsQ0FBQyxVQUFzQjs7UUFDNUMsTUFBTSxLQUFLLEdBQUcsR0FBRyxDQUFDO1FBQ2xCLE1BQU0sYUFBYSxHQUFHLFVBQVUsS0FBSyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztRQUN2RSxNQUFNLElBQUksU0FBRyxJQUFJLENBQUMsSUFBSSxtQ0FBSSxHQUFHLENBQUM7UUFDOUIsd0VBQXdFO1FBQ3hFLHNEQUFzRDtRQUN0RCxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUUvQyxPQUFPLHVCQUF1QixJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssSUFBSSxLQUFLLElBQUksYUFBYSxHQUFHLE9BQU8sRUFBRSxDQUFDO0tBQ25JOzs7Ozs7Ozs7SUFFTSxXQUFXLENBQUMsT0FBdUIsRUFBRSxVQUE4QixFQUFFOzs7UUFDMUUsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsS0FBSywwQkFBMEIsQ0FBQyxPQUFPLEVBQUU7WUFDeEcsTUFBTSxJQUFJLEtBQUssQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO1NBQ3ZFO1FBRUQsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEdBQUcsT0FBQyxPQUFPLENBQUMsV0FBVyxtQ0FBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDOUUsSUFBSSxJQUFJLENBQUMsTUFBTSxLQUFLLFVBQVUsQ0FBQyxHQUFHLElBQUksV0FBVyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sS0FBSyxJQUFJLENBQUMsTUFBTSxDQUFDLEVBQUU7WUFDeEYsTUFBTSxJQUFJLEtBQUssQ0FBQyw0RUFBNEUsQ0FBQyxDQUFDO1NBQy9GO1FBRUQsTUFBTSxZQUFZLEdBQUcsV0FBVyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUNoRCxPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDMUMsQ0FBQyxDQUFDLENBQUM7UUFFSCxPQUFPLEdBQUcsQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDO1lBQzlCLE9BQU87WUFDUCxPQUFPLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQztZQUMvQixZQUFZLEVBQUUsWUFBWTtTQUMzQixDQUFDLENBQUM7S0FDSjs7QUF2RkgsOEJBd0ZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuUm91dGUsIENmblJvdXRlUHJvcHMgfSBmcm9tICcuLi9hcGlnYXRld2F5djIuZ2VuZXJhdGVkJztcbmltcG9ydCB7IElSb3V0ZSB9IGZyb20gJy4uL2NvbW1vbic7XG5pbXBvcnQgeyBJSHR0cEFwaSB9IGZyb20gJy4vYXBpJztcbmltcG9ydCB7IEh0dHBSb3V0ZUF1dGhvcml6ZXJDb25maWcsIElIdHRwUm91dGVBdXRob3JpemVyIH0gZnJvbSAnLi9hdXRob3JpemVyJztcbmltcG9ydCB7IEh0dHBSb3V0ZUludGVncmF0aW9uIH0gZnJvbSAnLi9pbnRlZ3JhdGlvbic7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUh0dHBSb3V0ZSBleHRlbmRzIElSb3V0ZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaHR0cEFwaTogSUh0dHBBcGk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwYXRoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByb3V0ZUFybjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIGdyYW50SW52b2tlKGdyYW50ZWU6IGlhbS5JR3JhbnRhYmxlLCBvcHRpb25zPzogR3JhbnRJbnZva2VPcHRpb25zKTogaWFtLkdyYW50O1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEdyYW50SW52b2tlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaHR0cE1ldGhvZHM/OiBIdHRwTWV0aG9kW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gSHR0cE1ldGhvZCB7XG4gICAgICAgICAgICAgICAgIFxuICBBTlkgPSAnQU5ZJyxcbiAgICAgICAgICAgICAgICAgICAgXG4gIERFTEVURSA9ICdERUxFVEUnLFxuICAgICAgICAgICAgICAgICBcbiAgR0VUID0gJ0dFVCcsXG4gICAgICAgICAgICAgICAgICBcbiAgSEVBRCA9ICdIRUFEJyxcbiAgICAgICAgICAgICAgICAgICAgIFxuICBPUFRJT05TID0gJ09QVElPTlMnLFxuICAgICAgICAgICAgICAgICAgIFxuICBQQVRDSCA9ICdQQVRDSCcsXG4gICAgICAgICAgICAgICAgICBcbiAgUE9TVCA9ICdQT1NUJyxcbiAgICAgICAgICAgICAgICAgXG4gIFBVVCA9ICdQVVQnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEh0dHBSb3V0ZUtleSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBERUZBVUxUID0gbmV3IEh0dHBSb3V0ZUtleSgpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyB3aXRoKHBhdGg6IHN0cmluZywgbWV0aG9kPzogSHR0cE1ldGhvZCkge1xuICAgIGlmIChwYXRoICE9PSAnLycgJiYgKCFwYXRoLnN0YXJ0c1dpdGgoJy8nKSB8fCBwYXRoLmVuZHNXaXRoKCcvJykpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0Egcm91dGUgcGF0aCBtdXN0IGFsd2F5cyBzdGFydCB3aXRoIGEgXCIvXCIgYW5kIG5vdCBlbmQgd2l0aCBhIFwiL1wiJyk7XG4gICAgfVxuICAgIHJldHVybiBuZXcgSHR0cFJvdXRlS2V5KG1ldGhvZCwgcGF0aCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgbWV0aG9kOiBIdHRwTWV0aG9kO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGtleTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgcGF0aD86IHN0cmluZztcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKG1ldGhvZD86IEh0dHBNZXRob2QsIHBhdGg/OiBzdHJpbmcpIHtcbiAgICB0aGlzLm1ldGhvZCA9IG1ldGhvZCA/PyBIdHRwTWV0aG9kLkFOWTtcbiAgICB0aGlzLnBhdGggPSBwYXRoO1xuICAgIHRoaXMua2V5ID0gcGF0aCA/IGAke21ldGhvZH0gJHtwYXRofWAgOiAnJGRlZmF1bHQnO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEJhdGNoSHR0cFJvdXRlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGludGVncmF0aW9uOiBIdHRwUm91dGVJbnRlZ3JhdGlvbjtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFJvdXRlUHJvcHMgZXh0ZW5kcyBCYXRjaEh0dHBSb3V0ZU9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaHR0cEFwaTogSUh0dHBBcGk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcm91dGVLZXk6IEh0dHBSb3V0ZUtleTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGF1dGhvcml6ZXI/OiBJSHR0cFJvdXRlQXV0aG9yaXplcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGF1dGhvcml6YXRpb25TY29wZXM/OiBzdHJpbmdbXTtcbn1cblxuLyoqXG4gKiBTdXBwb3J0ZWQgUm91dGUgQXV0aG9yaXplciB0eXBlc1xuICovXG5lbnVtIEh0dHBSb3V0ZUF1dGhvcml6YXRpb25UeXBlIHtcbiAgLyoqIEFXUyBJQU0gKi9cbiAgQVdTX0lBTSA9ICdBV1NfSUFNJyxcblxuICAvKiogSlNPTiBXZWIgVG9rZW5zICovXG4gIEpXVCA9ICdKV1QnLFxuXG4gIC8qKiBMYW1iZGEgQXV0aG9yaXplciAqL1xuICBDVVNUT00gPSAnQ1VTVE9NJyxcblxuICAvKiogTm8gYXV0aG9yaXplciAqL1xuICBOT05FID0gJ05PTkUnXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEh0dHBSb3V0ZSBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUh0dHBSb3V0ZSB7XG4gIHB1YmxpYyByZWFkb25seSByb3V0ZUlkOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBodHRwQXBpOiBJSHR0cEFwaTtcbiAgcHVibGljIHJlYWRvbmx5IHBhdGg/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSByb3V0ZUFybjogc3RyaW5nO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgbWV0aG9kOiBIdHRwTWV0aG9kO1xuICBwcml2YXRlIHJlYWRvbmx5IGF1dGhCaW5kUmVzdWx0PzogSHR0cFJvdXRlQXV0aG9yaXplckNvbmZpZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSHR0cFJvdXRlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5odHRwQXBpID0gcHJvcHMuaHR0cEFwaTtcbiAgICB0aGlzLnBhdGggPSBwcm9wcy5yb3V0ZUtleS5wYXRoO1xuICAgIHRoaXMubWV0aG9kID0gcHJvcHMucm91dGVLZXkubWV0aG9kO1xuICAgIHRoaXMucm91dGVBcm4gPSB0aGlzLnByb2R1Y2VSb3V0ZUFybihwcm9wcy5yb3V0ZUtleS5tZXRob2QpO1xuXG4gICAgY29uc3QgY29uZmlnID0gcHJvcHMuaW50ZWdyYXRpb24uX2JpbmRUb1JvdXRlKHtcbiAgICAgIHJvdXRlOiB0aGlzLFxuICAgICAgc2NvcGU6IHRoaXMsXG4gICAgfSk7XG5cbiAgICB0aGlzLmF1dGhCaW5kUmVzdWx0ID0gcHJvcHMuYXV0aG9yaXplcj8uYmluZCh7XG4gICAgICByb3V0ZTogdGhpcyxcbiAgICAgIHNjb3BlOiB0aGlzLmh0dHBBcGkgaW5zdGFuY2VvZiBDb25zdHJ1Y3QgPyB0aGlzLmh0dHBBcGkgOiB0aGlzLCAvLyBzY29wZSB1bmRlciB0aGUgQVBJIGlmIGl0J3Mgbm90IGltcG9ydGVkXG4gICAgfSk7XG5cbiAgICBpZiAodGhpcy5hdXRoQmluZFJlc3VsdCAmJiAhKHRoaXMuYXV0aEJpbmRSZXN1bHQuYXV0aG9yaXphdGlvblR5cGUgaW4gSHR0cFJvdXRlQXV0aG9yaXphdGlvblR5cGUpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYGF1dGhvcml6YXRpb25UeXBlIHNob3VsZCBlaXRoZXIgYmUgQVdTX0lBTSwgSldULCBDVVNUT00sIG9yIE5PTkUgYnV0IHdhcyAnJHt0aGlzLmF1dGhCaW5kUmVzdWx0LmF1dGhvcml6YXRpb25UeXBlfSdgKTtcbiAgICB9XG5cbiAgICBsZXQgYXV0aG9yaXphdGlvblNjb3BlcyA9IHRoaXMuYXV0aEJpbmRSZXN1bHQ/LmF1dGhvcml6YXRpb25TY29wZXM7XG5cbiAgICBpZiAodGhpcy5hdXRoQmluZFJlc3VsdCAmJiBwcm9wcy5hdXRob3JpemF0aW9uU2NvcGVzKSB7XG4gICAgICBhdXRob3JpemF0aW9uU2NvcGVzID0gQXJyYXkuZnJvbShuZXcgU2V0KFtcbiAgICAgICAgLi4uYXV0aG9yaXphdGlvblNjb3BlcyA/PyBbXSxcbiAgICAgICAgLi4ucHJvcHMuYXV0aG9yaXphdGlvblNjb3BlcyxcbiAgICAgIF0pKTtcbiAgICB9XG5cbiAgICBpZiAoYXV0aG9yaXphdGlvblNjb3Blcz8ubGVuZ3RoID09PSAwKSB7XG4gICAgICBhdXRob3JpemF0aW9uU2NvcGVzID0gdW5kZWZpbmVkO1xuICAgIH1cblxuICAgIGNvbnN0IHJvdXRlUHJvcHM6IENmblJvdXRlUHJvcHMgPSB7XG4gICAgICBhcGlJZDogcHJvcHMuaHR0cEFwaS5hcGlJZCxcbiAgICAgIHJvdXRlS2V5OiBwcm9wcy5yb3V0ZUtleS5rZXksXG4gICAgICB0YXJnZXQ6IGBpbnRlZ3JhdGlvbnMvJHtjb25maWcuaW50ZWdyYXRpb25JZH1gLFxuICAgICAgYXV0aG9yaXplcklkOiB0aGlzLmF1dGhCaW5kUmVzdWx0Py5hdXRob3JpemVySWQsXG4gICAgICBhdXRob3JpemF0aW9uVHlwZTogdGhpcy5hdXRoQmluZFJlc3VsdD8uYXV0aG9yaXphdGlvblR5cGUgPz8gJ05PTkUnLFxuICAgICAgYXV0aG9yaXphdGlvblNjb3BlcyxcbiAgICB9O1xuXG4gICAgY29uc3Qgcm91dGUgPSBuZXcgQ2ZuUm91dGUodGhpcywgJ1Jlc291cmNlJywgcm91dGVQcm9wcyk7XG4gICAgdGhpcy5yb3V0ZUlkID0gcm91dGUucmVmO1xuICB9XG5cbiAgcHJpdmF0ZSBwcm9kdWNlUm91dGVBcm4oaHR0cE1ldGhvZDogSHR0cE1ldGhvZCk6IHN0cmluZyB7XG4gICAgY29uc3Qgc3RhZ2UgPSAnKic7XG4gICAgY29uc3QgaWFtSHR0cE1ldGhvZCA9IGh0dHBNZXRob2QgPT09IEh0dHBNZXRob2QuQU5ZID8gJyonIDogaHR0cE1ldGhvZDtcbiAgICBjb25zdCBwYXRoID0gdGhpcy5wYXRoID8/ICcvJztcbiAgICAvLyBXaGVuIHRoZSB1c2VyIGhhcyBwcm92aWRlZCBhIHBhdGggd2l0aCBwYXRoIHZhcmlhYmxlcywgd2UgcmVwbGFjZSB0aGVcbiAgICAvLyBwYXRoIHZhcmlhYmxlIGFuZCBhbGwgdGhhdCBmb2xsb3dzIHdpdGggYSB3aWxkY2FyZC5cbiAgICBjb25zdCBpYW1QYXRoID0gcGF0aC5yZXBsYWNlKC9cXHsuKj9cXH0uKi8sICcqJyk7XG5cbiAgICByZXR1cm4gYGFybjphd3M6ZXhlY3V0ZS1hcGk6JHt0aGlzLnN0YWNrLnJlZ2lvbn06JHt0aGlzLnN0YWNrLmFjY291bnR9OiR7dGhpcy5odHRwQXBpLmFwaUlkfS8ke3N0YWdlfS8ke2lhbUh0dHBNZXRob2R9JHtpYW1QYXRofWA7XG4gIH1cblxuICBwdWJsaWMgZ3JhbnRJbnZva2UoZ3JhbnRlZTogaWFtLklHcmFudGFibGUsIG9wdGlvbnM6IEdyYW50SW52b2tlT3B0aW9ucyA9IHt9KTogaWFtLkdyYW50IHtcbiAgICBpZiAoIXRoaXMuYXV0aEJpbmRSZXN1bHQgfHwgdGhpcy5hdXRoQmluZFJlc3VsdC5hdXRob3JpemF0aW9uVHlwZSAhPT0gSHR0cFJvdXRlQXV0aG9yaXphdGlvblR5cGUuQVdTX0lBTSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdUbyB1c2UgZ3JhbnRJbnZva2UsIHlvdSBtdXN0IHVzZSBJQU0gYXV0aG9yaXphdGlvbicpO1xuICAgIH1cblxuICAgIGNvbnN0IGh0dHBNZXRob2RzID0gQXJyYXkuZnJvbShuZXcgU2V0KG9wdGlvbnMuaHR0cE1ldGhvZHMgPz8gW3RoaXMubWV0aG9kXSkpO1xuICAgIGlmICh0aGlzLm1ldGhvZCAhPT0gSHR0cE1ldGhvZC5BTlkgJiYgaHR0cE1ldGhvZHMuc29tZShtZXRob2QgPT4gbWV0aG9kICE9PSB0aGlzLm1ldGhvZCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignVGhpcyByb3V0ZSBkb2VzIG5vdCBzdXBwb3J0IGdyYW50aW5nIGludm9rZSBmb3IgYWxsIHJlcXVlc3RlZCBodHRwIG1ldGhvZHMnKTtcbiAgICB9XG5cbiAgICBjb25zdCByZXNvdXJjZUFybnMgPSBodHRwTWV0aG9kcy5tYXAoaHR0cE1ldGhvZCA9PiB7XG4gICAgICByZXR1cm4gdGhpcy5wcm9kdWNlUm91dGVBcm4oaHR0cE1ldGhvZCk7XG4gICAgfSk7XG5cbiAgICByZXR1cm4gaWFtLkdyYW50LmFkZFRvUHJpbmNpcGFsKHtcbiAgICAgIGdyYW50ZWUsXG4gICAgICBhY3Rpb25zOiBbJ2V4ZWN1dGUtYXBpOkludm9rZSddLFxuICAgICAgcmVzb3VyY2VBcm5zOiByZXNvdXJjZUFybnMsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==