"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRouteIntegration = exports.WebSocketIntegration = exports.WebSocketIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * WebSocket Integration Types
 */
var WebSocketIntegrationType;
(function (WebSocketIntegrationType) {
    WebSocketIntegrationType["AWS_PROXY"] = "AWS_PROXY";
})(WebSocketIntegrationType = exports.WebSocketIntegrationType || (exports.WebSocketIntegrationType = {}));
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
class WebSocketIntegration extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketIntegrationProps(props);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
        });
        this.integrationId = integ.ref;
        this.webSocketApi = props.webSocketApi;
    }
}
exports.WebSocketIntegration = WebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketIntegration", version: "1.139.0" };
/**
 * (experimental) The interface that various route integration classes will inherit.
 *
 * @experimental
 */
class WebSocketRouteIntegration {
    /**
     * (experimental) Initialize an integration for a route on websocket api.
     *
     * @param id id of the underlying `WebSocketIntegration` construct.
     * @experimental
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.webSocketApi.node.addr !== options.route.webSocketApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new WebSocketIntegration(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                integrationType: config.type,
                integrationUri: config.uri,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.WebSocketRouteIntegration = WebSocketRouteIntegration;
_b = JSII_RTTI_SYMBOL_1;
WebSocketRouteIntegration[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketRouteIntegration", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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