"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRoute = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const authorizer_1 = require("./authorizer");
/**
 * (experimental) Route class that creates the Route for API Gateway WebSocket API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class WebSocketRoute extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketRouteProps(props);
        if (props.routeKey != '$connect' && props.authorizer) {
            throw new Error('You can only set a WebSocket authorizer to a $connect route.');
        }
        this.webSocketApi = props.webSocketApi;
        this.routeKey = props.routeKey;
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        const authorizer = (_b = props.authorizer) !== null && _b !== void 0 ? _b : new authorizer_1.WebSocketNoneAuthorizer(); // must be explicitly NONE (not undefined) for stack updates to work correctly
        const authBindResult = authorizer.bind({
            route: this,
            scope: this.webSocketApi instanceof constructs_1.Construct ? this.webSocketApi : this,
        });
        const route = new apigatewayv2_generated_1.CfnRoute(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            routeKey: props.routeKey,
            target: `integrations/${config.integrationId}`,
            authorizerId: authBindResult.authorizerId,
            authorizationType: authBindResult.authorizationType,
        });
        this.routeId = route.ref;
    }
}
exports.WebSocketRoute = WebSocketRoute;
_a = JSII_RTTI_SYMBOL_1;
WebSocketRoute[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketRoute", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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