"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketStage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
class WebSocketStage extends base_1.StageBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketStageProps(props);
        this.baseApi = props.webSocketApi;
        this.api = props.webSocketApi;
        this.stageName = this.physicalName;
        new apigatewayv2_generated_1.CfnStage(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromWebSocketStageAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketStageAttributes(attrs);
        class Import extends base_1.StageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get callbackUrl() {
                throw new Error('callback url is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) The websocket URL to this stage.
     *
     * @experimental
     */
    get url() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName;
        return `wss://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * (experimental) The callback URL to this stage.
     *
     * @experimental
     */
    get callbackUrl() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * (experimental) Grant access to the API Gateway management API for this WebSocket API Stage to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantManagementApiAccess(identity) {
        const arn = core_1.Stack.of(this.api).formatArn({
            service: 'execute-api',
            resource: this.api.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/${this.stageName}/POST/@connections/*`],
        });
    }
}
exports.WebSocketStage = WebSocketStage;
_a = JSII_RTTI_SYMBOL_1;
WebSocketStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketStage", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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